/*
 *   retail - a logfile monitoring utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Yee ole includes (I put this all in one file for my sanity) */
#include "include.h"

int read_infile_llcheck() {
	long int i;
	short int found = 0;
	char line[B_SIZE];

	/* set position to last known good - 1 */
	for(i = 2 ; i < B_SIZE ; ++i) {
		/* rewind exactly one line */
		fseek(in_file, (f.ipos - i), SEEK_SET);
		if(getc(in_file) == '\n') {
			break; /* found our first \n, we're home */
		}
	}
	
	/* get that line we just rewound to */
	fgets(line, sizeof(line), in_file);
	/* make sure the last line in the file is same as it was last time */
	if(strcmp(line, f.last_line) != 0) {
		found = 0;
		/* oops, file has changed; rewind and search for the last 
		 * known line of the file in ASCII. */
		fseek(in_file, 0, SEEK_SET);
		while(fgets(line, sizeof(line), in_file) != NULL) {
			/* ahh... we found it, set postion here, and continue */ 
			if(strcmp(line, f.last_line) == 0) {
				if(debug) fprintf(stderr, "file changed: new position found: resetting\n");
				f.ipos = ftell(in_file);
				found = 1;
				break;
			}
		}
		if(found != 1) {
			if(debug) fprintf(stderr, "file changed: resetting position to 0\n");
			f.ipos = 0;
		}
	}
	return retval;
}

int read_infile() {
	char line[B_SIZE];  /* where we stick our line */
	short int new_stuff = 0;	/* anything new found?	*/
	/* double check to see the file's not shorter than it used to be */
	fseek(in_file, 0, SEEK_END);
	if(ftell(in_file) < f.ipos) {
		/* reset that to 0 for where to start */
		f.ipos = 0;
	}
	
	/* check the last line against the know value */
	read_infile_llcheck();
	
	/* move to the last known position in the file */
	fseek(in_file, f.ipos, SEEK_SET);
	/* loop through the file for any new lines since last we looked */
	while(fgets(line, sizeof(line), in_file) != NULL) {
		new_stuff = 1;
		/* print the line as-is; no editing whatsoever */
		printf("%s", line); /* no \n at the end; should already be there */
	}
	if(new_stuff == 0) return retval;

	/* set the int position of the file to the current file position */
	f.ipos = ftell(in_file);
	/* free the last_line variable if need be */
	if(f.last_line != NULL) free(f.last_line);
	/* malloc it to the appropriate size */
	f.last_line = malloc(strlen(line) + 1);
	/* strcpy the new value into place */
	strcpy(f.last_line, line);
	/* all set, now get out of here */
	return retval;
}
/* read our stats file.  Call this BEFORE read_infile()!!! you have been WARNED! */
int read_stfile() {
	char *line;
	long int f_size;
	short int fc;
	
	/* find  out how much we need to malloc for line */
	fseek(in_stat, 0, SEEK_END);	/* jump to end of file		*/
	f_size = ftell(in_stat);	/* how many bytes in file?	*/
	fseek(in_stat, 0, SEEK_SET);	/* rewind to beginning of file	*/
	line = malloc(f_size);		/* malloc line to stuff this in */
	f.last_line = malloc(f_size);	/* malloc same for last line	*/
	if(line == NULL || f.last_line == NULL) { /* error check the malloc 	*/
		retval = RV_FATAL;
		perror("malloc");
		exit(retval);
	}
	
	/* rip the first line from the file in question */
	fgets(line, f_size, in_stat);
	/* reset position to beginning of file */
	fseek(in_stat, 0, SEEK_SET);
	fc = sscanf(line, "%[^:]:%[^\n]", f.apos, f.last_line);
	if(fc != 2) {
		retval = RV_OPEN;
		return retval;
	}
	/* can't strcmp later if we don't do this (yuck!) */
	strcat(f.last_line, "\n");
	/* convert ascii position to integer position */
	f.ipos = atoi(f.apos);
	if(debug) fprintf(stderr, "in_stat:%li:%s\n", f.ipos, f.last_line);
	return retval;
}
