/*
 *   retail - a logfile monitoring utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Yee ole includes (I put this all in one file for my sanity) */
#include "include.h"


int main(int argc, char **argv) {
	long int i;
	i = proc_args(argc, argv);	/* process our arg's	*/
	if(i != 0) return retval;

	/* for each file in our list, do process it */
	for(i = 0 ; files[i] != NULL ; ++i) {
		retval = open_infile(files[i]);		/* open our input file	*/
		if(retval == RV_OPEN) {
			/* oops, couldn't open infile, reset retval and restart */
			retval = 0;
			continue;
		} /* if that went OK, skip right along to the rest of this */
		open_stfile(files[i]);	/* open our status file	*/
		read_stfile();		/* read our status file	*/
		read_infile();		/* read the input file	*/
		write_stfile();		/* write our new status	*/
		close_files();		/* close all open files	*/
	}

	/* our last ditch cleanup efforts (if any)	*/	
	local_cleanup();
	/* all done, return whatever retval is currently */
	return retval;
}
