/* Generated by re2c */
#line 1 "parse_date.db.re"
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.re,v 1.36 2006/04/09 15:03:01 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 865 "parse_date.db.re"



#line 763 "parse_date.db.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 208,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		208,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0, 128,  64, 192,   0, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  32,  32,  32, 160,  32,  32,  32, 
		160,  32,  32,  32,  32,  32, 160,  32, 
		 32,  32, 160, 160, 160,  32,  32,  32, 
		 32,  32,  32,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 29) YYFILL(29);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy48;
	case '\t':
	case ' ':	goto yy45;
	case '(':	goto yy42;
	case '+':
	case '-':	goto yy41;
	case ',':
	case '.':	goto yy47;
	case '0':	goto yy13;
	case '1':	goto yy14;
	case '2':	goto yy15;
	case '3':	goto yy16;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy17;
	case '@':	goto yy11;
	case 'A':	goto yy25;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy43;
	case 'D':	goto yy31;
	case 'E':	goto yy35;
	case 'F':	goto yy23;
	case 'I':	goto yy18;
	case 'J':	goto yy21;
	case 'L':	goto yy37;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy29;
	case 'P':	goto yy39;
	case 'S':	goto yy27;
	case 'T':	goto yy9;
	case 'V':	goto yy19;
	case 'W':	goto yy33;
	case 'X':	goto yy20;
	case 'Y':	goto yy2;
	case 'a':	goto yy26;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy44;
	case 'd':	goto yy32;
	case 'e':	goto yy36;
	case 'f':	goto yy24;
	case 'j':	goto yy22;
	case 'l':	goto yy38;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy30;
	case 'p':	goto yy40;
	case 's':	goto yy28;
	case 't':	goto yy10;
	case 'w':	goto yy34;
	case 'y':	goto yy4;
	default:	goto yy50;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy133;
			goto yy1405;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy133;
			if (yych >= 'a') goto yy138;
		} else {
			if (yych <= 'e') goto yy1414;
			if (yych <= 'z') goto yy138;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1369 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 914 "parse_date.db.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy133;
			goto yy1405;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'e') goto yy1405;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1376;
				goto yy133;
			} else {
				if (yych <= 'I') goto yy1377;
				if (yych <= 'N') goto yy133;
				goto yy1375;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1392;
				goto yy138;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1393;
				goto yy138;
			} else {
				if (yych <= 'o') goto yy1391;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1376;
				goto yy133;
			} else {
				if (yych <= 'I') goto yy1377;
				if (yych <= 'N') goto yy133;
				goto yy1375;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1376;
				goto yy133;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1377;
				goto yy133;
			} else {
				if (yych <= 'o') goto yy1375;
				if (yych <= 'z') goto yy133;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy1345;
		} else {
			if (yych == 'I') goto yy1346;
			if (yych <= 'N') goto yy133;
			goto yy1347;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1360;
			goto yy138;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1361;
				goto yy138;
			} else {
				if (yych <= 'o') goto yy1362;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy1345;
		} else {
			if (yych == 'I') goto yy1346;
			if (yych <= 'N') goto yy133;
			goto yy1347;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1345;
			goto yy133;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1346;
				goto yy133;
			} else {
				if (yych <= 'o') goto yy1347;
				if (yych <= 'z') goto yy133;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy132;
	case '0':
	case '1':	goto yy1277;
	case '2':	goto yy1278;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1279;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy133;
	case 'E':	goto yy1272;
	case 'H':	goto yy1273;
	case 'O':	goto yy1274;
	case 'U':	goto yy1275;
	case 'W':	goto yy1276;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy138;
	case 'e':	goto yy1314;
	case 'h':	goto yy1315;
	case 'o':	goto yy1316;
	case 'u':	goto yy1317;
	case 'w':	goto yy1318;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy132;
	case '0':
	case '1':	goto yy1277;
	case '2':	goto yy1278;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1279;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy133;
	case 'E':
	case 'e':	goto yy1272;
	case 'H':
	case 'h':	goto yy1273;
	case 'O':
	case 'o':	goto yy1274;
	case 'U':
	case 'u':	goto yy1275;
	case 'W':
	case 'w':	goto yy1276;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1268;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1269;
yy12:
	YYDEBUG(12, *YYCURSOR);
#line 1440 "parse_date.db.re"
	{
		add_error(s, "Unexpected character");
		goto std;
	}
#line 1228 "parse_date.db.c"
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1230;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1232;
	case '-':	goto yy695;
	case '.':	goto yy1234;
	case '/':	goto yy694;
	case '0':	goto yy1267;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1266;
	case ':':	goto yy1235;
	case 'n':	goto yy692;
	case 'r':	goto yy693;
	case 's':	goto yy686;
	case 't':	goto yy690;
	default:	goto yy12;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy682;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy684;
	case '-':	goto yy695;
	case '.':	goto yy696;
	case '/':	goto yy694;
	case '0':
	case '1':
	case '2':	goto yy1266;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1233;
	case ':':	goto yy705;
	case 'n':	goto yy692;
	case 'r':	goto yy693;
	case 's':	goto yy686;
	case 't':	goto yy690;
	default:	goto yy12;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy682;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy684;
	case '-':	goto yy695;
	case '.':	goto yy696;
	case '/':	goto yy694;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1233;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1229;
	case ':':	goto yy705;
	case 'n':	goto yy692;
	case 'r':	goto yy693;
	case 's':	goto yy686;
	case 't':	goto yy690;
	default:	goto yy12;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy682;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy684;
	case '-':	goto yy695;
	case '.':	goto yy696;
	case '/':	goto yy694;
	case '0':
	case '1':	goto yy1229;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy691;
	case ':':	goto yy705;
	case 'n':	goto yy692;
	case 'r':	goto yy693;
	case 's':	goto yy686;
	case 't':	goto yy690;
	default:	goto yy12;
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy682;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy684;
	case '-':	goto yy695;
	case '.':	goto yy696;
	case '/':	goto yy694;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy691;
	case ':':	goto yy705;
	case 'n':	goto yy692;
	case 'r':	goto yy693;
	case 's':	goto yy686;
	case 't':	goto yy690;
	default:	goto yy12;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy423;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy133;
			} else {
				if (yych <= 'I') goto yy681;
				if (yych <= 'U') goto yy133;
				goto yy680;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy680;
				goto yy133;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy678;
				goto yy133;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy676;
				goto yy133;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy659;
			if (yych <= 'T') goto yy133;
			goto yy658;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy668;
		} else {
			if (yych == 'u') goto yy667;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy659;
			if (yych <= 'T') goto yy133;
			goto yy658;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy659;
		} else {
			if (yych == 'u') goto yy658;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy133;
				goto yy620;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy621;
				goto yy133;
			} else {
				if (yych <= 'O') goto yy622;
				if (yych <= 'Q') goto yy133;
				goto yy623;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy133;
				if (yych <= '`') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'e') goto yy639;
				if (yych <= 'h') goto yy138;
				goto yy640;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy641;
				goto yy138;
			} else {
				if (yych <= 'r') goto yy642;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy133;
				goto yy620;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy621;
				goto yy133;
			} else {
				if (yych <= 'O') goto yy622;
				if (yych <= 'Q') goto yy133;
				goto yy623;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy133;
				if (yych <= '`') goto yy3;
				goto yy133;
			} else {
				if (yych <= 'e') goto yy620;
				if (yych <= 'h') goto yy133;
				goto yy621;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy622;
				goto yy133;
			} else {
				if (yych <= 'r') goto yy623;
				if (yych <= 'z') goto yy133;
				goto yy3;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy599;
				goto yy133;
			} else {
				if (yych <= 'P') goto yy598;
				if (yych <= 'T') goto yy133;
				goto yy597;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if (yych == 'g') goto yy611;
				goto yy138;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy610;
				goto yy138;
			} else {
				if (yych <= 'u') goto yy609;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy599;
				goto yy133;
			} else {
				if (yych <= 'P') goto yy598;
				if (yych <= 'T') goto yy133;
				goto yy597;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if (yych == 'g') goto yy599;
				goto yy133;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy598;
				goto yy133;
			} else {
				if (yych <= 'u') goto yy597;
				if (yych <= 'z') goto yy133;
				goto yy3;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy540;
				goto yy133;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy539;
				goto yy133;
			} else {
				if (yych <= 'I') goto yy541;
				if (yych <= 'T') goto yy133;
				goto yy542;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy569;
				if (yych <= 'd') goto yy138;
				goto yy568;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy570;
				goto yy138;
			} else {
				if (yych <= 'u') goto yy571;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy540;
				goto yy133;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy539;
				goto yy133;
			} else {
				if (yych <= 'I') goto yy541;
				if (yych <= 'T') goto yy133;
				goto yy542;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy133;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy540;
				if (yych <= 'd') goto yy133;
				goto yy539;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy541;
				goto yy133;
			} else {
				if (yych <= 'u') goto yy542;
				if (yych <= 'z') goto yy133;
				goto yy3;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy133;
			goto yy529;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'c') goto yy534;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy133;
			goto yy529;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'c') goto yy529;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy133;
			goto yy420;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy522;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy133;
			goto yy420;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'e') goto yy420;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy133;
			goto yy403;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy412;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy133;
			goto yy403;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'e') goto yy403;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'I') goto yy367;
			if (yych <= 'K') goto yy133;
			goto yy368;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy138;
			goto yy385;
		} else {
			if (yych == 'l') goto yy386;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'I') goto yy367;
			if (yych <= 'K') goto yy133;
			goto yy368;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy133;
			goto yy367;
		} else {
			if (yych == 'l') goto yy368;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
		goto yy319;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy133;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy343;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
		goto yy319;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy133;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy319;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy133;
			goto yy157;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'r') goto yy239;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy133;
			goto yy157;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy133;
			if (yych <= '`') goto yy3;
			goto yy133;
		} else {
			if (yych <= 'r') goto yy157;
			if (yych <= 'z') goto yy133;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= '/') goto yy12;
	if (yych <= '1') goto yy150;
	if (yych <= '2') goto yy151;
	if (yych <= '9') goto yy152;
	goto yy12;
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy149;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy149;
	goto yy12;
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy133;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy138;
		goto yy3;
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy133;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy133;
		goto yy3;
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= '/') goto yy46;
	if (yych <= '9') goto yy51;
yy46:
	YYDEBUG(46, *YYCURSOR);
#line 1429 "parse_date.db.re"
	{
		goto std;
	}
#line 2222 "parse_date.db.c"
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy46;
yy48:
	YYDEBUG(48, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(49, *YYCURSOR);
#line 1434 "parse_date.db.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 2236 "parse_date.db.c"
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych >= ' ') goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy58;
				} else {
					if (yych <= 'T') goto yy65;
					if (yych >= 'W') goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy63;
				} else {
					if (yych == 'h') goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy53;
				if (yych <= 's') goto yy58;
				goto yy65;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy62;
				} else {
					if (yych == 'y') goto yy64;
				}
			}
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 13) {
		if (yyaccept <= 6) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept == 0) {
						goto yy3;
					} else {
						goto yy12;
					}
				} else {
					if (yyaccept == 2) {
						goto yy46;
					} else {
						goto yy69;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept == 4) {
						goto yy176;
					} else {
						goto yy405;
					}
				} else {
					goto yy426;
				}
			}
		} else {
			if (yyaccept <= 10) {
				if (yyaccept <= 8) {
					if (yyaccept == 7) {
						goto yy448;
					} else {
						goto yy491;
					}
				} else {
					if (yyaccept == 9) {
						goto yy601;
					} else {
						goto yy698;
					}
				}
			} else {
				if (yyaccept <= 12) {
					if (yyaccept == 11) {
						goto yy713;
					} else {
						goto yy860;
					}
				} else {
					goto yy870;
				}
			}
		}
	} else {
		if (yyaccept <= 20) {
			if (yyaccept <= 17) {
				if (yyaccept <= 15) {
					if (yyaccept == 14) {
						goto yy971;
					} else {
						goto yy1005;
					}
				} else {
					if (yyaccept == 16) {
						goto yy1032;
					} else {
						goto yy978;
					}
				}
			} else {
				if (yyaccept <= 19) {
					if (yyaccept == 18) {
						goto yy1134;
					} else {
						goto yy1026;
					}
				} else {
					goto yy1238;
				}
			}
		} else {
			if (yyaccept <= 23) {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy1246;
					} else {
						goto yy1301;
					}
				} else {
					goto yy1304;
				}
			} else {
				if (yyaccept <= 25) {
					if (yyaccept == 24) {
						goto yy1382;
					} else {
						goto yy1390;
					}
				} else {
					goto yy1413;
				}
			}
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy51;
	goto yy53;
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy57:
	YYDEBUG(57, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych <= 0x1F) goto yy53;
				goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych <= 'E') goto yy53;
				goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych <= 'L') goto yy53;
				goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
				} else {
					if (yych <= 'T') goto yy65;
					if (yych <= 'V') goto yy53;
					goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych <= 'c') goto yy53;
				goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy63;
				} else {
					if (yych == 'h') goto yy60;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy53;
				if (yych >= 't') goto yy65;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy62;
				} else {
					if (yych == 'y') goto yy64;
					goto yy53;
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy120;
			if (yych <= 'T') goto yy53;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy120;
			if (yych == 'u') goto yy118;
			goto yy53;
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy110;
		if (yych <= 'N') goto yy53;
		goto yy109;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy110;
		} else {
			if (yych == 'o') goto yy109;
			goto yy53;
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy107;
	if (yych == 'o') goto yy107;
	goto yy53;
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy106;
	if (yych == 'a') goto yy106;
	goto yy53;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy53;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy83;
		if (yych <= 'Q') goto yy53;
		goto yy82;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy83;
		} else {
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy79;
	if (yych == 'e') goto yy79;
	goto yy53;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy66;
		if (yych <= 'T') goto yy53;
		goto yy67;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
		} else {
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy74;
	if (yych == 'u') goto yy74;
	goto yy53;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy68;
	if (yych != 'e') goto yy53;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy70;
	if (yych == 's') goto yy70;
yy69:
	YYDEBUG(69, *YYCURSOR);
#line 1413 "parse_date.db.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 2610 "parse_date.db.c"
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy71;
	if (yych != 'd') goto yy53;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy72;
	if (yych != 'a') goto yy53;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych != 'y') goto yy53;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy69;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy75;
	if (yych != 'r') goto yy69;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych != 's') goto yy53;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy77;
	if (yych != 'd') goto yy53;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy78;
	if (yych != 'a') goto yy53;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy80;
	if (yych != 'a') goto yy53;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy81;
	if (yych != 'r') goto yy53;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
	goto yy69;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy95;
	if (yych == 'i') goto yy95;
	goto yy53;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy84;
	if (yych != 'r') goto yy53;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy85;
	if (yych != 't') goto yy53;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy87;
		if (yych <= 'M') goto yy53;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy87;
		} else {
			if (yych != 'n') goto yy53;
		}
	}
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy92;
	if (yych == 'i') goto yy92;
	goto yy53;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy88;
	if (yych != 'n') goto yy53;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy89;
	if (yych != 'i') goto yy53;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy90;
	if (yych != 'g') goto yy53;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy91;
	if (yych != 'h') goto yy53;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy81;
	if (yych == 't') goto yy81;
	goto yy53;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy93;
	if (yych != 'g') goto yy53;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy94;
	if (yych != 'h') goto yy53;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy81;
	if (yych == 't') goto yy81;
	goto yy53;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy96;
	if (yych != 'd') goto yy69;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy97;
	if (yych != 'a') goto yy53;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy100;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy100;
		if (yych >= 'f') goto yy53;
	}
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy81;
	if (yych == 'k') goto yy81;
	goto yy53;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy101;
	if (yych != 'n') goto yy69;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy102;
	if (yych != 'e') goto yy53;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy103;
	if (yych != 's') goto yy53;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy104;
	if (yych != 'd') goto yy53;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy105;
	if (yych != 'a') goto yy53;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy81;
	if (yych == 'y') goto yy81;
	goto yy53;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy108;
	if (yych != 'u') goto yy53;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy81;
	if (yych == 'r') goto yy81;
	goto yy53;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy114;
	if (yych == 'n') goto yy114;
	goto yy53;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy111;
	if (yych != 'n') goto yy53;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy73;
		if (yych <= 'T') goto yy69;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy69;
			goto yy73;
		} else {
			if (yych != 'u') goto yy69;
		}
	}
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy113;
	if (yych != 't') goto yy53;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy81;
	if (yych == 'e') goto yy81;
	goto yy53;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy115;
		if (yych <= 'S') goto yy69;
		goto yy116;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy69;
		} else {
			if (yych == 't') goto yy116;
			goto yy69;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy117;
	if (yych == 'a') goto yy117;
	goto yy53;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy81;
	if (yych == 'h') goto yy81;
	goto yy53;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy129;
	if (yych == 'n') goto yy129;
	goto yy53;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy124;
	if (yych == 't') goto yy124;
	goto yy53;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy121;
	if (yych != 'c') goto yy53;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy122;
		if (yych <= 'R') goto yy69;
		goto yy73;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy69;
		} else {
			if (yych == 's') goto yy73;
			goto yy69;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy123;
	if (yych != 'n') goto yy53;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy81;
	if (yych == 'd') goto yy81;
	goto yy53;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy125;
	if (yych != 'u') goto yy69;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy126;
	if (yych != 'r') goto yy53;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy127;
	if (yych != 'd') goto yy53;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy128;
	if (yych != 'a') goto yy53;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy130;
	if (yych != 'd') goto yy69;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy131;
	if (yych != 'a') goto yy53;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy134;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy135;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy136;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy132;
	goto yy3;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych != '/') goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '^') goto yy3;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych >= '[') goto yy53;
	YYDEBUG(141, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 32) {
		goto yy142;
	}
	goto yy53;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(143, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy142;
	}
	if (yych == '/') goto yy140;
	if (yych == '_') goto yy140;
	goto yy3;
yy144:
	YYDEBUG(144, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy132;
		if (yych <= '.') goto yy3;
		goto yy140;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy148:
	YYDEBUG(148, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy53;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy147;
		goto yy53;
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy133;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy133;
		goto yy3;
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy152;
				} else {
					if (yych <= ':') goto yy153;
					if (yych <= 'C') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '3') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '5') goto yy154;
					if (yych <= '9') goto yy155;
					goto yy153;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy154;
				} else {
					if (yych <= '9') goto yy155;
					if (yych >= ';') goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy156;
	if (yych <= '9') goto yy132;
	goto yy3;
yy154:
	YYDEBUG(154, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy155;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych <= 'E') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych <= 'L') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'R') goto yy3;
				if (yych <= 'T') goto yy57;
				if (yych <= 'V') goto yy3;
				goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych <= 'c') goto yy3;
				goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych <= 'g') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy132;
	goto yy3;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'e') goto yy158;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy135;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'v') goto yy159;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy136;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'i') goto yy160;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy137;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'o') goto yy161;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy162;
		if (yych != 'u') goto yy3;
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy163;
	if (yych != 's') goto yy53;
yy163:
	YYDEBUG(163, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy164:
	YYDEBUG(164, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy163;
				if (yych <= 0x1F) goto yy53;
				goto yy163;
			} else {
				if (yych == 'D') goto yy168;
				if (yych <= 'E') goto yy53;
				goto yy170;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy167;
				if (yych <= 'L') goto yy53;
				goto yy166;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
				} else {
					if (yych <= 'T') goto yy172;
					if (yych <= 'V') goto yy53;
					goto yy169;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy171;
				if (yych <= 'c') goto yy53;
				goto yy168;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy170;
				} else {
					if (yych == 'h') goto yy167;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy166;
				if (yych <= 'r') goto yy53;
				if (yych >= 't') goto yy172;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy169;
				} else {
					if (yych == 'y') goto yy171;
					goto yy53;
				}
			}
		}
	}
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy226;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy227;
			if (yych <= 'T') goto yy53;
			goto yy225;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy226;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy227;
			if (yych == 'u') goto yy225;
			goto yy53;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy217;
		if (yych <= 'N') goto yy53;
		goto yy216;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy217;
		} else {
			if (yych == 'o') goto yy216;
			goto yy53;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy214;
	if (yych == 'o') goto yy214;
	goto yy53;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy213;
	if (yych == 'a') goto yy213;
	goto yy53;
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy205;
	if (yych == 'e') goto yy205;
	goto yy53;
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy190;
		if (yych <= 'Q') goto yy53;
		goto yy189;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy190;
		} else {
			if (yych == 'r') goto yy189;
			goto yy53;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy186;
	if (yych == 'e') goto yy186;
	goto yy53;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy173;
		if (yych <= 'T') goto yy53;
		goto yy174;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
		} else {
			if (yych == 'u') goto yy174;
			goto yy53;
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy181;
	if (yych == 'u') goto yy181;
	goto yy53;
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy175;
	if (yych != 'e') goto yy53;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy177;
	if (yych == 's') goto yy177;
yy176:
	YYDEBUG(176, *YYCURSOR);
#line 1352 "parse_date.db.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3844 "parse_date.db.c"
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy178;
	if (yych != 'd') goto yy53;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy179;
	if (yych != 'a') goto yy53;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych != 'y') goto yy53;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy176;
yy181:
	YYDEBUG(181, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy182;
	if (yych != 'r') goto yy176;
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy183;
	if (yych != 's') goto yy53;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy184;
	if (yych != 'd') goto yy53;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy185;
	if (yych != 'a') goto yy53;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy180;
	goto yy53;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy187;
	if (yych != 'a') goto yy53;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy188;
	if (yych != 'r') goto yy53;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy180;
	if (yych == 's') goto yy180;
	goto yy176;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy202;
	if (yych == 'i') goto yy202;
	goto yy53;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy191;
	if (yych != 'r') goto yy53;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy192;
	if (yych != 't') goto yy53;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy194;
		if (yych <= 'M') goto yy53;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy194;
		} else {
			if (yych != 'n') goto yy53;
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy199;
	if (yych == 'i') goto yy199;
	goto yy53;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy195;
	if (yych != 'n') goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy196;
	if (yych != 'i') goto yy53;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy197;
	if (yych != 'g') goto yy53;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy198;
	if (yych != 'h') goto yy53;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy188;
	if (yych == 't') goto yy188;
	goto yy53;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy200;
	if (yych != 'g') goto yy53;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy201;
	if (yych != 'h') goto yy53;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy188;
	if (yych == 't') goto yy188;
	goto yy53;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy203;
	if (yych != 'd') goto yy176;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy204;
	if (yych != 'a') goto yy53;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy180;
	goto yy53;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy207;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy207;
		if (yych >= 'f') goto yy53;
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy188;
	if (yych == 'k') goto yy188;
	goto yy53;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy208;
	if (yych != 'n') goto yy176;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy209;
	if (yych != 'e') goto yy53;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy210;
	if (yych != 's') goto yy53;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy211;
	if (yych != 'd') goto yy53;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy212;
	if (yych != 'a') goto yy53;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy180;
	goto yy53;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy188;
	if (yych == 'y') goto yy188;
	goto yy53;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy215;
	if (yych != 'u') goto yy53;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy188;
	if (yych == 'r') goto yy188;
	goto yy53;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy221;
	if (yych == 'n') goto yy221;
	goto yy53;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy218;
	if (yych != 'n') goto yy53;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy180;
		if (yych <= 'T') goto yy176;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy176;
			goto yy180;
		} else {
			if (yych != 'u') goto yy176;
		}
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy220;
	if (yych != 't') goto yy53;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy188;
	if (yych == 'e') goto yy188;
	goto yy53;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy222;
		if (yych <= 'S') goto yy176;
		goto yy223;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy176;
		} else {
			if (yych == 't') goto yy223;
			goto yy176;
		}
	}
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy224;
	if (yych == 'a') goto yy224;
	goto yy53;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy188;
	if (yych == 'h') goto yy188;
	goto yy53;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy180;
	goto yy53;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy236;
	if (yych == 'n') goto yy236;
	goto yy53;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy231;
	if (yych == 't') goto yy231;
	goto yy53;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy228;
	if (yych != 'c') goto yy53;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy229;
		if (yych <= 'R') goto yy176;
		goto yy180;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy176;
		} else {
			if (yych == 's') goto yy180;
			goto yy176;
		}
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy230;
	if (yych != 'n') goto yy53;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy188;
	if (yych == 'd') goto yy188;
	goto yy53;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy232;
	if (yych != 'u') goto yy176;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy233;
	if (yych != 'r') goto yy53;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy234;
	if (yych != 'd') goto yy53;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy235;
	if (yych != 'a') goto yy53;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy180;
	goto yy53;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy237;
	if (yych != 'd') goto yy176;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy238;
	if (yych != 'a') goto yy53;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy180;
	goto yy53;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
			goto yy158;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy240;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy135;
			goto yy159;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'v') goto yy241;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy136;
			goto yy160;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'i') goto yy242;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy137;
			goto yy161;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy243;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'T') goto yy3;
			goto yy162;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'u') goto yy244;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy53;
			goto yy140;
		} else {
			if (yych == 'S') goto yy163;
			goto yy53;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy53;
			goto yy147;
		} else {
			if (yych <= 's') goto yy245;
			if (yych <= 'z') goto yy147;
			goto yy53;
		}
	}
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'h') {
		if (yych <= '`') {
			if (yych <= '/') {
				if (yych <= '.') goto yy164;
				goto yy140;
			} else {
				if (yych == '_') goto yy140;
				goto yy164;
			}
		} else {
			if (yych <= 'e') {
				if (yych == 'd') goto yy249;
				goto yy147;
			} else {
				if (yych <= 'f') goto yy251;
				if (yych <= 'g') goto yy147;
				goto yy248;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy147;
				goto yy247;
			} else {
				if (yych <= 'r') goto yy147;
				if (yych >= 't') goto yy253;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'w') goto yy250;
				goto yy147;
			} else {
				if (yych <= 'y') goto yy252;
				if (yych <= 'z') goto yy147;
				goto yy164;
			}
		}
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy226;
			goto yy148;
		} else {
			if (yych <= 'E') goto yy227;
			if (yych <= 'T') goto yy148;
			goto yy225;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy305;
			goto yy148;
		} else {
			if (yych <= 'e') goto yy306;
			if (yych == 'u') goto yy307;
			goto yy148;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy217;
		if (yych <= 'N') goto yy148;
		goto yy216;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy148;
			goto yy296;
		} else {
			if (yych == 'o') goto yy297;
			goto yy148;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy214;
	if (yych == 'o') goto yy294;
	goto yy148;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy213;
	if (yych == 'a') goto yy293;
	goto yy148;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy205;
	if (yych == 'e') goto yy285;
	goto yy148;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy190;
		if (yych <= 'Q') goto yy148;
		goto yy189;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy148;
			goto yy269;
		} else {
			if (yych == 'r') goto yy270;
			goto yy148;
		}
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy186;
	if (yych == 'e') goto yy266;
	goto yy148;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy173;
		if (yych <= 'T') goto yy148;
		goto yy174;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy148;
		} else {
			if (yych == 'u') goto yy255;
			goto yy148;
		}
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy181;
	if (yych == 'u') goto yy261;
	goto yy148;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy175;
	if (yych != 'e') goto yy148;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'S') goto yy177;
			goto yy176;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 's') goto yy257;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy178;
	if (yych != 'd') goto yy148;
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy179;
	if (yych != 'a') goto yy148;
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych != 'y') goto yy148;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy176;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy176;
		if (yych <= 'z') goto yy147;
		goto yy176;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'R') goto yy182;
			goto yy176;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 'r') goto yy262;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy183;
	if (yych != 's') goto yy148;
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy184;
	if (yych != 'd') goto yy148;
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy185;
	if (yych != 'a') goto yy148;
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy260;
	goto yy148;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy187;
	if (yych != 'a') goto yy148;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy188;
	if (yych != 'r') goto yy148;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'S') goto yy180;
			goto yy176;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 's') goto yy260;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy191;
	if (yych == 'r') goto yy274;
	goto yy148;
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy202;
	if (yych != 'i') goto yy148;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'D') goto yy203;
			goto yy176;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 'd') goto yy272;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy204;
	if (yych != 'a') goto yy148;
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy260;
	goto yy148;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy192;
	if (yych != 't') goto yy148;
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy194;
		if (yych <= 'M') goto yy148;
		goto yy193;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy148;
			goto yy277;
		} else {
			if (yych != 'n') goto yy148;
		}
	}
	YYDEBUG(276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy199;
	if (yych == 'i') goto yy282;
	goto yy148;
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy195;
	if (yych != 'n') goto yy148;
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy196;
	if (yych != 'i') goto yy148;
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy197;
	if (yych != 'g') goto yy148;
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy198;
	if (yych != 'h') goto yy148;
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy188;
	if (yych == 't') goto yy268;
	goto yy148;
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy200;
	if (yych != 'g') goto yy148;
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy201;
	if (yych != 'h') goto yy148;
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy188;
	if (yych == 't') goto yy268;
	goto yy148;
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy148;
		if (yych <= 'D') goto yy207;
		goto yy206;
	} else {
		if (yych <= 'c') goto yy148;
		if (yych <= 'd') goto yy287;
		if (yych >= 'f') goto yy148;
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy188;
	if (yych == 'k') goto yy268;
	goto yy148;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'N') goto yy208;
			goto yy176;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 'n') goto yy288;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy209;
	if (yych != 'e') goto yy148;
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy210;
	if (yych != 's') goto yy148;
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy211;
	if (yych != 'd') goto yy148;
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy212;
	if (yych != 'a') goto yy148;
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy260;
	goto yy148;
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy188;
	if (yych == 'y') goto yy268;
	goto yy148;
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy215;
	if (yych != 'u') goto yy148;
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy188;
	if (yych == 'r') goto yy268;
	goto yy148;
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy218;
	if (yych == 'n') goto yy302;
	goto yy148;
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy221;
	if (yych != 'n') goto yy148;
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'C') {
			if (yych == '/') goto yy140;
			goto yy176;
		} else {
			if (yych <= 'D') goto yy222;
			if (yych == 'T') goto yy223;
			goto yy176;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			if (yych <= 'c') goto yy147;
		} else {
			if (yych == 't') goto yy300;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy224;
	if (yych == 'a') goto yy301;
	goto yy148;
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy188;
	if (yych == 'h') goto yy268;
	goto yy148;
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy260;
	goto yy148;
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'R') {
			if (yych == '/') goto yy140;
			goto yy176;
		} else {
			if (yych <= 'S') goto yy180;
			if (yych == 'U') goto yy219;
			goto yy176;
		}
	} else {
		if (yych <= 's') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			if (yych <= 'r') goto yy147;
			goto yy260;
		} else {
			if (yych == 'u') goto yy303;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy220;
	if (yych != 't') goto yy148;
	YYDEBUG(304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy188;
	if (yych == 'e') goto yy268;
	goto yy148;
yy305:
	YYDEBUG(305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy231;
	if (yych == 't') goto yy314;
	goto yy148;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy228;
	if (yych == 'c') goto yy311;
	goto yy148;
yy307:
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy236;
	if (yych != 'n') goto yy148;
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'D') goto yy237;
			goto yy176;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 'd') goto yy309;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy238;
	if (yych != 'a') goto yy148;
	YYDEBUG(310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy260;
	goto yy148;
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'N') {
			if (yych == '/') goto yy140;
			goto yy176;
		} else {
			if (yych <= 'O') goto yy229;
			if (yych == 'S') goto yy180;
			goto yy176;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			if (yych <= 'n') goto yy147;
		} else {
			if (yych == 's') goto yy260;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy230;
	if (yych != 'n') goto yy148;
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy188;
	if (yych == 'd') goto yy268;
	goto yy148;
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy176;
			goto yy140;
		} else {
			if (yych == 'U') goto yy232;
			goto yy176;
		}
	} else {
		if (yych <= 't') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy176;
			goto yy147;
		} else {
			if (yych <= 'u') goto yy315;
			if (yych <= 'z') goto yy147;
			goto yy176;
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy233;
	if (yych != 'r') goto yy148;
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy234;
	if (yych != 'd') goto yy148;
	YYDEBUG(317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy235;
	if (yych != 'a') goto yy148;
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych == 'y') goto yy260;
	goto yy148;
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy134;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 's') goto yy320;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy321;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy163;
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy136;
	case 'D':
	case 'd':	goto yy325;
	case 'F':
	case 'f':	goto yy327;
	case 'H':
	case 'h':	goto yy324;
	case 'M':
	case 'm':	goto yy323;
	case 'S':
	case 's':	goto yy322;
	case 'T':
	case 't':	goto yy329;
	case 'W':
	case 'w':	goto yy326;
	case 'Y':
	case 'y':	goto yy328;
	default:	goto yy3;
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'A') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy340;
		} else {
			if (yych == 'E') goto yy341;
			if (yych <= 'T') goto yy137;
			goto yy342;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy340;
			goto yy137;
		} else {
			if (yych <= 't') {
				if (yych <= 'e') goto yy341;
				goto yy137;
			} else {
				if (yych <= 'u') goto yy342;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'I') goto yy338;
			if (yych <= 'N') goto yy137;
			goto yy339;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy137;
			goto yy338;
		} else {
			if (yych == 'o') goto yy339;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy137;
			goto yy337;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'o') goto yy337;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
		goto yy336;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy336;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy335;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy335;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'O') goto yy333;
			if (yych <= 'Q') goto yy137;
			goto yy334;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy137;
			goto yy333;
		} else {
			if (yych == 'r') goto yy334;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy332;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy332;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'H') goto yy330;
			if (yych <= 'T') goto yy137;
			goto yy331;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'g') goto yy137;
		} else {
			if (yych == 'u') goto yy331;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy181;
		if (yych == 'u') goto yy181;
		goto yy3;
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy175;
		if (yych == 'e') goto yy175;
		goto yy3;
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy187;
		if (yych == 'a') goto yy187;
		goto yy3;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy191;
		if (yych == 'r') goto yy191;
		goto yy3;
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'I') goto yy202;
		if (yych == 'i') goto yy202;
		goto yy3;
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy132;
		if (yych <= 'C') goto yy3;
		goto yy207;
	} else {
		if (yych <= 'c') {
			if (yych <= 'E') goto yy206;
			goto yy3;
		} else {
			if (yych <= 'd') goto yy207;
			if (yych <= 'e') goto yy206;
			goto yy3;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy188;
		if (yych == 'y') goto yy188;
		goto yy3;
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy215;
		if (yych == 'u') goto yy215;
		goto yy3;
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'N') goto yy218;
		if (yych == 'n') goto yy218;
		goto yy3;
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'N') goto yy221;
		if (yych == 'n') goto yy221;
		goto yy3;
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy231;
		if (yych == 't') goto yy231;
		goto yy3;
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy228;
		if (yych == 'c') goto yy228;
		goto yy3;
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'N') goto yy236;
		if (yych == 'n') goto yy236;
		goto yy3;
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy134;
			goto yy320;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 's') goto yy344;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy321;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy345;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy163;
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':	goto yy136;
	case 'D':	goto yy325;
	case 'F':	goto yy327;
	case 'H':	goto yy324;
	case 'M':	goto yy323;
	case 'S':	goto yy322;
	case 'T':	goto yy329;
	case 'W':	goto yy326;
	case 'Y':	goto yy328;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy145;
	case 'd':	goto yy349;
	case 'f':	goto yy351;
	case 'h':	goto yy348;
	case 'm':	goto yy347;
	case 's':	goto yy346;
	case 't':	goto yy353;
	case 'w':	goto yy350;
	case 'y':	goto yy352;
	default:	goto yy3;
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych == '/') goto yy140;
				goto yy3;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'A') goto yy340;
				goto yy137;
			} else {
				if (yych <= 'E') goto yy341;
				if (yych <= 'T') goto yy137;
				goto yy342;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy364;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'e') goto yy365;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy366;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy338;
				if (yych <= 'N') goto yy137;
				goto yy339;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy362;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy363;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy137;
			goto yy337;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy361;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy336;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy360;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy335;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy359;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'N') {
				if (yych <= '@') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'O') goto yy333;
				if (yych <= 'Q') goto yy137;
				goto yy334;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'o') goto yy357;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy358;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy332;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy356;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'H') goto yy330;
				if (yych <= 'T') goto yy137;
				goto yy331;
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 't') {
				if (yych >= 'i') goto yy146;
			} else {
				if (yych <= 'u') goto yy355;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'T') goto yy3;
			goto yy181;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'u') goto yy261;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'D') goto yy3;
			goto yy175;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy256;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy187;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy267;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'Q') goto yy3;
			goto yy191;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy274;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'H') goto yy3;
			goto yy202;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'i') goto yy271;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'C') goto yy3;
			if (yych <= 'D') goto yy207;
			goto yy206;
		}
	} else {
		if (yych <= 'c') {
			if (yych == '_') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') goto yy287;
			if (yych <= 'e') goto yy286;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'X') goto yy3;
			goto yy188;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy268;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'T') goto yy3;
			goto yy215;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'u') goto yy295;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'M') goto yy3;
			goto yy218;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy302;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'M') goto yy3;
			goto yy221;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy298;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'S') goto yy3;
			goto yy231;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy314;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'B') goto yy3;
			goto yy228;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'c') goto yy311;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'M') goto yy3;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy308;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy134;
			goto yy374;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'g') goto yy374;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'e') goto yy369;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy135;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'v') goto yy370;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy136;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'e') goto yy371;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy137;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'n') goto yy372;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy373;
		if (yych != 't') goto yy3;
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy163;
	if (yych == 'h') goto yy163;
	goto yy53;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy135;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'h') goto yy375;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy136;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 't') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy163;
	case ')':	goto yy132;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy137;
	case 'D':
	case 'd':	goto yy377;
	case 'F':
	case 'f':	goto yy378;
	case 'H':
	case 'h':	goto yy379;
	case 'M':
	case 'm':	goto yy380;
	case 'S':
	case 's':	goto yy381;
	case 'T':
	case 't':	goto yy382;
	case 'W':
	case 'w':	goto yy383;
	case 'Y':
	case 'y':	goto yy384;
	default:	goto yy3;
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy213;
		if (yych == 'a') goto yy213;
		goto yy3;
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych == 'O') goto yy190;
			goto yy3;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'R') goto yy189;
			if (yych <= 'n') goto yy3;
			goto yy190;
		} else {
			if (yych == 'r') goto yy189;
			goto yy3;
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy214;
		if (yych == 'o') goto yy214;
		goto yy3;
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych == 'I') goto yy217;
			goto yy3;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'O') goto yy216;
			if (yych <= 'h') goto yy3;
			goto yy217;
		} else {
			if (yych == 'o') goto yy216;
			goto yy3;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy226;
			if (yych == 'E') goto yy227;
			goto yy3;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'U') goto yy225;
			if (yych == 'a') goto yy226;
			goto yy3;
		} else {
			if (yych <= 'e') goto yy227;
			if (yych == 'u') goto yy225;
			goto yy3;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych == 'H') goto yy173;
			goto yy3;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'U') goto yy174;
			if (yych <= 'g') goto yy3;
			goto yy173;
		} else {
			if (yych == 'u') goto yy174;
			goto yy3;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy205;
		if (yych == 'e') goto yy205;
		goto yy3;
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy186;
		if (yych == 'e') goto yy186;
		goto yy3;
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy134;
			goto yy374;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'g') goto yy392;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
			goto yy369;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy387;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy135;
			goto yy370;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'v') goto yy388;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy136;
			goto yy371;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy389;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy137;
			goto yy372;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy390;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'S') goto yy3;
			goto yy373;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy391;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy53;
			goto yy140;
		} else {
			if (yych == 'H') goto yy163;
			goto yy53;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy53;
			goto yy147;
		} else {
			if (yych <= 'h') goto yy245;
			if (yych <= 'z') goto yy147;
			goto yy53;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy135;
			goto yy375;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy393;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy163;
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy140;
	case 'A':
	case 'B':
	case 'C':
	case 'E':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'U':
	case 'V':
	case 'X':
	case 'Z':	goto yy137;
	case 'D':	goto yy377;
	case 'F':	goto yy378;
	case 'H':	goto yy379;
	case 'M':	goto yy380;
	case 'S':	goto yy381;
	case 'T':	goto yy382;
	case 'W':	goto yy383;
	case 'Y':	goto yy384;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy146;
	case 'd':	goto yy395;
	case 'f':	goto yy396;
	case 'h':	goto yy397;
	case 'm':	goto yy398;
	case 's':	goto yy399;
	case 't':	goto yy400;
	case 'w':	goto yy401;
	case 'y':	goto yy402;
	default:	goto yy3;
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy213;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy293;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych == 'O') goto yy190;
			if (yych <= 'Q') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= 'n') {
			if (yych == '_') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= 'o') goto yy269;
				goto yy147;
			} else {
				if (yych <= 'r') goto yy270;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'N') goto yy3;
			goto yy214;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy294;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych == 'I') goto yy217;
			if (yych <= 'N') goto yy3;
			goto yy216;
		}
	} else {
		if (yych <= 'h') {
			if (yych == '_') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy296;
				goto yy147;
			} else {
				if (yych <= 'o') goto yy297;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych == '/') goto yy140;
				goto yy3;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'A') goto yy226;
				goto yy3;
			} else {
				if (yych <= 'E') goto yy227;
				if (yych <= 'T') goto yy3;
				goto yy225;
			}
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'a') goto yy305;
				goto yy147;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'e') goto yy306;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy307;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych == 'H') goto yy173;
			if (yych <= 'T') goto yy3;
			goto yy174;
		}
	} else {
		if (yych <= 'g') {
			if (yych == '_') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= 'h') goto yy254;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy255;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'D') goto yy3;
			goto yy205;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy285;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'D') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy266;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy134;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'd') goto yy404;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'M') goto yy135;
			goto yy406;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy135;
			if (yych >= 'a') goto yy135;
		} else {
			if (yych <= 'n') goto yy406;
			if (yych <= 'z') goto yy135;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
#line 1336 "parse_date.db.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 7101 "parse_date.db.c"
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy136;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'e') goto yy407;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy137;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 's') goto yy408;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy409;
		if (yych != 'd') goto yy3;
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy410;
	if (yych != 'a') goto yy53;
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy411;
	if (yych != 'y') goto yy53;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy405;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy134;
			goto yy404;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy413;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'M') goto yy135;
			goto yy406;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 'n') goto yy414;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy136;
			goto yy407;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy415;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy137;
			goto yy408;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 's') goto yy416;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'C') goto yy3;
			goto yy409;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy417;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy410;
	if (yych != 'a') goto yy148;
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy411;
	if (yych != 'y') goto yy148;
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy405;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy405;
		if (yych <= 'z') goto yy147;
		goto yy405;
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy134;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'c') goto yy421;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych == 'E') goto yy429;
				goto yy135;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'e') goto yy429;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
	yych = *YYCURSOR;
yy423:
	YYDEBUG(423, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy422;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy425;
	if (yych <= '3') goto yy427;
	if (yych <= '9') goto yy428;
	goto yy53;
yy424:
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy423;
	if (yych <= '0') goto yy511;
	if (yych <= '2') goto yy512;
	if (yych <= '3') goto yy513;
	goto yy423;
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy441;
			goto yy493;
		} else {
			if (yych <= '2') goto yy510;
			if (yych <= '9') goto yy493;
			goto yy441;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy437;
			if (yych <= 'q') goto yy441;
			goto yy438;
		} else {
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
#line 1151 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7442 "parse_date.db.c"
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy441;
			goto yy493;
		} else {
			if (yych <= '2') goto yy434;
			if (yych <= '9') goto yy435;
			goto yy441;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy437;
			if (yych <= 'q') goto yy441;
			goto yy438;
		} else {
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy441;
			goto yy433;
		} else {
			if (yych <= '2') goto yy434;
			if (yych <= '9') goto yy435;
			goto yy441;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy437;
			if (yych <= 'q') goto yy441;
			goto yy438;
		} else {
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy136;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'm') goto yy430;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy137;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'b') goto yy431;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy432;
		if (yych != 'e') goto yy3;
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy422;
	if (yych == 'r') goto yy422;
	goto yy53;
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy492;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '3') goto yy492;
		if (yych <= '9') goto yy489;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy489;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy441;
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy441;
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy441;
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy441;
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy441:
	YYDEBUG(441, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy440;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy426;
		if (yych <= '1') goto yy482;
		goto yy483;
	} else {
		if (yych <= '9') goto yy484;
		if (yych != 'T') goto yy426;
	}
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy443;
	if (yych <= '2') goto yy444;
	if (yych <= '9') goto yy445;
	goto yy53;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy53;
	} else {
		if (yych <= '9') goto yy445;
		if (yych <= ':') goto yy446;
		goto yy53;
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy53;
	} else {
		if (yych <= '3') goto yy445;
		if (yych == ':') goto yy446;
		goto yy53;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy446;
	if (yych != ':') goto yy53;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy447;
	if (yych <= '9') goto yy449;
	goto yy53;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy450;
	} else {
		if (yych <= '9') goto yy449;
		if (yych <= ':') goto yy450;
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
#line 1383 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 7710 "parse_date.db.c"
yy449:
	YYDEBUG(449, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy450;
	if (yych != ':') goto yy448;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy451;
	if (yych <= '6') goto yy452;
	if (yych <= '9') goto yy453;
	goto yy53;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy448;
	if (yych <= '9') goto yy454;
	goto yy448;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy454;
	goto yy448;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy448;
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy448;
		} else {
			if (yych <= ' ') goto yy455;
			if (yych == '(') goto yy458;
			goto yy448;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy448;
			if (yych <= '-') goto yy457;
			goto yy448;
		} else {
			if (yych <= 'Z') goto yy459;
			if (yych <= '`') goto yy448;
			if (yych <= 'z') goto yy460;
			goto yy448;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	YYDEBUG(456, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy455;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy455;
			if (yych == '(') goto yy458;
			goto yy53;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy53;
			if (yych >= '.') goto yy53;
		} else {
			if (yych <= 'Z') goto yy459;
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy460;
			goto yy53;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy477;
	if (yych <= '2') goto yy478;
	if (yych <= '9') goto yy479;
	goto yy53;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy460;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy460;
	goto yy53;
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy453;
		goto yy448;
	} else {
		if (yych <= 'Z') goto yy461;
		if (yych <= '`') goto yy448;
		if (yych <= 'z') goto yy466;
		goto yy448;
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy453;
		goto yy448;
	} else {
		if (yych <= 'Z') goto yy461;
		if (yych <= '`') goto yy448;
		if (yych >= '{') goto yy448;
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy453;
		goto yy448;
	} else {
		if (yych <= 'Z') goto yy462;
		if (yych <= '`') goto yy448;
		if (yych >= '{') goto yy448;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy453;
		goto yy448;
	} else {
		if (yych <= 'Z') goto yy463;
		if (yych <= '`') goto yy448;
		if (yych >= '{') goto yy448;
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy453;
		goto yy448;
	} else {
		if (yych <= 'Z') goto yy464;
		if (yych <= '`') goto yy448;
		if (yych >= '{') goto yy448;
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy453;
		goto yy448;
	} else {
		if (yych <= 'Z') goto yy465;
		if (yych <= '`') goto yy448;
		if (yych >= '{') goto yy448;
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy453;
	goto yy448;
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy448;
			goto yy453;
		} else {
			if (yych == '/') goto yy468;
			goto yy448;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy462;
			if (yych <= '^') goto yy448;
			goto yy468;
		} else {
			if (yych <= '`') goto yy448;
			if (yych >= '{') goto yy448;
		}
	}
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy448;
			goto yy453;
		} else {
			if (yych != '/') goto yy448;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy463;
			if (yych <= '^') goto yy448;
		} else {
			if (yych <= '`') goto yy448;
			if (yych <= 'z') goto yy472;
			goto yy448;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych >= '[') goto yy53;
	YYDEBUG(469, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy53;
	if (yych >= '{') goto yy53;
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(471, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy468;
		goto yy448;
	} else {
		if (yych <= '_') goto yy468;
		if (yych <= '`') goto yy448;
		if (yych <= 'z') goto yy470;
		goto yy448;
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy448;
			goto yy453;
		} else {
			if (yych == '/') goto yy468;
			goto yy448;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy464;
			if (yych <= '^') goto yy448;
			goto yy468;
		} else {
			if (yych <= '`') goto yy448;
			if (yych >= '{') goto yy448;
		}
	}
	YYDEBUG(473, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy448;
			goto yy453;
		} else {
			if (yych == '/') goto yy468;
			goto yy448;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy465;
			if (yych <= '^') goto yy448;
			goto yy468;
		} else {
			if (yych <= '`') goto yy448;
			if (yych >= '{') goto yy448;
		}
	}
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy453;
		if (yych <= '.') goto yy448;
		goto yy468;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy448;
			goto yy468;
		} else {
			if (yych <= '`') goto yy448;
			if (yych >= '{') goto yy448;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(476, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy468;
		goto yy53;
	} else {
		if (yych <= '_') goto yy468;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy475;
		goto yy53;
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy448;
	if (yych <= '9') goto yy479;
	if (yych <= ':') goto yy480;
	goto yy448;
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy448;
		if (yych >= '4') goto yy481;
	} else {
		if (yych <= '9') goto yy453;
		if (yych <= ':') goto yy480;
		goto yy448;
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy448;
	if (yych <= '5') goto yy481;
	if (yych <= '9') goto yy453;
	if (yych >= ';') goto yy448;
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy448;
	if (yych <= '5') goto yy481;
	if (yych <= '9') goto yy453;
	goto yy448;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy448;
	if (yych <= '9') goto yy453;
	goto yy448;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy488;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '3') goto yy488;
		if (yych <= '9') goto yy485;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy485;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy426;
	if (yych >= ':') goto yy426;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy426;
	if (yych >= ':') goto yy426;
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy426;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy486;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy426;
	if (yych >= ':') goto yy426;
yy490:
	YYDEBUG(490, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy491;
	if (yych <= '9') goto yy487;
yy491:
	YYDEBUG(491, *YYCURSOR);
#line 1125 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 8148 "parse_date.db.c"
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy490;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= '/') {
			if (yych != '.') goto yy441;
		} else {
			if (yych <= '1') goto yy495;
			if (yych <= '2') goto yy496;
			if (yych <= '9') goto yy497;
			goto yy446;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy437;
			goto yy441;
		} else {
			if (yych <= 'r') goto yy438;
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '2') {
		if (yych <= '/') goto yy441;
		if (yych <= '1') goto yy500;
		goto yy501;
	} else {
		if (yych <= '5') goto yy502;
		if (yych <= '9') goto yy503;
		goto yy441;
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy499;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '3') goto yy499;
		if (yych <= '9') goto yy498;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy426;
	} else {
		if (yych <= '9') goto yy498;
		if (yych <= ':') goto yy446;
		goto yy426;
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy491;
	if (yych <= '9') goto yy486;
	goto yy491;
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy446;
		goto yy491;
	} else {
		if (yych <= '9') goto yy486;
		if (yych <= ':') goto yy446;
		goto yy491;
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy504;
		goto yy426;
	} else {
		if (yych <= '9') goto yy509;
		if (yych <= ':') goto yy504;
		goto yy426;
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy504;
		goto yy426;
	} else {
		if (yych <= '3') goto yy509;
		if (yych <= '9') goto yy508;
		if (yych <= ':') goto yy504;
		goto yy426;
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy504;
		goto yy426;
	} else {
		if (yych <= '9') goto yy508;
		if (yych <= ':') goto yy504;
		goto yy426;
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy426;
	} else {
		if (yych <= '9') goto yy485;
		if (yych >= ';') goto yy426;
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy505;
	if (yych <= '6') goto yy506;
	if (yych <= '9') goto yy449;
	goto yy53;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy450;
		goto yy448;
	} else {
		if (yych <= '9') goto yy507;
		if (yych <= ':') goto yy450;
		goto yy448;
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy450;
		goto yy448;
	} else {
		if (yych <= '0') goto yy454;
		if (yych == ':') goto yy450;
		goto yy448;
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy455;
			if (yych <= 0x1F) goto yy448;
			goto yy455;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy448;
				goto yy458;
			} else {
				if (yych == '+') goto yy457;
				goto yy448;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy457;
			if (yych <= '.') goto yy450;
			if (yych <= '9') goto yy448;
			goto yy450;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy448;
				goto yy459;
			} else {
				if (yych <= '`') goto yy448;
				if (yych <= 'z') goto yy460;
				goto yy448;
			}
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy450;
		goto yy426;
	} else {
		if (yych <= '9') goto yy486;
		if (yych <= ':') goto yy450;
		goto yy426;
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy504;
		goto yy426;
	} else {
		if (yych <= '9') goto yy486;
		if (yych <= ':') goto yy504;
		goto yy426;
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= '/') {
			if (yych == '.') goto yy494;
			goto yy441;
		} else {
			if (yych <= '1') goto yy495;
			if (yych <= '2') goto yy496;
			if (yych <= '9') goto yy497;
			goto yy446;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy437;
			goto yy441;
		} else {
			if (yych <= 'r') goto yy438;
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy441;
			if (yych <= '0') goto yy493;
			goto yy514;
		} else {
			if (yych <= '2') goto yy521;
			if (yych <= '9') goto yy514;
			goto yy441;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy437;
			if (yych <= 'q') goto yy441;
			goto yy438;
		} else {
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy441;
			goto yy514;
		} else {
			if (yych <= '2') goto yy521;
			if (yych <= '9') goto yy514;
			goto yy441;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy437;
			if (yych <= 'q') goto yy441;
			goto yy438;
		} else {
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy441;
		} else {
			if (yych <= '2') goto yy434;
			if (yych <= '9') goto yy435;
			goto yy441;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy437;
			if (yych <= 'q') goto yy441;
			goto yy438;
		} else {
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '.') {
			if (yych <= ',') goto yy441;
			if (yych >= '.') goto yy494;
		} else {
			if (yych <= '/') goto yy441;
			if (yych <= '1') goto yy495;
			if (yych <= '2') goto yy496;
			goto yy497;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy446;
			if (yych == 'n') goto yy437;
			goto yy441;
		} else {
			if (yych <= 'r') goto yy438;
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(516, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy517;
	if (yych <= '9') goto yy518;
yy517:
	YYDEBUG(517, *YYCURSOR);
#line 1265 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 8537 "parse_date.db.c"
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy517;
	if (yych >= ':') goto yy517;
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy517;
	if (yych >= ':') goto yy517;
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy517;
yy521:
	YYDEBUG(521, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '.') {
			if (yych <= ',') goto yy441;
			if (yych <= '-') goto yy515;
			goto yy494;
		} else {
			if (yych <= '/') goto yy441;
			if (yych <= '1') goto yy495;
			if (yych <= '2') goto yy496;
			goto yy497;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy446;
			if (yych == 'n') goto yy437;
			goto yy441;
		} else {
			if (yych <= 'r') goto yy438;
			if (yych <= 's') goto yy436;
			if (yych <= 't') goto yy439;
			goto yy441;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy134;
			goto yy421;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'c') goto yy523;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'E') goto yy429;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'e') goto yy524;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy136;
			goto yy430;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'm') goto yy525;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy137;
			goto yy431;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'b') goto yy526;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'D') goto yy3;
			goto yy432;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy527;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy53;
			goto yy140;
		} else {
			if (yych == 'R') goto yy422;
			goto yy53;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy53;
			goto yy147;
		} else {
			if (yych <= 'r') goto yy528;
			if (yych <= 'z') goto yy147;
			goto yy53;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy423;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy423;
		if (yych <= 'z') goto yy147;
		goto yy423;
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy134;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 't') goto yy530;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'O') goto yy135;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'o') goto yy531;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy136;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'b') goto yy532;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy533;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy422;
		if (yych == 'r') goto yy422;
		goto yy3;
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy134;
			goto yy530;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy535;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'O') goto yy531;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'o') goto yy536;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy136;
			goto yy532;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'b') goto yy537;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy533;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy538;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'Q') goto yy3;
			goto yy422;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy528;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy555;
				goto yy134;
			} else {
				if (yych <= 'P') goto yy554;
				if (yych <= 'U') goto yy134;
				goto yy556;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych == 'c') goto yy555;
				goto yy134;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy554;
				goto yy134;
			} else {
				if (yych <= 'v') goto yy556;
				if (yych <= 'z') goto yy134;
				goto yy3;
			}
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy134;
			goto yy549;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 't') goto yy549;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy134;
			goto yy547;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'x') goto yy547;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'n') goto yy543;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy405;
			goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'C') goto yy135;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy405;
			goto yy135;
		} else {
			if (yych <= 'd') goto yy544;
			if (yych <= 'z') goto yy135;
			goto yy405;
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy545;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy137;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'y') goto yy546;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy132;
	goto yy405;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy548;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'h') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy405;
			goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'T') goto yy135;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy405;
			goto yy135;
		} else {
			if (yych <= 'u') goto yy550;
			if (yych <= 'z') goto yy135;
			goto yy405;
		}
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy136;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'r') goto yy551;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy137;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'd') goto yy552;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy553;
		if (yych != 'a') goto yy3;
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy411;
	if (yych == 'y') goto yy411;
	goto yy53;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych == 'T') goto yy563;
				goto yy135;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 't') goto yy563;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy135;
			goto yy560;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'o') goto yy560;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy135;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'e') goto yy557;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy136;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'n') goto yy558;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy137;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 't') goto yy559;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy163;
		if (yych == 'h') goto yy163;
		goto yy3;
	}
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy136;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'n') goto yy561;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy137;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'd') goto yy562;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy164;
				if (yych <= 0x1F) goto yy3;
				goto yy164;
			} else {
				if (yych == ')') goto yy132;
				if (yych <= 'C') goto yy3;
				goto yy164;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy164;
				if (yych <= 'G') goto yy3;
				goto yy164;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy164;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy164;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy164;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy164;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy164;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy164;
				if (yych <= 'r') goto yy3;
				goto yy164;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy164;
				} else {
					if (yych == 'y') goto yy164;
					goto yy3;
				}
			}
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'E') goto yy136;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy136;
			} else {
				if (yych <= 'e') goto yy564;
				if (yych <= 'z') goto yy136;
				goto yy3;
			}
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy137;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'm') goto yy565;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy566;
		if (yych != 'b') goto yy3;
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy567;
	if (yych != 'e') goto yy53;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy422;
	if (yych == 'r') goto yy422;
	goto yy53;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych == '/') goto yy140;
				goto yy3;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy555;
				goto yy134;
			} else {
				if (yych <= 'P') goto yy554;
				if (yych <= 'U') goto yy134;
				goto yy556;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy134;
				if (yych <= '^') goto yy3;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'b') goto yy139;
				goto yy584;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy583;
				goto yy139;
			} else {
				if (yych <= 'v') goto yy585;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy134;
			goto yy549;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy578;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy134;
			goto yy547;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'x') goto yy576;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
			goto yy543;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy572;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'C') goto yy135;
			goto yy544;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 'd') goto yy573;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy545;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy574;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy137;
			goto yy546;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy575;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy132;
		if (yych <= '.') goto yy405;
		goto yy140;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy405;
			goto yy140;
		} else {
			if (yych <= '`') goto yy405;
			if (yych <= 'z') goto yy147;
			goto yy405;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy548;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy577;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'T') goto yy135;
			goto yy550;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 'u') goto yy579;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy136;
			goto yy551;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy580;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy137;
			goto yy552;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy581;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy553;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy582;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy411;
	if (yych == 'y') goto yy419;
	goto yy148;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'T') goto yy563;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 't') goto yy592;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy135;
			goto yy560;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy589;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy135;
			goto yy557;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy586;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy136;
			goto yy558;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy587;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy137;
			goto yy559;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy588;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'G') goto yy3;
			goto yy163;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy245;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy136;
			goto yy561;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy590;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy137;
			goto yy562;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy591;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':	goto yy164;
	case ')':	goto yy132;
	case '/':
	case '_':	goto yy140;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy147;
	case 'd':	goto yy249;
	case 'f':	goto yy251;
	case 'h':	goto yy248;
	case 'm':	goto yy247;
	case 's':	goto yy246;
	case 't':	goto yy253;
	case 'w':	goto yy250;
	case 'y':	goto yy252;
	default:	goto yy3;
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy3;
				goto yy136;
			} else {
				if (yych <= 'E') goto yy564;
				if (yych <= 'Z') goto yy136;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy145;
			} else {
				if (yych <= 'e') goto yy593;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy137;
			goto yy565;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'm') goto yy594;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'A') goto yy3;
			goto yy566;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'b') goto yy595;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy567;
	if (yych != 'e') goto yy148;
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy53;
			goto yy140;
		} else {
			if (yych == 'R') goto yy422;
			goto yy53;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy53;
			goto yy147;
		} else {
			if (yych <= 'r') goto yy528;
			if (yych <= 'z') goto yy147;
			goto yy53;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy134;
			goto yy605;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'g') goto yy605;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy134;
			goto yy602;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'r') goto yy602;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy134;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'o') goto yy600;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy132;
	} else {
		if (yych <= 'Z') goto yy135;
		if (yych <= '`') goto yy601;
		if (yych <= 'z') goto yy135;
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
#line 1321 "parse_date.db.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 10496 "parse_date.db.c"
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'I') goto yy135;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'i') goto yy603;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy136;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'l') goto yy604;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych == ')') goto yy132;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy423;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'U') goto yy135;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'u') goto yy606;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy136;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 's') goto yy607;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy137;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 't') goto yy608;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy423;
		} else {
			if (yych == ' ') goto yy423;
			goto yy3;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		} else {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			goto yy3;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy134;
			goto yy605;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'g') goto yy616;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy134;
			goto yy602;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy613;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy134;
			goto yy600;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy612;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy601;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy601;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '^') goto yy601;
			goto yy140;
		} else {
			if (yych <= '`') goto yy601;
			if (yych <= 'z') goto yy144;
			goto yy601;
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'I') goto yy603;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'i') goto yy614;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy136;
			goto yy604;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'l') goto yy615;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'U') goto yy606;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'u') goto yy617;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy136;
			goto yy607;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 's') goto yy618;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy137;
			goto yy608;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy619;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych == ')') goto yy132;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy140;
			if (yych <= '9') goto yy423;
			goto yy3;
		} else {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy134;
			goto yy634;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'b') goto yy634;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'F') goto yy631;
			if (yych <= 'Q') goto yy134;
			goto yy630;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy134;
			goto yy631;
		} else {
			if (yych == 'r') goto yy630;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy134;
			goto yy627;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'u') goto yy627;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy134;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'i') goto yy624;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy405;
			goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'C') goto yy135;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy405;
			goto yy135;
		} else {
			if (yych <= 'd') goto yy625;
			if (yych <= 'z') goto yy135;
			goto yy405;
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy626;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy137;
			goto yy546;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'y') goto yy546;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy135;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'r') goto yy628;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy136;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 't') goto yy629;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy137;
			goto yy562;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'h') goto yy562;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy135;
			goto yy633;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 's') goto yy633;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy632;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'h') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 't') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'R') goto yy135;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'r') goto yy635;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy136;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'u') goto yy636;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy637;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy638;
		if (yych != 'r') goto yy3;
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy422;
	if (yych == 'y') goto yy422;
	goto yy53;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy134;
			goto yy634;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'b') goto yy653;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy3;
				goto yy134;
			} else {
				if (yych <= 'F') goto yy631;
				if (yych <= 'Q') goto yy134;
				goto yy630;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy139;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy650;
				goto yy139;
			} else {
				if (yych <= 'r') goto yy649;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy134;
			goto yy627;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'u') goto yy646;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy134;
			goto yy624;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'i') goto yy643;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'C') goto yy135;
			goto yy625;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 'd') goto yy644;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy626;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy645;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy137;
			goto yy546;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy575;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy135;
			goto yy628;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy647;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy136;
			goto yy629;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy648;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy137;
			goto yy562;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy591;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy135;
			goto yy633;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 's') goto yy652;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy632;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy651;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'R') goto yy635;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'r') goto yy654;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy136;
			goto yy636;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'u') goto yy655;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy637;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy656;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'Q') goto yy3;
			goto yy638;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy657;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy53;
			goto yy140;
		} else {
			if (yych == 'Y') goto yy422;
			goto yy53;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy53;
			goto yy147;
		} else {
			if (yych <= 'y') goto yy528;
			if (yych <= 'z') goto yy147;
			goto yy53;
		}
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'L') goto yy665;
			if (yych <= 'M') goto yy134;
			goto yy664;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy134;
			goto yy665;
		} else {
			if (yych == 'n') goto yy664;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'n') goto yy660;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'U') goto yy135;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'u') goto yy661;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy662;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'r') goto yy663;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy422;
		if (yych == 'y') goto yy422;
		goto yy3;
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych == 'E') goto yy666;
				goto yy135;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'e') goto yy666;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'Y') goto yy135;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'y') goto yy666;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych == ')') goto yy132;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy423;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy3;
				goto yy134;
			} else {
				if (yych <= 'L') goto yy665;
				if (yych <= 'M') goto yy134;
				goto yy664;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy139;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy674;
				goto yy139;
			} else {
				if (yych <= 'n') goto yy673;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
			goto yy660;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy669;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'U') goto yy661;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'u') goto yy670;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy662;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy671;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy663;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy672;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'X') goto yy3;
			goto yy422;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy528;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'E') goto yy666;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'e') goto yy675;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'Y') goto yy666;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'y') goto yy675;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy136;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy134;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy134;
				goto yy3;
			}
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych == ')') goto yy132;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy423;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy134;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy134;
				goto yy3;
			}
		}
	}
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy666;
				goto yy135;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych == ')') goto yy132;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy423;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy423;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy677;
				goto yy134;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy134;
				goto yy3;
			}
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy684;
	if (yych <= '0') goto yy932;
	if (yych <= '1') goto yy933;
	if (yych <= '9') goto yy934;
	goto yy684;
yy683:
	YYDEBUG(683, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy684:
	YYDEBUG(684, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy683;
	case '-':
	case '.':	goto yy783;
	case 'A':
	case 'a':	goto yy702;
	case 'D':
	case 'd':	goto yy688;
	case 'F':
	case 'f':	goto yy689;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy697;
	case 'J':
	case 'j':	goto yy701;
	case 'M':
	case 'm':	goto yy687;
	case 'N':
	case 'n':	goto yy704;
	case 'O':
	case 'o':	goto yy703;
	case 'P':
	case 'p':	goto yy706;
	case 'S':
	case 's':	goto yy685;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy699;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy700;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1228;
			if (yych <= 'T') goto yy53;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy1228;
			if (yych == 'u') goto yy118;
			goto yy53;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1228;
			if (yych == 'U') goto yy118;
			goto yy53;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy119;
			if (yych <= 'd') goto yy53;
			goto yy1228;
		} else {
			if (yych <= 's') goto yy53;
			if (yych <= 't') goto yy929;
			if (yych <= 'u') goto yy118;
			goto yy53;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy798;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy110;
			if (yych <= 'N') goto yy53;
			goto yy109;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy798;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy110;
			if (yych == 'o') goto yy109;
			goto yy53;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy106;
		if (yych <= 'D') goto yy53;
		goto yy785;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy106;
		} else {
			if (yych == 'e') goto yy785;
			goto yy53;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy801;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy83;
			if (yych <= 'Q') goto yy53;
			goto yy82;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy801;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy83;
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy66;
		if (yych <= 'T') goto yy53;
		goto yy67;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy1227;
		} else {
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy936;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy935;
	goto yy57;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy736;
		goto yy53;
	} else {
		if (yych <= 'd') goto yy929;
		if (yych == 'o') goto yy736;
		goto yy53;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy929;
	goto yy53;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy869;
	case '3':	goto yy871;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy872;
	case 'A':
	case 'a':	goto yy876;
	case 'D':
	case 'd':	goto yy880;
	case 'F':
	case 'f':	goto yy874;
	case 'J':
	case 'j':	goto yy873;
	case 'M':
	case 'm':	goto yy875;
	case 'N':
	case 'n':	goto yy879;
	case 'O':
	case 'o':	goto yy878;
	case 'S':
	case 's':	goto yy877;
	default:	goto yy53;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy819;
	case '1':	goto yy820;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy821;
	case 'A':
	case 'a':	goto yy825;
	case 'D':
	case 'd':	goto yy829;
	case 'F':
	case 'f':	goto yy823;
	case 'J':
	case 'j':	goto yy822;
	case 'M':
	case 'm':	goto yy824;
	case 'N':
	case 'n':	goto yy828;
	case 'O':
	case 'o':	goto yy827;
	case 'S':
	case 's':	goto yy826;
	default:	goto yy784;
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy784;
		if (yych <= '0') goto yy774;
		goto yy775;
	} else {
		if (yych <= '5') goto yy776;
		if (yych <= '9') goto yy777;
		goto yy784;
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '.') goto yy738;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy740;
			if (yych == 'I') goto yy773;
		} else {
			if (yych == 'W') goto yy698;
			if (yych <= 'X') goto yy746;
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
#line 1164 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 12956 "parse_date.db.c"
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy738;
			if (yych <= '/') goto yy698;
			goto yy740;
		} else {
			if (yych == 'I') goto yy771;
			goto yy698;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy738;
			if (yych <= '/') goto yy698;
			goto yy740;
		} else {
			if (yych == 'I') goto yy770;
			goto yy698;
		}
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy763;
		if (yych <= 'T') goto yy53;
		goto yy762;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy763;
		} else {
			if (yych == 'u') goto yy762;
			goto yy53;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy707;
			goto yy53;
		} else {
			if (yych <= 'M') goto yy708;
			if (yych == 'P') goto yy756;
			goto yy53;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy755;
			if (yych == 'm') goto yy708;
			goto yy53;
		} else {
			if (yych <= 'p') goto yy756;
			if (yych == 'u') goto yy755;
			goto yy53;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy750;
	if (yych == 'c') goto yy750;
	goto yy53;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy736;
	if (yych == 'o') goto yy736;
	goto yy53;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy712;
	if (yych <= '9') goto yy714;
	goto yy53;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy708;
		if (yych == 'm') goto yy708;
		goto yy53;
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy708;
	if (yych != 'm') goto yy53;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy710;
		if (yych == '\t') goto yy710;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy710;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy710;
		if (yych <= 0x08) goto yy53;
	} else {
		if (yych != ' ') goto yy53;
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(711, *YYCURSOR);
#line 949 "parse_date.db.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 13113 "parse_date.db.c"
yy712:
	YYDEBUG(712, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy715;
	} else {
		if (yych <= '9') goto yy729;
		if (yych <= ':') goto yy715;
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
#line 966 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 13151 "parse_date.db.c"
yy714:
	YYDEBUG(714, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy715;
	if (yych != ':') goto yy713;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy716;
	if (yych <= '6') goto yy717;
	if (yych <= '9') goto yy718;
	goto yy53;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych <= '/') goto yy713;
	if (yych <= '9') goto yy722;
	goto yy713;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych == '0') goto yy722;
	goto yy713;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy713;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy720:
	YYDEBUG(720, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(721, *YYCURSOR);
	if (yych <= '/') goto yy713;
	if (yych <= '9') goto yy720;
	goto yy713;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy713;
		} else {
			if (yych <= ' ') goto yy723;
			if (yych == '.') goto yy719;
			goto yy713;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy725;
			if (yych == 'P') goto yy725;
			goto yy713;
		} else {
			if (yych <= 'a') goto yy725;
			if (yych == 'p') goto yy725;
			goto yy713;
		}
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(724, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy723;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy723;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy725;
			if (yych != 'p') goto yy53;
		}
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy727;
		if (yych == 'm') goto yy727;
		goto yy53;
	}
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy727;
	if (yych != 'm') goto yy53;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy710;
		if (yych == '\t') goto yy710;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy710;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy710;
		if (yych <= 0x08) goto yy53;
		goto yy710;
	} else {
		if (yych == ' ') goto yy710;
		goto yy53;
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy730;
			if (yych <= 0x1F) goto yy713;
		} else {
			if (yych == '.') goto yy715;
			if (yych <= '9') goto yy713;
			goto yy715;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy732;
			if (yych <= 'O') goto yy713;
			goto yy732;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy713;
				goto yy732;
			} else {
				if (yych == 'p') goto yy732;
				goto yy713;
			}
		}
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(731, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy730;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy730;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy732;
			if (yych != 'p') goto yy53;
		}
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy734;
		if (yych == 'm') goto yy734;
		goto yy53;
	}
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy734;
	if (yych != 'm') goto yy53;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy710;
		if (yych == '\t') goto yy710;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy710;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy710;
		if (yych <= 0x08) goto yy53;
		goto yy710;
	} else {
		if (yych == ' ') goto yy710;
		goto yy53;
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy737;
	if (yych != 'v') goto yy53;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy742;
			if (yych == 'e') goto yy742;
			goto yy698;
		}
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy739:
	YYDEBUG(739, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy738;
		if (yych <= 0x1F) goto yy53;
		goto yy738;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy53;
			goto yy738;
		} else {
			if (yych <= '/') goto yy53;
			if (yych >= ':') goto yy53;
		}
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy741;
	if (yych <= '9') goto yy747;
yy741:
	YYDEBUG(741, *YYCURSOR);
#line 1098 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 13432 "parse_date.db.c"
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy743;
	if (yych != 'm') goto yy53;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy744;
	if (yych != 'b') goto yy53;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy745;
	if (yych != 'e') goto yy53;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy746;
	if (yych != 'r') goto yy53;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy738;
		if (yych <= 0x1F) goto yy698;
		goto yy738;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy698;
			goto yy738;
		} else {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy741;
	if (yych >= ':') goto yy741;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy741;
	if (yych >= ':') goto yy741;
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy741;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy751;
	if (yych != 't') goto yy53;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'O') goto yy752;
			if (yych != 'o') goto yy698;
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy753;
	if (yych != 'b') goto yy53;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy754;
	if (yych != 'e') goto yy53;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy746;
	if (yych == 'r') goto yy746;
	goto yy53;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy759;
	if (yych == 'g') goto yy759;
	goto yy53;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy757;
	if (yych != 'r') goto yy53;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'I') goto yy758;
			if (yych != 'i') goto yy698;
		}
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy746;
	if (yych == 'l') goto yy746;
	goto yy53;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'U') goto yy760;
			if (yych != 'u') goto yy698;
		}
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy761;
	if (yych != 's') goto yy53;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy746;
	if (yych == 't') goto yy746;
	goto yy53;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy769;
		if (yych <= 'M') goto yy53;
		goto yy768;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy769;
		} else {
			if (yych == 'n') goto yy768;
			goto yy53;
		}
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy764;
	if (yych != 'n') goto yy53;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'U') goto yy765;
			if (yych != 'u') goto yy698;
		}
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy766;
	if (yych != 'a') goto yy53;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy767;
	if (yych != 'r') goto yy53;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy746;
	if (yych == 'y') goto yy746;
	goto yy53;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy746;
			if (yych == 'e') goto yy746;
			goto yy698;
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'Y') goto yy746;
			if (yych == 'y') goto yy746;
			goto yy698;
		}
	}
yy770:
	YYDEBUG(770, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy738;
			if (yych <= '/') goto yy698;
			goto yy740;
		} else {
			if (yych == 'I') goto yy746;
			goto yy698;
		}
	}
yy771:
	YYDEBUG(771, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy738;
			if (yych <= '/') goto yy698;
			goto yy740;
		} else {
			if (yych != 'I') goto yy698;
		}
	}
	YYDEBUG(772, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy738;
			if (yych <= '/') goto yy698;
			goto yy740;
		} else {
			if (yych == 'I') goto yy746;
			goto yy698;
		}
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy738;
			if (yych <= '/') goto yy698;
			goto yy740;
		} else {
			if (yych == 'I') goto yy746;
			goto yy698;
		}
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		goto yy808;
	} else {
		if (yych <= '/') goto yy713;
		if (yych <= '9') goto yy818;
		if (yych <= ':') goto yy715;
		goto yy713;
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		if (yych <= '.') goto yy808;
		goto yy713;
	} else {
		if (yych <= '2') goto yy818;
		if (yych <= '9') goto yy729;
		if (yych <= ':') goto yy715;
		goto yy713;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		goto yy808;
	} else {
		if (yych <= '/') goto yy713;
		if (yych <= '9') goto yy729;
		if (yych <= ':') goto yy715;
		goto yy713;
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		goto yy808;
	} else {
		if (yych == ':') goto yy715;
		goto yy713;
	}
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy801;
	if (yych == 'e') goto yy801;
	goto yy53;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy798;
	if (yych == 'a') goto yy798;
	goto yy53;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy756;
		if (yych <= 'T') goto yy53;
		goto yy755;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy756;
		} else {
			if (yych == 'u') goto yy755;
			goto yy53;
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy791;
	if (yych == 'e') goto yy791;
	goto yy53;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy785;
	if (yych == 'e') goto yy785;
	goto yy53;
yy783:
	YYDEBUG(783, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy784:
	YYDEBUG(784, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy783;
	case 'A':
	case 'a':	goto yy780;
	case 'D':
	case 'd':	goto yy782;
	case 'F':
	case 'f':	goto yy778;
	case 'I':	goto yy697;
	case 'J':
	case 'j':	goto yy701;
	case 'M':
	case 'm':	goto yy779;
	case 'N':
	case 'n':	goto yy704;
	case 'O':
	case 'o':	goto yy703;
	case 'S':
	case 's':	goto yy781;
	case 'V':	goto yy699;
	case 'X':	goto yy700;
	default:	goto yy53;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy786;
	if (yych != 'c') goto yy53;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy787;
			if (yych != 'e') goto yy698;
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy788;
	if (yych != 'm') goto yy53;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy789;
	if (yych != 'b') goto yy53;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy790;
	if (yych != 'e') goto yy53;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy746;
	if (yych == 'r') goto yy746;
	goto yy53;
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy792;
	if (yych != 'p') goto yy53;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'T') goto yy793;
			if (yych != 't') goto yy698;
		}
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy794;
			if (yych != 'e') goto yy698;
		}
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy795;
	if (yych != 'm') goto yy53;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy796;
	if (yych != 'b') goto yy53;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy797;
	if (yych != 'e') goto yy53;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy746;
	if (yych == 'r') goto yy746;
	goto yy53;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy799;
		if (yych <= 'X') goto yy53;
		goto yy746;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy746;
			goto yy53;
		}
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'C') goto yy800;
			if (yych != 'c') goto yy698;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy746;
	if (yych == 'h') goto yy746;
	goto yy53;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy802;
	if (yych != 'b') goto yy53;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			goto yy738;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'R') goto yy803;
			if (yych != 'r') goto yy698;
		}
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy804;
	if (yych != 'u') goto yy53;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy805;
	if (yych != 'a') goto yy53;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy806;
	if (yych != 'r') goto yy53;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy746;
	if (yych == 'y') goto yy746;
	goto yy53;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy817;
	goto yy53;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy809;
	if (yych <= '6') goto yy810;
	if (yych <= '9') goto yy811;
	goto yy53;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych <= '/') goto yy713;
	if (yych <= '9') goto yy816;
	goto yy713;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy719;
		goto yy713;
	} else {
		if (yych <= '0') goto yy816;
		if (yych <= '9') goto yy812;
		goto yy713;
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych <= '/') goto yy713;
	if (yych >= ':') goto yy713;
yy812:
	YYDEBUG(812, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy813;
	if (yych <= '9') goto yy814;
yy813:
	YYDEBUG(813, *YYCURSOR);
#line 1112 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 14198 "parse_date.db.c"
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy813;
	if (yych >= ':') goto yy813;
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy813;
yy816:
	YYDEBUG(816, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy723;
			if (yych <= 0x1F) goto yy713;
			goto yy723;
		} else {
			if (yych == '.') goto yy719;
			if (yych <= '/') goto yy713;
			goto yy814;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy725;
			if (yych <= 'O') goto yy713;
			goto yy725;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy713;
				goto yy725;
			} else {
				if (yych == 'p') goto yy725;
				goto yy713;
			}
		}
	}
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy813;
	if (yych <= '9') goto yy812;
	goto yy813;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy730;
			if (yych <= 0x1F) goto yy713;
			goto yy730;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy713;
				goto yy807;
			} else {
				if (yych <= '.') goto yy808;
				if (yych <= '9') goto yy713;
				goto yy715;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy732;
			if (yych <= 'O') goto yy713;
			goto yy732;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy713;
				goto yy732;
			} else {
				if (yych == 'p') goto yy732;
				goto yy713;
			}
		}
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy858;
		goto yy807;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy821;
		goto yy53;
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy858;
		goto yy807;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy858;
	if (yych <= '.') goto yy807;
	goto yy53;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy854;
		if (yych <= 'T') goto yy53;
		goto yy853;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy854;
		} else {
			if (yych == 'u') goto yy853;
			goto yy53;
		}
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy851;
	if (yych == 'e') goto yy851;
	goto yy53;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy848;
	if (yych == 'a') goto yy848;
	goto yy53;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy845;
		if (yych <= 'T') goto yy53;
		goto yy844;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy845;
		} else {
			if (yych == 'u') goto yy844;
			goto yy53;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy841;
	if (yych == 'e') goto yy841;
	goto yy53;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy839;
	if (yych == 'c') goto yy839;
	goto yy53;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy837;
	if (yych == 'o') goto yy837;
	goto yy53;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy830;
	if (yych != 'e') goto yy53;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy831;
	if (yych != 'c') goto yy53;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych >= '.') goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy787;
			if (yych == 'e') goto yy787;
			goto yy698;
		}
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy739;
	if (yych <= '0') goto yy833;
	if (yych <= '2') goto yy834;
	if (yych <= '3') goto yy835;
	goto yy739;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy741;
	if (yych <= '0') goto yy747;
	if (yych <= '9') goto yy836;
	goto yy741;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy741;
	if (yych <= '9') goto yy836;
	goto yy741;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy741;
	if (yych <= '1') goto yy836;
	if (yych <= '9') goto yy747;
	goto yy741;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy741;
	if (yych <= '9') goto yy748;
	goto yy741;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy838;
	if (yych != 'v') goto yy53;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy742;
			if (yych == 'e') goto yy742;
			goto yy698;
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy840;
	if (yych != 't') goto yy53;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'O') goto yy752;
			if (yych == 'o') goto yy752;
			goto yy698;
		}
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy842;
	if (yych != 'p') goto yy53;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'T') goto yy843;
			if (yych != 't') goto yy698;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy794;
			if (yych == 'e') goto yy794;
			goto yy698;
		}
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy847;
	if (yych == 'g') goto yy847;
	goto yy53;
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy846;
	if (yych != 'r') goto yy53;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'I') goto yy758;
			if (yych == 'i') goto yy758;
			goto yy698;
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'U') goto yy760;
			if (yych == 'u') goto yy760;
			goto yy698;
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy849;
		if (yych <= 'X') goto yy53;
		goto yy850;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy850;
			goto yy53;
		}
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'C') goto yy800;
			if (yych == 'c') goto yy800;
			goto yy698;
		}
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy698;
			goto yy738;
		} else {
			if (yych == ' ') goto yy738;
			goto yy698;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy832;
			goto yy738;
		} else {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		}
	}
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy852;
	if (yych != 'b') goto yy53;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'R') goto yy803;
			if (yych == 'r') goto yy803;
			goto yy698;
		}
	}
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy857;
		if (yych <= 'M') goto yy53;
		goto yy856;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy857;
		} else {
			if (yych == 'n') goto yy856;
			goto yy53;
		}
	}
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy855;
	if (yych != 'n') goto yy53;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'U') goto yy765;
			if (yych == 'u') goto yy765;
			goto yy698;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'E') goto yy746;
			if (yych == 'e') goto yy746;
			goto yy698;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy738;
			goto yy698;
		} else {
			if (yych <= ' ') goto yy738;
			if (yych <= ',') goto yy698;
			if (yych <= '-') goto yy832;
			goto yy738;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy698;
			if (yych <= '9') goto yy740;
			goto yy698;
		} else {
			if (yych <= 'Y') goto yy746;
			if (yych == 'y') goto yy746;
			goto yy698;
		}
	}
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy859;
	if (yych <= '3') goto yy861;
	if (yych <= '9') goto yy862;
	goto yy53;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy860;
		if (yych <= '9') goto yy868;
		if (yych >= 'n') goto yy864;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy865;
		} else {
			if (yych <= 's') goto yy863;
			if (yych <= 't') goto yy866;
		}
	}
yy860:
	YYDEBUG(860, *YYCURSOR);
#line 1085 "parse_date.db.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14837 "parse_date.db.c"
yy861:
	YYDEBUG(861, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy860;
			goto yy868;
		} else {
			if (yych <= '9') goto yy812;
			if (yych <= 'm') goto yy860;
			goto yy864;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy860;
			goto yy865;
		} else {
			if (yych <= 's') goto yy863;
			if (yych <= 't') goto yy866;
			goto yy860;
		}
	}
yy862:
	YYDEBUG(862, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy860;
		if (yych <= '9') goto yy812;
		if (yych <= 'm') goto yy860;
		goto yy864;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy860;
			goto yy865;
		} else {
			if (yych <= 's') goto yy863;
			if (yych <= 't') goto yy866;
			goto yy860;
		}
	}
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy867;
	goto yy53;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy867;
	goto yy53;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy867;
	goto yy53;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy53;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy860;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy860;
		if (yych <= '9') goto yy814;
		if (yych <= 'm') goto yy860;
		goto yy864;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy860;
			goto yy865;
		} else {
			if (yych <= 's') goto yy863;
			if (yych <= 't') goto yy866;
			goto yy860;
		}
	}
yy869:
	YYDEBUG(869, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy923;
		} else {
			if (yych <= '9') goto yy872;
			if (yych >= 'n') goto yy920;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy921;
		} else {
			if (yych <= 's') goto yy919;
			if (yych <= 't') goto yy922;
		}
	}
yy870:
	YYDEBUG(870, *YYCURSOR);
#line 1058 "parse_date.db.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 14957 "parse_date.db.c"
yy871:
	YYDEBUG(871, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy870;
			goto yy923;
		} else {
			if (yych <= '1') goto yy872;
			if (yych <= 'm') goto yy870;
			goto yy920;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy870;
			goto yy921;
		} else {
			if (yych <= 's') goto yy919;
			if (yych <= 't') goto yy922;
			goto yy870;
		}
	}
yy872:
	YYDEBUG(872, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy923;
		if (yych <= 'm') goto yy870;
		goto yy920;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy870;
			goto yy921;
		} else {
			if (yych <= 's') goto yy919;
			if (yych <= 't') goto yy922;
			goto yy870;
		}
	}
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy918;
		if (yych <= 'T') goto yy53;
		goto yy917;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy918;
		} else {
			if (yych == 'u') goto yy917;
			goto yy53;
		}
	}
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy916;
	if (yych == 'e') goto yy916;
	goto yy53;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy915;
	if (yych == 'a') goto yy915;
	goto yy53;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy914;
		if (yych <= 'T') goto yy53;
		goto yy913;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy914;
		} else {
			if (yych == 'u') goto yy913;
			goto yy53;
		}
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy911;
	if (yych == 'e') goto yy911;
	goto yy53;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy910;
	if (yych == 'c') goto yy910;
	goto yy53;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy909;
	if (yych == 'o') goto yy909;
	goto yy53;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy881;
	if (yych != 'e') goto yy53;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy882;
	if (yych != 'c') goto yy53;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy889;
	if (yych <= '2') goto yy890;
	goto yy53;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy891;
	goto yy53;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy896;
	if (yych <= '6') goto yy897;
	goto yy53;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy898;
	goto yy53;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy899;
	if (yych != ' ') goto yy53;
yy899:
	YYDEBUG(899, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(900, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy899;
		if (yych <= 0x1F) goto yy53;
		goto yy899;
	} else {
		if (yych <= '+') {
			if (yych <= '*') goto yy53;
		} else {
			if (yych != '-') goto yy53;
		}
	}
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy902;
	if (yych <= '2') goto yy904;
	if (yych <= '9') goto yy905;
	goto yy53;
yy902:
	YYDEBUG(902, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy903;
	if (yych <= '9') goto yy905;
	if (yych <= ':') goto yy906;
yy903:
	YYDEBUG(903, *YYCURSOR);
#line 1291 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 15200 "parse_date.db.c"
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy903;
		if (yych >= '4') goto yy907;
	} else {
		if (yych <= '9') goto yy908;
		if (yych <= ':') goto yy906;
		goto yy903;
	}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy903;
	if (yych <= '5') goto yy907;
	if (yych <= '9') goto yy908;
	if (yych >= ';') goto yy903;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy903;
	if (yych <= '5') goto yy907;
	if (yych <= '9') goto yy908;
	goto yy903;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy903;
	if (yych >= ':') goto yy903;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy903;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy882;
	if (yych == 'v') goto yy882;
	goto yy53;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy882;
	if (yych == 't') goto yy882;
	goto yy53;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy912;
	if (yych != 'p') goto yy53;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy883;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy882;
		if (yych == 't') goto yy882;
		goto yy53;
	}
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy882;
	if (yych == 'g') goto yy882;
	goto yy53;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy882;
	if (yych == 'r') goto yy882;
	goto yy53;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy882;
		if (yych <= 'X') goto yy53;
		goto yy882;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy882;
		} else {
			if (yych == 'y') goto yy882;
			goto yy53;
		}
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy882;
	if (yych == 'b') goto yy882;
	goto yy53;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy882;
		if (yych <= 'M') goto yy53;
		goto yy882;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy882;
		} else {
			if (yych == 'n') goto yy882;
			goto yy53;
		}
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy882;
	if (yych == 'n') goto yy882;
	goto yy53;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy928;
	goto yy53;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy928;
	goto yy53;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy928;
	goto yy53;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy928;
	goto yy53;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy870;
	if (yych >= ':') goto yy870;
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy870;
	if (yych >= ':') goto yy870;
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy870;
	if (yych >= ':') goto yy870;
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy870;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy923;
	goto yy870;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy931;
		goto yy784;
	} else {
		if (yych <= '.') goto yy931;
		if (yych >= '0') goto yy784;
	}
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy876;
	case 'D':
	case 'd':	goto yy880;
	case 'F':
	case 'f':	goto yy874;
	case 'J':
	case 'j':	goto yy873;
	case 'M':
	case 'm':	goto yy875;
	case 'N':
	case 'n':	goto yy879;
	case 'O':
	case 'o':	goto yy878;
	case 'S':
	case 's':	goto yy877;
	default:	goto yy53;
	}
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy784;
	if (yych <= '0') goto yy932;
	if (yych <= '1') goto yy933;
	if (yych <= '9') goto yy934;
	goto yy784;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy807;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy934;
	goto yy53;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy807;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy807;
	goto yy53;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy936;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy970;
	goto yy57;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy945;
	case '1':	goto yy946;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy947;
	case 'A':
	case 'a':	goto yy940;
	case 'D':
	case 'd':	goto yy944;
	case 'F':
	case 'f':	goto yy938;
	case 'J':
	case 'j':	goto yy937;
	case 'M':
	case 'm':	goto yy939;
	case 'N':
	case 'n':	goto yy943;
	case 'O':
	case 'o':	goto yy942;
	case 'S':
	case 's':	goto yy941;
	default:	goto yy53;
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy969;
		if (yych <= 'T') goto yy53;
		goto yy968;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy969;
		} else {
			if (yych == 'u') goto yy968;
			goto yy53;
		}
	}
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy967;
	if (yych == 'e') goto yy967;
	goto yy53;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy966;
	if (yych == 'a') goto yy966;
	goto yy53;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy965;
		if (yych <= 'T') goto yy53;
		goto yy964;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy965;
		} else {
			if (yych == 'u') goto yy964;
			goto yy53;
		}
	}
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy962;
	if (yych == 'e') goto yy962;
	goto yy53;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy961;
	if (yych == 'c') goto yy961;
	goto yy53;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy960;
	if (yych == 'o') goto yy960;
	goto yy53;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy952;
	if (yych == 'e') goto yy952;
	goto yy53;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy948;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy947;
	goto yy53;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy948;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy949;
	if (yych <= '3') goto yy950;
	if (yych <= '9') goto yy951;
	goto yy53;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy860;
		if (yych <= '9') goto yy951;
		if (yych <= 'm') goto yy860;
		goto yy864;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy860;
			goto yy865;
		} else {
			if (yych <= 's') goto yy863;
			if (yych <= 't') goto yy866;
			goto yy860;
		}
	}
yy950:
	YYDEBUG(950, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy860;
		if (yych <= '1') goto yy951;
		if (yych <= 'm') goto yy860;
		goto yy864;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy860;
			goto yy865;
		} else {
			if (yych <= 's') goto yy863;
			if (yych <= 't') goto yy866;
			goto yy860;
		}
	}
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy864;
		goto yy860;
	} else {
		if (yych <= 'r') goto yy865;
		if (yych <= 's') goto yy863;
		if (yych <= 't') goto yy866;
		goto yy860;
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy953;
	if (yych != 'c') goto yy53;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy955;
	if (yych <= '2') goto yy956;
	if (yych <= '3') goto yy957;
	goto yy53;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy958;
	goto yy53;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy958;
	goto yy53;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy958:
	YYDEBUG(958, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(959, *YYCURSOR);
#line 1278 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 15659 "parse_date.db.c"
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy953;
	if (yych == 'v') goto yy953;
	goto yy53;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy953;
	if (yych == 't') goto yy953;
	goto yy53;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy963;
	if (yych != 'p') goto yy53;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy954;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy953;
		if (yych == 't') goto yy953;
		goto yy53;
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy953;
	if (yych == 'g') goto yy953;
	goto yy53;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy953;
	if (yych == 'r') goto yy953;
	goto yy53;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy953;
		if (yych <= 'X') goto yy53;
		goto yy953;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy953;
		} else {
			if (yych == 'y') goto yy953;
			goto yy53;
		}
	}
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy953;
	if (yych == 'b') goto yy953;
	goto yy53;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy953;
		if (yych <= 'M') goto yy53;
		goto yy953;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy953;
		} else {
			if (yych == 'n') goto yy953;
			goto yy53;
		}
	}
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy953;
	if (yych == 'n') goto yy953;
	goto yy53;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy975;
	case '-':	goto yy972;
	case '.':	goto yy976;
	case '/':	goto yy973;
	case '0':	goto yy989;
	case '1':	goto yy990;
	case '2':	goto yy992;
	case '3':	goto yy993;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy991;
	case 'W':	goto yy994;
	default:	goto yy971;
	}
yy971:
	YYDEBUG(971, *YYCURSOR);
#line 1312 "parse_date.db.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 15804 "parse_date.db.c"
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1156;
	case '1':	goto yy1157;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1158;
	case 'A':
	case 'a':	goto yy1151;
	case 'D':
	case 'd':	goto yy1155;
	case 'F':
	case 'f':	goto yy1149;
	case 'J':
	case 'j':	goto yy1148;
	case 'M':
	case 'm':	goto yy1150;
	case 'N':
	case 'n':	goto yy1154;
	case 'O':
	case 'o':	goto yy1153;
	case 'S':
	case 's':	goto yy1152;
	default:	goto yy1121;
	}
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1129;
	if (yych <= '1') goto yy1130;
	if (yych <= '9') goto yy1131;
	goto yy53;
yy974:
	YYDEBUG(974, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy975:
	YYDEBUG(975, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy974;
	case '-':
	case '.':	goto yy1120;
	case 'A':
	case 'a':	goto yy984;
	case 'D':
	case 'd':	goto yy988;
	case 'F':
	case 'f':	goto yy982;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy977;
	case 'J':
	case 'j':	goto yy981;
	case 'M':
	case 'm':	goto yy983;
	case 'N':
	case 'n':	goto yy987;
	case 'O':
	case 'o':	goto yy986;
	case 'S':
	case 's':	goto yy985;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy979;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy980;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1121;
	if (yych <= '0') goto yy1113;
	if (yych <= '2') goto yy1114;
	if (yych <= '3') goto yy1115;
	goto yy1121;
yy977:
	YYDEBUG(977, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy1112;
	} else {
		if (yych == 'W') goto yy978;
		if (yych <= 'X') goto yy1066;
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
#line 1138 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 15917 "parse_date.db.c"
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1110;
	goto yy978;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1109;
	goto yy978;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1102;
		if (yych <= 'T') goto yy53;
		goto yy1101;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy1102;
		} else {
			if (yych == 'u') goto yy1101;
			goto yy53;
		}
	}
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy1095;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy83;
			if (yych <= 'Q') goto yy53;
			goto yy82;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy1095;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy83;
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy1092;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy110;
			if (yych <= 'N') goto yy53;
			goto yy109;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy1092;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy110;
			if (yych == 'o') goto yy109;
			goto yy53;
		}
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1086;
		if (yych <= 'T') goto yy53;
		goto yy1085;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy1086;
		} else {
			if (yych == 'u') goto yy1085;
			goto yy53;
		}
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1078;
			if (yych <= 'T') goto yy53;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy1078;
			if (yych == 'u') goto yy118;
			goto yy53;
		}
	}
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1073;
	if (yych == 'c') goto yy1073;
	goto yy53;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1067;
	if (yych == 'o') goto yy1067;
	goto yy53;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy106;
		if (yych <= 'D') goto yy53;
		goto yy1060;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy106;
		} else {
			if (yych == 'e') goto yy1060;
			goto yy53;
		}
	}
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1058;
	if (yych <= '9') goto yy1059;
	goto yy57;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy1027;
	if (yych <= '9') goto yy1006;
	goto yy57;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1007;
	if (yych <= '1') goto yy1008;
	goto yy53;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1006;
	goto yy57;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1002;
	if (yych <= '6') goto yy1003;
	if (yych <= '9') goto yy51;
	goto yy57;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy995;
		if (yych <= '4') goto yy996;
		goto yy997;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy53;
			goto yy98;
		} else {
			if (yych == 'e') goto yy98;
			goto yy53;
		}
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy998;
	goto yy53;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy998;
	goto yy53;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy998:
	YYDEBUG(998, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy999;
	if (yych <= '7') goto yy1000;
yy999:
	YYDEBUG(999, *YYCURSOR);
#line 1246 "parse_date.db.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 16148 "parse_date.db.c"
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1001, *YYCURSOR);
#line 1227 "parse_date.db.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 16171 "parse_date.db.c"
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1004;
	goto yy57;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '6') goto yy1004;
	if (yych <= '9') goto yy51;
	goto yy57;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych >= ' ') goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych >= 'F') goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych >= 'M') goto yy57;
			} else {
				if (yych <= 'R') goto yy1005;
				if (yych <= 'T') goto yy57;
				if (yych >= 'W') goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych >= 'd') goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych >= 'h') goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych >= 's') goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy57;
				} else {
					if (yych == 'y') goto yy57;
				}
			}
		}
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
#line 1214 "parse_date.db.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 16247 "parse_date.db.c"
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1004;
	goto yy57;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1009;
	goto yy53;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1011;
	if (yych <= '2') goto yy1012;
	if (yych <= '3') goto yy1013;
	goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1014;
	goto yy53;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1014;
	goto yy53;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy53;
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1016;
	if (yych <= '2') goto yy1017;
	goto yy53;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1018;
	goto yy53;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1023;
	if (yych <= '6') goto yy1024;
	goto yy53;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	++YYCURSOR;
yy1026:
	YYDEBUG(1026, *YYCURSOR);
#line 1188 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 16375 "parse_date.db.c"
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy1029;
	} else {
		if (yych <= '3') goto yy1030;
		if (yych <= '9') goto yy1004;
		goto yy57;
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1005;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1005;
					goto yy51;
				} else {
					if (yych <= '9') goto yy1031;
					if (yych <= 'C') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1005;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1005;
					if (yych <= 'T') goto yy57;
					goto yy1005;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1005;
				if (yych <= 'Y') goto yy57;
				goto yy1005;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1005;
				} else {
					if (yych == 'g') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1005;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1005;
				}
			}
		}
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1005;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1005;
				if (yych <= '9') goto yy1031;
				if (yych <= 'C') goto yy1005;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1005;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1005;
					if (yych <= 'T') goto yy57;
					goto yy1005;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1005;
				if (yych <= 'Y') goto yy57;
				goto yy1005;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1005;
				} else {
					if (yych == 'g') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1005;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1005;
				}
			}
		}
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1005;
				goto yy57;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy1005;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1005;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1005;
					if (yych <= 'T') goto yy57;
					goto yy1005;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1005;
				if (yych <= 'Y') goto yy57;
				goto yy1005;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1005;
				} else {
					if (yych == 'g') goto yy1005;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1005;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1005;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1005;
				}
			}
		}
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych >= ' ') goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy58;
				} else {
					if (yych <= 'T') goto yy1033;
					if (yych >= 'W') goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy63;
				} else {
					if (yych == 'h') goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy1032;
				if (yych <= 's') goto yy58;
				goto yy1034;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy62;
				} else {
					if (yych == 'y') goto yy64;
				}
			}
		}
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
#line 1176 "parse_date.db.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 16652 "parse_date.db.c"
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1048;
			goto yy1049;
		} else {
			if (yych <= '9') goto yy1050;
			if (yych <= 'G') goto yy53;
			goto yy66;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy67;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy66;
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych >= '2') goto yy1036;
		} else {
			if (yych <= '9') goto yy1037;
			if (yych <= 'G') goto yy53;
			goto yy66;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy67;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy66;
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1042;
	if (yych <= '9') goto yy1037;
	goto yy53;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1042;
	if (yych <= '5') goto yy1038;
	goto yy53;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1040;
	if (yych <= '6') goto yy1041;
	goto yy53;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy53;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1043;
	if (yych <= '9') goto yy1039;
	goto yy53;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1044;
	if (yych <= '6') goto yy1045;
	if (yych <= '9') goto yy1039;
	goto yy53;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1046;
	if (yych <= '6') goto yy1047;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1046;
	if (yych <= '5') goto yy1040;
	if (yych <= '6') goto yy1041;
	goto yy53;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy1026;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1057;
	if (yych <= '9') goto yy1050;
	if (yych <= ':') goto yy1051;
	goto yy53;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '3') goto yy1057;
		goto yy1038;
	} else {
		if (yych == ':') goto yy1051;
		goto yy53;
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1038;
	if (yych != ':') goto yy53;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1055;
	if (yych <= '6') goto yy1056;
	goto yy53;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy53;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1043;
	if (yych <= '9') goto yy1039;
	if (yych <= ':') goto yy1051;
	goto yy53;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy51;
	if (yych <= '9') goto yy1004;
	goto yy57;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych <= '0') goto yy1028;
		goto yy1029;
	} else {
		if (yych <= '3') goto yy1030;
		if (yych <= '9') goto yy1004;
		goto yy57;
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1061;
	if (yych != 'c') goto yy53;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1062;
	if (yych != 'e') goto yy978;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1063;
	if (yych != 'm') goto yy53;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1064;
	if (yych != 'b') goto yy53;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1065;
	if (yych != 'e') goto yy53;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1066;
	if (yych != 'r') goto yy53;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy978;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1068;
	if (yych != 'v') goto yy53;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1069;
	if (yych != 'e') goto yy978;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1070;
	if (yych != 'm') goto yy53;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1071;
	if (yych != 'b') goto yy53;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1072;
	if (yych != 'e') goto yy53;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1066;
	if (yych == 'r') goto yy1066;
	goto yy53;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1074;
	if (yych != 't') goto yy53;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1075;
	if (yych != 'o') goto yy978;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1076;
	if (yych != 'b') goto yy53;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1077;
	if (yych != 'e') goto yy53;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1066;
	if (yych == 'r') goto yy1066;
	goto yy53;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy53;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy121;
		} else {
			if (yych != 'p') goto yy53;
		}
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1080;
	if (yych != 't') goto yy978;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1081;
	if (yych != 'e') goto yy978;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1082;
	if (yych != 'm') goto yy53;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1083;
	if (yych != 'b') goto yy53;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1084;
	if (yych != 'e') goto yy53;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1066;
	if (yych == 'r') goto yy1066;
	goto yy53;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1089;
	if (yych == 'g') goto yy1089;
	goto yy53;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1087;
	if (yych != 'r') goto yy53;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1088;
	if (yych != 'i') goto yy978;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1066;
	if (yych == 'l') goto yy1066;
	goto yy53;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1090;
	if (yych != 'u') goto yy978;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1091;
	if (yych != 's') goto yy53;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1066;
	if (yych == 't') goto yy1066;
	goto yy53;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1093;
		if (yych <= 'X') goto yy53;
		goto yy1066;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy1066;
			goto yy53;
		}
	}
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1094;
	if (yych != 'c') goto yy978;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1066;
	if (yych == 'h') goto yy1066;
	goto yy53;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1096;
	if (yych != 'b') goto yy53;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1097;
	if (yych != 'r') goto yy978;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1098;
	if (yych != 'u') goto yy53;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1099;
	if (yych != 'a') goto yy53;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1100;
	if (yych != 'r') goto yy53;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1066;
	if (yych == 'y') goto yy1066;
	goto yy53;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1108;
		if (yych <= 'M') goto yy53;
		goto yy1107;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy1108;
		} else {
			if (yych == 'n') goto yy1107;
			goto yy53;
		}
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1103;
	if (yych != 'n') goto yy53;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1104;
	if (yych != 'u') goto yy978;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1105;
	if (yych != 'a') goto yy53;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1106;
	if (yych != 'r') goto yy53;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1066;
	if (yych == 'y') goto yy1066;
	goto yy53;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1066;
	if (yych == 'e') goto yy1066;
	goto yy978;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1066;
	if (yych == 'y') goto yy1066;
	goto yy978;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1066;
	goto yy978;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy978;
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1066;
	goto yy978;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1066;
	goto yy978;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1128;
	if (yych <= '9') goto yy1127;
	goto yy53;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1126;
	goto yy53;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1124;
	if (yych <= '6') goto yy1123;
	goto yy53;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1095;
	if (yych == 'e') goto yy1095;
	goto yy53;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1092;
	if (yych == 'a') goto yy1092;
	goto yy53;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1122;
	if (yych == 'e') goto yy1122;
	goto yy53;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1060;
	if (yych == 'e') goto yy1060;
	goto yy53;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy1120;
	case 'A':
	case 'a':	goto yy984;
	case 'D':
	case 'd':	goto yy1119;
	case 'F':
	case 'f':	goto yy1116;
	case 'I':	goto yy977;
	case 'J':
	case 'j':	goto yy981;
	case 'M':
	case 'm':	goto yy1117;
	case 'N':
	case 'n':	goto yy987;
	case 'O':
	case 'o':	goto yy986;
	case 'S':
	case 's':	goto yy1118;
	case 'V':	goto yy979;
	case 'X':	goto yy980;
	default:	goto yy53;
	}
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1079;
	if (yych == 'p') goto yy1079;
	goto yy53;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '6') goto yy1125;
	goto yy53;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1005;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1125;
	goto yy53;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1125;
	goto yy53;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1125;
	goto yy53;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy1132;
	if (yych <= '0') goto yy1131;
	if (yych <= '9') goto yy1142;
	goto yy53;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy1132;
	if (yych <= '2') goto yy1142;
	goto yy53;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1133;
	if (yych <= '3') goto yy1135;
	if (yych <= '9') goto yy1136;
	goto yy53;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1134;
		if (yych <= '9') goto yy1136;
		if (yych >= 'n') goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
		}
	}
yy1134:
	YYDEBUG(1134, *YYCURSOR);
#line 1073 "parse_date.db.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 17346 "parse_date.db.c"
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1134;
		if (yych <= '1') goto yy1136;
		if (yych <= 'm') goto yy1134;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1134;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy1134;
		}
	}
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1138;
		goto yy1134;
	} else {
		if (yych <= 'r') goto yy1139;
		if (yych <= 's') goto yy1137;
		if (yych <= 't') goto yy1140;
		goto yy1134;
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1141;
	goto yy53;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1141;
	goto yy53;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1141;
	goto yy53;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy53;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1134;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1145;
	} else {
		if (yych <= '3') goto yy1146;
		if (yych <= '9') goto yy1136;
		goto yy53;
	}
	YYDEBUG(1144, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '0') {
			if (yych <= '/') goto yy1134;
			goto yy1136;
		} else {
			if (yych <= '9') goto yy1147;
			if (yych <= 'm') goto yy1134;
			goto yy1138;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1134;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy1134;
		}
	}
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1134;
		if (yych <= '9') goto yy1147;
		if (yych <= 'm') goto yy1134;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1134;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy1134;
		}
	}
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1134;
		if (yych <= '1') goto yy1147;
		if (yych <= 'm') goto yy1134;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1134;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy1134;
		}
	}
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1141;
		if (yych <= 'm') goto yy1134;
		goto yy1138;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1134;
			goto yy1139;
		} else {
			if (yych <= 's') goto yy1137;
			if (yych <= 't') goto yy1140;
			goto yy1134;
		}
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1223;
		if (yych <= 'T') goto yy53;
		goto yy1222;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy1223;
		} else {
			if (yych == 'u') goto yy1222;
			goto yy53;
		}
	}
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1220;
	if (yych == 'e') goto yy1220;
	goto yy53;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1217;
	if (yych == 'a') goto yy1217;
	goto yy53;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1214;
		if (yych <= 'T') goto yy53;
		goto yy1213;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy1214;
		} else {
			if (yych == 'u') goto yy1213;
			goto yy53;
		}
	}
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1210;
	if (yych == 'e') goto yy1210;
	goto yy53;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1208;
	if (yych == 'c') goto yy1208;
	goto yy53;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1206;
	if (yych == 'o') goto yy1206;
	goto yy53;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1204;
	if (yych == 'e') goto yy1204;
	goto yy53;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy1159;
		goto yy53;
	} else {
		if (yych <= '0') goto yy1158;
		if (yych <= '9') goto yy1178;
		goto yy53;
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1159;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1178;
	goto yy53;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1160;
	if (yych <= '3') goto yy1161;
	if (yych <= '9') goto yy1162;
	goto yy53;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy860;
			goto yy1162;
		} else {
			if (yych == 'T') goto yy1167;
			goto yy860;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1164;
			if (yych <= 'q') goto yy860;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy860;
		}
	}
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy860;
		} else {
			if (yych == 'T') goto yy1167;
			goto yy860;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1164;
			if (yych <= 'q') goto yy860;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy860;
		}
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1167;
		if (yych <= 'm') goto yy860;
		goto yy1164;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy860;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy860;
		}
	}
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1177;
	goto yy53;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1177;
	goto yy53;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1177;
	goto yy53;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1177;
	goto yy53;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1168;
	if (yych <= '2') goto yy1169;
	if (yych <= '9') goto yy1170;
	goto yy53;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1170;
	if (yych <= ':') goto yy1171;
	goto yy53;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1170;
	if (yych == ':') goto yy1171;
	goto yy53;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1172;
	if (yych <= '9') goto yy1173;
	goto yy53;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1173;
	if (yych <= ':') goto yy1174;
	goto yy53;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1175;
	if (yych <= '6') goto yy1176;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1025;
	goto yy1026;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1167;
	goto yy860;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1181;
	} else {
		if (yych <= '3') goto yy1182;
		if (yych <= '9') goto yy1162;
		goto yy53;
	}
	YYDEBUG(1180, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy860;
			if (yych <= '0') goto yy1162;
			goto yy1183;
		} else {
			if (yych == 'T') goto yy1167;
			goto yy860;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1164;
			if (yych <= 'q') goto yy860;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy860;
		}
	}
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy860;
			goto yy1183;
		} else {
			if (yych == 'T') goto yy1167;
			goto yy860;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1164;
			if (yych <= 'q') goto yy860;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy860;
		}
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy860;
		} else {
			if (yych == 'T') goto yy1167;
			goto yy860;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1164;
			if (yych <= 'q') goto yy860;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy860;
		}
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1184;
		if (yych <= 'm') goto yy1134;
		goto yy1164;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1134;
			goto yy1165;
		} else {
			if (yych <= 's') goto yy1163;
			if (yych <= 't') goto yy1166;
			goto yy1134;
		}
	}
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1185;
	if (yych <= '2') goto yy1186;
	if (yych <= '9') goto yy1170;
	goto yy53;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1187;
	if (yych <= ':') goto yy1171;
	goto yy53;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1187;
	if (yych == ':') goto yy1171;
	goto yy53;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1189;
	if (yych <= '9') goto yy1173;
	goto yy53;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1190;
	if (yych <= ':') goto yy1174;
	goto yy53;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1192;
	if (yych <= '6') goto yy1193;
	if (yych <= '9') goto yy1025;
	goto yy53;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1194;
	goto yy1026;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1026;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy1026;
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yyaccept = 19;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(1197, *YYCURSOR);
	if (yych <= ',') {
		if (yych != '+') goto yy1026;
	} else {
		if (yych <= '-') goto yy1198;
		if (yych <= '/') goto yy1026;
		if (yych <= '9') goto yy1196;
		goto yy1026;
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1199;
	if (yych <= '2') goto yy1200;
	if (yych <= '9') goto yy1201;
	goto yy53;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1201;
	if (yych <= ':') goto yy1202;
	goto yy1026;
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1026;
		if (yych >= '4') goto yy1203;
	} else {
		if (yych <= '9') goto yy1025;
		if (yych <= ':') goto yy1202;
		goto yy1026;
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '5') goto yy1203;
	if (yych <= '9') goto yy1025;
	if (yych >= ';') goto yy1026;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '5') goto yy1203;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1026;
	if (yych <= '9') goto yy1025;
	goto yy1026;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1205;
	if (yych != 'c') goto yy53;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'E') goto yy1062;
		if (yych == 'e') goto yy1062;
		goto yy978;
	}
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1207;
	if (yych != 'v') goto yy53;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'E') goto yy1069;
		if (yych == 'e') goto yy1069;
		goto yy978;
	}
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1209;
	if (yych != 't') goto yy53;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'O') goto yy1075;
		if (yych == 'o') goto yy1075;
		goto yy978;
	}
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1211;
	if (yych != 'p') goto yy53;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'T') goto yy1212;
		if (yych != 't') goto yy978;
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'E') goto yy1081;
		if (yych == 'e') goto yy1081;
		goto yy978;
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1216;
	if (yych == 'g') goto yy1216;
	goto yy53;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1215;
	if (yych != 'r') goto yy53;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'I') goto yy1088;
		if (yych == 'i') goto yy1088;
		goto yy978;
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'U') goto yy1090;
		if (yych == 'u') goto yy1090;
		goto yy978;
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1218;
		if (yych <= 'X') goto yy53;
		goto yy1219;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy1219;
			goto yy53;
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'C') goto yy1094;
		if (yych == 'c') goto yy1094;
		goto yy978;
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy954;
	goto yy978;
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1221;
	if (yych != 'b') goto yy53;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'R') goto yy1097;
		if (yych == 'r') goto yy1097;
		goto yy978;
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1226;
		if (yych <= 'M') goto yy53;
		goto yy1225;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy1226;
		} else {
			if (yych == 'n') goto yy1225;
			goto yy53;
		}
	}
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1224;
	if (yych != 'n') goto yy53;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'U') goto yy1104;
		if (yych == 'u') goto yy1104;
		goto yy978;
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'E') goto yy1066;
		if (yych == 'e') goto yy1066;
		goto yy978;
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy954;
		goto yy978;
	} else {
		if (yych <= 'Y') goto yy1066;
		if (yych == 'y') goto yy1066;
		goto yy978;
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy784;
			goto yy931;
		} else {
			if (yych <= ',') goto yy784;
			if (yych <= '.') goto yy931;
			goto yy930;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy784;
			goto yy74;
		} else {
			if (yych == 'u') goto yy74;
			goto yy784;
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy53;
		goto yy792;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy121;
		} else {
			if (yych == 'p') goto yy792;
			goto yy53;
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych != '\t') goto yy1232;
		} else {
			if (yych <= '-') goto yy695;
			if (yych <= '.') goto yy931;
			if (yych <= '/') goto yy930;
			goto yy935;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy692;
			goto yy1232;
		} else {
			if (yych <= 'r') goto yy693;
			if (yych <= 's') goto yy686;
			if (yych <= 't') goto yy690;
			goto yy1232;
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1232;
	if (yych <= '0') goto yy932;
	if (yych <= '1') goto yy933;
	if (yych <= '9') goto yy934;
	goto yy1232;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1231;
	case '-':
	case '.':	goto yy783;
	case 'A':
	case 'a':	goto yy780;
	case 'D':
	case 'd':	goto yy688;
	case 'F':
	case 'f':	goto yy689;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy697;
	case 'J':
	case 'j':	goto yy701;
	case 'M':
	case 'm':	goto yy687;
	case 'N':
	case 'n':	goto yy704;
	case 'O':
	case 'o':	goto yy703;
	case 'S':
	case 's':	goto yy685;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy699;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy700;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1230;
			if (yych <= ',') goto yy1232;
			goto yy695;
		} else {
			if (yych <= '.') goto yy1234;
			if (yych <= '/') goto yy930;
			if (yych <= '5') goto yy1236;
			goto yy935;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1235;
			if (yych == 'n') goto yy692;
			goto yy1232;
		} else {
			if (yych <= 'r') goto yy693;
			if (yych <= 's') goto yy686;
			if (yych <= 't') goto yy690;
			goto yy1232;
		}
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy784;
		if (yych <= '0') goto yy1258;
		goto yy1259;
	} else {
		if (yych <= '5') goto yy1260;
		if (yych <= '9') goto yy1261;
		goto yy784;
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1253;
	if (yych <= '9') goto yy1254;
	goto yy53;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy936;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(1237, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy975;
	case '-':	goto yy972;
	case '.':	goto yy976;
	case '/':	goto yy973;
	case '0':	goto yy1239;
	case '1':	goto yy1240;
	case '2':	goto yy1241;
	case '3':	goto yy1242;
	case '4':
	case '5':	goto yy1243;
	case '6':	goto yy1244;
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy991;
	case 'W':	goto yy994;
	default:	goto yy1238;
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
#line 992 "parse_date.db.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 18428 "parse_date.db.c"
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1251;
	if (yych <= '9') goto yy1252;
	goto yy57;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy1250;
	if (yych <= '9') goto yy1249;
	goto yy57;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1249;
	goto yy57;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1247;
	if (yych <= '6') goto yy1248;
	if (yych <= '9') goto yy1245;
	goto yy57;
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1245;
	goto yy57;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1245;
	if (yych <= '9') goto yy51;
	goto yy57;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych >= ' ') goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych >= 'F') goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych >= 'M') goto yy57;
			} else {
				if (yych <= 'R') goto yy1246;
				if (yych <= 'T') goto yy57;
				if (yych >= 'W') goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych >= 'd') goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych >= 'h') goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych >= 's') goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy57;
				} else {
					if (yych == 'y') goto yy57;
				}
			}
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
#line 1038 "parse_date.db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 18539 "parse_date.db.c"
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1246;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1246;
				if (yych <= '9') goto yy1004;
				if (yych <= 'C') goto yy1246;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1246;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1246;
					if (yych <= 'T') goto yy57;
					goto yy1246;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1246;
				if (yych <= 'Y') goto yy57;
				goto yy1246;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1246;
				} else {
					if (yych == 'g') goto yy1246;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1246;
				}
			}
		}
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1246;
				goto yy57;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1246;
					goto yy1004;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy1246;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1246;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1246;
					if (yych <= 'T') goto yy57;
					goto yy1246;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1246;
				if (yych <= 'Y') goto yy57;
				goto yy1246;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1246;
				} else {
					if (yych == 'g') goto yy1246;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1246;
				}
			}
		}
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1246;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1246;
				if (yych <= '9') goto yy1004;
				if (yych <= 'C') goto yy1246;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1246;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1246;
					if (yych <= 'T') goto yy57;
					goto yy1246;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1246;
				if (yych <= 'Y') goto yy57;
				goto yy1246;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1246;
				} else {
					if (yych == 'g') goto yy1246;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1246;
				}
			}
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1246;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1246;
					goto yy1028;
				} else {
					if (yych <= '2') goto yy1029;
					if (yych <= '3') goto yy1030;
					goto yy1004;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1246;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1246;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1246;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1246;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1246;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1246;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1246;
				}
			}
		}
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1246;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1246;
					goto yy51;
				} else {
					if (yych <= '9') goto yy1004;
					if (yych <= 'C') goto yy1246;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1246;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1246;
					if (yych <= 'T') goto yy57;
					goto yy1246;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1246;
				if (yych <= 'Y') goto yy57;
				goto yy1246;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1246;
				} else {
					if (yych == 'g') goto yy1246;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1246;
				}
			}
		}
	}
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1246;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1246;
					goto yy1028;
				} else {
					if (yych <= '2') goto yy1029;
					if (yych <= '3') goto yy1030;
					goto yy1004;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1246;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1246;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1246;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1246;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1246;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1246;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1246;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1246;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1246;
				}
			}
		}
	}
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1255;
		goto yy713;
	} else {
		if (yych <= '9') goto yy1254;
		if (yych <= ':') goto yy1255;
		goto yy713;
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1255;
	if (yych != ':') goto yy713;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1256;
	if (yych <= '6') goto yy1257;
	if (yych <= '9') goto yy718;
	goto yy53;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych <= '/') goto yy713;
	if (yych <= '9') goto yy718;
	goto yy713;
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych == '0') goto yy718;
	goto yy713;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		goto yy1262;
	} else {
		if (yych <= '/') goto yy713;
		if (yych <= '9') goto yy1261;
		if (yych <= ':') goto yy1255;
		goto yy713;
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		if (yych <= '.') goto yy1262;
		goto yy713;
	} else {
		if (yych <= '2') goto yy1261;
		if (yych <= '9') goto yy1254;
		if (yych <= ':') goto yy1255;
		goto yy713;
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
		goto yy1262;
	} else {
		if (yych <= '/') goto yy713;
		if (yych <= '9') goto yy1254;
		if (yych <= ':') goto yy1255;
		goto yy713;
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy713;
		if (yych <= '-') goto yy807;
	} else {
		if (yych == ':') goto yy1255;
		goto yy713;
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1263;
	if (yych <= '6') goto yy1264;
	if (yych <= '9') goto yy811;
	goto yy53;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych <= '/') goto yy713;
	if (yych <= '9') goto yy1265;
	goto yy713;
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy719;
		goto yy713;
	} else {
		if (yych <= '0') goto yy1265;
		if (yych <= '9') goto yy812;
		goto yy713;
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy719;
	if (yych <= '/') goto yy713;
	if (yych <= '9') goto yy814;
	goto yy713;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy682;
			if (yych <= ',') goto yy684;
			goto yy695;
		} else {
			if (yych <= '.') goto yy696;
			if (yych <= '/') goto yy694;
			if (yych <= '5') goto yy1236;
			goto yy935;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy705;
			if (yych == 'n') goto yy692;
			goto yy684;
		} else {
			if (yych <= 'r') goto yy693;
			if (yych <= 's') goto yy686;
			if (yych <= 't') goto yy690;
			goto yy684;
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1230;
			if (yych <= ',') goto yy1232;
			goto yy695;
		} else {
			if (yych <= '.') goto yy1234;
			if (yych <= '/') goto yy694;
			if (yych <= '5') goto yy1236;
			goto yy935;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1235;
			if (yych == 'n') goto yy692;
			goto yy1232;
		} else {
			if (yych <= 'r') goto yy693;
			if (yych <= 's') goto yy686;
			if (yych <= 't') goto yy690;
			goto yy1232;
		}
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1270, *YYCURSOR);
	if (yych <= '/') goto yy1271;
	if (yych <= '9') goto yy1269;
yy1271:
	YYDEBUG(1271, *YYCURSOR);
#line 925 "parse_date.db.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19173 "parse_date.db.c"
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
			goto yy1312;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'n') goto yy1312;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1306;
			if (yych <= 'T') goto yy134;
			goto yy1305;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy134;
			goto yy1306;
		} else {
			if (yych == 'u') goto yy1305;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1294;
			if (yych <= 'L') goto yy134;
			goto yy1295;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy134;
			goto yy1294;
		} else {
			if (yych == 'm') goto yy1295;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
			goto yy1290;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'e') goto yy1290;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
			goto yy1286;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'e') goto yy1286;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1235;
		goto yy53;
	} else {
		if (yych <= '9') goto yy1280;
		if (yych <= ':') goto yy1235;
		goto yy53;
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1235;
		goto yy53;
	} else {
		if (yych <= '3') goto yy1280;
		if (yych == ':') goto yy1235;
		goto yy53;
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1235;
	if (yych == ':') goto yy1235;
	goto yy53;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1235;
		goto yy53;
	} else {
		if (yych <= '5') goto yy1281;
		if (yych == ':') goto yy1235;
		goto yy53;
	}
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1238;
	if (yych <= '5') goto yy1283;
	if (yych <= '6') goto yy1284;
	goto yy1238;
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1285;
	goto yy53;
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1246;
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy135;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'l') goto yy1287;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy136;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'f') goto yy1288;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy137;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 't') goto yy1289;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy163;
		if (yych == 'h') goto yy163;
		goto yy3;
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy405;
			goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'R') goto yy135;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy405;
			goto yy135;
		} else {
			if (yych <= 's') goto yy1291;
			if (yych <= 'z') goto yy135;
			goto yy405;
		}
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy136;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'd') goto yy1292;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1293;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy411;
		if (yych == 'y') goto yy411;
		goto yy3;
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
		goto yy1302;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1302;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy135;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'o') goto yy1296;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy136;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'r') goto yy1297;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'r') goto yy1298;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1299;
		if (yych != 'o') goto yy3;
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1300;
	if (yych != 'w') goto yy53;
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	++YYCURSOR;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
#line 913 "parse_date.db.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19620 "parse_date.db.c"
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy136;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'y') goto yy1303;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy132;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy1304;
		if (yych <= 'z') goto yy137;
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
#line 903 "parse_date.db.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19664 "parse_date.db.c"
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy405;
			goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'Q') goto yy135;
			goto yy1308;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy405;
			goto yy135;
		} else {
			if (yych <= 'r') goto yy1308;
			if (yych <= 'z') goto yy135;
			goto yy405;
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy135;
			if (yych >= 'S') goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'r') goto yy1307;
			if (yych <= 's') goto yy321;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'd') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy136;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 's') goto yy1309;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy137;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'd') goto yy1310;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1311;
		if (yych != 'a') goto yy3;
	}
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy411;
	if (yych == 'y') goto yy411;
	goto yy53;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy1313;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'h') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
			goto yy1312;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1343;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy134;
			} else {
				if (yych <= 'I') goto yy1306;
				if (yych <= 'T') goto yy134;
				goto yy1305;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy139;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy1337;
				goto yy139;
			} else {
				if (yych <= 'u') goto yy1336;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				goto yy134;
			} else {
				if (yych <= 'D') goto yy1294;
				if (yych <= 'L') goto yy134;
				goto yy1295;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy139;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy1327;
				goto yy139;
			} else {
				if (yych <= 'm') goto yy1328;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
			goto yy1290;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1323;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy134;
			goto yy1286;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1319;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy135;
			goto yy1287;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'l') goto yy1320;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy136;
			goto yy1288;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'f') goto yy1321;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy137;
			goto yy1289;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy1322;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'G') goto yy3;
			goto yy163;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy245;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'R') goto yy135;
			goto yy1291;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 's') goto yy1324;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy136;
			goto yy1292;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1325;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy1293;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1326;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'X') goto yy3;
			goto yy411;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy419;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy1302;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1334;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy135;
			goto yy1296;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1329;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy136;
			goto yy1297;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1330;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy1298;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1331;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'N') goto yy3;
			goto yy1299;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1332;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1300;
	if (yych != 'w') goto yy148;
	YYDEBUG(1333, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy1301;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy1301;
		if (yych <= 'z') goto yy147;
		goto yy1301;
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy136;
			goto yy1303;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy1335;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy1304;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy1304;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '^') goto yy1304;
			goto yy140;
		} else {
			if (yych <= '`') goto yy1304;
			if (yych <= 'z') goto yy146;
			goto yy1304;
		}
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'Q') goto yy135;
			goto yy1308;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 'r') goto yy1339;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy135;
			if (yych <= 'R') goto yy1307;
			goto yy321;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy144;
			} else {
				if (yych <= 's') goto yy345;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
	YYDEBUG(1338, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy136;
			goto yy1309;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 's') goto yy1340;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy137;
			goto yy1310;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1341;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy1311;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1342;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy411;
	if (yych == 'y') goto yy419;
	goto yy148;
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy1313;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy1344;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1357;
			if (yych <= 'X') goto yy134;
			goto yy1358;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy134;
			goto yy1357;
		} else {
			if (yych == 'y') goto yy1358;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy134;
			goto yy1351;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'd') goto yy1351;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'n') goto yy1348;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy405;
			goto yy132;
		} else {
			if (yych <= '@') goto yy405;
			if (yych <= 'C') goto yy135;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy405;
			goto yy135;
		} else {
			if (yych <= 'd') goto yy1349;
			if (yych <= 'z') goto yy135;
			goto yy405;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy132;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1350;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy137;
			goto yy546;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'y') goto yy546;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy135;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'n') goto yy1352;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy136;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'i') goto yy1353;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy137;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'g') goto yy1354;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1355;
		if (yych != 'h') goto yy3;
	}
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1356;
	if (yych != 't') goto yy53;
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1304;
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych == 'C') goto yy1359;
				goto yy135;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'c') goto yy1359;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych == ')') goto yy132;
			if (yych <= ',') goto yy3;
			goto yy424;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy423;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy604;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'h') goto yy604;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy132;
			if (yych <= '.') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy3;
				goto yy134;
			} else {
				if (yych <= 'R') goto yy1357;
				if (yych <= 'X') goto yy134;
				goto yy1358;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy139;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy1372;
				goto yy139;
			} else {
				if (yych <= 'y') goto yy1373;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy134;
			goto yy1351;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1366;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
			goto yy1348;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1363;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy405;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy405;
			if (yych <= 'C') goto yy135;
			goto yy1349;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy405;
		} else {
			if (yych == 'd') goto yy1364;
			if (yych <= 'z') goto yy144;
			goto yy405;
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			goto yy1350;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '^') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1365;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy137;
			goto yy546;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'y') goto yy575;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy135;
			goto yy1352;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1367;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy136;
			goto yy1353;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'i') goto yy1368;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy137;
			goto yy1354;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'g') goto yy1369;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'G') goto yy3;
			goto yy1355;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1370;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1356;
	if (yych != 't') goto yy148;
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy1304;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy1304;
		if (yych <= 'z') goto yy147;
		goto yy1304;
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'C') goto yy1359;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'c') goto yy1374;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy3;
			goto yy423;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych <= ',') goto yy3;
				if (yych <= '-') goto yy424;
				goto yy423;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy140;
			if (yych <= '9') goto yy423;
			if (yych <= '@') goto yy3;
			goto yy135;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy604;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy615;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy132;
			if (yych <= '@') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'O') goto yy1383;
			if (yych <= 'U') goto yy134;
			if (yych <= 'V') goto yy1384;
			goto yy1381;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy134;
			goto yy1383;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy134;
				goto yy1384;
			} else {
				if (yych <= 'w') goto yy1381;
				if (yych <= 'z') goto yy134;
				goto yy3;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy134;
			goto yy1380;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'x') goto yy1380;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 'n') goto yy1378;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy1379;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'h') goto yy376;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy321;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy321;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy132;
	} else {
		if (yych <= 'Z') goto yy135;
		if (yych <= '`') goto yy1382;
		if (yych <= 'z') goto yy135;
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
#line 882 "parse_date.db.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21445 "parse_date.db.c"
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy135;
			goto yy1389;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 'n') goto yy1389;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy132;
				goto yy3;
			} else {
				if (yych <= '-') goto yy424;
				if (yych <= '.') goto yy423;
				goto yy3;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy423;
				goto yy3;
			} else {
				if (yych != 'E') goto yy135;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'e') goto yy1385;
				if (yych <= 'z') goto yy135;
				goto yy3;
			}
		}
	}
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy136;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'm') goto yy1386;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy137;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'b') goto yy1387;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1388;
		if (yych != 'e') goto yy3;
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy422;
	if (yych == 'r') goto yy422;
	goto yy53;
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy132;
	} else {
		if (yych <= 'Z') goto yy136;
		if (yych <= '`') goto yy1390;
		if (yych <= 'z') goto yy136;
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
#line 891 "parse_date.db.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21595 "parse_date.db.c"
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy132;
			} else {
				if (yych == '/') goto yy140;
				goto yy3;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy134;
				goto yy1383;
			} else {
				if (yych <= 'U') goto yy134;
				if (yych <= 'V') goto yy1384;
				goto yy1381;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy134;
				goto yy3;
			} else {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy139;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1398;
				if (yych <= 'u') goto yy139;
				goto yy1399;
			} else {
				if (yych <= 'w') goto yy1397;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy134;
			goto yy1380;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'x') goto yy1396;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy134;
			goto yy1378;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1394;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy1379;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy1395;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy136;
			goto yy376;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'h') goto yy394;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy321;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy345;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy1382;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy1382;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '^') goto yy1382;
			goto yy140;
		} else {
			if (yych <= '`') goto yy1382;
			if (yych <= 'z') goto yy144;
			goto yy1382;
		}
	}
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy135;
			goto yy1389;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'n') goto yy1404;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy423;
			} else {
				if (yych == ' ') goto yy423;
				goto yy3;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy132;
				if (yych <= ',') goto yy3;
				goto yy424;
			} else {
				if (yych == '/') goto yy140;
				goto yy423;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy3;
				goto yy135;
			} else {
				if (yych <= 'E') goto yy1385;
				if (yych <= 'Z') goto yy135;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'e') goto yy1400;
				if (yych <= 'z') goto yy144;
				goto yy3;
			}
		}
	}
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy136;
			goto yy1386;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'm') goto yy1401;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy137;
			goto yy1387;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1402;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'D') goto yy3;
			goto yy1388;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1403;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy53;
			goto yy140;
		} else {
			if (yych == 'R') goto yy422;
			goto yy53;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy140;
			if (yych <= '`') goto yy53;
			goto yy147;
		} else {
			if (yych <= 'r') goto yy528;
			if (yych <= 'z') goto yy147;
			goto yy53;
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy1390;
			goto yy132;
		} else {
			if (yych == '/') goto yy140;
			goto yy1390;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '^') goto yy1390;
			goto yy140;
		} else {
			if (yych <= '`') goto yy1390;
			if (yych <= 'z') goto yy145;
			goto yy1390;
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy134;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy134;
			if (yych <= '`') goto yy3;
			goto yy134;
		} else {
			if (yych <= 's') goto yy1406;
			if (yych <= 'z') goto yy134;
			goto yy3;
		}
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy135;
			if (yych <= '`') goto yy3;
			goto yy135;
		} else {
			if (yych <= 't') goto yy1407;
			if (yych <= 'z') goto yy135;
			goto yy3;
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy136;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy136;
			if (yych <= '`') goto yy3;
			goto yy136;
		} else {
			if (yych <= 'e') goto yy1408;
			if (yych <= 'z') goto yy136;
			goto yy3;
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy132;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'r') goto yy1409;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy132;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1410;
		if (yych != 'd') goto yy3;
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1411;
	if (yych != 'a') goto yy53;
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1412;
	if (yych != 'y') goto yy53;
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	++YYCURSOR;
yy1413:
	YYDEBUG(1413, *YYCURSOR);
#line 870 "parse_date.db.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22102 "parse_date.db.c"
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy134;
			goto yy1406;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy134;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 's') goto yy1415;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy135;
			goto yy1407;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy135;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 't') goto yy1416;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy136;
			goto yy1408;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy136;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1417;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy1409;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1418;
			if (yych <= 'z') goto yy146;
			goto yy3;
		}
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy132;
			goto yy3;
		} else {
			if (yych <= '/') goto yy140;
			if (yych <= 'C') goto yy3;
			goto yy1410;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy140;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1419;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1411;
	if (yych != 'a') goto yy148;
	YYDEBUG(1420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1412;
	if (yych != 'y') goto yy148;
	YYDEBUG(1421, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy140;
		goto yy1413;
	} else {
		if (yych <= '_') goto yy140;
		if (yych <= '`') goto yy1413;
		if (yych <= 'z') goto yy147;
		goto yy1413;
	}
}
#line 1444 "parse_date.db.re"

}

#define YYMAXFILL 29

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
