/* Generated by re2c */
#line 1 "condition_06.cs.re"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	BSIZE	8192

typedef struct Scanner
{
	FILE			*fp;
	unsigned char	*cur, *tok, *lim, *eof;
	unsigned char 	buffer[BSIZE];
} Scanner;

int fill(Scanner *s, int len)
{
	if (!len)
	{
		s->cur = s->tok = s->lim = s->buffer;
		s->eof = 0;
	}
	if (!s->eof)
	{
		int got, cnt = s->tok - s->buffer;

		if (cnt > 0)
		{
			memcpy(s->buffer, s->tok, s->lim - s->tok);
			s->tok -= cnt;
			s->cur -= cnt;
			s->lim -= cnt;
		}
		cnt = BSIZE - cnt;
		if ((got = fread(s->lim, 1, cnt, s->fp)) != cnt)
		{
			s->eof = &s->lim[got];
		}
		s->lim += got;
	}
	else if (s->cur + len > s->eof)
	{
		return 0; /* not enough input data */
	}
	return -1;
}

void fputl(const char *s, size_t len, FILE *stream)
{
	while(len-- > 0)
	{
		fputc(*s++, stream);
	}
}

#line 57 "condition_06.cs.c"

enum YYCONDTYPE {
	EStateNormal,
	EStateComment,
	EStateSkiptoeol,
	EStateString,
};

#line 54 "condition_06.cs.re"

void scan(Scanner *s)
{
	int cond = EStateNormal;
	
	fill(s, 0);

	for(;;)
	{
		s->tok = s->cur;

#line 78 "condition_06.cs.c"
		{
			unsigned char yych;
			if (cond < 2) {
				if (cond < 1) {
					goto yyc_Normal;
				} else {
					goto yyc_Comment;
				}
			} else {
				if (cond < 3) {
					goto yyc_Skiptoeol;
				} else {
					goto yyc_String;
				}
			}
/* *********************************** */
yyc_Comment:
			if ((s->lim - s->cur) < 2) { if(fill(s, 2) >= 0) break; }
			yych = *s->cur;
			if (yych != '*') goto yy5;
			++s->cur;
			if ((yych = *s->cur) == '/') goto yy6;
yy4:
#line 149 "condition_06.cs.re"
			{
				goto yyc_Comment;
			}
#line 106 "condition_06.cs.c"
yy5:
			yych = *++s->cur;
			goto yy4;
yy6:
			++s->cur;
#line 145 "condition_06.cs.re"
			{
				continue;
			}
#line 116 "condition_06.cs.c"
/* *********************************** */
yyc_Normal:
			if ((s->lim - s->cur) < 3) { if(fill(s, 3) >= 0) break; }
			yych = *s->cur;
			if (yych <= '.') {
				if (yych == '"') goto yy13;
				goto yy15;
			} else {
				if (yych <= '/') goto yy12;
				if (yych != '?') goto yy15;
			}
			yych = *(s->tok = ++s->cur);
			if (yych == '?') goto yy20;
yy11:
#line 140 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				continue;
			}
#line 136 "condition_06.cs.c"
yy12:
			yych = *++s->cur;
			if (yych == '*') goto yy18;
			if (yych == '/') goto yy16;
			goto yy11;
yy13:
			++s->cur;
#line 134 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				state = EStateString;
				continue;
			}
#line 150 "condition_06.cs.c"
yy15:
			yych = *++s->cur;
			goto yy11;
yy16:
			++s->cur;
#line 130 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 160 "condition_06.cs.c"
yy18:
			++s->cur;
#line 126 "condition_06.cs.re"
			{
				goto yyc_Comment;
			}
#line 167 "condition_06.cs.c"
yy20:
			yych = *++s->cur;
			switch (yych) {
			case '!':	goto yy36;
			case '\'':	goto yy34;
			case '(':	goto yy22;
			case ')':	goto yy24;
			case '-':	goto yy38;
			case '/':	goto yy32;
			case '<':	goto yy26;
			case '=':	goto yy30;
			case '>':	goto yy28;
			default:	goto yy21;
			}
yy21:
			s->cur = s->tok;
			goto yy11;
yy22:
			++s->cur;
#line 81 "condition_06.cs.re"
			{
				fputc('[', stdout);
				continue;
			}
#line 192 "condition_06.cs.c"
yy24:
			++s->cur;
#line 86 "condition_06.cs.re"
			{
				fputc(']', stdout);
				continue;
			}
#line 200 "condition_06.cs.c"
yy26:
			++s->cur;
#line 91 "condition_06.cs.re"
			{
				fputc('{', stdout);
				continue;
			}
#line 208 "condition_06.cs.c"
yy28:
			++s->cur;
#line 96 "condition_06.cs.re"
			{
				fputc('}', stdout);
				continue;
			}
#line 216 "condition_06.cs.c"
yy30:
			++s->cur;
#line 101 "condition_06.cs.re"
			{
				fputc('#', stdout);
				continue;
			}
#line 224 "condition_06.cs.c"
yy32:
			++s->cur;
#line 106 "condition_06.cs.re"
			{
				fputc('\\', stdout);
				continue;
			}
#line 232 "condition_06.cs.c"
yy34:
			++s->cur;
#line 111 "condition_06.cs.re"
			{
				fputc('^', stdout);
				continue;
			}
#line 240 "condition_06.cs.c"
yy36:
			++s->cur;
#line 116 "condition_06.cs.re"
			{
				fputc('|', stdout);
				continue;
			}
#line 248 "condition_06.cs.c"
yy38:
			++s->cur;
#line 121 "condition_06.cs.re"
			{
				fputc('~', stdout);
				continue;
			}
#line 256 "condition_06.cs.c"
/* *********************************** */
yyc_Skiptoeol:
			if ((s->lim - s->cur) < 5) { if(fill(s, 5) >= 0) break; }
			yych = *s->cur;
			if (yych <= '>') {
				if (yych == '\n') goto yy45;
				goto yy47;
			} else {
				if (yych <= '?') goto yy42;
				if (yych == '\\') goto yy44;
				goto yy47;
			}
yy42:
			yych = *(s->tok = ++s->cur);
			if (yych == '?') goto yy52;
yy43:
#line 165 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 277 "condition_06.cs.c"
yy44:
			yych = *(s->tok = ++s->cur);
			if (yych == '\n') goto yy50;
			if (yych == '\r') goto yy48;
			goto yy43;
yy45:
			++s->cur;
#line 161 "condition_06.cs.re"
			{
				continue;
			}
#line 289 "condition_06.cs.c"
yy47:
			yych = *++s->cur;
			goto yy43;
yy48:
			yych = *++s->cur;
			if (yych == '\n') goto yy50;
yy49:
			s->cur = s->tok;
			goto yy43;
yy50:
			++s->cur;
#line 157 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 305 "condition_06.cs.c"
yy52:
			yych = *++s->cur;
			if (yych != '/') goto yy49;
			yych = *++s->cur;
			if (yych == '\n') goto yy55;
			if (yych != '\r') goto yy49;
			yych = *++s->cur;
			if (yych != '\n') goto yy49;
yy55:
			++s->cur;
#line 153 "condition_06.cs.re"
			{
				goto yyc_Skiptoeol;
			}
#line 320 "condition_06.cs.c"
/* *********************************** */
yyc_String:
			if ((s->lim - s->cur) < 2) { if(fill(s, 2) >= 0) break; }
			yych = *s->cur;
			if (yych == '"') goto yy61;
			if (yych != '\\') goto yy63;
			++s->cur;
			if ((yych = *s->cur) != '\n') goto yy64;
yy60:
#line 179 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				continue;
			}
#line 335 "condition_06.cs.c"
yy61:
			++s->cur;
#line 174 "condition_06.cs.re"
			{
				fputc(*s->tok, stdout);
				continue;
			}
#line 343 "condition_06.cs.c"
yy63:
			yych = *++s->cur;
			goto yy60;
yy64:
			++s->cur;
#line 169 "condition_06.cs.re"
			{
				fputl((const char*)s->tok, 2, stdout);
				continue;
			}
#line 354 "condition_06.cs.c"
		}
#line 183 "condition_06.cs.re"

	}
}

int main(int argc, char **argv)
{
	Scanner in;
	char c;

	if (argc != 2)
	{
		fprintf(stderr, "%s <file>\n", argv[0]);
		return 1;;
	}

	memset((char*) &in, 0, sizeof(in));

	if (!strcmp(argv[1], "-"))
	{
		in.fp = stdin;
	}
	else if ((in.fp = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr, "Cannot open file '%s'\n", argv[1]);
		return 1;
	}

	scan(&in);

	if (in.fp != stdin)
	{
		fclose(in.fp);
	}
	return 0;
}
