#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 12
#define STATE_COUNT 602
#define LARGE_STATE_COUNT 175
#define SYMBOL_COUNT 265
#define ALIAS_COUNT 1
#define TOKEN_COUNT 120
#define EXTERNAL_TOKEN_COUNT 7
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 6

enum {
  anon_sym_DQUOTE = 1,
  aux_sym_legacy_quoted_command_token1 = 2,
  anon_sym_TILDE = 3,
  sym_grep_specifier_identifier = 4,
  aux_sym_grep_specifier_token1 = 5,
  anon_sym_PIPE = 6,
  anon_sym_PIPEH = 7,
  anon_sym_PIPET = 8,
  sym_pipe_second_command = 9,
  anon_sym_AT_AT_AT_EQ = 10,
  anon_sym_AT_AT_ATb = 11,
  anon_sym_AT_AT_ATc_COLON = 12,
  anon_sym_AT_AT_ATC_COLON = 13,
  anon_sym_AT_AT_ATi = 14,
  anon_sym_AT_AT_ATr = 15,
  anon_sym_AT_AT_ATs = 16,
  anon_sym_AT_AT_ATst = 17,
  anon_sym_AT_AT_ATS = 18,
  anon_sym_AT_AT_ATm = 19,
  anon_sym_AT_AT_ATM = 20,
  anon_sym_AT_AT_ATf = 21,
  anon_sym_AT_AT_ATf_COLON = 22,
  anon_sym_AT_AT_ATF = 23,
  anon_sym_AT_AT_ATF_COLON = 24,
  anon_sym_AT_AT_ATt = 25,
  anon_sym_AT_AT = 26,
  anon_sym_AT_ATdbt = 27,
  anon_sym_AT_ATdbta = 28,
  anon_sym_AT_ATdbtb = 29,
  anon_sym_AT_ATdbts = 30,
  anon_sym_AT_AT_DOT = 31,
  anon_sym_AT_AT_EQ = 32,
  anon_sym_AT_ATk = 33,
  anon_sym_AT_ATt = 34,
  anon_sym_AT_ATb = 35,
  anon_sym_AT_ATi = 36,
  anon_sym_AT_ATiS = 37,
  anon_sym_AT_ATf = 38,
  anon_sym_COLON = 39,
  anon_sym_AT_ATs_COLON = 40,
  anon_sym_AT_ATc_COLON = 41,
  anon_sym_AT = 42,
  anon_sym_AT_BANG = 43,
  anon_sym_AT_LBRACE = 44,
  anon_sym_RBRACE = 45,
  anon_sym_ATa_COLON = 46,
  anon_sym_ATb_COLON = 47,
  anon_sym_ATB_COLON = 48,
  anon_sym_ATe_COLON = 49,
  anon_sym_ATF_COLON = 50,
  anon_sym_ATi_COLON = 51,
  anon_sym_ATk_COLON = 52,
  anon_sym_ATo_COLON = 53,
  anon_sym_ATr_COLON = 54,
  anon_sym_ATf_COLON = 55,
  anon_sym_ATs_COLON = 56,
  anon_sym_ATx_COLON = 57,
  anon_sym_AMP = 58,
  anon_sym_AMPt = 59,
  aux_sym_task_command_token1 = 60,
  anon_sym_0 = 61,
  aux_sym_number_command_token1 = 62,
  aux_sym__search_command_token1 = 63,
  anon_sym_DOT = 64,
  anon_sym_DOT_BANG = 65,
  anon_sym_DOT_LPAREN = 66,
  anon_sym_PIPE_DOT = 67,
  anon_sym_DOT_SLASH = 68,
  anon_sym_pfo = 69,
  anon_sym_Cf = 70,
  sym_pf_dot_cmd_identifier = 71,
  sym_pf_dot_full_cmd_identifier = 72,
  aux_sym_pf_cmd_token1 = 73,
  anon_sym_EQ = 74,
  aux_sym__pf_dot_arg_identifier_token1 = 75,
  anon_sym_DOLLAR = 76,
  anon_sym_LPAREN = 77,
  anon_sym_RPAREN = 78,
  aux_sym_pf_arg_identifier_token1 = 79,
  anon_sym_PERCENT = 80,
  anon_sym_env = 81,
  anon_sym_DOT_DOT_DOT = 82,
  aux_sym__interpret_identifier_token1 = 83,
  aux_sym__interpret_identifier_token2 = 84,
  sym_system_identifier = 85,
  sym_question_mark_identifier = 86,
  sym_pointer_identifier = 87,
  sym_macro_identifier = 88,
  anon_sym_SEMI = 89,
  anon_sym_GT = 90,
  anon_sym_GT_GT = 91,
  sym_html_redirect_operator = 92,
  sym_html_append_operator = 93,
  anon_sym_COMMA = 94,
  aux_sym_tmp_eval_arg_token1 = 95,
  sym__eq_sep_key_identifier = 96,
  sym__any_command = 97,
  aux_sym_arg_identifier_token1 = 98,
  aux_sym_arg_identifier_brace_token1 = 99,
  aux_sym_double_quoted_arg_token1 = 100,
  aux_sym_double_quoted_arg_token2 = 101,
  aux_sym_double_quoted_arg_token3 = 102,
  anon_sym_SQUOTE = 103,
  aux_sym_single_quoted_arg_token1 = 104,
  aux_sym_single_quoted_arg_token2 = 105,
  anon_sym_DOLLAR_LPAREN = 106,
  anon_sym_BQUOTE = 107,
  aux_sym__dec_number_token1 = 108,
  aux_sym__dec_number_token2 = 109,
  sym__comment = 110,
  anon_sym_LF = 111,
  anon_sym_CR = 112,
  sym_cmd_identifier = 113,
  sym__help_command = 114,
  sym_file_descriptor = 115,
  sym__eq_sep_concat = 116,
  sym__concat = 117,
  sym__concat_brace = 118,
  sym__concat_pf_dot = 119,
  sym_commands = 120,
  sym__commands_singleline = 121,
  sym__command = 122,
  sym_legacy_quoted_command = 123,
  sym__simple_command = 124,
  sym__tmp_command = 125,
  sym__iter_command = 126,
  sym__foreach_command = 127,
  sym__pipe_command = 128,
  sym_grep_command = 129,
  sym_grep_specifier = 130,
  sym_html_disable_command = 131,
  sym_html_enable_command = 132,
  sym_scr_tts_command = 133,
  sym_pipe_command = 134,
  sym_foreach_addrsize_command = 135,
  sym_foreach_bb_command = 136,
  sym_foreach_cmd_command = 137,
  sym_foreach_comment_command = 138,
  sym_foreach_import_command = 139,
  sym_foreach_register_command = 140,
  sym_foreach_symbol_command = 141,
  sym_foreach_string_command = 142,
  sym_foreach_section_command = 143,
  sym_foreach_iomap_command = 144,
  sym_foreach_dbgmap_command = 145,
  sym_foreach_flag_command = 146,
  sym_foreach_function_command = 147,
  sym_foreach_thread_command = 148,
  sym_iter_flags_command = 149,
  sym_iter_dbta_command = 150,
  sym_iter_dbtb_command = 151,
  sym_iter_dbts_command = 152,
  sym_iter_file_lines_command = 153,
  sym_iter_offsets_command = 154,
  sym_iter_sdbquery_command = 155,
  sym_iter_threads_command = 156,
  sym_iter_bbs_command = 157,
  sym_iter_instrs_command = 158,
  sym_iter_sections_command = 159,
  sym_iter_functions_command = 160,
  sym_iter_step_command = 161,
  sym_iter_interpret_command = 162,
  sym_iter_hit_command = 163,
  sym_tmp_seek_command = 164,
  sym_tmp_blksz_command = 165,
  sym_tmp_fromto_command = 166,
  sym_tmp_arch_command = 167,
  sym_tmp_bits_command = 168,
  sym_tmp_nthi_command = 169,
  sym_tmp_eval_command = 170,
  sym_tmp_fs_command = 171,
  sym_tmp_reli_command = 172,
  sym_tmp_kuery_command = 173,
  sym_tmp_fd_command = 174,
  sym_tmp_reg_command = 175,
  sym_tmp_file_command = 176,
  sym_tmp_string_command = 177,
  sym_tmp_hex_command = 178,
  sym_task_command = 179,
  sym_number_command = 180,
  sym_help_command = 181,
  sym_arged_command = 182,
  sym__simple_arged_command = 183,
  sym__search_command = 184,
  sym__math_arged_command = 185,
  sym__pointer_arged_command = 186,
  sym__macro_arged_command = 187,
  sym__system_command = 188,
  sym__interpret_command = 189,
  sym__interpret_search_identifier = 190,
  sym__pf_arged_command = 191,
  sym__pf_commands = 192,
  sym_Cf_cmd = 193,
  sym__Cf_args = 194,
  sym_pf_new_cmd = 195,
  sym_pf_dot_cmd = 196,
  sym_pf_cmd = 197,
  sym_pf_new_args = 198,
  sym_pf_dot_cmd_args = 199,
  sym__pf_dot_arg_identifier = 200,
  sym__pf_arg_parentheses = 201,
  sym_pf_arg_identifier = 202,
  sym__pf_arg = 203,
  sym__pf_dot_arg = 204,
  sym_pf_concatenation = 205,
  sym_pf_dot_concatenation = 206,
  sym_pf_arg = 207,
  sym_pf_dot_arg = 208,
  sym_pf_args = 209,
  sym_pf_dot_args = 210,
  sym__env_command = 211,
  sym__env_command_identifier = 212,
  sym_last_command = 213,
  sym_last_command_identifier = 214,
  sym__interpret_identifier = 215,
  sym_interpret_arg = 216,
  sym_repeat_command = 217,
  sym_eq_sep_args = 218,
  sym_macro_call_content = 219,
  sym_macro_call_full_content = 220,
  sym_macro_content = 221,
  sym_macro_args = 222,
  sym_redirect_command = 223,
  sym__redirect_operator = 224,
  sym_fdn_redirect_operator = 225,
  sym_fdn_append_operator = 226,
  sym__arg = 227,
  sym__arg_brace = 228,
  sym_arg = 229,
  sym_arg_brace = 230,
  sym_args = 231,
  sym_tmp_eval_args = 232,
  sym_tmp_eval_arg = 233,
  sym__eq_sep_key_single = 234,
  sym_eq_sep_key = 235,
  sym_eq_sep_val = 236,
  sym_arg_identifier = 237,
  sym_arg_identifier_brace = 238,
  sym_double_quoted_arg = 239,
  sym_single_quoted_arg = 240,
  sym_cmd_substitution_arg = 241,
  sym_concatenation = 242,
  sym_concatenation_brace = 243,
  sym__dec_number = 244,
  aux_sym_commands_repeat1 = 245,
  aux_sym_commands_repeat2 = 246,
  aux_sym__commands_singleline_repeat1 = 247,
  aux_sym__commands_singleline_repeat2 = 248,
  aux_sym_grep_specifier_repeat1 = 249,
  aux_sym_foreach_addrsize_command_repeat1 = 250,
  aux_sym_pf_concatenation_repeat1 = 251,
  aux_sym_pf_dot_concatenation_repeat1 = 252,
  aux_sym_pf_args_repeat1 = 253,
  aux_sym_pf_dot_args_repeat1 = 254,
  aux_sym_macro_content_repeat1 = 255,
  aux_sym_args_repeat1 = 256,
  aux_sym_tmp_eval_args_repeat1 = 257,
  aux_sym_tmp_eval_arg_repeat1 = 258,
  aux_sym_eq_sep_key_repeat1 = 259,
  aux_sym_eq_sep_val_repeat1 = 260,
  aux_sym_double_quoted_arg_repeat1 = 261,
  aux_sym_single_quoted_arg_repeat1 = 262,
  aux_sym_concatenation_repeat1 = 263,
  aux_sym_concatenation_brace_repeat1 = 264,
  alias_sym_number = 265,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_legacy_quoted_command_token1] = "legacy_quoted_command_token1",
  [anon_sym_TILDE] = "~",
  [sym_grep_specifier_identifier] = "grep_specifier_identifier",
  [aux_sym_grep_specifier_token1] = "grep_specifier_identifier",
  [anon_sym_PIPE] = "|",
  [anon_sym_PIPEH] = "|H",
  [anon_sym_PIPET] = "|T",
  [sym_pipe_second_command] = "pipe_second_command",
  [anon_sym_AT_AT_AT_EQ] = "@@@=",
  [anon_sym_AT_AT_ATb] = "@@@b",
  [anon_sym_AT_AT_ATc_COLON] = "@@@c:",
  [anon_sym_AT_AT_ATC_COLON] = "@@@C:",
  [anon_sym_AT_AT_ATi] = "@@@i",
  [anon_sym_AT_AT_ATr] = "@@@r",
  [anon_sym_AT_AT_ATs] = "@@@s",
  [anon_sym_AT_AT_ATst] = "@@@st",
  [anon_sym_AT_AT_ATS] = "@@@S",
  [anon_sym_AT_AT_ATm] = "@@@m",
  [anon_sym_AT_AT_ATM] = "@@@M",
  [anon_sym_AT_AT_ATf] = "@@@f",
  [anon_sym_AT_AT_ATf_COLON] = "@@@f:",
  [anon_sym_AT_AT_ATF] = "@@@F",
  [anon_sym_AT_AT_ATF_COLON] = "@@@F:",
  [anon_sym_AT_AT_ATt] = "@@@t",
  [anon_sym_AT_AT] = "@@",
  [anon_sym_AT_ATdbt] = "@@dbt",
  [anon_sym_AT_ATdbta] = "@@dbta",
  [anon_sym_AT_ATdbtb] = "@@dbtb",
  [anon_sym_AT_ATdbts] = "@@dbts",
  [anon_sym_AT_AT_DOT] = "@@.",
  [anon_sym_AT_AT_EQ] = "@@=",
  [anon_sym_AT_ATk] = "@@k",
  [anon_sym_AT_ATt] = "@@t",
  [anon_sym_AT_ATb] = "@@b",
  [anon_sym_AT_ATi] = "@@i",
  [anon_sym_AT_ATiS] = "@@iS",
  [anon_sym_AT_ATf] = "@@f",
  [anon_sym_COLON] = ":",
  [anon_sym_AT_ATs_COLON] = "@@s:",
  [anon_sym_AT_ATc_COLON] = "@@c:",
  [anon_sym_AT] = "@",
  [anon_sym_AT_BANG] = "@!",
  [anon_sym_AT_LBRACE] = "@{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ATa_COLON] = "@a:",
  [anon_sym_ATb_COLON] = "@b:",
  [anon_sym_ATB_COLON] = "@B:",
  [anon_sym_ATe_COLON] = "@e:",
  [anon_sym_ATF_COLON] = "@F:",
  [anon_sym_ATi_COLON] = "@i:",
  [anon_sym_ATk_COLON] = "@k:",
  [anon_sym_ATo_COLON] = "@o:",
  [anon_sym_ATr_COLON] = "@r:",
  [anon_sym_ATf_COLON] = "@f:",
  [anon_sym_ATs_COLON] = "@s:",
  [anon_sym_ATx_COLON] = "@x:",
  [anon_sym_AMP] = "cmd_identifier",
  [anon_sym_AMPt] = "cmd_identifier",
  [aux_sym_task_command_token1] = "cmd_identifier",
  [anon_sym_0] = "0",
  [aux_sym_number_command_token1] = "number_command_token1",
  [aux_sym__search_command_token1] = "cmd_identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_BANG] = "cmd_identifier",
  [anon_sym_DOT_LPAREN] = "cmd_identifier",
  [anon_sym_PIPE_DOT] = "|.",
  [anon_sym_DOT_SLASH] = "./",
  [anon_sym_pfo] = "cmd_identifier",
  [anon_sym_Cf] = "cmd_identifier",
  [sym_pf_dot_cmd_identifier] = "cmd_identifier",
  [sym_pf_dot_full_cmd_identifier] = "cmd_identifier",
  [aux_sym_pf_cmd_token1] = "cmd_identifier",
  [anon_sym_EQ] = "pf_arg_identifier",
  [aux_sym__pf_dot_arg_identifier_token1] = "_pf_dot_arg_identifier_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [aux_sym_pf_arg_identifier_token1] = "pf_arg_identifier_token1",
  [anon_sym_PERCENT] = "%",
  [anon_sym_env] = "env",
  [anon_sym_DOT_DOT_DOT] = "...",
  [aux_sym__interpret_identifier_token1] = "_interpret_identifier_token1",
  [aux_sym__interpret_identifier_token2] = "_interpret_identifier_token2",
  [sym_system_identifier] = "system_identifier",
  [sym_question_mark_identifier] = "cmd_identifier",
  [sym_pointer_identifier] = "cmd_identifier",
  [sym_macro_identifier] = "cmd_identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [sym_html_redirect_operator] = "html_redirect_operator",
  [sym_html_append_operator] = "html_append_operator",
  [anon_sym_COMMA] = ",",
  [aux_sym_tmp_eval_arg_token1] = "tmp_eval_arg_token1",
  [sym__eq_sep_key_identifier] = "arg_identifier",
  [sym__any_command] = "_any_command",
  [aux_sym_arg_identifier_token1] = "arg_identifier_token1",
  [aux_sym_arg_identifier_brace_token1] = "arg_identifier_brace_token1",
  [aux_sym_double_quoted_arg_token1] = "double_quoted_arg_token1",
  [aux_sym_double_quoted_arg_token2] = "double_quoted_arg_token2",
  [aux_sym_double_quoted_arg_token3] = "double_quoted_arg_token3",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_single_quoted_arg_token1] = "single_quoted_arg_token1",
  [aux_sym_single_quoted_arg_token2] = "single_quoted_arg_token2",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [aux_sym__dec_number_token1] = "_dec_number_token1",
  [aux_sym__dec_number_token2] = "_dec_number_token2",
  [sym__comment] = "_comment",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [sym_cmd_identifier] = "cmd_identifier",
  [sym__help_command] = "cmd_identifier",
  [sym_file_descriptor] = "file_descriptor",
  [sym__eq_sep_concat] = "_eq_sep_concat",
  [sym__concat] = "_concat",
  [sym__concat_brace] = "_concat_brace",
  [sym__concat_pf_dot] = "_concat_pf_dot",
  [sym_commands] = "commands",
  [sym__commands_singleline] = "_commands_singleline",
  [sym__command] = "_command",
  [sym_legacy_quoted_command] = "legacy_quoted_command",
  [sym__simple_command] = "_simple_command",
  [sym__tmp_command] = "_tmp_command",
  [sym__iter_command] = "_iter_command",
  [sym__foreach_command] = "_foreach_command",
  [sym__pipe_command] = "_pipe_command",
  [sym_grep_command] = "grep_command",
  [sym_grep_specifier] = "grep_specifier",
  [sym_html_disable_command] = "html_disable_command",
  [sym_html_enable_command] = "html_enable_command",
  [sym_scr_tts_command] = "scr_tts_command",
  [sym_pipe_command] = "pipe_command",
  [sym_foreach_addrsize_command] = "foreach_addrsize_command",
  [sym_foreach_bb_command] = "foreach_bb_command",
  [sym_foreach_cmd_command] = "foreach_cmd_command",
  [sym_foreach_comment_command] = "foreach_comment_command",
  [sym_foreach_import_command] = "foreach_import_command",
  [sym_foreach_register_command] = "foreach_register_command",
  [sym_foreach_symbol_command] = "foreach_symbol_command",
  [sym_foreach_string_command] = "foreach_string_command",
  [sym_foreach_section_command] = "foreach_section_command",
  [sym_foreach_iomap_command] = "foreach_iomap_command",
  [sym_foreach_dbgmap_command] = "foreach_dbgmap_command",
  [sym_foreach_flag_command] = "foreach_flag_command",
  [sym_foreach_function_command] = "foreach_function_command",
  [sym_foreach_thread_command] = "foreach_thread_command",
  [sym_iter_flags_command] = "iter_flags_command",
  [sym_iter_dbta_command] = "iter_dbta_command",
  [sym_iter_dbtb_command] = "iter_dbtb_command",
  [sym_iter_dbts_command] = "iter_dbts_command",
  [sym_iter_file_lines_command] = "iter_file_lines_command",
  [sym_iter_offsets_command] = "iter_offsets_command",
  [sym_iter_sdbquery_command] = "iter_sdbquery_command",
  [sym_iter_threads_command] = "iter_threads_command",
  [sym_iter_bbs_command] = "iter_bbs_command",
  [sym_iter_instrs_command] = "iter_instrs_command",
  [sym_iter_sections_command] = "iter_sections_command",
  [sym_iter_functions_command] = "iter_functions_command",
  [sym_iter_step_command] = "iter_step_command",
  [sym_iter_interpret_command] = "iter_interpret_command",
  [sym_iter_hit_command] = "iter_hit_command",
  [sym_tmp_seek_command] = "tmp_seek_command",
  [sym_tmp_blksz_command] = "tmp_blksz_command",
  [sym_tmp_fromto_command] = "tmp_fromto_command",
  [sym_tmp_arch_command] = "tmp_arch_command",
  [sym_tmp_bits_command] = "tmp_bits_command",
  [sym_tmp_nthi_command] = "tmp_nthi_command",
  [sym_tmp_eval_command] = "tmp_eval_command",
  [sym_tmp_fs_command] = "tmp_fs_command",
  [sym_tmp_reli_command] = "tmp_reli_command",
  [sym_tmp_kuery_command] = "tmp_kuery_command",
  [sym_tmp_fd_command] = "tmp_fd_command",
  [sym_tmp_reg_command] = "tmp_reg_command",
  [sym_tmp_file_command] = "tmp_file_command",
  [sym_tmp_string_command] = "tmp_string_command",
  [sym_tmp_hex_command] = "tmp_hex_command",
  [sym_task_command] = "task_command",
  [sym_number_command] = "number_command",
  [sym_help_command] = "help_command",
  [sym_arged_command] = "arged_command",
  [sym__simple_arged_command] = "_simple_arged_command",
  [sym__search_command] = "arged_command",
  [sym__math_arged_command] = "_math_arged_command",
  [sym__pointer_arged_command] = "_pointer_arged_command",
  [sym__macro_arged_command] = "_macro_arged_command",
  [sym__system_command] = "_system_command",
  [sym__interpret_command] = "_interpret_command",
  [sym__interpret_search_identifier] = "cmd_identifier",
  [sym__pf_arged_command] = "_pf_arged_command",
  [sym__pf_commands] = "_pf_commands",
  [sym_Cf_cmd] = "arged_command",
  [sym__Cf_args] = "args",
  [sym_pf_new_cmd] = "arged_command",
  [sym_pf_dot_cmd] = "arged_command",
  [sym_pf_cmd] = "arged_command",
  [sym_pf_new_args] = "pf_new_args",
  [sym_pf_dot_cmd_args] = "pf_dot_cmd_args",
  [sym__pf_dot_arg_identifier] = "pf_arg_identifier",
  [sym__pf_arg_parentheses] = "_pf_arg_parentheses",
  [sym_pf_arg_identifier] = "pf_arg_identifier",
  [sym__pf_arg] = "_pf_arg",
  [sym__pf_dot_arg] = "_pf_dot_arg",
  [sym_pf_concatenation] = "pf_concatenation",
  [sym_pf_dot_concatenation] = "pf_concatenation",
  [sym_pf_arg] = "pf_arg",
  [sym_pf_dot_arg] = "pf_arg",
  [sym_pf_args] = "pf_args",
  [sym_pf_dot_args] = "pf_args",
  [sym__env_command] = "_env_command",
  [sym__env_command_identifier] = "cmd_identifier",
  [sym_last_command] = "last_command",
  [sym_last_command_identifier] = "cmd_identifier",
  [sym__interpret_identifier] = "cmd_identifier",
  [sym_interpret_arg] = "interpret_arg",
  [sym_repeat_command] = "repeat_command",
  [sym_eq_sep_args] = "args",
  [sym_macro_call_content] = "macro_call_content",
  [sym_macro_call_full_content] = "macro_call_full_content",
  [sym_macro_content] = "macro_content",
  [sym_macro_args] = "macro_args",
  [sym_redirect_command] = "redirect_command",
  [sym__redirect_operator] = "_redirect_operator",
  [sym_fdn_redirect_operator] = "fdn_redirect_operator",
  [sym_fdn_append_operator] = "fdn_append_operator",
  [sym__arg] = "_arg",
  [sym__arg_brace] = "_arg_brace",
  [sym_arg] = "arg",
  [sym_arg_brace] = "arg",
  [sym_args] = "args",
  [sym_tmp_eval_args] = "tmp_eval_args",
  [sym_tmp_eval_arg] = "tmp_eval_arg",
  [sym__eq_sep_key_single] = "arg",
  [sym_eq_sep_key] = "args",
  [sym_eq_sep_val] = "args",
  [sym_arg_identifier] = "arg_identifier",
  [sym_arg_identifier_brace] = "arg_identifier",
  [sym_double_quoted_arg] = "double_quoted_arg",
  [sym_single_quoted_arg] = "single_quoted_arg",
  [sym_cmd_substitution_arg] = "cmd_substitution_arg",
  [sym_concatenation] = "concatenation",
  [sym_concatenation_brace] = "concatenation",
  [sym__dec_number] = "_dec_number",
  [aux_sym_commands_repeat1] = "commands_repeat1",
  [aux_sym_commands_repeat2] = "commands_repeat2",
  [aux_sym__commands_singleline_repeat1] = "_commands_singleline_repeat1",
  [aux_sym__commands_singleline_repeat2] = "_commands_singleline_repeat2",
  [aux_sym_grep_specifier_repeat1] = "grep_specifier_repeat1",
  [aux_sym_foreach_addrsize_command_repeat1] = "foreach_addrsize_command_repeat1",
  [aux_sym_pf_concatenation_repeat1] = "pf_concatenation_repeat1",
  [aux_sym_pf_dot_concatenation_repeat1] = "pf_dot_concatenation_repeat1",
  [aux_sym_pf_args_repeat1] = "pf_args_repeat1",
  [aux_sym_pf_dot_args_repeat1] = "pf_dot_args_repeat1",
  [aux_sym_macro_content_repeat1] = "macro_content_repeat1",
  [aux_sym_args_repeat1] = "args_repeat1",
  [aux_sym_tmp_eval_args_repeat1] = "tmp_eval_args_repeat1",
  [aux_sym_tmp_eval_arg_repeat1] = "tmp_eval_arg_repeat1",
  [aux_sym_eq_sep_key_repeat1] = "eq_sep_key_repeat1",
  [aux_sym_eq_sep_val_repeat1] = "eq_sep_val_repeat1",
  [aux_sym_double_quoted_arg_repeat1] = "double_quoted_arg_repeat1",
  [aux_sym_single_quoted_arg_repeat1] = "single_quoted_arg_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_concatenation_brace_repeat1] = "concatenation_brace_repeat1",
  [alias_sym_number] = "number",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_legacy_quoted_command_token1] = aux_sym_legacy_quoted_command_token1,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_grep_specifier_identifier] = sym_grep_specifier_identifier,
  [aux_sym_grep_specifier_token1] = sym_grep_specifier_identifier,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PIPEH] = anon_sym_PIPEH,
  [anon_sym_PIPET] = anon_sym_PIPET,
  [sym_pipe_second_command] = sym_pipe_second_command,
  [anon_sym_AT_AT_AT_EQ] = anon_sym_AT_AT_AT_EQ,
  [anon_sym_AT_AT_ATb] = anon_sym_AT_AT_ATb,
  [anon_sym_AT_AT_ATc_COLON] = anon_sym_AT_AT_ATc_COLON,
  [anon_sym_AT_AT_ATC_COLON] = anon_sym_AT_AT_ATC_COLON,
  [anon_sym_AT_AT_ATi] = anon_sym_AT_AT_ATi,
  [anon_sym_AT_AT_ATr] = anon_sym_AT_AT_ATr,
  [anon_sym_AT_AT_ATs] = anon_sym_AT_AT_ATs,
  [anon_sym_AT_AT_ATst] = anon_sym_AT_AT_ATst,
  [anon_sym_AT_AT_ATS] = anon_sym_AT_AT_ATS,
  [anon_sym_AT_AT_ATm] = anon_sym_AT_AT_ATm,
  [anon_sym_AT_AT_ATM] = anon_sym_AT_AT_ATM,
  [anon_sym_AT_AT_ATf] = anon_sym_AT_AT_ATf,
  [anon_sym_AT_AT_ATf_COLON] = anon_sym_AT_AT_ATf_COLON,
  [anon_sym_AT_AT_ATF] = anon_sym_AT_AT_ATF,
  [anon_sym_AT_AT_ATF_COLON] = anon_sym_AT_AT_ATF_COLON,
  [anon_sym_AT_AT_ATt] = anon_sym_AT_AT_ATt,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [anon_sym_AT_ATdbt] = anon_sym_AT_ATdbt,
  [anon_sym_AT_ATdbta] = anon_sym_AT_ATdbta,
  [anon_sym_AT_ATdbtb] = anon_sym_AT_ATdbtb,
  [anon_sym_AT_ATdbts] = anon_sym_AT_ATdbts,
  [anon_sym_AT_AT_DOT] = anon_sym_AT_AT_DOT,
  [anon_sym_AT_AT_EQ] = anon_sym_AT_AT_EQ,
  [anon_sym_AT_ATk] = anon_sym_AT_ATk,
  [anon_sym_AT_ATt] = anon_sym_AT_ATt,
  [anon_sym_AT_ATb] = anon_sym_AT_ATb,
  [anon_sym_AT_ATi] = anon_sym_AT_ATi,
  [anon_sym_AT_ATiS] = anon_sym_AT_ATiS,
  [anon_sym_AT_ATf] = anon_sym_AT_ATf,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT_ATs_COLON] = anon_sym_AT_ATs_COLON,
  [anon_sym_AT_ATc_COLON] = anon_sym_AT_ATc_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_AT_BANG] = anon_sym_AT_BANG,
  [anon_sym_AT_LBRACE] = anon_sym_AT_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ATa_COLON] = anon_sym_ATa_COLON,
  [anon_sym_ATb_COLON] = anon_sym_ATb_COLON,
  [anon_sym_ATB_COLON] = anon_sym_ATB_COLON,
  [anon_sym_ATe_COLON] = anon_sym_ATe_COLON,
  [anon_sym_ATF_COLON] = anon_sym_ATF_COLON,
  [anon_sym_ATi_COLON] = anon_sym_ATi_COLON,
  [anon_sym_ATk_COLON] = anon_sym_ATk_COLON,
  [anon_sym_ATo_COLON] = anon_sym_ATo_COLON,
  [anon_sym_ATr_COLON] = anon_sym_ATr_COLON,
  [anon_sym_ATf_COLON] = anon_sym_ATf_COLON,
  [anon_sym_ATs_COLON] = anon_sym_ATs_COLON,
  [anon_sym_ATx_COLON] = anon_sym_ATx_COLON,
  [anon_sym_AMP] = sym_cmd_identifier,
  [anon_sym_AMPt] = sym_cmd_identifier,
  [aux_sym_task_command_token1] = sym_cmd_identifier,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_number_command_token1] = aux_sym_number_command_token1,
  [aux_sym__search_command_token1] = sym_cmd_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_BANG] = sym_cmd_identifier,
  [anon_sym_DOT_LPAREN] = sym_cmd_identifier,
  [anon_sym_PIPE_DOT] = anon_sym_PIPE_DOT,
  [anon_sym_DOT_SLASH] = anon_sym_DOT_SLASH,
  [anon_sym_pfo] = sym_cmd_identifier,
  [anon_sym_Cf] = sym_cmd_identifier,
  [sym_pf_dot_cmd_identifier] = sym_cmd_identifier,
  [sym_pf_dot_full_cmd_identifier] = sym_cmd_identifier,
  [aux_sym_pf_cmd_token1] = sym_cmd_identifier,
  [anon_sym_EQ] = sym_pf_arg_identifier,
  [aux_sym__pf_dot_arg_identifier_token1] = aux_sym__pf_dot_arg_identifier_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_pf_arg_identifier_token1] = aux_sym_pf_arg_identifier_token1,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_env] = anon_sym_env,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [aux_sym__interpret_identifier_token1] = aux_sym__interpret_identifier_token1,
  [aux_sym__interpret_identifier_token2] = aux_sym__interpret_identifier_token2,
  [sym_system_identifier] = sym_system_identifier,
  [sym_question_mark_identifier] = sym_cmd_identifier,
  [sym_pointer_identifier] = sym_cmd_identifier,
  [sym_macro_identifier] = sym_cmd_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [sym_html_redirect_operator] = sym_html_redirect_operator,
  [sym_html_append_operator] = sym_html_append_operator,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [aux_sym_tmp_eval_arg_token1] = aux_sym_tmp_eval_arg_token1,
  [sym__eq_sep_key_identifier] = sym_arg_identifier,
  [sym__any_command] = sym__any_command,
  [aux_sym_arg_identifier_token1] = aux_sym_arg_identifier_token1,
  [aux_sym_arg_identifier_brace_token1] = aux_sym_arg_identifier_brace_token1,
  [aux_sym_double_quoted_arg_token1] = aux_sym_double_quoted_arg_token1,
  [aux_sym_double_quoted_arg_token2] = aux_sym_double_quoted_arg_token2,
  [aux_sym_double_quoted_arg_token3] = aux_sym_double_quoted_arg_token3,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_single_quoted_arg_token1] = aux_sym_single_quoted_arg_token1,
  [aux_sym_single_quoted_arg_token2] = aux_sym_single_quoted_arg_token2,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym__dec_number_token1] = aux_sym__dec_number_token1,
  [aux_sym__dec_number_token2] = aux_sym__dec_number_token2,
  [sym__comment] = sym__comment,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [sym_cmd_identifier] = sym_cmd_identifier,
  [sym__help_command] = sym_cmd_identifier,
  [sym_file_descriptor] = sym_file_descriptor,
  [sym__eq_sep_concat] = sym__eq_sep_concat,
  [sym__concat] = sym__concat,
  [sym__concat_brace] = sym__concat_brace,
  [sym__concat_pf_dot] = sym__concat_pf_dot,
  [sym_commands] = sym_commands,
  [sym__commands_singleline] = sym__commands_singleline,
  [sym__command] = sym__command,
  [sym_legacy_quoted_command] = sym_legacy_quoted_command,
  [sym__simple_command] = sym__simple_command,
  [sym__tmp_command] = sym__tmp_command,
  [sym__iter_command] = sym__iter_command,
  [sym__foreach_command] = sym__foreach_command,
  [sym__pipe_command] = sym__pipe_command,
  [sym_grep_command] = sym_grep_command,
  [sym_grep_specifier] = sym_grep_specifier,
  [sym_html_disable_command] = sym_html_disable_command,
  [sym_html_enable_command] = sym_html_enable_command,
  [sym_scr_tts_command] = sym_scr_tts_command,
  [sym_pipe_command] = sym_pipe_command,
  [sym_foreach_addrsize_command] = sym_foreach_addrsize_command,
  [sym_foreach_bb_command] = sym_foreach_bb_command,
  [sym_foreach_cmd_command] = sym_foreach_cmd_command,
  [sym_foreach_comment_command] = sym_foreach_comment_command,
  [sym_foreach_import_command] = sym_foreach_import_command,
  [sym_foreach_register_command] = sym_foreach_register_command,
  [sym_foreach_symbol_command] = sym_foreach_symbol_command,
  [sym_foreach_string_command] = sym_foreach_string_command,
  [sym_foreach_section_command] = sym_foreach_section_command,
  [sym_foreach_iomap_command] = sym_foreach_iomap_command,
  [sym_foreach_dbgmap_command] = sym_foreach_dbgmap_command,
  [sym_foreach_flag_command] = sym_foreach_flag_command,
  [sym_foreach_function_command] = sym_foreach_function_command,
  [sym_foreach_thread_command] = sym_foreach_thread_command,
  [sym_iter_flags_command] = sym_iter_flags_command,
  [sym_iter_dbta_command] = sym_iter_dbta_command,
  [sym_iter_dbtb_command] = sym_iter_dbtb_command,
  [sym_iter_dbts_command] = sym_iter_dbts_command,
  [sym_iter_file_lines_command] = sym_iter_file_lines_command,
  [sym_iter_offsets_command] = sym_iter_offsets_command,
  [sym_iter_sdbquery_command] = sym_iter_sdbquery_command,
  [sym_iter_threads_command] = sym_iter_threads_command,
  [sym_iter_bbs_command] = sym_iter_bbs_command,
  [sym_iter_instrs_command] = sym_iter_instrs_command,
  [sym_iter_sections_command] = sym_iter_sections_command,
  [sym_iter_functions_command] = sym_iter_functions_command,
  [sym_iter_step_command] = sym_iter_step_command,
  [sym_iter_interpret_command] = sym_iter_interpret_command,
  [sym_iter_hit_command] = sym_iter_hit_command,
  [sym_tmp_seek_command] = sym_tmp_seek_command,
  [sym_tmp_blksz_command] = sym_tmp_blksz_command,
  [sym_tmp_fromto_command] = sym_tmp_fromto_command,
  [sym_tmp_arch_command] = sym_tmp_arch_command,
  [sym_tmp_bits_command] = sym_tmp_bits_command,
  [sym_tmp_nthi_command] = sym_tmp_nthi_command,
  [sym_tmp_eval_command] = sym_tmp_eval_command,
  [sym_tmp_fs_command] = sym_tmp_fs_command,
  [sym_tmp_reli_command] = sym_tmp_reli_command,
  [sym_tmp_kuery_command] = sym_tmp_kuery_command,
  [sym_tmp_fd_command] = sym_tmp_fd_command,
  [sym_tmp_reg_command] = sym_tmp_reg_command,
  [sym_tmp_file_command] = sym_tmp_file_command,
  [sym_tmp_string_command] = sym_tmp_string_command,
  [sym_tmp_hex_command] = sym_tmp_hex_command,
  [sym_task_command] = sym_task_command,
  [sym_number_command] = sym_number_command,
  [sym_help_command] = sym_help_command,
  [sym_arged_command] = sym_arged_command,
  [sym__simple_arged_command] = sym__simple_arged_command,
  [sym__search_command] = sym_arged_command,
  [sym__math_arged_command] = sym__math_arged_command,
  [sym__pointer_arged_command] = sym__pointer_arged_command,
  [sym__macro_arged_command] = sym__macro_arged_command,
  [sym__system_command] = sym__system_command,
  [sym__interpret_command] = sym__interpret_command,
  [sym__interpret_search_identifier] = sym_cmd_identifier,
  [sym__pf_arged_command] = sym__pf_arged_command,
  [sym__pf_commands] = sym__pf_commands,
  [sym_Cf_cmd] = sym_arged_command,
  [sym__Cf_args] = sym_args,
  [sym_pf_new_cmd] = sym_arged_command,
  [sym_pf_dot_cmd] = sym_arged_command,
  [sym_pf_cmd] = sym_arged_command,
  [sym_pf_new_args] = sym_pf_new_args,
  [sym_pf_dot_cmd_args] = sym_pf_dot_cmd_args,
  [sym__pf_dot_arg_identifier] = sym_pf_arg_identifier,
  [sym__pf_arg_parentheses] = sym__pf_arg_parentheses,
  [sym_pf_arg_identifier] = sym_pf_arg_identifier,
  [sym__pf_arg] = sym__pf_arg,
  [sym__pf_dot_arg] = sym__pf_dot_arg,
  [sym_pf_concatenation] = sym_pf_concatenation,
  [sym_pf_dot_concatenation] = sym_pf_concatenation,
  [sym_pf_arg] = sym_pf_arg,
  [sym_pf_dot_arg] = sym_pf_arg,
  [sym_pf_args] = sym_pf_args,
  [sym_pf_dot_args] = sym_pf_args,
  [sym__env_command] = sym__env_command,
  [sym__env_command_identifier] = sym_cmd_identifier,
  [sym_last_command] = sym_last_command,
  [sym_last_command_identifier] = sym_cmd_identifier,
  [sym__interpret_identifier] = sym_cmd_identifier,
  [sym_interpret_arg] = sym_interpret_arg,
  [sym_repeat_command] = sym_repeat_command,
  [sym_eq_sep_args] = sym_args,
  [sym_macro_call_content] = sym_macro_call_content,
  [sym_macro_call_full_content] = sym_macro_call_full_content,
  [sym_macro_content] = sym_macro_content,
  [sym_macro_args] = sym_macro_args,
  [sym_redirect_command] = sym_redirect_command,
  [sym__redirect_operator] = sym__redirect_operator,
  [sym_fdn_redirect_operator] = sym_fdn_redirect_operator,
  [sym_fdn_append_operator] = sym_fdn_append_operator,
  [sym__arg] = sym__arg,
  [sym__arg_brace] = sym__arg_brace,
  [sym_arg] = sym_arg,
  [sym_arg_brace] = sym_arg,
  [sym_args] = sym_args,
  [sym_tmp_eval_args] = sym_tmp_eval_args,
  [sym_tmp_eval_arg] = sym_tmp_eval_arg,
  [sym__eq_sep_key_single] = sym_arg,
  [sym_eq_sep_key] = sym_args,
  [sym_eq_sep_val] = sym_args,
  [sym_arg_identifier] = sym_arg_identifier,
  [sym_arg_identifier_brace] = sym_arg_identifier,
  [sym_double_quoted_arg] = sym_double_quoted_arg,
  [sym_single_quoted_arg] = sym_single_quoted_arg,
  [sym_cmd_substitution_arg] = sym_cmd_substitution_arg,
  [sym_concatenation] = sym_concatenation,
  [sym_concatenation_brace] = sym_concatenation,
  [sym__dec_number] = sym__dec_number,
  [aux_sym_commands_repeat1] = aux_sym_commands_repeat1,
  [aux_sym_commands_repeat2] = aux_sym_commands_repeat2,
  [aux_sym__commands_singleline_repeat1] = aux_sym__commands_singleline_repeat1,
  [aux_sym__commands_singleline_repeat2] = aux_sym__commands_singleline_repeat2,
  [aux_sym_grep_specifier_repeat1] = aux_sym_grep_specifier_repeat1,
  [aux_sym_foreach_addrsize_command_repeat1] = aux_sym_foreach_addrsize_command_repeat1,
  [aux_sym_pf_concatenation_repeat1] = aux_sym_pf_concatenation_repeat1,
  [aux_sym_pf_dot_concatenation_repeat1] = aux_sym_pf_dot_concatenation_repeat1,
  [aux_sym_pf_args_repeat1] = aux_sym_pf_args_repeat1,
  [aux_sym_pf_dot_args_repeat1] = aux_sym_pf_dot_args_repeat1,
  [aux_sym_macro_content_repeat1] = aux_sym_macro_content_repeat1,
  [aux_sym_args_repeat1] = aux_sym_args_repeat1,
  [aux_sym_tmp_eval_args_repeat1] = aux_sym_tmp_eval_args_repeat1,
  [aux_sym_tmp_eval_arg_repeat1] = aux_sym_tmp_eval_arg_repeat1,
  [aux_sym_eq_sep_key_repeat1] = aux_sym_eq_sep_key_repeat1,
  [aux_sym_eq_sep_val_repeat1] = aux_sym_eq_sep_val_repeat1,
  [aux_sym_double_quoted_arg_repeat1] = aux_sym_double_quoted_arg_repeat1,
  [aux_sym_single_quoted_arg_repeat1] = aux_sym_single_quoted_arg_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_concatenation_brace_repeat1] = aux_sym_concatenation_brace_repeat1,
  [alias_sym_number] = alias_sym_number,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_legacy_quoted_command_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_grep_specifier_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_grep_specifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPEH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPET] = {
    .visible = true,
    .named = false,
  },
  [sym_pipe_second_command] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT_AT_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATc_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATC_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATf_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATF_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbta] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbtb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATk] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATiS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATs_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATc_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATa_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATb_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATB_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATe_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATF_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATi_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATk_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATo_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATr_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATf_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATs_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATx_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMPt] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_task_command_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_number_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__search_command_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_BANG] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pfo] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Cf] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_cmd_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_full_cmd_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_pf_cmd_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__pf_dot_arg_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pf_arg_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_env] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__interpret_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpret_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_system_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_question_mark_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_html_redirect_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_html_append_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_tmp_eval_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__eq_sep_key_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__any_command] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_arg_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arg_identifier_brace_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_quoted_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quoted_arg_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__dec_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__dec_number_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [sym_cmd_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__help_command] = {
    .visible = true,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__eq_sep_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_pf_dot] = {
    .visible = false,
    .named = true,
  },
  [sym_commands] = {
    .visible = true,
    .named = true,
  },
  [sym__commands_singleline] = {
    .visible = false,
    .named = true,
  },
  [sym__command] = {
    .visible = false,
    .named = true,
  },
  [sym_legacy_quoted_command] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_command] = {
    .visible = false,
    .named = true,
  },
  [sym__tmp_command] = {
    .visible = false,
    .named = true,
  },
  [sym__iter_command] = {
    .visible = false,
    .named = true,
  },
  [sym__foreach_command] = {
    .visible = false,
    .named = true,
  },
  [sym__pipe_command] = {
    .visible = false,
    .named = true,
  },
  [sym_grep_command] = {
    .visible = true,
    .named = true,
  },
  [sym_grep_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_html_disable_command] = {
    .visible = true,
    .named = true,
  },
  [sym_html_enable_command] = {
    .visible = true,
    .named = true,
  },
  [sym_scr_tts_command] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_addrsize_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_bb_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_cmd_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_comment_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_import_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_register_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_symbol_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_string_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_section_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_iomap_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_dbgmap_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_flag_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_thread_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_flags_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_dbta_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_dbtb_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_dbts_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_file_lines_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_offsets_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_sdbquery_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_threads_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_bbs_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_instrs_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_sections_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_functions_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_step_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_interpret_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_hit_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_seek_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_blksz_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_fromto_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_arch_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_bits_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_nthi_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_eval_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_fs_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_reli_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_kuery_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_fd_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_reg_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_file_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_string_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_hex_command] = {
    .visible = true,
    .named = true,
  },
  [sym_task_command] = {
    .visible = true,
    .named = true,
  },
  [sym_number_command] = {
    .visible = true,
    .named = true,
  },
  [sym_help_command] = {
    .visible = true,
    .named = true,
  },
  [sym_arged_command] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__search_command] = {
    .visible = true,
    .named = true,
  },
  [sym__math_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__pointer_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__macro_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__system_command] = {
    .visible = false,
    .named = true,
  },
  [sym__interpret_command] = {
    .visible = false,
    .named = true,
  },
  [sym__interpret_search_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__pf_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__pf_commands] = {
    .visible = false,
    .named = true,
  },
  [sym_Cf_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym__Cf_args] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_new_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_new_args] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_cmd_args] = {
    .visible = true,
    .named = true,
  },
  [sym__pf_dot_arg_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__pf_arg_parentheses] = {
    .visible = false,
    .named = true,
  },
  [sym_pf_arg_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__pf_arg] = {
    .visible = false,
    .named = true,
  },
  [sym__pf_dot_arg] = {
    .visible = false,
    .named = true,
  },
  [sym_pf_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_args] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_args] = {
    .visible = true,
    .named = true,
  },
  [sym__env_command] = {
    .visible = false,
    .named = true,
  },
  [sym__env_command_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_last_command] = {
    .visible = true,
    .named = true,
  },
  [sym_last_command_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__interpret_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interpret_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_command] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_sep_args] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_call_content] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_call_full_content] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_content] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_args] = {
    .visible = true,
    .named = true,
  },
  [sym_redirect_command] = {
    .visible = true,
    .named = true,
  },
  [sym__redirect_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_fdn_redirect_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_fdn_append_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__arg] = {
    .visible = false,
    .named = true,
  },
  [sym__arg_brace] = {
    .visible = false,
    .named = true,
  },
  [sym_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_brace] = {
    .visible = true,
    .named = true,
  },
  [sym_args] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_eval_args] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_eval_arg] = {
    .visible = true,
    .named = true,
  },
  [sym__eq_sep_key_single] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_sep_key] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_sep_val] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_identifier_brace] = {
    .visible = true,
    .named = true,
  },
  [sym_double_quoted_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quoted_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_cmd_substitution_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation_brace] = {
    .visible = true,
    .named = true,
  },
  [sym__dec_number] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_commands_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_commands_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__commands_singleline_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__commands_singleline_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grep_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_foreach_addrsize_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_dot_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_dot_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macro_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tmp_eval_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tmp_eval_arg_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_eq_sep_key_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_eq_sep_val_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quoted_arg_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_brace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_number] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_arg = 1,
  field_args = 2,
  field_command = 3,
  field_name = 4,
  field_redirect_operator = 5,
  field_specifier = 6,
  field_string = 7,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_args] = "args",
  [field_command] = "command",
  [field_name] = "name",
  [field_redirect_operator] = "redirect_operator",
  [field_specifier] = "specifier",
  [field_string] = "string",
};

static const TSFieldMapSlice ts_field_map_slices[18] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 0, .length = 1},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 2},
  [8] = {.index = 7, .length = 2},
  [9] = {.index = 9, .length = 1},
  [10] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 3},
  [17] = {.index = 18, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_command, 0},
  [1] =
    {field_args, 0, .inherited = true},
    {field_command, 0, .inherited = true},
  [3] =
    {field_args, 1},
    {field_command, 0},
  [5] =
    {field_args, 0},
    {field_command, 1},
  [7] =
    {field_arg, 0},
    {field_command, 1},
  [9] =
    {field_string, 1},
  [10] =
    {field_args, 2},
    {field_command, 0},
  [12] =
    {field_name, 0},
  [13] =
    {field_command, 0},
    {field_specifier, 2},
  [15] =
    {field_arg, 2},
    {field_command, 0},
    {field_redirect_operator, 1},
  [18] =
    {field_args, 3, .inherited = true},
    {field_command, 3, .inherited = true},
};

static TSSymbol ts_alias_sequences[18][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = sym_cmd_identifier,
  },
  [4] = {
    [0] = sym_arg_identifier,
  },
  [6] = {
    [0] = sym_cmd_identifier,
  },
  [8] = {
    [0] = alias_sym_number,
  },
  [14] = {
    [0] = sym_arg_identifier,
    [2] = sym_arg_identifier,
  },
  [15] = {
    [0] = sym_pf_arg_identifier,
    [2] = sym_pf_arg_identifier,
  },
  [16] = {
    [1] = sym_arg_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__dec_number, 2,
    sym__dec_number,
    alias_sym_number,
  0,
};

static inline bool sym_grep_specifier_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == '#' ||
    lookahead == '(' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '`' ||
    lookahead == '|';
}

static inline bool sym_grep_specifier_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == '#' ||
    lookahead == '(' ||
    lookahead == ')' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|';
}

static inline bool aux_sym__pf_dot_arg_identifier_token1_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == '.' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool aux_sym__pf_dot_arg_identifier_token1_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == '.' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('|' <= lookahead && lookahead <= '~');
}

static inline bool aux_sym_pf_arg_identifier_token1_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__eq_sep_key_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '\\' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool aux_sym_arg_identifier_token1_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '\\' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool aux_sym_arg_identifier_token1_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool aux_sym_arg_identifier_token1_character_set_4(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('|' <= lookahead && lookahead <= '~');
}

static inline bool aux_sym_arg_identifier_brace_token1_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~');
}

static inline bool sym__comment_character_set_1(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '\\' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__comment_character_set_2(int32_t lookahead) {
  return
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == '#' ||
    lookahead == '(' ||
    lookahead == ')' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|';
}

static inline bool sym__comment_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__comment_character_set_4(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == '.' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__comment_character_set_5(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '\\' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__comment_character_set_6(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__comment_character_set_8(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~');
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(299);
      if (lookahead == '%') ADVANCE(315);
      if (lookahead == '&') ADVANCE(258);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == ',') ADVANCE(336);
      if (lookahead == '.') ADVANCE(271);
      if (lookahead == '/') ADVANCE(265);
      if (lookahead == '0') ADVANCE(261);
      if (lookahead == ':') ADVANCE(221);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '=') ADVANCE(282);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '?') ADVANCE(323);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(339);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '}') ADVANCE(232);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(337);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(363);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(364);
      if (lookahead != 0) ADVANCE(366);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(311);
      if (lookahead != 0) ADVANCE(312);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(313);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(312);
      if (lookahead != 0) ADVANCE(314);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '*') ADVANCE(293);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(292);
      if (lookahead != 0) ADVANCE(294);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(295);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == ',') ADVANCE(336);
      if (lookahead == '/') ADVANCE(357);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(8)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(359);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == '/') ADVANCE(340);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(9)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '\\' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(345);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(297);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ',') ADVANCE(336);
      if (lookahead == '/') ADVANCE(373);
      if (lookahead == '\\') ADVANCE(91);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(10)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(374);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(377);
      if (lookahead == '$') ADVANCE(384);
      if (lookahead == '/') ADVANCE(381);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(378);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(382);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(130);
      if (lookahead == '/') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|') ADVANCE(123);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(296);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '/') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(13)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(309);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(298);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != '.' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '.') ADVANCE(269);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '/') ADVANCE(265);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '/') ADVANCE(338);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(17)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '\\' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(337);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == ')') ADVANCE(302);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(227);
      if (lookahead == 'H') ADVANCE(158);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(135);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(162);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(227);
      if (lookahead == 'H') ADVANCE(158);
      if (lookahead == '`') ADVANCE(398);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(162);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == '/') ADVANCE(392);
      if (lookahead == '\\') ADVANCE(395);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(389);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(393);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(355);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(356);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(402);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(112);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(114);
      END_STATE();
    case 23:
      if (lookahead == '$') ADVANCE(362);
      if (lookahead == '{') ADVANCE(94);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(359);
      END_STATE();
    case 24:
      if (lookahead == '$') ADVANCE(368);
      if (lookahead == '*') ADVANCE(363);
      if (lookahead == '{') ADVANCE(38);
      if (sym__comment_character_set_1(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 25:
      if (lookahead == '$') ADVANCE(304);
      if (lookahead == '{') ADVANCE(95);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(309);
      END_STATE();
    case 26:
      if (lookahead == '$') ADVANCE(306);
      if (lookahead == '*') ADVANCE(311);
      if (lookahead == '{') ADVANCE(42);
      if (sym__comment_character_set_1(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(312);
      END_STATE();
    case 27:
      if (lookahead == '$') ADVANCE(370);
      if (lookahead == '{') ADVANCE(97);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(374);
      END_STATE();
    case 28:
      if (lookahead == '$') ADVANCE(372);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '{') ADVANCE(48);
      if (sym__comment_character_set_1(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 29:
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '{') ADVANCE(98);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(290);
      END_STATE();
    case 30:
      if (lookahead == '$') ADVANCE(287);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '{') ADVANCE(51);
      if (sym__comment_character_set_1(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 31:
      if (lookahead == '(') ADVANCE(396);
      if (lookahead == '{') ADVANCE(96);
      if (lookahead != 0) ADVANCE(345);
      END_STATE();
    case 32:
      if (lookahead == '(') ADVANCE(35);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '{') ADVANCE(45);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 33:
      if (lookahead == '*') ADVANCE(35);
      END_STATE();
    case 34:
      if (lookahead == '*') ADVANCE(34);
      if (lookahead == '/') ADVANCE(401);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == '*') ADVANCE(34);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '*') ADVANCE(36);
      if (lookahead == '/') ADVANCE(403);
      if (lookahead == '}') ADVANCE(364);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 37:
      if (lookahead == '*') ADVANCE(36);
      if (lookahead == '}') ADVANCE(364);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(36);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(35);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 39:
      if (lookahead == '*') ADVANCE(127);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(35);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 40:
      if (lookahead == '*') ADVANCE(40);
      if (lookahead == '/') ADVANCE(404);
      if (lookahead == '}') ADVANCE(312);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(41);
      END_STATE();
    case 41:
      if (lookahead == '*') ADVANCE(40);
      if (lookahead == '}') ADVANCE(312);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(41);
      END_STATE();
    case 42:
      if (lookahead == '*') ADVANCE(40);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(35);
      if (lookahead != 0) ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == '*') ADVANCE(43);
      if (lookahead == '/') ADVANCE(405);
      if (lookahead == '}') ADVANCE(350);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 44:
      if (lookahead == '*') ADVANCE(43);
      if (lookahead == '}') ADVANCE(350);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '*') ADVANCE(43);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(35);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '/') ADVANCE(406);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(47);
      END_STATE();
    case 47:
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(35);
      if (lookahead != 0) ADVANCE(47);
      END_STATE();
    case 49:
      if (lookahead == '*') ADVANCE(49);
      if (lookahead == '/') ADVANCE(407);
      if (lookahead == '}') ADVANCE(292);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == '*') ADVANCE(49);
      if (lookahead == '}') ADVANCE(292);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(35);
      if (lookahead != 0) ADVANCE(50);
      END_STATE();
    case 51:
      if (lookahead == '*') ADVANCE(49);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(35);
      if (lookahead != 0) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == '.') ADVANCE(279);
      END_STATE();
    case 53:
      if (lookahead == ':') ADVANCE(237);
      END_STATE();
    case 54:
      if (lookahead == ':') ADVANCE(241);
      END_STATE();
    case 55:
      if (lookahead == ':') ADVANCE(233);
      END_STATE();
    case 56:
      if (lookahead == ':') ADVANCE(235);
      END_STATE();
    case 57:
      if (lookahead == ':') ADVANCE(239);
      END_STATE();
    case 58:
      if (lookahead == ':') ADVANCE(251);
      END_STATE();
    case 59:
      if (lookahead == ':') ADVANCE(243);
      END_STATE();
    case 60:
      if (lookahead == ':') ADVANCE(245);
      END_STATE();
    case 61:
      if (lookahead == ':') ADVANCE(247);
      END_STATE();
    case 62:
      if (lookahead == ':') ADVANCE(249);
      END_STATE();
    case 63:
      if (lookahead == ':') ADVANCE(253);
      END_STATE();
    case 64:
      if (lookahead == ':') ADVANCE(255);
      END_STATE();
    case 65:
      if (lookahead == ':') ADVANCE(224);
      END_STATE();
    case 66:
      if (lookahead == ':') ADVANCE(222);
      END_STATE();
    case 67:
      if (lookahead == ':') ADVANCE(169);
      END_STATE();
    case 68:
      if (lookahead == ':') ADVANCE(167);
      END_STATE();
    case 69:
      if (lookahead == '=') ADVANCE(163);
      if (lookahead == 'C') ADVANCE(67);
      if (lookahead == 'F') ADVANCE(189);
      if (lookahead == 'M') ADVANCE(183);
      if (lookahead == 'S') ADVANCE(179);
      if (lookahead == 'b') ADVANCE(165);
      if (lookahead == 'c') ADVANCE(68);
      if (lookahead == 'f') ADVANCE(185);
      if (lookahead == 'i') ADVANCE(171);
      if (lookahead == 'm') ADVANCE(181);
      if (lookahead == 'r') ADVANCE(173);
      if (lookahead == 's') ADVANCE(175);
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 70:
      if (lookahead == '>') ADVANCE(332);
      END_STATE();
    case 71:
      if (lookahead == 'b') ADVANCE(75);
      END_STATE();
    case 72:
      if (lookahead == 'f') ADVANCE(277);
      END_STATE();
    case 73:
      if (lookahead == 'f') ADVANCE(280);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 76:
      if (lookahead == 'v') ADVANCE(316);
      END_STATE();
    case 77:
      if (lookahead == '{') ADVANCE(96);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(345);
      END_STATE();
    case 78:
      if (lookahead == '}') ADVANCE(359);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(78);
      END_STATE();
    case 79:
      if (lookahead == '}') ADVANCE(309);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(79);
      END_STATE();
    case 80:
      if (lookahead == '}') ADVANCE(345);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(80);
      END_STATE();
    case 81:
      if (lookahead == '}') ADVANCE(374);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(81);
      END_STATE();
    case 82:
      if (lookahead == '}') ADVANCE(290);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(82);
      END_STATE();
    case 83:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(263);
      END_STATE();
    case 84:
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(359);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(360);
      END_STATE();
    case 85:
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(309);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(310);
      END_STATE();
    case 86:
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(290);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(289);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(264);
      END_STATE();
    case 88:
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 89:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(359);
      END_STATE();
    case 90:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(309);
      END_STATE();
    case 91:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(374);
      END_STATE();
    case 92:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(290);
      END_STATE();
    case 93:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(111);
      if (lookahead == '*') ADVANCE(110);
      END_STATE();
    case 94:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(78);
      END_STATE();
    case 95:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(79);
      END_STATE();
    case 96:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(80);
      END_STATE();
    case 97:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(81);
      END_STATE();
    case 98:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(82);
      END_STATE();
    case 99:
      if (!sym_grep_specifier_identifier_character_set_1(lookahead)) ADVANCE(123);
      END_STATE();
    case 100:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '!') ADVANCE(322);
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '%') ADVANCE(315);
      if (lookahead == '&') ADVANCE(257);
      if (lookahead == '(') ADVANCE(326);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '*') ADVANCE(324);
      if (lookahead == ',') ADVANCE(336);
      if (lookahead == '.') ADVANCE(270);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == '0') ADVANCE(262);
      if (lookahead == ':') ADVANCE(221);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '=') ADVANCE(282);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '?') ADVANCE(323);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'C') ADVANCE(72);
      if (lookahead == 'H') ADVANCE(70);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == 'e') ADVANCE(74);
      if (lookahead == 'p') ADVANCE(73);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '}') ADVANCE(232);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(100)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 101:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(295);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == ',') ADVANCE(336);
      if (lookahead == '/') ADVANCE(357);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(358);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(101)
      if (lookahead != 0) ADVANCE(359);
      END_STATE();
    case 102:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(31);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == '\'') ADVANCE(387);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '/') ADVANCE(340);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(342);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(102)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ',' &&
          lookahead != '=' &&
          lookahead != '\\') ADVANCE(345);
      END_STATE();
    case 103:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(130);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '/') ADVANCE(121);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(122);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(119);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(123);
      END_STATE();
    case 104:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(296);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '/') ADVANCE(307);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '=') ADVANCE(283);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(308);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(104)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'') ADVANCE(309);
      END_STATE();
    case 105:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '$') ADVANCE(296);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == '/') ADVANCE(307);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(308);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(105)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'') ADVANCE(309);
      END_STATE();
    case 106:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '#') ADVANCE(408);
      if (lookahead == '(') ADVANCE(300);
      if (lookahead == ')') ADVANCE(301);
      if (lookahead == ',') ADVANCE(336);
      if (lookahead == '/') ADVANCE(338);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(328);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == 'H') ADVANCE(339);
      if (lookahead == '`') ADVANCE(397);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(106)
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(337);
      END_STATE();
    case 107:
      if (eof) ADVANCE(108);
      if (lookahead == '\n') ADVANCE(410);
      if (lookahead == '\r') ADVANCE(411);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(327);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(227);
      if (lookahead == 'H') ADVANCE(158);
      if (lookahead == '|') ADVANCE(132);
      if (lookahead == '~') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(137);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '"') ADVANCE(35);
      if (lookahead == '*') ADVANCE(110);
      if (lookahead == '/') ADVANCE(401);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '"') ADVANCE(35);
      if (lookahead == '*') ADVANCE(110);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '#') ADVANCE(402);
      if (lookahead == '/') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(112);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(114);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '*') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(114);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(114);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '$') ADVANCE(99);
      if (lookahead == '\\') ADVANCE(125);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(123);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '$') ADVANCE(129);
      if (lookahead == '*') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(118);
      if (lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(128);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(130);
      if (lookahead == '/') ADVANCE(121);
      if (lookahead == 'H') ADVANCE(122);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '~') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(119);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(123);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(130);
      if (lookahead == '/') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(120);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(123);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(99);
      if (lookahead == '*') ADVANCE(128);
      if (lookahead == '\\') ADVANCE(125);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(123);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(99);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|') ADVANCE(123);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(99);
      if (lookahead == '\\') ADVANCE(125);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == ')' ||
          lookahead == '@') ADVANCE(123);
      if (!sym_grep_specifier_identifier_character_set_1(lookahead)) ADVANCE(123);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(123);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(131);
      if (lookahead == '\\') ADVANCE(125);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(123);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '*') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(118);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(39);
      if (lookahead == '*') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(118);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(129);
      if (lookahead == '*') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(118);
      if (lookahead == ')' ||
          lookahead == '@') ADVANCE(128);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(35);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_grep_specifier_token1);
      if (lookahead == '$') ADVANCE(126);
      if (lookahead == '(') ADVANCE(396);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '#' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '`' &&
          lookahead != '|') ADVANCE(123);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_grep_specifier_token1);
      if (lookahead == '$') ADVANCE(126);
      if (!sym_grep_specifier_identifier_character_set_1(lookahead)) ADVANCE(123);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '.') ADVANCE(274);
      if (lookahead == 'H') ADVANCE(133);
      if (lookahead == 'T') ADVANCE(134);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PIPEH);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPET);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == ')') ADVANCE(302);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(227);
      if (lookahead == 'H') ADVANCE(158);
      if (lookahead == '~') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(135);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(227);
      if (lookahead == 'H') ADVANCE(158);
      if (lookahead == '`') ADVANCE(398);
      if (lookahead == '~') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '#') ADVANCE(161);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(227);
      if (lookahead == 'H') ADVANCE(158);
      if (lookahead == '~') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '*') ADVANCE(139);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|') ADVANCE(35);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '*') ADVANCE(139);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|') ADVANCE(35);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(242);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(234);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(236);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(240);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(252);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(244);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(246);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(250);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(254);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(256);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '=') ADVANCE(164);
      if (lookahead == 'C') ADVANCE(155);
      if (lookahead == 'F') ADVANCE(190);
      if (lookahead == 'M') ADVANCE(184);
      if (lookahead == 'S') ADVANCE(180);
      if (lookahead == 'b') ADVANCE(166);
      if (lookahead == 'c') ADVANCE(156);
      if (lookahead == 'f') ADVANCE(186);
      if (lookahead == 'i') ADVANCE(172);
      if (lookahead == 'm') ADVANCE(182);
      if (lookahead == 'r') ADVANCE(174);
      if (lookahead == 's') ADVANCE(176);
      if (lookahead == 't') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '>') ADVANCE(333);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == 'b') ADVANCE(160);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == 't') ADVANCE(198);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ';' ||
          lookahead == '|') ADVANCE(408);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_AT_AT_AT_EQ);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_AT_AT_AT_EQ);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATb);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATb);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATc_COLON);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATc_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATC_COLON);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATC_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATi);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATi);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATr);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATr);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATs);
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATs);
      if (lookahead == 't') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATst);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATst);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATS);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATS);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATm);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATm);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATM);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATM);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf);
      if (lookahead == ':') ADVANCE(187);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf);
      if (lookahead == ':') ADVANCE(188);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf_COLON);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF);
      if (lookahead == ':') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF_COLON);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATt);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATt);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      if (lookahead == '.') ADVANCE(205);
      if (lookahead == '=') ADVANCE(207);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == 'b') ADVANCE(213);
      if (lookahead == 'c') ADVANCE(65);
      if (lookahead == 'd') ADVANCE(71);
      if (lookahead == 'f') ADVANCE(219);
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'k') ADVANCE(209);
      if (lookahead == 's') ADVANCE(66);
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      if (lookahead == '.') ADVANCE(206);
      if (lookahead == '=') ADVANCE(208);
      if (lookahead == '@') ADVANCE(157);
      if (lookahead == 'b') ADVANCE(214);
      if (lookahead == 'c') ADVANCE(153);
      if (lookahead == 'd') ADVANCE(159);
      if (lookahead == 'f') ADVANCE(220);
      if (lookahead == 'i') ADVANCE(216);
      if (lookahead == 'k') ADVANCE(210);
      if (lookahead == 's') ADVANCE(154);
      if (lookahead == 't') ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_AT_ATdbt);
      if (lookahead == 'a') ADVANCE(199);
      if (lookahead == 'b') ADVANCE(201);
      if (lookahead == 's') ADVANCE(203);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_AT_ATdbt);
      if (lookahead == 'a') ADVANCE(200);
      if (lookahead == 'b') ADVANCE(202);
      if (lookahead == 's') ADVANCE(204);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_AT_ATdbta);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_AT_ATdbta);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_AT_ATdbtb);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_AT_ATdbtb);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_AT_ATdbts);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_AT_ATdbts);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_AT_AT_DOT);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_AT_AT_DOT);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_AT_AT_EQ);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_AT_AT_EQ);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_AT_ATk);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_AT_ATk);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_AT_ATt);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_AT_ATt);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AT_ATb);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_AT_ATb);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_AT_ATi);
      if (lookahead == 'S') ADVANCE(217);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_AT_ATi);
      if (lookahead == 'S') ADVANCE(218);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_AT_ATiS);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_AT_ATiS);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_AT_ATf);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_AT_ATf);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_AT_ATs_COLON);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_AT_ATs_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_AT_ATc_COLON);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_AT_ATc_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '!') ADVANCE(228);
      if (lookahead == '@') ADVANCE(195);
      if (lookahead == 'B') ADVANCE(53);
      if (lookahead == 'F') ADVANCE(54);
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == 'i') ADVANCE(59);
      if (lookahead == 'k') ADVANCE(60);
      if (lookahead == 'o') ADVANCE(61);
      if (lookahead == 'r') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 'x') ADVANCE(64);
      if (lookahead == '{') ADVANCE(230);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '!') ADVANCE(229);
      if (lookahead == '@') ADVANCE(196);
      if (lookahead == 'B') ADVANCE(141);
      if (lookahead == 'F') ADVANCE(142);
      if (lookahead == 'a') ADVANCE(143);
      if (lookahead == 'b') ADVANCE(144);
      if (lookahead == 'e') ADVANCE(145);
      if (lookahead == 'f') ADVANCE(146);
      if (lookahead == 'i') ADVANCE(147);
      if (lookahead == 'k') ADVANCE(148);
      if (lookahead == 'o') ADVANCE(149);
      if (lookahead == 'r') ADVANCE(150);
      if (lookahead == 's') ADVANCE(151);
      if (lookahead == 'x') ADVANCE(152);
      if (lookahead == '{') ADVANCE(231);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_AT_BANG);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_AT_BANG);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_ATa_COLON);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_ATa_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_ATb_COLON);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_ATb_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_ATB_COLON);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_ATB_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_ATe_COLON);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_ATe_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_ATF_COLON);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_ATF_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_ATi_COLON);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_ATi_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_ATk_COLON);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_ATk_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_ATo_COLON);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_ATo_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_ATr_COLON);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_ATr_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_ATf_COLON);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_ATf_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_ATs_COLON);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_ATs_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_ATx_COLON);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_ATx_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == 't') ADVANCE(259);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(260);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(260);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_AMPt);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(260);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(aux_sym_task_command_token1);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(260);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_0);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(83);
      if (lookahead == 'x') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(400);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(aux_sym_number_command_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(aux_sym_number_command_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(264);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '*') ADVANCE(267);
      if (lookahead == '!' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(268);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '*') ADVANCE(266);
      if (lookahead == '/') ADVANCE(268);
      if (lookahead == '!' ||
          lookahead == '+' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '*') ADVANCE(266);
      if (lookahead == '!' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '!' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == ' ') ADVANCE(321);
      if (lookahead == '!') ADVANCE(272);
      if (lookahead == '(') ADVANCE(273);
      if (lookahead == '.') ADVANCE(319);
      if (lookahead == '/') ADVANCE(275);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == ':') ADVANCE(320);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '(') ADVANCE(273);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_DOT_BANG);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_DOT_LPAREN);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_PIPE_DOT);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_DOT_SLASH);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_pfo);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_Cf);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_pf_dot_cmd_identifier);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_pf_dot_full_cmd_identifier);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(aux_sym_pf_cmd_token1);
      if (lookahead == '.') ADVANCE(278);
      if (lookahead == 'o') ADVANCE(276);
      if (lookahead == 'v') ADVANCE(52);
      if (lookahead == '*' ||
          lookahead == 'c' ||
          lookahead == 'j' ||
          lookahead == 'q' ||
          lookahead == 's') ADVANCE(281);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_pf_cmd_token1);
      if (lookahead == '.') ADVANCE(279);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(90);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(309);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(284);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '{') ADVANCE(289);
      if (lookahead == '.' ||
          lookahead == '=') ADVANCE(290);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(290);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(284);
      if (lookahead == '\\') ADVANCE(92);
      if (!aux_sym__pf_dot_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(290);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(286);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '{') ADVANCE(294);
      if (lookahead == '.' ||
          lookahead == '=') ADVANCE(292);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(286);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(6);
      if (sym__comment_character_set_4(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '*') ADVANCE(292);
      if (lookahead == '\\') ADVANCE(92);
      if (!aux_sym__pf_dot_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(290);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(86);
      if (lookahead == '}') ADVANCE(290);
      if (aux_sym__pf_dot_arg_identifier_token1_character_set_3(lookahead)) ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(92);
      if (!aux_sym__pf_dot_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '/') ADVANCE(290);
      if (lookahead == '\\') ADVANCE(6);
      if (sym__comment_character_set_4(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '*') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(6);
      if (sym__comment_character_set_4(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '*') ADVANCE(293);
      if (lookahead == '/') ADVANCE(289);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead == '}') ADVANCE(292);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (aux_sym__pf_dot_arg_identifier_token1_character_set_3(lookahead)) ADVANCE(50);
      if (lookahead != 0) ADVANCE(294);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(aux_sym__pf_dot_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(30);
      if (lookahead == '*') ADVANCE(293);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead == '}') ADVANCE(292);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (aux_sym__pf_dot_arg_identifier_token1_character_set_3(lookahead)) ADVANCE(50);
      if (lookahead != 0) ADVANCE(294);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(362);
      if (lookahead == '(') ADVANCE(396);
      if (lookahead == '{') ADVANCE(94);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(359);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(304);
      if (lookahead == '(') ADVANCE(396);
      if (lookahead == '{') ADVANCE(95);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(309);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(370);
      if (lookahead == '(') ADVANCE(396);
      if (lookahead == '{') ADVANCE(97);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(374);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '(') ADVANCE(396);
      if (lookahead == '{') ADVANCE(98);
      if (!aux_sym_arg_identifier_token1_character_set_1(lookahead)) ADVANCE(290);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(') ADVANCE(396);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(303);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == '{') ADVANCE(310);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(309);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(303);
      if (lookahead == '\\') ADVANCE(90);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(309);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(305);
      if (lookahead == '*') ADVANCE(311);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '{') ADVANCE(314);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(312);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(305);
      if (lookahead == '*') ADVANCE(311);
      if (lookahead == '\\') ADVANCE(3);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(312);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead == '\\') ADVANCE(90);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(309);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(309);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(90);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(309);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(85);
      if (lookahead == '}') ADVANCE(309);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(79);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(310);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(26);
      if (lookahead == '*') ADVANCE(311);
      if (lookahead == '/') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(3);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(312);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(26);
      if (lookahead == '*') ADVANCE(311);
      if (lookahead == '\\') ADVANCE(3);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(26);
      if (lookahead == '*') ADVANCE(313);
      if (lookahead == '/') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '}') ADVANCE(312);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(41);
      if (lookahead != 0) ADVANCE(314);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_pf_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(26);
      if (lookahead == '*') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '}') ADVANCE(312);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(41);
      if (lookahead != 0) ADVANCE(314);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_env);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      if (lookahead == ' ') ADVANCE(318);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':') ADVANCE(320);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token1);
      if (lookahead == ' ') ADVANCE(318);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token1);
      if (lookahead == ' ') ADVANCE(318);
      if (lookahead == '.') ADVANCE(317);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == ':') ADVANCE(320);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token1);
      if (lookahead == ' ') ADVANCE(318);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':') ADVANCE(320);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token2);
      if (lookahead == ' ') ADVANCE(321);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_system_identifier);
      if (('!' <= lookahead && lookahead <= '=')) ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_question_mark_identifier);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_pointer_identifier);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_macro_identifier);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_macro_identifier);
      if (lookahead == '*' ||
          lookahead == '-') ADVANCE(325);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(330);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_html_redirect_operator);
      if (lookahead == '>') ADVANCE(334);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_html_redirect_operator);
      if (lookahead == '>') ADVANCE(335);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_html_append_operator);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_html_append_operator);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(aux_sym_tmp_eval_arg_token1);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(aux_sym_tmp_eval_arg_token1);
      if (lookahead == '*') ADVANCE(35);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(aux_sym_tmp_eval_arg_token1);
      if (lookahead == '>') ADVANCE(332);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(77);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == '*') ADVANCE(350);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(345);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(77);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == '5') ADVANCE(343);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(345);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(77);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '@' &&
          lookahead != '\\' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(345);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(77);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == 'C') ADVANCE(344);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(345);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(77);
      if (lookahead == '%') ADVANCE(341);
      if (lookahead == 's') ADVANCE(345);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(345);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(77);
      if (lookahead == '%') ADVANCE(341);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(345);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '/') ADVANCE(345);
      if (sym__comment_character_set_5(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == '5') ADVANCE(348);
      if (sym__comment_character_set_5(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == 'C') ADVANCE(349);
      if (sym__comment_character_set_5(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(346);
      if (lookahead == 's') ADVANCE(350);
      if (sym__comment_character_set_5(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(32);
      if (lookahead == '%') ADVANCE(347);
      if (lookahead == '*') ADVANCE(346);
      if (sym__comment_character_set_5(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(350);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '#') ADVANCE(355);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(356);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '*') ADVANCE(354);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(356);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '*') ADVANCE(353);
      if (lookahead == '/') ADVANCE(356);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(35);
      if (lookahead != 0) ADVANCE(354);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '*') ADVANCE(353);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(35);
      if (lookahead != 0) ADVANCE(354);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(408);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(355);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(356);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '*') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(89);
      if (!aux_sym_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(359);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(359);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '\\') ADVANCE(89);
      if (!aux_sym_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(359);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead == '}') ADVANCE(359);
      if (aux_sym_arg_identifier_token1_character_set_4(lookahead)) ADVANCE(78);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(361);
      if (lookahead == ',') ADVANCE(359);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead == '{') ADVANCE(360);
      if (!aux_sym_pf_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(359);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(361);
      if (lookahead == '\\') ADVANCE(89);
      if (!aux_sym_arg_identifier_token1_character_set_2(lookahead)) ADVANCE(359);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(24);
      if (lookahead == '*') ADVANCE(363);
      if (lookahead == '/') ADVANCE(359);
      if (lookahead == '\\') ADVANCE(1);
      if (sym__comment_character_set_6(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(24);
      if (lookahead == '*') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(1);
      if (sym__comment_character_set_6(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(24);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '/') ADVANCE(360);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '}') ADVANCE(364);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (aux_sym_arg_identifier_token1_character_set_4(lookahead)) ADVANCE(37);
      if (lookahead != 0) ADVANCE(366);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(24);
      if (lookahead == '*') ADVANCE(365);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '}') ADVANCE(364);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (aux_sym_arg_identifier_token1_character_set_4(lookahead)) ADVANCE(37);
      if (lookahead != 0) ADVANCE(366);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(367);
      if (lookahead == '*') ADVANCE(363);
      if (lookahead == ',') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '{') ADVANCE(366);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(aux_sym_arg_identifier_token1);
      if (lookahead == '$') ADVANCE(367);
      if (lookahead == '*') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(1);
      if (sym__comment_character_set_6(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(364);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(369);
      if (lookahead == '\\') ADVANCE(91);
      if (lookahead == '{') ADVANCE(97);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(374);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead)) ADVANCE(374);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(369);
      if (lookahead == '\\') ADVANCE(91);
      if (!aux_sym_arg_identifier_brace_token1_character_set_2(lookahead)) ADVANCE(374);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(371);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '{') ADVANCE(48);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(376);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(35);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(371);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(5);
      if (sym__comment_character_set_8(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(27);
      if (lookahead == '*') ADVANCE(376);
      if (lookahead == '\\') ADVANCE(91);
      if (!aux_sym_arg_identifier_brace_token1_character_set_2(lookahead)) ADVANCE(374);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(27);
      if (lookahead == '\\') ADVANCE(91);
      if (!aux_sym_arg_identifier_brace_token1_character_set_2(lookahead)) ADVANCE(374);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '/') ADVANCE(374);
      if (lookahead == '\\') ADVANCE(5);
      if (sym__comment_character_set_8(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_arg_identifier_brace_token1);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '\\') ADVANCE(5);
      if (sym__comment_character_set_8(lookahead)) ADVANCE(35);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '\r') ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(377);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '#') ADVANCE(377);
      if (lookahead == '/') ADVANCE(381);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(378);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(382);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(379);
      if (lookahead == '/') ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(380);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(379);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(380);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(380);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(382);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(382);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token2);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token2);
      if (lookahead == '(') ADVANCE(396);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(383);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token3);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token3);
      if (lookahead == '\n' ||
          lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '\\' ||
          lookahead == '`') ADVANCE(385);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '\r') ADVANCE(393);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(388);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '/') ADVANCE(392);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(389);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(393);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(390);
      if (lookahead == '/') ADVANCE(393);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(391);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(390);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(391);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(391);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(393);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(393);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token2);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token2);
      if (lookahead == '\n' ||
          lookahead == '\'' ||
          lookahead == '\\') ADVANCE(394);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(162);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym__dec_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(399);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym__dec_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(400);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__comment);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '"') ADVANCE(408);
      if (lookahead == '\\') ADVANCE(409);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(402);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(359);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(78);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(309);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(79);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(345);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(80);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(374);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(81);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(290);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(82);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(408);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(402);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_CR);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 100, .external_lex_state = 2},
  [2] = {.lex_state = 100, .external_lex_state = 3},
  [3] = {.lex_state = 100, .external_lex_state = 3},
  [4] = {.lex_state = 100, .external_lex_state = 3},
  [5] = {.lex_state = 100, .external_lex_state = 3},
  [6] = {.lex_state = 100, .external_lex_state = 3},
  [7] = {.lex_state = 100, .external_lex_state = 3},
  [8] = {.lex_state = 100, .external_lex_state = 2},
  [9] = {.lex_state = 100, .external_lex_state = 2},
  [10] = {.lex_state = 100, .external_lex_state = 2},
  [11] = {.lex_state = 100, .external_lex_state = 2},
  [12] = {.lex_state = 100, .external_lex_state = 2},
  [13] = {.lex_state = 100, .external_lex_state = 2},
  [14] = {.lex_state = 100, .external_lex_state = 2},
  [15] = {.lex_state = 100, .external_lex_state = 2},
  [16] = {.lex_state = 100, .external_lex_state = 2},
  [17] = {.lex_state = 100, .external_lex_state = 2},
  [18] = {.lex_state = 100, .external_lex_state = 2},
  [19] = {.lex_state = 100, .external_lex_state = 2},
  [20] = {.lex_state = 100, .external_lex_state = 2},
  [21] = {.lex_state = 100, .external_lex_state = 2},
  [22] = {.lex_state = 100, .external_lex_state = 2},
  [23] = {.lex_state = 100, .external_lex_state = 2},
  [24] = {.lex_state = 100, .external_lex_state = 2},
  [25] = {.lex_state = 100, .external_lex_state = 2},
  [26] = {.lex_state = 100, .external_lex_state = 2},
  [27] = {.lex_state = 100, .external_lex_state = 2},
  [28] = {.lex_state = 100, .external_lex_state = 2},
  [29] = {.lex_state = 100, .external_lex_state = 2},
  [30] = {.lex_state = 100, .external_lex_state = 2},
  [31] = {.lex_state = 100, .external_lex_state = 2},
  [32] = {.lex_state = 100, .external_lex_state = 2},
  [33] = {.lex_state = 100, .external_lex_state = 2},
  [34] = {.lex_state = 100, .external_lex_state = 2},
  [35] = {.lex_state = 100, .external_lex_state = 2},
  [36] = {.lex_state = 100, .external_lex_state = 2},
  [37] = {.lex_state = 100, .external_lex_state = 2},
  [38] = {.lex_state = 100, .external_lex_state = 2},
  [39] = {.lex_state = 100, .external_lex_state = 2},
  [40] = {.lex_state = 100, .external_lex_state = 2},
  [41] = {.lex_state = 100, .external_lex_state = 2},
  [42] = {.lex_state = 100, .external_lex_state = 2},
  [43] = {.lex_state = 100, .external_lex_state = 2},
  [44] = {.lex_state = 100, .external_lex_state = 2},
  [45] = {.lex_state = 100, .external_lex_state = 2},
  [46] = {.lex_state = 100, .external_lex_state = 2},
  [47] = {.lex_state = 100, .external_lex_state = 2},
  [48] = {.lex_state = 100, .external_lex_state = 2},
  [49] = {.lex_state = 100, .external_lex_state = 2},
  [50] = {.lex_state = 100, .external_lex_state = 2},
  [51] = {.lex_state = 100, .external_lex_state = 2},
  [52] = {.lex_state = 100, .external_lex_state = 2},
  [53] = {.lex_state = 100, .external_lex_state = 3},
  [54] = {.lex_state = 101, .external_lex_state = 4},
  [55] = {.lex_state = 101, .external_lex_state = 4},
  [56] = {.lex_state = 101, .external_lex_state = 4},
  [57] = {.lex_state = 101, .external_lex_state = 4},
  [58] = {.lex_state = 101, .external_lex_state = 4},
  [59] = {.lex_state = 101, .external_lex_state = 4},
  [60] = {.lex_state = 101, .external_lex_state = 4},
  [61] = {.lex_state = 101, .external_lex_state = 4},
  [62] = {.lex_state = 101, .external_lex_state = 4},
  [63] = {.lex_state = 101, .external_lex_state = 4},
  [64] = {.lex_state = 101, .external_lex_state = 4},
  [65] = {.lex_state = 101, .external_lex_state = 4},
  [66] = {.lex_state = 101, .external_lex_state = 4},
  [67] = {.lex_state = 101, .external_lex_state = 4},
  [68] = {.lex_state = 104, .external_lex_state = 5},
  [69] = {.lex_state = 101, .external_lex_state = 4},
  [70] = {.lex_state = 101, .external_lex_state = 4},
  [71] = {.lex_state = 101, .external_lex_state = 4},
  [72] = {.lex_state = 101, .external_lex_state = 4},
  [73] = {.lex_state = 101, .external_lex_state = 4},
  [74] = {.lex_state = 101, .external_lex_state = 4},
  [75] = {.lex_state = 101, .external_lex_state = 4},
  [76] = {.lex_state = 101, .external_lex_state = 4},
  [77] = {.lex_state = 101, .external_lex_state = 4},
  [78] = {.lex_state = 105, .external_lex_state = 4},
  [79] = {.lex_state = 104, .external_lex_state = 5},
  [80] = {.lex_state = 101, .external_lex_state = 4},
  [81] = {.lex_state = 105, .external_lex_state = 4},
  [82] = {.lex_state = 101, .external_lex_state = 4},
  [83] = {.lex_state = 101, .external_lex_state = 4},
  [84] = {.lex_state = 102, .external_lex_state = 4},
  [85] = {.lex_state = 101, .external_lex_state = 6},
  [86] = {.lex_state = 101, .external_lex_state = 6},
  [87] = {.lex_state = 101, .external_lex_state = 6},
  [88] = {.lex_state = 101, .external_lex_state = 6},
  [89] = {.lex_state = 101, .external_lex_state = 6},
  [90] = {.lex_state = 101, .external_lex_state = 6},
  [91] = {.lex_state = 101, .external_lex_state = 6},
  [92] = {.lex_state = 101, .external_lex_state = 6},
  [93] = {.lex_state = 101, .external_lex_state = 6},
  [94] = {.lex_state = 101, .external_lex_state = 6},
  [95] = {.lex_state = 101, .external_lex_state = 6},
  [96] = {.lex_state = 101, .external_lex_state = 6},
  [97] = {.lex_state = 101, .external_lex_state = 6},
  [98] = {.lex_state = 105, .external_lex_state = 4},
  [99] = {.lex_state = 104, .external_lex_state = 5},
  [100] = {.lex_state = 101, .external_lex_state = 4},
  [101] = {.lex_state = 104, .external_lex_state = 5},
  [102] = {.lex_state = 104, .external_lex_state = 5},
  [103] = {.lex_state = 101, .external_lex_state = 4},
  [104] = {.lex_state = 101, .external_lex_state = 4},
  [105] = {.lex_state = 104, .external_lex_state = 5},
  [106] = {.lex_state = 102, .external_lex_state = 4},
  [107] = {.lex_state = 104, .external_lex_state = 5},
  [108] = {.lex_state = 105, .external_lex_state = 6},
  [109] = {.lex_state = 105, .external_lex_state = 6},
  [110] = {.lex_state = 104, .external_lex_state = 5},
  [111] = {.lex_state = 105, .external_lex_state = 6},
  [112] = {.lex_state = 104, .external_lex_state = 5},
  [113] = {.lex_state = 104, .external_lex_state = 5},
  [114] = {.lex_state = 105, .external_lex_state = 6},
  [115] = {.lex_state = 105, .external_lex_state = 6},
  [116] = {.lex_state = 105, .external_lex_state = 6},
  [117] = {.lex_state = 105, .external_lex_state = 6},
  [118] = {.lex_state = 105, .external_lex_state = 6},
  [119] = {.lex_state = 103, .external_lex_state = 4},
  [120] = {.lex_state = 102, .external_lex_state = 4},
  [121] = {.lex_state = 105, .external_lex_state = 4},
  [122] = {.lex_state = 103, .external_lex_state = 4},
  [123] = {.lex_state = 100, .external_lex_state = 5},
  [124] = {.lex_state = 100, .external_lex_state = 7},
  [125] = {.lex_state = 100, .external_lex_state = 5},
  [126] = {.lex_state = 106, .external_lex_state = 4},
  [127] = {.lex_state = 100, .external_lex_state = 5},
  [128] = {.lex_state = 100, .external_lex_state = 8},
  [129] = {.lex_state = 100, .external_lex_state = 7},
  [130] = {.lex_state = 106, .external_lex_state = 4},
  [131] = {.lex_state = 100, .external_lex_state = 5},
  [132] = {.lex_state = 100, .external_lex_state = 7},
  [133] = {.lex_state = 100, .external_lex_state = 8},
  [134] = {.lex_state = 100, .external_lex_state = 5},
  [135] = {.lex_state = 100, .external_lex_state = 5},
  [136] = {.lex_state = 100, .external_lex_state = 8},
  [137] = {.lex_state = 100, .external_lex_state = 7},
  [138] = {.lex_state = 100, .external_lex_state = 7},
  [139] = {.lex_state = 100, .external_lex_state = 6},
  [140] = {.lex_state = 100, .external_lex_state = 4},
  [141] = {.lex_state = 103, .external_lex_state = 4},
  [142] = {.lex_state = 100, .external_lex_state = 8},
  [143] = {.lex_state = 100, .external_lex_state = 8},
  [144] = {.lex_state = 100, .external_lex_state = 7},
  [145] = {.lex_state = 100, .external_lex_state = 7},
  [146] = {.lex_state = 100, .external_lex_state = 6},
  [147] = {.lex_state = 100, .external_lex_state = 8},
  [148] = {.lex_state = 100, .external_lex_state = 8},
  [149] = {.lex_state = 100, .external_lex_state = 5},
  [150] = {.lex_state = 103, .external_lex_state = 4},
  [151] = {.lex_state = 103, .external_lex_state = 4},
  [152] = {.lex_state = 100, .external_lex_state = 7},
  [153] = {.lex_state = 100, .external_lex_state = 5},
  [154] = {.lex_state = 100, .external_lex_state = 8},
  [155] = {.lex_state = 100, .external_lex_state = 8},
  [156] = {.lex_state = 100, .external_lex_state = 4},
  [157] = {.lex_state = 103, .external_lex_state = 4},
  [158] = {.lex_state = 100, .external_lex_state = 7},
  [159] = {.lex_state = 100, .external_lex_state = 5},
  [160] = {.lex_state = 100, .external_lex_state = 8},
  [161] = {.lex_state = 100, .external_lex_state = 8},
  [162] = {.lex_state = 100, .external_lex_state = 5},
  [163] = {.lex_state = 100, .external_lex_state = 5},
  [164] = {.lex_state = 100, .external_lex_state = 7},
  [165] = {.lex_state = 100, .external_lex_state = 7},
  [166] = {.lex_state = 100, .external_lex_state = 8},
  [167] = {.lex_state = 100, .external_lex_state = 7},
  [168] = {.lex_state = 100, .external_lex_state = 8},
  [169] = {.lex_state = 106, .external_lex_state = 4},
  [170] = {.lex_state = 100, .external_lex_state = 6},
  [171] = {.lex_state = 100, .external_lex_state = 4},
  [172] = {.lex_state = 100, .external_lex_state = 7},
  [173] = {.lex_state = 100, .external_lex_state = 7},
  [174] = {.lex_state = 100, .external_lex_state = 5},
  [175] = {.lex_state = 100, .external_lex_state = 6},
  [176] = {.lex_state = 100, .external_lex_state = 6},
  [177] = {.lex_state = 100, .external_lex_state = 4},
  [178] = {.lex_state = 106, .external_lex_state = 4},
  [179] = {.lex_state = 100, .external_lex_state = 6},
  [180] = {.lex_state = 100, .external_lex_state = 7},
  [181] = {.lex_state = 106, .external_lex_state = 4},
  [182] = {.lex_state = 100, .external_lex_state = 4},
  [183] = {.lex_state = 100, .external_lex_state = 4},
  [184] = {.lex_state = 100, .external_lex_state = 7},
  [185] = {.lex_state = 106, .external_lex_state = 4},
  [186] = {.lex_state = 100, .external_lex_state = 6},
  [187] = {.lex_state = 100, .external_lex_state = 6},
  [188] = {.lex_state = 106, .external_lex_state = 4},
  [189] = {.lex_state = 100, .external_lex_state = 6},
  [190] = {.lex_state = 103, .external_lex_state = 4},
  [191] = {.lex_state = 100, .external_lex_state = 6},
  [192] = {.lex_state = 100, .external_lex_state = 6},
  [193] = {.lex_state = 100, .external_lex_state = 6},
  [194] = {.lex_state = 100, .external_lex_state = 4},
  [195] = {.lex_state = 106, .external_lex_state = 4},
  [196] = {.lex_state = 100, .external_lex_state = 6},
  [197] = {.lex_state = 100, .external_lex_state = 4},
  [198] = {.lex_state = 103, .external_lex_state = 4},
  [199] = {.lex_state = 100, .external_lex_state = 4},
  [200] = {.lex_state = 100, .external_lex_state = 4},
  [201] = {.lex_state = 100, .external_lex_state = 4},
  [202] = {.lex_state = 100, .external_lex_state = 4},
  [203] = {.lex_state = 100, .external_lex_state = 4},
  [204] = {.lex_state = 100, .external_lex_state = 4},
  [205] = {.lex_state = 100, .external_lex_state = 4},
  [206] = {.lex_state = 100, .external_lex_state = 4},
  [207] = {.lex_state = 100, .external_lex_state = 4},
  [208] = {.lex_state = 100, .external_lex_state = 4},
  [209] = {.lex_state = 100, .external_lex_state = 4},
  [210] = {.lex_state = 100, .external_lex_state = 4},
  [211] = {.lex_state = 100, .external_lex_state = 4},
  [212] = {.lex_state = 100, .external_lex_state = 4},
  [213] = {.lex_state = 100, .external_lex_state = 4},
  [214] = {.lex_state = 100, .external_lex_state = 4},
  [215] = {.lex_state = 100, .external_lex_state = 4},
  [216] = {.lex_state = 100, .external_lex_state = 4},
  [217] = {.lex_state = 100, .external_lex_state = 4},
  [218] = {.lex_state = 100, .external_lex_state = 4},
  [219] = {.lex_state = 100, .external_lex_state = 4},
  [220] = {.lex_state = 100, .external_lex_state = 4},
  [221] = {.lex_state = 100, .external_lex_state = 4},
  [222] = {.lex_state = 100, .external_lex_state = 4},
  [223] = {.lex_state = 100, .external_lex_state = 4},
  [224] = {.lex_state = 100, .external_lex_state = 4},
  [225] = {.lex_state = 100, .external_lex_state = 4},
  [226] = {.lex_state = 103, .external_lex_state = 4},
  [227] = {.lex_state = 100, .external_lex_state = 4},
  [228] = {.lex_state = 100, .external_lex_state = 4},
  [229] = {.lex_state = 100, .external_lex_state = 5},
  [230] = {.lex_state = 100, .external_lex_state = 4},
  [231] = {.lex_state = 100, .external_lex_state = 4},
  [232] = {.lex_state = 100, .external_lex_state = 4},
  [233] = {.lex_state = 100, .external_lex_state = 4},
  [234] = {.lex_state = 100, .external_lex_state = 4},
  [235] = {.lex_state = 100, .external_lex_state = 4},
  [236] = {.lex_state = 100, .external_lex_state = 4},
  [237] = {.lex_state = 100, .external_lex_state = 4},
  [238] = {.lex_state = 100, .external_lex_state = 4},
  [239] = {.lex_state = 100, .external_lex_state = 4},
  [240] = {.lex_state = 100, .external_lex_state = 4},
  [241] = {.lex_state = 100, .external_lex_state = 4},
  [242] = {.lex_state = 100, .external_lex_state = 4},
  [243] = {.lex_state = 100, .external_lex_state = 4},
  [244] = {.lex_state = 100, .external_lex_state = 4},
  [245] = {.lex_state = 100, .external_lex_state = 4},
  [246] = {.lex_state = 100, .external_lex_state = 4},
  [247] = {.lex_state = 100, .external_lex_state = 4},
  [248] = {.lex_state = 100, .external_lex_state = 4},
  [249] = {.lex_state = 100, .external_lex_state = 4},
  [250] = {.lex_state = 100, .external_lex_state = 4},
  [251] = {.lex_state = 100, .external_lex_state = 4},
  [252] = {.lex_state = 100, .external_lex_state = 4},
  [253] = {.lex_state = 100, .external_lex_state = 4},
  [254] = {.lex_state = 100, .external_lex_state = 4},
  [255] = {.lex_state = 100, .external_lex_state = 4},
  [256] = {.lex_state = 100, .external_lex_state = 4},
  [257] = {.lex_state = 100, .external_lex_state = 4},
  [258] = {.lex_state = 100, .external_lex_state = 4},
  [259] = {.lex_state = 100, .external_lex_state = 4},
  [260] = {.lex_state = 100, .external_lex_state = 4},
  [261] = {.lex_state = 100, .external_lex_state = 4},
  [262] = {.lex_state = 100, .external_lex_state = 4},
  [263] = {.lex_state = 100, .external_lex_state = 4},
  [264] = {.lex_state = 100, .external_lex_state = 4},
  [265] = {.lex_state = 100, .external_lex_state = 4},
  [266] = {.lex_state = 100, .external_lex_state = 4},
  [267] = {.lex_state = 100, .external_lex_state = 4},
  [268] = {.lex_state = 100, .external_lex_state = 4},
  [269] = {.lex_state = 100, .external_lex_state = 4},
  [270] = {.lex_state = 100, .external_lex_state = 4},
  [271] = {.lex_state = 100, .external_lex_state = 4},
  [272] = {.lex_state = 100, .external_lex_state = 4},
  [273] = {.lex_state = 100, .external_lex_state = 4},
  [274] = {.lex_state = 100, .external_lex_state = 4},
  [275] = {.lex_state = 100, .external_lex_state = 4},
  [276] = {.lex_state = 100, .external_lex_state = 4},
  [277] = {.lex_state = 100, .external_lex_state = 4},
  [278] = {.lex_state = 100, .external_lex_state = 4},
  [279] = {.lex_state = 100, .external_lex_state = 4},
  [280] = {.lex_state = 100, .external_lex_state = 4},
  [281] = {.lex_state = 100, .external_lex_state = 4},
  [282] = {.lex_state = 100, .external_lex_state = 4},
  [283] = {.lex_state = 100, .external_lex_state = 4},
  [284] = {.lex_state = 107, .external_lex_state = 4},
  [285] = {.lex_state = 100, .external_lex_state = 4},
  [286] = {.lex_state = 100, .external_lex_state = 4},
  [287] = {.lex_state = 100, .external_lex_state = 4},
  [288] = {.lex_state = 100, .external_lex_state = 4},
  [289] = {.lex_state = 19, .external_lex_state = 4},
  [290] = {.lex_state = 100, .external_lex_state = 5},
  [291] = {.lex_state = 18, .external_lex_state = 4},
  [292] = {.lex_state = 100, .external_lex_state = 4},
  [293] = {.lex_state = 100, .external_lex_state = 4},
  [294] = {.lex_state = 100, .external_lex_state = 4},
  [295] = {.lex_state = 100, .external_lex_state = 2},
  [296] = {.lex_state = 100, .external_lex_state = 2},
  [297] = {.lex_state = 8},
  [298] = {.lex_state = 8},
  [299] = {.lex_state = 8},
  [300] = {.lex_state = 8},
  [301] = {.lex_state = 8},
  [302] = {.lex_state = 8},
  [303] = {.lex_state = 8},
  [304] = {.lex_state = 8},
  [305] = {.lex_state = 8},
  [306] = {.lex_state = 8},
  [307] = {.lex_state = 8},
  [308] = {.lex_state = 8},
  [309] = {.lex_state = 8},
  [310] = {.lex_state = 8},
  [311] = {.lex_state = 8},
  [312] = {.lex_state = 8},
  [313] = {.lex_state = 8},
  [314] = {.lex_state = 8},
  [315] = {.lex_state = 8},
  [316] = {.lex_state = 8},
  [317] = {.lex_state = 8},
  [318] = {.lex_state = 8},
  [319] = {.lex_state = 8},
  [320] = {.lex_state = 8},
  [321] = {.lex_state = 8},
  [322] = {.lex_state = 8},
  [323] = {.lex_state = 8},
  [324] = {.lex_state = 8},
  [325] = {.lex_state = 8, .external_lex_state = 9},
  [326] = {.lex_state = 8, .external_lex_state = 9},
  [327] = {.lex_state = 8},
  [328] = {.lex_state = 8},
  [329] = {.lex_state = 10},
  [330] = {.lex_state = 8},
  [331] = {.lex_state = 8},
  [332] = {.lex_state = 8},
  [333] = {.lex_state = 8},
  [334] = {.lex_state = 8},
  [335] = {.lex_state = 8},
  [336] = {.lex_state = 8},
  [337] = {.lex_state = 8},
  [338] = {.lex_state = 8},
  [339] = {.lex_state = 8},
  [340] = {.lex_state = 8},
  [341] = {.lex_state = 8},
  [342] = {.lex_state = 10},
  [343] = {.lex_state = 8},
  [344] = {.lex_state = 8},
  [345] = {.lex_state = 8},
  [346] = {.lex_state = 8},
  [347] = {.lex_state = 8},
  [348] = {.lex_state = 8},
  [349] = {.lex_state = 13},
  [350] = {.lex_state = 13},
  [351] = {.lex_state = 13},
  [352] = {.lex_state = 8},
  [353] = {.lex_state = 13},
  [354] = {.lex_state = 10},
  [355] = {.lex_state = 10},
  [356] = {.lex_state = 13},
  [357] = {.lex_state = 8},
  [358] = {.lex_state = 10},
  [359] = {.lex_state = 10},
  [360] = {.lex_state = 8},
  [361] = {.lex_state = 8},
  [362] = {.lex_state = 13},
  [363] = {.lex_state = 13},
  [364] = {.lex_state = 13},
  [365] = {.lex_state = 13},
  [366] = {.lex_state = 13},
  [367] = {.lex_state = 8},
  [368] = {.lex_state = 10},
  [369] = {.lex_state = 8},
  [370] = {.lex_state = 8, .external_lex_state = 9},
  [371] = {.lex_state = 8, .external_lex_state = 9},
  [372] = {.lex_state = 8, .external_lex_state = 9},
  [373] = {.lex_state = 14},
  [374] = {.lex_state = 14},
  [375] = {.lex_state = 14},
  [376] = {.lex_state = 9},
  [377] = {.lex_state = 8, .external_lex_state = 9},
  [378] = {.lex_state = 8, .external_lex_state = 9},
  [379] = {.lex_state = 8, .external_lex_state = 9},
  [380] = {.lex_state = 14},
  [381] = {.lex_state = 8, .external_lex_state = 9},
  [382] = {.lex_state = 8, .external_lex_state = 9},
  [383] = {.lex_state = 8, .external_lex_state = 9},
  [384] = {.lex_state = 8, .external_lex_state = 9},
  [385] = {.lex_state = 8, .external_lex_state = 9},
  [386] = {.lex_state = 8, .external_lex_state = 9},
  [387] = {.lex_state = 8, .external_lex_state = 9},
  [388] = {.lex_state = 10, .external_lex_state = 10},
  [389] = {.lex_state = 10, .external_lex_state = 10},
  [390] = {.lex_state = 8},
  [391] = {.lex_state = 10, .external_lex_state = 10},
  [392] = {.lex_state = 14},
  [393] = {.lex_state = 13},
  [394] = {.lex_state = 10, .external_lex_state = 10},
  [395] = {.lex_state = 10, .external_lex_state = 10},
  [396] = {.lex_state = 10, .external_lex_state = 10},
  [397] = {.lex_state = 9},
  [398] = {.lex_state = 10, .external_lex_state = 10},
  [399] = {.lex_state = 10, .external_lex_state = 10},
  [400] = {.lex_state = 10, .external_lex_state = 10},
  [401] = {.lex_state = 10, .external_lex_state = 10},
  [402] = {.lex_state = 10, .external_lex_state = 10},
  [403] = {.lex_state = 10, .external_lex_state = 10},
  [404] = {.lex_state = 13},
  [405] = {.lex_state = 10, .external_lex_state = 10},
  [406] = {.lex_state = 13, .external_lex_state = 9},
  [407] = {.lex_state = 100, .external_lex_state = 9},
  [408] = {.lex_state = 8},
  [409] = {.lex_state = 100, .external_lex_state = 9},
  [410] = {.lex_state = 11},
  [411] = {.lex_state = 13, .external_lex_state = 9},
  [412] = {.lex_state = 11},
  [413] = {.lex_state = 8},
  [414] = {.lex_state = 100, .external_lex_state = 9},
  [415] = {.lex_state = 11},
  [416] = {.lex_state = 11},
  [417] = {.lex_state = 13, .external_lex_state = 9},
  [418] = {.lex_state = 8},
  [419] = {.lex_state = 11},
  [420] = {.lex_state = 11},
  [421] = {.lex_state = 11},
  [422] = {.lex_state = 11},
  [423] = {.lex_state = 11},
  [424] = {.lex_state = 8},
  [425] = {.lex_state = 11},
  [426] = {.lex_state = 11},
  [427] = {.lex_state = 8},
  [428] = {.lex_state = 11},
  [429] = {.lex_state = 11},
  [430] = {.lex_state = 11},
  [431] = {.lex_state = 11},
  [432] = {.lex_state = 11},
  [433] = {.lex_state = 11},
  [434] = {.lex_state = 10},
  [435] = {.lex_state = 11},
  [436] = {.lex_state = 11},
  [437] = {.lex_state = 11},
  [438] = {.lex_state = 11},
  [439] = {.lex_state = 100, .external_lex_state = 9},
  [440] = {.lex_state = 100, .external_lex_state = 9},
  [441] = {.lex_state = 13, .external_lex_state = 9},
  [442] = {.lex_state = 12},
  [443] = {.lex_state = 100, .external_lex_state = 9},
  [444] = {.lex_state = 13, .external_lex_state = 9},
  [445] = {.lex_state = 100, .external_lex_state = 9},
  [446] = {.lex_state = 100, .external_lex_state = 9},
  [447] = {.lex_state = 13, .external_lex_state = 9},
  [448] = {.lex_state = 13, .external_lex_state = 9},
  [449] = {.lex_state = 100, .external_lex_state = 9},
  [450] = {.lex_state = 100, .external_lex_state = 9},
  [451] = {.lex_state = 100, .external_lex_state = 9},
  [452] = {.lex_state = 100, .external_lex_state = 9},
  [453] = {.lex_state = 12},
  [454] = {.lex_state = 13, .external_lex_state = 9},
  [455] = {.lex_state = 12},
  [456] = {.lex_state = 13, .external_lex_state = 9},
  [457] = {.lex_state = 14},
  [458] = {.lex_state = 13, .external_lex_state = 9},
  [459] = {.lex_state = 100, .external_lex_state = 9},
  [460] = {.lex_state = 13, .external_lex_state = 9},
  [461] = {.lex_state = 14},
  [462] = {.lex_state = 13, .external_lex_state = 9},
  [463] = {.lex_state = 13, .external_lex_state = 9},
  [464] = {.lex_state = 13, .external_lex_state = 9},
  [465] = {.lex_state = 13, .external_lex_state = 9},
  [466] = {.lex_state = 100},
  [467] = {.lex_state = 13},
  [468] = {.lex_state = 13, .external_lex_state = 9},
  [469] = {.lex_state = 11},
  [470] = {.lex_state = 11},
  [471] = {.lex_state = 100},
  [472] = {.lex_state = 13, .external_lex_state = 9},
  [473] = {.lex_state = 13, .external_lex_state = 9},
  [474] = {.lex_state = 13, .external_lex_state = 9},
  [475] = {.lex_state = 100},
  [476] = {.lex_state = 100},
  [477] = {.lex_state = 100},
  [478] = {.lex_state = 100},
  [479] = {.lex_state = 13},
  [480] = {.lex_state = 100},
  [481] = {.lex_state = 20},
  [482] = {.lex_state = 20},
  [483] = {.lex_state = 20},
  [484] = {.lex_state = 20},
  [485] = {.lex_state = 20},
  [486] = {.lex_state = 20},
  [487] = {.lex_state = 20},
  [488] = {.lex_state = 20},
  [489] = {.lex_state = 20},
  [490] = {.lex_state = 17},
  [491] = {.lex_state = 20},
  [492] = {.lex_state = 20},
  [493] = {.lex_state = 20},
  [494] = {.lex_state = 20},
  [495] = {.lex_state = 20},
  [496] = {.lex_state = 20},
  [497] = {.lex_state = 20},
  [498] = {.lex_state = 20},
  [499] = {.lex_state = 100},
  [500] = {.lex_state = 20},
  [501] = {.lex_state = 20},
  [502] = {.lex_state = 20},
  [503] = {.lex_state = 20},
  [504] = {.lex_state = 100},
  [505] = {.lex_state = 100},
  [506] = {.lex_state = 100},
  [507] = {.lex_state = 100},
  [508] = {.lex_state = 100},
  [509] = {.lex_state = 100, .external_lex_state = 10},
  [510] = {.lex_state = 100},
  [511] = {.lex_state = 100},
  [512] = {.lex_state = 100},
  [513] = {.lex_state = 100, .external_lex_state = 10},
  [514] = {.lex_state = 100},
  [515] = {.lex_state = 100},
  [516] = {.lex_state = 100},
  [517] = {.lex_state = 100},
  [518] = {.lex_state = 100},
  [519] = {.lex_state = 100},
  [520] = {.lex_state = 17},
  [521] = {.lex_state = 100},
  [522] = {.lex_state = 100},
  [523] = {.lex_state = 100, .external_lex_state = 10},
  [524] = {.lex_state = 100, .external_lex_state = 10},
  [525] = {.lex_state = 100, .external_lex_state = 10},
  [526] = {.lex_state = 16},
  [527] = {.lex_state = 100},
  [528] = {.lex_state = 100, .external_lex_state = 10},
  [529] = {.lex_state = 100, .external_lex_state = 10},
  [530] = {.lex_state = 16},
  [531] = {.lex_state = 100, .external_lex_state = 10},
  [532] = {.lex_state = 100, .external_lex_state = 10},
  [533] = {.lex_state = 100, .external_lex_state = 10},
  [534] = {.lex_state = 100, .external_lex_state = 10},
  [535] = {.lex_state = 100, .external_lex_state = 10},
  [536] = {.lex_state = 100},
  [537] = {.lex_state = 21},
  [538] = {.lex_state = 100},
  [539] = {.lex_state = 100, .external_lex_state = 10},
  [540] = {.lex_state = 100},
  [541] = {.lex_state = 100},
  [542] = {.lex_state = 100},
  [543] = {.lex_state = 100},
  [544] = {.lex_state = 100},
  [545] = {.lex_state = 100},
  [546] = {.lex_state = 100},
  [547] = {.lex_state = 100},
  [548] = {.lex_state = 100},
  [549] = {.lex_state = 100},
  [550] = {.lex_state = 100},
  [551] = {.lex_state = 100},
  [552] = {.lex_state = 100},
  [553] = {.lex_state = 100},
  [554] = {.lex_state = 100},
  [555] = {.lex_state = 100},
  [556] = {.lex_state = 100},
  [557] = {.lex_state = 100},
  [558] = {.lex_state = 100},
  [559] = {.lex_state = 100},
  [560] = {.lex_state = 100},
  [561] = {.lex_state = 100},
  [562] = {.lex_state = 100},
  [563] = {.lex_state = 100},
  [564] = {.lex_state = 100},
  [565] = {.lex_state = 100},
  [566] = {.lex_state = 100},
  [567] = {.lex_state = 100},
  [568] = {.lex_state = 100},
  [569] = {.lex_state = 100},
  [570] = {.lex_state = 100},
  [571] = {.lex_state = 100},
  [572] = {.lex_state = 100},
  [573] = {.lex_state = 100},
  [574] = {.lex_state = 100},
  [575] = {.lex_state = 100},
  [576] = {.lex_state = 100},
  [577] = {.lex_state = 100, .external_lex_state = 11},
  [578] = {.lex_state = 100},
  [579] = {.lex_state = 100},
  [580] = {.lex_state = 100},
  [581] = {.lex_state = 100},
  [582] = {.lex_state = 100},
  [583] = {.lex_state = 100},
  [584] = {.lex_state = 100},
  [585] = {.lex_state = 100},
  [586] = {.lex_state = 100},
  [587] = {.lex_state = 100},
  [588] = {.lex_state = 100},
  [589] = {.lex_state = 100},
  [590] = {.lex_state = 100},
  [591] = {.lex_state = 100},
  [592] = {.lex_state = 100},
  [593] = {.lex_state = 100, .external_lex_state = 11},
  [594] = {.lex_state = 15},
  [595] = {.lex_state = 22},
  [596] = {.lex_state = 100},
  [597] = {.lex_state = 100},
  [598] = {.lex_state = 100},
  [599] = {.lex_state = 100},
  [600] = {.lex_state = 100},
  [601] = {.lex_state = 100, .external_lex_state = 11},
};

enum {
  ts_external_token_cmd_identifier = 0,
  ts_external_token__help_command = 1,
  ts_external_token_file_descriptor = 2,
  ts_external_token__eq_sep_concat = 3,
  ts_external_token__concat = 4,
  ts_external_token__concat_brace = 5,
  ts_external_token__concat_pf_dot = 6,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_cmd_identifier] = sym_cmd_identifier,
  [ts_external_token__help_command] = sym__help_command,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__eq_sep_concat] = sym__eq_sep_concat,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token__concat_brace] = sym__concat_brace,
  [ts_external_token__concat_pf_dot] = sym__concat_pf_dot,
};

static bool ts_external_scanner_states[12][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_cmd_identifier] = true,
    [ts_external_token__help_command] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__eq_sep_concat] = true,
    [ts_external_token__concat] = true,
    [ts_external_token__concat_brace] = true,
    [ts_external_token__concat_pf_dot] = true,
  },
  [2] = {
    [ts_external_token_cmd_identifier] = true,
    [ts_external_token__help_command] = true,
  },
  [3] = {
    [ts_external_token_cmd_identifier] = true,
    [ts_external_token__help_command] = true,
    [ts_external_token_file_descriptor] = true,
  },
  [4] = {
    [ts_external_token_file_descriptor] = true,
  },
  [5] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat_pf_dot] = true,
  },
  [6] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
  },
  [7] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__eq_sep_concat] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__eq_sep_concat] = true,
    [ts_external_token__concat] = true,
  },
  [9] = {
    [ts_external_token__concat] = true,
  },
  [10] = {
    [ts_external_token__concat_brace] = true,
  },
  [11] = {
    [ts_external_token__concat_pf_dot] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PIPEH] = ACTIONS(1),
    [anon_sym_PIPET] = ACTIONS(1),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(1),
    [anon_sym_AT_AT_ATb] = ACTIONS(1),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATi] = ACTIONS(1),
    [anon_sym_AT_AT_ATr] = ACTIONS(1),
    [anon_sym_AT_AT_ATs] = ACTIONS(1),
    [anon_sym_AT_AT_ATst] = ACTIONS(1),
    [anon_sym_AT_AT_ATS] = ACTIONS(1),
    [anon_sym_AT_AT_ATm] = ACTIONS(1),
    [anon_sym_AT_AT_ATM] = ACTIONS(1),
    [anon_sym_AT_AT_ATf] = ACTIONS(1),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATF] = ACTIONS(1),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATt] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [anon_sym_AT_ATdbt] = ACTIONS(1),
    [anon_sym_AT_ATdbta] = ACTIONS(1),
    [anon_sym_AT_ATdbtb] = ACTIONS(1),
    [anon_sym_AT_ATdbts] = ACTIONS(1),
    [anon_sym_AT_AT_DOT] = ACTIONS(1),
    [anon_sym_AT_AT_EQ] = ACTIONS(1),
    [anon_sym_AT_ATk] = ACTIONS(1),
    [anon_sym_AT_ATt] = ACTIONS(1),
    [anon_sym_AT_ATb] = ACTIONS(1),
    [anon_sym_AT_ATi] = ACTIONS(1),
    [anon_sym_AT_ATiS] = ACTIONS(1),
    [anon_sym_AT_ATf] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT_ATs_COLON] = ACTIONS(1),
    [anon_sym_AT_ATc_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_AT_BANG] = ACTIONS(1),
    [anon_sym_AT_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_ATa_COLON] = ACTIONS(1),
    [anon_sym_ATb_COLON] = ACTIONS(1),
    [anon_sym_ATB_COLON] = ACTIONS(1),
    [anon_sym_ATe_COLON] = ACTIONS(1),
    [anon_sym_ATF_COLON] = ACTIONS(1),
    [anon_sym_ATi_COLON] = ACTIONS(1),
    [anon_sym_ATk_COLON] = ACTIONS(1),
    [anon_sym_ATo_COLON] = ACTIONS(1),
    [anon_sym_ATr_COLON] = ACTIONS(1),
    [anon_sym_ATf_COLON] = ACTIONS(1),
    [anon_sym_ATs_COLON] = ACTIONS(1),
    [anon_sym_ATx_COLON] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [aux_sym_task_command_token1] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym__search_command_token1] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_LPAREN] = ACTIONS(1),
    [anon_sym_PIPE_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_question_mark_identifier] = ACTIONS(1),
    [sym_pointer_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [sym_html_redirect_operator] = ACTIONS(1),
    [sym_html_append_operator] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [aux_sym_tmp_eval_arg_token1] = ACTIONS(1),
    [aux_sym_double_quoted_arg_token3] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_CR] = ACTIONS(1),
    [sym_cmd_identifier] = ACTIONS(1),
    [sym__help_command] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__eq_sep_concat] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym__concat_brace] = ACTIONS(1),
    [sym__concat_pf_dot] = ACTIONS(1),
  },
  [1] = {
    [sym_commands] = STATE(589),
    [sym__command] = STATE(476),
    [sym_legacy_quoted_command] = STATE(194),
    [sym__simple_command] = STATE(194),
    [sym__tmp_command] = STATE(194),
    [sym__iter_command] = STATE(194),
    [sym__foreach_command] = STATE(194),
    [sym__pipe_command] = STATE(194),
    [sym_grep_command] = STATE(194),
    [sym_html_disable_command] = STATE(194),
    [sym_html_enable_command] = STATE(194),
    [sym_scr_tts_command] = STATE(194),
    [sym_pipe_command] = STATE(194),
    [sym_foreach_addrsize_command] = STATE(194),
    [sym_foreach_bb_command] = STATE(194),
    [sym_foreach_cmd_command] = STATE(194),
    [sym_foreach_comment_command] = STATE(194),
    [sym_foreach_import_command] = STATE(194),
    [sym_foreach_register_command] = STATE(194),
    [sym_foreach_symbol_command] = STATE(194),
    [sym_foreach_string_command] = STATE(194),
    [sym_foreach_section_command] = STATE(194),
    [sym_foreach_iomap_command] = STATE(194),
    [sym_foreach_dbgmap_command] = STATE(194),
    [sym_foreach_flag_command] = STATE(194),
    [sym_foreach_function_command] = STATE(194),
    [sym_foreach_thread_command] = STATE(194),
    [sym_iter_flags_command] = STATE(194),
    [sym_iter_dbta_command] = STATE(194),
    [sym_iter_dbtb_command] = STATE(194),
    [sym_iter_dbts_command] = STATE(194),
    [sym_iter_file_lines_command] = STATE(194),
    [sym_iter_offsets_command] = STATE(194),
    [sym_iter_sdbquery_command] = STATE(194),
    [sym_iter_threads_command] = STATE(194),
    [sym_iter_bbs_command] = STATE(194),
    [sym_iter_instrs_command] = STATE(194),
    [sym_iter_sections_command] = STATE(194),
    [sym_iter_functions_command] = STATE(194),
    [sym_iter_step_command] = STATE(194),
    [sym_iter_interpret_command] = STATE(194),
    [sym_iter_hit_command] = STATE(194),
    [sym_tmp_seek_command] = STATE(194),
    [sym_tmp_blksz_command] = STATE(194),
    [sym_tmp_fromto_command] = STATE(194),
    [sym_tmp_arch_command] = STATE(194),
    [sym_tmp_bits_command] = STATE(194),
    [sym_tmp_nthi_command] = STATE(194),
    [sym_tmp_eval_command] = STATE(194),
    [sym_tmp_fs_command] = STATE(194),
    [sym_tmp_reli_command] = STATE(194),
    [sym_tmp_kuery_command] = STATE(194),
    [sym_tmp_fd_command] = STATE(194),
    [sym_tmp_reg_command] = STATE(194),
    [sym_tmp_file_command] = STATE(194),
    [sym_tmp_string_command] = STATE(194),
    [sym_tmp_hex_command] = STATE(194),
    [sym_task_command] = STATE(194),
    [sym_number_command] = STATE(194),
    [sym_help_command] = STATE(194),
    [sym_arged_command] = STATE(194),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(194),
    [sym_Cf_cmd] = STATE(194),
    [sym_pf_new_cmd] = STATE(194),
    [sym_pf_dot_cmd] = STATE(194),
    [sym_pf_cmd] = STATE(194),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(194),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(194),
    [sym_redirect_command] = STATE(476),
    [sym__dec_number] = STATE(4),
    [aux_sym_commands_repeat1] = STATE(8),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(51),
    [anon_sym_CR] = ACTIONS(51),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [2] = {
    [sym_legacy_quoted_command] = STATE(264),
    [sym__simple_command] = STATE(264),
    [sym__tmp_command] = STATE(264),
    [sym__iter_command] = STATE(264),
    [sym__foreach_command] = STATE(264),
    [sym__pipe_command] = STATE(264),
    [sym_grep_command] = STATE(264),
    [sym_html_disable_command] = STATE(264),
    [sym_html_enable_command] = STATE(264),
    [sym_scr_tts_command] = STATE(264),
    [sym_pipe_command] = STATE(264),
    [sym_foreach_addrsize_command] = STATE(264),
    [sym_foreach_bb_command] = STATE(264),
    [sym_foreach_cmd_command] = STATE(264),
    [sym_foreach_comment_command] = STATE(264),
    [sym_foreach_import_command] = STATE(264),
    [sym_foreach_register_command] = STATE(264),
    [sym_foreach_symbol_command] = STATE(264),
    [sym_foreach_string_command] = STATE(264),
    [sym_foreach_section_command] = STATE(264),
    [sym_foreach_iomap_command] = STATE(264),
    [sym_foreach_dbgmap_command] = STATE(264),
    [sym_foreach_flag_command] = STATE(264),
    [sym_foreach_function_command] = STATE(264),
    [sym_foreach_thread_command] = STATE(264),
    [sym_iter_flags_command] = STATE(264),
    [sym_iter_dbta_command] = STATE(264),
    [sym_iter_dbtb_command] = STATE(264),
    [sym_iter_dbts_command] = STATE(264),
    [sym_iter_file_lines_command] = STATE(264),
    [sym_iter_offsets_command] = STATE(264),
    [sym_iter_sdbquery_command] = STATE(264),
    [sym_iter_threads_command] = STATE(264),
    [sym_iter_bbs_command] = STATE(264),
    [sym_iter_instrs_command] = STATE(264),
    [sym_iter_sections_command] = STATE(264),
    [sym_iter_functions_command] = STATE(264),
    [sym_iter_step_command] = STATE(264),
    [sym_iter_interpret_command] = STATE(264),
    [sym_iter_hit_command] = STATE(264),
    [sym_tmp_seek_command] = STATE(264),
    [sym_tmp_blksz_command] = STATE(264),
    [sym_tmp_fromto_command] = STATE(264),
    [sym_tmp_arch_command] = STATE(264),
    [sym_tmp_bits_command] = STATE(264),
    [sym_tmp_nthi_command] = STATE(264),
    [sym_tmp_eval_command] = STATE(264),
    [sym_tmp_fs_command] = STATE(264),
    [sym_tmp_reli_command] = STATE(264),
    [sym_tmp_kuery_command] = STATE(264),
    [sym_tmp_fd_command] = STATE(264),
    [sym_tmp_reg_command] = STATE(264),
    [sym_tmp_file_command] = STATE(264),
    [sym_tmp_string_command] = STATE(264),
    [sym_tmp_hex_command] = STATE(264),
    [sym_task_command] = STATE(264),
    [sym_number_command] = STATE(264),
    [sym_help_command] = STATE(264),
    [sym_arged_command] = STATE(264),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(264),
    [sym_Cf_cmd] = STATE(264),
    [sym_pf_new_cmd] = STATE(264),
    [sym_pf_dot_cmd] = STATE(264),
    [sym_pf_cmd] = STATE(264),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(264),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(264),
    [sym__dec_number] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_PIPE] = ACTIONS(65),
    [anon_sym_PIPEH] = ACTIONS(63),
    [anon_sym_PIPET] = ACTIONS(63),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATi] = ACTIONS(63),
    [anon_sym_AT_AT_ATr] = ACTIONS(63),
    [anon_sym_AT_AT_ATs] = ACTIONS(65),
    [anon_sym_AT_AT_ATst] = ACTIONS(63),
    [anon_sym_AT_AT_ATS] = ACTIONS(63),
    [anon_sym_AT_AT_ATm] = ACTIONS(63),
    [anon_sym_AT_AT_ATM] = ACTIONS(63),
    [anon_sym_AT_AT_ATf] = ACTIONS(65),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATF] = ACTIONS(65),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_AT] = ACTIONS(65),
    [anon_sym_AT_ATdbt] = ACTIONS(65),
    [anon_sym_AT_ATdbta] = ACTIONS(63),
    [anon_sym_AT_ATdbtb] = ACTIONS(63),
    [anon_sym_AT_ATdbts] = ACTIONS(63),
    [anon_sym_AT_AT_DOT] = ACTIONS(63),
    [anon_sym_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_ATk] = ACTIONS(63),
    [anon_sym_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_ATi] = ACTIONS(65),
    [anon_sym_AT_ATiS] = ACTIONS(63),
    [anon_sym_AT_ATf] = ACTIONS(63),
    [anon_sym_AT_ATs_COLON] = ACTIONS(63),
    [anon_sym_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_AT_BANG] = ACTIONS(63),
    [anon_sym_AT_LBRACE] = ACTIONS(63),
    [anon_sym_ATa_COLON] = ACTIONS(63),
    [anon_sym_ATb_COLON] = ACTIONS(63),
    [anon_sym_ATB_COLON] = ACTIONS(63),
    [anon_sym_ATe_COLON] = ACTIONS(63),
    [anon_sym_ATF_COLON] = ACTIONS(63),
    [anon_sym_ATi_COLON] = ACTIONS(63),
    [anon_sym_ATk_COLON] = ACTIONS(63),
    [anon_sym_ATo_COLON] = ACTIONS(63),
    [anon_sym_ATr_COLON] = ACTIONS(63),
    [anon_sym_ATf_COLON] = ACTIONS(63),
    [anon_sym_ATs_COLON] = ACTIONS(63),
    [anon_sym_ATx_COLON] = ACTIONS(63),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_PIPE_DOT] = ACTIONS(63),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_GT_GT] = ACTIONS(63),
    [sym_html_redirect_operator] = ACTIONS(65),
    [sym_html_append_operator] = ACTIONS(63),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(63),
    [anon_sym_CR] = ACTIONS(63),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(63),
  },
  [3] = {
    [sym_legacy_quoted_command] = STATE(273),
    [sym__simple_command] = STATE(273),
    [sym__tmp_command] = STATE(273),
    [sym__iter_command] = STATE(273),
    [sym__foreach_command] = STATE(273),
    [sym__pipe_command] = STATE(273),
    [sym_grep_command] = STATE(273),
    [sym_html_disable_command] = STATE(273),
    [sym_html_enable_command] = STATE(273),
    [sym_scr_tts_command] = STATE(273),
    [sym_pipe_command] = STATE(273),
    [sym_foreach_addrsize_command] = STATE(273),
    [sym_foreach_bb_command] = STATE(273),
    [sym_foreach_cmd_command] = STATE(273),
    [sym_foreach_comment_command] = STATE(273),
    [sym_foreach_import_command] = STATE(273),
    [sym_foreach_register_command] = STATE(273),
    [sym_foreach_symbol_command] = STATE(273),
    [sym_foreach_string_command] = STATE(273),
    [sym_foreach_section_command] = STATE(273),
    [sym_foreach_iomap_command] = STATE(273),
    [sym_foreach_dbgmap_command] = STATE(273),
    [sym_foreach_flag_command] = STATE(273),
    [sym_foreach_function_command] = STATE(273),
    [sym_foreach_thread_command] = STATE(273),
    [sym_iter_flags_command] = STATE(273),
    [sym_iter_dbta_command] = STATE(273),
    [sym_iter_dbtb_command] = STATE(273),
    [sym_iter_dbts_command] = STATE(273),
    [sym_iter_file_lines_command] = STATE(273),
    [sym_iter_offsets_command] = STATE(273),
    [sym_iter_sdbquery_command] = STATE(273),
    [sym_iter_threads_command] = STATE(273),
    [sym_iter_bbs_command] = STATE(273),
    [sym_iter_instrs_command] = STATE(273),
    [sym_iter_sections_command] = STATE(273),
    [sym_iter_functions_command] = STATE(273),
    [sym_iter_step_command] = STATE(273),
    [sym_iter_interpret_command] = STATE(273),
    [sym_iter_hit_command] = STATE(273),
    [sym_tmp_seek_command] = STATE(273),
    [sym_tmp_blksz_command] = STATE(273),
    [sym_tmp_fromto_command] = STATE(273),
    [sym_tmp_arch_command] = STATE(273),
    [sym_tmp_bits_command] = STATE(273),
    [sym_tmp_nthi_command] = STATE(273),
    [sym_tmp_eval_command] = STATE(273),
    [sym_tmp_fs_command] = STATE(273),
    [sym_tmp_reli_command] = STATE(273),
    [sym_tmp_kuery_command] = STATE(273),
    [sym_tmp_fd_command] = STATE(273),
    [sym_tmp_reg_command] = STATE(273),
    [sym_tmp_file_command] = STATE(273),
    [sym_tmp_string_command] = STATE(273),
    [sym_tmp_hex_command] = STATE(273),
    [sym_task_command] = STATE(273),
    [sym_number_command] = STATE(273),
    [sym_help_command] = STATE(273),
    [sym_arged_command] = STATE(273),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(273),
    [sym_Cf_cmd] = STATE(273),
    [sym_pf_new_cmd] = STATE(273),
    [sym_pf_dot_cmd] = STATE(273),
    [sym_pf_cmd] = STATE(273),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(273),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(273),
    [sym__dec_number] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_PIPEH] = ACTIONS(67),
    [anon_sym_PIPET] = ACTIONS(67),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(67),
    [anon_sym_AT_AT_ATb] = ACTIONS(67),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATi] = ACTIONS(67),
    [anon_sym_AT_AT_ATr] = ACTIONS(67),
    [anon_sym_AT_AT_ATs] = ACTIONS(69),
    [anon_sym_AT_AT_ATst] = ACTIONS(67),
    [anon_sym_AT_AT_ATS] = ACTIONS(67),
    [anon_sym_AT_AT_ATm] = ACTIONS(67),
    [anon_sym_AT_AT_ATM] = ACTIONS(67),
    [anon_sym_AT_AT_ATf] = ACTIONS(69),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATF] = ACTIONS(69),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATt] = ACTIONS(67),
    [anon_sym_AT_AT] = ACTIONS(69),
    [anon_sym_AT_ATdbt] = ACTIONS(69),
    [anon_sym_AT_ATdbta] = ACTIONS(67),
    [anon_sym_AT_ATdbtb] = ACTIONS(67),
    [anon_sym_AT_ATdbts] = ACTIONS(67),
    [anon_sym_AT_AT_DOT] = ACTIONS(67),
    [anon_sym_AT_AT_EQ] = ACTIONS(67),
    [anon_sym_AT_ATk] = ACTIONS(67),
    [anon_sym_AT_ATt] = ACTIONS(67),
    [anon_sym_AT_ATb] = ACTIONS(67),
    [anon_sym_AT_ATi] = ACTIONS(69),
    [anon_sym_AT_ATiS] = ACTIONS(67),
    [anon_sym_AT_ATf] = ACTIONS(67),
    [anon_sym_AT_ATs_COLON] = ACTIONS(67),
    [anon_sym_AT_ATc_COLON] = ACTIONS(67),
    [anon_sym_AT] = ACTIONS(69),
    [anon_sym_AT_BANG] = ACTIONS(67),
    [anon_sym_AT_LBRACE] = ACTIONS(67),
    [anon_sym_ATa_COLON] = ACTIONS(67),
    [anon_sym_ATb_COLON] = ACTIONS(67),
    [anon_sym_ATB_COLON] = ACTIONS(67),
    [anon_sym_ATe_COLON] = ACTIONS(67),
    [anon_sym_ATF_COLON] = ACTIONS(67),
    [anon_sym_ATi_COLON] = ACTIONS(67),
    [anon_sym_ATk_COLON] = ACTIONS(67),
    [anon_sym_ATo_COLON] = ACTIONS(67),
    [anon_sym_ATr_COLON] = ACTIONS(67),
    [anon_sym_ATf_COLON] = ACTIONS(67),
    [anon_sym_ATs_COLON] = ACTIONS(67),
    [anon_sym_ATx_COLON] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_PIPE_DOT] = ACTIONS(67),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(67),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_GT_GT] = ACTIONS(67),
    [sym_html_redirect_operator] = ACTIONS(69),
    [sym_html_append_operator] = ACTIONS(67),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_CR] = ACTIONS(67),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
  },
  [4] = {
    [sym_legacy_quoted_command] = STATE(216),
    [sym__simple_command] = STATE(216),
    [sym__tmp_command] = STATE(216),
    [sym__iter_command] = STATE(216),
    [sym__foreach_command] = STATE(216),
    [sym__pipe_command] = STATE(216),
    [sym_grep_command] = STATE(216),
    [sym_html_disable_command] = STATE(216),
    [sym_html_enable_command] = STATE(216),
    [sym_scr_tts_command] = STATE(216),
    [sym_pipe_command] = STATE(216),
    [sym_foreach_addrsize_command] = STATE(216),
    [sym_foreach_bb_command] = STATE(216),
    [sym_foreach_cmd_command] = STATE(216),
    [sym_foreach_comment_command] = STATE(216),
    [sym_foreach_import_command] = STATE(216),
    [sym_foreach_register_command] = STATE(216),
    [sym_foreach_symbol_command] = STATE(216),
    [sym_foreach_string_command] = STATE(216),
    [sym_foreach_section_command] = STATE(216),
    [sym_foreach_iomap_command] = STATE(216),
    [sym_foreach_dbgmap_command] = STATE(216),
    [sym_foreach_flag_command] = STATE(216),
    [sym_foreach_function_command] = STATE(216),
    [sym_foreach_thread_command] = STATE(216),
    [sym_iter_flags_command] = STATE(216),
    [sym_iter_dbta_command] = STATE(216),
    [sym_iter_dbtb_command] = STATE(216),
    [sym_iter_dbts_command] = STATE(216),
    [sym_iter_file_lines_command] = STATE(216),
    [sym_iter_offsets_command] = STATE(216),
    [sym_iter_sdbquery_command] = STATE(216),
    [sym_iter_threads_command] = STATE(216),
    [sym_iter_bbs_command] = STATE(216),
    [sym_iter_instrs_command] = STATE(216),
    [sym_iter_sections_command] = STATE(216),
    [sym_iter_functions_command] = STATE(216),
    [sym_iter_step_command] = STATE(216),
    [sym_iter_interpret_command] = STATE(216),
    [sym_iter_hit_command] = STATE(216),
    [sym_tmp_seek_command] = STATE(216),
    [sym_tmp_blksz_command] = STATE(216),
    [sym_tmp_fromto_command] = STATE(216),
    [sym_tmp_arch_command] = STATE(216),
    [sym_tmp_bits_command] = STATE(216),
    [sym_tmp_nthi_command] = STATE(216),
    [sym_tmp_eval_command] = STATE(216),
    [sym_tmp_fs_command] = STATE(216),
    [sym_tmp_reli_command] = STATE(216),
    [sym_tmp_kuery_command] = STATE(216),
    [sym_tmp_fd_command] = STATE(216),
    [sym_tmp_reg_command] = STATE(216),
    [sym_tmp_file_command] = STATE(216),
    [sym_tmp_string_command] = STATE(216),
    [sym_tmp_hex_command] = STATE(216),
    [sym_task_command] = STATE(216),
    [sym_number_command] = STATE(216),
    [sym_help_command] = STATE(216),
    [sym_arged_command] = STATE(216),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(216),
    [sym_Cf_cmd] = STATE(216),
    [sym_pf_new_cmd] = STATE(216),
    [sym_pf_dot_cmd] = STATE(216),
    [sym_pf_cmd] = STATE(216),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(216),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(216),
    [sym__dec_number] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PIPEH] = ACTIONS(71),
    [anon_sym_PIPET] = ACTIONS(71),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(71),
    [anon_sym_AT_AT_ATb] = ACTIONS(71),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATi] = ACTIONS(71),
    [anon_sym_AT_AT_ATr] = ACTIONS(71),
    [anon_sym_AT_AT_ATs] = ACTIONS(73),
    [anon_sym_AT_AT_ATst] = ACTIONS(71),
    [anon_sym_AT_AT_ATS] = ACTIONS(71),
    [anon_sym_AT_AT_ATm] = ACTIONS(71),
    [anon_sym_AT_AT_ATM] = ACTIONS(71),
    [anon_sym_AT_AT_ATf] = ACTIONS(73),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATF] = ACTIONS(73),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATt] = ACTIONS(71),
    [anon_sym_AT_AT] = ACTIONS(73),
    [anon_sym_AT_ATdbt] = ACTIONS(73),
    [anon_sym_AT_ATdbta] = ACTIONS(71),
    [anon_sym_AT_ATdbtb] = ACTIONS(71),
    [anon_sym_AT_ATdbts] = ACTIONS(71),
    [anon_sym_AT_AT_DOT] = ACTIONS(71),
    [anon_sym_AT_AT_EQ] = ACTIONS(71),
    [anon_sym_AT_ATk] = ACTIONS(71),
    [anon_sym_AT_ATt] = ACTIONS(71),
    [anon_sym_AT_ATb] = ACTIONS(71),
    [anon_sym_AT_ATi] = ACTIONS(73),
    [anon_sym_AT_ATiS] = ACTIONS(71),
    [anon_sym_AT_ATf] = ACTIONS(71),
    [anon_sym_AT_ATs_COLON] = ACTIONS(71),
    [anon_sym_AT_ATc_COLON] = ACTIONS(71),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_BANG] = ACTIONS(71),
    [anon_sym_AT_LBRACE] = ACTIONS(71),
    [anon_sym_ATa_COLON] = ACTIONS(71),
    [anon_sym_ATb_COLON] = ACTIONS(71),
    [anon_sym_ATB_COLON] = ACTIONS(71),
    [anon_sym_ATe_COLON] = ACTIONS(71),
    [anon_sym_ATF_COLON] = ACTIONS(71),
    [anon_sym_ATi_COLON] = ACTIONS(71),
    [anon_sym_ATk_COLON] = ACTIONS(71),
    [anon_sym_ATo_COLON] = ACTIONS(71),
    [anon_sym_ATr_COLON] = ACTIONS(71),
    [anon_sym_ATf_COLON] = ACTIONS(71),
    [anon_sym_ATs_COLON] = ACTIONS(71),
    [anon_sym_ATx_COLON] = ACTIONS(71),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_PIPE_DOT] = ACTIONS(71),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(71),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_GT_GT] = ACTIONS(71),
    [sym_html_redirect_operator] = ACTIONS(73),
    [sym_html_append_operator] = ACTIONS(71),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(71),
    [anon_sym_CR] = ACTIONS(71),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(71),
  },
  [5] = {
    [sym_legacy_quoted_command] = STATE(273),
    [sym__simple_command] = STATE(273),
    [sym__tmp_command] = STATE(273),
    [sym__iter_command] = STATE(273),
    [sym__foreach_command] = STATE(273),
    [sym__pipe_command] = STATE(273),
    [sym_grep_command] = STATE(273),
    [sym_html_disable_command] = STATE(273),
    [sym_html_enable_command] = STATE(273),
    [sym_scr_tts_command] = STATE(273),
    [sym_pipe_command] = STATE(273),
    [sym_foreach_addrsize_command] = STATE(273),
    [sym_foreach_bb_command] = STATE(273),
    [sym_foreach_cmd_command] = STATE(273),
    [sym_foreach_comment_command] = STATE(273),
    [sym_foreach_import_command] = STATE(273),
    [sym_foreach_register_command] = STATE(273),
    [sym_foreach_symbol_command] = STATE(273),
    [sym_foreach_string_command] = STATE(273),
    [sym_foreach_section_command] = STATE(273),
    [sym_foreach_iomap_command] = STATE(273),
    [sym_foreach_dbgmap_command] = STATE(273),
    [sym_foreach_flag_command] = STATE(273),
    [sym_foreach_function_command] = STATE(273),
    [sym_foreach_thread_command] = STATE(273),
    [sym_iter_flags_command] = STATE(273),
    [sym_iter_dbta_command] = STATE(273),
    [sym_iter_dbtb_command] = STATE(273),
    [sym_iter_dbts_command] = STATE(273),
    [sym_iter_file_lines_command] = STATE(273),
    [sym_iter_offsets_command] = STATE(273),
    [sym_iter_sdbquery_command] = STATE(273),
    [sym_iter_threads_command] = STATE(273),
    [sym_iter_bbs_command] = STATE(273),
    [sym_iter_instrs_command] = STATE(273),
    [sym_iter_sections_command] = STATE(273),
    [sym_iter_functions_command] = STATE(273),
    [sym_iter_step_command] = STATE(273),
    [sym_iter_interpret_command] = STATE(273),
    [sym_iter_hit_command] = STATE(273),
    [sym_tmp_seek_command] = STATE(273),
    [sym_tmp_blksz_command] = STATE(273),
    [sym_tmp_fromto_command] = STATE(273),
    [sym_tmp_arch_command] = STATE(273),
    [sym_tmp_bits_command] = STATE(273),
    [sym_tmp_nthi_command] = STATE(273),
    [sym_tmp_eval_command] = STATE(273),
    [sym_tmp_fs_command] = STATE(273),
    [sym_tmp_reli_command] = STATE(273),
    [sym_tmp_kuery_command] = STATE(273),
    [sym_tmp_fd_command] = STATE(273),
    [sym_tmp_reg_command] = STATE(273),
    [sym_tmp_file_command] = STATE(273),
    [sym_tmp_string_command] = STATE(273),
    [sym_tmp_hex_command] = STATE(273),
    [sym_task_command] = STATE(273),
    [sym_number_command] = STATE(273),
    [sym_help_command] = STATE(273),
    [sym_arged_command] = STATE(273),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(273),
    [sym_Cf_cmd] = STATE(273),
    [sym_pf_new_cmd] = STATE(273),
    [sym_pf_dot_cmd] = STATE(273),
    [sym_pf_cmd] = STATE(273),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(273),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(273),
    [sym__dec_number] = STATE(6),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_PIPEH] = ACTIONS(67),
    [anon_sym_PIPET] = ACTIONS(67),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(67),
    [anon_sym_AT_AT_ATb] = ACTIONS(67),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATi] = ACTIONS(67),
    [anon_sym_AT_AT_ATr] = ACTIONS(67),
    [anon_sym_AT_AT_ATs] = ACTIONS(69),
    [anon_sym_AT_AT_ATst] = ACTIONS(67),
    [anon_sym_AT_AT_ATS] = ACTIONS(67),
    [anon_sym_AT_AT_ATm] = ACTIONS(67),
    [anon_sym_AT_AT_ATM] = ACTIONS(67),
    [anon_sym_AT_AT_ATf] = ACTIONS(69),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATF] = ACTIONS(69),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(67),
    [anon_sym_AT_AT_ATt] = ACTIONS(67),
    [anon_sym_AT_AT] = ACTIONS(69),
    [anon_sym_AT_ATdbt] = ACTIONS(69),
    [anon_sym_AT_ATdbta] = ACTIONS(67),
    [anon_sym_AT_ATdbtb] = ACTIONS(67),
    [anon_sym_AT_ATdbts] = ACTIONS(67),
    [anon_sym_AT_AT_DOT] = ACTIONS(67),
    [anon_sym_AT_AT_EQ] = ACTIONS(67),
    [anon_sym_AT_ATk] = ACTIONS(67),
    [anon_sym_AT_ATt] = ACTIONS(67),
    [anon_sym_AT_ATb] = ACTIONS(67),
    [anon_sym_AT_ATi] = ACTIONS(69),
    [anon_sym_AT_ATiS] = ACTIONS(67),
    [anon_sym_AT_ATf] = ACTIONS(67),
    [anon_sym_AT_ATs_COLON] = ACTIONS(67),
    [anon_sym_AT_ATc_COLON] = ACTIONS(67),
    [anon_sym_AT] = ACTIONS(69),
    [anon_sym_AT_BANG] = ACTIONS(67),
    [anon_sym_AT_LBRACE] = ACTIONS(67),
    [anon_sym_ATa_COLON] = ACTIONS(67),
    [anon_sym_ATb_COLON] = ACTIONS(67),
    [anon_sym_ATB_COLON] = ACTIONS(67),
    [anon_sym_ATe_COLON] = ACTIONS(67),
    [anon_sym_ATF_COLON] = ACTIONS(67),
    [anon_sym_ATi_COLON] = ACTIONS(67),
    [anon_sym_ATk_COLON] = ACTIONS(67),
    [anon_sym_ATo_COLON] = ACTIONS(67),
    [anon_sym_ATr_COLON] = ACTIONS(67),
    [anon_sym_ATf_COLON] = ACTIONS(67),
    [anon_sym_ATs_COLON] = ACTIONS(67),
    [anon_sym_ATx_COLON] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_PIPE_DOT] = ACTIONS(67),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(67),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_GT_GT] = ACTIONS(67),
    [sym_html_redirect_operator] = ACTIONS(69),
    [sym_html_append_operator] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(67),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(67),
  },
  [6] = {
    [sym_legacy_quoted_command] = STATE(216),
    [sym__simple_command] = STATE(216),
    [sym__tmp_command] = STATE(216),
    [sym__iter_command] = STATE(216),
    [sym__foreach_command] = STATE(216),
    [sym__pipe_command] = STATE(216),
    [sym_grep_command] = STATE(216),
    [sym_html_disable_command] = STATE(216),
    [sym_html_enable_command] = STATE(216),
    [sym_scr_tts_command] = STATE(216),
    [sym_pipe_command] = STATE(216),
    [sym_foreach_addrsize_command] = STATE(216),
    [sym_foreach_bb_command] = STATE(216),
    [sym_foreach_cmd_command] = STATE(216),
    [sym_foreach_comment_command] = STATE(216),
    [sym_foreach_import_command] = STATE(216),
    [sym_foreach_register_command] = STATE(216),
    [sym_foreach_symbol_command] = STATE(216),
    [sym_foreach_string_command] = STATE(216),
    [sym_foreach_section_command] = STATE(216),
    [sym_foreach_iomap_command] = STATE(216),
    [sym_foreach_dbgmap_command] = STATE(216),
    [sym_foreach_flag_command] = STATE(216),
    [sym_foreach_function_command] = STATE(216),
    [sym_foreach_thread_command] = STATE(216),
    [sym_iter_flags_command] = STATE(216),
    [sym_iter_dbta_command] = STATE(216),
    [sym_iter_dbtb_command] = STATE(216),
    [sym_iter_dbts_command] = STATE(216),
    [sym_iter_file_lines_command] = STATE(216),
    [sym_iter_offsets_command] = STATE(216),
    [sym_iter_sdbquery_command] = STATE(216),
    [sym_iter_threads_command] = STATE(216),
    [sym_iter_bbs_command] = STATE(216),
    [sym_iter_instrs_command] = STATE(216),
    [sym_iter_sections_command] = STATE(216),
    [sym_iter_functions_command] = STATE(216),
    [sym_iter_step_command] = STATE(216),
    [sym_iter_interpret_command] = STATE(216),
    [sym_iter_hit_command] = STATE(216),
    [sym_tmp_seek_command] = STATE(216),
    [sym_tmp_blksz_command] = STATE(216),
    [sym_tmp_fromto_command] = STATE(216),
    [sym_tmp_arch_command] = STATE(216),
    [sym_tmp_bits_command] = STATE(216),
    [sym_tmp_nthi_command] = STATE(216),
    [sym_tmp_eval_command] = STATE(216),
    [sym_tmp_fs_command] = STATE(216),
    [sym_tmp_reli_command] = STATE(216),
    [sym_tmp_kuery_command] = STATE(216),
    [sym_tmp_fd_command] = STATE(216),
    [sym_tmp_reg_command] = STATE(216),
    [sym_tmp_file_command] = STATE(216),
    [sym_tmp_string_command] = STATE(216),
    [sym_tmp_hex_command] = STATE(216),
    [sym_task_command] = STATE(216),
    [sym_number_command] = STATE(216),
    [sym_help_command] = STATE(216),
    [sym_arged_command] = STATE(216),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(216),
    [sym_Cf_cmd] = STATE(216),
    [sym_pf_new_cmd] = STATE(216),
    [sym_pf_dot_cmd] = STATE(216),
    [sym_pf_cmd] = STATE(216),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(216),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(216),
    [sym__dec_number] = STATE(6),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PIPEH] = ACTIONS(71),
    [anon_sym_PIPET] = ACTIONS(71),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(71),
    [anon_sym_AT_AT_ATb] = ACTIONS(71),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATi] = ACTIONS(71),
    [anon_sym_AT_AT_ATr] = ACTIONS(71),
    [anon_sym_AT_AT_ATs] = ACTIONS(73),
    [anon_sym_AT_AT_ATst] = ACTIONS(71),
    [anon_sym_AT_AT_ATS] = ACTIONS(71),
    [anon_sym_AT_AT_ATm] = ACTIONS(71),
    [anon_sym_AT_AT_ATM] = ACTIONS(71),
    [anon_sym_AT_AT_ATf] = ACTIONS(73),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATF] = ACTIONS(73),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(71),
    [anon_sym_AT_AT_ATt] = ACTIONS(71),
    [anon_sym_AT_AT] = ACTIONS(73),
    [anon_sym_AT_ATdbt] = ACTIONS(73),
    [anon_sym_AT_ATdbta] = ACTIONS(71),
    [anon_sym_AT_ATdbtb] = ACTIONS(71),
    [anon_sym_AT_ATdbts] = ACTIONS(71),
    [anon_sym_AT_AT_DOT] = ACTIONS(71),
    [anon_sym_AT_AT_EQ] = ACTIONS(71),
    [anon_sym_AT_ATk] = ACTIONS(71),
    [anon_sym_AT_ATt] = ACTIONS(71),
    [anon_sym_AT_ATb] = ACTIONS(71),
    [anon_sym_AT_ATi] = ACTIONS(73),
    [anon_sym_AT_ATiS] = ACTIONS(71),
    [anon_sym_AT_ATf] = ACTIONS(71),
    [anon_sym_AT_ATs_COLON] = ACTIONS(71),
    [anon_sym_AT_ATc_COLON] = ACTIONS(71),
    [anon_sym_AT] = ACTIONS(73),
    [anon_sym_AT_BANG] = ACTIONS(71),
    [anon_sym_AT_LBRACE] = ACTIONS(71),
    [anon_sym_ATa_COLON] = ACTIONS(71),
    [anon_sym_ATb_COLON] = ACTIONS(71),
    [anon_sym_ATB_COLON] = ACTIONS(71),
    [anon_sym_ATe_COLON] = ACTIONS(71),
    [anon_sym_ATF_COLON] = ACTIONS(71),
    [anon_sym_ATi_COLON] = ACTIONS(71),
    [anon_sym_ATk_COLON] = ACTIONS(71),
    [anon_sym_ATo_COLON] = ACTIONS(71),
    [anon_sym_ATr_COLON] = ACTIONS(71),
    [anon_sym_ATf_COLON] = ACTIONS(71),
    [anon_sym_ATs_COLON] = ACTIONS(71),
    [anon_sym_ATx_COLON] = ACTIONS(71),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_PIPE_DOT] = ACTIONS(71),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_GT_GT] = ACTIONS(71),
    [sym_html_redirect_operator] = ACTIONS(73),
    [sym_html_append_operator] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(71),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(71),
  },
  [7] = {
    [sym_legacy_quoted_command] = STATE(264),
    [sym__simple_command] = STATE(264),
    [sym__tmp_command] = STATE(264),
    [sym__iter_command] = STATE(264),
    [sym__foreach_command] = STATE(264),
    [sym__pipe_command] = STATE(264),
    [sym_grep_command] = STATE(264),
    [sym_html_disable_command] = STATE(264),
    [sym_html_enable_command] = STATE(264),
    [sym_scr_tts_command] = STATE(264),
    [sym_pipe_command] = STATE(264),
    [sym_foreach_addrsize_command] = STATE(264),
    [sym_foreach_bb_command] = STATE(264),
    [sym_foreach_cmd_command] = STATE(264),
    [sym_foreach_comment_command] = STATE(264),
    [sym_foreach_import_command] = STATE(264),
    [sym_foreach_register_command] = STATE(264),
    [sym_foreach_symbol_command] = STATE(264),
    [sym_foreach_string_command] = STATE(264),
    [sym_foreach_section_command] = STATE(264),
    [sym_foreach_iomap_command] = STATE(264),
    [sym_foreach_dbgmap_command] = STATE(264),
    [sym_foreach_flag_command] = STATE(264),
    [sym_foreach_function_command] = STATE(264),
    [sym_foreach_thread_command] = STATE(264),
    [sym_iter_flags_command] = STATE(264),
    [sym_iter_dbta_command] = STATE(264),
    [sym_iter_dbtb_command] = STATE(264),
    [sym_iter_dbts_command] = STATE(264),
    [sym_iter_file_lines_command] = STATE(264),
    [sym_iter_offsets_command] = STATE(264),
    [sym_iter_sdbquery_command] = STATE(264),
    [sym_iter_threads_command] = STATE(264),
    [sym_iter_bbs_command] = STATE(264),
    [sym_iter_instrs_command] = STATE(264),
    [sym_iter_sections_command] = STATE(264),
    [sym_iter_functions_command] = STATE(264),
    [sym_iter_step_command] = STATE(264),
    [sym_iter_interpret_command] = STATE(264),
    [sym_iter_hit_command] = STATE(264),
    [sym_tmp_seek_command] = STATE(264),
    [sym_tmp_blksz_command] = STATE(264),
    [sym_tmp_fromto_command] = STATE(264),
    [sym_tmp_arch_command] = STATE(264),
    [sym_tmp_bits_command] = STATE(264),
    [sym_tmp_nthi_command] = STATE(264),
    [sym_tmp_eval_command] = STATE(264),
    [sym_tmp_fs_command] = STATE(264),
    [sym_tmp_reli_command] = STATE(264),
    [sym_tmp_kuery_command] = STATE(264),
    [sym_tmp_fd_command] = STATE(264),
    [sym_tmp_reg_command] = STATE(264),
    [sym_tmp_file_command] = STATE(264),
    [sym_tmp_string_command] = STATE(264),
    [sym_tmp_hex_command] = STATE(264),
    [sym_task_command] = STATE(264),
    [sym_number_command] = STATE(264),
    [sym_help_command] = STATE(264),
    [sym_arged_command] = STATE(264),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(264),
    [sym_Cf_cmd] = STATE(264),
    [sym_pf_new_cmd] = STATE(264),
    [sym_pf_dot_cmd] = STATE(264),
    [sym_pf_cmd] = STATE(264),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(264),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(264),
    [sym__dec_number] = STATE(6),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_PIPE] = ACTIONS(65),
    [anon_sym_PIPEH] = ACTIONS(63),
    [anon_sym_PIPET] = ACTIONS(63),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATi] = ACTIONS(63),
    [anon_sym_AT_AT_ATr] = ACTIONS(63),
    [anon_sym_AT_AT_ATs] = ACTIONS(65),
    [anon_sym_AT_AT_ATst] = ACTIONS(63),
    [anon_sym_AT_AT_ATS] = ACTIONS(63),
    [anon_sym_AT_AT_ATm] = ACTIONS(63),
    [anon_sym_AT_AT_ATM] = ACTIONS(63),
    [anon_sym_AT_AT_ATf] = ACTIONS(65),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATF] = ACTIONS(65),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_AT] = ACTIONS(65),
    [anon_sym_AT_ATdbt] = ACTIONS(65),
    [anon_sym_AT_ATdbta] = ACTIONS(63),
    [anon_sym_AT_ATdbtb] = ACTIONS(63),
    [anon_sym_AT_ATdbts] = ACTIONS(63),
    [anon_sym_AT_AT_DOT] = ACTIONS(63),
    [anon_sym_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_ATk] = ACTIONS(63),
    [anon_sym_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_ATi] = ACTIONS(65),
    [anon_sym_AT_ATiS] = ACTIONS(63),
    [anon_sym_AT_ATf] = ACTIONS(63),
    [anon_sym_AT_ATs_COLON] = ACTIONS(63),
    [anon_sym_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_AT_BANG] = ACTIONS(63),
    [anon_sym_AT_LBRACE] = ACTIONS(63),
    [anon_sym_ATa_COLON] = ACTIONS(63),
    [anon_sym_ATb_COLON] = ACTIONS(63),
    [anon_sym_ATB_COLON] = ACTIONS(63),
    [anon_sym_ATe_COLON] = ACTIONS(63),
    [anon_sym_ATF_COLON] = ACTIONS(63),
    [anon_sym_ATi_COLON] = ACTIONS(63),
    [anon_sym_ATk_COLON] = ACTIONS(63),
    [anon_sym_ATo_COLON] = ACTIONS(63),
    [anon_sym_ATr_COLON] = ACTIONS(63),
    [anon_sym_ATf_COLON] = ACTIONS(63),
    [anon_sym_ATs_COLON] = ACTIONS(63),
    [anon_sym_ATx_COLON] = ACTIONS(63),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_PIPE_DOT] = ACTIONS(63),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_GT_GT] = ACTIONS(63),
    [sym_html_redirect_operator] = ACTIONS(65),
    [sym_html_append_operator] = ACTIONS(63),
    [anon_sym_BQUOTE] = ACTIONS(63),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(63),
  },
  [8] = {
    [sym__command] = STATE(480),
    [sym_legacy_quoted_command] = STATE(194),
    [sym__simple_command] = STATE(194),
    [sym__tmp_command] = STATE(194),
    [sym__iter_command] = STATE(194),
    [sym__foreach_command] = STATE(194),
    [sym__pipe_command] = STATE(194),
    [sym_grep_command] = STATE(194),
    [sym_html_disable_command] = STATE(194),
    [sym_html_enable_command] = STATE(194),
    [sym_scr_tts_command] = STATE(194),
    [sym_pipe_command] = STATE(194),
    [sym_foreach_addrsize_command] = STATE(194),
    [sym_foreach_bb_command] = STATE(194),
    [sym_foreach_cmd_command] = STATE(194),
    [sym_foreach_comment_command] = STATE(194),
    [sym_foreach_import_command] = STATE(194),
    [sym_foreach_register_command] = STATE(194),
    [sym_foreach_symbol_command] = STATE(194),
    [sym_foreach_string_command] = STATE(194),
    [sym_foreach_section_command] = STATE(194),
    [sym_foreach_iomap_command] = STATE(194),
    [sym_foreach_dbgmap_command] = STATE(194),
    [sym_foreach_flag_command] = STATE(194),
    [sym_foreach_function_command] = STATE(194),
    [sym_foreach_thread_command] = STATE(194),
    [sym_iter_flags_command] = STATE(194),
    [sym_iter_dbta_command] = STATE(194),
    [sym_iter_dbtb_command] = STATE(194),
    [sym_iter_dbts_command] = STATE(194),
    [sym_iter_file_lines_command] = STATE(194),
    [sym_iter_offsets_command] = STATE(194),
    [sym_iter_sdbquery_command] = STATE(194),
    [sym_iter_threads_command] = STATE(194),
    [sym_iter_bbs_command] = STATE(194),
    [sym_iter_instrs_command] = STATE(194),
    [sym_iter_sections_command] = STATE(194),
    [sym_iter_functions_command] = STATE(194),
    [sym_iter_step_command] = STATE(194),
    [sym_iter_interpret_command] = STATE(194),
    [sym_iter_hit_command] = STATE(194),
    [sym_tmp_seek_command] = STATE(194),
    [sym_tmp_blksz_command] = STATE(194),
    [sym_tmp_fromto_command] = STATE(194),
    [sym_tmp_arch_command] = STATE(194),
    [sym_tmp_bits_command] = STATE(194),
    [sym_tmp_nthi_command] = STATE(194),
    [sym_tmp_eval_command] = STATE(194),
    [sym_tmp_fs_command] = STATE(194),
    [sym_tmp_reli_command] = STATE(194),
    [sym_tmp_kuery_command] = STATE(194),
    [sym_tmp_fd_command] = STATE(194),
    [sym_tmp_reg_command] = STATE(194),
    [sym_tmp_file_command] = STATE(194),
    [sym_tmp_string_command] = STATE(194),
    [sym_tmp_hex_command] = STATE(194),
    [sym_task_command] = STATE(194),
    [sym_number_command] = STATE(194),
    [sym_help_command] = STATE(194),
    [sym_arged_command] = STATE(194),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(194),
    [sym_Cf_cmd] = STATE(194),
    [sym_pf_new_cmd] = STATE(194),
    [sym_pf_dot_cmd] = STATE(194),
    [sym_pf_cmd] = STATE(194),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(194),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(194),
    [sym_redirect_command] = STATE(480),
    [sym__dec_number] = STATE(4),
    [aux_sym_commands_repeat1] = STATE(295),
    [ts_builtin_sym_end] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(103),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(103),
    [anon_sym_CR] = ACTIONS(103),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [9] = {
    [sym__command] = STATE(499),
    [sym_legacy_quoted_command] = STATE(194),
    [sym__simple_command] = STATE(194),
    [sym__tmp_command] = STATE(194),
    [sym__iter_command] = STATE(194),
    [sym__foreach_command] = STATE(194),
    [sym__pipe_command] = STATE(194),
    [sym_grep_command] = STATE(194),
    [sym_html_disable_command] = STATE(194),
    [sym_html_enable_command] = STATE(194),
    [sym_scr_tts_command] = STATE(194),
    [sym_pipe_command] = STATE(194),
    [sym_foreach_addrsize_command] = STATE(194),
    [sym_foreach_bb_command] = STATE(194),
    [sym_foreach_cmd_command] = STATE(194),
    [sym_foreach_comment_command] = STATE(194),
    [sym_foreach_import_command] = STATE(194),
    [sym_foreach_register_command] = STATE(194),
    [sym_foreach_symbol_command] = STATE(194),
    [sym_foreach_string_command] = STATE(194),
    [sym_foreach_section_command] = STATE(194),
    [sym_foreach_iomap_command] = STATE(194),
    [sym_foreach_dbgmap_command] = STATE(194),
    [sym_foreach_flag_command] = STATE(194),
    [sym_foreach_function_command] = STATE(194),
    [sym_foreach_thread_command] = STATE(194),
    [sym_iter_flags_command] = STATE(194),
    [sym_iter_dbta_command] = STATE(194),
    [sym_iter_dbtb_command] = STATE(194),
    [sym_iter_dbts_command] = STATE(194),
    [sym_iter_file_lines_command] = STATE(194),
    [sym_iter_offsets_command] = STATE(194),
    [sym_iter_sdbquery_command] = STATE(194),
    [sym_iter_threads_command] = STATE(194),
    [sym_iter_bbs_command] = STATE(194),
    [sym_iter_instrs_command] = STATE(194),
    [sym_iter_sections_command] = STATE(194),
    [sym_iter_functions_command] = STATE(194),
    [sym_iter_step_command] = STATE(194),
    [sym_iter_interpret_command] = STATE(194),
    [sym_iter_hit_command] = STATE(194),
    [sym_tmp_seek_command] = STATE(194),
    [sym_tmp_blksz_command] = STATE(194),
    [sym_tmp_fromto_command] = STATE(194),
    [sym_tmp_arch_command] = STATE(194),
    [sym_tmp_bits_command] = STATE(194),
    [sym_tmp_nthi_command] = STATE(194),
    [sym_tmp_eval_command] = STATE(194),
    [sym_tmp_fs_command] = STATE(194),
    [sym_tmp_reli_command] = STATE(194),
    [sym_tmp_kuery_command] = STATE(194),
    [sym_tmp_fd_command] = STATE(194),
    [sym_tmp_reg_command] = STATE(194),
    [sym_tmp_file_command] = STATE(194),
    [sym_tmp_string_command] = STATE(194),
    [sym_tmp_hex_command] = STATE(194),
    [sym_task_command] = STATE(194),
    [sym_number_command] = STATE(194),
    [sym_help_command] = STATE(194),
    [sym_arged_command] = STATE(194),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(194),
    [sym_Cf_cmd] = STATE(194),
    [sym_pf_new_cmd] = STATE(194),
    [sym_pf_dot_cmd] = STATE(194),
    [sym_pf_cmd] = STATE(194),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(194),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(194),
    [sym_redirect_command] = STATE(499),
    [sym__dec_number] = STATE(4),
    [ts_builtin_sym_end] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(105),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(105),
    [anon_sym_CR] = ACTIONS(105),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [10] = {
    [sym__commands_singleline] = STATE(547),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [11] = {
    [sym__commands_singleline] = STATE(562),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [12] = {
    [sym__commands_singleline] = STATE(554),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [13] = {
    [sym__commands_singleline] = STATE(553),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [14] = {
    [sym__commands_singleline] = STATE(571),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [15] = {
    [sym__commands_singleline] = STATE(552),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [16] = {
    [sym__commands_singleline] = STATE(551),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [17] = {
    [sym__commands_singleline] = STATE(550),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [18] = {
    [sym__commands_singleline] = STATE(549),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [19] = {
    [sym__commands_singleline] = STATE(569),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [20] = {
    [sym__commands_singleline] = STATE(558),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [21] = {
    [sym__commands_singleline] = STATE(548),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [22] = {
    [sym__commands_singleline] = STATE(566),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [23] = {
    [sym__commands_singleline] = STATE(556),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [24] = {
    [sym__commands_singleline] = STATE(572),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [25] = {
    [sym__commands_singleline] = STATE(546),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [26] = {
    [sym__commands_singleline] = STATE(591),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [27] = {
    [sym__commands_singleline] = STATE(564),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [28] = {
    [sym__commands_singleline] = STATE(545),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [29] = {
    [sym__commands_singleline] = STATE(555),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [30] = {
    [sym__commands_singleline] = STATE(576),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [31] = {
    [sym__commands_singleline] = STATE(559),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [32] = {
    [sym__commands_singleline] = STATE(578),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [33] = {
    [sym__commands_singleline] = STATE(588),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [34] = {
    [sym__commands_singleline] = STATE(557),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [35] = {
    [sym__commands_singleline] = STATE(542),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [36] = {
    [sym__commands_singleline] = STATE(582),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [37] = {
    [sym__commands_singleline] = STATE(541),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [38] = {
    [sym__commands_singleline] = STATE(583),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [39] = {
    [sym__commands_singleline] = STATE(544),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [40] = {
    [sym__commands_singleline] = STATE(567),
    [sym__command] = STATE(515),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(515),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(107),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [41] = {
    [sym__commands_singleline] = STATE(570),
    [sym__command] = STATE(505),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(505),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(42),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [42] = {
    [sym__command] = STATE(517),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(517),
    [sym__dec_number] = STATE(6),
    [aux_sym__commands_singleline_repeat1] = STATE(296),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(111),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [43] = {
    [sym__command] = STATE(504),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(504),
    [sym__dec_number] = STATE(4),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(113),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [44] = {
    [sym__command] = STATE(519),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(519),
    [sym__dec_number] = STATE(4),
    [aux_sym__commands_singleline_repeat1] = STATE(296),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(111),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [45] = {
    [sym__command] = STATE(504),
    [sym_legacy_quoted_command] = STATE(287),
    [sym__simple_command] = STATE(287),
    [sym__tmp_command] = STATE(287),
    [sym__iter_command] = STATE(287),
    [sym__foreach_command] = STATE(287),
    [sym__pipe_command] = STATE(287),
    [sym_grep_command] = STATE(287),
    [sym_html_disable_command] = STATE(287),
    [sym_html_enable_command] = STATE(287),
    [sym_scr_tts_command] = STATE(287),
    [sym_pipe_command] = STATE(287),
    [sym_foreach_addrsize_command] = STATE(287),
    [sym_foreach_bb_command] = STATE(287),
    [sym_foreach_cmd_command] = STATE(287),
    [sym_foreach_comment_command] = STATE(287),
    [sym_foreach_import_command] = STATE(287),
    [sym_foreach_register_command] = STATE(287),
    [sym_foreach_symbol_command] = STATE(287),
    [sym_foreach_string_command] = STATE(287),
    [sym_foreach_section_command] = STATE(287),
    [sym_foreach_iomap_command] = STATE(287),
    [sym_foreach_dbgmap_command] = STATE(287),
    [sym_foreach_flag_command] = STATE(287),
    [sym_foreach_function_command] = STATE(287),
    [sym_foreach_thread_command] = STATE(287),
    [sym_iter_flags_command] = STATE(287),
    [sym_iter_dbta_command] = STATE(287),
    [sym_iter_dbtb_command] = STATE(287),
    [sym_iter_dbts_command] = STATE(287),
    [sym_iter_file_lines_command] = STATE(287),
    [sym_iter_offsets_command] = STATE(287),
    [sym_iter_sdbquery_command] = STATE(287),
    [sym_iter_threads_command] = STATE(287),
    [sym_iter_bbs_command] = STATE(287),
    [sym_iter_instrs_command] = STATE(287),
    [sym_iter_sections_command] = STATE(287),
    [sym_iter_functions_command] = STATE(287),
    [sym_iter_step_command] = STATE(287),
    [sym_iter_interpret_command] = STATE(287),
    [sym_iter_hit_command] = STATE(287),
    [sym_tmp_seek_command] = STATE(287),
    [sym_tmp_blksz_command] = STATE(287),
    [sym_tmp_fromto_command] = STATE(287),
    [sym_tmp_arch_command] = STATE(287),
    [sym_tmp_bits_command] = STATE(287),
    [sym_tmp_nthi_command] = STATE(287),
    [sym_tmp_eval_command] = STATE(287),
    [sym_tmp_fs_command] = STATE(287),
    [sym_tmp_reli_command] = STATE(287),
    [sym_tmp_kuery_command] = STATE(287),
    [sym_tmp_fd_command] = STATE(287),
    [sym_tmp_reg_command] = STATE(287),
    [sym_tmp_file_command] = STATE(287),
    [sym_tmp_string_command] = STATE(287),
    [sym_tmp_hex_command] = STATE(287),
    [sym_task_command] = STATE(287),
    [sym_number_command] = STATE(287),
    [sym_help_command] = STATE(287),
    [sym_arged_command] = STATE(287),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(287),
    [sym_Cf_cmd] = STATE(287),
    [sym_pf_new_cmd] = STATE(287),
    [sym_pf_dot_cmd] = STATE(287),
    [sym_pf_cmd] = STATE(287),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(287),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(287),
    [sym_redirect_command] = STATE(504),
    [sym__dec_number] = STATE(6),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [anon_sym_SEMI] = ACTIONS(113),
    [anon_sym_BQUOTE] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [46] = {
    [sym__command] = STATE(508),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(508),
    [sym__dec_number] = STATE(4),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [47] = {
    [sym__command] = STATE(522),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(522),
    [sym__dec_number] = STATE(4),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [48] = {
    [sym__command] = STATE(536),
    [sym_legacy_quoted_command] = STATE(288),
    [sym__simple_command] = STATE(288),
    [sym__tmp_command] = STATE(288),
    [sym__iter_command] = STATE(288),
    [sym__foreach_command] = STATE(288),
    [sym__pipe_command] = STATE(288),
    [sym_grep_command] = STATE(288),
    [sym_html_disable_command] = STATE(288),
    [sym_html_enable_command] = STATE(288),
    [sym_scr_tts_command] = STATE(288),
    [sym_pipe_command] = STATE(288),
    [sym_foreach_addrsize_command] = STATE(288),
    [sym_foreach_bb_command] = STATE(288),
    [sym_foreach_cmd_command] = STATE(288),
    [sym_foreach_comment_command] = STATE(288),
    [sym_foreach_import_command] = STATE(288),
    [sym_foreach_register_command] = STATE(288),
    [sym_foreach_symbol_command] = STATE(288),
    [sym_foreach_string_command] = STATE(288),
    [sym_foreach_section_command] = STATE(288),
    [sym_foreach_iomap_command] = STATE(288),
    [sym_foreach_dbgmap_command] = STATE(288),
    [sym_foreach_flag_command] = STATE(288),
    [sym_foreach_function_command] = STATE(288),
    [sym_foreach_thread_command] = STATE(288),
    [sym_iter_flags_command] = STATE(288),
    [sym_iter_dbta_command] = STATE(288),
    [sym_iter_dbtb_command] = STATE(288),
    [sym_iter_dbts_command] = STATE(288),
    [sym_iter_file_lines_command] = STATE(288),
    [sym_iter_offsets_command] = STATE(288),
    [sym_iter_sdbquery_command] = STATE(288),
    [sym_iter_threads_command] = STATE(288),
    [sym_iter_bbs_command] = STATE(288),
    [sym_iter_instrs_command] = STATE(288),
    [sym_iter_sections_command] = STATE(288),
    [sym_iter_functions_command] = STATE(288),
    [sym_iter_step_command] = STATE(288),
    [sym_iter_interpret_command] = STATE(288),
    [sym_iter_hit_command] = STATE(288),
    [sym_tmp_seek_command] = STATE(288),
    [sym_tmp_blksz_command] = STATE(288),
    [sym_tmp_fromto_command] = STATE(288),
    [sym_tmp_arch_command] = STATE(288),
    [sym_tmp_bits_command] = STATE(288),
    [sym_tmp_nthi_command] = STATE(288),
    [sym_tmp_eval_command] = STATE(288),
    [sym_tmp_fs_command] = STATE(288),
    [sym_tmp_reli_command] = STATE(288),
    [sym_tmp_kuery_command] = STATE(288),
    [sym_tmp_fd_command] = STATE(288),
    [sym_tmp_reg_command] = STATE(288),
    [sym_tmp_file_command] = STATE(288),
    [sym_tmp_string_command] = STATE(288),
    [sym_tmp_hex_command] = STATE(288),
    [sym_task_command] = STATE(288),
    [sym_number_command] = STATE(288),
    [sym_help_command] = STATE(288),
    [sym_arged_command] = STATE(288),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(288),
    [sym_Cf_cmd] = STATE(288),
    [sym_pf_new_cmd] = STATE(288),
    [sym_pf_dot_cmd] = STATE(288),
    [sym_pf_cmd] = STATE(288),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(288),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(288),
    [sym_redirect_command] = STATE(536),
    [sym__dec_number] = STATE(4),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [49] = {
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(285),
    [sym__dec_number] = STATE(4),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [50] = {
    [sym_legacy_quoted_command] = STATE(286),
    [sym__simple_command] = STATE(286),
    [sym__tmp_command] = STATE(286),
    [sym__iter_command] = STATE(286),
    [sym__foreach_command] = STATE(286),
    [sym__pipe_command] = STATE(286),
    [sym_grep_command] = STATE(286),
    [sym_html_disable_command] = STATE(286),
    [sym_html_enable_command] = STATE(286),
    [sym_scr_tts_command] = STATE(286),
    [sym_pipe_command] = STATE(286),
    [sym_foreach_addrsize_command] = STATE(286),
    [sym_foreach_bb_command] = STATE(286),
    [sym_foreach_cmd_command] = STATE(286),
    [sym_foreach_comment_command] = STATE(286),
    [sym_foreach_import_command] = STATE(286),
    [sym_foreach_register_command] = STATE(286),
    [sym_foreach_symbol_command] = STATE(286),
    [sym_foreach_string_command] = STATE(286),
    [sym_foreach_section_command] = STATE(286),
    [sym_foreach_iomap_command] = STATE(286),
    [sym_foreach_dbgmap_command] = STATE(286),
    [sym_foreach_flag_command] = STATE(286),
    [sym_foreach_function_command] = STATE(286),
    [sym_foreach_thread_command] = STATE(286),
    [sym_iter_flags_command] = STATE(286),
    [sym_iter_dbta_command] = STATE(286),
    [sym_iter_dbtb_command] = STATE(286),
    [sym_iter_dbts_command] = STATE(286),
    [sym_iter_file_lines_command] = STATE(286),
    [sym_iter_offsets_command] = STATE(286),
    [sym_iter_sdbquery_command] = STATE(286),
    [sym_iter_threads_command] = STATE(286),
    [sym_iter_bbs_command] = STATE(286),
    [sym_iter_instrs_command] = STATE(286),
    [sym_iter_sections_command] = STATE(286),
    [sym_iter_functions_command] = STATE(286),
    [sym_iter_step_command] = STATE(286),
    [sym_iter_interpret_command] = STATE(286),
    [sym_iter_hit_command] = STATE(286),
    [sym_tmp_seek_command] = STATE(286),
    [sym_tmp_blksz_command] = STATE(286),
    [sym_tmp_fromto_command] = STATE(286),
    [sym_tmp_arch_command] = STATE(286),
    [sym_tmp_bits_command] = STATE(286),
    [sym_tmp_nthi_command] = STATE(286),
    [sym_tmp_eval_command] = STATE(286),
    [sym_tmp_fs_command] = STATE(286),
    [sym_tmp_reli_command] = STATE(286),
    [sym_tmp_kuery_command] = STATE(286),
    [sym_tmp_fd_command] = STATE(286),
    [sym_tmp_reg_command] = STATE(286),
    [sym_tmp_file_command] = STATE(286),
    [sym_tmp_string_command] = STATE(286),
    [sym_tmp_hex_command] = STATE(286),
    [sym_task_command] = STATE(286),
    [sym_number_command] = STATE(286),
    [sym_help_command] = STATE(286),
    [sym_arged_command] = STATE(286),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(317),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(286),
    [sym_Cf_cmd] = STATE(286),
    [sym_pf_new_cmd] = STATE(286),
    [sym_pf_dot_cmd] = STATE(286),
    [sym_pf_cmd] = STATE(286),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(84),
    [sym_last_command] = STATE(286),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(54),
    [sym_repeat_command] = STATE(286),
    [sym__dec_number] = STATE(4),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(9),
    [anon_sym_AMPt] = ACTIONS(9),
    [aux_sym_task_command_token1] = ACTIONS(11),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(17),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(25),
    [anon_sym_Cf] = ACTIONS(27),
    [sym_pf_dot_cmd_identifier] = ACTIONS(29),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(31),
    [aux_sym_pf_cmd_token1] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(43),
    [sym_question_mark_identifier] = ACTIONS(45),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(49),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(59),
    [sym__help_command] = ACTIONS(61),
  },
  [51] = {
    [sym_legacy_quoted_command] = STATE(294),
    [sym__simple_command] = STATE(294),
    [sym__tmp_command] = STATE(294),
    [sym__iter_command] = STATE(294),
    [sym__foreach_command] = STATE(294),
    [sym__pipe_command] = STATE(294),
    [sym_grep_command] = STATE(294),
    [sym_html_disable_command] = STATE(294),
    [sym_html_enable_command] = STATE(294),
    [sym_scr_tts_command] = STATE(294),
    [sym_pipe_command] = STATE(294),
    [sym_foreach_addrsize_command] = STATE(294),
    [sym_foreach_bb_command] = STATE(294),
    [sym_foreach_cmd_command] = STATE(294),
    [sym_foreach_comment_command] = STATE(294),
    [sym_foreach_import_command] = STATE(294),
    [sym_foreach_register_command] = STATE(294),
    [sym_foreach_symbol_command] = STATE(294),
    [sym_foreach_string_command] = STATE(294),
    [sym_foreach_section_command] = STATE(294),
    [sym_foreach_iomap_command] = STATE(294),
    [sym_foreach_dbgmap_command] = STATE(294),
    [sym_foreach_flag_command] = STATE(294),
    [sym_foreach_function_command] = STATE(294),
    [sym_foreach_thread_command] = STATE(294),
    [sym_iter_flags_command] = STATE(294),
    [sym_iter_dbta_command] = STATE(294),
    [sym_iter_dbtb_command] = STATE(294),
    [sym_iter_dbts_command] = STATE(294),
    [sym_iter_file_lines_command] = STATE(294),
    [sym_iter_offsets_command] = STATE(294),
    [sym_iter_sdbquery_command] = STATE(294),
    [sym_iter_threads_command] = STATE(294),
    [sym_iter_bbs_command] = STATE(294),
    [sym_iter_instrs_command] = STATE(294),
    [sym_iter_sections_command] = STATE(294),
    [sym_iter_functions_command] = STATE(294),
    [sym_iter_step_command] = STATE(294),
    [sym_iter_interpret_command] = STATE(294),
    [sym_iter_hit_command] = STATE(294),
    [sym_tmp_seek_command] = STATE(294),
    [sym_tmp_blksz_command] = STATE(294),
    [sym_tmp_fromto_command] = STATE(294),
    [sym_tmp_arch_command] = STATE(294),
    [sym_tmp_bits_command] = STATE(294),
    [sym_tmp_nthi_command] = STATE(294),
    [sym_tmp_eval_command] = STATE(294),
    [sym_tmp_fs_command] = STATE(294),
    [sym_tmp_reli_command] = STATE(294),
    [sym_tmp_kuery_command] = STATE(294),
    [sym_tmp_fd_command] = STATE(294),
    [sym_tmp_reg_command] = STATE(294),
    [sym_tmp_file_command] = STATE(294),
    [sym_tmp_string_command] = STATE(294),
    [sym_tmp_hex_command] = STATE(294),
    [sym_task_command] = STATE(294),
    [sym_number_command] = STATE(294),
    [sym_help_command] = STATE(294),
    [sym_arged_command] = STATE(294),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(294),
    [sym_Cf_cmd] = STATE(294),
    [sym_pf_new_cmd] = STATE(294),
    [sym_pf_dot_cmd] = STATE(294),
    [sym_pf_cmd] = STATE(294),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(294),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(294),
    [sym__dec_number] = STATE(6),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [52] = {
    [sym_legacy_quoted_command] = STATE(293),
    [sym__simple_command] = STATE(293),
    [sym__tmp_command] = STATE(293),
    [sym__iter_command] = STATE(293),
    [sym__foreach_command] = STATE(293),
    [sym__pipe_command] = STATE(293),
    [sym_grep_command] = STATE(293),
    [sym_html_disable_command] = STATE(293),
    [sym_html_enable_command] = STATE(293),
    [sym_scr_tts_command] = STATE(293),
    [sym_pipe_command] = STATE(293),
    [sym_foreach_addrsize_command] = STATE(293),
    [sym_foreach_bb_command] = STATE(293),
    [sym_foreach_cmd_command] = STATE(293),
    [sym_foreach_comment_command] = STATE(293),
    [sym_foreach_import_command] = STATE(293),
    [sym_foreach_register_command] = STATE(293),
    [sym_foreach_symbol_command] = STATE(293),
    [sym_foreach_string_command] = STATE(293),
    [sym_foreach_section_command] = STATE(293),
    [sym_foreach_iomap_command] = STATE(293),
    [sym_foreach_dbgmap_command] = STATE(293),
    [sym_foreach_flag_command] = STATE(293),
    [sym_foreach_function_command] = STATE(293),
    [sym_foreach_thread_command] = STATE(293),
    [sym_iter_flags_command] = STATE(293),
    [sym_iter_dbta_command] = STATE(293),
    [sym_iter_dbtb_command] = STATE(293),
    [sym_iter_dbts_command] = STATE(293),
    [sym_iter_file_lines_command] = STATE(293),
    [sym_iter_offsets_command] = STATE(293),
    [sym_iter_sdbquery_command] = STATE(293),
    [sym_iter_threads_command] = STATE(293),
    [sym_iter_bbs_command] = STATE(293),
    [sym_iter_instrs_command] = STATE(293),
    [sym_iter_sections_command] = STATE(293),
    [sym_iter_functions_command] = STATE(293),
    [sym_iter_step_command] = STATE(293),
    [sym_iter_interpret_command] = STATE(293),
    [sym_iter_hit_command] = STATE(293),
    [sym_tmp_seek_command] = STATE(293),
    [sym_tmp_blksz_command] = STATE(293),
    [sym_tmp_fromto_command] = STATE(293),
    [sym_tmp_arch_command] = STATE(293),
    [sym_tmp_bits_command] = STATE(293),
    [sym_tmp_nthi_command] = STATE(293),
    [sym_tmp_eval_command] = STATE(293),
    [sym_tmp_fs_command] = STATE(293),
    [sym_tmp_reli_command] = STATE(293),
    [sym_tmp_kuery_command] = STATE(293),
    [sym_tmp_fd_command] = STATE(293),
    [sym_tmp_reg_command] = STATE(293),
    [sym_tmp_file_command] = STATE(293),
    [sym_tmp_string_command] = STATE(293),
    [sym_tmp_hex_command] = STATE(293),
    [sym_task_command] = STATE(293),
    [sym_number_command] = STATE(293),
    [sym_help_command] = STATE(293),
    [sym_arged_command] = STATE(293),
    [sym__simple_arged_command] = STATE(254),
    [sym__math_arged_command] = STATE(254),
    [sym__pointer_arged_command] = STATE(254),
    [sym__macro_arged_command] = STATE(254),
    [sym__system_command] = STATE(254),
    [sym__interpret_command] = STATE(254),
    [sym__interpret_search_identifier] = STATE(311),
    [sym__pf_arged_command] = STATE(254),
    [sym__pf_commands] = STATE(293),
    [sym_Cf_cmd] = STATE(293),
    [sym_pf_new_cmd] = STATE(293),
    [sym_pf_dot_cmd] = STATE(293),
    [sym_pf_cmd] = STATE(293),
    [sym__env_command] = STATE(254),
    [sym__env_command_identifier] = STATE(106),
    [sym_last_command] = STATE(293),
    [sym_last_command_identifier] = STATE(258),
    [sym__interpret_identifier] = STATE(73),
    [sym_repeat_command] = STATE(293),
    [sym__dec_number] = STATE(6),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(75),
    [anon_sym_AMPt] = ACTIONS(75),
    [aux_sym_task_command_token1] = ACTIONS(77),
    [anon_sym_0] = ACTIONS(13),
    [aux_sym_number_command_token1] = ACTIONS(15),
    [anon_sym_DOT] = ACTIONS(79),
    [anon_sym_DOT_BANG] = ACTIONS(19),
    [anon_sym_DOT_LPAREN] = ACTIONS(21),
    [anon_sym_DOT_SLASH] = ACTIONS(23),
    [anon_sym_pfo] = ACTIONS(81),
    [anon_sym_Cf] = ACTIONS(83),
    [sym_pf_dot_cmd_identifier] = ACTIONS(85),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(87),
    [aux_sym_pf_cmd_token1] = ACTIONS(89),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym_env] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [aux_sym__interpret_identifier_token1] = ACTIONS(39),
    [aux_sym__interpret_identifier_token2] = ACTIONS(41),
    [sym_system_identifier] = ACTIONS(91),
    [sym_question_mark_identifier] = ACTIONS(93),
    [sym_pointer_identifier] = ACTIONS(47),
    [sym_macro_identifier] = ACTIONS(95),
    [aux_sym__dec_number_token1] = ACTIONS(53),
    [aux_sym__dec_number_token2] = ACTIONS(55),
    [sym__comment] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(97),
    [sym__help_command] = ACTIONS(99),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(115),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(115),
    [anon_sym_PIPE] = ACTIONS(117),
    [anon_sym_PIPEH] = ACTIONS(115),
    [anon_sym_PIPET] = ACTIONS(115),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(115),
    [anon_sym_AT_AT_ATb] = ACTIONS(115),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(115),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(115),
    [anon_sym_AT_AT_ATi] = ACTIONS(115),
    [anon_sym_AT_AT_ATr] = ACTIONS(115),
    [anon_sym_AT_AT_ATs] = ACTIONS(117),
    [anon_sym_AT_AT_ATst] = ACTIONS(115),
    [anon_sym_AT_AT_ATS] = ACTIONS(115),
    [anon_sym_AT_AT_ATm] = ACTIONS(115),
    [anon_sym_AT_AT_ATM] = ACTIONS(115),
    [anon_sym_AT_AT_ATf] = ACTIONS(117),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(115),
    [anon_sym_AT_AT_ATF] = ACTIONS(117),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(115),
    [anon_sym_AT_AT_ATt] = ACTIONS(115),
    [anon_sym_AT_AT] = ACTIONS(117),
    [anon_sym_AT_ATdbt] = ACTIONS(117),
    [anon_sym_AT_ATdbta] = ACTIONS(115),
    [anon_sym_AT_ATdbtb] = ACTIONS(115),
    [anon_sym_AT_ATdbts] = ACTIONS(115),
    [anon_sym_AT_AT_DOT] = ACTIONS(115),
    [anon_sym_AT_AT_EQ] = ACTIONS(115),
    [anon_sym_AT_ATk] = ACTIONS(115),
    [anon_sym_AT_ATt] = ACTIONS(115),
    [anon_sym_AT_ATb] = ACTIONS(115),
    [anon_sym_AT_ATi] = ACTIONS(117),
    [anon_sym_AT_ATiS] = ACTIONS(115),
    [anon_sym_AT_ATf] = ACTIONS(115),
    [anon_sym_AT_ATs_COLON] = ACTIONS(115),
    [anon_sym_AT_ATc_COLON] = ACTIONS(115),
    [anon_sym_AT] = ACTIONS(117),
    [anon_sym_AT_BANG] = ACTIONS(115),
    [anon_sym_AT_LBRACE] = ACTIONS(115),
    [anon_sym_ATa_COLON] = ACTIONS(115),
    [anon_sym_ATb_COLON] = ACTIONS(115),
    [anon_sym_ATB_COLON] = ACTIONS(115),
    [anon_sym_ATe_COLON] = ACTIONS(115),
    [anon_sym_ATF_COLON] = ACTIONS(115),
    [anon_sym_ATi_COLON] = ACTIONS(115),
    [anon_sym_ATk_COLON] = ACTIONS(115),
    [anon_sym_ATo_COLON] = ACTIONS(115),
    [anon_sym_ATr_COLON] = ACTIONS(115),
    [anon_sym_ATf_COLON] = ACTIONS(115),
    [anon_sym_ATs_COLON] = ACTIONS(115),
    [anon_sym_ATx_COLON] = ACTIONS(115),
    [anon_sym_AMP] = ACTIONS(117),
    [anon_sym_AMPt] = ACTIONS(117),
    [aux_sym_task_command_token1] = ACTIONS(117),
    [anon_sym_0] = ACTIONS(117),
    [aux_sym_number_command_token1] = ACTIONS(115),
    [anon_sym_DOT] = ACTIONS(117),
    [anon_sym_DOT_BANG] = ACTIONS(115),
    [anon_sym_DOT_LPAREN] = ACTIONS(115),
    [anon_sym_PIPE_DOT] = ACTIONS(115),
    [anon_sym_DOT_SLASH] = ACTIONS(115),
    [anon_sym_pfo] = ACTIONS(115),
    [anon_sym_Cf] = ACTIONS(115),
    [sym_pf_dot_cmd_identifier] = ACTIONS(115),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(115),
    [aux_sym_pf_cmd_token1] = ACTIONS(117),
    [anon_sym_RPAREN] = ACTIONS(115),
    [anon_sym_PERCENT] = ACTIONS(115),
    [anon_sym_env] = ACTIONS(115),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(117),
    [aux_sym__interpret_identifier_token1] = ACTIONS(117),
    [aux_sym__interpret_identifier_token2] = ACTIONS(115),
    [sym_system_identifier] = ACTIONS(115),
    [sym_question_mark_identifier] = ACTIONS(115),
    [sym_pointer_identifier] = ACTIONS(115),
    [sym_macro_identifier] = ACTIONS(115),
    [anon_sym_SEMI] = ACTIONS(115),
    [anon_sym_GT] = ACTIONS(117),
    [anon_sym_GT_GT] = ACTIONS(115),
    [sym_html_redirect_operator] = ACTIONS(117),
    [sym_html_append_operator] = ACTIONS(115),
    [anon_sym_BQUOTE] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(115),
    [aux_sym__dec_number_token2] = ACTIONS(117),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(115),
    [anon_sym_CR] = ACTIONS(115),
    [sym_cmd_identifier] = ACTIONS(115),
    [sym__help_command] = ACTIONS(115),
    [sym_file_descriptor] = ACTIONS(115),
  },
  [54] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(265),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(119),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PIPE] = ACTIONS(123),
    [anon_sym_PIPEH] = ACTIONS(119),
    [anon_sym_PIPET] = ACTIONS(119),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(119),
    [anon_sym_AT_AT_ATb] = ACTIONS(119),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATi] = ACTIONS(119),
    [anon_sym_AT_AT_ATr] = ACTIONS(119),
    [anon_sym_AT_AT_ATs] = ACTIONS(123),
    [anon_sym_AT_AT_ATst] = ACTIONS(119),
    [anon_sym_AT_AT_ATS] = ACTIONS(119),
    [anon_sym_AT_AT_ATm] = ACTIONS(119),
    [anon_sym_AT_AT_ATM] = ACTIONS(119),
    [anon_sym_AT_AT_ATf] = ACTIONS(123),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATF] = ACTIONS(123),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATt] = ACTIONS(119),
    [anon_sym_AT_AT] = ACTIONS(123),
    [anon_sym_AT_ATdbt] = ACTIONS(123),
    [anon_sym_AT_ATdbta] = ACTIONS(119),
    [anon_sym_AT_ATdbtb] = ACTIONS(119),
    [anon_sym_AT_ATdbts] = ACTIONS(119),
    [anon_sym_AT_AT_DOT] = ACTIONS(119),
    [anon_sym_AT_AT_EQ] = ACTIONS(119),
    [anon_sym_AT_ATk] = ACTIONS(119),
    [anon_sym_AT_ATt] = ACTIONS(119),
    [anon_sym_AT_ATb] = ACTIONS(119),
    [anon_sym_AT_ATi] = ACTIONS(123),
    [anon_sym_AT_ATiS] = ACTIONS(119),
    [anon_sym_AT_ATf] = ACTIONS(119),
    [anon_sym_AT_ATs_COLON] = ACTIONS(119),
    [anon_sym_AT_ATc_COLON] = ACTIONS(119),
    [anon_sym_AT] = ACTIONS(123),
    [anon_sym_AT_BANG] = ACTIONS(119),
    [anon_sym_AT_LBRACE] = ACTIONS(119),
    [anon_sym_ATa_COLON] = ACTIONS(119),
    [anon_sym_ATb_COLON] = ACTIONS(119),
    [anon_sym_ATB_COLON] = ACTIONS(119),
    [anon_sym_ATe_COLON] = ACTIONS(119),
    [anon_sym_ATF_COLON] = ACTIONS(119),
    [anon_sym_ATi_COLON] = ACTIONS(119),
    [anon_sym_ATk_COLON] = ACTIONS(119),
    [anon_sym_ATo_COLON] = ACTIONS(119),
    [anon_sym_ATr_COLON] = ACTIONS(119),
    [anon_sym_ATf_COLON] = ACTIONS(119),
    [anon_sym_ATs_COLON] = ACTIONS(119),
    [anon_sym_ATx_COLON] = ACTIONS(119),
    [anon_sym_PIPE_DOT] = ACTIONS(119),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(119),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_GT] = ACTIONS(123),
    [anon_sym_GT_GT] = ACTIONS(119),
    [sym_html_redirect_operator] = ACTIONS(123),
    [sym_html_append_operator] = ACTIONS(119),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(119),
    [anon_sym_CR] = ACTIONS(119),
    [sym_file_descriptor] = ACTIONS(119),
  },
  [55] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(263),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_PIPEH] = ACTIONS(137),
    [anon_sym_PIPET] = ACTIONS(137),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATi] = ACTIONS(137),
    [anon_sym_AT_AT_ATr] = ACTIONS(137),
    [anon_sym_AT_AT_ATs] = ACTIONS(139),
    [anon_sym_AT_AT_ATst] = ACTIONS(137),
    [anon_sym_AT_AT_ATS] = ACTIONS(137),
    [anon_sym_AT_AT_ATm] = ACTIONS(137),
    [anon_sym_AT_AT_ATM] = ACTIONS(137),
    [anon_sym_AT_AT_ATf] = ACTIONS(139),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATF] = ACTIONS(139),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_AT] = ACTIONS(139),
    [anon_sym_AT_ATdbt] = ACTIONS(139),
    [anon_sym_AT_ATdbta] = ACTIONS(137),
    [anon_sym_AT_ATdbtb] = ACTIONS(137),
    [anon_sym_AT_ATdbts] = ACTIONS(137),
    [anon_sym_AT_AT_DOT] = ACTIONS(137),
    [anon_sym_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_ATk] = ACTIONS(137),
    [anon_sym_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_ATi] = ACTIONS(139),
    [anon_sym_AT_ATiS] = ACTIONS(137),
    [anon_sym_AT_ATf] = ACTIONS(137),
    [anon_sym_AT_ATs_COLON] = ACTIONS(137),
    [anon_sym_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT] = ACTIONS(139),
    [anon_sym_AT_BANG] = ACTIONS(137),
    [anon_sym_AT_LBRACE] = ACTIONS(137),
    [anon_sym_ATa_COLON] = ACTIONS(137),
    [anon_sym_ATb_COLON] = ACTIONS(137),
    [anon_sym_ATB_COLON] = ACTIONS(137),
    [anon_sym_ATe_COLON] = ACTIONS(137),
    [anon_sym_ATF_COLON] = ACTIONS(137),
    [anon_sym_ATi_COLON] = ACTIONS(137),
    [anon_sym_ATk_COLON] = ACTIONS(137),
    [anon_sym_ATo_COLON] = ACTIONS(137),
    [anon_sym_ATr_COLON] = ACTIONS(137),
    [anon_sym_ATf_COLON] = ACTIONS(137),
    [anon_sym_ATs_COLON] = ACTIONS(137),
    [anon_sym_ATx_COLON] = ACTIONS(137),
    [anon_sym_PIPE_DOT] = ACTIONS(137),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(137),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_GT_GT] = ACTIONS(137),
    [sym_html_redirect_operator] = ACTIONS(139),
    [sym_html_append_operator] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(137),
    [anon_sym_CR] = ACTIONS(137),
    [sym_file_descriptor] = ACTIONS(137),
  },
  [56] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(266),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(63),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_PIPE] = ACTIONS(65),
    [anon_sym_PIPEH] = ACTIONS(63),
    [anon_sym_PIPET] = ACTIONS(63),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATi] = ACTIONS(63),
    [anon_sym_AT_AT_ATr] = ACTIONS(63),
    [anon_sym_AT_AT_ATs] = ACTIONS(65),
    [anon_sym_AT_AT_ATst] = ACTIONS(63),
    [anon_sym_AT_AT_ATS] = ACTIONS(63),
    [anon_sym_AT_AT_ATm] = ACTIONS(63),
    [anon_sym_AT_AT_ATM] = ACTIONS(63),
    [anon_sym_AT_AT_ATf] = ACTIONS(65),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATF] = ACTIONS(65),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_AT] = ACTIONS(65),
    [anon_sym_AT_ATdbt] = ACTIONS(65),
    [anon_sym_AT_ATdbta] = ACTIONS(63),
    [anon_sym_AT_ATdbtb] = ACTIONS(63),
    [anon_sym_AT_ATdbts] = ACTIONS(63),
    [anon_sym_AT_AT_DOT] = ACTIONS(63),
    [anon_sym_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_ATk] = ACTIONS(63),
    [anon_sym_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_ATi] = ACTIONS(65),
    [anon_sym_AT_ATiS] = ACTIONS(63),
    [anon_sym_AT_ATf] = ACTIONS(63),
    [anon_sym_AT_ATs_COLON] = ACTIONS(63),
    [anon_sym_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_AT_BANG] = ACTIONS(63),
    [anon_sym_AT_LBRACE] = ACTIONS(63),
    [anon_sym_ATa_COLON] = ACTIONS(63),
    [anon_sym_ATb_COLON] = ACTIONS(63),
    [anon_sym_ATB_COLON] = ACTIONS(63),
    [anon_sym_ATe_COLON] = ACTIONS(63),
    [anon_sym_ATF_COLON] = ACTIONS(63),
    [anon_sym_ATi_COLON] = ACTIONS(63),
    [anon_sym_ATk_COLON] = ACTIONS(63),
    [anon_sym_ATo_COLON] = ACTIONS(63),
    [anon_sym_ATr_COLON] = ACTIONS(63),
    [anon_sym_ATf_COLON] = ACTIONS(63),
    [anon_sym_ATs_COLON] = ACTIONS(63),
    [anon_sym_ATx_COLON] = ACTIONS(63),
    [anon_sym_PIPE_DOT] = ACTIONS(63),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(63),
    [anon_sym_SEMI] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_GT_GT] = ACTIONS(63),
    [sym_html_redirect_operator] = ACTIONS(65),
    [sym_html_append_operator] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(63),
    [anon_sym_CR] = ACTIONS(63),
    [sym_file_descriptor] = ACTIONS(63),
  },
  [57] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(233),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(141),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(141),
    [anon_sym_PIPE] = ACTIONS(143),
    [anon_sym_PIPEH] = ACTIONS(141),
    [anon_sym_PIPET] = ACTIONS(141),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(141),
    [anon_sym_AT_AT_ATb] = ACTIONS(141),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATi] = ACTIONS(141),
    [anon_sym_AT_AT_ATr] = ACTIONS(141),
    [anon_sym_AT_AT_ATs] = ACTIONS(143),
    [anon_sym_AT_AT_ATst] = ACTIONS(141),
    [anon_sym_AT_AT_ATS] = ACTIONS(141),
    [anon_sym_AT_AT_ATm] = ACTIONS(141),
    [anon_sym_AT_AT_ATM] = ACTIONS(141),
    [anon_sym_AT_AT_ATf] = ACTIONS(143),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATF] = ACTIONS(143),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATt] = ACTIONS(141),
    [anon_sym_AT_AT] = ACTIONS(143),
    [anon_sym_AT_ATdbt] = ACTIONS(143),
    [anon_sym_AT_ATdbta] = ACTIONS(141),
    [anon_sym_AT_ATdbtb] = ACTIONS(141),
    [anon_sym_AT_ATdbts] = ACTIONS(141),
    [anon_sym_AT_AT_DOT] = ACTIONS(141),
    [anon_sym_AT_AT_EQ] = ACTIONS(141),
    [anon_sym_AT_ATk] = ACTIONS(141),
    [anon_sym_AT_ATt] = ACTIONS(141),
    [anon_sym_AT_ATb] = ACTIONS(141),
    [anon_sym_AT_ATi] = ACTIONS(143),
    [anon_sym_AT_ATiS] = ACTIONS(141),
    [anon_sym_AT_ATf] = ACTIONS(141),
    [anon_sym_AT_ATs_COLON] = ACTIONS(141),
    [anon_sym_AT_ATc_COLON] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(143),
    [anon_sym_AT_BANG] = ACTIONS(141),
    [anon_sym_AT_LBRACE] = ACTIONS(141),
    [anon_sym_ATa_COLON] = ACTIONS(141),
    [anon_sym_ATb_COLON] = ACTIONS(141),
    [anon_sym_ATB_COLON] = ACTIONS(141),
    [anon_sym_ATe_COLON] = ACTIONS(141),
    [anon_sym_ATF_COLON] = ACTIONS(141),
    [anon_sym_ATi_COLON] = ACTIONS(141),
    [anon_sym_ATk_COLON] = ACTIONS(141),
    [anon_sym_ATo_COLON] = ACTIONS(141),
    [anon_sym_ATr_COLON] = ACTIONS(141),
    [anon_sym_ATf_COLON] = ACTIONS(141),
    [anon_sym_ATs_COLON] = ACTIONS(141),
    [anon_sym_ATx_COLON] = ACTIONS(141),
    [anon_sym_PIPE_DOT] = ACTIONS(141),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(141),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_GT_GT] = ACTIONS(141),
    [sym_html_redirect_operator] = ACTIONS(143),
    [sym_html_append_operator] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(141),
    [anon_sym_CR] = ACTIONS(141),
    [sym_file_descriptor] = ACTIONS(141),
  },
  [58] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(223),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(147),
    [anon_sym_PIPEH] = ACTIONS(145),
    [anon_sym_PIPET] = ACTIONS(145),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(145),
    [anon_sym_AT_AT_ATb] = ACTIONS(145),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATi] = ACTIONS(145),
    [anon_sym_AT_AT_ATr] = ACTIONS(145),
    [anon_sym_AT_AT_ATs] = ACTIONS(147),
    [anon_sym_AT_AT_ATst] = ACTIONS(145),
    [anon_sym_AT_AT_ATS] = ACTIONS(145),
    [anon_sym_AT_AT_ATm] = ACTIONS(145),
    [anon_sym_AT_AT_ATM] = ACTIONS(145),
    [anon_sym_AT_AT_ATf] = ACTIONS(147),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATF] = ACTIONS(147),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATt] = ACTIONS(145),
    [anon_sym_AT_AT] = ACTIONS(147),
    [anon_sym_AT_ATdbt] = ACTIONS(147),
    [anon_sym_AT_ATdbta] = ACTIONS(145),
    [anon_sym_AT_ATdbtb] = ACTIONS(145),
    [anon_sym_AT_ATdbts] = ACTIONS(145),
    [anon_sym_AT_AT_DOT] = ACTIONS(145),
    [anon_sym_AT_AT_EQ] = ACTIONS(145),
    [anon_sym_AT_ATk] = ACTIONS(145),
    [anon_sym_AT_ATt] = ACTIONS(145),
    [anon_sym_AT_ATb] = ACTIONS(145),
    [anon_sym_AT_ATi] = ACTIONS(147),
    [anon_sym_AT_ATiS] = ACTIONS(145),
    [anon_sym_AT_ATf] = ACTIONS(145),
    [anon_sym_AT_ATs_COLON] = ACTIONS(145),
    [anon_sym_AT_ATc_COLON] = ACTIONS(145),
    [anon_sym_AT] = ACTIONS(147),
    [anon_sym_AT_BANG] = ACTIONS(145),
    [anon_sym_AT_LBRACE] = ACTIONS(145),
    [anon_sym_ATa_COLON] = ACTIONS(145),
    [anon_sym_ATb_COLON] = ACTIONS(145),
    [anon_sym_ATB_COLON] = ACTIONS(145),
    [anon_sym_ATe_COLON] = ACTIONS(145),
    [anon_sym_ATF_COLON] = ACTIONS(145),
    [anon_sym_ATi_COLON] = ACTIONS(145),
    [anon_sym_ATk_COLON] = ACTIONS(145),
    [anon_sym_ATo_COLON] = ACTIONS(145),
    [anon_sym_ATr_COLON] = ACTIONS(145),
    [anon_sym_ATf_COLON] = ACTIONS(145),
    [anon_sym_ATs_COLON] = ACTIONS(145),
    [anon_sym_ATx_COLON] = ACTIONS(145),
    [anon_sym_PIPE_DOT] = ACTIONS(145),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(147),
    [anon_sym_GT_GT] = ACTIONS(145),
    [sym_html_redirect_operator] = ACTIONS(147),
    [sym_html_append_operator] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_CR] = ACTIONS(145),
    [sym_file_descriptor] = ACTIONS(145),
  },
  [59] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(245),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_PIPEH] = ACTIONS(137),
    [anon_sym_PIPET] = ACTIONS(137),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATi] = ACTIONS(137),
    [anon_sym_AT_AT_ATr] = ACTIONS(137),
    [anon_sym_AT_AT_ATs] = ACTIONS(139),
    [anon_sym_AT_AT_ATst] = ACTIONS(137),
    [anon_sym_AT_AT_ATS] = ACTIONS(137),
    [anon_sym_AT_AT_ATm] = ACTIONS(137),
    [anon_sym_AT_AT_ATM] = ACTIONS(137),
    [anon_sym_AT_AT_ATf] = ACTIONS(139),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATF] = ACTIONS(139),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_AT] = ACTIONS(139),
    [anon_sym_AT_ATdbt] = ACTIONS(139),
    [anon_sym_AT_ATdbta] = ACTIONS(137),
    [anon_sym_AT_ATdbtb] = ACTIONS(137),
    [anon_sym_AT_ATdbts] = ACTIONS(137),
    [anon_sym_AT_AT_DOT] = ACTIONS(137),
    [anon_sym_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_ATk] = ACTIONS(137),
    [anon_sym_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_ATi] = ACTIONS(139),
    [anon_sym_AT_ATiS] = ACTIONS(137),
    [anon_sym_AT_ATf] = ACTIONS(137),
    [anon_sym_AT_ATs_COLON] = ACTIONS(137),
    [anon_sym_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT] = ACTIONS(139),
    [anon_sym_AT_BANG] = ACTIONS(137),
    [anon_sym_AT_LBRACE] = ACTIONS(137),
    [anon_sym_ATa_COLON] = ACTIONS(137),
    [anon_sym_ATb_COLON] = ACTIONS(137),
    [anon_sym_ATB_COLON] = ACTIONS(137),
    [anon_sym_ATe_COLON] = ACTIONS(137),
    [anon_sym_ATF_COLON] = ACTIONS(137),
    [anon_sym_ATi_COLON] = ACTIONS(137),
    [anon_sym_ATk_COLON] = ACTIONS(137),
    [anon_sym_ATo_COLON] = ACTIONS(137),
    [anon_sym_ATr_COLON] = ACTIONS(137),
    [anon_sym_ATf_COLON] = ACTIONS(137),
    [anon_sym_ATs_COLON] = ACTIONS(137),
    [anon_sym_ATx_COLON] = ACTIONS(137),
    [anon_sym_PIPE_DOT] = ACTIONS(137),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(137),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_GT_GT] = ACTIONS(137),
    [sym_html_redirect_operator] = ACTIONS(139),
    [sym_html_append_operator] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(137),
    [anon_sym_CR] = ACTIONS(137),
    [sym_file_descriptor] = ACTIONS(137),
  },
  [60] = {
    [sym_macro_content] = STATE(169),
    [sym_macro_args] = STATE(220),
    [sym__arg] = STATE(371),
    [sym_arg] = STATE(299),
    [sym_arg_identifier] = STATE(371),
    [sym_double_quoted_arg] = STATE(371),
    [sym_single_quoted_arg] = STATE(371),
    [sym_cmd_substitution_arg] = STATE(371),
    [sym_concatenation] = STATE(390),
    [ts_builtin_sym_end] = ACTIONS(149),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(149),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_PIPEH] = ACTIONS(149),
    [anon_sym_PIPET] = ACTIONS(149),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(149),
    [anon_sym_AT_AT_ATb] = ACTIONS(149),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATi] = ACTIONS(149),
    [anon_sym_AT_AT_ATr] = ACTIONS(149),
    [anon_sym_AT_AT_ATs] = ACTIONS(153),
    [anon_sym_AT_AT_ATst] = ACTIONS(149),
    [anon_sym_AT_AT_ATS] = ACTIONS(149),
    [anon_sym_AT_AT_ATm] = ACTIONS(149),
    [anon_sym_AT_AT_ATM] = ACTIONS(149),
    [anon_sym_AT_AT_ATf] = ACTIONS(153),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATF] = ACTIONS(153),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATt] = ACTIONS(149),
    [anon_sym_AT_AT] = ACTIONS(153),
    [anon_sym_AT_ATdbt] = ACTIONS(153),
    [anon_sym_AT_ATdbta] = ACTIONS(149),
    [anon_sym_AT_ATdbtb] = ACTIONS(149),
    [anon_sym_AT_ATdbts] = ACTIONS(149),
    [anon_sym_AT_AT_DOT] = ACTIONS(149),
    [anon_sym_AT_AT_EQ] = ACTIONS(149),
    [anon_sym_AT_ATk] = ACTIONS(149),
    [anon_sym_AT_ATt] = ACTIONS(149),
    [anon_sym_AT_ATb] = ACTIONS(149),
    [anon_sym_AT_ATi] = ACTIONS(153),
    [anon_sym_AT_ATiS] = ACTIONS(149),
    [anon_sym_AT_ATf] = ACTIONS(149),
    [anon_sym_AT_ATs_COLON] = ACTIONS(149),
    [anon_sym_AT_ATc_COLON] = ACTIONS(149),
    [anon_sym_AT] = ACTIONS(153),
    [anon_sym_AT_BANG] = ACTIONS(149),
    [anon_sym_AT_LBRACE] = ACTIONS(149),
    [anon_sym_ATa_COLON] = ACTIONS(149),
    [anon_sym_ATb_COLON] = ACTIONS(149),
    [anon_sym_ATB_COLON] = ACTIONS(149),
    [anon_sym_ATe_COLON] = ACTIONS(149),
    [anon_sym_ATF_COLON] = ACTIONS(149),
    [anon_sym_ATi_COLON] = ACTIONS(149),
    [anon_sym_ATk_COLON] = ACTIONS(149),
    [anon_sym_ATo_COLON] = ACTIONS(149),
    [anon_sym_ATr_COLON] = ACTIONS(149),
    [anon_sym_ATf_COLON] = ACTIONS(149),
    [anon_sym_ATs_COLON] = ACTIONS(149),
    [anon_sym_ATx_COLON] = ACTIONS(149),
    [anon_sym_PIPE_DOT] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_SEMI] = ACTIONS(149),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_GT] = ACTIONS(149),
    [sym_html_redirect_operator] = ACTIONS(153),
    [sym_html_append_operator] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(159),
    [aux_sym_arg_identifier_token1] = ACTIONS(155),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(149),
    [anon_sym_CR] = ACTIONS(149),
    [sym_file_descriptor] = ACTIONS(149),
  },
  [61] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(275),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_PIPEH] = ACTIONS(167),
    [anon_sym_PIPET] = ACTIONS(167),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(167),
    [anon_sym_AT_AT_ATb] = ACTIONS(167),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATi] = ACTIONS(167),
    [anon_sym_AT_AT_ATr] = ACTIONS(167),
    [anon_sym_AT_AT_ATs] = ACTIONS(169),
    [anon_sym_AT_AT_ATst] = ACTIONS(167),
    [anon_sym_AT_AT_ATS] = ACTIONS(167),
    [anon_sym_AT_AT_ATm] = ACTIONS(167),
    [anon_sym_AT_AT_ATM] = ACTIONS(167),
    [anon_sym_AT_AT_ATf] = ACTIONS(169),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATF] = ACTIONS(169),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATt] = ACTIONS(167),
    [anon_sym_AT_AT] = ACTIONS(169),
    [anon_sym_AT_ATdbt] = ACTIONS(169),
    [anon_sym_AT_ATdbta] = ACTIONS(167),
    [anon_sym_AT_ATdbtb] = ACTIONS(167),
    [anon_sym_AT_ATdbts] = ACTIONS(167),
    [anon_sym_AT_AT_DOT] = ACTIONS(167),
    [anon_sym_AT_AT_EQ] = ACTIONS(167),
    [anon_sym_AT_ATk] = ACTIONS(167),
    [anon_sym_AT_ATt] = ACTIONS(167),
    [anon_sym_AT_ATb] = ACTIONS(167),
    [anon_sym_AT_ATi] = ACTIONS(169),
    [anon_sym_AT_ATiS] = ACTIONS(167),
    [anon_sym_AT_ATf] = ACTIONS(167),
    [anon_sym_AT_ATs_COLON] = ACTIONS(167),
    [anon_sym_AT_ATc_COLON] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(169),
    [anon_sym_AT_BANG] = ACTIONS(167),
    [anon_sym_AT_LBRACE] = ACTIONS(167),
    [anon_sym_ATa_COLON] = ACTIONS(167),
    [anon_sym_ATb_COLON] = ACTIONS(167),
    [anon_sym_ATB_COLON] = ACTIONS(167),
    [anon_sym_ATe_COLON] = ACTIONS(167),
    [anon_sym_ATF_COLON] = ACTIONS(167),
    [anon_sym_ATi_COLON] = ACTIONS(167),
    [anon_sym_ATk_COLON] = ACTIONS(167),
    [anon_sym_ATo_COLON] = ACTIONS(167),
    [anon_sym_ATr_COLON] = ACTIONS(167),
    [anon_sym_ATf_COLON] = ACTIONS(167),
    [anon_sym_ATs_COLON] = ACTIONS(167),
    [anon_sym_ATx_COLON] = ACTIONS(167),
    [anon_sym_PIPE_DOT] = ACTIONS(167),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(167),
    [anon_sym_SEMI] = ACTIONS(167),
    [anon_sym_GT] = ACTIONS(169),
    [anon_sym_GT_GT] = ACTIONS(167),
    [sym_html_redirect_operator] = ACTIONS(169),
    [sym_html_append_operator] = ACTIONS(167),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(167),
    [anon_sym_CR] = ACTIONS(167),
    [sym_file_descriptor] = ACTIONS(167),
  },
  [62] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(64),
    [sym_args] = STATE(262),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(171),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_PIPEH] = ACTIONS(171),
    [anon_sym_PIPET] = ACTIONS(171),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(171),
    [anon_sym_AT_AT_ATb] = ACTIONS(171),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATi] = ACTIONS(171),
    [anon_sym_AT_AT_ATr] = ACTIONS(171),
    [anon_sym_AT_AT_ATs] = ACTIONS(173),
    [anon_sym_AT_AT_ATst] = ACTIONS(171),
    [anon_sym_AT_AT_ATS] = ACTIONS(171),
    [anon_sym_AT_AT_ATm] = ACTIONS(171),
    [anon_sym_AT_AT_ATM] = ACTIONS(171),
    [anon_sym_AT_AT_ATf] = ACTIONS(173),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATF] = ACTIONS(173),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATt] = ACTIONS(171),
    [anon_sym_AT_AT] = ACTIONS(173),
    [anon_sym_AT_ATdbt] = ACTIONS(173),
    [anon_sym_AT_ATdbta] = ACTIONS(171),
    [anon_sym_AT_ATdbtb] = ACTIONS(171),
    [anon_sym_AT_ATdbts] = ACTIONS(171),
    [anon_sym_AT_AT_DOT] = ACTIONS(171),
    [anon_sym_AT_AT_EQ] = ACTIONS(171),
    [anon_sym_AT_ATk] = ACTIONS(171),
    [anon_sym_AT_ATt] = ACTIONS(171),
    [anon_sym_AT_ATb] = ACTIONS(171),
    [anon_sym_AT_ATi] = ACTIONS(173),
    [anon_sym_AT_ATiS] = ACTIONS(171),
    [anon_sym_AT_ATf] = ACTIONS(171),
    [anon_sym_AT_ATs_COLON] = ACTIONS(171),
    [anon_sym_AT_ATc_COLON] = ACTIONS(171),
    [anon_sym_AT] = ACTIONS(173),
    [anon_sym_AT_BANG] = ACTIONS(171),
    [anon_sym_AT_LBRACE] = ACTIONS(171),
    [anon_sym_ATa_COLON] = ACTIONS(171),
    [anon_sym_ATb_COLON] = ACTIONS(171),
    [anon_sym_ATB_COLON] = ACTIONS(171),
    [anon_sym_ATe_COLON] = ACTIONS(171),
    [anon_sym_ATF_COLON] = ACTIONS(171),
    [anon_sym_ATi_COLON] = ACTIONS(171),
    [anon_sym_ATk_COLON] = ACTIONS(171),
    [anon_sym_ATo_COLON] = ACTIONS(171),
    [anon_sym_ATr_COLON] = ACTIONS(171),
    [anon_sym_ATf_COLON] = ACTIONS(171),
    [anon_sym_ATs_COLON] = ACTIONS(171),
    [anon_sym_ATx_COLON] = ACTIONS(171),
    [anon_sym_PIPE_DOT] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(171),
    [anon_sym_SEMI] = ACTIONS(171),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(171),
    [sym_html_redirect_operator] = ACTIONS(173),
    [sym_html_append_operator] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(171),
    [anon_sym_CR] = ACTIONS(171),
    [sym_file_descriptor] = ACTIONS(171),
  },
  [63] = {
    [sym__arg] = STATE(371),
    [sym_arg] = STATE(338),
    [sym_arg_identifier] = STATE(371),
    [sym_double_quoted_arg] = STATE(371),
    [sym_single_quoted_arg] = STATE(371),
    [sym_cmd_substitution_arg] = STATE(371),
    [sym_concatenation] = STATE(390),
    [aux_sym_foreach_addrsize_command_repeat1] = STATE(63),
    [ts_builtin_sym_end] = ACTIONS(175),
    [anon_sym_DQUOTE] = ACTIONS(177),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_PIPE] = ACTIONS(180),
    [anon_sym_PIPEH] = ACTIONS(175),
    [anon_sym_PIPET] = ACTIONS(175),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(175),
    [anon_sym_AT_AT_ATb] = ACTIONS(175),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATi] = ACTIONS(175),
    [anon_sym_AT_AT_ATr] = ACTIONS(175),
    [anon_sym_AT_AT_ATs] = ACTIONS(180),
    [anon_sym_AT_AT_ATst] = ACTIONS(175),
    [anon_sym_AT_AT_ATS] = ACTIONS(175),
    [anon_sym_AT_AT_ATm] = ACTIONS(175),
    [anon_sym_AT_AT_ATM] = ACTIONS(175),
    [anon_sym_AT_AT_ATf] = ACTIONS(180),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATF] = ACTIONS(180),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATt] = ACTIONS(175),
    [anon_sym_AT_AT] = ACTIONS(180),
    [anon_sym_AT_ATdbt] = ACTIONS(180),
    [anon_sym_AT_ATdbta] = ACTIONS(175),
    [anon_sym_AT_ATdbtb] = ACTIONS(175),
    [anon_sym_AT_ATdbts] = ACTIONS(175),
    [anon_sym_AT_AT_DOT] = ACTIONS(175),
    [anon_sym_AT_AT_EQ] = ACTIONS(175),
    [anon_sym_AT_ATk] = ACTIONS(175),
    [anon_sym_AT_ATt] = ACTIONS(175),
    [anon_sym_AT_ATb] = ACTIONS(175),
    [anon_sym_AT_ATi] = ACTIONS(180),
    [anon_sym_AT_ATiS] = ACTIONS(175),
    [anon_sym_AT_ATf] = ACTIONS(175),
    [anon_sym_AT_ATs_COLON] = ACTIONS(175),
    [anon_sym_AT_ATc_COLON] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(180),
    [anon_sym_AT_BANG] = ACTIONS(175),
    [anon_sym_AT_LBRACE] = ACTIONS(175),
    [anon_sym_ATa_COLON] = ACTIONS(175),
    [anon_sym_ATb_COLON] = ACTIONS(175),
    [anon_sym_ATB_COLON] = ACTIONS(175),
    [anon_sym_ATe_COLON] = ACTIONS(175),
    [anon_sym_ATF_COLON] = ACTIONS(175),
    [anon_sym_ATi_COLON] = ACTIONS(175),
    [anon_sym_ATk_COLON] = ACTIONS(175),
    [anon_sym_ATo_COLON] = ACTIONS(175),
    [anon_sym_ATr_COLON] = ACTIONS(175),
    [anon_sym_ATf_COLON] = ACTIONS(175),
    [anon_sym_ATs_COLON] = ACTIONS(175),
    [anon_sym_ATx_COLON] = ACTIONS(175),
    [anon_sym_PIPE_DOT] = ACTIONS(175),
    [anon_sym_DOLLAR] = ACTIONS(182),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(180),
    [anon_sym_GT_GT] = ACTIONS(175),
    [sym_html_redirect_operator] = ACTIONS(180),
    [sym_html_append_operator] = ACTIONS(175),
    [anon_sym_COMMA] = ACTIONS(188),
    [aux_sym_arg_identifier_token1] = ACTIONS(182),
    [anon_sym_SQUOTE] = ACTIONS(191),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(194),
    [anon_sym_BQUOTE] = ACTIONS(197),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(175),
    [anon_sym_CR] = ACTIONS(175),
    [sym_file_descriptor] = ACTIONS(175),
  },
  [64] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(66),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(200),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(200),
    [anon_sym_PIPE] = ACTIONS(202),
    [anon_sym_PIPEH] = ACTIONS(200),
    [anon_sym_PIPET] = ACTIONS(200),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(200),
    [anon_sym_AT_AT_ATb] = ACTIONS(200),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATi] = ACTIONS(200),
    [anon_sym_AT_AT_ATr] = ACTIONS(200),
    [anon_sym_AT_AT_ATs] = ACTIONS(202),
    [anon_sym_AT_AT_ATst] = ACTIONS(200),
    [anon_sym_AT_AT_ATS] = ACTIONS(200),
    [anon_sym_AT_AT_ATm] = ACTIONS(200),
    [anon_sym_AT_AT_ATM] = ACTIONS(200),
    [anon_sym_AT_AT_ATf] = ACTIONS(202),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATF] = ACTIONS(202),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATt] = ACTIONS(200),
    [anon_sym_AT_AT] = ACTIONS(202),
    [anon_sym_AT_ATdbt] = ACTIONS(202),
    [anon_sym_AT_ATdbta] = ACTIONS(200),
    [anon_sym_AT_ATdbtb] = ACTIONS(200),
    [anon_sym_AT_ATdbts] = ACTIONS(200),
    [anon_sym_AT_AT_DOT] = ACTIONS(200),
    [anon_sym_AT_AT_EQ] = ACTIONS(200),
    [anon_sym_AT_ATk] = ACTIONS(200),
    [anon_sym_AT_ATt] = ACTIONS(200),
    [anon_sym_AT_ATb] = ACTIONS(200),
    [anon_sym_AT_ATi] = ACTIONS(202),
    [anon_sym_AT_ATiS] = ACTIONS(200),
    [anon_sym_AT_ATf] = ACTIONS(200),
    [anon_sym_AT_ATs_COLON] = ACTIONS(200),
    [anon_sym_AT_ATc_COLON] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(202),
    [anon_sym_AT_BANG] = ACTIONS(200),
    [anon_sym_AT_LBRACE] = ACTIONS(200),
    [anon_sym_ATa_COLON] = ACTIONS(200),
    [anon_sym_ATb_COLON] = ACTIONS(200),
    [anon_sym_ATB_COLON] = ACTIONS(200),
    [anon_sym_ATe_COLON] = ACTIONS(200),
    [anon_sym_ATF_COLON] = ACTIONS(200),
    [anon_sym_ATi_COLON] = ACTIONS(200),
    [anon_sym_ATk_COLON] = ACTIONS(200),
    [anon_sym_ATo_COLON] = ACTIONS(200),
    [anon_sym_ATr_COLON] = ACTIONS(200),
    [anon_sym_ATf_COLON] = ACTIONS(200),
    [anon_sym_ATs_COLON] = ACTIONS(200),
    [anon_sym_ATx_COLON] = ACTIONS(200),
    [anon_sym_PIPE_DOT] = ACTIONS(200),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_RPAREN] = ACTIONS(200),
    [anon_sym_SEMI] = ACTIONS(200),
    [anon_sym_GT] = ACTIONS(202),
    [anon_sym_GT_GT] = ACTIONS(200),
    [sym_html_redirect_operator] = ACTIONS(202),
    [sym_html_append_operator] = ACTIONS(200),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(200),
    [anon_sym_CR] = ACTIONS(200),
    [sym_file_descriptor] = ACTIONS(200),
  },
  [65] = {
    [sym__Cf_args] = STATE(214),
    [sym__arg] = STATE(456),
    [sym_arg] = STATE(353),
    [sym_arg_identifier] = STATE(456),
    [sym_double_quoted_arg] = STATE(456),
    [sym_single_quoted_arg] = STATE(456),
    [sym_cmd_substitution_arg] = STATE(456),
    [sym_concatenation] = STATE(479),
    [ts_builtin_sym_end] = ACTIONS(204),
    [anon_sym_DQUOTE] = ACTIONS(206),
    [anon_sym_TILDE] = ACTIONS(204),
    [anon_sym_PIPE] = ACTIONS(208),
    [anon_sym_PIPEH] = ACTIONS(204),
    [anon_sym_PIPET] = ACTIONS(204),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(204),
    [anon_sym_AT_AT_ATb] = ACTIONS(204),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATi] = ACTIONS(204),
    [anon_sym_AT_AT_ATr] = ACTIONS(204),
    [anon_sym_AT_AT_ATs] = ACTIONS(208),
    [anon_sym_AT_AT_ATst] = ACTIONS(204),
    [anon_sym_AT_AT_ATS] = ACTIONS(204),
    [anon_sym_AT_AT_ATm] = ACTIONS(204),
    [anon_sym_AT_AT_ATM] = ACTIONS(204),
    [anon_sym_AT_AT_ATf] = ACTIONS(208),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATF] = ACTIONS(208),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATt] = ACTIONS(204),
    [anon_sym_AT_AT] = ACTIONS(208),
    [anon_sym_AT_ATdbt] = ACTIONS(208),
    [anon_sym_AT_ATdbta] = ACTIONS(204),
    [anon_sym_AT_ATdbtb] = ACTIONS(204),
    [anon_sym_AT_ATdbts] = ACTIONS(204),
    [anon_sym_AT_AT_DOT] = ACTIONS(204),
    [anon_sym_AT_AT_EQ] = ACTIONS(204),
    [anon_sym_AT_ATk] = ACTIONS(204),
    [anon_sym_AT_ATt] = ACTIONS(204),
    [anon_sym_AT_ATb] = ACTIONS(204),
    [anon_sym_AT_ATi] = ACTIONS(208),
    [anon_sym_AT_ATiS] = ACTIONS(204),
    [anon_sym_AT_ATf] = ACTIONS(204),
    [anon_sym_AT_ATs_COLON] = ACTIONS(204),
    [anon_sym_AT_ATc_COLON] = ACTIONS(204),
    [anon_sym_AT] = ACTIONS(208),
    [anon_sym_AT_BANG] = ACTIONS(204),
    [anon_sym_AT_LBRACE] = ACTIONS(204),
    [anon_sym_ATa_COLON] = ACTIONS(204),
    [anon_sym_ATb_COLON] = ACTIONS(204),
    [anon_sym_ATB_COLON] = ACTIONS(204),
    [anon_sym_ATe_COLON] = ACTIONS(204),
    [anon_sym_ATF_COLON] = ACTIONS(204),
    [anon_sym_ATi_COLON] = ACTIONS(204),
    [anon_sym_ATk_COLON] = ACTIONS(204),
    [anon_sym_ATo_COLON] = ACTIONS(204),
    [anon_sym_ATr_COLON] = ACTIONS(204),
    [anon_sym_ATf_COLON] = ACTIONS(204),
    [anon_sym_ATs_COLON] = ACTIONS(204),
    [anon_sym_ATx_COLON] = ACTIONS(204),
    [anon_sym_PIPE_DOT] = ACTIONS(204),
    [anon_sym_DOLLAR] = ACTIONS(210),
    [anon_sym_LPAREN] = ACTIONS(212),
    [anon_sym_RPAREN] = ACTIONS(204),
    [anon_sym_SEMI] = ACTIONS(204),
    [anon_sym_GT] = ACTIONS(208),
    [anon_sym_GT_GT] = ACTIONS(204),
    [sym_html_redirect_operator] = ACTIONS(208),
    [sym_html_append_operator] = ACTIONS(204),
    [anon_sym_COMMA] = ACTIONS(214),
    [aux_sym_arg_identifier_token1] = ACTIONS(210),
    [anon_sym_SQUOTE] = ACTIONS(216),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(218),
    [anon_sym_BQUOTE] = ACTIONS(220),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(204),
    [anon_sym_CR] = ACTIONS(204),
    [sym_file_descriptor] = ACTIONS(204),
  },
  [66] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(66),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(222),
    [anon_sym_DQUOTE] = ACTIONS(224),
    [anon_sym_TILDE] = ACTIONS(222),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_PIPEH] = ACTIONS(222),
    [anon_sym_PIPET] = ACTIONS(222),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(222),
    [anon_sym_AT_AT_ATb] = ACTIONS(222),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(222),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(222),
    [anon_sym_AT_AT_ATi] = ACTIONS(222),
    [anon_sym_AT_AT_ATr] = ACTIONS(222),
    [anon_sym_AT_AT_ATs] = ACTIONS(227),
    [anon_sym_AT_AT_ATst] = ACTIONS(222),
    [anon_sym_AT_AT_ATS] = ACTIONS(222),
    [anon_sym_AT_AT_ATm] = ACTIONS(222),
    [anon_sym_AT_AT_ATM] = ACTIONS(222),
    [anon_sym_AT_AT_ATf] = ACTIONS(227),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(222),
    [anon_sym_AT_AT_ATF] = ACTIONS(227),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(222),
    [anon_sym_AT_AT_ATt] = ACTIONS(222),
    [anon_sym_AT_AT] = ACTIONS(227),
    [anon_sym_AT_ATdbt] = ACTIONS(227),
    [anon_sym_AT_ATdbta] = ACTIONS(222),
    [anon_sym_AT_ATdbtb] = ACTIONS(222),
    [anon_sym_AT_ATdbts] = ACTIONS(222),
    [anon_sym_AT_AT_DOT] = ACTIONS(222),
    [anon_sym_AT_AT_EQ] = ACTIONS(222),
    [anon_sym_AT_ATk] = ACTIONS(222),
    [anon_sym_AT_ATt] = ACTIONS(222),
    [anon_sym_AT_ATb] = ACTIONS(222),
    [anon_sym_AT_ATi] = ACTIONS(227),
    [anon_sym_AT_ATiS] = ACTIONS(222),
    [anon_sym_AT_ATf] = ACTIONS(222),
    [anon_sym_AT_ATs_COLON] = ACTIONS(222),
    [anon_sym_AT_ATc_COLON] = ACTIONS(222),
    [anon_sym_AT] = ACTIONS(227),
    [anon_sym_AT_BANG] = ACTIONS(222),
    [anon_sym_AT_LBRACE] = ACTIONS(222),
    [anon_sym_ATa_COLON] = ACTIONS(222),
    [anon_sym_ATb_COLON] = ACTIONS(222),
    [anon_sym_ATB_COLON] = ACTIONS(222),
    [anon_sym_ATe_COLON] = ACTIONS(222),
    [anon_sym_ATF_COLON] = ACTIONS(222),
    [anon_sym_ATi_COLON] = ACTIONS(222),
    [anon_sym_ATk_COLON] = ACTIONS(222),
    [anon_sym_ATo_COLON] = ACTIONS(222),
    [anon_sym_ATr_COLON] = ACTIONS(222),
    [anon_sym_ATf_COLON] = ACTIONS(222),
    [anon_sym_ATs_COLON] = ACTIONS(222),
    [anon_sym_ATx_COLON] = ACTIONS(222),
    [anon_sym_PIPE_DOT] = ACTIONS(222),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(222),
    [anon_sym_SEMI] = ACTIONS(222),
    [anon_sym_GT] = ACTIONS(227),
    [anon_sym_GT_GT] = ACTIONS(222),
    [sym_html_redirect_operator] = ACTIONS(227),
    [sym_html_append_operator] = ACTIONS(222),
    [anon_sym_COMMA] = ACTIONS(235),
    [aux_sym_arg_identifier_token1] = ACTIONS(229),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(241),
    [anon_sym_BQUOTE] = ACTIONS(244),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(222),
    [anon_sym_CR] = ACTIONS(222),
    [sym_file_descriptor] = ACTIONS(222),
  },
  [67] = {
    [sym__arg] = STATE(371),
    [sym_arg] = STATE(338),
    [sym_arg_identifier] = STATE(371),
    [sym_double_quoted_arg] = STATE(371),
    [sym_single_quoted_arg] = STATE(371),
    [sym_cmd_substitution_arg] = STATE(371),
    [sym_concatenation] = STATE(390),
    [aux_sym_foreach_addrsize_command_repeat1] = STATE(63),
    [ts_builtin_sym_end] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(247),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_PIPEH] = ACTIONS(247),
    [anon_sym_PIPET] = ACTIONS(247),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(247),
    [anon_sym_AT_AT_ATb] = ACTIONS(247),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATi] = ACTIONS(247),
    [anon_sym_AT_AT_ATr] = ACTIONS(247),
    [anon_sym_AT_AT_ATs] = ACTIONS(249),
    [anon_sym_AT_AT_ATst] = ACTIONS(247),
    [anon_sym_AT_AT_ATS] = ACTIONS(247),
    [anon_sym_AT_AT_ATm] = ACTIONS(247),
    [anon_sym_AT_AT_ATM] = ACTIONS(247),
    [anon_sym_AT_AT_ATf] = ACTIONS(249),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATF] = ACTIONS(249),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATt] = ACTIONS(247),
    [anon_sym_AT_AT] = ACTIONS(249),
    [anon_sym_AT_ATdbt] = ACTIONS(249),
    [anon_sym_AT_ATdbta] = ACTIONS(247),
    [anon_sym_AT_ATdbtb] = ACTIONS(247),
    [anon_sym_AT_ATdbts] = ACTIONS(247),
    [anon_sym_AT_AT_DOT] = ACTIONS(247),
    [anon_sym_AT_AT_EQ] = ACTIONS(247),
    [anon_sym_AT_ATk] = ACTIONS(247),
    [anon_sym_AT_ATt] = ACTIONS(247),
    [anon_sym_AT_ATb] = ACTIONS(247),
    [anon_sym_AT_ATi] = ACTIONS(249),
    [anon_sym_AT_ATiS] = ACTIONS(247),
    [anon_sym_AT_ATf] = ACTIONS(247),
    [anon_sym_AT_ATs_COLON] = ACTIONS(247),
    [anon_sym_AT_ATc_COLON] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(249),
    [anon_sym_AT_BANG] = ACTIONS(247),
    [anon_sym_AT_LBRACE] = ACTIONS(247),
    [anon_sym_ATa_COLON] = ACTIONS(247),
    [anon_sym_ATb_COLON] = ACTIONS(247),
    [anon_sym_ATB_COLON] = ACTIONS(247),
    [anon_sym_ATe_COLON] = ACTIONS(247),
    [anon_sym_ATF_COLON] = ACTIONS(247),
    [anon_sym_ATi_COLON] = ACTIONS(247),
    [anon_sym_ATk_COLON] = ACTIONS(247),
    [anon_sym_ATo_COLON] = ACTIONS(247),
    [anon_sym_ATr_COLON] = ACTIONS(247),
    [anon_sym_ATf_COLON] = ACTIONS(247),
    [anon_sym_ATs_COLON] = ACTIONS(247),
    [anon_sym_ATx_COLON] = ACTIONS(247),
    [anon_sym_PIPE_DOT] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_SEMI] = ACTIONS(247),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [sym_html_redirect_operator] = ACTIONS(249),
    [sym_html_append_operator] = ACTIONS(247),
    [anon_sym_COMMA] = ACTIONS(159),
    [aux_sym_arg_identifier_token1] = ACTIONS(155),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(165),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_CR] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
  },
  [68] = {
    [sym__pf_arg_parentheses] = STATE(109),
    [sym_pf_arg_identifier] = STATE(109),
    [sym__pf_arg] = STATE(109),
    [sym_pf_concatenation] = STATE(121),
    [sym_pf_arg] = STATE(78),
    [sym_pf_args] = STATE(232),
    [sym_cmd_substitution_arg] = STATE(109),
    [aux_sym_pf_args_repeat1] = STATE(78),
    [aux_sym_pf_dot_args_repeat1] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(251),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_PIPEH] = ACTIONS(251),
    [anon_sym_PIPET] = ACTIONS(251),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(251),
    [anon_sym_AT_AT_ATb] = ACTIONS(251),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATi] = ACTIONS(251),
    [anon_sym_AT_AT_ATr] = ACTIONS(251),
    [anon_sym_AT_AT_ATs] = ACTIONS(253),
    [anon_sym_AT_AT_ATst] = ACTIONS(251),
    [anon_sym_AT_AT_ATS] = ACTIONS(251),
    [anon_sym_AT_AT_ATm] = ACTIONS(251),
    [anon_sym_AT_AT_ATM] = ACTIONS(251),
    [anon_sym_AT_AT_ATf] = ACTIONS(253),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATF] = ACTIONS(253),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATt] = ACTIONS(251),
    [anon_sym_AT_AT] = ACTIONS(253),
    [anon_sym_AT_ATdbt] = ACTIONS(253),
    [anon_sym_AT_ATdbta] = ACTIONS(251),
    [anon_sym_AT_ATdbtb] = ACTIONS(251),
    [anon_sym_AT_ATdbts] = ACTIONS(251),
    [anon_sym_AT_AT_DOT] = ACTIONS(251),
    [anon_sym_AT_AT_EQ] = ACTIONS(251),
    [anon_sym_AT_ATk] = ACTIONS(251),
    [anon_sym_AT_ATt] = ACTIONS(251),
    [anon_sym_AT_ATb] = ACTIONS(251),
    [anon_sym_AT_ATi] = ACTIONS(253),
    [anon_sym_AT_ATiS] = ACTIONS(251),
    [anon_sym_AT_ATf] = ACTIONS(251),
    [anon_sym_AT_ATs_COLON] = ACTIONS(251),
    [anon_sym_AT_ATc_COLON] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_AT_BANG] = ACTIONS(251),
    [anon_sym_AT_LBRACE] = ACTIONS(251),
    [anon_sym_ATa_COLON] = ACTIONS(251),
    [anon_sym_ATb_COLON] = ACTIONS(251),
    [anon_sym_ATB_COLON] = ACTIONS(251),
    [anon_sym_ATe_COLON] = ACTIONS(251),
    [anon_sym_ATF_COLON] = ACTIONS(251),
    [anon_sym_ATi_COLON] = ACTIONS(251),
    [anon_sym_ATk_COLON] = ACTIONS(251),
    [anon_sym_ATo_COLON] = ACTIONS(251),
    [anon_sym_ATr_COLON] = ACTIONS(251),
    [anon_sym_ATf_COLON] = ACTIONS(251),
    [anon_sym_ATs_COLON] = ACTIONS(251),
    [anon_sym_ATx_COLON] = ACTIONS(251),
    [anon_sym_PIPE_DOT] = ACTIONS(251),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_DOLLAR] = ACTIONS(255),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_RPAREN] = ACTIONS(251),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(255),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_GT_GT] = ACTIONS(251),
    [sym_html_redirect_operator] = ACTIONS(253),
    [sym_html_append_operator] = ACTIONS(251),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(259),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(251),
    [anon_sym_CR] = ACTIONS(251),
    [sym_file_descriptor] = ACTIONS(251),
    [sym__concat_pf_dot] = ACTIONS(263),
  },
  [69] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(245),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_PIPEH] = ACTIONS(137),
    [anon_sym_PIPET] = ACTIONS(137),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATi] = ACTIONS(137),
    [anon_sym_AT_AT_ATr] = ACTIONS(137),
    [anon_sym_AT_AT_ATs] = ACTIONS(139),
    [anon_sym_AT_AT_ATst] = ACTIONS(137),
    [anon_sym_AT_AT_ATS] = ACTIONS(137),
    [anon_sym_AT_AT_ATm] = ACTIONS(137),
    [anon_sym_AT_AT_ATM] = ACTIONS(137),
    [anon_sym_AT_AT_ATf] = ACTIONS(139),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATF] = ACTIONS(139),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_AT] = ACTIONS(139),
    [anon_sym_AT_ATdbt] = ACTIONS(139),
    [anon_sym_AT_ATdbta] = ACTIONS(137),
    [anon_sym_AT_ATdbtb] = ACTIONS(137),
    [anon_sym_AT_ATdbts] = ACTIONS(137),
    [anon_sym_AT_AT_DOT] = ACTIONS(137),
    [anon_sym_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_ATk] = ACTIONS(137),
    [anon_sym_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_ATi] = ACTIONS(139),
    [anon_sym_AT_ATiS] = ACTIONS(137),
    [anon_sym_AT_ATf] = ACTIONS(137),
    [anon_sym_AT_ATs_COLON] = ACTIONS(137),
    [anon_sym_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT] = ACTIONS(139),
    [anon_sym_AT_BANG] = ACTIONS(137),
    [anon_sym_AT_LBRACE] = ACTIONS(137),
    [anon_sym_ATa_COLON] = ACTIONS(137),
    [anon_sym_ATb_COLON] = ACTIONS(137),
    [anon_sym_ATB_COLON] = ACTIONS(137),
    [anon_sym_ATe_COLON] = ACTIONS(137),
    [anon_sym_ATF_COLON] = ACTIONS(137),
    [anon_sym_ATi_COLON] = ACTIONS(137),
    [anon_sym_ATk_COLON] = ACTIONS(137),
    [anon_sym_ATo_COLON] = ACTIONS(137),
    [anon_sym_ATr_COLON] = ACTIONS(137),
    [anon_sym_ATf_COLON] = ACTIONS(137),
    [anon_sym_ATs_COLON] = ACTIONS(137),
    [anon_sym_ATx_COLON] = ACTIONS(137),
    [anon_sym_PIPE_DOT] = ACTIONS(137),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_GT_GT] = ACTIONS(137),
    [sym_html_redirect_operator] = ACTIONS(139),
    [sym_html_append_operator] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(137),
  },
  [70] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(262),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(171),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_PIPEH] = ACTIONS(171),
    [anon_sym_PIPET] = ACTIONS(171),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(171),
    [anon_sym_AT_AT_ATb] = ACTIONS(171),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATi] = ACTIONS(171),
    [anon_sym_AT_AT_ATr] = ACTIONS(171),
    [anon_sym_AT_AT_ATs] = ACTIONS(173),
    [anon_sym_AT_AT_ATst] = ACTIONS(171),
    [anon_sym_AT_AT_ATS] = ACTIONS(171),
    [anon_sym_AT_AT_ATm] = ACTIONS(171),
    [anon_sym_AT_AT_ATM] = ACTIONS(171),
    [anon_sym_AT_AT_ATf] = ACTIONS(173),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATF] = ACTIONS(173),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(171),
    [anon_sym_AT_AT_ATt] = ACTIONS(171),
    [anon_sym_AT_AT] = ACTIONS(173),
    [anon_sym_AT_ATdbt] = ACTIONS(173),
    [anon_sym_AT_ATdbta] = ACTIONS(171),
    [anon_sym_AT_ATdbtb] = ACTIONS(171),
    [anon_sym_AT_ATdbts] = ACTIONS(171),
    [anon_sym_AT_AT_DOT] = ACTIONS(171),
    [anon_sym_AT_AT_EQ] = ACTIONS(171),
    [anon_sym_AT_ATk] = ACTIONS(171),
    [anon_sym_AT_ATt] = ACTIONS(171),
    [anon_sym_AT_ATb] = ACTIONS(171),
    [anon_sym_AT_ATi] = ACTIONS(173),
    [anon_sym_AT_ATiS] = ACTIONS(171),
    [anon_sym_AT_ATf] = ACTIONS(171),
    [anon_sym_AT_ATs_COLON] = ACTIONS(171),
    [anon_sym_AT_ATc_COLON] = ACTIONS(171),
    [anon_sym_AT] = ACTIONS(173),
    [anon_sym_AT_BANG] = ACTIONS(171),
    [anon_sym_AT_LBRACE] = ACTIONS(171),
    [anon_sym_ATa_COLON] = ACTIONS(171),
    [anon_sym_ATb_COLON] = ACTIONS(171),
    [anon_sym_ATB_COLON] = ACTIONS(171),
    [anon_sym_ATe_COLON] = ACTIONS(171),
    [anon_sym_ATF_COLON] = ACTIONS(171),
    [anon_sym_ATi_COLON] = ACTIONS(171),
    [anon_sym_ATk_COLON] = ACTIONS(171),
    [anon_sym_ATo_COLON] = ACTIONS(171),
    [anon_sym_ATr_COLON] = ACTIONS(171),
    [anon_sym_ATf_COLON] = ACTIONS(171),
    [anon_sym_ATs_COLON] = ACTIONS(171),
    [anon_sym_ATx_COLON] = ACTIONS(171),
    [anon_sym_PIPE_DOT] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(171),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_GT] = ACTIONS(171),
    [sym_html_redirect_operator] = ACTIONS(173),
    [sym_html_append_operator] = ACTIONS(171),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(171),
  },
  [71] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(275),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_PIPE] = ACTIONS(169),
    [anon_sym_PIPEH] = ACTIONS(167),
    [anon_sym_PIPET] = ACTIONS(167),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(167),
    [anon_sym_AT_AT_ATb] = ACTIONS(167),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATi] = ACTIONS(167),
    [anon_sym_AT_AT_ATr] = ACTIONS(167),
    [anon_sym_AT_AT_ATs] = ACTIONS(169),
    [anon_sym_AT_AT_ATst] = ACTIONS(167),
    [anon_sym_AT_AT_ATS] = ACTIONS(167),
    [anon_sym_AT_AT_ATm] = ACTIONS(167),
    [anon_sym_AT_AT_ATM] = ACTIONS(167),
    [anon_sym_AT_AT_ATf] = ACTIONS(169),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATF] = ACTIONS(169),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(167),
    [anon_sym_AT_AT_ATt] = ACTIONS(167),
    [anon_sym_AT_AT] = ACTIONS(169),
    [anon_sym_AT_ATdbt] = ACTIONS(169),
    [anon_sym_AT_ATdbta] = ACTIONS(167),
    [anon_sym_AT_ATdbtb] = ACTIONS(167),
    [anon_sym_AT_ATdbts] = ACTIONS(167),
    [anon_sym_AT_AT_DOT] = ACTIONS(167),
    [anon_sym_AT_AT_EQ] = ACTIONS(167),
    [anon_sym_AT_ATk] = ACTIONS(167),
    [anon_sym_AT_ATt] = ACTIONS(167),
    [anon_sym_AT_ATb] = ACTIONS(167),
    [anon_sym_AT_ATi] = ACTIONS(169),
    [anon_sym_AT_ATiS] = ACTIONS(167),
    [anon_sym_AT_ATf] = ACTIONS(167),
    [anon_sym_AT_ATs_COLON] = ACTIONS(167),
    [anon_sym_AT_ATc_COLON] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(169),
    [anon_sym_AT_BANG] = ACTIONS(167),
    [anon_sym_AT_LBRACE] = ACTIONS(167),
    [anon_sym_ATa_COLON] = ACTIONS(167),
    [anon_sym_ATb_COLON] = ACTIONS(167),
    [anon_sym_ATB_COLON] = ACTIONS(167),
    [anon_sym_ATe_COLON] = ACTIONS(167),
    [anon_sym_ATF_COLON] = ACTIONS(167),
    [anon_sym_ATi_COLON] = ACTIONS(167),
    [anon_sym_ATk_COLON] = ACTIONS(167),
    [anon_sym_ATo_COLON] = ACTIONS(167),
    [anon_sym_ATr_COLON] = ACTIONS(167),
    [anon_sym_ATf_COLON] = ACTIONS(167),
    [anon_sym_ATs_COLON] = ACTIONS(167),
    [anon_sym_ATx_COLON] = ACTIONS(167),
    [anon_sym_PIPE_DOT] = ACTIONS(167),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(167),
    [anon_sym_GT] = ACTIONS(169),
    [anon_sym_GT_GT] = ACTIONS(167),
    [sym_html_redirect_operator] = ACTIONS(169),
    [sym_html_append_operator] = ACTIONS(167),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(167),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(167),
  },
  [72] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(233),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(141),
    [anon_sym_PIPE] = ACTIONS(143),
    [anon_sym_PIPEH] = ACTIONS(141),
    [anon_sym_PIPET] = ACTIONS(141),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(141),
    [anon_sym_AT_AT_ATb] = ACTIONS(141),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATi] = ACTIONS(141),
    [anon_sym_AT_AT_ATr] = ACTIONS(141),
    [anon_sym_AT_AT_ATs] = ACTIONS(143),
    [anon_sym_AT_AT_ATst] = ACTIONS(141),
    [anon_sym_AT_AT_ATS] = ACTIONS(141),
    [anon_sym_AT_AT_ATm] = ACTIONS(141),
    [anon_sym_AT_AT_ATM] = ACTIONS(141),
    [anon_sym_AT_AT_ATf] = ACTIONS(143),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATF] = ACTIONS(143),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(141),
    [anon_sym_AT_AT_ATt] = ACTIONS(141),
    [anon_sym_AT_AT] = ACTIONS(143),
    [anon_sym_AT_ATdbt] = ACTIONS(143),
    [anon_sym_AT_ATdbta] = ACTIONS(141),
    [anon_sym_AT_ATdbtb] = ACTIONS(141),
    [anon_sym_AT_ATdbts] = ACTIONS(141),
    [anon_sym_AT_AT_DOT] = ACTIONS(141),
    [anon_sym_AT_AT_EQ] = ACTIONS(141),
    [anon_sym_AT_ATk] = ACTIONS(141),
    [anon_sym_AT_ATt] = ACTIONS(141),
    [anon_sym_AT_ATb] = ACTIONS(141),
    [anon_sym_AT_ATi] = ACTIONS(143),
    [anon_sym_AT_ATiS] = ACTIONS(141),
    [anon_sym_AT_ATf] = ACTIONS(141),
    [anon_sym_AT_ATs_COLON] = ACTIONS(141),
    [anon_sym_AT_ATc_COLON] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(143),
    [anon_sym_AT_BANG] = ACTIONS(141),
    [anon_sym_AT_LBRACE] = ACTIONS(141),
    [anon_sym_ATa_COLON] = ACTIONS(141),
    [anon_sym_ATb_COLON] = ACTIONS(141),
    [anon_sym_ATB_COLON] = ACTIONS(141),
    [anon_sym_ATe_COLON] = ACTIONS(141),
    [anon_sym_ATF_COLON] = ACTIONS(141),
    [anon_sym_ATi_COLON] = ACTIONS(141),
    [anon_sym_ATk_COLON] = ACTIONS(141),
    [anon_sym_ATo_COLON] = ACTIONS(141),
    [anon_sym_ATr_COLON] = ACTIONS(141),
    [anon_sym_ATf_COLON] = ACTIONS(141),
    [anon_sym_ATs_COLON] = ACTIONS(141),
    [anon_sym_ATx_COLON] = ACTIONS(141),
    [anon_sym_PIPE_DOT] = ACTIONS(141),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(141),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_GT_GT] = ACTIONS(141),
    [sym_html_redirect_operator] = ACTIONS(143),
    [sym_html_append_operator] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(135),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(141),
  },
  [73] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(265),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PIPE] = ACTIONS(123),
    [anon_sym_PIPEH] = ACTIONS(119),
    [anon_sym_PIPET] = ACTIONS(119),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(119),
    [anon_sym_AT_AT_ATb] = ACTIONS(119),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATi] = ACTIONS(119),
    [anon_sym_AT_AT_ATr] = ACTIONS(119),
    [anon_sym_AT_AT_ATs] = ACTIONS(123),
    [anon_sym_AT_AT_ATst] = ACTIONS(119),
    [anon_sym_AT_AT_ATS] = ACTIONS(119),
    [anon_sym_AT_AT_ATm] = ACTIONS(119),
    [anon_sym_AT_AT_ATM] = ACTIONS(119),
    [anon_sym_AT_AT_ATf] = ACTIONS(123),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATF] = ACTIONS(123),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(119),
    [anon_sym_AT_AT_ATt] = ACTIONS(119),
    [anon_sym_AT_AT] = ACTIONS(123),
    [anon_sym_AT_ATdbt] = ACTIONS(123),
    [anon_sym_AT_ATdbta] = ACTIONS(119),
    [anon_sym_AT_ATdbtb] = ACTIONS(119),
    [anon_sym_AT_ATdbts] = ACTIONS(119),
    [anon_sym_AT_AT_DOT] = ACTIONS(119),
    [anon_sym_AT_AT_EQ] = ACTIONS(119),
    [anon_sym_AT_ATk] = ACTIONS(119),
    [anon_sym_AT_ATt] = ACTIONS(119),
    [anon_sym_AT_ATb] = ACTIONS(119),
    [anon_sym_AT_ATi] = ACTIONS(123),
    [anon_sym_AT_ATiS] = ACTIONS(119),
    [anon_sym_AT_ATf] = ACTIONS(119),
    [anon_sym_AT_ATs_COLON] = ACTIONS(119),
    [anon_sym_AT_ATc_COLON] = ACTIONS(119),
    [anon_sym_AT] = ACTIONS(123),
    [anon_sym_AT_BANG] = ACTIONS(119),
    [anon_sym_AT_LBRACE] = ACTIONS(119),
    [anon_sym_ATa_COLON] = ACTIONS(119),
    [anon_sym_ATb_COLON] = ACTIONS(119),
    [anon_sym_ATB_COLON] = ACTIONS(119),
    [anon_sym_ATe_COLON] = ACTIONS(119),
    [anon_sym_ATF_COLON] = ACTIONS(119),
    [anon_sym_ATi_COLON] = ACTIONS(119),
    [anon_sym_ATk_COLON] = ACTIONS(119),
    [anon_sym_ATo_COLON] = ACTIONS(119),
    [anon_sym_ATr_COLON] = ACTIONS(119),
    [anon_sym_ATf_COLON] = ACTIONS(119),
    [anon_sym_ATs_COLON] = ACTIONS(119),
    [anon_sym_ATx_COLON] = ACTIONS(119),
    [anon_sym_PIPE_DOT] = ACTIONS(119),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_GT] = ACTIONS(123),
    [anon_sym_GT_GT] = ACTIONS(119),
    [sym_html_redirect_operator] = ACTIONS(123),
    [sym_html_append_operator] = ACTIONS(119),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(119),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(119),
  },
  [74] = {
    [sym_macro_content] = STATE(169),
    [sym_macro_args] = STATE(220),
    [sym__arg] = STATE(371),
    [sym_arg] = STATE(299),
    [sym_arg_identifier] = STATE(371),
    [sym_double_quoted_arg] = STATE(371),
    [sym_single_quoted_arg] = STATE(371),
    [sym_cmd_substitution_arg] = STATE(371),
    [sym_concatenation] = STATE(390),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(149),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_PIPEH] = ACTIONS(149),
    [anon_sym_PIPET] = ACTIONS(149),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(149),
    [anon_sym_AT_AT_ATb] = ACTIONS(149),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATi] = ACTIONS(149),
    [anon_sym_AT_AT_ATr] = ACTIONS(149),
    [anon_sym_AT_AT_ATs] = ACTIONS(153),
    [anon_sym_AT_AT_ATst] = ACTIONS(149),
    [anon_sym_AT_AT_ATS] = ACTIONS(149),
    [anon_sym_AT_AT_ATm] = ACTIONS(149),
    [anon_sym_AT_AT_ATM] = ACTIONS(149),
    [anon_sym_AT_AT_ATf] = ACTIONS(153),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATF] = ACTIONS(153),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(149),
    [anon_sym_AT_AT_ATt] = ACTIONS(149),
    [anon_sym_AT_AT] = ACTIONS(153),
    [anon_sym_AT_ATdbt] = ACTIONS(153),
    [anon_sym_AT_ATdbta] = ACTIONS(149),
    [anon_sym_AT_ATdbtb] = ACTIONS(149),
    [anon_sym_AT_ATdbts] = ACTIONS(149),
    [anon_sym_AT_AT_DOT] = ACTIONS(149),
    [anon_sym_AT_AT_EQ] = ACTIONS(149),
    [anon_sym_AT_ATk] = ACTIONS(149),
    [anon_sym_AT_ATt] = ACTIONS(149),
    [anon_sym_AT_ATb] = ACTIONS(149),
    [anon_sym_AT_ATi] = ACTIONS(153),
    [anon_sym_AT_ATiS] = ACTIONS(149),
    [anon_sym_AT_ATf] = ACTIONS(149),
    [anon_sym_AT_ATs_COLON] = ACTIONS(149),
    [anon_sym_AT_ATc_COLON] = ACTIONS(149),
    [anon_sym_AT] = ACTIONS(153),
    [anon_sym_AT_BANG] = ACTIONS(149),
    [anon_sym_AT_LBRACE] = ACTIONS(149),
    [anon_sym_ATa_COLON] = ACTIONS(149),
    [anon_sym_ATb_COLON] = ACTIONS(149),
    [anon_sym_ATB_COLON] = ACTIONS(149),
    [anon_sym_ATe_COLON] = ACTIONS(149),
    [anon_sym_ATF_COLON] = ACTIONS(149),
    [anon_sym_ATi_COLON] = ACTIONS(149),
    [anon_sym_ATk_COLON] = ACTIONS(149),
    [anon_sym_ATo_COLON] = ACTIONS(149),
    [anon_sym_ATr_COLON] = ACTIONS(149),
    [anon_sym_ATf_COLON] = ACTIONS(149),
    [anon_sym_ATs_COLON] = ACTIONS(149),
    [anon_sym_ATx_COLON] = ACTIONS(149),
    [anon_sym_PIPE_DOT] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_SEMI] = ACTIONS(149),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_GT] = ACTIONS(149),
    [sym_html_redirect_operator] = ACTIONS(153),
    [sym_html_append_operator] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(159),
    [aux_sym_arg_identifier_token1] = ACTIONS(155),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(149),
  },
  [75] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(223),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(147),
    [anon_sym_PIPEH] = ACTIONS(145),
    [anon_sym_PIPET] = ACTIONS(145),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(145),
    [anon_sym_AT_AT_ATb] = ACTIONS(145),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATi] = ACTIONS(145),
    [anon_sym_AT_AT_ATr] = ACTIONS(145),
    [anon_sym_AT_AT_ATs] = ACTIONS(147),
    [anon_sym_AT_AT_ATst] = ACTIONS(145),
    [anon_sym_AT_AT_ATS] = ACTIONS(145),
    [anon_sym_AT_AT_ATm] = ACTIONS(145),
    [anon_sym_AT_AT_ATM] = ACTIONS(145),
    [anon_sym_AT_AT_ATf] = ACTIONS(147),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATF] = ACTIONS(147),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(145),
    [anon_sym_AT_AT_ATt] = ACTIONS(145),
    [anon_sym_AT_AT] = ACTIONS(147),
    [anon_sym_AT_ATdbt] = ACTIONS(147),
    [anon_sym_AT_ATdbta] = ACTIONS(145),
    [anon_sym_AT_ATdbtb] = ACTIONS(145),
    [anon_sym_AT_ATdbts] = ACTIONS(145),
    [anon_sym_AT_AT_DOT] = ACTIONS(145),
    [anon_sym_AT_AT_EQ] = ACTIONS(145),
    [anon_sym_AT_ATk] = ACTIONS(145),
    [anon_sym_AT_ATt] = ACTIONS(145),
    [anon_sym_AT_ATb] = ACTIONS(145),
    [anon_sym_AT_ATi] = ACTIONS(147),
    [anon_sym_AT_ATiS] = ACTIONS(145),
    [anon_sym_AT_ATf] = ACTIONS(145),
    [anon_sym_AT_ATs_COLON] = ACTIONS(145),
    [anon_sym_AT_ATc_COLON] = ACTIONS(145),
    [anon_sym_AT] = ACTIONS(147),
    [anon_sym_AT_BANG] = ACTIONS(145),
    [anon_sym_AT_LBRACE] = ACTIONS(145),
    [anon_sym_ATa_COLON] = ACTIONS(145),
    [anon_sym_ATb_COLON] = ACTIONS(145),
    [anon_sym_ATB_COLON] = ACTIONS(145),
    [anon_sym_ATe_COLON] = ACTIONS(145),
    [anon_sym_ATF_COLON] = ACTIONS(145),
    [anon_sym_ATi_COLON] = ACTIONS(145),
    [anon_sym_ATk_COLON] = ACTIONS(145),
    [anon_sym_ATo_COLON] = ACTIONS(145),
    [anon_sym_ATr_COLON] = ACTIONS(145),
    [anon_sym_ATf_COLON] = ACTIONS(145),
    [anon_sym_ATs_COLON] = ACTIONS(145),
    [anon_sym_ATx_COLON] = ACTIONS(145),
    [anon_sym_PIPE_DOT] = ACTIONS(145),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(147),
    [anon_sym_GT_GT] = ACTIONS(145),
    [sym_html_redirect_operator] = ACTIONS(147),
    [sym_html_append_operator] = ACTIONS(145),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(145),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(145),
  },
  [76] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(266),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_PIPE] = ACTIONS(65),
    [anon_sym_PIPEH] = ACTIONS(63),
    [anon_sym_PIPET] = ACTIONS(63),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATi] = ACTIONS(63),
    [anon_sym_AT_AT_ATr] = ACTIONS(63),
    [anon_sym_AT_AT_ATs] = ACTIONS(65),
    [anon_sym_AT_AT_ATst] = ACTIONS(63),
    [anon_sym_AT_AT_ATS] = ACTIONS(63),
    [anon_sym_AT_AT_ATm] = ACTIONS(63),
    [anon_sym_AT_AT_ATM] = ACTIONS(63),
    [anon_sym_AT_AT_ATf] = ACTIONS(65),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATF] = ACTIONS(65),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(63),
    [anon_sym_AT_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_AT] = ACTIONS(65),
    [anon_sym_AT_ATdbt] = ACTIONS(65),
    [anon_sym_AT_ATdbta] = ACTIONS(63),
    [anon_sym_AT_ATdbtb] = ACTIONS(63),
    [anon_sym_AT_ATdbts] = ACTIONS(63),
    [anon_sym_AT_AT_DOT] = ACTIONS(63),
    [anon_sym_AT_AT_EQ] = ACTIONS(63),
    [anon_sym_AT_ATk] = ACTIONS(63),
    [anon_sym_AT_ATt] = ACTIONS(63),
    [anon_sym_AT_ATb] = ACTIONS(63),
    [anon_sym_AT_ATi] = ACTIONS(65),
    [anon_sym_AT_ATiS] = ACTIONS(63),
    [anon_sym_AT_ATf] = ACTIONS(63),
    [anon_sym_AT_ATs_COLON] = ACTIONS(63),
    [anon_sym_AT_ATc_COLON] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(65),
    [anon_sym_AT_BANG] = ACTIONS(63),
    [anon_sym_AT_LBRACE] = ACTIONS(63),
    [anon_sym_ATa_COLON] = ACTIONS(63),
    [anon_sym_ATb_COLON] = ACTIONS(63),
    [anon_sym_ATB_COLON] = ACTIONS(63),
    [anon_sym_ATe_COLON] = ACTIONS(63),
    [anon_sym_ATF_COLON] = ACTIONS(63),
    [anon_sym_ATi_COLON] = ACTIONS(63),
    [anon_sym_ATk_COLON] = ACTIONS(63),
    [anon_sym_ATo_COLON] = ACTIONS(63),
    [anon_sym_ATr_COLON] = ACTIONS(63),
    [anon_sym_ATf_COLON] = ACTIONS(63),
    [anon_sym_ATs_COLON] = ACTIONS(63),
    [anon_sym_ATx_COLON] = ACTIONS(63),
    [anon_sym_PIPE_DOT] = ACTIONS(63),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(63),
    [anon_sym_GT] = ACTIONS(65),
    [anon_sym_GT_GT] = ACTIONS(63),
    [sym_html_redirect_operator] = ACTIONS(65),
    [sym_html_append_operator] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(63),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(63),
  },
  [77] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(82),
    [sym_args] = STATE(263),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(82),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_PIPE] = ACTIONS(139),
    [anon_sym_PIPEH] = ACTIONS(137),
    [anon_sym_PIPET] = ACTIONS(137),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATi] = ACTIONS(137),
    [anon_sym_AT_AT_ATr] = ACTIONS(137),
    [anon_sym_AT_AT_ATs] = ACTIONS(139),
    [anon_sym_AT_AT_ATst] = ACTIONS(137),
    [anon_sym_AT_AT_ATS] = ACTIONS(137),
    [anon_sym_AT_AT_ATm] = ACTIONS(137),
    [anon_sym_AT_AT_ATM] = ACTIONS(137),
    [anon_sym_AT_AT_ATf] = ACTIONS(139),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATF] = ACTIONS(139),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(137),
    [anon_sym_AT_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_AT] = ACTIONS(139),
    [anon_sym_AT_ATdbt] = ACTIONS(139),
    [anon_sym_AT_ATdbta] = ACTIONS(137),
    [anon_sym_AT_ATdbtb] = ACTIONS(137),
    [anon_sym_AT_ATdbts] = ACTIONS(137),
    [anon_sym_AT_AT_DOT] = ACTIONS(137),
    [anon_sym_AT_AT_EQ] = ACTIONS(137),
    [anon_sym_AT_ATk] = ACTIONS(137),
    [anon_sym_AT_ATt] = ACTIONS(137),
    [anon_sym_AT_ATb] = ACTIONS(137),
    [anon_sym_AT_ATi] = ACTIONS(139),
    [anon_sym_AT_ATiS] = ACTIONS(137),
    [anon_sym_AT_ATf] = ACTIONS(137),
    [anon_sym_AT_ATs_COLON] = ACTIONS(137),
    [anon_sym_AT_ATc_COLON] = ACTIONS(137),
    [anon_sym_AT] = ACTIONS(139),
    [anon_sym_AT_BANG] = ACTIONS(137),
    [anon_sym_AT_LBRACE] = ACTIONS(137),
    [anon_sym_ATa_COLON] = ACTIONS(137),
    [anon_sym_ATb_COLON] = ACTIONS(137),
    [anon_sym_ATB_COLON] = ACTIONS(137),
    [anon_sym_ATe_COLON] = ACTIONS(137),
    [anon_sym_ATF_COLON] = ACTIONS(137),
    [anon_sym_ATi_COLON] = ACTIONS(137),
    [anon_sym_ATk_COLON] = ACTIONS(137),
    [anon_sym_ATo_COLON] = ACTIONS(137),
    [anon_sym_ATr_COLON] = ACTIONS(137),
    [anon_sym_ATf_COLON] = ACTIONS(137),
    [anon_sym_ATs_COLON] = ACTIONS(137),
    [anon_sym_ATx_COLON] = ACTIONS(137),
    [anon_sym_PIPE_DOT] = ACTIONS(137),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(137),
    [anon_sym_GT] = ACTIONS(139),
    [anon_sym_GT_GT] = ACTIONS(137),
    [sym_html_redirect_operator] = ACTIONS(139),
    [sym_html_append_operator] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(137),
  },
  [78] = {
    [sym__pf_arg_parentheses] = STATE(109),
    [sym_pf_arg_identifier] = STATE(109),
    [sym__pf_arg] = STATE(109),
    [sym_pf_concatenation] = STATE(121),
    [sym_pf_arg] = STATE(81),
    [sym_cmd_substitution_arg] = STATE(109),
    [aux_sym_pf_args_repeat1] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_PIPEH] = ACTIONS(265),
    [anon_sym_PIPET] = ACTIONS(265),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(265),
    [anon_sym_AT_AT_ATb] = ACTIONS(265),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATi] = ACTIONS(265),
    [anon_sym_AT_AT_ATr] = ACTIONS(265),
    [anon_sym_AT_AT_ATs] = ACTIONS(267),
    [anon_sym_AT_AT_ATst] = ACTIONS(265),
    [anon_sym_AT_AT_ATS] = ACTIONS(265),
    [anon_sym_AT_AT_ATm] = ACTIONS(265),
    [anon_sym_AT_AT_ATM] = ACTIONS(265),
    [anon_sym_AT_AT_ATf] = ACTIONS(267),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATF] = ACTIONS(267),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATt] = ACTIONS(265),
    [anon_sym_AT_AT] = ACTIONS(267),
    [anon_sym_AT_ATdbt] = ACTIONS(267),
    [anon_sym_AT_ATdbta] = ACTIONS(265),
    [anon_sym_AT_ATdbtb] = ACTIONS(265),
    [anon_sym_AT_ATdbts] = ACTIONS(265),
    [anon_sym_AT_AT_DOT] = ACTIONS(265),
    [anon_sym_AT_AT_EQ] = ACTIONS(265),
    [anon_sym_AT_ATk] = ACTIONS(265),
    [anon_sym_AT_ATt] = ACTIONS(265),
    [anon_sym_AT_ATb] = ACTIONS(265),
    [anon_sym_AT_ATi] = ACTIONS(267),
    [anon_sym_AT_ATiS] = ACTIONS(265),
    [anon_sym_AT_ATf] = ACTIONS(265),
    [anon_sym_AT_ATs_COLON] = ACTIONS(265),
    [anon_sym_AT_ATc_COLON] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_AT_BANG] = ACTIONS(265),
    [anon_sym_AT_LBRACE] = ACTIONS(265),
    [anon_sym_ATa_COLON] = ACTIONS(265),
    [anon_sym_ATb_COLON] = ACTIONS(265),
    [anon_sym_ATB_COLON] = ACTIONS(265),
    [anon_sym_ATe_COLON] = ACTIONS(265),
    [anon_sym_ATF_COLON] = ACTIONS(265),
    [anon_sym_ATi_COLON] = ACTIONS(265),
    [anon_sym_ATk_COLON] = ACTIONS(265),
    [anon_sym_ATo_COLON] = ACTIONS(265),
    [anon_sym_ATr_COLON] = ACTIONS(265),
    [anon_sym_ATf_COLON] = ACTIONS(265),
    [anon_sym_ATs_COLON] = ACTIONS(265),
    [anon_sym_ATx_COLON] = ACTIONS(265),
    [anon_sym_PIPE_DOT] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(255),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_RPAREN] = ACTIONS(265),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(255),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_GT_GT] = ACTIONS(265),
    [sym_html_redirect_operator] = ACTIONS(267),
    [sym_html_append_operator] = ACTIONS(265),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(259),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(265),
    [anon_sym_CR] = ACTIONS(265),
    [sym_file_descriptor] = ACTIONS(265),
  },
  [79] = {
    [sym__pf_arg_parentheses] = STATE(109),
    [sym_pf_arg_identifier] = STATE(109),
    [sym__pf_arg] = STATE(109),
    [sym_pf_concatenation] = STATE(121),
    [sym_pf_arg] = STATE(98),
    [sym_pf_args] = STATE(232),
    [sym_cmd_substitution_arg] = STATE(109),
    [aux_sym_pf_args_repeat1] = STATE(98),
    [aux_sym_pf_dot_args_repeat1] = STATE(123),
    [anon_sym_TILDE] = ACTIONS(251),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_PIPEH] = ACTIONS(251),
    [anon_sym_PIPET] = ACTIONS(251),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(251),
    [anon_sym_AT_AT_ATb] = ACTIONS(251),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATi] = ACTIONS(251),
    [anon_sym_AT_AT_ATr] = ACTIONS(251),
    [anon_sym_AT_AT_ATs] = ACTIONS(253),
    [anon_sym_AT_AT_ATst] = ACTIONS(251),
    [anon_sym_AT_AT_ATS] = ACTIONS(251),
    [anon_sym_AT_AT_ATm] = ACTIONS(251),
    [anon_sym_AT_AT_ATM] = ACTIONS(251),
    [anon_sym_AT_AT_ATf] = ACTIONS(253),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATF] = ACTIONS(253),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATt] = ACTIONS(251),
    [anon_sym_AT_AT] = ACTIONS(253),
    [anon_sym_AT_ATdbt] = ACTIONS(253),
    [anon_sym_AT_ATdbta] = ACTIONS(251),
    [anon_sym_AT_ATdbtb] = ACTIONS(251),
    [anon_sym_AT_ATdbts] = ACTIONS(251),
    [anon_sym_AT_AT_DOT] = ACTIONS(251),
    [anon_sym_AT_AT_EQ] = ACTIONS(251),
    [anon_sym_AT_ATk] = ACTIONS(251),
    [anon_sym_AT_ATt] = ACTIONS(251),
    [anon_sym_AT_ATb] = ACTIONS(251),
    [anon_sym_AT_ATi] = ACTIONS(253),
    [anon_sym_AT_ATiS] = ACTIONS(251),
    [anon_sym_AT_ATf] = ACTIONS(251),
    [anon_sym_AT_ATs_COLON] = ACTIONS(251),
    [anon_sym_AT_ATc_COLON] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_AT_BANG] = ACTIONS(251),
    [anon_sym_AT_LBRACE] = ACTIONS(251),
    [anon_sym_ATa_COLON] = ACTIONS(251),
    [anon_sym_ATb_COLON] = ACTIONS(251),
    [anon_sym_ATB_COLON] = ACTIONS(251),
    [anon_sym_ATe_COLON] = ACTIONS(251),
    [anon_sym_ATF_COLON] = ACTIONS(251),
    [anon_sym_ATi_COLON] = ACTIONS(251),
    [anon_sym_ATk_COLON] = ACTIONS(251),
    [anon_sym_ATo_COLON] = ACTIONS(251),
    [anon_sym_ATr_COLON] = ACTIONS(251),
    [anon_sym_ATf_COLON] = ACTIONS(251),
    [anon_sym_ATs_COLON] = ACTIONS(251),
    [anon_sym_ATx_COLON] = ACTIONS(251),
    [anon_sym_PIPE_DOT] = ACTIONS(251),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_DOLLAR] = ACTIONS(255),
    [anon_sym_LPAREN] = ACTIONS(257),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(255),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_GT_GT] = ACTIONS(251),
    [sym_html_redirect_operator] = ACTIONS(253),
    [sym_html_append_operator] = ACTIONS(251),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(259),
    [anon_sym_BQUOTE] = ACTIONS(251),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(251),
    [sym__concat_pf_dot] = ACTIONS(263),
  },
  [80] = {
    [sym__arg] = STATE(371),
    [sym_arg] = STATE(338),
    [sym_arg_identifier] = STATE(371),
    [sym_double_quoted_arg] = STATE(371),
    [sym_single_quoted_arg] = STATE(371),
    [sym_cmd_substitution_arg] = STATE(371),
    [sym_concatenation] = STATE(390),
    [aux_sym_foreach_addrsize_command_repeat1] = STATE(63),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_TILDE] = ACTIONS(247),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_PIPEH] = ACTIONS(247),
    [anon_sym_PIPET] = ACTIONS(247),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(247),
    [anon_sym_AT_AT_ATb] = ACTIONS(247),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATi] = ACTIONS(247),
    [anon_sym_AT_AT_ATr] = ACTIONS(247),
    [anon_sym_AT_AT_ATs] = ACTIONS(249),
    [anon_sym_AT_AT_ATst] = ACTIONS(247),
    [anon_sym_AT_AT_ATS] = ACTIONS(247),
    [anon_sym_AT_AT_ATm] = ACTIONS(247),
    [anon_sym_AT_AT_ATM] = ACTIONS(247),
    [anon_sym_AT_AT_ATf] = ACTIONS(249),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATF] = ACTIONS(249),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(247),
    [anon_sym_AT_AT_ATt] = ACTIONS(247),
    [anon_sym_AT_AT] = ACTIONS(249),
    [anon_sym_AT_ATdbt] = ACTIONS(249),
    [anon_sym_AT_ATdbta] = ACTIONS(247),
    [anon_sym_AT_ATdbtb] = ACTIONS(247),
    [anon_sym_AT_ATdbts] = ACTIONS(247),
    [anon_sym_AT_AT_DOT] = ACTIONS(247),
    [anon_sym_AT_AT_EQ] = ACTIONS(247),
    [anon_sym_AT_ATk] = ACTIONS(247),
    [anon_sym_AT_ATt] = ACTIONS(247),
    [anon_sym_AT_ATb] = ACTIONS(247),
    [anon_sym_AT_ATi] = ACTIONS(249),
    [anon_sym_AT_ATiS] = ACTIONS(247),
    [anon_sym_AT_ATf] = ACTIONS(247),
    [anon_sym_AT_ATs_COLON] = ACTIONS(247),
    [anon_sym_AT_ATc_COLON] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(249),
    [anon_sym_AT_BANG] = ACTIONS(247),
    [anon_sym_AT_LBRACE] = ACTIONS(247),
    [anon_sym_ATa_COLON] = ACTIONS(247),
    [anon_sym_ATb_COLON] = ACTIONS(247),
    [anon_sym_ATB_COLON] = ACTIONS(247),
    [anon_sym_ATe_COLON] = ACTIONS(247),
    [anon_sym_ATF_COLON] = ACTIONS(247),
    [anon_sym_ATi_COLON] = ACTIONS(247),
    [anon_sym_ATk_COLON] = ACTIONS(247),
    [anon_sym_ATo_COLON] = ACTIONS(247),
    [anon_sym_ATr_COLON] = ACTIONS(247),
    [anon_sym_ATf_COLON] = ACTIONS(247),
    [anon_sym_ATs_COLON] = ACTIONS(247),
    [anon_sym_ATx_COLON] = ACTIONS(247),
    [anon_sym_PIPE_DOT] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(157),
    [anon_sym_SEMI] = ACTIONS(247),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [sym_html_redirect_operator] = ACTIONS(249),
    [sym_html_append_operator] = ACTIONS(247),
    [anon_sym_COMMA] = ACTIONS(159),
    [aux_sym_arg_identifier_token1] = ACTIONS(155),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(163),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(247),
  },
  [81] = {
    [sym__pf_arg_parentheses] = STATE(109),
    [sym_pf_arg_identifier] = STATE(109),
    [sym__pf_arg] = STATE(109),
    [sym_pf_concatenation] = STATE(121),
    [sym_pf_arg] = STATE(81),
    [sym_cmd_substitution_arg] = STATE(109),
    [aux_sym_pf_args_repeat1] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(269),
    [anon_sym_TILDE] = ACTIONS(269),
    [anon_sym_PIPE] = ACTIONS(271),
    [anon_sym_PIPEH] = ACTIONS(269),
    [anon_sym_PIPET] = ACTIONS(269),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(269),
    [anon_sym_AT_AT_ATb] = ACTIONS(269),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(269),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(269),
    [anon_sym_AT_AT_ATi] = ACTIONS(269),
    [anon_sym_AT_AT_ATr] = ACTIONS(269),
    [anon_sym_AT_AT_ATs] = ACTIONS(271),
    [anon_sym_AT_AT_ATst] = ACTIONS(269),
    [anon_sym_AT_AT_ATS] = ACTIONS(269),
    [anon_sym_AT_AT_ATm] = ACTIONS(269),
    [anon_sym_AT_AT_ATM] = ACTIONS(269),
    [anon_sym_AT_AT_ATf] = ACTIONS(271),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(269),
    [anon_sym_AT_AT_ATF] = ACTIONS(271),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(269),
    [anon_sym_AT_AT_ATt] = ACTIONS(269),
    [anon_sym_AT_AT] = ACTIONS(271),
    [anon_sym_AT_ATdbt] = ACTIONS(271),
    [anon_sym_AT_ATdbta] = ACTIONS(269),
    [anon_sym_AT_ATdbtb] = ACTIONS(269),
    [anon_sym_AT_ATdbts] = ACTIONS(269),
    [anon_sym_AT_AT_DOT] = ACTIONS(269),
    [anon_sym_AT_AT_EQ] = ACTIONS(269),
    [anon_sym_AT_ATk] = ACTIONS(269),
    [anon_sym_AT_ATt] = ACTIONS(269),
    [anon_sym_AT_ATb] = ACTIONS(269),
    [anon_sym_AT_ATi] = ACTIONS(271),
    [anon_sym_AT_ATiS] = ACTIONS(269),
    [anon_sym_AT_ATf] = ACTIONS(269),
    [anon_sym_AT_ATs_COLON] = ACTIONS(269),
    [anon_sym_AT_ATc_COLON] = ACTIONS(269),
    [anon_sym_AT] = ACTIONS(271),
    [anon_sym_AT_BANG] = ACTIONS(269),
    [anon_sym_AT_LBRACE] = ACTIONS(269),
    [anon_sym_ATa_COLON] = ACTIONS(269),
    [anon_sym_ATb_COLON] = ACTIONS(269),
    [anon_sym_ATB_COLON] = ACTIONS(269),
    [anon_sym_ATe_COLON] = ACTIONS(269),
    [anon_sym_ATF_COLON] = ACTIONS(269),
    [anon_sym_ATi_COLON] = ACTIONS(269),
    [anon_sym_ATk_COLON] = ACTIONS(269),
    [anon_sym_ATo_COLON] = ACTIONS(269),
    [anon_sym_ATr_COLON] = ACTIONS(269),
    [anon_sym_ATf_COLON] = ACTIONS(269),
    [anon_sym_ATs_COLON] = ACTIONS(269),
    [anon_sym_ATx_COLON] = ACTIONS(269),
    [anon_sym_PIPE_DOT] = ACTIONS(269),
    [anon_sym_DOLLAR] = ACTIONS(273),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_RPAREN] = ACTIONS(269),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(273),
    [anon_sym_SEMI] = ACTIONS(269),
    [anon_sym_GT] = ACTIONS(271),
    [anon_sym_GT_GT] = ACTIONS(269),
    [sym_html_redirect_operator] = ACTIONS(271),
    [sym_html_append_operator] = ACTIONS(269),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_BQUOTE] = ACTIONS(282),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(269),
    [anon_sym_CR] = ACTIONS(269),
    [sym_file_descriptor] = ACTIONS(269),
  },
  [82] = {
    [sym__arg] = STATE(85),
    [sym_arg] = STATE(66),
    [sym_arg_identifier] = STATE(85),
    [sym_double_quoted_arg] = STATE(85),
    [sym_single_quoted_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(85),
    [sym_concatenation] = STATE(100),
    [aux_sym_args_repeat1] = STATE(66),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(200),
    [anon_sym_PIPE] = ACTIONS(202),
    [anon_sym_PIPEH] = ACTIONS(200),
    [anon_sym_PIPET] = ACTIONS(200),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(200),
    [anon_sym_AT_AT_ATb] = ACTIONS(200),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATi] = ACTIONS(200),
    [anon_sym_AT_AT_ATr] = ACTIONS(200),
    [anon_sym_AT_AT_ATs] = ACTIONS(202),
    [anon_sym_AT_AT_ATst] = ACTIONS(200),
    [anon_sym_AT_AT_ATS] = ACTIONS(200),
    [anon_sym_AT_AT_ATm] = ACTIONS(200),
    [anon_sym_AT_AT_ATM] = ACTIONS(200),
    [anon_sym_AT_AT_ATf] = ACTIONS(202),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATF] = ACTIONS(202),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(200),
    [anon_sym_AT_AT_ATt] = ACTIONS(200),
    [anon_sym_AT_AT] = ACTIONS(202),
    [anon_sym_AT_ATdbt] = ACTIONS(202),
    [anon_sym_AT_ATdbta] = ACTIONS(200),
    [anon_sym_AT_ATdbtb] = ACTIONS(200),
    [anon_sym_AT_ATdbts] = ACTIONS(200),
    [anon_sym_AT_AT_DOT] = ACTIONS(200),
    [anon_sym_AT_AT_EQ] = ACTIONS(200),
    [anon_sym_AT_ATk] = ACTIONS(200),
    [anon_sym_AT_ATt] = ACTIONS(200),
    [anon_sym_AT_ATb] = ACTIONS(200),
    [anon_sym_AT_ATi] = ACTIONS(202),
    [anon_sym_AT_ATiS] = ACTIONS(200),
    [anon_sym_AT_ATf] = ACTIONS(200),
    [anon_sym_AT_ATs_COLON] = ACTIONS(200),
    [anon_sym_AT_ATc_COLON] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(202),
    [anon_sym_AT_BANG] = ACTIONS(200),
    [anon_sym_AT_LBRACE] = ACTIONS(200),
    [anon_sym_ATa_COLON] = ACTIONS(200),
    [anon_sym_ATb_COLON] = ACTIONS(200),
    [anon_sym_ATB_COLON] = ACTIONS(200),
    [anon_sym_ATe_COLON] = ACTIONS(200),
    [anon_sym_ATF_COLON] = ACTIONS(200),
    [anon_sym_ATi_COLON] = ACTIONS(200),
    [anon_sym_ATk_COLON] = ACTIONS(200),
    [anon_sym_ATo_COLON] = ACTIONS(200),
    [anon_sym_ATr_COLON] = ACTIONS(200),
    [anon_sym_ATf_COLON] = ACTIONS(200),
    [anon_sym_ATs_COLON] = ACTIONS(200),
    [anon_sym_ATx_COLON] = ACTIONS(200),
    [anon_sym_PIPE_DOT] = ACTIONS(200),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(127),
    [anon_sym_SEMI] = ACTIONS(200),
    [anon_sym_GT] = ACTIONS(202),
    [anon_sym_GT_GT] = ACTIONS(200),
    [sym_html_redirect_operator] = ACTIONS(202),
    [sym_html_append_operator] = ACTIONS(200),
    [anon_sym_COMMA] = ACTIONS(129),
    [aux_sym_arg_identifier_token1] = ACTIONS(125),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(200),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(200),
  },
  [83] = {
    [sym__Cf_args] = STATE(214),
    [sym__arg] = STATE(456),
    [sym_arg] = STATE(363),
    [sym_arg_identifier] = STATE(456),
    [sym_double_quoted_arg] = STATE(456),
    [sym_single_quoted_arg] = STATE(456),
    [sym_cmd_substitution_arg] = STATE(456),
    [sym_concatenation] = STATE(479),
    [anon_sym_DQUOTE] = ACTIONS(206),
    [anon_sym_TILDE] = ACTIONS(204),
    [anon_sym_PIPE] = ACTIONS(208),
    [anon_sym_PIPEH] = ACTIONS(204),
    [anon_sym_PIPET] = ACTIONS(204),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(204),
    [anon_sym_AT_AT_ATb] = ACTIONS(204),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATi] = ACTIONS(204),
    [anon_sym_AT_AT_ATr] = ACTIONS(204),
    [anon_sym_AT_AT_ATs] = ACTIONS(208),
    [anon_sym_AT_AT_ATst] = ACTIONS(204),
    [anon_sym_AT_AT_ATS] = ACTIONS(204),
    [anon_sym_AT_AT_ATm] = ACTIONS(204),
    [anon_sym_AT_AT_ATM] = ACTIONS(204),
    [anon_sym_AT_AT_ATf] = ACTIONS(208),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATF] = ACTIONS(208),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(204),
    [anon_sym_AT_AT_ATt] = ACTIONS(204),
    [anon_sym_AT_AT] = ACTIONS(208),
    [anon_sym_AT_ATdbt] = ACTIONS(208),
    [anon_sym_AT_ATdbta] = ACTIONS(204),
    [anon_sym_AT_ATdbtb] = ACTIONS(204),
    [anon_sym_AT_ATdbts] = ACTIONS(204),
    [anon_sym_AT_AT_DOT] = ACTIONS(204),
    [anon_sym_AT_AT_EQ] = ACTIONS(204),
    [anon_sym_AT_ATk] = ACTIONS(204),
    [anon_sym_AT_ATt] = ACTIONS(204),
    [anon_sym_AT_ATb] = ACTIONS(204),
    [anon_sym_AT_ATi] = ACTIONS(208),
    [anon_sym_AT_ATiS] = ACTIONS(204),
    [anon_sym_AT_ATf] = ACTIONS(204),
    [anon_sym_AT_ATs_COLON] = ACTIONS(204),
    [anon_sym_AT_ATc_COLON] = ACTIONS(204),
    [anon_sym_AT] = ACTIONS(208),
    [anon_sym_AT_BANG] = ACTIONS(204),
    [anon_sym_AT_LBRACE] = ACTIONS(204),
    [anon_sym_ATa_COLON] = ACTIONS(204),
    [anon_sym_ATb_COLON] = ACTIONS(204),
    [anon_sym_ATB_COLON] = ACTIONS(204),
    [anon_sym_ATe_COLON] = ACTIONS(204),
    [anon_sym_ATF_COLON] = ACTIONS(204),
    [anon_sym_ATi_COLON] = ACTIONS(204),
    [anon_sym_ATk_COLON] = ACTIONS(204),
    [anon_sym_ATo_COLON] = ACTIONS(204),
    [anon_sym_ATr_COLON] = ACTIONS(204),
    [anon_sym_ATf_COLON] = ACTIONS(204),
    [anon_sym_ATs_COLON] = ACTIONS(204),
    [anon_sym_ATx_COLON] = ACTIONS(204),
    [anon_sym_PIPE_DOT] = ACTIONS(204),
    [anon_sym_DOLLAR] = ACTIONS(210),
    [anon_sym_LPAREN] = ACTIONS(212),
    [anon_sym_SEMI] = ACTIONS(204),
    [anon_sym_GT] = ACTIONS(208),
    [anon_sym_GT_GT] = ACTIONS(204),
    [sym_html_redirect_operator] = ACTIONS(208),
    [sym_html_append_operator] = ACTIONS(204),
    [anon_sym_COMMA] = ACTIONS(214),
    [aux_sym_arg_identifier_token1] = ACTIONS(210),
    [anon_sym_SQUOTE] = ACTIONS(216),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(218),
    [anon_sym_BQUOTE] = ACTIONS(204),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(204),
  },
  [84] = {
    [sym_eq_sep_args] = STATE(219),
    [sym__eq_sep_key_single] = STATE(129),
    [sym_eq_sep_key] = STATE(177),
    [sym_double_quoted_arg] = STATE(167),
    [sym_single_quoted_arg] = STATE(167),
    [sym_cmd_substitution_arg] = STATE(167),
    [ts_builtin_sym_end] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(289),
    [anon_sym_PIPEH] = ACTIONS(285),
    [anon_sym_PIPET] = ACTIONS(285),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(285),
    [anon_sym_AT_AT_ATb] = ACTIONS(285),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATi] = ACTIONS(285),
    [anon_sym_AT_AT_ATr] = ACTIONS(285),
    [anon_sym_AT_AT_ATs] = ACTIONS(289),
    [anon_sym_AT_AT_ATst] = ACTIONS(285),
    [anon_sym_AT_AT_ATS] = ACTIONS(285),
    [anon_sym_AT_AT_ATm] = ACTIONS(285),
    [anon_sym_AT_AT_ATM] = ACTIONS(285),
    [anon_sym_AT_AT_ATf] = ACTIONS(289),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATF] = ACTIONS(289),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATt] = ACTIONS(285),
    [anon_sym_AT_AT] = ACTIONS(289),
    [anon_sym_AT_ATdbt] = ACTIONS(289),
    [anon_sym_AT_ATdbta] = ACTIONS(285),
    [anon_sym_AT_ATdbtb] = ACTIONS(285),
    [anon_sym_AT_ATdbts] = ACTIONS(285),
    [anon_sym_AT_AT_DOT] = ACTIONS(285),
    [anon_sym_AT_AT_EQ] = ACTIONS(285),
    [anon_sym_AT_ATk] = ACTIONS(285),
    [anon_sym_AT_ATt] = ACTIONS(285),
    [anon_sym_AT_ATb] = ACTIONS(285),
    [anon_sym_AT_ATi] = ACTIONS(289),
    [anon_sym_AT_ATiS] = ACTIONS(285),
    [anon_sym_AT_ATf] = ACTIONS(285),
    [anon_sym_AT_ATs_COLON] = ACTIONS(285),
    [anon_sym_AT_ATc_COLON] = ACTIONS(285),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_AT_BANG] = ACTIONS(285),
    [anon_sym_AT_LBRACE] = ACTIONS(285),
    [anon_sym_ATa_COLON] = ACTIONS(285),
    [anon_sym_ATb_COLON] = ACTIONS(285),
    [anon_sym_ATB_COLON] = ACTIONS(285),
    [anon_sym_ATe_COLON] = ACTIONS(285),
    [anon_sym_ATF_COLON] = ACTIONS(285),
    [anon_sym_ATi_COLON] = ACTIONS(285),
    [anon_sym_ATk_COLON] = ACTIONS(285),
    [anon_sym_ATo_COLON] = ACTIONS(285),
    [anon_sym_ATr_COLON] = ACTIONS(285),
    [anon_sym_ATf_COLON] = ACTIONS(285),
    [anon_sym_ATs_COLON] = ACTIONS(285),
    [anon_sym_ATx_COLON] = ACTIONS(285),
    [anon_sym_PIPE_DOT] = ACTIONS(285),
    [anon_sym_RPAREN] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(285),
    [sym_html_redirect_operator] = ACTIONS(289),
    [sym_html_append_operator] = ACTIONS(285),
    [sym__eq_sep_key_identifier] = ACTIONS(291),
    [anon_sym_SQUOTE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(285),
    [anon_sym_CR] = ACTIONS(285),
    [sym_file_descriptor] = ACTIONS(285),
  },
  [85] = {
    [aux_sym_concatenation_repeat1] = STATE(87),
    [ts_builtin_sym_end] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_TILDE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_PIPEH] = ACTIONS(299),
    [anon_sym_PIPET] = ACTIONS(299),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATi] = ACTIONS(299),
    [anon_sym_AT_AT_ATr] = ACTIONS(299),
    [anon_sym_AT_AT_ATs] = ACTIONS(301),
    [anon_sym_AT_AT_ATst] = ACTIONS(299),
    [anon_sym_AT_AT_ATS] = ACTIONS(299),
    [anon_sym_AT_AT_ATm] = ACTIONS(299),
    [anon_sym_AT_AT_ATM] = ACTIONS(299),
    [anon_sym_AT_AT_ATf] = ACTIONS(301),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATF] = ACTIONS(301),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_AT] = ACTIONS(301),
    [anon_sym_AT_ATdbt] = ACTIONS(301),
    [anon_sym_AT_ATdbta] = ACTIONS(299),
    [anon_sym_AT_ATdbtb] = ACTIONS(299),
    [anon_sym_AT_ATdbts] = ACTIONS(299),
    [anon_sym_AT_AT_DOT] = ACTIONS(299),
    [anon_sym_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_ATk] = ACTIONS(299),
    [anon_sym_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_ATi] = ACTIONS(301),
    [anon_sym_AT_ATiS] = ACTIONS(299),
    [anon_sym_AT_ATf] = ACTIONS(299),
    [anon_sym_AT_ATs_COLON] = ACTIONS(299),
    [anon_sym_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_AT_BANG] = ACTIONS(299),
    [anon_sym_AT_LBRACE] = ACTIONS(299),
    [anon_sym_ATa_COLON] = ACTIONS(299),
    [anon_sym_ATb_COLON] = ACTIONS(299),
    [anon_sym_ATB_COLON] = ACTIONS(299),
    [anon_sym_ATe_COLON] = ACTIONS(299),
    [anon_sym_ATF_COLON] = ACTIONS(299),
    [anon_sym_ATi_COLON] = ACTIONS(299),
    [anon_sym_ATk_COLON] = ACTIONS(299),
    [anon_sym_ATo_COLON] = ACTIONS(299),
    [anon_sym_ATr_COLON] = ACTIONS(299),
    [anon_sym_ATf_COLON] = ACTIONS(299),
    [anon_sym_ATs_COLON] = ACTIONS(299),
    [anon_sym_ATx_COLON] = ACTIONS(299),
    [anon_sym_PIPE_DOT] = ACTIONS(299),
    [anon_sym_DOLLAR] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(299),
    [sym_html_redirect_operator] = ACTIONS(301),
    [sym_html_append_operator] = ACTIONS(299),
    [anon_sym_COMMA] = ACTIONS(299),
    [aux_sym_arg_identifier_token1] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(299),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(299),
    [anon_sym_CR] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(299),
    [sym__concat] = ACTIONS(303),
  },
  [86] = {
    [aux_sym_concatenation_repeat1] = STATE(86),
    [ts_builtin_sym_end] = ACTIONS(305),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_TILDE] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(307),
    [anon_sym_PIPEH] = ACTIONS(305),
    [anon_sym_PIPET] = ACTIONS(305),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATi] = ACTIONS(305),
    [anon_sym_AT_AT_ATr] = ACTIONS(305),
    [anon_sym_AT_AT_ATs] = ACTIONS(307),
    [anon_sym_AT_AT_ATst] = ACTIONS(305),
    [anon_sym_AT_AT_ATS] = ACTIONS(305),
    [anon_sym_AT_AT_ATm] = ACTIONS(305),
    [anon_sym_AT_AT_ATM] = ACTIONS(305),
    [anon_sym_AT_AT_ATf] = ACTIONS(307),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATF] = ACTIONS(307),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_AT] = ACTIONS(307),
    [anon_sym_AT_ATdbt] = ACTIONS(307),
    [anon_sym_AT_ATdbta] = ACTIONS(305),
    [anon_sym_AT_ATdbtb] = ACTIONS(305),
    [anon_sym_AT_ATdbts] = ACTIONS(305),
    [anon_sym_AT_AT_DOT] = ACTIONS(305),
    [anon_sym_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_ATk] = ACTIONS(305),
    [anon_sym_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_ATi] = ACTIONS(307),
    [anon_sym_AT_ATiS] = ACTIONS(305),
    [anon_sym_AT_ATf] = ACTIONS(305),
    [anon_sym_AT_ATs_COLON] = ACTIONS(305),
    [anon_sym_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(307),
    [anon_sym_AT_BANG] = ACTIONS(305),
    [anon_sym_AT_LBRACE] = ACTIONS(305),
    [anon_sym_ATa_COLON] = ACTIONS(305),
    [anon_sym_ATb_COLON] = ACTIONS(305),
    [anon_sym_ATB_COLON] = ACTIONS(305),
    [anon_sym_ATe_COLON] = ACTIONS(305),
    [anon_sym_ATF_COLON] = ACTIONS(305),
    [anon_sym_ATi_COLON] = ACTIONS(305),
    [anon_sym_ATk_COLON] = ACTIONS(305),
    [anon_sym_ATo_COLON] = ACTIONS(305),
    [anon_sym_ATr_COLON] = ACTIONS(305),
    [anon_sym_ATf_COLON] = ACTIONS(305),
    [anon_sym_ATs_COLON] = ACTIONS(305),
    [anon_sym_ATx_COLON] = ACTIONS(305),
    [anon_sym_PIPE_DOT] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(305),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_SEMI] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(305),
    [sym_html_redirect_operator] = ACTIONS(307),
    [sym_html_append_operator] = ACTIONS(305),
    [anon_sym_COMMA] = ACTIONS(305),
    [aux_sym_arg_identifier_token1] = ACTIONS(307),
    [anon_sym_SQUOTE] = ACTIONS(305),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(305),
    [anon_sym_BQUOTE] = ACTIONS(305),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(305),
    [anon_sym_CR] = ACTIONS(305),
    [sym_file_descriptor] = ACTIONS(305),
    [sym__concat] = ACTIONS(309),
  },
  [87] = {
    [aux_sym_concatenation_repeat1] = STATE(86),
    [ts_builtin_sym_end] = ACTIONS(312),
    [anon_sym_DQUOTE] = ACTIONS(312),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(314),
    [anon_sym_PIPEH] = ACTIONS(312),
    [anon_sym_PIPET] = ACTIONS(312),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(312),
    [anon_sym_AT_AT_ATb] = ACTIONS(312),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATi] = ACTIONS(312),
    [anon_sym_AT_AT_ATr] = ACTIONS(312),
    [anon_sym_AT_AT_ATs] = ACTIONS(314),
    [anon_sym_AT_AT_ATst] = ACTIONS(312),
    [anon_sym_AT_AT_ATS] = ACTIONS(312),
    [anon_sym_AT_AT_ATm] = ACTIONS(312),
    [anon_sym_AT_AT_ATM] = ACTIONS(312),
    [anon_sym_AT_AT_ATf] = ACTIONS(314),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATF] = ACTIONS(314),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATt] = ACTIONS(312),
    [anon_sym_AT_AT] = ACTIONS(314),
    [anon_sym_AT_ATdbt] = ACTIONS(314),
    [anon_sym_AT_ATdbta] = ACTIONS(312),
    [anon_sym_AT_ATdbtb] = ACTIONS(312),
    [anon_sym_AT_ATdbts] = ACTIONS(312),
    [anon_sym_AT_AT_DOT] = ACTIONS(312),
    [anon_sym_AT_AT_EQ] = ACTIONS(312),
    [anon_sym_AT_ATk] = ACTIONS(312),
    [anon_sym_AT_ATt] = ACTIONS(312),
    [anon_sym_AT_ATb] = ACTIONS(312),
    [anon_sym_AT_ATi] = ACTIONS(314),
    [anon_sym_AT_ATiS] = ACTIONS(312),
    [anon_sym_AT_ATf] = ACTIONS(312),
    [anon_sym_AT_ATs_COLON] = ACTIONS(312),
    [anon_sym_AT_ATc_COLON] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_AT_BANG] = ACTIONS(312),
    [anon_sym_AT_LBRACE] = ACTIONS(312),
    [anon_sym_ATa_COLON] = ACTIONS(312),
    [anon_sym_ATb_COLON] = ACTIONS(312),
    [anon_sym_ATB_COLON] = ACTIONS(312),
    [anon_sym_ATe_COLON] = ACTIONS(312),
    [anon_sym_ATF_COLON] = ACTIONS(312),
    [anon_sym_ATi_COLON] = ACTIONS(312),
    [anon_sym_ATk_COLON] = ACTIONS(312),
    [anon_sym_ATo_COLON] = ACTIONS(312),
    [anon_sym_ATr_COLON] = ACTIONS(312),
    [anon_sym_ATf_COLON] = ACTIONS(312),
    [anon_sym_ATs_COLON] = ACTIONS(312),
    [anon_sym_ATx_COLON] = ACTIONS(312),
    [anon_sym_PIPE_DOT] = ACTIONS(312),
    [anon_sym_DOLLAR] = ACTIONS(314),
    [anon_sym_LPAREN] = ACTIONS(312),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_SEMI] = ACTIONS(312),
    [anon_sym_GT] = ACTIONS(314),
    [anon_sym_GT_GT] = ACTIONS(312),
    [sym_html_redirect_operator] = ACTIONS(314),
    [sym_html_append_operator] = ACTIONS(312),
    [anon_sym_COMMA] = ACTIONS(312),
    [aux_sym_arg_identifier_token1] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(312),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(312),
    [anon_sym_BQUOTE] = ACTIONS(312),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(312),
    [anon_sym_CR] = ACTIONS(312),
    [sym_file_descriptor] = ACTIONS(312),
    [sym__concat] = ACTIONS(303),
  },
  [88] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_DQUOTE] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(316),
    [aux_sym_arg_identifier_token1] = ACTIONS(318),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat] = ACTIONS(316),
  },
  [89] = {
    [ts_builtin_sym_end] = ACTIONS(320),
    [anon_sym_DQUOTE] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_PIPEH] = ACTIONS(320),
    [anon_sym_PIPET] = ACTIONS(320),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(320),
    [anon_sym_AT_AT_ATb] = ACTIONS(320),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATi] = ACTIONS(320),
    [anon_sym_AT_AT_ATr] = ACTIONS(320),
    [anon_sym_AT_AT_ATs] = ACTIONS(322),
    [anon_sym_AT_AT_ATst] = ACTIONS(320),
    [anon_sym_AT_AT_ATS] = ACTIONS(320),
    [anon_sym_AT_AT_ATm] = ACTIONS(320),
    [anon_sym_AT_AT_ATM] = ACTIONS(320),
    [anon_sym_AT_AT_ATf] = ACTIONS(322),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATF] = ACTIONS(322),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATt] = ACTIONS(320),
    [anon_sym_AT_AT] = ACTIONS(322),
    [anon_sym_AT_ATdbt] = ACTIONS(322),
    [anon_sym_AT_ATdbta] = ACTIONS(320),
    [anon_sym_AT_ATdbtb] = ACTIONS(320),
    [anon_sym_AT_ATdbts] = ACTIONS(320),
    [anon_sym_AT_AT_DOT] = ACTIONS(320),
    [anon_sym_AT_AT_EQ] = ACTIONS(320),
    [anon_sym_AT_ATk] = ACTIONS(320),
    [anon_sym_AT_ATt] = ACTIONS(320),
    [anon_sym_AT_ATb] = ACTIONS(320),
    [anon_sym_AT_ATi] = ACTIONS(322),
    [anon_sym_AT_ATiS] = ACTIONS(320),
    [anon_sym_AT_ATf] = ACTIONS(320),
    [anon_sym_AT_ATs_COLON] = ACTIONS(320),
    [anon_sym_AT_ATc_COLON] = ACTIONS(320),
    [anon_sym_AT] = ACTIONS(322),
    [anon_sym_AT_BANG] = ACTIONS(320),
    [anon_sym_AT_LBRACE] = ACTIONS(320),
    [anon_sym_ATa_COLON] = ACTIONS(320),
    [anon_sym_ATb_COLON] = ACTIONS(320),
    [anon_sym_ATB_COLON] = ACTIONS(320),
    [anon_sym_ATe_COLON] = ACTIONS(320),
    [anon_sym_ATF_COLON] = ACTIONS(320),
    [anon_sym_ATi_COLON] = ACTIONS(320),
    [anon_sym_ATk_COLON] = ACTIONS(320),
    [anon_sym_ATo_COLON] = ACTIONS(320),
    [anon_sym_ATr_COLON] = ACTIONS(320),
    [anon_sym_ATf_COLON] = ACTIONS(320),
    [anon_sym_ATs_COLON] = ACTIONS(320),
    [anon_sym_ATx_COLON] = ACTIONS(320),
    [anon_sym_PIPE_DOT] = ACTIONS(320),
    [anon_sym_DOLLAR] = ACTIONS(322),
    [anon_sym_LPAREN] = ACTIONS(320),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_SEMI] = ACTIONS(320),
    [anon_sym_GT] = ACTIONS(322),
    [anon_sym_GT_GT] = ACTIONS(320),
    [sym_html_redirect_operator] = ACTIONS(322),
    [sym_html_append_operator] = ACTIONS(320),
    [anon_sym_COMMA] = ACTIONS(320),
    [aux_sym_arg_identifier_token1] = ACTIONS(322),
    [anon_sym_SQUOTE] = ACTIONS(320),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(320),
    [anon_sym_BQUOTE] = ACTIONS(320),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(320),
    [anon_sym_CR] = ACTIONS(320),
    [sym_file_descriptor] = ACTIONS(320),
    [sym__concat] = ACTIONS(320),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(324),
    [anon_sym_DQUOTE] = ACTIONS(324),
    [anon_sym_TILDE] = ACTIONS(324),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_PIPEH] = ACTIONS(324),
    [anon_sym_PIPET] = ACTIONS(324),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(324),
    [anon_sym_AT_AT_ATb] = ACTIONS(324),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATi] = ACTIONS(324),
    [anon_sym_AT_AT_ATr] = ACTIONS(324),
    [anon_sym_AT_AT_ATs] = ACTIONS(326),
    [anon_sym_AT_AT_ATst] = ACTIONS(324),
    [anon_sym_AT_AT_ATS] = ACTIONS(324),
    [anon_sym_AT_AT_ATm] = ACTIONS(324),
    [anon_sym_AT_AT_ATM] = ACTIONS(324),
    [anon_sym_AT_AT_ATf] = ACTIONS(326),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATF] = ACTIONS(326),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATt] = ACTIONS(324),
    [anon_sym_AT_AT] = ACTIONS(326),
    [anon_sym_AT_ATdbt] = ACTIONS(326),
    [anon_sym_AT_ATdbta] = ACTIONS(324),
    [anon_sym_AT_ATdbtb] = ACTIONS(324),
    [anon_sym_AT_ATdbts] = ACTIONS(324),
    [anon_sym_AT_AT_DOT] = ACTIONS(324),
    [anon_sym_AT_AT_EQ] = ACTIONS(324),
    [anon_sym_AT_ATk] = ACTIONS(324),
    [anon_sym_AT_ATt] = ACTIONS(324),
    [anon_sym_AT_ATb] = ACTIONS(324),
    [anon_sym_AT_ATi] = ACTIONS(326),
    [anon_sym_AT_ATiS] = ACTIONS(324),
    [anon_sym_AT_ATf] = ACTIONS(324),
    [anon_sym_AT_ATs_COLON] = ACTIONS(324),
    [anon_sym_AT_ATc_COLON] = ACTIONS(324),
    [anon_sym_AT] = ACTIONS(326),
    [anon_sym_AT_BANG] = ACTIONS(324),
    [anon_sym_AT_LBRACE] = ACTIONS(324),
    [anon_sym_ATa_COLON] = ACTIONS(324),
    [anon_sym_ATb_COLON] = ACTIONS(324),
    [anon_sym_ATB_COLON] = ACTIONS(324),
    [anon_sym_ATe_COLON] = ACTIONS(324),
    [anon_sym_ATF_COLON] = ACTIONS(324),
    [anon_sym_ATi_COLON] = ACTIONS(324),
    [anon_sym_ATk_COLON] = ACTIONS(324),
    [anon_sym_ATo_COLON] = ACTIONS(324),
    [anon_sym_ATr_COLON] = ACTIONS(324),
    [anon_sym_ATf_COLON] = ACTIONS(324),
    [anon_sym_ATs_COLON] = ACTIONS(324),
    [anon_sym_ATx_COLON] = ACTIONS(324),
    [anon_sym_PIPE_DOT] = ACTIONS(324),
    [anon_sym_DOLLAR] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(324),
    [anon_sym_RPAREN] = ACTIONS(324),
    [anon_sym_SEMI] = ACTIONS(324),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_GT_GT] = ACTIONS(324),
    [sym_html_redirect_operator] = ACTIONS(326),
    [sym_html_append_operator] = ACTIONS(324),
    [anon_sym_COMMA] = ACTIONS(324),
    [aux_sym_arg_identifier_token1] = ACTIONS(326),
    [anon_sym_SQUOTE] = ACTIONS(324),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(324),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(324),
    [anon_sym_CR] = ACTIONS(324),
    [sym_file_descriptor] = ACTIONS(324),
    [sym__concat] = ACTIONS(324),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(305),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_TILDE] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(307),
    [anon_sym_PIPEH] = ACTIONS(305),
    [anon_sym_PIPET] = ACTIONS(305),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATi] = ACTIONS(305),
    [anon_sym_AT_AT_ATr] = ACTIONS(305),
    [anon_sym_AT_AT_ATs] = ACTIONS(307),
    [anon_sym_AT_AT_ATst] = ACTIONS(305),
    [anon_sym_AT_AT_ATS] = ACTIONS(305),
    [anon_sym_AT_AT_ATm] = ACTIONS(305),
    [anon_sym_AT_AT_ATM] = ACTIONS(305),
    [anon_sym_AT_AT_ATf] = ACTIONS(307),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATF] = ACTIONS(307),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_AT] = ACTIONS(307),
    [anon_sym_AT_ATdbt] = ACTIONS(307),
    [anon_sym_AT_ATdbta] = ACTIONS(305),
    [anon_sym_AT_ATdbtb] = ACTIONS(305),
    [anon_sym_AT_ATdbts] = ACTIONS(305),
    [anon_sym_AT_AT_DOT] = ACTIONS(305),
    [anon_sym_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_ATk] = ACTIONS(305),
    [anon_sym_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_ATi] = ACTIONS(307),
    [anon_sym_AT_ATiS] = ACTIONS(305),
    [anon_sym_AT_ATf] = ACTIONS(305),
    [anon_sym_AT_ATs_COLON] = ACTIONS(305),
    [anon_sym_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(307),
    [anon_sym_AT_BANG] = ACTIONS(305),
    [anon_sym_AT_LBRACE] = ACTIONS(305),
    [anon_sym_ATa_COLON] = ACTIONS(305),
    [anon_sym_ATb_COLON] = ACTIONS(305),
    [anon_sym_ATB_COLON] = ACTIONS(305),
    [anon_sym_ATe_COLON] = ACTIONS(305),
    [anon_sym_ATF_COLON] = ACTIONS(305),
    [anon_sym_ATi_COLON] = ACTIONS(305),
    [anon_sym_ATk_COLON] = ACTIONS(305),
    [anon_sym_ATo_COLON] = ACTIONS(305),
    [anon_sym_ATr_COLON] = ACTIONS(305),
    [anon_sym_ATf_COLON] = ACTIONS(305),
    [anon_sym_ATs_COLON] = ACTIONS(305),
    [anon_sym_ATx_COLON] = ACTIONS(305),
    [anon_sym_PIPE_DOT] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(305),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_SEMI] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(305),
    [sym_html_redirect_operator] = ACTIONS(307),
    [sym_html_append_operator] = ACTIONS(305),
    [anon_sym_COMMA] = ACTIONS(305),
    [aux_sym_arg_identifier_token1] = ACTIONS(307),
    [anon_sym_SQUOTE] = ACTIONS(305),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(305),
    [anon_sym_BQUOTE] = ACTIONS(305),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(305),
    [anon_sym_CR] = ACTIONS(305),
    [sym_file_descriptor] = ACTIONS(305),
    [sym__concat] = ACTIONS(305),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(328),
    [anon_sym_DQUOTE] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_PIPEH] = ACTIONS(328),
    [anon_sym_PIPET] = ACTIONS(328),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(328),
    [anon_sym_AT_AT_ATb] = ACTIONS(328),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATi] = ACTIONS(328),
    [anon_sym_AT_AT_ATr] = ACTIONS(328),
    [anon_sym_AT_AT_ATs] = ACTIONS(330),
    [anon_sym_AT_AT_ATst] = ACTIONS(328),
    [anon_sym_AT_AT_ATS] = ACTIONS(328),
    [anon_sym_AT_AT_ATm] = ACTIONS(328),
    [anon_sym_AT_AT_ATM] = ACTIONS(328),
    [anon_sym_AT_AT_ATf] = ACTIONS(330),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATF] = ACTIONS(330),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATt] = ACTIONS(328),
    [anon_sym_AT_AT] = ACTIONS(330),
    [anon_sym_AT_ATdbt] = ACTIONS(330),
    [anon_sym_AT_ATdbta] = ACTIONS(328),
    [anon_sym_AT_ATdbtb] = ACTIONS(328),
    [anon_sym_AT_ATdbts] = ACTIONS(328),
    [anon_sym_AT_AT_DOT] = ACTIONS(328),
    [anon_sym_AT_AT_EQ] = ACTIONS(328),
    [anon_sym_AT_ATk] = ACTIONS(328),
    [anon_sym_AT_ATt] = ACTIONS(328),
    [anon_sym_AT_ATb] = ACTIONS(328),
    [anon_sym_AT_ATi] = ACTIONS(330),
    [anon_sym_AT_ATiS] = ACTIONS(328),
    [anon_sym_AT_ATf] = ACTIONS(328),
    [anon_sym_AT_ATs_COLON] = ACTIONS(328),
    [anon_sym_AT_ATc_COLON] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(330),
    [anon_sym_AT_BANG] = ACTIONS(328),
    [anon_sym_AT_LBRACE] = ACTIONS(328),
    [anon_sym_ATa_COLON] = ACTIONS(328),
    [anon_sym_ATb_COLON] = ACTIONS(328),
    [anon_sym_ATB_COLON] = ACTIONS(328),
    [anon_sym_ATe_COLON] = ACTIONS(328),
    [anon_sym_ATF_COLON] = ACTIONS(328),
    [anon_sym_ATi_COLON] = ACTIONS(328),
    [anon_sym_ATk_COLON] = ACTIONS(328),
    [anon_sym_ATo_COLON] = ACTIONS(328),
    [anon_sym_ATr_COLON] = ACTIONS(328),
    [anon_sym_ATf_COLON] = ACTIONS(328),
    [anon_sym_ATs_COLON] = ACTIONS(328),
    [anon_sym_ATx_COLON] = ACTIONS(328),
    [anon_sym_PIPE_DOT] = ACTIONS(328),
    [anon_sym_DOLLAR] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_GT] = ACTIONS(330),
    [anon_sym_GT_GT] = ACTIONS(328),
    [sym_html_redirect_operator] = ACTIONS(330),
    [sym_html_append_operator] = ACTIONS(328),
    [anon_sym_COMMA] = ACTIONS(328),
    [aux_sym_arg_identifier_token1] = ACTIONS(330),
    [anon_sym_SQUOTE] = ACTIONS(328),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(328),
    [anon_sym_CR] = ACTIONS(328),
    [sym_file_descriptor] = ACTIONS(328),
    [sym__concat] = ACTIONS(328),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(332),
    [anon_sym_DQUOTE] = ACTIONS(332),
    [anon_sym_TILDE] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(334),
    [anon_sym_PIPEH] = ACTIONS(332),
    [anon_sym_PIPET] = ACTIONS(332),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(332),
    [anon_sym_AT_AT_ATb] = ACTIONS(332),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATi] = ACTIONS(332),
    [anon_sym_AT_AT_ATr] = ACTIONS(332),
    [anon_sym_AT_AT_ATs] = ACTIONS(334),
    [anon_sym_AT_AT_ATst] = ACTIONS(332),
    [anon_sym_AT_AT_ATS] = ACTIONS(332),
    [anon_sym_AT_AT_ATm] = ACTIONS(332),
    [anon_sym_AT_AT_ATM] = ACTIONS(332),
    [anon_sym_AT_AT_ATf] = ACTIONS(334),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATF] = ACTIONS(334),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATt] = ACTIONS(332),
    [anon_sym_AT_AT] = ACTIONS(334),
    [anon_sym_AT_ATdbt] = ACTIONS(334),
    [anon_sym_AT_ATdbta] = ACTIONS(332),
    [anon_sym_AT_ATdbtb] = ACTIONS(332),
    [anon_sym_AT_ATdbts] = ACTIONS(332),
    [anon_sym_AT_AT_DOT] = ACTIONS(332),
    [anon_sym_AT_AT_EQ] = ACTIONS(332),
    [anon_sym_AT_ATk] = ACTIONS(332),
    [anon_sym_AT_ATt] = ACTIONS(332),
    [anon_sym_AT_ATb] = ACTIONS(332),
    [anon_sym_AT_ATi] = ACTIONS(334),
    [anon_sym_AT_ATiS] = ACTIONS(332),
    [anon_sym_AT_ATf] = ACTIONS(332),
    [anon_sym_AT_ATs_COLON] = ACTIONS(332),
    [anon_sym_AT_ATc_COLON] = ACTIONS(332),
    [anon_sym_AT] = ACTIONS(334),
    [anon_sym_AT_BANG] = ACTIONS(332),
    [anon_sym_AT_LBRACE] = ACTIONS(332),
    [anon_sym_ATa_COLON] = ACTIONS(332),
    [anon_sym_ATb_COLON] = ACTIONS(332),
    [anon_sym_ATB_COLON] = ACTIONS(332),
    [anon_sym_ATe_COLON] = ACTIONS(332),
    [anon_sym_ATF_COLON] = ACTIONS(332),
    [anon_sym_ATi_COLON] = ACTIONS(332),
    [anon_sym_ATk_COLON] = ACTIONS(332),
    [anon_sym_ATo_COLON] = ACTIONS(332),
    [anon_sym_ATr_COLON] = ACTIONS(332),
    [anon_sym_ATf_COLON] = ACTIONS(332),
    [anon_sym_ATs_COLON] = ACTIONS(332),
    [anon_sym_ATx_COLON] = ACTIONS(332),
    [anon_sym_PIPE_DOT] = ACTIONS(332),
    [anon_sym_DOLLAR] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(332),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_SEMI] = ACTIONS(332),
    [anon_sym_GT] = ACTIONS(334),
    [anon_sym_GT_GT] = ACTIONS(332),
    [sym_html_redirect_operator] = ACTIONS(334),
    [sym_html_append_operator] = ACTIONS(332),
    [anon_sym_COMMA] = ACTIONS(332),
    [aux_sym_arg_identifier_token1] = ACTIONS(334),
    [anon_sym_SQUOTE] = ACTIONS(332),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(332),
    [anon_sym_BQUOTE] = ACTIONS(332),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(332),
    [anon_sym_CR] = ACTIONS(332),
    [sym_file_descriptor] = ACTIONS(332),
    [sym__concat] = ACTIONS(332),
  },
  [94] = {
    [ts_builtin_sym_end] = ACTIONS(336),
    [anon_sym_DQUOTE] = ACTIONS(336),
    [anon_sym_TILDE] = ACTIONS(336),
    [anon_sym_PIPE] = ACTIONS(338),
    [anon_sym_PIPEH] = ACTIONS(336),
    [anon_sym_PIPET] = ACTIONS(336),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(336),
    [anon_sym_AT_AT_ATb] = ACTIONS(336),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATi] = ACTIONS(336),
    [anon_sym_AT_AT_ATr] = ACTIONS(336),
    [anon_sym_AT_AT_ATs] = ACTIONS(338),
    [anon_sym_AT_AT_ATst] = ACTIONS(336),
    [anon_sym_AT_AT_ATS] = ACTIONS(336),
    [anon_sym_AT_AT_ATm] = ACTIONS(336),
    [anon_sym_AT_AT_ATM] = ACTIONS(336),
    [anon_sym_AT_AT_ATf] = ACTIONS(338),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATF] = ACTIONS(338),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATt] = ACTIONS(336),
    [anon_sym_AT_AT] = ACTIONS(338),
    [anon_sym_AT_ATdbt] = ACTIONS(338),
    [anon_sym_AT_ATdbta] = ACTIONS(336),
    [anon_sym_AT_ATdbtb] = ACTIONS(336),
    [anon_sym_AT_ATdbts] = ACTIONS(336),
    [anon_sym_AT_AT_DOT] = ACTIONS(336),
    [anon_sym_AT_AT_EQ] = ACTIONS(336),
    [anon_sym_AT_ATk] = ACTIONS(336),
    [anon_sym_AT_ATt] = ACTIONS(336),
    [anon_sym_AT_ATb] = ACTIONS(336),
    [anon_sym_AT_ATi] = ACTIONS(338),
    [anon_sym_AT_ATiS] = ACTIONS(336),
    [anon_sym_AT_ATf] = ACTIONS(336),
    [anon_sym_AT_ATs_COLON] = ACTIONS(336),
    [anon_sym_AT_ATc_COLON] = ACTIONS(336),
    [anon_sym_AT] = ACTIONS(338),
    [anon_sym_AT_BANG] = ACTIONS(336),
    [anon_sym_AT_LBRACE] = ACTIONS(336),
    [anon_sym_ATa_COLON] = ACTIONS(336),
    [anon_sym_ATb_COLON] = ACTIONS(336),
    [anon_sym_ATB_COLON] = ACTIONS(336),
    [anon_sym_ATe_COLON] = ACTIONS(336),
    [anon_sym_ATF_COLON] = ACTIONS(336),
    [anon_sym_ATi_COLON] = ACTIONS(336),
    [anon_sym_ATk_COLON] = ACTIONS(336),
    [anon_sym_ATo_COLON] = ACTIONS(336),
    [anon_sym_ATr_COLON] = ACTIONS(336),
    [anon_sym_ATf_COLON] = ACTIONS(336),
    [anon_sym_ATs_COLON] = ACTIONS(336),
    [anon_sym_ATx_COLON] = ACTIONS(336),
    [anon_sym_PIPE_DOT] = ACTIONS(336),
    [anon_sym_DOLLAR] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(336),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_SEMI] = ACTIONS(336),
    [anon_sym_GT] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(336),
    [sym_html_redirect_operator] = ACTIONS(338),
    [sym_html_append_operator] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(336),
    [aux_sym_arg_identifier_token1] = ACTIONS(338),
    [anon_sym_SQUOTE] = ACTIONS(336),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(336),
    [anon_sym_BQUOTE] = ACTIONS(336),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(336),
    [anon_sym_CR] = ACTIONS(336),
    [sym_file_descriptor] = ACTIONS(336),
    [sym__concat] = ACTIONS(336),
  },
  [95] = {
    [ts_builtin_sym_end] = ACTIONS(340),
    [anon_sym_DQUOTE] = ACTIONS(340),
    [anon_sym_TILDE] = ACTIONS(340),
    [anon_sym_PIPE] = ACTIONS(342),
    [anon_sym_PIPEH] = ACTIONS(340),
    [anon_sym_PIPET] = ACTIONS(340),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(340),
    [anon_sym_AT_AT_ATb] = ACTIONS(340),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATi] = ACTIONS(340),
    [anon_sym_AT_AT_ATr] = ACTIONS(340),
    [anon_sym_AT_AT_ATs] = ACTIONS(342),
    [anon_sym_AT_AT_ATst] = ACTIONS(340),
    [anon_sym_AT_AT_ATS] = ACTIONS(340),
    [anon_sym_AT_AT_ATm] = ACTIONS(340),
    [anon_sym_AT_AT_ATM] = ACTIONS(340),
    [anon_sym_AT_AT_ATf] = ACTIONS(342),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATF] = ACTIONS(342),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATt] = ACTIONS(340),
    [anon_sym_AT_AT] = ACTIONS(342),
    [anon_sym_AT_ATdbt] = ACTIONS(342),
    [anon_sym_AT_ATdbta] = ACTIONS(340),
    [anon_sym_AT_ATdbtb] = ACTIONS(340),
    [anon_sym_AT_ATdbts] = ACTIONS(340),
    [anon_sym_AT_AT_DOT] = ACTIONS(340),
    [anon_sym_AT_AT_EQ] = ACTIONS(340),
    [anon_sym_AT_ATk] = ACTIONS(340),
    [anon_sym_AT_ATt] = ACTIONS(340),
    [anon_sym_AT_ATb] = ACTIONS(340),
    [anon_sym_AT_ATi] = ACTIONS(342),
    [anon_sym_AT_ATiS] = ACTIONS(340),
    [anon_sym_AT_ATf] = ACTIONS(340),
    [anon_sym_AT_ATs_COLON] = ACTIONS(340),
    [anon_sym_AT_ATc_COLON] = ACTIONS(340),
    [anon_sym_AT] = ACTIONS(342),
    [anon_sym_AT_BANG] = ACTIONS(340),
    [anon_sym_AT_LBRACE] = ACTIONS(340),
    [anon_sym_ATa_COLON] = ACTIONS(340),
    [anon_sym_ATb_COLON] = ACTIONS(340),
    [anon_sym_ATB_COLON] = ACTIONS(340),
    [anon_sym_ATe_COLON] = ACTIONS(340),
    [anon_sym_ATF_COLON] = ACTIONS(340),
    [anon_sym_ATi_COLON] = ACTIONS(340),
    [anon_sym_ATk_COLON] = ACTIONS(340),
    [anon_sym_ATo_COLON] = ACTIONS(340),
    [anon_sym_ATr_COLON] = ACTIONS(340),
    [anon_sym_ATf_COLON] = ACTIONS(340),
    [anon_sym_ATs_COLON] = ACTIONS(340),
    [anon_sym_ATx_COLON] = ACTIONS(340),
    [anon_sym_PIPE_DOT] = ACTIONS(340),
    [anon_sym_DOLLAR] = ACTIONS(342),
    [anon_sym_LPAREN] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(340),
    [anon_sym_SEMI] = ACTIONS(340),
    [anon_sym_GT] = ACTIONS(342),
    [anon_sym_GT_GT] = ACTIONS(340),
    [sym_html_redirect_operator] = ACTIONS(342),
    [sym_html_append_operator] = ACTIONS(340),
    [anon_sym_COMMA] = ACTIONS(340),
    [aux_sym_arg_identifier_token1] = ACTIONS(342),
    [anon_sym_SQUOTE] = ACTIONS(340),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(340),
    [anon_sym_BQUOTE] = ACTIONS(340),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(340),
    [anon_sym_CR] = ACTIONS(340),
    [sym_file_descriptor] = ACTIONS(340),
    [sym__concat] = ACTIONS(340),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(344),
    [anon_sym_DQUOTE] = ACTIONS(344),
    [anon_sym_TILDE] = ACTIONS(344),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PIPEH] = ACTIONS(344),
    [anon_sym_PIPET] = ACTIONS(344),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(344),
    [anon_sym_AT_AT_ATb] = ACTIONS(344),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATi] = ACTIONS(344),
    [anon_sym_AT_AT_ATr] = ACTIONS(344),
    [anon_sym_AT_AT_ATs] = ACTIONS(346),
    [anon_sym_AT_AT_ATst] = ACTIONS(344),
    [anon_sym_AT_AT_ATS] = ACTIONS(344),
    [anon_sym_AT_AT_ATm] = ACTIONS(344),
    [anon_sym_AT_AT_ATM] = ACTIONS(344),
    [anon_sym_AT_AT_ATf] = ACTIONS(346),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATF] = ACTIONS(346),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATt] = ACTIONS(344),
    [anon_sym_AT_AT] = ACTIONS(346),
    [anon_sym_AT_ATdbt] = ACTIONS(346),
    [anon_sym_AT_ATdbta] = ACTIONS(344),
    [anon_sym_AT_ATdbtb] = ACTIONS(344),
    [anon_sym_AT_ATdbts] = ACTIONS(344),
    [anon_sym_AT_AT_DOT] = ACTIONS(344),
    [anon_sym_AT_AT_EQ] = ACTIONS(344),
    [anon_sym_AT_ATk] = ACTIONS(344),
    [anon_sym_AT_ATt] = ACTIONS(344),
    [anon_sym_AT_ATb] = ACTIONS(344),
    [anon_sym_AT_ATi] = ACTIONS(346),
    [anon_sym_AT_ATiS] = ACTIONS(344),
    [anon_sym_AT_ATf] = ACTIONS(344),
    [anon_sym_AT_ATs_COLON] = ACTIONS(344),
    [anon_sym_AT_ATc_COLON] = ACTIONS(344),
    [anon_sym_AT] = ACTIONS(346),
    [anon_sym_AT_BANG] = ACTIONS(344),
    [anon_sym_AT_LBRACE] = ACTIONS(344),
    [anon_sym_ATa_COLON] = ACTIONS(344),
    [anon_sym_ATb_COLON] = ACTIONS(344),
    [anon_sym_ATB_COLON] = ACTIONS(344),
    [anon_sym_ATe_COLON] = ACTIONS(344),
    [anon_sym_ATF_COLON] = ACTIONS(344),
    [anon_sym_ATi_COLON] = ACTIONS(344),
    [anon_sym_ATk_COLON] = ACTIONS(344),
    [anon_sym_ATo_COLON] = ACTIONS(344),
    [anon_sym_ATr_COLON] = ACTIONS(344),
    [anon_sym_ATf_COLON] = ACTIONS(344),
    [anon_sym_ATs_COLON] = ACTIONS(344),
    [anon_sym_ATx_COLON] = ACTIONS(344),
    [anon_sym_PIPE_DOT] = ACTIONS(344),
    [anon_sym_DOLLAR] = ACTIONS(346),
    [anon_sym_LPAREN] = ACTIONS(344),
    [anon_sym_RPAREN] = ACTIONS(344),
    [anon_sym_SEMI] = ACTIONS(344),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_GT_GT] = ACTIONS(344),
    [sym_html_redirect_operator] = ACTIONS(346),
    [sym_html_append_operator] = ACTIONS(344),
    [anon_sym_COMMA] = ACTIONS(344),
    [aux_sym_arg_identifier_token1] = ACTIONS(346),
    [anon_sym_SQUOTE] = ACTIONS(344),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(344),
    [anon_sym_BQUOTE] = ACTIONS(344),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(344),
    [anon_sym_CR] = ACTIONS(344),
    [sym_file_descriptor] = ACTIONS(344),
    [sym__concat] = ACTIONS(344),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_DQUOTE] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(316),
    [aux_sym_arg_identifier_token1] = ACTIONS(318),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat] = ACTIONS(316),
  },
  [98] = {
    [sym__pf_arg_parentheses] = STATE(109),
    [sym_pf_arg_identifier] = STATE(109),
    [sym__pf_arg] = STATE(109),
    [sym_pf_concatenation] = STATE(121),
    [sym_pf_arg] = STATE(81),
    [sym_cmd_substitution_arg] = STATE(109),
    [aux_sym_pf_args_repeat1] = STATE(81),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_PIPEH] = ACTIONS(265),
    [anon_sym_PIPET] = ACTIONS(265),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(265),
    [anon_sym_AT_AT_ATb] = ACTIONS(265),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATi] = ACTIONS(265),
    [anon_sym_AT_AT_ATr] = ACTIONS(265),
    [anon_sym_AT_AT_ATs] = ACTIONS(267),
    [anon_sym_AT_AT_ATst] = ACTIONS(265),
    [anon_sym_AT_AT_ATS] = ACTIONS(265),
    [anon_sym_AT_AT_ATm] = ACTIONS(265),
    [anon_sym_AT_AT_ATM] = ACTIONS(265),
    [anon_sym_AT_AT_ATf] = ACTIONS(267),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATF] = ACTIONS(267),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(265),
    [anon_sym_AT_AT_ATt] = ACTIONS(265),
    [anon_sym_AT_AT] = ACTIONS(267),
    [anon_sym_AT_ATdbt] = ACTIONS(267),
    [anon_sym_AT_ATdbta] = ACTIONS(265),
    [anon_sym_AT_ATdbtb] = ACTIONS(265),
    [anon_sym_AT_ATdbts] = ACTIONS(265),
    [anon_sym_AT_AT_DOT] = ACTIONS(265),
    [anon_sym_AT_AT_EQ] = ACTIONS(265),
    [anon_sym_AT_ATk] = ACTIONS(265),
    [anon_sym_AT_ATt] = ACTIONS(265),
    [anon_sym_AT_ATb] = ACTIONS(265),
    [anon_sym_AT_ATi] = ACTIONS(267),
    [anon_sym_AT_ATiS] = ACTIONS(265),
    [anon_sym_AT_ATf] = ACTIONS(265),
    [anon_sym_AT_ATs_COLON] = ACTIONS(265),
    [anon_sym_AT_ATc_COLON] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_AT_BANG] = ACTIONS(265),
    [anon_sym_AT_LBRACE] = ACTIONS(265),
    [anon_sym_ATa_COLON] = ACTIONS(265),
    [anon_sym_ATb_COLON] = ACTIONS(265),
    [anon_sym_ATB_COLON] = ACTIONS(265),
    [anon_sym_ATe_COLON] = ACTIONS(265),
    [anon_sym_ATF_COLON] = ACTIONS(265),
    [anon_sym_ATi_COLON] = ACTIONS(265),
    [anon_sym_ATk_COLON] = ACTIONS(265),
    [anon_sym_ATo_COLON] = ACTIONS(265),
    [anon_sym_ATr_COLON] = ACTIONS(265),
    [anon_sym_ATf_COLON] = ACTIONS(265),
    [anon_sym_ATs_COLON] = ACTIONS(265),
    [anon_sym_ATx_COLON] = ACTIONS(265),
    [anon_sym_PIPE_DOT] = ACTIONS(265),
    [anon_sym_DOLLAR] = ACTIONS(255),
    [anon_sym_LPAREN] = ACTIONS(257),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(255),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_GT_GT] = ACTIONS(265),
    [sym_html_redirect_operator] = ACTIONS(267),
    [sym_html_append_operator] = ACTIONS(265),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(259),
    [anon_sym_BQUOTE] = ACTIONS(265),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(265),
  },
  [99] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(101),
    [ts_builtin_sym_end] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_PIPE] = ACTIONS(350),
    [anon_sym_PIPEH] = ACTIONS(348),
    [anon_sym_PIPET] = ACTIONS(348),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_AT_ATr] = ACTIONS(348),
    [anon_sym_AT_AT_ATs] = ACTIONS(350),
    [anon_sym_AT_AT_ATst] = ACTIONS(348),
    [anon_sym_AT_AT_ATS] = ACTIONS(348),
    [anon_sym_AT_AT_ATm] = ACTIONS(348),
    [anon_sym_AT_AT_ATM] = ACTIONS(348),
    [anon_sym_AT_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATF] = ACTIONS(350),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_AT] = ACTIONS(350),
    [anon_sym_AT_ATdbt] = ACTIONS(350),
    [anon_sym_AT_ATdbta] = ACTIONS(348),
    [anon_sym_AT_ATdbtb] = ACTIONS(348),
    [anon_sym_AT_ATdbts] = ACTIONS(348),
    [anon_sym_AT_AT_DOT] = ACTIONS(348),
    [anon_sym_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_ATk] = ACTIONS(348),
    [anon_sym_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_ATiS] = ACTIONS(348),
    [anon_sym_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_ATs_COLON] = ACTIONS(348),
    [anon_sym_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT] = ACTIONS(350),
    [anon_sym_AT_BANG] = ACTIONS(348),
    [anon_sym_AT_LBRACE] = ACTIONS(348),
    [anon_sym_ATa_COLON] = ACTIONS(348),
    [anon_sym_ATb_COLON] = ACTIONS(348),
    [anon_sym_ATB_COLON] = ACTIONS(348),
    [anon_sym_ATe_COLON] = ACTIONS(348),
    [anon_sym_ATF_COLON] = ACTIONS(348),
    [anon_sym_ATi_COLON] = ACTIONS(348),
    [anon_sym_ATk_COLON] = ACTIONS(348),
    [anon_sym_ATo_COLON] = ACTIONS(348),
    [anon_sym_ATr_COLON] = ACTIONS(348),
    [anon_sym_ATf_COLON] = ACTIONS(348),
    [anon_sym_ATs_COLON] = ACTIONS(348),
    [anon_sym_ATx_COLON] = ACTIONS(348),
    [anon_sym_PIPE_DOT] = ACTIONS(348),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_DOLLAR] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(348),
    [anon_sym_RPAREN] = ACTIONS(348),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(348),
    [anon_sym_GT] = ACTIONS(350),
    [anon_sym_GT_GT] = ACTIONS(348),
    [sym_html_redirect_operator] = ACTIONS(350),
    [sym_html_append_operator] = ACTIONS(348),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(348),
    [anon_sym_BQUOTE] = ACTIONS(348),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(348),
    [anon_sym_CR] = ACTIONS(348),
    [sym_file_descriptor] = ACTIONS(348),
    [sym__concat_pf_dot] = ACTIONS(348),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_TILDE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_PIPEH] = ACTIONS(299),
    [anon_sym_PIPET] = ACTIONS(299),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATi] = ACTIONS(299),
    [anon_sym_AT_AT_ATr] = ACTIONS(299),
    [anon_sym_AT_AT_ATs] = ACTIONS(301),
    [anon_sym_AT_AT_ATst] = ACTIONS(299),
    [anon_sym_AT_AT_ATS] = ACTIONS(299),
    [anon_sym_AT_AT_ATm] = ACTIONS(299),
    [anon_sym_AT_AT_ATM] = ACTIONS(299),
    [anon_sym_AT_AT_ATf] = ACTIONS(301),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATF] = ACTIONS(301),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_AT] = ACTIONS(301),
    [anon_sym_AT_ATdbt] = ACTIONS(301),
    [anon_sym_AT_ATdbta] = ACTIONS(299),
    [anon_sym_AT_ATdbtb] = ACTIONS(299),
    [anon_sym_AT_ATdbts] = ACTIONS(299),
    [anon_sym_AT_AT_DOT] = ACTIONS(299),
    [anon_sym_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_ATk] = ACTIONS(299),
    [anon_sym_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_ATi] = ACTIONS(301),
    [anon_sym_AT_ATiS] = ACTIONS(299),
    [anon_sym_AT_ATf] = ACTIONS(299),
    [anon_sym_AT_ATs_COLON] = ACTIONS(299),
    [anon_sym_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_AT_BANG] = ACTIONS(299),
    [anon_sym_AT_LBRACE] = ACTIONS(299),
    [anon_sym_ATa_COLON] = ACTIONS(299),
    [anon_sym_ATb_COLON] = ACTIONS(299),
    [anon_sym_ATB_COLON] = ACTIONS(299),
    [anon_sym_ATe_COLON] = ACTIONS(299),
    [anon_sym_ATF_COLON] = ACTIONS(299),
    [anon_sym_ATi_COLON] = ACTIONS(299),
    [anon_sym_ATk_COLON] = ACTIONS(299),
    [anon_sym_ATo_COLON] = ACTIONS(299),
    [anon_sym_ATr_COLON] = ACTIONS(299),
    [anon_sym_ATf_COLON] = ACTIONS(299),
    [anon_sym_ATs_COLON] = ACTIONS(299),
    [anon_sym_ATx_COLON] = ACTIONS(299),
    [anon_sym_PIPE_DOT] = ACTIONS(299),
    [anon_sym_DOLLAR] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(299),
    [sym_html_redirect_operator] = ACTIONS(301),
    [sym_html_append_operator] = ACTIONS(299),
    [anon_sym_COMMA] = ACTIONS(299),
    [aux_sym_arg_identifier_token1] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(299),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(299),
    [anon_sym_CR] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(299),
  },
  [101] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(102),
    [ts_builtin_sym_end] = ACTIONS(352),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_PIPE] = ACTIONS(354),
    [anon_sym_PIPEH] = ACTIONS(352),
    [anon_sym_PIPET] = ACTIONS(352),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_AT_ATr] = ACTIONS(352),
    [anon_sym_AT_AT_ATs] = ACTIONS(354),
    [anon_sym_AT_AT_ATst] = ACTIONS(352),
    [anon_sym_AT_AT_ATS] = ACTIONS(352),
    [anon_sym_AT_AT_ATm] = ACTIONS(352),
    [anon_sym_AT_AT_ATM] = ACTIONS(352),
    [anon_sym_AT_AT_ATf] = ACTIONS(354),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATF] = ACTIONS(354),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_AT] = ACTIONS(354),
    [anon_sym_AT_ATdbt] = ACTIONS(354),
    [anon_sym_AT_ATdbta] = ACTIONS(352),
    [anon_sym_AT_ATdbtb] = ACTIONS(352),
    [anon_sym_AT_ATdbts] = ACTIONS(352),
    [anon_sym_AT_AT_DOT] = ACTIONS(352),
    [anon_sym_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_ATk] = ACTIONS(352),
    [anon_sym_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_ATi] = ACTIONS(354),
    [anon_sym_AT_ATiS] = ACTIONS(352),
    [anon_sym_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_ATs_COLON] = ACTIONS(352),
    [anon_sym_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(354),
    [anon_sym_AT_BANG] = ACTIONS(352),
    [anon_sym_AT_LBRACE] = ACTIONS(352),
    [anon_sym_ATa_COLON] = ACTIONS(352),
    [anon_sym_ATb_COLON] = ACTIONS(352),
    [anon_sym_ATB_COLON] = ACTIONS(352),
    [anon_sym_ATe_COLON] = ACTIONS(352),
    [anon_sym_ATF_COLON] = ACTIONS(352),
    [anon_sym_ATi_COLON] = ACTIONS(352),
    [anon_sym_ATk_COLON] = ACTIONS(352),
    [anon_sym_ATo_COLON] = ACTIONS(352),
    [anon_sym_ATr_COLON] = ACTIONS(352),
    [anon_sym_ATf_COLON] = ACTIONS(352),
    [anon_sym_ATs_COLON] = ACTIONS(352),
    [anon_sym_ATx_COLON] = ACTIONS(352),
    [anon_sym_PIPE_DOT] = ACTIONS(352),
    [anon_sym_EQ] = ACTIONS(354),
    [anon_sym_DOLLAR] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(352),
    [anon_sym_RPAREN] = ACTIONS(352),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(354),
    [anon_sym_SEMI] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(354),
    [anon_sym_GT_GT] = ACTIONS(352),
    [sym_html_redirect_operator] = ACTIONS(354),
    [sym_html_append_operator] = ACTIONS(352),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(352),
    [anon_sym_BQUOTE] = ACTIONS(352),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(352),
    [anon_sym_CR] = ACTIONS(352),
    [sym_file_descriptor] = ACTIONS(352),
    [sym__concat_pf_dot] = ACTIONS(356),
  },
  [102] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(102),
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(360),
    [anon_sym_DOLLAR] = ACTIONS(360),
    [anon_sym_LPAREN] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(362),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(365),
    [anon_sym_DQUOTE] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(365),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_PIPEH] = ACTIONS(365),
    [anon_sym_PIPET] = ACTIONS(365),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(365),
    [anon_sym_AT_AT_ATb] = ACTIONS(365),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(365),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(365),
    [anon_sym_AT_AT_ATi] = ACTIONS(365),
    [anon_sym_AT_AT_ATr] = ACTIONS(365),
    [anon_sym_AT_AT_ATs] = ACTIONS(367),
    [anon_sym_AT_AT_ATst] = ACTIONS(365),
    [anon_sym_AT_AT_ATS] = ACTIONS(365),
    [anon_sym_AT_AT_ATm] = ACTIONS(365),
    [anon_sym_AT_AT_ATM] = ACTIONS(365),
    [anon_sym_AT_AT_ATf] = ACTIONS(367),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(365),
    [anon_sym_AT_AT_ATF] = ACTIONS(367),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(365),
    [anon_sym_AT_AT_ATt] = ACTIONS(365),
    [anon_sym_AT_AT] = ACTIONS(367),
    [anon_sym_AT_ATdbt] = ACTIONS(367),
    [anon_sym_AT_ATdbta] = ACTIONS(365),
    [anon_sym_AT_ATdbtb] = ACTIONS(365),
    [anon_sym_AT_ATdbts] = ACTIONS(365),
    [anon_sym_AT_AT_DOT] = ACTIONS(365),
    [anon_sym_AT_AT_EQ] = ACTIONS(365),
    [anon_sym_AT_ATk] = ACTIONS(365),
    [anon_sym_AT_ATt] = ACTIONS(365),
    [anon_sym_AT_ATb] = ACTIONS(365),
    [anon_sym_AT_ATi] = ACTIONS(367),
    [anon_sym_AT_ATiS] = ACTIONS(365),
    [anon_sym_AT_ATf] = ACTIONS(365),
    [anon_sym_AT_ATs_COLON] = ACTIONS(365),
    [anon_sym_AT_ATc_COLON] = ACTIONS(365),
    [anon_sym_AT] = ACTIONS(367),
    [anon_sym_AT_BANG] = ACTIONS(365),
    [anon_sym_AT_LBRACE] = ACTIONS(365),
    [anon_sym_ATa_COLON] = ACTIONS(365),
    [anon_sym_ATb_COLON] = ACTIONS(365),
    [anon_sym_ATB_COLON] = ACTIONS(365),
    [anon_sym_ATe_COLON] = ACTIONS(365),
    [anon_sym_ATF_COLON] = ACTIONS(365),
    [anon_sym_ATi_COLON] = ACTIONS(365),
    [anon_sym_ATk_COLON] = ACTIONS(365),
    [anon_sym_ATo_COLON] = ACTIONS(365),
    [anon_sym_ATr_COLON] = ACTIONS(365),
    [anon_sym_ATf_COLON] = ACTIONS(365),
    [anon_sym_ATs_COLON] = ACTIONS(365),
    [anon_sym_ATx_COLON] = ACTIONS(365),
    [anon_sym_PIPE_DOT] = ACTIONS(365),
    [anon_sym_DOLLAR] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(365),
    [anon_sym_RPAREN] = ACTIONS(365),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_GT] = ACTIONS(367),
    [anon_sym_GT_GT] = ACTIONS(365),
    [sym_html_redirect_operator] = ACTIONS(367),
    [sym_html_append_operator] = ACTIONS(365),
    [anon_sym_COMMA] = ACTIONS(365),
    [aux_sym_arg_identifier_token1] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(365),
    [anon_sym_CR] = ACTIONS(365),
    [sym_file_descriptor] = ACTIONS(365),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(175),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_PIPE] = ACTIONS(180),
    [anon_sym_PIPEH] = ACTIONS(175),
    [anon_sym_PIPET] = ACTIONS(175),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(175),
    [anon_sym_AT_AT_ATb] = ACTIONS(175),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATi] = ACTIONS(175),
    [anon_sym_AT_AT_ATr] = ACTIONS(175),
    [anon_sym_AT_AT_ATs] = ACTIONS(180),
    [anon_sym_AT_AT_ATst] = ACTIONS(175),
    [anon_sym_AT_AT_ATS] = ACTIONS(175),
    [anon_sym_AT_AT_ATm] = ACTIONS(175),
    [anon_sym_AT_AT_ATM] = ACTIONS(175),
    [anon_sym_AT_AT_ATf] = ACTIONS(180),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATF] = ACTIONS(180),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(175),
    [anon_sym_AT_AT_ATt] = ACTIONS(175),
    [anon_sym_AT_AT] = ACTIONS(180),
    [anon_sym_AT_ATdbt] = ACTIONS(180),
    [anon_sym_AT_ATdbta] = ACTIONS(175),
    [anon_sym_AT_ATdbtb] = ACTIONS(175),
    [anon_sym_AT_ATdbts] = ACTIONS(175),
    [anon_sym_AT_AT_DOT] = ACTIONS(175),
    [anon_sym_AT_AT_EQ] = ACTIONS(175),
    [anon_sym_AT_ATk] = ACTIONS(175),
    [anon_sym_AT_ATt] = ACTIONS(175),
    [anon_sym_AT_ATb] = ACTIONS(175),
    [anon_sym_AT_ATi] = ACTIONS(180),
    [anon_sym_AT_ATiS] = ACTIONS(175),
    [anon_sym_AT_ATf] = ACTIONS(175),
    [anon_sym_AT_ATs_COLON] = ACTIONS(175),
    [anon_sym_AT_ATc_COLON] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(180),
    [anon_sym_AT_BANG] = ACTIONS(175),
    [anon_sym_AT_LBRACE] = ACTIONS(175),
    [anon_sym_ATa_COLON] = ACTIONS(175),
    [anon_sym_ATb_COLON] = ACTIONS(175),
    [anon_sym_ATB_COLON] = ACTIONS(175),
    [anon_sym_ATe_COLON] = ACTIONS(175),
    [anon_sym_ATF_COLON] = ACTIONS(175),
    [anon_sym_ATi_COLON] = ACTIONS(175),
    [anon_sym_ATk_COLON] = ACTIONS(175),
    [anon_sym_ATo_COLON] = ACTIONS(175),
    [anon_sym_ATr_COLON] = ACTIONS(175),
    [anon_sym_ATf_COLON] = ACTIONS(175),
    [anon_sym_ATs_COLON] = ACTIONS(175),
    [anon_sym_ATx_COLON] = ACTIONS(175),
    [anon_sym_PIPE_DOT] = ACTIONS(175),
    [anon_sym_DOLLAR] = ACTIONS(180),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_RPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(180),
    [anon_sym_GT_GT] = ACTIONS(175),
    [sym_html_redirect_operator] = ACTIONS(180),
    [sym_html_append_operator] = ACTIONS(175),
    [anon_sym_COMMA] = ACTIONS(175),
    [aux_sym_arg_identifier_token1] = ACTIONS(180),
    [anon_sym_SQUOTE] = ACTIONS(175),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(175),
    [anon_sym_BQUOTE] = ACTIONS(175),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(175),
    [anon_sym_CR] = ACTIONS(175),
    [sym_file_descriptor] = ACTIONS(175),
  },
  [105] = {
    [ts_builtin_sym_end] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_PIPE] = ACTIONS(350),
    [anon_sym_PIPEH] = ACTIONS(348),
    [anon_sym_PIPET] = ACTIONS(348),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_AT_ATr] = ACTIONS(348),
    [anon_sym_AT_AT_ATs] = ACTIONS(350),
    [anon_sym_AT_AT_ATst] = ACTIONS(348),
    [anon_sym_AT_AT_ATS] = ACTIONS(348),
    [anon_sym_AT_AT_ATm] = ACTIONS(348),
    [anon_sym_AT_AT_ATM] = ACTIONS(348),
    [anon_sym_AT_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATF] = ACTIONS(350),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_AT] = ACTIONS(350),
    [anon_sym_AT_ATdbt] = ACTIONS(350),
    [anon_sym_AT_ATdbta] = ACTIONS(348),
    [anon_sym_AT_ATdbtb] = ACTIONS(348),
    [anon_sym_AT_ATdbts] = ACTIONS(348),
    [anon_sym_AT_AT_DOT] = ACTIONS(348),
    [anon_sym_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_ATk] = ACTIONS(348),
    [anon_sym_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_ATiS] = ACTIONS(348),
    [anon_sym_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_ATs_COLON] = ACTIONS(348),
    [anon_sym_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT] = ACTIONS(350),
    [anon_sym_AT_BANG] = ACTIONS(348),
    [anon_sym_AT_LBRACE] = ACTIONS(348),
    [anon_sym_ATa_COLON] = ACTIONS(348),
    [anon_sym_ATb_COLON] = ACTIONS(348),
    [anon_sym_ATB_COLON] = ACTIONS(348),
    [anon_sym_ATe_COLON] = ACTIONS(348),
    [anon_sym_ATF_COLON] = ACTIONS(348),
    [anon_sym_ATi_COLON] = ACTIONS(348),
    [anon_sym_ATk_COLON] = ACTIONS(348),
    [anon_sym_ATo_COLON] = ACTIONS(348),
    [anon_sym_ATr_COLON] = ACTIONS(348),
    [anon_sym_ATf_COLON] = ACTIONS(348),
    [anon_sym_ATs_COLON] = ACTIONS(348),
    [anon_sym_ATx_COLON] = ACTIONS(348),
    [anon_sym_PIPE_DOT] = ACTIONS(348),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_DOLLAR] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(348),
    [anon_sym_RPAREN] = ACTIONS(348),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(348),
    [anon_sym_GT] = ACTIONS(350),
    [anon_sym_GT_GT] = ACTIONS(348),
    [sym_html_redirect_operator] = ACTIONS(350),
    [sym_html_append_operator] = ACTIONS(348),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(348),
    [anon_sym_BQUOTE] = ACTIONS(348),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(348),
    [anon_sym_CR] = ACTIONS(348),
    [sym_file_descriptor] = ACTIONS(348),
    [sym__concat_pf_dot] = ACTIONS(348),
  },
  [106] = {
    [sym_eq_sep_args] = STATE(219),
    [sym__eq_sep_key_single] = STATE(129),
    [sym_eq_sep_key] = STATE(177),
    [sym_double_quoted_arg] = STATE(167),
    [sym_single_quoted_arg] = STATE(167),
    [sym_cmd_substitution_arg] = STATE(167),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_TILDE] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(289),
    [anon_sym_PIPEH] = ACTIONS(285),
    [anon_sym_PIPET] = ACTIONS(285),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(285),
    [anon_sym_AT_AT_ATb] = ACTIONS(285),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATi] = ACTIONS(285),
    [anon_sym_AT_AT_ATr] = ACTIONS(285),
    [anon_sym_AT_AT_ATs] = ACTIONS(289),
    [anon_sym_AT_AT_ATst] = ACTIONS(285),
    [anon_sym_AT_AT_ATS] = ACTIONS(285),
    [anon_sym_AT_AT_ATm] = ACTIONS(285),
    [anon_sym_AT_AT_ATM] = ACTIONS(285),
    [anon_sym_AT_AT_ATf] = ACTIONS(289),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATF] = ACTIONS(289),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(285),
    [anon_sym_AT_AT_ATt] = ACTIONS(285),
    [anon_sym_AT_AT] = ACTIONS(289),
    [anon_sym_AT_ATdbt] = ACTIONS(289),
    [anon_sym_AT_ATdbta] = ACTIONS(285),
    [anon_sym_AT_ATdbtb] = ACTIONS(285),
    [anon_sym_AT_ATdbts] = ACTIONS(285),
    [anon_sym_AT_AT_DOT] = ACTIONS(285),
    [anon_sym_AT_AT_EQ] = ACTIONS(285),
    [anon_sym_AT_ATk] = ACTIONS(285),
    [anon_sym_AT_ATt] = ACTIONS(285),
    [anon_sym_AT_ATb] = ACTIONS(285),
    [anon_sym_AT_ATi] = ACTIONS(289),
    [anon_sym_AT_ATiS] = ACTIONS(285),
    [anon_sym_AT_ATf] = ACTIONS(285),
    [anon_sym_AT_ATs_COLON] = ACTIONS(285),
    [anon_sym_AT_ATc_COLON] = ACTIONS(285),
    [anon_sym_AT] = ACTIONS(289),
    [anon_sym_AT_BANG] = ACTIONS(285),
    [anon_sym_AT_LBRACE] = ACTIONS(285),
    [anon_sym_ATa_COLON] = ACTIONS(285),
    [anon_sym_ATb_COLON] = ACTIONS(285),
    [anon_sym_ATB_COLON] = ACTIONS(285),
    [anon_sym_ATe_COLON] = ACTIONS(285),
    [anon_sym_ATF_COLON] = ACTIONS(285),
    [anon_sym_ATi_COLON] = ACTIONS(285),
    [anon_sym_ATk_COLON] = ACTIONS(285),
    [anon_sym_ATo_COLON] = ACTIONS(285),
    [anon_sym_ATr_COLON] = ACTIONS(285),
    [anon_sym_ATf_COLON] = ACTIONS(285),
    [anon_sym_ATs_COLON] = ACTIONS(285),
    [anon_sym_ATx_COLON] = ACTIONS(285),
    [anon_sym_PIPE_DOT] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(289),
    [anon_sym_GT_GT] = ACTIONS(285),
    [sym_html_redirect_operator] = ACTIONS(289),
    [sym_html_append_operator] = ACTIONS(285),
    [sym__eq_sep_key_identifier] = ACTIONS(291),
    [anon_sym_SQUOTE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(285),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(285),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(318),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(318),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat_pf_dot] = ACTIONS(316),
  },
  [108] = {
    [aux_sym_pf_concatenation_repeat1] = STATE(108),
    [ts_builtin_sym_end] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_PIPEH] = ACTIONS(369),
    [anon_sym_PIPET] = ACTIONS(369),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(369),
    [anon_sym_AT_AT_ATb] = ACTIONS(369),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATi] = ACTIONS(369),
    [anon_sym_AT_AT_ATr] = ACTIONS(369),
    [anon_sym_AT_AT_ATs] = ACTIONS(371),
    [anon_sym_AT_AT_ATst] = ACTIONS(369),
    [anon_sym_AT_AT_ATS] = ACTIONS(369),
    [anon_sym_AT_AT_ATm] = ACTIONS(369),
    [anon_sym_AT_AT_ATM] = ACTIONS(369),
    [anon_sym_AT_AT_ATf] = ACTIONS(371),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATF] = ACTIONS(371),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATt] = ACTIONS(369),
    [anon_sym_AT_AT] = ACTIONS(371),
    [anon_sym_AT_ATdbt] = ACTIONS(371),
    [anon_sym_AT_ATdbta] = ACTIONS(369),
    [anon_sym_AT_ATdbtb] = ACTIONS(369),
    [anon_sym_AT_ATdbts] = ACTIONS(369),
    [anon_sym_AT_AT_DOT] = ACTIONS(369),
    [anon_sym_AT_AT_EQ] = ACTIONS(369),
    [anon_sym_AT_ATk] = ACTIONS(369),
    [anon_sym_AT_ATt] = ACTIONS(369),
    [anon_sym_AT_ATb] = ACTIONS(369),
    [anon_sym_AT_ATi] = ACTIONS(371),
    [anon_sym_AT_ATiS] = ACTIONS(369),
    [anon_sym_AT_ATf] = ACTIONS(369),
    [anon_sym_AT_ATs_COLON] = ACTIONS(369),
    [anon_sym_AT_ATc_COLON] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(371),
    [anon_sym_AT_BANG] = ACTIONS(369),
    [anon_sym_AT_LBRACE] = ACTIONS(369),
    [anon_sym_ATa_COLON] = ACTIONS(369),
    [anon_sym_ATb_COLON] = ACTIONS(369),
    [anon_sym_ATB_COLON] = ACTIONS(369),
    [anon_sym_ATe_COLON] = ACTIONS(369),
    [anon_sym_ATF_COLON] = ACTIONS(369),
    [anon_sym_ATi_COLON] = ACTIONS(369),
    [anon_sym_ATk_COLON] = ACTIONS(369),
    [anon_sym_ATo_COLON] = ACTIONS(369),
    [anon_sym_ATr_COLON] = ACTIONS(369),
    [anon_sym_ATf_COLON] = ACTIONS(369),
    [anon_sym_ATs_COLON] = ACTIONS(369),
    [anon_sym_ATx_COLON] = ACTIONS(369),
    [anon_sym_PIPE_DOT] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(369),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [sym_html_redirect_operator] = ACTIONS(371),
    [sym_html_append_operator] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(369),
    [anon_sym_CR] = ACTIONS(369),
    [sym_file_descriptor] = ACTIONS(369),
    [sym__concat] = ACTIONS(373),
  },
  [109] = {
    [aux_sym_pf_concatenation_repeat1] = STATE(111),
    [ts_builtin_sym_end] = ACTIONS(376),
    [anon_sym_TILDE] = ACTIONS(376),
    [anon_sym_PIPE] = ACTIONS(378),
    [anon_sym_PIPEH] = ACTIONS(376),
    [anon_sym_PIPET] = ACTIONS(376),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(376),
    [anon_sym_AT_AT_ATb] = ACTIONS(376),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATi] = ACTIONS(376),
    [anon_sym_AT_AT_ATr] = ACTIONS(376),
    [anon_sym_AT_AT_ATs] = ACTIONS(378),
    [anon_sym_AT_AT_ATst] = ACTIONS(376),
    [anon_sym_AT_AT_ATS] = ACTIONS(376),
    [anon_sym_AT_AT_ATm] = ACTIONS(376),
    [anon_sym_AT_AT_ATM] = ACTIONS(376),
    [anon_sym_AT_AT_ATf] = ACTIONS(378),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATF] = ACTIONS(378),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATt] = ACTIONS(376),
    [anon_sym_AT_AT] = ACTIONS(378),
    [anon_sym_AT_ATdbt] = ACTIONS(378),
    [anon_sym_AT_ATdbta] = ACTIONS(376),
    [anon_sym_AT_ATdbtb] = ACTIONS(376),
    [anon_sym_AT_ATdbts] = ACTIONS(376),
    [anon_sym_AT_AT_DOT] = ACTIONS(376),
    [anon_sym_AT_AT_EQ] = ACTIONS(376),
    [anon_sym_AT_ATk] = ACTIONS(376),
    [anon_sym_AT_ATt] = ACTIONS(376),
    [anon_sym_AT_ATb] = ACTIONS(376),
    [anon_sym_AT_ATi] = ACTIONS(378),
    [anon_sym_AT_ATiS] = ACTIONS(376),
    [anon_sym_AT_ATf] = ACTIONS(376),
    [anon_sym_AT_ATs_COLON] = ACTIONS(376),
    [anon_sym_AT_ATc_COLON] = ACTIONS(376),
    [anon_sym_AT] = ACTIONS(378),
    [anon_sym_AT_BANG] = ACTIONS(376),
    [anon_sym_AT_LBRACE] = ACTIONS(376),
    [anon_sym_ATa_COLON] = ACTIONS(376),
    [anon_sym_ATb_COLON] = ACTIONS(376),
    [anon_sym_ATB_COLON] = ACTIONS(376),
    [anon_sym_ATe_COLON] = ACTIONS(376),
    [anon_sym_ATF_COLON] = ACTIONS(376),
    [anon_sym_ATi_COLON] = ACTIONS(376),
    [anon_sym_ATk_COLON] = ACTIONS(376),
    [anon_sym_ATo_COLON] = ACTIONS(376),
    [anon_sym_ATr_COLON] = ACTIONS(376),
    [anon_sym_ATf_COLON] = ACTIONS(376),
    [anon_sym_ATs_COLON] = ACTIONS(376),
    [anon_sym_ATx_COLON] = ACTIONS(376),
    [anon_sym_PIPE_DOT] = ACTIONS(376),
    [anon_sym_DOLLAR] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_RPAREN] = ACTIONS(376),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(378),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_GT] = ACTIONS(378),
    [anon_sym_GT_GT] = ACTIONS(376),
    [sym_html_redirect_operator] = ACTIONS(378),
    [sym_html_append_operator] = ACTIONS(376),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(376),
    [anon_sym_BQUOTE] = ACTIONS(376),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(376),
    [anon_sym_CR] = ACTIONS(376),
    [sym_file_descriptor] = ACTIONS(376),
    [sym__concat] = ACTIONS(380),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(318),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(318),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat_pf_dot] = ACTIONS(316),
  },
  [111] = {
    [aux_sym_pf_concatenation_repeat1] = STATE(108),
    [ts_builtin_sym_end] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(382),
    [anon_sym_PIPE] = ACTIONS(384),
    [anon_sym_PIPEH] = ACTIONS(382),
    [anon_sym_PIPET] = ACTIONS(382),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(382),
    [anon_sym_AT_AT_ATb] = ACTIONS(382),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(382),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(382),
    [anon_sym_AT_AT_ATi] = ACTIONS(382),
    [anon_sym_AT_AT_ATr] = ACTIONS(382),
    [anon_sym_AT_AT_ATs] = ACTIONS(384),
    [anon_sym_AT_AT_ATst] = ACTIONS(382),
    [anon_sym_AT_AT_ATS] = ACTIONS(382),
    [anon_sym_AT_AT_ATm] = ACTIONS(382),
    [anon_sym_AT_AT_ATM] = ACTIONS(382),
    [anon_sym_AT_AT_ATf] = ACTIONS(384),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(382),
    [anon_sym_AT_AT_ATF] = ACTIONS(384),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(382),
    [anon_sym_AT_AT_ATt] = ACTIONS(382),
    [anon_sym_AT_AT] = ACTIONS(384),
    [anon_sym_AT_ATdbt] = ACTIONS(384),
    [anon_sym_AT_ATdbta] = ACTIONS(382),
    [anon_sym_AT_ATdbtb] = ACTIONS(382),
    [anon_sym_AT_ATdbts] = ACTIONS(382),
    [anon_sym_AT_AT_DOT] = ACTIONS(382),
    [anon_sym_AT_AT_EQ] = ACTIONS(382),
    [anon_sym_AT_ATk] = ACTIONS(382),
    [anon_sym_AT_ATt] = ACTIONS(382),
    [anon_sym_AT_ATb] = ACTIONS(382),
    [anon_sym_AT_ATi] = ACTIONS(384),
    [anon_sym_AT_ATiS] = ACTIONS(382),
    [anon_sym_AT_ATf] = ACTIONS(382),
    [anon_sym_AT_ATs_COLON] = ACTIONS(382),
    [anon_sym_AT_ATc_COLON] = ACTIONS(382),
    [anon_sym_AT] = ACTIONS(384),
    [anon_sym_AT_BANG] = ACTIONS(382),
    [anon_sym_AT_LBRACE] = ACTIONS(382),
    [anon_sym_ATa_COLON] = ACTIONS(382),
    [anon_sym_ATb_COLON] = ACTIONS(382),
    [anon_sym_ATB_COLON] = ACTIONS(382),
    [anon_sym_ATe_COLON] = ACTIONS(382),
    [anon_sym_ATF_COLON] = ACTIONS(382),
    [anon_sym_ATi_COLON] = ACTIONS(382),
    [anon_sym_ATk_COLON] = ACTIONS(382),
    [anon_sym_ATo_COLON] = ACTIONS(382),
    [anon_sym_ATr_COLON] = ACTIONS(382),
    [anon_sym_ATf_COLON] = ACTIONS(382),
    [anon_sym_ATs_COLON] = ACTIONS(382),
    [anon_sym_ATx_COLON] = ACTIONS(382),
    [anon_sym_PIPE_DOT] = ACTIONS(382),
    [anon_sym_DOLLAR] = ACTIONS(384),
    [anon_sym_LPAREN] = ACTIONS(382),
    [anon_sym_RPAREN] = ACTIONS(382),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(384),
    [anon_sym_SEMI] = ACTIONS(382),
    [anon_sym_GT] = ACTIONS(384),
    [anon_sym_GT_GT] = ACTIONS(382),
    [sym_html_redirect_operator] = ACTIONS(384),
    [sym_html_append_operator] = ACTIONS(382),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(382),
    [anon_sym_BQUOTE] = ACTIONS(382),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(382),
    [anon_sym_CR] = ACTIONS(382),
    [sym_file_descriptor] = ACTIONS(382),
    [sym__concat] = ACTIONS(380),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(386),
    [anon_sym_TILDE] = ACTIONS(386),
    [anon_sym_PIPE] = ACTIONS(388),
    [anon_sym_PIPEH] = ACTIONS(386),
    [anon_sym_PIPET] = ACTIONS(386),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(386),
    [anon_sym_AT_AT_ATb] = ACTIONS(386),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATi] = ACTIONS(386),
    [anon_sym_AT_AT_ATr] = ACTIONS(386),
    [anon_sym_AT_AT_ATs] = ACTIONS(388),
    [anon_sym_AT_AT_ATst] = ACTIONS(386),
    [anon_sym_AT_AT_ATS] = ACTIONS(386),
    [anon_sym_AT_AT_ATm] = ACTIONS(386),
    [anon_sym_AT_AT_ATM] = ACTIONS(386),
    [anon_sym_AT_AT_ATf] = ACTIONS(388),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATF] = ACTIONS(388),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATt] = ACTIONS(386),
    [anon_sym_AT_AT] = ACTIONS(388),
    [anon_sym_AT_ATdbt] = ACTIONS(388),
    [anon_sym_AT_ATdbta] = ACTIONS(386),
    [anon_sym_AT_ATdbtb] = ACTIONS(386),
    [anon_sym_AT_ATdbts] = ACTIONS(386),
    [anon_sym_AT_AT_DOT] = ACTIONS(386),
    [anon_sym_AT_AT_EQ] = ACTIONS(386),
    [anon_sym_AT_ATk] = ACTIONS(386),
    [anon_sym_AT_ATt] = ACTIONS(386),
    [anon_sym_AT_ATb] = ACTIONS(386),
    [anon_sym_AT_ATi] = ACTIONS(388),
    [anon_sym_AT_ATiS] = ACTIONS(386),
    [anon_sym_AT_ATf] = ACTIONS(386),
    [anon_sym_AT_ATs_COLON] = ACTIONS(386),
    [anon_sym_AT_ATc_COLON] = ACTIONS(386),
    [anon_sym_AT] = ACTIONS(388),
    [anon_sym_AT_BANG] = ACTIONS(386),
    [anon_sym_AT_LBRACE] = ACTIONS(386),
    [anon_sym_ATa_COLON] = ACTIONS(386),
    [anon_sym_ATb_COLON] = ACTIONS(386),
    [anon_sym_ATB_COLON] = ACTIONS(386),
    [anon_sym_ATe_COLON] = ACTIONS(386),
    [anon_sym_ATF_COLON] = ACTIONS(386),
    [anon_sym_ATi_COLON] = ACTIONS(386),
    [anon_sym_ATk_COLON] = ACTIONS(386),
    [anon_sym_ATo_COLON] = ACTIONS(386),
    [anon_sym_ATr_COLON] = ACTIONS(386),
    [anon_sym_ATf_COLON] = ACTIONS(386),
    [anon_sym_ATs_COLON] = ACTIONS(386),
    [anon_sym_ATx_COLON] = ACTIONS(386),
    [anon_sym_PIPE_DOT] = ACTIONS(386),
    [anon_sym_EQ] = ACTIONS(388),
    [anon_sym_DOLLAR] = ACTIONS(388),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_RPAREN] = ACTIONS(386),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(388),
    [anon_sym_SEMI] = ACTIONS(386),
    [anon_sym_GT] = ACTIONS(388),
    [anon_sym_GT_GT] = ACTIONS(386),
    [sym_html_redirect_operator] = ACTIONS(388),
    [sym_html_append_operator] = ACTIONS(386),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(386),
    [anon_sym_BQUOTE] = ACTIONS(386),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(386),
    [anon_sym_CR] = ACTIONS(386),
    [sym_file_descriptor] = ACTIONS(386),
    [sym__concat_pf_dot] = ACTIONS(386),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(360),
    [anon_sym_DOLLAR] = ACTIONS(360),
    [anon_sym_LPAREN] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(358),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(318),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat] = ACTIONS(316),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(318),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat] = ACTIONS(316),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(390),
    [anon_sym_PIPE] = ACTIONS(392),
    [anon_sym_PIPEH] = ACTIONS(390),
    [anon_sym_PIPET] = ACTIONS(390),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(390),
    [anon_sym_AT_AT_ATb] = ACTIONS(390),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(390),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(390),
    [anon_sym_AT_AT_ATi] = ACTIONS(390),
    [anon_sym_AT_AT_ATr] = ACTIONS(390),
    [anon_sym_AT_AT_ATs] = ACTIONS(392),
    [anon_sym_AT_AT_ATst] = ACTIONS(390),
    [anon_sym_AT_AT_ATS] = ACTIONS(390),
    [anon_sym_AT_AT_ATm] = ACTIONS(390),
    [anon_sym_AT_AT_ATM] = ACTIONS(390),
    [anon_sym_AT_AT_ATf] = ACTIONS(392),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(390),
    [anon_sym_AT_AT_ATF] = ACTIONS(392),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(390),
    [anon_sym_AT_AT_ATt] = ACTIONS(390),
    [anon_sym_AT_AT] = ACTIONS(392),
    [anon_sym_AT_ATdbt] = ACTIONS(392),
    [anon_sym_AT_ATdbta] = ACTIONS(390),
    [anon_sym_AT_ATdbtb] = ACTIONS(390),
    [anon_sym_AT_ATdbts] = ACTIONS(390),
    [anon_sym_AT_AT_DOT] = ACTIONS(390),
    [anon_sym_AT_AT_EQ] = ACTIONS(390),
    [anon_sym_AT_ATk] = ACTIONS(390),
    [anon_sym_AT_ATt] = ACTIONS(390),
    [anon_sym_AT_ATb] = ACTIONS(390),
    [anon_sym_AT_ATi] = ACTIONS(392),
    [anon_sym_AT_ATiS] = ACTIONS(390),
    [anon_sym_AT_ATf] = ACTIONS(390),
    [anon_sym_AT_ATs_COLON] = ACTIONS(390),
    [anon_sym_AT_ATc_COLON] = ACTIONS(390),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_AT_BANG] = ACTIONS(390),
    [anon_sym_AT_LBRACE] = ACTIONS(390),
    [anon_sym_ATa_COLON] = ACTIONS(390),
    [anon_sym_ATb_COLON] = ACTIONS(390),
    [anon_sym_ATB_COLON] = ACTIONS(390),
    [anon_sym_ATe_COLON] = ACTIONS(390),
    [anon_sym_ATF_COLON] = ACTIONS(390),
    [anon_sym_ATi_COLON] = ACTIONS(390),
    [anon_sym_ATk_COLON] = ACTIONS(390),
    [anon_sym_ATo_COLON] = ACTIONS(390),
    [anon_sym_ATr_COLON] = ACTIONS(390),
    [anon_sym_ATf_COLON] = ACTIONS(390),
    [anon_sym_ATs_COLON] = ACTIONS(390),
    [anon_sym_ATx_COLON] = ACTIONS(390),
    [anon_sym_PIPE_DOT] = ACTIONS(390),
    [anon_sym_DOLLAR] = ACTIONS(392),
    [anon_sym_LPAREN] = ACTIONS(390),
    [anon_sym_RPAREN] = ACTIONS(390),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(392),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_GT] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(390),
    [sym_html_redirect_operator] = ACTIONS(392),
    [sym_html_append_operator] = ACTIONS(390),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(390),
    [anon_sym_BQUOTE] = ACTIONS(390),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(390),
    [anon_sym_CR] = ACTIONS(390),
    [sym_file_descriptor] = ACTIONS(390),
    [sym__concat] = ACTIONS(390),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(394),
    [anon_sym_PIPE] = ACTIONS(396),
    [anon_sym_PIPEH] = ACTIONS(394),
    [anon_sym_PIPET] = ACTIONS(394),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(394),
    [anon_sym_AT_AT_ATb] = ACTIONS(394),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATi] = ACTIONS(394),
    [anon_sym_AT_AT_ATr] = ACTIONS(394),
    [anon_sym_AT_AT_ATs] = ACTIONS(396),
    [anon_sym_AT_AT_ATst] = ACTIONS(394),
    [anon_sym_AT_AT_ATS] = ACTIONS(394),
    [anon_sym_AT_AT_ATm] = ACTIONS(394),
    [anon_sym_AT_AT_ATM] = ACTIONS(394),
    [anon_sym_AT_AT_ATf] = ACTIONS(396),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATF] = ACTIONS(396),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATt] = ACTIONS(394),
    [anon_sym_AT_AT] = ACTIONS(396),
    [anon_sym_AT_ATdbt] = ACTIONS(396),
    [anon_sym_AT_ATdbta] = ACTIONS(394),
    [anon_sym_AT_ATdbtb] = ACTIONS(394),
    [anon_sym_AT_ATdbts] = ACTIONS(394),
    [anon_sym_AT_AT_DOT] = ACTIONS(394),
    [anon_sym_AT_AT_EQ] = ACTIONS(394),
    [anon_sym_AT_ATk] = ACTIONS(394),
    [anon_sym_AT_ATt] = ACTIONS(394),
    [anon_sym_AT_ATb] = ACTIONS(394),
    [anon_sym_AT_ATi] = ACTIONS(396),
    [anon_sym_AT_ATiS] = ACTIONS(394),
    [anon_sym_AT_ATf] = ACTIONS(394),
    [anon_sym_AT_ATs_COLON] = ACTIONS(394),
    [anon_sym_AT_ATc_COLON] = ACTIONS(394),
    [anon_sym_AT] = ACTIONS(396),
    [anon_sym_AT_BANG] = ACTIONS(394),
    [anon_sym_AT_LBRACE] = ACTIONS(394),
    [anon_sym_ATa_COLON] = ACTIONS(394),
    [anon_sym_ATb_COLON] = ACTIONS(394),
    [anon_sym_ATB_COLON] = ACTIONS(394),
    [anon_sym_ATe_COLON] = ACTIONS(394),
    [anon_sym_ATF_COLON] = ACTIONS(394),
    [anon_sym_ATi_COLON] = ACTIONS(394),
    [anon_sym_ATk_COLON] = ACTIONS(394),
    [anon_sym_ATo_COLON] = ACTIONS(394),
    [anon_sym_ATr_COLON] = ACTIONS(394),
    [anon_sym_ATf_COLON] = ACTIONS(394),
    [anon_sym_ATs_COLON] = ACTIONS(394),
    [anon_sym_ATx_COLON] = ACTIONS(394),
    [anon_sym_PIPE_DOT] = ACTIONS(394),
    [anon_sym_DOLLAR] = ACTIONS(396),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(394),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(396),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(396),
    [anon_sym_GT_GT] = ACTIONS(394),
    [sym_html_redirect_operator] = ACTIONS(396),
    [sym_html_append_operator] = ACTIONS(394),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(394),
    [anon_sym_BQUOTE] = ACTIONS(394),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(394),
    [anon_sym_CR] = ACTIONS(394),
    [sym_file_descriptor] = ACTIONS(394),
    [sym__concat] = ACTIONS(394),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_PIPEH] = ACTIONS(369),
    [anon_sym_PIPET] = ACTIONS(369),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(369),
    [anon_sym_AT_AT_ATb] = ACTIONS(369),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATi] = ACTIONS(369),
    [anon_sym_AT_AT_ATr] = ACTIONS(369),
    [anon_sym_AT_AT_ATs] = ACTIONS(371),
    [anon_sym_AT_AT_ATst] = ACTIONS(369),
    [anon_sym_AT_AT_ATS] = ACTIONS(369),
    [anon_sym_AT_AT_ATm] = ACTIONS(369),
    [anon_sym_AT_AT_ATM] = ACTIONS(369),
    [anon_sym_AT_AT_ATf] = ACTIONS(371),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATF] = ACTIONS(371),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(369),
    [anon_sym_AT_AT_ATt] = ACTIONS(369),
    [anon_sym_AT_AT] = ACTIONS(371),
    [anon_sym_AT_ATdbt] = ACTIONS(371),
    [anon_sym_AT_ATdbta] = ACTIONS(369),
    [anon_sym_AT_ATdbtb] = ACTIONS(369),
    [anon_sym_AT_ATdbts] = ACTIONS(369),
    [anon_sym_AT_AT_DOT] = ACTIONS(369),
    [anon_sym_AT_AT_EQ] = ACTIONS(369),
    [anon_sym_AT_ATk] = ACTIONS(369),
    [anon_sym_AT_ATt] = ACTIONS(369),
    [anon_sym_AT_ATb] = ACTIONS(369),
    [anon_sym_AT_ATi] = ACTIONS(371),
    [anon_sym_AT_ATiS] = ACTIONS(369),
    [anon_sym_AT_ATf] = ACTIONS(369),
    [anon_sym_AT_ATs_COLON] = ACTIONS(369),
    [anon_sym_AT_ATc_COLON] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(371),
    [anon_sym_AT_BANG] = ACTIONS(369),
    [anon_sym_AT_LBRACE] = ACTIONS(369),
    [anon_sym_ATa_COLON] = ACTIONS(369),
    [anon_sym_ATb_COLON] = ACTIONS(369),
    [anon_sym_ATB_COLON] = ACTIONS(369),
    [anon_sym_ATe_COLON] = ACTIONS(369),
    [anon_sym_ATF_COLON] = ACTIONS(369),
    [anon_sym_ATi_COLON] = ACTIONS(369),
    [anon_sym_ATk_COLON] = ACTIONS(369),
    [anon_sym_ATo_COLON] = ACTIONS(369),
    [anon_sym_ATr_COLON] = ACTIONS(369),
    [anon_sym_ATf_COLON] = ACTIONS(369),
    [anon_sym_ATs_COLON] = ACTIONS(369),
    [anon_sym_ATx_COLON] = ACTIONS(369),
    [anon_sym_PIPE_DOT] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(369),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [sym_html_redirect_operator] = ACTIONS(371),
    [sym_html_append_operator] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(369),
    [anon_sym_CR] = ACTIONS(369),
    [sym_file_descriptor] = ACTIONS(369),
    [sym__concat] = ACTIONS(369),
  },
  [119] = {
    [sym_cmd_substitution_arg] = STATE(122),
    [aux_sym_grep_specifier_repeat1] = STATE(122),
    [ts_builtin_sym_end] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(400),
    [sym_grep_specifier_identifier] = ACTIONS(402),
    [aux_sym_grep_specifier_token1] = ACTIONS(404),
    [anon_sym_PIPE] = ACTIONS(400),
    [anon_sym_PIPEH] = ACTIONS(400),
    [anon_sym_PIPET] = ACTIONS(400),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(400),
    [anon_sym_AT_AT_ATb] = ACTIONS(400),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATi] = ACTIONS(400),
    [anon_sym_AT_AT_ATr] = ACTIONS(400),
    [anon_sym_AT_AT_ATs] = ACTIONS(400),
    [anon_sym_AT_AT_ATst] = ACTIONS(400),
    [anon_sym_AT_AT_ATS] = ACTIONS(400),
    [anon_sym_AT_AT_ATm] = ACTIONS(400),
    [anon_sym_AT_AT_ATM] = ACTIONS(400),
    [anon_sym_AT_AT_ATf] = ACTIONS(400),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATF] = ACTIONS(400),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATt] = ACTIONS(400),
    [anon_sym_AT_AT] = ACTIONS(400),
    [anon_sym_AT_ATdbt] = ACTIONS(400),
    [anon_sym_AT_ATdbta] = ACTIONS(400),
    [anon_sym_AT_ATdbtb] = ACTIONS(400),
    [anon_sym_AT_ATdbts] = ACTIONS(400),
    [anon_sym_AT_AT_DOT] = ACTIONS(400),
    [anon_sym_AT_AT_EQ] = ACTIONS(400),
    [anon_sym_AT_ATk] = ACTIONS(400),
    [anon_sym_AT_ATt] = ACTIONS(400),
    [anon_sym_AT_ATb] = ACTIONS(400),
    [anon_sym_AT_ATi] = ACTIONS(400),
    [anon_sym_AT_ATiS] = ACTIONS(400),
    [anon_sym_AT_ATf] = ACTIONS(400),
    [anon_sym_AT_ATs_COLON] = ACTIONS(400),
    [anon_sym_AT_ATc_COLON] = ACTIONS(400),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_AT_BANG] = ACTIONS(400),
    [anon_sym_AT_LBRACE] = ACTIONS(400),
    [anon_sym_ATa_COLON] = ACTIONS(400),
    [anon_sym_ATb_COLON] = ACTIONS(400),
    [anon_sym_ATB_COLON] = ACTIONS(400),
    [anon_sym_ATe_COLON] = ACTIONS(400),
    [anon_sym_ATF_COLON] = ACTIONS(400),
    [anon_sym_ATi_COLON] = ACTIONS(400),
    [anon_sym_ATk_COLON] = ACTIONS(400),
    [anon_sym_ATo_COLON] = ACTIONS(400),
    [anon_sym_ATr_COLON] = ACTIONS(400),
    [anon_sym_ATf_COLON] = ACTIONS(400),
    [anon_sym_ATs_COLON] = ACTIONS(400),
    [anon_sym_ATx_COLON] = ACTIONS(400),
    [anon_sym_PIPE_DOT] = ACTIONS(400),
    [anon_sym_SEMI] = ACTIONS(400),
    [anon_sym_GT] = ACTIONS(400),
    [anon_sym_GT_GT] = ACTIONS(400),
    [sym_html_redirect_operator] = ACTIONS(400),
    [sym_html_append_operator] = ACTIONS(400),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(408),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(400),
    [anon_sym_CR] = ACTIONS(400),
    [sym_file_descriptor] = ACTIONS(398),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(410),
    [anon_sym_DQUOTE] = ACTIONS(410),
    [anon_sym_TILDE] = ACTIONS(410),
    [anon_sym_PIPE] = ACTIONS(412),
    [anon_sym_PIPEH] = ACTIONS(410),
    [anon_sym_PIPET] = ACTIONS(410),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(410),
    [anon_sym_AT_AT_ATb] = ACTIONS(410),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(410),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(410),
    [anon_sym_AT_AT_ATi] = ACTIONS(410),
    [anon_sym_AT_AT_ATr] = ACTIONS(410),
    [anon_sym_AT_AT_ATs] = ACTIONS(412),
    [anon_sym_AT_AT_ATst] = ACTIONS(410),
    [anon_sym_AT_AT_ATS] = ACTIONS(410),
    [anon_sym_AT_AT_ATm] = ACTIONS(410),
    [anon_sym_AT_AT_ATM] = ACTIONS(410),
    [anon_sym_AT_AT_ATf] = ACTIONS(412),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(410),
    [anon_sym_AT_AT_ATF] = ACTIONS(412),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(410),
    [anon_sym_AT_AT_ATt] = ACTIONS(410),
    [anon_sym_AT_AT] = ACTIONS(412),
    [anon_sym_AT_ATdbt] = ACTIONS(412),
    [anon_sym_AT_ATdbta] = ACTIONS(410),
    [anon_sym_AT_ATdbtb] = ACTIONS(410),
    [anon_sym_AT_ATdbts] = ACTIONS(410),
    [anon_sym_AT_AT_DOT] = ACTIONS(410),
    [anon_sym_AT_AT_EQ] = ACTIONS(410),
    [anon_sym_AT_ATk] = ACTIONS(410),
    [anon_sym_AT_ATt] = ACTIONS(410),
    [anon_sym_AT_ATb] = ACTIONS(410),
    [anon_sym_AT_ATi] = ACTIONS(412),
    [anon_sym_AT_ATiS] = ACTIONS(410),
    [anon_sym_AT_ATf] = ACTIONS(410),
    [anon_sym_AT_ATs_COLON] = ACTIONS(410),
    [anon_sym_AT_ATc_COLON] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(412),
    [anon_sym_AT_BANG] = ACTIONS(410),
    [anon_sym_AT_LBRACE] = ACTIONS(410),
    [anon_sym_ATa_COLON] = ACTIONS(410),
    [anon_sym_ATb_COLON] = ACTIONS(410),
    [anon_sym_ATB_COLON] = ACTIONS(410),
    [anon_sym_ATe_COLON] = ACTIONS(410),
    [anon_sym_ATF_COLON] = ACTIONS(410),
    [anon_sym_ATi_COLON] = ACTIONS(410),
    [anon_sym_ATk_COLON] = ACTIONS(410),
    [anon_sym_ATo_COLON] = ACTIONS(410),
    [anon_sym_ATr_COLON] = ACTIONS(410),
    [anon_sym_ATf_COLON] = ACTIONS(410),
    [anon_sym_ATs_COLON] = ACTIONS(410),
    [anon_sym_ATx_COLON] = ACTIONS(410),
    [anon_sym_PIPE_DOT] = ACTIONS(410),
    [anon_sym_RPAREN] = ACTIONS(410),
    [anon_sym_SEMI] = ACTIONS(410),
    [anon_sym_GT] = ACTIONS(412),
    [anon_sym_GT_GT] = ACTIONS(410),
    [sym_html_redirect_operator] = ACTIONS(412),
    [sym_html_append_operator] = ACTIONS(410),
    [sym__eq_sep_key_identifier] = ACTIONS(412),
    [anon_sym_SQUOTE] = ACTIONS(410),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(410),
    [anon_sym_BQUOTE] = ACTIONS(410),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(410),
    [anon_sym_CR] = ACTIONS(410),
    [sym_file_descriptor] = ACTIONS(410),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(376),
    [anon_sym_TILDE] = ACTIONS(376),
    [anon_sym_PIPE] = ACTIONS(378),
    [anon_sym_PIPEH] = ACTIONS(376),
    [anon_sym_PIPET] = ACTIONS(376),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(376),
    [anon_sym_AT_AT_ATb] = ACTIONS(376),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATi] = ACTIONS(376),
    [anon_sym_AT_AT_ATr] = ACTIONS(376),
    [anon_sym_AT_AT_ATs] = ACTIONS(378),
    [anon_sym_AT_AT_ATst] = ACTIONS(376),
    [anon_sym_AT_AT_ATS] = ACTIONS(376),
    [anon_sym_AT_AT_ATm] = ACTIONS(376),
    [anon_sym_AT_AT_ATM] = ACTIONS(376),
    [anon_sym_AT_AT_ATf] = ACTIONS(378),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATF] = ACTIONS(378),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(376),
    [anon_sym_AT_AT_ATt] = ACTIONS(376),
    [anon_sym_AT_AT] = ACTIONS(378),
    [anon_sym_AT_ATdbt] = ACTIONS(378),
    [anon_sym_AT_ATdbta] = ACTIONS(376),
    [anon_sym_AT_ATdbtb] = ACTIONS(376),
    [anon_sym_AT_ATdbts] = ACTIONS(376),
    [anon_sym_AT_AT_DOT] = ACTIONS(376),
    [anon_sym_AT_AT_EQ] = ACTIONS(376),
    [anon_sym_AT_ATk] = ACTIONS(376),
    [anon_sym_AT_ATt] = ACTIONS(376),
    [anon_sym_AT_ATb] = ACTIONS(376),
    [anon_sym_AT_ATi] = ACTIONS(378),
    [anon_sym_AT_ATiS] = ACTIONS(376),
    [anon_sym_AT_ATf] = ACTIONS(376),
    [anon_sym_AT_ATs_COLON] = ACTIONS(376),
    [anon_sym_AT_ATc_COLON] = ACTIONS(376),
    [anon_sym_AT] = ACTIONS(378),
    [anon_sym_AT_BANG] = ACTIONS(376),
    [anon_sym_AT_LBRACE] = ACTIONS(376),
    [anon_sym_ATa_COLON] = ACTIONS(376),
    [anon_sym_ATb_COLON] = ACTIONS(376),
    [anon_sym_ATB_COLON] = ACTIONS(376),
    [anon_sym_ATe_COLON] = ACTIONS(376),
    [anon_sym_ATF_COLON] = ACTIONS(376),
    [anon_sym_ATi_COLON] = ACTIONS(376),
    [anon_sym_ATk_COLON] = ACTIONS(376),
    [anon_sym_ATo_COLON] = ACTIONS(376),
    [anon_sym_ATr_COLON] = ACTIONS(376),
    [anon_sym_ATf_COLON] = ACTIONS(376),
    [anon_sym_ATs_COLON] = ACTIONS(376),
    [anon_sym_ATx_COLON] = ACTIONS(376),
    [anon_sym_PIPE_DOT] = ACTIONS(376),
    [anon_sym_DOLLAR] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_RPAREN] = ACTIONS(376),
    [aux_sym_pf_arg_identifier_token1] = ACTIONS(378),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_GT] = ACTIONS(378),
    [anon_sym_GT_GT] = ACTIONS(376),
    [sym_html_redirect_operator] = ACTIONS(378),
    [sym_html_append_operator] = ACTIONS(376),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(376),
    [anon_sym_BQUOTE] = ACTIONS(376),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(376),
    [anon_sym_CR] = ACTIONS(376),
    [sym_file_descriptor] = ACTIONS(376),
  },
  [122] = {
    [sym_cmd_substitution_arg] = STATE(122),
    [aux_sym_grep_specifier_repeat1] = STATE(122),
    [ts_builtin_sym_end] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_grep_specifier_identifier] = ACTIONS(418),
    [aux_sym_grep_specifier_token1] = ACTIONS(416),
    [anon_sym_PIPE] = ACTIONS(416),
    [anon_sym_PIPEH] = ACTIONS(416),
    [anon_sym_PIPET] = ACTIONS(416),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(416),
    [anon_sym_AT_AT_ATb] = ACTIONS(416),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATi] = ACTIONS(416),
    [anon_sym_AT_AT_ATr] = ACTIONS(416),
    [anon_sym_AT_AT_ATs] = ACTIONS(416),
    [anon_sym_AT_AT_ATst] = ACTIONS(416),
    [anon_sym_AT_AT_ATS] = ACTIONS(416),
    [anon_sym_AT_AT_ATm] = ACTIONS(416),
    [anon_sym_AT_AT_ATM] = ACTIONS(416),
    [anon_sym_AT_AT_ATf] = ACTIONS(416),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATF] = ACTIONS(416),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATt] = ACTIONS(416),
    [anon_sym_AT_AT] = ACTIONS(416),
    [anon_sym_AT_ATdbt] = ACTIONS(416),
    [anon_sym_AT_ATdbta] = ACTIONS(416),
    [anon_sym_AT_ATdbtb] = ACTIONS(416),
    [anon_sym_AT_ATdbts] = ACTIONS(416),
    [anon_sym_AT_AT_DOT] = ACTIONS(416),
    [anon_sym_AT_AT_EQ] = ACTIONS(416),
    [anon_sym_AT_ATk] = ACTIONS(416),
    [anon_sym_AT_ATt] = ACTIONS(416),
    [anon_sym_AT_ATb] = ACTIONS(416),
    [anon_sym_AT_ATi] = ACTIONS(416),
    [anon_sym_AT_ATiS] = ACTIONS(416),
    [anon_sym_AT_ATf] = ACTIONS(416),
    [anon_sym_AT_ATs_COLON] = ACTIONS(416),
    [anon_sym_AT_ATc_COLON] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(416),
    [anon_sym_AT_BANG] = ACTIONS(416),
    [anon_sym_AT_LBRACE] = ACTIONS(416),
    [anon_sym_ATa_COLON] = ACTIONS(416),
    [anon_sym_ATb_COLON] = ACTIONS(416),
    [anon_sym_ATB_COLON] = ACTIONS(416),
    [anon_sym_ATe_COLON] = ACTIONS(416),
    [anon_sym_ATF_COLON] = ACTIONS(416),
    [anon_sym_ATi_COLON] = ACTIONS(416),
    [anon_sym_ATk_COLON] = ACTIONS(416),
    [anon_sym_ATo_COLON] = ACTIONS(416),
    [anon_sym_ATr_COLON] = ACTIONS(416),
    [anon_sym_ATf_COLON] = ACTIONS(416),
    [anon_sym_ATs_COLON] = ACTIONS(416),
    [anon_sym_ATx_COLON] = ACTIONS(416),
    [anon_sym_PIPE_DOT] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(416),
    [anon_sym_GT] = ACTIONS(416),
    [anon_sym_GT_GT] = ACTIONS(416),
    [sym_html_redirect_operator] = ACTIONS(416),
    [sym_html_append_operator] = ACTIONS(416),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(421),
    [anon_sym_BQUOTE] = ACTIONS(424),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(416),
    [anon_sym_CR] = ACTIONS(416),
    [sym_file_descriptor] = ACTIONS(414),
  },
  [123] = {
    [aux_sym_pf_dot_args_repeat1] = STATE(131),
    [ts_builtin_sym_end] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(427),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_PIPEH] = ACTIONS(427),
    [anon_sym_PIPET] = ACTIONS(427),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(427),
    [anon_sym_AT_AT_ATb] = ACTIONS(427),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(427),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(427),
    [anon_sym_AT_AT_ATi] = ACTIONS(427),
    [anon_sym_AT_AT_ATr] = ACTIONS(427),
    [anon_sym_AT_AT_ATs] = ACTIONS(429),
    [anon_sym_AT_AT_ATst] = ACTIONS(427),
    [anon_sym_AT_AT_ATS] = ACTIONS(427),
    [anon_sym_AT_AT_ATm] = ACTIONS(427),
    [anon_sym_AT_AT_ATM] = ACTIONS(427),
    [anon_sym_AT_AT_ATf] = ACTIONS(429),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(427),
    [anon_sym_AT_AT_ATF] = ACTIONS(429),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(427),
    [anon_sym_AT_AT_ATt] = ACTIONS(427),
    [anon_sym_AT_AT] = ACTIONS(429),
    [anon_sym_AT_ATdbt] = ACTIONS(429),
    [anon_sym_AT_ATdbta] = ACTIONS(427),
    [anon_sym_AT_ATdbtb] = ACTIONS(427),
    [anon_sym_AT_ATdbts] = ACTIONS(427),
    [anon_sym_AT_AT_DOT] = ACTIONS(427),
    [anon_sym_AT_AT_EQ] = ACTIONS(427),
    [anon_sym_AT_ATk] = ACTIONS(427),
    [anon_sym_AT_ATt] = ACTIONS(427),
    [anon_sym_AT_ATb] = ACTIONS(427),
    [anon_sym_AT_ATi] = ACTIONS(429),
    [anon_sym_AT_ATiS] = ACTIONS(427),
    [anon_sym_AT_ATf] = ACTIONS(427),
    [anon_sym_AT_ATs_COLON] = ACTIONS(427),
    [anon_sym_AT_ATc_COLON] = ACTIONS(427),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_AT_BANG] = ACTIONS(427),
    [anon_sym_AT_LBRACE] = ACTIONS(427),
    [anon_sym_ATa_COLON] = ACTIONS(427),
    [anon_sym_ATb_COLON] = ACTIONS(427),
    [anon_sym_ATB_COLON] = ACTIONS(427),
    [anon_sym_ATe_COLON] = ACTIONS(427),
    [anon_sym_ATF_COLON] = ACTIONS(427),
    [anon_sym_ATi_COLON] = ACTIONS(427),
    [anon_sym_ATk_COLON] = ACTIONS(427),
    [anon_sym_ATo_COLON] = ACTIONS(427),
    [anon_sym_ATr_COLON] = ACTIONS(427),
    [anon_sym_ATf_COLON] = ACTIONS(427),
    [anon_sym_ATs_COLON] = ACTIONS(427),
    [anon_sym_ATx_COLON] = ACTIONS(427),
    [anon_sym_PIPE_DOT] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(427),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(427),
    [sym_html_redirect_operator] = ACTIONS(429),
    [sym_html_append_operator] = ACTIONS(427),
    [anon_sym_BQUOTE] = ACTIONS(427),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(427),
    [anon_sym_CR] = ACTIONS(427),
    [sym_file_descriptor] = ACTIONS(427),
    [sym__concat_pf_dot] = ACTIONS(263),
  },
  [124] = {
    [aux_sym_eq_sep_key_repeat1] = STATE(124),
    [ts_builtin_sym_end] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(431),
    [anon_sym_PIPE] = ACTIONS(433),
    [anon_sym_PIPEH] = ACTIONS(431),
    [anon_sym_PIPET] = ACTIONS(431),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(431),
    [anon_sym_AT_AT_ATb] = ACTIONS(431),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATi] = ACTIONS(431),
    [anon_sym_AT_AT_ATr] = ACTIONS(431),
    [anon_sym_AT_AT_ATs] = ACTIONS(433),
    [anon_sym_AT_AT_ATst] = ACTIONS(431),
    [anon_sym_AT_AT_ATS] = ACTIONS(431),
    [anon_sym_AT_AT_ATm] = ACTIONS(431),
    [anon_sym_AT_AT_ATM] = ACTIONS(431),
    [anon_sym_AT_AT_ATf] = ACTIONS(433),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATF] = ACTIONS(433),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATt] = ACTIONS(431),
    [anon_sym_AT_AT] = ACTIONS(433),
    [anon_sym_AT_ATdbt] = ACTIONS(433),
    [anon_sym_AT_ATdbta] = ACTIONS(431),
    [anon_sym_AT_ATdbtb] = ACTIONS(431),
    [anon_sym_AT_ATdbts] = ACTIONS(431),
    [anon_sym_AT_AT_DOT] = ACTIONS(431),
    [anon_sym_AT_AT_EQ] = ACTIONS(431),
    [anon_sym_AT_ATk] = ACTIONS(431),
    [anon_sym_AT_ATt] = ACTIONS(431),
    [anon_sym_AT_ATb] = ACTIONS(431),
    [anon_sym_AT_ATi] = ACTIONS(433),
    [anon_sym_AT_ATiS] = ACTIONS(431),
    [anon_sym_AT_ATf] = ACTIONS(431),
    [anon_sym_AT_ATs_COLON] = ACTIONS(431),
    [anon_sym_AT_ATc_COLON] = ACTIONS(431),
    [anon_sym_AT] = ACTIONS(433),
    [anon_sym_AT_BANG] = ACTIONS(431),
    [anon_sym_AT_LBRACE] = ACTIONS(431),
    [anon_sym_ATa_COLON] = ACTIONS(431),
    [anon_sym_ATb_COLON] = ACTIONS(431),
    [anon_sym_ATB_COLON] = ACTIONS(431),
    [anon_sym_ATe_COLON] = ACTIONS(431),
    [anon_sym_ATF_COLON] = ACTIONS(431),
    [anon_sym_ATi_COLON] = ACTIONS(431),
    [anon_sym_ATk_COLON] = ACTIONS(431),
    [anon_sym_ATo_COLON] = ACTIONS(431),
    [anon_sym_ATr_COLON] = ACTIONS(431),
    [anon_sym_ATf_COLON] = ACTIONS(431),
    [anon_sym_ATs_COLON] = ACTIONS(431),
    [anon_sym_ATx_COLON] = ACTIONS(431),
    [anon_sym_PIPE_DOT] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(431),
    [sym_html_redirect_operator] = ACTIONS(433),
    [sym_html_append_operator] = ACTIONS(431),
    [anon_sym_BQUOTE] = ACTIONS(431),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(431),
    [anon_sym_CR] = ACTIONS(431),
    [sym_file_descriptor] = ACTIONS(431),
    [sym__eq_sep_concat] = ACTIONS(435),
  },
  [125] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(135),
    [ts_builtin_sym_end] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_PIPE] = ACTIONS(350),
    [anon_sym_PIPEH] = ACTIONS(348),
    [anon_sym_PIPET] = ACTIONS(348),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_AT_ATr] = ACTIONS(348),
    [anon_sym_AT_AT_ATs] = ACTIONS(350),
    [anon_sym_AT_AT_ATst] = ACTIONS(348),
    [anon_sym_AT_AT_ATS] = ACTIONS(348),
    [anon_sym_AT_AT_ATm] = ACTIONS(348),
    [anon_sym_AT_AT_ATM] = ACTIONS(348),
    [anon_sym_AT_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATF] = ACTIONS(350),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_AT] = ACTIONS(350),
    [anon_sym_AT_ATdbt] = ACTIONS(350),
    [anon_sym_AT_ATdbta] = ACTIONS(348),
    [anon_sym_AT_ATdbtb] = ACTIONS(348),
    [anon_sym_AT_ATdbts] = ACTIONS(348),
    [anon_sym_AT_AT_DOT] = ACTIONS(348),
    [anon_sym_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_ATk] = ACTIONS(348),
    [anon_sym_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_ATiS] = ACTIONS(348),
    [anon_sym_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_ATs_COLON] = ACTIONS(348),
    [anon_sym_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT] = ACTIONS(350),
    [anon_sym_AT_BANG] = ACTIONS(348),
    [anon_sym_AT_LBRACE] = ACTIONS(348),
    [anon_sym_ATa_COLON] = ACTIONS(348),
    [anon_sym_ATb_COLON] = ACTIONS(348),
    [anon_sym_ATB_COLON] = ACTIONS(348),
    [anon_sym_ATe_COLON] = ACTIONS(348),
    [anon_sym_ATF_COLON] = ACTIONS(348),
    [anon_sym_ATi_COLON] = ACTIONS(348),
    [anon_sym_ATk_COLON] = ACTIONS(348),
    [anon_sym_ATo_COLON] = ACTIONS(348),
    [anon_sym_ATr_COLON] = ACTIONS(348),
    [anon_sym_ATf_COLON] = ACTIONS(348),
    [anon_sym_ATs_COLON] = ACTIONS(348),
    [anon_sym_ATx_COLON] = ACTIONS(348),
    [anon_sym_PIPE_DOT] = ACTIONS(348),
    [anon_sym_EQ] = ACTIONS(348),
    [anon_sym_RPAREN] = ACTIONS(348),
    [anon_sym_SEMI] = ACTIONS(348),
    [anon_sym_GT] = ACTIONS(350),
    [anon_sym_GT_GT] = ACTIONS(348),
    [sym_html_redirect_operator] = ACTIONS(350),
    [sym_html_append_operator] = ACTIONS(348),
    [anon_sym_BQUOTE] = ACTIONS(348),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(348),
    [anon_sym_CR] = ACTIONS(348),
    [sym_file_descriptor] = ACTIONS(348),
    [sym__concat_pf_dot] = ACTIONS(348),
  },
  [126] = {
    [aux_sym_tmp_eval_arg_repeat1] = STATE(130),
    [ts_builtin_sym_end] = ACTIONS(438),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_PIPE] = ACTIONS(440),
    [anon_sym_PIPEH] = ACTIONS(438),
    [anon_sym_PIPET] = ACTIONS(438),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(438),
    [anon_sym_AT_AT_ATb] = ACTIONS(438),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(438),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(438),
    [anon_sym_AT_AT_ATi] = ACTIONS(438),
    [anon_sym_AT_AT_ATr] = ACTIONS(438),
    [anon_sym_AT_AT_ATs] = ACTIONS(440),
    [anon_sym_AT_AT_ATst] = ACTIONS(438),
    [anon_sym_AT_AT_ATS] = ACTIONS(438),
    [anon_sym_AT_AT_ATm] = ACTIONS(438),
    [anon_sym_AT_AT_ATM] = ACTIONS(438),
    [anon_sym_AT_AT_ATf] = ACTIONS(440),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(438),
    [anon_sym_AT_AT_ATF] = ACTIONS(440),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(438),
    [anon_sym_AT_AT_ATt] = ACTIONS(438),
    [anon_sym_AT_AT] = ACTIONS(440),
    [anon_sym_AT_ATdbt] = ACTIONS(440),
    [anon_sym_AT_ATdbta] = ACTIONS(438),
    [anon_sym_AT_ATdbtb] = ACTIONS(438),
    [anon_sym_AT_ATdbts] = ACTIONS(438),
    [anon_sym_AT_AT_DOT] = ACTIONS(438),
    [anon_sym_AT_AT_EQ] = ACTIONS(438),
    [anon_sym_AT_ATk] = ACTIONS(438),
    [anon_sym_AT_ATt] = ACTIONS(438),
    [anon_sym_AT_ATb] = ACTIONS(438),
    [anon_sym_AT_ATi] = ACTIONS(440),
    [anon_sym_AT_ATiS] = ACTIONS(438),
    [anon_sym_AT_ATf] = ACTIONS(438),
    [anon_sym_AT_ATs_COLON] = ACTIONS(438),
    [anon_sym_AT_ATc_COLON] = ACTIONS(438),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_AT_BANG] = ACTIONS(438),
    [anon_sym_AT_LBRACE] = ACTIONS(438),
    [anon_sym_ATa_COLON] = ACTIONS(438),
    [anon_sym_ATb_COLON] = ACTIONS(438),
    [anon_sym_ATB_COLON] = ACTIONS(438),
    [anon_sym_ATe_COLON] = ACTIONS(438),
    [anon_sym_ATF_COLON] = ACTIONS(438),
    [anon_sym_ATi_COLON] = ACTIONS(438),
    [anon_sym_ATk_COLON] = ACTIONS(438),
    [anon_sym_ATo_COLON] = ACTIONS(438),
    [anon_sym_ATr_COLON] = ACTIONS(438),
    [anon_sym_ATf_COLON] = ACTIONS(438),
    [anon_sym_ATs_COLON] = ACTIONS(438),
    [anon_sym_ATx_COLON] = ACTIONS(438),
    [anon_sym_PIPE_DOT] = ACTIONS(438),
    [anon_sym_RPAREN] = ACTIONS(438),
    [anon_sym_SEMI] = ACTIONS(438),
    [anon_sym_GT] = ACTIONS(440),
    [anon_sym_GT_GT] = ACTIONS(438),
    [sym_html_redirect_operator] = ACTIONS(440),
    [sym_html_append_operator] = ACTIONS(438),
    [anon_sym_COMMA] = ACTIONS(438),
    [aux_sym_tmp_eval_arg_token1] = ACTIONS(442),
    [anon_sym_BQUOTE] = ACTIONS(438),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(438),
    [anon_sym_CR] = ACTIONS(438),
    [sym_file_descriptor] = ACTIONS(438),
  },
  [127] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(127),
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(444),
  },
  [128] = {
    [aux_sym_concatenation_repeat1] = STATE(136),
    [ts_builtin_sym_end] = ACTIONS(299),
    [anon_sym_TILDE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_PIPEH] = ACTIONS(299),
    [anon_sym_PIPET] = ACTIONS(299),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATi] = ACTIONS(299),
    [anon_sym_AT_AT_ATr] = ACTIONS(299),
    [anon_sym_AT_AT_ATs] = ACTIONS(301),
    [anon_sym_AT_AT_ATst] = ACTIONS(299),
    [anon_sym_AT_AT_ATS] = ACTIONS(299),
    [anon_sym_AT_AT_ATm] = ACTIONS(299),
    [anon_sym_AT_AT_ATM] = ACTIONS(299),
    [anon_sym_AT_AT_ATf] = ACTIONS(301),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATF] = ACTIONS(301),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_AT] = ACTIONS(301),
    [anon_sym_AT_ATdbt] = ACTIONS(301),
    [anon_sym_AT_ATdbta] = ACTIONS(299),
    [anon_sym_AT_ATdbtb] = ACTIONS(299),
    [anon_sym_AT_ATdbts] = ACTIONS(299),
    [anon_sym_AT_AT_DOT] = ACTIONS(299),
    [anon_sym_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_ATk] = ACTIONS(299),
    [anon_sym_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_ATi] = ACTIONS(301),
    [anon_sym_AT_ATiS] = ACTIONS(299),
    [anon_sym_AT_ATf] = ACTIONS(299),
    [anon_sym_AT_ATs_COLON] = ACTIONS(299),
    [anon_sym_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_AT_BANG] = ACTIONS(299),
    [anon_sym_AT_LBRACE] = ACTIONS(299),
    [anon_sym_ATa_COLON] = ACTIONS(299),
    [anon_sym_ATb_COLON] = ACTIONS(299),
    [anon_sym_ATB_COLON] = ACTIONS(299),
    [anon_sym_ATe_COLON] = ACTIONS(299),
    [anon_sym_ATF_COLON] = ACTIONS(299),
    [anon_sym_ATi_COLON] = ACTIONS(299),
    [anon_sym_ATk_COLON] = ACTIONS(299),
    [anon_sym_ATo_COLON] = ACTIONS(299),
    [anon_sym_ATr_COLON] = ACTIONS(299),
    [anon_sym_ATf_COLON] = ACTIONS(299),
    [anon_sym_ATs_COLON] = ACTIONS(299),
    [anon_sym_ATx_COLON] = ACTIONS(299),
    [anon_sym_PIPE_DOT] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(299),
    [sym_html_redirect_operator] = ACTIONS(301),
    [sym_html_append_operator] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(299),
    [anon_sym_CR] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(299),
    [sym__eq_sep_concat] = ACTIONS(299),
    [sym__concat] = ACTIONS(447),
  },
  [129] = {
    [aux_sym_eq_sep_key_repeat1] = STATE(132),
    [ts_builtin_sym_end] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PIPEH] = ACTIONS(449),
    [anon_sym_PIPET] = ACTIONS(449),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(449),
    [anon_sym_AT_AT_ATb] = ACTIONS(449),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(449),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(449),
    [anon_sym_AT_AT_ATi] = ACTIONS(449),
    [anon_sym_AT_AT_ATr] = ACTIONS(449),
    [anon_sym_AT_AT_ATs] = ACTIONS(451),
    [anon_sym_AT_AT_ATst] = ACTIONS(449),
    [anon_sym_AT_AT_ATS] = ACTIONS(449),
    [anon_sym_AT_AT_ATm] = ACTIONS(449),
    [anon_sym_AT_AT_ATM] = ACTIONS(449),
    [anon_sym_AT_AT_ATf] = ACTIONS(451),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(449),
    [anon_sym_AT_AT_ATF] = ACTIONS(451),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(449),
    [anon_sym_AT_AT_ATt] = ACTIONS(449),
    [anon_sym_AT_AT] = ACTIONS(451),
    [anon_sym_AT_ATdbt] = ACTIONS(451),
    [anon_sym_AT_ATdbta] = ACTIONS(449),
    [anon_sym_AT_ATdbtb] = ACTIONS(449),
    [anon_sym_AT_ATdbts] = ACTIONS(449),
    [anon_sym_AT_AT_DOT] = ACTIONS(449),
    [anon_sym_AT_AT_EQ] = ACTIONS(449),
    [anon_sym_AT_ATk] = ACTIONS(449),
    [anon_sym_AT_ATt] = ACTIONS(449),
    [anon_sym_AT_ATb] = ACTIONS(449),
    [anon_sym_AT_ATi] = ACTIONS(451),
    [anon_sym_AT_ATiS] = ACTIONS(449),
    [anon_sym_AT_ATf] = ACTIONS(449),
    [anon_sym_AT_ATs_COLON] = ACTIONS(449),
    [anon_sym_AT_ATc_COLON] = ACTIONS(449),
    [anon_sym_AT] = ACTIONS(451),
    [anon_sym_AT_BANG] = ACTIONS(449),
    [anon_sym_AT_LBRACE] = ACTIONS(449),
    [anon_sym_ATa_COLON] = ACTIONS(449),
    [anon_sym_ATb_COLON] = ACTIONS(449),
    [anon_sym_ATB_COLON] = ACTIONS(449),
    [anon_sym_ATe_COLON] = ACTIONS(449),
    [anon_sym_ATF_COLON] = ACTIONS(449),
    [anon_sym_ATi_COLON] = ACTIONS(449),
    [anon_sym_ATk_COLON] = ACTIONS(449),
    [anon_sym_ATo_COLON] = ACTIONS(449),
    [anon_sym_ATr_COLON] = ACTIONS(449),
    [anon_sym_ATf_COLON] = ACTIONS(449),
    [anon_sym_ATs_COLON] = ACTIONS(449),
    [anon_sym_ATx_COLON] = ACTIONS(449),
    [anon_sym_PIPE_DOT] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(449),
    [anon_sym_RPAREN] = ACTIONS(449),
    [anon_sym_SEMI] = ACTIONS(449),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_GT_GT] = ACTIONS(449),
    [sym_html_redirect_operator] = ACTIONS(451),
    [sym_html_append_operator] = ACTIONS(449),
    [anon_sym_BQUOTE] = ACTIONS(449),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(449),
    [anon_sym_CR] = ACTIONS(449),
    [sym_file_descriptor] = ACTIONS(449),
    [sym__eq_sep_concat] = ACTIONS(453),
  },
  [130] = {
    [aux_sym_tmp_eval_arg_repeat1] = STATE(130),
    [ts_builtin_sym_end] = ACTIONS(455),
    [anon_sym_TILDE] = ACTIONS(455),
    [anon_sym_PIPE] = ACTIONS(457),
    [anon_sym_PIPEH] = ACTIONS(455),
    [anon_sym_PIPET] = ACTIONS(455),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(455),
    [anon_sym_AT_AT_ATb] = ACTIONS(455),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(455),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(455),
    [anon_sym_AT_AT_ATi] = ACTIONS(455),
    [anon_sym_AT_AT_ATr] = ACTIONS(455),
    [anon_sym_AT_AT_ATs] = ACTIONS(457),
    [anon_sym_AT_AT_ATst] = ACTIONS(455),
    [anon_sym_AT_AT_ATS] = ACTIONS(455),
    [anon_sym_AT_AT_ATm] = ACTIONS(455),
    [anon_sym_AT_AT_ATM] = ACTIONS(455),
    [anon_sym_AT_AT_ATf] = ACTIONS(457),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(455),
    [anon_sym_AT_AT_ATF] = ACTIONS(457),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(455),
    [anon_sym_AT_AT_ATt] = ACTIONS(455),
    [anon_sym_AT_AT] = ACTIONS(457),
    [anon_sym_AT_ATdbt] = ACTIONS(457),
    [anon_sym_AT_ATdbta] = ACTIONS(455),
    [anon_sym_AT_ATdbtb] = ACTIONS(455),
    [anon_sym_AT_ATdbts] = ACTIONS(455),
    [anon_sym_AT_AT_DOT] = ACTIONS(455),
    [anon_sym_AT_AT_EQ] = ACTIONS(455),
    [anon_sym_AT_ATk] = ACTIONS(455),
    [anon_sym_AT_ATt] = ACTIONS(455),
    [anon_sym_AT_ATb] = ACTIONS(455),
    [anon_sym_AT_ATi] = ACTIONS(457),
    [anon_sym_AT_ATiS] = ACTIONS(455),
    [anon_sym_AT_ATf] = ACTIONS(455),
    [anon_sym_AT_ATs_COLON] = ACTIONS(455),
    [anon_sym_AT_ATc_COLON] = ACTIONS(455),
    [anon_sym_AT] = ACTIONS(457),
    [anon_sym_AT_BANG] = ACTIONS(455),
    [anon_sym_AT_LBRACE] = ACTIONS(455),
    [anon_sym_ATa_COLON] = ACTIONS(455),
    [anon_sym_ATb_COLON] = ACTIONS(455),
    [anon_sym_ATB_COLON] = ACTIONS(455),
    [anon_sym_ATe_COLON] = ACTIONS(455),
    [anon_sym_ATF_COLON] = ACTIONS(455),
    [anon_sym_ATi_COLON] = ACTIONS(455),
    [anon_sym_ATk_COLON] = ACTIONS(455),
    [anon_sym_ATo_COLON] = ACTIONS(455),
    [anon_sym_ATr_COLON] = ACTIONS(455),
    [anon_sym_ATf_COLON] = ACTIONS(455),
    [anon_sym_ATs_COLON] = ACTIONS(455),
    [anon_sym_ATx_COLON] = ACTIONS(455),
    [anon_sym_PIPE_DOT] = ACTIONS(455),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_SEMI] = ACTIONS(455),
    [anon_sym_GT] = ACTIONS(457),
    [anon_sym_GT_GT] = ACTIONS(455),
    [sym_html_redirect_operator] = ACTIONS(457),
    [sym_html_append_operator] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(455),
    [aux_sym_tmp_eval_arg_token1] = ACTIONS(459),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(455),
    [anon_sym_CR] = ACTIONS(455),
    [sym_file_descriptor] = ACTIONS(455),
  },
  [131] = {
    [aux_sym_pf_dot_args_repeat1] = STATE(131),
    [ts_builtin_sym_end] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(462),
    [anon_sym_PIPE] = ACTIONS(464),
    [anon_sym_PIPEH] = ACTIONS(462),
    [anon_sym_PIPET] = ACTIONS(462),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(462),
    [anon_sym_AT_AT_ATb] = ACTIONS(462),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATi] = ACTIONS(462),
    [anon_sym_AT_AT_ATr] = ACTIONS(462),
    [anon_sym_AT_AT_ATs] = ACTIONS(464),
    [anon_sym_AT_AT_ATst] = ACTIONS(462),
    [anon_sym_AT_AT_ATS] = ACTIONS(462),
    [anon_sym_AT_AT_ATm] = ACTIONS(462),
    [anon_sym_AT_AT_ATM] = ACTIONS(462),
    [anon_sym_AT_AT_ATf] = ACTIONS(464),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATF] = ACTIONS(464),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATt] = ACTIONS(462),
    [anon_sym_AT_AT] = ACTIONS(464),
    [anon_sym_AT_ATdbt] = ACTIONS(464),
    [anon_sym_AT_ATdbta] = ACTIONS(462),
    [anon_sym_AT_ATdbtb] = ACTIONS(462),
    [anon_sym_AT_ATdbts] = ACTIONS(462),
    [anon_sym_AT_AT_DOT] = ACTIONS(462),
    [anon_sym_AT_AT_EQ] = ACTIONS(462),
    [anon_sym_AT_ATk] = ACTIONS(462),
    [anon_sym_AT_ATt] = ACTIONS(462),
    [anon_sym_AT_ATb] = ACTIONS(462),
    [anon_sym_AT_ATi] = ACTIONS(464),
    [anon_sym_AT_ATiS] = ACTIONS(462),
    [anon_sym_AT_ATf] = ACTIONS(462),
    [anon_sym_AT_ATs_COLON] = ACTIONS(462),
    [anon_sym_AT_ATc_COLON] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_AT_BANG] = ACTIONS(462),
    [anon_sym_AT_LBRACE] = ACTIONS(462),
    [anon_sym_ATa_COLON] = ACTIONS(462),
    [anon_sym_ATb_COLON] = ACTIONS(462),
    [anon_sym_ATB_COLON] = ACTIONS(462),
    [anon_sym_ATe_COLON] = ACTIONS(462),
    [anon_sym_ATF_COLON] = ACTIONS(462),
    [anon_sym_ATi_COLON] = ACTIONS(462),
    [anon_sym_ATk_COLON] = ACTIONS(462),
    [anon_sym_ATo_COLON] = ACTIONS(462),
    [anon_sym_ATr_COLON] = ACTIONS(462),
    [anon_sym_ATf_COLON] = ACTIONS(462),
    [anon_sym_ATs_COLON] = ACTIONS(462),
    [anon_sym_ATx_COLON] = ACTIONS(462),
    [anon_sym_PIPE_DOT] = ACTIONS(462),
    [anon_sym_EQ] = ACTIONS(462),
    [anon_sym_RPAREN] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(464),
    [anon_sym_GT_GT] = ACTIONS(462),
    [sym_html_redirect_operator] = ACTIONS(464),
    [sym_html_append_operator] = ACTIONS(462),
    [anon_sym_BQUOTE] = ACTIONS(462),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(462),
    [anon_sym_CR] = ACTIONS(462),
    [sym_file_descriptor] = ACTIONS(462),
    [sym__concat_pf_dot] = ACTIONS(466),
  },
  [132] = {
    [aux_sym_eq_sep_key_repeat1] = STATE(124),
    [ts_builtin_sym_end] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(471),
    [anon_sym_PIPEH] = ACTIONS(469),
    [anon_sym_PIPET] = ACTIONS(469),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(469),
    [anon_sym_AT_AT_ATb] = ACTIONS(469),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(469),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(469),
    [anon_sym_AT_AT_ATi] = ACTIONS(469),
    [anon_sym_AT_AT_ATr] = ACTIONS(469),
    [anon_sym_AT_AT_ATs] = ACTIONS(471),
    [anon_sym_AT_AT_ATst] = ACTIONS(469),
    [anon_sym_AT_AT_ATS] = ACTIONS(469),
    [anon_sym_AT_AT_ATm] = ACTIONS(469),
    [anon_sym_AT_AT_ATM] = ACTIONS(469),
    [anon_sym_AT_AT_ATf] = ACTIONS(471),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(469),
    [anon_sym_AT_AT_ATF] = ACTIONS(471),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(469),
    [anon_sym_AT_AT_ATt] = ACTIONS(469),
    [anon_sym_AT_AT] = ACTIONS(471),
    [anon_sym_AT_ATdbt] = ACTIONS(471),
    [anon_sym_AT_ATdbta] = ACTIONS(469),
    [anon_sym_AT_ATdbtb] = ACTIONS(469),
    [anon_sym_AT_ATdbts] = ACTIONS(469),
    [anon_sym_AT_AT_DOT] = ACTIONS(469),
    [anon_sym_AT_AT_EQ] = ACTIONS(469),
    [anon_sym_AT_ATk] = ACTIONS(469),
    [anon_sym_AT_ATt] = ACTIONS(469),
    [anon_sym_AT_ATb] = ACTIONS(469),
    [anon_sym_AT_ATi] = ACTIONS(471),
    [anon_sym_AT_ATiS] = ACTIONS(469),
    [anon_sym_AT_ATf] = ACTIONS(469),
    [anon_sym_AT_ATs_COLON] = ACTIONS(469),
    [anon_sym_AT_ATc_COLON] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(471),
    [anon_sym_AT_BANG] = ACTIONS(469),
    [anon_sym_AT_LBRACE] = ACTIONS(469),
    [anon_sym_ATa_COLON] = ACTIONS(469),
    [anon_sym_ATb_COLON] = ACTIONS(469),
    [anon_sym_ATB_COLON] = ACTIONS(469),
    [anon_sym_ATe_COLON] = ACTIONS(469),
    [anon_sym_ATF_COLON] = ACTIONS(469),
    [anon_sym_ATi_COLON] = ACTIONS(469),
    [anon_sym_ATk_COLON] = ACTIONS(469),
    [anon_sym_ATo_COLON] = ACTIONS(469),
    [anon_sym_ATr_COLON] = ACTIONS(469),
    [anon_sym_ATf_COLON] = ACTIONS(469),
    [anon_sym_ATs_COLON] = ACTIONS(469),
    [anon_sym_ATx_COLON] = ACTIONS(469),
    [anon_sym_PIPE_DOT] = ACTIONS(469),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_RPAREN] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(471),
    [anon_sym_GT_GT] = ACTIONS(469),
    [sym_html_redirect_operator] = ACTIONS(471),
    [sym_html_append_operator] = ACTIONS(469),
    [anon_sym_BQUOTE] = ACTIONS(469),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(469),
    [anon_sym_CR] = ACTIONS(469),
    [sym_file_descriptor] = ACTIONS(469),
    [sym__eq_sep_concat] = ACTIONS(453),
  },
  [133] = {
    [aux_sym_concatenation_repeat1] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(305),
    [anon_sym_TILDE] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(307),
    [anon_sym_PIPEH] = ACTIONS(305),
    [anon_sym_PIPET] = ACTIONS(305),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATi] = ACTIONS(305),
    [anon_sym_AT_AT_ATr] = ACTIONS(305),
    [anon_sym_AT_AT_ATs] = ACTIONS(307),
    [anon_sym_AT_AT_ATst] = ACTIONS(305),
    [anon_sym_AT_AT_ATS] = ACTIONS(305),
    [anon_sym_AT_AT_ATm] = ACTIONS(305),
    [anon_sym_AT_AT_ATM] = ACTIONS(305),
    [anon_sym_AT_AT_ATf] = ACTIONS(307),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATF] = ACTIONS(307),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_AT] = ACTIONS(307),
    [anon_sym_AT_ATdbt] = ACTIONS(307),
    [anon_sym_AT_ATdbta] = ACTIONS(305),
    [anon_sym_AT_ATdbtb] = ACTIONS(305),
    [anon_sym_AT_ATdbts] = ACTIONS(305),
    [anon_sym_AT_AT_DOT] = ACTIONS(305),
    [anon_sym_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_ATk] = ACTIONS(305),
    [anon_sym_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_ATi] = ACTIONS(307),
    [anon_sym_AT_ATiS] = ACTIONS(305),
    [anon_sym_AT_ATf] = ACTIONS(305),
    [anon_sym_AT_ATs_COLON] = ACTIONS(305),
    [anon_sym_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(307),
    [anon_sym_AT_BANG] = ACTIONS(305),
    [anon_sym_AT_LBRACE] = ACTIONS(305),
    [anon_sym_ATa_COLON] = ACTIONS(305),
    [anon_sym_ATb_COLON] = ACTIONS(305),
    [anon_sym_ATB_COLON] = ACTIONS(305),
    [anon_sym_ATe_COLON] = ACTIONS(305),
    [anon_sym_ATF_COLON] = ACTIONS(305),
    [anon_sym_ATi_COLON] = ACTIONS(305),
    [anon_sym_ATk_COLON] = ACTIONS(305),
    [anon_sym_ATo_COLON] = ACTIONS(305),
    [anon_sym_ATr_COLON] = ACTIONS(305),
    [anon_sym_ATf_COLON] = ACTIONS(305),
    [anon_sym_ATs_COLON] = ACTIONS(305),
    [anon_sym_ATx_COLON] = ACTIONS(305),
    [anon_sym_PIPE_DOT] = ACTIONS(305),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_SEMI] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(305),
    [sym_html_redirect_operator] = ACTIONS(307),
    [sym_html_append_operator] = ACTIONS(305),
    [anon_sym_BQUOTE] = ACTIONS(305),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(305),
    [anon_sym_CR] = ACTIONS(305),
    [sym_file_descriptor] = ACTIONS(305),
    [sym__eq_sep_concat] = ACTIONS(305),
    [sym__concat] = ACTIONS(473),
  },
  [134] = {
    [aux_sym_pf_dot_args_repeat1] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(251),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_PIPEH] = ACTIONS(251),
    [anon_sym_PIPET] = ACTIONS(251),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(251),
    [anon_sym_AT_AT_ATb] = ACTIONS(251),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATi] = ACTIONS(251),
    [anon_sym_AT_AT_ATr] = ACTIONS(251),
    [anon_sym_AT_AT_ATs] = ACTIONS(253),
    [anon_sym_AT_AT_ATst] = ACTIONS(251),
    [anon_sym_AT_AT_ATS] = ACTIONS(251),
    [anon_sym_AT_AT_ATm] = ACTIONS(251),
    [anon_sym_AT_AT_ATM] = ACTIONS(251),
    [anon_sym_AT_AT_ATf] = ACTIONS(253),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATF] = ACTIONS(253),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(251),
    [anon_sym_AT_AT_ATt] = ACTIONS(251),
    [anon_sym_AT_AT] = ACTIONS(253),
    [anon_sym_AT_ATdbt] = ACTIONS(253),
    [anon_sym_AT_ATdbta] = ACTIONS(251),
    [anon_sym_AT_ATdbtb] = ACTIONS(251),
    [anon_sym_AT_ATdbts] = ACTIONS(251),
    [anon_sym_AT_AT_DOT] = ACTIONS(251),
    [anon_sym_AT_AT_EQ] = ACTIONS(251),
    [anon_sym_AT_ATk] = ACTIONS(251),
    [anon_sym_AT_ATt] = ACTIONS(251),
    [anon_sym_AT_ATb] = ACTIONS(251),
    [anon_sym_AT_ATi] = ACTIONS(253),
    [anon_sym_AT_ATiS] = ACTIONS(251),
    [anon_sym_AT_ATf] = ACTIONS(251),
    [anon_sym_AT_ATs_COLON] = ACTIONS(251),
    [anon_sym_AT_ATc_COLON] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_AT_BANG] = ACTIONS(251),
    [anon_sym_AT_LBRACE] = ACTIONS(251),
    [anon_sym_ATa_COLON] = ACTIONS(251),
    [anon_sym_ATb_COLON] = ACTIONS(251),
    [anon_sym_ATB_COLON] = ACTIONS(251),
    [anon_sym_ATe_COLON] = ACTIONS(251),
    [anon_sym_ATF_COLON] = ACTIONS(251),
    [anon_sym_ATi_COLON] = ACTIONS(251),
    [anon_sym_ATk_COLON] = ACTIONS(251),
    [anon_sym_ATo_COLON] = ACTIONS(251),
    [anon_sym_ATr_COLON] = ACTIONS(251),
    [anon_sym_ATf_COLON] = ACTIONS(251),
    [anon_sym_ATs_COLON] = ACTIONS(251),
    [anon_sym_ATx_COLON] = ACTIONS(251),
    [anon_sym_PIPE_DOT] = ACTIONS(251),
    [anon_sym_EQ] = ACTIONS(251),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_GT_GT] = ACTIONS(251),
    [sym_html_redirect_operator] = ACTIONS(253),
    [sym_html_append_operator] = ACTIONS(251),
    [anon_sym_BQUOTE] = ACTIONS(251),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(251),
    [anon_sym_CR] = ACTIONS(251),
    [sym_file_descriptor] = ACTIONS(251),
    [sym__concat_pf_dot] = ACTIONS(263),
  },
  [135] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(127),
    [ts_builtin_sym_end] = ACTIONS(352),
    [anon_sym_TILDE] = ACTIONS(352),
    [anon_sym_PIPE] = ACTIONS(354),
    [anon_sym_PIPEH] = ACTIONS(352),
    [anon_sym_PIPET] = ACTIONS(352),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_AT_ATr] = ACTIONS(352),
    [anon_sym_AT_AT_ATs] = ACTIONS(354),
    [anon_sym_AT_AT_ATst] = ACTIONS(352),
    [anon_sym_AT_AT_ATS] = ACTIONS(352),
    [anon_sym_AT_AT_ATm] = ACTIONS(352),
    [anon_sym_AT_AT_ATM] = ACTIONS(352),
    [anon_sym_AT_AT_ATf] = ACTIONS(354),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATF] = ACTIONS(354),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_AT] = ACTIONS(354),
    [anon_sym_AT_ATdbt] = ACTIONS(354),
    [anon_sym_AT_ATdbta] = ACTIONS(352),
    [anon_sym_AT_ATdbtb] = ACTIONS(352),
    [anon_sym_AT_ATdbts] = ACTIONS(352),
    [anon_sym_AT_AT_DOT] = ACTIONS(352),
    [anon_sym_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_ATk] = ACTIONS(352),
    [anon_sym_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_ATi] = ACTIONS(354),
    [anon_sym_AT_ATiS] = ACTIONS(352),
    [anon_sym_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_ATs_COLON] = ACTIONS(352),
    [anon_sym_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(354),
    [anon_sym_AT_BANG] = ACTIONS(352),
    [anon_sym_AT_LBRACE] = ACTIONS(352),
    [anon_sym_ATa_COLON] = ACTIONS(352),
    [anon_sym_ATb_COLON] = ACTIONS(352),
    [anon_sym_ATB_COLON] = ACTIONS(352),
    [anon_sym_ATe_COLON] = ACTIONS(352),
    [anon_sym_ATF_COLON] = ACTIONS(352),
    [anon_sym_ATi_COLON] = ACTIONS(352),
    [anon_sym_ATk_COLON] = ACTIONS(352),
    [anon_sym_ATo_COLON] = ACTIONS(352),
    [anon_sym_ATr_COLON] = ACTIONS(352),
    [anon_sym_ATf_COLON] = ACTIONS(352),
    [anon_sym_ATs_COLON] = ACTIONS(352),
    [anon_sym_ATx_COLON] = ACTIONS(352),
    [anon_sym_PIPE_DOT] = ACTIONS(352),
    [anon_sym_EQ] = ACTIONS(352),
    [anon_sym_RPAREN] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(354),
    [anon_sym_GT_GT] = ACTIONS(352),
    [sym_html_redirect_operator] = ACTIONS(354),
    [sym_html_append_operator] = ACTIONS(352),
    [anon_sym_BQUOTE] = ACTIONS(352),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(352),
    [anon_sym_CR] = ACTIONS(352),
    [sym_file_descriptor] = ACTIONS(352),
    [sym__concat_pf_dot] = ACTIONS(476),
  },
  [136] = {
    [aux_sym_concatenation_repeat1] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(312),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(314),
    [anon_sym_PIPEH] = ACTIONS(312),
    [anon_sym_PIPET] = ACTIONS(312),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(312),
    [anon_sym_AT_AT_ATb] = ACTIONS(312),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATi] = ACTIONS(312),
    [anon_sym_AT_AT_ATr] = ACTIONS(312),
    [anon_sym_AT_AT_ATs] = ACTIONS(314),
    [anon_sym_AT_AT_ATst] = ACTIONS(312),
    [anon_sym_AT_AT_ATS] = ACTIONS(312),
    [anon_sym_AT_AT_ATm] = ACTIONS(312),
    [anon_sym_AT_AT_ATM] = ACTIONS(312),
    [anon_sym_AT_AT_ATf] = ACTIONS(314),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATF] = ACTIONS(314),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATt] = ACTIONS(312),
    [anon_sym_AT_AT] = ACTIONS(314),
    [anon_sym_AT_ATdbt] = ACTIONS(314),
    [anon_sym_AT_ATdbta] = ACTIONS(312),
    [anon_sym_AT_ATdbtb] = ACTIONS(312),
    [anon_sym_AT_ATdbts] = ACTIONS(312),
    [anon_sym_AT_AT_DOT] = ACTIONS(312),
    [anon_sym_AT_AT_EQ] = ACTIONS(312),
    [anon_sym_AT_ATk] = ACTIONS(312),
    [anon_sym_AT_ATt] = ACTIONS(312),
    [anon_sym_AT_ATb] = ACTIONS(312),
    [anon_sym_AT_ATi] = ACTIONS(314),
    [anon_sym_AT_ATiS] = ACTIONS(312),
    [anon_sym_AT_ATf] = ACTIONS(312),
    [anon_sym_AT_ATs_COLON] = ACTIONS(312),
    [anon_sym_AT_ATc_COLON] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_AT_BANG] = ACTIONS(312),
    [anon_sym_AT_LBRACE] = ACTIONS(312),
    [anon_sym_ATa_COLON] = ACTIONS(312),
    [anon_sym_ATb_COLON] = ACTIONS(312),
    [anon_sym_ATB_COLON] = ACTIONS(312),
    [anon_sym_ATe_COLON] = ACTIONS(312),
    [anon_sym_ATF_COLON] = ACTIONS(312),
    [anon_sym_ATi_COLON] = ACTIONS(312),
    [anon_sym_ATk_COLON] = ACTIONS(312),
    [anon_sym_ATo_COLON] = ACTIONS(312),
    [anon_sym_ATr_COLON] = ACTIONS(312),
    [anon_sym_ATf_COLON] = ACTIONS(312),
    [anon_sym_ATs_COLON] = ACTIONS(312),
    [anon_sym_ATx_COLON] = ACTIONS(312),
    [anon_sym_PIPE_DOT] = ACTIONS(312),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_SEMI] = ACTIONS(312),
    [anon_sym_GT] = ACTIONS(314),
    [anon_sym_GT_GT] = ACTIONS(312),
    [sym_html_redirect_operator] = ACTIONS(314),
    [sym_html_append_operator] = ACTIONS(312),
    [anon_sym_BQUOTE] = ACTIONS(312),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(312),
    [anon_sym_CR] = ACTIONS(312),
    [sym_file_descriptor] = ACTIONS(312),
    [sym__eq_sep_concat] = ACTIONS(312),
    [sym__concat] = ACTIONS(447),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_PIPEH] = ACTIONS(328),
    [anon_sym_PIPET] = ACTIONS(328),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(328),
    [anon_sym_AT_AT_ATb] = ACTIONS(328),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATi] = ACTIONS(328),
    [anon_sym_AT_AT_ATr] = ACTIONS(328),
    [anon_sym_AT_AT_ATs] = ACTIONS(330),
    [anon_sym_AT_AT_ATst] = ACTIONS(328),
    [anon_sym_AT_AT_ATS] = ACTIONS(328),
    [anon_sym_AT_AT_ATm] = ACTIONS(328),
    [anon_sym_AT_AT_ATM] = ACTIONS(328),
    [anon_sym_AT_AT_ATf] = ACTIONS(330),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATF] = ACTIONS(330),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATt] = ACTIONS(328),
    [anon_sym_AT_AT] = ACTIONS(330),
    [anon_sym_AT_ATdbt] = ACTIONS(330),
    [anon_sym_AT_ATdbta] = ACTIONS(328),
    [anon_sym_AT_ATdbtb] = ACTIONS(328),
    [anon_sym_AT_ATdbts] = ACTIONS(328),
    [anon_sym_AT_AT_DOT] = ACTIONS(328),
    [anon_sym_AT_AT_EQ] = ACTIONS(328),
    [anon_sym_AT_ATk] = ACTIONS(328),
    [anon_sym_AT_ATt] = ACTIONS(328),
    [anon_sym_AT_ATb] = ACTIONS(328),
    [anon_sym_AT_ATi] = ACTIONS(330),
    [anon_sym_AT_ATiS] = ACTIONS(328),
    [anon_sym_AT_ATf] = ACTIONS(328),
    [anon_sym_AT_ATs_COLON] = ACTIONS(328),
    [anon_sym_AT_ATc_COLON] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(330),
    [anon_sym_AT_BANG] = ACTIONS(328),
    [anon_sym_AT_LBRACE] = ACTIONS(328),
    [anon_sym_ATa_COLON] = ACTIONS(328),
    [anon_sym_ATb_COLON] = ACTIONS(328),
    [anon_sym_ATB_COLON] = ACTIONS(328),
    [anon_sym_ATe_COLON] = ACTIONS(328),
    [anon_sym_ATF_COLON] = ACTIONS(328),
    [anon_sym_ATi_COLON] = ACTIONS(328),
    [anon_sym_ATk_COLON] = ACTIONS(328),
    [anon_sym_ATo_COLON] = ACTIONS(328),
    [anon_sym_ATr_COLON] = ACTIONS(328),
    [anon_sym_ATf_COLON] = ACTIONS(328),
    [anon_sym_ATs_COLON] = ACTIONS(328),
    [anon_sym_ATx_COLON] = ACTIONS(328),
    [anon_sym_PIPE_DOT] = ACTIONS(328),
    [anon_sym_EQ] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_GT] = ACTIONS(330),
    [anon_sym_GT_GT] = ACTIONS(328),
    [sym_html_redirect_operator] = ACTIONS(330),
    [sym_html_append_operator] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(328),
    [anon_sym_CR] = ACTIONS(328),
    [sym_file_descriptor] = ACTIONS(328),
    [sym__eq_sep_concat] = ACTIONS(328),
  },
  [138] = {
    [aux_sym_eq_sep_val_repeat1] = STATE(164),
    [ts_builtin_sym_end] = ACTIONS(478),
    [anon_sym_TILDE] = ACTIONS(478),
    [anon_sym_PIPE] = ACTIONS(480),
    [anon_sym_PIPEH] = ACTIONS(478),
    [anon_sym_PIPET] = ACTIONS(478),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(478),
    [anon_sym_AT_AT_ATb] = ACTIONS(478),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATi] = ACTIONS(478),
    [anon_sym_AT_AT_ATr] = ACTIONS(478),
    [anon_sym_AT_AT_ATs] = ACTIONS(480),
    [anon_sym_AT_AT_ATst] = ACTIONS(478),
    [anon_sym_AT_AT_ATS] = ACTIONS(478),
    [anon_sym_AT_AT_ATm] = ACTIONS(478),
    [anon_sym_AT_AT_ATM] = ACTIONS(478),
    [anon_sym_AT_AT_ATf] = ACTIONS(480),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATF] = ACTIONS(480),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATt] = ACTIONS(478),
    [anon_sym_AT_AT] = ACTIONS(480),
    [anon_sym_AT_ATdbt] = ACTIONS(480),
    [anon_sym_AT_ATdbta] = ACTIONS(478),
    [anon_sym_AT_ATdbtb] = ACTIONS(478),
    [anon_sym_AT_ATdbts] = ACTIONS(478),
    [anon_sym_AT_AT_DOT] = ACTIONS(478),
    [anon_sym_AT_AT_EQ] = ACTIONS(478),
    [anon_sym_AT_ATk] = ACTIONS(478),
    [anon_sym_AT_ATt] = ACTIONS(478),
    [anon_sym_AT_ATb] = ACTIONS(478),
    [anon_sym_AT_ATi] = ACTIONS(480),
    [anon_sym_AT_ATiS] = ACTIONS(478),
    [anon_sym_AT_ATf] = ACTIONS(478),
    [anon_sym_AT_ATs_COLON] = ACTIONS(478),
    [anon_sym_AT_ATc_COLON] = ACTIONS(478),
    [anon_sym_AT] = ACTIONS(480),
    [anon_sym_AT_BANG] = ACTIONS(478),
    [anon_sym_AT_LBRACE] = ACTIONS(478),
    [anon_sym_ATa_COLON] = ACTIONS(478),
    [anon_sym_ATb_COLON] = ACTIONS(478),
    [anon_sym_ATB_COLON] = ACTIONS(478),
    [anon_sym_ATe_COLON] = ACTIONS(478),
    [anon_sym_ATF_COLON] = ACTIONS(478),
    [anon_sym_ATi_COLON] = ACTIONS(478),
    [anon_sym_ATk_COLON] = ACTIONS(478),
    [anon_sym_ATo_COLON] = ACTIONS(478),
    [anon_sym_ATr_COLON] = ACTIONS(478),
    [anon_sym_ATf_COLON] = ACTIONS(478),
    [anon_sym_ATs_COLON] = ACTIONS(478),
    [anon_sym_ATx_COLON] = ACTIONS(478),
    [anon_sym_PIPE_DOT] = ACTIONS(478),
    [anon_sym_RPAREN] = ACTIONS(478),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_GT] = ACTIONS(480),
    [anon_sym_GT_GT] = ACTIONS(478),
    [sym_html_redirect_operator] = ACTIONS(480),
    [sym_html_append_operator] = ACTIONS(478),
    [anon_sym_BQUOTE] = ACTIONS(478),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(478),
    [anon_sym_CR] = ACTIONS(478),
    [sym_file_descriptor] = ACTIONS(478),
    [sym__eq_sep_concat] = ACTIONS(482),
  },
  [139] = {
    [aux_sym_concatenation_repeat1] = STATE(139),
    [ts_builtin_sym_end] = ACTIONS(305),
    [anon_sym_TILDE] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(307),
    [anon_sym_PIPEH] = ACTIONS(305),
    [anon_sym_PIPET] = ACTIONS(305),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATi] = ACTIONS(305),
    [anon_sym_AT_AT_ATr] = ACTIONS(305),
    [anon_sym_AT_AT_ATs] = ACTIONS(307),
    [anon_sym_AT_AT_ATst] = ACTIONS(305),
    [anon_sym_AT_AT_ATS] = ACTIONS(305),
    [anon_sym_AT_AT_ATm] = ACTIONS(305),
    [anon_sym_AT_AT_ATM] = ACTIONS(305),
    [anon_sym_AT_AT_ATf] = ACTIONS(307),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATF] = ACTIONS(307),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_AT] = ACTIONS(307),
    [anon_sym_AT_ATdbt] = ACTIONS(307),
    [anon_sym_AT_ATdbta] = ACTIONS(305),
    [anon_sym_AT_ATdbtb] = ACTIONS(305),
    [anon_sym_AT_ATdbts] = ACTIONS(305),
    [anon_sym_AT_AT_DOT] = ACTIONS(305),
    [anon_sym_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_ATk] = ACTIONS(305),
    [anon_sym_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_ATi] = ACTIONS(307),
    [anon_sym_AT_ATiS] = ACTIONS(305),
    [anon_sym_AT_ATf] = ACTIONS(305),
    [anon_sym_AT_ATs_COLON] = ACTIONS(305),
    [anon_sym_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(307),
    [anon_sym_AT_BANG] = ACTIONS(305),
    [anon_sym_AT_LBRACE] = ACTIONS(305),
    [anon_sym_ATa_COLON] = ACTIONS(305),
    [anon_sym_ATb_COLON] = ACTIONS(305),
    [anon_sym_ATB_COLON] = ACTIONS(305),
    [anon_sym_ATe_COLON] = ACTIONS(305),
    [anon_sym_ATF_COLON] = ACTIONS(305),
    [anon_sym_ATi_COLON] = ACTIONS(305),
    [anon_sym_ATk_COLON] = ACTIONS(305),
    [anon_sym_ATo_COLON] = ACTIONS(305),
    [anon_sym_ATr_COLON] = ACTIONS(305),
    [anon_sym_ATf_COLON] = ACTIONS(305),
    [anon_sym_ATs_COLON] = ACTIONS(305),
    [anon_sym_ATx_COLON] = ACTIONS(305),
    [anon_sym_PIPE_DOT] = ACTIONS(305),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_SEMI] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(305),
    [sym_html_redirect_operator] = ACTIONS(307),
    [sym_html_append_operator] = ACTIONS(305),
    [anon_sym_BQUOTE] = ACTIONS(305),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(305),
    [anon_sym_CR] = ACTIONS(305),
    [sym_file_descriptor] = ACTIONS(305),
    [sym__concat] = ACTIONS(484),
  },
  [140] = {
    [aux_sym_tmp_eval_args_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(489),
    [anon_sym_PIPEH] = ACTIONS(487),
    [anon_sym_PIPET] = ACTIONS(487),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(487),
    [anon_sym_AT_AT_ATb] = ACTIONS(487),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(487),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(487),
    [anon_sym_AT_AT_ATi] = ACTIONS(487),
    [anon_sym_AT_AT_ATr] = ACTIONS(487),
    [anon_sym_AT_AT_ATs] = ACTIONS(489),
    [anon_sym_AT_AT_ATst] = ACTIONS(487),
    [anon_sym_AT_AT_ATS] = ACTIONS(487),
    [anon_sym_AT_AT_ATm] = ACTIONS(487),
    [anon_sym_AT_AT_ATM] = ACTIONS(487),
    [anon_sym_AT_AT_ATf] = ACTIONS(489),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(487),
    [anon_sym_AT_AT_ATF] = ACTIONS(489),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(487),
    [anon_sym_AT_AT_ATt] = ACTIONS(487),
    [anon_sym_AT_AT] = ACTIONS(489),
    [anon_sym_AT_ATdbt] = ACTIONS(489),
    [anon_sym_AT_ATdbta] = ACTIONS(487),
    [anon_sym_AT_ATdbtb] = ACTIONS(487),
    [anon_sym_AT_ATdbts] = ACTIONS(487),
    [anon_sym_AT_AT_DOT] = ACTIONS(487),
    [anon_sym_AT_AT_EQ] = ACTIONS(487),
    [anon_sym_AT_ATk] = ACTIONS(487),
    [anon_sym_AT_ATt] = ACTIONS(487),
    [anon_sym_AT_ATb] = ACTIONS(487),
    [anon_sym_AT_ATi] = ACTIONS(489),
    [anon_sym_AT_ATiS] = ACTIONS(487),
    [anon_sym_AT_ATf] = ACTIONS(487),
    [anon_sym_AT_ATs_COLON] = ACTIONS(487),
    [anon_sym_AT_ATc_COLON] = ACTIONS(487),
    [anon_sym_AT] = ACTIONS(489),
    [anon_sym_AT_BANG] = ACTIONS(487),
    [anon_sym_AT_LBRACE] = ACTIONS(487),
    [anon_sym_ATa_COLON] = ACTIONS(487),
    [anon_sym_ATb_COLON] = ACTIONS(487),
    [anon_sym_ATB_COLON] = ACTIONS(487),
    [anon_sym_ATe_COLON] = ACTIONS(487),
    [anon_sym_ATF_COLON] = ACTIONS(487),
    [anon_sym_ATi_COLON] = ACTIONS(487),
    [anon_sym_ATk_COLON] = ACTIONS(487),
    [anon_sym_ATo_COLON] = ACTIONS(487),
    [anon_sym_ATr_COLON] = ACTIONS(487),
    [anon_sym_ATf_COLON] = ACTIONS(487),
    [anon_sym_ATs_COLON] = ACTIONS(487),
    [anon_sym_ATx_COLON] = ACTIONS(487),
    [anon_sym_PIPE_DOT] = ACTIONS(487),
    [anon_sym_RPAREN] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(489),
    [anon_sym_GT_GT] = ACTIONS(487),
    [sym_html_redirect_operator] = ACTIONS(489),
    [sym_html_append_operator] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(491),
    [anon_sym_BQUOTE] = ACTIONS(487),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(487),
    [anon_sym_CR] = ACTIONS(487),
    [sym_file_descriptor] = ACTIONS(487),
  },
  [141] = {
    [sym_cmd_substitution_arg] = STATE(141),
    [aux_sym_grep_specifier_repeat1] = STATE(141),
    [anon_sym_TILDE] = ACTIONS(416),
    [sym_grep_specifier_identifier] = ACTIONS(493),
    [aux_sym_grep_specifier_token1] = ACTIONS(416),
    [anon_sym_PIPE] = ACTIONS(416),
    [anon_sym_PIPEH] = ACTIONS(416),
    [anon_sym_PIPET] = ACTIONS(416),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(416),
    [anon_sym_AT_AT_ATb] = ACTIONS(416),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATi] = ACTIONS(416),
    [anon_sym_AT_AT_ATr] = ACTIONS(416),
    [anon_sym_AT_AT_ATs] = ACTIONS(416),
    [anon_sym_AT_AT_ATst] = ACTIONS(416),
    [anon_sym_AT_AT_ATS] = ACTIONS(416),
    [anon_sym_AT_AT_ATm] = ACTIONS(416),
    [anon_sym_AT_AT_ATM] = ACTIONS(416),
    [anon_sym_AT_AT_ATf] = ACTIONS(416),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATF] = ACTIONS(416),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(416),
    [anon_sym_AT_AT_ATt] = ACTIONS(416),
    [anon_sym_AT_AT] = ACTIONS(416),
    [anon_sym_AT_ATdbt] = ACTIONS(416),
    [anon_sym_AT_ATdbta] = ACTIONS(416),
    [anon_sym_AT_ATdbtb] = ACTIONS(416),
    [anon_sym_AT_ATdbts] = ACTIONS(416),
    [anon_sym_AT_AT_DOT] = ACTIONS(416),
    [anon_sym_AT_AT_EQ] = ACTIONS(416),
    [anon_sym_AT_ATk] = ACTIONS(416),
    [anon_sym_AT_ATt] = ACTIONS(416),
    [anon_sym_AT_ATb] = ACTIONS(416),
    [anon_sym_AT_ATi] = ACTIONS(416),
    [anon_sym_AT_ATiS] = ACTIONS(416),
    [anon_sym_AT_ATf] = ACTIONS(416),
    [anon_sym_AT_ATs_COLON] = ACTIONS(416),
    [anon_sym_AT_ATc_COLON] = ACTIONS(416),
    [anon_sym_AT] = ACTIONS(416),
    [anon_sym_AT_BANG] = ACTIONS(416),
    [anon_sym_AT_LBRACE] = ACTIONS(416),
    [anon_sym_ATa_COLON] = ACTIONS(416),
    [anon_sym_ATb_COLON] = ACTIONS(416),
    [anon_sym_ATB_COLON] = ACTIONS(416),
    [anon_sym_ATe_COLON] = ACTIONS(416),
    [anon_sym_ATF_COLON] = ACTIONS(416),
    [anon_sym_ATi_COLON] = ACTIONS(416),
    [anon_sym_ATk_COLON] = ACTIONS(416),
    [anon_sym_ATo_COLON] = ACTIONS(416),
    [anon_sym_ATr_COLON] = ACTIONS(416),
    [anon_sym_ATf_COLON] = ACTIONS(416),
    [anon_sym_ATs_COLON] = ACTIONS(416),
    [anon_sym_ATx_COLON] = ACTIONS(416),
    [anon_sym_PIPE_DOT] = ACTIONS(416),
    [anon_sym_RPAREN] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(416),
    [anon_sym_GT] = ACTIONS(416),
    [anon_sym_GT_GT] = ACTIONS(416),
    [sym_html_redirect_operator] = ACTIONS(416),
    [sym_html_append_operator] = ACTIONS(416),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(496),
    [anon_sym_BQUOTE] = ACTIONS(499),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(414),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__eq_sep_concat] = ACTIONS(316),
    [sym__concat] = ACTIONS(316),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__eq_sep_concat] = ACTIONS(316),
    [sym__concat] = ACTIONS(316),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__eq_sep_concat] = ACTIONS(316),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__eq_sep_concat] = ACTIONS(316),
  },
  [146] = {
    [aux_sym_concatenation_repeat1] = STATE(170),
    [ts_builtin_sym_end] = ACTIONS(299),
    [anon_sym_TILDE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_PIPEH] = ACTIONS(299),
    [anon_sym_PIPET] = ACTIONS(299),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATi] = ACTIONS(299),
    [anon_sym_AT_AT_ATr] = ACTIONS(299),
    [anon_sym_AT_AT_ATs] = ACTIONS(301),
    [anon_sym_AT_AT_ATst] = ACTIONS(299),
    [anon_sym_AT_AT_ATS] = ACTIONS(299),
    [anon_sym_AT_AT_ATm] = ACTIONS(299),
    [anon_sym_AT_AT_ATM] = ACTIONS(299),
    [anon_sym_AT_AT_ATf] = ACTIONS(301),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATF] = ACTIONS(301),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(299),
    [anon_sym_AT_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_AT] = ACTIONS(301),
    [anon_sym_AT_ATdbt] = ACTIONS(301),
    [anon_sym_AT_ATdbta] = ACTIONS(299),
    [anon_sym_AT_ATdbtb] = ACTIONS(299),
    [anon_sym_AT_ATdbts] = ACTIONS(299),
    [anon_sym_AT_AT_DOT] = ACTIONS(299),
    [anon_sym_AT_AT_EQ] = ACTIONS(299),
    [anon_sym_AT_ATk] = ACTIONS(299),
    [anon_sym_AT_ATt] = ACTIONS(299),
    [anon_sym_AT_ATb] = ACTIONS(299),
    [anon_sym_AT_ATi] = ACTIONS(301),
    [anon_sym_AT_ATiS] = ACTIONS(299),
    [anon_sym_AT_ATf] = ACTIONS(299),
    [anon_sym_AT_ATs_COLON] = ACTIONS(299),
    [anon_sym_AT_ATc_COLON] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_AT_BANG] = ACTIONS(299),
    [anon_sym_AT_LBRACE] = ACTIONS(299),
    [anon_sym_ATa_COLON] = ACTIONS(299),
    [anon_sym_ATb_COLON] = ACTIONS(299),
    [anon_sym_ATB_COLON] = ACTIONS(299),
    [anon_sym_ATe_COLON] = ACTIONS(299),
    [anon_sym_ATF_COLON] = ACTIONS(299),
    [anon_sym_ATi_COLON] = ACTIONS(299),
    [anon_sym_ATk_COLON] = ACTIONS(299),
    [anon_sym_ATo_COLON] = ACTIONS(299),
    [anon_sym_ATr_COLON] = ACTIONS(299),
    [anon_sym_ATf_COLON] = ACTIONS(299),
    [anon_sym_ATs_COLON] = ACTIONS(299),
    [anon_sym_ATx_COLON] = ACTIONS(299),
    [anon_sym_PIPE_DOT] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(299),
    [sym_html_redirect_operator] = ACTIONS(301),
    [sym_html_append_operator] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(299),
    [anon_sym_CR] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(299),
    [sym__concat] = ACTIONS(502),
  },
  [147] = {
    [ts_builtin_sym_end] = ACTIONS(340),
    [anon_sym_TILDE] = ACTIONS(340),
    [anon_sym_PIPE] = ACTIONS(342),
    [anon_sym_PIPEH] = ACTIONS(340),
    [anon_sym_PIPET] = ACTIONS(340),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(340),
    [anon_sym_AT_AT_ATb] = ACTIONS(340),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATi] = ACTIONS(340),
    [anon_sym_AT_AT_ATr] = ACTIONS(340),
    [anon_sym_AT_AT_ATs] = ACTIONS(342),
    [anon_sym_AT_AT_ATst] = ACTIONS(340),
    [anon_sym_AT_AT_ATS] = ACTIONS(340),
    [anon_sym_AT_AT_ATm] = ACTIONS(340),
    [anon_sym_AT_AT_ATM] = ACTIONS(340),
    [anon_sym_AT_AT_ATf] = ACTIONS(342),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATF] = ACTIONS(342),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(340),
    [anon_sym_AT_AT_ATt] = ACTIONS(340),
    [anon_sym_AT_AT] = ACTIONS(342),
    [anon_sym_AT_ATdbt] = ACTIONS(342),
    [anon_sym_AT_ATdbta] = ACTIONS(340),
    [anon_sym_AT_ATdbtb] = ACTIONS(340),
    [anon_sym_AT_ATdbts] = ACTIONS(340),
    [anon_sym_AT_AT_DOT] = ACTIONS(340),
    [anon_sym_AT_AT_EQ] = ACTIONS(340),
    [anon_sym_AT_ATk] = ACTIONS(340),
    [anon_sym_AT_ATt] = ACTIONS(340),
    [anon_sym_AT_ATb] = ACTIONS(340),
    [anon_sym_AT_ATi] = ACTIONS(342),
    [anon_sym_AT_ATiS] = ACTIONS(340),
    [anon_sym_AT_ATf] = ACTIONS(340),
    [anon_sym_AT_ATs_COLON] = ACTIONS(340),
    [anon_sym_AT_ATc_COLON] = ACTIONS(340),
    [anon_sym_AT] = ACTIONS(342),
    [anon_sym_AT_BANG] = ACTIONS(340),
    [anon_sym_AT_LBRACE] = ACTIONS(340),
    [anon_sym_ATa_COLON] = ACTIONS(340),
    [anon_sym_ATb_COLON] = ACTIONS(340),
    [anon_sym_ATB_COLON] = ACTIONS(340),
    [anon_sym_ATe_COLON] = ACTIONS(340),
    [anon_sym_ATF_COLON] = ACTIONS(340),
    [anon_sym_ATi_COLON] = ACTIONS(340),
    [anon_sym_ATk_COLON] = ACTIONS(340),
    [anon_sym_ATo_COLON] = ACTIONS(340),
    [anon_sym_ATr_COLON] = ACTIONS(340),
    [anon_sym_ATf_COLON] = ACTIONS(340),
    [anon_sym_ATs_COLON] = ACTIONS(340),
    [anon_sym_ATx_COLON] = ACTIONS(340),
    [anon_sym_PIPE_DOT] = ACTIONS(340),
    [anon_sym_RPAREN] = ACTIONS(340),
    [anon_sym_SEMI] = ACTIONS(340),
    [anon_sym_GT] = ACTIONS(342),
    [anon_sym_GT_GT] = ACTIONS(340),
    [sym_html_redirect_operator] = ACTIONS(342),
    [sym_html_append_operator] = ACTIONS(340),
    [anon_sym_BQUOTE] = ACTIONS(340),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(340),
    [anon_sym_CR] = ACTIONS(340),
    [sym_file_descriptor] = ACTIONS(340),
    [sym__eq_sep_concat] = ACTIONS(340),
    [sym__concat] = ACTIONS(340),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(324),
    [anon_sym_TILDE] = ACTIONS(324),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_PIPEH] = ACTIONS(324),
    [anon_sym_PIPET] = ACTIONS(324),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(324),
    [anon_sym_AT_AT_ATb] = ACTIONS(324),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATi] = ACTIONS(324),
    [anon_sym_AT_AT_ATr] = ACTIONS(324),
    [anon_sym_AT_AT_ATs] = ACTIONS(326),
    [anon_sym_AT_AT_ATst] = ACTIONS(324),
    [anon_sym_AT_AT_ATS] = ACTIONS(324),
    [anon_sym_AT_AT_ATm] = ACTIONS(324),
    [anon_sym_AT_AT_ATM] = ACTIONS(324),
    [anon_sym_AT_AT_ATf] = ACTIONS(326),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATF] = ACTIONS(326),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(324),
    [anon_sym_AT_AT_ATt] = ACTIONS(324),
    [anon_sym_AT_AT] = ACTIONS(326),
    [anon_sym_AT_ATdbt] = ACTIONS(326),
    [anon_sym_AT_ATdbta] = ACTIONS(324),
    [anon_sym_AT_ATdbtb] = ACTIONS(324),
    [anon_sym_AT_ATdbts] = ACTIONS(324),
    [anon_sym_AT_AT_DOT] = ACTIONS(324),
    [anon_sym_AT_AT_EQ] = ACTIONS(324),
    [anon_sym_AT_ATk] = ACTIONS(324),
    [anon_sym_AT_ATt] = ACTIONS(324),
    [anon_sym_AT_ATb] = ACTIONS(324),
    [anon_sym_AT_ATi] = ACTIONS(326),
    [anon_sym_AT_ATiS] = ACTIONS(324),
    [anon_sym_AT_ATf] = ACTIONS(324),
    [anon_sym_AT_ATs_COLON] = ACTIONS(324),
    [anon_sym_AT_ATc_COLON] = ACTIONS(324),
    [anon_sym_AT] = ACTIONS(326),
    [anon_sym_AT_BANG] = ACTIONS(324),
    [anon_sym_AT_LBRACE] = ACTIONS(324),
    [anon_sym_ATa_COLON] = ACTIONS(324),
    [anon_sym_ATb_COLON] = ACTIONS(324),
    [anon_sym_ATB_COLON] = ACTIONS(324),
    [anon_sym_ATe_COLON] = ACTIONS(324),
    [anon_sym_ATF_COLON] = ACTIONS(324),
    [anon_sym_ATi_COLON] = ACTIONS(324),
    [anon_sym_ATk_COLON] = ACTIONS(324),
    [anon_sym_ATo_COLON] = ACTIONS(324),
    [anon_sym_ATr_COLON] = ACTIONS(324),
    [anon_sym_ATf_COLON] = ACTIONS(324),
    [anon_sym_ATs_COLON] = ACTIONS(324),
    [anon_sym_ATx_COLON] = ACTIONS(324),
    [anon_sym_PIPE_DOT] = ACTIONS(324),
    [anon_sym_RPAREN] = ACTIONS(324),
    [anon_sym_SEMI] = ACTIONS(324),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_GT_GT] = ACTIONS(324),
    [sym_html_redirect_operator] = ACTIONS(326),
    [sym_html_append_operator] = ACTIONS(324),
    [anon_sym_BQUOTE] = ACTIONS(324),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(324),
    [anon_sym_CR] = ACTIONS(324),
    [sym_file_descriptor] = ACTIONS(324),
    [sym__eq_sep_concat] = ACTIONS(324),
    [sym__concat] = ACTIONS(324),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(504),
    [anon_sym_TILDE] = ACTIONS(504),
    [anon_sym_PIPE] = ACTIONS(506),
    [anon_sym_PIPEH] = ACTIONS(504),
    [anon_sym_PIPET] = ACTIONS(504),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(504),
    [anon_sym_AT_AT_ATb] = ACTIONS(504),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATi] = ACTIONS(504),
    [anon_sym_AT_AT_ATr] = ACTIONS(504),
    [anon_sym_AT_AT_ATs] = ACTIONS(506),
    [anon_sym_AT_AT_ATst] = ACTIONS(504),
    [anon_sym_AT_AT_ATS] = ACTIONS(504),
    [anon_sym_AT_AT_ATm] = ACTIONS(504),
    [anon_sym_AT_AT_ATM] = ACTIONS(504),
    [anon_sym_AT_AT_ATf] = ACTIONS(506),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATF] = ACTIONS(506),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATt] = ACTIONS(504),
    [anon_sym_AT_AT] = ACTIONS(506),
    [anon_sym_AT_ATdbt] = ACTIONS(506),
    [anon_sym_AT_ATdbta] = ACTIONS(504),
    [anon_sym_AT_ATdbtb] = ACTIONS(504),
    [anon_sym_AT_ATdbts] = ACTIONS(504),
    [anon_sym_AT_AT_DOT] = ACTIONS(504),
    [anon_sym_AT_AT_EQ] = ACTIONS(504),
    [anon_sym_AT_ATk] = ACTIONS(504),
    [anon_sym_AT_ATt] = ACTIONS(504),
    [anon_sym_AT_ATb] = ACTIONS(504),
    [anon_sym_AT_ATi] = ACTIONS(506),
    [anon_sym_AT_ATiS] = ACTIONS(504),
    [anon_sym_AT_ATf] = ACTIONS(504),
    [anon_sym_AT_ATs_COLON] = ACTIONS(504),
    [anon_sym_AT_ATc_COLON] = ACTIONS(504),
    [anon_sym_AT] = ACTIONS(506),
    [anon_sym_AT_BANG] = ACTIONS(504),
    [anon_sym_AT_LBRACE] = ACTIONS(504),
    [anon_sym_ATa_COLON] = ACTIONS(504),
    [anon_sym_ATb_COLON] = ACTIONS(504),
    [anon_sym_ATB_COLON] = ACTIONS(504),
    [anon_sym_ATe_COLON] = ACTIONS(504),
    [anon_sym_ATF_COLON] = ACTIONS(504),
    [anon_sym_ATi_COLON] = ACTIONS(504),
    [anon_sym_ATk_COLON] = ACTIONS(504),
    [anon_sym_ATo_COLON] = ACTIONS(504),
    [anon_sym_ATr_COLON] = ACTIONS(504),
    [anon_sym_ATf_COLON] = ACTIONS(504),
    [anon_sym_ATs_COLON] = ACTIONS(504),
    [anon_sym_ATx_COLON] = ACTIONS(504),
    [anon_sym_PIPE_DOT] = ACTIONS(504),
    [anon_sym_EQ] = ACTIONS(504),
    [anon_sym_RPAREN] = ACTIONS(504),
    [anon_sym_SEMI] = ACTIONS(504),
    [anon_sym_GT] = ACTIONS(506),
    [anon_sym_GT_GT] = ACTIONS(504),
    [sym_html_redirect_operator] = ACTIONS(506),
    [sym_html_append_operator] = ACTIONS(504),
    [anon_sym_BQUOTE] = ACTIONS(504),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(504),
    [anon_sym_CR] = ACTIONS(504),
    [sym_file_descriptor] = ACTIONS(504),
    [sym__concat_pf_dot] = ACTIONS(504),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(318),
    [sym_grep_specifier_identifier] = ACTIONS(318),
    [aux_sym_grep_specifier_token1] = ACTIONS(318),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(318),
    [anon_sym_PIPET] = ACTIONS(318),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(318),
    [anon_sym_AT_AT_ATb] = ACTIONS(318),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_AT_ATr] = ACTIONS(318),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(318),
    [anon_sym_AT_AT_ATS] = ACTIONS(318),
    [anon_sym_AT_AT_ATm] = ACTIONS(318),
    [anon_sym_AT_AT_ATM] = ACTIONS(318),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATt] = ACTIONS(318),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(318),
    [anon_sym_AT_ATdbtb] = ACTIONS(318),
    [anon_sym_AT_ATdbts] = ACTIONS(318),
    [anon_sym_AT_AT_DOT] = ACTIONS(318),
    [anon_sym_AT_AT_EQ] = ACTIONS(318),
    [anon_sym_AT_ATk] = ACTIONS(318),
    [anon_sym_AT_ATt] = ACTIONS(318),
    [anon_sym_AT_ATb] = ACTIONS(318),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(318),
    [anon_sym_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_ATs_COLON] = ACTIONS(318),
    [anon_sym_AT_ATc_COLON] = ACTIONS(318),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(318),
    [anon_sym_AT_LBRACE] = ACTIONS(318),
    [anon_sym_ATa_COLON] = ACTIONS(318),
    [anon_sym_ATb_COLON] = ACTIONS(318),
    [anon_sym_ATB_COLON] = ACTIONS(318),
    [anon_sym_ATe_COLON] = ACTIONS(318),
    [anon_sym_ATF_COLON] = ACTIONS(318),
    [anon_sym_ATi_COLON] = ACTIONS(318),
    [anon_sym_ATk_COLON] = ACTIONS(318),
    [anon_sym_ATo_COLON] = ACTIONS(318),
    [anon_sym_ATr_COLON] = ACTIONS(318),
    [anon_sym_ATf_COLON] = ACTIONS(318),
    [anon_sym_ATs_COLON] = ACTIONS(318),
    [anon_sym_ATx_COLON] = ACTIONS(318),
    [anon_sym_PIPE_DOT] = ACTIONS(318),
    [anon_sym_SEMI] = ACTIONS(318),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(318),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(318),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(318),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(318),
    [anon_sym_CR] = ACTIONS(318),
    [sym_file_descriptor] = ACTIONS(316),
  },
  [151] = {
    [sym_cmd_substitution_arg] = STATE(141),
    [aux_sym_grep_specifier_repeat1] = STATE(141),
    [anon_sym_TILDE] = ACTIONS(400),
    [sym_grep_specifier_identifier] = ACTIONS(508),
    [aux_sym_grep_specifier_token1] = ACTIONS(404),
    [anon_sym_PIPE] = ACTIONS(400),
    [anon_sym_PIPEH] = ACTIONS(400),
    [anon_sym_PIPET] = ACTIONS(400),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(400),
    [anon_sym_AT_AT_ATb] = ACTIONS(400),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATi] = ACTIONS(400),
    [anon_sym_AT_AT_ATr] = ACTIONS(400),
    [anon_sym_AT_AT_ATs] = ACTIONS(400),
    [anon_sym_AT_AT_ATst] = ACTIONS(400),
    [anon_sym_AT_AT_ATS] = ACTIONS(400),
    [anon_sym_AT_AT_ATm] = ACTIONS(400),
    [anon_sym_AT_AT_ATM] = ACTIONS(400),
    [anon_sym_AT_AT_ATf] = ACTIONS(400),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATF] = ACTIONS(400),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(400),
    [anon_sym_AT_AT_ATt] = ACTIONS(400),
    [anon_sym_AT_AT] = ACTIONS(400),
    [anon_sym_AT_ATdbt] = ACTIONS(400),
    [anon_sym_AT_ATdbta] = ACTIONS(400),
    [anon_sym_AT_ATdbtb] = ACTIONS(400),
    [anon_sym_AT_ATdbts] = ACTIONS(400),
    [anon_sym_AT_AT_DOT] = ACTIONS(400),
    [anon_sym_AT_AT_EQ] = ACTIONS(400),
    [anon_sym_AT_ATk] = ACTIONS(400),
    [anon_sym_AT_ATt] = ACTIONS(400),
    [anon_sym_AT_ATb] = ACTIONS(400),
    [anon_sym_AT_ATi] = ACTIONS(400),
    [anon_sym_AT_ATiS] = ACTIONS(400),
    [anon_sym_AT_ATf] = ACTIONS(400),
    [anon_sym_AT_ATs_COLON] = ACTIONS(400),
    [anon_sym_AT_ATc_COLON] = ACTIONS(400),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_AT_BANG] = ACTIONS(400),
    [anon_sym_AT_LBRACE] = ACTIONS(400),
    [anon_sym_ATa_COLON] = ACTIONS(400),
    [anon_sym_ATb_COLON] = ACTIONS(400),
    [anon_sym_ATB_COLON] = ACTIONS(400),
    [anon_sym_ATe_COLON] = ACTIONS(400),
    [anon_sym_ATF_COLON] = ACTIONS(400),
    [anon_sym_ATi_COLON] = ACTIONS(400),
    [anon_sym_ATk_COLON] = ACTIONS(400),
    [anon_sym_ATo_COLON] = ACTIONS(400),
    [anon_sym_ATr_COLON] = ACTIONS(400),
    [anon_sym_ATf_COLON] = ACTIONS(400),
    [anon_sym_ATs_COLON] = ACTIONS(400),
    [anon_sym_ATx_COLON] = ACTIONS(400),
    [anon_sym_PIPE_DOT] = ACTIONS(400),
    [anon_sym_RPAREN] = ACTIONS(400),
    [anon_sym_SEMI] = ACTIONS(400),
    [anon_sym_GT] = ACTIONS(400),
    [anon_sym_GT_GT] = ACTIONS(400),
    [sym_html_redirect_operator] = ACTIONS(400),
    [sym_html_append_operator] = ACTIONS(400),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(510),
    [anon_sym_BQUOTE] = ACTIONS(512),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(398),
  },
  [152] = {
    [aux_sym_eq_sep_val_repeat1] = STATE(152),
    [ts_builtin_sym_end] = ACTIONS(514),
    [anon_sym_TILDE] = ACTIONS(514),
    [anon_sym_PIPE] = ACTIONS(516),
    [anon_sym_PIPEH] = ACTIONS(514),
    [anon_sym_PIPET] = ACTIONS(514),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(514),
    [anon_sym_AT_AT_ATb] = ACTIONS(514),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(514),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(514),
    [anon_sym_AT_AT_ATi] = ACTIONS(514),
    [anon_sym_AT_AT_ATr] = ACTIONS(514),
    [anon_sym_AT_AT_ATs] = ACTIONS(516),
    [anon_sym_AT_AT_ATst] = ACTIONS(514),
    [anon_sym_AT_AT_ATS] = ACTIONS(514),
    [anon_sym_AT_AT_ATm] = ACTIONS(514),
    [anon_sym_AT_AT_ATM] = ACTIONS(514),
    [anon_sym_AT_AT_ATf] = ACTIONS(516),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(514),
    [anon_sym_AT_AT_ATF] = ACTIONS(516),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(514),
    [anon_sym_AT_AT_ATt] = ACTIONS(514),
    [anon_sym_AT_AT] = ACTIONS(516),
    [anon_sym_AT_ATdbt] = ACTIONS(516),
    [anon_sym_AT_ATdbta] = ACTIONS(514),
    [anon_sym_AT_ATdbtb] = ACTIONS(514),
    [anon_sym_AT_ATdbts] = ACTIONS(514),
    [anon_sym_AT_AT_DOT] = ACTIONS(514),
    [anon_sym_AT_AT_EQ] = ACTIONS(514),
    [anon_sym_AT_ATk] = ACTIONS(514),
    [anon_sym_AT_ATt] = ACTIONS(514),
    [anon_sym_AT_ATb] = ACTIONS(514),
    [anon_sym_AT_ATi] = ACTIONS(516),
    [anon_sym_AT_ATiS] = ACTIONS(514),
    [anon_sym_AT_ATf] = ACTIONS(514),
    [anon_sym_AT_ATs_COLON] = ACTIONS(514),
    [anon_sym_AT_ATc_COLON] = ACTIONS(514),
    [anon_sym_AT] = ACTIONS(516),
    [anon_sym_AT_BANG] = ACTIONS(514),
    [anon_sym_AT_LBRACE] = ACTIONS(514),
    [anon_sym_ATa_COLON] = ACTIONS(514),
    [anon_sym_ATb_COLON] = ACTIONS(514),
    [anon_sym_ATB_COLON] = ACTIONS(514),
    [anon_sym_ATe_COLON] = ACTIONS(514),
    [anon_sym_ATF_COLON] = ACTIONS(514),
    [anon_sym_ATi_COLON] = ACTIONS(514),
    [anon_sym_ATk_COLON] = ACTIONS(514),
    [anon_sym_ATo_COLON] = ACTIONS(514),
    [anon_sym_ATr_COLON] = ACTIONS(514),
    [anon_sym_ATf_COLON] = ACTIONS(514),
    [anon_sym_ATs_COLON] = ACTIONS(514),
    [anon_sym_ATx_COLON] = ACTIONS(514),
    [anon_sym_PIPE_DOT] = ACTIONS(514),
    [anon_sym_RPAREN] = ACTIONS(514),
    [anon_sym_SEMI] = ACTIONS(514),
    [anon_sym_GT] = ACTIONS(516),
    [anon_sym_GT_GT] = ACTIONS(514),
    [sym_html_redirect_operator] = ACTIONS(516),
    [sym_html_append_operator] = ACTIONS(514),
    [anon_sym_BQUOTE] = ACTIONS(514),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(514),
    [anon_sym_CR] = ACTIONS(514),
    [sym_file_descriptor] = ACTIONS(514),
    [sym__eq_sep_concat] = ACTIONS(518),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_PIPE] = ACTIONS(350),
    [anon_sym_PIPEH] = ACTIONS(348),
    [anon_sym_PIPET] = ACTIONS(348),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_AT_ATr] = ACTIONS(348),
    [anon_sym_AT_AT_ATs] = ACTIONS(350),
    [anon_sym_AT_AT_ATst] = ACTIONS(348),
    [anon_sym_AT_AT_ATS] = ACTIONS(348),
    [anon_sym_AT_AT_ATm] = ACTIONS(348),
    [anon_sym_AT_AT_ATM] = ACTIONS(348),
    [anon_sym_AT_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATF] = ACTIONS(350),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(348),
    [anon_sym_AT_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_AT] = ACTIONS(350),
    [anon_sym_AT_ATdbt] = ACTIONS(350),
    [anon_sym_AT_ATdbta] = ACTIONS(348),
    [anon_sym_AT_ATdbtb] = ACTIONS(348),
    [anon_sym_AT_ATdbts] = ACTIONS(348),
    [anon_sym_AT_AT_DOT] = ACTIONS(348),
    [anon_sym_AT_AT_EQ] = ACTIONS(348),
    [anon_sym_AT_ATk] = ACTIONS(348),
    [anon_sym_AT_ATt] = ACTIONS(348),
    [anon_sym_AT_ATb] = ACTIONS(348),
    [anon_sym_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_ATiS] = ACTIONS(348),
    [anon_sym_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_ATs_COLON] = ACTIONS(348),
    [anon_sym_AT_ATc_COLON] = ACTIONS(348),
    [anon_sym_AT] = ACTIONS(350),
    [anon_sym_AT_BANG] = ACTIONS(348),
    [anon_sym_AT_LBRACE] = ACTIONS(348),
    [anon_sym_ATa_COLON] = ACTIONS(348),
    [anon_sym_ATb_COLON] = ACTIONS(348),
    [anon_sym_ATB_COLON] = ACTIONS(348),
    [anon_sym_ATe_COLON] = ACTIONS(348),
    [anon_sym_ATF_COLON] = ACTIONS(348),
    [anon_sym_ATi_COLON] = ACTIONS(348),
    [anon_sym_ATk_COLON] = ACTIONS(348),
    [anon_sym_ATo_COLON] = ACTIONS(348),
    [anon_sym_ATr_COLON] = ACTIONS(348),
    [anon_sym_ATf_COLON] = ACTIONS(348),
    [anon_sym_ATs_COLON] = ACTIONS(348),
    [anon_sym_ATx_COLON] = ACTIONS(348),
    [anon_sym_PIPE_DOT] = ACTIONS(348),
    [anon_sym_EQ] = ACTIONS(348),
    [anon_sym_RPAREN] = ACTIONS(348),
    [anon_sym_SEMI] = ACTIONS(348),
    [anon_sym_GT] = ACTIONS(350),
    [anon_sym_GT_GT] = ACTIONS(348),
    [sym_html_redirect_operator] = ACTIONS(350),
    [sym_html_append_operator] = ACTIONS(348),
    [anon_sym_BQUOTE] = ACTIONS(348),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(348),
    [anon_sym_CR] = ACTIONS(348),
    [sym_file_descriptor] = ACTIONS(348),
    [sym__concat_pf_dot] = ACTIONS(348),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(336),
    [anon_sym_TILDE] = ACTIONS(336),
    [anon_sym_PIPE] = ACTIONS(338),
    [anon_sym_PIPEH] = ACTIONS(336),
    [anon_sym_PIPET] = ACTIONS(336),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(336),
    [anon_sym_AT_AT_ATb] = ACTIONS(336),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATi] = ACTIONS(336),
    [anon_sym_AT_AT_ATr] = ACTIONS(336),
    [anon_sym_AT_AT_ATs] = ACTIONS(338),
    [anon_sym_AT_AT_ATst] = ACTIONS(336),
    [anon_sym_AT_AT_ATS] = ACTIONS(336),
    [anon_sym_AT_AT_ATm] = ACTIONS(336),
    [anon_sym_AT_AT_ATM] = ACTIONS(336),
    [anon_sym_AT_AT_ATf] = ACTIONS(338),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATF] = ACTIONS(338),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(336),
    [anon_sym_AT_AT_ATt] = ACTIONS(336),
    [anon_sym_AT_AT] = ACTIONS(338),
    [anon_sym_AT_ATdbt] = ACTIONS(338),
    [anon_sym_AT_ATdbta] = ACTIONS(336),
    [anon_sym_AT_ATdbtb] = ACTIONS(336),
    [anon_sym_AT_ATdbts] = ACTIONS(336),
    [anon_sym_AT_AT_DOT] = ACTIONS(336),
    [anon_sym_AT_AT_EQ] = ACTIONS(336),
    [anon_sym_AT_ATk] = ACTIONS(336),
    [anon_sym_AT_ATt] = ACTIONS(336),
    [anon_sym_AT_ATb] = ACTIONS(336),
    [anon_sym_AT_ATi] = ACTIONS(338),
    [anon_sym_AT_ATiS] = ACTIONS(336),
    [anon_sym_AT_ATf] = ACTIONS(336),
    [anon_sym_AT_ATs_COLON] = ACTIONS(336),
    [anon_sym_AT_ATc_COLON] = ACTIONS(336),
    [anon_sym_AT] = ACTIONS(338),
    [anon_sym_AT_BANG] = ACTIONS(336),
    [anon_sym_AT_LBRACE] = ACTIONS(336),
    [anon_sym_ATa_COLON] = ACTIONS(336),
    [anon_sym_ATb_COLON] = ACTIONS(336),
    [anon_sym_ATB_COLON] = ACTIONS(336),
    [anon_sym_ATe_COLON] = ACTIONS(336),
    [anon_sym_ATF_COLON] = ACTIONS(336),
    [anon_sym_ATi_COLON] = ACTIONS(336),
    [anon_sym_ATk_COLON] = ACTIONS(336),
    [anon_sym_ATo_COLON] = ACTIONS(336),
    [anon_sym_ATr_COLON] = ACTIONS(336),
    [anon_sym_ATf_COLON] = ACTIONS(336),
    [anon_sym_ATs_COLON] = ACTIONS(336),
    [anon_sym_ATx_COLON] = ACTIONS(336),
    [anon_sym_PIPE_DOT] = ACTIONS(336),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_SEMI] = ACTIONS(336),
    [anon_sym_GT] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(336),
    [sym_html_redirect_operator] = ACTIONS(338),
    [sym_html_append_operator] = ACTIONS(336),
    [anon_sym_BQUOTE] = ACTIONS(336),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(336),
    [anon_sym_CR] = ACTIONS(336),
    [sym_file_descriptor] = ACTIONS(336),
    [sym__eq_sep_concat] = ACTIONS(336),
    [sym__concat] = ACTIONS(336),
  },
  [155] = {
    [ts_builtin_sym_end] = ACTIONS(305),
    [anon_sym_TILDE] = ACTIONS(305),
    [anon_sym_PIPE] = ACTIONS(307),
    [anon_sym_PIPEH] = ACTIONS(305),
    [anon_sym_PIPET] = ACTIONS(305),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATi] = ACTIONS(305),
    [anon_sym_AT_AT_ATr] = ACTIONS(305),
    [anon_sym_AT_AT_ATs] = ACTIONS(307),
    [anon_sym_AT_AT_ATst] = ACTIONS(305),
    [anon_sym_AT_AT_ATS] = ACTIONS(305),
    [anon_sym_AT_AT_ATm] = ACTIONS(305),
    [anon_sym_AT_AT_ATM] = ACTIONS(305),
    [anon_sym_AT_AT_ATf] = ACTIONS(307),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATF] = ACTIONS(307),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(305),
    [anon_sym_AT_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_AT] = ACTIONS(307),
    [anon_sym_AT_ATdbt] = ACTIONS(307),
    [anon_sym_AT_ATdbta] = ACTIONS(305),
    [anon_sym_AT_ATdbtb] = ACTIONS(305),
    [anon_sym_AT_ATdbts] = ACTIONS(305),
    [anon_sym_AT_AT_DOT] = ACTIONS(305),
    [anon_sym_AT_AT_EQ] = ACTIONS(305),
    [anon_sym_AT_ATk] = ACTIONS(305),
    [anon_sym_AT_ATt] = ACTIONS(305),
    [anon_sym_AT_ATb] = ACTIONS(305),
    [anon_sym_AT_ATi] = ACTIONS(307),
    [anon_sym_AT_ATiS] = ACTIONS(305),
    [anon_sym_AT_ATf] = ACTIONS(305),
    [anon_sym_AT_ATs_COLON] = ACTIONS(305),
    [anon_sym_AT_ATc_COLON] = ACTIONS(305),
    [anon_sym_AT] = ACTIONS(307),
    [anon_sym_AT_BANG] = ACTIONS(305),
    [anon_sym_AT_LBRACE] = ACTIONS(305),
    [anon_sym_ATa_COLON] = ACTIONS(305),
    [anon_sym_ATb_COLON] = ACTIONS(305),
    [anon_sym_ATB_COLON] = ACTIONS(305),
    [anon_sym_ATe_COLON] = ACTIONS(305),
    [anon_sym_ATF_COLON] = ACTIONS(305),
    [anon_sym_ATi_COLON] = ACTIONS(305),
    [anon_sym_ATk_COLON] = ACTIONS(305),
    [anon_sym_ATo_COLON] = ACTIONS(305),
    [anon_sym_ATr_COLON] = ACTIONS(305),
    [anon_sym_ATf_COLON] = ACTIONS(305),
    [anon_sym_ATs_COLON] = ACTIONS(305),
    [anon_sym_ATx_COLON] = ACTIONS(305),
    [anon_sym_PIPE_DOT] = ACTIONS(305),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_SEMI] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(305),
    [sym_html_redirect_operator] = ACTIONS(307),
    [sym_html_append_operator] = ACTIONS(305),
    [anon_sym_BQUOTE] = ACTIONS(305),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(305),
    [anon_sym_CR] = ACTIONS(305),
    [sym_file_descriptor] = ACTIONS(305),
    [sym__eq_sep_concat] = ACTIONS(305),
    [sym__concat] = ACTIONS(305),
  },
  [156] = {
    [aux_sym_tmp_eval_args_repeat1] = STATE(156),
    [ts_builtin_sym_end] = ACTIONS(521),
    [anon_sym_TILDE] = ACTIONS(521),
    [anon_sym_PIPE] = ACTIONS(523),
    [anon_sym_PIPEH] = ACTIONS(521),
    [anon_sym_PIPET] = ACTIONS(521),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(521),
    [anon_sym_AT_AT_ATb] = ACTIONS(521),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATi] = ACTIONS(521),
    [anon_sym_AT_AT_ATr] = ACTIONS(521),
    [anon_sym_AT_AT_ATs] = ACTIONS(523),
    [anon_sym_AT_AT_ATst] = ACTIONS(521),
    [anon_sym_AT_AT_ATS] = ACTIONS(521),
    [anon_sym_AT_AT_ATm] = ACTIONS(521),
    [anon_sym_AT_AT_ATM] = ACTIONS(521),
    [anon_sym_AT_AT_ATf] = ACTIONS(523),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATF] = ACTIONS(523),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATt] = ACTIONS(521),
    [anon_sym_AT_AT] = ACTIONS(523),
    [anon_sym_AT_ATdbt] = ACTIONS(523),
    [anon_sym_AT_ATdbta] = ACTIONS(521),
    [anon_sym_AT_ATdbtb] = ACTIONS(521),
    [anon_sym_AT_ATdbts] = ACTIONS(521),
    [anon_sym_AT_AT_DOT] = ACTIONS(521),
    [anon_sym_AT_AT_EQ] = ACTIONS(521),
    [anon_sym_AT_ATk] = ACTIONS(521),
    [anon_sym_AT_ATt] = ACTIONS(521),
    [anon_sym_AT_ATb] = ACTIONS(521),
    [anon_sym_AT_ATi] = ACTIONS(523),
    [anon_sym_AT_ATiS] = ACTIONS(521),
    [anon_sym_AT_ATf] = ACTIONS(521),
    [anon_sym_AT_ATs_COLON] = ACTIONS(521),
    [anon_sym_AT_ATc_COLON] = ACTIONS(521),
    [anon_sym_AT] = ACTIONS(523),
    [anon_sym_AT_BANG] = ACTIONS(521),
    [anon_sym_AT_LBRACE] = ACTIONS(521),
    [anon_sym_ATa_COLON] = ACTIONS(521),
    [anon_sym_ATb_COLON] = ACTIONS(521),
    [anon_sym_ATB_COLON] = ACTIONS(521),
    [anon_sym_ATe_COLON] = ACTIONS(521),
    [anon_sym_ATF_COLON] = ACTIONS(521),
    [anon_sym_ATi_COLON] = ACTIONS(521),
    [anon_sym_ATk_COLON] = ACTIONS(521),
    [anon_sym_ATo_COLON] = ACTIONS(521),
    [anon_sym_ATr_COLON] = ACTIONS(521),
    [anon_sym_ATf_COLON] = ACTIONS(521),
    [anon_sym_ATs_COLON] = ACTIONS(521),
    [anon_sym_ATx_COLON] = ACTIONS(521),
    [anon_sym_PIPE_DOT] = ACTIONS(521),
    [anon_sym_RPAREN] = ACTIONS(521),
    [anon_sym_SEMI] = ACTIONS(521),
    [anon_sym_GT] = ACTIONS(523),
    [anon_sym_GT_GT] = ACTIONS(521),
    [sym_html_redirect_operator] = ACTIONS(523),
    [sym_html_append_operator] = ACTIONS(521),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_BQUOTE] = ACTIONS(521),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(521),
    [anon_sym_CR] = ACTIONS(521),
    [sym_file_descriptor] = ACTIONS(521),
  },
  [157] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(318),
    [sym_grep_specifier_identifier] = ACTIONS(318),
    [aux_sym_grep_specifier_token1] = ACTIONS(318),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(318),
    [anon_sym_PIPET] = ACTIONS(318),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(318),
    [anon_sym_AT_AT_ATb] = ACTIONS(318),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_AT_ATr] = ACTIONS(318),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(318),
    [anon_sym_AT_AT_ATS] = ACTIONS(318),
    [anon_sym_AT_AT_ATm] = ACTIONS(318),
    [anon_sym_AT_AT_ATM] = ACTIONS(318),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(318),
    [anon_sym_AT_AT_ATt] = ACTIONS(318),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(318),
    [anon_sym_AT_ATdbtb] = ACTIONS(318),
    [anon_sym_AT_ATdbts] = ACTIONS(318),
    [anon_sym_AT_AT_DOT] = ACTIONS(318),
    [anon_sym_AT_AT_EQ] = ACTIONS(318),
    [anon_sym_AT_ATk] = ACTIONS(318),
    [anon_sym_AT_ATt] = ACTIONS(318),
    [anon_sym_AT_ATb] = ACTIONS(318),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(318),
    [anon_sym_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_ATs_COLON] = ACTIONS(318),
    [anon_sym_AT_ATc_COLON] = ACTIONS(318),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(318),
    [anon_sym_AT_LBRACE] = ACTIONS(318),
    [anon_sym_ATa_COLON] = ACTIONS(318),
    [anon_sym_ATb_COLON] = ACTIONS(318),
    [anon_sym_ATB_COLON] = ACTIONS(318),
    [anon_sym_ATe_COLON] = ACTIONS(318),
    [anon_sym_ATF_COLON] = ACTIONS(318),
    [anon_sym_ATi_COLON] = ACTIONS(318),
    [anon_sym_ATk_COLON] = ACTIONS(318),
    [anon_sym_ATo_COLON] = ACTIONS(318),
    [anon_sym_ATr_COLON] = ACTIONS(318),
    [anon_sym_ATf_COLON] = ACTIONS(318),
    [anon_sym_ATs_COLON] = ACTIONS(318),
    [anon_sym_ATx_COLON] = ACTIONS(318),
    [anon_sym_PIPE_DOT] = ACTIONS(318),
    [anon_sym_SEMI] = ACTIONS(318),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(318),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(318),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(318),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(318),
    [anon_sym_CR] = ACTIONS(318),
    [sym_file_descriptor] = ACTIONS(316),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(431),
    [anon_sym_PIPE] = ACTIONS(433),
    [anon_sym_PIPEH] = ACTIONS(431),
    [anon_sym_PIPET] = ACTIONS(431),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(431),
    [anon_sym_AT_AT_ATb] = ACTIONS(431),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATi] = ACTIONS(431),
    [anon_sym_AT_AT_ATr] = ACTIONS(431),
    [anon_sym_AT_AT_ATs] = ACTIONS(433),
    [anon_sym_AT_AT_ATst] = ACTIONS(431),
    [anon_sym_AT_AT_ATS] = ACTIONS(431),
    [anon_sym_AT_AT_ATm] = ACTIONS(431),
    [anon_sym_AT_AT_ATM] = ACTIONS(431),
    [anon_sym_AT_AT_ATf] = ACTIONS(433),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATF] = ACTIONS(433),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(431),
    [anon_sym_AT_AT_ATt] = ACTIONS(431),
    [anon_sym_AT_AT] = ACTIONS(433),
    [anon_sym_AT_ATdbt] = ACTIONS(433),
    [anon_sym_AT_ATdbta] = ACTIONS(431),
    [anon_sym_AT_ATdbtb] = ACTIONS(431),
    [anon_sym_AT_ATdbts] = ACTIONS(431),
    [anon_sym_AT_AT_DOT] = ACTIONS(431),
    [anon_sym_AT_AT_EQ] = ACTIONS(431),
    [anon_sym_AT_ATk] = ACTIONS(431),
    [anon_sym_AT_ATt] = ACTIONS(431),
    [anon_sym_AT_ATb] = ACTIONS(431),
    [anon_sym_AT_ATi] = ACTIONS(433),
    [anon_sym_AT_ATiS] = ACTIONS(431),
    [anon_sym_AT_ATf] = ACTIONS(431),
    [anon_sym_AT_ATs_COLON] = ACTIONS(431),
    [anon_sym_AT_ATc_COLON] = ACTIONS(431),
    [anon_sym_AT] = ACTIONS(433),
    [anon_sym_AT_BANG] = ACTIONS(431),
    [anon_sym_AT_LBRACE] = ACTIONS(431),
    [anon_sym_ATa_COLON] = ACTIONS(431),
    [anon_sym_ATb_COLON] = ACTIONS(431),
    [anon_sym_ATB_COLON] = ACTIONS(431),
    [anon_sym_ATe_COLON] = ACTIONS(431),
    [anon_sym_ATF_COLON] = ACTIONS(431),
    [anon_sym_ATi_COLON] = ACTIONS(431),
    [anon_sym_ATk_COLON] = ACTIONS(431),
    [anon_sym_ATo_COLON] = ACTIONS(431),
    [anon_sym_ATr_COLON] = ACTIONS(431),
    [anon_sym_ATf_COLON] = ACTIONS(431),
    [anon_sym_ATs_COLON] = ACTIONS(431),
    [anon_sym_ATx_COLON] = ACTIONS(431),
    [anon_sym_PIPE_DOT] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(431),
    [sym_html_redirect_operator] = ACTIONS(433),
    [sym_html_append_operator] = ACTIONS(431),
    [anon_sym_BQUOTE] = ACTIONS(431),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(431),
    [anon_sym_CR] = ACTIONS(431),
    [sym_file_descriptor] = ACTIONS(431),
    [sym__eq_sep_concat] = ACTIONS(431),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(358),
  },
  [160] = {
    [ts_builtin_sym_end] = ACTIONS(344),
    [anon_sym_TILDE] = ACTIONS(344),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PIPEH] = ACTIONS(344),
    [anon_sym_PIPET] = ACTIONS(344),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(344),
    [anon_sym_AT_AT_ATb] = ACTIONS(344),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATi] = ACTIONS(344),
    [anon_sym_AT_AT_ATr] = ACTIONS(344),
    [anon_sym_AT_AT_ATs] = ACTIONS(346),
    [anon_sym_AT_AT_ATst] = ACTIONS(344),
    [anon_sym_AT_AT_ATS] = ACTIONS(344),
    [anon_sym_AT_AT_ATm] = ACTIONS(344),
    [anon_sym_AT_AT_ATM] = ACTIONS(344),
    [anon_sym_AT_AT_ATf] = ACTIONS(346),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATF] = ACTIONS(346),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATt] = ACTIONS(344),
    [anon_sym_AT_AT] = ACTIONS(346),
    [anon_sym_AT_ATdbt] = ACTIONS(346),
    [anon_sym_AT_ATdbta] = ACTIONS(344),
    [anon_sym_AT_ATdbtb] = ACTIONS(344),
    [anon_sym_AT_ATdbts] = ACTIONS(344),
    [anon_sym_AT_AT_DOT] = ACTIONS(344),
    [anon_sym_AT_AT_EQ] = ACTIONS(344),
    [anon_sym_AT_ATk] = ACTIONS(344),
    [anon_sym_AT_ATt] = ACTIONS(344),
    [anon_sym_AT_ATb] = ACTIONS(344),
    [anon_sym_AT_ATi] = ACTIONS(346),
    [anon_sym_AT_ATiS] = ACTIONS(344),
    [anon_sym_AT_ATf] = ACTIONS(344),
    [anon_sym_AT_ATs_COLON] = ACTIONS(344),
    [anon_sym_AT_ATc_COLON] = ACTIONS(344),
    [anon_sym_AT] = ACTIONS(346),
    [anon_sym_AT_BANG] = ACTIONS(344),
    [anon_sym_AT_LBRACE] = ACTIONS(344),
    [anon_sym_ATa_COLON] = ACTIONS(344),
    [anon_sym_ATb_COLON] = ACTIONS(344),
    [anon_sym_ATB_COLON] = ACTIONS(344),
    [anon_sym_ATe_COLON] = ACTIONS(344),
    [anon_sym_ATF_COLON] = ACTIONS(344),
    [anon_sym_ATi_COLON] = ACTIONS(344),
    [anon_sym_ATk_COLON] = ACTIONS(344),
    [anon_sym_ATo_COLON] = ACTIONS(344),
    [anon_sym_ATr_COLON] = ACTIONS(344),
    [anon_sym_ATf_COLON] = ACTIONS(344),
    [anon_sym_ATs_COLON] = ACTIONS(344),
    [anon_sym_ATx_COLON] = ACTIONS(344),
    [anon_sym_PIPE_DOT] = ACTIONS(344),
    [anon_sym_RPAREN] = ACTIONS(344),
    [anon_sym_SEMI] = ACTIONS(344),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_GT_GT] = ACTIONS(344),
    [sym_html_redirect_operator] = ACTIONS(346),
    [sym_html_append_operator] = ACTIONS(344),
    [anon_sym_BQUOTE] = ACTIONS(344),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(344),
    [anon_sym_CR] = ACTIONS(344),
    [sym_file_descriptor] = ACTIONS(344),
    [sym__eq_sep_concat] = ACTIONS(344),
    [sym__concat] = ACTIONS(344),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(332),
    [anon_sym_TILDE] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(334),
    [anon_sym_PIPEH] = ACTIONS(332),
    [anon_sym_PIPET] = ACTIONS(332),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(332),
    [anon_sym_AT_AT_ATb] = ACTIONS(332),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATi] = ACTIONS(332),
    [anon_sym_AT_AT_ATr] = ACTIONS(332),
    [anon_sym_AT_AT_ATs] = ACTIONS(334),
    [anon_sym_AT_AT_ATst] = ACTIONS(332),
    [anon_sym_AT_AT_ATS] = ACTIONS(332),
    [anon_sym_AT_AT_ATm] = ACTIONS(332),
    [anon_sym_AT_AT_ATM] = ACTIONS(332),
    [anon_sym_AT_AT_ATf] = ACTIONS(334),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATF] = ACTIONS(334),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATt] = ACTIONS(332),
    [anon_sym_AT_AT] = ACTIONS(334),
    [anon_sym_AT_ATdbt] = ACTIONS(334),
    [anon_sym_AT_ATdbta] = ACTIONS(332),
    [anon_sym_AT_ATdbtb] = ACTIONS(332),
    [anon_sym_AT_ATdbts] = ACTIONS(332),
    [anon_sym_AT_AT_DOT] = ACTIONS(332),
    [anon_sym_AT_AT_EQ] = ACTIONS(332),
    [anon_sym_AT_ATk] = ACTIONS(332),
    [anon_sym_AT_ATt] = ACTIONS(332),
    [anon_sym_AT_ATb] = ACTIONS(332),
    [anon_sym_AT_ATi] = ACTIONS(334),
    [anon_sym_AT_ATiS] = ACTIONS(332),
    [anon_sym_AT_ATf] = ACTIONS(332),
    [anon_sym_AT_ATs_COLON] = ACTIONS(332),
    [anon_sym_AT_ATc_COLON] = ACTIONS(332),
    [anon_sym_AT] = ACTIONS(334),
    [anon_sym_AT_BANG] = ACTIONS(332),
    [anon_sym_AT_LBRACE] = ACTIONS(332),
    [anon_sym_ATa_COLON] = ACTIONS(332),
    [anon_sym_ATb_COLON] = ACTIONS(332),
    [anon_sym_ATB_COLON] = ACTIONS(332),
    [anon_sym_ATe_COLON] = ACTIONS(332),
    [anon_sym_ATF_COLON] = ACTIONS(332),
    [anon_sym_ATi_COLON] = ACTIONS(332),
    [anon_sym_ATk_COLON] = ACTIONS(332),
    [anon_sym_ATo_COLON] = ACTIONS(332),
    [anon_sym_ATr_COLON] = ACTIONS(332),
    [anon_sym_ATf_COLON] = ACTIONS(332),
    [anon_sym_ATs_COLON] = ACTIONS(332),
    [anon_sym_ATx_COLON] = ACTIONS(332),
    [anon_sym_PIPE_DOT] = ACTIONS(332),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_SEMI] = ACTIONS(332),
    [anon_sym_GT] = ACTIONS(334),
    [anon_sym_GT_GT] = ACTIONS(332),
    [sym_html_redirect_operator] = ACTIONS(334),
    [sym_html_append_operator] = ACTIONS(332),
    [anon_sym_BQUOTE] = ACTIONS(332),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(332),
    [anon_sym_CR] = ACTIONS(332),
    [sym_file_descriptor] = ACTIONS(332),
    [sym__eq_sep_concat] = ACTIONS(332),
    [sym__concat] = ACTIONS(332),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(386),
    [anon_sym_TILDE] = ACTIONS(386),
    [anon_sym_PIPE] = ACTIONS(388),
    [anon_sym_PIPEH] = ACTIONS(386),
    [anon_sym_PIPET] = ACTIONS(386),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(386),
    [anon_sym_AT_AT_ATb] = ACTIONS(386),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATi] = ACTIONS(386),
    [anon_sym_AT_AT_ATr] = ACTIONS(386),
    [anon_sym_AT_AT_ATs] = ACTIONS(388),
    [anon_sym_AT_AT_ATst] = ACTIONS(386),
    [anon_sym_AT_AT_ATS] = ACTIONS(386),
    [anon_sym_AT_AT_ATm] = ACTIONS(386),
    [anon_sym_AT_AT_ATM] = ACTIONS(386),
    [anon_sym_AT_AT_ATf] = ACTIONS(388),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATF] = ACTIONS(388),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(386),
    [anon_sym_AT_AT_ATt] = ACTIONS(386),
    [anon_sym_AT_AT] = ACTIONS(388),
    [anon_sym_AT_ATdbt] = ACTIONS(388),
    [anon_sym_AT_ATdbta] = ACTIONS(386),
    [anon_sym_AT_ATdbtb] = ACTIONS(386),
    [anon_sym_AT_ATdbts] = ACTIONS(386),
    [anon_sym_AT_AT_DOT] = ACTIONS(386),
    [anon_sym_AT_AT_EQ] = ACTIONS(386),
    [anon_sym_AT_ATk] = ACTIONS(386),
    [anon_sym_AT_ATt] = ACTIONS(386),
    [anon_sym_AT_ATb] = ACTIONS(386),
    [anon_sym_AT_ATi] = ACTIONS(388),
    [anon_sym_AT_ATiS] = ACTIONS(386),
    [anon_sym_AT_ATf] = ACTIONS(386),
    [anon_sym_AT_ATs_COLON] = ACTIONS(386),
    [anon_sym_AT_ATc_COLON] = ACTIONS(386),
    [anon_sym_AT] = ACTIONS(388),
    [anon_sym_AT_BANG] = ACTIONS(386),
    [anon_sym_AT_LBRACE] = ACTIONS(386),
    [anon_sym_ATa_COLON] = ACTIONS(386),
    [anon_sym_ATb_COLON] = ACTIONS(386),
    [anon_sym_ATB_COLON] = ACTIONS(386),
    [anon_sym_ATe_COLON] = ACTIONS(386),
    [anon_sym_ATF_COLON] = ACTIONS(386),
    [anon_sym_ATi_COLON] = ACTIONS(386),
    [anon_sym_ATk_COLON] = ACTIONS(386),
    [anon_sym_ATo_COLON] = ACTIONS(386),
    [anon_sym_ATr_COLON] = ACTIONS(386),
    [anon_sym_ATf_COLON] = ACTIONS(386),
    [anon_sym_ATs_COLON] = ACTIONS(386),
    [anon_sym_ATx_COLON] = ACTIONS(386),
    [anon_sym_PIPE_DOT] = ACTIONS(386),
    [anon_sym_EQ] = ACTIONS(386),
    [anon_sym_RPAREN] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(386),
    [anon_sym_GT] = ACTIONS(388),
    [anon_sym_GT_GT] = ACTIONS(386),
    [sym_html_redirect_operator] = ACTIONS(388),
    [sym_html_append_operator] = ACTIONS(386),
    [anon_sym_BQUOTE] = ACTIONS(386),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(386),
    [anon_sym_CR] = ACTIONS(386),
    [sym_file_descriptor] = ACTIONS(386),
    [sym__concat_pf_dot] = ACTIONS(386),
  },
  [163] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat_pf_dot] = ACTIONS(316),
  },
  [164] = {
    [aux_sym_eq_sep_val_repeat1] = STATE(152),
    [ts_builtin_sym_end] = ACTIONS(528),
    [anon_sym_TILDE] = ACTIONS(528),
    [anon_sym_PIPE] = ACTIONS(530),
    [anon_sym_PIPEH] = ACTIONS(528),
    [anon_sym_PIPET] = ACTIONS(528),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(528),
    [anon_sym_AT_AT_ATb] = ACTIONS(528),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(528),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(528),
    [anon_sym_AT_AT_ATi] = ACTIONS(528),
    [anon_sym_AT_AT_ATr] = ACTIONS(528),
    [anon_sym_AT_AT_ATs] = ACTIONS(530),
    [anon_sym_AT_AT_ATst] = ACTIONS(528),
    [anon_sym_AT_AT_ATS] = ACTIONS(528),
    [anon_sym_AT_AT_ATm] = ACTIONS(528),
    [anon_sym_AT_AT_ATM] = ACTIONS(528),
    [anon_sym_AT_AT_ATf] = ACTIONS(530),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(528),
    [anon_sym_AT_AT_ATF] = ACTIONS(530),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(528),
    [anon_sym_AT_AT_ATt] = ACTIONS(528),
    [anon_sym_AT_AT] = ACTIONS(530),
    [anon_sym_AT_ATdbt] = ACTIONS(530),
    [anon_sym_AT_ATdbta] = ACTIONS(528),
    [anon_sym_AT_ATdbtb] = ACTIONS(528),
    [anon_sym_AT_ATdbts] = ACTIONS(528),
    [anon_sym_AT_AT_DOT] = ACTIONS(528),
    [anon_sym_AT_AT_EQ] = ACTIONS(528),
    [anon_sym_AT_ATk] = ACTIONS(528),
    [anon_sym_AT_ATt] = ACTIONS(528),
    [anon_sym_AT_ATb] = ACTIONS(528),
    [anon_sym_AT_ATi] = ACTIONS(530),
    [anon_sym_AT_ATiS] = ACTIONS(528),
    [anon_sym_AT_ATf] = ACTIONS(528),
    [anon_sym_AT_ATs_COLON] = ACTIONS(528),
    [anon_sym_AT_ATc_COLON] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(530),
    [anon_sym_AT_BANG] = ACTIONS(528),
    [anon_sym_AT_LBRACE] = ACTIONS(528),
    [anon_sym_ATa_COLON] = ACTIONS(528),
    [anon_sym_ATb_COLON] = ACTIONS(528),
    [anon_sym_ATB_COLON] = ACTIONS(528),
    [anon_sym_ATe_COLON] = ACTIONS(528),
    [anon_sym_ATF_COLON] = ACTIONS(528),
    [anon_sym_ATi_COLON] = ACTIONS(528),
    [anon_sym_ATk_COLON] = ACTIONS(528),
    [anon_sym_ATo_COLON] = ACTIONS(528),
    [anon_sym_ATr_COLON] = ACTIONS(528),
    [anon_sym_ATf_COLON] = ACTIONS(528),
    [anon_sym_ATs_COLON] = ACTIONS(528),
    [anon_sym_ATx_COLON] = ACTIONS(528),
    [anon_sym_PIPE_DOT] = ACTIONS(528),
    [anon_sym_RPAREN] = ACTIONS(528),
    [anon_sym_SEMI] = ACTIONS(528),
    [anon_sym_GT] = ACTIONS(530),
    [anon_sym_GT_GT] = ACTIONS(528),
    [sym_html_redirect_operator] = ACTIONS(530),
    [sym_html_append_operator] = ACTIONS(528),
    [anon_sym_BQUOTE] = ACTIONS(528),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(528),
    [anon_sym_CR] = ACTIONS(528),
    [sym_file_descriptor] = ACTIONS(528),
    [sym__eq_sep_concat] = ACTIONS(482),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_PIPEH] = ACTIONS(320),
    [anon_sym_PIPET] = ACTIONS(320),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(320),
    [anon_sym_AT_AT_ATb] = ACTIONS(320),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATi] = ACTIONS(320),
    [anon_sym_AT_AT_ATr] = ACTIONS(320),
    [anon_sym_AT_AT_ATs] = ACTIONS(322),
    [anon_sym_AT_AT_ATst] = ACTIONS(320),
    [anon_sym_AT_AT_ATS] = ACTIONS(320),
    [anon_sym_AT_AT_ATm] = ACTIONS(320),
    [anon_sym_AT_AT_ATM] = ACTIONS(320),
    [anon_sym_AT_AT_ATf] = ACTIONS(322),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATF] = ACTIONS(322),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATt] = ACTIONS(320),
    [anon_sym_AT_AT] = ACTIONS(322),
    [anon_sym_AT_ATdbt] = ACTIONS(322),
    [anon_sym_AT_ATdbta] = ACTIONS(320),
    [anon_sym_AT_ATdbtb] = ACTIONS(320),
    [anon_sym_AT_ATdbts] = ACTIONS(320),
    [anon_sym_AT_AT_DOT] = ACTIONS(320),
    [anon_sym_AT_AT_EQ] = ACTIONS(320),
    [anon_sym_AT_ATk] = ACTIONS(320),
    [anon_sym_AT_ATt] = ACTIONS(320),
    [anon_sym_AT_ATb] = ACTIONS(320),
    [anon_sym_AT_ATi] = ACTIONS(322),
    [anon_sym_AT_ATiS] = ACTIONS(320),
    [anon_sym_AT_ATf] = ACTIONS(320),
    [anon_sym_AT_ATs_COLON] = ACTIONS(320),
    [anon_sym_AT_ATc_COLON] = ACTIONS(320),
    [anon_sym_AT] = ACTIONS(322),
    [anon_sym_AT_BANG] = ACTIONS(320),
    [anon_sym_AT_LBRACE] = ACTIONS(320),
    [anon_sym_ATa_COLON] = ACTIONS(320),
    [anon_sym_ATb_COLON] = ACTIONS(320),
    [anon_sym_ATB_COLON] = ACTIONS(320),
    [anon_sym_ATe_COLON] = ACTIONS(320),
    [anon_sym_ATF_COLON] = ACTIONS(320),
    [anon_sym_ATi_COLON] = ACTIONS(320),
    [anon_sym_ATk_COLON] = ACTIONS(320),
    [anon_sym_ATo_COLON] = ACTIONS(320),
    [anon_sym_ATr_COLON] = ACTIONS(320),
    [anon_sym_ATf_COLON] = ACTIONS(320),
    [anon_sym_ATs_COLON] = ACTIONS(320),
    [anon_sym_ATx_COLON] = ACTIONS(320),
    [anon_sym_PIPE_DOT] = ACTIONS(320),
    [anon_sym_EQ] = ACTIONS(320),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_SEMI] = ACTIONS(320),
    [anon_sym_GT] = ACTIONS(322),
    [anon_sym_GT_GT] = ACTIONS(320),
    [sym_html_redirect_operator] = ACTIONS(322),
    [sym_html_append_operator] = ACTIONS(320),
    [anon_sym_BQUOTE] = ACTIONS(320),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(320),
    [anon_sym_CR] = ACTIONS(320),
    [sym_file_descriptor] = ACTIONS(320),
    [sym__eq_sep_concat] = ACTIONS(320),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_PIPEH] = ACTIONS(320),
    [anon_sym_PIPET] = ACTIONS(320),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(320),
    [anon_sym_AT_AT_ATb] = ACTIONS(320),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATi] = ACTIONS(320),
    [anon_sym_AT_AT_ATr] = ACTIONS(320),
    [anon_sym_AT_AT_ATs] = ACTIONS(322),
    [anon_sym_AT_AT_ATst] = ACTIONS(320),
    [anon_sym_AT_AT_ATS] = ACTIONS(320),
    [anon_sym_AT_AT_ATm] = ACTIONS(320),
    [anon_sym_AT_AT_ATM] = ACTIONS(320),
    [anon_sym_AT_AT_ATf] = ACTIONS(322),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATF] = ACTIONS(322),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(320),
    [anon_sym_AT_AT_ATt] = ACTIONS(320),
    [anon_sym_AT_AT] = ACTIONS(322),
    [anon_sym_AT_ATdbt] = ACTIONS(322),
    [anon_sym_AT_ATdbta] = ACTIONS(320),
    [anon_sym_AT_ATdbtb] = ACTIONS(320),
    [anon_sym_AT_ATdbts] = ACTIONS(320),
    [anon_sym_AT_AT_DOT] = ACTIONS(320),
    [anon_sym_AT_AT_EQ] = ACTIONS(320),
    [anon_sym_AT_ATk] = ACTIONS(320),
    [anon_sym_AT_ATt] = ACTIONS(320),
    [anon_sym_AT_ATb] = ACTIONS(320),
    [anon_sym_AT_ATi] = ACTIONS(322),
    [anon_sym_AT_ATiS] = ACTIONS(320),
    [anon_sym_AT_ATf] = ACTIONS(320),
    [anon_sym_AT_ATs_COLON] = ACTIONS(320),
    [anon_sym_AT_ATc_COLON] = ACTIONS(320),
    [anon_sym_AT] = ACTIONS(322),
    [anon_sym_AT_BANG] = ACTIONS(320),
    [anon_sym_AT_LBRACE] = ACTIONS(320),
    [anon_sym_ATa_COLON] = ACTIONS(320),
    [anon_sym_ATb_COLON] = ACTIONS(320),
    [anon_sym_ATB_COLON] = ACTIONS(320),
    [anon_sym_ATe_COLON] = ACTIONS(320),
    [anon_sym_ATF_COLON] = ACTIONS(320),
    [anon_sym_ATi_COLON] = ACTIONS(320),
    [anon_sym_ATk_COLON] = ACTIONS(320),
    [anon_sym_ATo_COLON] = ACTIONS(320),
    [anon_sym_ATr_COLON] = ACTIONS(320),
    [anon_sym_ATf_COLON] = ACTIONS(320),
    [anon_sym_ATs_COLON] = ACTIONS(320),
    [anon_sym_ATx_COLON] = ACTIONS(320),
    [anon_sym_PIPE_DOT] = ACTIONS(320),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_SEMI] = ACTIONS(320),
    [anon_sym_GT] = ACTIONS(322),
    [anon_sym_GT_GT] = ACTIONS(320),
    [sym_html_redirect_operator] = ACTIONS(322),
    [sym_html_append_operator] = ACTIONS(320),
    [anon_sym_BQUOTE] = ACTIONS(320),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(320),
    [anon_sym_CR] = ACTIONS(320),
    [sym_file_descriptor] = ACTIONS(320),
    [sym__eq_sep_concat] = ACTIONS(320),
    [sym__concat] = ACTIONS(320),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(532),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_PIPE] = ACTIONS(534),
    [anon_sym_PIPEH] = ACTIONS(532),
    [anon_sym_PIPET] = ACTIONS(532),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(532),
    [anon_sym_AT_AT_ATb] = ACTIONS(532),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(532),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(532),
    [anon_sym_AT_AT_ATi] = ACTIONS(532),
    [anon_sym_AT_AT_ATr] = ACTIONS(532),
    [anon_sym_AT_AT_ATs] = ACTIONS(534),
    [anon_sym_AT_AT_ATst] = ACTIONS(532),
    [anon_sym_AT_AT_ATS] = ACTIONS(532),
    [anon_sym_AT_AT_ATm] = ACTIONS(532),
    [anon_sym_AT_AT_ATM] = ACTIONS(532),
    [anon_sym_AT_AT_ATf] = ACTIONS(534),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(532),
    [anon_sym_AT_AT_ATF] = ACTIONS(534),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(532),
    [anon_sym_AT_AT_ATt] = ACTIONS(532),
    [anon_sym_AT_AT] = ACTIONS(534),
    [anon_sym_AT_ATdbt] = ACTIONS(534),
    [anon_sym_AT_ATdbta] = ACTIONS(532),
    [anon_sym_AT_ATdbtb] = ACTIONS(532),
    [anon_sym_AT_ATdbts] = ACTIONS(532),
    [anon_sym_AT_AT_DOT] = ACTIONS(532),
    [anon_sym_AT_AT_EQ] = ACTIONS(532),
    [anon_sym_AT_ATk] = ACTIONS(532),
    [anon_sym_AT_ATt] = ACTIONS(532),
    [anon_sym_AT_ATb] = ACTIONS(532),
    [anon_sym_AT_ATi] = ACTIONS(534),
    [anon_sym_AT_ATiS] = ACTIONS(532),
    [anon_sym_AT_ATf] = ACTIONS(532),
    [anon_sym_AT_ATs_COLON] = ACTIONS(532),
    [anon_sym_AT_ATc_COLON] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(534),
    [anon_sym_AT_BANG] = ACTIONS(532),
    [anon_sym_AT_LBRACE] = ACTIONS(532),
    [anon_sym_ATa_COLON] = ACTIONS(532),
    [anon_sym_ATb_COLON] = ACTIONS(532),
    [anon_sym_ATB_COLON] = ACTIONS(532),
    [anon_sym_ATe_COLON] = ACTIONS(532),
    [anon_sym_ATF_COLON] = ACTIONS(532),
    [anon_sym_ATi_COLON] = ACTIONS(532),
    [anon_sym_ATk_COLON] = ACTIONS(532),
    [anon_sym_ATo_COLON] = ACTIONS(532),
    [anon_sym_ATr_COLON] = ACTIONS(532),
    [anon_sym_ATf_COLON] = ACTIONS(532),
    [anon_sym_ATs_COLON] = ACTIONS(532),
    [anon_sym_ATx_COLON] = ACTIONS(532),
    [anon_sym_PIPE_DOT] = ACTIONS(532),
    [anon_sym_EQ] = ACTIONS(532),
    [anon_sym_RPAREN] = ACTIONS(532),
    [anon_sym_SEMI] = ACTIONS(532),
    [anon_sym_GT] = ACTIONS(534),
    [anon_sym_GT_GT] = ACTIONS(532),
    [sym_html_redirect_operator] = ACTIONS(534),
    [sym_html_append_operator] = ACTIONS(532),
    [anon_sym_BQUOTE] = ACTIONS(532),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(532),
    [anon_sym_CR] = ACTIONS(532),
    [sym_file_descriptor] = ACTIONS(532),
    [sym__eq_sep_concat] = ACTIONS(532),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(328),
    [anon_sym_TILDE] = ACTIONS(328),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_PIPEH] = ACTIONS(328),
    [anon_sym_PIPET] = ACTIONS(328),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(328),
    [anon_sym_AT_AT_ATb] = ACTIONS(328),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATi] = ACTIONS(328),
    [anon_sym_AT_AT_ATr] = ACTIONS(328),
    [anon_sym_AT_AT_ATs] = ACTIONS(330),
    [anon_sym_AT_AT_ATst] = ACTIONS(328),
    [anon_sym_AT_AT_ATS] = ACTIONS(328),
    [anon_sym_AT_AT_ATm] = ACTIONS(328),
    [anon_sym_AT_AT_ATM] = ACTIONS(328),
    [anon_sym_AT_AT_ATf] = ACTIONS(330),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATF] = ACTIONS(330),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(328),
    [anon_sym_AT_AT_ATt] = ACTIONS(328),
    [anon_sym_AT_AT] = ACTIONS(330),
    [anon_sym_AT_ATdbt] = ACTIONS(330),
    [anon_sym_AT_ATdbta] = ACTIONS(328),
    [anon_sym_AT_ATdbtb] = ACTIONS(328),
    [anon_sym_AT_ATdbts] = ACTIONS(328),
    [anon_sym_AT_AT_DOT] = ACTIONS(328),
    [anon_sym_AT_AT_EQ] = ACTIONS(328),
    [anon_sym_AT_ATk] = ACTIONS(328),
    [anon_sym_AT_ATt] = ACTIONS(328),
    [anon_sym_AT_ATb] = ACTIONS(328),
    [anon_sym_AT_ATi] = ACTIONS(330),
    [anon_sym_AT_ATiS] = ACTIONS(328),
    [anon_sym_AT_ATf] = ACTIONS(328),
    [anon_sym_AT_ATs_COLON] = ACTIONS(328),
    [anon_sym_AT_ATc_COLON] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(330),
    [anon_sym_AT_BANG] = ACTIONS(328),
    [anon_sym_AT_LBRACE] = ACTIONS(328),
    [anon_sym_ATa_COLON] = ACTIONS(328),
    [anon_sym_ATb_COLON] = ACTIONS(328),
    [anon_sym_ATB_COLON] = ACTIONS(328),
    [anon_sym_ATe_COLON] = ACTIONS(328),
    [anon_sym_ATF_COLON] = ACTIONS(328),
    [anon_sym_ATi_COLON] = ACTIONS(328),
    [anon_sym_ATk_COLON] = ACTIONS(328),
    [anon_sym_ATo_COLON] = ACTIONS(328),
    [anon_sym_ATr_COLON] = ACTIONS(328),
    [anon_sym_ATf_COLON] = ACTIONS(328),
    [anon_sym_ATs_COLON] = ACTIONS(328),
    [anon_sym_ATx_COLON] = ACTIONS(328),
    [anon_sym_PIPE_DOT] = ACTIONS(328),
    [anon_sym_RPAREN] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_GT] = ACTIONS(330),
    [anon_sym_GT_GT] = ACTIONS(328),
    [sym_html_redirect_operator] = ACTIONS(330),
    [sym_html_append_operator] = ACTIONS(328),
    [anon_sym_BQUOTE] = ACTIONS(328),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(328),
    [anon_sym_CR] = ACTIONS(328),
    [sym_file_descriptor] = ACTIONS(328),
    [sym__eq_sep_concat] = ACTIONS(328),
    [sym__concat] = ACTIONS(328),
  },
  [169] = {
    [sym_macro_call_full_content] = STATE(267),
    [ts_builtin_sym_end] = ACTIONS(536),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_PIPE] = ACTIONS(538),
    [anon_sym_PIPEH] = ACTIONS(536),
    [anon_sym_PIPET] = ACTIONS(536),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(536),
    [anon_sym_AT_AT_ATb] = ACTIONS(536),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(536),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(536),
    [anon_sym_AT_AT_ATi] = ACTIONS(536),
    [anon_sym_AT_AT_ATr] = ACTIONS(536),
    [anon_sym_AT_AT_ATs] = ACTIONS(538),
    [anon_sym_AT_AT_ATst] = ACTIONS(536),
    [anon_sym_AT_AT_ATS] = ACTIONS(536),
    [anon_sym_AT_AT_ATm] = ACTIONS(536),
    [anon_sym_AT_AT_ATM] = ACTIONS(536),
    [anon_sym_AT_AT_ATf] = ACTIONS(538),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(536),
    [anon_sym_AT_AT_ATF] = ACTIONS(538),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(536),
    [anon_sym_AT_AT_ATt] = ACTIONS(536),
    [anon_sym_AT_AT] = ACTIONS(538),
    [anon_sym_AT_ATdbt] = ACTIONS(538),
    [anon_sym_AT_ATdbta] = ACTIONS(536),
    [anon_sym_AT_ATdbtb] = ACTIONS(536),
    [anon_sym_AT_ATdbts] = ACTIONS(536),
    [anon_sym_AT_AT_DOT] = ACTIONS(536),
    [anon_sym_AT_AT_EQ] = ACTIONS(536),
    [anon_sym_AT_ATk] = ACTIONS(536),
    [anon_sym_AT_ATt] = ACTIONS(536),
    [anon_sym_AT_ATb] = ACTIONS(536),
    [anon_sym_AT_ATi] = ACTIONS(538),
    [anon_sym_AT_ATiS] = ACTIONS(536),
    [anon_sym_AT_ATf] = ACTIONS(536),
    [anon_sym_AT_ATs_COLON] = ACTIONS(536),
    [anon_sym_AT_ATc_COLON] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(538),
    [anon_sym_AT_BANG] = ACTIONS(536),
    [anon_sym_AT_LBRACE] = ACTIONS(536),
    [anon_sym_ATa_COLON] = ACTIONS(536),
    [anon_sym_ATb_COLON] = ACTIONS(536),
    [anon_sym_ATB_COLON] = ACTIONS(536),
    [anon_sym_ATe_COLON] = ACTIONS(536),
    [anon_sym_ATF_COLON] = ACTIONS(536),
    [anon_sym_ATi_COLON] = ACTIONS(536),
    [anon_sym_ATk_COLON] = ACTIONS(536),
    [anon_sym_ATo_COLON] = ACTIONS(536),
    [anon_sym_ATr_COLON] = ACTIONS(536),
    [anon_sym_ATf_COLON] = ACTIONS(536),
    [anon_sym_ATs_COLON] = ACTIONS(536),
    [anon_sym_ATx_COLON] = ACTIONS(536),
    [anon_sym_PIPE_DOT] = ACTIONS(536),
    [anon_sym_LPAREN] = ACTIONS(540),
    [anon_sym_RPAREN] = ACTIONS(536),
    [anon_sym_SEMI] = ACTIONS(536),
    [anon_sym_GT] = ACTIONS(538),
    [anon_sym_GT_GT] = ACTIONS(536),
    [sym_html_redirect_operator] = ACTIONS(538),
    [sym_html_append_operator] = ACTIONS(536),
    [anon_sym_BQUOTE] = ACTIONS(536),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(536),
    [anon_sym_CR] = ACTIONS(536),
    [sym_file_descriptor] = ACTIONS(536),
  },
  [170] = {
    [aux_sym_concatenation_repeat1] = STATE(139),
    [ts_builtin_sym_end] = ACTIONS(312),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(314),
    [anon_sym_PIPEH] = ACTIONS(312),
    [anon_sym_PIPET] = ACTIONS(312),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(312),
    [anon_sym_AT_AT_ATb] = ACTIONS(312),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATi] = ACTIONS(312),
    [anon_sym_AT_AT_ATr] = ACTIONS(312),
    [anon_sym_AT_AT_ATs] = ACTIONS(314),
    [anon_sym_AT_AT_ATst] = ACTIONS(312),
    [anon_sym_AT_AT_ATS] = ACTIONS(312),
    [anon_sym_AT_AT_ATm] = ACTIONS(312),
    [anon_sym_AT_AT_ATM] = ACTIONS(312),
    [anon_sym_AT_AT_ATf] = ACTIONS(314),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATF] = ACTIONS(314),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(312),
    [anon_sym_AT_AT_ATt] = ACTIONS(312),
    [anon_sym_AT_AT] = ACTIONS(314),
    [anon_sym_AT_ATdbt] = ACTIONS(314),
    [anon_sym_AT_ATdbta] = ACTIONS(312),
    [anon_sym_AT_ATdbtb] = ACTIONS(312),
    [anon_sym_AT_ATdbts] = ACTIONS(312),
    [anon_sym_AT_AT_DOT] = ACTIONS(312),
    [anon_sym_AT_AT_EQ] = ACTIONS(312),
    [anon_sym_AT_ATk] = ACTIONS(312),
    [anon_sym_AT_ATt] = ACTIONS(312),
    [anon_sym_AT_ATb] = ACTIONS(312),
    [anon_sym_AT_ATi] = ACTIONS(314),
    [anon_sym_AT_ATiS] = ACTIONS(312),
    [anon_sym_AT_ATf] = ACTIONS(312),
    [anon_sym_AT_ATs_COLON] = ACTIONS(312),
    [anon_sym_AT_ATc_COLON] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_AT_BANG] = ACTIONS(312),
    [anon_sym_AT_LBRACE] = ACTIONS(312),
    [anon_sym_ATa_COLON] = ACTIONS(312),
    [anon_sym_ATb_COLON] = ACTIONS(312),
    [anon_sym_ATB_COLON] = ACTIONS(312),
    [anon_sym_ATe_COLON] = ACTIONS(312),
    [anon_sym_ATF_COLON] = ACTIONS(312),
    [anon_sym_ATi_COLON] = ACTIONS(312),
    [anon_sym_ATk_COLON] = ACTIONS(312),
    [anon_sym_ATo_COLON] = ACTIONS(312),
    [anon_sym_ATr_COLON] = ACTIONS(312),
    [anon_sym_ATf_COLON] = ACTIONS(312),
    [anon_sym_ATs_COLON] = ACTIONS(312),
    [anon_sym_ATx_COLON] = ACTIONS(312),
    [anon_sym_PIPE_DOT] = ACTIONS(312),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_SEMI] = ACTIONS(312),
    [anon_sym_GT] = ACTIONS(314),
    [anon_sym_GT_GT] = ACTIONS(312),
    [sym_html_redirect_operator] = ACTIONS(314),
    [sym_html_append_operator] = ACTIONS(312),
    [anon_sym_BQUOTE] = ACTIONS(312),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(312),
    [anon_sym_CR] = ACTIONS(312),
    [sym_file_descriptor] = ACTIONS(312),
    [sym__concat] = ACTIONS(502),
  },
  [171] = {
    [aux_sym_tmp_eval_args_repeat1] = STATE(156),
    [ts_builtin_sym_end] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_PIPE] = ACTIONS(544),
    [anon_sym_PIPEH] = ACTIONS(542),
    [anon_sym_PIPET] = ACTIONS(542),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(542),
    [anon_sym_AT_AT_ATb] = ACTIONS(542),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(542),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(542),
    [anon_sym_AT_AT_ATi] = ACTIONS(542),
    [anon_sym_AT_AT_ATr] = ACTIONS(542),
    [anon_sym_AT_AT_ATs] = ACTIONS(544),
    [anon_sym_AT_AT_ATst] = ACTIONS(542),
    [anon_sym_AT_AT_ATS] = ACTIONS(542),
    [anon_sym_AT_AT_ATm] = ACTIONS(542),
    [anon_sym_AT_AT_ATM] = ACTIONS(542),
    [anon_sym_AT_AT_ATf] = ACTIONS(544),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(542),
    [anon_sym_AT_AT_ATF] = ACTIONS(544),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(542),
    [anon_sym_AT_AT_ATt] = ACTIONS(542),
    [anon_sym_AT_AT] = ACTIONS(544),
    [anon_sym_AT_ATdbt] = ACTIONS(544),
    [anon_sym_AT_ATdbta] = ACTIONS(542),
    [anon_sym_AT_ATdbtb] = ACTIONS(542),
    [anon_sym_AT_ATdbts] = ACTIONS(542),
    [anon_sym_AT_AT_DOT] = ACTIONS(542),
    [anon_sym_AT_AT_EQ] = ACTIONS(542),
    [anon_sym_AT_ATk] = ACTIONS(542),
    [anon_sym_AT_ATt] = ACTIONS(542),
    [anon_sym_AT_ATb] = ACTIONS(542),
    [anon_sym_AT_ATi] = ACTIONS(544),
    [anon_sym_AT_ATiS] = ACTIONS(542),
    [anon_sym_AT_ATf] = ACTIONS(542),
    [anon_sym_AT_ATs_COLON] = ACTIONS(542),
    [anon_sym_AT_ATc_COLON] = ACTIONS(542),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_AT_BANG] = ACTIONS(542),
    [anon_sym_AT_LBRACE] = ACTIONS(542),
    [anon_sym_ATa_COLON] = ACTIONS(542),
    [anon_sym_ATb_COLON] = ACTIONS(542),
    [anon_sym_ATB_COLON] = ACTIONS(542),
    [anon_sym_ATe_COLON] = ACTIONS(542),
    [anon_sym_ATF_COLON] = ACTIONS(542),
    [anon_sym_ATi_COLON] = ACTIONS(542),
    [anon_sym_ATk_COLON] = ACTIONS(542),
    [anon_sym_ATo_COLON] = ACTIONS(542),
    [anon_sym_ATr_COLON] = ACTIONS(542),
    [anon_sym_ATf_COLON] = ACTIONS(542),
    [anon_sym_ATs_COLON] = ACTIONS(542),
    [anon_sym_ATx_COLON] = ACTIONS(542),
    [anon_sym_PIPE_DOT] = ACTIONS(542),
    [anon_sym_RPAREN] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_GT] = ACTIONS(544),
    [anon_sym_GT_GT] = ACTIONS(542),
    [sym_html_redirect_operator] = ACTIONS(544),
    [sym_html_append_operator] = ACTIONS(542),
    [anon_sym_COMMA] = ACTIONS(491),
    [anon_sym_BQUOTE] = ACTIONS(542),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(542),
    [anon_sym_CR] = ACTIONS(542),
    [sym_file_descriptor] = ACTIONS(542),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(344),
    [anon_sym_TILDE] = ACTIONS(344),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PIPEH] = ACTIONS(344),
    [anon_sym_PIPET] = ACTIONS(344),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(344),
    [anon_sym_AT_AT_ATb] = ACTIONS(344),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATi] = ACTIONS(344),
    [anon_sym_AT_AT_ATr] = ACTIONS(344),
    [anon_sym_AT_AT_ATs] = ACTIONS(346),
    [anon_sym_AT_AT_ATst] = ACTIONS(344),
    [anon_sym_AT_AT_ATS] = ACTIONS(344),
    [anon_sym_AT_AT_ATm] = ACTIONS(344),
    [anon_sym_AT_AT_ATM] = ACTIONS(344),
    [anon_sym_AT_AT_ATf] = ACTIONS(346),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATF] = ACTIONS(346),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(344),
    [anon_sym_AT_AT_ATt] = ACTIONS(344),
    [anon_sym_AT_AT] = ACTIONS(346),
    [anon_sym_AT_ATdbt] = ACTIONS(346),
    [anon_sym_AT_ATdbta] = ACTIONS(344),
    [anon_sym_AT_ATdbtb] = ACTIONS(344),
    [anon_sym_AT_ATdbts] = ACTIONS(344),
    [anon_sym_AT_AT_DOT] = ACTIONS(344),
    [anon_sym_AT_AT_EQ] = ACTIONS(344),
    [anon_sym_AT_ATk] = ACTIONS(344),
    [anon_sym_AT_ATt] = ACTIONS(344),
    [anon_sym_AT_ATb] = ACTIONS(344),
    [anon_sym_AT_ATi] = ACTIONS(346),
    [anon_sym_AT_ATiS] = ACTIONS(344),
    [anon_sym_AT_ATf] = ACTIONS(344),
    [anon_sym_AT_ATs_COLON] = ACTIONS(344),
    [anon_sym_AT_ATc_COLON] = ACTIONS(344),
    [anon_sym_AT] = ACTIONS(346),
    [anon_sym_AT_BANG] = ACTIONS(344),
    [anon_sym_AT_LBRACE] = ACTIONS(344),
    [anon_sym_ATa_COLON] = ACTIONS(344),
    [anon_sym_ATb_COLON] = ACTIONS(344),
    [anon_sym_ATB_COLON] = ACTIONS(344),
    [anon_sym_ATe_COLON] = ACTIONS(344),
    [anon_sym_ATF_COLON] = ACTIONS(344),
    [anon_sym_ATi_COLON] = ACTIONS(344),
    [anon_sym_ATk_COLON] = ACTIONS(344),
    [anon_sym_ATo_COLON] = ACTIONS(344),
    [anon_sym_ATr_COLON] = ACTIONS(344),
    [anon_sym_ATf_COLON] = ACTIONS(344),
    [anon_sym_ATs_COLON] = ACTIONS(344),
    [anon_sym_ATx_COLON] = ACTIONS(344),
    [anon_sym_PIPE_DOT] = ACTIONS(344),
    [anon_sym_EQ] = ACTIONS(344),
    [anon_sym_RPAREN] = ACTIONS(344),
    [anon_sym_SEMI] = ACTIONS(344),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_GT_GT] = ACTIONS(344),
    [sym_html_redirect_operator] = ACTIONS(346),
    [sym_html_append_operator] = ACTIONS(344),
    [anon_sym_BQUOTE] = ACTIONS(344),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(344),
    [anon_sym_CR] = ACTIONS(344),
    [sym_file_descriptor] = ACTIONS(344),
    [sym__eq_sep_concat] = ACTIONS(344),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(332),
    [anon_sym_TILDE] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(334),
    [anon_sym_PIPEH] = ACTIONS(332),
    [anon_sym_PIPET] = ACTIONS(332),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(332),
    [anon_sym_AT_AT_ATb] = ACTIONS(332),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATi] = ACTIONS(332),
    [anon_sym_AT_AT_ATr] = ACTIONS(332),
    [anon_sym_AT_AT_ATs] = ACTIONS(334),
    [anon_sym_AT_AT_ATst] = ACTIONS(332),
    [anon_sym_AT_AT_ATS] = ACTIONS(332),
    [anon_sym_AT_AT_ATm] = ACTIONS(332),
    [anon_sym_AT_AT_ATM] = ACTIONS(332),
    [anon_sym_AT_AT_ATf] = ACTIONS(334),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATF] = ACTIONS(334),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(332),
    [anon_sym_AT_AT_ATt] = ACTIONS(332),
    [anon_sym_AT_AT] = ACTIONS(334),
    [anon_sym_AT_ATdbt] = ACTIONS(334),
    [anon_sym_AT_ATdbta] = ACTIONS(332),
    [anon_sym_AT_ATdbtb] = ACTIONS(332),
    [anon_sym_AT_ATdbts] = ACTIONS(332),
    [anon_sym_AT_AT_DOT] = ACTIONS(332),
    [anon_sym_AT_AT_EQ] = ACTIONS(332),
    [anon_sym_AT_ATk] = ACTIONS(332),
    [anon_sym_AT_ATt] = ACTIONS(332),
    [anon_sym_AT_ATb] = ACTIONS(332),
    [anon_sym_AT_ATi] = ACTIONS(334),
    [anon_sym_AT_ATiS] = ACTIONS(332),
    [anon_sym_AT_ATf] = ACTIONS(332),
    [anon_sym_AT_ATs_COLON] = ACTIONS(332),
    [anon_sym_AT_ATc_COLON] = ACTIONS(332),
    [anon_sym_AT] = ACTIONS(334),
    [anon_sym_AT_BANG] = ACTIONS(332),
    [anon_sym_AT_LBRACE] = ACTIONS(332),
    [anon_sym_ATa_COLON] = ACTIONS(332),
    [anon_sym_ATb_COLON] = ACTIONS(332),
    [anon_sym_ATB_COLON] = ACTIONS(332),
    [anon_sym_ATe_COLON] = ACTIONS(332),
    [anon_sym_ATF_COLON] = ACTIONS(332),
    [anon_sym_ATi_COLON] = ACTIONS(332),
    [anon_sym_ATk_COLON] = ACTIONS(332),
    [anon_sym_ATo_COLON] = ACTIONS(332),
    [anon_sym_ATr_COLON] = ACTIONS(332),
    [anon_sym_ATf_COLON] = ACTIONS(332),
    [anon_sym_ATs_COLON] = ACTIONS(332),
    [anon_sym_ATx_COLON] = ACTIONS(332),
    [anon_sym_PIPE_DOT] = ACTIONS(332),
    [anon_sym_EQ] = ACTIONS(332),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_SEMI] = ACTIONS(332),
    [anon_sym_GT] = ACTIONS(334),
    [anon_sym_GT_GT] = ACTIONS(332),
    [sym_html_redirect_operator] = ACTIONS(334),
    [sym_html_append_operator] = ACTIONS(332),
    [anon_sym_BQUOTE] = ACTIONS(332),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(332),
    [anon_sym_CR] = ACTIONS(332),
    [sym_file_descriptor] = ACTIONS(332),
    [sym__eq_sep_concat] = ACTIONS(332),
  },
  [174] = {
    [ts_builtin_sym_end] = ACTIONS(316),
    [anon_sym_TILDE] = ACTIONS(316),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_PIPEH] = ACTIONS(316),
    [anon_sym_PIPET] = ACTIONS(316),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATi] = ACTIONS(316),
    [anon_sym_AT_AT_ATr] = ACTIONS(316),
    [anon_sym_AT_AT_ATs] = ACTIONS(318),
    [anon_sym_AT_AT_ATst] = ACTIONS(316),
    [anon_sym_AT_AT_ATS] = ACTIONS(316),
    [anon_sym_AT_AT_ATm] = ACTIONS(316),
    [anon_sym_AT_AT_ATM] = ACTIONS(316),
    [anon_sym_AT_AT_ATf] = ACTIONS(318),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATF] = ACTIONS(318),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(316),
    [anon_sym_AT_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_AT] = ACTIONS(318),
    [anon_sym_AT_ATdbt] = ACTIONS(318),
    [anon_sym_AT_ATdbta] = ACTIONS(316),
    [anon_sym_AT_ATdbtb] = ACTIONS(316),
    [anon_sym_AT_ATdbts] = ACTIONS(316),
    [anon_sym_AT_AT_DOT] = ACTIONS(316),
    [anon_sym_AT_AT_EQ] = ACTIONS(316),
    [anon_sym_AT_ATk] = ACTIONS(316),
    [anon_sym_AT_ATt] = ACTIONS(316),
    [anon_sym_AT_ATb] = ACTIONS(316),
    [anon_sym_AT_ATi] = ACTIONS(318),
    [anon_sym_AT_ATiS] = ACTIONS(316),
    [anon_sym_AT_ATf] = ACTIONS(316),
    [anon_sym_AT_ATs_COLON] = ACTIONS(316),
    [anon_sym_AT_ATc_COLON] = ACTIONS(316),
    [anon_sym_AT] = ACTIONS(318),
    [anon_sym_AT_BANG] = ACTIONS(316),
    [anon_sym_AT_LBRACE] = ACTIONS(316),
    [anon_sym_ATa_COLON] = ACTIONS(316),
    [anon_sym_ATb_COLON] = ACTIONS(316),
    [anon_sym_ATB_COLON] = ACTIONS(316),
    [anon_sym_ATe_COLON] = ACTIONS(316),
    [anon_sym_ATF_COLON] = ACTIONS(316),
    [anon_sym_ATi_COLON] = ACTIONS(316),
    [anon_sym_ATk_COLON] = ACTIONS(316),
    [anon_sym_ATo_COLON] = ACTIONS(316),
    [anon_sym_ATr_COLON] = ACTIONS(316),
    [anon_sym_ATf_COLON] = ACTIONS(316),
    [anon_sym_ATs_COLON] = ACTIONS(316),
    [anon_sym_ATx_COLON] = ACTIONS(316),
    [anon_sym_PIPE_DOT] = ACTIONS(316),
    [anon_sym_EQ] = ACTIONS(316),
    [anon_sym_RPAREN] = ACTIONS(316),
    [anon_sym_SEMI] = ACTIONS(316),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(316),
    [sym_html_redirect_operator] = ACTIONS(318),
    [sym_html_append_operator] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(316),
    [sym__comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(316),
    [anon_sym_CR] = ACTIONS(316),
    [sym_file_descriptor] = ACTIONS(316),
    [sym__concat_pf_dot] = ACTIONS(316),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(326), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(324), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [71] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(307), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(305), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [142] = 4,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(550), 1,
      anon_sym_EQ,
    ACTIONS(548), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(546), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [215] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(554), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(552), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [286] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(338), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(336), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [357] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(301), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(299), 53,
      sym_file_descriptor,
      sym__eq_sep_concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [428] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(558), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(556), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [499] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(523), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(521), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_COMMA,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [570] = 4,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(564), 1,
      anon_sym_COLON,
    ACTIONS(562), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(560), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [643] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(516), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(514), 53,
      sym_file_descriptor,
      sym__eq_sep_concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [714] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(568), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(566), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [785] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(342), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(340), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [856] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(334), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(332), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [927] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(572), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(570), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [998] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(318), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(316), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1069] = 7,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(398), 1,
      sym_file_descriptor,
    ACTIONS(404), 1,
      aux_sym_grep_specifier_token1,
    ACTIONS(508), 1,
      sym_grep_specifier_identifier,
    ACTIONS(510), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(141), 2,
      sym_cmd_substitution_arg,
      aux_sym_grep_specifier_repeat1,
    ACTIONS(400), 57,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_BQUOTE,
  [1148] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(318), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(316), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1219] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(330), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(328), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1290] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(322), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(320), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1361] = 59,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(576), 1,
      anon_sym_TILDE,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(580), 1,
      anon_sym_PIPEH,
    ACTIONS(582), 1,
      anon_sym_PIPET,
    ACTIONS(584), 1,
      anon_sym_AT_AT_AT_EQ,
    ACTIONS(586), 1,
      anon_sym_AT_AT_ATb,
    ACTIONS(588), 1,
      anon_sym_AT_AT_ATc_COLON,
    ACTIONS(590), 1,
      anon_sym_AT_AT_ATC_COLON,
    ACTIONS(592), 1,
      anon_sym_AT_AT_ATi,
    ACTIONS(594), 1,
      anon_sym_AT_AT_ATr,
    ACTIONS(596), 1,
      anon_sym_AT_AT_ATs,
    ACTIONS(598), 1,
      anon_sym_AT_AT_ATst,
    ACTIONS(600), 1,
      anon_sym_AT_AT_ATS,
    ACTIONS(602), 1,
      anon_sym_AT_AT_ATm,
    ACTIONS(604), 1,
      anon_sym_AT_AT_ATM,
    ACTIONS(606), 1,
      anon_sym_AT_AT_ATf,
    ACTIONS(608), 1,
      anon_sym_AT_AT_ATf_COLON,
    ACTIONS(610), 1,
      anon_sym_AT_AT_ATF,
    ACTIONS(612), 1,
      anon_sym_AT_AT_ATF_COLON,
    ACTIONS(614), 1,
      anon_sym_AT_AT_ATt,
    ACTIONS(616), 1,
      anon_sym_AT_AT,
    ACTIONS(618), 1,
      anon_sym_AT_ATdbt,
    ACTIONS(620), 1,
      anon_sym_AT_ATdbta,
    ACTIONS(622), 1,
      anon_sym_AT_ATdbtb,
    ACTIONS(624), 1,
      anon_sym_AT_ATdbts,
    ACTIONS(626), 1,
      anon_sym_AT_AT_DOT,
    ACTIONS(628), 1,
      anon_sym_AT_AT_EQ,
    ACTIONS(630), 1,
      anon_sym_AT_ATk,
    ACTIONS(632), 1,
      anon_sym_AT_ATt,
    ACTIONS(634), 1,
      anon_sym_AT_ATb,
    ACTIONS(636), 1,
      anon_sym_AT_ATi,
    ACTIONS(638), 1,
      anon_sym_AT_ATiS,
    ACTIONS(640), 1,
      anon_sym_AT_ATf,
    ACTIONS(642), 1,
      anon_sym_AT_ATs_COLON,
    ACTIONS(644), 1,
      anon_sym_AT_ATc_COLON,
    ACTIONS(646), 1,
      anon_sym_AT,
    ACTIONS(648), 1,
      anon_sym_AT_BANG,
    ACTIONS(650), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(652), 1,
      anon_sym_ATa_COLON,
    ACTIONS(654), 1,
      anon_sym_ATb_COLON,
    ACTIONS(656), 1,
      anon_sym_ATB_COLON,
    ACTIONS(658), 1,
      anon_sym_ATe_COLON,
    ACTIONS(660), 1,
      anon_sym_ATF_COLON,
    ACTIONS(662), 1,
      anon_sym_ATi_COLON,
    ACTIONS(664), 1,
      anon_sym_ATk_COLON,
    ACTIONS(666), 1,
      anon_sym_ATo_COLON,
    ACTIONS(668), 1,
      anon_sym_ATr_COLON,
    ACTIONS(670), 1,
      anon_sym_ATf_COLON,
    ACTIONS(672), 1,
      anon_sym_ATs_COLON,
    ACTIONS(674), 1,
      anon_sym_ATx_COLON,
    ACTIONS(676), 1,
      anon_sym_PIPE_DOT,
    ACTIONS(678), 1,
      anon_sym_GT,
    ACTIONS(680), 1,
      anon_sym_GT_GT,
    ACTIONS(682), 1,
      sym_html_redirect_operator,
    ACTIONS(684), 1,
      sym_html_append_operator,
    ACTIONS(686), 1,
      sym_file_descriptor,
    STATE(328), 3,
      sym__redirect_operator,
      sym_fdn_redirect_operator,
      sym_fdn_append_operator,
    ACTIONS(574), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR,
  [1544] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(690), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(688), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1615] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(346), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(344), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1686] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(694), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(692), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1756] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(316), 1,
      sym_file_descriptor,
    ACTIONS(318), 61,
      anon_sym_TILDE,
      sym_grep_specifier_identifier,
      aux_sym_grep_specifier_token1,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
  [1826] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(698), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(696), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1896] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(702), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(700), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1966] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(706), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(704), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2036] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(710), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(708), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2106] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(714), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(712), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2176] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(718), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(716), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2246] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(722), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(720), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2316] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(726), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(724), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2386] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(730), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(728), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2456] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(734), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(732), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2526] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(738), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(736), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2596] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(742), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(740), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2666] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(746), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(744), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2736] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(750), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(748), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2806] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(754), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(752), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2876] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(758), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(756), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2946] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(73), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(71), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3016] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(762), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(760), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3086] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(766), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(764), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3156] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(770), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(768), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3226] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(774), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(772), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3296] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(778), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(776), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3366] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(782), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(780), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3436] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(786), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(784), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3506] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(790), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(788), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3576] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(794), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(792), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3646] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(798), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(796), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3716] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(316), 1,
      sym_file_descriptor,
    ACTIONS(318), 61,
      anon_sym_TILDE,
      sym_grep_specifier_identifier,
      aux_sym_grep_specifier_token1,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
  [3786] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(802), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(800), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3856] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(806), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(804), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3926] = 4,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(812), 1,
      sym__concat_pf_dot,
    ACTIONS(810), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(808), 51,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_LF,
      anon_sym_CR,
  [3998] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(816), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(814), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4068] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(820), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(818), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4138] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(824), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(822), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4208] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(828), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(826), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4278] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(832), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(830), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4348] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(836), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(834), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4418] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(840), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(838), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4488] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(69), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(67), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4558] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(844), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(842), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4628] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(848), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(846), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4698] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(852), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(850), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4768] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(856), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(854), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4838] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(860), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(858), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4908] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(864), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(862), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4978] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(868), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(866), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5048] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(872), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(870), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5118] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(876), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(874), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5188] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(880), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(878), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5258] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(884), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(882), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5328] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(400), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(398), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5398] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(888), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(886), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5468] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(892), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(890), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5538] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(896), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(894), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5608] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(900), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(898), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5678] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(904), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(902), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5748] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(908), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(906), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5818] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(912), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(910), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5888] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(916), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(914), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5958] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(920), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(918), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6028] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(924), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(922), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6098] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(928), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(926), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6168] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(932), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(930), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6238] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(936), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(934), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6308] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(940), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(938), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6378] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(944), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(942), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6448] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(948), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(946), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6518] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(944), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(942), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6588] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(952), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(950), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6658] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(956), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(954), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6728] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(960), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(958), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6798] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(964), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(962), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6868] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(968), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(966), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6938] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(972), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(970), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7008] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(948), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(946), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7078] = 4,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(978), 1,
      anon_sym_EQ,
    ACTIONS(976), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(974), 51,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_LF,
      anon_sym_CR,
  [7150] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(982), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(980), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7220] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(986), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(984), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7290] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(990), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(988), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7360] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(994), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(992), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7430] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(998), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(996), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7500] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(1002), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1000), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7570] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(301), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(299), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7640] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(1006), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1004), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7710] = 3,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(1010), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1008), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7780] = 4,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(1016), 1,
      sym_pipe_second_command,
    ACTIONS(1012), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1014), 58,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_LF,
      anon_sym_CR,
  [7851] = 52,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(580), 1,
      anon_sym_PIPEH,
    ACTIONS(582), 1,
      anon_sym_PIPET,
    ACTIONS(584), 1,
      anon_sym_AT_AT_AT_EQ,
    ACTIONS(586), 1,
      anon_sym_AT_AT_ATb,
    ACTIONS(588), 1,
      anon_sym_AT_AT_ATc_COLON,
    ACTIONS(590), 1,
      anon_sym_AT_AT_ATC_COLON,
    ACTIONS(592), 1,
      anon_sym_AT_AT_ATi,
    ACTIONS(594), 1,
      anon_sym_AT_AT_ATr,
    ACTIONS(596), 1,
      anon_sym_AT_AT_ATs,
    ACTIONS(598), 1,
      anon_sym_AT_AT_ATst,
    ACTIONS(600), 1,
      anon_sym_AT_AT_ATS,
    ACTIONS(602), 1,
      anon_sym_AT_AT_ATm,
    ACTIONS(604), 1,
      anon_sym_AT_AT_ATM,
    ACTIONS(606), 1,
      anon_sym_AT_AT_ATf,
    ACTIONS(608), 1,
      anon_sym_AT_AT_ATf_COLON,
    ACTIONS(610), 1,
      anon_sym_AT_AT_ATF,
    ACTIONS(612), 1,
      anon_sym_AT_AT_ATF_COLON,
    ACTIONS(614), 1,
      anon_sym_AT_AT_ATt,
    ACTIONS(616), 1,
      anon_sym_AT_AT,
    ACTIONS(618), 1,
      anon_sym_AT_ATdbt,
    ACTIONS(620), 1,
      anon_sym_AT_ATdbta,
    ACTIONS(622), 1,
      anon_sym_AT_ATdbtb,
    ACTIONS(624), 1,
      anon_sym_AT_ATdbts,
    ACTIONS(626), 1,
      anon_sym_AT_AT_DOT,
    ACTIONS(628), 1,
      anon_sym_AT_AT_EQ,
    ACTIONS(630), 1,
      anon_sym_AT_ATk,
    ACTIONS(632), 1,
      anon_sym_AT_ATt,
    ACTIONS(634), 1,
      anon_sym_AT_ATb,
    ACTIONS(636), 1,
      anon_sym_AT_ATi,
    ACTIONS(638), 1,
      anon_sym_AT_ATiS,
    ACTIONS(640), 1,
      anon_sym_AT_ATf,
    ACTIONS(642), 1,
      anon_sym_AT_ATs_COLON,
    ACTIONS(644), 1,
      anon_sym_AT_ATc_COLON,
    ACTIONS(646), 1,
      anon_sym_AT,
    ACTIONS(648), 1,
      anon_sym_AT_BANG,
    ACTIONS(650), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(652), 1,
      anon_sym_ATa_COLON,
    ACTIONS(654), 1,
      anon_sym_ATb_COLON,
    ACTIONS(656), 1,
      anon_sym_ATB_COLON,
    ACTIONS(658), 1,
      anon_sym_ATe_COLON,
    ACTIONS(660), 1,
      anon_sym_ATF_COLON,
    ACTIONS(662), 1,
      anon_sym_ATi_COLON,
    ACTIONS(664), 1,
      anon_sym_ATk_COLON,
    ACTIONS(666), 1,
      anon_sym_ATo_COLON,
    ACTIONS(668), 1,
      anon_sym_ATr_COLON,
    ACTIONS(670), 1,
      anon_sym_ATf_COLON,
    ACTIONS(672), 1,
      anon_sym_ATs_COLON,
    ACTIONS(674), 1,
      anon_sym_ATx_COLON,
    ACTIONS(676), 1,
      anon_sym_PIPE_DOT,
    ACTIONS(1020), 3,
      anon_sym_PIPE,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1018), 9,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_LF,
      anon_sym_CR,
  [8018] = 52,
    ACTIONS(57), 1,
      sym__comment,
    ACTIONS(580), 1,
      anon_sym_PIPEH,
    ACTIONS(582), 1,
      anon_sym_PIPET,
    ACTIONS(584), 1,
      anon_sym_AT_AT_AT_EQ,
    ACTIONS(586), 1,
      anon_sym_AT_AT_ATb,
    ACTIONS(588), 1,
      anon_sym_AT_AT_ATc_COLON,
    ACTIONS(590), 1,
      anon_sym_AT_AT_ATC_COLON,
    ACTIONS(592), 1,
      anon_sym_AT_AT_ATi,
    ACTIONS(594), 1,
      anon_sym_AT_AT_ATr,
    ACTIONS(596), 1,
      anon_sym_AT_AT_ATs,
    ACTIONS(598), 1,
      anon_sym_AT_AT_ATst,
    ACTIONS(600), 1,
      anon_sym_AT_AT_ATS,
    ACTIONS(602), 1,
      anon_sym_AT_AT_ATm,
    ACTIONS(604), 1,
      anon_sym_AT_AT_ATM,
    ACTIONS(606), 1,
      anon_sym_AT_AT_ATf,
    ACTIONS(608), 1,
      anon_sym_AT_AT_ATf_COLON,
    ACTIONS(610), 1,
      anon_sym_AT_AT_ATF,
    ACTIONS(612), 1,
      anon_sym_AT_AT_ATF_COLON,
    ACTIONS(614), 1,
      anon_sym_AT_AT_ATt,
    ACTIONS(616), 1,
      anon_sym_AT_AT,
    ACTIONS(618), 1,
      anon_sym_AT_ATdbt,
    ACTIONS(620), 1,
      anon_sym_AT_ATdbta,
    ACTIONS(622), 1,
      anon_sym_AT_ATdbtb,
    ACTIONS(624), 1,
      anon_sym_AT_ATdbts,
    ACTIONS(626), 1,
      anon_sym_AT_AT_DOT,
    ACTIONS(628), 1,
      anon_sym_AT_AT_EQ,
    ACTIONS(630), 1,
      anon_sym_AT_ATk,
    ACTIONS(632), 1,
      anon_sym_AT_ATt,
    ACTIONS(634), 1,
      anon_sym_AT_ATb,
    ACTIONS(636), 1,
      anon_sym_AT_ATi,
    ACTIONS(638), 1,
      anon_sym_AT_ATiS,
    ACTIONS(640), 1,
      anon_sym_AT_ATf,
    ACTIONS(642), 1,
      anon_sym_AT_ATs_COLON,
    ACTIONS(644), 1,
      anon_sym_AT_ATc_COLON,
    ACTIONS(646), 1,
      anon_sym_AT,
    ACTIONS(648), 1,
      anon_sym_AT_BANG,
    ACTIONS(650), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(652), 1,
      anon_sym_ATa_COLON,
    ACTIONS(654), 1,
      anon_sym_ATb_COLON,
    ACTIONS(656), 1,
      anon_sym_ATB_COLON,
    ACTIONS(658), 1,
      anon_sym_ATe_COLON,
    ACTIONS(660), 1,
      anon_sym_ATF_COLON,
    ACTIONS(662), 1,
      anon_sym_ATi_COLON,
    ACTIONS(664), 1,
      anon_sym_ATk_COLON,
    ACTIONS(666), 1,
      anon_sym_ATo_COLON,
    ACTIONS(668), 1,
      anon_sym_ATr_COLON,
    ACTIONS(670), 1,
      anon_sym_ATf_COLON,
    ACTIONS(672), 1,
      anon_sym_ATs_COLON,
    ACTIONS(674), 1,
      anon_sym_ATx_COLON,
    ACTIONS(676), 1,
      anon_sym_PIPE_DOT,
    ACTIONS(1024), 3,
      anon_sym_PIPE,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1022), 9,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_RPAREN,
      anon_sym_SEM