// -*- mode: c++; indent-tabs-mode: nil -*-

/*  WebDavHandler module Copyright 2019 - 2022 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

namespace WebDavHandler {

//! Proxy  WebDavHandler inteface class.
class WebDavHandlerProxy : public AbstractWebDavHandler {

public:
protected:
        hash<string, AbstractWebDavHandler> m_ifaces;

public:

    //! Creates the object with an empty logger and an in-memory property handler
    /** @param interfaces the WebDAV handlers to proxy
    */
    constructor(hash<string, AbstractWebDavHandler> interfaces);


    //! Creates the object with the given argument and an in-memory property handler
    /** @param interfaces the WebDAV handlers to proxy
        @param virtual_relative_path_base the virtual base path for WebDavHandler requests; this path will be
        stripped from requests internally when serving WebDavHandler resources
    */
    constructor(hash<string, AbstractWebDavHandler> interfaces, string virtual_relative_path_base) ;


    //! Creates the object with the given arguments
    /** @param interfaces the WebDAV handlers to proxy
        @param logger the logger
        @param virtual_relative_path_base the virtual base path for WebDavHandler requests; this path will be
        stripped from requests internally when serving WebDavHandler resources
    */
    constructor(hash<string, AbstractWebDavHandler> interfaces, Logger logger, string virtual_relative_path_base = "/")
 ;


protected:
     __7_ hash<auto> handleChildRaw(string method_name, Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);
public:


protected:
     hash<HttpResponseInfo> handleChild(string method_name, Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);
public:


    /**
        GET

        Get a resource.
    */
    hash<HttpResponseInfo> handleGet(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        HEAD

        Same like GET but without sending a body.
    */
    hash<HttpResponseInfo> handleHead(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        POST

        Create new resource.
    */
    hash<HttpResponseInfo> handlePost(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        PUT

        Modify resource.
    */
    hash<HttpResponseInfo> handlePut(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        DELETE

        Delete a resource.
    */
    hash<HttpResponseInfo> handleDelete(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        COPY

        Copy a resource from one URI to another.
    */
    hash<HttpResponseInfo> handleCopy(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        MOVE

        Move a resource from one URI to another.
    */
    hash<HttpResponseInfo> handleMove(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        LOCK

        Put a lock on a resource. WebDavHandler supports both shared and exclusive locks.
    */
    hash<HttpResponseInfo> handleLock(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        UNLOCK

        Remove a lock from a resource.
    */
    hash<HttpResponseInfo> handleUnlock(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        MKCOL

        Create collections (aka a directory).
    */
    hash<HttpResponseInfo> handleMkcol(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        PROPFIND

        Retrieve properties, stored as XML, from a web resource. It is also
        overloaded to allow one to retrieve the collection structure (also
        known as directory hierarchy) of a remote system.
    */
    hash<HttpResponseInfo> handlePropfind(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);


    /**
        PROPPATCH

        Change and delete multiple properties on a resource in a single atomic act.
    */
    hash<HttpResponseInfo> handleProppatch(Socket sock, hash<auto> cx, hash<auto> hdr, __7_ data body);

}; // class WebDavHandlerProxy
}; // namespace WebDavHandler
