// -*- mode: c++; indent-tabs-mode: nil -*-
// Qore SaxDataProvider class definition

/*  SaxDataProvider.qc Copyright 2012 - 2022 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

//! The main namespace for the SaxDataProvider module
namespace SaxDataProvider {
//! Provides a data provider for reading XML files
/** Supports generic record search operators and options

    @note If the SAX iterator does not return a hash for each iteration, then this data provider will return A
    hash with the deserialized XML data returned in the \c data key
*/
class SaxDataProvider : public DataProvider::AbstractDataProvider {

public:
        //! Provider info
        const ProviderInfo = ...;


        //! Constructor options
        const ConstructorOptions = ...;


        //! XML iteration option list
        const CsvIterationOptionList = keys (ConstructorOptions - ("path", "stream"));

protected:
        //! the iterator object
        SaxIteratorWrapper i;

        //! the source location
        string location;

public:

    //! Creates the object from constructor options
    constructor(__7_ hash<auto> options);


    //! Returns the object name
    string getName();


    //! Returns an iterator for zero or more records matching the search options
    /** @param where_cond the search criteria
        @param search_options the search options after processing by validateSearchOptions()
    */
protected:
     AbstractDataProviderRecordIterator searchRecordsImpl(__7_ hash<auto> where_cond, __7_ hash<auto> search_options);
public:


    //! Returns an iterator for zero or more records matching the search options
    /** @param where_cond the search criteria
        @param search_options the search options after processing by validateSearchOptions()
    */
protected:
     AbstractDataProviderRecordIterator searchRecordsImpl(__7_ hash<DataProviderExpression> where_cond, *hash<auto> search_options);
public:


    //! Returns the description of the record type, if any
protected:
     __7_ hash<string, AbstractDataField> getRecordTypeImpl(__7_ hash<auto> search_options);
public:


    //! Returns data provider static info
protected:
     hash<DataProviderInfo> getStaticInfoImpl();
public:

};
};

// private namespace
namespace Priv {
class SaxIteratorWrapper : public AbstractIterator {

public:
protected:
        SaxIterator i;

public:

    constructor(SaxIterator i);


    bool next();


    hash<auto> getValue();


    bool valid();

};
};
