
/* $Id: catalog.q,v 1.3 2004/09/10 19:25:13 agraef Exp $
   catalog.q: Another demonstration of the xslt interface. */

/* This program illustrates how to translate an internal data structure to an
   XMLDoc object and then format the resulting XML as HTML, using an XSLT
   stylesheet. (Sample data and stylesheet have been pilfered from
   http://www.w3schools.com.) */

import xml;

/* The dataset. To simplify matters, we implement this here as a list of
   tuples. In a real application the data would probably come from a
   database. */

def DATA =
  [// title, artist, country, company, price, year
   ("Empire Burlesque","Bob Dylan","USA","Columbia",10.90,1985),
   ("Hide your heart","Bonnie Tyler","UK","CBS Records",9.90,1988),
   ("Greatest Hits","Dolly Parton","USA","RCA",9.90,1982),
   ("Still got the blues","Gary Moore","UK","Virgin records",10.20,1990),
   ("Eros","Eros Ramazzotti","EU","BMG",9.90,1997),
   ("One night only","Bee Gees","UK","Polydor",10.90,1998),
   ("Sylvias Mother","Dr.Hook","UK","CBS",8.10,1973),
   ("Maggie May","Rod Stewart","UK","Pickwick",8.50,1990),
   ("Romanza","Andrea Bocelli","EU","Polydor",10.80,1996),
   ("When a man loves a woman","Percy Sledge","USA","Atlantic",8.70,1987),
   ("Black angel","Savage Rose","EU","Mega",10.90,1995),
   ("1999 Grammy Nominees","Many","USA","Grammy",10.20,1999),
   ("For the good times","Kenny Rogers","UK","Mucik Master",8.70,1995),
   ("Big Willie style","Will Smith","USA","Columbia",9.90,1997),
   ("Tupelo Honey","Van Morrison","UK","Polydor",8.20,1971),
   ("Soulsville","Jorn Hoel","Norway","WEA",7.90,1996),
   ("The very best of","Cat Stevens","UK","Island",8.90,1990),
   ("Stop","Sam Brown","UK","A and M",8.90,1988),
   ("Bridge of Spies","T`Pau","UK","Siren",7.90,1987),
   ("Private Dancer","Tina Turner","UK","Capitol",8.90,1983),
   ("Midt om natten","Kim Larsen","EU","Medley",7.80,1983),
   ("Pavarotti Gala Concert","Luciano Pavarotti","UK","DECCA",9.90,1991),
   ("The dock of the bay","Otis Redding","USA","Atlantic",7.90,1987),
   ("Picture book","Simply Red","EU","Elektra",7.20,1985),
   ("Red","The Communards","UK","London",7.80,1987),
   ("Unchain my heart","Joe Cocker","USA","EMI",8.20,1987)];

/* The stylesheet. */

def STY = xslt_load_stylesheet "catalog.xsl";

/* Translate the data to an XML document (XMLDoc object). */

mkcd ROOT (TITLE,ARTIST,COUNTRY,COMPANY,PRICE,YEAR)
		= do (xml_add_last NODE)
		  [element_text "title" [] [] TITLE,
		   element_text "artist" [] [] ARTIST,
		   element_text "country" [] [] COUNTRY,
		   element_text "company" [] [] COMPANY,
		   element_text "price" [] [] (sprintf "%0.2f" PRICE),
		   element_text "year" [] [] (sprintf "%d" YEAR)]
		    where NODE:XMLNode =
		      xml_add_last ROOT (element "cd" [] []);

mkdoc DATA	= do (mkcd (xml_root DOC)) DATA || DOC
		    where DOC:XMLDoc =
		      xml_new_doc "1.0" () (element "catalog" [] []);

def DOC = mkdoc DATA;

/* Test the resulting XML. Prints the XML data on stdout. */

test		= xml_save_file "-" DOC () 0;

/* Apply the stylesheet to the data and save the resulting html in a file.
   Just invoke the html function and open catalog.html in your favourite
   browser to view the result. */

html		= xslt_save_result_file "catalog.html" RES STY 0
		    where RES:XMLDoc = xslt_apply_stylesheet STY DOC ();
