
/* The Q interpreter can actually perform computations with arbitrary
   "symbolic" expressions, and equations can be arbitrary rewriting
   rules. E.g., the following equations implement distributivity and
   associativity. Try with something like `square (A+B)'. */

(X+Y)*Z		= X*Z+Y*Z;
X*(Y+Z)		= X*Y+X*Z;

X+(Y+Z)		= (X+Y)+Z;
X*(Y*Z)		= (X*Y)*Z;

double X	= 2*X;
square X	= X*X;

/* Another tiny example: symbolic differentiation. E.g., try something like
   `diff X (5*square X+double X+10)'. */

diff X X	= 1;
diff X (U+V)	= diff X U + diff X V;
diff X (U*V)	= U*diff X V + V*diff X U;
diff X Y	= 0 otherwise;

/* A few additional simplification rules. */

X*0		= 0;
0*X		= 0;

X*1		= X;
1*X		= X;

X+0		= X;
0+X		= X;
