// This file is generated by Tools/cases_generator/generate_cases.py
// from:
//   Python/bytecodes.c
// Do not edit!

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include <stdbool.h>              // bool


#define IS_PSEUDO_INSTR(OP)  ( \
    ((OP) == LOAD_CLOSURE) || \
    ((OP) == STORE_FAST_MAYBE_NULL) || \
    ((OP) == LOAD_SUPER_METHOD) || \
    ((OP) == LOAD_ZERO_SUPER_METHOD) || \
    ((OP) == LOAD_ZERO_SUPER_ATTR) || \
    ((OP) == LOAD_METHOD) || \
    ((OP) == JUMP) || \
    ((OP) == JUMP_NO_INTERRUPT) || \
    ((OP) == SETUP_FINALLY) || \
    ((OP) == SETUP_CLEANUP) || \
    ((OP) == SETUP_WITH) || \
    ((OP) == POP_BLOCK) || \
    0)

#define _EXIT_TRACE 300
#define _SET_IP 301
#define _GUARD_BOTH_INT 302
#define _BINARY_OP_MULTIPLY_INT 303
#define _BINARY_OP_ADD_INT 304
#define _BINARY_OP_SUBTRACT_INT 305
#define _GUARD_BOTH_FLOAT 306
#define _BINARY_OP_MULTIPLY_FLOAT 307
#define _BINARY_OP_ADD_FLOAT 308
#define _BINARY_OP_SUBTRACT_FLOAT 309
#define _GUARD_BOTH_UNICODE 310
#define _BINARY_OP_ADD_UNICODE 311
#define _BINARY_OP_INPLACE_ADD_UNICODE 312
#define _POP_FRAME 313
#define _GUARD_GLOBALS_VERSION 314
#define _GUARD_BUILTINS_VERSION 315
#define _LOAD_GLOBAL_MODULE 316
#define _LOAD_GLOBAL_BUILTINS 317
#define _GUARD_TYPE_VERSION 318
#define _CHECK_MANAGED_OBJECT_HAS_VALUES 319
#define _LOAD_ATTR_INSTANCE_VALUE 320
#define _CHECK_ATTR_MODULE 321
#define _LOAD_ATTR_MODULE 322
#define _CHECK_ATTR_WITH_HINT 323
#define _LOAD_ATTR_WITH_HINT 324
#define _LOAD_ATTR_SLOT 325
#define _CHECK_ATTR_CLASS 326
#define _LOAD_ATTR_CLASS 327
#define _GUARD_DORV_VALUES 328
#define _STORE_ATTR_INSTANCE_VALUE 329
#define _STORE_ATTR_SLOT 330
#define _IS_NONE 331
#define _ITER_CHECK_LIST 332
#define _ITER_JUMP_LIST 333
#define _IS_ITER_EXHAUSTED_LIST 334
#define _ITER_NEXT_LIST 335
#define _ITER_CHECK_TUPLE 336
#define _ITER_JUMP_TUPLE 337
#define _IS_ITER_EXHAUSTED_TUPLE 338
#define _ITER_NEXT_TUPLE 339
#define _ITER_CHECK_RANGE 340
#define _ITER_JUMP_RANGE 341
#define _IS_ITER_EXHAUSTED_RANGE 342
#define _ITER_NEXT_RANGE 343
#define _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT 344
#define _GUARD_KEYS_VERSION 345
#define _LOAD_ATTR_METHOD_WITH_VALUES 346
#define _LOAD_ATTR_METHOD_NO_DICT 347
#define _LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES 348
#define _LOAD_ATTR_NONDESCRIPTOR_NO_DICT 349
#define _CHECK_ATTR_METHOD_LAZY_DICT 350
#define _LOAD_ATTR_METHOD_LAZY_DICT 351
#define _CHECK_CALL_BOUND_METHOD_EXACT_ARGS 352
#define _INIT_CALL_BOUND_METHOD_EXACT_ARGS 353
#define _CHECK_PEP_523 354
#define _CHECK_FUNCTION_EXACT_ARGS 355
#define _CHECK_STACK_SPACE 356
#define _INIT_CALL_PY_EXACT_ARGS 357
#define _PUSH_FRAME 358
#define _POP_JUMP_IF_FALSE 359
#define _POP_JUMP_IF_TRUE 360
#define _JUMP_TO_TOP 361
#define _SAVE_CURRENT_IP 362
#define _INSERT 363

extern int _PyOpcode_num_popped(int opcode, int oparg, bool jump);
#ifdef NEED_OPCODE_METADATA
int _PyOpcode_num_popped(int opcode, int oparg, bool jump)  {
    switch(opcode) {
        case NOP:
            return 0;
        case RESUME:
            return 0;
        case RESUME_CHECK:
            return 0;
        case INSTRUMENTED_RESUME:
            return 0;
        case LOAD_CLOSURE:
            return 0;
        case LOAD_FAST_CHECK:
            return 0;
        case LOAD_FAST:
            return 0;
        case LOAD_FAST_AND_CLEAR:
            return 0;
        case LOAD_FAST_LOAD_FAST:
            return 0;
        case LOAD_CONST:
            return 0;
        case STORE_FAST:
            return 1;
        case STORE_FAST_MAYBE_NULL:
            return 1;
        case STORE_FAST_LOAD_FAST:
            return 1;
        case STORE_FAST_STORE_FAST:
            return 2;
        case POP_TOP:
            return 1;
        case PUSH_NULL:
            return 0;
        case END_FOR:
            return 2;
        case INSTRUMENTED_END_FOR:
            return 2;
        case END_SEND:
            return 2;
        case INSTRUMENTED_END_SEND:
            return 2;
        case UNARY_NEGATIVE:
            return 1;
        case UNARY_NOT:
            return 1;
        case TO_BOOL:
            return 1;
        case TO_BOOL_BOOL:
            return 1;
        case TO_BOOL_INT:
            return 1;
        case TO_BOOL_LIST:
            return 1;
        case TO_BOOL_NONE:
            return 1;
        case TO_BOOL_STR:
            return 1;
        case TO_BOOL_ALWAYS_TRUE:
            return 1;
        case UNARY_INVERT:
            return 1;
        case _GUARD_BOTH_INT:
            return 2;
        case _BINARY_OP_MULTIPLY_INT:
            return 2;
        case _BINARY_OP_ADD_INT:
            return 2;
        case _BINARY_OP_SUBTRACT_INT:
            return 2;
        case BINARY_OP_MULTIPLY_INT:
            return 2;
        case BINARY_OP_ADD_INT:
            return 2;
        case BINARY_OP_SUBTRACT_INT:
            return 2;
        case _GUARD_BOTH_FLOAT:
            return 2;
        case _BINARY_OP_MULTIPLY_FLOAT:
            return 2;
        case _BINARY_OP_ADD_FLOAT:
            return 2;
        case _BINARY_OP_SUBTRACT_FLOAT:
            return 2;
        case BINARY_OP_MULTIPLY_FLOAT:
            return 2;
        case BINARY_OP_ADD_FLOAT:
            return 2;
        case BINARY_OP_SUBTRACT_FLOAT:
            return 2;
        case _GUARD_BOTH_UNICODE:
            return 2;
        case _BINARY_OP_ADD_UNICODE:
            return 2;
        case BINARY_OP_ADD_UNICODE:
            return 2;
        case _BINARY_OP_INPLACE_ADD_UNICODE:
            return 2;
        case BINARY_OP_INPLACE_ADD_UNICODE:
            return 2;
        case BINARY_SUBSCR:
            return 2;
        case BINARY_SLICE:
            return 3;
        case STORE_SLICE:
            return 4;
        case BINARY_SUBSCR_LIST_INT:
            return 2;
        case BINARY_SUBSCR_STR_INT:
            return 2;
        case BINARY_SUBSCR_TUPLE_INT:
            return 2;
        case BINARY_SUBSCR_DICT:
            return 2;
        case BINARY_SUBSCR_GETITEM:
            return 2;
        case LIST_APPEND:
            return (oparg-1) + 2;
        case SET_ADD:
            return (oparg-1) + 2;
        case STORE_SUBSCR:
            return 3;
        case STORE_SUBSCR_LIST_INT:
            return 3;
        case STORE_SUBSCR_DICT:
            return 3;
        case DELETE_SUBSCR:
            return 2;
        case CALL_INTRINSIC_1:
            return 1;
        case CALL_INTRINSIC_2:
            return 2;
        case RAISE_VARARGS:
            return oparg;
        case INTERPRETER_EXIT:
            return 1;
        case _POP_FRAME:
            return 1;
        case RETURN_VALUE:
            return 1;
        case INSTRUMENTED_RETURN_VALUE:
            return 1;
        case RETURN_CONST:
            return 0;
        case INSTRUMENTED_RETURN_CONST:
            return 0;
        case GET_AITER:
            return 1;
        case GET_ANEXT:
            return 1;
        case GET_AWAITABLE:
            return 1;
        case SEND:
            return 2;
        case SEND_GEN:
            return 2;
        case INSTRUMENTED_YIELD_VALUE:
            return 1;
        case YIELD_VALUE:
            return 1;
        case POP_EXCEPT:
            return 1;
        case RERAISE:
            return oparg + 1;
        case END_ASYNC_FOR:
            return 2;
        case CLEANUP_THROW:
            return 3;
        case LOAD_ASSERTION_ERROR:
            return 0;
        case LOAD_BUILD_CLASS:
            return 0;
        case STORE_NAME:
            return 1;
        case DELETE_NAME:
            return 0;
        case UNPACK_SEQUENCE:
            return 1;
        case UNPACK_SEQUENCE_TWO_TUPLE:
            return 1;
        case UNPACK_SEQUENCE_TUPLE:
            return 1;
        case UNPACK_SEQUENCE_LIST:
            return 1;
        case UNPACK_EX:
            return 1;
        case STORE_ATTR:
            return 2;
        case DELETE_ATTR:
            return 1;
        case STORE_GLOBAL:
            return 1;
        case DELETE_GLOBAL:
            return 0;
        case LOAD_LOCALS:
            return 0;
        case LOAD_FROM_DICT_OR_GLOBALS:
            return 1;
        case LOAD_NAME:
            return 0;
        case LOAD_GLOBAL:
            return 0;
        case _GUARD_GLOBALS_VERSION:
            return 0;
        case _GUARD_BUILTINS_VERSION:
            return 0;
        case _LOAD_GLOBAL_MODULE:
            return 0;
        case _LOAD_GLOBAL_BUILTINS:
            return 0;
        case LOAD_GLOBAL_MODULE:
            return 0;
        case LOAD_GLOBAL_BUILTIN:
            return 0;
        case DELETE_FAST:
            return 0;
        case MAKE_CELL:
            return 0;
        case DELETE_DEREF:
            return 0;
        case LOAD_FROM_DICT_OR_DEREF:
            return 1;
        case LOAD_DEREF:
            return 0;
        case STORE_DEREF:
            return 1;
        case COPY_FREE_VARS:
            return 0;
        case BUILD_STRING:
            return oparg;
        case BUILD_TUPLE:
            return oparg;
        case BUILD_LIST:
            return oparg;
        case LIST_EXTEND:
            return (oparg-1) + 2;
        case SET_UPDATE:
            return (oparg-1) + 2;
        case BUILD_SET:
            return oparg;
        case BUILD_MAP:
            return oparg*2;
        case SETUP_ANNOTATIONS:
            return 0;
        case BUILD_CONST_KEY_MAP:
            return oparg + 1;
        case DICT_UPDATE:
            return (oparg - 1) + 2;
        case DICT_MERGE:
            return (oparg - 1) + 5;
        case MAP_ADD:
            return (oparg - 1) + 3;
        case INSTRUMENTED_LOAD_SUPER_ATTR:
            return 3;
        case LOAD_SUPER_ATTR:
            return 3;
        case LOAD_SUPER_METHOD:
            return 3;
        case LOAD_ZERO_SUPER_METHOD:
            return 3;
        case LOAD_ZERO_SUPER_ATTR:
            return 3;
        case LOAD_SUPER_ATTR_ATTR:
            return 3;
        case LOAD_SUPER_ATTR_METHOD:
            return 3;
        case LOAD_ATTR:
            return 1;
        case LOAD_METHOD:
            return 1;
        case _GUARD_TYPE_VERSION:
            return 1;
        case _CHECK_MANAGED_OBJECT_HAS_VALUES:
            return 1;
        case _LOAD_ATTR_INSTANCE_VALUE:
            return 1;
        case LOAD_ATTR_INSTANCE_VALUE:
            return 1;
        case _CHECK_ATTR_MODULE:
            return 1;
        case _LOAD_ATTR_MODULE:
            return 1;
        case LOAD_ATTR_MODULE:
            return 1;
        case _CHECK_ATTR_WITH_HINT:
            return 1;
        case _LOAD_ATTR_WITH_HINT:
            return 1;
        case LOAD_ATTR_WITH_HINT:
            return 1;
        case _LOAD_ATTR_SLOT:
            return 1;
        case LOAD_ATTR_SLOT:
            return 1;
        case _CHECK_ATTR_CLASS:
            return 1;
        case _LOAD_ATTR_CLASS:
            return 1;
        case LOAD_ATTR_CLASS:
            return 1;
        case LOAD_ATTR_PROPERTY:
            return 1;
        case LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN:
            return 1;
        case _GUARD_DORV_VALUES:
            return 1;
        case _STORE_ATTR_INSTANCE_VALUE:
            return 2;
        case STORE_ATTR_INSTANCE_VALUE:
            return 2;
        case STORE_ATTR_WITH_HINT:
            return 2;
        case _STORE_ATTR_SLOT:
            return 2;
        case STORE_ATTR_SLOT:
            return 2;
        case COMPARE_OP:
            return 2;
        case COMPARE_OP_FLOAT:
            return 2;
        case COMPARE_OP_INT:
            return 2;
        case COMPARE_OP_STR:
            return 2;
        case IS_OP:
            return 2;
        case CONTAINS_OP:
            return 2;
        case CHECK_EG_MATCH:
            return 2;
        case CHECK_EXC_MATCH:
            return 2;
        case IMPORT_NAME:
            return 2;
        case IMPORT_FROM:
            return 1;
        case JUMP_FORWARD:
            return 0;
        case JUMP_BACKWARD:
            return 0;
        case JUMP:
            return 0;
        case JUMP_NO_INTERRUPT:
            return 0;
        case ENTER_EXECUTOR:
            return 0;
        case POP_JUMP_IF_FALSE:
            return 1;
        case POP_JUMP_IF_TRUE:
            return 1;
        case _IS_NONE:
            return 1;
        case POP_JUMP_IF_NONE:
            return 1;
        case POP_JUMP_IF_NOT_NONE:
            return 1;
        case JUMP_BACKWARD_NO_INTERRUPT:
            return 0;
        case GET_LEN:
            return 1;
        case MATCH_CLASS:
            return 3;
        case MATCH_MAPPING:
            return 1;
        case MATCH_SEQUENCE:
            return 1;
        case MATCH_KEYS:
            return 2;
        case GET_ITER:
            return 1;
        case GET_YIELD_FROM_ITER:
            return 1;
        case FOR_ITER:
            return 1;
        case INSTRUMENTED_FOR_ITER:
            return 0;
        case _ITER_CHECK_LIST:
            return 1;
        case _ITER_JUMP_LIST:
            return 1;
        case _IS_ITER_EXHAUSTED_LIST:
            return 1;
        case _ITER_NEXT_LIST:
            return 1;
        case FOR_ITER_LIST:
            return 1;
        case _ITER_CHECK_TUPLE:
            return 1;
        case _ITER_JUMP_TUPLE:
            return 1;
        case _IS_ITER_EXHAUSTED_TUPLE:
            return 1;
        case _ITER_NEXT_TUPLE:
            return 1;
        case FOR_ITER_TUPLE:
            return 1;
        case _ITER_CHECK_RANGE:
            return 1;
        case _ITER_JUMP_RANGE:
            return 1;
        case _IS_ITER_EXHAUSTED_RANGE:
            return 1;
        case _ITER_NEXT_RANGE:
            return 1;
        case FOR_ITER_RANGE:
            return 1;
        case FOR_ITER_GEN:
            return 1;
        case BEFORE_ASYNC_WITH:
            return 1;
        case BEFORE_WITH:
            return 1;
        case WITH_EXCEPT_START:
            return 4;
        case SETUP_FINALLY:
            return 0;
        case SETUP_CLEANUP:
            return 0;
        case SETUP_WITH:
            return 0;
        case POP_BLOCK:
            return 0;
        case PUSH_EXC_INFO:
            return 1;
        case _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT:
            return 1;
        case _GUARD_KEYS_VERSION:
            return 1;
        case _LOAD_ATTR_METHOD_WITH_VALUES:
            return 1;
        case LOAD_ATTR_METHOD_WITH_VALUES:
            return 1;
        case _LOAD_ATTR_METHOD_NO_DICT:
            return 1;
        case LOAD_ATTR_METHOD_NO_DICT:
            return 1;
        case _LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES:
            return 1;
        case LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES:
            return 1;
        case _LOAD_ATTR_NONDESCRIPTOR_NO_DICT:
            return 1;
        case LOAD_ATTR_NONDESCRIPTOR_NO_DICT:
            return 1;
        case _CHECK_ATTR_METHOD_LAZY_DICT:
            return 1;
        case _LOAD_ATTR_METHOD_LAZY_DICT:
            return 1;
        case LOAD_ATTR_METHOD_LAZY_DICT:
            return 1;
        case INSTRUMENTED_CALL:
            return 0;
        case CALL:
            return oparg + 2;
        case _CHECK_CALL_BOUND_METHOD_EXACT_ARGS:
            return oparg + 2;
        case _INIT_CALL_BOUND_METHOD_EXACT_ARGS:
            return oparg + 2;
        case _CHECK_PEP_523:
            return 0;
        case _CHECK_FUNCTION_EXACT_ARGS:
            return oparg + 2;
        case _CHECK_STACK_SPACE:
            return oparg + 2;
        case _INIT_CALL_PY_EXACT_ARGS:
            return oparg + 2;
        case _PUSH_FRAME:
            return 1;
        case CALL_BOUND_METHOD_EXACT_ARGS:
            return oparg + 2;
        case CALL_PY_EXACT_ARGS:
            return oparg + 2;
        case CALL_PY_WITH_DEFAULTS:
            return oparg + 2;
        case CALL_TYPE_1:
            return oparg + 2;
        case CALL_STR_1:
            return oparg + 2;
        case CALL_TUPLE_1:
            return oparg + 2;
        case CALL_ALLOC_AND_ENTER_INIT:
            return oparg + 2;
        case EXIT_INIT_CHECK:
            return 1;
        case CALL_BUILTIN_CLASS:
            return oparg + 2;
        case CALL_BUILTIN_O:
            return oparg + 2;
        case CALL_BUILTIN_FAST:
            return oparg + 2;
        case CALL_BUILTIN_FAST_WITH_KEYWORDS:
            return oparg + 2;
        case CALL_LEN:
            return oparg + 2;
        case CALL_ISINSTANCE:
            return oparg + 2;
        case CALL_LIST_APPEND:
            return oparg + 2;
        case CALL_METHOD_DESCRIPTOR_O:
            return oparg + 2;
        case CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS:
            return oparg + 2;
        case CALL_METHOD_DESCRIPTOR_NOARGS:
            return oparg + 2;
        case CALL_METHOD_DESCRIPTOR_FAST:
            return oparg + 2;
        case INSTRUMENTED_CALL_KW:
            return 0;
        case CALL_KW:
            return oparg + 3;
        case INSTRUMENTED_CALL_FUNCTION_EX:
            return 0;
        case CALL_FUNCTION_EX:
            return ((oparg & 1) ? 1 : 0) + 3;
        case MAKE_FUNCTION:
            return 1;
        case SET_FUNCTION_ATTRIBUTE:
            return 2;
        case RETURN_GENERATOR:
            return 0;
        case BUILD_SLICE:
            return ((oparg == 3) ? 1 : 0) + 2;
        case CONVERT_VALUE:
            return 1;
        case FORMAT_SIMPLE:
            return 1;
        case FORMAT_WITH_SPEC:
            return 2;
        case COPY:
            return (oparg-1) + 1;
        case BINARY_OP:
            return 2;
        case SWAP:
            return (oparg-2) + 2;
        case INSTRUMENTED_INSTRUCTION:
            return 0;
        case INSTRUMENTED_JUMP_FORWARD:
            return 0;
        case INSTRUMENTED_JUMP_BACKWARD:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_TRUE:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_FALSE:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_NONE:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_NOT_NONE:
            return 0;
        case EXTENDED_ARG:
            return 0;
        case CACHE:
            return 0;
        case RESERVED:
            return 0;
        case _POP_JUMP_IF_FALSE:
            return 1;
        case _POP_JUMP_IF_TRUE:
            return 1;
        case _JUMP_TO_TOP:
            return 0;
        case _SET_IP:
            return 0;
        case _SAVE_CURRENT_IP:
            return 0;
        case _EXIT_TRACE:
            return 0;
        case _INSERT:
            return oparg + 1;
        default:
            return -1;
    }
}
#endif // NEED_OPCODE_METADATA

extern int _PyOpcode_num_pushed(int opcode, int oparg, bool jump);
#ifdef NEED_OPCODE_METADATA
int _PyOpcode_num_pushed(int opcode, int oparg, bool jump)  {
    switch(opcode) {
        case NOP:
            return 0;
        case RESUME:
            return 0;
        case RESUME_CHECK:
            return 0;
        case INSTRUMENTED_RESUME:
            return 0;
        case LOAD_CLOSURE:
            return 1;
        case LOAD_FAST_CHECK:
            return 1;
        case LOAD_FAST:
            return 1;
        case LOAD_FAST_AND_CLEAR:
            return 1;
        case LOAD_FAST_LOAD_FAST:
            return 2;
        case LOAD_CONST:
            return 1;
        case STORE_FAST:
            return 0;
        case STORE_FAST_MAYBE_NULL:
            return 0;
        case STORE_FAST_LOAD_FAST:
            return 1;
        case STORE_FAST_STORE_FAST:
            return 0;
        case POP_TOP:
            return 0;
        case PUSH_NULL:
            return 1;
        case END_FOR:
            return 0;
        case INSTRUMENTED_END_FOR:
            return 0;
        case END_SEND:
            return 1;
        case INSTRUMENTED_END_SEND:
            return 1;
        case UNARY_NEGATIVE:
            return 1;
        case UNARY_NOT:
            return 1;
        case TO_BOOL:
            return 1;
        case TO_BOOL_BOOL:
            return 1;
        case TO_BOOL_INT:
            return 1;
        case TO_BOOL_LIST:
            return 1;
        case TO_BOOL_NONE:
            return 1;
        case TO_BOOL_STR:
            return 1;
        case TO_BOOL_ALWAYS_TRUE:
            return 1;
        case UNARY_INVERT:
            return 1;
        case _GUARD_BOTH_INT:
            return 2;
        case _BINARY_OP_MULTIPLY_INT:
            return 1;
        case _BINARY_OP_ADD_INT:
            return 1;
        case _BINARY_OP_SUBTRACT_INT:
            return 1;
        case BINARY_OP_MULTIPLY_INT:
            return 1;
        case BINARY_OP_ADD_INT:
            return 1;
        case BINARY_OP_SUBTRACT_INT:
            return 1;
        case _GUARD_BOTH_FLOAT:
            return 2;
        case _BINARY_OP_MULTIPLY_FLOAT:
            return 1;
        case _BINARY_OP_ADD_FLOAT:
            return 1;
        case _BINARY_OP_SUBTRACT_FLOAT:
            return 1;
        case BINARY_OP_MULTIPLY_FLOAT:
            return 1;
        case BINARY_OP_ADD_FLOAT:
            return 1;
        case BINARY_OP_SUBTRACT_FLOAT:
            return 1;
        case _GUARD_BOTH_UNICODE:
            return 2;
        case _BINARY_OP_ADD_UNICODE:
            return 1;
        case BINARY_OP_ADD_UNICODE:
            return 1;
        case _BINARY_OP_INPLACE_ADD_UNICODE:
            return 0;
        case BINARY_OP_INPLACE_ADD_UNICODE:
            return 0;
        case BINARY_SUBSCR:
            return 1;
        case BINARY_SLICE:
            return 1;
        case STORE_SLICE:
            return 0;
        case BINARY_SUBSCR_LIST_INT:
            return 1;
        case BINARY_SUBSCR_STR_INT:
            return 1;
        case BINARY_SUBSCR_TUPLE_INT:
            return 1;
        case BINARY_SUBSCR_DICT:
            return 1;
        case BINARY_SUBSCR_GETITEM:
            return 1;
        case LIST_APPEND:
            return (oparg-1) + 1;
        case SET_ADD:
            return (oparg-1) + 1;
        case STORE_SUBSCR:
            return 0;
        case STORE_SUBSCR_LIST_INT:
            return 0;
        case STORE_SUBSCR_DICT:
            return 0;
        case DELETE_SUBSCR:
            return 0;
        case CALL_INTRINSIC_1:
            return 1;
        case CALL_INTRINSIC_2:
            return 1;
        case RAISE_VARARGS:
            return 0;
        case INTERPRETER_EXIT:
            return 0;
        case _POP_FRAME:
            return 0;
        case RETURN_VALUE:
            return 0;
        case INSTRUMENTED_RETURN_VALUE:
            return 0;
        case RETURN_CONST:
            return 0;
        case INSTRUMENTED_RETURN_CONST:
            return 0;
        case GET_AITER:
            return 1;
        case GET_ANEXT:
            return 2;
        case GET_AWAITABLE:
            return 1;
        case SEND:
            return 2;
        case SEND_GEN:
            return 2;
        case INSTRUMENTED_YIELD_VALUE:
            return 1;
        case YIELD_VALUE:
            return 1;
        case POP_EXCEPT:
            return 0;
        case RERAISE:
            return oparg;
        case END_ASYNC_FOR:
            return 0;
        case CLEANUP_THROW:
            return 2;
        case LOAD_ASSERTION_ERROR:
            return 1;
        case LOAD_BUILD_CLASS:
            return 1;
        case STORE_NAME:
            return 0;
        case DELETE_NAME:
            return 0;
        case UNPACK_SEQUENCE:
            return oparg;
        case UNPACK_SEQUENCE_TWO_TUPLE:
            return oparg;
        case UNPACK_SEQUENCE_TUPLE:
            return oparg;
        case UNPACK_SEQUENCE_LIST:
            return oparg;
        case UNPACK_EX:
            return (oparg & 0xFF) + (oparg >> 8) + 1;
        case STORE_ATTR:
            return 0;
        case DELETE_ATTR:
            return 0;
        case STORE_GLOBAL:
            return 0;
        case DELETE_GLOBAL:
            return 0;
        case LOAD_LOCALS:
            return 1;
        case LOAD_FROM_DICT_OR_GLOBALS:
            return 1;
        case LOAD_NAME:
            return 1;
        case LOAD_GLOBAL:
            return ((oparg & 1) ? 1 : 0) + 1;
        case _GUARD_GLOBALS_VERSION:
            return 0;
        case _GUARD_BUILTINS_VERSION:
            return 0;
        case _LOAD_GLOBAL_MODULE:
            return ((oparg & 1) ? 1 : 0) + 1;
        case _LOAD_GLOBAL_BUILTINS:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_GLOBAL_MODULE:
            return (oparg & 1 ? 1 : 0) + 1;
        case LOAD_GLOBAL_BUILTIN:
            return (oparg & 1 ? 1 : 0) + 1;
        case DELETE_FAST:
            return 0;
        case MAKE_CELL:
            return 0;
        case DELETE_DEREF:
            return 0;
        case LOAD_FROM_DICT_OR_DEREF:
            return 1;
        case LOAD_DEREF:
            return 1;
        case STORE_DEREF:
            return 0;
        case COPY_FREE_VARS:
            return 0;
        case BUILD_STRING:
            return 1;
        case BUILD_TUPLE:
            return 1;
        case BUILD_LIST:
            return 1;
        case LIST_EXTEND:
            return (oparg-1) + 1;
        case SET_UPDATE:
            return (oparg-1) + 1;
        case BUILD_SET:
            return 1;
        case BUILD_MAP:
            return 1;
        case SETUP_ANNOTATIONS:
            return 0;
        case BUILD_CONST_KEY_MAP:
            return 1;
        case DICT_UPDATE:
            return (oparg - 1) + 1;
        case DICT_MERGE:
            return (oparg - 1) + 4;
        case MAP_ADD:
            return (oparg - 1) + 1;
        case INSTRUMENTED_LOAD_SUPER_ATTR:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_SUPER_ATTR:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_SUPER_METHOD:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ZERO_SUPER_METHOD:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ZERO_SUPER_ATTR:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_SUPER_ATTR_ATTR:
            return 1;
        case LOAD_SUPER_ATTR_METHOD:
            return 2;
        case LOAD_ATTR:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_METHOD:
            return ((oparg & 1) ? 1 : 0) + 1;
        case _GUARD_TYPE_VERSION:
            return 1;
        case _CHECK_MANAGED_OBJECT_HAS_VALUES:
            return 1;
        case _LOAD_ATTR_INSTANCE_VALUE:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ATTR_INSTANCE_VALUE:
            return (oparg & 1 ? 1 : 0) + 1;
        case _CHECK_ATTR_MODULE:
            return 1;
        case _LOAD_ATTR_MODULE:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ATTR_MODULE:
            return (oparg & 1 ? 1 : 0) + 1;
        case _CHECK_ATTR_WITH_HINT:
            return 1;
        case _LOAD_ATTR_WITH_HINT:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ATTR_WITH_HINT:
            return (oparg & 1 ? 1 : 0) + 1;
        case _LOAD_ATTR_SLOT:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ATTR_SLOT:
            return (oparg & 1 ? 1 : 0) + 1;
        case _CHECK_ATTR_CLASS:
            return 1;
        case _LOAD_ATTR_CLASS:
            return ((oparg & 1) ? 1 : 0) + 1;
        case LOAD_ATTR_CLASS:
            return (oparg & 1 ? 1 : 0) + 1;
        case LOAD_ATTR_PROPERTY:
            return 1;
        case LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN:
            return 1;
        case _GUARD_DORV_VALUES:
            return 1;
        case _STORE_ATTR_INSTANCE_VALUE:
            return 0;
        case STORE_ATTR_INSTANCE_VALUE:
            return 0;
        case STORE_ATTR_WITH_HINT:
            return 0;
        case _STORE_ATTR_SLOT:
            return 0;
        case STORE_ATTR_SLOT:
            return 0;
        case COMPARE_OP:
            return 1;
        case COMPARE_OP_FLOAT:
            return 1;
        case COMPARE_OP_INT:
            return 1;
        case COMPARE_OP_STR:
            return 1;
        case IS_OP:
            return 1;
        case CONTAINS_OP:
            return 1;
        case CHECK_EG_MATCH:
            return 2;
        case CHECK_EXC_MATCH:
            return 2;
        case IMPORT_NAME:
            return 1;
        case IMPORT_FROM:
            return 2;
        case JUMP_FORWARD:
            return 0;
        case JUMP_BACKWARD:
            return 0;
        case JUMP:
            return 0;
        case JUMP_NO_INTERRUPT:
            return 0;
        case ENTER_EXECUTOR:
            return 0;
        case POP_JUMP_IF_FALSE:
            return 0;
        case POP_JUMP_IF_TRUE:
            return 0;
        case _IS_NONE:
            return 1;
        case POP_JUMP_IF_NONE:
            return 0;
        case POP_JUMP_IF_NOT_NONE:
            return 0;
        case JUMP_BACKWARD_NO_INTERRUPT:
            return 0;
        case GET_LEN:
            return 2;
        case MATCH_CLASS:
            return 1;
        case MATCH_MAPPING:
            return 2;
        case MATCH_SEQUENCE:
            return 2;
        case MATCH_KEYS:
            return 3;
        case GET_ITER:
            return 1;
        case GET_YIELD_FROM_ITER:
            return 1;
        case FOR_ITER:
            return 2;
        case INSTRUMENTED_FOR_ITER:
            return 0;
        case _ITER_CHECK_LIST:
            return 1;
        case _ITER_JUMP_LIST:
            return 1;
        case _IS_ITER_EXHAUSTED_LIST:
            return 2;
        case _ITER_NEXT_LIST:
            return 2;
        case FOR_ITER_LIST:
            return 2;
        case _ITER_CHECK_TUPLE:
            return 1;
        case _ITER_JUMP_TUPLE:
            return 1;
        case _IS_ITER_EXHAUSTED_TUPLE:
            return 2;
        case _ITER_NEXT_TUPLE:
            return 2;
        case FOR_ITER_TUPLE:
            return 2;
        case _ITER_CHECK_RANGE:
            return 1;
        case _ITER_JUMP_RANGE:
            return 1;
        case _IS_ITER_EXHAUSTED_RANGE:
            return 2;
        case _ITER_NEXT_RANGE:
            return 2;
        case FOR_ITER_RANGE:
            return 2;
        case FOR_ITER_GEN:
            return 2;
        case BEFORE_ASYNC_WITH:
            return 2;
        case BEFORE_WITH:
            return 2;
        case WITH_EXCEPT_START:
            return 5;
        case SETUP_FINALLY:
            return 0;
        case SETUP_CLEANUP:
            return 0;
        case SETUP_WITH:
            return 0;
        case POP_BLOCK:
            return 0;
        case PUSH_EXC_INFO:
            return 2;
        case _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT:
            return 1;
        case _GUARD_KEYS_VERSION:
            return 1;
        case _LOAD_ATTR_METHOD_WITH_VALUES:
            return 2;
        case LOAD_ATTR_METHOD_WITH_VALUES:
            return 2;
        case _LOAD_ATTR_METHOD_NO_DICT:
            return 2;
        case LOAD_ATTR_METHOD_NO_DICT:
            return 2;
        case _LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES:
            return 1;
        case LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES:
            return 1;
        case _LOAD_ATTR_NONDESCRIPTOR_NO_DICT:
            return 1;
        case LOAD_ATTR_NONDESCRIPTOR_NO_DICT:
            return 1;
        case _CHECK_ATTR_METHOD_LAZY_DICT:
            return 1;
        case _LOAD_ATTR_METHOD_LAZY_DICT:
            return 2;
        case LOAD_ATTR_METHOD_LAZY_DICT:
            return 2;
        case INSTRUMENTED_CALL:
            return 0;
        case CALL:
            return 1;
        case _CHECK_CALL_BOUND_METHOD_EXACT_ARGS:
            return oparg + 2;
        case _INIT_CALL_BOUND_METHOD_EXACT_ARGS:
            return oparg + 2;
        case _CHECK_PEP_523:
            return 0;
        case _CHECK_FUNCTION_EXACT_ARGS:
            return oparg + 2;
        case _CHECK_STACK_SPACE:
            return oparg + 2;
        case _INIT_CALL_PY_EXACT_ARGS:
            return 1;
        case _PUSH_FRAME:
            return 1;
        case CALL_BOUND_METHOD_EXACT_ARGS:
            return 1;
        case CALL_PY_EXACT_ARGS:
            return 1;
        case CALL_PY_WITH_DEFAULTS:
            return 1;
        case CALL_TYPE_1:
            return 1;
        case CALL_STR_1:
            return 1;
        case CALL_TUPLE_1:
            return 1;
        case CALL_ALLOC_AND_ENTER_INIT:
            return 1;
        case EXIT_INIT_CHECK:
            return 0;
        case CALL_BUILTIN_CLASS:
            return 1;
        case CALL_BUILTIN_O:
            return 1;
        case CALL_BUILTIN_FAST:
            return 1;
        case CALL_BUILTIN_FAST_WITH_KEYWORDS:
            return 1;
        case CALL_LEN:
            return 1;
        case CALL_ISINSTANCE:
            return 1;
        case CALL_LIST_APPEND:
            return 1;
        case CALL_METHOD_DESCRIPTOR_O:
            return 1;
        case CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS:
            return 1;
        case CALL_METHOD_DESCRIPTOR_NOARGS:
            return 1;
        case CALL_METHOD_DESCRIPTOR_FAST:
            return 1;
        case INSTRUMENTED_CALL_KW:
            return 0;
        case CALL_KW:
            return 1;
        case INSTRUMENTED_CALL_FUNCTION_EX:
            return 0;
        case CALL_FUNCTION_EX:
            return 1;
        case MAKE_FUNCTION:
            return 1;
        case SET_FUNCTION_ATTRIBUTE:
            return 1;
        case RETURN_GENERATOR:
            return 0;
        case BUILD_SLICE:
            return 1;
        case CONVERT_VALUE:
            return 1;
        case FORMAT_SIMPLE:
            return 1;
        case FORMAT_WITH_SPEC:
            return 1;
        case COPY:
            return (oparg-1) + 2;
        case BINARY_OP:
            return 1;
        case SWAP:
            return (oparg-2) + 2;
        case INSTRUMENTED_INSTRUCTION:
            return 0;
        case INSTRUMENTED_JUMP_FORWARD:
            return 0;
        case INSTRUMENTED_JUMP_BACKWARD:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_TRUE:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_FALSE:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_NONE:
            return 0;
        case INSTRUMENTED_POP_JUMP_IF_NOT_NONE:
            return 0;
        case EXTENDED_ARG:
            return 0;
        case CACHE:
            return 0;
        case RESERVED:
            return 0;
        case _POP_JUMP_IF_FALSE:
            return 0;
        case _POP_JUMP_IF_TRUE:
            return 0;
        case _JUMP_TO_TOP:
            return 0;
        case _SET_IP:
            return 0;
        case _SAVE_CURRENT_IP:
            return 0;
        case _EXIT_TRACE:
            return 0;
        case _INSERT:
            return oparg + 1;
        default:
            return -1;
    }
}
#endif // NEED_OPCODE_METADATA

enum InstructionFormat {
    INSTR_FMT_IB,
    INSTR_FMT_IBC,
    INSTR_FMT_IBC0,
    INSTR_FMT_IBC00,
    INSTR_FMT_IBC000,
    INSTR_FMT_IBC00000000,
    INSTR_FMT_IX,
    INSTR_FMT_IXC,
    INSTR_FMT_IXC0,
    INSTR_FMT_IXC00,
    INSTR_FMT_IXC000,
};

#define IS_VALID_OPCODE(OP) \
    (((OP) >= 0) && ((OP) < OPCODE_METADATA_SIZE) && \
     (_PyOpcode_opcode_metadata[(OP)].valid_entry))

#define HAS_ARG_FLAG (1)
#define HAS_CONST_FLAG (2)
#define HAS_NAME_FLAG (4)
#define HAS_JUMP_FLAG (8)
#define HAS_FREE_FLAG (16)
#define HAS_LOCAL_FLAG (32)
#define HAS_EVAL_BREAK_FLAG (64)
#define HAS_DEOPT_FLAG (128)
#define HAS_ERROR_FLAG (256)
#define OPCODE_HAS_ARG(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_ARG_FLAG))
#define OPCODE_HAS_CONST(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_CONST_FLAG))
#define OPCODE_HAS_NAME(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_NAME_FLAG))
#define OPCODE_HAS_JUMP(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_JUMP_FLAG))
#define OPCODE_HAS_FREE(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_FREE_FLAG))
#define OPCODE_HAS_LOCAL(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_LOCAL_FLAG))
#define OPCODE_HAS_EVAL_BREAK(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_EVAL_BREAK_FLAG))
#define OPCODE_HAS_DEOPT(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_DEOPT_FLAG))
#define OPCODE_HAS_ERROR(OP) (_PyOpcode_opcode_metadata[OP].flags & (HAS_ERROR_FLAG))

struct opcode_metadata {
    bool valid_entry;
    enum InstructionFormat instr_format;
    int flags;
};

struct opcode_macro_expansion {
    int nuops;
    struct { int16_t uop; int8_t size; int8_t offset; } uops[12];
};

#define OPARG_FULL 0
#define OPARG_CACHE_1 1
#define OPARG_CACHE_2 2
#define OPARG_CACHE_4 4
#define OPARG_TOP 5
#define OPARG_BOTTOM 6
#define OPARG_SET_IP 7

#define OPCODE_METADATA_FMT(OP) (_PyOpcode_opcode_metadata[(OP)].instr_format)
#define SAME_OPCODE_METADATA(OP1, OP2) \
        (OPCODE_METADATA_FMT(OP1) == OPCODE_METADATA_FMT(OP2))

#define OPCODE_METADATA_SIZE 512
#define OPCODE_UOP_NAME_SIZE 512
#define OPCODE_MACRO_EXPANSION_SIZE 256

extern const struct opcode_metadata _PyOpcode_opcode_metadata[OPCODE_METADATA_SIZE];
#ifdef NEED_OPCODE_METADATA
const struct opcode_metadata _PyOpcode_opcode_metadata[OPCODE_METADATA_SIZE] = {
    [NOP] = { true, INSTR_FMT_IX, 0 },
    [RESUME] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [RESUME_CHECK] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [INSTRUMENTED_RESUME] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [LOAD_CLOSURE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [LOAD_FAST_CHECK] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG | HAS_ERROR_FLAG },
    [LOAD_FAST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [LOAD_FAST_AND_CLEAR] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [LOAD_FAST_LOAD_FAST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [LOAD_CONST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_CONST_FLAG },
    [STORE_FAST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [STORE_FAST_MAYBE_NULL] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [STORE_FAST_LOAD_FAST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [STORE_FAST_STORE_FAST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG },
    [POP_TOP] = { true, INSTR_FMT_IX, 0 },
    [PUSH_NULL] = { true, INSTR_FMT_IX, 0 },
    [END_FOR] = { true, INSTR_FMT_IX, 0 },
    [INSTRUMENTED_END_FOR] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [END_SEND] = { true, INSTR_FMT_IX, 0 },
    [INSTRUMENTED_END_SEND] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [UNARY_NEGATIVE] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [UNARY_NOT] = { true, INSTR_FMT_IX, 0 },
    [TO_BOOL] = { true, INSTR_FMT_IXC00, HAS_ERROR_FLAG },
    [TO_BOOL_BOOL] = { true, INSTR_FMT_IXC00, HAS_DEOPT_FLAG },
    [TO_BOOL_INT] = { true, INSTR_FMT_IXC00, HAS_DEOPT_FLAG },
    [TO_BOOL_LIST] = { true, INSTR_FMT_IXC00, HAS_DEOPT_FLAG },
    [TO_BOOL_NONE] = { true, INSTR_FMT_IXC00, HAS_DEOPT_FLAG },
    [TO_BOOL_STR] = { true, INSTR_FMT_IXC00, HAS_DEOPT_FLAG },
    [TO_BOOL_ALWAYS_TRUE] = { true, INSTR_FMT_IXC00, HAS_DEOPT_FLAG },
    [UNARY_INVERT] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [_GUARD_BOTH_INT] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_BINARY_OP_MULTIPLY_INT] = { true, INSTR_FMT_IXC, HAS_ERROR_FLAG },
    [_BINARY_OP_ADD_INT] = { true, INSTR_FMT_IXC, HAS_ERROR_FLAG },
    [_BINARY_OP_SUBTRACT_INT] = { true, INSTR_FMT_IXC, HAS_ERROR_FLAG },
    [BINARY_OP_MULTIPLY_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [BINARY_OP_ADD_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [BINARY_OP_SUBTRACT_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [_GUARD_BOTH_FLOAT] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_BINARY_OP_MULTIPLY_FLOAT] = { true, INSTR_FMT_IXC, 0 },
    [_BINARY_OP_ADD_FLOAT] = { true, INSTR_FMT_IXC, 0 },
    [_BINARY_OP_SUBTRACT_FLOAT] = { true, INSTR_FMT_IXC, 0 },
    [BINARY_OP_MULTIPLY_FLOAT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [BINARY_OP_ADD_FLOAT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [BINARY_OP_SUBTRACT_FLOAT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [_GUARD_BOTH_UNICODE] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_BINARY_OP_ADD_UNICODE] = { true, INSTR_FMT_IXC, HAS_ERROR_FLAG },
    [BINARY_OP_ADD_UNICODE] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [_BINARY_OP_INPLACE_ADD_UNICODE] = { true, INSTR_FMT_IX, HAS_LOCAL_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [BINARY_OP_INPLACE_ADD_UNICODE] = { true, INSTR_FMT_IX, HAS_LOCAL_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [BINARY_SUBSCR] = { true, INSTR_FMT_IXC, HAS_ERROR_FLAG },
    [BINARY_SLICE] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [STORE_SLICE] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [BINARY_SUBSCR_LIST_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [BINARY_SUBSCR_STR_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [BINARY_SUBSCR_TUPLE_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [BINARY_SUBSCR_DICT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [BINARY_SUBSCR_GETITEM] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [LIST_APPEND] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [SET_ADD] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [STORE_SUBSCR] = { true, INSTR_FMT_IXC, HAS_ERROR_FLAG },
    [STORE_SUBSCR_LIST_INT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [STORE_SUBSCR_DICT] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [DELETE_SUBSCR] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [CALL_INTRINSIC_1] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [CALL_INTRINSIC_2] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [RAISE_VARARGS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [INTERPRETER_EXIT] = { true, INSTR_FMT_IX, 0 },
    [_POP_FRAME] = { true, INSTR_FMT_IX, 0 },
    [RETURN_VALUE] = { true, INSTR_FMT_IX, 0 },
    [INSTRUMENTED_RETURN_VALUE] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [RETURN_CONST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_CONST_FLAG },
    [INSTRUMENTED_RETURN_CONST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_CONST_FLAG | HAS_ERROR_FLAG },
    [GET_AITER] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [GET_ANEXT] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [GET_AWAITABLE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [SEND] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_ERROR_FLAG },
    [SEND_GEN] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [INSTRUMENTED_YIELD_VALUE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [YIELD_VALUE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [POP_EXCEPT] = { true, INSTR_FMT_IX, 0 },
    [RERAISE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [END_ASYNC_FOR] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [CLEANUP_THROW] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [LOAD_ASSERTION_ERROR] = { true, INSTR_FMT_IX, 0 },
    [LOAD_BUILD_CLASS] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [STORE_NAME] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [DELETE_NAME] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [UNPACK_SEQUENCE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [UNPACK_SEQUENCE_TWO_TUPLE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [UNPACK_SEQUENCE_TUPLE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [UNPACK_SEQUENCE_LIST] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [UNPACK_EX] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [STORE_ATTR] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [DELETE_ATTR] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [STORE_GLOBAL] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [DELETE_GLOBAL] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_LOCALS] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [LOAD_FROM_DICT_OR_GLOBALS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_NAME] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_GLOBAL] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [_GUARD_GLOBALS_VERSION] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [_GUARD_BUILTINS_VERSION] = { true, INSTR_FMT_IXC, HAS_DEOPT_FLAG },
    [_LOAD_GLOBAL_MODULE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_LOAD_GLOBAL_BUILTINS] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_GLOBAL_MODULE] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_GLOBAL_BUILTIN] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [DELETE_FAST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_LOCAL_FLAG | HAS_ERROR_FLAG },
    [MAKE_CELL] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG },
    [DELETE_DEREF] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG },
    [LOAD_FROM_DICT_OR_DEREF] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG },
    [LOAD_DEREF] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG },
    [STORE_DEREF] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_FREE_FLAG },
    [COPY_FREE_VARS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [BUILD_STRING] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [BUILD_TUPLE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [BUILD_LIST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [LIST_EXTEND] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [SET_UPDATE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [BUILD_SET] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [BUILD_MAP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [SETUP_ANNOTATIONS] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [BUILD_CONST_KEY_MAP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [DICT_UPDATE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [DICT_MERGE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [MAP_ADD] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [INSTRUMENTED_LOAD_SUPER_ATTR] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG },
    [LOAD_SUPER_ATTR] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_SUPER_METHOD] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_ZERO_SUPER_METHOD] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_ZERO_SUPER_ATTR] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_SUPER_ATTR_ATTR] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [LOAD_SUPER_ATTR_METHOD] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [LOAD_ATTR] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [LOAD_METHOD] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [_GUARD_TYPE_VERSION] = { true, INSTR_FMT_IXC0, HAS_DEOPT_FLAG },
    [_CHECK_MANAGED_OBJECT_HAS_VALUES] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_LOAD_ATTR_INSTANCE_VALUE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_ATTR_INSTANCE_VALUE] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_CHECK_ATTR_MODULE] = { true, INSTR_FMT_IXC0, HAS_DEOPT_FLAG },
    [_LOAD_ATTR_MODULE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_ATTR_MODULE] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_CHECK_ATTR_WITH_HINT] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_LOAD_ATTR_WITH_HINT] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG },
    [LOAD_ATTR_WITH_HINT] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG },
    [_LOAD_ATTR_SLOT] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_ATTR_SLOT] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_CHECK_ATTR_CLASS] = { true, INSTR_FMT_IXC0, HAS_DEOPT_FLAG },
    [_LOAD_ATTR_CLASS] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG },
    [LOAD_ATTR_CLASS] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_ATTR_PROPERTY] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG },
    [_GUARD_DORV_VALUES] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_STORE_ATTR_INSTANCE_VALUE] = { true, INSTR_FMT_IXC, 0 },
    [STORE_ATTR_INSTANCE_VALUE] = { true, INSTR_FMT_IXC000, HAS_DEOPT_FLAG },
    [STORE_ATTR_WITH_HINT] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG },
    [_STORE_ATTR_SLOT] = { true, INSTR_FMT_IXC, 0 },
    [STORE_ATTR_SLOT] = { true, INSTR_FMT_IXC000, HAS_DEOPT_FLAG },
    [COMPARE_OP] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [COMPARE_OP_FLOAT] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [COMPARE_OP_INT] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [COMPARE_OP_STR] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [IS_OP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [CONTAINS_OP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [CHECK_EG_MATCH] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [CHECK_EXC_MATCH] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [IMPORT_NAME] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [IMPORT_FROM] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG },
    [JUMP_FORWARD] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [JUMP_BACKWARD] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [JUMP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [JUMP_NO_INTERRUPT] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [ENTER_EXECUTOR] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [POP_JUMP_IF_FALSE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [POP_JUMP_IF_TRUE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [_IS_NONE] = { true, INSTR_FMT_IX, 0 },
    [POP_JUMP_IF_NONE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [POP_JUMP_IF_NOT_NONE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [JUMP_BACKWARD_NO_INTERRUPT] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [GET_LEN] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [MATCH_CLASS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [MATCH_MAPPING] = { true, INSTR_FMT_IX, 0 },
    [MATCH_SEQUENCE] = { true, INSTR_FMT_IX, 0 },
    [MATCH_KEYS] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [GET_ITER] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [GET_YIELD_FROM_ITER] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [FOR_ITER] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_ERROR_FLAG },
    [INSTRUMENTED_FOR_ITER] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [_ITER_CHECK_LIST] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_ITER_JUMP_LIST] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [_IS_ITER_EXHAUSTED_LIST] = { true, INSTR_FMT_IX, 0 },
    [_ITER_NEXT_LIST] = { true, INSTR_FMT_IX, 0 },
    [FOR_ITER_LIST] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_DEOPT_FLAG },
    [_ITER_CHECK_TUPLE] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_ITER_JUMP_TUPLE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [_IS_ITER_EXHAUSTED_TUPLE] = { true, INSTR_FMT_IX, 0 },
    [_ITER_NEXT_TUPLE] = { true, INSTR_FMT_IX, 0 },
    [FOR_ITER_TUPLE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_DEOPT_FLAG },
    [_ITER_CHECK_RANGE] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_ITER_JUMP_RANGE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_JUMP_FLAG },
    [_IS_ITER_EXHAUSTED_RANGE] = { true, INSTR_FMT_IX, 0 },
    [_ITER_NEXT_RANGE] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [FOR_ITER_RANGE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_JUMP_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [FOR_ITER_GEN] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [BEFORE_ASYNC_WITH] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [BEFORE_WITH] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [WITH_EXCEPT_START] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [SETUP_FINALLY] = { true, INSTR_FMT_IX, 0 },
    [SETUP_CLEANUP] = { true, INSTR_FMT_IX, 0 },
    [SETUP_WITH] = { true, INSTR_FMT_IX, 0 },
    [POP_BLOCK] = { true, INSTR_FMT_IX, 0 },
    [PUSH_EXC_INFO] = { true, INSTR_FMT_IX, 0 },
    [_GUARD_DORV_VALUES_INST_ATTR_FROM_DICT] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_GUARD_KEYS_VERSION] = { true, INSTR_FMT_IXC0, HAS_DEOPT_FLAG },
    [_LOAD_ATTR_METHOD_WITH_VALUES] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG },
    [LOAD_ATTR_METHOD_WITH_VALUES] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_LOAD_ATTR_METHOD_NO_DICT] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG },
    [LOAD_ATTR_METHOD_NO_DICT] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG },
    [LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG },
    [LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_CHECK_ATTR_METHOD_LAZY_DICT] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_LOAD_ATTR_METHOD_LAZY_DICT] = { true, INSTR_FMT_IBC000, HAS_ARG_FLAG },
    [LOAD_ATTR_METHOD_LAZY_DICT] = { true, INSTR_FMT_IBC00000000, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [INSTRUMENTED_CALL] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [CALL] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [_CHECK_CALL_BOUND_METHOD_EXACT_ARGS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_INIT_CALL_BOUND_METHOD_EXACT_ARGS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [_CHECK_PEP_523] = { true, INSTR_FMT_IX, HAS_DEOPT_FLAG },
    [_CHECK_FUNCTION_EXACT_ARGS] = { true, INSTR_FMT_IBC0, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_CHECK_STACK_SPACE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [_INIT_CALL_PY_EXACT_ARGS] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [_PUSH_FRAME] = { true, INSTR_FMT_IX, 0 },
    [CALL_BOUND_METHOD_EXACT_ARGS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [CALL_PY_EXACT_ARGS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [CALL_PY_WITH_DEFAULTS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [CALL_TYPE_1] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG },
    [CALL_STR_1] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_TUPLE_1] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_ALLOC_AND_ENTER_INIT] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [EXIT_INIT_CHECK] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [CALL_BUILTIN_CLASS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_BUILTIN_O] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_BUILTIN_FAST] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_BUILTIN_FAST_WITH_KEYWORDS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_LEN] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_ISINSTANCE] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_LIST_APPEND] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_METHOD_DESCRIPTOR_O] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_METHOD_DESCRIPTOR_NOARGS] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [CALL_METHOD_DESCRIPTOR_FAST] = { true, INSTR_FMT_IBC00, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG },
    [INSTRUMENTED_CALL_KW] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [CALL_KW] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [INSTRUMENTED_CALL_FUNCTION_EX] = { true, INSTR_FMT_IX, 0 },
    [CALL_FUNCTION_EX] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG | HAS_ERROR_FLAG },
    [MAKE_FUNCTION] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [SET_FUNCTION_ATTRIBUTE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [RETURN_GENERATOR] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [BUILD_SLICE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [CONVERT_VALUE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [FORMAT_SIMPLE] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [FORMAT_WITH_SPEC] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [COPY] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [BINARY_OP] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG | HAS_ERROR_FLAG },
    [SWAP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [INSTRUMENTED_INSTRUCTION] = { true, INSTR_FMT_IX, HAS_ERROR_FLAG },
    [INSTRUMENTED_JUMP_FORWARD] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [INSTRUMENTED_JUMP_BACKWARD] = { true, INSTR_FMT_IB, HAS_ARG_FLAG | HAS_EVAL_BREAK_FLAG },
    [INSTRUMENTED_POP_JUMP_IF_TRUE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG },
    [INSTRUMENTED_POP_JUMP_IF_FALSE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG },
    [INSTRUMENTED_POP_JUMP_IF_NONE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG },
    [INSTRUMENTED_POP_JUMP_IF_NOT_NONE] = { true, INSTR_FMT_IBC, HAS_ARG_FLAG },
    [EXTENDED_ARG] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [CACHE] = { true, INSTR_FMT_IX, 0 },
    [RESERVED] = { true, INSTR_FMT_IX, 0 },
    [_POP_JUMP_IF_FALSE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [_POP_JUMP_IF_TRUE] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [_JUMP_TO_TOP] = { true, INSTR_FMT_IX, HAS_EVAL_BREAK_FLAG },
    [_SET_IP] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
    [_SAVE_CURRENT_IP] = { true, INSTR_FMT_IX, 0 },
    [_EXIT_TRACE] = { true, INSTR_FMT_IX, 0 },
    [_INSERT] = { true, INSTR_FMT_IB, HAS_ARG_FLAG },
};
#endif // NEED_OPCODE_METADATA

extern const struct opcode_macro_expansion _PyOpcode_macro_expansion[OPCODE_MACRO_EXPANSION_SIZE];
#ifdef NEED_OPCODE_METADATA
const struct opcode_macro_expansion _PyOpcode_macro_expansion[OPCODE_MACRO_EXPANSION_SIZE] = {
    [NOP] = { .nuops = 1, .uops = { { NOP, 0, 0 } } },
    [RESUME_CHECK] = { .nuops = 1, .uops = { { RESUME_CHECK, 0, 0 } } },
    [LOAD_FAST_CHECK] = { .nuops = 1, .uops = { { LOAD_FAST_CHECK, 0, 0 } } },
    [LOAD_FAST] = { .nuops = 1, .uops = { { LOAD_FAST, 0, 0 } } },
    [LOAD_FAST_AND_CLEAR] = { .nuops = 1, .uops = { { LOAD_FAST_AND_CLEAR, 0, 0 } } },
    [LOAD_FAST_LOAD_FAST] = { .nuops = 2, .uops = { { LOAD_FAST, 5, 0 }, { LOAD_FAST, 6, 0 } } },
    [LOAD_CONST] = { .nuops = 1, .uops = { { LOAD_CONST, 0, 0 } } },
    [STORE_FAST] = { .nuops = 1, .uops = { { STORE_FAST, 0, 0 } } },
    [STORE_FAST_LOAD_FAST] = { .nuops = 2, .uops = { { STORE_FAST, 5, 0 }, { LOAD_FAST, 6, 0 } } },
    [STORE_FAST_STORE_FAST] = { .nuops = 2, .uops = { { STORE_FAST, 5, 0 }, { STORE_FAST, 6, 0 } } },
    [POP_TOP] = { .nuops = 1, .uops = { { POP_TOP, 0, 0 } } },
    [PUSH_NULL] = { .nuops = 1, .uops = { { PUSH_NULL, 0, 0 } } },
    [END_FOR] = { .nuops = 2, .uops = { { POP_TOP, 0, 0 }, { POP_TOP, 0, 0 } } },
    [END_SEND] = { .nuops = 1, .uops = { { END_SEND, 0, 0 } } },
    [UNARY_NEGATIVE] = { .nuops = 1, .uops = { { UNARY_NEGATIVE, 0, 0 } } },
    [UNARY_NOT] = { .nuops = 1, .uops = { { UNARY_NOT, 0, 0 } } },
    [TO_BOOL] = { .nuops = 1, .uops = { { TO_BOOL, 0, 0 } } },
    [TO_BOOL_BOOL] = { .nuops = 1, .uops = { { TO_BOOL_BOOL, 0, 0 } } },
    [TO_BOOL_INT] = { .nuops = 1, .uops = { { TO_BOOL_INT, 0, 0 } } },
    [TO_BOOL_LIST] = { .nuops = 1, .uops = { { TO_BOOL_LIST, 0, 0 } } },
    [TO_BOOL_NONE] = { .nuops = 1, .uops = { { TO_BOOL_NONE, 0, 0 } } },
    [TO_BOOL_STR] = { .nuops = 1, .uops = { { TO_BOOL_STR, 0, 0 } } },
    [TO_BOOL_ALWAYS_TRUE] = { .nuops = 1, .uops = { { TO_BOOL_ALWAYS_TRUE, 2, 1 } } },
    [UNARY_INVERT] = { .nuops = 1, .uops = { { UNARY_INVERT, 0, 0 } } },
    [BINARY_OP_MULTIPLY_INT] = { .nuops = 2, .uops = { { _GUARD_BOTH_INT, 0, 0 }, { _BINARY_OP_MULTIPLY_INT, 0, 0 } } },
    [BINARY_OP_ADD_INT] = { .nuops = 2, .uops = { { _GUARD_BOTH_INT, 0, 0 }, { _BINARY_OP_ADD_INT, 0, 0 } } },
    [BINARY_OP_SUBTRACT_INT] = { .nuops = 2, .uops = { { _GUARD_BOTH_INT, 0, 0 }, { _BINARY_OP_SUBTRACT_INT, 0, 0 } } },
    [BINARY_OP_MULTIPLY_FLOAT] = { .nuops = 2, .uops = { { _GUARD_BOTH_FLOAT, 0, 0 }, { _BINARY_OP_MULTIPLY_FLOAT, 0, 0 } } },
    [BINARY_OP_ADD_FLOAT] = { .nuops = 2, .uops = { { _GUARD_BOTH_FLOAT, 0, 0 }, { _BINARY_OP_ADD_FLOAT, 0, 0 } } },
    [BINARY_OP_SUBTRACT_FLOAT] = { .nuops = 2, .uops = { { _GUARD_BOTH_FLOAT, 0, 0 }, { _BINARY_OP_SUBTRACT_FLOAT, 0, 0 } } },
    [BINARY_OP_ADD_UNICODE] = { .nuops = 2, .uops = { { _GUARD_BOTH_UNICODE, 0, 0 }, { _BINARY_OP_ADD_UNICODE, 0, 0 } } },
    [BINARY_SUBSCR] = { .nuops = 1, .uops = { { BINARY_SUBSCR, 0, 0 } } },
    [BINARY_SLICE] = { .nuops = 1, .uops = { { BINARY_SLICE, 0, 0 } } },
    [STORE_SLICE] = { .nuops = 1, .uops = { { STORE_SLICE, 0, 0 } } },
    [BINARY_SUBSCR_LIST_INT] = { .nuops = 1, .uops = { { BINARY_SUBSCR_LIST_INT, 0, 0 } } },
    [BINARY_SUBSCR_STR_INT] = { .nuops = 1, .uops = { { BINARY_SUBSCR_STR_INT, 0, 0 } } },
    [BINARY_SUBSCR_TUPLE_INT] = { .nuops = 1, .uops = { { BINARY_SUBSCR_TUPLE_INT, 0, 0 } } },
    [BINARY_SUBSCR_DICT] = { .nuops = 1, .uops = { { BINARY_SUBSCR_DICT, 0, 0 } } },
    [LIST_APPEND] = { .nuops = 1, .uops = { { LIST_APPEND, 0, 0 } } },
    [SET_ADD] = { .nuops = 1, .uops = { { SET_ADD, 0, 0 } } },
    [STORE_SUBSCR] = { .nuops = 1, .uops = { { STORE_SUBSCR, 0, 0 } } },
    [STORE_SUBSCR_LIST_INT] = { .nuops = 1, .uops = { { STORE_SUBSCR_LIST_INT, 0, 0 } } },
    [STORE_SUBSCR_DICT] = { .nuops = 1, .uops = { { STORE_SUBSCR_DICT, 0, 0 } } },
    [DELETE_SUBSCR] = { .nuops = 1, .uops = { { DELETE_SUBSCR, 0, 0 } } },
    [CALL_INTRINSIC_1] = { .nuops = 1, .uops = { { CALL_INTRINSIC_1, 0, 0 } } },
    [CALL_INTRINSIC_2] = { .nuops = 1, .uops = { { CALL_INTRINSIC_2, 0, 0 } } },
    [RETURN_VALUE] = { .nuops = 2, .uops = { { _SAVE_CURRENT_IP, 7, -1 }, { _POP_FRAME, 0, 0 } } },
    [RETURN_CONST] = { .nuops = 3, .uops = { { LOAD_CONST, 0, 0 }, { _SAVE_CURRENT_IP, 7, -1 }, { _POP_FRAME, 0, 0 } } },
    [GET_AITER] = { .nuops = 1, .uops = { { GET_AITER, 0, 0 } } },
    [GET_ANEXT] = { .nuops = 1, .uops = { { GET_ANEXT, 0, 0 } } },
    [GET_AWAITABLE] = { .nuops = 1, .uops = { { GET_AWAITABLE, 0, 0 } } },
    [POP_EXCEPT] = { .nuops = 1, .uops = { { POP_EXCEPT, 0, 0 } } },
    [LOAD_ASSERTION_ERROR] = { .nuops = 1, .uops = { { LOAD_ASSERTION_ERROR, 0, 0 } } },
    [LOAD_BUILD_CLASS] = { .nuops = 1, .uops = { { LOAD_BUILD_CLASS, 0, 0 } } },
    [STORE_NAME] = { .nuops = 1, .uops = { { STORE_NAME, 0, 0 } } },
    [DELETE_NAME] = { .nuops = 1, .uops = { { DELETE_NAME, 0, 0 } } },
    [UNPACK_SEQUENCE] = { .nuops = 1, .uops = { { UNPACK_SEQUENCE, 0, 0 } } },
    [UNPACK_SEQUENCE_TWO_TUPLE] = { .nuops = 1, .uops = { { UNPACK_SEQUENCE_TWO_TUPLE, 0, 0 } } },
    [UNPACK_SEQUENCE_TUPLE] = { .nuops = 1, .uops = { { UNPACK_SEQUENCE_TUPLE, 0, 0 } } },
    [UNPACK_SEQUENCE_LIST] = { .nuops = 1, .uops = { { UNPACK_SEQUENCE_LIST, 0, 0 } } },
    [UNPACK_EX] = { .nuops = 1, .uops = { { UNPACK_EX, 0, 0 } } },
    [STORE_ATTR] = { .nuops = 1, .uops = { { STORE_ATTR, 0, 0 } } },
    [DELETE_ATTR] = { .nuops = 1, .uops = { { DELETE_ATTR, 0, 0 } } },
    [STORE_GLOBAL] = { .nuops = 1, .uops = { { STORE_GLOBAL, 0, 0 } } },
    [DELETE_GLOBAL] = { .nuops = 1, .uops = { { DELETE_GLOBAL, 0, 0 } } },
    [LOAD_LOCALS] = { .nuops = 1, .uops = { { LOAD_LOCALS, 0, 0 } } },
    [LOAD_FROM_DICT_OR_GLOBALS] = { .nuops = 1, .uops = { { LOAD_FROM_DICT_OR_GLOBALS, 0, 0 } } },
    [LOAD_NAME] = { .nuops = 1, .uops = { { LOAD_NAME, 0, 0 } } },
    [LOAD_GLOBAL] = { .nuops = 1, .uops = { { LOAD_GLOBAL, 0, 0 } } },
    [LOAD_GLOBAL_MODULE] = { .nuops = 2, .uops = { { _GUARD_GLOBALS_VERSION, 1, 1 }, { _LOAD_GLOBAL_MODULE, 1, 3 } } },
    [LOAD_GLOBAL_BUILTIN] = { .nuops = 3, .uops = { { _GUARD_GLOBALS_VERSION, 1, 1 }, { _GUARD_BUILTINS_VERSION, 1, 2 }, { _LOAD_GLOBAL_BUILTINS, 1, 3 } } },
    [DELETE_FAST] = { .nuops = 1, .uops = { { DELETE_FAST, 0, 0 } } },
    [DELETE_DEREF] = { .nuops = 1, .uops = { { DELETE_DEREF, 0, 0 } } },
    [LOAD_FROM_DICT_OR_DEREF] = { .nuops = 1, .uops = { { LOAD_FROM_DICT_OR_DEREF, 0, 0 } } },
    [LOAD_DEREF] = { .nuops = 1, .uops = { { LOAD_DEREF, 0, 0 } } },
    [STORE_DEREF] = { .nuops = 1, .uops = { { STORE_DEREF, 0, 0 } } },
    [COPY_FREE_VARS] = { .nuops = 1, .uops = { { COPY_FREE_VARS, 0, 0 } } },
    [BUILD_STRING] = { .nuops = 1, .uops = { { BUILD_STRING, 0, 0 } } },
    [BUILD_TUPLE] = { .nuops = 1, .uops = { { BUILD_TUPLE, 0, 0 } } },
    [BUILD_LIST] = { .nuops = 1, .uops = { { BUILD_LIST, 0, 0 } } },
    [LIST_EXTEND] = { .nuops = 1, .uops = { { LIST_EXTEND, 0, 0 } } },
    [SET_UPDATE] = { .nuops = 1, .uops = { { SET_UPDATE, 0, 0 } } },
    [BUILD_SET] = { .nuops = 1, .uops = { { BUILD_SET, 0, 0 } } },
    [BUILD_MAP] = { .nuops = 1, .uops = { { BUILD_MAP, 0, 0 } } },
    [SETUP_ANNOTATIONS] = { .nuops = 1, .uops = { { SETUP_ANNOTATIONS, 0, 0 } } },
    [BUILD_CONST_KEY_MAP] = { .nuops = 1, .uops = { { BUILD_CONST_KEY_MAP, 0, 0 } } },
    [DICT_UPDATE] = { .nuops = 1, .uops = { { DICT_UPDATE, 0, 0 } } },
    [DICT_MERGE] = { .nuops = 1, .uops = { { DICT_MERGE, 0, 0 } } },
    [MAP_ADD] = { .nuops = 1, .uops = { { MAP_ADD, 0, 0 } } },
    [LOAD_SUPER_ATTR_ATTR] = { .nuops = 1, .uops = { { LOAD_SUPER_ATTR_ATTR, 0, 0 } } },
    [LOAD_SUPER_ATTR_METHOD] = { .nuops = 1, .uops = { { LOAD_SUPER_ATTR_METHOD, 0, 0 } } },
    [LOAD_ATTR] = { .nuops = 1, .uops = { { LOAD_ATTR, 0, 0 } } },
    [LOAD_ATTR_INSTANCE_VALUE] = { .nuops = 3, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _CHECK_MANAGED_OBJECT_HAS_VALUES, 0, 0 }, { _LOAD_ATTR_INSTANCE_VALUE, 1, 3 } } },
    [LOAD_ATTR_MODULE] = { .nuops = 2, .uops = { { _CHECK_ATTR_MODULE, 2, 1 }, { _LOAD_ATTR_MODULE, 1, 3 } } },
    [LOAD_ATTR_WITH_HINT] = { .nuops = 3, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _CHECK_ATTR_WITH_HINT, 0, 0 }, { _LOAD_ATTR_WITH_HINT, 1, 3 } } },
    [LOAD_ATTR_SLOT] = { .nuops = 2, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _LOAD_ATTR_SLOT, 1, 3 } } },
    [LOAD_ATTR_CLASS] = { .nuops = 2, .uops = { { _CHECK_ATTR_CLASS, 2, 1 }, { _LOAD_ATTR_CLASS, 4, 5 } } },
    [STORE_ATTR_INSTANCE_VALUE] = { .nuops = 3, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _GUARD_DORV_VALUES, 0, 0 }, { _STORE_ATTR_INSTANCE_VALUE, 1, 3 } } },
    [STORE_ATTR_SLOT] = { .nuops = 2, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _STORE_ATTR_SLOT, 1, 3 } } },
    [COMPARE_OP] = { .nuops = 1, .uops = { { COMPARE_OP, 0, 0 } } },
    [COMPARE_OP_FLOAT] = { .nuops = 1, .uops = { { COMPARE_OP_FLOAT, 0, 0 } } },
    [COMPARE_OP_INT] = { .nuops = 1, .uops = { { COMPARE_OP_INT, 0, 0 } } },
    [COMPARE_OP_STR] = { .nuops = 1, .uops = { { COMPARE_OP_STR, 0, 0 } } },
    [IS_OP] = { .nuops = 1, .uops = { { IS_OP, 0, 0 } } },
    [CONTAINS_OP] = { .nuops = 1, .uops = { { CONTAINS_OP, 0, 0 } } },
    [CHECK_EG_MATCH] = { .nuops = 1, .uops = { { CHECK_EG_MATCH, 0, 0 } } },
    [CHECK_EXC_MATCH] = { .nuops = 1, .uops = { { CHECK_EXC_MATCH, 0, 0 } } },
    [GET_LEN] = { .nuops = 1, .uops = { { GET_LEN, 0, 0 } } },
    [MATCH_CLASS] = { .nuops = 1, .uops = { { MATCH_CLASS, 0, 0 } } },
    [MATCH_MAPPING] = { .nuops = 1, .uops = { { MATCH_MAPPING, 0, 0 } } },
    [MATCH_SEQUENCE] = { .nuops = 1, .uops = { { MATCH_SEQUENCE, 0, 0 } } },
    [MATCH_KEYS] = { .nuops = 1, .uops = { { MATCH_KEYS, 0, 0 } } },
    [GET_ITER] = { .nuops = 1, .uops = { { GET_ITER, 0, 0 } } },
    [GET_YIELD_FROM_ITER] = { .nuops = 1, .uops = { { GET_YIELD_FROM_ITER, 0, 0 } } },
    [WITH_EXCEPT_START] = { .nuops = 1, .uops = { { WITH_EXCEPT_START, 0, 0 } } },
    [PUSH_EXC_INFO] = { .nuops = 1, .uops = { { PUSH_EXC_INFO, 0, 0 } } },
    [LOAD_ATTR_METHOD_WITH_VALUES] = { .nuops = 4, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT, 0, 0 }, { _GUARD_KEYS_VERSION, 2, 3 }, { _LOAD_ATTR_METHOD_WITH_VALUES, 4, 5 } } },
    [LOAD_ATTR_METHOD_NO_DICT] = { .nuops = 2, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _LOAD_ATTR_METHOD_NO_DICT, 4, 5 } } },
    [LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = { .nuops = 4, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT, 0, 0 }, { _GUARD_KEYS_VERSION, 2, 3 }, { _LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES, 4, 5 } } },
    [LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = { .nuops = 2, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _LOAD_ATTR_NONDESCRIPTOR_NO_DICT, 4, 5 } } },
    [LOAD_ATTR_METHOD_LAZY_DICT] = { .nuops = 3, .uops = { { _GUARD_TYPE_VERSION, 2, 1 }, { _CHECK_ATTR_METHOD_LAZY_DICT, 0, 0 }, { _LOAD_ATTR_METHOD_LAZY_DICT, 4, 5 } } },
    [CALL_BOUND_METHOD_EXACT_ARGS] = { .nuops = 8, .uops = { { _CHECK_PEP_523, 0, 0 }, { _CHECK_CALL_BOUND_METHOD_EXACT_ARGS, 0, 0 }, { _INIT_CALL_BOUND_METHOD_EXACT_ARGS, 0, 0 }, { _CHECK_FUNCTION_EXACT_ARGS, 2, 1 }, { _CHECK_STACK_SPACE, 0, 0 }, { _INIT_CALL_PY_EXACT_ARGS, 0, 0 }, { _SAVE_CURRENT_IP, 7, 2 }, { _PUSH_FRAME, 0, 0 } } },
    [CALL_PY_EXACT_ARGS] = { .nuops = 6, .uops = { { _CHECK_PEP_523, 0, 0 }, { _CHECK_FUNCTION_EXACT_ARGS, 2, 1 }, { _CHECK_STACK_SPACE, 0, 0 }, { _INIT_CALL_PY_EXACT_ARGS, 0, 0 }, { _SAVE_CURRENT_IP, 7, 2 }, { _PUSH_FRAME, 0, 0 } } },
    [CALL_TYPE_1] = { .nuops = 1, .uops = { { CALL_TYPE_1, 0, 0 } } },
    [CALL_STR_1] = { .nuops = 1, .uops = { { CALL_STR_1, 0, 0 } } },
    [CALL_TUPLE_1] = { .nuops = 1, .uops = { { CALL_TUPLE_1, 0, 0 } } },
    [EXIT_INIT_CHECK] = { .nuops = 1, .uops = { { EXIT_INIT_CHECK, 0, 0 } } },
    [CALL_BUILTIN_CLASS] = { .nuops = 1, .uops = { { CALL_BUILTIN_CLASS, 0, 0 } } },
    [CALL_BUILTIN_O] = { .nuops = 1, .uops = { { CALL_BUILTIN_O, 0, 0 } } },
    [CALL_BUILTIN_FAST] = { .nuops = 1, .uops = { { CALL_BUILTIN_FAST, 0, 0 } } },
    [CALL_BUILTIN_FAST_WITH_KEYWORDS] = { .nuops = 1, .uops = { { CALL_BUILTIN_FAST_WITH_KEYWORDS, 0, 0 } } },
    [CALL_LEN] = { .nuops = 1, .uops = { { CALL_LEN, 0, 0 } } },
    [CALL_ISINSTANCE] = { .nuops = 1, .uops = { { CALL_ISINSTANCE, 0, 0 } } },
    [CALL_METHOD_DESCRIPTOR_O] = { .nuops = 1, .uops = { { CALL_METHOD_DESCRIPTOR_O, 0, 0 } } },
    [CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS] = { .nuops = 1, .uops = { { CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS, 0, 0 } } },
    [CALL_METHOD_DESCRIPTOR_NOARGS] = { .nuops = 1, .uops = { { CALL_METHOD_DESCRIPTOR_NOARGS, 0, 0 } } },
    [CALL_METHOD_DESCRIPTOR_FAST] = { .nuops = 1, .uops = { { CALL_METHOD_DESCRIPTOR_FAST, 0, 0 } } },
    [MAKE_FUNCTION] = { .nuops = 1, .uops = { { MAKE_FUNCTION, 0, 0 } } },
    [SET_FUNCTION_ATTRIBUTE] = { .nuops = 1, .uops = { { SET_FUNCTION_ATTRIBUTE, 0, 0 } } },
    [BUILD_SLICE] = { .nuops = 1, .uops = { { BUILD_SLICE, 0, 0 } } },
    [CONVERT_VALUE] = { .nuops = 1, .uops = { { CONVERT_VALUE, 0, 0 } } },
    [FORMAT_SIMPLE] = { .nuops = 1, .uops = { { FORMAT_SIMPLE, 0, 0 } } },
    [FORMAT_WITH_SPEC] = { .nuops = 1, .uops = { { FORMAT_WITH_SPEC, 0, 0 } } },
    [COPY] = { .nuops = 1, .uops = { { COPY, 0, 0 } } },
    [BINARY_OP] = { .nuops = 1, .uops = { { BINARY_OP, 0, 0 } } },
    [SWAP] = { .nuops = 1, .uops = { { SWAP, 0, 0 } } },
};
#endif // NEED_OPCODE_METADATA

extern const char * const _PyOpcode_uop_name[OPCODE_UOP_NAME_SIZE];
#ifdef NEED_OPCODE_METADATA
const char * const _PyOpcode_uop_name[OPCODE_UOP_NAME_SIZE] = {
    [_EXIT_TRACE] = "_EXIT_TRACE",
    [_SET_IP] = "_SET_IP",
    [_GUARD_BOTH_INT] = "_GUARD_BOTH_INT",
    [_BINARY_OP_MULTIPLY_INT] = "_BINARY_OP_MULTIPLY_INT",
    [_BINARY_OP_ADD_INT] = "_BINARY_OP_ADD_INT",
    [_BINARY_OP_SUBTRACT_INT] = "_BINARY_OP_SUBTRACT_INT",
    [_GUARD_BOTH_FLOAT] = "_GUARD_BOTH_FLOAT",
    [_BINARY_OP_MULTIPLY_FLOAT] = "_BINARY_OP_MULTIPLY_FLOAT",
    [_BINARY_OP_ADD_FLOAT] = "_BINARY_OP_ADD_FLOAT",
    [_BINARY_OP_SUBTRACT_FLOAT] = "_BINARY_OP_SUBTRACT_FLOAT",
    [_GUARD_BOTH_UNICODE] = "_GUARD_BOTH_UNICODE",
    [_BINARY_OP_ADD_UNICODE] = "_BINARY_OP_ADD_UNICODE",
    [_BINARY_OP_INPLACE_ADD_UNICODE] = "_BINARY_OP_INPLACE_ADD_UNICODE",
    [_POP_FRAME] = "_POP_FRAME",
    [_GUARD_GLOBALS_VERSION] = "_GUARD_GLOBALS_VERSION",
    [_GUARD_BUILTINS_VERSION] = "_GUARD_BUILTINS_VERSION",
    [_LOAD_GLOBAL_MODULE] = "_LOAD_GLOBAL_MODULE",
    [_LOAD_GLOBAL_BUILTINS] = "_LOAD_GLOBAL_BUILTINS",
    [_GUARD_TYPE_VERSION] = "_GUARD_TYPE_VERSION",
    [_CHECK_MANAGED_OBJECT_HAS_VALUES] = "_CHECK_MANAGED_OBJECT_HAS_VALUES",
    [_LOAD_ATTR_INSTANCE_VALUE] = "_LOAD_ATTR_INSTANCE_VALUE",
    [_CHECK_ATTR_MODULE] = "_CHECK_ATTR_MODULE",
    [_LOAD_ATTR_MODULE] = "_LOAD_ATTR_MODULE",
    [_CHECK_ATTR_WITH_HINT] = "_CHECK_ATTR_WITH_HINT",
    [_LOAD_ATTR_WITH_HINT] = "_LOAD_ATTR_WITH_HINT",
    [_LOAD_ATTR_SLOT] = "_LOAD_ATTR_SLOT",
    [_CHECK_ATTR_CLASS] = "_CHECK_ATTR_CLASS",
    [_LOAD_ATTR_CLASS] = "_LOAD_ATTR_CLASS",
    [_GUARD_DORV_VALUES] = "_GUARD_DORV_VALUES",
    [_STORE_ATTR_INSTANCE_VALUE] = "_STORE_ATTR_INSTANCE_VALUE",
    [_STORE_ATTR_SLOT] = "_STORE_ATTR_SLOT",
    [_IS_NONE] = "_IS_NONE",
    [_ITER_CHECK_LIST] = "_ITER_CHECK_LIST",
    [_ITER_JUMP_LIST] = "_ITER_JUMP_LIST",
    [_IS_ITER_EXHAUSTED_LIST] = "_IS_ITER_EXHAUSTED_LIST",
    [_ITER_NEXT_LIST] = "_ITER_NEXT_LIST",
    [_ITER_CHECK_TUPLE] = "_ITER_CHECK_TUPLE",
    [_ITER_JUMP_TUPLE] = "_ITER_JUMP_TUPLE",
    [_IS_ITER_EXHAUSTED_TUPLE] = "_IS_ITER_EXHAUSTED_TUPLE",
    [_ITER_NEXT_TUPLE] = "_ITER_NEXT_TUPLE",
    [_ITER_CHECK_RANGE] = "_ITER_CHECK_RANGE",
    [_ITER_JUMP_RANGE] = "_ITER_JUMP_RANGE",
    [_IS_ITER_EXHAUSTED_RANGE] = "_IS_ITER_EXHAUSTED_RANGE",
    [_ITER_NEXT_RANGE] = "_ITER_NEXT_RANGE",
    [_GUARD_DORV_VALUES_INST_ATTR_FROM_DICT] = "_GUARD_DORV_VALUES_INST_ATTR_FROM_DICT",
    [_GUARD_KEYS_VERSION] = "_GUARD_KEYS_VERSION",
    [_LOAD_ATTR_METHOD_WITH_VALUES] = "_LOAD_ATTR_METHOD_WITH_VALUES",
    [_LOAD_ATTR_METHOD_NO_DICT] = "_LOAD_ATTR_METHOD_NO_DICT",
    [_LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = "_LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES",
    [_LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = "_LOAD_ATTR_NONDESCRIPTOR_NO_DICT",
    [_CHECK_ATTR_METHOD_LAZY_DICT] = "_CHECK_ATTR_METHOD_LAZY_DICT",
    [_LOAD_ATTR_METHOD_LAZY_DICT] = "_LOAD_ATTR_METHOD_LAZY_DICT",
    [_CHECK_CALL_BOUND_METHOD_EXACT_ARGS] = "_CHECK_CALL_BOUND_METHOD_EXACT_ARGS",
    [_INIT_CALL_BOUND_METHOD_EXACT_ARGS] = "_INIT_CALL_BOUND_METHOD_EXACT_ARGS",
    [_CHECK_PEP_523] = "_CHECK_PEP_523",
    [_CHECK_FUNCTION_EXACT_ARGS] = "_CHECK_FUNCTION_EXACT_ARGS",
    [_CHECK_STACK_SPACE] = "_CHECK_STACK_SPACE",
    [_INIT_CALL_PY_EXACT_ARGS] = "_INIT_CALL_PY_EXACT_ARGS",
    [_PUSH_FRAME] = "_PUSH_FRAME",
    [_POP_JUMP_IF_FALSE] = "_POP_JUMP_IF_FALSE",
    [_POP_JUMP_IF_TRUE] = "_POP_JUMP_IF_TRUE",
    [_JUMP_TO_TOP] = "_JUMP_TO_TOP",
    [_SAVE_CURRENT_IP] = "_SAVE_CURRENT_IP",
    [_INSERT] = "_INSERT",
};
#endif // NEED_OPCODE_METADATA

extern const char *const _PyOpcode_OpName[268];
#ifdef NEED_OPCODE_METADATA
const char *const _PyOpcode_OpName[268] = {
    [CACHE] = "CACHE",
    [RESERVED] = "RESERVED",
    [RESUME] = "RESUME",
    [BEFORE_ASYNC_WITH] = "BEFORE_ASYNC_WITH",
    [BEFORE_WITH] = "BEFORE_WITH",
    [BINARY_OP_INPLACE_ADD_UNICODE] = "BINARY_OP_INPLACE_ADD_UNICODE",
    [BINARY_SLICE] = "BINARY_SLICE",
    [BINARY_SUBSCR] = "BINARY_SUBSCR",
    [CHECK_EG_MATCH] = "CHECK_EG_MATCH",
    [CHECK_EXC_MATCH] = "CHECK_EXC_MATCH",
    [CLEANUP_THROW] = "CLEANUP_THROW",
    [DELETE_SUBSCR] = "DELETE_SUBSCR",
    [END_ASYNC_FOR] = "END_ASYNC_FOR",
    [END_FOR] = "END_FOR",
    [END_SEND] = "END_SEND",
    [EXIT_INIT_CHECK] = "EXIT_INIT_CHECK",
    [FORMAT_SIMPLE] = "FORMAT_SIMPLE",
    [FORMAT_WITH_SPEC] = "FORMAT_WITH_SPEC",
    [GET_AITER] = "GET_AITER",
    [GET_ANEXT] = "GET_ANEXT",
    [GET_ITER] = "GET_ITER",
    [GET_LEN] = "GET_LEN",
    [GET_YIELD_FROM_ITER] = "GET_YIELD_FROM_ITER",
    [INTERPRETER_EXIT] = "INTERPRETER_EXIT",
    [LOAD_ASSERTION_ERROR] = "LOAD_ASSERTION_ERROR",
    [LOAD_BUILD_CLASS] = "LOAD_BUILD_CLASS",
    [LOAD_LOCALS] = "LOAD_LOCALS",
    [MAKE_FUNCTION] = "MAKE_FUNCTION",
    [MATCH_KEYS] = "MATCH_KEYS",
    [MATCH_MAPPING] = "MATCH_MAPPING",
    [MATCH_SEQUENCE] = "MATCH_SEQUENCE",
    [NOP] = "NOP",
    [POP_EXCEPT] = "POP_EXCEPT",
    [POP_TOP] = "POP_TOP",
    [PUSH_EXC_INFO] = "PUSH_EXC_INFO",
    [PUSH_NULL] = "PUSH_NULL",
    [RETURN_GENERATOR] = "RETURN_GENERATOR",
    [RETURN_VALUE] = "RETURN_VALUE",
    [SETUP_ANNOTATIONS] = "SETUP_ANNOTATIONS",
    [STORE_SLICE] = "STORE_SLICE",
    [STORE_SUBSCR] = "STORE_SUBSCR",
    [TO_BOOL] = "TO_BOOL",
    [UNARY_INVERT] = "UNARY_INVERT",
    [UNARY_NEGATIVE] = "UNARY_NEGATIVE",
    [UNARY_NOT] = "UNARY_NOT",
    [WITH_EXCEPT_START] = "WITH_EXCEPT_START",
    [BINARY_OP] = "BINARY_OP",
    [BUILD_CONST_KEY_MAP] = "BUILD_CONST_KEY_MAP",
    [BUILD_LIST] = "BUILD_LIST",
    [BUILD_MAP] = "BUILD_MAP",
    [BUILD_SET] = "BUILD_SET",
    [BUILD_SLICE] = "BUILD_SLICE",
    [BUILD_STRING] = "BUILD_STRING",
    [BUILD_TUPLE] = "BUILD_TUPLE",
    [CALL] = "CALL",
    [CALL_FUNCTION_EX] = "CALL_FUNCTION_EX",
    [CALL_INTRINSIC_1] = "CALL_INTRINSIC_1",
    [CALL_INTRINSIC_2] = "CALL_INTRINSIC_2",
    [CALL_KW] = "CALL_KW",
    [COMPARE_OP] = "COMPARE_OP",
    [CONTAINS_OP] = "CONTAINS_OP",
    [CONVERT_VALUE] = "CONVERT_VALUE",
    [COPY] = "COPY",
    [COPY_FREE_VARS] = "COPY_FREE_VARS",
    [DELETE_ATTR] = "DELETE_ATTR",
    [DELETE_DEREF] = "DELETE_DEREF",
    [DELETE_FAST] = "DELETE_FAST",
    [DELETE_GLOBAL] = "DELETE_GLOBAL",
    [DELETE_NAME] = "DELETE_NAME",
    [DICT_MERGE] = "DICT_MERGE",
    [DICT_UPDATE] = "DICT_UPDATE",
    [ENTER_EXECUTOR] = "ENTER_EXECUTOR",
    [EXTENDED_ARG] = "EXTENDED_ARG",
    [FOR_ITER] = "FOR_ITER",
    [GET_AWAITABLE] = "GET_AWAITABLE",
    [IMPORT_FROM] = "IMPORT_FROM",
    [IMPORT_NAME] = "IMPORT_NAME",
    [IS_OP] = "IS_OP",
    [JUMP_BACKWARD] = "JUMP_BACKWARD",
    [JUMP_BACKWARD_NO_INTERRUPT] = "JUMP_BACKWARD_NO_INTERRUPT",
    [JUMP_FORWARD] = "JUMP_FORWARD",
    [LIST_APPEND] = "LIST_APPEND",
    [LIST_EXTEND] = "LIST_EXTEND",
    [LOAD_ATTR] = "LOAD_ATTR",
    [LOAD_CONST] = "LOAD_CONST",
    [LOAD_DEREF] = "LOAD_DEREF",
    [LOAD_FAST] = "LOAD_FAST",
    [LOAD_FAST_AND_CLEAR] = "LOAD_FAST_AND_CLEAR",
    [LOAD_FAST_CHECK] = "LOAD_FAST_CHECK",
    [LOAD_FAST_LOAD_FAST] = "LOAD_FAST_LOAD_FAST",
    [LOAD_FROM_DICT_OR_DEREF] = "LOAD_FROM_DICT_OR_DEREF",
    [LOAD_FROM_DICT_OR_GLOBALS] = "LOAD_FROM_DICT_OR_GLOBALS",
    [LOAD_GLOBAL] = "LOAD_GLOBAL",
    [LOAD_NAME] = "LOAD_NAME",
    [LOAD_SUPER_ATTR] = "LOAD_SUPER_ATTR",
    [MAKE_CELL] = "MAKE_CELL",
    [MAP_ADD] = "MAP_ADD",
    [MATCH_CLASS] = "MATCH_CLASS",
    [POP_JUMP_IF_FALSE] = "POP_JUMP_IF_FALSE",
    [POP_JUMP_IF_NONE] = "POP_JUMP_IF_NONE",
    [POP_JUMP_IF_NOT_NONE] = "POP_JUMP_IF_NOT_NONE",
    [POP_JUMP_IF_TRUE] = "POP_JUMP_IF_TRUE",
    [RAISE_VARARGS] = "RAISE_VARARGS",
    [RERAISE] = "RERAISE",
    [RETURN_CONST] = "RETURN_CONST",
    [SEND] = "SEND",
    [SET_ADD] = "SET_ADD",
    [SET_FUNCTION_ATTRIBUTE] = "SET_FUNCTION_ATTRIBUTE",
    [SET_UPDATE] = "SET_UPDATE",
    [STORE_ATTR] = "STORE_ATTR",
    [STORE_DEREF] = "STORE_DEREF",
    [STORE_FAST] = "STORE_FAST",
    [STORE_FAST_LOAD_FAST] = "STORE_FAST_LOAD_FAST",
    [STORE_FAST_STORE_FAST] = "STORE_FAST_STORE_FAST",
    [STORE_GLOBAL] = "STORE_GLOBAL",
    [STORE_NAME] = "STORE_NAME",
    [SWAP] = "SWAP",
    [UNPACK_EX] = "UNPACK_EX",
    [UNPACK_SEQUENCE] = "UNPACK_SEQUENCE",
    [YIELD_VALUE] = "YIELD_VALUE",
    [BINARY_OP_ADD_FLOAT] = "BINARY_OP_ADD_FLOAT",
    [BINARY_OP_ADD_INT] = "BINARY_OP_ADD_INT",
    [BINARY_OP_ADD_UNICODE] = "BINARY_OP_ADD_UNICODE",
    [BINARY_OP_MULTIPLY_FLOAT] = "BINARY_OP_MULTIPLY_FLOAT",
    [BINARY_OP_MULTIPLY_INT] = "BINARY_OP_MULTIPLY_INT",
    [BINARY_OP_SUBTRACT_FLOAT] = "BINARY_OP_SUBTRACT_FLOAT",
    [BINARY_OP_SUBTRACT_INT] = "BINARY_OP_SUBTRACT_INT",
    [BINARY_SUBSCR_DICT] = "BINARY_SUBSCR_DICT",
    [BINARY_SUBSCR_GETITEM] = "BINARY_SUBSCR_GETITEM",
    [BINARY_SUBSCR_LIST_INT] = "BINARY_SUBSCR_LIST_INT",
    [BINARY_SUBSCR_STR_INT] = "BINARY_SUBSCR_STR_INT",
    [BINARY_SUBSCR_TUPLE_INT] = "BINARY_SUBSCR_TUPLE_INT",
    [CALL_ALLOC_AND_ENTER_INIT] = "CALL_ALLOC_AND_ENTER_INIT",
    [CALL_BOUND_METHOD_EXACT_ARGS] = "CALL_BOUND_METHOD_EXACT_ARGS",
    [CALL_BUILTIN_CLASS] = "CALL_BUILTIN_CLASS",
    [CALL_BUILTIN_FAST] = "CALL_BUILTIN_FAST",
    [CALL_BUILTIN_FAST_WITH_KEYWORDS] = "CALL_BUILTIN_FAST_WITH_KEYWORDS",
    [CALL_BUILTIN_O] = "CALL_BUILTIN_O",
    [CALL_ISINSTANCE] = "CALL_ISINSTANCE",
    [CALL_LEN] = "CALL_LEN",
    [CALL_LIST_APPEND] = "CALL_LIST_APPEND",
    [CALL_METHOD_DESCRIPTOR_FAST] = "CALL_METHOD_DESCRIPTOR_FAST",
    [CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS] = "CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS",
    [CALL_METHOD_DESCRIPTOR_NOARGS] = "CALL_METHOD_DESCRIPTOR_NOARGS",
    [CALL_METHOD_DESCRIPTOR_O] = "CALL_METHOD_DESCRIPTOR_O",
    [CALL_PY_EXACT_ARGS] = "CALL_PY_EXACT_ARGS",
    [CALL_PY_WITH_DEFAULTS] = "CALL_PY_WITH_DEFAULTS",
    [CALL_STR_1] = "CALL_STR_1",
    [CALL_TUPLE_1] = "CALL_TUPLE_1",
    [CALL_TYPE_1] = "CALL_TYPE_1",
    [COMPARE_OP_FLOAT] = "COMPARE_OP_FLOAT",
    [COMPARE_OP_INT] = "COMPARE_OP_INT",
    [COMPARE_OP_STR] = "COMPARE_OP_STR",
    [FOR_ITER_GEN] = "FOR_ITER_GEN",
    [FOR_ITER_LIST] = "FOR_ITER_LIST",
    [FOR_ITER_RANGE] = "FOR_ITER_RANGE",
    [FOR_ITER_TUPLE] = "FOR_ITER_TUPLE",
    [LOAD_ATTR_CLASS] = "LOAD_ATTR_CLASS",
    [LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN] = "LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN",
    [LOAD_ATTR_INSTANCE_VALUE] = "LOAD_ATTR_INSTANCE_VALUE",
    [LOAD_ATTR_METHOD_LAZY_DICT] = "LOAD_ATTR_METHOD_LAZY_DICT",
    [LOAD_ATTR_METHOD_NO_DICT] = "LOAD_ATTR_METHOD_NO_DICT",
    [LOAD_ATTR_METHOD_WITH_VALUES] = "LOAD_ATTR_METHOD_WITH_VALUES",
    [LOAD_ATTR_MODULE] = "LOAD_ATTR_MODULE",
    [LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = "LOAD_ATTR_NONDESCRIPTOR_NO_DICT",
    [LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = "LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES",
    [LOAD_ATTR_PROPERTY] = "LOAD_ATTR_PROPERTY",
    [LOAD_ATTR_SLOT] = "LOAD_ATTR_SLOT",
    [LOAD_ATTR_WITH_HINT] = "LOAD_ATTR_WITH_HINT",
    [LOAD_GLOBAL_BUILTIN] = "LOAD_GLOBAL_BUILTIN",
    [LOAD_GLOBAL_MODULE] = "LOAD_GLOBAL_MODULE",
    [LOAD_SUPER_ATTR_ATTR] = "LOAD_SUPER_ATTR_ATTR",
    [LOAD_SUPER_ATTR_METHOD] = "LOAD_SUPER_ATTR_METHOD",
    [RESUME_CHECK] = "RESUME_CHECK",
    [SEND_GEN] = "SEND_GEN",
    [STORE_ATTR_INSTANCE_VALUE] = "STORE_ATTR_INSTANCE_VALUE",
    [STORE_ATTR_SLOT] = "STORE_ATTR_SLOT",
    [STORE_ATTR_WITH_HINT] = "STORE_ATTR_WITH_HINT",
    [STORE_SUBSCR_DICT] = "STORE_SUBSCR_DICT",
    [STORE_SUBSCR_LIST_INT] = "STORE_SUBSCR_LIST_INT",
    [TO_BOOL_ALWAYS_TRUE] = "TO_BOOL_ALWAYS_TRUE",
    [TO_BOOL_BOOL] = "TO_BOOL_BOOL",
    [TO_BOOL_INT] = "TO_BOOL_INT",
    [TO_BOOL_LIST] = "TO_BOOL_LIST",
    [TO_BOOL_NONE] = "TO_BOOL_NONE",
    [TO_BOOL_STR] = "TO_BOOL_STR",
    [UNPACK_SEQUENCE_LIST] = "UNPACK_SEQUENCE_LIST",
    [UNPACK_SEQUENCE_TUPLE] = "UNPACK_SEQUENCE_TUPLE",
    [UNPACK_SEQUENCE_TWO_TUPLE] = "UNPACK_SEQUENCE_TWO_TUPLE",
    [INSTRUMENTED_RESUME] = "INSTRUMENTED_RESUME",
    [INSTRUMENTED_END_FOR] = "INSTRUMENTED_END_FOR",
    [INSTRUMENTED_END_SEND] = "INSTRUMENTED_END_SEND",
    [INSTRUMENTED_RETURN_VALUE] = "INSTRUMENTED_RETURN_VALUE",
    [INSTRUMENTED_RETURN_CONST] = "INSTRUMENTED_RETURN_CONST",
    [INSTRUMENTED_YIELD_VALUE] = "INSTRUMENTED_YIELD_VALUE",
    [INSTRUMENTED_LOAD_SUPER_ATTR] = "INSTRUMENTED_LOAD_SUPER_ATTR",
    [INSTRUMENTED_FOR_ITER] = "INSTRUMENTED_FOR_ITER",
    [INSTRUMENTED_CALL] = "INSTRUMENTED_CALL",
    [INSTRUMENTED_CALL_KW] = "INSTRUMENTED_CALL_KW",
    [INSTRUMENTED_CALL_FUNCTION_EX] = "INSTRUMENTED_CALL_FUNCTION_EX",
    [INSTRUMENTED_INSTRUCTION] = "INSTRUMENTED_INSTRUCTION",
    [INSTRUMENTED_JUMP_FORWARD] = "INSTRUMENTED_JUMP_FORWARD",
    [INSTRUMENTED_JUMP_BACKWARD] = "INSTRUMENTED_JUMP_BACKWARD",
    [INSTRUMENTED_POP_JUMP_IF_TRUE] = "INSTRUMENTED_POP_JUMP_IF_TRUE",
    [INSTRUMENTED_POP_JUMP_IF_FALSE] = "INSTRUMENTED_POP_JUMP_IF_FALSE",
    [INSTRUMENTED_POP_JUMP_IF_NONE] = "INSTRUMENTED_POP_JUMP_IF_NONE",
    [INSTRUMENTED_POP_JUMP_IF_NOT_NONE] = "INSTRUMENTED_POP_JUMP_IF_NOT_NONE",
    [INSTRUMENTED_LINE] = "INSTRUMENTED_LINE",
    [JUMP] = "JUMP",
    [JUMP_NO_INTERRUPT] = "JUMP_NO_INTERRUPT",
    [LOAD_CLOSURE] = "LOAD_CLOSURE",
    [LOAD_METHOD] = "LOAD_METHOD",
    [LOAD_SUPER_METHOD] = "LOAD_SUPER_METHOD",
    [LOAD_ZERO_SUPER_ATTR] = "LOAD_ZERO_SUPER_ATTR",
    [LOAD_ZERO_SUPER_METHOD] = "LOAD_ZERO_SUPER_METHOD",
    [POP_BLOCK] = "POP_BLOCK",
    [SETUP_CLEANUP] = "SETUP_CLEANUP",
    [SETUP_FINALLY] = "SETUP_FINALLY",
    [SETUP_WITH] = "SETUP_WITH",
    [STORE_FAST_MAYBE_NULL] = "STORE_FAST_MAYBE_NULL",
};
#endif // NEED_OPCODE_METADATA

extern const uint8_t _PyOpcode_Caches[256];
#ifdef NEED_OPCODE_METADATA
const uint8_t _PyOpcode_Caches[256] = {
    [TO_BOOL] = 3,
    [BINARY_SUBSCR] = 1,
    [STORE_SUBSCR] = 1,
    [SEND] = 1,
    [UNPACK_SEQUENCE] = 1,
    [STORE_ATTR] = 4,
    [LOAD_GLOBAL] = 4,
    [LOAD_SUPER_ATTR] = 1,
    [LOAD_ATTR] = 9,
    [COMPARE_OP] = 1,
    [POP_JUMP_IF_FALSE] = 1,
    [POP_JUMP_IF_TRUE] = 1,
    [POP_JUMP_IF_NONE] = 1,
    [POP_JUMP_IF_NOT_NONE] = 1,
    [FOR_ITER] = 1,
    [CALL] = 3,
    [BINARY_OP] = 1,
    [JUMP_BACKWARD] = 1,
};
#endif // NEED_OPCODE_METADATA

extern const uint8_t _PyOpcode_Deopt[256];
#ifdef NEED_OPCODE_METADATA
const uint8_t _PyOpcode_Deopt[256] = {
    [BEFORE_ASYNC_WITH] = BEFORE_ASYNC_WITH,
    [BEFORE_WITH] = BEFORE_WITH,
    [BINARY_OP] = BINARY_OP,
    [BINARY_OP_ADD_FLOAT] = BINARY_OP,
    [BINARY_OP_ADD_INT] = BINARY_OP,
    [BINARY_OP_ADD_UNICODE] = BINARY_OP,
    [BINARY_OP_INPLACE_ADD_UNICODE] = BINARY_OP,
    [BINARY_OP_MULTIPLY_FLOAT] = BINARY_OP,
    [BINARY_OP_MULTIPLY_INT] = BINARY_OP,
    [BINARY_OP_SUBTRACT_FLOAT] = BINARY_OP,
    [BINARY_OP_SUBTRACT_INT] = BINARY_OP,
    [BINARY_SLICE] = BINARY_SLICE,
    [BINARY_SUBSCR] = BINARY_SUBSCR,
    [BINARY_SUBSCR_DICT] = BINARY_SUBSCR,
    [BINARY_SUBSCR_GETITEM] = BINARY_SUBSCR,
    [BINARY_SUBSCR_LIST_INT] = BINARY_SUBSCR,
    [BINARY_SUBSCR_STR_INT] = BINARY_SUBSCR,
    [BINARY_SUBSCR_TUPLE_INT] = BINARY_SUBSCR,
    [BUILD_CONST_KEY_MAP] = BUILD_CONST_KEY_MAP,
    [BUILD_LIST] = BUILD_LIST,
    [BUILD_MAP] = BUILD_MAP,
    [BUILD_SET] = BUILD_SET,
    [BUILD_SLICE] = BUILD_SLICE,
    [BUILD_STRING] = BUILD_STRING,
    [BUILD_TUPLE] = BUILD_TUPLE,
    [CACHE] = CACHE,
    [CALL] = CALL,
    [CALL_ALLOC_AND_ENTER_INIT] = CALL,
    [CALL_BOUND_METHOD_EXACT_ARGS] = CALL,
    [CALL_BUILTIN_CLASS] = CALL,
    [CALL_BUILTIN_FAST] = CALL,
    [CALL_BUILTIN_FAST_WITH_KEYWORDS] = CALL,
    [CALL_BUILTIN_O] = CALL,
    [CALL_FUNCTION_EX] = CALL_FUNCTION_EX,
    [CALL_INTRINSIC_1] = CALL_INTRINSIC_1,
    [CALL_INTRINSIC_2] = CALL_INTRINSIC_2,
    [CALL_ISINSTANCE] = CALL,
    [CALL_KW] = CALL_KW,
    [CALL_LEN] = CALL,
    [CALL_LIST_APPEND] = CALL,
    [CALL_METHOD_DESCRIPTOR_FAST] = CALL,
    [CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS] = CALL,
    [CALL_METHOD_DESCRIPTOR_NOARGS] = CALL,
    [CALL_METHOD_DESCRIPTOR_O] = CALL,
    [CALL_PY_EXACT_ARGS] = CALL,
    [CALL_PY_WITH_DEFAULTS] = CALL,
    [CALL_STR_1] = CALL,
    [CALL_TUPLE_1] = CALL,
    [CALL_TYPE_1] = CALL,
    [CHECK_EG_MATCH] = CHECK_EG_MATCH,
    [CHECK_EXC_MATCH] = CHECK_EXC_MATCH,
    [CLEANUP_THROW] = CLEANUP_THROW,
    [COMPARE_OP] = COMPARE_OP,
    [COMPARE_OP_FLOAT] = COMPARE_OP,
    [COMPARE_OP_INT] = COMPARE_OP,
    [COMPARE_OP_STR] = COMPARE_OP,
    [CONTAINS_OP] = CONTAINS_OP,
    [CONVERT_VALUE] = CONVERT_VALUE,
    [COPY] = COPY,
    [COPY_FREE_VARS] = COPY_FREE_VARS,
    [DELETE_ATTR] = DELETE_ATTR,
    [DELETE_DEREF] = DELETE_DEREF,
    [DELETE_FAST] = DELETE_FAST,
    [DELETE_GLOBAL] = DELETE_GLOBAL,
    [DELETE_NAME] = DELETE_NAME,
    [DELETE_SUBSCR] = DELETE_SUBSCR,
    [DICT_MERGE] = DICT_MERGE,
    [DICT_UPDATE] = DICT_UPDATE,
    [END_ASYNC_FOR] = END_ASYNC_FOR,
    [END_FOR] = END_FOR,
    [END_SEND] = END_SEND,
    [ENTER_EXECUTOR] = ENTER_EXECUTOR,
    [EXIT_INIT_CHECK] = EXIT_INIT_CHECK,
    [EXTENDED_ARG] = EXTENDED_ARG,
    [FORMAT_SIMPLE] = FORMAT_SIMPLE,
    [FORMAT_WITH_SPEC] = FORMAT_WITH_SPEC,
    [FOR_ITER] = FOR_ITER,
    [FOR_ITER_GEN] = FOR_ITER,
    [FOR_ITER_LIST] = FOR_ITER,
    [FOR_ITER_RANGE] = FOR_ITER,
    [FOR_ITER_TUPLE] = FOR_ITER,
    [GET_AITER] = GET_AITER,
    [GET_ANEXT] = GET_ANEXT,
    [GET_AWAITABLE] = GET_AWAITABLE,
    [GET_ITER] = GET_ITER,
    [GET_LEN] = GET_LEN,
    [GET_YIELD_FROM_ITER] = GET_YIELD_FROM_ITER,
    [IMPORT_FROM] = IMPORT_FROM,
    [IMPORT_NAME] = IMPORT_NAME,
    [INSTRUMENTED_CALL] = INSTRUMENTED_CALL,
    [INSTRUMENTED_CALL_FUNCTION_EX] = INSTRUMENTED_CALL_FUNCTION_EX,
    [INSTRUMENTED_CALL_KW] = INSTRUMENTED_CALL_KW,
    [INSTRUMENTED_END_FOR] = INSTRUMENTED_END_FOR,
    [INSTRUMENTED_END_SEND] = INSTRUMENTED_END_SEND,
    [INSTRUMENTED_FOR_ITER] = INSTRUMENTED_FOR_ITER,
    [INSTRUMENTED_INSTRUCTION] = INSTRUMENTED_INSTRUCTION,
    [INSTRUMENTED_JUMP_BACKWARD] = INSTRUMENTED_JUMP_BACKWARD,
    [INSTRUMENTED_JUMP_FORWARD] = INSTRUMENTED_JUMP_FORWARD,
    [INSTRUMENTED_LINE] = INSTRUMENTED_LINE,
    [INSTRUMENTED_LOAD_SUPER_ATTR] = INSTRUMENTED_LOAD_SUPER_ATTR,
    [INSTRUMENTED_POP_JUMP_IF_FALSE] = INSTRUMENTED_POP_JUMP_IF_FALSE,
    [INSTRUMENTED_POP_JUMP_IF_NONE] = INSTRUMENTED_POP_JUMP_IF_NONE,
    [INSTRUMENTED_POP_JUMP_IF_NOT_NONE] = INSTRUMENTED_POP_JUMP_IF_NOT_NONE,
    [INSTRUMENTED_POP_JUMP_IF_TRUE] = INSTRUMENTED_POP_JUMP_IF_TRUE,
    [INSTRUMENTED_RESUME] = INSTRUMENTED_RESUME,
    [INSTRUMENTED_RETURN_CONST] = INSTRUMENTED_RETURN_CONST,
    [INSTRUMENTED_RETURN_VALUE] = INSTRUMENTED_RETURN_VALUE,
    [INSTRUMENTED_YIELD_VALUE] = INSTRUMENTED_YIELD_VALUE,
    [INTERPRETER_EXIT] = INTERPRETER_EXIT,
    [IS_OP] = IS_OP,
    [JUMP_BACKWARD] = JUMP_BACKWARD,
    [JUMP_BACKWARD_NO_INTERRUPT] = JUMP_BACKWARD_NO_INTERRUPT,
    [JUMP_FORWARD] = JUMP_FORWARD,
    [LIST_APPEND] = LIST_APPEND,
    [LIST_EXTEND] = LIST_EXTEND,
    [LOAD_ASSERTION_ERROR] = LOAD_ASSERTION_ERROR,
    [LOAD_ATTR] = LOAD_ATTR,
    [LOAD_ATTR_CLASS] = LOAD_ATTR,
    [LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN] = LOAD_ATTR,
    [LOAD_ATTR_INSTANCE_VALUE] = LOAD_ATTR,
    [LOAD_ATTR_METHOD_LAZY_DICT] = LOAD_ATTR,
    [LOAD_ATTR_METHOD_NO_DICT] = LOAD_ATTR,
    [LOAD_ATTR_METHOD_WITH_VALUES] = LOAD_ATTR,
    [LOAD_ATTR_MODULE] = LOAD_ATTR,
    [LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = LOAD_ATTR,
    [LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = LOAD_ATTR,
    [LOAD_ATTR_PROPERTY] = LOAD_ATTR,
    [LOAD_ATTR_SLOT] = LOAD_ATTR,
    [LOAD_ATTR_WITH_HINT] = LOAD_ATTR,
    [LOAD_BUILD_CLASS] = LOAD_BUILD_CLASS,
    [LOAD_CONST] = LOAD_CONST,
    [LOAD_DEREF] = LOAD_DEREF,
    [LOAD_FAST] = LOAD_FAST,
    [LOAD_FAST_AND_CLEAR] = LOAD_FAST_AND_CLEAR,
    [LOAD_FAST_CHECK] = LOAD_FAST_CHECK,
    [LOAD_FAST_LOAD_FAST] = LOAD_FAST_LOAD_FAST,
    [LOAD_FROM_DICT_OR_DEREF] = LOAD_FROM_DICT_OR_DEREF,
    [LOAD_FROM_DICT_OR_GLOBALS] = LOAD_FROM_DICT_OR_GLOBALS,
    [LOAD_GLOBAL] = LOAD_GLOBAL,
    [LOAD_GLOBAL_BUILTIN] = LOAD_GLOBAL,
    [LOAD_GLOBAL_MODULE] = LOAD_GLOBAL,
    [LOAD_LOCALS] = LOAD_LOCALS,
    [LOAD_NAME] = LOAD_NAME,
    [LOAD_SUPER_ATTR] = LOAD_SUPER_ATTR,
    [LOAD_SUPER_ATTR_ATTR] = LOAD_SUPER_ATTR,
    [LOAD_SUPER_ATTR_METHOD] = LOAD_SUPER_ATTR,
    [MAKE_CELL] = MAKE_CELL,
    [MAKE_FUNCTION] = MAKE_FUNCTION,
    [MAP_ADD] = MAP_ADD,
    [MATCH_CLASS] = MATCH_CLASS,
    [MATCH_KEYS] = MATCH_KEYS,
    [MATCH_MAPPING] = MATCH_MAPPING,
    [MATCH_SEQUENCE] = MATCH_SEQUENCE,
    [NOP] = NOP,
    [POP_EXCEPT] = POP_EXCEPT,
    [POP_JUMP_IF_FALSE] = POP_JUMP_IF_FALSE,
    [POP_JUMP_IF_NONE] = POP_JUMP_IF_NONE,
    [POP_JUMP_IF_NOT_NONE] = POP_JUMP_IF_NOT_NONE,
    [POP_JUMP_IF_TRUE] = POP_JUMP_IF_TRUE,
    [POP_TOP] = POP_TOP,
    [PUSH_EXC_INFO] = PUSH_EXC_INFO,
    [PUSH_NULL] = PUSH_NULL,
    [RAISE_VARARGS] = RAISE_VARARGS,
    [RERAISE] = RERAISE,
    [RESERVED] = RESERVED,
    [RESUME] = RESUME,
    [RESUME_CHECK] = RESUME,
    [RETURN_CONST] = RETURN_CONST,
    [RETURN_GENERATOR] = RETURN_GENERATOR,
    [RETURN_VALUE] = RETURN_VALUE,
    [SEND] = SEND,
    [SEND_GEN] = SEND,
    [SETUP_ANNOTATIONS] = SETUP_ANNOTATIONS,
    [SET_ADD] = SET_ADD,
    [SET_FUNCTION_ATTRIBUTE] = SET_FUNCTION_ATTRIBUTE,
    [SET_UPDATE] = SET_UPDATE,
    [STORE_ATTR] = STORE_ATTR,
    [STORE_ATTR_INSTANCE_VALUE] = STORE_ATTR,
    [STORE_ATTR_SLOT] = STORE_ATTR,
    [STORE_ATTR_WITH_HINT] = STORE_ATTR,
    [STORE_DEREF] = STORE_DEREF,
    [STORE_FAST] = STORE_FAST,
    [STORE_FAST_LOAD_FAST] = STORE_FAST_LOAD_FAST,
    [STORE_FAST_STORE_FAST] = STORE_FAST_STORE_FAST,
    [STORE_GLOBAL] = STORE_GLOBAL,
    [STORE_NAME] = STORE_NAME,
    [STORE_SLICE] = STORE_SLICE,
    [STORE_SUBSCR] = STORE_SUBSCR,
    [STORE_SUBSCR_DICT] = STORE_SUBSCR,
    [STORE_SUBSCR_LIST_INT] = STORE_SUBSCR,
    [SWAP] = SWAP,
    [TO_BOOL] = TO_BOOL,
    [TO_BOOL_ALWAYS_TRUE] = TO_BOOL,
    [TO_BOOL_BOOL] = TO_BOOL,
    [TO_BOOL_INT] = TO_BOOL,
    [TO_BOOL_LIST] = TO_BOOL,
    [TO_BOOL_NONE] = TO_BOOL,
    [TO_BOOL_STR] = TO_BOOL,
    [UNARY_INVERT] = UNARY_INVERT,
    [UNARY_NEGATIVE] = UNARY_NEGATIVE,
    [UNARY_NOT] = UNARY_NOT,
    [UNPACK_EX] = UNPACK_EX,
    [UNPACK_SEQUENCE] = UNPACK_SEQUENCE,
    [UNPACK_SEQUENCE_LIST] = UNPACK_SEQUENCE,
    [UNPACK_SEQUENCE_TUPLE] = UNPACK_SEQUENCE,
    [UNPACK_SEQUENCE_TWO_TUPLE] = UNPACK_SEQUENCE,
    [WITH_EXCEPT_START] = WITH_EXCEPT_START,
    [YIELD_VALUE] = YIELD_VALUE,
};
#endif // NEED_OPCODE_METADATA

#define EXTRA_CASES \
    case 119: \
    case 120: \
    case 121: \
    case 122: \
    case 123: \
    case 124: \
    case 125: \
    case 126: \
    case 127: \
    case 128: \
    case 129: \
    case 130: \
    case 131: \
    case 132: \
    case 133: \
    case 134: \
    case 135: \
    case 136: \
    case 137: \
    case 138: \
    case 139: \
    case 140: \
    case 141: \
    case 142: \
    case 143: \
    case 144: \
    case 145: \
    case 146: \
    case 147: \
    case 148: \
    case 219: \
    case 220: \
    case 221: \
    case 222: \
    case 223: \
    case 224: \
    case 225: \
    case 226: \
    case 227: \
    case 228: \
    case 229: \
    case 230: \
    case 231: \
    case 232: \
    case 233: \
    case 234: \
    case 235: \
    case 255: \
        ;

