#!/usr/bin/env python
""" A simple tool for importing the cffi version into pypy, should sync
whatever version you provide. Usage:

import_cffi.py <path-to-cffi>
"""

import sys, py

def mangle(lines, ext):
    if ext == '.py':
        yield "# Generated by pypy/tool/import_cffi.py\n"
        for line in lines:
            line = line.replace('from testing', 'from pypy.module.test_lib_pypy.cffi_tests')
            yield line
    elif ext in ('.c', '.h'):
        yield "/* Generated by pypy/tool/import_cffi.py */\n"
        for line in lines:
            yield line
    else:
        raise AssertionError(ext)

def main(cffi_dir):
    cffi_dir = py.path.local(cffi_dir)
    pypydir = py.path.local(__file__).join('..', '..')
    cffi_dest = pypydir.join('..', 'lib_pypy', 'cffi')
    cffi_dest.ensure(dir=1)
    test_dest = pypydir.join('module', 'test_lib_pypy', 'cffi_tests')
    test_dest.ensure(dir=1)
    for p in (list(cffi_dir.join('cffi').visit(fil='*.py')) +
              list(cffi_dir.join('cffi').visit(fil='*.h'))):
        cffi_dest.join('..', p.relto(cffi_dir)).write(p.read())
    for p in (list(cffi_dir.join('testing').visit(fil='*.py')) +
              list(cffi_dir.join('testing').visit(fil='*.h')) +
              list(cffi_dir.join('testing').visit(fil='*.c'))):
        path = test_dest.join(p.relto(cffi_dir.join('testing')))
        path.join('..').ensure(dir=1)
        path.write(''.join(mangle(p.readlines(), p.ext)))

if __name__ == '__main__':
    if len(sys.argv) != 2:
        print __doc__
        sys.exit(2)
    main(sys.argv[1])
