/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 3 "osmgpsmap.override"
#include <Python.h>
#include <pygobject.h>
#include <pygtk/pygtk.h>
#include "osm-gps-map.h"
#line 13 "osmgpsmap.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)
static PyTypeObject *_PyGtkDrawingArea_Type;
#define PyGtkDrawingArea_Type (*_PyGtkDrawingArea_Type)
static PyTypeObject *_PyGdkPixbuf_Type;
#define PyGdkPixbuf_Type (*_PyGdkPixbuf_Type)
static PyTypeObject *_PyGdkDrawable_Type;
#define PyGdkDrawable_Type (*_PyGdkDrawable_Type)
static PyTypeObject *_PyGdkGC_Type;
#define PyGdkGC_Type (*_PyGdkGC_Type)
static PyTypeObject *_PyGtkRectangle_Type;
#define PyGtkRectangle_Type (*_PyGtkRectangle_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapPoint_Type;
PyTypeObject G_GNUC_INTERNAL PyOsmGpsMap_Type;
PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapImage_Type;
PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapOsd_Type;
PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapTrack_Type;
PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapLayer_Type;

#line 39 "osmgpsmap.c"



/* ----------- OsmGpsMapPoint ----------- */

static int
pygobject_no_constructor(PyObject *self, PyObject *args, PyObject *kwargs)
{
    gchar buf[512];

    g_snprintf(buf, sizeof(buf), "%s is an abstract widget", self->ob_type->tp_name);
    PyErr_SetString(PyExc_NotImplementedError, buf);
    return -1;
}

#line 110 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_point_get_degrees(PyGObject *self)
{
    float lat, lon;

    osm_gps_map_point_get_degrees(pyg_boxed_get(self, OsmGpsMapPoint), &lat, &lon);

    return Py_BuildValue("(ff)", lat, lon);
}
#line 65 "osmgpsmap.c"


#line 121 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_point_get_radians(PyGObject *self)
{
    float rlat, rlon;

    osm_gps_map_point_get_radians(pyg_boxed_get(self, OsmGpsMapPoint), &rlat, &rlon);

    return Py_BuildValue("(ff)", rlat, rlon);
}
#line 78 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_point_set_degrees(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "lat", "lon", NULL };
    double lat, lon;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dd:Osm.Point.set_degrees", kwlist, &lat, &lon))
        return NULL;
    
    osm_gps_map_point_set_degrees(pyg_boxed_get(self, OsmGpsMapPoint), lat, lon);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_point_set_radians(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "rlat", "rlon", NULL };
    double rlat, rlon;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dd:Osm.Point.set_radians", kwlist, &rlat, &rlon))
        return NULL;
    
    osm_gps_map_point_set_radians(pyg_boxed_get(self, OsmGpsMapPoint), rlat, rlon);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyOsmGpsMapPoint_methods[] = {
    { "get_degrees", (PyCFunction)_wrap_osm_gps_map_point_get_degrees, METH_NOARGS,
      NULL },
    { "get_radians", (PyCFunction)_wrap_osm_gps_map_point_get_radians, METH_NOARGS,
      NULL },
    { "set_degrees", (PyCFunction)_wrap_osm_gps_map_point_set_degrees, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_radians", (PyCFunction)_wrap_osm_gps_map_point_set_radians, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

static PyObject *
_wrap_osm_gps_map_point__get_rlat(PyObject *self, void *closure)
{
    double ret;

    ret = pyg_boxed_get(self, OsmGpsMapPoint)->rlat;
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_osm_gps_map_point__get_rlon(PyObject *self, void *closure)
{
    double ret;

    ret = pyg_boxed_get(self, OsmGpsMapPoint)->rlon;
    return PyFloat_FromDouble(ret);
}

static const PyGetSetDef osm_gps_map_point_getsets[] = {
    { "rlat", (getter)_wrap_osm_gps_map_point__get_rlat, (setter)0 },
    { "rlon", (getter)_wrap_osm_gps_map_point__get_rlon, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapPoint_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "osmgpsmap.Point",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyOsmGpsMapPoint_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)osm_gps_map_point_getsets,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)pygobject_no_constructor,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- OsmGpsMap ----------- */

static int
_wrap_osm_gps_map_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GType obj_type = pyg_type_from_object((PyObject *) self);
    GParameter params[22];
    PyObject *parsed_args[22] = {NULL, };
    char *arg_names[] = {"auto_center", "auto_center_threshold", "record_trip_history", "show_trip_history", "show_gps_point", "auto_download", "repo_uri", "proxy_uri", "tile_cache", "tile_cache_base", "tile_cache_is_full_path", "zoom", "max_zoom", "min_zoom", "map_x", "map_y", "gps_track_width", "gps_track_point_radius", "gps_track_highlight_radius", "map_source", "image_format", "drag_limit", NULL };
    char *prop_names[] = {"auto_center", "auto_center_threshold", "record_trip_history", "show_trip_history", "show_gps_point", "auto_download", "repo_uri", "proxy_uri", "tile_cache", "tile_cache_base", "tile_cache_is_full_path", "zoom", "max_zoom", "min_zoom", "map_x", "map_y", "gps_track_width", "gps_track_point_radius", "gps_track_highlight_radius", "map_source", "image_format", "drag_limit", NULL };
    guint nparams, i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OOOOOOOOOOOOOOOOOOOOOO:osmgpsmap.GpsMap.__init__" , arg_names , &parsed_args[0] , &parsed_args[1] , &parsed_args[2] , &parsed_args[3] , &parsed_args[4] , &parsed_args[5] , &parsed_args[6] , &parsed_args[7] , &parsed_args[8] , &parsed_args[9] , &parsed_args[10] , &parsed_args[11] , &parsed_args[12] , &parsed_args[13] , &parsed_args[14] , &parsed_args[15] , &parsed_args[16] , &parsed_args[17] , &parsed_args[18] , &parsed_args[19] , &parsed_args[20] , &parsed_args[21]))
        return -1;

    memset(params, 0, sizeof(GParameter)*22);
    if (!pyg_parse_constructor_args(obj_type, arg_names,
                                    prop_names, params, 
                                    &nparams, parsed_args))
        return -1;
    pygobject_constructv(self, nparams, params);
    for (i = 0; i < nparams; ++i)
        g_value_unset(&params[i].value);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create osmgpsmap.GpsMap object");
        return -1;
    }
    return 0;
}

#line 201 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_add_track(PyGObject *self, PyObject *args, 
                                     PyObject *kwargs)
{
    static char *kwlist[] = { "track", NULL };
    float rlat,rlon;
    int i, numItems;
    PyObject *list;
    PyObject *coords;
    GSList *track = NULL;
    int err = FALSE;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GpsMap.add_track", kwlist, &PyList_Type, &list))
        return NULL;

    numItems = PyList_Size(list);
    for(i = 0; i < numItems; i++)
    {
        coords = PyList_GetItem(list,i);
        if(PyArg_ParseTuple(coords,"ff",&rlat,&rlon)) 
        {
            OsmGpsMapPoint *c = osm_gps_map_point_new_radians (rlat, rlon);
            track = g_slist_append(track, c);
        }
        else
        {
            err = TRUE;
            break;
        }
    }

    if (err) 
    {
    	if (track) 
        {
    		g_slist_foreach(track, (GFunc) g_free, NULL);
	    	g_slist_free(track);
        }
        PyErr_SetString(PyExc_ValueError, "track cordinates must be a 2-tuple of lat,lon in radians");
    	return NULL;
    }
    else
    {
        osm_gps_map_add_track(OSM_GPS_MAP(self->obj), track);
    }
    Py_RETURN_NONE;
}
// vim: filetype=c
#line 275 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_clear_tracks(PyGObject *self)
{
    
    osm_gps_map_clear_tracks(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_add_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "image", NULL };
    PyGObject *image;
    double latitude, longitude;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ddO!:Osm.GpsMap.add_image", kwlist, &latitude, &longitude, &PyGdkPixbuf_Type, &image))
        return NULL;
    
    osm_gps_map_add_image(OSM_GPS_MAP(self->obj), latitude, longitude, GDK_PIXBUF(image->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_remove_image(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "image", NULL };
    PyGObject *image;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.remove_image", kwlist, &PyGdkPixbuf_Type, &image))
        return NULL;
    
    ret = osm_gps_map_remove_image(OSM_GPS_MAP(self->obj), GDK_PIXBUF(image->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_osm_gps_map_clear_images(PyGObject *self)
{
    
    osm_gps_map_clear_images(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_draw_gps(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "heading", NULL };
    double latitude, longitude, heading;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ddd:Osm.GpsMap.draw_gps", kwlist, &latitude, &longitude, &heading))
        return NULL;
    
    osm_gps_map_draw_gps(OSM_GPS_MAP(self->obj), latitude, longitude, heading);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_clear_gps(PyGObject *self)
{
    
    osm_gps_map_clear_gps(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_add_layer(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "layer", NULL };
    PyGObject *layer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.add_layer", kwlist, &PyOsmGpsMapLayer_Type, &layer))
        return NULL;
    
    osm_gps_map_add_layer(OSM_GPS_MAP(self->obj), OSM_GPS_MAP_LAYER(layer->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 137 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_get_co_ordinates(PyGObject *self, PyObject *args, 
                                     PyObject *kwargs)
{
    static char *kwlist[] = { "pixel_x", "pixel_y", NULL };
    int pixel_x = -1, pixel_y = -1;
    OsmGpsMapPoint coord;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "|ii:GpsMap.get_co_ordinates",
				     kwlist, &pixel_x, &pixel_y))
        return NULL;

    if ( pixel_x < 0 || pixel_y < 0 ) {
    	PyErr_SetString(PyExc_ValueError, "pixel co-ordinatites must be >= 0");
    	return NULL;
	}

    osm_gps_map_convert_screen_to_geographic(OSM_GPS_MAP(self->obj), pixel_x, pixel_y, &coord);

    return Py_BuildValue("(dd)", coord.rlat, coord.rlon);
}
#line 393 "osmgpsmap.c"


#line 161 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_screen_to_geographic(PyGObject *self, PyObject *args)
{
    int pixel_x, pixel_y;
    OsmGpsMapPoint coord;
    gfloat lat, lon;

    if (PyTuple_Size(args) == 1)
        args = PyTuple_GetItem(args, 0);
    if (!PyArg_ParseTuple(args, "ii:OsmGpsMap.screen_to_geographic takes two"
                          "integers (also in a tuple)", &pixel_x, &pixel_y))
        return NULL;

    osm_gps_map_convert_screen_to_geographic(OSM_GPS_MAP(self->obj), pixel_x, pixel_y, &coord);
    osm_gps_map_point_get_degrees(&coord, &lat, &lon);

    return Py_BuildValue("(ff)", lat, lon);
}
#line 415 "osmgpsmap.c"


#line 181 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_geographic_to_screen(PyGObject *self, PyObject *args)
{
    int pixel_x, pixel_y;
    gfloat lat, lon;
    OsmGpsMapPoint coord;

    if (PyTuple_Size(args) == 1)
        args = PyTuple_GetItem(args, 0);
    if (!PyArg_ParseTuple(args, "ff:OsmGpsMap.geographic_to_screen takes two"
                          "floats (also in a tuple)", &lat, &lon))
        return NULL;

    osm_gps_map_point_set_degrees(&coord, lat, lon);
    osm_gps_map_convert_geographic_to_screen(OSM_GPS_MAP(self->obj), &coord, &pixel_x, &pixel_y);

    return Py_BuildValue("(ii)", pixel_x, pixel_y);
}
#line 437 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_set_mapcenter(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "zoom", NULL };
    int zoom;
    double latitude, longitude;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ddi:Osm.GpsMap.set_mapcenter", kwlist, &latitude, &longitude, &zoom))
        return NULL;
    
    osm_gps_map_set_mapcenter(OSM_GPS_MAP(self->obj), latitude, longitude, zoom);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 67 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_download_maps(PyGObject *self, PyObject *args, 
                                     PyObject *kwargs)
{
    static char *kwlist[] = { "lat1", "lon1", "lat2", "lon2", "zoom_start", "zoom_end", NULL };
    int zoom_start, zoom_end;
    OsmGpsMapPoint pt1, pt2;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				        "ffffii:GpsMap.download_maps",
				        kwlist, &pt1.rlat,&pt1.rlon,&pt2.rlat, &pt2.rlon,
                        &zoom_start, &zoom_end))
        return NULL;

    osm_gps_map_download_maps(OSM_GPS_MAP(self->obj), &pt1, &pt2, zoom_start, zoom_end);

    Py_RETURN_NONE;
}
#line 475 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_download_cancel_all(PyGObject *self)
{
    
    osm_gps_map_download_cancel_all(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 21 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_get_bbox(PyGObject *self)
{
    OsmGpsMapPoint pt1,pt2;

    osm_gps_map_get_bbox(OSM_GPS_MAP(self->obj), &pt1, &pt2);

    return Py_BuildValue("(dddd)", pt1.rlat, pt1.rlon, pt2.rlat, pt2.rlon);
}
#line 498 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_set_center_and_zoom(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "zoom", NULL };
    int zoom;
    double latitude, longitude;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ddi:Osm.GpsMap.set_center_and_zoom", kwlist, &latitude, &longitude, &zoom))
        return NULL;
    
    osm_gps_map_set_center_and_zoom(OSM_GPS_MAP(self->obj), latitude, longitude, zoom);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 32 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_set_center(PyGObject *self, PyObject *args)
{
    double latitude, longitude;

    if (PyTuple_Size(args) == 1)
        args = PyTuple_GetItem(args, 0);
    if (!PyArg_ParseTuple(args, "dd;OsmGpsMap.set_center takes two floats (also in a tuple)",
                          &latitude, &longitude))
        return NULL;
    osm_gps_map_set_center(OSM_GPS_MAP(self->obj), latitude, longitude);

    Py_INCREF(Py_None);
    return Py_None;
}
#line 533 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_set_zoom(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "zoom", NULL };
    int zoom, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:Osm.GpsMap.set_zoom", kwlist, &zoom))
        return NULL;
    
    ret = osm_gps_map_set_zoom(OSM_GPS_MAP(self->obj), zoom);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_osm_gps_map_set_zoom_offset(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "zoom_offset", NULL };
    int zoom_offset;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:Osm.GpsMap.set_zoom_offset", kwlist, &zoom_offset))
        return NULL;
    
    osm_gps_map_set_zoom_offset(OSM_GPS_MAP(self->obj), zoom_offset);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_zoom_in(PyGObject *self)
{
    int ret;

    
    ret = osm_gps_map_zoom_in(OSM_GPS_MAP(self->obj));
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_osm_gps_map_zoom_out(PyGObject *self)
{
    int ret;

    
    ret = osm_gps_map_zoom_out(OSM_GPS_MAP(self->obj));
    
    return PyInt_FromLong(ret);
}

#line 49 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_scroll(PyGObject *self, PyObject *args)
{
    int dx, dy;

    if (PyTuple_Size(args) == 1)
        args = PyTuple_GetItem(args, 0);
    if (!PyArg_ParseTuple(args, "ii:OsmGpsMap.scroll takes two "
                          "integers (also in a tuple)", &dx, &dy))
        return NULL;

    osm_gps_map_scroll(OSM_GPS_MAP(self->obj), dx, dy);

    Py_INCREF(Py_None);
    return Py_None;
}
#line 604 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_get_scale(PyGObject *self)
{
    double ret;

    
    ret = osm_gps_map_get_scale(OSM_GPS_MAP(self->obj));
    
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_osm_gps_map_set_keyboard_shortcut(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "keyval", NULL };
    int key;
    PyObject *py_keyval = NULL;
    guint keyval = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"iO:Osm.GpsMap.set_keyboard_shortcut", kwlist, &key, &py_keyval))
        return NULL;
    if (py_keyval) {
        if (PyLong_Check(py_keyval))
            keyval = PyLong_AsUnsignedLong(py_keyval);
        else if (PyInt_Check(py_keyval))
            keyval = PyInt_AsLong(py_keyval);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'keyval' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    osm_gps_map_set_keyboard_shortcut(OSM_GPS_MAP(self->obj), key, keyval);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_track_add(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "track", NULL };
    PyGObject *track;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.track_add", kwlist, &PyOsmGpsMapTrack_Type, &track))
        return NULL;
    
    osm_gps_map_track_add(OSM_GPS_MAP(self->obj), OSM_GPS_MAP_TRACK(track->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_track_remove_all(PyGObject *self)
{
    
    osm_gps_map_track_remove_all(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_track_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "track", NULL };
    PyGObject *track;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.track_remove", kwlist, &PyOsmGpsMapTrack_Type, &track))
        return NULL;
    
    ret = osm_gps_map_track_remove(OSM_GPS_MAP(self->obj), OSM_GPS_MAP_TRACK(track->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_osm_gps_map_gps_add(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "heading", NULL };
    double latitude, longitude, heading = OSM_GPS_MAP_INVALID;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dd|d:Osm.GpsMap.gps_add", kwlist, &latitude, &longitude, &heading))
        return NULL;
    
    osm_gps_map_gps_add(OSM_GPS_MAP(self->obj), latitude, longitude, heading);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_gps_clear(PyGObject *self)
{
    
    osm_gps_map_gps_clear(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_gps_get_track(PyGObject *self)
{
    OsmGpsMapTrack *ret;

    
    ret = osm_gps_map_gps_get_track(OSM_GPS_MAP(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_osm_gps_map_image_add(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "image", NULL };
    PyGObject *image;
    double latitude, longitude;
    OsmGpsMapImage *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ddO!:Osm.GpsMap.image_add", kwlist, &latitude, &longitude, &PyGdkPixbuf_Type, &image))
        return NULL;
    
    ret = osm_gps_map_image_add(OSM_GPS_MAP(self->obj), latitude, longitude, GDK_PIXBUF(image->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_osm_gps_map_image_add_with_alignment(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "latitude", "longitude", "image", "xalign", "yalign", NULL };
    PyGObject *image;
    double latitude, longitude, xalign, yalign;
    OsmGpsMapImage *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ddO!dd:Osm.GpsMap.image_add_with_alignment", kwlist, &latitude, &longitude, &PyGdkPixbuf_Type, &image, &xalign, &yalign))
        return NULL;
    
    ret = osm_gps_map_image_add_with_alignment(OSM_GPS_MAP(self->obj), latitude, longitude, GDK_PIXBUF(image->obj), xalign, yalign);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_osm_gps_map_image_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "image", NULL };
    PyGObject *image;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.image_remove", kwlist, &PyOsmGpsMapImage_Type, &image))
        return NULL;
    
    ret = osm_gps_map_image_remove(OSM_GPS_MAP(self->obj), OSM_GPS_MAP_IMAGE(image->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_osm_gps_map_image_remove_all(PyGObject *self)
{
    
    osm_gps_map_image_remove_all(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_layer_add(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "layer", NULL };
    PyGObject *layer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.layer_add", kwlist, &PyOsmGpsMapLayer_Type, &layer))
        return NULL;
    
    osm_gps_map_layer_add(OSM_GPS_MAP(self->obj), OSM_GPS_MAP_LAYER(layer->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_layer_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "layer", NULL };
    PyGObject *layer;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMap.layer_remove", kwlist, &PyOsmGpsMapLayer_Type, &layer))
        return NULL;
    
    ret = osm_gps_map_layer_remove(OSM_GPS_MAP(self->obj), OSM_GPS_MAP_LAYER(layer->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_osm_gps_map_layer_remove_all(PyGObject *self)
{
    
    osm_gps_map_layer_remove_all(OSM_GPS_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_convert_screen_to_geographic(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "pixel_x", "pixel_y", "pt", NULL };
    int pixel_x, pixel_y;
    PyObject *py_pt;
    OsmGpsMapPoint *pt = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"iiO:Osm.GpsMap.convert_screen_to_geographic", kwlist, &pixel_x, &pixel_y, &py_pt))
        return NULL;
    if (pyg_boxed_check(py_pt, OSM_TYPE_GPS_MAP_POINT))
        pt = pyg_boxed_get(py_pt, OsmGpsMapPoint);
    else {
        PyErr_SetString(PyExc_TypeError, "pt should be a OsmGpsMapPoint");
        return NULL;
    }
    
    osm_gps_map_convert_screen_to_geographic(OSM_GPS_MAP(self->obj), pixel_x, pixel_y, pt);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 87 "osmgpsmap.override"
static PyObject *
_wrap_osm_gps_map_convert_geographic_to_screen(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "pt", NULL };
    int pixel_x, pixel_y;
    PyObject *py_pt;
    OsmGpsMapPoint *pt = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Osm.GpsMap.convert_geographic_to_screen", kwlist, &py_pt))
        return NULL;
    if (pyg_boxed_check(py_pt, OSM_TYPE_GPS_MAP_POINT))
        pt = pyg_boxed_get(py_pt, OsmGpsMapPoint);
    else {
        PyErr_SetString(PyExc_TypeError, "pt should be a OsmGpsMapPoint");
        return NULL;
    }

    osm_gps_map_convert_geographic_to_screen(OSM_GPS_MAP(self->obj), pt, &pixel_x, &pixel_y);

    return Py_BuildValue("(ii)", pixel_x, pixel_y);
}
#line 869 "osmgpsmap.c"


static PyObject *
_wrap_osm_gps_map_get_event_location(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "event", NULL };
    GdkEvent *event = NULL;
    PyObject *py_event;
    OsmGpsMapPoint *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Osm.GpsMap.get_event_location", kwlist, &py_event))
        return NULL;
    if (pyg_boxed_check(py_event, GDK_TYPE_EVENT))
        event = pyg_boxed_get(py_event, GdkEvent);
    else {
        PyErr_SetString(PyExc_TypeError, "event should be a GdkEvent");
        return NULL;
    }
    
    ret = osm_gps_map_get_event_location(OSM_GPS_MAP(self->obj), (GdkEventButton *)event);
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(OSM_TYPE_GPS_MAP_POINT, ret, FALSE, TRUE);
}

static PyObject *
_wrap_OsmGpsMap__do_draw_gps_point(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    gpointer klass;
    static char *kwlist[] = { "self", "drawable", NULL };
    PyGObject *self, *drawable;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:Osm.GpsMap.draw_gps_point", kwlist, &PyOsmGpsMap_Type, &self, &PyGdkDrawable_Type, &drawable))
        return NULL;
    klass = g_type_class_ref(pyg_type_from_object(cls));
    if (OSM_GPS_MAP_CLASS(klass)->draw_gps_point)
        OSM_GPS_MAP_CLASS(klass)->draw_gps_point(OSM_GPS_MAP(self->obj), GDK_DRAWABLE(drawable->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "virtual method Osm.GpsMap.draw_gps_point not implemented");
        g_type_class_unref(klass);
        return NULL;
    }
    g_type_class_unref(klass);
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyOsmGpsMap_methods[] = {
    { "add_track", (PyCFunction)_wrap_osm_gps_map_add_track, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "clear_tracks", (PyCFunction)_wrap_osm_gps_map_clear_tracks, METH_NOARGS,
      NULL },
    { "add_image", (PyCFunction)_wrap_osm_gps_map_add_image, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "remove_image", (PyCFunction)_wrap_osm_gps_map_remove_image, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "clear_images", (PyCFunction)_wrap_osm_gps_map_clear_images, METH_NOARGS,
      NULL },
    { "draw_gps", (PyCFunction)_wrap_osm_gps_map_draw_gps, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "clear_gps", (PyCFunction)_wrap_osm_gps_map_clear_gps, METH_NOARGS,
      NULL },
    { "add_layer", (PyCFunction)_wrap_osm_gps_map_add_layer, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_co_ordinates", (PyCFunction)_wrap_osm_gps_map_get_co_ordinates, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "screen_to_geographic", (PyCFunction)_wrap_osm_gps_map_screen_to_geographic, METH_VARARGS,
      NULL },
    { "geographic_to_screen", (PyCFunction)_wrap_osm_gps_map_geographic_to_screen, METH_VARARGS,
      NULL },
    { "set_mapcenter", (PyCFunction)_wrap_osm_gps_map_set_mapcenter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "download_maps", (PyCFunction)_wrap_osm_gps_map_download_maps, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "download_cancel_all", (PyCFunction)_wrap_osm_gps_map_download_cancel_all, METH_NOARGS,
      NULL },
    { "get_bbox", (PyCFunction)_wrap_osm_gps_map_get_bbox, METH_NOARGS,
      NULL },
    { "set_center_and_zoom", (PyCFunction)_wrap_osm_gps_map_set_center_and_zoom, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_center", (PyCFunction)_wrap_osm_gps_map_set_center, METH_VARARGS,
      NULL },
    { "set_zoom", (PyCFunction)_wrap_osm_gps_map_set_zoom, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_zoom_offset", (PyCFunction)_wrap_osm_gps_map_set_zoom_offset, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "zoom_in", (PyCFunction)_wrap_osm_gps_map_zoom_in, METH_NOARGS,
      NULL },
    { "zoom_out", (PyCFunction)_wrap_osm_gps_map_zoom_out, METH_NOARGS,
      NULL },
    { "scroll", (PyCFunction)_wrap_osm_gps_map_scroll, METH_VARARGS,
      NULL },
    { "get_scale", (PyCFunction)_wrap_osm_gps_map_get_scale, METH_NOARGS,
      NULL },
    { "set_keyboard_shortcut", (PyCFunction)_wrap_osm_gps_map_set_keyboard_shortcut, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "track_add", (PyCFunction)_wrap_osm_gps_map_track_add, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "track_remove_all", (PyCFunction)_wrap_osm_gps_map_track_remove_all, METH_NOARGS,
      NULL },
    { "track_remove", (PyCFunction)_wrap_osm_gps_map_track_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "gps_add", (PyCFunction)_wrap_osm_gps_map_gps_add, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "gps_clear", (PyCFunction)_wrap_osm_gps_map_gps_clear, METH_NOARGS,
      NULL },
    { "gps_get_track", (PyCFunction)_wrap_osm_gps_map_gps_get_track, METH_NOARGS,
      NULL },
    { "image_add", (PyCFunction)_wrap_osm_gps_map_image_add, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "image_add_with_alignment", (PyCFunction)_wrap_osm_gps_map_image_add_with_alignment, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "image_remove", (PyCFunction)_wrap_osm_gps_map_image_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "image_remove_all", (PyCFunction)_wrap_osm_gps_map_image_remove_all, METH_NOARGS,
      NULL },
    { "layer_add", (PyCFunction)_wrap_osm_gps_map_layer_add, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "layer_remove", (PyCFunction)_wrap_osm_gps_map_layer_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "layer_remove_all", (PyCFunction)_wrap_osm_gps_map_layer_remove_all, METH_NOARGS,
      NULL },
    { "convert_screen_to_geographic", (PyCFunction)_wrap_osm_gps_map_convert_screen_to_geographic, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "convert_geographic_to_screen", (PyCFunction)_wrap_osm_gps_map_convert_geographic_to_screen, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_event_location", (PyCFunction)_wrap_osm_gps_map_get_event_location, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "do_draw_gps_point", (PyCFunction)_wrap_OsmGpsMap__do_draw_gps_point, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyOsmGpsMap_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "osmgpsmap.GpsMap",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyOsmGpsMap_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_osm_gps_map_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static void
_wrap_OsmGpsMap__proxy_do_draw_gps_point(OsmGpsMap *self, GdkDrawable*drawable)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_drawable = NULL;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    if (drawable)
        py_drawable = pygobject_new((GObject *) drawable);
    else {
        Py_INCREF(Py_None);
        py_drawable = Py_None;
    }
    
    py_args = PyTuple_New(1);
    PyTuple_SET_ITEM(py_args, 0, py_drawable);
    
    py_method = PyObject_GetAttrString(py_self, "do_draw_gps_point");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}

static int
__OsmGpsMap_class_init(gpointer gclass, PyTypeObject *pyclass)
{
    PyObject *o;
    OsmGpsMapClass *klass = OSM_GPS_MAP_CLASS(gclass);
    PyObject *gsignals = PyDict_GetItemString(pyclass->tp_dict, "__gsignals__");

    o = PyObject_GetAttrString((PyObject *) pyclass, "do_draw_gps_point");
    if (o == NULL)
        PyErr_Clear();
    else {
        if (!PyObject_TypeCheck(o, &PyCFunction_Type)
            && !(gsignals && PyDict_GetItemString(gsignals, "draw_gps_point")))
            klass->draw_gps_point = _wrap_OsmGpsMap__proxy_do_draw_gps_point;
        Py_DECREF(o);
    }
    return 0;
}


/* ----------- OsmGpsMapImage ----------- */

 static int
_wrap_osm_gps_map_image_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":osmgpsmap.GpsMapImage.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create osmgpsmap.GpsMapImage object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_osm_gps_map_image_draw(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "drawable", "gc", "rect", NULL };
    PyGObject *drawable, *gc;
    PyObject *py_rect;
    GdkRectangle rect = { 0, 0, 0, 0 };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!O:Osm.GpsMapImage.draw", kwlist, &PyGdkDrawable_Type, &drawable, &PyGdkGC_Type, &gc, &py_rect))
        return NULL;
    if (!pygdk_rectangle_from_pyobject(py_rect, &rect))
        return NULL;
    
    osm_gps_map_image_draw(OSM_GPS_MAP_IMAGE(self->obj), GDK_DRAWABLE(drawable->obj), GDK_GC(gc->obj), &rect);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_image_get_point(PyGObject *self)
{
    const OsmGpsMapPoint *ret;

    
    ret = osm_gps_map_image_get_point(OSM_GPS_MAP_IMAGE(self->obj));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(OSM_TYPE_GPS_MAP_POINT, (OsmGpsMapPoint*) ret, TRUE, TRUE);
}

static const PyMethodDef _PyOsmGpsMapImage_methods[] = {
    { "draw", (PyCFunction)_wrap_osm_gps_map_image_draw, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_point", (PyCFunction)_wrap_osm_gps_map_image_get_point, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapImage_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "osmgpsmap.GpsMapImage",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyOsmGpsMapImage_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_osm_gps_map_image_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- OsmGpsMapOsd ----------- */

static int
_wrap_osm_gps_map_osd_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GType obj_type = pyg_type_from_object((PyObject *) self);
    GParameter params[10];
    PyObject *parsed_args[10] = {NULL, };
    char *arg_names[] = {"osd_x", "osd_y", "dpad_radius", "show_scale", "show_coordinates", "show_crosshair", "show_dpad", "show_zoom", "show_gps_in_dpad", "show_gps_in_zoom", NULL };
    char *prop_names[] = {"osd_x", "osd_y", "dpad_radius", "show_scale", "show_coordinates", "show_crosshair", "show_dpad", "show_zoom", "show_gps_in_dpad", "show_gps_in_zoom", NULL };
    guint nparams, i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OOOOOOOOOO:osmgpsmap.GpsMapOsd.__init__" , arg_names , &parsed_args[0] , &parsed_args[1] , &parsed_args[2] , &parsed_args[3] , &parsed_args[4] , &parsed_args[5] , &parsed_args[6] , &parsed_args[7] , &parsed_args[8] , &parsed_args[9]))
        return -1;

    memset(params, 0, sizeof(GParameter)*10);
    if (!pyg_parse_constructor_args(obj_type, arg_names,
                                    prop_names, params, 
                                    &nparams, parsed_args))
        return -1;
    pygobject_constructv(self, nparams, params);
    for (i = 0; i < nparams; ++i)
        g_value_unset(&params[i].value);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create osmgpsmap.GpsMapOsd object");
        return -1;
    }
    return 0;
}

PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapOsd_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "osmgpsmap.GpsMapOsd",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_osm_gps_map_osd_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- OsmGpsMapTrack ----------- */

 static int
_wrap_osm_gps_map_track_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":osmgpsmap.GpsMapTrack.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create osmgpsmap.GpsMapTrack object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_osm_gps_map_track_add_point(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "point", NULL };
    PyObject *py_point;
    OsmGpsMapPoint *point = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Osm.GpsMapTrack.add_point", kwlist, &py_point))
        return NULL;
    if (pyg_boxed_check(py_point, OSM_TYPE_GPS_MAP_POINT))
        point = pyg_boxed_get(py_point, OsmGpsMapPoint);
    else {
        PyErr_SetString(PyExc_TypeError, "point should be a OsmGpsMapPoint");
        return NULL;
    }
    
    osm_gps_map_track_add_point(OSM_GPS_MAP_TRACK(self->obj), point);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_track_get_color(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "color", NULL };
    PyObject *py_color;
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:Osm.GpsMapTrack.get_color", kwlist, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor");
        return NULL;
    }
    
    osm_gps_map_track_get_color(OSM_GPS_MAP_TRACK(self->obj), color);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyOsmGpsMapTrack_methods[] = {
    { "add_point", (PyCFunction)_wrap_osm_gps_map_track_add_point, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_color", (PyCFunction)_wrap_osm_gps_map_track_get_color, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapTrack_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "osmgpsmap.GpsMapTrack",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyOsmGpsMapTrack_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_osm_gps_map_track_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- OsmGpsMapLayer ----------- */

static PyObject *
_wrap_OsmGpsMapLayer__do_render(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    OsmGpsMapLayerIface *iface;
    static char *kwlist[] = { "self", "map", NULL };
    PyGObject *self, *map;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:Osm.GpsMapLayer.render", kwlist, &PyOsmGpsMapLayer_Type, &self, &PyOsmGpsMap_Type, &map))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), OSM_TYPE_GPS_MAP_LAYER);
    if (iface->render)
        iface->render(OSM_GPS_MAP_LAYER(self->obj), OSM_GPS_MAP(map->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method Osm.GpsMapLayer.render not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_OsmGpsMapLayer__do_draw(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    OsmGpsMapLayerIface *iface;
    static char *kwlist[] = { "self", "map", "drawable", NULL };
    PyGObject *self, *map, *drawable;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!O!:Osm.GpsMapLayer.draw", kwlist, &PyOsmGpsMapLayer_Type, &self, &PyOsmGpsMap_Type, &map, &PyGdkDrawable_Type, &drawable))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), OSM_TYPE_GPS_MAP_LAYER);
    if (iface->draw)
        iface->draw(OSM_GPS_MAP_LAYER(self->obj), OSM_GPS_MAP(map->obj), GDK_DRAWABLE(drawable->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method Osm.GpsMapLayer.draw not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_OsmGpsMapLayer__do_busy(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    OsmGpsMapLayerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:Osm.GpsMapLayer.busy", kwlist, &PyOsmGpsMapLayer_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), OSM_TYPE_GPS_MAP_LAYER);
    if (iface->busy)
        ret = iface->busy(OSM_GPS_MAP_LAYER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method Osm.GpsMapLayer.busy not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_OsmGpsMapLayer__do_button_press(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    OsmGpsMapLayerIface *iface;
    static char *kwlist[] = { "self", "map", "event", NULL };
    PyGObject *self, *map;
    GdkEvent *event = NULL;
    int ret;
    PyObject *py_event;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!O:Osm.GpsMapLayer.button_press", kwlist, &PyOsmGpsMapLayer_Type, &self, &PyOsmGpsMap_Type, &map, &py_event))
        return NULL;
    if (pyg_boxed_check(py_event, GDK_TYPE_EVENT))
        event = pyg_boxed_get(py_event, GdkEvent);
    else {
        PyErr_SetString(PyExc_TypeError, "event should be a GdkEvent");
        return NULL;
    }
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), OSM_TYPE_GPS_MAP_LAYER);
    if (iface->button_press)
        ret = iface->button_press(OSM_GPS_MAP_LAYER(self->obj), OSM_GPS_MAP(map->obj), (GdkEventButton *)event);
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method Osm.GpsMapLayer.button_press not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyOsmGpsMapLayer_methods[] = {
    { "do_render", (PyCFunction)_wrap_OsmGpsMapLayer__do_render, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_draw", (PyCFunction)_wrap_OsmGpsMapLayer__do_draw, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_busy", (PyCFunction)_wrap_OsmGpsMapLayer__do_busy, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_button_press", (PyCFunction)_wrap_OsmGpsMapLayer__do_button_press, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyOsmGpsMapLayer_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "osmgpsmap.GpsMapLayer",                   /* tp_name */
    sizeof(PyObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyOsmGpsMapLayer_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static void
_wrap_OsmGpsMapLayer__proxy_do_render(OsmGpsMapLayer *self, OsmGpsMap*map)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_map = NULL;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    if (map)
        py_map = pygobject_new((GObject *) map);
    else {
        Py_INCREF(Py_None);
        py_map = Py_None;
    }
    
    py_args = PyTuple_New(1);
    PyTuple_SET_ITEM(py_args, 0, py_map);
    
    py_method = PyObject_GetAttrString(py_self, "do_render");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_OsmGpsMapLayer__proxy_do_draw(OsmGpsMapLayer *self, OsmGpsMap*map, GdkDrawable*drawable)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_map = NULL;
    PyObject *py_drawable = NULL;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    if (map)
        py_map = pygobject_new((GObject *) map);
    else {
        Py_INCREF(Py_None);
        py_map = Py_None;
    }
    if (drawable)
        py_drawable = pygobject_new((GObject *) drawable);
    else {
        Py_INCREF(Py_None);
        py_drawable = Py_None;
    }
    
    py_args = PyTuple_New(2);
    PyTuple_SET_ITEM(py_args, 0, py_map);
    PyTuple_SET_ITEM(py_args, 1, py_drawable);
    
    py_method = PyObject_GetAttrString(py_self, "do_draw");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static gboolean
_wrap_OsmGpsMapLayer__proxy_do_busy(OsmGpsMapLayer *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_busy");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gboolean
_wrap_OsmGpsMapLayer__proxy_do_button_press(OsmGpsMapLayer *self, OsmGpsMap*map, GdkEventButton*event)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_map = NULL;
    PyObject *py_event;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    if (map)
        py_map = pygobject_new((GObject *) map);
    else {
        Py_INCREF(Py_None);
        py_map = Py_None;
    }
    py_event = pyg_boxed_new(GDK_TYPE_EVENT, event, FALSE, FALSE);
    
    py_args = PyTuple_New(2);
    PyTuple_SET_ITEM(py_args, 0, py_map);
    PyTuple_SET_ITEM(py_args, 1, py_event);
    
    py_method = PyObject_GetAttrString(py_self, "do_button_press");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}

static void
__OsmGpsMapLayer__interface_init(OsmGpsMapLayerIface *iface, PyTypeObject *pytype)
{
    OsmGpsMapLayerIface *parent_iface = g_type_interface_peek_parent(iface);
    PyObject *py_method;

    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_render") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->render = _wrap_OsmGpsMapLayer__proxy_do_render;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->render = parent_iface->render;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_draw") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->draw = _wrap_OsmGpsMapLayer__proxy_do_draw;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->draw = parent_iface->draw;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_busy") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->busy = _wrap_OsmGpsMapLayer__proxy_do_busy;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->busy = parent_iface->busy;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_button_press") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->button_press = _wrap_OsmGpsMapLayer__proxy_do_button_press;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->button_press = parent_iface->button_press;
        }
    Py_XDECREF(py_method);
    }
}


static const GInterfaceInfo __OsmGpsMapLayer__iinfo = {
    (GInterfaceInitFunc) __OsmGpsMapLayer__interface_init,
    NULL,
    NULL
};


/* ----------- functions ----------- */

static PyObject *
_wrap_osm_gps_map_get_default_cache_directory(PyObject *self)
{
    gchar *ret;

    
    ret = osm_gps_map_get_default_cache_directory();
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_point_new_degrees(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "lat", "lon", NULL };
    double lat, lon;
    OsmGpsMapPoint *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dd:point_new_degrees", kwlist, &lat, &lon))
        return NULL;
    
    ret = osm_gps_map_point_new_degrees(lat, lon);
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(OSM_TYPE_GPS_MAP_POINT, ret, TRUE, TRUE);
}

static PyObject *
_wrap_osm_gps_map_point_new_radians(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "rlat", "rlon", NULL };
    double rlat, rlon;
    OsmGpsMapPoint *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dd:point_new_radians", kwlist, &rlat, &rlon))
        return NULL;
    
    ret = osm_gps_map_point_new_radians(rlat, rlon);
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(OSM_TYPE_GPS_MAP_POINT, ret, TRUE, TRUE);
}

static PyObject *
_wrap_osm_gps_map_source_get_friendly_name(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "source", NULL };
    int source;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:source_get_friendly_name", kwlist, &source))
        return NULL;
    
    ret = osm_gps_map_source_get_friendly_name(source);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_source_get_repo_uri(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "source", NULL };
    int source;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:source_get_repo_uri", kwlist, &source))
        return NULL;
    
    ret = osm_gps_map_source_get_repo_uri(source);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_source_get_image_format(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "source", NULL };
    int source;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:source_get_image_format", kwlist, &source))
        return NULL;
    
    ret = osm_gps_map_source_get_image_format(source);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_osm_gps_map_source_get_min_zoom(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "source", NULL };
    int source, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:source_get_min_zoom", kwlist, &source))
        return NULL;
    
    ret = osm_gps_map_source_get_min_zoom(source);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_osm_gps_map_source_get_max_zoom(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "source", NULL };
    int source, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:source_get_max_zoom", kwlist, &source))
        return NULL;
    
    ret = osm_gps_map_source_get_max_zoom(source);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_osm_gps_map_source_is_valid(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "source", NULL };
    int source, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:source_is_valid", kwlist, &source))
        return NULL;
    
    ret = osm_gps_map_source_is_valid(source);
    
    return PyBool_FromLong(ret);

}

const PyMethodDef pyosmgpsmap_functions[] = {
    { "get_default_cache_directory", (PyCFunction)_wrap_osm_gps_map_get_default_cache_directory, METH_NOARGS,
      NULL },
    { "point_new_degrees", (PyCFunction)_wrap_osm_gps_map_point_new_degrees, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "point_new_radians", (PyCFunction)_wrap_osm_gps_map_point_new_radians, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "source_get_friendly_name", (PyCFunction)_wrap_osm_gps_map_source_get_friendly_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "source_get_repo_uri", (PyCFunction)_wrap_osm_gps_map_source_get_repo_uri, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "source_get_image_format", (PyCFunction)_wrap_osm_gps_map_source_get_image_format, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "source_get_min_zoom", (PyCFunction)_wrap_osm_gps_map_source_get_min_zoom, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "source_get_max_zoom", (PyCFunction)_wrap_osm_gps_map_source_get_max_zoom, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "source_is_valid", (PyCFunction)_wrap_osm_gps_map_source_is_valid, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};


/* ----------- enums and flags ----------- */

void
pyosmgpsmap_add_constants(PyObject *module, const gchar *strip_prefix)
{
#ifdef VERSION
    PyModule_AddStringConstant(module, "__version__", VERSION);
#endif
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_NULL", strip_prefix), OSM_GPS_MAP_SOURCE_NULL);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_OPENSTREETMAP", strip_prefix), OSM_GPS_MAP_SOURCE_OPENSTREETMAP);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_OPENSTREETMAP_RENDERER", strip_prefix), OSM_GPS_MAP_SOURCE_OPENSTREETMAP_RENDERER);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_OPENAERIALMAP", strip_prefix), OSM_GPS_MAP_SOURCE_OPENAERIALMAP);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_MAPS_FOR_FREE", strip_prefix), OSM_GPS_MAP_SOURCE_MAPS_FOR_FREE);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_GOOGLE_STREET", strip_prefix), OSM_GPS_MAP_SOURCE_GOOGLE_STREET);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_GOOGLE_SATELLITE", strip_prefix), OSM_GPS_MAP_SOURCE_GOOGLE_SATELLITE);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_GOOGLE_HYBRID", strip_prefix), OSM_GPS_MAP_SOURCE_GOOGLE_HYBRID);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_VIRTUAL_EARTH_STREET", strip_prefix), OSM_GPS_MAP_SOURCE_VIRTUAL_EARTH_STREET);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_VIRTUAL_EARTH_SATELLITE", strip_prefix), OSM_GPS_MAP_SOURCE_VIRTUAL_EARTH_SATELLITE);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_VIRTUAL_EARTH_HYBRID", strip_prefix), OSM_GPS_MAP_SOURCE_VIRTUAL_EARTH_HYBRID);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_YAHOO_STREET", strip_prefix), OSM_GPS_MAP_SOURCE_YAHOO_STREET);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_YAHOO_SATELLITE", strip_prefix), OSM_GPS_MAP_SOURCE_YAHOO_SATELLITE);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_SOURCE_YAHOO_HYBRID", strip_prefix), OSM_GPS_MAP_SOURCE_YAHOO_HYBRID);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_FULLSCREEN", strip_prefix), OSM_GPS_MAP_KEY_FULLSCREEN);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_ZOOMIN", strip_prefix), OSM_GPS_MAP_KEY_ZOOMIN);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_ZOOMOUT", strip_prefix), OSM_GPS_MAP_KEY_ZOOMOUT);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_UP", strip_prefix), OSM_GPS_MAP_KEY_UP);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_DOWN", strip_prefix), OSM_GPS_MAP_KEY_DOWN);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_LEFT", strip_prefix), OSM_GPS_MAP_KEY_LEFT);
    PyModule_AddIntConstant(module, (char *) pyg_constant_strip_prefix("OSM_GPS_MAP_KEY_RIGHT", strip_prefix), OSM_GPS_MAP_KEY_RIGHT);

  if (PyErr_Occurred())
    PyErr_Print();
}

/* initialise stuff extension classes */
void
pyosmgpsmap_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        _PyGObject_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return ;
    }
    if ((module = PyImport_ImportModule("gtk")) != NULL) {
        _PyGtkDrawingArea_Type = (PyTypeObject *)PyObject_GetAttrString(module, "DrawingArea");
        if (_PyGtkDrawingArea_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name DrawingArea from gtk");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gtk");
        return ;
    }
    if ((module = PyImport_ImportModule("gtk.gdk")) != NULL) {
        _PyGdkPixbuf_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Pixbuf");
        if (_PyGdkPixbuf_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Pixbuf from gtk.gdk");
            return ;
        }
        _PyGdkDrawable_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Drawable");
        if (_PyGdkDrawable_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Drawable from gtk.gdk");
            return ;
        }
        _PyGdkGC_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GC");
        if (_PyGdkGC_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GC from gtk.gdk");
            return ;
        }
        _PyGtkRectangle_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Rectangle");
        if (_PyGtkRectangle_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Rectangle from gtk.gdk");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gtk.gdk");
        return ;
    }


#line 2189 "osmgpsmap.c"
    pyg_register_boxed(d, "Point", OSM_TYPE_GPS_MAP_POINT, &PyOsmGpsMapPoint_Type);
    pyg_register_interface(d, "GpsMapLayer", OSM_TYPE_GPS_MAP_LAYER, &PyOsmGpsMapLayer_Type);
    pyg_register_interface_info(OSM_TYPE_GPS_MAP_LAYER, &__OsmGpsMapLayer__iinfo);
    pygobject_register_class(d, "OsmGpsMap", OSM_TYPE_GPS_MAP, &PyOsmGpsMap_Type, Py_BuildValue("(O)", &PyGtkDrawingArea_Type));
    pyg_set_object_has_new_constructor(OSM_TYPE_GPS_MAP);
    pyg_register_class_init(OSM_TYPE_GPS_MAP, __OsmGpsMap_class_init);
    pygobject_register_class(d, "OsmGpsMapImage", OSM_TYPE_GPS_MAP_IMAGE, &PyOsmGpsMapImage_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(OSM_TYPE_GPS_MAP_IMAGE);
    pygobject_register_class(d, "OsmGpsMapOsd", OSM_TYPE_GPS_MAP_OSD, &PyOsmGpsMapOsd_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(OSM_TYPE_GPS_MAP_OSD);
    pygobject_register_class(d, "OsmGpsMapTrack", OSM_TYPE_GPS_MAP_TRACK, &PyOsmGpsMapTrack_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(OSM_TYPE_GPS_MAP_TRACK);
}
