# Changes in Traitlets

<!-- <START NEW CHANGELOG ENTRY> -->

## 5.14.2

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.14.1...2d0fb91f39a71c5528860e23bf9c2138e441b319))

### Maintenance and upkeep improvements

- Update Release Scripts [#900](https://github.com/ipython/traitlets/pull/900) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#897](https://github.com/ipython/traitlets/pull/897) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Bump the actions group with 1 update [#896](https://github.com/ipython/traitlets/pull/896) ([@dependabot](https://github.com/dependabot))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2024-01-02&to=2024-03-12&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2024-01-02..2024-03-12&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Adependabot+updated%3A2024-01-02..2024-03-12&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2024-01-02..2024-03-12&type=Issues)

<!-- <END NEW CHANGELOG ENTRY> -->

## 5.14.1

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.14.0...a1108c92013f9da56a9dccb79f7a5453ffe8d1db))

### Bugs fixed

- FIX: map - to _ for environment variable prefix. [#895](https://github.com/ipython/traitlets/pull/895) ([@Carreau](https://github.com/Carreau))

### Maintenance and upkeep improvements

- chore: update pre-commit hooks [#894](https://github.com/ipython/traitlets/pull/894) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Update ruff config [#893](https://github.com/ipython/traitlets/pull/893) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-11-27&to=2024-01-02&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-11-27..2024-01-02&type=Issues) | [@Carreau](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3ACarreau+updated%3A2023-11-27..2024-01-02&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2023-11-27..2024-01-02&type=Issues)

## 5.14.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.13.0...4d7504601b9db9eb6f31dfc102b9c469c8517496))

### Enhancements made

- Add option to load  traitlets values from environment. [#856](https://github.com/ipython/traitlets/pull/856) ([@Carreau](https://github.com/Carreau))

### Maintenance and upkeep improvements

- Update types for mypy 1.7 [#892](https://github.com/ipython/traitlets/pull/892) ([@blink1073](https://github.com/blink1073))
- chore: update pre-commit hooks [#890](https://github.com/ipython/traitlets/pull/890) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Clean up lint handling [#888](https://github.com/ipython/traitlets/pull/888) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-10-30&to=2023-11-27&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-10-30..2023-11-27&type=Issues) | [@Carreau](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3ACarreau+updated%3A2023-10-30..2023-11-27&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2023-10-30..2023-11-27&type=Issues)

## 5.13.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.12.0...dacbf9b03ebecbd09604ab2fa41e088e3f60b403))

### Bugs fixed

- Use passed-in `info` argument for `TraitType.error()` [#884](https://github.com/ipython/traitlets/pull/884) ([@kylebarron](https://github.com/kylebarron))

### Maintenance and upkeep improvements

- Improve generics handling [#886](https://github.com/ipython/traitlets/pull/886) ([@blink1073](https://github.com/blink1073))
- Finish Strict Typing [#885](https://github.com/ipython/traitlets/pull/885) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-10-25&to=2023-10-30&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-10-25..2023-10-30&type=Issues) | [@kylebarron](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Akylebarron+updated%3A2023-10-25..2023-10-30&type=Issues)

## 5.12.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.11.2...b018581f0acd75844bbd7584e233c3ab3126501b))

### Enhancements made

- Pass \*\*kwds in MetaHasDescriptors __new__ and __init__ [#881](https://github.com/ipython/traitlets/pull/881) ([@fleming79](https://github.com/fleming79))

### Maintenance and upkeep improvements

- Adopt sp-repo-review [#883](https://github.com/ipython/traitlets/pull/883) ([@blink1073](https://github.com/blink1073))
- Cleanup after remove Python 2 support [#882](https://github.com/ipython/traitlets/pull/882) ([@shadchin](https://github.com/shadchin))
- Add more project URLs, trove classifiers [#879](https://github.com/ipython/traitlets/pull/879) ([@bollwyvl](https://github.com/bollwyvl))

### Documentation improvements

- Fix docs version [#880](https://github.com/ipython/traitlets/pull/880) ([@bollwyvl](https://github.com/bollwyvl))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-10-03&to=2023-10-24&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-10-03..2023-10-24&type=Issues) | [@bollwyvl](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Abollwyvl+updated%3A2023-10-03..2023-10-24&type=Issues) | [@fleming79](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Afleming79+updated%3A2023-10-03..2023-10-24&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2023-10-03..2023-10-24&type=Issues) | [@shadchin](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ashadchin+updated%3A2023-10-03..2023-10-24&type=Issues)

## 5.11.2

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.11.1...e238765a0ba28fc68318cff75e852958d5c65c93))

### Maintenance and upkeep improvements

- More typing cleanup [#877](https://github.com/ipython/traitlets/pull/877) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-10-03&to=2023-10-03&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-10-03..2023-10-03&type=Issues)

## 5.11.1

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.11.0...292a699ad1a3a3ece760a8335cae73927cccd711))

### Maintenance and upkeep improvements

- Typing fixups [#875](https://github.com/ipython/traitlets/pull/875) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-10-03&to=2023-10-03&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-10-03..2023-10-03&type=Issues)

## 5.11.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.10.1...24a24508260d501abd6bc8b42b59163c6c07d8c4))

### Maintenance and upkeep improvements

- More Typing Adoption [#873](https://github.com/ipython/traitlets/pull/873) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-09-26&to=2023-10-03&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-09-26..2023-10-03&type=Issues)

## 5.10.1

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.10.0...c0a3afdb2dcb28bd7ade6dd730604df8f3fbfc78))

### Maintenance and upkeep improvements

- Typing upgrades [#868](https://github.com/ipython/traitlets/pull/868) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-09-14&to=2023-09-26&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-09-14..2023-09-26&type=Issues)

## 5.10.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.9.0...6588680dc69be75676ca3835b4061b1784232600))

### Enhancements made

- Added type hints to HasTraits.observe() and friends. (#834 [#834](https://github.com/ipython/traitlets/pull/834) ([@scholer](https://github.com/scholer))
- feat: trait typing [#818](https://github.com/ipython/traitlets/pull/818) ([@maartenbreddels](https://github.com/maartenbreddels))

### Maintenance and upkeep improvements

- Fix mypy deps and support Python 3.8-3.12 [#862](https://github.com/ipython/traitlets/pull/862) ([@blink1073](https://github.com/blink1073))
- Update pytest requirement from \<7.2,>=7.0 to >=7.0,\<7.5 [#861](https://github.com/ipython/traitlets/pull/861) ([@dependabot](https://github.com/dependabot))
- Bump actions/checkout from 3 to 4 [#860](https://github.com/ipython/traitlets/pull/860) ([@dependabot](https://github.com/dependabot))
- Fix typing [#848](https://github.com/ipython/traitlets/pull/848) ([@blink1073](https://github.com/blink1073))
- Update docs config [#843](https://github.com/ipython/traitlets/pull/843) ([@blink1073](https://github.com/blink1073))
- Use local coverage [#842](https://github.com/ipython/traitlets/pull/842) ([@blink1073](https://github.com/blink1073))
- Adjust argcomplete typings [#839](https://github.com/ipython/traitlets/pull/839) ([@blink1073](https://github.com/blink1073))
- Better warnings [#838](https://github.com/ipython/traitlets/pull/838) ([@NickCrews](https://github.com/NickCrews))
- Update typings (#836 [#836](https://github.com/ipython/traitlets/pull/836) ([@blink1073](https://github.com/blink1073))

### Documentation improvements

- rename `MyClass` to `School` [#858](https://github.com/ipython/traitlets/pull/858) ([@metaperl](https://github.com/metaperl))
- Even though returning a value from a validation method is ideal, by no means is `proposal['value']` the only thing that can be returned [#855](https://github.com/ipython/traitlets/pull/855) ([@metaperl](https://github.com/metaperl))
- Document help parameter of TraitType.__init__(). [#847](https://github.com/ipython/traitlets/pull/847) ([@metaperl](https://github.com/metaperl))

### Other merged PRs

- Clean up license (#832)Co-authored-by: pre-commit-ci\[bot\] \<66853113+pre-commit-ci\[bot\]@users.noreply.github.com> [#832](https://github.com/ipython/traitlets/pull/832) ([@dcsaba89](https://github.com/dcsaba89))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-01-30&to=2023-09-14&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-01-30..2023-09-14&type=Issues) | [@dcsaba89](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Adcsaba89+updated%3A2023-01-30..2023-09-14&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Adependabot+updated%3A2023-01-30..2023-09-14&type=Issues) | [@maartenbreddels](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Amaartenbreddels+updated%3A2023-01-30..2023-09-14&type=Issues) | [@metaperl](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ametaperl+updated%3A2023-01-30..2023-09-14&type=Issues) | [@NickCrews](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3ANickCrews+updated%3A2023-01-30..2023-09-14&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2023-01-30..2023-09-14&type=Issues) | [@rmorshea](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Armorshea+updated%3A2023-01-30..2023-09-14&type=Issues) | [@saulshanabrook](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Asaulshanabrook+updated%3A2023-01-30..2023-09-14&type=Issues) | [@scholer](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ascholer+updated%3A2023-01-30..2023-09-14&type=Issues)

## 5.9.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.8.1...c11a4d942b08df5c19be88b6cc81dfa8302fef9b))

### Enhancements made

- Polishing argcomplete support [#829](https://github.com/ipython/traitlets/pull/829) ([@azjps](https://github.com/azjps))

### Maintenance and upkeep improvements

- Test that name and description can be set via constructor. [#826](https://github.com/ipython/traitlets/pull/826) ([@Carreau](https://github.com/Carreau))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2023-01-09&to=2023-01-30&type=c))

[@azjps](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Aazjps+updated%3A2023-01-09..2023-01-30&type=Issues) | [@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2023-01-09..2023-01-30&type=Issues) | [@Carreau](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3ACarreau+updated%3A2023-01-09..2023-01-30&type=Issues)

## 5.8.1

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.8.0...18814204c7e7987851cc1836a36863b4fab60165))

### Bugs fixed

- fix: mro_trait can be unbound when the class is not in mro [#824](https://github.com/ipython/traitlets/pull/824) ([@maartenbreddels](https://github.com/maartenbreddels))

### Maintenance and upkeep improvements

### Documentation improvements

- Add more api docs [#821](https://github.com/ipython/traitlets/pull/821) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2022-12-19&to=2023-01-09&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2022-12-19..2023-01-09&type=Issues) | [@maartenbreddels](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Amaartenbreddels+updated%3A2022-12-19..2023-01-09&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2022-12-19..2023-01-09&type=Issues) | [@rmorshea](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Armorshea+updated%3A2022-12-19..2023-01-09&type=Issues)

## 5.8.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.7.1...47e652f96aff54d1aa3b19337c9c8d80fe0fd4c4))

### Enhancements made

-Shell command-line tab-completion via `argcomplete` [#811](https://github.com/ipython/traitlets/pull/811) ([@azjps](https://github.com/azjps))

- Define `trait.__doc__` = `trait.help` for better API Docs [#816](https://github.com/ipython/traitlets/pull/816) ([@minrk](https://github.com/minrk))

### Maintenance and upkeep improvements

- Expose more attributes for typing [#817](https://github.com/ipython/traitlets/pull/817) ([@blink1073](https://github.com/blink1073))
- Fix lint [#814](https://github.com/ipython/traitlets/pull/814) ([@blink1073](https://github.com/blink1073))

### Documentation improvements

- Additional `Application` examples and docs  [#811](https://github.com/ipython/traitlets/pull/811) ([@azjps](https://github.com/azjps))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2022-12-12&to=2022-12-19&type=c))

[@azjps](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Aazjps+updated%3A2022-12-12..2022-12-19&type=Issues) | [@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2022-12-12..2022-12-19&type=Issues) | [@minrk](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Aminrk+updated%3A2022-12-12..2022-12-19&type=Issues)

## 5.7.1

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.7.0...aa0d38bf02d34a6df788477da30eac6e58ffbda5))

### Bugs fixed

- fix: some descriptors raise AttributeError [#812](https://github.com/ipython/traitlets/pull/812) ([@maartenbreddels](https://github.com/maartenbreddels))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2022-12-08&to=2022-12-12&type=c))

[@maartenbreddels](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Amaartenbreddels+updated%3A2022-12-08..2022-12-12&type=Issues)

## 5.7.0

([Full Changelog](https://github.com/ipython/traitlets/compare/v5.6.0...f07afea52cf6314bc20571c52409ff6cb115a709))

### Enhancements made

- Performance: decrease runtime overhead for constructing HasTraits (up to 20x faster) [#777](https://github.com/ipython/traitlets/pull/777) ([@maartenbreddels](https://github.com/maartenbreddels))

### Maintenance and upkeep improvements

- Minor fixes for Application.aliases [#810](https://github.com/ipython/traitlets/pull/810) ([@azjps](https://github.com/azjps))
- Adopt ruff and address lint [#809](https://github.com/ipython/traitlets/pull/809) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2022-11-29&to=2022-12-08&type=c))

[@azjps](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Aazjps+updated%3A2022-11-29..2022-12-08&type=Issues) | [@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2022-11-29..2022-12-08&type=Issues) | [@maartenbreddels](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Amaartenbreddels+updated%3A2022-11-29..2022-12-08&type=Issues) | [@naterush](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Anaterush+updated%3A2022-11-29..2022-12-08&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2022-11-29..2022-12-08&type=Issues)

## 5.6.0

([Full Changelog](https://github.com/ipython/traitlets/compare/5.5.0...2c5188a3562f03c0703315b21df41ca7ace23dd3))

### Maintenance and upkeep improvements

- Adopt jupyter releaser [#806](https://github.com/ipython/traitlets/pull/806) ([@blink1073](https://github.com/blink1073))
- Use base setup dependency type [#805](https://github.com/ipython/traitlets/pull/805) ([@blink1073](https://github.com/blink1073))
- More CI Cleanup [#803](https://github.com/ipython/traitlets/pull/803) ([@blink1073](https://github.com/blink1073))
- More maintenance cleanup [#802](https://github.com/ipython/traitlets/pull/802) ([@blink1073](https://github.com/blink1073))
- Add project description [#801](https://github.com/ipython/traitlets/pull/801) ([@blink1073](https://github.com/blink1073))
- Bump actions/setup-python from 2 to 4 [#798](https://github.com/ipython/traitlets/pull/798) ([@dependabot](https://github.com/dependabot))
- Bump actions/checkout from 2 to 3 [#797](https://github.com/ipython/traitlets/pull/797) ([@dependabot](https://github.com/dependabot))
- Bump pre-commit/action from 2.0.0 to 3.0.0 [#796](https://github.com/ipython/traitlets/pull/796) ([@dependabot](https://github.com/dependabot))
- Bump actions/upload-artifact from 2 to 3 [#795](https://github.com/ipython/traitlets/pull/795) ([@dependabot](https://github.com/dependabot))
- Add dependabot [#794](https://github.com/ipython/traitlets/pull/794) ([@blink1073](https://github.com/blink1073))
- Add more typings [#791](https://github.com/ipython/traitlets/pull/791) ([@blink1073](https://github.com/blink1073))
- Format changelog [#789](https://github.com/ipython/traitlets/pull/789) ([@blink1073](https://github.com/blink1073))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/ipython/traitlets/graphs/contributors?from=2022-10-18&to=2022-11-29&type=c))

[@blink1073](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Ablink1073+updated%3A2022-10-18..2022-11-29&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Adependabot+updated%3A2022-10-18..2022-11-29&type=Issues) | [@maartenbreddels](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Amaartenbreddels+updated%3A2022-10-18..2022-11-29&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Apre-commit-ci+updated%3A2022-10-18..2022-11-29&type=Issues) | [@rmorshea](https://github.com/search?q=repo%3Aipython%2Ftraitlets+involves%3Armorshea+updated%3A2022-10-18..2022-11-29&type=Issues)

## 5.5.0

- Clean up application typing
- Update tests and docs to use non-deprecated functions
- Clean up version handling
- Prep for jupyter releaser
- Format the changelog

## 5.4.0

- Fix version_info
- Make generated config files more lintable
- Fix union trait from string
- Add security.md, and tidelift badge

## 5.3.0

- Fix traitlet name in docstring
- Re-support multiple-alias key for ArgParseConfigLoader

## 5.2.2

- Make `traitlets.__all__` explicit and validate in test.
- Fix `KeyError` in `Application.get_default_logging_config`.

## 5.2.1

- logging: Don't attempt to close handlers unless they have been
  opened. Fixes `ValueError: Unable to configure formatter 'console'` traceback.

## 5.2.0

Traitlets 5.2 brings a couple of updates and changes to traitlets, and
is recommended for all users. What follows is a non-exhaustive list of
changes:

- Application: add logging_config trait.
- Disambiguate the use of the term value in the example.
- Add mypy typing support.
- DOC: Add log example.
- Internal cleanup: linters, autoformatters, CI.

## 5.1.1

5.1.1 fixes compatibility issues with Python 3.10 (rc2).

## 5.1.0

Traitlets 5.1 brings a couple of updates and changes to traitlets, and
is recommended for all users. What follow is a non-exhaustive list of
changes:

- Removal of the `ipython_genutils` dependency, this should remove
  any direct and indirect reliance on `nose` and prepare traitlets
  5.1 for Python 3.10 and above compatibility, some test suite
  changes also accommodate Python 3.10 changes. If you package
  traitlets downstream, make sure to remove this dependency.
- Removal of `ipython_genutils` may have change the default encoding
  detected for the command line argument parsing when not utf-8. We
  expect this to affect a small portion of older windows version. If
  you encounter issue let us know.
- Stop recommendation of `CUnicode` in some circumstances as it's
  deprecated.
- Our test suite is now using GitHub action instead of travis CI. If
  you are packaging downstream using the git repository, you may
  have to exclude the `.github` folder now, and can remove exclusion
  of
- It fixes a parsing issue for list of one single element on the
  CLI.
- We reserve the right to remove official support for Python 3.7 in
  subsequent minor revisions.

## 5.0.5

- Support deprecated literals for sets, tuples on the command-line:
  `nbconvert --TagRemovePreprocessor.remove_cell_tags='{"tag"}'`
- Fix `from_string_list` for Tuples in general
- Fix support for `List(default_value=None, allow_none=True)` and
  other Container traits
- Fix help output for nested aliases and tuple traits

## 5.0.4

- Support deprecated use of byte-literals for bytes on the
  command-line: `ipython kernel --Session.key="b'abc'"`. The
  `b` prefix is no longer needed in traitlets 5.0, but is
  supported for backward-compatibility
- Improve output of configuration errors, especially when help output
  would make it hard to find the helpful error message

## 5.0.3

- Fix regression in handling `--opt=None` on the CLI for
  configurable traits with `allow_none=True`

## 5.0.2

- Fix casting bytes to unicode

## 5.0.0

(This is an in-progress changelog, please let us know if something is
missing/or could be phrased better)

Traitlets 5.0 is a new version of traitlets that accumulate changes over
a period of more close to four years; A number of internal refactoring
made the internal code structure cleaner and simpler, and greatly
improved the diagnostic error messages as well has help and
documentation generation.

We expect no code change needed for any consumer of the Python API
(ipywidgets, and alike), though CLI argument parsing have seen a
complete rewrite, so if you have an application that does use the
parsing logic of traitlets you may see changes in behavior, and now have
access to more features. There was also a cleanup of what was considered
a part of the public API, certain previously exposed utility functions
and types are no longer available. Please see an exhaustive list below.

::: seealso
`commandline` docs for details about
command-line parsing and the changes in 5.0.

Please [let us know](https://github.com/ipython/traitlets/issues) if you
find issues with the new command-line parsing changes.
:::

We also want to thanks in particular a number of regular contributor
through the years that have patiently waited for their often large
contribution to be available, if **rough** order of number of
contribution:

- Ryan Morshead - @rmorshea - For serving as a maintainer of the
  4.x branch and providing a number of bug fix through the years.
- Kostis Anagnostopoulos - @ankostis - Who push a major refactor of
  the CLI paring, as well as many help-generating function.
- Benjamin Ragan-Kelley -- @minrk -- for reviewing and help fixing
  edge case in most of the above
- Matthias Bussonnier -- @carreau
- Sylvain Corlay
- Francisco de la Peña
- Martin Renou
- Yves Delley
- Thomas Kluyver
- hristian Clauss
- maartenbreddels
- Aliaksei Urbanski
- Kevin Bates
- David Brochart

As well as many of the passer-by, and less frequent contributors:

- Tim Paine
- Jake VanderPlas
- Frédéric Chapoton
- Dan Allan
- Adam Chainz
- William Krinsman
- Travis DePrato
- Todd
- Thomas Aarholt
- Lumir Balhar
- Leonardo Uieda
- Leo Gallucci
- Kyle Kelley
- Jeroen Demeyer
- Jason Grout
- Hans Moritz Günther
- FredInChina
- Conner Cowling
- Carol Willing
- Albert Zeyer

Major changes are:

- Removal of Python 2 support,
- Removal of Python 3.0-3.6 support
- we now follow NEP 29, and are thus Python 3.7+ only.
- remove `six` as a dependency
- remove `funcsig` as a dependency.
- no longer exposes the following functions / types:
  - ClassTypes
  - DefaultHandler
  - EventHandler
  - ForwardDeclaredMixin
  - ObserveHandler
  - SequenceTypes
  - ValidateHandler
  - add_article
  - class_of
  - getargspec
  - getmembers
  - is_trait
  - isidentifier
  - repr_type

Here is a list of most Pull requests that went into 5.0 and a short
description.

- [#362](https://github.com/ipython/traitlets/pull/362) , [#361](https://github.com/ipython/traitlets/pull/361) introduces:
  - help for aliases , aliases dict values can now be a tuple with
    ('target', 'help string')
  - subcommands can now be arbitrary callable and do not need to be
    subclass of `Application`
- [#306](https://github.com/ipython/traitlets/pull/306) Add compatibility with the
  `trait` package for Dictionaries and add the `key_trait` parameters
  allowing to restrict the type of the key of a mapping. The
  constructor parameters `trait` and `traits` are renamed to
  `value_trait` and `per_key_traits`.
- [#319](https://github.com/ipython/traitlets/pull/319) adds ability to introduce
  both shot and long version of aliases, allowing for short and long
  options `-` and `--`.
- [#322](https://github.com/ipython/traitlets/pull/322) rewrite command line argument
  parsing to use argparse, and allow more flexibility in assigning
  literals without quoting.
- [#332](https://github.com/ipython/traitlets/pull/332) Make it easier to redefined
  default values of parents classes.
- [#333](https://github.com/ipython/traitlets/pull/333) introduces a
  `Callable` trait.
- [#340](https://github.com/ipython/traitlets/pull/340) Old way of passing containers
  in the command line is now deprecated, and will emit warning on the
  command line.
- [#341](https://github.com/ipython/traitlets/pull/341) introduces
  `--Application.show_config=True` which will make by default any
  application show it configuration, all the files it loaded
  configuration from, and exit.
- [#349](https://github.com/ipython/traitlets/pull/349) unify ability to declare
  default values across traitlets with a singular method `default`
  method, and [#525](https://github.com/ipython/traitlets/pull/525) adds a warning
  that `Undefined`is deprecated.
- [#355](https://github.com/ipython/traitlets/pull/355) fix a random ordering issues
  in command lines flags.
- [#356](https://github.com/ipython/traitlets/pull/356) allow both `self` and `cls`
  in `__new__` method for genericity.
- [#360](https://github.com/ipython/traitlets/pull/360) Simplify overwriting and
  extending the command line argument parser.
- [#371](https://github.com/ipython/traitlets/pull/371) introduces a
  `FuzzyEnum` trait that allow case
  insensitive and unique prefix matching.
- [#384](https://github.com/ipython/traitlets/pull/384) Ass a
  `trait_values` method to extra a mapping of trait and
  their values.
- [#393](https://github.com/ipython/traitlets/pull/393) `Link` now have a
  transform attribute (taking two functions inverse of each other),
  that affect how a value is mapped between a source and a target.
- [#394](https://github.com/ipython/traitlets/pull/394) `Link` now have a
  `link` method to re-link object after
  `unlink` has been called.
- [#402](https://github.com/ipython/traitlets/pull/402) rewrite handling of error
  messages for nested traits.
- [#405](https://github.com/ipython/traitlets/pull/405) all function that use to
  print help now have an equivalent that yields the help lines.
- [#413](https://github.com/ipython/traitlets/pull/413) traits now have a method
  `trait_has_value`, returning a boolean to know if a
  value has been assigned to a trait (excluding the default), in order
  to help avoiding circular validation at initialisation.
- [#416](https://github.com/ipython/traitlets/pull/416) Explicitly export traitlets
  in `__all__` to avoid exposing implementation details.
- [#438](https://github.com/ipython/traitlets/pull/438) introduces `.info_rst()` to
  let traitlets overwrite the automatically generated rst
  documentation.
- [#458](https://github.com/ipython/traitlets/pull/458) Add a sphinx extension to
  automatically document options of `Application` instance
  in projects using traitlets.
- [#509](https://github.com/ipython/traitlets/pull/509) remove all base `except:`
  meaning traitlets will not catch a number of
  `BaseException` s anymore.
- [#515](https://github.com/ipython/traitlets/pull/515) Add a class decorator to
  enable tab completion of keyword arguments in signature.
- [#516](https://github.com/ipython/traitlets/pull/516) a `Sentinel` Traitlets was
  made public by mistake and is now deprecated.
- [#517](https://github.com/ipython/traitlets/pull/517) use parent Logger within
  logggin configurable when possible.
- [#522](https://github.com/ipython/traitlets/pull/522) Make loading config files
  idempotent and expose the list of loaded config files for long
  running services.

### API changes

This list is auto-generated by `frappuccino`, comparing with traitlets
4.3.3 API and edited for shortness:

```
The following items are new:
    + traitlets.Sentinel
    + traitlets.config.application.Application.emit_alias_help(self)
    + traitlets.config.application.Application.emit_description(self)
    + traitlets.config.application.Application.emit_examples(self)
    + traitlets.config.application.Application.emit_flag_help(self)
    + traitlets.config.application.Application.emit_help(self, classes=False)
    + traitlets.config.application.Application.emit_help_epilogue(self, classes)
    + traitlets.config.application.Application.emit_options_help(self)
    + traitlets.config.application.Application.emit_subcommands_help(self)
    + traitlets.config.application.Application.start_show_config(self)
    + traitlets.config.application.default_aliases
    + traitlets.config.application.default_flags
    + traitlets.config.default_aliases
    + traitlets.config.default_flags
    + traitlets.config.loader.DeferredConfig
    + traitlets.config.loader.DeferredConfig.get_value(self, trait)
    + traitlets.config.loader.DeferredConfigList
    + traitlets.config.loader.DeferredConfigList.get_value(self, trait)
    + traitlets.config.loader.DeferredConfigString
    + traitlets.config.loader.DeferredConfigString.get_value(self, trait)
    + traitlets.config.loader.LazyConfigValue.merge_into(self, other)
    + traitlets.config.loader.Undefined
    + traitlets.config.loader.class_trait_opt_pattern
    + traitlets.traitlets.BaseDescriptor.subclass_init(self, cls)
    + traitlets.traitlets.Bool.from_string(self, s)
    + traitlets.traitlets.Bytes.from_string(self, s)
    + traitlets.traitlets.Callable
    + traitlets.traitlets.Callable.validate(self, obj, value)
    + traitlets.traitlets.CaselessStrEnum.info(self)
    + traitlets.traitlets.CaselessStrEnum.info_rst(self)
    + traitlets.traitlets.Complex.from_string(self, s)
    + traitlets.traitlets.Container.from_string(self, s)
    + traitlets.traitlets.Container.from_string_list(self, s_list)
    + traitlets.traitlets.Container.item_from_string(self, s)
    + traitlets.traitlets.Dict.from_string(self, s)
    + traitlets.traitlets.Dict.from_string_list(self, s_list)
    + traitlets.traitlets.Dict.item_from_string(self, s)
    + traitlets.traitlets.Enum.from_string(self, s)
    + traitlets.traitlets.Enum.info_rst(self)
    + traitlets.traitlets.Float.from_string(self, s)
    + traitlets.traitlets.FuzzyEnum
    + traitlets.traitlets.FuzzyEnum.info(self)
    + traitlets.traitlets.FuzzyEnum.info_rst(self)
    + traitlets.traitlets.FuzzyEnum.validate(self, obj, value)
    + traitlets.traitlets.HasTraits.trait_defaults(self, *names, **metadata)
    + traitlets.traitlets.HasTraits.trait_has_value(self, name)
    + traitlets.traitlets.HasTraits.trait_values(self, **metadata)
    + traitlets.traitlets.Instance.from_string(self, s)
    + traitlets.traitlets.Int.from_string(self, s)
    + traitlets.traitlets.ObjectName.from_string(self, s)
    + traitlets.traitlets.TCPAddress.from_string(self, s)
    + traitlets.traitlets.TraitType.default(self, obj='None')
    + traitlets.traitlets.TraitType.from_string(self, s)
    + traitlets.traitlets.Unicode.from_string(self, s)
    + traitlets.traitlets.Union.default(self, obj='None')
    + traitlets.traitlets.UseEnum.info_rst(self)
    + traitlets.traitlets.directional_link.link(self)
    + traitlets.traitlets.link.link(self)
    + traitlets.utils.cast_unicode(s, encoding='None')
    + traitlets.utils.decorators
    + traitlets.utils.decorators.Undefined
    + traitlets.utils.decorators.signature_has_traits(cls)
    + traitlets.utils.descriptions
    + traitlets.utils.descriptions.add_article(name, definite=False, capital=False)
    + traitlets.utils.descriptions.class_of(value)
    + traitlets.utils.descriptions.describe(article, value, name='None', verbose=False, capital=False)
    + traitlets.utils.descriptions.repr_type(obj)

The following items have been removed (or moved to superclass):
    - traitlets.ClassTypes
    - traitlets.SequenceTypes
    - traitlets.config.absolute_import
    - traitlets.config.application.print_function
    - traitlets.config.configurable.absolute_import
    - traitlets.config.configurable.print_function
    - traitlets.config.loader.KeyValueConfigLoader.clear
    - traitlets.config.loader.KeyValueConfigLoader.load_config
    - traitlets.config.loader.flag_pattern
    - traitlets.config.loader.kv_pattern
    - traitlets.config.print_function
    - traitlets.traitlets.ClassBasedTraitType.error
    - traitlets.traitlets.Container.element_error
    - traitlets.traitlets.List.validate
    - traitlets.traitlets.TraitType.instance_init
    - traitlets.traitlets.Union.make_dynamic_default
    - traitlets.traitlets.add_article
    - traitlets.traitlets.class_of
    - traitlets.traitlets.repr_type
    - traitlets.utils.getargspec.PY3
    - traitlets.utils.importstring.string_types
    - traitlets.warn_explicit

The following signatures differ between versions:

    - traitlets.config.application.Application.generate_config_file(self)
    + traitlets.config.application.Application.generate_config_file(self, classes='None')

    - traitlets.config.application.catch_config_error(method, app, *args, **kwargs)
    + traitlets.config.application.catch_config_error(method)

    - traitlets.config.configurable.Configurable.class_config_section()
    + traitlets.config.configurable.Configurable.class_config_section(classes='None')

    - traitlets.config.configurable.Configurable.class_get_trait_help(trait, inst='None')
    + traitlets.config.configurable.Configurable.class_get_trait_help(trait, inst='None', helptext='None')

    - traitlets.config.loader.ArgParseConfigLoader.load_config(self, argv='None', aliases='None', flags='None')
    + traitlets.config.loader.ArgParseConfigLoader.load_config(self, argv='None', aliases='None', flags='<deprecated>', classes='None')

    - traitlets.traitlets.Dict.element_error(self, obj, element, validator)
    + traitlets.traitlets.Dict.element_error(self, obj, element, validator, side='Values')

    - traitlets.traitlets.HasDescriptors.setup_instance(self, *args, **kwargs)
    + traitlets.traitlets.HasDescriptors.setup_instance(*args, **kwargs)

    - traitlets.traitlets.HasTraits.setup_instance(self, *args, **kwargs)
    + traitlets.traitlets.HasTraits.setup_instance(*args, **kwargs)

    - traitlets.traitlets.TraitType.error(self, obj, value)
    + traitlets.traitlets.TraitType.error(self, obj, value, error='None', info='None')
```

## 4.3

## 4.3.2

[4.3.2 on GitHub](https://github.com/ipython/traitlets/milestones/4.3.2)

4.3.2 is a tiny release, relaxing some of the deprecations introduced in
4.3.1:

- using `_traitname_default()` without
  the `@default` decorator is no longer deprecated.
- Passing `config=True` in traitlets constructors is no longer
  deprecated.

## 4.3.1

[4.3.1 on GitHub](https://github.com/ipython/traitlets/milestones/4.3.1)

- Compatibility fix for Python 3.6a1
- Fix bug in Application.classes getting extra entries when multiple
  Applications are instantiated in the same process.

## 4.3.0

[4.3.0 on GitHub](https://github.com/ipython/traitlets/milestones/4.3)

- Improve the generated config file output.
- Allow TRAITLETS_APPLICATION_RAISE_CONFIG_FILE_ERROR env to override
  `Application.raise_config_file_errors`, so that config file errors can
  result in exiting immediately.
- Avoid using root logger. If no application logger is registered, the
  `'traitlets'` logger will be used instead of the root logger.
- Change/Validation arguments are now Bunch objects, allowing
  attribute-access, in addition to dictionary access.
- Reduce number of common deprecation messages in certain cases.
- Ensure command-line options always have higher priority than config
  files.
- Add bounds on numeric traits.
- Improves various error messages.

## 4.2

## 4.2.2 - 2016-07-01

[4.2.2 on GitHub](https://github.com/ipython/traitlets/milestones/4.2.2)

Partially revert a change in 4.1 that prevented IPython's command-line
options from taking priority over config files.

## 4.2.1 - 2016-03-14

[4.2.1 on GitHub](https://github.com/ipython/traitlets/milestones/4.2.1)

Demotes warning about unused arguments in `HasTraits.__init__`
introduced in 4.2.0 to DeprecationWarning.

## 4.2.0 - 2016-03-14

[4.2 on GitHub](https://github.com/ipython/traitlets/milestones/4.2)

- `JSONFileConfigLoader` can be used
  as a context manager for updating configuration.
- If a value in config does not map onto a configurable trait, a
  message is displayed that the value will have no effect.
- Unused arguments are passed to `super()` in `HasTraits.__init__`,
  improving support for multiple inheritance.
- Various bugfixes and improvements in the new API introduced in 4.1.
- Application subclasses may specify `raise_config_file_errors = True`
  to exit on failure to load config files, instead of the default of
  logging the failures.

## 4.1 - 2016-01-15

[4.1 on GitHub](https://github.com/ipython/traitlets/milestones/4.1)

Traitlets 4.1 introduces a totally new decorator-based API for
configuring traitlets. Highlights:

- Decorators are used, rather than magic method names, for registering
  trait-related methods. See `using_traitlets` and `migration` for more
  info.
- Deprecate `Trait(config=True)` in favor of
  `Trait().tag(config=True)`. In general, metadata is added via `tag`
  instead of the constructor.

Other changes:

- Trait attributes initialized with `read_only=True` can only be set
  with the `set_trait` method. Attempts to directly modify a read-only
  trait attribute raises a `TraitError`.
- The directional link now takes an optional `transform`
  attribute allowing the modification of the value.
- Various fixes and improvements to config-file generation (fixed
  ordering, Undefined showing up, etc.)
- Warn on unrecognized traits that aren't configurable, to avoid
  silently ignoring mistyped config.

## 4.0 - 2015-06-19

[4.0 on GitHub](https://github.com/ipython/traitlets/milestones/4.0)

First release of traitlets as a standalone package.
