// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { CodeEditorWrapper } from '@jupyterlab/codeeditor';
import { CodeMirrorEditorFactory, CodeMirrorMimeTypeService, EditorLanguageRegistry } from '@jupyterlab/codemirror';
import { CodeCellModel } from './model';
import { Cell } from './widget';
/**
 * The default notebook content.
 */
export var NBTestUtils;
(function (NBTestUtils) {
    const editorServices = (function () {
        const languages = new EditorLanguageRegistry();
        const factoryService = new CodeMirrorEditorFactory({ languages });
        const mimeTypeService = new CodeMirrorMimeTypeService(languages);
        return {
            factoryService,
            mimeTypeService
        };
    })();
    NBTestUtils.editorFactory = editorServices.factoryService.newInlineEditor.bind(editorServices.factoryService);
    NBTestUtils.mimeTypeService = editorServices.mimeTypeService;
    /**
     * Create a base cell content factory.
     */
    function createBaseCellFactory() {
        return new Cell.ContentFactory({ editorFactory: NBTestUtils.editorFactory });
    }
    NBTestUtils.createBaseCellFactory = createBaseCellFactory;
    /**
     * Create a new code cell content factory.
     */
    function createCodeCellFactory() {
        return new Cell.ContentFactory({ editorFactory: NBTestUtils.editorFactory });
    }
    NBTestUtils.createCodeCellFactory = createCodeCellFactory;
    /**
     * Create a cell editor widget.
     */
    function createCellEditor(model) {
        return new CodeEditorWrapper({
            model: model !== null && model !== void 0 ? model : new CodeCellModel(),
            factory: NBTestUtils.editorFactory
        });
    }
    NBTestUtils.createCellEditor = createCellEditor;
})(NBTestUtils || (NBTestUtils = {}));
//# sourceMappingURL=testutils.js.map