/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class PVFile {
    public static byte[] versionNumber;
    public static int number;
    public static HashMap<String, String> configMap;
    public static int maxSegmentNum;
    public static byte OFFSET;
    public static int ABS;
    public static int REL;
    public static int ABS_AND_REL;
    public static int ABS_OR_REL;
    public static int errBoundMode;
    public static double absBoundRatio;
    public static double relBoundRatio;
    public static double compressTime;
    public static double zipTime;
    public static double spacefillingTime;
    public static double computeValueRangeTime;
    public static double writeTime;
    public static double decompressTime;
    public static double unzipTime;
    public static double readTime;
    public static DecimalFormat df1;
    public static DecimalFormat df2;

    static {
        byte[] byArray = new byte[3];
        byArray[1] = 5;
        byArray[2] = 14;
        versionNumber = byArray;
        number = 0;
        configMap = new HashMap();
        maxSegmentNum = 1024;
        OFFSET = (byte)2;
        ABS = 0;
        REL = 1;
        ABS_AND_REL = 2;
        ABS_OR_REL = 3;
        errBoundMode = ABS;
        absBoundRatio = 1.0E-6;
        relBoundRatio = 1.0E-10;
        compressTime = 0.0;
        zipTime = 0.0;
        spacefillingTime = 0.0;
        computeValueRangeTime = 0.0;
        writeTime = 0.0;
        decompressTime = 0.0;
        unzipTime = 0.0;
        readTime = 0.0;
        df1 = new DecimalFormat("0000");
        df2 = new DecimalFormat("00000");
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?[dD]?");
        return pattern.matcher(str).matches();
    }

    public static List<String> getSubFile(String path) {
        LinkedList<String> list;
        block3: {
            List<String> ls;
            block2: {
                list = new LinkedList<String>();
                ls = PVFile.getDir(path);
                if (ls.size() <= 0) break block2;
                Iterator<String> it = ls.iterator();
                while (it.hasNext()) {
                    String curpath = String.valueOf(path) + File.separator + it.next();
                    List<String> sublist = PVFile.getSubFile(curpath);
                    list.addAll(sublist);
                }
                break block3;
            }
            ls = PVFile.getFiles(path);
            if (ls.size() <= 0) break block3;
            Iterator<String> it = ls.iterator();
            while (it.hasNext()) {
                String fileName = String.valueOf(path) + File.separator + it.next();
                list.add(fileName);
            }
        }
        return list;
    }

    public static List<String> getDir(String path) {
        List<String> list = PVFile.getFileByType(path, 1);
        return list;
    }

    public static List<String> getFiles(String path) {
        List<String> list = PVFile.getFileByType(path, 2);
        return list;
    }

    public static List<String> getFiles(String path, String extension) {
        ArrayList<String> newlist = new ArrayList<String>();
        List<String> list = PVFile.getFiles(path);
        for (String fileName : list) {
            if (!fileName.endsWith(extension)) continue;
            newlist.add(fileName);
        }
        return newlist;
    }

    public static List<String> getFiles(String path, String extension1, String extension2) {
        ArrayList<String> newlist = new ArrayList<String>();
        List<String> list = PVFile.getFiles(path);
        for (String fileName : list) {
            if (!fileName.endsWith(extension1) && !fileName.endsWith(extension2)) continue;
            newlist.add(fileName);
        }
        return newlist;
    }

    private static List<String> getFileByType(String path, int type) {
        LinkedList<String> list = new LinkedList<String>();
        List<String> ls = PVFile.getLs(path);
        if (ls.size() > 0) {
            for (String filename : ls) {
                File f = new File(path, filename);
                if (type == 1 && f.isDirectory()) {
                    list.add(filename);
                    continue;
                }
                if (type != 2 || !f.isFile()) continue;
                list.add(filename);
            }
        }
        return list;
    }

    private static List<String> getLs(String path) {
        LinkedList<String> list = new LinkedList<String>();
        File dir = new File(path);
        if (dir.isDirectory()) {
            String[] fileNames = dir.list();
            int i = 0;
            while (i < fileNames.length) {
                list.add(fileNames[i]);
                ++i;
            }
        }
        return list;
    }

    public static void writeRec(String filename, String line) throws IOException {
        RandomAccessFile raf;
        FileChannel fc;
        FileLock fl;
        File output = new File(filename);
        if (!output.exists()) {
            output.createNewFile();
        }
        if ((fl = (fc = (raf = new RandomAccessFile(output, "rw")).getChannel()).tryLock()).isValid()) {
            raf.seek(0L);
            raf.writeBytes(String.valueOf(line));
            fl.release();
        }
        raf.close();
    }

    public static String read(String filename) {
        String line = "";
        try {
            File input = new File(filename);
            if (!input.exists()) {
                input.createNewFile();
            }
            InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(input), "GBK");
            BufferedReader reader = new BufferedReader(read);
            line = reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return line;
    }

    public static List<String> parseFile(String file) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            File input = new File(file);
            InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(input), "utf-8");
            BufferedReader reader = new BufferedReader(read);
            String line = null;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void createDir(String dirPath) {
        File f = new File(dirPath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            file.delete();
            System.out.println("Deleting File: " + fileName + " OK delete");
            return true;
        }
        System.out.println("Deleting File: " + fileName + " Failed delete");
        return false;
    }

    public static boolean deleteDir(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            System.out.println("delete dir failure: " + dir);
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() ? !(flag = PVFile.deleteFile(files[i].getAbsolutePath())) : !(flag = PVFile.deleteDir(files[i].getAbsolutePath()))) break;
            ++i;
        }
        if (!flag) {
            System.out.println("failed of deleting file!");
            return false;
        }
        if (dirFile.delete()) {
            System.out.println("deleting " + dir + " OK delte");
            return true;
        }
        System.out.println("deleting " + dir + " failed delete");
        return false;
    }

    public static void checkCreateDir(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static boolean isExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static File checkCreateFile(String filePath) {
        String[] s = filePath.split("/|\\\\");
        String dirPath = "";
        int i = 0;
        while (i < s.length - 1) {
            dirPath = String.valueOf(dirPath) + s[i] + "/";
            ++i;
        }
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(filePath);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void delete(String filePath) {
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            System.err.println("Failure to delete " + file.getPath());
            System.exit(0);
        }
    }

    public static List<String> getRecursiveFiles(String srcDirPath, String extension) {
        ArrayList<String> fileList = new ArrayList<String>();
        List<String> fileNameList = PVFile.getFiles(srcDirPath);
        for (String fileName : fileNameList) {
            if (fileName.endsWith(extension)) {
                fileList.add(String.valueOf(srcDirPath) + "/" + fileName);
            }
            if (number % 4000 == 0) {
                System.out.println("Load " + number + " " + extension + "-files: " + srcDirPath);
            }
            ++number;
        }
        List<String> dirList = PVFile.getDir(srcDirPath);
        for (String dir : dirList) {
            fileList.addAll(PVFile.getRecursiveFiles(String.valueOf(srcDirPath) + "/" + dir, extension));
        }
        return fileList;
    }

    public static List<String> readFile(String fileName) {
        if (!PVFile.isExist(fileName)) {
            return null;
        }
        ArrayList<String> readResult = new ArrayList<String>();
        try {
            String line;
            FileReader fr = new FileReader(fileName);
            BufferedReader in = new BufferedReader(fr);
            while ((line = in.readLine()) != null) {
                readResult.add(line);
            }
            in.close();
            fr.close();
            return readResult;
        }
        catch (Exception e) {
            System.err.print(e);
            return null;
        }
    }

    public static void print2File(byte[] bytes, String filePath) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < bytes.length) {
            list.add(String.valueOf(bytes[i]));
            ++i;
        }
        PVFile.print2File(list, filePath);
    }

    public static File print2File(List list, String filePath) {
        File file = PVFile.checkCreateFile(filePath);
        try {
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String xyz = it.next().toString();
                bw.write(xyz);
                bw.newLine();
            }
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void showProgress(double initLogTime, int i, int size, String fileName) {
        String currentTime = PVFile.getDateTime("HH:mm", new Date());
        long currentTimeValue = System.currentTimeMillis() / 1000L;
        System.out.println(String.valueOf(currentTime) + " : already " + ((double)currentTimeValue - initLogTime) + " sec passed, (" + i + "/" + size + "): " + fileName);
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        df = new SimpleDateFormat(aMask);
        returnValue = df.format(aDate);
        return returnValue;
    }

    public static void splitFile(int partitions, int times, String filePath, String outputDir) {
        ArrayList<String> readResult = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            int j = 1;
            int k = 0;
            int i = 0;
            while ((line = in.readLine()) != null) {
                readResult.add(line);
                if (i % partitions == 0 && i > 0) {
                    ++k;
                    PVFile.print2File(readResult, String.valueOf(outputDir) + "/" + j + ".data");
                    System.out.println("outputFile:" + outputDir + "/" + j + ".data");
                    ++j;
                    readResult.clear();
                    if (k >= times) {
                        System.out.println("done.");
                        System.exit(0);
                    }
                }
                ++i;
            }
            PVFile.print2File(readResult, String.valueOf(outputDir) + "/" + j + ".data");
            System.out.println("outputFile:" + outputDir + "/" + ++j + ".data");
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    public static Object readZipFile2Object(String zipFilePath) {
        try {
            double start = System.nanoTime();
            byte[] bytes = PVFile.readBinaryFile(zipFilePath);
            double end = System.nanoTime();
            readTime += end - start;
            double before = System.nanoTime();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            GZIPInputStream gzipIn = new GZIPInputStream(bais);
            ObjectInputStream objectIn = new ObjectInputStream(gzipIn);
            Object obj = objectIn.readObject();
            objectIn.close();
            double after = System.nanoTime();
            unzipTime += after - before;
            return obj;
        }
        catch (Exception e) {
            System.out.println("Error: The input file or data stream is not in SZ format!");
            System.out.println("Please make sure the input data is the byte stream compressed by SZ.");
            System.exit(0);
            return null;
        }
    }

    public static Object unGzip(byte[] bytes) {
        Object obj = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            GZIPInputStream gzipIn = new GZIPInputStream(bais);
            ObjectInputStream objectIn = new ObjectInputStream(gzipIn);
            obj = objectIn.readObject();
            objectIn.close();
        }
        catch (Exception e) {
            System.out.println("Error: The input file or data stream is not in Gzip format!");
            System.out.println("Please check if the input file is correct.");
            System.exit(0);
        }
        return obj;
    }

    private static void doUncompressFile(String inFileName) {
        try {
            int len;
            if (!PVFile.getExtension(inFileName).equalsIgnoreCase("gz")) {
                System.err.println("File name must have extension of \".gz\"");
                System.exit(1);
            }
            System.out.println("Opening the compressed file.");
            GZIPInputStream in = null;
            try {
                in = new GZIPInputStream(new FileInputStream(inFileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found. " + inFileName);
                System.exit(1);
            }
            System.out.println("Open the output file.");
            String outFileName = PVFile.getFileName(inFileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFileName);
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not write to file. " + outFileName);
                System.exit(1);
            }
            System.out.println("Transfering bytes from compressed file to the output file.");
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            System.out.println("Closing the file and stream");
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getExtension(String f) {
        String ext = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            ext = f.substring(i + 1);
        }
        return ext;
    }

    public static String getFileName(String f) {
        String fname = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            fname = f.substring(0, i);
        }
        return fname;
    }

    public static void append2File(List<String> list, String filePath) {
        PVFile.checkCreateFile(filePath);
        try {
            FileWriter fw = new FileWriter(filePath, true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (String xyz : list) {
                bw.write(xyz);
                bw.newLine();
            }
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void append2File(String line, BufferedWriter bw) throws IOException {
        bw.append(line);
    }

    public static void writeObject(Object object, String objectFilePath) {
        File file = PVFile.checkCreateFile(objectFilePath);
        try {
            ObjectOutputStream oout = new ObjectOutputStream(new FileOutputStream(file));
            oout.writeObject(object);
            oout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object readObject(String objectFilePath) {
        File file = new File(objectFilePath);
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            Object o = in.readObject();
            in.close();
            return o;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String checkCompressionRatio(String rootSnapshotDir, String outputDir) {
        String aggOriFilePath = String.valueOf(rootSnapshotDir) + "/aggregateSnapshot.obj";
        File f0 = new File(aggOriFilePath);
        float totalOriSize = f0.length();
        float totalObjSize = 0.0f;
        float totalZipSize = 0.0f;
        List<String> cmpressFileList = PVFile.getFiles(String.valueOf(outputDir) + "/test");
        for (String fileName : cmpressFileList) {
            if (!fileName.endsWith("obj")) continue;
            String filePath = String.valueOf(outputDir) + "/test/" + fileName;
            File f = new File(filePath);
            totalObjSize += (float)f.length();
        }
        List<String> cmpressFileList2 = PVFile.getFiles(String.valueOf(outputDir) + "/test2");
        for (String fileName : cmpressFileList2) {
            if (!fileName.endsWith("sz")) continue;
            String filePath = String.valueOf(outputDir) + "/test2/" + fileName;
            File f = new File(filePath);
            totalZipSize += (float)f.length();
        }
        String result = "totalOriSize=" + totalOriSize + " totalObjSize=" + totalObjSize + " totalZipSize=" + totalZipSize + " ratio1=1:" + totalOriSize / totalObjSize + " ratio2=1:" + totalOriSize / totalZipSize;
        return result;
    }

    public static byte[] readBinaryFile(String filePath) {
        File file = new File(filePath);
        return PVFile.readBinaryFile(file);
    }

    public static byte[] readBinaryFile(File sourceFile) {
        long fileLength;
        if (sourceFile.isFile() && sourceFile.exists() && (fileLength = sourceFile.length()) > 0L) {
            try {
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(sourceFile));
                byte[] b = new byte[(int)fileLength];
                while (fis.read(b) != -1) {
                }
                fis.close();
                fis = null;
                return b;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void writeBytes2File(byte[] bytes, String tgtFile) {
        BufferedOutputStream bos = null;
        try {
            FileOutputStream fos = new FileOutputStream(new File(tgtFile));
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig(String configFile) {
        List<String> lineList = PVFile.readFile(configFile);
        Iterator<String> iter = lineList.iterator();
        while (iter.hasNext()) {
            String line = iter.next().trim();
            if (line.startsWith("#") || !line.contains("=")) continue;
            String[] s = line.split("=");
            configMap.put(s[0].trim(), s[1].trim());
        }
    }

    public static boolean checkEndianType() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN;
    }

    public static boolean checkVersion(byte[] version) {
        int i = 0;
        while (i < version.length) {
            if (version[i] != versionNumber[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        String userhome = System.getProperty("user.home");
        List<String> list = PVFile.readFile(String.valueOf(userhome) + "/.bashrc");
    }
}

