###############################################################################
#
# Tests for XlsxWriter.
#
# Copyright (c), 2013-2016, John McNamara, jmcnamara@cpan.org
#

from ..excel_comparsion_test import ExcelComparisonTest
from ...workbook import Workbook


class TestCompareXLSXFiles(ExcelComparisonTest):
    """
    Test file created by XlsxWriter against a file created by Excel.

    """

    def setUp(self):
        self.maxDiff = None

        filename = 'chart_gridlines09.xlsx'

        test_dir = 'xlsxwriter/test/comparison/'
        self.got_filename = test_dir + '_test_' + filename
        self.exp_filename = test_dir + 'xlsx_files/' + filename

        self.ignore_files = []
        self.ignore_elements = {}

    def test_create_file(self):
        """Test XlsxWriter gridlines."""

        workbook = Workbook(self.got_filename)

        worksheet = workbook.add_worksheet()
        chart = workbook.add_chart({'type': 'column'})

        chart.axis_ids = [48744320, 49566848]

        data = [
            [1, 2, 3, 4, 5],
            [2, 4, 6, 8, 10],
            [3, 6, 9, 12, 15],

        ]

        worksheet.write_column('A1', data[0])
        worksheet.write_column('B1', data[1])
        worksheet.write_column('C1', data[2])

        chart.add_series({'values': '=Sheet1!$A$1:$A$5'})
        chart.add_series({'values': '=Sheet1!$B$1:$B$5'})
        chart.add_series({'values': '=Sheet1!$C$1:$C$5'})

        chart.set_x_axis({
            'major_gridlines': {
                'visible': 1,
                'line': {'color': 'red', 'width': 0.5, 'dash_type': 'square_dot'}
            },

            'minor_gridlines': {
                'visible': 1,
                'line': {'color': 'yellow'}
            },
        })

        chart.set_y_axis({
            'major_gridlines': {
                'visible': 1,
                'line': {'width': 1.25, 'dash_type': 'dash'}
            },

            'minor_gridlines': {
                'visible': 1,
                'line': {'color': '#00B050'}
            },
        })

        worksheet.insert_chart('E9', chart)

        workbook.close()

        self.assertExcelEqual()
