#!/usr/bin/env python3

import sys

# File to take a .bit file generated by xilinx webpack ISE
# and replace the date and time embedded within with 'F'.
# The header of the bitfile is seperated by ascii markers
# 'a', 'b', 'c', 'd' etc.
# see fpga_compress.c for comparison

def parse_and_split_file(filename):
    split_chars = ['a', 'b', 'c', 'd']  # Characters to split on
    extracted_data = [] # for debug

    print("Overwriting date and time in bitfile {}".format(filename))

    with open(filename, 'rb') as f:  # Read as binary to handle non-text files
        data = f.read(100)  # Read first 100 bytes which should contain all information

    decoded_data = bytearray(data)

    for i in range(len(decoded_data) - 3):
        # subsequent two bytes after marker are null and the length
        next_byte   = decoded_data[i+1]
        data_length = decoded_data[i+2] - 1 # Don't overwrite terminating char

        if decoded_data[i] == ord(split_chars[0]) and next_byte == 0x0:
            start = i+3
            extracted_data.append(decoded_data[start:start+data_length])

            # time, date
            if split_chars[0] == 'c' or split_chars[0] == 'd':
                decoded_data[start:start+data_length] = bytes('F', encoding='ascii') * data_length

            split_chars.pop(0)

            if not split_chars:
                break

    print("Extracted data from bitfile: {}".format(extracted_data))

    with open(filename, 'r+b') as f:  # Write back modified bytes
        f.seek(0)
        f.write(decoded_data.ljust(100, b' '))
    print("writing complete")

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python script.py <filename>")
        sys.exit(1)

    filename = sys.argv[1]
    parse_and_split_file(filename)
