/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.StringReader;
import java.util.Objects;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.internal.util.AssertionUtil;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.ReaderDataSource;

@Experimental
class StringTextFile
implements TextFile {
    private final String content;
    private final String pathId;
    private final String displayName;
    private final LanguageVersion languageVersion;

    StringTextFile(String content, String pathId, String displayName, LanguageVersion languageVersion) {
        AssertionUtil.requireParamNotNull("source text", content);
        AssertionUtil.requireParamNotNull("file name", displayName);
        AssertionUtil.requireParamNotNull("file ID", pathId);
        AssertionUtil.requireParamNotNull("language version", languageVersion);
        this.languageVersion = languageVersion;
        this.content = content;
        this.pathId = pathId;
        this.displayName = displayName;
    }

    @Override
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getPathId() {
        return this.pathId;
    }

    @Override
    public String readContents() {
        return this.content;
    }

    @Override
    public DataSource toDataSourceCompat() {
        return new ReaderDataSource(new StringReader(this.content), this.pathId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringTextFile that = (StringTextFile)o;
        return Objects.equals(this.pathId, that.pathId);
    }

    public int hashCode() {
        return Objects.hash(this.pathId);
    }

    public String toString() {
        return this.getPathId();
    }
}

