/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import net.sourceforge.pmd.cache.internal.ClasspathEntryFingerprinter;
import org.apache.commons.io.IOUtils;

public class RawFileFingerprinter
implements ClasspathEntryFingerprinter {
    private static final Logger LOG = Logger.getLogger(RawFileFingerprinter.class.getName());
    private static final Set<String> SUPPORTED_EXTENSIONS;

    @Override
    public boolean appliesTo(String fileExtension) {
        return SUPPORTED_EXTENSIONS.contains(fileExtension);
    }

    @Override
    public void fingerprint(URL entry, Checksum checksum) throws IOException {
        try (CheckedInputStream inputStream = new CheckedInputStream(entry.openStream(), checksum);){
            while (IOUtils.skip((InputStream)inputStream, (long)Long.MAX_VALUE) == Long.MAX_VALUE) {
            }
        }
        catch (FileNotFoundException ignored) {
            LOG.warning("Classpath entry " + entry.toString() + " doesn't exist, ignoring it");
        }
    }

    static {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("class");
        SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(extensions);
    }
}

