/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.plot.AbstractSymbolFactory;
import jcckit.plot.Hint;
import jcckit.plot.PositionHint;
import jcckit.plot.Symbol;
import jcckit.util.ConfigParameters;

public class BarFactory
extends AbstractSymbolFactory {
    public static final String STACKED_KEY = "stacked";
    public static final String HORIZONTAL_BARS_KEY = "horizontalBars";
    private final boolean _stacked;
    private final boolean _horizontalBars;

    public BarFactory(ConfigParameters config) {
        super(config);
        this._horizontalBars = config.getBoolean(HORIZONTAL_BARS_KEY, false);
        this._stacked = config.getBoolean(STACKED_KEY, false);
    }

    @Override
    protected Symbol createSymbol(GraphPoint point, GraphicAttributes attributes, Hint hintForNextPoint, Hint hintFromPreviousCurve) {
        GraphPoint origin;
        GraphPoint position = origin = new GraphPoint(null);
        if (hintFromPreviousCurve instanceof PositionHint) {
            origin = ((PositionHint)hintFromPreviousCurve).getOrigin();
            position = ((PositionHint)hintFromPreviousCurve).getPosition();
        }
        double px = position.getX();
        double py = position.getY();
        double x = point.getX() - origin.getX();
        double y = point.getY() - origin.getY();
        if (this._horizontalBars) {
            y = this._size;
            position = new GraphPoint(px + 0.5 * x, point.getY() + py);
            px += this._stacked ? x : 0.0;
            py += this._stacked ? 0.0 : this._size;
        } else {
            x = this._size;
            position = new GraphPoint(point.getX() + px, py + 0.5 * y);
            px += this._stacked ? 0.0 : this._size;
            py += this._stacked ? y : 0.0;
        }
        PositionHint hintForNextCurve = new PositionHint(origin, new GraphPoint(px, py));
        return new Symbol(new Rectangle(position, Math.abs(x), Math.abs(y), attributes), hintForNextPoint, hintForNextCurve);
    }

    @Override
    public GraphicalElement createLegendSymbol(GraphPoint centerPosition, double size) {
        return new Rectangle(centerPosition, size, size, this._attributes);
    }

    @Override
    protected GraphicalElement createPlainSymbol(GraphPoint centerPosition, double size, GraphicAttributes attributes) {
        return null;
    }
}

