/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.xmi.UMLAggregationKind;
import net.sourceforge.plantuml.xmi.XmiClassDiagramAbstract;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmiClassDiagramScript
extends XmiClassDiagramAbstract
implements XmlDiagramTransformer {
    protected final Map<String, List<MemberData>> members = new HashMap<String, List<MemberData>>();

    public XmiClassDiagramScript(ClassDiagram classDiagram) throws ParserConfigurationException {
        super(classDiagram);
        this.addPackage(this.ownedElementRoot, classDiagram.getRootGroup());
        for (Link link : classDiagram.getLinks()) {
            this.addLink(link);
        }
    }

    protected final Element createElementPackage(Entity group) {
        Element umlPackage = this.document.createElement("UML:Package");
        umlPackage.setAttribute("xmi.id", group.getUid());
        umlPackage.setAttribute("name", group.getDisplay().get(0).toString());
        Element namespaceOwnedElement = this.document.createElement("UML:Namespace.ownedElement");
        umlPackage.appendChild(namespaceOwnedElement);
        this.addPackage(namespaceOwnedElement, group);
        return umlPackage;
    }

    private void addPackage(Element element, Entity group) {
        for (Entity ent : group.leafs()) {
            Element cla = this.createEntityNode(ent);
            if (cla == null) continue;
            element.appendChild(cla);
            if (!this.members.containsKey(ent.getUid())) {
                this.members.put(ent.getUid(), new ArrayList());
            }
            NodeList attrs = cla.getElementsByTagName("UML:Attribute");
            for (int i = 0; i < attrs.getLength(); ++i) {
                Element child = (Element)attrs.item(i);
                this.members.get(ent.getUid()).add(new MemberData(child.getAttribute("name"), child.getAttribute("xmi.id"), child.getTagName()));
            }
            NodeList ops = cla.getElementsByTagName("UML:Operation");
            for (int i = 0; i < ops.getLength(); ++i) {
                Element child = (Element)ops.item(i);
                this.members.get(ent.getUid()).add(new MemberData(child.getAttribute("name"), child.getAttribute("xmi.id"), child.getTagName()));
            }
            this.done.add(ent);
        }
        for (Entity childGroup : group.groups()) {
            Element result = this.createElementPackage(childGroup);
            element.appendChild(result);
            this.done.add(childGroup);
        }
    }

    private void addLink(Link link) {
        if (link.isHidden() || link.isInvis()) {
            return;
        }
        if (!link.getType().getStyle().isNormal()) {
            Element dependency = this.createDependency(link);
            this.ownedElementRoot.appendChild(dependency);
            return;
        }
        String assId = this.classDiagram.getUniqueSequence("ass");
        if (link.getType().getDecor1() == LinkDecor.EXTENDS || link.getType().getDecor2() == LinkDecor.EXTENDS) {
            this.addExtension(link, assId);
            return;
        }
        UMLAggregationKind aggregation = UMLAggregationKind.None;
        if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            aggregation = UMLAggregationKind.Composite;
        }
        if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            aggregation = UMLAggregationKind.Composite;
        }
        if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
            aggregation = UMLAggregationKind.Aggregation;
        }
        if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
            aggregation = UMLAggregationKind.Aggregation;
        }
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        if (!Display.isNull(link.getLabel())) {
            association.setAttribute("name", this.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.createAssociationEnd(assId, link.getType().getDecor2(), link.getQuantifier1(), link.getEntity1(), aggregation);
        connection.appendChild(end1);
        Element end2 = this.createAssociationEnd(assId, link.getType().getDecor1(), link.getQuantifier2(), link.getEntity2(), aggregation);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElementRoot.appendChild(association);
    }

    private Element createAssociationEnd(String assId, LinkDecor decor, String quantifier, Entity entity, UMLAggregationKind aggregation) {
        Element end = this.document.createElement("UML:AssociationEnd");
        end.setAttribute("xmi.id", this.classDiagram.getUniqueSequence("end"));
        end.setAttribute("association", assId);
        if (quantifier != null) {
            end.setAttribute("name", this.forXMI(quantifier));
        }
        end.setAttribute("participant", entity.getUid());
        if (aggregation != UMLAggregationKind.None) {
            end.setAttribute("aggregation", aggregation.name);
        }
        boolean navigable = decor != LinkDecor.NOT_NAVIGABLE && decor != LinkDecor.NONE;
        end.setAttribute("isNavigable", Boolean.toString(navigable));
        return end;
    }

    private void addExtension(Link link, String assId) {
        Element association = this.document.createElement("UML:Generalization");
        association.setAttribute("xmi.id", assId);
        if (link.getLabel() != null) {
            association.setAttribute("name", this.forXMI(link.getLabel()));
        }
        if (link.getType().getDecor1() == LinkDecor.EXTENDS) {
            this.generalizationChildParent(association, link.getEntity1().getUid(), link.getEntity2().getUid());
        } else if (link.getType().getDecor2() == LinkDecor.EXTENDS) {
            this.generalizationChildParent(association, link.getEntity2().getUid(), link.getEntity1().getUid());
        } else {
            throw new IllegalStateException();
        }
        this.ownedElementRoot.appendChild(association);
    }

    private Element createDependency(Link link) {
        if (link.isInverted()) {
            return this.createDependencyClientSupplier(link.getEntity2(), link.getPortName2(), link.getEntity1(), link.getPortName1());
        }
        return this.createDependencyClientSupplier(link.getEntity1(), link.getPortName1(), link.getEntity2(), link.getPortName2());
    }

    private Element createRef(Entity entity, String member) {
        if (member == null) {
            Element ref = this.document.createElement("UML:Class");
            ref.setAttribute("xmi.idref", entity.getUid());
            return ref;
        }
        List<MemberData> mbers = this.members.get(entity.getUid());
        if (mbers == null) {
            Log.info(() -> String.format("Could not find entity %s in member list", entity.getName()));
            return null;
        }
        for (MemberData m : mbers) {
            if (!m.name.contains(member)) continue;
            Element ref = this.document.createElement(m.kind);
            ref.setAttribute("xmi.idref", m.id);
            return ref;
        }
        Log.error(String.format("Could not find the member %s in the object %s", member, entity.getName()));
        return null;
    }

    private Element createDependencyClientSupplier(Entity clientEntity, String clientPort, Entity supplierEntity, String supplierPort) {
        Element supplierRef;
        String depID = this.classDiagram.getUniqueSequence("dep");
        Element dependency = this.document.createElement("UML:Dependency");
        dependency.setAttribute("xmi.id", depID);
        Element client = this.document.createElement("UML:Dependency.client");
        Element supplier = this.document.createElement("UML:Dependency.supplier");
        Element clientRef = this.createRef(clientEntity, clientPort);
        if (clientRef != null) {
            client.appendChild(clientRef);
        }
        if ((supplierRef = this.createRef(supplierEntity, supplierPort)) != null) {
            supplier.appendChild(supplierRef);
        }
        dependency.appendChild(client);
        dependency.appendChild(supplier);
        return dependency;
    }

    private void generalizationChildParent(Element association, String uidChild, String uidParent) {
        Element child = this.document.createElement("UML:Generalization.child");
        Element parent = this.document.createElement("UML:Generalization.parent");
        Element classChild = this.document.createElement("UML:Class");
        classChild.setAttribute("xmi.idref", uidChild);
        Element classParent = this.document.createElement("UML:Class");
        classParent.setAttribute("xmi.idref", uidParent);
        parent.appendChild(classParent);
        child.appendChild(classChild);
        association.appendChild(child);
        association.appendChild(parent);
    }

    private static class MemberData {
        public final String name;
        public final String id;
        public final String kind;

        public MemberData(String name, String id, String kind) {
            this.name = name;
            this.id = id;
            this.kind = kind;
        }
    }
}

