amends "../snippetTest.pkl"

facts {
  ["isNaN"] {
    NaN.isNaN
    !Infinity.isNaN
    !(-Infinity).isNaN
    !42.123.isNaN
    !(-42.123).isNaN
  }

  ["isFinite"] {
    42.123.isFinite
    (-42.123).isFinite
    !NaN.isFinite
    !Infinity.isFinite
    !(-Infinity).isFinite
  }

  ["isInfinite"] {
    Infinity.isInfinite
    (-Infinity).isInfinite
    !42.123.isInfinite
    !(-42.123).isInfinite
    !NaN.isInfinite
  }

  ["isPositive"] {
    42.123.isPositive
    0.0.isPositive
    Infinity.isPositive
    (-0.0).isPositive
    !(-42.123).isPositive
    !NaN.isPositive
    !(-Infinity).isPositive
  }

  ["isBetween()"] {
    3.3.isBetween(2, 4)
    3.3.isBetween(2.2, 4.4)
    3.3.isBetween(2.2, 4)
    3.3.isBetween(2, 4.4)
    3.3.isBetween(2, 3.3)
    3.3.isBetween(3.3, 4.0)
    3.3.isBetween(3.3, 3.3)
    !3.3.isBetween(1.1, 2.2)
    !3.3.isBetween(4.4, 2.2)
  }

  ["isNonZero"] {
    3.3.isNonZero
    (-3.3).isNonZero
    NaN.isNonZero
    !0.isNonZero
    !0.0.isNonZero
    !(-0.0).isNonZero
  }

  ["toDuration()"] {
    3.21.toDuration("min") == 3.21.min
    -99.999.toDuration("ms") == -99.999.ms
  }

  ["toDataSize()"] {
    3.21.toDataSize("kb") == 3.21.kb
    -99.999.toDataSize("gib") == -99.999.gib
  }
}

examples {
  ["sign"] {
    2.34.sign
    (-2.34).sign
    0.0.sign
    (-0.0).sign
    NaN.sign
    Infinity.sign
    (-Infinity).sign
  }

  ["abs"] {
    2.34.abs
    (-2.34).abs
    0.0.abs
    (-0.0).abs
    NaN.abs
    Infinity.abs
    (-Infinity).abs
  }

  ["ceil"] {
    2.34.ceil
    2.9.ceil
    (-2.34).ceil
    (-2.9).ceil
    0.0.ceil
    (-0.0).ceil
    NaN.ceil
    Infinity.ceil
    (-Infinity).ceil
  }

  ["floor"] {
    2.34.floor
    2.9.floor
    (-2.34).floor
    (-2.9).floor
    0.0.floor
    (-0.0).floor
    NaN.floor
    Infinity.floor
    (-Infinity).floor
  }

  ["round()"] {
    2.34.round()
    2.9.round()
    (-2.34).round()
    (-2.9).round()
    0.0.round()
    (-0.0).round()
    NaN.round()
    Infinity.round()
    (-Infinity).round()
  }

  ["truncate()"] {
    2.34.truncate()
    2.9.truncate()
    (-2.34).truncate()
    (-2.9).truncate()
    0.0.truncate()
    (-0.0).truncate()
    NaN.truncate()
    Infinity.truncate()
    (-Infinity).truncate()
  }

  ["toInt()"] {
    2.34.toInt()
    2.9.toInt()
    (-2.34).toInt()
    (-2.9).toInt()
    0.0.toInt()
    (-0.0).toInt()
    module.catch(() -> Infinity.toInt())
    module.catch(() -> (-Infinity).toInt())
    module.catch(() -> NaN.toInt())
    module.catch(() -> 9223372036854775808.1.toInt())
  }

  ["toFloat()"] {
    2.34.toFloat()
    2.9.toFloat()
    (-2.34).toFloat()
    (-2.9).toFloat()
    0.0.toFloat()
    (-0.0).toFloat()
    NaN.toFloat()
    Infinity.toFloat()
    (-Infinity).toFloat()
  }

  ["toString()"] {
    2.34.toString()
    2.9.toString()
    (-2.34).toString()
    (-2.9).toString()
    0.0.toString()
    (-0.0).toString()
    NaN.toString()
    Infinity.toString()
    (-Infinity).toString()
  }

  ["toFixed()"] {
    2.34.toFixed(0)
    2.9.toFixed(0)
    (-2.34).toFixed(0)
    (-2.9).toFixed(0)
    0.0.toFixed(0)
    (-0.0).toFixed(0)
    NaN.toFixed(0)
    Infinity.toFixed(0)
    (-Infinity).toFixed(0)

    2.34.toFixed(1)
    2.9.toFixed(2)
    (-2.34).toFixed(3)
    (-2.9).toFixed(4)
    0.0.toFixed(5)
    (-0.0).toFixed(6)
    NaN.toFixed(7)
    Infinity.toFixed(8)
    (-Infinity).toFixed(9)

    1.23456789.toFixed(1)
    (-1.23456789).toFixed(2)
    1.23456789.toFixed(3)
    (-1.23456789).toFixed(4)
    1.23456789.toFixed(5)
    (-1.23456789).toFixed(6)
    1.23456789.toFixed(7)
    (-1.23456789).toFixed(8)
    1.23456789.toFixed(9)

    123456789.123456789.toFixed(1)
    123456789.123456789.toFixed(2)
    123456789.123456789.toFixed(3)
    123456789.123456789.toFixed(4)
    123456789.123456789.toFixed(5)
    123456789.123456789.toFixed(6)
    123456789.123456789.toFixed(7)
    123456789.123456789.toFixed(8)
    123456789.123456789.toFixed(9)
    
    module.catch(() -> 1.23.toFixed(-1))
    module.catch(() -> 1.23.toFixed(21))
  }
}
