//  Copyright (c) 2007-2012 Hartmut Kaiser
//  Copyright (c) 2017      Denis Blank
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <pika/config.hpp>
#include <pika/debugging/attach_debugger.hpp>
#include <pika/runtime/config_entry.hpp>
#include <pika/runtime/debugging.hpp>

#include <string>

namespace pika::util {
    void may_attach_debugger(std::string const& category)
    {
        if (get_config_entry("pika.attach_debugger", "") == category)
        {
            debug::detail::attach_debugger();
        }
    }
}    // namespace pika::util
