/*
  +----------------------------------------------------------------------+
  | Copyright (c) The PHP Group                                          |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | https://www.php.net/license/3_01.txt                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Andrey Hristov <andrey@php.net>                             |
  |          Ulf Wendel <uw@php.net>                                     |
  |          Georg Richter <georg@php.net>                               |
  +----------------------------------------------------------------------+
*/

#ifndef MYSQLND_ENUM_N_DEF_H
#define MYSQLND_ENUM_N_DEF_H

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#define MYSQLND_MIN_COMPRESS_LEN 0

#define MYSQLND_MAX_PACKET_SIZE (256L*256L*256L-1)

#define MYSQLND_ASSEMBLED_PACKET_MAX_SIZE 3UL*1024UL*1024UL*1024UL

#define MYSQLND_DEFAULT_AUTH_PROTOCOL "mysql_native_password"

#define MYSQLND_ERRMSG_SIZE			512
#define MYSQLND_SQLSTATE_LENGTH		5
#define MYSQLND_SQLSTATE_NULL		"00000"

#define MYSQLND_MAX_ALLOWED_USER_LEN	252		/* 63 char * 4byte . MySQL supports now only 16 char, but let it be forward compatible */
#define MYSQLND_MAX_ALLOWED_DB_LEN		1024	/* 256 char * 4byte. MySQL supports now only 64 char in the tables, but on the FS could be different. Forward compatible. */

#define MYSQLND_NET_CMD_BUFFER_MIN_SIZE			4096
#define MYSQLND_NET_CMD_BUFFER_MIN_SIZE_STR		"4096"

#define MYSQLND_STMT_ID_LENGTH 4


#define SERVER_STATUS_IN_TRANS					1	/* Transaction has started */
#define SERVER_STATUS_AUTOCOMMIT				2	/* Server in auto_commit mode */
#define SERVER_MORE_RESULTS_EXISTS				8	/* Multi query - next query exists */
#define SERVER_QUERY_NO_GOOD_INDEX_USED	16
#define SERVER_QUERY_NO_INDEX_USED		32
/*
  The server was able to fulfill the clients request and opened a
  read-only non-scrollable cursor for a query. This flag comes
  in reply to COM_STMT_EXECUTE and COM_STMT_FETCH commands.
*/
#define SERVER_STATUS_CURSOR_EXISTS				64
/*
  This flag is sent when a read-only cursor is exhausted, in reply to
  COM_STMT_FETCH command.
*/
#define SERVER_STATUS_LAST_ROW_SENT				128
#define SERVER_STATUS_DB_DROPPED				256 /* A database was dropped */
#define SERVER_STATUS_NO_BACKSLASH_ESCAPES		512
#define SERVER_QUERY_WAS_SLOW					2048
#define SERVER_PS_OUT_PARAMS            		4096

#define MYSQLND_NO_DATA			100
#define MYSQLND_DATA_TRUNCATED	101

#define SHA1_MAX_LENGTH 20
#define SCRAMBLE_LENGTH 20
#define SCRAMBLE_LENGTH_323 8

#define CLIENT_LONG_PASSWORD		1		/* new more secure passwords */
#define CLIENT_FOUND_ROWS			2		/* Found instead of affected rows */
#define CLIENT_LONG_FLAG			4		/* Get all column flags */
#define CLIENT_CONNECT_WITH_DB		8		/* One can specify db on connect */
#define CLIENT_NO_SCHEMA			16		/* Don't allow database.table.column */
#define CLIENT_COMPRESS				32		/* Can use compression protocol */
#define CLIENT_ODBC					64		/* Odbc client */
#define CLIENT_LOCAL_FILES			128		/* Can use LOAD DATA LOCAL */
#define CLIENT_IGNORE_SPACE			256		/* Ignore spaces before '(' */
#define CLIENT_PROTOCOL_41			512		/* New 4.1 protocol */
#define CLIENT_INTERACTIVE			1024	/* This is an interactive client */
#define CLIENT_SSL					2048	/* Switch to SSL after handshake */
#define CLIENT_IGNORE_SIGPIPE		4096	/* IGNORE sigpipes */
#define CLIENT_TRANSACTIONS			8192	/* Client knows about transactions */
#define CLIENT_RESERVED				16384	/* Old flag for 4.1 protocol */
#define CLIENT_SECURE_CONNECTION	32768	/* New 4.1 authentication */
#define CLIENT_MULTI_STATEMENTS		(1UL << 16) /* Enable/disable multi-stmt support */
#define CLIENT_MULTI_RESULTS		(1UL << 17) /* Enable/disable multi-results */
#define CLIENT_PS_MULTI_RESULTS		(1UL << 18) /* Multi-results in PS-protocol */
#define CLIENT_PLUGIN_AUTH			(1UL << 19) /* Client supports plugin authentication */
#define CLIENT_CONNECT_ATTRS		(1UL << 20) /* Client supports connection attributes */
#define CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA	(1UL << 21) /* Enable authentication response packet to be larger than 255 bytes. */
#define CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS		(1UL << 22) /* Don't close the connection for a connection with expired password. */
#define CLIENT_SESSION_TRACK					(1UL << 23) /* Extended OK */
/*
  This is a mysqlnd extension. CLIENT_ODBC is not used anyway. We will reuse it for our case and translate it to not using SSL peer verification
*/
#define CLIENT_SSL_DONT_VERIFY_SERVER_CERT	CLIENT_ODBC
#define CLIENT_SSL_VERIFY_SERVER_CERT	(1UL << 30)
#define CLIENT_REMEMBER_OPTIONS			(1UL << 31)

#define MYSQLND_CAPABILITIES (CLIENT_LONG_PASSWORD | CLIENT_LONG_FLAG | CLIENT_TRANSACTIONS | \
				CLIENT_PROTOCOL_41 | CLIENT_SECURE_CONNECTION | \
				CLIENT_MULTI_RESULTS  | CLIENT_LOCAL_FILES | CLIENT_PLUGIN_AUTH)

#define MYSQLND_PROTOCOL_FLAG_USE_COMPRESSION 1


/* Client Error codes */
#define CR_UNKNOWN_ERROR		2000
#define CR_CONNECTION_ERROR		2002
#define CR_SERVER_GONE_ERROR	2006
#define CR_OUT_OF_MEMORY		2008
#define CR_SERVER_LOST			2013
#define CR_COMMANDS_OUT_OF_SYNC	2014
#define CR_CANT_FIND_CHARSET	2019
#define CR_MALFORMED_PACKET		2027
#define CR_NOT_IMPLEMENTED		2054
#define CR_NO_PREPARE_STMT		2030
#define CR_PARAMS_NOT_BOUND		2031
#define CR_INVALID_PARAMETER_NO	2034
#define CR_INVALID_BUFFER_USE	2035
#define CR_LOAD_DATA_LOCAL_INFILE_REJECTED 2068

#define MYSQLND_EE_FILENOTFOUND	 7890

#define UNKNOWN_SQLSTATE		"HY000"

#define MAX_CHARSET_LEN			32


#define TRANS_START_NO_OPT						0
#define TRANS_START_WITH_CONSISTENT_SNAPSHOT	1
#define TRANS_START_READ_WRITE					2
#define TRANS_START_READ_ONLY					4

#define TRANS_COR_NO_OPT		0
#define TRANS_COR_AND_CHAIN		1
#define TRANS_COR_AND_NO_CHAIN	2
#define TRANS_COR_RELEASE		4
#define TRANS_COR_NO_RELEASE	8

enum
{
	MYSQLND_FETCH_ASSOC = 1,
	MYSQLND_FETCH_NUM = 2,
	MYSQLND_FETCH_BOTH = 1|2
};

/* Follow libmysql convention */
typedef enum func_status
{
	PASS = 0,
	FAIL = 1
} enum_func_status;

typedef enum mysqlnd_query_type
{
	QUERY_UPSERT,
	QUERY_SELECT,
	QUERY_LOAD_LOCAL
} enum_mysqlnd_query_type;

typedef enum mysqlnd_res_type
{
	MYSQLND_RES_NORMAL = 1,
	MYSQLND_RES_PS_BUF,
	MYSQLND_RES_PS_UNBUF
} enum_mysqlnd_res_type;

typedef enum mysqlnd_send_query_type
{
	MYSQLND_SEND_QUERY_IMPLICIT = 0,
	MYSQLND_SEND_QUERY_EXPLICIT
} enum_mysqlnd_send_query_type;

typedef enum mysqlnd_reap_result_type
{
	MYSQLND_REAP_RESULT_IMPLICIT = 0,
	MYSQLND_REAP_RESULT_EXPLICIT
} enum_mysqlnd_reap_result_type;

typedef enum mysqlnd_send_execute_type
{
	MYSQLND_SEND_EXECUTE_IMPLICIT = 0,
	MYSQLND_SEND_EXECUTE_EXPLICIT
} enum_mysqlnd_send_execute_type;

typedef enum mysqlnd_parse_exec_response_type
{
	MYSQLND_PARSE_EXEC_RESPONSE_IMPLICIT = 0,
	MYSQLND_PARSE_EXEC_RESPONSE_IMPLICIT_NEXT_RESULT,
	MYSQLND_PARSE_EXEC_RESPONSE_IMPLICIT_OUT_VARIABLES,
	MYSQLND_PARSE_EXEC_RESPONSE_EXPLICIT,
} enum_mysqlnd_parse_exec_response_type;

typedef enum mysqlnd_client_option
{
	MYSQL_OPT_CONNECT_TIMEOUT,
	MYSQL_OPT_COMPRESS,
	MYSQL_OPT_NAMED_PIPE,
	MYSQL_INIT_COMMAND,
	MYSQL_READ_DEFAULT_FILE,
	MYSQL_READ_DEFAULT_GROUP,
	MYSQL_SET_CHARSET_DIR,
	MYSQL_SET_CHARSET_NAME,
	MYSQL_OPT_LOCAL_INFILE,
	MYSQL_OPT_PROTOCOL,
	MYSQL_SHARED_MEMORY_BASE_NAME,
	MYSQL_OPT_READ_TIMEOUT,
	MYSQL_OPT_WRITE_TIMEOUT,
	MYSQL_OPT_USE_RESULT,
	MYSQL_OPT_USE_REMOTE_CONNECTION,
	MYSQL_OPT_USE_EMBEDDED_CONNECTION,
	MYSQL_OPT_GUESS_CONNECTION,
	MYSQL_SET_CLIENT_IP,
	MYSQL_SECURE_AUTH,
	MYSQL_REPORT_DATA_TRUNCATION,
	MYSQL_OPT_RECONNECT,
	MYSQL_OPT_SSL_VERIFY_SERVER_CERT,
	MYSQL_PLUGIN_DIR,
	MYSQL_DEFAULT_AUTH,
	MYSQL_OPT_BIND,
	MYSQL_OPT_SSL_KEY,
	MYSQL_OPT_SSL_CERT,
	MYSQL_OPT_SSL_CA,
	MYSQL_OPT_SSL_CAPATH,
	MYSQL_OPT_SSL_CIPHER,
	MYSQL_OPT_SSL_CRL,
	MYSQL_OPT_SSL_CRLPATH,
	MYSQL_OPT_CONNECT_ATTR_RESET,
	MYSQL_OPT_CONNECT_ATTR_ADD,
	MYSQL_OPT_CONNECT_ATTR_DELETE,
	MYSQL_SERVER_PUBLIC_KEY,
	MYSQL_ENABLE_CLEARTEXT_PLUGIN,
	MYSQL_OPT_CAN_HANDLE_EXPIRED_PASSWORDS,
	MYSQL_OPT_SSL_ENFORCE,
	MYSQL_OPT_MAX_ALLOWED_PACKET,
	MYSQL_OPT_NET_BUFFER_LENGTH,
	MYSQL_OPT_TLS_VERSION,
	MYSQL_OPT_SSL_MODE,
	MYSQL_OPT_LOAD_DATA_LOCAL_DIR,
	MYSQLND_DEPRECATED_ENUM1 = 200,
	MYSQLND_OPT_INT_AND_FLOAT_NATIVE = 201,
	MYSQLND_OPT_NET_CMD_BUFFER_SIZE = 202,
	MYSQLND_OPT_NET_READ_BUFFER_SIZE = 203,
	MYSQLND_OPT_SSL_KEY = 204,
	MYSQLND_OPT_SSL_CERT = 205,
	MYSQLND_OPT_SSL_CA = 206,
	MYSQLND_OPT_SSL_CAPATH = 207,
	MYSQLND_OPT_SSL_CIPHER = 208,
	MYSQLND_OPT_SSL_PASSPHRASE = 209,
	MYSQLND_OPT_MAX_ALLOWED_PACKET = 210,
	MYSQLND_OPT_AUTH_PROTOCOL = 211
} enum_mysqlnd_client_option;

typedef enum mysqlnd_session_protocol_type
{
	MYSQL_PROTOCOL_DEFAULT = 0,
	MYSQL_PROTOCOL_TCP,		/* all, supported */
	MYSQL_PROTOCOL_SOCKET,	/* unix, supported */
	MYSQL_PROTOCOL_PIPE,	/* win32, not-supported */
	MYSQL_PROTOCOL_MEMORY,	/* win32, not-supported */
	MYSQL_PROTOCOL_LAST
} enum_mysqlnd_session_protocol_type;

typedef enum mysqlnd_field_types
{
	MYSQL_TYPE_DECIMAL	= 0,
	MYSQL_TYPE_TINY		= 1,
	MYSQL_TYPE_SHORT	= 2,
	MYSQL_TYPE_LONG		= 3,
	MYSQL_TYPE_FLOAT	= 4,
	MYSQL_TYPE_DOUBLE	= 5,
	MYSQL_TYPE_NULL		= 6,
	MYSQL_TYPE_TIMESTAMP= 7,
	MYSQL_TYPE_LONGLONG	= 8,
	MYSQL_TYPE_INT24	= 9,
	MYSQL_TYPE_DATE		= 10,
	MYSQL_TYPE_TIME		= 11,
	MYSQL_TYPE_DATETIME	= 12,
	MYSQL_TYPE_YEAR		= 13,
	MYSQL_TYPE_NEWDATE	= 14,
	MYSQL_TYPE_VARCHAR	= 15,
	MYSQL_TYPE_BIT		= 16,
	MYSQL_TYPE_JSON=245,
	MYSQL_TYPE_NEWDECIMAL=246,
	MYSQL_TYPE_ENUM=247,
	MYSQL_TYPE_SET=248,
	MYSQL_TYPE_TINY_BLOB=249,
	MYSQL_TYPE_MEDIUM_BLOB=250,
	MYSQL_TYPE_LONG_BLOB=251,
	MYSQL_TYPE_BLOB=252,
	MYSQL_TYPE_VAR_STRING=253,
	MYSQL_TYPE_STRING=254,
	MYSQL_TYPE_GEOMETRY=255
} enum_mysqlnd_field_types;

/* Please update this if there is a new type after MYSQL_TYPE_GEOMETRY */
#define MYSQL_TYPE_LAST		MYSQL_TYPE_GEOMETRY


typedef enum mysqlnd_server_option
{
	MYSQL_OPTION_MULTI_STATEMENTS_ON,
	MYSQL_OPTION_MULTI_STATEMENTS_OFF
} enum_mysqlnd_server_option;


#define FIELD_TYPE_DECIMAL		MYSQL_TYPE_DECIMAL
#define FIELD_TYPE_NEWDECIMAL	MYSQL_TYPE_NEWDECIMAL
#define FIELD_TYPE_TINY			MYSQL_TYPE_TINY
#define FIELD_TYPE_SHORT		MYSQL_TYPE_SHORT
#define FIELD_TYPE_LONG			MYSQL_TYPE_LONG
#define FIELD_TYPE_FLOAT		MYSQL_TYPE_FLOAT
#define FIELD_TYPE_DOUBLE		MYSQL_TYPE_DOUBLE
#define FIELD_TYPE_NULL			MYSQL_TYPE_NULL
#define FIELD_TYPE_TIMESTAMP	MYSQL_TYPE_TIMESTAMP
#define FIELD_TYPE_LONGLONG		MYSQL_TYPE_LONGLONG
#define FIELD_TYPE_INT24		MYSQL_TYPE_INT24
#define FIELD_TYPE_DATE			MYSQL_TYPE_DATE
#define FIELD_TYPE_TIME			MYSQL_TYPE_TIME
#define FIELD_TYPE_DATETIME		MYSQL_TYPE_DATETIME
#define FIELD_TYPE_YEAR			MYSQL_TYPE_YEAR
#define FIELD_TYPE_NEWDATE		MYSQL_TYPE_NEWDATE
#define FIELD_TYPE_ENUM			MYSQL_TYPE_ENUM
#define FIELD_TYPE_SET			MYSQL_TYPE_SET
#define FIELD_TYPE_JSON 		MYSQL_TYPE_JSON
#define FIELD_TYPE_TINY_BLOB	MYSQL_TYPE_TINY_BLOB
#define FIELD_TYPE_MEDIUM_BLOB	MYSQL_TYPE_MEDIUM_BLOB
#define FIELD_TYPE_LONG_BLOB	MYSQL_TYPE_LONG_BLOB
#define FIELD_TYPE_BLOB			MYSQL_TYPE_BLOB
#define FIELD_TYPE_VAR_STRING	MYSQL_TYPE_VAR_STRING
#define FIELD_TYPE_STRING		MYSQL_TYPE_STRING
#define FIELD_TYPE_CHAR			MYSQL_TYPE_TINY
#define FIELD_TYPE_INTERVAL		MYSQL_TYPE_ENUM
#define FIELD_TYPE_GEOMETRY		MYSQL_TYPE_GEOMETRY
#define FIELD_TYPE_BIT			MYSQL_TYPE_BIT

#define NOT_NULL_FLAG			    1
#define PRI_KEY_FLAG			    2
#define UNIQUE_KEY_FLAG			    4
#define MULTIPLE_KEY_FLAG		    8
#define BLOB_FLAG				   16
#define UNSIGNED_FLAG			   32
#define ZEROFILL_FLAG			   64
#define BINARY_FLAG				  128
#define ENUM_FLAG				  256
#define AUTO_INCREMENT_FLAG		  512
#define TIMESTAMP_FLAG			 1024
#define SET_FLAG				 2048
#define NO_DEFAULT_VALUE_FLAG	 4096
#define ON_UPDATE_NOW_FLAG		 8192
#define PART_KEY_FLAG			16384
#define GROUP_FLAG				32768
#define NUM_FLAG				32768

#define IS_PRI_KEY(n)	((n) & PRI_KEY_FLAG)
#define IS_NOT_NULL(n)	((n) & NOT_NULL_FLAG)
#define IS_BLOB(n)		((n) & BLOB_FLAG)
#define IS_NUM(t)		((t) <= FIELD_TYPE_INT24 || (t) == FIELD_TYPE_YEAR || (t) == FIELD_TYPE_NEWDECIMAL)


/*
		/-----> CONN_CLOSE  <---------------\
		|           ^                         \
		|           |                         \
	CONN_READY -> CONN_QUERY_SENT -> CONN_FETCHING_DATA
		^                                      |
		\-------------------------------------/
*/
typedef enum mysqlnd_connection_state
{
	CONN_ALLOCED = 0,
	CONN_READY = 1,
	CONN_QUERY_SENT = 2,
	CONN_SENDING_LOAD_DATA = 3,
	CONN_FETCHING_DATA = 4,
	CONN_NEXT_RESULT_PENDING = 5,
	CONN_QUIT_SENT = 6 /* object is "destroyed" at this stage */
} enum_mysqlnd_connection_state;


typedef enum mysqlnd_stmt_state
{
	MYSQLND_STMT_INITTED = 0,
	MYSQLND_STMT_PREPARED = 1,
	MYSQLND_STMT_EXECUTED = 2,
	MYSQLND_STMT_WAITING_USE_OR_STORE = 3,
	MYSQLND_STMT_USE_OR_STORE_CALLED = 4,
	MYSQLND_STMT_USER_FETCHING = 5/* fetch_row_buff or fetch_row_unbuf */
} enum_mysqlnd_stmt_state;


typedef enum param_bind_flags
{
	MYSQLND_PARAM_BIND_BLOB_USED = 1
} enum_param_bind_flags;


/* PS */
enum mysqlnd_stmt_attr
{
	STMT_ATTR_UPDATE_MAX_LENGTH,
	STMT_ATTR_CURSOR_TYPE,
	STMT_ATTR_PREFETCH_ROWS
};

enum myslqnd_cursor_type
{
	CURSOR_TYPE_NO_CURSOR= 0,
	CURSOR_TYPE_READ_ONLY= 1,
	CURSOR_TYPE_FOR_UPDATE= 2,
	CURSOR_TYPE_SCROLLABLE= 4
};

typedef enum mysqlnd_connection_close_type
{
	MYSQLND_CLOSE_EXPLICIT = 0,
	MYSQLND_CLOSE_IMPLICIT,
	MYSQLND_CLOSE_DISCONNECTED,
	MYSQLND_CLOSE_LAST	/* for checking, should always be last */
} enum_connection_close_type;


typedef enum mysqlnd_collected_stats
{
	STAT_BYTES_SENT,
	STAT_BYTES_RECEIVED,
	STAT_PACKETS_SENT,
	STAT_PACKETS_RECEIVED,
	STAT_PROTOCOL_OVERHEAD_IN,
	STAT_PROTOCOL_OVERHEAD_OUT,
	STAT_BYTES_RECEIVED_OK,
	STAT_BYTES_RECEIVED_EOF,
	STAT_BYTES_RECEIVED_RSET_HEADER,
	STAT_BYTES_RECEIVED_RSET_FIELD_META,
	STAT_BYTES_RECEIVED_RSET_ROW,
	STAT_BYTES_RECEIVED_PREPARE_RESPONSE,
	STAT_BYTES_RECEIVED_CHANGE_USER,
	STAT_PACKETS_SENT_CMD,
	STAT_PACKETS_RECEIVED_OK,
	STAT_PACKETS_RECEIVED_EOF,
	STAT_PACKETS_RECEIVED_RSET_HEADER,
	STAT_PACKETS_RECEIVED_RSET_FIELD_META,
	STAT_PACKETS_RECEIVED_RSET_ROW,
	STAT_PACKETS_RECEIVED_PREPARE_RESPONSE,
	STAT_PACKETS_RECEIVED_CHANGE_USER,
	STAT_RSET_QUERY,
	STAT_NON_RSET_QUERY,
	STAT_NO_INDEX_USED,
	STAT_BAD_INDEX_USED,
	STAT_QUERY_WAS_SLOW,
	STAT_BUFFERED_SETS,
	STAT_UNBUFFERED_SETS,
	STAT_PS_BUFFERED_SETS,
	STAT_PS_UNBUFFERED_SETS,
	STAT_FLUSHED_NORMAL_SETS,
	STAT_FLUSHED_PS_SETS,
	STAT_PS_PREPARED_NEVER_EXECUTED,
	STAT_PS_PREPARED_ONCE_USED,
	STAT_ROWS_FETCHED_FROM_SERVER_NORMAL,
	STAT_ROWS_FETCHED_FROM_SERVER_PS,
	STAT_ROWS_BUFFERED_FROM_CLIENT_NORMAL,
	STAT_ROWS_BUFFERED_FROM_CLIENT_PS,
	STAT_ROWS_FETCHED_FROM_CLIENT_NORMAL_BUF,
	STAT_ROWS_FETCHED_FROM_CLIENT_NORMAL_UNBUF,
	STAT_ROWS_FETCHED_FROM_CLIENT_PS_BUF,
	STAT_ROWS_FETCHED_FROM_CLIENT_PS_UNBUF,
	STAT_ROWS_FETCHED_FROM_CLIENT_PS_CURSOR,
	STAT_ROWS_AFFECTED_NORMAL,
	STAT_ROWS_AFFECTED_PS,
	STAT_ROWS_SKIPPED_NORMAL,
	STAT_ROWS_SKIPPED_PS,
	STAT_COPY_ON_WRITE_SAVED,
	STAT_COPY_ON_WRITE_PERFORMED,
	STAT_CMD_BUFFER_TOO_SMALL,
	STAT_CONNECT_SUCCESS,
	STAT_CONNECT_FAILURE,
	STAT_CONNECT_REUSED,
	STAT_RECONNECT,
	STAT_PCONNECT_SUCCESS,
	STAT_OPENED_CONNECTIONS,
	STAT_OPENED_PERSISTENT_CONNECTIONS,
	STAT_CLOSE_EXPLICIT,
	STAT_CLOSE_IMPLICIT,
	STAT_CLOSE_DISCONNECT,
	STAT_CLOSE_IN_MIDDLE,
	STAT_FREE_RESULT_EXPLICIT,
	STAT_FREE_RESULT_IMPLICIT,
	STAT_STMT_CLOSE_EXPLICIT,
	STAT_STMT_CLOSE_IMPLICIT,
	STAT_MEM_EMALLOC_COUNT,
	STAT_MEM_EMALLOC_AMOUNT,
	STAT_MEM_ECALLOC_COUNT,
	STAT_MEM_ECALLOC_AMOUNT,
	STAT_MEM_EREALLOC_COUNT,
	STAT_MEM_EREALLOC_AMOUNT,
	STAT_MEM_EFREE_COUNT,
	STAT_MEM_EFREE_AMOUNT,
	STAT_MEM_MALLOC_COUNT,
	STAT_MEM_MALLOC_AMOUNT,
	STAT_MEM_CALLOC_COUNT,
	STAT_MEM_CALLOC_AMOUNT,
	STAT_MEM_REALLOC_COUNT,
	STAT_MEM_REALLOC_AMOUNT,
	STAT_MEM_FREE_COUNT,
	STAT_MEM_FREE_AMOUNT,
	STAT_MEM_ESTRNDUP_COUNT,
	STAT_MEM_STRNDUP_COUNT,
	STAT_MEM_ESTRDUP_COUNT,
	STAT_MEM_STRDUP_COUNT,
	STAT_MEM_EDUP_COUNT,
	STAT_MEM_DUP_COUNT,
	STAT_TEXT_TYPE_FETCHED_NULL,
	STAT_TEXT_TYPE_FETCHED_BIT,
	STAT_TEXT_TYPE_FETCHED_INT8,
	STAT_TEXT_TYPE_FETCHED_INT16,
	STAT_TEXT_TYPE_FETCHED_INT24,
	STAT_TEXT_TYPE_FETCHED_INT32,
	STAT_TEXT_TYPE_FETCHED_INT64,
	STAT_TEXT_TYPE_FETCHED_DECIMAL,
	STAT_TEXT_TYPE_FETCHED_FLOAT,
	STAT_TEXT_TYPE_FETCHED_DOUBLE,
	STAT_TEXT_TYPE_FETCHED_DATE,
	STAT_TEXT_TYPE_FETCHED_YEAR,
	STAT_TEXT_TYPE_FETCHED_TIME,
	STAT_TEXT_TYPE_FETCHED_DATETIME,
	STAT_TEXT_TYPE_FETCHED_TIMESTAMP,
	STAT_TEXT_TYPE_FETCHED_STRING,
	STAT_TEXT_TYPE_FETCHED_JSON,
	STAT_TEXT_TYPE_FETCHED_BLOB,
	STAT_TEXT_TYPE_FETCHED_ENUM,
	STAT_TEXT_TYPE_FETCHED_SET,
	STAT_TEXT_TYPE_FETCHED_GEOMETRY,
	STAT_TEXT_TYPE_FETCHED_OTHER,
	STAT_BINARY_TYPE_FETCHED_NULL,
	STAT_BINARY_TYPE_FETCHED_BIT,
	STAT_BINARY_TYPE_FETCHED_INT8,
	STAT_BINARY_TYPE_FETCHED_INT16,
	STAT_BINARY_TYPE_FETCHED_INT24,
	STAT_BINARY_TYPE_FETCHED_INT32,
	STAT_BINARY_TYPE_FETCHED_INT64,
	STAT_BINARY_TYPE_FETCHED_DECIMAL,
	STAT_BINARY_TYPE_FETCHED_FLOAT,
	STAT_BINARY_TYPE_FETCHED_DOUBLE,
	STAT_BINARY_TYPE_FETCHED_DATE,
	STAT_BINARY_TYPE_FETCHED_YEAR,
	STAT_BINARY_TYPE_FETCHED_TIME,
	STAT_BINARY_TYPE_FETCHED_DATETIME,
	STAT_BINARY_TYPE_FETCHED_TIMESTAMP,
	STAT_BINARY_TYPE_FETCHED_STRING,
	STAT_BINARY_TYPE_FETCHED_BLOB,
	STAT_BINARY_TYPE_FETCHED_ENUM,
	STAT_BINARY_TYPE_FETCHED_SET,
	STAT_BINARY_TYPE_FETCHED_GEOMETRY,
	STAT_BINARY_TYPE_FETCHED_OTHER,
	STAT_INIT_COMMAND_EXECUTED_COUNT,
	STAT_INIT_COMMAND_FAILED_COUNT,
	STAT_COM_QUIT,
	STAT_COM_INIT_DB,
	STAT_COM_QUERY,
	STAT_COM_FIELD_LIST,
	STAT_COM_CREATE_DB,
	STAT_COM_DROP_DB,
	STAT_COM_REFRESH,
	STAT_COM_SHUTDOWN,
	STAT_COM_STATISTICS,
	STAT_COM_PROCESS_INFO,
	STAT_COM_CONNECT,
	STAT_COM_PROCESS_KILL,
	STAT_COM_DEBUG,
	STAT_COM_PING,
	STAT_COM_TIME,
	STAT_COM_DELAYED_INSERT,
	STAT_COM_CHANGE_USER,
	STAT_COM_BINLOG_DUMP,
	STAT_COM_TABLE_DUMP,
	STAT_COM_CONNECT_OUT,
	STAT_COM_REGISTER_SLAVE,
	STAT_COM_STMT_PREPARE,
	STAT_COM_STMT_EXECUTE,
	STAT_COM_STMT_SEND_LONG_DATA,
	STAT_COM_STMT_CLOSE,
	STAT_COM_STMT_RESET,
	STAT_COM_SET_OPTION,
	STAT_COM_STMT_FETCH,
	STAT_COM_DAEMON,
	STAT_BYTES_RECEIVED_PURE_DATA_TEXT,
	STAT_BYTES_RECEIVED_PURE_DATA_PS,
	STAT_LAST /* Should be always the last */
} enum_mysqlnd_collected_stats;


/* Enums */
enum mysqlnd_packet_type
{
	PROT_GREET_PACKET= 0,
	PROT_AUTH_PACKET,
	PROT_AUTH_RESP_PACKET,
	PROT_CHANGE_AUTH_RESP_PACKET,
	PROT_OK_PACKET,
	PROT_EOF_PACKET,
	PROT_CMD_PACKET,
	PROT_RSET_HEADER_PACKET,
	PROT_RSET_FLD_PACKET,
	PROT_ROW_PACKET,
	PROT_STATS_PACKET,
	PROT_PREPARE_RESP_PACKET,
	PROT_CHG_USER_RESP_PACKET,
	PROT_SHA256_PK_REQUEST_PACKET,
	PROT_SHA256_PK_REQUEST_RESPONSE_PACKET,
	PROT_CACHED_SHA2_RESULT_PACKET,
	PROT_LAST /* should always be last */
};


/*
  After adding new elements please update
  `mysqlnd_command_to_text` in mysqlnd_wireprotocol.c
*/
enum php_mysqlnd_server_command
{
	COM_SLEEP = 0,
	COM_QUIT,
	COM_INIT_DB,
	COM_QUERY,
	COM_FIELD_LIST,
	COM_CREATE_DB,
	COM_DROP_DB,
	COM_REFRESH,
	COM_SHUTDOWN,
	COM_STATISTICS,
	COM_PROCESS_INFO,
	COM_CONNECT,
	COM_PROCESS_KILL,
	COM_DEBUG,
	COM_PING,
	COM_TIME = 15,
	COM_DELAYED_INSERT,
	COM_CHANGE_USER,
	COM_BINLOG_DUMP,
	COM_TABLE_DUMP,
	COM_CONNECT_OUT = 20,
	COM_REGISTER_SLAVE,
	COM_STMT_PREPARE = 22,
	COM_STMT_EXECUTE = 23,
	COM_STMT_SEND_LONG_DATA = 24,
	COM_STMT_CLOSE = 25,
	COM_STMT_RESET = 26,
	COM_SET_OPTION = 27,
	COM_STMT_FETCH = 28,
	COM_DAEMON = 29,
	COM_BINLOG_DUMP_GTID = 30,
	COM_RESET_CONNECTION = 31,
	COM_STMT_EXECUTE_BATCH = 32,
	COM_END,
	/* Here follow own, non-protocol, commands */
	COM_REAP_RESULT=240,	/* own command */
	COM_ENABLE_SSL,			/* own command */
	COM_HANDSHAKE,			/* own command */
};


#define MYSQLND_DEFAULT_PREFETCH_ROWS (zend_ulong) 1

#define MYSQLND_REFRESH_GRANT		1	/* Refresh grant tables */
#define MYSQLND_REFRESH_LOG			2	/* Start on new log file */
#define MYSQLND_REFRESH_TABLES		4	/* close all tables */
#define MYSQLND_REFRESH_HOSTS		8	/* Flush host cache */
#define MYSQLND_REFRESH_STATUS		16	/* Flush status variables */
#define MYSQLND_REFRESH_THREADS		32	/* Flush thread cache */
#define MYSQLND_REFRESH_REPLICA		64	/* Reset master info and restart replica */
#define MYSQLND_REFRESH_SLAVE		MYSQLND_REFRESH_REPLICA	/* temporarily for backward compatibility */
#define MYSQLND_REFRESH_MASTER		128	/* Remove all bin logs in the index */
#define MYSQLND_REFRESH_BACKUP_LOG	0x200000L


#define MYSQLND_CLIENT_NO_FLAG				0

#endif	/* MYSQLND_ENUM_N_DEF_H */
