/* Generated by re2c 2.0.3 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))


static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API zend_result zend_lex_tstring(zval *zv, unsigned char *ident)
{
	unsigned char *end = ident;
	while ((*end >= 'a' && *end <= 'z') || (*end >= 'A' && *end <= 'Z') || *end == '_') {
		end++;
	}

	size_t length = end - ident;
	if (length == 0) {
		ZEND_ASSERT(ident[0] == '<' && ident[1] == '?' && ident[2] == '=');
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, (char *) ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char *) ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		file_handle->in_list = 1;
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	file_handle->in_list = 1;

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_copy(file_handle->filename);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		zend_init_static_variables_map_ptr(op_array);
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, ZSTR_VAL(file_handle->filename));
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, ZSTR_VAL(file_handle->filename));
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, zend_string *filename) {
	zval code_zv;
	bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zend_string *filename)
{
	zend_file_handle file_handle;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	zend_stream_init_filename_ex(&file_handle, filename);

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(filename);
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, zend_string *filename)
{
	char *buf;
	size_t size, old_len;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);
	zend_set_compiled_filename(filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_string *filename_str;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	filename_str = zend_string_init(filename, strlen(filename), 0);
	zend_prepare_string_for_scanning(&tmp, filename_str);
	zend_string_release(filename_str);
	BEGIN(ST_IN_SCRIPTING);
	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_destroy_file_handle(&file_handle);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zend_string *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *filename)
{
	zend_lex_state original_lex_state;
	zval str_zv;
	zend_string *filename_str = zend_string_init(filename, strlen(filename), 0);
	ZVAL_STR_COPY(&str_zv, str);
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&str_zv, filename_str);
	zend_string_release(filename_str);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&str_zv);
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, bool using_spaces,
	bool newline_at_start, bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end(void)
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  18,   2,   0,   0,   2,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 18,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			236, 236, 204, 204, 204, 204, 204, 204, 
			140, 140,   0,   0,   0,   0,   0,   0, 
			  0, 136, 136, 136, 136, 136, 136,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  0, 136, 136, 136, 136, 136, 136,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   0, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy4;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy2;
		case ' ':
		case '!':	goto yy7;
		case '"':	goto yy9;
		case '#':	goto yy11;
		case '$':	goto yy13;
		case '%':	goto yy14;
		case '&':	goto yy15;
		case '\'':	goto yy17;
		case '(':	goto yy19;
		case ')':
		case ']':	goto yy21;
		case '*':	goto yy23;
		case '+':	goto yy24;
		case ',':
		case ';':
		case '@':
		case '~':	goto yy25;
		case '-':	goto yy26;
		case '.':	goto yy27;
		case '/':	goto yy28;
		case '0':	goto yy29;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy31;
		case ':':	goto yy33;
		case '<':	goto yy34;
		case '=':	goto yy35;
		case '>':	goto yy36;
		case '?':	goto yy37;
		case 'A':
		case 'a':	goto yy38;
		case 'B':
		case 'b':	goto yy40;
		case 'C':
		case 'c':	goto yy41;
		case 'D':
		case 'd':	goto yy42;
		case 'E':
		case 'e':	goto yy43;
		case 'F':
		case 'f':	goto yy44;
		case 'G':
		case 'g':	goto yy45;
		case 'I':
		case 'i':	goto yy48;
		case 'L':
		case 'l':	goto yy49;
		case 'M':
		case 'm':	goto yy50;
		case 'N':
		case 'n':	goto yy51;
		case 'O':
		case 'o':	goto yy52;
		case 'P':
		case 'p':	goto yy53;
		case 'R':
		case 'r':	goto yy54;
		case 'S':
		case 's':	goto yy55;
		case 'T':
		case 't':	goto yy56;
		case 'U':
		case 'u':	goto yy57;
		case 'V':
		case 'v':	goto yy58;
		case 'W':
		case 'w':	goto yy59;
		case 'X':
		case 'x':	goto yy60;
		case 'Y':
		case 'y':	goto yy61;
		case '[':	goto yy62;
		case '\\':	goto yy63;
		case '^':	goto yy65;
		case '_':	goto yy66;
		case '`':	goto yy67;
		case '{':	goto yy69;
		case '|':	goto yy71;
		case '}':	goto yy72;
		default:	goto yy46;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy74;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '[') goto yy76;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy8;
			if (yych <= 'Z') goto yy78;
			if (yych <= '^') goto yy8;
			goto yy78;
		} else {
			if (yych <= '`') goto yy8;
			if (yych <= 'z') goto yy78;
			if (yych <= 0x7F) goto yy8;
			goto yy78;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy81;
		goto yy8;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy83;
		}
		if (yych <= '&') {
			if (yych == '$') goto yy86;
			if (yych >= '&') goto yy88;
		} else {
			if (yych <= '.') {
				if (yych >= '.') goto yy90;
			} else {
				if (yych == '=') goto yy91;
			}
		}
yy16:
		YYDEBUG(16, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AMPERSAND_NOT_FOLLOWED_BY_VAR_OR_VARARG);
}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy94;
					if (yych >= ' ') goto yy94;
				} else {
					if (yych <= '@') goto yy20;
					if (yych != 'C') goto yy94;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy94;
					if (yych >= 'I') goto yy94;
				} else {
					if (yych == 'O') goto yy94;
					if (yych >= 'R') goto yy94;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy94;
					if (yych >= 'a') goto yy94;
				} else {
					if (yych == 'd') goto yy94;
					if (yych >= 'f') goto yy94;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy94;
					if (yych >= 'o') goto yy94;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy94;
					} else {
						if (yych == 'u') goto yy94;
					}
				}
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(22, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy104;
		if (yych == '=') goto yy106;
		goto yy8;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy108;
		if (yych == '=') goto yy110;
		goto yy8;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		goto yy8;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy112;
			goto yy8;
		} else {
			if (yych <= '=') goto yy114;
			if (yych <= '>') goto yy116;
			goto yy8;
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy118;
			goto yy8;
		} else {
			if (yych <= '9') goto yy119;
			if (yych == '=') goto yy122;
			goto yy8;
		}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy124;
			goto yy8;
		} else {
			if (yych <= '/') goto yy126;
			if (yych == '=') goto yy127;
			goto yy8;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'N') {
				if (yych == 'B') goto yy130;
				goto yy32;
			} else {
				if (yych <= 'O') goto yy132;
				if (yych <= 'W') goto yy32;
				goto yy133;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy130;
				goto yy32;
			} else {
				if (yych <= 'o') goto yy132;
				if (yych == 'x') goto yy133;
				goto yy32;
			}
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	bool is_octal = lnum[0] == '0';
	bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy31;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy129;
			if (yych <= 'D') goto yy30;
			goto yy131;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy30;
				goto yy134;
			} else {
				if (yych == 'e') goto yy131;
				goto yy30;
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy135;
		goto yy8;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy8;
		if (yych <= '<') goto yy137;
		if (yych <= '=') goto yy139;
		if (yych <= '>') goto yy141;
		goto yy8;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy142;
		if (yych <= '>') goto yy144;
		goto yy8;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy146;
		if (yych <= '>') goto yy148;
		goto yy8;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy150;
			goto yy8;
		} else {
			if (yych <= '>') goto yy151;
			if (yych <= '?') goto yy153;
			goto yy8;
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy155;
				goto yy47;
			} else {
				if (yych <= 'N') goto yy156;
				if (yych <= 'Q') goto yy47;
				if (yych <= 'R') goto yy157;
				goto yy158;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy155;
				if (yych <= 'm') goto yy47;
				goto yy156;
			} else {
				if (yych <= 'q') goto yy47;
				if (yych <= 'r') goto yy157;
				if (yych <= 's') goto yy158;
				goto yy47;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy47;
				goto yy9;
			} else {
				if (yych == '\'') goto yy17;
				goto yy47;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy161;
				if (yych <= 'Q') goto yy47;
				goto yy162;
			} else {
				if (yych == 'r') goto yy162;
				goto yy47;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy163;
				goto yy47;
			} else {
				if (yych <= 'L') goto yy164;
				if (yych <= 'N') goto yy47;
				goto yy165;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy163;
				goto yy47;
			} else {
				if (yych <= 'l') goto yy164;
				if (yych == 'o') goto yy165;
				goto yy47;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy166;
				goto yy47;
			} else {
				if (yych <= 'I') goto yy167;
				if (yych <= 'N') goto yy47;
				goto yy168;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy166;
				goto yy47;
			} else {
				if (yych <= 'i') goto yy167;
				if (yych == 'o') goto yy168;
				goto yy47;
			}
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy170;
		case 'L':
		case 'l':	goto yy171;
		case 'M':
		case 'm':	goto yy172;
		case 'N':
		case 'n':	goto yy173;
		case 'V':
		case 'v':	goto yy174;
		case 'X':
		case 'x':	goto yy175;
		default:	goto yy47;
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy176;
				goto yy47;
			} else {
				if (yych <= 'N') goto yy177;
				if (yych <= 'O') goto yy179;
				if (yych <= 'T') goto yy47;
				goto yy180;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy176;
				if (yych <= 'm') goto yy47;
				goto yy177;
			} else {
				if (yych <= 'o') goto yy179;
				if (yych == 'u') goto yy180;
				goto yy47;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy181;
			if (yych <= 'N') goto yy47;
			goto yy182;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy47;
				goto yy181;
			} else {
				if (yych == 'o') goto yy182;
				goto yy47;
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy47:
		YYDEBUG(47, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
		goto yy39;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy183;
				goto yy47;
			} else {
				if (yych <= 'M') goto yy185;
				if (yych <= 'N') goto yy186;
				if (yych <= 'R') goto yy47;
				goto yy187;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy183;
				if (yych <= 'l') goto yy47;
				goto yy185;
			} else {
				if (yych <= 'n') goto yy186;
				if (yych == 's') goto yy187;
				goto yy47;
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy188;
		if (yych == 'i') goto yy188;
		goto yy47;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy189;
		if (yych == 'a') goto yy189;
		goto yy47;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy190;
			if (yych <= 'D') goto yy47;
			goto yy191;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy190;
			} else {
				if (yych == 'e') goto yy191;
				goto yy47;
			}
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy192;
		if (yych == 'r') goto yy192;
		goto yy47;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy194;
			if (yych <= 'T') goto yy47;
			goto yy195;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy47;
				goto yy194;
			} else {
				if (yych == 'u') goto yy195;
				goto yy47;
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy196;
		if (yych == 'e') goto yy196;
		goto yy47;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy197;
			if (yych <= 'V') goto yy47;
			goto yy198;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy47;
				goto yy197;
			} else {
				if (yych == 'w') goto yy198;
				goto yy47;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy199;
			if (yych <= 'Q') goto yy47;
			goto yy200;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy47;
				goto yy199;
			} else {
				if (yych == 'r') goto yy200;
				goto yy47;
			}
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy201;
			if (yych <= 'R') goto yy47;
			goto yy202;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy47;
				goto yy201;
			} else {
				if (yych == 's') goto yy202;
				goto yy47;
			}
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy203;
		if (yych == 'a') goto yy203;
		goto yy47;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy204;
		if (yych == 'h') goto yy204;
		goto yy47;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy205;
		if (yych == 'o') goto yy205;
		goto yy47;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy206;
		if (yych == 'i') goto yy206;
		goto yy47;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		goto yy20;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy64;
			if (yych <= 'Z') goto yy207;
			if (yych >= '_') goto yy207;
		} else {
			if (yych <= '`') goto yy64;
			if (yych <= 'z') goto yy207;
			if (yych >= 0x80) goto yy207;
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy210;
		goto yy8;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy212;
		goto yy47;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy213;
		if (yych == '|') goto yy215;
		goto yy8;
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy217;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy78;
			} else {
				if (yych <= '@') goto yy80;
				if (yych <= 'Z') goto yy78;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy78;
			} else {
				if (yych <= 'z') goto yy78;
				if (yych >= 0x80) goto yy78;
			}
		}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy83;
		}
		if (yych == '$') goto yy86;
		if (yych == '.') goto yy90;
yy85:
		YYDEBUG(85, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 46) {
			if (yyaccept <= 23) {
				if (yyaccept <= 11) {
					if (yyaccept <= 5) {
						if (yyaccept <= 2) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy16;
								} else {
									goto yy20;
								}
							} else {
								goto yy8;
							}
						} else {
							if (yyaccept <= 4) {
								if (yyaccept == 3) {
									goto yy30;
								} else {
									goto yy39;
								}
							} else {
								goto yy121;
							}
						}
					} else {
						if (yyaccept <= 8) {
							if (yyaccept <= 7) {
								if (yyaccept == 6) {
									goto yy125;
								} else {
									goto yy138;
								}
							} else {
								goto yy159;
							}
						} else {
							if (yyaccept <= 10) {
								if (yyaccept == 9) {
									goto yy169;
								} else {
									goto yy178;
								}
							} else {
								goto yy184;
							}
						}
					}
				} else {
					if (yyaccept <= 17) {
						if (yyaccept <= 14) {
							if (yyaccept <= 13) {
								if (yyaccept == 12) {
									goto yy193;
								} else {
									goto yy209;
								}
							} else {
								goto yy238;
							}
						} else {
							if (yyaccept <= 16) {
								if (yyaccept == 15) {
									goto yy244;
								} else {
									goto yy247;
								}
							} else {
								goto yy266;
							}
						}
					} else {
						if (yyaccept <= 20) {
							if (yyaccept <= 19) {
								if (yyaccept == 18) {
									goto yy270;
								} else {
									goto yy282;
								}
							} else {
								goto yy293;
							}
						} else {
							if (yyaccept <= 22) {
								if (yyaccept == 21) {
									goto yy306;
								} else {
									goto yy318;
								}
							} else {
								goto yy321;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 35) {
					if (yyaccept <= 29) {
						if (yyaccept <= 26) {
							if (yyaccept <= 25) {
								if (yyaccept == 24) {
									goto yy323;
								} else {
									goto yy326;
								}
							} else {
								goto yy358;
							}
						} else {
							if (yyaccept <= 28) {
								if (yyaccept == 27) {
									goto yy367;
								} else {
									goto yy369;
								}
							} else {
								goto yy378;
							}
						}
					} else {
						if (yyaccept <= 32) {
							if (yyaccept <= 31) {
								if (yyaccept == 30) {
									goto yy380;
								} else {
									goto yy387;
								}
							} else {
								goto yy394;
							}
						} else {
							if (yyaccept <= 34) {
								if (yyaccept == 33) {
									goto yy444;
								} else {
									goto yy446;
								}
							} else {
								goto yy449;
							}
						}
					}
				} else {
					if (yyaccept <= 41) {
						if (yyaccept <= 38) {
							if (yyaccept <= 37) {
								if (yyaccept == 36) {
									goto yy451;
								} else {
									goto yy453;
								}
							} else {
								goto yy455;
							}
						} else {
							if (yyaccept <= 40) {
								if (yyaccept == 39) {
									goto yy461;
								} else {
									goto yy465;
								}
							} else {
								goto yy472;
							}
						}
					} else {
						if (yyaccept <= 44) {
							if (yyaccept <= 43) {
								if (yyaccept == 42) {
									goto yy482;
								} else {
									goto yy484;
								}
							} else {
								goto yy487;
							}
						} else {
							if (yyaccept == 45) {
								goto yy497;
							} else {
								goto yy499;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 69) {
				if (yyaccept <= 58) {
					if (yyaccept <= 52) {
						if (yyaccept <= 49) {
							if (yyaccept <= 48) {
								if (yyaccept == 47) {
									goto yy501;
								} else {
									goto yy503;
								}
							} else {
								goto yy505;
							}
						} else {
							if (yyaccept <= 51) {
								if (yyaccept == 50) {
									goto yy540;
								} else {
									goto yy543;
								}
							} else {
								goto yy547;
							}
						}
					} else {
						if (yyaccept <= 55) {
							if (yyaccept <= 54) {
								if (yyaccept == 53) {
									goto yy555;
								} else {
									goto yy565;
								}
							} else {
								goto yy569;
							}
						} else {
							if (yyaccept <= 57) {
								if (yyaccept == 56) {
									goto yy571;
								} else {
									goto yy573;
								}
							} else {
								goto yy601;
							}
						}
					}
				} else {
					if (yyaccept <= 64) {
						if (yyaccept <= 61) {
							if (yyaccept <= 60) {
								if (yyaccept == 59) {
									goto yy603;
								} else {
									goto yy611;
								}
							} else {
								goto yy613;
							}
						} else {
							if (yyaccept <= 63) {
								if (yyaccept == 62) {
									goto yy615;
								} else {
									goto yy619;
								}
							} else {
								goto yy625;
							}
						}
					} else {
						if (yyaccept <= 67) {
							if (yyaccept <= 66) {
								if (yyaccept == 65) {
									goto yy629;
								} else {
									goto yy633;
								}
							} else {
								goto yy646;
							}
						} else {
							if (yyaccept == 68) {
								goto yy648;
							} else {
								goto yy650;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 81) {
					if (yyaccept <= 75) {
						if (yyaccept <= 72) {
							if (yyaccept <= 71) {
								if (yyaccept == 70) {
									goto yy655;
								} else {
									goto yy659;
								}
							} else {
								goto yy668;
							}
						} else {
							if (yyaccept <= 74) {
								if (yyaccept == 73) {
									goto yy673;
								} else {
									goto yy677;
								}
							} else {
								goto yy684;
							}
						}
					} else {
						if (yyaccept <= 78) {
							if (yyaccept <= 77) {
								if (yyaccept == 76) {
									goto yy691;
								} else {
									goto yy693;
								}
							} else {
								goto yy695;
							}
						} else {
							if (yyaccept <= 80) {
								if (yyaccept == 79) {
									goto yy697;
								} else {
									goto yy701;
								}
							} else {
								goto yy707;
							}
						}
					}
				} else {
					if (yyaccept <= 87) {
						if (yyaccept <= 84) {
							if (yyaccept <= 83) {
								if (yyaccept == 82) {
									goto yy709;
								} else {
									goto yy711;
								}
							} else {
								goto yy715;
							}
						} else {
							if (yyaccept <= 86) {
								if (yyaccept == 85) {
									goto yy718;
								} else {
									goto yy725;
								}
							} else {
								goto yy732;
							}
						}
					} else {
						if (yyaccept <= 90) {
							if (yyaccept <= 89) {
								if (yyaccept == 88) {
									goto yy743;
								} else {
									goto yy745;
								}
							} else {
								goto yy747;
							}
						} else {
							if (yyaccept == 91) {
								goto yy753;
							} else {
								goto yy756;
							}
						}
					}
				}
			}
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(1);
	RETURN_TOKEN(T_AMPERSAND_FOLLOWED_BY_VAR_OR_VARARG);
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy219;
		goto yy85;
yy91:
		YYDEBUG(91, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy94:
		YYDEBUG(94, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy93;
					if (yych <= 0x1F) goto yy85;
					goto yy93;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy85;
					} else {
						if (yych <= 'B') goto yy96;
						if (yych <= 'C') goto yy85;
						goto yy97;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy98;
					if (yych <= 'H') goto yy85;
					goto yy99;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy85;
						goto yy100;
					} else {
						if (yych <= 'Q') goto yy85;
						if (yych <= 'R') goto yy101;
						goto yy102;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy103;
					if (yych <= '`') goto yy85;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy96;
						goto yy85;
					} else {
						if (yych <= 'd') goto yy97;
						if (yych <= 'e') goto yy85;
						goto yy98;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy85;
						goto yy99;
					} else {
						if (yych == 'o') goto yy100;
						goto yy85;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy101;
						goto yy102;
					} else {
						if (yych == 'u') goto yy103;
						goto yy85;
					}
				}
			}
		}
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy220;
		if (yych == 'r') goto yy220;
		goto yy85;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy221;
			if (yych <= 'N') goto yy85;
			goto yy222;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy85;
				goto yy221;
			} else {
				if (yych == 'o') goto yy222;
				goto yy85;
			}
		}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy223;
		if (yych == 'o') goto yy223;
		goto yy85;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy224;
		if (yych == 'l') goto yy224;
		goto yy85;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy225;
		if (yych == 'n') goto yy225;
		goto yy85;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy226;
		if (yych == 'b') goto yy226;
		goto yy85;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy227;
		if (yych == 'e') goto yy227;
		goto yy85;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy228;
		if (yych == 't') goto yy228;
		goto yy85;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy229;
		if (yych == 'n') goto yy229;
		goto yy85;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy230;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy232;
		goto yy85;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy120:
		YYDEBUG(120, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy121;
			if (yych <= '9') goto yy119;
			if (yych >= 'E') goto yy131;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy234;
			} else {
				if (yych == 'e') goto yy131;
			}
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy235;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy126:
		YYDEBUG(126, *YYCURSOR);
		++YYCURSOR;
		goto yy12;
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy121;
		goto yy120;
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy236;
		}
		goto yy85;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy239;
			goto yy85;
		} else {
			if (yych <= '-') goto yy239;
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy240;
			goto yy85;
		}
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy242;
		}
		goto yy85;
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy245;
		}
		goto yy85;
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy31;
		}
		goto yy85;
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy138;
		if (yych <= '<') goto yy248;
		if (yych <= '=') goto yy250;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy252;
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
		goto yy75;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy254;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy256;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy258;
		goto yy85;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy260;
		if (yych == '\r') goto yy261;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy262;
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy264;
		if (yych == 's') goto yy264;
		goto yy47;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy265;
		if (yych == 'd') goto yy265;
		goto yy47;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy267;
		if (yych == 'r') goto yy267;
		goto yy47;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy268;
			if (yych <= '^') goto yy85;
			goto yy268;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy268;
			if (yych <= 0x7F) goto yy85;
			goto yy268;
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy271;
		goto yy85;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy272;
		if (yych == 'e') goto yy272;
		goto yy47;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy47;
				goto yy273;
			} else {
				if (yych <= 'R') goto yy47;
				if (yych <= 'S') goto yy274;
				goto yy275;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy273;
				goto yy47;
			} else {
				if (yych <= 's') goto yy274;
				if (yych <= 't') goto yy275;
				goto yy47;
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy276;
			if (yych <= 'N') goto yy47;
			goto yy277;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy276;
			} else {
				if (yych == 'o') goto yy277;
				goto yy47;
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy278;
		if (yych == 'n') goto yy278;
		goto yy47;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy279;
			if (yych <= 'E') goto yy47;
			goto yy280;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy47;
				goto yy279;
			} else {
				if (yych == 'f') goto yy280;
				goto yy47;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy281;
		if (yych == 'e') goto yy281;
		goto yy47;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy283;
		if (yych == 'h') goto yy283;
		goto yy47;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy284;
		if (yych == 's') goto yy284;
		goto yy47;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy285;
		if (yych == 'p') goto yy285;
		goto yy47;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'D') goto yy286;
			if (yych <= 'T') goto yy47;
			goto yy287;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy47;
				goto yy286;
			} else {
				if (yych == 'u') goto yy287;
				goto yy47;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy288;
		if (yych == 'a') goto yy288;
		goto yy47;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy289;
			if (yych <= 'S') goto yy47;
			goto yy290;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy289;
			} else {
				if (yych == 't') goto yy290;
				goto yy47;
			}
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy291;
		if (yych == 'n') goto yy291;
		goto yy47;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy292;
		if (yych == 'r') goto yy292;
		goto yy47;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy294;
		if (yych == 'n') goto yy294;
		goto yy47;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy295;
		if (yych == 'o') goto yy295;
		goto yy47;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy296;
		if (yych == 't') goto yy296;
		goto yy47;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy297;
		if (yych == 'p') goto yy297;
		goto yy47;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy47;
				goto yy298;
			} else {
				if (yych <= 'R') goto yy47;
				if (yych <= 'S') goto yy299;
				goto yy300;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy298;
				goto yy47;
			} else {
				if (yych <= 's') goto yy299;
				if (yych <= 't') goto yy300;
				goto yy47;
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy301;
		if (yych == 's') goto yy301;
		goto yy47;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy302;
		if (yych == 's') goto yy302;
		goto yy47;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy303;
		if (yych == 't') goto yy303;
		goto yy47;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy304;
		if (yych == 'm') goto yy304;
		goto yy47;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy305;
		if (yych == 'w') goto yy305;
		goto yy47;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy307;
			if (yych <= 'N') goto yy47;
			goto yy308;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy307;
			} else {
				if (yych == 'o') goto yy308;
				goto yy47;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy309;
		if (yych == 'b') goto yy309;
		goto yy47;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'P') {
				if (yych == 'A') goto yy310;
				goto yy47;
			} else {
				if (yych <= 'Q') goto yy311;
				if (yych <= 'S') goto yy47;
				goto yy312;
			}
		} else {
			if (yych <= 'p') {
				if (yych == 'a') goto yy310;
				goto yy47;
			} else {
				if (yych <= 'q') goto yy311;
				if (yych == 't') goto yy312;
				goto yy47;
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy313;
		if (yych == 'a') goto yy313;
		goto yy47;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy314;
		if (yych == 'i') goto yy314;
		goto yy47;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy315;
		if (yych == 'r') goto yy315;
		goto yy47;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy316;
			if (yych <= 'X') goto yy47;
			goto yy317;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy316;
			} else {
				if (yych == 'y') goto yy317;
				goto yy47;
			}
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy319;
		if (yych == 's') goto yy319;
		goto yy47;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy320;
		if (yych == 'e') goto yy320;
		goto yy47;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy322;
		if (yych == 'r') goto yy322;
		goto yy47;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy324;
		if (yych == 'i') goto yy324;
		goto yy47;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy325;
		if (yych == 'r') goto yy325;
		goto yy47;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy327;
		if (yych == 'e') goto yy327;
		goto yy47;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy209;
				if (yych <= '9') goto yy207;
			} else {
				if (yych <= 'Z') goto yy207;
				if (yych >= '\\') goto yy328;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy207;
			} else {
				if (yych <= 'z') goto yy207;
				if (yych >= 0x80) goto yy207;
			}
		}
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy329;
		case 'D':
		case 'd':	goto yy330;
		case 'F':
		case 'f':	goto yy331;
		case 'H':
		case 'h':	goto yy332;
		case 'L':
		case 'l':	goto yy333;
		case 'M':
		case 'm':	goto yy334;
		case 'N':
		case 'n':	goto yy335;
		case 'T':
		case 't':	goto yy336;
		default:	goto yy47;
		}
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy86;
		goto yy85;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy337;
		if (yych == 'r') goto yy337;
		goto yy85;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy338;
		if (yych == 'n') goto yy338;
		goto yy85;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy339;
		if (yych == 'o') goto yy339;
		goto yy85;
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy340;
		if (yych == 'u') goto yy340;
		goto yy85;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy341;
		if (yych == 'o') goto yy341;
		goto yy85;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy342;
		if (yych == 't') goto yy342;
		goto yy85;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy343;
		if (yych == 'j') goto yy343;
		goto yy85;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy344;
		if (yych == 'a') goto yy344;
		goto yy85;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy345;
		if (yych == 'r') goto yy345;
		goto yy85;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy346;
		if (yych == 's') goto yy346;
		goto yy85;
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy234:
		YYDEBUG(234, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych <= '9') goto yy119;
		goto yy85;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy85;
			if (yych <= '\n') goto yy347;
			goto yy85;
		} else {
			if (yych <= '\r') goto yy347;
			if (yych == ' ') goto yy347;
			goto yy85;
		}
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(237, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy236;
		}
		if (yych == '_') goto yy130;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych >= ':') goto yy85;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		if (yych <= '/') goto yy121;
		if (yych <= '9') goto yy240;
		if (yych == '_') goto yy239;
		goto yy121;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 15;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(243, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy242;
		}
		if (yych == '_') goto yy132;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0o" */
	size_t len = yyleng - 2;
	char *end, *octal = yytext + 2;
	bool contains_underscores = (memchr(octal, '_', len) != NULL);

	/* Skip any leading 0s */
	while (len > 0 && (*octal == '0' || *octal == '_')) {
		++octal;
		--len;
	}

	if (len == 0) {
		ZVAL_LONG(zendlval, 0);
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	if (contains_underscores) {
		octal = estrndup(octal, len);
		strip_underscores(octal, &len);
	}

	errno = 0;

	ZVAL_LONG(zendlval, ZEND_STRTOL(octal, &end, 8));

	ZEND_ASSERT(end == octal + len);

	if (!errno) {
		if (contains_underscores) {
			efree(octal);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	/* Overflow */
	ZEND_ASSERT(errno == ERANGE);
	/* Reset errno */
	errno = 0;

	/* zend_oct_strtod skips leading '0' */
	ZVAL_DOUBLE(zendlval, zend_oct_strtod(octal, (const char **)&end));
	ZEND_ASSERT(!errno);
	ZEND_ASSERT(end == octal + len);
	if (contains_underscores) {
		efree(octal);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 16;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy245;
		}
		if (yych == '_') goto yy133;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(249, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy248;
				if (yych <= 0x1F) goto yy85;
				goto yy248;
			} else {
				if (yych == '"') goto yy349;
				if (yych <= '&') goto yy85;
				goto yy350;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy85;
				if (yych <= 'Z') goto yy351;
				if (yych <= '^') goto yy85;
				goto yy351;
			} else {
				if (yych <= '`') goto yy85;
				if (yych <= 'z') goto yy351;
				if (yych <= 0x7F) goto yy85;
				goto yy351;
			}
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy254:
		YYDEBUG(254, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(257, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy260:
		YYDEBUG(260, *YYCURSOR);
		++YYCURSOR;
		goto yy152;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy260;
		goto yy152;
yy262:
		YYDEBUG(262, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy353;
		if (yych == 't') goto yy353;
		goto yy47;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy354;
		if (yych == 'a') goto yy354;
		goto yy47;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 18;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(269, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy270;
				if (yych <= '9') goto yy268;
			} else {
				if (yych <= 'Z') goto yy268;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy268;
			} else {
				if (yych <= 'z') goto yy268;
				if (yych >= 0x80) goto yy268;
			}
		}
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy248;
		goto yy85;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy355;
		if (yych == 'a') goto yy355;
		goto yy47;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy356;
		if (yych == 'l') goto yy356;
		goto yy47;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy357;
		if (yych == 'e') goto yy357;
		goto yy47;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy359;
		if (yych == 'c') goto yy359;
		goto yy47;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy360;
		if (yych == 's') goto yy360;
		goto yy47;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy361;
		if (yych == 'n') goto yy361;
		goto yy47;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy47;
			if (yych <= 'S') goto yy362;
			goto yy363;
		} else {
			if (yych <= 'r') goto yy47;
			if (yych <= 's') goto yy362;
			if (yych <= 't') goto yy363;
			goto yy47;
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy364;
		if (yych == 'l') goto yy364;
		goto yy47;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy365;
		if (yych == 'a') goto yy365;
		goto yy47;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy366;
		if (yych == 'o') goto yy366;
		goto yy47;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy368;
		if (yych == 'e') goto yy368;
		goto yy47;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy370;
		if (yych == 't') goto yy370;
		goto yy47;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'D':
		case 'd':	goto yy371;
		case 'F':
		case 'f':	goto yy372;
		case 'I':
		case 'i':	goto yy373;
		case 'S':
		case 's':	goto yy374;
		case 'W':
		case 'w':	goto yy375;
		default:	goto yy47;
		}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy376;
		if (yych == 'm') goto yy376;
		goto yy47;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy377;
		if (yych == 'l') goto yy377;
		goto yy47;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy379;
		if (yych == 't') goto yy379;
		goto yy47;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy381;
		if (yych == 'e') goto yy381;
		goto yy47;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy382;
		if (yych == 'a') goto yy382;
		goto yy47;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy293;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'E') goto yy383;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'e') goto yy383;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy384;
		if (yych == 'c') goto yy384;
		goto yy47;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy385;
		if (yych == 'b') goto yy385;
		goto yy47;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy386;
		if (yych == 'o') goto yy386;
		goto yy47;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy388;
		if (yych == 'l') goto yy388;
		goto yy47;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy389;
		if (yych == 'l') goto yy389;
		goto yy47;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy390;
		if (yych == 't') goto yy390;
		goto yy47;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy391;
		if (yych == 'e') goto yy391;
		goto yy47;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy392;
		if (yych == 'e') goto yy392;
		goto yy47;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy393;
		if (yych == 't') goto yy393;
		goto yy47;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy395;
		if (yych == 'c') goto yy395;
		goto yy47;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy396;
		if (yych == 'e') goto yy396;
		goto yy47;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy397;
			if (yych <= 'U') goto yy47;
			goto yy398;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy47;
				goto yy397;
			} else {
				if (yych == 'v') goto yy398;
				goto yy47;
			}
		}
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy399;
		if (yych == 't') goto yy399;
		goto yy47;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy400;
		if (yych == 'l') goto yy400;
		goto yy47;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy401;
		if (yych == 'd') goto yy401;
		goto yy47;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy402;
		if (yych == 'u') goto yy402;
		goto yy47;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy403;
		if (yych == 'u') goto yy403;
		goto yy47;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy404;
		if (yych == 't') goto yy404;
		goto yy47;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy405;
		if (yych == 't') goto yy405;
		goto yy47;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy406;
		if (yych == 'o') goto yy406;
		goto yy47;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy407;
		if (yych == 'i') goto yy407;
		goto yy47;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy408;
		if (yych == 'e') goto yy408;
		goto yy47;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy409;
		if (yych == 'l') goto yy409;
		goto yy47;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy410;
		if (yych == 'l') goto yy410;
		goto yy47;
yy328:
		YYDEBUG(328, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy207;
			if (yych <= '^') goto yy85;
			goto yy207;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy207;
			if (yych <= 0x7F) goto yy85;
			goto yy207;
		}
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy411;
		if (yych == 'l') goto yy411;
		goto yy47;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy412;
		if (yych == 'i') goto yy412;
		goto yy47;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy413;
			if (yych <= 'T') goto yy47;
			goto yy414;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy413;
			} else {
				if (yych == 'u') goto yy414;
				goto yy47;
			}
		}
yy332:
		YYDEBUG(332, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy415;
		if (yych == 'a') goto yy415;
		goto yy47;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy416;
		if (yych == 'i') goto yy416;
		goto yy47;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy417;
		if (yych == 'e') goto yy417;
		goto yy47;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy418;
		if (yych == 'a') goto yy418;
		goto yy47;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy419;
		if (yych == 'r') goto yy419;
		goto yy47;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy420;
		if (yych == 'a') goto yy420;
		goto yy85;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy421;
		if (yych == 'a') goto yy421;
		goto yy85;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy422;
		if (yych == 'l') goto yy422;
		goto yy85;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy423;
		if (yych == 'b') goto yy423;
		goto yy85;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy424;
		if (yych == 'a') goto yy424;
		goto yy85;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy429;
		if (yych == 'e') goto yy429;
		goto yy426;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy430;
		if (yych == 'e') goto yy430;
		goto yy85;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy431;
		if (yych == 'l') goto yy431;
		goto yy85;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy433;
		if (yych == 'i') goto yy433;
		goto yy85;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy434;
		if (yych == 'e') goto yy434;
		goto yy85;
yy347:
		YYDEBUG(347, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(348, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy125;
			if (yych <= '\n') goto yy347;
			goto yy125;
		} else {
			if (yych <= '\r') goto yy347;
			if (yych == ' ') goto yy347;
			goto yy125;
		}
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy85;
		if (yych <= '/') goto yy436;
		if (yych <= '9') goto yy85;
		goto yy436;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy85;
		if (yych <= '/') goto yy438;
		if (yych <= '9') goto yy85;
		goto yy438;
yy351:
		YYDEBUG(351, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(352, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy439;
				goto yy85;
			} else {
				if (yych <= '\r') goto yy441;
				if (yych <= '/') goto yy85;
				if (yych <= '9') goto yy351;
				goto yy85;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy351;
				if (yych <= '^') goto yy85;
				goto yy351;
			} else {
				if (yych <= '`') goto yy85;
				if (yych <= 'z') goto yy351;
				if (yych <= 0x7F) goto yy85;
				goto yy351;
			}
		}
yy353:
		YYDEBUG(353, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy442;
		if (yych == 'r') goto yy442;
		goto yy47;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy443;
		if (yych == 'y') goto yy443;
		goto yy47;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy445;
		if (yych == 'k') goto yy445;
		goto yy47;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy447;
		if (yych == 'a') goto yy447;
		goto yy47;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy359:
		YYDEBUG(359, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy448;
		if (yych == 'h') goto yy448;
		goto yy47;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy450;
		if (yych == 's') goto yy450;
		goto yy47;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy452;
		if (yych == 'e') goto yy452;
		goto yy47;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy454;
		if (yych == 't') goto yy454;
		goto yy47;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy456;
		if (yych == 'i') goto yy456;
		goto yy47;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy457;
		if (yych == 'a') goto yy457;
		goto yy47;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy458;
		if (yych == 'u') goto yy458;
		goto yy47;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy368:
		YYDEBUG(368, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy369;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'I') goto yy459;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'i') goto yy459;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy369:
		YYDEBUG(369, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy370:
		YYDEBUG(370, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy460;
		if (yych == 'y') goto yy460;
		goto yy47;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy462;
		if (yych == 'e') goto yy462;
		goto yy47;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy463;
		if (yych == 'o') goto yy463;
		goto yy47;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy464;
		if (yych == 'f') goto yy464;
		goto yy47;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy466;
		if (yych == 'w') goto yy466;
		goto yy47;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy467;
		if (yych == 'h') goto yy467;
		goto yy47;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy47;
			if (yych <= '\n') goto yy468;
			goto yy47;
		} else {
			if (yych <= '\r') goto yy468;
			if (yych == ' ') goto yy468;
			goto yy47;
		}
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy470;
		if (yych == 'n') goto yy470;
		goto yy47;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy471;
		if (yych == 'l') goto yy471;
		goto yy47;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy473;
		if (yych == 'a') goto yy473;
		goto yy47;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy474;
		if (yych == 't') goto yy474;
		goto yy47;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy475;
		if (yych == 'a') goto yy475;
		goto yy47;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy388:
		YYDEBUG(388, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy476;
		if (yych == 'e') goto yy476;
		goto yy47;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy477;
		if (yych == 'u') goto yy477;
		goto yy47;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy478;
			if (yych <= 'D') goto yy47;
			goto yy479;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy478;
			} else {
				if (yych == 'e') goto yy479;
				goto yy47;
			}
		}
yy391:
		YYDEBUG(391, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy480;
		if (yych == 'r') goto yy480;
		goto yy47;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy481;
		if (yych == 't') goto yy481;
		goto yy47;
yy393:
		YYDEBUG(393, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy483;
		if (yych == 'h') goto yy483;
		goto yy47;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy485;
		if (yych == 's') goto yy485;
		goto yy47;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy486;
		if (yych == 't') goto yy486;
		goto yy47;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy488;
		if (yych == 'a') goto yy488;
		goto yy47;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy489;
		if (yych == 'e') goto yy489;
		goto yy47;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy490;
		if (yych == 'i') goto yy490;
		goto yy47;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy491;
		if (yych == 'o') goto yy491;
		goto yy47;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy492;
		if (yych == 'i') goto yy492;
		goto yy47;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy493;
		if (yych == 'r') goto yy493;
		goto yy47;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy494;
		if (yych == 'i') goto yy494;
		goto yy47;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy495;
		if (yych == 'c') goto yy495;
		goto yy47;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy496;
		if (yych == 'w') goto yy496;
		goto yy47;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy498;
		if (yych == 't') goto yy498;
		goto yy47;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy500;
		if (yych == 't') goto yy500;
		goto yy47;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy502;
		if (yych == 'e') goto yy502;
		goto yy47;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy504;
		if (yych == 'd') goto yy504;
		goto yy47;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy506;
		if (yych == 'a') goto yy506;
		goto yy47;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy507;
		if (yych == 'r') goto yy507;
		goto yy47;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy508;
		if (yych == 'l') goto yy508;
		goto yy47;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy509;
		if (yych == 'n') goto yy509;
		goto yy47;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy510;
		if (yych == 'l') goto yy510;
		goto yy47;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy511;
		if (yych == 'n') goto yy511;
		goto yy47;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy512;
		if (yych == 't') goto yy512;
		goto yy47;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy513;
		if (yych == 'm') goto yy513;
		goto yy47;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy514;
		if (yych == 'a') goto yy514;
		goto yy47;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy515;
		if (yych == 'y') goto yy515;
		goto yy85;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy517;
		if (yych == 'r') goto yy517;
		goto yy85;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy522;
		if (yych == 'e') goto yy522;
		goto yy519;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy523;
		if (yych == 'l') goto yy523;
		goto yy85;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy524;
		if (yych == 't') goto yy524;
		goto yy85;
yy425:
		YYDEBUG(425, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy426:
		YYDEBUG(426, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy425;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy425;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(427, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(428, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy526;
		if (yych == 'g') goto yy526;
		goto yy85;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy527;
		if (yych == 'c') goto yy527;
		goto yy85;
yy431:
		YYDEBUG(431, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(432, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy431;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy431;
			if (yych == ')') goto yy528;
			goto yy85;
		}
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy530;
		if (yych == 'n') goto yy530;
		goto yy85;
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy531;
		if (yych == 't') goto yy531;
		goto yy85;
yy435:
		YYDEBUG(435, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy436:
		YYDEBUG(436, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy533;
				goto yy85;
			} else {
				if (yych <= '9') goto yy435;
				if (yych <= '@') goto yy85;
				goto yy435;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy435;
				goto yy85;
			} else {
				if (yych <= 'z') goto yy435;
				if (yych <= 0x7F) goto yy85;
				goto yy435;
			}
		}
yy437:
		YYDEBUG(437, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy438:
		YYDEBUG(438, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy533;
				goto yy85;
			} else {
				if (yych <= '9') goto yy437;
				if (yych <= '@') goto yy85;
				goto yy437;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy437;
				goto yy85;
			} else {
				if (yych <= 'z') goto yy437;
				if (yych <= 0x7F) goto yy85;
				goto yy437;
			}
		}
yy439:
		YYDEBUG(439, *YYCURSOR);
		++YYCURSOR;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy439;
		goto yy440;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy534;
		if (yych == 'a') goto yy534;
		goto yy47;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy445:
		YYDEBUG(445, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy447:
		YYDEBUG(447, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy535;
		if (yych == 'b') goto yy535;
		goto yy47;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy452:
		YYDEBUG(452, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy454:
		YYDEBUG(454, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy536;
		if (yych == 'n') goto yy536;
		goto yy47;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy537;
		if (yych == 'r') goto yy537;
		goto yy47;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy538;
		if (yych == 'l') goto yy538;
		goto yy47;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy539;
		if (yych == 'f') goto yy539;
		goto yy47;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy541;
		if (yych == 'c') goto yy541;
		goto yy47;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy542;
		if (yych == 'r') goto yy542;
		goto yy47;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy544;
		if (yych == 'i') goto yy544;
		goto yy47;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy545;
		if (yych == 'i') goto yy545;
		goto yy47;
yy468:
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		YYFILL(10);
		yych = *YYCURSOR;
		YYDEBUG(469, *YYCURSOR);
		if (yych <= 'I') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy85;
					goto yy468;
				} else {
					if (yych == '\r') goto yy468;
					goto yy85;
				}
			} else {
				if (yych <= 'D') {
					if (yych <= ' ') goto yy468;
					if (yych <= '@') goto yy85;
					goto yy546;
				} else {
					if (yych <= 'E') goto yy548;
					if (yych <= 'H') goto yy546;
					goto yy549;
				}
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '^') {
					if (yych <= 'Z') goto yy546;
					goto yy85;
				} else {
					if (yych == '`') goto yy85;
					goto yy546;
				}
			} else {
				if (yych <= 'i') {
					if (yych <= 'e') goto yy548;
					if (yych <= 'h') goto yy546;
					goto yy549;
				} else {
					if (yych <= 'z') goto yy546;
					if (yych <= 0x7F) goto yy85;
					goto yy546;
				}
			}
		}
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy550;
		if (yych == 'd') goto yy550;
		goto yy47;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy472;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'L') goto yy551;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'l') goto yy551;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy552;
		if (yych == 'c') goto yy552;
		goto yy47;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy553;
		if (yych == 'i') goto yy553;
		goto yy47;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy554;
		if (yych == 'l') goto yy554;
		goto yy47;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy556;
		if (yych == 'm') goto yy556;
		goto yy47;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy557;
		if (yych == 'd') goto yy557;
		goto yy47;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy558;
		if (yych == 'n') goto yy558;
		goto yy47;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy559;
		if (yych == 'a') goto yy559;
		goto yy47;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy560;
		if (yych == 'f') goto yy560;
		goto yy47;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy483:
		YYDEBUG(483, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy485:
		YYDEBUG(485, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy561;
		if (yych == 'p') goto yy561;
		goto yy47;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy488:
		YYDEBUG(488, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy562;
		if (yych == 't') goto yy562;
		goto yy47;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy563;
		if (yych == 'c') goto yy563;
		goto yy47;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy564;
		if (yych == 'c') goto yy564;
		goto yy47;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy566;
		if (yych == 'n') goto yy566;
		goto yy47;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy567;
		if (yych == 'r') goto yy567;
		goto yy47;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy568;
		if (yych == 'n') goto yy568;
		goto yy47;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy570;
		if (yych == 'c') goto yy570;
		goto yy47;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy572;
		if (yych == 'h') goto yy572;
		goto yy47;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy505;
			if (yych <= '\n') goto yy574;
			if (yych >= '\r') goto yy574;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy574;
			} else {
				if (yych == '\\') goto yy160;
			}
		}
yy505:
		YYDEBUG(505, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy506:
		YYDEBUG(506, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy576;
		if (yych == 's') goto yy576;
		goto yy47;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy577;
		goto yy47;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy578;
		if (yych == 'e') goto yy578;
		goto yy47;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy579;
		if (yych == 'c') goto yy579;
		goto yy47;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy580;
		if (yych == 't') goto yy580;
		goto yy47;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy581;
		if (yych == 'e') goto yy581;
		goto yy47;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy582;
		if (yych == 'h') goto yy582;
		goto yy47;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy583;
		if (yych == 'e') goto yy583;
		goto yy47;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy584;
		if (yych == 'i') goto yy584;
		goto yy47;
yy515:
		YYDEBUG(515, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(516, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy515;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy515;
			if (yych == ')') goto yy585;
			goto yy85;
		}
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy587;
		if (yych == 'y') goto yy587;
		goto yy85;
yy518:
		YYDEBUG(518, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy519:
		YYDEBUG(519, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy518;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy518;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(520, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(521, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy589;
		if (yych == 'a') goto yy589;
		goto yy85;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy524;
		if (yych != 'e') goto yy85;
yy524:
		YYDEBUG(524, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(525, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy524;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy524;
			if (yych == ')') goto yy590;
			goto yy85;
		}
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy592;
		if (yych == 'e') goto yy592;
		goto yy85;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy593;
		if (yych == 't') goto yy593;
		goto yy85;
yy528:
		YYDEBUG(528, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(529, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy587;
		if (yych == 'g') goto yy587;
		goto yy85;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(532, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych == ')') goto yy595;
			goto yy85;
		}
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy439;
		if (yych == '\r') goto yy441;
		goto yy85;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy597;
		if (yych == 'c') goto yy597;
		goto yy47;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy598;
		if (yych == 'l') goto yy598;
		goto yy47;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy599;
		if (yych == 'u') goto yy599;
		goto yy47;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy600;
		if (yych == 'e') goto yy600;
		goto yy47;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy602;
		if (yych == 't') goto yy602;
		goto yy47;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy604;
		if (yych == 'l') goto yy604;
		goto yy47;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy543;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'E') goto yy605;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'e') goto yy605;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy543:
		YYDEBUG(543, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy606;
		if (yych == 't') goto yy606;
		goto yy47;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy607;
		if (yych == 'l') goto yy607;
		goto yy47;
yy546:
		YYDEBUG(546, *YYCURSOR);
		++YYCURSOR;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_IDENT(T_ENUM);
}
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'X') goto yy608;
		if (yych == 'x') goto yy608;
		goto yy547;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy609;
		if (yych == 'm') goto yy609;
		goto yy547;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy610;
		if (yych == 's') goto yy610;
		goto yy47;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy612;
		if (yych == 'y') goto yy612;
		goto yy47;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy614;
		if (yych == 'h') goto yy614;
		goto yy47;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy616;
		if (yych == 'o') goto yy616;
		goto yy47;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy617;
		if (yych == 'e') goto yy617;
		goto yy47;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy618;
		if (yych == 'e') goto yy618;
		goto yy47;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy620;
		if (yych == 'c') goto yy620;
		goto yy47;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy621;
		if (yych == 'd') goto yy621;
		goto yy47;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy622;
		if (yych == 'a') goto yy622;
		goto yy47;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy623;
		if (yych == 'a') goto yy623;
		goto yy47;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy624;
		if (yych == 'e') goto yy624;
		goto yy47;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy626;
		if (yych == 't') goto yy626;
		goto yy47;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy627;
		if (yych == 'l') goto yy627;
		goto yy47;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy628;
		if (yych == 'e') goto yy628;
		goto yy47;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy572:
		YYDEBUG(572, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy574:
		YYDEBUG(574, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(575, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy85;
				goto yy574;
			} else {
				if (yych == '\r') goto yy574;
				goto yy85;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy574;
				if (yych <= 'E') goto yy85;
				goto yy630;
			} else {
				if (yych == 'f') goto yy630;
				goto yy85;
			}
		}
yy576:
		YYDEBUG(576, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy631;
		if (yych == 's') goto yy631;
		goto yy47;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy632;
		goto yy47;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy634;
		goto yy47;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy635;
		if (yych == 't') goto yy635;
		goto yy47;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy636;
		goto yy47;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy637;
		goto yy47;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy638;
		if (yych == 'o') goto yy638;
		goto yy47;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy639;
		if (yych == 's') goto yy639;
		goto yy47;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy640;
		if (yych == 't') goto yy640;
		goto yy47;
yy585:
		YYDEBUG(585, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(586, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy587:
		YYDEBUG(587, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(588, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy587;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy587;
			if (yych == ')') goto yy641;
			goto yy85;
		}
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy518;
		if (yych == 'n') goto yy518;
		goto yy85;
yy590:
		YYDEBUG(590, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy425;
		if (yych == 'r') goto yy425;
		goto yy85;
yy593:
		YYDEBUG(593, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(594, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy593;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy593;
			if (yych == ')') goto yy643;
			goto yy85;
		}
yy595:
		YYDEBUG(595, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(596, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy597:
		YYDEBUG(597, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy645;
		if (yych == 't') goto yy645;
		goto yy47;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy647;
		if (yych == 'e') goto yy647;
		goto yy47;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy649;
		if (yych == 'e') goto yy649;
		goto yy47;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy604:
		YYDEBUG(604, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy651;
		if (yych == 'a') goto yy651;
		goto yy47;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy652;
		if (yych == 'a') goto yy652;
		goto yy47;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy653;
		if (yych == 'c') goto yy653;
		goto yy47;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy654;
		if (yych == 'e') goto yy654;
		goto yy47;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy656;
		if (yych == 't') goto yy656;
		goto yy85;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy657;
		if (yych == 'p') goto yy657;
		goto yy85;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy658;
		if (yych == 'n') goto yy658;
		goto yy47;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy660;
		if (yych == 'n') goto yy660;
		goto yy47;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy619;
				if (yych <= '9') goto yy46;
			} else {
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy661;
			} else {
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy619:
		YYDEBUG(619, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy662;
		if (yych == 'e') goto yy662;
		goto yy47;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy663;
		if (yych == 'o') goto yy663;
		goto yy47;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy664;
		if (yych == 'c') goto yy664;
		goto yy47;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy665;
		if (yych == 'c') goto yy665;
		goto yy47;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy666;
		if (yych == 'e') goto yy666;
		goto yy47;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy667;
		if (yych == 'y') goto yy667;
		goto yy47;
yy628:
		YYDEBUG(628, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy629;
				if (yych <= '9') goto yy46;
			} else {
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy669;
			} else {
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy629:
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy670;
		if (yych == 'r') goto yy670;
		goto yy85;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy671;
		goto yy47;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy672;
		goto yy47;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy674;
		if (yych == 'i') goto yy674;
		goto yy47;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy675;
		if (yych == 'c') goto yy675;
		goto yy47;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy676;
		goto yy47;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy678;
		if (yych == 'd') goto yy678;
		goto yy47;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy679;
		if (yych == 'p') goto yy679;
		goto yy47;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy680;
		goto yy47;
yy641:
		YYDEBUG(641, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(642, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy643:
		YYDEBUG(643, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(644, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy645:
		YYDEBUG(645, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy651:
		YYDEBUG(651, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy681;
		if (yych == 'r') goto yy681;
		goto yy47;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy682;
		if (yych == 'c') goto yy682;
		goto yy47;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy683;
		if (yych == 'h') goto yy683;
		goto yy47;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy685;
		if (yych == 'e') goto yy685;
		goto yy85;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy686;
		if (yych == 'l') goto yy686;
		goto yy85;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy687;
		if (yych == 't') goto yy687;
		goto yy47;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy688;
		if (yych == 'o') goto yy688;
		goto yy47;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy689;
		if (yych == 'o') goto yy689;
		goto yy47;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy690;
		if (yych == 'f') goto yy690;
		goto yy47;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy692;
		if (yych == 'e') goto yy692;
		goto yy47;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy694;
		if (yych == 'e') goto yy694;
		goto yy47;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy696;
		if (yych == 'd') goto yy696;
		goto yy47;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_READONLY);
}
yy669:
		YYDEBUG(669, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy698;
		if (yych == 'o') goto yy698;
		goto yy47;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy699;
		if (yych == 'o') goto yy699;
		goto yy85;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy700;
		goto yy47;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy674:
		YYDEBUG(674, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy702;
		if (yych == 'o') goto yy702;
		goto yy47;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy703;
		if (yych == 'o') goto yy703;
		goto yy47;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy704;
		goto yy47;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy705;
		if (yych == 'a') goto yy705;
		goto yy47;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy706;
		goto yy47;
yy681:
		YYDEBUG(681, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy708;
		if (yych == 'e') goto yy708;
		goto yy47;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy710;
		if (yych == 'h') goto yy710;
		goto yy47;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy712;
		if (yych == 'n') goto yy712;
		goto yy85;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy713;
		if (yych == 'e') goto yy713;
		goto yy85;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy714;
		if (yych == 's') goto yy714;
		goto yy47;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy716;
		if (yych == 'n') goto yy716;
		goto yy47;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy717;
		if (yych == 'f') goto yy717;
		goto yy47;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy692:
		YYDEBUG(692, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy694:
		YYDEBUG(694, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy719;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy696:
		YYDEBUG(696, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy698:
		YYDEBUG(698, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy720;
		if (yych == 'n') goto yy720;
		goto yy47;
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy721;
		if (yych == 'm') goto yy721;
		goto yy85;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy722;
		if (yych == 'n') goto yy722;
		goto yy47;
yy703:
		YYDEBUG(703, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy723;
		if (yych == 'm') goto yy723;
		goto yy47;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy724;
		goto yy47;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy726;
		if (yych == 'c') goto yy726;
		goto yy47;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy708:
		YYDEBUG(708, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy710:
		YYDEBUG(710, *YYCURSOR);
		yyaccept = 83;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy727;
		if (yych == 'd') goto yy727;
		goto yy85;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy728;
		if (yych == 'm') goto yy728;
		goto yy85;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy716:
		YYDEBUG(716, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy729;
		if (yych == 'c') goto yy729;
		goto yy47;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yyaccept = 85;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy730;
			if (yych <= '^') goto yy85;
			goto yy730;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy730;
			if (yych <= 0x7F) goto yy85;
			goto yy730;
		}
yy720:
		YYDEBUG(720, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy733;
		if (yych == 'c') goto yy733;
		goto yy47;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy734;
				goto yy85;
			} else {
				if (yych <= '@') goto yy734;
				if (yych <= 'Z') goto yy85;
				goto yy734;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy85;
				goto yy734;
			} else {
				if (yych <= 'z') goto yy85;
				if (yych <= 0x7F) goto yy734;
				goto yy85;
			}
		}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy736;
		goto yy47;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy737;
		if (yych == 'p') goto yy737;
		goto yy47;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyaccept = 86;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy725:
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy726:
		YYDEBUG(726, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy738;
		if (yych == 'e') goto yy738;
		goto yy47;
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy739;
		if (yych == 's') goto yy739;
		goto yy85;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy741;
		if (yych == 'e') goto yy741;
		goto yy85;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy742;
		if (yych == 'e') goto yy742;
		goto yy47;
yy730:
		YYDEBUG(730, *YYCURSOR);
		yyaccept = 87;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(731, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy732;
				if (yych <= '9') goto yy730;
			} else {
				if (yych <= 'Z') goto yy730;
				if (yych >= '\\') goto yy719;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy730;
			} else {
				if (yych <= 'z') goto yy730;
				if (yych >= 0x80) goto yy730;
			}
		}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy733:
		YYDEBUG(733, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy744;
		if (yych == 'e') goto yy744;
		goto yy47;
yy734:
		YYDEBUG(734, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(735, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy736:
		YYDEBUG(736, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy746;
		goto yy47;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy748;
		if (yych == 'i') goto yy748;
		goto yy47;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy749;
		goto yy47;
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy750;
		if (yych == 'n') goto yy750;
		goto yy85;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yyaccept = 88;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy744:
		YYDEBUG(744, *YYCURSOR);
		yyaccept = 89;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy746:
		YYDEBUG(746, *YYCURSOR);
		yyaccept = 90;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy748:
		YYDEBUG(748, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy751;
		if (yych == 'l') goto yy751;
		goto yy47;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy752;
		goto yy47;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy727;
		if (yych == 't') goto yy727;
		goto yy85;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy754;
		if (yych == 'e') goto yy754;
		goto yy47;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yyaccept = 91;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy754:
		YYDEBUG(754, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy755;
		if (yych != 'r') goto yy47;
yy755:
		YYDEBUG(755, *YYCURSOR);
		yyaccept = 92;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy756:
		YYDEBUG(756, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(757, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy761;
		}
		if (yych <= 'Z') {
			if (yych <= '>') {
				if (yych == '-') goto yy764;
			} else {
				if (yych <= '?') goto yy765;
				if (yych >= 'A') goto yy766;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy766;
			} else {
				if (yych <= 'z') goto yy766;
				if (yych >= 0x80) goto yy766;
			}
		}
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
yy760:
		YYDEBUG(760, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(762, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy761;
		}
		YYDEBUG(763, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy769;
		goto yy760;
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy771;
		goto yy760;
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(767, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy766;
		}
		YYDEBUG(768, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy771:
		YYDEBUG(771, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy773;
		YYDEBUG(772, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy760;
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(774, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(775, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy779;
		} else {
			if (yych <= '`') goto yy780;
			if (yych == '{') goto yy782;
		}
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy779:
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy778;
			if (yych <= 'Z') goto yy783;
			if (yych <= '^') goto yy778;
			goto yy783;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy778;
				goto yy783;
			} else {
				if (yych <= '{') goto yy786;
				if (yych <= 0x7F) goto yy778;
				goto yy783;
			}
		}
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy788;
		goto yy778;
yy783:
		YYDEBUG(783, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(784, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy783;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy790;
		} else {
			if (yych <= '?') goto yy792;
			if (yych <= '@') goto yy785;
			if (yych <= '[') goto yy793;
		}
yy785:
		YYDEBUG(785, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy786:
		YYDEBUG(786, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy788:
		YYDEBUG(788, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(789, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy790:
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy795;
yy791:
		YYDEBUG(791, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy785;
yy792:
		YYDEBUG(792, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy796;
		goto yy791;
yy793:
		YYDEBUG(793, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(794, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy795:
		YYDEBUG(795, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy791;
			if (yych <= 'Z') goto yy797;
			if (yych <= '^') goto yy791;
			goto yy797;
		} else {
			if (yych <= '`') goto yy791;
			if (yych <= 'z') goto yy797;
			if (yych <= 0x7F) goto yy791;
			goto yy797;
		}
yy796:
		YYDEBUG(796, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy799;
		goto yy791;
yy797:
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy791;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy791;
		} else {
			if (yych <= '`') goto yy791;
			if (yych <= 'z') goto yy800;
			if (yych <= 0x7F) goto yy791;
		}
yy800:
		YYDEBUG(800, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(801, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(802, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy806;
		} else {
			if (yych <= '$') goto yy808;
			if (yych == '{') goto yy809;
		}
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
yy805:
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(807, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy808:
		YYDEBUG(808, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy805;
			if (yych <= 'Z') goto yy810;
			if (yych <= '^') goto yy805;
			goto yy810;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy805;
				goto yy810;
			} else {
				if (yych <= '{') goto yy813;
				if (yych <= 0x7F) goto yy805;
				goto yy810;
			}
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy815;
		goto yy805;
yy810:
		YYDEBUG(810, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(811, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy810;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy817;
		} else {
			if (yych <= '?') goto yy819;
			if (yych <= '@') goto yy812;
			if (yych <= '[') goto yy820;
		}
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy815:
		YYDEBUG(815, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(816, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy817:
		YYDEBUG(817, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy822;
yy818:
		YYDEBUG(818, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy812;
yy819:
		YYDEBUG(819, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy823;
		goto yy818;
yy820:
		YYDEBUG(820, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(821, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy822:
		YYDEBUG(822, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy818;
			if (yych <= 'Z') goto yy824;
			if (yych <= '^') goto yy818;
			goto yy824;
		} else {
			if (yych <= '`') goto yy818;
			if (yych <= 'z') goto yy824;
			if (yych <= 0x7F) goto yy818;
			goto yy824;
		}
yy823:
		YYDEBUG(823, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy826;
		goto yy818;
yy824:
		YYDEBUG(824, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(825, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy826:
		YYDEBUG(826, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy818;
			if (yych <= 'Z') goto yy827;
			if (yych <= '^') goto yy818;
		} else {
			if (yych <= '`') goto yy818;
			if (yych <= 'z') goto yy827;
			if (yych <= 0x7F) goto yy818;
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(828, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(829, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy833;
		if (yych == '{') goto yy834;
		YYDEBUG(831, *YYCURSOR);
		++YYCURSOR;
yy832:
		YYDEBUG(832, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy833:
		YYDEBUG(833, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy832;
			if (yych <= 'Z') goto yy835;
			if (yych <= '^') goto yy832;
			goto yy835;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy832;
				goto yy835;
			} else {
				if (yych <= '{') goto yy838;
				if (yych <= 0x7F) goto yy832;
				goto yy835;
			}
		}
yy834:
		YYDEBUG(834, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy840;
		goto yy832;
yy835:
		YYDEBUG(835, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(836, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy835;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy842;
		} else {
			if (yych <= '?') goto yy844;
			if (yych <= '@') goto yy837;
			if (yych <= '[') goto yy845;
		}
yy837:
		YYDEBUG(837, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(839, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy840:
		YYDEBUG(840, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(841, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy842:
		YYDEBUG(842, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy847;
yy843:
		YYDEBUG(843, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy837;
yy844:
		YYDEBUG(844, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy848;
		goto yy843;
yy845:
		YYDEBUG(845, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(846, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy847:
		YYDEBUG(847, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy843;
			if (yych <= 'Z') goto yy849;
			if (yych <= '^') goto yy843;
			goto yy849;
		} else {
			if (yych <= '`') goto yy843;
			if (yych <= 'z') goto yy849;
			if (yych <= 0x7F) goto yy843;
			goto yy849;
		}
yy848:
		YYDEBUG(848, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy851;
		goto yy843;
yy849:
		YYDEBUG(849, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(850, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy851:
		YYDEBUG(851, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy843;
			if (yych <= 'Z') goto yy852;
			if (yych <= '^') goto yy843;
		} else {
			if (yych <= '`') goto yy843;
			if (yych <= 'z') goto yy852;
			if (yych <= 0x7F) goto yy843;
		}
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(853, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(854, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy856;
			if (yych <= 'Z') goto yy858;
			if (yych >= '_') goto yy858;
		} else {
			if (yych <= '`') goto yy856;
			if (yych <= 'z') goto yy858;
			if (yych >= 0x80) goto yy858;
		}
yy856:
		YYDEBUG(856, *YYCURSOR);
		++YYCURSOR;
yy857:
		YYDEBUG(857, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy858:
		YYDEBUG(858, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy857;
				if (yych <= '9') goto yy860;
				goto yy857;
			} else {
				if (yych <= '[') goto yy860;
				if (yych <= '^') goto yy857;
				goto yy860;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy857;
				if (yych <= 'z') goto yy860;
				goto yy857;
			} else {
				if (yych <= '}') goto yy860;
				if (yych <= 0x7F) goto yy857;
				goto yy860;
			}
		}
yy859:
		YYDEBUG(859, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy860:
		YYDEBUG(860, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy859;
		}
		if (yych <= '@') goto yy861;
		if (yych <= '[') goto yy862;
		if (yych == '}') goto yy862;
yy861:
		YYDEBUG(861, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy857;
yy862:
		YYDEBUG(862, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(863, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			248, 248, 216, 216, 216, 216, 216, 216, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(864, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy866;
					if (yych <= '\n') goto yy868;
				} else {
					if (yych <= '\r') goto yy868;
					if (yych >= ' ') goto yy868;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy870;
					if (yych <= '#') goto yy868;
					goto yy872;
				} else {
					if (yych == '\'') goto yy868;
					if (yych <= '/') goto yy870;
					goto yy873;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy875;
					if (yych <= '@') goto yy870;
					goto yy877;
				} else {
					if (yych <= '[') goto yy870;
					if (yych <= '\\') goto yy868;
					goto yy880;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy877;
					goto yy870;
				} else {
					if (yych <= 'z') goto yy877;
					if (yych <= '~') goto yy870;
					if (yych >= 0x80) goto yy877;
				}
			}
		}
yy866:
		YYDEBUG(866, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(867, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy868:
		YYDEBUG(868, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(869, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy870:
		YYDEBUG(870, *YYCURSOR);
		++YYCURSOR;
yy871:
		YYDEBUG(871, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy872:
		YYDEBUG(872, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy871;
			if (yych <= 'Z') goto yy882;
			if (yych <= '^') goto yy871;
			goto yy882;
		} else {
			if (yych <= '`') goto yy871;
			if (yych <= 'z') goto yy882;
			if (yych <= 0x7F) goto yy871;
			goto yy882;
		}
yy873:
		YYDEBUG(873, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'B') {
				if (yych <= '/') goto yy874;
				if (yych <= '9') goto yy885;
				if (yych >= 'B') goto yy888;
			} else {
				if (yych == 'O') goto yy890;
				if (yych >= 'X') goto yy891;
			}
		} else {
			if (yych <= 'b') {
				if (yych == '_') goto yy892;
				if (yych >= 'b') goto yy888;
			} else {
				if (yych <= 'o') {
					if (yych >= 'o') goto yy890;
				} else {
					if (yych == 'x') goto yy891;
				}
			}
		}
yy874:
		YYDEBUG(874, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy875:
		YYDEBUG(875, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(876, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy875;
		}
		if (yych == '_') goto yy892;
		goto yy874;
yy877:
		YYDEBUG(877, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(878, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy877;
		}
		YYDEBUG(879, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy880:
		YYDEBUG(880, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(881, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy882:
		YYDEBUG(882, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(883, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy882;
			} else {
				if (yych <= '@') goto yy884;
				if (yych <= 'Z') goto yy882;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy882;
			} else {
				if (yych <= 'z') goto yy882;
				if (yych >= 0x80) goto yy882;
			}
		}
yy884:
		YYDEBUG(884, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy885:
		YYDEBUG(885, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(886, *YYCURSOR);
		if (yych <= '/') goto yy887;
		if (yych <= '9') goto yy885;
		if (yych == '_') goto yy892;
yy887:
		YYDEBUG(887, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy888:
		YYDEBUG(888, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy893;
		}
yy889:
		YYDEBUG(889, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy874;
		} else {
			goto yy887;
		}
yy890:
		YYDEBUG(890, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy895;
		}
		goto yy889;
yy891:
		YYDEBUG(891, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy897;
		}
		goto yy889;
yy892:
		YYDEBUG(892, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy889;
		if (yych <= '9') goto yy885;
		goto yy889;
yy893:
		YYDEBUG(893, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(894, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy893;
		}
		if (yych == '_') goto yy888;
		goto yy887;
yy895:
		YYDEBUG(895, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(896, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy895;
		}
		if (yych == '_') goto yy890;
		goto yy887;
yy897:
		YYDEBUG(897, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(898, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy897;
		}
		if (yych == '_') goto yy891;
		goto yy887;
	}
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(899, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy903;
		YYDEBUG(901, *YYCURSOR);
		++YYCURSOR;
yy902:
		YYDEBUG(902, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy903:
		YYDEBUG(903, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy902;
yy904:
		YYDEBUG(904, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(905, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy904;
		}
		YYDEBUG(906, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(907, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(908, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy912;
	YYDEBUG(910, *YYCURSOR);
	++YYCURSOR;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy911;
	YYDEBUG(913, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy915;
	} else {
		if (yych <= 'P') goto yy917;
		if (yych == 'p') goto yy917;
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy915:
	YYDEBUG(915, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(916, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy919;
	if (yych == 'h') goto yy919;
yy918:
	YYDEBUG(918, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy914;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy920;
	if (yych != 'p') goto yy918;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy921;
		if (yych <= '\n') goto yy922;
	} else {
		if (yych <= '\r') goto yy924;
		if (yych == ' ') goto yy922;
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy922:
	YYDEBUG(922, *YYCURSOR);
	++YYCURSOR;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy922;
	goto yy923;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(925, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(927, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(928, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(929, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(931, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(932, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident = SCNG(yy_text);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
