/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class IllegalInstantiationCheck
extends Check {
    private final Set mIllegalClasses = new HashSet();
    private String mPkgName;
    private final Set mImports = new HashSet();
    private final Set mClassNames = new HashSet();
    private final Set mInstantiations = new HashSet();

    public int[] getDefaultTokens() {
        return new int[]{30, 136, 16, 14};
    }

    public int[] getAcceptableTokens() {
        return new int[0];
    }

    public int[] getRequiredTokens() {
        return new int[]{30, 136, 16};
    }

    public void beginTree(DetailAST aRootAST) {
        super.beginTree(aRootAST);
        this.mPkgName = null;
        this.mImports.clear();
        this.mInstantiations.clear();
        this.mClassNames.clear();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 136: {
                this.processLiteralNew(aAST);
                break;
            }
            case 16: {
                this.processPackageDef(aAST);
                break;
            }
            case 30: {
                this.processImport(aAST);
                break;
            }
            case 14: {
                this.processClassDef(aAST);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + aAST);
            }
        }
    }

    public void finishTree(DetailAST aRootAST) {
        Iterator it = this.mInstantiations.iterator();
        while (it.hasNext()) {
            DetailAST literalNewAST = (DetailAST)it.next();
            this.postprocessLiteralNew(literalNewAST);
        }
    }

    private void processClassDef(DetailAST aAST) {
        DetailAST identToken = aAST.findFirstToken(58);
        String className = identToken.getText();
        this.mClassNames.add(className);
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null) {
            this.mImports.add(name);
        }
    }

    private void processPackageDef(DetailAST aAST) {
        DetailAST packageNameAST = aAST.getLastChild().getPreviousSibling();
        FullIdent packageIdent = FullIdent.createFullIdent(packageNameAST);
        this.mPkgName = packageIdent.getText();
    }

    private void processLiteralNew(DetailAST aAST) {
        this.mInstantiations.add(aAST);
    }

    private void postprocessLiteralNew(DetailAST aAST) {
        DetailAST typeNameAST = (DetailAST)aAST.getFirstChild();
        AST nameSibling = typeNameAST.getNextSibling();
        if (nameSibling != null && nameSibling.getType() == 17) {
            return;
        }
        FullIdent typeIdent = FullIdent.createFullIdent(typeNameAST);
        String typeName = typeIdent.getText();
        int lineNo = aAST.getLineNo();
        int colNo = aAST.getColumnNo();
        String fqClassName = this.getIllegalInstantiation(typeName);
        if (fqClassName != null) {
            this.log(lineNo, colNo, "instantiation.avoid", (Object)fqClassName);
        }
    }

    private String getIllegalInstantiation(String aClassName) {
        String javaLang = "java.lang.";
        if (this.mIllegalClasses.contains(aClassName)) {
            return aClassName;
        }
        int clsNameLen = aClassName.length();
        int pkgNameLen = this.mPkgName == null ? 0 : this.mPkgName.length();
        Iterator illIter = this.mIllegalClasses.iterator();
        while (illIter.hasNext()) {
            String illegal = (String)illIter.next();
            int illegalLen = illegal.length();
            if (illegalLen - "java.lang.".length() == clsNameLen && illegal.endsWith(aClassName) && illegal.startsWith("java.lang.")) {
                boolean isSameFile = this.mClassNames.contains(aClassName);
                boolean isSamePackage = false;
                try {
                    ClassLoader classLoader = this.getClassLoader();
                    if (classLoader != null) {
                        String fqName = this.mPkgName + "." + aClassName;
                        classLoader.loadClass(fqName);
                        isSamePackage = true;
                    }
                }
                catch (ClassNotFoundException ex) {
                    isSamePackage = false;
                }
                if (!isSameFile && !isSamePackage) {
                    return illegal;
                }
            }
            if (this.mPkgName != null && clsNameLen == illegalLen - pkgNameLen - 1 && illegal.charAt(pkgNameLen) == '.' && illegal.endsWith(aClassName) && illegal.startsWith(this.mPkgName)) {
                return illegal;
            }
            Iterator importIter = this.mImports.iterator();
            while (importIter.hasNext()) {
                FullIdent importLineText = (FullIdent)importIter.next();
                String importArg = importLineText.getText();
                if (importArg.endsWith(".*")) {
                    String fqClass = importArg.substring(0, importArg.length() - 1) + aClassName;
                    if (!this.mIllegalClasses.contains(fqClass)) continue;
                    return fqClass;
                }
                if (!Utils.baseClassname(importArg).equals(aClassName) || !this.mIllegalClasses.contains(importArg)) continue;
                return importArg;
            }
        }
        return null;
    }

    public void setClasses(String aClassNames) {
        this.mIllegalClasses.clear();
        StringTokenizer tok = new StringTokenizer(aClassNames, ",");
        while (tok.hasMoreTokens()) {
            this.mIllegalClasses.add(tok.nextToken());
        }
    }
}

