/*
This source is published under the following 3-clause BSD license.

Copyright (c) 2012 - 2013, Lukas Hosek and Alexander Wilkie
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * None of the names of the contributors may be used to endorse or promote 
      products derived from this software without specific prior written 
      permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/* ============================================================================

This file is part of a sample implementation of the analytical skylight and
solar radiance models presented in the SIGGRAPH 2012 paper


           "An Analytic Model for Full Spectral Sky-Dome Radiance"

and the 2013 IEEE CG&A paper

       "Adding a Solar Radiance Function to the Hosek Skylight Model"

                                   both by 

                       Lukas Hosek and Alexander Wilkie
                Charles University in Prague, Czech Republic


                        Version: 1.4a, February 22nd, 2013
                        
Version history:

1.4a  February 22nd, 2013
      Removed unnecessary and counter-intuitive solar radius parameters 
      from the interface of the colourspace sky dome initialisation functions.

1.4   February 11th, 2013
      Fixed a bug which caused the relative brightness of the solar disc
      and the sky dome to be off by a factor of about 6. The sun was too 
      bright: this affected both normal and alien sun scenarios. The 
      coefficients of the solar radiance function were changed to fix this.

1.3   January 21st, 2013 (not released to the public)
      Added support for solar discs that are not exactly the same size as
      the terrestrial sun. Also added support for suns with a different
      emission spectrum ("Alien World" functionality).

1.2a  December 18th, 2012
      Fixed a mistake and some inaccuracies in the solar radiance function
      explanations found in ArHosekSkyModel.h. The actual source code is
      unchanged compared to version 1.2.

1.2   December 17th, 2012
      Native RGB data and a solar radiance function that matches the turbidity
      conditions were added.

1.1   September 2012
      The coefficients of the spectral model are now scaled so that the output
      is given in physical units: W / (m^-2 * sr * nm). Also, the output of the
      XYZ model is now no longer scaled to the range [0...1]. Instead, it is
      the result of a simple conversion from spectral data via the CIE 2 degree
      standard observer matching functions. Therefore, after multiplication
      with 683 lm / W, the Y channel now corresponds to luminance in lm.
     
1.0   May 11th, 2012
      Initial release.


Please visit http://cgg.mff.cuni.cz/projects/SkylightModelling/ to check if
an updated version of this code has been published!

============================================================================ */


/*

This file contains the coefficient data for the spectral version of the model.

*/

// uses Apr 26 dataset

double dataset320[] = 
{
	// albedo 0, turbidity 1
	-1.341049e+001,
	-3.742293e+000,
	-5.229614e+000,
	5.307180e+000,
	-2.182658e-002,
	1.497676e-001,
	-8.561730e-006,
	1.733480e+000,
	8.826913e-001,
	-1.426825e+001,
	-3.550926e+000,
	5.719350e-002,
	3.165753e-001,
	-5.870693e-002,
	1.333896e-001,
	1.779338e-005,
	1.504276e+000,
	9.750357e-001,
	-2.239068e+000,
	-4.290407e+000,
	-7.494879e-001,
	2.864989e-001,
	-6.017855e-002,
	1.325901e-001,
	-1.661674e-004,
	1.732120e+000,
	6.513374e-001,
	-1.336194e+000,
	-2.467808e-001,
	3.961139e-001,
	-6.723820e-002,
	-1.817268e-001,
	1.017581e-002,
	6.096079e-004,
	1.986859e+000,
	1.415296e+000,
	-1.554271e+000,
	-1.811527e+000,
	7.309756e-001,
	1.766793e-003,
	5.779090e-001,
	6.186216e-001,
	-1.755338e-003,
	-2.701090e-002,
	2.699530e-001,
	-8.449639e-001,
	-5.665198e-001,
	5.525823e-001,
	-2.838870e-003,
	-4.555228e+000,
	2.824945e-001,
	4.002014e-003,
	1.114208e+000,
	6.637074e-001,
	// albedo 0, turbidity 2
	-1.298333e+001,
	-3.775577e+000,
	-5.173531e+000,
	5.316518e+000,
	-2.572615e-002,
	1.516601e-001,
	-8.297168e-006,
	1.669649e+000,
	9.000495e-001,
	-1.402639e+001,
	-3.787558e+000,
	7.611941e-002,
	2.521881e-001,
	-5.859973e-002,
	1.753711e-001,
	4.670097e-005,
	1.459275e+000,
	8.998629e-001,
	-2.190256e+000,
	-3.575495e+000,
	-4.930996e-001,
	4.826321e-002,
	-6.797145e-002,
	3.425922e-002,
	-3.512550e-004,
	1.978419e+000,
	8.866517e-001,
	-2.415991e+000,
	-1.453294e+000,
	2.170671e-001,
	1.341284e-001,
	-1.926330e-001,
	1.059103e-001,
	1.360739e-003,
	1.587725e+000,
	9.821154e-001,
	-5.254592e-001,
	-8.181026e-001,
	7.535702e-001,
	-3.323364e-002,
	4.503149e-001,
	5.778285e-001,
	-4.089673e-003,
	3.335089e-001,
	6.827164e-001,
	-1.280108e+000,
	-1.013716e+000,
	5.577676e-001,
	9.539205e-004,
	-4.934956e+000,
	2.642883e-001,
	1.005169e-002,
	9.265844e-001,
	4.999698e-001,
	// albedo 0, turbidity 3
	-1.292247e+001,
	-3.819777e+000,
	-4.478733e+000,
	4.582924e+000,
	-2.364370e-002,
	1.619828e-001,
	-3.053548e-006,
	1.646629e+000,
	5.103371e-001,
	-1.433099e+001,
	-3.766213e+000,
	4.930150e-001,
	-3.081235e-002,
	-6.522199e-002,
	1.564198e-001,
	3.455657e-004,
	1.428507e+000,
	4.312273e-001,
	-2.539220e+000,
	-3.459074e+000,
	-3.774393e-001,
	-3.628419e-001,
	-2.124451e-001,
	-1.358132e-002,
	-1.812805e-003,
	2.245152e+000,
	7.247429e-001,
	-2.393246e+000,
	-1.937898e+000,
	1.005834e-001,
	5.867890e-001,
	2.645044e-001,
	1.413695e-001,
	6.378716e-003,
	1.140715e+000,
	1.263014e+000,
	-1.185583e-001,
	-1.960943e-001,
	7.212723e-001,
	-1.763978e-001,
	-1.000190e+000,
	6.259726e-001,
	-1.783726e-002,
	7.790644e-001,
	3.244710e-001,
	-1.550325e+000,
	-1.333575e+000,
	5.618137e-001,
	2.563595e-002,
	-5.007716e+000,
	6.522985e-002,
	4.262830e-002,
	7.371930e-001,
	5.239972e-001,
	// albedo 0, turbidity 4
	-1.234358e+001,
	-3.851875e+000,
	-3.911206e+000,
	4.011324e+000,
	-2.734425e-002,
	1.272306e-001,
	-7.628210e-006,
	1.661843e+000,
	8.993903e-001,
	-1.349727e+001,
	-3.592681e+000,
	1.335192e+000,
	-9.426446e-001,
	-5.741127e-002,
	9.765267e-002,
	5.518099e-005,
	1.428554e+000,
	-4.278471e-001,
	-3.399618e+000,
	-3.818725e+000,
	-8.698171e-001,
	2.723930e-001,
	-3.644369e-001,
	1.238759e-001,
	-5.189179e-004,
	2.279175e+000,
	1.841076e+000,
	-1.925152e+000,
	-1.539333e+000,
	2.757771e-001,
	-6.435980e-002,
	6.466700e-001,
	3.084382e-002,
	3.114730e-003,
	1.259818e+000,
	5.121617e-001,
	-5.706832e-001,
	-6.696186e-001,
	6.798158e-001,
	6.920162e-001,
	-3.898854e+000,
	5.954021e-001,
	-1.196667e-002,
	5.714991e-001,
	6.528481e-001,
	-1.371907e+000,
	-1.142330e+000,
	5.207805e-001,
	-4.480298e-003,
	-5.008950e+000,
	1.251549e-001,
	3.531514e-002,
	8.776759e-001,
	4.999465e-001,
	// albedo 0, turbidity 5
	-1.459738e+001,
	-3.833562e+000,
	-4.148717e+000,
	4.203270e+000,
	-2.484405e-002,
	1.189704e-001,
	4.166397e-004,
	1.748850e+000,
	4.999721e-001,
	-1.223022e+001,
	-3.942049e+000,
	1.183072e+000,
	-9.018678e-001,
	-4.644071e-002,
	1.237476e-001,
	-2.359994e-003,
	1.471013e+000,
	5.298845e-001,
	-4.078262e+000,
	-3.261096e+000,
	-5.520001e-001,
	2.174261e-001,
	-3.582576e-001,
	2.000597e-002,
	9.890182e-003,
	2.199274e+000,
	2.756320e-001,
	-2.499065e+000,
	-2.408391e+000,
	3.391663e-002,
	-6.167543e-002,
	7.555424e-001,
	2.349252e-001,
	-2.443140e-002,
	1.328540e+000,
	1.348906e+000,
	5.456648e-002,
	-9.221401e-002,
	7.403428e-001,
	5.565324e-001,
	-5.134970e+000,
	3.021763e-001,
	3.638500e-002,
	5.560149e-001,
	1.818210e-001,
	-1.590269e+000,
	-1.344330e+000,
	4.805789e-001,
	5.038509e-001,
	-3.370644e+000,
	3.040357e-001,
	2.418483e-003,
	8.979818e-001,
	7.477974e-001,
	// albedo 0, turbidity 6
	-6.775680e+000,
	-3.436745e+000,
	-2.696730e+000,
	2.740681e+000,
	-4.032382e-002,
	1.036486e-001,
	8.133034e-005,
	1.767160e+000,
	5.401354e-001,
	-7.800595e+000,
	-2.867058e+000,
	1.478909e+000,
	-1.380160e+000,
	-1.658909e-001,
	1.962673e-001,
	-6.512798e-004,
	1.634359e+000,
	4.300704e-001,
	-4.392403e+000,
	-3.857979e+000,
	-1.022020e+000,
	1.449394e+000,
	2.769695e-001,
	-3.331834e-001,
	3.513950e-003,
	1.942113e+000,
	3.970742e-001,
	-2.469701e+000,
	-1.357319e+000,
	2.132600e-001,
	-1.918729e+000,
	-4.193060e+000,
	8.101579e-001,
	-9.605279e-003,
	1.844443e+000,
	1.582310e+000,
	-7.759612e-001,
	-1.298076e+000,
	7.162377e-001,
	2.906682e+000,
	-8.261148e-001,
	-2.892123e-001,
	1.491449e-002,
	6.529387e-002,
	-4.180287e-002,
	-9.962340e-001,
	-6.488730e-001,
	3.933344e-001,
	-4.752111e-003,
	-4.721793e+000,
	6.053196e-001,
	3.453563e-003,
	1.247655e+000,
	8.673379e-001,
	// albedo 0, turbidity 7
	-7.552689e+000,
	-3.219112e+000,
	-2.730242e+000,
	2.755929e+000,
	-3.925138e-002,
	8.394617e-002,
	1.514980e-004,
	1.844410e+000,
	5.389194e-001,
	-8.494732e+000,
	-3.138528e+000,
	1.424739e+000,
	-1.269326e+000,
	-1.561580e-001,
	1.767060e-001,
	-1.175921e-003,
	1.659123e+000,
	3.746132e-001,
	-4.672972e+000,
	-4.049529e+000,
	-1.027600e+000,
	1.072252e+000,
	7.908165e-002,
	-2.243835e-001,
	6.190595e-003,
	1.988822e+000,
	6.684758e-001,
	-2.256117e+000,
	-1.258356e+000,
	2.198377e-001,
	-1.296239e+000,
	-3.200970e+000,
	6.407291e-001,
	-1.527762e-002,
	1.735209e+000,
	1.170530e+000,
	-7.790059e-001,
	-1.269213e+000,
	6.315194e-001,
	2.368850e+000,
	-1.199163e+000,
	-1.504024e-001,
	1.733299e-002,
	2.544016e-001,
	2.756763e-001,
	-1.046916e+000,
	-6.991719e-001,
	3.620624e-001,
	7.364236e-002,
	-5.012491e+000,
	4.240417e-001,
	3.580425e-002,
	1.202329e+000,
	6.255804e-001,
	// albedo 0, turbidity 8
	-1.886851e+001,
	-4.491136e+000,
	-3.660440e+000,
	3.704226e+000,
	-3.158478e-002,
	1.229909e-001,
	9.233613e-004,
	1.745459e+000,
	5.011929e-001,
	-1.986322e+001,
	-3.528401e+000,
	1.401749e+000,
	-1.191377e+000,
	-7.474944e-002,
	-2.193835e-002,
	-5.138968e-003,
	1.710181e+000,
	5.473672e-001,
	5.355660e-001,
	-5.459304e+000,
	-8.809226e-001,
	5.959028e-001,
	-3.311339e-001,
	3.876731e-001,
	2.126070e-002,
	1.929868e+000,
	1.883429e-001,
	-3.136053e+000,
	-2.856938e-001,
	1.048390e-001,
	-7.708877e-001,
	2.106630e-001,
	-1.488471e-001,
	-5.172733e-002,
	1.769302e+000,
	1.526253e+000,
	1.496752e-001,
	-9.170428e-001,
	5.628226e-001,
	1.733601e+000,
	-4.784033e+000,
	3.570330e-001,
	7.396580e-002,
	3.954993e-001,
	1.397727e-003,
	-1.839740e+000,
	-1.279260e+000,
	3.173503e-001,
	1.096266e+000,
	-4.168649e+000,
	2.121881e-001,
	2.150917e-002,
	1.151497e+000,
	7.233585e-001,
	// albedo 0, turbidity 9
	-1.841090e+001,
	-4.803089e+000,
	-4.883823e+000,
	4.962235e+000,
	-2.693216e-002,
	1.089917e-001,
	-6.338015e-006,
	1.725865e+000,
	8.890717e-001,
	-1.947081e+001,
	-2.961260e+000,
	1.963002e+000,
	-1.942423e+000,
	-5.550118e-002,
	7.036456e-002,
	-5.990592e-004,
	1.807097e+000,
	-8.871814e-003,
	9.588307e-001,
	-6.379803e+000,
	-1.021090e+000,
	9.560589e-001,
	-2.175500e-001,
	8.613517e-002,
	1.362268e-002,
	1.953529e+000,
	7.422482e-001,
	-3.609766e+000,
	-1.823498e-003,
	2.516424e-002,
	-8.909855e-001,
	2.207805e-001,
	1.783064e-001,
	-4.293958e-002,
	1.607901e+000,
	1.131559e+000,
	6.087707e-001,
	-6.744295e-001,
	4.236310e-001,
	1.505925e+000,
	-4.197126e+000,
	2.046561e-001,
	6.445824e-002,
	7.793118e-001,
	3.262213e-001,
	-2.148492e+000,
	-1.597890e+000,
	3.166858e-001,
	2.414329e+000,
	-4.201339e+000,
	1.005902e-001,
	4.687865e-002,
	9.335376e-001,
	5.289661e-001,
	// albedo 0, turbidity 10
	-1.787767e+001,
	-4.873485e+000,
	-5.861224e+000,
	5.866336e+000,
	-1.564202e-002,
	6.967640e-002,
	7.574926e-004,
	1.768065e+000,
	5.856596e-001,
	-1.932995e+001,
	-4.092647e+000,
	2.679531e+000,
	-2.555671e+000,
	-4.181418e-002,
	1.023654e-001,
	-5.964172e-003,
	1.625691e+000,
	4.036808e-001,
	1.788482e+000,
	-5.652582e+000,
	-1.517519e+000,
	1.251535e+000,
	-2.225912e-001,
	-1.084716e-001,
	3.272584e-002,
	2.139078e+000,
	3.876645e-001,
	-3.363801e+000,
	-3.266475e-001,
	1.313912e-001,
	-6.889075e-001,
	4.356523e-001,
	3.120297e-001,
	-8.700131e-002,
	1.750122e+000,
	1.223546e+000,
	4.668756e-004,
	-9.612337e-001,
	3.082344e-001,
	1.298938e+000,
	-4.371395e+000,
	8.845524e-002,
	1.303481e-001,
	5.843720e-001,
	2.718863e-001,
	-1.759172e+000,
	-1.386072e+000,
	2.349661e-001,
	1.592185e+000,
	-3.063267e+000,
	1.529736e-001,
	3.429185e-002,
	1.030294e+000,
	6.917018e-001,
	// albedo 1, turbidity 1
	-1.341051e+001,
	-3.742047e+000,
	-5.229556e+000,
	5.307222e+000,
	-2.094796e-002,
	1.499787e-001,
	-7.023116e-006,
	1.732898e+000,
	8.826861e-001,
	-1.426829e+001,
	-3.550660e+000,
	5.731266e-002,
	3.166575e-001,
	-5.821080e-002,
	1.335860e-001,
	2.003178e-004,
	1.503788e+000,
	9.750310e-001,
	-2.239143e+000,
	-4.290084e+000,
	-7.493158e-001,
	2.865753e-001,
	-5.993923e-002,
	1.327393e-001,
	-5.399344e-004,
	1.731677e+000,
	6.513329e-001,
	-1.336350e+000,
	-2.463606e-001,
	3.963632e-001,
	-6.721398e-002,
	-1.816244e-001,
	1.021503e-002,
	8.081470e-004,
	1.986453e+000,
	1.415292e+000,
	-1.554584e+000,
	-1.810948e+000,
	7.313475e-001,
	1.703307e-003,
	5.779436e-001,
	6.184790e-001,
	-6.832621e-004,
	-2.739619e-002,
	2.699443e-001,
	-8.456234e-001,
	-5.656772e-001,
	5.531782e-001,
	-2.975361e-003,
	-4.555221e+000,
	2.821035e-001,
	4.007713e-004,
	1.113850e+000,
	6.636719e-001,
	// albedo 1, turbidity 2
	-1.263311e+001,
	-4.099112e+000,
	-5.130792e+000,
	5.526406e+000,
	-2.122841e-002,
	1.202556e-001,
	-8.060670e-006,
	1.209196e+000,
	8.997967e-001,
	-1.361400e+001,
	-3.538236e+000,
	1.570583e-001,
	3.445259e-001,
	-5.306874e-002,
	2.322893e-001,
	1.572516e-005,
	1.152750e+000,
	9.026902e-001,
	-1.477014e+000,
	-3.664310e+000,
	-1.442116e-001,
	-4.293554e-002,
	-3.768326e-002,
	-1.388530e-001,
	-1.687893e-004,
	1.592625e+000,
	8.804841e-001,
	-2.050884e+000,
	-1.470536e+000,
	3.327590e-001,
	1.976143e-001,
	-1.930369e-001,
	2.831960e-001,
	6.940849e-004,
	1.271203e+000,
	9.790242e-001,
	-3.704793e-001,
	-5.829841e-001,
	1.168589e+000,
	-1.387973e-001,
	5.998426e-001,
	3.825096e-001,
	-2.188637e-003,
	-2.273264e-001,
	7.393514e-001,
	-9.877542e-001,
	-7.646946e-001,
	8.859003e-001,
	5.263145e-002,
	-4.849410e+000,
	1.301905e-001,
	5.464872e-003,
	5.270984e-001,
	5.001226e-001,
	// albedo 1, turbidity 3
	-1.294452e+001,
	-3.858933e+000,
	-4.362969e+000,
	4.657159e+000,
	-2.281956e-002,
	1.371565e-001,
	3.552610e-006,
	1.354369e+000,
	5.222053e-001,
	-1.425646e+001,
	-3.745266e+000,
	6.901454e-001,
	-5.345642e-002,
	-5.238708e-002,
	1.157055e-001,
	-1.961110e-005,
	1.030408e+000,
	4.036292e-001,
	-2.236186e+000,
	-3.560196e+000,
	-1.053059e-001,
	-3.002269e-001,
	-1.702750e-001,
	3.290753e-002,
	-7.253274e-005,
	1.846963e+000,
	6.828000e-001,
	-1.991088e+000,
	-2.028027e+000,
	2.747056e-001,
	5.076456e-001,
	2.056096e-001,
	1.537040e-001,
	1.010611e-003,
	8.439763e-001,
	1.286657e+000,
	-2.733597e-001,
	-1.938590e-001,
	1.108079e+000,
	-1.668080e-001,
	-8.136300e-001,
	3.962292e-001,
	-4.757393e-003,
	1.536882e-001,
	4.595467e-001,
	-9.782447e-001,
	-8.452104e-001,
	9.149995e-001,
	2.750126e-002,
	-4.996263e+000,
	1.226836e-001,
	1.533731e-002,
	3.686265e-001,
	5.004484e-001,
	// albedo 1, turbidity 4
	-1.234416e+001,
	-3.818503e+000,
	-3.804408e+000,
	4.093838e+000,
	-2.505623e-002,
	1.149315e-001,
	-7.610563e-006,
	1.361584e+000,
	8.981571e-001,
	-1.349621e+001,
	-3.551853e+000,
	1.469377e+000,
	-8.971164e-001,
	-5.623731e-002,
	1.078524e-001,
	1.491378e-003,
	1.113040e+000,
	-4.279059e-001,
	-3.391950e+000,
	-3.791028e+000,
	-6.935352e-001,
	2.998175e-001,
	-3.155309e-001,
	1.196041e-001,
	-4.708048e-003,
	2.001973e+000,
	1.840166e+000,
	-1.915114e+000,
	-1.493080e+000,
	4.567342e-001,
	-7.334296e-002,
	6.767060e-001,
	-4.562689e-003,
	1.016838e-002,
	1.003272e+000,
	5.102018e-001,
	-5.674128e-001,
	-5.568719e-001,
	9.084369e-001,
	6.684870e-001,
	-3.892720e+000,
	5.312866e-001,
	-1.768715e-002,
	3.252051e-001,
	6.541029e-001,
	-1.343751e+000,
	-9.647458e-001,
	7.945561e-001,
	5.127485e-004,
	-5.009873e+000,
	6.165389e-002,
	2.642926e-002,
	6.213595e-001,
	5.327376e-001,
	// albedo 1, turbidity 5
	-1.450562e+001,
	-4.021778e+000,
	-4.181517e+000,
	4.509518e+000,
	-2.369519e-002,
	6.955582e-002,
	1.149882e-004,
	1.329583e+000,
	5.260857e-001,
	-1.297772e+001,
	-3.655039e+000,
	2.030636e+000,
	-1.537436e+000,
	-4.915490e-002,
	1.511047e-001,
	-9.053517e-004,
	1.156980e+000,
	4.831690e-001,
	-1.991837e+000,
	-3.919397e+000,
	-8.466357e-001,
	5.319508e-001,
	-3.165811e-001,
	1.056172e-001,
	4.836036e-003,
	1.843574e+000,
	3.084513e-001,
	-2.052725e+000,
	-1.606839e+000,
	5.876624e-001,
	-7.464148e-002,
	7.525473e-001,
	1.590947e-003,
	-1.261084e-002,
	8.587516e-001,
	1.404076e+000,
	-3.737447e-001,
	-4.061843e-001,
	8.985804e-001,
	5.700187e-001,
	-5.422882e+000,
	4.334301e-001,
	1.759754e-002,
	2.613056e-001,
	2.062463e-001,
	-1.002263e+000,
	-1.006484e+000,
	9.629219e-001,
	8.528366e-002,
	-4.220831e+000,
	7.848806e-002,
	1.254937e-002,
	2.140208e-001,
	6.187813e-001,
	// albedo 1, turbidity 6
	-7.175451e+000,
	-3.313094e+000,
	-2.396914e+000,
	2.657177e+000,
	-3.936959e-002,
	1.123476e-001,
	7.315860e-005,
	1.431209e+000,
	5.107145e-001,
	-8.058121e+000,
	-3.119458e+000,
	1.729776e+000,
	-1.435370e+000,
	-1.414745e-001,
	2.338787e-001,
	-5.865288e-004,
	1.247225e+000,
	5.037743e-001,
	-4.387785e+000,
	-3.851081e+000,
	-7.774273e-001,
	1.405520e+000,
	1.743075e-001,
	-4.108912e-001,
	3.058571e-003,
	1.519803e+000,
	2.636805e-001,
	-1.807473e+000,
	-1.498491e+000,
	3.237723e-001,
	-1.626737e+000,
	-3.741656e+000,
	8.444519e-001,
	-8.297013e-003,
	1.624861e+000,
	1.753817e+000,
	-6.242455e-001,
	-1.063850e+000,
	1.166897e+000,
	2.283807e+000,
	-1.150947e+000,
	-3.242997e-001,
	1.279340e-002,
	-5.448139e-001,
	-8.653106e-002,
	-8.143405e-001,
	-5.251732e-001,
	7.822692e-001,
	-3.764280e-003,
	-5.011112e+000,
	3.985065e-001,
	3.652394e-003,
	7.140115e-001,
	7.004910e-001,
	// albedo 1, turbidity 7
	-7.579673e+000,
	-3.495594e+000,
	-2.498830e+000,
	2.771470e+000,
	-3.451351e-002,
	8.186886e-002,
	1.272079e-004,
	1.390420e+000,
	5.545117e-001,
	-8.524117e+000,
	-3.121778e+000,
	1.680395e+000,
	-1.329455e+000,
	-1.395912e-001,
	1.911589e-001,
	-1.027988e-003,
	1.259267e+000,
	3.356989e-001,
	-4.579718e+000,
	-4.086739e+000,
	-8.030175e-001,
	1.103390e+000,
	1.429699e-001,
	-2.211841e-001,
	5.620349e-003,
	1.693702e+000,
	7.084432e-001,
	-1.946704e+000,
	-1.512415e+000,
	3.559506e-001,
	-1.318829e+000,
	-3.063409e+000,
	6.250046e-001,
	-1.490672e-002,
	1.414520e+000,
	1.317647e+000,
	-7.123367e-001,
	-1.133848e+000,
	1.064800e+000,
	2.217543e+000,
	-1.247373e+000,
	-2.105594e-001,
	2.261048e-002,
	-3.648618e-001,
	1.147223e-001,
	-7.979833e-001,
	-5.546030e-001,
	7.765850e-001,
	-4.676928e-003,
	-5.014372e+000,
	3.694816e-001,
	2.373221e-003,
	6.783145e-001,
	7.862971e-001,
	// albedo 1, turbidity 8
	-1.886599e+001,
	-4.523457e+000,
	-3.559445e+000,
	3.748747e+000,
	-2.082711e-002,
	1.120505e-001,
	4.908827e-005,
	1.430333e+000,
	4.999603e-001,
	-1.985552e+001,
	-3.530040e+000,
	1.578922e+000,
	-1.170838e+000,
	-6.347814e-002,
	2.032158e-003,
	-7.291357e-004,
	1.399338e+000,
	5.515394e-001,
	5.631541e-001,
	-5.483754e+000,
	-6.832337e-001,
	6.170499e-001,
	-2.824393e-001,
	3.546810e-001,
	6.248420e-003,
	1.638520e+000,
	2.300717e-001,
	-3.083195e+000,
	-3.071409e-001,
	2.822360e-001,
	-7.871125e-001,
	2.420642e-001,
	-1.716096e-001,
	-1.936307e-002,
	1.450902e+000,
	1.590291e+000,
	2.003824e-001,
	-8.374106e-001,
	8.800366e-001,
	1.702679e+000,
	-4.785357e+000,
	3.194078e-001,
	3.028099e-002,
	6.649245e-002,
	-4.459174e-003,
	-1.738851e+000,
	-1.144728e+000,
	6.950894e-001,
	1.073870e+000,
	-4.176611e+000,
	9.901497e-002,
	2.719362e-002,
	6.579628e-001,
	6.542088e-001,
	// albedo 1, turbidity 9
	-1.842858e+001,
	-4.464894e+000,
	-4.876181e+000,
	4.999894e+000,
	-1.680473e-002,
	9.284371e-002,
	8.631599e-005,
	1.551671e+000,
	8.637202e-001,
	-1.946220e+001,
	-2.928492e+000,
	1.932796e+000,
	-2.009963e+000,
	-2.067172e-002,
	2.760643e-001,
	-1.316034e-003,
	1.910005e+000,
	-2.057018e-002,
	1.012726e+000,
	-6.397245e+000,
	-8.570688e-001,
	9.466942e-001,
	-2.428074e-001,
	4.505376e-002,
	1.159119e-002,
	1.686356e+000,
	7.885028e-001,
	-3.502022e+000,
	-9.795202e-002,
	3.286657e-001,
	-8.318684e-001,
	1.254695e-001,
	9.600123e-002,
	-3.501772e-002,
	1.161309e+000,
	1.205342e+000,
	7.024550e-001,
	-6.903001e-001,
	7.519618e-001,
	1.501909e+000,
	-4.224528e+000,
	1.253867e-001,
	5.829515e-002,
	2.671626e-001,
	3.030079e-001,
	-2.056576e+000,
	-1.583471e+000,
	7.947031e-001,
	2.224097e+000,
	-4.127138e+000,
	1.885249e-001,
	1.729132e-005,
	3.336881e-001,
	5.332061e-001,
	// albedo 1, turbidity 10
	-1.825745e+001,
	-5.122861e+000,
	-5.876715e+000,
	5.970876e+000,
	-1.788919e-002,
	1.063934e-001,
	4.770037e-004,
	1.612403e+000,
	5.156506e-001,
	-1.981828e+001,
	-3.746331e+000,
	2.729783e+000,
	-2.477317e+000,
	-2.797536e-002,
	-5.281985e-002,
	-3.739083e-003,
	1.378246e+000,
	5.904024e-001,
	1.346751e+000,
	-6.486837e+000,
	-1.082622e+000,
	1.125524e+000,
	-2.228944e-001,
	3.975587e-001,
	2.035973e-002,
	1.884664e+000,
	1.086023e-003,
	-3.996320e+000,
	-4.646476e-001,
	3.008639e-002,
	-1.193861e+000,
	4.443960e-001,
	-2.593178e-001,
	-5.378377e-002,
	1.528777e+000,
	1.734923e+000,
	4.789259e-001,
	-8.952042e-001,
	8.595191e-001,
	2.353988e+000,
	-4.885398e+000,
	4.438339e-001,
	7.931163e-002,
	-8.144393e-002,
	1.663921e-002,
	-1.772626e+000,
	-1.783205e+000,
	7.322534e-001,
	1.529827e+000,
	-2.789303e+000,
	-1.817210e-001,
	2.737502e-002,
	2.620216e-001,
	6.227585e-001,
};

double datasetRad320[] = 
{
	// albedo 0, turbidity 1
	9.282016e-004,
	3.169257e-004,
	5.255138e-003,
	-1.465200e-002,
	7.187172e-002,
	5.400860e-002,
	// albedo 0, turbidity 2
	9.160628e-004,
	2.599956e-004,
	5.466998e-003,
	-1.503537e-002,
	7.200167e-002,
	5.387713e-002,
	// albedo 0, turbidity 3
	9.148749e-004,
	2.164768e-004,
	5.576667e-003,
	-1.537254e-002,
	7.215609e-002,
	5.380753e-002,
	// albedo 0, turbidity 4
	9.090685e-004,
	1.467840e-004,
	5.775870e-003,
	-1.598491e-002,
	7.252530e-002,
	5.329870e-002,
	// albedo 0, turbidity 5
	8.902830e-004,
	1.126529e-004,
	5.945913e-003,
	-1.648173e-002,
	7.220217e-002,
	5.391054e-002,
	// albedo 0, turbidity 6
	8.885423e-004,
	1.142350e-004,
	5.938903e-003,
	-1.668800e-002,
	7.231405e-002,
	5.331532e-002,
	// albedo 0, turbidity 7
	8.674766e-004,
	3.506619e-005,
	6.176212e-003,
	-1.732036e-002,
	7.223472e-002,
	5.318228e-002,
	// albedo 0, turbidity 8
	8.525095e-004,
	-1.752028e-005,
	6.286417e-003,
	-1.779286e-002,
	7.150222e-002,
	5.334072e-002,
	// albedo 0, turbidity 9
	8.232652e-004,
	-1.292152e-004,
	6.645270e-003,
	-1.886566e-002,
	7.052974e-002,
	5.331726e-002,
	// albedo 0, turbidity 10
	7.670001e-004,
	-1.885989e-004,
	6.484739e-003,
	-1.852036e-002,
	6.610758e-002,
	5.484068e-002,
	// albedo 1, turbidity 1
	1.105405e-003,
	2.555979e-005,
	7.984713e-003,
	-2.152422e-002,
	8.452836e-002,
	9.622688e-002,
	// albedo 1, turbidity 2
	1.111427e-003,
	-6.046059e-005,
	8.035207e-003,
	-2.134768e-002,
	8.363698e-002,
	9.641842e-002,
	// albedo 1, turbidity 3
	1.103552e-003,
	-8.229160e-005,
	8.170699e-003,
	-2.189940e-002,
	8.404871e-002,
	9.504912e-002,
	// albedo 1, turbidity 4
	1.075129e-003,
	-1.473970e-004,
	8.391094e-003,
	-2.255482e-002,
	8.415497e-002,
	9.338994e-002,
	// albedo 1, turbidity 5
	1.036467e-003,
	-1.328992e-004,
	8.348236e-003,
	-2.256138e-002,
	8.304671e-002,
	9.263679e-002,
	// albedo 1, turbidity 6
	1.042383e-003,
	-2.016636e-004,
	8.479624e-003,
	-2.296524e-002,
	8.303746e-002,
	9.082494e-002,
	// albedo 1, turbidity 7
	1.014293e-003,
	-2.355927e-004,
	8.551010e-003,
	-2.333261e-002,
	8.258160e-002,
	8.873588e-002,
	// albedo 1, turbidity 8
	9.683336e-004,
	-2.120256e-004,
	8.172046e-003,
	-2.223973e-002,
	7.852279e-002,
	8.864017e-002,
	// albedo 1, turbidity 9
	9.139571e-004,
	-2.688667e-004,
	8.068793e-003,
	-2.224390e-002,
	7.590320e-002,
	8.464876e-002,
	// albedo 1, turbidity 10
	8.457855e-004,
	-3.459869e-004,
	7.626953e-003,
	-2.067614e-002,
	6.841363e-002,
	8.244103e-002,
};

double dataset360[] = 
{
	// albedo 0, turbidity 1
	-2.974290e+000,
	-1.670904e+000,
	-5.183199e+000,
	5.377376e+000,
	-2.904124e-002,
	2.486720e-001,
	8.045624e-005,
	1.889212e+000,
	5.188203e-001,
	-2.638402e+000,
	-1.651876e+000,
	-1.229939e+000,
	1.776358e+000,
	-6.372414e-002,
	3.767834e-001,
	-6.475530e-004,
	1.373589e+000,
	4.349252e-001,
	-2.449142e+000,
	-1.541788e+000,
	4.629358e-001,
	-1.149742e+000,
	-7.317185e-002,
	-2.422158e-001,
	3.667113e-003,
	3.146429e+000,
	6.725657e-001,
	-8.559357e-001,
	-5.054959e-001,
	4.334205e-001,
	4.254155e-001,
	-2.920605e-001,
	9.303230e-001,
	-1.212609e-002,
	4.498482e-001,
	2.117838e-001,
	-1.098145e+000,
	-5.123514e-001,
	7.773196e-001,
	-1.325175e-001,
	4.648396e-001,
	1.386648e-001,
	2.427679e-002,
	1.199386e+000,
	7.988611e-001,
	-1.124849e+000,
	-5.693597e-001,
	7.315125e-001,
	2.986435e-002,
	-4.536788e+000,
	6.650081e-001,
	-9.004215e-007,
	1.006380e+000,
	4.999682e-001,
	// albedo 0, turbidity 2
	-2.709497e+000,
	-1.635812e+000,
	-4.594177e+000,
	4.809336e+000,
	-3.672907e-002,
	2.383111e-001,
	3.241989e-005,
	1.885505e+000,
	6.619619e-001,
	-2.590279e+000,
	-1.525236e+000,
	-6.846073e-001,
	1.216080e+000,
	-8.022814e-002,
	3.040074e-001,
	-4.984576e-004,
	1.521429e+000,
	1.746040e-001,
	-2.988403e+000,
	-1.938687e+000,
	4.954649e-002,
	-8.992325e-001,
	-7.157111e-002,
	-4.370068e-002,
	4.336645e-003,
	2.849496e+000,
	8.892788e-001,
	-2.932084e-001,
	-1.323910e-001,
	5.535910e-001,
	7.456284e-001,
	-2.713400e-001,
	6.989175e-001,
	-1.513162e-002,
	6.926848e-001,
	5.719944e-001,
	-1.379400e+000,
	-6.876864e-001,
	7.224534e-001,
	-6.172704e-001,
	1.217500e-001,
	3.074795e-001,
	2.905167e-002,
	1.123563e+000,
	6.837510e-001,
	-1.042446e+000,
	-5.201193e-001,
	7.107656e-001,
	4.182566e-001,
	-4.956238e+000,
	5.315425e-001,
	6.232999e-003,
	1.059015e+000,
	5.116427e-001,
	// albedo 0, turbidity 3
	-2.686687e+000,
	-1.615137e+000,
	-3.811956e+000,
	4.018597e+000,
	-3.953418e-002,
	2.171778e-001,
	-7.374887e-006,
	1.875745e+000,
	8.996180e-001,
	-3.049670e+000,
	-1.775802e+000,
	2.577719e-002,
	5.331200e-001,
	-9.424429e-002,
	3.852753e-001,
	-8.678326e-005,
	1.347053e+000,
	-1.078327e-001,
	-2.414334e+000,
	-1.637863e+000,
	-3.948523e-001,
	-4.867989e-001,
	-1.545516e-001,
	-2.045592e-001,
	2.308206e-003,
	3.257409e+000,
	1.029606e+000,
	-6.821703e-001,
	-3.665215e-001,
	7.496076e-001,
	5.391760e-001,
	-2.903450e-001,
	8.498544e-001,
	-1.388990e-002,
	2.126622e-001,
	6.857005e-001,
	-1.227285e+000,
	-5.958479e-001,
	5.828611e-001,
	-4.050489e-001,
	-2.935835e-001,
	1.410603e-001,
	4.352812e-002,
	1.406076e+000,
	4.955059e-001,
	-1.080553e+000,
	-5.308084e-001,
	6.980027e-001,
	2.193524e-001,
	-5.007206e+000,
	5.895807e-001,
	1.122391e-002,
	1.052433e+000,
	6.643198e-001,
	// albedo 0, turbidity 4
	-2.983088e+000,
	-1.746025e+000,
	-4.564198e+000,
	4.776145e+000,
	-3.208607e-002,
	2.008358e-001,
	-6.578048e-006,
	1.829880e+000,
	9.001069e-001,
	-2.858023e+000,
	-1.624623e+000,
	1.859497e+000,
	-1.348577e+000,
	-7.427284e-002,
	2.943068e-001,
	-1.961205e-004,
	1.502334e+000,
	-3.183648e-001,
	-2.858102e+000,
	-2.072804e+000,
	-1.205584e+000,
	5.674135e-001,
	-3.934144e-001,
	-3.736288e-002,
	4.780332e-003,
	2.831298e+000,
	1.553942e+000,
	-3.305766e-001,
	-8.277591e-003,
	8.561917e-001,
	-2.239172e-001,
	5.896697e-001,
	6.229823e-001,
	-2.242577e-002,
	7.216263e-001,
	4.295956e-001,
	-1.322728e+000,
	-7.101315e-001,
	5.645563e-001,
	9.897384e-001,
	-6.756374e+000,
	2.491515e-001,
	5.308124e-002,
	1.166258e+000,
	5.472501e-001,
	-1.117086e+000,
	-5.760006e-001,
	6.388217e-001,
	1.659290e-001,
	-4.687099e+000,
	4.544540e-001,
	2.672063e-002,
	1.067777e+000,
	6.419825e-001,
	// albedo 0, turbidity 5
	-2.943340e+000,
	-1.779161e+000,
	-3.715839e+000,
	3.949049e+000,
	-4.499824e-002,
	2.234466e-001,
	-8.091518e-006,
	1.825217e+000,
	9.000118e-001,
	-3.717358e+000,
	-1.850324e+000,
	2.277659e+000,
	-2.027790e+000,
	-1.240730e-001,
	3.029522e-001,
	-2.176255e-004,
	1.585933e+000,
	-2.794001e-001,
	-2.439542e+000,
	-2.277701e+000,
	-1.702329e+000,
	2.025885e+000,
	-1.142291e-001,
	-2.011641e-001,
	5.563891e-003,
	2.424957e+000,
	1.399542e+000,
	-1.562453e-001,
	5.099893e-001,
	1.026847e+000,
	-2.516874e+000,
	-2.212969e+000,
	9.252660e-001,
	-2.696795e-002,
	1.443711e+000,
	7.450372e-001,
	-1.579698e+000,
	-1.110703e+000,
	4.743061e-001,
	4.160187e+000,
	-4.597085e+000,
	-2.112156e-001,
	6.791770e-002,
	6.131169e-001,
	2.291635e-001,
	-9.959610e-001,
	-4.119588e-001,
	5.707529e-001,
	-3.505536e-003,
	-4.253949e+000,
	7.498003e-001,
	8.246945e-003,
	1.397857e+000,
	8.021253e-001,
	// albedo 0, turbidity 6
	-2.304734e+000,
	-1.483605e+000,
	-1.531059e+000,
	1.707306e+000,
	-1.150367e-001,
	2.153063e-001,
	-3.351533e-006,
	2.021261e+000,
	5.742842e-001,
	-3.130477e+000,
	-1.966839e+000,
	6.058600e-001,
	-9.209976e-001,
	-1.932901e-001,
	3.242645e-001,
	3.361262e-002,
	1.529938e+000,
	2.851152e-001,
	-1.110129e+000,
	-1.306323e+000,
	-3.235833e-001,
	2.998748e+000,
	-1.535927e-002,
	-4.001906e-001,
	-9.430492e-002,
	2.211086e+000,
	8.632200e-001,
	-1.174540e+000,
	7.550161e-002,
	-1.849588e-001,
	-6.281432e+000,
	-6.186665e+000,
	1.173048e+000,
	1.481656e-001,
	2.668578e+000,
	6.145923e-001,
	-1.104583e+000,
	-8.430389e-001,
	8.668416e-001,
	9.153752e+000,
	-7.289540e-001,
	-4.346537e-001,
	-9.065784e-002,
	2.866983e-001,
	6.920973e-001,
	-1.105893e+000,
	-4.500399e-001,
	4.286451e-001,
	1.207864e+000,
	-5.018291e+000,
	6.988292e-001,
	3.891745e-002,
	1.602324e+000,
	6.269169e-001,
	// albedo 0, turbidity 7
	-3.709341e+000,
	-2.038242e+000,
	-3.127214e+000,
	3.287030e+000,
	-4.565671e-002,
	2.427627e-001,
	-7.503980e-006,
	1.817881e+000,
	9.000389e-001,
	-3.393374e+000,
	-1.710497e+000,
	1.661275e+000,
	-1.388896e+000,
	-1.012293e-001,
	1.676172e-001,
	-5.719846e-004,
	1.694199e+000,
	-3.140071e-001,
	-2.812820e+000,
	-2.678401e+000,
	-1.170428e+000,
	1.560988e+000,
	-4.488218e-001,
	1.088693e-001,
	1.391966e-002,
	2.144426e+000,
	1.525731e+000,
	2.547360e-001,
	8.840167e-001,
	5.469168e-001,
	-2.615530e+000,
	-1.048663e+000,
	4.823171e-001,
	-5.958515e-002,
	1.842479e+000,
	5.322138e-001,
	-1.612173e+000,
	-1.055541e+000,
	4.733463e-001,
	5.083504e+000,
	-5.558403e+000,
	8.029584e-002,
	1.294180e-001,
	7.807964e-001,
	3.949822e-001,
	-1.098367e+000,
	-5.550631e-001,
	4.221569e-001,
	-1.661587e-003,
	-4.970027e+000,
	3.479325e-001,
	4.503648e-002,
	1.369224e+000,
	6.753984e-001,
	// albedo 0, turbidity 8
	-4.292777e+000,
	-2.231300e+000,
	-4.359252e+000,
	4.562131e+000,
	-3.759725e-002,
	2.170783e-001,
	-6.945269e-006,
	1.791630e+000,
	8.996451e-001,
	-4.016595e+000,
	-1.761175e+000,
	2.616213e+000,
	-2.658657e+000,
	-8.209207e-002,
	2.736152e-001,
	-6.864170e-004,
	1.820262e+000,
	-2.712707e-001,
	-2.942646e+000,
	-3.350329e+000,
	-1.645817e+000,
	2.957424e+000,
	-1.073783e-001,
	-1.920050e-001,
	1.665992e-002,
	1.723144e+000,
	1.394962e+000,
	9.793627e-001,
	1.743715e+000,
	5.396545e-001,
	-4.618273e+000,
	-2.186669e+000,
	1.012973e+000,
	-7.213786e-002,
	2.388103e+000,
	6.712519e-001,
	-2.085434e+000,
	-1.445755e+000,
	3.384806e-001,
	7.702938e+000,
	-3.897179e+000,
	-5.947697e-001,
	1.614194e-001,
	7.854754e-001,
	3.291034e-001,
	-9.660466e-001,
	-5.247410e-001,
	4.199048e-001,
	-3.304707e-003,
	-5.014144e+000,
	6.733599e-001,
	2.345161e-002,
	1.225739e+000,
	7.256834e-001,
	// albedo 0, turbidity 9
	-3.950771e+000,
	-2.192673e+000,
	-7.263653e+000,
	7.343312e+000,
	-1.840332e-002,
	1.893809e-001,
	-3.583629e-006,
	1.901172e+000,
	5.902387e-001,
	-6.384690e+000,
	-2.515788e+000,
	3.874778e+000,
	-3.776079e+000,
	-3.484710e-002,
	3.311078e-001,
	8.248395e-003,
	1.612712e+000,
	3.123684e-001,
	-6.207616e-001,
	-2.681061e+000,
	-2.005212e+000,
	2.445498e+000,
	-1.935675e-001,
	-1.988856e-001,
	-1.553754e-002,
	2.210740e+000,
	6.507040e-001,
	-1.241493e+000,
	5.908170e-001,
	3.899777e-001,
	-2.344038e+000,
	-1.820327e-001,
	7.889592e-001,
	-1.468064e-002,
	1.586758e+000,
	1.007885e+000,
	-4.395130e-001,
	-3.700611e-001,
	2.452754e-001,
	3.602006e+000,
	-4.692896e+000,
	-8.620746e-002,
	1.418548e-001,
	1.521301e+000,
	3.989756e-001,
	-1.794977e+000,
	-1.190586e+000,
	3.928989e-001,
	1.946953e+000,
	-1.874118e+000,
	-3.292602e-002,
	2.983309e-002,
	6.737092e-001,
	7.322706e-001,
	// albedo 0, turbidity 10
	-8.896186e+000,
	-3.278330e+000,
	-7.998349e+000,
	8.023312e+000,
	-1.357555e-002,
	1.947910e-001,
	-5.390226e-006,
	1.798414e+000,
	7.881395e-001,
	-8.040403e+000,
	-2.528514e+000,
	3.774303e+000,
	-3.590457e+000,
	-3.551313e-002,
	3.650761e-001,
	-4.401382e-004,
	1.701545e+000,
	-6.992899e-003,
	-4.150010e-001,
	-3.539507e+000,
	-1.527733e+000,
	1.415242e+000,
	-1.831476e-001,
	-3.009746e-001,
	1.211955e-002,
	2.365976e+000,
	9.928240e-001,
	-2.090923e+000,
	1.673638e-001,
	-2.183495e-001,
	-8.374584e-001,
	2.774184e-002,
	7.912769e-001,
	-6.650609e-002,
	1.154446e+000,
	7.863979e-001,
	5.115239e-001,
	2.415831e-001,
	4.022318e-001,
	2.292950e+000,
	-4.061496e+000,
	7.453182e-002,
	1.902451e-001,
	1.587339e+000,
	5.207620e-001,
	-2.334879e+000,
	-1.642495e+000,
	2.384458e-001,
	3.068363e+000,
	-1.699588e+000,
	-3.936924e-001,
	3.028660e-002,
	4.715374e-001,
	7.091893e-001,
	// albedo 1, turbidity 1
	-2.375941e+000,
	-1.508643e+000,
	-5.070151e+000,
	5.509378e+000,
	-2.915769e-002,
	2.122471e-001,
	8.584007e-005,
	1.517285e+000,
	5.163253e-001,
	-2.605398e+000,
	-1.589160e+000,
	-1.137560e+000,
	1.827729e+000,
	-4.939637e-002,
	3.243952e-001,
	-6.464612e-004,
	1.008816e+000,
	4.568463e-001,
	-2.176260e+000,
	-1.601522e+000,
	7.060324e-001,
	-1.060717e+000,
	-5.144614e-002,
	-1.938031e-001,
	3.449257e-003,
	2.641594e+000,
	5.976852e-001,
	-7.365744e-001,
	-3.720296e-001,
	7.315328e-001,
	3.156067e-001,
	-2.739385e-001,
	8.252942e-001,
	-1.055013e-002,
	7.327610e-002,
	3.218251e-001,
	-1.017537e+000,
	-4.631811e-001,
	1.093174e+000,
	-7.215941e-002,
	5.408457e-001,
	-1.848322e-002,
	1.942990e-002,
	6.882763e-001,
	7.268524e-001,
	-1.025215e+000,
	-3.712574e-001,
	9.661278e-001,
	7.791398e-003,
	-4.508617e+000,
	4.371074e-001,
	-1.241898e-006,
	1.152655e+000,
	5.008240e-001,
	// albedo 1, turbidity 2
	-2.621793e+000,
	-1.611544e+000,
	-4.494730e+000,
	4.902741e+000,
	-2.935751e-002,
	1.930048e-001,
	1.821579e-005,
	1.522018e+000,
	6.563013e-001,
	-2.473330e+000,
	-1.495083e+000,
	-5.536781e-001,
	1.305457e+000,
	-7.261347e-002,
	2.967738e-001,
	-2.858526e-004,
	1.132650e+000,
	1.737068e-001,
	-2.843519e+000,
	-1.913751e+000,
	2.006296e-001,
	-8.580922e-001,
	-5.273753e-002,
	-7.800250e-002,
	2.395781e-003,
	2.505017e+000,
	9.023934e-001,
	-1.805184e-001,
	-3.670063e-002,
	7.583717e-001,
	7.594739e-001,
	-2.092951e-001,
	6.278666e-001,
	-8.086828e-003,
	4.136002e-001,
	6.026937e-001,
	-1.274753e+000,
	-5.831501e-001,
	9.711756e-001,
	-6.209175e-001,
	1.488633e-001,
	2.117108e-001,
	1.531499e-002,
	9.306008e-001,
	7.201852e-001,
	-9.224434e-001,
	-3.344822e-001,
	9.964647e-001,
	3.991735e-001,
	-4.951439e+000,
	4.332347e-001,
	-1.082832e-005,
	9.570977e-001,
	5.221054e-001,
	// albedo 1, turbidity 3
	-2.648100e+000,
	-1.587720e+000,
	-3.738681e+000,
	4.084015e+000,
	-3.301163e-002,
	1.736140e-001,
	-5.598265e-006,
	1.628176e+000,
	8.967917e-001,
	-3.004556e+000,
	-1.702983e+000,
	1.060112e-001,
	5.816666e-001,
	-8.140777e-002,
	3.584557e-001,
	-7.793874e-005,
	1.090228e+000,
	-1.079451e-001,
	-2.337937e+000,
	-1.584523e+000,
	-2.912486e-001,
	-4.467895e-001,
	-9.195281e-002,
	-2.355753e-001,
	1.887118e-003,
	3.053238e+000,
	1.043382e+000,
	-5.985994e-001,
	-2.846782e-001,
	8.903642e-001,
	5.578845e-001,
	-2.510042e-001,
	8.033778e-001,
	-9.920460e-003,
	7.388584e-002,
	7.097127e-001,
	-1.155357e+000,
	-4.638306e-001,
	8.041892e-001,
	-4.051351e-001,
	-2.819435e-001,
	8.505708e-002,
	2.749222e-002,
	1.334820e+000,
	5.216620e-001,
	-1.010658e+000,
	-3.816787e-001,
	9.644918e-001,
	2.144477e-001,
	-5.005667e+000,
	5.475125e-001,
	3.758162e-005,
	1.033427e+000,
	6.866266e-001,
	// albedo 1, turbidity 4
	-2.686681e+000,
	-1.694114e+000,
	-4.346908e+000,
	4.745876e+000,
	-2.879846e-002,
	2.237339e-001,
	-6.438656e-006,
	1.456353e+000,
	9.000340e-001,
	-2.684912e+000,
	-1.616888e+000,
	2.447798e+000,
	-1.626883e+000,
	-7.346183e-002,
	2.641722e-001,
	-1.001518e-004,
	1.045501e+000,
	-2.314856e-001,
	-2.587652e+000,
	-1.999748e+000,
	-1.325810e+000,
	7.561102e-001,
	-4.182131e-001,
	-4.285017e-002,
	2.719759e-003,
	2.420598e+000,
	1.281981e+000,
	-2.679506e-001,
	5.139740e-002,
	1.276587e+000,
	-2.286956e-001,
	7.388924e-001,
	5.606395e-001,
	-1.472508e-002,
	5.105614e-001,
	7.670396e-001,
	-1.267160e+000,
	-7.441021e-001,
	9.154665e-001,
	8.190436e-001,
	-6.805266e+000,
	1.013064e-001,
	4.140297e-002,
	3.378301e-001,
	3.128860e-001,
	-9.570978e-001,
	-3.478847e-001,
	9.709923e-001,
	-3.444499e-003,
	-4.677921e+000,
	3.551546e-001,
	6.241534e-003,
	1.052060e+000,
	7.543152e-001,
	// albedo 1, turbidity 5
	-3.093830e+000,
	-1.859478e+000,
	-4.003711e+000,
	4.391665e+000,
	-3.051581e-002,
	2.180265e-001,
	-7.401285e-006,
	1.448366e+000,
	9.000549e-001,
	-3.121106e+000,
	-1.664385e+000,
	2.868256e+000,
	-2.280292e+000,
	-8.456847e-002,
	2.227469e-001,
	-1.681252e-004,
	1.176332e+000,
	-2.605895e-001,
	-2.166025e+000,
	-2.172663e+000,
	-1.705862e+000,
	1.960864e+000,
	-2.185020e-001,
	1.891067e-002,
	4.423413e-003,
	2.071931e+000,
	1.297661e+000,
	-5.263078e-001,
	2.296403e-001,
	1.342025e+000,
	-2.034590e+000,
	-1.024013e+000,
	4.873264e-001,
	-1.982506e-002,
	9.818474e-001,
	1.040041e+000,
	-1.138361e+000,
	-8.186096e-001,
	8.845700e-001,
	3.291911e+000,
	-5.915866e+000,
	1.125846e-001,
	4.477952e-002,
	9.195132e-002,
	-1.138939e-002,
	-1.013651e+000,
	-3.811416e-001,
	9.420266e-001,
	-3.599378e-003,
	-4.895655e+000,
	2.864445e-001,
	1.940262e-002,
	1.026648e+000,
	7.421204e-001,
	// albedo 1, turbidity 6
	-2.379373e+000,
	-1.540348e+000,
	-1.318467e+000,
	1.724703e+000,
	-1.017147e-001,
	1.811106e-001,
	-3.047951e-006,
	1.598808e+000,
	5.796580e-001,
	-3.200327e+000,
	-2.016985e+000,
	9.935187e-001,
	-9.970906e-001,
	-2.159523e-001,
	3.183812e-001,
	1.575987e-002,
	1.180131e+000,
	2.839510e-001,
	-1.107956e+000,
	-1.330969e+000,
	-1.627216e-001,
	2.985435e+000,
	-2.198633e-002,
	-4.401148e-001,
	-5.433064e-002,
	1.701087e+000,
	8.289746e-001,
	-9.423359e-001,
	4.619106e-002,
	3.116348e-002,
	-6.353122e+000,
	-6.192769e+000,
	1.175886e+000,
	1.020452e-001,
	2.180417e+000,
	7.076018e-001,
	-1.037343e+000,
	-5.711080e-001,
	1.282899e+000,
	8.808032e+000,
	-8.741903e-001,
	-6.097972e-001,
	-5.996612e-002,
	1.533313e-001,
	5.842877e-001,
	-1.002208e+000,
	-3.271512e-001,
	7.288675e-001,
	7.950560e-001,
	-5.029931e+000,
	4.493639e-001,
	2.389923e-002,
	1.568465e+000,
	5.653910e-001,
	// albedo 1, turbidity 7
	-3.584221e+000,
	-2.140498e+000,
	-5.324613e+000,
	5.753381e+000,
	-2.662581e-002,
	2.099272e-001,
	-6.879519e-006,
	1.362229e+000,
	9.000467e-001,
	-3.579609e+000,
	-1.804420e+000,
	3.448490e+000,
	-2.929179e+000,
	-6.009529e-002,
	2.821561e-001,
	-6.203809e-004,
	1.312035e+000,
	-3.013934e-001,
	-2.053811e+000,
	-2.420850e+000,
	-1.795999e+000,
	1.835004e+000,
	-3.451800e-001,
	-1.042135e-001,
	1.511574e-002,
	1.751304e+000,
	1.491704e+000,
	-2.602659e-001,
	5.963320e-001,
	1.059632e+000,
	-1.214076e+000,
	6.424455e-001,
	6.890202e-001,
	-6.544341e-002,
	1.457883e+000,
	5.321707e-001,
	-1.266632e+000,
	-8.504227e-001,
	8.680693e-001,
	1.899473e+000,
	-8.680238e+000,
	-1.798563e-001,
	1.477665e-001,
	2.430031e-001,
	4.229871e-001,
	-1.021321e+000,
	-5.129049e-001,
	9.006232e-001,
	1.534018e+000,
	-3.672948e+000,
	2.301115e-001,
	5.151145e-003,
	7.460819e-001,
	5.418252e-001,
	// albedo 1, turbidity 8
	-4.095186e+000,
	-2.274183e+000,
	-4.115160e+000,
	4.514741e+000,
	-3.131440e-002,
	1.475658e-001,
	-5.329133e-006,
	1.411833e+000,
	8.893477e-001,
	-3.691554e+000,
	-1.654418e+000,
	3.158573e+000,
	-2.961366e+000,
	-7.834161e-002,
	3.035141e-001,
	-4.241191e-004,
	1.485200e+000,
	-1.689443e-001,
	-2.697067e+000,
	-3.473351e+000,
	-1.707297e+000,
	3.138823e+000,
	-8.323430e-002,
	-1.605972e-001,
	1.025052e-002,
	1.132282e+000,
	1.093318e+000,
	7.049827e-001,
	1.769870e+000,
	8.659868e-001,
	-4.445404e+000,
	-2.256134e+000,
	7.768538e-001,
	-4.741793e-002,
	2.212406e+000,
	1.109562e+000,
	-1.771411e+000,
	-1.358270e+000,
	7.604506e-001,
	7.191590e+000,
	-4.358366e+000,
	-3.375251e-001,
	1.136852e-001,
	1.844576e-001,
	-1.208189e-003,
	-9.623648e-001,
	-5.518470e-001,
	9.623684e-001,
	-5.697517e-003,
	-5.015884e+000,
	2.811964e-001,
	2.100168e-002,
	4.434131e-001,
	7.212648e-001,
	// albedo 1, turbidity 9
	-5.131552e+000,
	-2.558716e+000,
	-8.066753e+000,
	8.403192e+000,
	-1.450692e-002,
	1.494495e-001,
	-2.898774e-006,
	1.427512e+000,
	5.020826e-001,
	-6.192910e+000,
	-2.261479e+000,
	5.059205e+000,
	-4.892079e+000,
	-2.703716e-002,
	3.381259e-001,
	2.231257e-002,
	1.490697e+000,
	5.441761e-001,
	-6.741018e-001,
	-3.356237e+000,
	-2.207329e+000,
	3.300094e+000,
	-1.801120e-001,
	-2.560242e-001,
	-6.216731e-002,
	1.180699e+000,
	2.241782e-001,
	-8.312435e-001,
	1.325391e+000,
	5.324159e-001,
	-2.912438e+000,
	-8.384977e-002,
	7.600872e-001,
	7.749519e-002,
	2.129188e+000,
	1.328287e+000,
	-7.455272e-001,
	-8.504579e-001,
	9.021474e-001,
	3.426594e+000,
	-4.607412e+000,
	-1.706127e-001,
	4.792024e-002,
	2.354077e-001,
	2.718195e-001,
	-1.448374e+000,
	-9.739004e-001,
	8.801628e-001,
	1.705262e+000,
	-2.420298e+000,
	-1.077392e-002,
	2.691713e-002,
	1.854876e-001,
	7.097466e-001,
	// albedo 1, turbidity 10
	-8.672396e+000,
	-3.339107e+000,
	-7.666257e+000,
	7.916291e+000,
	-1.396976e-002,
	1.676538e-001,
	-5.816416e-006,
	1.448247e+000,
	8.178892e-001,
	-7.852799e+000,
	-2.606120e+000,
	4.231840e+000,
	-3.774406e+000,
	-3.540722e-002,
	2.178494e-001,
	6.198617e-005,
	1.295236e+000,
	1.130678e-001,
	-1.374103e-001,
	-3.570476e+000,
	-1.588768e+000,
	1.538806e+000,
	-1.923629e-001,
	-1.793545e-002,
	3.373950e-003,
	2.008581e+000,
	6.041668e-001,
	-2.211224e+000,
	1.190704e-001,
	6.700025e-002,
	-8.972445e-001,
	2.133056e-001,
	4.471730e-001,
	-3.148150e-002,
	9.759721e-001,
	1.166537e+000,
	5.932825e-001,
	2.482606e-001,
	9.239617e-001,
	2.382787e+000,
	-4.611846e+000,
	1.608983e-001,
	1.385590e-001,
	7.641781e-001,
	3.076032e-001,
	-2.098394e+000,
	-1.561705e+000,
	7.602298e-001,
	1.783879e+000,
	-1.486238e+000,
	-4.025919e-001,
	2.965074e-002,
	-8.717180e-002,
	7.279518e-001,
};

double datasetRad360[] = 
{
	// albedo 0, turbidity 1
	2.494129e-003,
	3.556297e-003,
	2.965923e-004,
	2.713084e-003,
	1.335823e-001,
	8.293879e-002,
	// albedo 0, turbidity 2
	2.473622e-003,
	3.518055e-003,
	4.432438e-004,
	1.754027e-003,
	1.352516e-001,
	8.253805e-002,
	// albedo 0, turbidity 3
	2.485307e-003,
	3.507686e-003,
	4.235269e-004,
	1.120748e-003,
	1.360769e-001,
	8.328522e-002,
	// albedo 0, turbidity 4
	2.421491e-003,
	3.278595e-003,
	1.395344e-003,
	-1.953245e-003,
	1.392978e-001,
	8.376885e-002,
	// albedo 0, turbidity 5
	2.403587e-003,
	3.114517e-003,
	2.224702e-003,
	-5.305220e-003,
	1.435766e-001,
	8.315234e-002,
	// albedo 0, turbidity 6
	2.351950e-003,
	2.915308e-003,
	3.179213e-003,
	-8.297787e-003,
	1.471589e-001,
	8.200387e-002,
	// albedo 0, turbidity 7
	2.347797e-003,
	2.761449e-003,
	3.671854e-003,
	-1.012039e-002,
	1.480091e-001,
	8.399335e-002,
	// albedo 0, turbidity 8
	2.296250e-003,
	2.420416e-003,
	5.106803e-003,
	-1.515460e-002,
	1.526421e-001,
	8.454641e-002,
	// albedo 0, turbidity 9
	2.193368e-003,
	1.826966e-003,
	7.606333e-003,
	-2.312584e-002,
	1.588488e-001,
	8.547295e-002,
	// albedo 0, turbidity 10
	2.037533e-003,
	9.415569e-004,
	1.104382e-002,
	-3.348390e-002,
	1.637893e-001,
	8.792408e-002,
	// albedo 1, turbidity 1
	3.061048e-003,
	2.126839e-003,
	1.132767e-002,
	-2.788848e-002,
	1.948610e-001,
	1.618476e-001,
	// albedo 1, turbidity 2
	3.047180e-003,
	2.153513e-003,
	1.116935e-002,
	-2.810228e-002,
	1.949994e-001,
	1.614103e-001,
	// albedo 1, turbidity 3
	3.038920e-003,
	2.051613e-003,
	1.130934e-002,
	-2.861029e-002,
	1.941964e-001,
	1.617911e-001,
	// albedo 1, turbidity 4
	2.963024e-003,
	1.869150e-003,
	1.189063e-002,
	-3.088695e-002,
	1.962576e-001,
	1.593205e-001,
	// albedo 1, turbidity 5
	2.918936e-003,
	1.726267e-003,
	1.250792e-002,
	-3.337994e-002,
	1.973927e-001,
	1.577752e-001,
	// albedo 1, turbidity 6
	2.855489e-003,
	1.647214e-003,
	1.256484e-002,
	-3.387525e-002,
	1.965371e-001,
	1.571482e-001,
	// albedo 1, turbidity 7
	2.825443e-003,
	1.406555e-003,
	1.336433e-002,
	-3.675617e-002,
	1.982073e-001,
	1.535780e-001,
	// albedo 1, turbidity 8
	2.678428e-003,
	1.109106e-003,
	1.431453e-002,
	-4.011878e-002,
	1.979278e-001,
	1.510186e-001,
	// albedo 1, turbidity 9
	2.555750e-003,
	6.244779e-004,
	1.562522e-002,
	-4.466841e-002,
	1.968517e-001,
	1.462399e-001,
	// albedo 1, turbidity 10
	2.323920e-003,
	1.300657e-004,
	1.663828e-002,
	-4.826021e-002,
	1.889056e-001,
	1.427310e-001,
};

double dataset400[] = 
{
	// albedo 0, turbidity 1
	-1.869600e+000,
	-9.575785e-001,
	-6.993871e+000,
	7.306207e+000,
	-3.240320e-002,
	3.834949e-001,
	4.369976e-005,
	2.254773e+000,
	5.025988e-001,
	-1.746138e+000,
	-1.001117e+000,
	-1.758295e+000,
	2.492931e+000,
	-6.202861e-002,
	4.442043e-001,
	-3.779550e-004,
	1.411622e+000,
	4.890101e-001,
	-1.536453e+000,
	-5.330479e-001,
	1.126830e+000,
	-2.452367e+000,
	-6.694842e-002,
	-2.983825e-002,
	2.320196e-003,
	5.488905e+000,
	5.403856e-001,
	-1.069780e+000,
	-5.815078e-001,
	8.612956e-001,
	1.301347e+000,
	-4.089489e-001,
	1.269432e+000,
	-9.018004e-003,
	-2.283572e+000,
	3.760374e-001,
	-1.060384e+000,
	-2.207518e-001,
	6.362691e-001,
	-5.757237e-001,
	4.275177e-001,
	8.443714e-002,
	2.082596e-002,
	3.125040e+000,
	7.891611e-001,
	-1.077246e+000,
	-2.993040e-001,
	8.167430e-001,
	2.203982e-001,
	-3.984213e+000,
	1.123699e+000,
	1.313138e-002,
	1.750491e+000,
	4.999653e-001,
	// albedo 0, turbidity 2
	-1.752499e+000,
	-9.053927e-001,
	-1.080943e+001,
	1.110516e+001,
	-2.092090e-002,
	3.348109e-001,
	-8.432141e-006,
	2.326824e+000,
	9.000500e-001,
	-1.888565e+000,
	-1.067725e+000,
	1.491851e+000,
	-7.934014e-001,
	-4.853718e-002,
	5.346693e-001,
	9.170370e-005,
	1.397595e+000,
	-3.635730e-001,
	-1.471013e+000,
	-5.497976e-001,
	-4.310423e-001,
	-8.787275e-001,
	-9.206447e-002,
	-1.490862e-001,
	-4.078054e-005,
	5.442983e+000,
	1.757010e+000,
	-1.061905e+000,
	-5.429222e-001,
	1.412232e+000,
	8.460977e-001,
	-2.973654e-001,
	1.357299e+000,
	-5.347332e-003,
	-2.444304e+000,
	-3.363016e-002,
	-1.071200e+000,
	-2.263246e-001,
	3.639469e-001,
	-6.109244e-001,
	-2.484665e-001,
	-7.097027e-002,
	4.735641e-002,
	3.445733e+000,
	8.486491e-001,
	-1.081645e+000,
	-3.128264e-001,
	8.436471e-001,
	3.884148e-001,
	-5.004662e+000,
	1.137000e+000,
	1.500838e-002,
	1.585647e+000,
	5.832608e-001,
	// albedo 0, turbidity 3
	-1.774187e+000,
	-9.327599e-001,
	-9.130103e+000,
	9.413272e+000,
	-2.448089e-002,
	3.487996e-001,
	-3.033497e-006,
	2.291071e+000,
	6.408360e-001,
	-1.849342e+000,
	-1.038735e+000,
	2.863013e+000,
	-2.260302e+000,
	-5.040252e-002,
	4.583723e-001,
	1.008690e-002,
	1.502617e+000,
	7.223351e-002,
	-1.624679e+000,
	-7.257060e-001,
	-1.493033e+000,
	5.658415e-001,
	-2.079847e-001,
	-4.651180e-002,
	-3.701743e-002,
	4.858534e+000,
	1.342775e+000,
	-8.692395e-001,
	-3.025565e-001,
	1.630221e+000,
	-4.624355e-002,
	8.408669e-002,
	1.091981e+000,
	6.506253e-002,
	-1.403006e+000,
	2.076066e-001,
	-1.169258e+000,
	-3.711802e-001,
	3.440155e-001,
	-1.044556e-001,
	-3.304858e+000,
	1.185883e-001,
	1.489352e-002,
	2.642598e+000,
	8.151882e-001,
	-1.058391e+000,
	-2.657785e-001,
	6.984363e-001,
	9.737578e-002,
	-1.903943e+000,
	8.963329e-001,
	6.480860e-002,
	2.034024e+000,
	5.870424e-001,
	// albedo 0, turbidity 4
	-1.898858e+000,
	-1.031814e+000,
	-9.726056e+000,
	1.000989e+001,
	-2.125268e-002,
	3.569897e-001,
	-2.706653e-006,
	2.147646e+000,
	5.982401e-001,
	-2.136007e+000,
	-1.206456e+000,
	3.801172e+000,
	-3.254852e+000,
	-4.516490e-002,
	4.001123e-001,
	2.151890e-002,
	1.481457e+000,
	1.444904e-001,
	-1.355343e+000,
	-6.736369e-001,
	-2.052620e+000,
	1.298239e+000,
	-1.986869e-001,
	6.321488e-002,
	-6.792635e-002,
	4.482593e+000,
	1.322565e+000,
	-9.063816e-001,
	-1.873797e-001,
	1.559544e+000,
	-2.631298e-001,
	5.988684e-002,
	9.375378e-001,
	9.681349e-002,
	-6.480890e-001,
	2.362949e-001,
	-1.170470e+000,
	-3.968082e-001,
	2.266604e-001,
	-2.018118e-001,
	-3.768512e+000,
	9.706445e-002,
	6.046660e-002,
	2.723200e+000,
	7.968878e-001,
	-1.085813e+000,
	-3.519543e-001,
	7.537557e-001,
	3.003522e-001,
	-1.811803e+000,
	7.945754e-001,
	5.293207e-002,
	1.335214e+000,
	6.385980e-001,
	// albedo 0, turbidity 5
	-1.743240e+000,
	-9.391727e-001,
	-8.905876e+000,
	9.139326e+000,
	-2.333803e-002,
	3.093783e-001,
	-2.051734e-006,
	2.320564e+000,
	5.474845e-001,
	-2.624196e+000,
	-1.516703e+000,
	5.053093e+000,
	-4.599198e+000,
	-4.248730e-002,
	4.820250e-001,
	1.829762e-002,
	1.216991e+000,
	2.739806e-001,
	-1.040612e+000,
	-6.103044e-001,
	-3.190021e+000,
	3.216574e+000,
	-3.285978e-001,
	-1.982489e-001,
	-5.367025e-002,
	3.984414e+000,
	1.158312e+000,
	-9.537244e-001,
	-6.895800e-003,
	1.788307e+000,
	-2.659655e+000,
	6.473584e-001,
	1.333544e+000,
	5.529579e-002,
	8.049825e-001,
	4.930209e-001,
	-1.163791e+000,
	-5.095388e-001,
	1.215079e-001,
	3.427998e+000,
	-9.243257e+000,
	-5.059496e-001,
	1.412681e-001,
	1.829389e+000,
	5.544610e-001,
	-1.118058e+000,
	-3.706501e-001,
	6.885180e-001,
	-1.596776e-003,
	-3.279613e+000,
	1.068229e+000,
	3.010797e-002,
	1.479756e+000,
	7.483765e-001,
	// albedo 0, turbidity 6
	-1.811701e+000,
	-1.002650e+000,
	-9.194183e+000,
	9.469966e+000,
	-2.224886e-002,
	3.237441e-001,
	-2.632967e-006,
	2.168879e+000,
	5.952956e-001,
	-2.746180e+000,
	-1.592055e+000,
	4.225172e+000,
	-3.929912e+000,
	-3.866297e-002,
	3.982440e-001,
	3.812089e-002,
	1.390284e+000,
	1.922369e-001,
	-9.558770e-001,
	-6.401790e-001,
	-2.117905e+000,
	2.293799e+000,
	-2.226591e-001,
	6.151477e-002,
	-1.223358e-001,
	3.475975e+000,
	1.124575e+000,
	-9.065351e-001,
	1.443765e-001,
	7.871576e-001,
	-1.631026e+000,
	1.537369e-001,
	8.353048e-001,
	1.849704e-001,
	1.650615e+000,
	4.473559e-001,
	-1.180081e+000,
	-5.441674e-001,
	3.963103e-001,
	1.375519e+000,
	-4.882926e+000,
	-9.391794e-004,
	6.455569e-002,
	1.774670e+000,
	6.989373e-001,
	-1.128755e+000,
	-3.892532e-001,
	5.327884e-001,
	1.825253e+000,
	-2.335719e+000,
	5.863162e-001,
	5.535626e-002,
	1.452293e+000,
	6.920090e-001,
	// albedo 0, turbidity 7
	-2.042064e+000,
	-1.144943e+000,
	-5.152625e+000,
	5.384535e+000,
	-3.519943e-002,
	3.025845e-001,
	-2.994849e-006,
	2.113418e+000,
	6.000255e-001,
	-2.700541e+000,
	-1.485611e+000,
	2.159154e+000,
	-2.188608e+000,
	-5.879735e-002,
	3.921779e-001,
	5.020849e-002,
	1.869923e+000,
	2.118398e-001,
	-1.187417e+000,
	-1.102630e+000,
	-9.404690e-001,
	2.427532e+000,
	-2.948903e-001,
	-3.437257e-002,
	-1.636446e-001,
	1.894926e+000,
	1.001327e+000,
	-5.639857e-001,
	7.170770e-001,
	-1.146502e-001,
	-3.487513e+000,
	-7.711076e-001,
	1.046031e+000,
	2.606854e-001,
	3.873520e+000,
	5.637980e-001,
	-1.363103e+000,
	-8.396317e-001,
	5.750351e-001,
	4.317766e+000,
	-2.364722e+000,
	-4.135433e-001,
	2.669162e-002,
	5.768700e-001,
	6.649078e-001,
	-1.102449e+000,
	-3.685043e-001,
	4.622549e-001,
	-2.018634e-003,
	-3.947538e+000,
	8.449276e-001,
	8.837036e-002,
	1.601304e+000,
	7.026980e-001,
	// albedo 0, turbidity 8
	-2.314053e+000,
	-1.314766e+000,
	-7.125646e+000,
	7.357344e+000,
	-2.585710e-002,
	2.863908e-001,
	-2.425744e-006,
	2.039404e+000,
	5.594003e-001,
	-2.630411e+000,
	-1.404258e+000,
	3.675058e+000,
	-3.804226e+000,
	-4.249037e-002,
	3.486414e-001,
	5.675141e-002,
	1.944935e+000,
	2.880711e-001,
	-1.884599e+000,
	-1.657069e+000,
	-1.731916e+000,
	3.034605e+000,
	-1.746846e-001,
	-1.559184e-002,
	-1.600465e-001,
	1.915108e+000,
	9.460232e-001,
	6.351036e-002,
	1.061776e+000,
	1.195544e-002,
	-3.018584e+000,
	-5.618808e-001,
	1.008146e+000,
	2.013783e-001,
	3.212273e+000,
	6.523624e-001,
	-1.672505e+000,
	-9.752710e-001,
	5.282860e-001,
	3.776331e+000,
	-4.325128e+000,
	-4.384279e-001,
	1.352387e-001,
	8.847662e-001,
	5.717158e-001,
	-1.007695e+000,
	-3.840375e-001,
	3.463543e-001,
	2.848366e+000,
	-2.105699e+000,
	4.636429e-001,
	2.800131e-002,
	1.306056e+000,
	7.618236e-001,
	// albedo 0, turbidity 9
	-2.865406e+000,
	-1.637174e+000,
	-7.429613e+000,
	7.592861e+000,
	-2.196505e-002,
	2.800873e-001,
	-3.908530e-006,
	1.962505e+000,
	5.891464e-001,
	-3.196334e+000,
	-1.512711e+000,
	3.947880e+000,
	-4.029796e+000,
	-3.699620e-002,
	1.461452e-001,
	5.921432e-002,
	1.806132e+000,
	2.331816e-001,
	-2.335492e+000,
	-2.353032e+000,
	-1.764665e+000,
	2.841986e+000,
	-7.331326e-002,
	4.537047e-001,
	-1.668000e-001,
	2.156269e+000,
	9.812486e-001,
	3.278911e-001,
	1.315177e+000,
	-1.438189e-001,
	-2.859630e+000,
	-8.436262e-001,
	2.645711e-001,
	2.154409e-001,
	2.264493e+000,
	5.975203e-001,
	-1.738015e+000,
	-1.091057e+000,
	5.425696e-001,
	4.650166e+000,
	-3.975190e+000,
	2.066035e-001,
	1.017332e-001,
	9.321625e-001,
	6.517783e-001,
	-1.006457e+000,
	-4.243112e-001,
	1.934952e-001,
	2.795030e+000,
	-1.680697e+000,
	-9.428375e-002,
	7.158314e-002,
	1.082383e+000,
	7.234775e-001,
	// albedo 0, turbidity 10
	-4.195701e+000,
	-2.171135e+000,
	-5.278016e+000,
	5.393085e+000,
	-2.419182e-002,
	2.050075e-001,
	-3.797795e-006,
	1.853402e+000,
	6.912927e-001,
	-4.119053e+000,
	-1.648023e+000,
	2.332552e+000,
	-2.173813e+000,
	-6.442977e-002,
	2.188945e-001,
	3.548565e-002,
	1.792598e+000,
	4.162082e-002,
	-4.016823e+000,
	-3.599323e+000,
	-6.179057e-001,
	6.454998e-001,
	-9.913704e-002,
	2.770986e-001,
	-9.265471e-002,
	2.227501e+000,
	1.179216e+000,
	1.066227e+000,
	1.392783e+000,
	-9.653695e-001,
	-5.471637e-001,
	-8.500569e-001,
	4.678476e-001,
	8.760324e-002,
	1.564314e+000,
	4.885251e-001,
	-1.855594e+000,
	-1.029300e+000,
	8.521013e-001,
	3.975027e+000,
	-3.806819e+000,
	-2.044703e-002,
	1.757298e-001,
	7.790123e-001,
	6.918921e-001,
	-1.014961e+000,
	-6.014045e-001,
	1.926619e-002,
	2.357335e+000,
	-1.312911e+000,
	-8.783609e-002,
	7.739369e-002,
	7.356770e-001,
	7.042591e-001,
	// albedo 1, turbidity 1
	-1.467874e+000,
	-7.636581e-001,
	-7.251111e+000,
	7.726558e+000,
	-2.759341e-002,
	3.527534e-001,
	5.340629e-005,
	2.007747e+000,
	5.447487e-001,
	-1.863242e+000,
	-1.048209e+000,
	-1.580541e+000,
	2.558030e+000,
	-5.622126e-002,
	3.053960e-001,
	-4.657733e-004,
	9.956390e-001,
	3.409087e-001,
	-1.384101e+000,
	-5.553588e-001,
	1.191974e+000,
	-2.157512e+000,
	-3.567589e-002,
	1.020018e-001,
	2.940191e-003,
	4.555372e+000,
	8.736043e-001,
	-9.828878e-001,
	-4.220161e-001,
	1.184916e+000,
	9.230716e-001,
	-4.062756e-001,
	1.064980e+000,
	-1.060088e-002,
	-1.764815e+000,
	2.932808e-001,
	-1.057001e+000,
	-2.727017e-001,
	1.000018e+000,
	-3.108668e-001,
	6.848382e-001,
	-1.682596e-001,
	2.301218e-002,
	2.075821e+000,
	7.647327e-001,
	-1.058165e+000,
	-2.436130e-001,
	1.074414e+000,
	8.554434e-002,
	-3.846431e+000,
	7.595465e-001,
	9.729528e-006,
	1.915942e+000,
	4.999612e-001,
	// albedo 1, turbidity 2
	-1.610179e+000,
	-8.336019e-001,
	-1.443356e+001,
	1.492556e+001,
	-1.381931e-002,
	2.902743e-001,
	-7.665717e-006,
	1.981513e+000,
	9.000423e-001,
	-2.004083e+000,
	-1.148388e+000,
	3.747156e+000,
	-2.808560e+000,
	-3.298677e-002,
	4.224754e-001,
	4.166438e-004,
	8.792110e-001,
	-2.321793e-001,
	-1.178554e+000,
	-5.064839e-001,
	-1.117126e+000,
	2.815740e-001,
	-7.068438e-002,
	-3.031589e-002,
	-3.468069e-003,
	4.539093e+000,
	1.385612e+000,
	-1.091191e+000,
	-4.200919e-001,
	1.826508e+000,
	7.131992e-002,
	-1.883417e-001,
	1.061437e+000,
	1.311913e-002,
	-1.972550e+000,
	2.511246e-001,
	-9.987232e-001,
	-2.073656e-001,
	7.443384e-001,
	-7.245157e-002,
	-5.588818e-001,
	-1.364188e-001,
	2.023795e-002,
	2.829822e+000,
	7.230021e-001,
	-1.075477e+000,
	-2.556973e-001,
	1.051690e+000,
	3.075960e-002,
	-1.895492e+000,
	6.408333e-001,
	2.109454e-002,
	1.891240e+000,
	5.652527e-001,
	// albedo 1, turbidity 3
	-1.531711e+000,
	-8.266123e-001,
	-9.324763e+000,
	9.811491e+000,
	-1.988560e-002,
	3.404598e-001,
	-2.068369e-006,
	1.869307e+000,
	5.860842e-001,
	-2.113444e+000,
	-1.209106e+000,
	3.526508e+000,
	-2.628730e+000,
	-4.634065e-002,
	3.182739e-001,
	9.500212e-003,
	1.004871e+000,
	2.109968e-001,
	-1.196720e+000,
	-5.485073e-001,
	-1.667136e+000,
	9.920197e-001,
	-1.622954e-001,
	6.951315e-002,
	-3.482877e-002,
	4.214632e+000,
	1.108967e+000,
	-1.003096e+000,
	-3.200944e-001,
	2.042427e+000,
	-4.417822e-001,
	-1.404599e-001,
	9.288535e-001,
	6.077264e-002,
	-1.386737e+000,
	4.557129e-001,
	-1.061048e+000,
	-2.908451e-001,
	6.390633e-001,
	1.406786e-001,
	-1.834706e+000,
	-1.432145e-001,
	1.914080e-002,
	2.284516e+000,
	5.965839e-001,
	-1.054623e+000,
	-2.267971e-001,
	1.028491e+000,
	-3.197518e-003,
	-1.705329e+000,
	6.747358e-001,
	2.072713e-002,
	2.140509e+000,
	7.205824e-001,
	// albedo 1, turbidity 4
	-1.610001e+000,
	-8.622601e-001,
	-1.060181e+001,
	1.106133e+001,
	-1.648296e-002,
	2.590559e-001,
	-1.904522e-006,
	1.930415e+000,
	6.006964e-001,
	-2.308577e+000,
	-1.440194e+000,
	2.937335e+000,
	-2.093599e+000,
	-3.430217e-002,
	3.427774e-001,
	2.590705e-002,
	5.673750e-001,
	1.250422e-001,
	-9.441254e-001,
	-3.064812e-001,
	-8.895068e-001,
	2.815271e-001,
	-8.036228e-002,
	1.867017e-001,
	-7.809247e-002,
	4.774631e+000,
	1.391904e+000,
	-1.214397e+000,
	-5.423074e-001,
	1.361001e+000,
	1.782273e-001,
	-3.648675e-001,
	7.181838e-001,
	1.135547e-001,
	-1.935982e+000,
	1.820361e-001,
	-9.377631e-001,
	-1.533211e-001,
	8.439993e-001,
	-3.893771e-001,
	-2.564779e-001,
	-6.742272e-002,
	2.255856e-002,
	2.780601e+000,
	7.972008e-001,
	-1.101428e+000,
	-3.069552e-001,
	9.687591e-001,
	4.500576e-001,
	-4.912444e+000,
	5.398387e-001,
	3.638172e-002,
	1.582999e+000,
	6.425950e-001,
	// albedo 1, turbidity 5
	-1.687541e+000,
	-9.378170e-001,
	-8.475686e+000,
	8.929279e+000,
	-2.132746e-002,
	2.917650e-001,
	-2.177239e-006,
	1.863407e+000,
	5.908179e-001,
	-2.278432e+000,
	-1.387936e+000,
	5.425292e+000,
	-4.725025e+000,
	-3.892912e-002,
	4.084727e-001,
	1.842665e-002,
	8.461986e-001,
	1.673366e-001,
	-1.302702e+000,
	-7.200083e-001,
	-3.084331e+000,
	3.191487e+000,
	-3.222828e-001,
	-1.493849e-001,
	-5.641672e-002,
	3.624218e+000,
	1.256086e+000,
	-7.886965e-001,
	-3.966453e-002,
	2.110076e+000,
	-2.232935e+000,
	7.269719e-001,
	1.163410e+000,
	7.133744e-002,
	-1.660119e-001,
	4.329084e-001,
	-1.157760e+000,
	-4.084596e-001,
	5.689088e-001,
	2.379590e+000,
	-9.687743e+000,
	-5.598487e-001,
	9.191895e-002,
	1.923047e+000,
	5.802927e-001,
	-1.047250e+000,
	-2.873072e-001,
	1.046858e+000,
	6.890046e-001,
	-2.947892e+000,
	7.245997e-001,
	1.125227e-002,
	1.352625e+000,
	7.193979e-001,
	// albedo 1, turbidity 6
	-1.643764e+000,
	-9.086683e-001,
	-8.750078e+000,
	9.165653e+000,
	-2.025728e-002,
	2.737848e-001,
	-2.240987e-006,
	1.943471e+000,
	5.731722e-001,
	-2.473069e+000,
	-1.505194e+000,
	5.448737e+000,
	-4.863726e+000,
	-3.662439e-002,
	1.938729e-001,
	4.741355e-002,
	8.586572e-001,
	2.284408e-001,
	-1.232599e+000,
	-7.896777e-001,
	-3.056911e+000,
	3.546334e+000,
	-1.948820e-001,
	3.344216e-001,
	-1.376967e-001,
	3.029469e+000,
	1.120573e+000,
	-6.095289e-001,
	2.745468e-001,
	1.809782e+000,
	-2.593032e+000,
	-1.710009e-002,
	5.537278e-001,
	1.935506e-001,
	1.259882e+000,
	4.970103e-001,
	-1.324655e+000,
	-6.255071e-001,
	6.240868e-001,
	2.021182e+000,
	-5.876050e+000,
	-1.507819e-001,
	3.301250e-002,
	1.142019e+000,
	5.986671e-001,
	-9.888131e-001,
	-2.584852e-001,
	1.052160e+000,
	7.264224e-001,
	-2.563426e+000,
	5.494058e-001,
	1.821983e-002,
	1.277896e+000,
	7.557967e-001,
	// albedo 1, turbidity 7
	-2.100689e+000,
	-1.204431e+000,
	-7.573121e+000,
	8.039632e+000,
	-2.300526e-002,
	2.839214e-001,
	-2.346958e-006,
	1.678847e+000,
	5.536303e-001,
	-2.610610e+000,
	-1.587799e+000,
	5.460928e+000,
	-5.158708e+000,
	-4.505650e-002,
	3.876929e-001,
	3.852459e-002,
	1.172854e+000,
	3.104745e-001,
	-8.340903e-001,
	-7.487965e-001,
	-3.154774e+000,
	4.600448e+000,
	-1.818975e-001,
	-1.871764e-001,
	-1.222094e-001,
	2.067197e+000,
	8.802127e-001,
	-9.180308e-001,
	3.752197e-001,
	1.471125e+000,
	-4.691789e+000,
	-5.128294e-001,
	1.164707e+000,
	1.831224e-001,
	2.900937e+000,
	7.718397e-001,
	-1.126819e+000,
	-6.652330e-001,
	7.386065e-001,
	5.362044e+000,
	-6.196453e+000,
	-7.280092e-001,
	6.312604e-002,
	2.874666e-001,
	4.225580e-001,
	-1.091610e+000,
	-3.433417e-001,
	1.042206e+000,
	1.075776e-001,
	-4.443940e+000,
	7.469895e-001,
	3.166247e-002,
	1.019495e+000,
	7.523771e-001,
	// albedo 1, turbidity 8
	-2.234623e+000,
	-1.310221e+000,
	-8.525764e+000,
	8.932373e+000,
	-1.814945e-002,
	2.615153e-001,
	-2.992344e-006,
	1.672403e+000,
	5.897681e-001,
	-2.566352e+000,
	-1.472664e+000,
	5.894182e+000,
	-5.619094e+000,
	-3.204346e-002,
	2.993298e-001,
	4.281047e-002,
	1.303481e+000,
	2.453403e-001,
	-1.577477e+000,
	-1.491725e+000,
	-3.065840e+000,
	4.446634e+000,
	-1.689128e-001,
	9.559287e-002,
	-1.384724e-001,
	1.778589e+000,
	9.159045e-001,
	-2.747774e-001,
	8.787060e-001,
	1.071723e+000,
	-4.169230e+000,
	-3.029966e-001,
	6.326611e-001,
	2.145395e-001,
	2.611218e+000,
	7.082708e-001,
	-1.433045e+000,
	-8.939972e-001,
	8.538090e-001,
	4.481475e+000,
	-5.978961e+000,
	-1.608369e-001,
	5.335732e-002,
	3.510751e-001,
	5.421327e-001,
	-9.961738e-001,
	-3.023960e-001,
	9.152994e-001,
	2.936173e+000,
	-2.311060e+000,
	1.216642e-001,
	2.844950e-002,
	9.492671e-001,
	6.929460e-001,
	// albedo 1, turbidity 9
	-2.428587e+000,
	-1.538689e+000,
	-9.076712e+000,
	9.464050e+000,
	-1.503392e-002,
	2.373401e-001,
	-2.770103e-006,
	1.537508e+000,
	5.959289e-001,
	-3.240872e+000,
	-1.646067e+000,
	6.091797e+000,
	-5.738481e+000,
	-3.098072e-002,
	2.698026e-001,
	3.864212e-002,
	1.286514e+000,
	2.461153e-001,
	-1.970987e+000,
	-2.124015e+000,
	-2.894000e+000,
	3.858260e+000,
	-1.449222e-001,
	1.903898e-001,
	-1.194017e-001,
	1.882566e+000,
	8.764452e-001,
	3.562238e-002,
	1.092427e+000,
	6.291668e-001,
	-3.337396e+000,
	-2.817141e-001,
	4.799828e-001,
	1.674350e-001,
	1.943489e+000,
	7.728749e-001,
	-1.501790e+000,
	-9.408520e-001,
	1.000954e+000,
	4.599103e+000,
	-5.295662e+000,
	-1.111397e-001,
	1.040124e-001,
	3.185557e-001,
	4.959400e-001,
	-9.859417e-001,
	-3.827367e-001,
	8.040930e-001,
	2.980678e+000,
	-2.015582e+000,
	-8.947514e-003,
	1.696367e-002,
	6.489501e-001,
	7.555598e-001,
	// albedo 1, turbidity 10
	-3.758956e+000,
	-2.159015e+000,
	-7.207163e+000,
	7.516659e+000,
	-1.643521e-002,
	2.465725e-001,
	-4.045068e-006,
	1.471688e+000,
	6.687943e-001,
	-4.635664e+000,
	-1.766046e+000,
	4.282669e+000,
	-4.058908e+000,
	-2.908998e-002,
	1.202684e-001,
	3.167305e-002,
	1.450927e+000,
	8.171815e-002,
	-3.458011e+000,
	-3.657280e+000,
	-1.484743e+000,
	2.264533e+000,
	-1.033120e-001,
	4.282323e-001,
	-8.387881e-002,
	1.687334e+000,
	1.130604e+000,
	9.673527e-001,
	1.500425e+000,
	-3.604932e-001,
	-2.050346e+000,
	-3.778381e-001,
	2.416298e-001,
	8.439313e-002,
	1.458583e+000,
	5.816071e-001,
	-1.808078e+000,
	-1.089975e+000,
	1.291838e+000,
	5.144631e+000,
	-5.047822e+000,
	4.301183e-002,
	1.426941e-001,
	1.187472e-001,
	6.145551e-001,
	-8.399253e-001,
	-3.832885e-001,
	6.306417e-001,
	2.179775e+000,
	-1.492762e+000,
	-1.682763e-001,
	4.109851e-002,
	4.221724e-001,
	7.086504e-001,
};

double datasetRad400[] = 
{
	// albedo 0, turbidity 1
	5.767645e-003,
	1.219302e-002,
	-2.188467e-002,
	8.262275e-002,
	1.719839e-001,
	1.233791e-001,
	// albedo 0, turbidity 2
	5.661981e-003,
	1.258489e-002,
	-2.324339e-002,
	8.372421e-002,
	1.730981e-001,
	1.255797e-001,
	// albedo 0, turbidity 3
	5.644031e-003,
	1.248986e-002,
	-2.287316e-002,
	7.999388e-002,
	1.815345e-001,
	1.252983e-001,
	// albedo 0, turbidity 4
	5.479152e-003,
	1.215496e-002,
	-2.122586e-002,
	7.189527e-002,
	1.962517e-001,
	1.245648e-001,
	// albedo 0, turbidity 5
	5.385972e-003,
	1.187505e-002,
	-2.025911e-002,
	6.602510e-002,
	2.067312e-001,
	1.264910e-001,
	// albedo 0, turbidity 6
	5.319970e-003,
	1.160513e-002,
	-1.904232e-002,
	6.030292e-002,
	2.158311e-001,
	1.261204e-001,
	// albedo 0, turbidity 7
	5.179289e-003,
	1.125842e-002,
	-1.708641e-002,
	5.111365e-002,
	2.285030e-001,
	1.278260e-001,
	// albedo 0, turbidity 8
	4.994685e-003,
	1.025385e-002,
	-1.254777e-002,
	3.429945e-002,
	2.490310e-001,
	1.302691e-001,
	// albedo 0, turbidity 9
	4.759538e-003,
	8.205142e-003,
	-3.246300e-003,
	3.909938e-003,
	2.819549e-001,
	1.322430e-001,
	// albedo 0, turbidity 10
	4.412341e-003,
	4.910210e-003,
	1.040886e-002,
	-3.627125e-002,
	3.147182e-001,
	1.409331e-001,
	// albedo 1, turbidity 1
	7.016633e-003,
	9.796846e-003,
	-9.823849e-004,
	2.324224e-002,
	3.035010e-001,
	2.573850e-001,
	// albedo 1, turbidity 2
	6.984411e-003,
	9.584282e-003,
	-5.945671e-004,
	2.061312e-002,
	3.090019e-001,
	2.547364e-001,
	// albedo 1, turbidity 3
	6.865141e-003,
	9.540856e-003,
	-3.311701e-004,
	1.726495e-002,
	3.147099e-001,
	2.539552e-001,
	// albedo 1, turbidity 4
	6.701191e-003,
	9.352606e-003,
	3.392916e-004,
	1.159886e-002,
	3.228446e-001,
	2.530111e-001,
	// albedo 1, turbidity 5
	6.513679e-003,
	8.873317e-003,
	2.339520e-003,
	2.817964e-003,
	3.341256e-001,
	2.496316e-001,
	// albedo 1, turbidity 6
	6.405833e-003,
	8.466409e-003,
	3.661909e-003,
	-3.045984e-003,
	3.414328e-001,
	2.464327e-001,
	// albedo 1, turbidity 7
	6.220899e-003,
	7.997469e-003,
	5.957591e-003,
	-1.302863e-002,
	3.523355e-001,
	2.418785e-001,
	// albedo 1, turbidity 8
	5.912801e-003,
	6.826679e-003,
	1.008544e-002,
	-2.771812e-002,
	3.640405e-001,
	2.386599e-001,
	// albedo 1, turbidity 9
	5.550967e-003,
	5.157051e-003,
	1.661696e-002,
	-5.072656e-002,
	3.807009e-001,
	2.315489e-001,
	// albedo 1, turbidity 10
	5.011118e-003,
	2.636752e-003,
	2.499879e-002,
	-7.576617e-002,
	3.828189e-001,
	2.328116e-001,
};

double dataset440[] = 
{
	// albedo 0, turbidity 1
	-1.397312e+000,
	-5.327311e-001,
	-5.456059e+000,
	5.777674e+000,
	-5.111575e-002,
	4.730804e-001,
	7.375500e-003,
	3.032806e+000,
	5.181890e-001,
	-1.561639e+000,
	-7.024946e-001,
	-2.140322e+000,
	2.841761e+000,
	-8.846023e-002,
	5.529005e-001,
	6.219344e-003,
	2.004212e+000,
	3.701256e-001,
	-1.047473e+000,
	-1.152734e-001,
	2.275873e+000,
	-3.020347e+000,
	-1.739218e-001,
	2.250142e-001,
	-2.731776e-002,
	6.659723e+000,
	1.067495e+000,
	-1.298483e+000,
	-5.788209e-001,
	4.906412e-001,
	1.522576e+000,
	-5.650061e-001,
	1.544707e+000,
	4.638003e-002,
	-3.742019e+000,
	2.485397e-001,
	-9.485899e-001,
	-7.383610e-002,
	1.039247e+000,
	-4.744931e-001,
	-1.822357e-001,
	2.284415e-001,
	-4.796962e-002,
	4.363935e+000,
	8.217971e-001,
	-1.099082e+000,
	-2.001688e-001,
	7.365077e-001,
	1.068489e-001,
	-5.005434e+000,
	1.508145e+000,
	8.181497e-002,
	3.226865e+000,
	4.999418e-001,
	// albedo 0, turbidity 2
	-1.416143e+000,
	-5.515006e-001,
	-7.045898e+000,
	7.448161e+000,
	-4.504075e-002,
	5.055437e-001,
	-1.378949e-006,
	2.955475e+000,
	6.184716e-001,
	-1.698183e+000,
	-8.272914e-001,
	9.984388e-001,
	-2.511235e-001,
	-9.262675e-002,
	5.681534e-001,
	5.377123e-003,
	1.631048e+000,
	1.137691e-001,
	-9.234085e-001,
	-2.165404e-002,
	6.483039e-002,
	-8.535145e-001,
	-2.497457e-001,
	1.695057e-001,
	-3.410225e-002,
	6.726925e+000,
	1.331197e+000,
	-1.265077e+000,
	-5.034231e-001,
	1.196547e+000,
	3.666463e-001,
	-3.960044e-001,
	1.404008e+000,
	1.129300e-001,
	-2.644439e+000,
	1.103356e-001,
	-1.008210e+000,
	-1.455232e-001,
	7.347739e-001,
	2.462433e-002,
	-2.534587e+000,
	3.088590e-001,
	-6.687136e-002,
	3.786007e+000,
	9.578369e-001,
	-1.076840e+000,
	-1.851501e-001,
	7.341818e-001,
	-2.658571e-003,
	-5.001762e+000,
	1.275390e+000,
	1.277410e-001,
	3.223315e+000,
	5.147659e-001,
	// albedo 0, turbidity 3
	-1.449526e+000,
	-5.738159e-001,
	-8.976383e+000,
	9.275142e+000,
	-3.157845e-002,
	5.011970e-001,
	-1.218363e-006,
	3.001006e+000,
	5.662190e-001,
	-1.748840e+000,
	-9.338946e-001,
	5.557460e-002,
	9.451626e-001,
	-6.929558e-002,
	5.458365e-001,
	5.505399e-003,
	8.818793e-001,
	2.135274e-001,
	-8.369988e-001,
	1.127967e-001,
	8.846958e-001,
	-2.467908e+000,
	-8.394011e-002,
	1.684067e-001,
	-3.352743e-002,
	7.957386e+000,
	1.297777e+000,
	-1.284515e+000,
	-5.332365e-001,
	5.511261e-001,
	1.702784e+000,
	-6.616281e-001,
	1.349449e+000,
	1.269152e-001,
	-3.247373e+000,
	2.115827e-001,
	-9.889637e-001,
	-9.962819e-002,
	6.096776e-001,
	-8.472749e-001,
	7.672924e-001,
	7.425160e-002,
	2.113714e-002,
	4.990637e+000,
	8.274585e-001,
	-1.093910e+000,
	-2.211349e-001,
	6.959659e-001,
	3.423174e-001,
	-5.004213e+000,
	1.347201e+000,
	1.198192e-001,
	2.547517e+000,
	6.329489e-001,
	// albedo 0, turbidity 4
	-1.394462e+000,
	-5.287733e-001,
	-8.095187e+000,
	8.076613e+000,
	-1.275227e-002,
	1.916790e-001,
	4.741296e-002,
	3.145140e+000,
	5.071760e-001,
	-2.234192e+000,
	-1.437079e+000,
	-5.734544e-001,
	1.248687e+000,
	-4.136344e-002,
	7.671749e-001,
	-1.273584e-002,
	4.751894e-001,
	4.116995e-001,
	-4.063889e-001,
	4.920785e-001,
	3.865520e-001,
	2.254008e-001,
	-1.618861e-001,
	1.950875e-001,
	-8.622479e-002,
	3.836900e+000,
	1.108189e+000,
	-1.366924e+000,
	-4.557853e-001,
	-6.731417e-001,
	-3.011452e-001,
	2.413069e-001,
	1.404821e+000,
	1.920278e-001,
	6.394529e+000,
	4.219713e-001,
	-9.128947e-001,
	1.980978e-002,
	5.119874e-001,
	8.027541e-002,
	-3.680159e+000,
	6.597416e-001,
	3.853339e-002,
	3.969131e+000,
	8.351942e-001,
	-1.162856e+000,
	-3.606511e-001,
	7.055795e-001,
	-2.702137e-003,
	4.777294e-001,
	-7.722331e-001,
	3.446509e-001,
	1.186834e+000,
	5.118539e-001,
	// albedo 0, turbidity 5
	-1.563353e+000,
	-6.916347e-001,
	-4.154766e+001,
	4.181703e+001,
	-5.673370e-003,
	4.344900e-001,
	1.839829e-003,
	2.669278e+000,
	5.021266e-001,
	-1.948172e+000,
	-1.080669e+000,
	1.082552e+001,
	-1.034262e+001,
	-1.196421e-002,
	3.895739e-001,
	5.621831e-002,
	1.347130e+000,
	4.561106e-001,
	-9.155219e-001,
	-1.456265e-001,
	-2.177275e+000,
	2.079788e+000,
	-2.154465e-002,
	7.743816e-001,
	-2.181642e-001,
	4.897704e+000,
	1.035464e+000,
	-1.010898e+000,
	-4.425431e-002,
	3.067880e-001,
	-6.899235e-001,
	-1.891895e-001,
	3.015686e-001,
	4.236422e-001,
	1.901582e+000,
	3.916662e-001,
	-1.159005e+000,
	-4.048136e-001,
	5.385745e-001,
	3.423651e-001,
	1.474365e-001,
	3.516065e-001,
	2.564260e-003,
	1.815518e+000,
	7.634079e-001,
	-1.081675e+000,
	-2.556981e-001,
	6.544471e-001,
	4.093649e-001,
	-3.215201e+000,
	9.116400e-001,
	1.406660e-001,
	1.869407e+000,
	6.968119e-001,
	// albedo 0, turbidity 6
	-1.561484e+000,
	-7.153039e-001,
	-1.623772e+001,
	1.650713e+001,
	-1.394913e-002,
	4.467465e-001,
	9.613464e-004,
	2.564429e+000,
	5.363746e-001,
	-2.308050e+000,
	-1.314851e+000,
	-1.484346e+000,
	1.928705e+000,
	-2.164130e-002,
	2.817711e-001,
	7.177671e-002,
	1.146387e+000,
	3.025595e-001,
	-4.886429e-001,
	8.279799e-002,
	2.432876e+000,
	-2.276257e+000,
	-4.799742e-002,
	9.362010e-001,
	-2.753669e-001,
	4.784291e+000,
	1.180593e+000,
	-1.306115e+000,
	-1.759650e-001,
	-1.392008e+000,
	3.119302e-001,
	-2.268673e-001,
	8.336951e-002,
	5.250725e-001,
	2.534962e+000,
	2.800244e-001,
	-1.016608e+000,
	-3.429911e-001,
	5.659470e-001,
	9.044333e-001,
	7.387499e-002,
	4.267609e-001,
	-4.165623e-002,
	1.452779e+000,
	8.409560e-001,
	-1.127637e+000,
	-2.854231e-001,
	4.933964e-001,
	-3.379287e-003,
	-1.181893e+000,
	8.164171e-001,
	1.910509e-001,
	1.979338e+000,
	6.658885e-001,
	// albedo 0, turbidity 7
	-1.675310e+000,
	-8.020443e-001,
	-1.136130e+001,
	1.159861e+001,
	-1.871156e-002,
	4.151400e-001,
	-1.940992e-006,
	2.486322e+000,
	5.256426e-001,
	-2.071301e+000,
	-1.175325e+000,
	1.789426e+000,
	-1.455233e+000,
	-2.855906e-002,
	3.218745e-001,
	7.776969e-002,
	1.431615e+000,
	3.478887e-001,
	-1.093503e+000,
	-4.120496e-001,
	-8.598647e-002,
	4.564844e-001,
	-1.231980e-001,
	7.992132e-001,
	-2.910745e-001,
	3.881502e+000,
	1.064658e+000,
	-7.736128e-001,
	2.385498e-001,
	-7.867818e-001,
	-6.009723e-001,
	-1.808566e-001,
	-8.796429e-003,
	5.412620e-001,
	2.991552e+000,
	4.008143e-001,
	-1.259083e+000,
	-5.300975e-001,
	5.418031e-001,
	1.150966e+000,
	-7.553821e-001,
	5.991000e-001,
	-2.344718e-003,
	1.097939e+000,
	7.756612e-001,
	-1.094148e+000,
	-3.178958e-001,
	4.126954e-001,
	3.591106e-001,
	-1.415744e+000,
	3.908399e-001,
	1.806147e-001,
	1.584959e+000,
	6.862009e-001,
	// albedo 0, turbidity 8
	-1.815485e+000,
	-9.306778e-001,
	-1.249527e+001,
	1.271288e+001,
	-1.497209e-002,
	3.576353e-001,
	-2.464284e-006,
	2.326460e+000,
	5.655414e-001,
	-2.225570e+000,
	-1.213627e+000,
	6.082472e+000,
	-5.907562e+000,
	-2.446452e-002,
	2.113558e-001,
	7.708802e-002,
	1.647556e+000,
	2.416155e-001,
	-1.439532e+000,
	-8.666475e-001,
	-2.734807e+000,
	3.355265e+000,
	-1.311068e-001,
	1.048703e+000,
	-2.887025e-001,
	3.419973e+000,
	1.146322e+000,
	-5.599890e-001,
	4.437236e-001,
	1.582320e-001,
	-2.000110e+000,
	-2.859304e-001,
	-5.600631e-001,
	5.382793e-001,
	1.986387e+000,
	3.455121e-001,
	-1.319304e+000,
	-6.466246e-001,
	5.684685e-001,
	2.050330e+000,
	-2.796053e+000,
	1.001659e+000,
	-1.161356e-002,
	9.737235e-001,
	8.101246e-001,
	-1.097281e+000,
	-3.336023e-001,
	1.781708e-001,
	1.733079e+000,
	-1.378806e+000,
	-1.870394e-001,
	1.997578e-001,
	1.456148e+000,
	6.791796e-001,
	// albedo 0, turbidity 9
	-2.208666e+000,
	-1.219745e+000,
	-7.548669e+000,
	7.680830e+000,
	-2.012473e-002,
	3.627866e-001,
	-2.906182e-006,
	2.147138e+000,
	6.340095e-001,
	-1.967348e+000,
	-9.528057e-001,
	4.171590e+000,
	-4.002838e+000,
	-5.074552e-002,
	1.581866e-001,
	5.920106e-002,
	1.981564e+000,
	1.023257e-001,
	-3.150304e+000,
	-2.193706e+000,
	-2.016165e+000,
	2.374337e+000,
	-6.793058e-002,
	9.623811e-001,
	-2.195022e-001,
	2.736885e+000,
	1.252161e+000,
	4.737094e-001,
	1.067875e+000,
	-1.003861e-001,
	-1.566752e+000,
	-1.217264e+000,
	-4.270598e-001,
	3.968055e-001,
	1.234108e+000,
	3.105789e-001,
	-1.706975e+000,
	-9.607442e-001,
	7.140098e-001,
	3.981202e+000,
	-3.521433e+000,
	6.308820e-001,
	5.140937e-002,
	7.435120e-001,
	8.074305e-001,
	-1.012042e+000,
	-3.372525e-001,
	2.589450e-002,
	1.768224e+000,
	-1.059990e+000,
	-1.299077e-001,
	1.790337e-001,
	1.091012e+000,
	6.873854e-001,
	// albedo 0, turbidity 10
	-2.912541e+000,
	-1.677524e+000,
	-3.843452e+000,
	3.954207e+000,
	-3.414327e-002,
	2.945890e-001,
	-4.245832e-006,
	1.934337e+000,
	7.258748e-001,
	-1.567383e+000,
	-8.279686e-001,
	1.690940e+000,
	-1.413268e+000,
	-1.216792e-001,
	7.332798e-002,
	4.862765e-002,
	2.034766e+000,
	-5.041561e-002,
	-6.058613e+000,
	-3.509207e+000,
	-6.312870e-001,
	-4.558316e-002,
	6.168891e-002,
	8.153413e-001,
	-1.686845e-001,
	2.670227e+000,
	1.362906e+000,
	1.347177e+000,
	9.821888e-001,
	-9.242155e-001,
	5.851576e-001,
	-1.897421e+000,
	-2.729487e-002,
	2.866724e-001,
	7.306238e-001,
	2.792136e-001,
	-1.810783e+000,
	-1.027512e+000,
	1.216071e+000,
	5.270108e+000,
	-3.887149e+000,
	6.193256e-002,
	2.774610e-002,
	1.484756e-001,
	8.033249e-001,
	-9.801965e-001,
	-3.375841e-001,
	-3.004804e-001,
	1.385754e+000,
	-6.834540e-001,
	5.827734e-002,
	2.268309e-001,
	1.028696e+000,
	6.797371e-001,
	// albedo 1, turbidity 1
	-1.345260e+000,
	-5.085528e-001,
	-6.052009e+000,
	6.604590e+000,
	-4.300752e-002,
	4.745234e-001,
	6.591457e-003,
	2.595142e+000,
	5.013653e-001,
	-1.573525e+000,
	-7.133524e-001,
	-1.671346e+000,
	2.693205e+000,
	-7.828763e-002,
	2.915699e-001,
	1.795879e-002,
	1.469445e+000,
	4.927472e-001,
	-1.013665e+000,
	-1.731419e-001,
	2.043423e+000,
	-2.919634e+000,
	-1.020807e-001,
	5.467619e-001,
	-4.041481e-002,
	5.853992e+000,
	5.272064e-001,
	-1.173191e+000,
	-3.964683e-001,
	1.097258e+000,
	1.509973e+000,
	-5.675641e-001,
	9.815927e-001,
	6.962319e-002,
	-3.358210e+000,
	4.263117e-001,
	-1.003507e+000,
	-1.124908e-001,
	1.030642e+000,
	-5.357088e-001,
	6.114201e-001,
	1.628414e-001,
	-5.701497e-002,
	4.541126e+000,
	8.084996e-001,
	-1.071959e+000,
	-1.567262e-001,
	9.923029e-001,
	1.457160e-001,
	-4.742907e+000,
	7.280970e-001,
	6.770360e-002,
	3.919300e+000,
	4.999529e-001,
	// albedo 1, turbidity 2
	-1.399982e+000,
	-5.538549e-001,
	-6.983148e+000,
	7.513966e+000,
	-3.358417e-002,
	3.667027e-001,
	1.158837e-002,
	2.499680e+000,
	5.598537e-001,
	-1.602839e+000,
	-7.835806e-001,
	1.200264e+000,
	-1.454290e-001,
	-7.431927e-002,
	5.374263e-001,
	9.505505e-004,
	1.096167e+000,
	2.185838e-001,
	-9.587294e-001,
	-6.134134e-002,
	2.234030e-001,
	-8.115395e-001,
	-2.344054e-001,
	2.018782e-001,
	-4.192332e-002,
	6.331499e+000,
	1.353587e+000,
	-1.166832e+000,
	-4.057833e-001,
	1.461335e+000,
	3.165401e-001,
	-3.245858e-001,
	1.199323e+000,
	1.100274e-001,
	-2.727373e+000,
	5.329788e-002,
	-1.023178e+000,
	-1.351631e-001,
	9.944251e-001,
	2.103341e-002,
	-2.460318e+000,
	5.136074e-003,
	-5.267951e-002,
	4.097235e+000,
	9.388837e-001,
	-1.071426e+000,
	-1.726491e-001,
	1.048949e+000,
	-2.624840e-003,
	-4.993124e+000,
	6.621513e-001,
	7.801931e-002,
	3.227750e+000,
	5.363265e-001,
	// albedo 1, turbidity 3
	-1.362723e+000,
	-5.257224e-001,
	-1.325130e+001,
	1.374641e+001,
	-1.971887e-002,
	4.480379e-001,
	-9.588735e-007,
	2.679516e+000,
	5.628531e-001,
	-1.824466e+000,
	-9.877790e-001,
	4.631069e+000,
	-3.630521e+000,
	-4.340325e-002,
	3.913450e-001,
	3.415899e-002,
	4.746800e-001,
	2.022772e-001,
	-6.435267e-001,
	1.629762e-001,
	-1.452097e+000,
	8.028761e-001,
	-9.611017e-002,
	4.267105e-001,
	-1.023573e-001,
	6.652106e+000,
	1.406057e+000,
	-1.400277e+000,
	-5.150235e-001,
	1.752017e+000,
	-1.699743e-001,
	-3.411643e-001,
	8.465596e-001,
	2.127075e-001,
	-2.235971e+000,
	4.728189e-002,
	-9.044866e-001,
	-7.979493e-002,
	8.298122e-001,
	-5.604698e-002,
	-1.433761e+000,
	1.011757e-001,
	-7.175544e-002,
	4.243075e+000,
	9.588179e-001,
	-1.115618e+000,
	-2.148000e-001,
	1.109081e+000,
	2.661209e-001,
	-5.008111e+000,
	6.333048e-001,
	9.274718e-002,
	2.494529e+000,
	5.890657e-001,
	// albedo 1, turbidity 4
	-1.389611e+000,
	-5.579886e-001,
	-1.045229e+001,
	1.092342e+001,
	-2.282772e-002,
	4.054079e-001,
	2.781558e-003,
	2.578484e+000,
	5.372706e-001,
	-1.893851e+000,
	-1.116122e+000,
	2.111553e+000,
	-8.775468e-001,
	-5.640158e-002,
	5.399894e-001,
	1.929352e-002,
	-5.585557e-002,
	2.870402e-001,
	-7.015617e-001,
	1.884526e-001,
	-1.660273e-001,
	-8.785899e-001,
	-5.471987e-002,
	1.787856e-001,
	-9.958870e-002,
	7.207213e+000,
	1.277933e+000,
	-1.279075e+000,
	-4.794032e-001,
	9.037342e-001,
	6.225399e-001,
	-6.592270e-001,
	9.474313e-001,
	2.524811e-001,
	-2.485658e+000,
	2.050401e-001,
	-9.744212e-001,
	-9.899254e-002,
	9.474600e-001,
	-2.536639e-001,
	5.390432e-001,
	-8.465488e-002,
	-3.140532e-002,
	4.512343e+000,
	8.530654e-001,
	-1.093264e+000,
	-2.115594e-001,
	9.876876e-001,
	7.531309e-002,
	-5.003648e+000,
	6.719560e-001,
	1.111699e-001,
	2.412349e+000,
	6.482966e-001,
	// albedo 1, turbidity 5
	-1.410458e+000,
	-5.905263e-001,
	-4.146328e+001,
	4.190254e+001,
	-5.607421e-003,
	4.437719e-001,
	-1.948391e-006,
	2.496743e+000,
	5.031933e-001,
	-1.817258e+000,
	-9.848495e-001,
	1.089217e+001,
	-1.028029e+001,
	-1.221684e-002,
	3.317008e-001,
	5.060062e-002,
	1.198443e+000,
	4.449482e-001,
	-8.920534e-001,
	-8.835804e-002,
	-2.111594e+000,
	2.083599e+000,
	-1.507800e-002,
	6.993567e-001,
	-1.987686e-001,
	4.793539e+000,
	1.072586e+000,
	-1.048633e+000,
	-1.110825e-001,
	5.438710e-001,
	-6.707296e-001,
	-1.825365e-001,
	2.307221e-001,
	4.056218e-001,
	1.886912e+000,
	3.579576e-001,
	-1.094223e+000,
	-3.084727e-001,
	9.739595e-001,
	3.972140e-001,
	1.511647e-001,
	2.788218e-001,
	-6.279180e-002,
	1.866444e+000,
	7.995203e-001,
	-1.078162e+000,
	-2.176197e-001,
	1.088756e+000,
	4.329413e-001,
	-3.209490e+000,
	8.364785e-001,
	7.689785e-002,
	1.943182e+000,
	7.150615e-001,
	// albedo 1, turbidity 6
	-1.455846e+000,
	-6.322333e-001,
	-1.618289e+001,
	1.656258e+001,
	-1.280603e-002,
	4.130359e-001,
	-9.061644e-007,
	2.461391e+000,
	5.315915e-001,
	-2.222251e+000,
	-1.233356e+000,
	-1.454954e+000,
	1.957432e+000,
	-1.730555e-002,
	2.418496e-001,
	7.240262e-002,
	1.061939e+000,
	3.148474e-001,
	-4.536196e-001,
	1.457295e-001,
	2.483934e+000,
	-2.244550e+000,
	-4.593767e-002,
	8.967621e-001,
	-2.712877e-001,
	4.732142e+000,
	1.188839e+000,
	-1.277343e+000,
	-2.046024e-001,
	-1.229720e+000,
	3.977256e-001,
	-2.209195e-001,
	6.033235e-002,
	5.267707e-001,
	2.536445e+000,
	2.759606e-001,
	-1.029833e+000,
	-2.979843e-001,
	8.742883e-001,
	1.037710e+000,
	1.350257e-001,
	4.066094e-001,
	-1.376375e-001,
	1.500753e+000,
	8.676699e-001,
	-1.095935e+000,
	-2.211775e-001,
	9.320585e-001,
	8.955212e-002,
	-1.113388e+000,
	7.909911e-001,
	1.393848e-001,
	2.057146e+000,
	6.699739e-001,
	// albedo 1, turbidity 7
	-1.571831e+000,
	-7.466353e-001,
	-1.226063e+001,
	1.265995e+001,
	-1.514083e-002,
	3.639653e-001,
	-2.504287e-006,
	2.204454e+000,
	5.468861e-001,
	-2.235398e+000,
	-1.371434e+000,
	1.787996e+000,
	-1.073965e+000,
	-2.503530e-002,
	2.143584e-001,
	7.703453e-002,
	5.207181e-001,
	2.714312e-001,
	-6.944677e-001,
	-7.243136e-002,
	-6.193104e-001,
	9.567440e-001,
	-6.317194e-002,
	8.881508e-001,
	-2.783301e-001,
	4.224532e+000,
	1.192802e+000,
	-1.133391e+000,
	-9.811942e-002,
	2.312721e-001,
	-1.100585e+000,
	-3.655097e-001,
	2.268787e-003,
	5.074358e-001,
	1.512457e+000,
	3.165593e-001,
	-1.057051e+000,
	-3.424797e-001,
	9.536822e-001,
	1.034064e+000,
	6.413292e-001,
	1.165363e-001,
	-4.248128e-002,
	1.592803e+000,
	7.875911e-001,
	-1.096695e+000,
	-2.745143e-001,
	1.077920e+000,
	-8.435082e-004,
	-3.715956e+000,
	5.197900e-001,
	1.171467e-001,
	1.236912e+000,
	6.915287e-001,
	// albedo 1, turbidity 8
	-1.711623e+000,
	-9.023881e-001,
	-9.799257e+000,
	1.022040e+001,
	-1.708447e-002,
	3.309925e-001,
	-3.241111e-006,
	1.932295e+000,
	5.844205e-001,
	-2.351937e+000,
	-1.340391e+000,
	6.329976e+000,
	-6.054139e+000,
	-2.843868e-002,
	2.298301e-001,
	7.698142e-002,
	1.109800e+000,
	1.863187e-001,
	-1.141314e+000,
	-6.670322e-001,
	-3.262632e+000,
	4.551521e+000,
	-8.614941e-002,
	8.058038e-001,
	-2.791051e-001,
	3.084281e+000,
	1.236638e+000,
	-7.950557e-001,
	2.489854e-001,
	9.966347e-001,
	-3.391737e+000,
	-7.235716e-001,
	-2.155609e-001,
	5.126659e-001,
	1.452322e+000,
	2.882812e-001,
	-1.182289e+000,
	-5.192524e-001,
	9.672941e-001,
	3.091448e+000,
	-4.193043e+000,
	4.051469e-001,
	-5.708309e-002,
	9.386723e-001,
	8.208828e-001,
	-1.080579e+000,
	-2.918654e-001,
	9.499317e-001,
	2.856082e+000,
	-2.256007e+000,
	1.377750e-002,
	1.012914e-001,
	9.716489e-001,
	6.832750e-001,
	// albedo 1, turbidity 9
	-1.964781e+000,
	-1.162652e+000,
	-6.074737e+000,
	6.497797e+000,
	-2.595660e-002,
	3.222936e-001,
	-3.220871e-006,
	1.685891e+000,
	6.501551e-001,
	-2.352213e+000,
	-1.199539e+000,
	4.248376e+000,
	-3.876965e+000,
	-6.837923e-002,
	1.764412e-001,
	5.514810e-002,
	1.442736e+000,
	6.979575e-002,
	-2.560247e+000,
	-1.883591e+000,
	-1.916723e+000,
	2.598994e+000,
	-2.372381e-002,
	8.442578e-001,
	-2.063113e-001,
	2.359942e+000,
	1.287838e+000,
	7.281064e-002,
	7.835433e-001,
	1.380748e-001,
	-2.065580e+000,
	-1.696648e+000,
	-4.575316e-001,
	3.840004e-001,
	9.397056e-001,
	3.103904e-001,
	-1.444446e+000,
	-7.662151e-001,
	1.364103e+000,
	4.930232e+000,
	-4.455564e+000,
	6.735458e-001,
	-4.052978e-003,
	3.194173e-001,
	7.842959e-001,
	-1.039666e+000,
	-3.171617e-001,
	7.295920e-001,
	2.813846e+000,
	-1.561230e+000,
	-4.128303e-001,
	1.004149e-001,
	6.653613e-001,
	6.980277e-001,
	// albedo 1, turbidity 10
	-2.999915e+000,
	-1.721740e+000,
	-4.796494e+000,
	5.021888e+000,
	-2.163250e-002,
	3.309183e-001,
	-4.051804e-006,
	1.645464e+000,
	7.145890e-001,
	-1.673162e+000,
	-1.056666e+000,
	3.209766e+000,
	-2.559187e+000,
	-7.456364e-002,
	6.215063e-002,
	4.469425e-002,
	1.242757e+000,
	-1.580590e-002,
	-5.775475e+000,
	-3.239700e+000,
	-1.356432e+000,
	1.099950e+000,
	-9.497509e-002,
	7.121875e-001,
	-1.656838e-001,
	2.553396e+000,
	1.286227e+000,
	1.241869e+000,
	6.671222e-001,
	-4.156007e-001,
	-8.167921e-001,
	-1.037816e+000,
	5.950065e-002,
	3.114868e-001,
	6.414114e-001,
	3.677503e-001,
	-1.580126e+000,
	-7.852349e-001,
	1.749569e+000,
	5.987990e+000,
	-5.075133e+000,
	-4.693815e-002,
	-5.106759e-002,
	-9.755925e-001,
	7.440092e-001,
	-9.732917e-001,
	-1.939297e-001,
	2.709367e-001,
	1.352990e+000,
	-9.040352e-001,
	5.181217e-003,
	2.302437e-001,
	1.506500e+000,
	6.840186e-001,
};

double datasetRad440[] = 
{
	// albedo 0, turbidity 1
	9.406889e-003,
	1.954373e-002,
	-4.018205e-002,
	1.740051e-001,
	1.351020e-001,
	1.365376e-001,
	// albedo 0, turbidity 2
	9.206049e-003,
	2.042313e-002,
	-4.377380e-002,
	1.787089e-001,
	1.388614e-001,
	1.384128e-001,
	// albedo 0, turbidity 3
	9.050889e-003,
	2.086396e-002,
	-4.652916e-002,
	1.794829e-001,
	1.524222e-001,
	1.376563e-001,
	// albedo 0, turbidity 4
	8.656343e-003,
	2.210653e-002,
	-5.212791e-002,
	1.836315e-001,
	1.663040e-001,
	1.419649e-001,
	// albedo 0, turbidity 5
	8.355466e-003,
	2.244975e-002,
	-5.393078e-002,
	1.788056e-001,
	1.868417e-001,
	1.445069e-001,
	// albedo 0, turbidity 6
	8.187585e-003,
	2.235434e-002,
	-5.291187e-002,
	1.693688e-001,
	2.073941e-001,
	1.424517e-001,
	// albedo 0, turbidity 7
	7.909229e-003,
	2.199365e-002,
	-5.165975e-002,
	1.577725e-001,
	2.297489e-001,
	1.468516e-001,
	// albedo 0, turbidity 8
	7.580566e-003,
	2.048421e-002,
	-4.471863e-002,
	1.277026e-001,
	2.737620e-001,
	1.497600e-001,
	// albedo 0, turbidity 9
	7.101943e-003,
	1.675094e-002,
	-2.761544e-002,
	7.078506e-002,
	3.397147e-001,
	1.557184e-001,
	// albedo 0, turbidity 10
	6.525444e-003,
	1.090411e-002,
	-1.995302e-003,
	-8.176097e-003,
	4.124321e-001,
	1.714881e-001,
	// albedo 1, turbidity 1
	1.111702e-002,
	1.783998e-002,
	-1.949635e-002,
	1.124970e-001,
	2.993330e-001,
	2.864943e-001,
	// albedo 1, turbidity 2
	1.099681e-002,
	1.809609e-002,
	-2.099087e-002,
	1.131858e-001,
	3.057413e-001,
	2.866962e-001,
	// albedo 1, turbidity 3
	1.070017e-002,
	1.818573e-002,
	-2.159895e-002,
	1.084494e-001,
	3.229180e-001,
	2.835407e-001,
	// albedo 1, turbidity 4
	1.032234e-002,
	1.871074e-002,
	-2.469404e-002,
	1.069731e-001,
	3.380450e-001,
	2.864479e-001,
	// albedo 1, turbidity 5
	9.893912e-003,
	1.844953e-002,
	-2.358500e-002,
	9.439551e-002,
	3.642566e-001,
	2.829554e-001,
	// albedo 1, turbidity 6
	9.650400e-003,
	1.877062e-002,
	-2.542361e-002,
	9.189004e-002,
	3.720610e-001,
	2.856265e-001,
	// albedo 1, turbidity 7
	9.322628e-003,
	1.810055e-002,
	-2.246559e-002,
	7.543314e-002,
	3.958251e-001,
	2.842134e-001,
	// albedo 1, turbidity 8
	8.842659e-003,
	1.604245e-002,
	-1.397353e-002,
	4.233011e-002,
	4.358270e-001,
	2.789888e-001,
	// albedo 1, turbidity 9
	8.169168e-003,
	1.265551e-002,
	4.076399e-004,
	-7.877623e-003,
	4.830048e-001,
	2.768485e-001,
	// albedo 1, turbidity 10
	7.383449e-003,
	7.340131e-003,
	2.094279e-002,
	-7.138907e-002,
	5.217098e-001,
	2.803810e-001,
};

double dataset480[] = 
{
	// albedo 0, turbidity 1
	-1.255072e+000,
	-3.501170e-001,
	-5.952795e+000,
	6.529723e+000,
	-6.362962e-002,
	6.436422e-001,
	7.745270e-003,
	3.657426e+000,
	5.329375e-001,
	-1.344988e+000,
	-4.365880e-001,
	-1.750961e+000,
	2.262943e+000,
	-1.049983e-001,
	3.754288e-001,
	5.298712e-002,
	3.402851e+000,
	3.874229e-001,
	-1.073402e+000,
	-1.395260e-001,
	2.839003e+000,
	-2.827315e+000,
	-1.882090e-001,
	1.054349e+000,
	-8.976330e-002,
	5.604794e+000,
	6.740510e-001,
	-1.183711e+000,
	-4.011868e-001,
	7.358740e-001,
	1.479436e+000,
	-7.268596e-001,
	1.133998e+000,
	1.205942e-001,
	-4.232970e+000,
	1.060586e+000,
	-1.018668e+000,
	-8.561816e-002,
	1.030241e+000,
	-4.461392e-001,
	3.940284e-001,
	1.220382e+000,
	-1.391238e-001,
	5.771847e+000,
	5.627180e-001,
	-1.080081e+000,
	-1.746769e-001,
	1.174843e+000,
	9.389450e-002,
	-4.893194e+000,
	1.162505e+000,
	1.563406e-001,
	2.606800e+000,
	4.999990e-001,
	// albedo 0, turbidity 2
	-1.268430e+000,
	-3.752425e-001,
	-8.504068e+000,
	9.021017e+000,
	-4.092613e-002,
	6.553965e-001,
	8.607147e-003,
	3.444138e+000,
	5.600385e-001,
	-1.459780e+000,
	-5.882818e-001,
	1.800729e+000,
	-9.674514e-001,
	-8.308819e-002,
	4.453337e-001,
	4.086836e-002,
	1.853978e+000,
	2.818975e-001,
	-8.680288e-001,
	1.148721e-001,
	3.161508e-001,
	-1.524870e+000,
	-1.921031e-001,
	6.496299e-001,
	4.422347e-004,
	8.241268e+000,
	9.821338e-001,
	-1.277439e+000,
	-4.550135e-001,
	1.088681e+000,
	1.552370e+000,
	-6.184442e-001,
	1.386667e+000,
	1.035135e-001,
	-3.331179e+000,
	5.236122e-001,
	-9.964896e-001,
	-9.832891e-002,
	9.746026e-001,
	-9.125638e-001,
	-7.457170e-001,
	9.111352e-001,
	-7.027011e-002,
	4.669829e+000,
	7.455938e-001,
	-1.083449e+000,
	-1.686372e-001,
	1.003727e+000,
	4.085513e-001,
	-4.725304e+000,
	1.112591e+000,
	1.855240e-001,
	3.038195e+000,
	5.969305e-001,
	// albedo 0, turbidity 3
	-1.290677e+000,
	-3.901158e-001,
	-9.520695e+000,
	9.828711e+000,
	-3.154131e-002,
	5.939314e-001,
	2.686840e-002,
	3.612397e+000,
	5.140176e-001,
	-1.535002e+000,
	-6.667464e-001,
	2.735758e-002,
	9.423936e-001,
	-8.287240e-002,
	6.775029e-001,
	4.575744e-003,
	1.432097e+000,
	3.872415e-001,
	-7.903104e-001,
	1.563438e-001,
	-2.022567e-001,
	-1.026670e+000,
	9.063977e-003,
	3.942033e-001,
	-1.241980e-002,
	7.980026e+000,
	1.066191e+000,
	-1.278947e+000,
	-3.694875e-001,
	8.111792e-001,
	4.993027e-001,
	-1.096772e+000,
	1.008837e+000,
	2.920972e-001,
	-7.314209e-001,
	3.179440e-001,
	-1.006667e+000,
	-1.519095e-001,
	8.774664e-001,
	-1.909283e-001,
	3.756189e+000,
	9.311862e-001,
	-9.327427e-002,
	3.499747e+000,
	8.574583e-001,
	-1.086931e+000,
	-1.774734e-001,
	8.989024e-001,
	5.536469e-002,
	-3.474034e+000,
	9.736834e-001,
	2.325787e-001,
	2.809427e+000,
	6.246481e-001,
	// albedo 0, turbidity 4
	-1.346571e+000,
	-4.451276e-001,
	-2.373159e+001,
	2.408962e+001,
	-1.225268e-002,
	5.720568e-001,
	1.636363e-002,
	3.288957e+000,
	5.104502e-001,
	-1.607315e+000,
	-7.416360e-001,
	-5.233286e-001,
	1.169215e+000,
	-2.350907e-002,
	4.942922e-001,
	3.544231e-002,
	1.659598e+000,
	3.959771e-001,
	-8.259129e-001,
	9.305732e-002,
	4.864320e+000,
	-5.585537e+000,
	-4.428624e-002,
	7.540493e-001,
	-1.060506e-001,
	6.548781e+000,
	1.138009e+000,
	-1.204471e+000,
	-2.620580e-001,
	-2.637261e+000,
	3.057335e+000,
	-1.226916e-001,
	5.657925e-001,
	4.446409e-001,
	1.136957e+000,
	2.881385e-001,
	-1.035718e+000,
	-2.116415e-001,
	1.288642e+000,
	-3.834162e-001,
	-9.488050e-002,
	7.404996e-001,
	-6.538922e-002,
	2.336877e+000,
	8.612030e-001,
	-1.087946e+000,
	-1.841898e-001,
	4.491757e-001,
	1.691479e-001,
	1.022577e-001,
	9.202996e-001,
	2.926112e-001,
	2.844475e+000,
	6.452620e-001,
	// albedo 0, turbidity 5
	-1.381782e+000,
	-4.914069e-001,
	-4.813999e+001,
	4.837634e+001,
	-5.296025e-003,
	5.571609e-001,
	1.649034e-002,
	3.203385e+000,
	5.048069e-001,
	-1.776157e+000,
	-9.226583e-001,
	1.389662e+001,
	-1.292490e+001,
	-1.480095e-002,
	5.073308e-001,
	4.585849e-002,
	7.385206e-001,
	4.280887e-001,
	-8.381948e-001,
	1.229315e-001,
	-3.370527e+000,
	1.825510e+000,
	-9.728251e-003,
	8.572929e-001,
	-1.855299e-001,
	7.471741e+000,
	1.133190e+000,
	-1.125194e+000,
	-2.647028e-001,
	6.942391e-001,
	1.389102e+000,
	-2.216447e-001,
	1.356485e-001,
	5.812792e-001,
	-5.073865e-001,
	2.675490e-001,
	-1.095144e+000,
	-2.442208e-001,
	4.787687e-001,
	-2.707940e+000,
	6.129627e-001,
	7.213058e-001,
	-6.034254e-002,
	2.798703e+000,
	8.787214e-001,
	-1.062019e+000,
	-1.765309e-001,
	5.423897e-001,
	3.783099e+000,
	-5.007038e+000,
	7.376299e-001,
	3.034085e-001,
	2.733411e+000,
	6.555070e-001,
	// albedo 0, turbidity 6
	-1.390263e+000,
	-5.185474e-001,
	-1.630741e+001,
	1.654109e+001,
	-1.499201e-002,
	5.661787e-001,
	1.452544e-002,
	3.046179e+000,
	5.026700e-001,
	-1.935801e+000,
	-9.953289e-001,
	-1.483271e+000,
	1.913745e+000,
	-2.518160e-002,
	4.593343e-001,
	4.285617e-002,
	1.448437e+000,
	4.509310e-001,
	-7.547378e-001,
	2.590987e-002,
	2.480507e+000,
	-2.271835e+000,
	-5.259620e-002,
	9.001709e-001,
	-2.024986e-001,
	4.958191e+000,
	1.036940e+000,
	-1.157324e+000,
	-1.198742e-001,
	-1.440574e+000,
	3.070751e-001,
	-1.807577e-001,
	4.059237e-002,
	6.210184e-001,
	2.425946e+000,
	3.828327e-001,
	-1.065566e+000,
	-3.139616e-001,
	5.715306e-001,
	8.053761e-001,
	1.396364e-001,
	4.009778e-001,
	5.681033e-003,
	1.354013e+000,
	7.861375e-001,
	-1.095972e+000,
	-2.178745e-001,
	4.681537e-001,
	1.235458e-001,
	-1.084613e+000,
	1.006455e+000,
	2.754677e-001,
	2.239616e+000,
	6.954839e-001,
	// albedo 0, turbidity 7
	-1.453150e+000,
	-5.790574e-001,
	-1.243832e+001,
	1.263425e+001,
	-1.892784e-002,
	4.979177e-001,
	1.035899e-002,
	2.982682e+000,
	5.056256e-001,
	-1.925518e+000,
	-1.010928e+000,
	1.513827e+000,
	-9.219873e-001,
	-3.776925e-002,
	4.692652e-001,
	4.083023e-002,
	1.303495e+000,
	4.245150e-001,
	-1.134311e+000,
	-2.754710e-001,
	-2.443212e-001,
	3.845396e-002,
	-1.074645e-001,
	1.066657e+000,
	-2.324557e-001,
	4.996897e+000,
	1.052268e+000,
	-8.094396e-001,
	1.096826e-001,
	-5.117072e-001,
	-1.915992e-001,
	-1.991693e-001,
	-5.943341e-001,
	6.791986e-001,
	1.332014e+000,
	3.606306e-001,
	-1.227889e+000,
	-4.522793e-001,
	5.338266e-002,
	1.074118e+000,
	8.733709e-002,
	1.005448e+000,
	-1.725176e-002,
	1.326110e+000,
	8.063751e-001,
	-1.065450e+000,
	-2.160134e-001,
	3.413994e-001,
	4.950303e-001,
	-1.077199e+000,
	3.654185e-001,
	3.125819e-001,
	1.998536e+000,
	6.865917e-001,
	// albedo 0, turbidity 8
	-1.594869e+000,
	-7.366760e-001,
	-1.252117e+001,
	1.275030e+001,
	-1.697659e-002,
	4.892543e-001,
	2.831848e-003,
	2.542039e+000,
	5.457358e-001,
	-1.980952e+000,
	-9.910920e-001,
	6.178699e+000,
	-5.888582e+000,
	-3.099336e-002,
	3.859266e-001,
	4.511764e-002,
	1.839601e+000,
	2.791527e-001,
	-1.766081e+000,
	-8.995150e-001,
	-2.712687e+000,
	3.263201e+000,
	-1.840688e-001,
	1.305410e+000,
	-2.675879e-001,
	3.647246e+000,
	1.168203e+000,
	-3.742071e-001,
	4.678023e-001,
	6.371403e-002,
	-2.016941e+000,
	-2.723239e-001,
	-1.446876e+000,
	7.533604e-001,
	1.131760e+000,
	2.537537e-001,
	-1.380378e+000,
	-6.406403e-001,
	7.018678e-001,
	2.032023e+000,
	-2.393487e+000,
	1.930827e+000,
	-1.260608e-001,
	7.634327e-001,
	8.870918e-001,
	-1.088465e+000,
	-2.971190e-001,
	1.411657e-001,
	1.879601e+000,
	-1.310304e+000,
	-7.045740e-001,
	3.313185e-001,
	1.264266e+000,
	6.534482e-001,
	// albedo 0, turbidity 9
	-2.229949e+000,
	-1.153733e+000,
	-7.505783e+000,
	7.718722e+000,
	-2.407129e-002,
	4.175820e-001,
	4.559186e-005,
	2.157318e+000,
	6.337774e-001,
	-1.995509e+000,
	-8.778717e-001,
	4.191031e+000,
	-3.968507e+000,
	-5.176872e-002,
	1.960357e-001,
	3.755797e-002,
	1.975436e+000,
	1.077053e-001,
	-3.174785e+000,
	-2.105130e+000,
	-2.062230e+000,
	2.391786e+000,
	-4.217147e-002,
	9.727297e-001,
	-1.540078e-001,
	2.691773e+000,
	1.235189e+000,
	4.882832e-001,
	1.097365e+000,
	-1.866214e-001,
	-1.567231e+000,
	-1.216396e+000,
	-4.391280e-001,
	4.541998e-001,
	1.167636e+000,
	3.003642e-001,
	-1.709118e+000,
	-9.374505e-001,
	6.559000e-001,
	3.977860e+000,
	-3.525762e+000,
	6.202828e-001,
	7.863257e-002,
	6.882512e-001,
	8.161696e-001,
	-9.999977e-001,
	-2.777886e-001,
	9.586687e-003,
	1.766813e+000,
	-1.065121e+000,
	-1.325963e-001,
	2.512239e-001,
	1.055043e+000,
	6.874661e-001,
	// albedo 0, turbidity 10
	-2.932652e+000,
	-1.609416e+000,
	-3.825171e+000,
	3.969752e+000,
	-3.638195e-002,
	3.557402e-001,
	-4.379735e-006,
	1.927804e+000,
	7.278380e-001,
	-1.591732e+000,
	-7.579896e-001,
	1.711976e+000,
	-1.369988e+000,
	-1.107557e-001,
	1.237841e-001,
	1.548121e-002,
	2.024749e+000,
	-4.315379e-002,
	-6.085760e+000,
	-3.429651e+000,
	-6.780006e-001,
	-1.902709e-002,
	6.566034e-002,
	8.329946e-001,
	-1.012845e-001,
	2.617589e+000,
	1.342663e+000,
	1.335204e+000,
	1.035931e+000,
	-1.008915e+000,
	5.915758e-001,
	-1.907371e+000,
	-3.568938e-002,
	3.295382e-001,
	6.546480e-001,
	2.435447e-001,
	-1.800155e+000,
	-1.010684e+000,
	1.160290e+000,
	5.269190e+000,
	-3.895543e+000,
	5.274946e-002,
	3.971324e-002,
	8.769492e-002,
	8.252336e-001,
	-9.843476e-001,
	-3.014031e-001,
	-3.167912e-001,
	1.384556e+000,
	-6.881572e-001,
	5.617519e-002,
	2.805263e-001,
	9.930291e-001,
	6.783964e-001,
	// albedo 1, turbidity 1
	-1.257325e+000,
	-3.441598e-001,
	-5.951667e+000,
	6.530618e+000,
	-5.773033e-002,
	6.437990e-001,
	8.453838e-003,
	3.657343e+000,
	5.329715e-001,
	-1.346061e+000,
	-4.331978e-001,
	-1.749638e+000,
	2.263845e+000,
	-1.013807e-001,
	3.755084e-001,
	5.287214e-002,
	3.402954e+000,
	3.874047e-001,
	-1.073983e+000,
	-1.372222e-001,
	2.840388e+000,
	-2.826616e+000,
	-1.866609e-001,
	1.054193e+000,
	-8.989038e-002,
	5.604984e+000,
	6.739811e-001,
	-1.184707e+000,
	-3.992543e-001,
	7.374377e-001,
	1.479838e+000,
	-7.263903e-001,
	1.133619e+000,
	1.199206e-001,
	-4.232702e+000,
	1.060412e+000,
	-1.021623e+000,
	-8.422241e-002,
	1.032293e+000,
	-4.460168e-001,
	3.941239e-001,
	1.219939e+000,
	-1.420884e-001,
	5.772239e+000,
	5.623142e-001,
	-1.087791e+000,
	-1.754873e-001,
	1.178006e+000,
	9.386850e-002,
	-4.893184e+000,
	1.162164e+000,
	1.535543e-001,
	2.607460e+000,
	4.997706e-001,
	// albedo 1, turbidity 2
	-1.251295e+000,
	-3.651612e-001,
	-9.950987e+000,
	1.058444e+001,
	-3.065334e-002,
	5.979560e-001,
	1.817303e-002,
	3.132460e+000,
	5.458738e-001,
	-1.374134e+000,
	-5.079738e-001,
	2.333109e+000,
	-1.251359e+000,
	-7.802080e-002,
	3.182768e-001,
	3.746599e-002,
	1.963940e+000,
	2.733180e-001,
	-9.862389e-001,
	-2.441831e-002,
	2.657376e-001,
	-1.054016e+000,
	-8.576871e-002,
	7.356127e-001,
	-4.711349e-002,
	6.677884e+000,
	1.206629e+000,
	-1.140461e+000,
	-3.212487e-001,
	1.547332e+000,
	9.031281e-001,
	-8.421239e-001,
	1.166595e+000,
	1.643076e-001,
	-2.534096e+000,
	1.884034e-001,
	-1.049493e+000,
	-1.256523e-001,
	1.205849e+000,
	-3.649526e-001,
	8.075413e-001,
	3.421308e-001,
	-1.173508e-001,
	4.535809e+000,
	9.497555e-001,
	-1.063961e+000,
	-1.336751e-001,
	1.173271e+000,
	1.016777e-001,
	-4.093576e+000,
	4.559998e-001,
	1.519017e-001,
	4.153208e+000,
	5.324846e-001,
	// albedo 1, turbidity 3
	-1.271751e+000,
	-3.837936e-001,
	-1.052025e+001,
	1.102826e+001,
	-2.411879e-002,
	5.019991e-001,
	3.094786e-002,
	3.138107e+000,
	5.059631e-001,
	-1.472034e+000,
	-6.259760e-001,
	-5.356154e-001,
	1.713500e+000,
	-6.089970e-002,
	4.750716e-001,
	6.622428e-003,
	1.224931e+000,
	4.198087e-001,
	-8.587401e-001,
	1.099859e-001,
	3.258521e-001,
	-1.301658e+000,
	-4.452458e-002,
	6.461336e-001,
	-2.947489e-002,
	7.603712e+000,
	1.091511e+000,
	-1.221875e+000,
	-3.659269e-001,
	9.953072e-001,
	8.481237e-001,
	-5.952235e-001,
	1.016442e+000,
	2.259940e-001,
	-1.925411e+000,
	3.654292e-001,
	-1.008105e+000,
	-1.136472e-001,
	1.248935e+000,
	-3.865165e-001,
	1.714619e+000,
	-1.216223e-001,
	-2.436842e-002,
	4.227455e+000,
	7.030495e-001,
	-1.082262e+000,
	-1.513279e-001,
	1.052383e+000,
	2.125686e-001,
	-5.028093e-001,
	8.694047e-001,
	1.099128e-001,
	3.634467e+000,
	7.206727e-001,
	// albedo 1, turbidity 4
	-1.310438e+000,
	-4.332417e-001,
	-2.812457e+001,
	2.859054e+001,
	-7.241887e-003,
	4.123186e-001,
	2.839263e-002,
	2.866138e+000,
	5.063521e-001,
	-1.598864e+000,
	-7.787419e-001,
	4.189377e+000,
	-3.122921e+000,
	-1.896105e-002,
	6.071985e-001,
	1.999660e-002,
	7.039076e-001,
	4.125456e-001,
	-7.834866e-001,
	1.890740e-001,
	1.102853e+000,
	-1.842558e+000,
	-3.985000e-002,
	6.423282e-001,
	-1.131231e-001,
	7.222493e+000,
	1.177285e+000,
	-1.244910e+000,
	-3.668018e-001,
	-2.083168e-001,
	1.051092e+000,
	-1.483362e-001,
	4.066210e-001,
	4.623360e-001,
	-1.971682e-001,
	2.178890e-001,
	-1.010078e+000,
	-1.593623e-001,
	1.747411e+000,
	-6.961852e-002,
	-1.503091e-001,
	5.439839e-001,
	-1.874287e-001,
	2.074758e+000,
	9.133302e-001,
	-1.086611e+000,
	-1.529597e-001,
	4.548984e-001,
	2.836062e-001,
	4.168066e-001,
	3.953841e-001,
	2.451427e-001,
	3.799065e+000,
	6.288711e-001,
	// albedo 1, turbidity 5
	-1.338369e+000,
	-4.683873e-001,
	-3.858110e+001,
	3.898823e+001,
	-5.111812e-003,
	4.638476e-001,
	2.389163e-002,
	2.774207e+000,
	5.242274e-001,
	-1.785780e+000,
	-9.773633e-001,
	6.470331e+000,
	-5.147348e+000,
	-1.593592e-002,
	4.175720e-001,
	2.497956e-002,
	7.090702e-002,
	3.252744e-001,
	-6.972735e-001,
	2.786524e-001,
	4.011350e-003,
	-1.686706e+000,
	-4.966516e-003,
	8.368703e-001,
	-1.225606e-001,
	7.731542e+000,
	1.267577e+000,
	-1.307129e+000,
	-4.728119e-001,
	2.639424e-002,
	2.633155e+000,
	-2.357439e-001,
	1.263362e-001,
	4.765765e-001,
	-2.025027e+000,
	1.705113e-001,
	-9.583414e-001,
	-7.928834e-002,
	1.447497e+000,
	-2.797571e+000,
	8.553597e-001,
	4.842942e-001,
	-7.727878e-002,
	3.765006e+000,
	9.191738e-001,
	-1.114040e+000,
	-2.132678e-001,
	1.030931e+000,
	2.871507e+000,
	-5.013319e+000,
	2.699945e-001,
	1.819978e-001,
	2.239642e+000,
	6.539653e-001,
	// albedo 1, turbidity 6
	-1.393024e+000,
	-5.200008e-001,
	-1.941271e+001,
	1.986171e+001,
	-1.212818e-002,
	5.019138e-001,
	7.897163e-003,
	2.696459e+000,
	5.258316e-001,
	-1.831466e+000,
	-1.018106e+000,
	3.204932e+000,
	-2.139369e+000,
	-2.441969e-002,
	3.191029e-001,
	5.563321e-002,
	1.320760e-001,
	3.265220e-001,
	-7.994553e-001,
	1.337239e-001,
	-1.563712e+000,
	7.392042e-001,
	-3.136373e-002,
	1.008208e+000,
	-1.988762e-001,
	6.626579e+000,
	1.223213e+000,
	-1.159543e+000,
	-2.836180e-001,
	1.057464e+000,
	-3.647533e-001,
	-2.513115e-001,
	-1.995636e-001,
	5.943224e-001,
	-4.865436e-001,
	2.279895e-001,
	-1.044528e+000,
	-2.152538e-001,
	1.023157e+000,
	5.599579e-002,
	6.321805e-001,
	5.155639e-001,
	-1.111252e-001,
	2.282270e+000,
	8.647371e-001,
	-1.092518e+000,
	-1.865821e-001,
	1.057856e+000,
	3.491427e-001,
	-2.631526e+000,
	3.584288e-001,
	2.191649e-001,
	2.389704e+000,
	6.765946e-001,
	// albedo 1, turbidity 7
	-1.384989e+000,
	-5.305700e-001,
	-1.459855e+001,
	1.497673e+001,
	-1.471976e-002,
	4.569028e-001,
	5.419006e-003,
	2.735360e+000,
	5.389891e-001,
	-2.086660e+000,
	-1.234696e+000,
	2.053196e+000,
	-1.257012e+000,
	-2.129117e-002,
	1.990309e-001,
	8.511032e-002,
	-1.312659e-001,
	2.800139e-001,
	-7.309069e-001,
	1.413931e-001,
	-1.773938e-001,
	2.938820e-001,
	-4.933601e-002,
	1.496853e+000,
	-3.213358e-001,
	6.305852e+000,
	1.298086e+000,
	-1.203529e+000,
	-3.216432e-001,
	-1.458970e-001,
	-5.598789e-001,
	-2.934068e-001,
	-1.206192e+000,
	7.793654e-001,
	-9.223710e-001,
	1.229360e-001,
	-1.002538e+000,
	-1.984480e-001,
	1.233954e+000,
	8.779171e-001,
	3.133737e-001,
	1.311239e+000,
	-2.132532e-001,
	2.223702e+000,
	9.461065e-001,
	-1.123572e+000,
	-2.342682e-001,
	9.679089e-001,
	-1.017991e-003,
	-1.960819e+000,
	-1.153680e-001,
	2.843114e-001,
	1.779831e+000,
	6.400916e-001,
	// albedo 1, turbidity 8
	-1.537393e+000,
	-6.924151e-001,
	-1.239252e+001,
	1.285585e+001,
	-1.666284e-002,
	4.429862e-001,
	2.398230e-003,
	2.210714e+000,
	5.509453e-001,
	-1.817841e+000,
	-9.662082e-001,
	6.281905e+000,
	-5.778709e+000,
	-3.131226e-002,
	3.074609e-001,
	4.530074e-002,
	1.409838e+000,
	2.538213e-001,
	-1.790530e+000,
	-8.332867e-001,
	-2.605975e+000,
	3.383959e+000,
	-1.685493e-001,
	1.307568e+000,
	-2.569465e-001,
	3.272862e+000,
	1.247743e+000,
	-3.808658e-001,
	3.525732e-001,
	3.897535e-001,
	-2.085715e+000,
	-1.845614e-001,
	-1.470598e+000,
	7.033938e-001,
	8.475130e-001,
	1.758974e-001,
	-1.374360e+000,
	-5.517879e-001,
	1.276626e+000,
	1.821209e+000,
	-2.480880e+000,
	1.866494e+000,
	-1.649246e-001,
	6.333864e-001,
	9.339444e-001,
	-1.024167e+000,
	-2.097189e-001,
	8.424991e-001,
	1.767689e+000,
	-1.312031e+000,
	-8.191386e-001,
	2.156968e-001,
	1.201032e+000,
	6.593457e-001,
	// albedo 1, turbidity 9
	-2.190652e+000,
	-1.106580e+000,
	-7.466636e+000,
	7.752518e+000,
	-2.263662e-002,
	4.154878e-001,
	-1.646586e-006,
	2.076563e+000,
	6.322611e-001,
	-1.972368e+000,
	-8.108244e-001,
	4.233742e+000,
	-3.927321e+000,
	-5.152609e-002,
	2.005285e-001,
	2.985984e-002,
	1.903602e+000,
	1.099985e-001,
	-3.148093e+000,
	-2.033135e+000,
	-2.019650e+000,
	2.409779e+000,
	-1.255187e-002,
	9.697956e-001,
	-1.538080e-001,
	2.617071e+000,
	1.234755e+000,
	5.592882e-001,
	1.073057e+000,
	-2.763735e-002,
	-1.563728e+000,
	-1.191791e+000,
	-4.331798e-001,
	4.622361e-001,
	1.142664e+000,
	2.988891e-001,
	-1.706427e+000,
	-8.516236e-001,
	1.014996e+000,
	3.980336e+000,
	-3.487485e+000,
	6.331985e-001,
	-1.818380e-002,
	7.352340e-001,
	8.452629e-001,
	-1.006197e+000,
	-1.932306e-001,
	5.337019e-001,
	1.797637e+000,
	-9.474717e-001,
	-1.353274e-001,
	2.049954e-001,
	1.156100e+000,
	6.894153e-001,
	// albedo 1, turbidity 10
	-2.473813e+000,
	-1.478132e+000,
	-3.492210e+000,
	3.805303e+000,
	-3.251673e-002,
	3.621052e-001,
	-6.447770e-006,
	1.596383e+000,
	8.551930e-001,
	-1.494464e+000,
	-7.635918e-001,
	2.071212e+000,
	-1.536108e+000,
	-1.369345e-001,
	1.287259e-001,
	2.147844e-002,
	1.753080e+000,
	-2.246103e-001,
	-6.305007e+000,
	-3.323156e+000,
	-7.099379e-001,
	1.686111e-001,
	1.080881e-001,
	8.729732e-001,
	-1.291207e-001,
	2.282989e+000,
	1.475588e+000,
	1.325532e+000,
	5.765517e-001,
	-7.011257e-001,
	7.720216e-001,
	-2.013560e+000,
	-1.990572e-001,
	3.922685e-001,
	9.898769e-003,
	1.789360e-001,
	-1.590406e+000,
	-7.529646e-001,
	1.930414e+000,
	5.169169e+000,
	-4.221403e+000,
	4.614858e-002,
	-9.527005e-002,
	-7.894472e-001,
	8.458063e-001,
	-1.005785e+000,
	-2.286223e-001,
	3.330253e-001,
	1.438452e+000,
	-7.701349e-001,
	2.780764e-002,
	2.630698e-001,
	8.329894e-001,
	6.747408e-001,
};

double datasetRad480[] = 
{
	// albedo 0, turbidity 1
	1.367487e-002,
	1.998477e-002,
	-2.747378e-002,
	2.012913e-001,
	1.065803e-001,
	1.249226e-001,
	// albedo 0, turbidity 2
	1.319623e-002,
	2.233282e-002,
	-3.838862e-002,
	2.216885e-001,
	1.032539e-001,
	1.308019e-001,
	// albedo 0, turbidity 3
	1.265118e-002,
	2.391819e-002,
	-4.721677e-002,
	2.352182e-001,
	1.174476e-001,
	1.303906e-001,
	// albedo 0, turbidity 4
	1.204726e-002,
	2.745130e-002,
	-6.437791e-002,
	2.605947e-001,
	1.298129e-001,
	1.378516e-001,
	// albedo 0, turbidity 5
	1.125691e-002,
	3.031033e-002,
	-7.856070e-002,
	2.797308e-001,
	1.411425e-001,
	1.486601e-001,
	// albedo 0, turbidity 6
	1.087451e-002,
	3.134174e-002,
	-8.308676e-002,
	2.793109e-001,
	1.610134e-001,
	1.502290e-001,
	// albedo 0, turbidity 7
	1.035757e-002,
	3.176437e-002,
	-8.486370e-002,
	2.674373e-001,
	1.974534e-001,
	1.533206e-001,
	// albedo 0, turbidity 8
	9.649434e-003,
	3.087937e-002,
	-8.067259e-002,
	2.353243e-001,
	2.553337e-001,
	1.608814e-001,
	// albedo 0, turbidity 9
	8.869346e-003,
	2.627497e-002,
	-5.891488e-002,
	1.570602e-001,
	3.504762e-001,
	1.724148e-001,
	// albedo 0, turbidity 10
	8.105360e-003,
	1.756907e-002,
	-2.001928e-002,
	3.536541e-002,
	4.692392e-001,
	1.926373e-001,
	// albedo 1, turbidity 1
	1.531497e-002,
	2.090118e-002,
	-1.665041e-002,
	1.626765e-001,
	2.602854e-001,
	2.739350e-001,
	// albedo 1, turbidity 2
	1.500055e-002,
	2.258405e-002,
	-2.517423e-002,
	1.780058e-001,
	2.604774e-001,
	2.803331e-001,
	// albedo 1, turbidity 3
	1.435727e-002,
	2.473634e-002,
	-3.651251e-002,
	1.966627e-001,
	2.645889e-001,
	2.894029e-001,
	// albedo 1, turbidity 4
	1.368791e-002,
	2.602874e-002,
	-4.462666e-002,
	2.008996e-001,
	2.978971e-001,
	2.872899e-001,
	// albedo 1, turbidity 5
	1.298035e-002,
	2.709110e-002,
	-5.084570e-002,
	2.010066e-001,
	3.257828e-001,
	2.917322e-001,
	// albedo 1, turbidity 6
	1.267531e-002,
	2.752851e-002,
	-5.364450e-002,
	1.962715e-001,
	3.472458e-001,
	2.928354e-001,
	// albedo 1, turbidity 7
	1.200196e-002,
	2.782022e-002,
	-5.449978e-002,
	1.818445e-001,
	3.795420e-001,
	2.974612e-001,
	// albedo 1, turbidity 8
	1.115769e-002,
	2.603247e-002,
	-4.606362e-002,
	1.383509e-001,
	4.427481e-001,
	2.969281e-001,
	// albedo 1, turbidity 9
	1.034375e-002,
	2.111036e-002,
	-2.502615e-002,
	6.215948e-002,
	5.253192e-001,
	2.999927e-001,
	// albedo 1, turbidity 10
	9.270257e-003,
	1.252950e-002,
	1.085115e-002,
	-5.004679e-002,
	6.169243e-001,
	3.053035e-001,
};

double dataset520[] = 
{
	// albedo 0, turbidity 1
	-1.171338e+000,
	-2.379456e-001,
	-6.515446e+000,
	7.133235e+000,
	-5.382867e-002,
	6.889982e-001,
	4.250983e-002,
	4.471437e+000,
	5.087463e-001,
	-1.193029e+000,
	-2.445141e-001,
	-4.311723e-001,
	1.019354e+000,
	-1.281643e-001,
	7.837279e-001,
	2.609613e-002,
	5.965800e+000,
	4.381607e-001,
	-1.165299e+000,
	-2.503239e-001,
	3.829843e+000,
	-2.234083e+000,
	-4.693988e-001,
	1.045109e+000,
	-6.241707e-002,
	2.623310e-001,
	7.500398e-001,
	-1.077288e+000,
	-2.659342e-001,
	-7.565678e-002,
	1.145086e+000,
	-2.316655e-002,
	1.564941e+000,
	9.375322e-002,
	-7.476929e-001,
	6.076913e-001,
	-1.075530e+000,
	-1.232648e-001,
	1.877081e+000,
	-1.186427e-001,
	-2.748628e+000,
	1.249377e+000,
	-1.085780e-001,
	3.838331e+000,
	8.601227e-001,
	-1.067002e+000,
	-1.572453e-001,
	1.350156e+000,
	3.140948e-003,
	-3.277283e+000,
	1.488404e+000,
	1.127058e-001,
	2.655730e+000,
	4.999138e-001,
	// albedo 0, turbidity 2
	-1.175145e+000,
	-2.454528e-001,
	-8.173280e+000,
	8.622722e+000,
	-3.895019e-002,
	6.739096e-001,
	6.622835e-002,
	4.450872e+000,
	5.061382e-001,
	-1.226543e+000,
	-2.979950e-001,
	3.102814e+000,
	-2.662701e+000,
	-1.012309e-001,
	5.142095e-001,
	4.939276e-002,
	5.007851e+000,
	4.179865e-001,
	-1.075743e+000,
	-1.267529e-001,
	1.017884e-001,
	4.839556e-001,
	-4.025119e-001,
	1.120466e+000,
	-5.059103e-002,
	3.601070e+000,
	1.104232e+000,
	-1.104008e+000,
	-2.079352e-001,
	1.094572e+000,
	1.147058e+000,
	-1.516726e-001,
	1.526097e+000,
	1.922554e-001,
	4.060614e-001,
	2.975787e-001,
	-1.080135e+000,
	-1.942481e-001,
	1.409056e+000,
	-3.800384e+000,
	-7.125701e+000,
	9.731220e-001,
	-7.312793e-002,
	2.377810e+000,
	9.223131e-001,
	-1.066280e+000,
	-1.421591e-001,
	1.272936e+000,
	7.891881e+000,
	-3.626975e+000,
	1.294678e+000,
	1.331475e-001,
	2.986127e+000,
	5.316962e-001,
	// albedo 0, turbidity 3
	-1.210057e+000,
	-2.827640e-001,
	-5.179186e+000,
	5.514430e+000,
	-5.638504e-002,
	6.656727e-001,
	5.417868e-002,
	4.216550e+000,
	5.495231e-001,
	-1.311087e+000,
	-3.921139e-001,
	1.436554e+000,
	-7.051260e-001,
	-1.462714e-001,
	2.604620e-001,
	5.771570e-002,
	3.493766e+000,
	5.041164e-001,
	-9.705912e-001,
	-4.316197e-002,
	5.357225e-001,
	-1.399982e+000,
	-3.407923e-001,
	1.585242e+000,
	-6.423039e-002,
	5.338193e+000,
	9.835385e-001,
	-1.177697e+000,
	-1.893604e-001,
	-5.207247e-002,
	4.572666e+000,
	-5.523178e-001,
	2.677765e-001,
	3.872768e-001,
	1.978123e+000,
	4.095974e-001,
	-1.029420e+000,
	-2.105096e-001,
	1.657176e+000,
	-1.028655e+001,
	-7.725428e+000,
	1.707122e+000,
	-7.681108e-002,
	1.074660e+000,
	8.312794e-001,
	-1.082084e+000,
	-1.321893e-001,
	8.487219e-001,
	1.858290e+001,
	-3.172656e+000,
	6.915801e-001,
	1.905927e-001,
	3.901473e+000,
	6.144141e-001,
	// albedo 0, turbidity 4
	-1.259854e+000,
	-3.329630e-001,
	-2.270176e+000,
	2.357599e+000,
	-9.019414e-002,
	5.779792e-001,
	7.706039e-002,
	3.971905e+000,
	4.999172e-001,
	-1.413220e+000,
	-5.430979e-001,
	-1.715627e-001,
	1.151561e+000,
	-2.318489e-001,
	2.791441e-001,
	1.306646e-002,
	1.794583e+000,
	6.167457e-001,
	-9.926840e-001,
	2.303697e-002,
	7.306051e-001,
	-2.124879e+000,
	-2.221853e-001,
	1.635982e+000,
	-8.684297e-002,
	7.621636e+000,
	9.443863e-001,
	-1.113409e+000,
	-2.409045e-001,
	-1.979662e-001,
	5.089736e+000,
	-2.071840e+000,
	-6.954891e-001,
	5.966469e-001,
	-1.346819e+000,
	3.752080e-001,
	-1.055595e+000,
	-1.703680e-001,
	1.089771e+000,
	-1.041463e+001,
	-4.687545e+000,
	2.149733e+000,
	-1.118987e-001,
	3.558810e+000,
	8.741214e-001,
	-1.070779e+000,
	-1.445161e-001,
	6.385947e-001,
	1.695445e+001,
	-3.724275e+000,
	-3.465499e-002,
	3.645376e-001,
	3.232410e+000,
	6.285788e-001,
	// albedo 0, turbidity 5
	-1.297812e+000,
	-3.805039e-001,
	-1.474455e+000,
	1.558382e+000,
	-1.292485e-001,
	5.206238e-001,
	7.166147e-002,
	3.651150e+000,
	4.998781e-001,
	-1.680599e+000,
	-8.036751e-001,
	8.267015e-001,
	-2.109200e-001,
	-4.326451e-001,
	3.843930e-001,
	5.207142e-002,
	6.938520e-001,
	4.752346e-001,
	-8.467684e-001,
	1.620743e-001,
	-5.520307e-001,
	8.293798e-001,
	8.728132e-001,
	9.075147e-001,
	-1.734859e-001,
	7.815672e+000,
	1.126843e+000,
	-1.182658e+000,
	-3.290773e-001,
	1.442907e-001,
	-1.705529e+000,
	-1.186174e+001,
	-1.903040e-001,
	7.826049e-001,
	-1.497409e+000,
	2.238945e-001,
	-1.032316e+000,
	-1.590425e-001,
	9.289968e-001,
	1.217091e+001,
	1.274690e+000,
	1.400296e+000,
	-3.047612e-001,
	2.805729e+000,
	9.198989e-001,
	-1.073060e+000,
	-1.623303e-001,
	3.798836e-001,
	2.223272e+000,
	-4.660805e+000,
	-1.172357e-001,
	5.306455e-001,
	3.105520e+000,
	6.420864e-001,
	// albedo 0, turbidity 6
	-1.374072e+000,
	-4.453408e-001,
	-1.081601e+000,
	1.104314e+000,
	-1.730612e-001,
	5.074812e-001,
	5.784588e-002,
	3.488150e+000,
	5.037112e-001,
	-1.704606e+000,
	-8.629255e-001,
	-3.905040e-001,
	2.152742e+000,
	-6.716606e-001,
	5.638527e-001,
	-5.967161e-003,
	4.886292e-001,
	4.385432e-001,
	-9.651511e-001,
	1.186522e-001,
	3.421397e-001,
	-4.626814e+000,
	9.716770e-001,
	7.579588e-001,
	-1.064476e-002,
	8.154392e+000,
	1.103676e+000,
	-1.067172e+000,
	-3.214506e-001,
	-3.934660e-001,
	9.254630e+000,
	-3.599603e+000,
	-1.624031e-001,
	5.478446e-001,
	-2.781628e+000,
	2.905848e-001,
	-1.063218e+000,
	-1.412572e-001,
	8.153795e-001,
	-1.467486e+001,
	-2.020170e+000,
	1.094685e+000,
	7.786265e-002,
	3.719129e+000,
	8.826899e-001,
	-1.070058e+000,
	-1.684172e-001,
	2.225147e-001,
	2.345795e+001,
	-4.342429e+000,
	-4.661816e-002,
	3.545794e-001,
	3.051769e+000,
	6.567686e-001,
	// albedo 0, turbidity 7
	-1.397244e+000,
	-4.874379e-001,
	-2.217129e+000,
	2.415780e+000,
	-1.039290e-001,
	5.444596e-001,
	2.296795e-002,
	3.242776e+000,
	5.575920e-001,
	-1.943117e+000,
	-1.042293e+000,
	1.936194e+000,
	-7.807718e-001,
	-4.753317e-001,
	6.351817e-001,
	3.357824e-002,
	3.221570e-001,
	2.277390e-001,
	-1.007469e+000,
	4.283560e-002,
	-1.830583e+000,
	-1.613949e-001,
	5.103059e-001,
	1.830881e-001,
	-6.111472e-002,
	7.698471e+000,
	1.322151e+000,
	-9.885823e-001,
	-2.796329e-001,
	9.017585e-001,
	9.500529e-001,
	-8.751757e+000,
	5.198673e-001,
	6.111910e-001,
	-3.165369e+000,
	1.193651e-001,
	-1.105054e+000,
	-1.835801e-001,
	2.099263e-001,
	3.626436e+000,
	4.241807e-001,
	2.861915e-002,
	-3.245808e-002,
	3.560209e+000,
	9.581069e-001,
	-1.061783e+000,
	-1.955111e-001,
	3.405765e-001,
	1.682185e+001,
	-4.868111e+000,
	3.591669e-001,
	3.518670e-001,
	2.163473e+000,
	6.425305e-001,
	// albedo 0, turbidity 8
	-1.452178e+000,
	-5.662818e-001,
	-1.492883e+000,
	1.742373e+000,
	-1.894966e-001,
	6.129524e-001,
	2.370115e-006,
	3.042560e+000,
	7.988979e-001,
	-2.146318e+000,
	-1.176122e+000,
	1.480664e+000,
	1.846814e-001,
	-9.003192e-001,
	2.819986e-001,
	-6.858291e-003,
	5.447940e-001,
	-2.109028e-001,
	-1.465359e+000,
	-3.055025e-001,
	-1.747423e+000,
	-2.538335e+000,
	6.082904e-001,
	6.523133e-001,
	1.426957e-001,
	6.921276e+000,
	1.637843e+000,
	-7.135462e-001,
	-2.351046e-001,
	1.111445e+000,
	2.259275e+000,
	-7.853810e+000,
	-3.006083e-001,
	3.100486e-001,
	-4.047366e+000,
	-3.732308e-002,
	-1.188030e+000,
	-2.177467e-001,
	8.022451e-002,
	8.746107e+000,
	-6.824017e-001,
	5.968181e-001,
	7.024883e-002,
	3.164998e+000,
	9.909158e-001,
	-1.038065e+000,
	-1.989059e-001,
	1.630845e-001,
	1.261969e+001,
	-4.006594e+000,
	-3.213161e-001,
	3.948313e-001,
	2.040063e+000,
	6.364874e-001,
	// albedo 0, turbidity 9
	-1.789980e+000,
	-8.450140e-001,
	-2.591234e+000,
	2.769295e+000,
	-8.338896e-002,
	5.620741e-001,
	-8.271253e-006,
	2.531602e+000,
	9.001159e-001,
	-1.468080e+000,
	-7.426812e-001,
	2.369441e+000,
	-1.635443e+000,
	-3.560365e-001,
	2.130482e-001,
	-2.124886e-003,
	1.863478e+000,
	-3.426455e-001,
	-3.911974e+000,
	-1.873182e+000,
	-2.428294e+000,
	1.019786e+000,
	2.178584e-001,
	9.599962e-001,
	3.763471e-002,
	4.121844e+000,
	1.708236e+000,
	5.986629e-001,
	4.160930e-001,
	1.499968e+000,
	-4.234635e+000,
	-7.153272e+000,
	-8.777277e-001,
	4.276508e-001,
	-2.268730e+000,
	-9.278595e-002,
	-1.581111e+000,
	-5.414559e-001,
	3.449756e-002,
	2.095624e+001,
	-1.717086e+000,
	6.913385e-001,
	-1.227380e-001,
	1.401315e+000,
	9.723511e-001,
	-9.931334e-001,
	-2.191364e-001,
	1.647201e-001,
	2.954460e+000,
	-2.889774e+000,
	-4.261816e-001,
	4.166838e-001,
	1.370273e+000,
	6.561021e-001,
	// albedo 0, turbidity 10
	-2.368520e+000,
	-1.245557e+000,
	-3.473878e+000,
	3.511922e+000,
	-4.076311e-002,
	4.228576e-001,
	-8.136079e-006,
	2.268992e+000,
	9.001266e-001,
	-1.498984e+000,
	-9.483364e-001,
	2.970418e+000,
	-2.003511e+000,
	-3.005171e-001,
	3.242320e-001,
	6.724107e-003,
	1.693927e+000,
	-2.648941e-001,
	-6.258071e+000,
	-2.616781e+000,
	-3.186408e+000,
	-3.570416e-002,
	5.972101e-001,
	5.638927e-001,
	-8.227073e-002,
	3.805214e+000,
	1.486701e+000,
	7.183470e-001,
	-1.332710e-001,
	1.495243e+000,
	3.859652e+000,
	-5.605361e+000,
	3.808435e-001,
	4.998100e-001,
	-1.207866e+000,
	1.082917e-001,
	-1.422091e+000,
	-5.984032e-001,
	2.297508e-001,
	1.726780e+000,
	-6.684454e-001,
	-1.024912e+000,
	-1.967199e-001,
	-3.214571e-001,
	8.922300e-001,
	-1.018798e+000,
	-2.003211e-001,
	5.344788e-002,
	1.474717e+001,
	-4.025558e+000,
	9.010150e-001,
	3.605184e-001,
	1.504726e+000,
	6.720300e-001,
	// albedo 1, turbidity 1
	-1.150179e+000,
	-2.233430e-001,
	-6.725138e+000,
	7.601675e+000,
	-6.176639e-002,
	7.963802e-001,
	2.476816e-002,
	4.311811e+000,
	5.070506e-001,
	-1.184017e+000,
	-2.330060e-001,
	1.903877e-001,
	4.425206e-001,
	-1.173330e-001,
	2.459899e-001,
	6.799957e-002,
	5.710763e+000,
	4.639162e-001,
	-1.129855e+000,
	-2.313999e-001,
	3.299978e+000,
	-1.861830e+000,
	-3.626476e-001,
	1.858194e+000,
	-9.845844e-002,
	6.523143e-001,
	6.278178e-001,
	-1.090030e+000,
	-2.445577e-001,
	4.546659e-001,
	9.848860e-001,
	-4.044981e-001,
	3.532740e-001,
	1.409977e-001,
	-7.724273e-001,
	2.901711e-001,
	-1.048192e+000,
	-1.048720e-001,
	2.079951e+000,
	-7.519850e-002,
	-1.451911e+000,
	1.354243e+000,
	-1.508252e-001,
	4.159135e+000,
	8.685415e-001,
	-1.081709e+000,
	-1.496534e-001,
	1.433416e+000,
	-8.415186e-005,
	-3.147387e+000,
	6.964893e-002,
	1.345400e-001,
	3.372381e+000,
	5.369835e-001,
	// albedo 1, turbidity 2
	-1.163329e+000,
	-2.341078e-001,
	-8.084459e+000,
	8.765664e+000,
	-4.227908e-002,
	6.476384e-001,
	5.575993e-002,
	4.291594e+000,
	5.023286e-001,
	-1.234281e+000,
	-3.038288e-001,
	3.304120e+000,
	-2.565467e+000,
	-1.080261e-001,
	5.183037e-001,
	2.633070e-002,
	4.459108e+000,
	4.526356e-001,
	-1.015235e+000,
	-1.003890e-001,
	2.834337e-001,
	4.230399e-001,
	-4.060874e-001,
	1.119918e+000,
	-2.357803e-002,
	3.215664e+000,
	1.089777e+000,
	-1.171497e+000,
	-2.465867e-001,
	1.219344e+000,
	1.184120e+000,
	-6.451707e-002,
	1.087554e+000,
	1.687897e-001,
	4.111776e-001,
	2.471485e-001,
	-1.010262e+000,
	-1.337460e-001,
	1.953577e+000,
	-3.761183e+000,
	-7.089300e+000,
	5.963565e-001,
	-8.297304e-002,
	2.741114e+000,
	9.771003e-001,
	-1.102719e+000,
	-1.647974e-001,
	1.510508e+000,
	7.573412e+000,
	-3.431528e+000,
	3.953995e-001,
	6.793657e-002,
	2.744717e+000,
	5.018037e-001,
	// albedo 1, turbidity 3
	-1.186728e+000,
	-2.648685e-001,
	-7.540497e+000,
	8.152868e+000,
	-4.363040e-002,
	6.836829e-001,
	3.221451e-002,
	4.013046e+000,
	6.004295e-001,
	-1.302626e+000,
	-3.904258e-001,
	3.431819e+000,
	-2.975541e+000,
	-7.666020e-002,
	2.464561e-002,
	1.054528e-001,
	3.161765e+000,
	3.544185e-001,
	-9.615438e-001,
	-4.842098e-002,
	-4.756207e-001,
	9.408081e-001,
	-3.108222e-001,
	1.708814e+000,
	-1.241215e-001,
	4.416567e+000,
	1.207369e+000,
	-1.178731e+000,
	-1.824314e-001,
	8.266664e-001,
	1.001614e+000,
	3.024332e-001,
	3.291998e-002,
	4.178949e-001,
	2.532397e+000,
	2.014902e-001,
	-1.018913e+000,
	-2.016682e-001,
	2.132865e+000,
	-3.323938e+000,
	-8.751654e+000,
	1.240780e+000,
	-1.801214e-001,
	6.145479e-001,
	9.457932e-001,
	-1.101603e+000,
	-1.521834e-001,
	1.348807e+000,
	5.640453e+000,
	-2.695953e+000,
	-7.496627e-002,
	1.719606e-001,
	3.175091e+000,
	5.968939e-001,
	// albedo 1, turbidity 4
	-1.229694e+000,
	-3.167126e-001,
	-3.548352e+000,
	3.846155e+000,
	-5.028022e-002,
	5.061677e-001,
	7.498335e-002,
	3.626295e+000,
	4.999424e-001,
	-1.436439e+000,
	-5.562909e-001,
	8.010070e-001,
	3.290243e-001,
	-1.385772e-001,
	4.556269e-002,
	2.571935e-002,
	1.623385e+000,
	5.222220e-001,
	-8.876360e-001,
	5.717281e-002,
	4.713905e-001,
	-1.668970e+000,
	-3.199243e-001,
	2.050582e+000,
	-7.783980e-002,
	6.117601e+000,
	1.070445e+000,
	-1.235363e+000,
	-2.778190e-001,
	1.577638e-001,
	3.982457e+000,
	-2.266885e-002,
	-1.411004e+000,
	5.570462e-001,
	1.740426e-001,
	2.747952e-001,
	-9.785264e-001,
	-1.458813e-001,
	1.996989e+000,
	-7.517409e+000,
	-6.602487e+000,
	2.387711e+000,
	-1.996484e-001,
	2.112759e+000,
	9.289256e-001,
	-1.117781e+000,
	-1.699302e-001,
	1.214480e+000,
	1.141083e+001,
	-3.253445e+000,
	-8.156284e-001,
	2.248021e-001,
	2.860500e+000,
	6.151694e-001,
	// albedo 1, turbidity 5
	-1.290523e+000,
	-3.813116e-001,
	-6.728796e-001,
	1.007366e+000,
	-2.068030e-001,
	4.422499e-001,
	6.016254e-002,
	3.218056e+000,
	5.068822e-001,
	-1.614452e+000,
	-7.953309e-001,
	5.977485e-001,
	1.056365e+000,
	-8.402403e-001,
	3.713919e-001,
	3.164720e-002,
	-2.526630e-001,
	4.072481e-001,
	-8.377211e-001,
	2.276878e-001,
	-3.232539e-001,
	-2.390300e+000,
	2.127070e+000,
	7.169058e-001,
	-4.032313e-002,
	9.072383e+000,
	1.188019e+000,
	-1.226600e+000,
	-4.426177e-001,
	6.370202e-001,
	3.846913e+000,
	-1.128719e+001,
	3.667721e-002,
	5.000027e-001,
	-4.192432e+000,
	2.376054e-001,
	-9.852235e-001,
	-5.890324e-002,
	1.529937e+000,
	4.301220e+000,
	-1.839775e+000,
	8.993504e-001,
	-1.040866e-001,
	4.636528e+000,
	8.466710e-001,
	-1.118112e+000,
	-2.040213e-001,
	1.203227e+000,
	7.252102e+000,
	-4.515955e+000,
	-2.398231e-001,
	2.375855e-001,
	1.923160e+000,
	6.645269e-001,
	// albedo 1, turbidity 6
	-1.330626e+000,
	-4.272516e-001,
	-1.317682e+000,
	1.650847e+000,
	-1.192771e-001,
	4.904191e-001,
	4.074827e-002,
	3.015846e+000,
	5.271835e-001,
	-1.711989e+000,
	-8.644776e-001,
	4.057135e-001,
	9.037139e-001,
	-3.100084e-001,
	6.317697e-002,
	1.065625e-001,
	9.226240e-002,
	3.022474e-001,
	-8.465894e-001,
	1.652715e-001,
	-2.532361e-001,
	-2.422693e+000,
	3.144841e-001,
	1.839347e+000,
	-2.818162e-001,
	7.856667e+000,
	1.387977e+000,
	-1.192114e+000,
	-3.830569e-001,
	5.124751e-001,
	7.280034e+000,
	-2.610477e+000,
	-1.832768e+000,
	9.101904e-001,
	-3.349116e+000,
	-7.313079e-002,
	-1.011026e+000,
	-1.061217e-001,
	1.357854e+000,
	-1.496195e+001,
	-2.180975e+000,
	2.484329e+000,
	-3.239225e-001,
	3.899425e+000,
	1.179264e+000,
	-1.106228e+000,
	-1.927917e-001,
	1.179701e+000,
	2.379834e+001,
	-4.870211e+000,
	-1.290713e+000,
	2.854422e-001,
	2.078973e+000,
	5.128625e-001,
	// albedo 1, turbidity 7
	-1.342815e+000,
	-4.571984e-001,
	-1.803521e+000,
	2.229578e+000,
	-1.196587e-001,
	5.694038e-001,
	1.194687e-002,
	2.950110e+000,
	5.961719e-001,
	-1.937297e+000,
	-1.078823e+000,
	2.178495e+000,
	-1.251900e+000,
	-3.577875e-001,
	2.553915e-001,
	8.081142e-002,
	-4.723152e-001,
	1.174551e-001,
	-9.292675e-001,
	1.125551e-001,
	-1.708569e+000,
	1.832840e+000,
	5.150525e-001,
	9.287322e-001,
	-1.746780e-001,
	7.793815e+000,
	1.498832e+000,
	-1.058850e+000,
	-3.495292e-001,
	1.135259e+000,
	-4.069374e+000,
	-9.727412e+000,
	-7.670653e-001,
	7.550431e-001,
	-4.105064e+000,
	-5.149354e-002,
	-1.079472e+000,
	-1.399984e-001,
	1.058148e+000,
	1.392667e+001,
	-6.245343e-001,
	1.192083e+000,
	-2.578858e-001,
	4.030723e+000,
	1.025069e+000,
	-1.093159e+000,
	-2.150433e-001,
	1.210946e+000,
	3.349246e+000,
	-4.030345e+000,
	-5.362971e-001,
	2.886842e-001,
	1.192375e+000,
	6.363049e-001,
	// albedo 1, turbidity 8
	-1.408172e+000,
	-5.491538e-001,
	-1.360219e+000,
	1.738150e+000,
	-1.505117e-001,
	6.030014e-001,
	-6.866289e-006,
	2.656101e+000,
	9.001849e-001,
	-2.171702e+000,
	-1.231851e+000,
	1.860400e+000,
	3.613146e-002,
	-7.300078e-001,
	1.974371e-001,
	-5.351202e-003,
	-1.443434e-001,
	-3.779605e-001,
	-1.284657e+000,
	-1.935945e-001,
	-1.494185e+000,
	-2.070689e+000,
	2.974020e-001,
	8.048383e-001,
	1.097715e-001,
	6.907960e+000,
	1.819367e+000,
	-8.288598e-001,
	-3.374917e-001,
	1.029011e+000,
	1.347088e+000,
	-7.655126e+000,
	-8.232335e-001,
	3.722934e-001,
	-4.847675e+000,
	-1.864913e-001,
	-1.146031e+000,
	-1.480097e-001,
	1.051391e+000,
	8.396865e+000,
	-1.407010e+000,
	1.240651e+000,
	-3.942068e-002,
	3.291458e+000,
	1.060212e+000,
	-1.069599e+000,
	-2.047532e-001,
	9.437765e-001,
	1.189879e+001,
	-4.026750e+000,
	-9.372092e-001,
	2.463501e-001,
	1.782902e+000,
	6.235027e-001,
	// albedo 1, turbidity 9
	-1.793508e+000,
	-8.986075e-001,
	-2.346395e+000,
	2.775625e+000,
	-7.052213e-002,
	5.349215e-001,
	-7.457456e-006,
	1.901248e+000,
	9.001358e-001,
	-1.629402e+000,
	-8.273410e-001,
	2.270930e+000,
	-1.125114e+000,
	-3.562854e-001,
	1.948044e-001,
	1.703882e-003,
	1.426305e+000,
	-3.737234e-001,
	-3.443431e+000,
	-1.686429e+000,
	-1.515036e+000,
	-6.941862e-001,
	4.976814e-001,
	1.144483e+000,
	-4.277285e-002,
	3.662107e+000,
	1.819972e+000,
	3.138150e-001,
	2.426714e-001,
	7.717995e-001,
	2.759520e+000,
	-7.216077e+000,
	-1.389093e+000,
	5.332838e-001,
	-2.316313e+000,
	-2.636593e-001,
	-1.449802e+000,
	-4.017798e-001,
	1.133688e+000,
	2.114337e+000,
	6.227965e-002,
	1.378688e+000,
	-1.759313e-001,
	9.446579e-001,
	1.165017e+000,
	-1.049420e+000,
	-2.614006e-001,
	9.473363e-001,
	1.531288e+001,
	-4.714989e+000,
	-8.992715e-001,
	2.423509e-001,
	9.148027e-001,
	5.650972e-001,
	// albedo 1, turbidity 10
	-2.382332e+000,
	-1.290760e+000,
	-3.316114e+000,
	3.587059e+000,
	-3.748522e-002,
	4.468493e-001,
	-7.212198e-006,
	1.789208e+000,
	9.001267e-001,
	-1.333339e+000,
	-9.355999e-001,
	3.281313e+000,
	-2.263103e+000,
	-2.499164e-001,
	1.591742e-001,
	8.117981e-003,
	1.345396e+000,
	-2.689053e-001,
	-6.612658e+000,
	-2.809230e+000,
	-2.744061e+000,
	1.005261e+000,
	4.216309e-001,
	1.055067e+000,
	-9.021558e-002,
	2.940833e+000,
	1.495270e+000,
	1.251113e+000,
	5.915517e-002,
	1.142846e+000,
	-2.807371e-001,
	-5.335452e+000,
	-6.967012e-001,
	5.129558e-001,
	-5.264483e-001,
	1.137786e-001,
	-1.517768e+000,
	-5.807447e-001,
	1.179477e+000,
	1.252252e+001,
	-2.305973e+000,
	2.184822e-001,
	-3.092917e-001,
	-1.524373e+000,
	8.724218e-001,
	-1.037889e+000,
	-2.065780e-001,
	6.479897e-001,
	4.786848e-002,
	-2.348244e+000,
	-3.053490e-002,
	4.059549e-001,
	1.313102e+000,
	6.713422e-001,
};

double datasetRad520[] = 
{
	// albedo 0, turbidity 1
	1.459826e-002,
	1.539451e-002,
	-1.848659e-003,
	1.563602e-001,
	6.773320e-002,
	9.272923e-002,
	// albedo 0, turbidity 2
	1.433599e-002,
	1.641988e-002,
	-1.010719e-002,
	1.752844e-001,
	7.101618e-002,
	9.423920e-002,
	// albedo 0, turbidity 3
	1.361165e-002,
	2.045058e-002,
	-3.003054e-002,
	2.142268e-001,
	6.624853e-002,
	1.021088e-001,
	// albedo 0, turbidity 4
	1.263245e-002,
	2.450953e-002,
	-5.278634e-002,
	2.554090e-001,
	7.442617e-002,
	1.093243e-001,
	// albedo 0, turbidity 5
	1.161553e-002,
	2.837614e-002,
	-7.218472e-002,
	2.860706e-001,
	8.559036e-002,
	1.183292e-001,
	// albedo 0, turbidity 6
	1.106384e-002,
	3.079241e-002,
	-8.377247e-002,
	3.007502e-001,
	9.584072e-002,
	1.242989e-001,
	// albedo 0, turbidity 7
	1.036501e-002,
	3.253539e-002,
	-9.274680e-002,
	3.036297e-001,
	1.249370e-001,
	1.307019e-001,
	// albedo 0, turbidity 8
	9.469294e-003,
	3.287197e-002,
	-9.329500e-002,
	2.773078e-001,
	1.866053e-001,
	1.366498e-001,
	// albedo 0, turbidity 9
	8.599754e-003,
	2.901873e-002,
	-7.532574e-002,
	2.032418e-001,
	2.837623e-001,
	1.499765e-001,
	// albedo 0, turbidity 10
	7.760808e-003,
	1.977285e-002,
	-3.328752e-002,
	7.084295e-002,
	4.155148e-001,
	1.708600e-001,
	// albedo 1, turbidity 1
	1.597952e-002,
	1.790201e-002,
	-1.839686e-003,
	1.470389e-001,
	1.698205e-001,
	2.119268e-001,
	// albedo 1, turbidity 2
	1.553599e-002,
	1.969270e-002,
	-1.173079e-002,
	1.677871e-001,
	1.714108e-001,
	2.173300e-001,
	// albedo 1, turbidity 3
	1.489601e-002,
	2.206336e-002,
	-2.576017e-002,
	1.949160e-001,
	1.781909e-001,
	2.236776e-001,
	// albedo 1, turbidity 4
	1.384558e-002,
	2.528945e-002,
	-4.419483e-002,
	2.249469e-001,
	1.968802e-001,
	2.312108e-001,
	// albedo 1, turbidity 5
	1.299228e-002,
	2.767429e-002,
	-5.793193e-002,
	2.409692e-001,
	2.215448e-001,
	2.384850e-001,
	// albedo 1, turbidity 6
	1.245635e-002,
	2.874175e-002,
	-6.384005e-002,
	2.429023e-001,
	2.428387e-001,
	2.418906e-001,
	// albedo 1, turbidity 7
	1.170787e-002,
	3.001101e-002,
	-6.977107e-002,
	2.368382e-001,
	2.775809e-001,
	2.482129e-001,
	// albedo 1, turbidity 8
	1.081211e-002,
	2.854760e-002,
	-6.360294e-002,
	1.948047e-001,
	3.501631e-001,
	2.490269e-001,
	// albedo 1, turbidity 9
	9.903541e-003,
	2.416012e-002,
	-4.342521e-002,
	1.140965e-001,
	4.468771e-001,
	2.561579e-001,
	// albedo 1, turbidity 10
	8.793464e-003,
	1.518177e-002,
	-4.699154e-003,
	-9.107614e-003,
	5.554550e-001,
	2.692918e-001,
};

double dataset560[] = 
{
	// albedo 0, turbidity 1
	-1.121223e+000,
	-1.710187e-001,
	-1.383038e+001,
	1.475343e+001,
	-3.137953e-002,
	1.035662e+000,
	4.060064e-002,
	5.222551e+000,
	5.001051e-001,
	-1.172565e+000,
	-1.880874e-001,
	7.283594e+000,
	-5.774643e+000,
	-9.051333e-002,
	9.108126e-001,
	-1.565410e-002,
	6.194404e+000,
	4.688599e-001,
	-1.124108e+000,
	-3.082835e-001,
	-2.179926e-001,
	1.330167e+000,
	-4.502254e-001,
	1.470140e+000,
	4.202392e-004,
	-4.724308e+000,
	1.134678e+000,
	-1.079809e+000,
	-9.226814e-002,
	1.465364e+000,
	1.348856e+000,
	4.357794e-001,
	1.771543e+000,
	8.121383e-003,
	6.057395e+000,
	2.462141e-001,
	-1.086667e+000,
	-2.709889e-001,
	2.249152e+000,
	-3.177505e+000,
	-7.138130e+000,
	1.112553e+000,
	-9.718434e-003,
	-2.392239e+000,
	9.352768e-001,
	-1.071154e+000,
	-1.272150e-001,
	1.644374e+000,
	4.326598e+000,
	-2.244682e+000,
	1.611051e+000,
	7.835546e-003,
	3.213282e+000,
	6.580432e-001,
	// albedo 0, turbidity 2
	-1.133883e+000,
	-1.835049e-001,
	-1.232301e+001,
	1.307796e+001,
	-3.760123e-002,
	1.051162e+000,
	3.392954e-002,
	5.319376e+000,
	6.501601e-001,
	-1.116119e+000,
	-1.457114e-001,
	5.436576e+000,
	-5.114276e+000,
	-7.178414e-002,
	2.658168e-001,
	1.603756e-001,
	7.619379e+000,
	3.112698e-001,
	-1.215552e+000,
	-3.391607e-001,
	4.502377e-001,
	1.281602e+000,
	-4.095778e-001,
	2.374058e+000,
	-1.988430e-001,
	-3.809377e+000,
	1.254846e+000,
	-9.657094e-001,
	3.858547e-002,
	3.324554e-001,
	1.541740e+000,
	6.029572e-001,
	2.346414e-001,
	3.902458e-001,
	7.263050e+000,
	1.353991e-001,
	-1.152042e+000,
	-3.155103e-001,
	2.163244e+000,
	-5.230832e+000,
	-7.443608e+000,
	2.247834e+000,
	-1.632216e-001,
	-1.725315e+000,
	1.034709e+000,
	-1.051862e+000,
	-1.310458e-001,
	1.554942e+000,
	1.063510e+001,
	-3.558989e+000,
	6.764257e-001,
	1.428912e-001,
	2.541641e+000,
	5.000389e-001,
	// albedo 0, turbidity 3
	-1.156925e+000,
	-2.104634e-001,
	-1.793090e+001,
	1.817524e+001,
	-1.225514e-002,
	6.518753e-001,
	1.085708e-001,
	4.947239e+000,
	5.635117e-001,
	-1.183783e+000,
	-2.187288e-001,
	5.860654e+000,
	-5.643960e+000,
	-4.453459e-002,
	6.724995e-001,
	1.698133e-002,
	6.742131e+000,
	6.353553e-001,
	-1.143101e+000,
	-2.644541e-001,
	9.354577e-001,
	9.256854e-001,
	-1.074845e-001,
	1.663131e+000,
	4.998918e-002,
	-2.049721e+000,
	8.150826e-001,
	-1.021102e+000,
	2.478746e-002,
	-1.367363e+000,
	-9.011684e-002,
	-5.001730e-001,
	4.316685e-002,
	3.952231e-001,
	8.084754e+000,
	5.380131e-001,
	-1.101145e+000,
	-2.731481e-001,
	2.483816e+000,
	3.581780e-001,
	4.249615e-001,
	2.284087e+000,
	-5.836688e-002,
	-1.651434e+000,
	7.685430e-001,
	-1.073863e+000,
	-1.705854e-001,
	1.169673e+000,
	-2.183705e-003,
	-5.007439e+000,
	2.318154e-001,
	2.738714e-001,
	2.187327e+000,
	6.676882e-001,
	// albedo 0, turbidity 4
	-1.207581e+000,
	-2.653224e-001,
	-9.004497e+000,
	8.985720e+000,
	-9.024461e-003,
	4.273132e-001,
	1.378091e-001,
	4.307648e+000,
	5.309421e-001,
	-1.278614e+000,
	-3.516334e-001,
	2.489304e+000,
	-1.840089e+000,
	-6.293646e-002,
	8.426903e-001,
	-7.266949e-002,
	4.434869e+000,
	7.077739e-001,
	-1.150333e+000,
	-2.033123e-001,
	8.150312e-001,
	-7.926382e-001,
	-3.230951e-001,
	1.291679e+000,
	1.822329e-001,
	1.619133e+000,
	7.522432e-001,
	-1.002248e+000,
	-3.092969e-002,
	-1.092273e+000,
	2.820671e+000,
	4.504455e-001,
	-5.121048e-001,
	4.229688e-001,
	4.037073e+000,
	5.843543e-001,
	-1.087962e+000,
	-2.434172e-001,
	1.817322e+000,
	-6.031774e+000,
	-4.873903e+000,
	2.094606e+000,
	1.184743e-001,
	2.293346e-001,
	7.283940e-001,
	-1.072272e+000,
	-1.614715e-001,
	8.337136e-001,
	1.086866e+001,
	-3.373042e+000,
	2.260332e-002,
	2.622468e-001,
	2.470766e+000,
	7.078601e-001,
	// albedo 0, turbidity 5
	-1.263850e+000,
	-3.278851e-001,
	-5.336400e+000,
	5.102832e+000,
	2.070020e-003,
	3.605369e-001,
	1.633426e-001,
	3.790121e+000,
	4.999503e-001,
	-1.507623e+000,
	-6.465694e-001,
	-2.983753e+000,
	4.212027e+000,
	-5.868795e-002,
	3.852488e-001,
	-7.222995e-002,
	1.042808e+000,
	6.632120e-001,
	-1.041397e+000,
	6.326589e-002,
	3.860471e+000,
	-5.579882e+000,
	-1.730201e-001,
	2.303753e+000,
	6.102393e-002,
	7.287763e+000,
	8.916057e-001,
	-1.049861e+000,
	-2.836044e-001,
	-2.302537e+000,
	6.724969e+000,
	4.373598e-001,
	-2.422514e+000,
	6.952438e-001,
	-2.633600e+000,
	4.070954e-001,
	-1.054117e+000,
	-1.206625e-001,
	1.764625e+000,
	-9.467716e+000,
	-3.436987e+000,
	3.394707e+000,
	-8.149683e-002,
	3.485918e+000,
	8.515716e-001,
	-1.072517e+000,
	-1.574135e-001,
	2.214599e-001,
	1.331766e+001,
	-3.915381e+000,
	-1.229973e+000,
	6.267275e-001,
	2.923262e+000,
	6.516824e-001,
	// albedo 0, turbidity 6
	-1.293503e+000,
	-3.676147e-001,
	-1.323095e+001,
	1.301713e+001,
	-3.471894e-004,
	3.957986e-001,
	1.317480e-001,
	3.616827e+000,
	4.998510e-001,
	-1.757697e+000,
	-8.202513e-001,
	2.560133e+000,
	-1.337734e+000,
	-3.413795e-002,
	5.633043e-001,
	-4.355758e-002,
	7.324869e-001,
	5.728008e-001,
	-8.814599e-001,
	9.828960e-002,
	-2.701428e-001,
	-1.298657e+000,
	-6.721423e-002,
	1.581675e+000,
	4.095024e-002,
	6.548913e+000,
	9.726866e-001,
	-1.125663e+000,
	-2.625873e-001,
	-2.797592e-001,
	2.848739e+000,
	-3.363778e-002,
	-1.672768e+000,
	7.349952e-001,
	-1.708628e+000,
	3.557813e-001,
	-1.044841e+000,
	-1.712889e-001,
	7.091708e-001,
	-4.275119e+000,
	-7.565130e-001,
	2.483873e+000,
	-7.781321e-002,
	2.667776e+000,
	8.709126e-001,
	-1.067360e+000,
	-1.543712e-001,
	3.884866e-001,
	6.915851e+000,
	-4.250734e+000,
	-6.525729e-001,
	6.368377e-001,
	2.671865e+000,
	6.566986e-001,
	// albedo 0, turbidity 7
	-1.360356e+000,
	-4.336026e-001,
	-1.442967e+001,
	1.428579e+001,
	-3.990325e-003,
	4.600126e-001,
	1.023159e-001,
	3.367805e+000,
	4.999150e-001,
	-2.054147e+000,
	-1.064745e+000,
	-7.857491e-001,
	2.214734e+000,
	-3.764113e-002,
	8.504761e-001,
	-4.222958e-002,
	1.091377e-001,
	4.732161e-001,
	-8.953952e-001,
	1.048085e-001,
	1.481293e+000,
	-4.223012e+000,
	-4.164160e-002,
	5.999023e-001,
	6.310005e-002,
	7.156883e+000,
	1.066682e+000,
	-1.030251e+000,
	-2.777709e-001,
	-8.361086e-001,
	5.611154e+000,
	1.861240e-001,
	-5.823197e-001,
	6.716210e-001,
	-3.269717e+000,
	2.922029e-001,
	-1.095631e+000,
	-1.966849e-001,
	6.300566e-001,
	-7.129591e+000,
	-7.351951e-001,
	1.400340e+000,
	-6.997516e-003,
	2.879018e+000,
	8.879337e-001,
	-1.052935e+000,
	-1.551958e-001,
	2.334578e-001,
	1.040948e+001,
	-4.426381e+000,
	-3.477323e-001,
	6.257070e-001,
	2.451148e+000,
	6.570737e-001,
	// albedo 0, turbidity 8
	-1.382656e+000,
	-4.830539e-001,
	-1.107403e+001,
	1.127854e+001,
	-2.723641e-002,
	8.478005e-001,
	2.907652e-003,
	3.290364e+000,
	7.398950e-001,
	-2.230895e+000,
	-1.163446e+000,
	-1.001991e+001,
	1.125340e+001,
	-3.233871e-002,
	3.041577e-001,
	3.870458e-003,
	3.463879e-001,
	-8.829082e-002,
	-1.489234e+000,
	-3.402035e-001,
	2.948409e+000,
	-8.098077e+000,
	9.078299e-002,
	-3.179835e-001,
	4.730321e-001,
	6.765707e+000,
	1.440217e+000,
	-6.206234e-001,
	-1.701007e-001,
	-7.346357e-002,
	9.350033e+000,
	1.548964e-001,
	1.313206e+000,
	-1.479143e-001,
	-5.119165e+000,
	1.854277e-001,
	-1.226372e+000,
	-2.128299e-001,
	-1.643093e-001,
	-9.382334e+000,
	-4.857784e-001,
	-1.374948e-001,
	5.877245e-001,
	3.862307e+000,
	8.700125e-001,
	-1.030598e+000,
	-1.931668e-001,
	3.691403e-001,
	1.066393e+001,
	-4.244968e+000,
	-5.872571e-002,
	4.193140e-001,
	1.461878e+000,
	6.699478e-001,
	// albedo 0, turbidity 9
	-1.606656e+000,
	-7.140209e-001,
	-1.149565e+001,
	1.168427e+001,
	-2.245577e-002,
	7.718953e-001,
	-8.349882e-006,
	2.654449e+000,
	9.001224e-001,
	-2.100494e+000,
	-1.013602e+000,
	-1.638934e+001,
	1.729185e+001,
	-1.580924e-002,
	5.038208e-002,
	-1.628735e-002,
	1.762584e+000,
	-3.121794e-001,
	-3.228292e+000,
	-1.459508e+000,
	7.424519e+000,
	-1.194272e+001,
	4.931054e-002,
	6.493074e-001,
	3.590561e-001,
	4.068321e+000,
	1.613039e+000,
	1.278814e-001,
	4.010913e-002,
	-2.185675e+000,
	1.164548e+001,
	2.706306e-002,
	1.632886e-001,
	-1.090111e-002,
	-3.342580e+000,
	1.916992e-002,
	-1.400278e+000,
	-2.825658e-001,
	4.168149e-001,
	-1.195909e+001,
	-1.122968e-002,
	1.863328e-001,
	4.263033e-001,
	2.270053e+000,
	9.748449e-001,
	-1.017511e+000,
	-2.884028e-001,
	3.544996e-001,
	1.535118e+001,
	-5.009184e+000,
	1.511064e-001,
	2.916578e-001,
	7.889658e-001,
	6.294910e-001,
	// albedo 0, turbidity 10
	-2.031136e+000,
	-1.076357e+000,
	-8.660773e+000,
	8.800317e+000,
	-2.370842e-002,
	5.736027e-001,
	-8.441313e-006,
	2.248669e+000,
	9.001280e-001,
	-1.270967e+000,
	-7.828844e-001,
	-1.198232e+001,
	1.262753e+001,
	-1.509989e-002,
	1.663438e-001,
	2.440939e-004,
	2.068640e+000,
	-2.521574e-001,
	-6.600872e+000,
	-2.689874e+000,
	6.453928e+000,
	-9.592747e+000,
	-3.551170e-002,
	1.325662e+000,
	-1.894375e-002,
	3.506163e+000,
	1.469724e+000,
	7.961323e-001,
	-1.989144e-001,
	-2.685238e+000,
	1.034230e+001,
	2.076702e-001,
	-7.692350e-001,
	6.184894e-001,
	-1.969413e+000,
	3.842922e-002,
	-1.459073e+000,
	-4.964034e-001,
	1.060127e+000,
	-1.277712e+001,
	-9.634553e-001,
	5.610879e-001,
	-2.034286e-001,
	3.525910e-001,
	1.003048e+000,
	-1.021565e+000,
	-2.553022e-001,
	6.367571e-002,
	2.028825e+001,
	-4.623219e+000,
	-2.400428e-002,
	4.251423e-001,
	9.640897e-001,
	6.080298e-001,
	// albedo 1, turbidity 1
	-1.121224e+000,
	-1.710171e-001,
	-1.383038e+001,
	1.475343e+001,
	-3.137812e-002,
	1.035662e+000,
	4.060006e-002,
	5.222551e+000,
	5.001051e-001,
	-1.172565e+000,
	-1.880857e-001,
	7.283595e+000,
	-5.774643e+000,
	-9.051285e-002,
	9.108124e-001,
	-1.565627e-002,
	6.194404e+000,
	4.688599e-001,
	-1.124109e+000,
	-3.082816e-001,
	-2.179926e-001,
	1.330167e+000,
	-4.502252e-001,
	1.470140e+000,
	4.158616e-004,
	-4.724308e+000,
	1.134678e+000,
	-1.079810e+000,
	-9.226583e-002,
	1.465364e+000,
	1.348856e+000,
	4.357794e-001,
	1.771543e+000,
	8.115381e-003,
	6.057395e+000,
	2.462140e-001,
	-1.086668e+000,
	-2.709863e-001,
	2.249153e+000,
	-3.177505e+000,
	-7.138130e+000,
	1.112553e+000,
	-9.724210e-003,
	-2.392239e+000,
	9.352768e-001,
	-1.071158e+000,
	-1.272123e-001,
	1.644374e+000,
	4.326598e+000,
	-2.244682e+000,
	1.611051e+000,
	7.831866e-003,
	3.213282e+000,
	6.580432e-001,
	// albedo 1, turbidity 2
	-1.125449e+000,
	-1.733403e-001,
	-1.228038e+001,
	1.311695e+001,
	-3.541409e-002,
	1.005494e+000,
	4.147852e-002,
	5.316886e+000,
	6.051699e-001,
	-1.101273e+000,
	-1.422106e-001,
	5.484715e+000,
	-5.089835e+000,
	-6.655928e-002,
	2.076815e-001,
	1.633101e-001,
	7.624535e+000,
	3.044941e-001,
	-1.213425e+000,
	-3.085010e-001,
	5.550585e-001,
	1.302798e+000,
	-3.946488e-001,
	2.285152e+000,
	-1.925101e-001,
	-3.790065e+000,
	1.263207e+000,
	-9.610579e-001,
	9.458093e-003,
	5.293256e-001,
	1.553214e+000,
	6.053752e-001,
	1.172267e-001,
	3.674690e-001,
	7.305350e+000,
	1.509544e-001,
	-1.119731e+000,
	-2.765693e-001,
	2.433951e+000,
	-5.229810e+000,
	-7.449777e+000,
	2.123304e+000,
	-2.242917e-001,
	-1.669115e+000,
	1.041008e+000,
	-1.094324e+000,
	-1.418743e-001,
	1.836224e+000,
	1.063054e+001,
	-3.561209e+000,
	5.916534e-001,
	9.296571e-002,
	2.600060e+000,
	4.999316e-001,
	// albedo 1, turbidity 3
	-1.155818e+000,
	-2.162981e-001,
	-2.560068e+001,
	2.636088e+001,
	-1.382944e-002,
	8.101983e-001,
	4.709210e-002,
	4.301909e+000,
	6.416958e-001,
	-1.171460e+000,
	-1.866443e-001,
	8.497645e+000,
	-8.396229e+000,
	-3.345417e-002,
	2.960022e-001,
	7.985279e-002,
	7.420544e+000,
	5.552152e-001,
	-1.114385e+000,
	-2.963805e-001,
	5.955009e-002,
	2.320529e+000,
	-7.649266e-002,
	2.277940e+000,
	-5.942479e-002,
	-4.040964e+000,
	9.588558e-001,
	-1.070647e+000,
	4.194546e-002,
	-5.701942e-001,
	-1.001278e+000,
	-3.389615e-001,
	-8.559533e-001,
	5.070784e-001,
	9.805560e+000,
	3.529747e-001,
	-1.057912e+000,
	-2.733753e-001,
	3.080618e+000,
	7.477366e-001,
	3.484876e-001,
	2.214994e+000,
	-2.597625e-001,
	-2.842961e+000,
	9.178917e-001,
	-1.105636e+000,
	-1.815423e-001,
	1.651373e+000,
	-2.553941e-003,
	-5.008441e+000,
	-6.378055e-001,
	2.370503e-001,
	1.890656e+000,
	6.018255e-001,
	// albedo 1, turbidity 4
	-1.194221e+000,
	-2.570801e-001,
	-8.919095e+000,
	9.380192e+000,
	-2.650470e-002,
	6.233645e-001,
	6.663964e-002,
	4.027438e+000,
	6.125383e-001,
	-1.308216e+000,
	-3.781794e-001,
	2.369107e+000,
	-1.977066e+000,
	-4.079773e-002,
	1.443960e-001,
	8.206719e-002,
	3.465933e+000,
	5.442867e-001,
	-1.048459e+000,
	-1.617720e-001,
	1.015136e+000,
	-2.989579e-001,
	-2.764989e-001,
	2.427990e+000,
	-1.147612e-001,
	1.522921e+000,
	1.041410e+000,
	-1.105796e+000,
	-4.826962e-002,
	-8.419705e-001,
	3.285981e+000,
	7.975109e-001,
	-1.954456e+000,
	7.424696e-001,
	4.604902e+000,
	2.602059e-001,
	-1.033856e+000,
	-2.507382e-001,
	2.882633e+000,
	-8.250912e+000,
	-6.878129e+000,
	2.948966e+000,
	-2.850302e-001,
	-8.253849e-001,
	9.844934e-001,
	-1.125219e+000,
	-1.879003e-001,
	1.474838e+000,
	1.453266e+001,
	-3.271910e+000,
	-1.231579e+000,
	2.397524e-001,
	1.654932e+000,
	5.625696e-001,
	// albedo 1, turbidity 5
	-1.246640e+000,
	-3.202274e-001,
	-6.355032e+000,
	6.364143e+000,
	9.028376e-004,
	3.146975e-001,
	1.550718e-001,
	3.413749e+000,
	4.999065e-001,
	-1.477471e+000,
	-5.819223e-001,
	1.329471e+000,
	-2.694229e-001,
	-4.575905e-002,
	5.087866e-001,
	-6.857139e-002,
	1.810092e+000,
	6.318693e-001,
	-1.046136e+000,
	-6.763679e-002,
	6.725076e-001,
	-1.036786e+000,
	-3.192799e-001,
	1.724205e+000,
	6.468388e-002,
	3.953855e+000,
	9.417528e-001,
	-1.033910e+000,
	-1.295544e-001,
	-4.551294e-001,
	2.659205e+000,
	8.887235e-001,
	-1.733153e+000,
	6.540117e-001,
	8.046523e-001,
	3.597443e-001,
	-1.094530e+000,
	-2.282012e-001,
	2.298267e+000,
	-5.184881e+000,
	-6.122309e+000,
	2.590799e+000,
	-1.618707e-001,
	1.116033e+000,
	8.867666e-001,
	-1.095556e+000,
	-1.807112e-001,
	1.406193e+000,
	8.120385e+000,
	-3.058239e+000,
	-1.121150e+000,
	2.933606e-001,
	1.488339e+000,
	6.374827e-001,
	// albedo 1, turbidity 6
	-1.270123e+000,
	-3.552595e-001,
	-8.975893e+000,
	9.110080e+000,
	-3.388207e-003,
	3.559109e-001,
	1.201097e-001,
	3.109904e+000,
	4.998957e-001,
	-1.663376e+000,
	-7.846840e-001,
	6.951405e-001,
	3.139107e-001,
	-2.448004e-002,
	3.572505e-001,
	1.453572e-002,
	6.307761e-001,
	5.142914e-001,
	-9.518772e-001,
	7.764573e-002,
	1.247094e+000,
	-2.224855e+000,
	-1.195310e-001,
	1.709581e+000,
	-8.836329e-002,
	5.688916e+000,
	1.113629e+000,
	-1.087154e+000,
	-2.665646e-001,
	-8.624251e-001,
	4.536060e+000,
	4.180650e-001,
	-1.629798e+000,
	8.479560e-001,
	-1.293696e+000,
	1.869693e-001,
	-1.064826e+000,
	-1.599892e-001,
	2.285337e+000,
	-8.584887e+000,
	-3.074560e+000,
	2.139459e+000,
	-2.592372e-001,
	1.937577e+000,
	9.957954e-001,
	-1.099622e+000,
	-1.849797e-001,
	1.193609e+000,
	1.416481e+001,
	-5.009527e+000,
	-8.592493e-001,
	3.485606e-001,
	1.884203e+000,
	6.097274e-001,
	// albedo 1, turbidity 7
	-1.344841e+000,
	-4.339942e-001,
	-9.193112e+000,
	9.385864e+000,
	-9.742818e-003,
	4.812040e-001,
	7.690647e-002,
	2.843801e+000,
	5.228047e-001,
	-1.975928e+000,
	-1.042040e+000,
	9.695714e-001,
	3.718000e-001,
	-3.334078e-002,
	1.333620e-001,
	8.180282e-002,
	-1.652429e-001,
	3.267010e-001,
	-8.651864e-001,
	1.288722e-001,
	6.811456e-001,
	-3.282787e+000,
	-9.074685e-002,
	1.894059e+000,
	-1.849744e-001,
	6.610614e+000,
	1.322978e+000,
	-1.103780e+000,
	-3.279618e-001,
	-4.193802e-001,
	7.331165e+000,
	6.529659e-001,
	-2.227297e+000,
	9.625482e-001,
	-3.348971e+000,
	-7.261722e-003,
	-1.055963e+000,
	-1.527328e-001,
	1.786114e+000,
	-1.367578e+001,
	-3.450729e+000,
	2.641691e+000,
	-3.229222e-001,
	2.800131e+000,
	1.129409e+000,
	-1.111541e+000,
	-2.123518e-001,
	1.286159e+000,
	2.297563e+001,
	-4.591526e+000,
	-1.374672e+000,
	3.462811e-001,
	1.071127e+000,
	5.498514e-001,
	// albedo 1, turbidity 8
	-1.387544e+000,
	-4.964558e-001,
	-9.744778e+000,
	1.014533e+001,
	-2.463089e-002,
	7.188705e-001,
	3.919951e-003,
	2.760792e+000,
	7.369418e-001,
	-2.206536e+000,
	-1.191342e+000,
	-2.244384e+000,
	3.629413e+000,
	-3.601610e-002,
	7.725349e-002,
	5.357588e-002,
	-2.692147e-001,
	-1.142476e-001,
	-1.358286e+000,
	-2.268740e-001,
	9.805731e-001,
	-5.163195e+000,
	-8.589000e-003,
	7.697565e-001,
	2.198750e-001,
	7.029301e+000,
	1.567170e+000,
	-7.167767e-001,
	-2.969978e-001,
	2.300987e-001,
	7.956088e+000,
	6.339728e-001,
	-6.195374e-001,
	2.502844e-001,
	-6.307569e+000,
	-2.208822e-002,
	-1.210525e+000,
	-1.245541e-001,
	9.742409e-001,
	-9.705683e+000,
	-1.658899e+000,
	1.365829e+000,
	2.003500e-001,
	4.400174e+000,
	1.042345e+000,
	-1.061524e+000,
	-2.323500e-001,
	1.284880e+000,
	1.294836e+001,
	-5.011732e+000,
	-9.141086e-001,
	2.723804e-001,
	6.225528e-001,
	6.030977e-001,
	// albedo 1, turbidity 9
	-1.548946e+000,
	-6.802676e-001,
	-1.274231e+001,
	1.312954e+001,
	-1.834225e-002,
	7.051580e-001,
	-8.330446e-006,
	2.320435e+000,
	9.001244e-001,
	-1.867128e+000,
	-9.670210e-001,
	-6.847422e+000,
	7.952765e+000,
	-1.985986e-002,
	1.690548e-002,
	-1.176902e-002,
	8.988469e-001,
	-3.242269e-001,
	-3.470633e+000,
	-1.555121e+000,
	2.684966e+000,
	-5.964736e+000,
	-5.524158e-003,
	1.187089e+000,
	2.552534e-001,
	4.394076e+000,
	1.656399e+000,
	4.095837e-001,
	1.440005e-001,
	-5.602190e-001,
	7.110869e+000,
	2.313366e-001,
	-1.373206e+000,
	1.973962e-001,
	-4.112998e+000,
	-5.877027e-002,
	-1.540633e+000,
	-3.264234e-001,
	1.072405e+000,
	-7.205546e+000,
	-5.125251e-001,
	2.009905e+000,
	1.531985e-001,
	2.113439e+000,
	1.042547e+000,
	-1.013330e+000,
	-2.663837e-001,
	1.168934e+000,
	9.315778e+000,
	-4.320502e+000,
	-1.303393e+000,
	2.825872e-001,
	2.365015e-001,
	5.993344e-001,
	// albedo 1, turbidity 10
	-2.055426e+000,
	-1.093229e+000,
	-3.487182e+000,
	3.753855e+000,
	-4.639837e-002,
	5.797714e-001,
	-8.056992e-006,
	1.916262e+000,
	9.001298e-001,
	-1.643864e+000,
	-9.676934e-001,
	-1.147133e+001,
	1.253880e+001,
	2.347351e-002,
	-1.602964e-002,
	4.481579e-003,
	1.373645e+000,
	-2.884929e-001,
	-6.156336e+000,
	-2.568735e+000,
	6.499533e+000,
	-9.136753e+000,
	-1.751599e-001,
	1.876960e+000,
	-7.959051e-002,
	3.074951e+000,
	1.579874e+000,
	7.378485e-001,
	-2.614544e-001,
	-2.861777e+000,
	9.518947e+000,
	5.033808e-001,
	-1.844722e+000,
	6.855962e-001,
	-1.497263e+000,
	-9.081643e-002,
	-1.341940e+000,
	-3.847183e-001,
	2.045437e+000,
	-1.179073e+001,
	-1.532773e+000,
	1.639939e+000,
	-2.668175e-001,
	-8.401827e-001,
	1.083722e+000,
	-1.086126e+000,
	-2.811402e-001,
	7.554239e-001,
	1.862181e+001,
	-4.343385e+000,
	-8.611011e-001,
	3.146558e-001,
	7.022438e-001,
	5.872694e-001,
};

double datasetRad560[] = 
{
	// albedo 0, turbidity 1
	1.518543e-002,
	1.176421e-002,
	1.736355e-002,
	1.085640e-001,
	4.928107e-002,
	6.789277e-002,
	// albedo 0, turbidity 2
	1.482072e-002,
	1.335627e-002,
	7.685462e-003,
	1.336625e-001,
	4.842644e-002,
	7.083679e-002,
	// albedo 0, turbidity 3
	1.406436e-002,
	1.604888e-002,
	-9.000273e-003,
	1.735923e-001,
	4.526955e-002,
	7.742648e-002,
	// albedo 0, turbidity 4
	1.296165e-002,
	2.074811e-002,
	-3.672731e-002,
	2.310227e-001,
	4.272776e-002,
	8.807197e-002,
	// albedo 0, turbidity 5
	1.185836e-002,
	2.557920e-002,
	-6.240734e-002,
	2.766326e-001,
	4.714655e-002,
	9.809189e-002,
	// albedo 0, turbidity 6
	1.107469e-002,
	2.825097e-002,
	-7.618392e-002,
	2.978619e-001,
	5.429803e-002,
	1.044545e-001,
	// albedo 0, turbidity 7
	1.030435e-002,
	3.060206e-002,
	-8.858708e-002,
	3.072427e-001,
	8.473378e-002,
	1.077059e-001,
	// albedo 0, turbidity 8
	9.197751e-003,
	3.269422e-002,
	-9.785581e-002,
	2.997964e-001,
	1.328366e-001,
	1.192367e-001,
	// albedo 0, turbidity 9
	8.191103e-003,
	3.038883e-002,
	-8.623921e-002,
	2.362785e-001,
	2.259917e-001,
	1.331360e-001,
	// albedo 0, turbidity 10
	7.275920e-003,
	2.128876e-002,
	-4.464890e-002,
	1.022425e-001,
	3.640615e-001,
	1.521652e-001,
	// albedo 1, turbidity 1
	1.623600e-002,
	1.386631e-002,
	1.790676e-002,
	9.999420e-002,
	1.334051e-001,
	1.524062e-001,
	// albedo 1, turbidity 2
	1.580346e-002,
	1.594123e-002,
	5.795411e-003,
	1.311774e-001,
	1.256680e-001,
	1.627637e-001,
	// albedo 1, turbidity 3
	1.508292e-002,
	1.888592e-002,
	-1.186753e-002,
	1.719109e-001,
	1.235706e-001,
	1.739866e-001,
	// albedo 1, turbidity 4
	1.385430e-002,
	2.238574e-002,
	-3.390048e-002,
	2.155912e-001,
	1.366535e-001,
	1.840316e-001,
	// albedo 1, turbidity 5
	1.289448e-002,
	2.572803e-002,
	-5.406854e-002,
	2.481650e-001,
	1.539663e-001,
	1.943329e-001,
	// albedo 1, turbidity 6
	1.229427e-002,
	2.715903e-002,
	-6.212273e-002,
	2.543339e-001,
	1.780617e-001,
	1.961306e-001,
	// albedo 1, turbidity 7
	1.142362e-002,
	2.928317e-002,
	-7.246911e-002,
	2.573202e-001,
	2.123595e-001,
	2.030761e-001,
	// albedo 1, turbidity 8
	1.030850e-002,
	2.979460e-002,
	-7.568370e-002,
	2.359473e-001,
	2.693691e-001,
	2.158786e-001,
	// albedo 1, turbidity 9
	9.256414e-003,
	2.622384e-002,
	-5.910990e-002,
	1.602850e-001,
	3.679614e-001,
	2.281095e-001,
	// albedo 1, turbidity 10
	8.220083e-003,
	1.701079e-002,
	-1.768254e-002,
	2.593519e-002,
	4.977242e-001,
	2.394514e-001,
};

double dataset600[] = 
{
	// albedo 0, turbidity 1
	-1.120756e+000,
	-1.756050e-001,
	-3.557732e+000,
	5.117996e+000,
	-1.042966e-001,
	1.269364e+000,
	1.318863e-002,
	3.718263e+000,
	5.393663e-001,
	-1.170564e+000,
	-1.845108e-001,
	1.081952e+000,
	1.330153e+000,
	-2.486698e-001,
	7.864551e-001,
	3.710973e-003,
	4.567181e+000,
	4.998408e-001,
	-1.036563e+000,
	-2.605284e-001,
	3.803752e+000,
	-3.585400e+000,
	-9.070196e-001,
	2.380958e+000,
	-1.320680e-002,
	-4.210738e+000,
	1.085121e+000,
	-1.193752e+000,
	-1.236757e-001,
	-2.036484e-001,
	4.137855e+000,
	1.566414e+000,
	8.510547e-001,
	1.653213e-002,
	5.488784e+000,
	2.335910e-001,
	-9.950781e-001,
	-2.103974e-001,
	2.992004e+000,
	-4.050491e+000,
	-6.354208e+000,
	2.250652e+000,
	-1.548511e-002,
	-1.876535e+000,
	9.733518e-001,
	-1.106820e+000,
	-1.804412e-001,
	1.960315e+000,
	3.667064e+000,
	-2.460232e+000,
	9.553453e-001,
	1.238019e-002,
	1.307691e+000,
	5.564710e-001,
	// albedo 0, turbidity 2
	-1.112834e+000,
	-1.534956e-001,
	-4.968015e+000,
	6.079068e+000,
	-8.917942e-002,
	1.167545e+000,
	5.945633e-002,
	5.295468e+000,
	6.272123e-001,
	-1.160910e+000,
	-1.640745e-001,
	7.416807e-001,
	-2.894668e-001,
	-8.983936e-002,
	3.778575e-002,
	2.133300e-001,
	6.390765e+000,
	3.592393e-001,
	-1.054872e+000,
	-2.642844e-001,
	4.375802e+000,
	-1.434824e+000,
	-7.521504e-001,
	3.669027e+000,
	-2.992879e-001,
	-5.159653e+000,
	1.284643e+000,
	-1.147542e+000,
	1.011446e-002,
	-2.308529e+000,
	1.587994e+000,
	1.226957e+000,
	-1.328837e+000,
	5.996235e-001,
	1.004278e+001,
	5.212352e-002,
	-1.023945e+000,
	-2.867193e-001,
	3.733660e+000,
	-2.572157e+000,
	-7.749675e+000,
	3.927326e+000,
	-3.230666e-001,
	-4.260418e+000,
	1.091761e+000,
	-1.100815e+000,
	-1.590204e-001,
	1.413330e+000,
	6.546557e+000,
	-2.407235e+000,
	-2.678587e-001,
	2.367155e-001,
	2.242596e+000,
	5.273419e-001,
	// albedo 0, turbidity 3
	-1.137271e+000,
	-1.838447e-001,
	-2.268731e+000,
	3.013967e+000,
	-1.471213e-001,
	9.047947e-001,
	8.086373e-002,
	4.834215e+000,
	6.545047e-001,
	-1.136415e+000,
	-1.536696e-001,
	-1.821062e+000,
	1.756804e+000,
	-9.313635e-002,
	2.208938e-001,
	2.021774e-001,
	7.289664e+000,
	4.997813e-001,
	-1.173214e+000,
	-3.202233e-001,
	4.868221e+000,
	-2.485467e+000,
	-7.693969e-001,
	3.027854e+000,
	-1.745243e-001,
	-4.896365e+000,
	1.014186e+000,
	-1.021346e+000,
	7.262425e-002,
	-2.940205e+000,
	3.357462e+000,
	1.150486e+000,
	-1.710207e+000,
	7.381637e-001,
	9.857427e+000,
	3.036725e-001,
	-1.082107e+000,
	-2.721172e-001,
	3.071962e+000,
	-7.058088e+000,
	-5.103538e+000,
	3.852302e+000,
	-2.281911e-001,
	-2.565665e+000,
	9.669584e-001,
	-1.076296e+000,
	-1.655466e-001,
	1.323765e+000,
	1.496892e+001,
	-3.773928e+000,
	-5.211752e-001,
	2.583009e-001,
	1.797906e+000,
	5.888323e-001,
	// albedo 0, turbidity 4
	-1.180432e+000,
	-2.327942e-001,
	-7.152650e-001,
	1.078120e+000,
	-2.935788e-001,
	6.977295e-001,
	1.118530e-001,
	4.270574e+000,
	6.241267e-001,
	-1.260549e+000,
	-2.865438e-001,
	-2.736770e+000,
	2.720969e+000,
	1.291231e-001,
	4.072562e-001,
	4.510932e-002,
	5.412464e+000,
	6.781695e-001,
	-1.119712e+000,
	-2.521160e-001,
	4.860527e+000,
	-1.950603e+000,
	-1.598805e+000,
	2.556718e+000,
	2.462723e-002,
	-2.059404e+000,
	8.000995e-001,
	-1.056386e+000,
	2.018258e-002,
	-3.728955e+000,
	1.022270e+000,
	1.722210e+000,
	-2.691554e+000,
	8.329883e-001,
	6.982450e+000,
	4.746778e-001,
	-1.044811e+000,
	-2.531291e-001,
	3.102204e+000,
	-3.662632e+000,
	-5.609358e+000,
	4.574385e+000,
	-2.173600e-001,
	-1.646110e+000,
	8.593305e-001,
	-1.090027e+000,
	-1.699462e-001,
	7.118896e-001,
	1.287572e+001,
	-2.747429e+000,
	-1.706223e+000,
	4.483382e-001,
	2.029605e+000,
	6.366599e-001,
	// albedo 0, turbidity 5
	-1.232266e+000,
	-2.905676e-001,
	-4.158347e-001,
	5.285264e-001,
	-3.064312e-001,
	5.569478e-001,
	1.195289e-001,
	3.788091e+000,
	5.970680e-001,
	-1.451205e+000,
	-5.169964e-001,
	-2.018331e-001,
	1.499655e+000,
	-1.575963e+000,
	2.761459e-001,
	5.184923e-002,
	2.301119e+000,
	6.177771e-001,
	-1.059832e+000,
	-7.658003e-002,
	6.456894e-001,
	-4.398594e+000,
	5.369604e+000,
	2.121235e+000,
	3.210869e-002,
	3.542794e+000,
	9.114953e-001,
	-1.040966e+000,
	-1.269405e-001,
	-3.751056e-001,
	1.229395e+001,
	-1.977090e+001,
	-2.458488e+000,
	7.711932e-001,
	8.079227e-001,
	3.865305e-001,
	-1.061923e+000,
	-1.981907e-001,
	1.089854e+000,
	-3.414507e+000,
	8.032592e+000,
	3.459965e+000,
	-1.253984e-001,
	1.188198e+000,
	8.639277e-001,
	-1.070607e+000,
	-1.627049e-001,
	7.012071e-001,
	2.138780e+000,
	-5.006595e+000,
	-1.096698e+000,
	6.658771e-001,
	1.999430e+000,
	6.557122e-001,
	// albedo 0, turbidity 6
	-1.280090e+000,
	-3.357179e-001,
	-9.337154e-002,
	-5.075553e-003,
	-3.096112e+000,
	4.001499e-001,
	1.489818e-001,
	3.515349e+000,
	5.571477e-001,
	-1.648190e+000,
	-7.024227e-001,
	-2.925797e-002,
	1.658094e+000,
	4.229924e+000,
	3.502683e-001,
	3.180108e-002,
	1.430955e+000,
	5.739552e-001,
	-9.589189e-001,
	2.559557e-002,
	2.192186e-001,
	-5.276316e+000,
	-4.153922e+000,
	1.855574e+000,
	3.052317e-002,
	4.323694e+000,
	9.839497e-001,
	-1.076589e+000,
	-1.936109e-001,
	-4.162615e-001,
	1.202609e+001,
	-9.327314e+000,
	-2.326508e+000,
	7.983253e-001,
	2.100845e-001,
	3.135170e-001,
	-1.049437e+000,
	-1.694738e-001,
	1.062110e+000,
	5.575299e+000,
	4.846701e-001,
	3.089474e+000,
	-1.584214e-001,
	1.369457e+000,
	8.995377e-001,
	-1.069986e+000,
	-1.830827e-001,
	5.006422e-001,
	-3.063835e-003,
	-2.768514e+000,
	-1.258027e+000,
	6.679955e-001,
	1.840288e+000,
	6.498676e-001,
	// albedo 0, turbidity 7
	-1.328971e+000,
	-3.853230e-001,
	-2.343098e-001,
	-6.505414e-003,
	-4.859294e+000,
	3.752993e-001,
	1.670718e-001,
	3.474961e+000,
	4.998573e-001,
	-2.023062e+000,
	-1.023840e+000,
	4.308501e-001,
	1.473146e+000,
	6.112105e+000,
	5.767265e-001,
	-3.107377e-002,
	7.748759e-002,
	5.016978e-001,
	-8.575747e-001,
	1.580212e-001,
	-7.365004e-001,
	-4.007773e+000,
	-4.051657e+000,
	8.889282e-001,
	1.978413e-001,
	6.282132e+000,
	1.063928e+000,
	-1.073428e+000,
	-3.228761e-001,
	4.793085e-001,
	5.455778e+000,
	-7.830559e+000,
	-9.794478e-001,
	5.370543e-001,
	-3.022750e+000,
	2.818600e-001,
	-1.057120e+000,
	-1.266841e-001,
	4.555368e-001,
	1.201278e+001,
	-9.293773e-001,
	1.439595e+000,
	3.262182e-002,
	2.890364e+000,
	8.821540e-001,
	-1.060079e+000,
	-1.816680e-001,
	3.541107e-001,
	-2.642196e-003,
	-2.588317e+000,
	-5.640010e-001,
	6.643994e-001,
	1.673077e+000,
	6.658333e-001,
	// albedo 0, turbidity 8
	-1.395409e+000,
	-4.658947e-001,
	-4.370597e-001,
	1.342039e+000,
	-1.108674e+000,
	6.439316e-001,
	1.355229e-002,
	3.241153e+000,
	6.696079e-001,
	-2.418167e+000,
	-1.266061e+000,
	3.287382e-001,
	-1.486721e+000,
	-6.770180e-001,
	2.439008e-001,
	1.703788e-001,
	1.664559e-002,
	-6.330217e-003,
	-1.221212e+000,
	-1.072571e-001,
	-1.655914e+000,
	2.659047e+000,
	6.830770e+000,
	4.984792e-001,
	2.538158e-001,
	6.500660e+000,
	1.486576e+000,
	-7.182331e-001,
	-2.519055e-001,
	1.641261e+000,
	-5.500375e+000,
	-1.253143e+001,
	-1.542672e-001,
	1.741161e-001,
	-4.907497e+000,
	7.968864e-002,
	-1.207117e+000,
	-1.635739e-001,
	-3.256308e-001,
	1.409033e+001,
	1.107883e+000,
	7.217342e-001,
	3.158860e-001,
	3.537550e+000,
	9.389751e-001,
	-1.015927e+000,
	-1.890895e-001,
	4.180376e-001,
	9.528535e+000,
	-4.073979e+000,
	-8.713087e-001,
	4.899379e-001,
	1.277831e+000,
	6.519818e-001,
	// albedo 0, turbidity 9
	-1.551242e+000,
	-6.400568e-001,
	-3.673011e-001,
	1.623228e+000,
	-1.482572e+000,
	5.625944e-001,
	-1.130924e-005,
	2.792007e+000,
	9.000924e-001,
	-1.971409e+000,
	-9.004995e-001,
	-2.337582e-001,
	-1.511905e+000,
	6.645432e-002,
	6.149087e-001,
	-3.184094e-002,
	2.026210e+000,
	-2.799058e-001,
	-3.464015e+000,
	-1.604654e+000,
	-1.514516e+000,
	2.768075e+000,
	4.084166e+000,
	-4.287171e-001,
	7.112107e-001,
	2.896460e+000,
	1.502031e+000,
	4.069978e-001,
	2.775394e-001,
	1.525761e+000,
	-5.264056e+000,
	-7.108445e+000,
	1.134996e+000,
	-4.122625e-001,
	-2.558151e+000,
	2.009854e-001,
	-1.504217e+000,
	-3.618442e-001,
	-2.305374e-001,
	1.434481e+001,
	-1.713254e+000,
	-5.670708e-001,
	5.206848e-001,
	1.704009e+000,
	8.447497e-001,
	-9.753124e-001,
	-2.080868e-001,
	2.450141e-001,
	-3.535206e-003,
	-2.121317e+000,
	-1.425634e-001,
	4.670084e-001,
	1.027875e+000,
	6.735543e-001,
	// albedo 0, turbidity 10
	-2.027207e+000,
	-1.003600e+000,
	-3.813114e-001,
	9.357907e-001,
	-1.031886e+000,
	5.523389e-001,
	-8.883940e-006,
	2.339379e+000,
	9.001659e-001,
	-1.506235e+000,
	-7.795241e-001,
	-4.313309e-001,
	9.124054e-001,
	-7.484352e-001,
	-8.417756e-002,
	-1.426561e-002,
	2.571178e+000,
	-2.504298e-001,
	-6.482777e+000,
	-2.700075e+000,
	-1.556622e+000,
	-2.978497e+000,
	4.623255e+000,
	1.953868e+000,
	3.113178e-001,
	2.311303e+000,
	1.451021e+000,
	9.357272e-001,
	-1.066566e-001,
	1.476763e+000,
	6.889797e+000,
	-1.038036e+001,
	-2.094856e+000,
	1.330069e-001,
	-1.446404e+000,
	1.121890e-001,
	-1.398229e+000,
	-3.167573e-001,
	-1.276866e-001,
	1.239440e+000,
	1.816678e+000,
	1.586775e+000,
	8.043533e-002,
	3.219192e-001,
	9.200620e-001,
	-1.070734e+000,
	-3.636167e-001,
	2.426490e-001,
	8.282765e+000,
	-3.588710e+000,
	-9.105402e-001,
	3.760276e-001,
	5.756358e-001,
	6.508161e-001,
	// albedo 1, turbidity 1
	-1.120757e+000,
	-1.756034e-001,
	-3.557732e+000,
	5.117996e+000,
	-1.042960e-001,
	1.269364e+000,
	1.318834e-002,
	3.718263e+000,
	5.393663e-001,
	-1.170565e+000,
	-1.845093e-001,
	1.081952e+000,
	1.330153e+000,
	-2.486697e-001,
	7.864550e-001,
	3.709405e-003,
	4.567181e+000,
	4.998408e-001,
	-1.036564e+000,
	-2.605265e-001,
	3.803752e+000,
	-3.585400e+000,
	-9.070196e-001,
	2.380958e+000,
	-1.320996e-002,
	-4.210738e+000,
	1.085121e+000,
	-1.193753e+000,
	-1.236733e-001,
	-2.036483e-001,
	4.137855e+000,
	1.566414e+000,
	8.510543e-001,
	1.652749e-002,
	5.488784e+000,
	2.335910e-001,
	-9.950796e-001,
	-2.103948e-001,
	2.992004e+000,
	-4.050491e+000,
	-6.354208e+000,
	2.250652e+000,
	-1.548996e-002,
	-1.876535e+000,
	9.733518e-001,
	-1.106823e+000,
	-1.804388e-001,
	1.960315e+000,
	3.667064e+000,
	-2.460232e+000,
	9.553451e-001,
	1.237721e-002,
	1.307692e+000,
	5.564710e-001,
	// albedo 1, turbidity 2
	-1.113356e+000,
	-1.560185e-001,
	-7.788803e+000,
	8.963658e+000,
	-5.322872e-002,
	1.116670e+000,
	7.024842e-002,
	4.886694e+000,
	5.931909e-001,
	-1.134232e+000,
	-1.667475e-001,
	4.176259e+000,
	-3.242194e+000,
	-7.889230e-002,
	8.254326e-002,
	1.400333e-001,
	5.395289e+000,
	4.862375e-001,
	-1.105040e+000,
	-2.389195e-001,
	9.866260e-001,
	1.271557e+000,
	-6.066849e-001,
	3.599900e+000,
	-1.681445e-001,
	-2.812867e+000,
	1.053791e+000,
	-1.078302e+000,
	-2.258635e-002,
	7.407482e-001,
	1.805864e-001,
	9.070580e-001,
	-1.720820e+000,
	4.256187e-001,
	6.982502e+000,
	3.350778e-001,
	-1.070883e+000,
	-2.752054e-001,
	2.937203e+000,
	-2.246366e+000,
	-9.847865e+000,
	3.104714e+000,
	-2.573859e-001,
	-2.816401e+000,
	8.478900e-001,
	-1.090880e+000,
	-1.453755e-001,
	2.046382e+000,
	5.595795e+000,
	-2.809181e+000,
	-9.239576e-001,
	1.783176e-001,
	2.051350e+000,
	5.815062e-001,
	// albedo 1, turbidity 3
	-1.136641e+000,
	-1.825277e-001,
	-3.464338e+000,
	4.413974e+000,
	-1.123917e-001,
	1.009115e+000,
	5.542918e-002,
	4.702599e+000,
	6.799974e-001,
	-1.146478e+000,
	-1.593833e-001,
	-9.055790e-001,
	8.991902e-001,
	-4.711416e-002,
	-3.813573e-001,
	2.290428e-001,
	6.961903e+000,
	4.206011e-001,
	-1.136317e+000,
	-3.103198e-001,
	4.219694e+000,
	-2.031887e+000,
	-7.184952e-001,
	3.795646e+000,
	-1.650547e-001,
	-5.402471e+000,
	1.118561e+000,
	-1.044973e+000,
	7.826651e-002,
	-2.043684e+000,
	3.410720e+000,
	1.974969e+000,
	-2.736513e+000,
	6.828176e-001,
	1.049084e+001,
	1.894241e-001,
	-1.076125e+000,
	-2.930526e-001,
	3.722784e+000,
	-7.364061e+000,
	-7.399428e+000,
	4.034307e+000,
	-3.489831e-001,
	-3.438955e+000,
	1.077145e+000,
	-1.100551e+000,
	-1.533449e-001,
	1.767589e+000,
	1.479022e+001,
	-2.910058e+000,
	-1.732923e+000,
	2.193598e-001,
	1.880974e+000,
	4.999331e-001,
	// albedo 1, turbidity 4
	-1.175282e+000,
	-2.274651e-001,
	-8.788053e-001,
	1.446934e+000,
	-2.568124e-001,
	7.201567e-001,
	1.054963e-001,
	4.149007e+000,
	6.084060e-001,
	-1.224868e+000,
	-2.528005e-001,
	-2.861303e+000,
	3.033667e+000,
	1.405049e-001,
	2.481768e-001,
	6.435189e-002,
	5.409907e+000,
	6.372238e-001,
	-1.144647e+000,
	-3.063749e-001,
	4.347579e+000,
	-2.473291e+000,
	-1.180139e+000,
	2.550631e+000,
	3.833967e-002,
	-3.231444e+000,
	8.737219e-001,
	-1.028428e+000,
	8.888974e-002,
	-2.431225e+000,
	2.811511e+000,
	2.400771e+000,
	-2.380403e+000,
	7.114868e-001,
	8.190106e+000,
	4.166861e-001,
	-1.076730e+000,
	-3.129260e-001,
	3.582560e+000,
	-5.902417e+000,
	-6.959342e+000,
	3.528030e+000,
	-2.613596e-001,
	-2.993803e+000,
	8.934226e-001,
	-1.107957e+000,
	-1.728652e-001,
	1.679540e+000,
	1.238391e+001,
	-2.945620e+000,
	-1.568811e+000,
	2.418421e-001,
	1.360652e+000,
	6.182405e-001,
	// albedo 1, turbidity 5
	-1.215034e+000,
	-2.755459e-001,
	-1.477751e-001,
	4.448730e-001,
	-4.027817e-001,
	4.787013e-001,
	1.200617e-001,
	3.613995e+000,
	5.999756e-001,
	-1.443500e+000,
	-5.194350e-001,
	1.588243e-001,
	1.429114e+000,
	-2.310655e+000,
	3.033213e-001,
	2.308566e-002,
	1.894189e+000,
	6.066576e-001,
	-1.051421e+000,
	-9.990731e-002,
	5.187710e-001,
	-3.890856e+000,
	7.794599e+000,
	1.810628e+000,
	6.532073e-002,
	2.564480e+000,
	9.334916e-001,
	-1.034548e+000,
	-6.777012e-002,
	-2.587520e-002,
	1.062675e+001,
	-2.266196e+001,
	-2.002081e+000,
	7.508804e-001,
	2.022771e+000,
	3.517577e-001,
	-1.090576e+000,
	-2.542157e-001,
	2.213560e+000,
	-3.563890e+000,
	9.180955e+000,
	2.780121e+000,
	-2.656654e-001,
	-5.012514e-002,
	8.968751e-001,
	-1.104356e+000,
	-1.955634e-001,
	1.782217e+000,
	1.085584e+000,
	-5.011522e+000,
	-1.075140e+000,
	3.828238e-001,
	6.133363e-001,
	6.448312e-001,
	// albedo 1, turbidity 6
	-1.261147e+000,
	-3.271435e-001,
	1.136430e-001,
	-3.464762e-003,
	-3.025565e+000,
	3.660675e-001,
	1.337332e-001,
	3.190374e+000,
	5.655627e-001,
	-1.611753e+000,
	-6.914768e-001,
	2.911405e-001,
	1.806475e+000,
	2.823240e+000,
	3.320241e-001,
	2.606391e-002,
	9.946717e-001,
	5.581393e-001,
	-9.491151e-001,
	9.848038e-003,
	2.711804e-001,
	-5.319331e+000,
	1.135835e-001,
	1.669815e+000,
	3.604115e-002,
	3.506230e+000,
	1.008650e+000,
	-1.109597e+000,
	-1.650703e-001,
	-3.529912e-001,
	1.209251e+001,
	-1.435008e+001,
	-2.085063e+000,
	7.955493e-001,
	1.240407e+000,
	2.856509e-001,
	-1.035803e+000,
	-1.963707e-001,
	2.407913e+000,
	-1.564693e+000,
	4.483717e+000,
	2.795295e+000,
	-2.799711e-001,
	6.851892e-002,
	9.312311e-001,
	-1.132687e+000,
	-2.383551e-001,
	1.590132e+000,
	1.025733e+000,
	-4.837236e+000,
	-1.334195e+000,
	4.022060e-001,
	4.281273e-001,
	6.334802e-001,
	// albedo 1, turbidity 7
	-1.310240e+000,
	-3.819813e-001,
	2.469845e-002,
	-7.043983e-003,
	-5.009925e+000,
	3.560980e-001,
	1.582176e-001,
	2.966421e+000,
	4.998910e-001,
	-1.993638e+000,
	-1.029241e+000,
	7.780588e-001,
	1.080741e+000,
	7.179598e+000,
	2.478857e-001,
	1.935012e-002,
	-3.434240e-001,
	4.813586e-001,
	-8.209344e-001,
	1.728853e-001,
	-7.045676e-001,
	-3.384688e+000,
	-4.855111e+000,
	1.661563e+000,
	4.252574e-002,
	5.701648e+000,
	1.110774e+000,
	-1.130678e+000,
	-3.273624e-001,
	5.555549e-001,
	5.800793e+000,
	-8.817085e+000,
	-2.344445e+000,
	7.532869e-001,
	-2.418368e+000,
	2.201826e-001,
	-1.032417e+000,
	-1.335568e-001,
	1.707051e+000,
	8.168228e+000,
	-5.151972e-003,
	2.785504e+000,
	-2.123703e-001,
	1.770173e+000,
	9.064082e-001,
	-1.125604e+000,
	-2.328530e-001,
	1.537245e+000,
	4.347312e+000,
	-4.368526e+000,
	-1.527321e+000,
	3.574251e-001,
	5.982159e-001,
	6.705880e-001,
	// albedo 1, turbidity 8
	-1.381743e+000,
	-4.607543e-001,
	-2.754732e-001,
	9.134243e-001,
	-7.581174e-001,
	6.220814e-001,
	2.353878e-002,
	2.891536e+000,
	6.426078e-001,
	-2.362341e+000,
	-1.306326e+000,
	6.909936e-001,
	-7.196658e-001,
	-4.501812e-001,
	-5.219928e-002,
	2.111683e-001,
	-9.499603e-001,
	3.301774e-002,
	-1.218829e+000,
	-6.834768e-002,
	-1.241760e+000,
	1.122890e+000,
	5.750762e+000,
	1.231058e+000,
	6.884716e-003,
	6.801032e+000,
	1.512485e+000,
	-6.781560e-001,
	-2.446588e-001,
	1.302166e+000,
	-2.334650e+000,
	-1.218960e+001,
	-1.257952e+000,
	5.387955e-001,
	-5.559859e+000,
	-1.209718e-002,
	-1.270037e+000,
	-1.870204e-001,
	9.650201e-001,
	9.976613e+000,
	1.444014e+000,
	1.523442e+000,
	-2.753646e-002,
	3.415790e+000,
	1.017645e+000,
	-1.046712e+000,
	-2.173979e-001,
	1.473981e+000,
	4.368847e+000,
	-4.642506e+000,
	-1.049951e+000,
	3.511771e-001,
	2.379457e-001,
	6.307946e-001,
	// albedo 1, turbidity 9
	-1.532302e+000,
	-6.390752e-001,
	-1.369123e-001,
	1.480171e+000,
	-1.313391e+000,
	5.210118e-001,
	-1.053608e-005,
	2.352090e+000,
	9.000581e-001,
	-2.042866e+000,
	-1.015386e+000,
	1.750126e-001,
	-9.921800e-001,
	-9.449241e-002,
	4.791921e-001,
	-2.744712e-002,
	9.337925e-001,
	-2.902902e-001,
	-3.413474e+000,
	-1.485380e+000,
	-1.301300e+000,
	1.266203e+000,
	3.869657e+000,
	-1.405606e-002,
	6.109944e-001,
	3.883967e+000,
	1.540321e+000,
	5.838664e-001,
	2.370098e-001,
	1.420200e+000,
	-1.803001e+000,
	-6.672775e+000,
	2.866921e-001,
	-2.599250e-001,
	-4.162164e+000,
	1.296901e-001,
	-1.654226e+000,
	-3.296843e-001,
	6.245723e-001,
	7.899655e+000,
	-1.079857e+000,
	3.145485e-001,
	4.085894e-001,
	2.258895e+000,
	9.071309e-001,
	-9.748612e-001,
	-2.545963e-001,
	1.374064e+000,
	-2.816107e-003,
	-2.589259e+000,
	-5.960628e-001,
	2.656787e-001,
	-1.458520e-001,
	6.529731e-001,
	// albedo 1, turbidity 10
	-1.944006e+000,
	-9.776516e-001,
	-2.425412e-001,
	8.187180e-001,
	-6.620102e-001,
	5.676187e-001,
	-7.857556e-006,
	1.944153e+000,
	9.001463e-001,
	-1.294455e+000,
	-7.294996e-001,
	-1.718682e-002,
	1.261264e+000,
	-1.170104e+000,
	-2.029198e-001,
	-1.306023e-002,
	1.821821e+000,
	-2.533820e-001,
	-6.849943e+000,
	-2.937611e+000,
	-1.107710e+000,
	-3.923478e+000,
	5.018293e+000,
	2.040419e+000,
	2.845113e-001,
	2.080902e+000,
	1.460328e+000,
	1.445166e+000,
	1.641979e-001,
	9.591325e-001,
	8.676572e+000,
	-1.098801e+001,
	-2.274573e+000,
	1.340040e-001,
	-1.166380e+000,
	1.014270e-001,
	-1.596800e+000,
	-4.130457e-001,
	9.250919e-001,
	-1.406592e+000,
	2.474727e+000,
	1.748285e+000,
	9.929937e-002,
	-6.705073e-001,
	9.210646e-001,
	-1.035617e+000,
	-3.537996e-001,
	1.073337e+000,
	6.090616e+000,
	-3.710420e+000,
	-9.390485e-001,
	2.233788e-001,
	-3.213961e-004,
	6.545784e-001,
};

double datasetRad600[] = 
{
	// albedo 0, turbidity 1
	1.605147e-002,
	1.028116e-002,
	2.949675e-002,
	7.265851e-002,
	4.608279e-002,
	5.069475e-002,
	// albedo 0, turbidity 2
	1.569474e-002,
	1.190744e-002,
	1.996322e-002,
	1.044303e-001,
	3.746120e-002,
	5.764085e-002,
	// albedo 0, turbidity 3
	1.507252e-002,
	1.350309e-002,
	7.291417e-003,
	1.433035e-001,
	3.625213e-002,
	6.291384e-002,
	// albedo 0, turbidity 4
	1.383183e-002,
	1.670171e-002,
	-1.576321e-002,
	1.993796e-001,
	3.837478e-002,
	7.063028e-002,
	// albedo 0, turbidity 5
	1.253723e-002,
	2.261520e-002,
	-4.847485e-002,
	2.646653e-001,
	2.855366e-002,
	8.568437e-002,
	// albedo 0, turbidity 6
	1.179552e-002,
	2.546904e-002,
	-6.503150e-002,
	2.924065e-001,
	3.516626e-002,
	9.101182e-002,
	// albedo 0, turbidity 7
	1.070809e-002,
	3.005971e-002,
	-8.793572e-002,
	3.255182e-001,
	4.780714e-002,
	1.014896e-001,
	// albedo 0, turbidity 8
	9.466972e-003,
	3.330913e-002,
	-1.028545e-001,
	3.284098e-001,
	9.602966e-002,
	1.103224e-001,
	// albedo 0, turbidity 9
	8.190696e-003,
	3.248675e-002,
	-9.882934e-002,
	2.798409e-001,
	1.829752e-001,
	1.263322e-001,
	// albedo 0, turbidity 10
	7.225549e-003,
	2.433471e-002,
	-6.029571e-002,
	1.468935e-001,
	3.282492e-001,
	1.441367e-001,
	// albedo 1, turbidity 1
	1.676204e-002,
	1.269480e-002,
	2.674342e-002,
	7.380770e-002,
	1.072658e-001,
	1.211512e-001,
	// albedo 1, turbidity 2
	1.649305e-002,
	1.445974e-002,
	1.662432e-002,
	1.056364e-001,
	1.002831e-001,
	1.317330e-001,
	// albedo 1, turbidity 3
	1.577677e-002,
	1.637005e-002,
	2.821156e-003,
	1.465189e-001,
	9.971575e-002,
	1.424798e-001,
	// albedo 1, turbidity 4
	1.469049e-002,
	1.969668e-002,
	-2.105278e-002,
	2.024104e-001,
	1.062768e-001,
	1.557134e-001,
	// albedo 1, turbidity 5
	1.339480e-002,
	2.402713e-002,
	-4.671234e-002,
	2.518382e-001,
	1.135974e-001,
	1.711111e-001,
	// albedo 1, turbidity 6
	1.274349e-002,
	2.648472e-002,
	-6.068209e-002,
	2.720113e-001,
	1.285128e-001,
	1.776298e-001,
	// albedo 1, turbidity 7
	1.165402e-002,
	2.958682e-002,
	-7.746524e-002,
	2.912132e-001,
	1.536569e-001,
	1.896419e-001,
	// albedo 1, turbidity 8
	1.048769e-002,
	3.115400e-002,
	-8.550235e-002,
	2.769964e-001,
	2.173505e-001,
	1.991057e-001,
	// albedo 1, turbidity 9
	9.312926e-003,
	2.881725e-002,
	-7.387358e-002,
	2.079818e-001,
	3.221838e-001,
	2.120657e-001,
	// albedo 1, turbidity 10
	8.151793e-003,
	1.998414e-002,
	-3.316224e-002,
	6.957927e-002,
	4.654511e-001,
	2.260782e-001,
};

double dataset640[] = 
{
	// albedo 0, turbidity 1
	-1.113346e+000,
	-1.715076e-001,
	-2.657094e+000,
	4.632520e+000,
	-1.092310e-001,
	1.421516e+000,
	3.230348e-003,
	2.697889e+000,
	6.262031e-001,
	-1.193355e+000,
	-2.074379e-001,
	1.431777e+000,
	8.245570e-001,
	-1.936967e-001,
	9.392137e-001,
	1.972523e-002,
	3.001209e+000,
	4.415825e-001,
	-9.337792e-001,
	-2.037239e-001,
	3.943675e+000,
	-2.487730e+000,
	-9.876315e-001,
	2.772411e+000,
	-4.919462e-002,
	-4.176827e+000,
	1.026227e+000,
	-1.297623e+000,
	-1.296758e-001,
	-3.144502e-001,
	2.454199e+000,
	2.433614e+000,
	5.298928e-001,
	7.814939e-002,
	6.564581e+000,
	5.587597e-001,
	-9.325270e-001,
	-1.997966e-001,
	3.363315e+000,
	-1.887198e+000,
	-8.905212e+000,
	2.808597e+000,
	-9.537165e-002,
	-3.059702e+000,
	5.403718e-001,
	-1.125650e+000,
	-1.904795e-001,
	2.099998e+000,
	1.251930e+000,
	-1.899312e+000,
	5.255919e-001,
	9.848260e-002,
	9.627433e-001,
	6.251236e-001,
	// albedo 0, turbidity 2
	-1.104956e+000,
	-1.372068e-001,
	-2.996624e+000,
	4.260021e+000,
	-1.263137e-001,
	1.327775e+000,
	7.595887e-002,
	5.301229e+000,
	6.478109e-001,
	-1.158426e+000,
	-1.921879e-001,
	3.371987e-001,
	8.543727e-001,
	-1.195421e-001,
	2.178871e-001,
	1.573997e-001,
	3.059646e+000,
	5.355391e-001,
	-1.012076e+000,
	-1.456275e-001,
	3.857821e+000,
	-1.137640e+000,
	-7.400821e-001,
	4.132381e+000,
	-2.101470e-001,
	-1.704290e-001,
	1.094519e+000,
	-1.200085e+000,
	-9.008631e-002,
	-1.764929e+000,
	4.584027e-001,
	8.033799e-001,
	-1.730728e+000,
	5.892683e-001,
	6.438112e+000,
	2.141131e-001,
	-9.836248e-001,
	-1.983419e-001,
	3.519957e+000,
	-9.777763e-001,
	-5.727911e+000,
	4.397457e+000,
	-2.864495e-001,
	-2.511187e+000,
	9.881415e-001,
	-1.111842e+000,
	-1.992363e-001,
	1.746814e+000,
	5.036170e+000,
	-2.993753e+000,
	-5.348114e-001,
	2.332738e-001,
	8.970344e-001,
	5.806194e-001,
	// albedo 0, turbidity 3
	-1.120087e+000,
	-1.577355e-001,
	-1.165606e+000,
	1.782016e+000,
	-1.771264e-001,
	8.928578e-001,
	1.613110e-001,
	4.975693e+000,
	6.258796e-001,
	-1.182069e+000,
	-2.047357e-001,
	-4.041517e-001,
	1.732659e+000,
	-4.322749e-001,
	6.549554e-001,
	5.392767e-002,
	4.838218e+000,
	6.441461e-001,
	-1.071518e+000,
	-2.057500e-001,
	2.808685e+000,
	-1.990080e+000,
	-8.491815e-001,
	2.193915e+000,
	2.411077e-001,
	-3.251587e+000,
	7.470978e-001,
	-1.113379e+000,
	-6.708322e-003,
	-2.181109e+000,
	2.107674e+000,
	2.216970e+000,
	-6.233552e-001,
	3.558080e-001,
	9.251876e+000,
	6.319555e-001,
	-1.026698e+000,
	-2.260748e-001,
	3.031659e+000,
	-1.615765e+000,
	-1.323341e+000,
	2.835147e+000,
	1.186568e-001,
	-3.366247e+000,
	6.850407e-001,
	-1.088223e+000,
	-1.817555e-001,
	1.435855e+000,
	1.845164e+000,
	-3.488539e+000,
	2.554837e-001,
	2.144895e-001,
	1.558895e+000,
	7.315398e-001,
	// albedo 0, turbidity 4
	-1.164089e+000,
	-2.003003e-001,
	-2.998423e-001,
	2.713689e-001,
	-1.828861e-001,
	5.800779e-001,
	1.968402e-001,
	4.650130e+000,
	6.156174e-001,
	-1.209796e+000,
	-2.733887e-001,
	-9.360003e-001,
	2.769100e+000,
	-1.870929e+000,
	7.049322e-001,
	-8.477045e-002,
	4.120960e+000,
	7.444509e-001,
	-1.232839e+000,
	-2.622151e-001,
	2.857050e+000,
	-2.866256e+000,
	3.128232e+000,
	1.897877e+000,
	4.581244e-001,
	-2.112943e+000,
	6.384882e-001,
	-9.291113e-001,
	4.110508e-002,
	-2.235781e+000,
	2.969741e+000,
	-9.758544e+000,
	-1.941571e+000,
	3.426656e-001,
	6.907158e+000,
	6.945892e-001,
	-1.103614e+000,
	-2.279953e-001,
	2.314490e+000,
	-6.307971e-001,
	3.369674e+000,
	3.787928e+000,
	2.456513e-001,
	-1.776073e+000,
	6.864316e-001,
	-1.072160e+000,
	-1.984678e-001,
	1.092192e+000,
	8.472734e-001,
	-3.126637e+000,
	-1.076607e+000,
	3.908469e-001,
	1.205671e+000,
	7.035925e-001,
	// albedo 0, turbidity 5
	-1.222416e+000,
	-2.654298e-001,
	-1.149975e-001,
	-6.277756e-003,
	-1.369463e+000,
	4.402179e-001,
	1.881320e-001,
	3.896722e+000,
	6.037946e-001,
	-1.407746e+000,
	-4.603243e-001,
	-3.071475e-001,
	2.937390e+000,
	-9.164938e-001,
	6.696693e-001,
	-6.608327e-002,
	2.444782e+000,
	6.905594e-001,
	-1.120454e+000,
	-1.466269e-001,
	7.829076e-001,
	-7.009271e+000,
	5.364470e+000,
	1.294280e+000,
	4.109552e-001,
	1.525889e+000,
	7.709564e-001,
	-9.792886e-001,
	-4.325464e-002,
	-4.059461e-001,
	1.522559e+001,
	-1.867598e+001,
	-1.169367e+000,
	3.589556e-001,
	2.368951e+000,
	5.526839e-001,
	-1.091118e+000,
	-2.286983e-001,
	9.896666e-001,
	-6.655971e+000,
	8.168041e+000,
	1.923773e+000,
	3.116805e-001,
	1.852611e-001,
	7.524175e-001,
	-1.053081e+000,
	-1.598496e-001,
	9.684194e-001,
	3.620674e+000,
	-5.015769e+000,
	8.125082e-002,
	4.669502e-001,
	1.415221e+000,
	7.044272e-001,
	// albedo 0, turbidity 6
	-1.267172e+000,
	-3.101221e-001,
	-8.556526e-002,
	-3.602153e-003,
	-4.988229e+000,
	4.099753e-001,
	1.555248e-001,
	3.585489e+000,
	6.128833e-001,
	-1.613116e+000,
	-6.560485e-001,
	9.250270e-002,
	2.119268e+000,
	8.031058e+000,
	4.019483e-001,
	4.526662e-002,
	1.362051e+000,
	5.999628e-001,
	-1.012405e+000,
	-2.251592e-002,
	2.836289e-001,
	-7.904006e+000,
	-9.544755e+000,
	1.754891e+000,
	1.283266e-001,
	3.042478e+000,
	9.234755e-001,
	-1.022835e+000,
	-1.361070e-001,
	-4.207218e-001,
	1.947050e+001,
	-5.511234e+000,
	-2.417169e+000,
	7.837822e-001,
	8.288902e-001,
	3.509734e-001,
	-1.068370e+000,
	-1.806143e-001,
	1.059217e+000,
	7.087518e-001,
	-1.671865e+000,
	3.098645e+000,
	-9.859822e-002,
	9.336021e-001,
	8.929147e-001,
	-1.065467e+000,
	-1.928982e-001,
	6.159162e-001,
	-4.157538e-003,
	-9.397621e-001,
	-1.193139e+000,
	6.979501e-001,
	1.118894e+000,
	6.467115e-001,
	// albedo 0, turbidity 7
	-1.345697e+000,
	-3.906019e-001,
	-1.921159e-001,
	-7.410201e-003,
	-4.683006e+000,
	4.591917e-001,
	1.919817e-001,
	3.158844e+000,
	5.319014e-001,
	-2.096314e+000,
	-1.056514e+000,
	7.665515e-001,
	1.602483e+000,
	6.290779e+000,
	4.693208e-001,
	-6.258855e-002,
	-3.745685e-001,
	5.853677e-001,
	-7.573573e-001,
	2.265213e-001,
	-1.283398e+000,
	-4.696984e+000,
	-4.261986e+000,
	1.197826e+000,
	3.444468e-001,
	6.004387e+000,
	9.413954e-001,
	-1.140929e+000,
	-3.489820e-001,
	1.095429e+000,
	7.531589e+000,
	-8.153320e+000,
	-1.722207e+000,
	4.427477e-001,
	-3.072440e+000,
	3.874398e-001,
	-1.009003e+000,
	-9.087616e-002,
	4.181128e-002,
	1.154023e+001,
	-5.092155e-001,
	2.166116e+000,
	1.620893e-001,
	2.824826e+000,
	8.289491e-001,
	-1.080842e+000,
	-2.166745e-001,
	6.939662e-001,
	-2.316636e-003,
	-2.616711e+000,
	-1.012238e+000,
	6.132021e-001,
	7.579828e-001,
	6.813755e-001,
	// albedo 0, turbidity 8
	-1.394668e+000,
	-4.508268e-001,
	-2.615024e-001,
	-7.412740e-003,
	-4.811648e+000,
	4.235635e-001,
	1.627041e-001,
	3.134174e+000,
	5.225016e-001,
	-2.715734e+000,
	-1.409574e+000,
	6.485110e-001,
	6.307101e-001,
	8.120123e+000,
	3.677567e-001,
	6.430919e-002,
	-3.729191e-001,
	3.463130e-001,
	-8.973624e-001,
	2.859206e-002,
	-1.610007e+000,
	-1.483136e+000,
	-5.613288e+000,
	7.093329e-001,
	2.936945e-001,
	5.541210e+000,
	1.143952e+000,
	-8.450858e-001,
	-1.969825e-001,
	1.399585e+000,
	1.418708e-001,
	-4.532026e+000,
	-7.432040e-001,
	3.410858e-001,
	-3.386293e+000,
	2.885614e-001,
	-1.180533e+000,
	-2.469972e-001,
	-2.694505e-002,
	1.635998e+001,
	-2.378676e+000,
	9.477733e-001,
	1.105776e-001,
	1.954485e+000,
	8.559872e-001,
	-1.022908e+000,
	-1.650807e-001,
	3.812483e-001,
	-2.139201e-003,
	-2.300711e+000,
	-5.917998e-001,
	6.793527e-001,
	1.248273e+000,
	6.747565e-001,
	// albedo 0, turbidity 9
	-1.557922e+000,
	-6.294681e-001,
	-2.355549e-001,
	-8.743568e-003,
	-5.017111e+000,
	4.034446e-001,
	1.005643e-001,
	2.735289e+000,
	5.667004e-001,
	-3.061673e+000,
	-1.398157e+000,
	1.597008e-001,
	1.066059e+000,
	8.207018e+000,
	4.785780e-001,
	4.629487e-002,
	1.324020e+000,
	2.540204e-001,
	-2.371583e+000,
	-1.100187e+000,
	-1.279309e+000,
	-3.340819e+000,
	-6.556706e+000,
	2.636750e-001,
	4.298705e-001,
	2.649782e+000,
	1.060950e+000,
	-5.315727e-002,
	2.306821e-001,
	1.091037e+000,
	5.297610e+000,
	-2.412315e+000,
	-7.083157e-002,
	7.256586e-002,
	-1.330891e+000,
	4.168205e-001,
	-1.375983e+000,
	-4.677570e-001,
	2.271650e-001,
	8.771601e+000,
	-2.511780e+000,
	1.487082e-001,
	8.542210e-002,
	5.509707e-003,
	7.821447e-001,
	-1.006483e+000,
	-1.435513e-001,
	5.802646e-002,
	-3.181899e-003,
	-2.010861e+000,
	-1.746922e-001,
	7.487809e-001,
	1.623209e+000,
	6.848148e-001,
	// albedo 0, turbidity 10
	-1.919035e+000,
	-9.396362e-001,
	-3.059418e-001,
	1.542398e+000,
	-1.488273e+000,
	5.133825e-001,
	-7.992185e-006,
	2.276361e+000,
	8.334381e-001,
	-2.470138e+000,
	-1.108577e+000,
	-5.521438e-001,
	-9.047033e-001,
	6.905739e-001,
	3.774300e-001,
	-2.801883e-002,
	2.413470e+000,
	-8.986266e-002,
	-5.532450e+000,
	-2.346497e+000,
	-1.734654e+000,
	1.461689e+000,
	1.765938e+000,
	4.969811e-001,
	6.205943e-001,
	2.112232e+000,
	1.159488e+000,
	4.159150e-001,
	-2.306809e-001,
	1.540502e+000,
	-1.006923e+000,
	-5.275092e+000,
	-2.776202e-002,
	-1.632884e-001,
	-1.467491e+000,
	4.177919e-001,
	-1.248112e+000,
	-3.080519e-001,
	-1.229235e-001,
	8.972757e+000,
	-1.532948e+000,
	-8.283794e-002,
	1.561573e-001,
	1.856113e-001,
	7.696948e-001,
	-1.054499e+000,
	-2.660558e-001,
	1.307025e-001,
	-2.167883e-003,
	-1.531056e+000,
	1.525856e-001,
	5.356892e-001,
	7.181428e-001,
	6.837654e-001,
	// albedo 1, turbidity 1
	-1.113347e+000,
	-1.715068e-001,
	-2.657094e+000,
	4.632520e+000,
	-1.092308e-001,
	1.421516e+000,
	3.229759e-003,
	2.697889e+000,
	6.262031e-001,
	-1.193355e+000,
	-2.074367e-001,
	1.431777e+000,
	8.245569e-001,
	-1.936966e-001,
	9.392136e-001,
	1.972263e-002,
	3.001209e+000,
	4.415825e-001,
	-9.337795e-001,
	-2.037221e-001,
	3.943675e+000,
	-2.487730e+000,
	-9.876315e-001,
	2.772410e+000,
	-4.919872e-002,
	-4.176827e+000,
	1.026227e+000,
	-1.297624e+000,
	-1.296733e-001,
	-3.144502e-001,
	2.454199e+000,
	2.433614e+000,
	5.298925e-001,
	7.814503e-002,
	6.564581e+000,
	5.587597e-001,
	-9.325285e-001,
	-1.997939e-001,
	3.363316e+000,
	-1.887198e+000,
	-8.905212e+000,
	2.808596e+000,
	-9.537523e-002,
	-3.059702e+000,
	5.403717e-001,
	-1.125653e+000,
	-1.904767e-001,
	2.099998e+000,
	1.251930e+000,
	-1.899312e+000,
	5.255917e-001,
	9.848033e-002,
	9.627434e-001,
	6.251233e-001,
	// albedo 1, turbidity 2
	-1.115892e+000,
	-1.571450e-001,
	-5.361081e+000,
	6.833528e+000,
	-6.891479e-002,
	1.309709e+000,
	6.046362e-002,
	3.972373e+000,
	6.651606e-001,
	-1.147479e+000,
	-1.855896e-001,
	2.239259e+000,
	-5.937930e-001,
	-1.005125e-001,
	2.773971e-001,
	1.337105e-001,
	3.136906e+000,
	5.194230e-001,
	-1.030450e+000,
	-1.533626e-001,
	2.268967e+000,
	-4.886576e-001,
	-6.336865e-001,
	3.911080e+000,
	-1.602643e-001,
	1.513730e-001,
	1.130153e+000,
	-1.159297e+000,
	-5.818314e-002,
	-1.488690e-001,
	1.358829e+000,
	1.208889e+000,
	-1.827456e+000,
	4.867277e-001,
	6.185880e+000,
	1.951064e-001,
	-1.023581e+000,
	-2.517540e-001,
	3.635148e+000,
	-2.375150e+000,
	-9.409992e+000,
	3.209554e+000,
	-3.006489e-001,
	-3.235953e+000,
	9.969505e-001,
	-1.102864e+000,
	-1.644399e-001,
	2.160645e+000,
	5.685422e+000,
	-2.867248e+000,
	-1.020916e+000,
	2.064591e-001,
	1.192668e+000,
	5.029621e-001,
	// albedo 1, turbidity 3
	-1.120417e+000,
	-1.543428e-001,
	-2.173869e+000,
	2.965267e+000,
	-1.062190e-001,
	8.112859e-001,
	1.448682e-001,
	4.993622e+000,
	6.373394e-001,
	-1.168618e+000,
	-1.948508e-001,
	-6.247560e-001,
	2.203402e+000,
	-2.724794e-001,
	8.364691e-001,
	5.608377e-002,
	4.262497e+000,
	6.310098e-001,
	-1.080229e+000,
	-2.282841e-001,
	2.194035e+000,
	-1.203336e+000,
	-3.861545e-001,
	2.234045e+000,
	1.553866e-001,
	-3.266039e+000,
	8.246847e-001,
	-1.101698e+000,
	2.182410e-002,
	-1.179116e+000,
	8.533844e-001,
	8.777171e-001,
	-1.222988e+000,
	5.021882e-001,
	9.364642e+000,
	4.790363e-001,
	-1.047144e+000,
	-2.539571e-001,
	3.684827e+000,
	9.827861e-002,
	-2.297266e-001,
	3.038327e+000,
	-2.609445e-001,
	-3.685112e+000,
	8.596057e-001,
	-1.103227e+000,
	-1.861499e-001,
	2.098952e+000,
	1.030900e-001,
	-4.268311e+000,
	-1.120060e+000,
	2.879792e-001,
	7.160893e-001,
	6.213207e-001,
	// albedo 1, turbidity 4
	-1.155288e+000,
	-2.006105e-001,
	-5.822630e-002,
	3.970794e-001,
	-2.828885e-001,
	5.093569e-001,
	1.631119e-001,
	4.152479e+000,
	6.357376e-001,
	-1.241627e+000,
	-2.673712e-001,
	-6.444494e-001,
	2.257014e+000,
	-1.630843e+000,
	5.967071e-001,
	9.888683e-003,
	4.308732e+000,
	6.751366e-001,
	-1.136812e+000,
	-2.811418e-001,
	2.220215e+000,
	-1.535870e+000,
	2.354743e+000,
	2.041362e+000,
	2.387976e-001,
	-3.453756e+000,
	7.672245e-001,
	-1.028322e+000,
	9.134962e-002,
	-1.151053e+000,
	6.511620e-001,
	-5.683098e+000,
	-2.001006e+000,
	6.430642e-001,
	8.523367e+000,
	5.422240e-001,
	-1.076830e+000,
	-3.101207e-001,
	3.052794e+000,
	3.177593e-001,
	3.054756e+000,
	3.386727e+000,
	-2.312489e-001,
	-3.908802e+000,
	7.978614e-001,
	-1.107083e+000,
	-1.880372e-001,
	2.001810e+000,
	-3.352202e-003,
	-1.526356e+000,
	-1.480550e+000,
	3.486524e-001,
	7.220325e-001,
	6.581821e-001,
	// albedo 1, turbidity 5
	-1.214879e+000,
	-2.719222e-001,
	2.247747e-001,
	1.509740e-002,
	-5.438281e-001,
	3.728351e-001,
	1.749880e-001,
	3.132220e+000,
	6.001432e-001,
	-1.424202e+000,
	-4.768943e-001,
	-6.396040e-001,
	2.060101e+000,
	-1.113780e+000,
	6.993089e-001,
	-2.098291e-002,
	2.504826e+000,
	6.757213e-001,
	-1.048548e+000,
	-1.173837e-001,
	1.885902e+000,
	-3.700301e+000,
	4.667326e+000,
	1.344798e+000,
	2.140261e-001,
	1.525414e-001,
	8.450168e-001,
	-1.056271e+000,
	-5.272364e-002,
	-1.391708e+000,
	9.711492e+000,
	-1.742761e+001,
	-1.677628e+000,
	6.906304e-001,
	4.107662e+000,
	4.268005e-001,
	-1.072328e+000,
	-2.450563e-001,
	3.125155e+000,
	-2.470389e+000,
	6.794968e+000,
	2.678049e+000,
	-2.092059e-001,
	-1.651858e+000,
	8.708740e-001,
	-1.107628e+000,
	-2.089585e-001,
	1.799168e+000,
	4.621596e-001,
	-5.008181e+000,
	-1.121127e+000,
	3.917217e-001,
	2.703209e-001,
	6.449597e-001,
	// albedo 1, turbidity 6
	-1.249741e+000,
	-3.073987e-001,
	1.398829e-001,
	-2.878563e-003,
	-5.008845e+000,
	4.535605e-001,
	1.447766e-001,
	3.091173e+000,
	6.138128e-001,
	-1.577209e+000,
	-6.213162e-001,
	2.895282e-001,
	1.670732e+000,
	8.708786e+000,
	2.480283e-001,
	7.326386e-002,
	1.395638e+000,
	5.814691e-001,
	-1.015394e+000,
	-9.306378e-002,
	4.870291e-001,
	-6.558243e+000,
	-1.073347e+001,
	1.842159e+000,
	2.135043e-002,
	1.655269e+000,
	9.750505e-001,
	-1.030222e+000,
	-3.712071e-002,
	-4.565649e-001,
	1.827249e+001,
	-4.505703e+000,
	-2.635230e+000,
	9.447498e-001,
	2.450865e+000,
	2.757082e-001,
	-1.086063e+000,
	-2.709359e-001,
	2.527868e+000,
	-1.786375e+000,
	-2.329338e+000,
	3.367729e+000,
	-4.201670e-001,
	-9.372873e-001,
	9.570917e-001,
	-1.113156e+000,
	-2.162986e-001,
	1.815038e+000,
	1.036606e-001,
	-1.106537e+000,
	-1.657558e+000,
	4.923976e-001,
	-1.768985e-002,
	6.218745e-001,
	// albedo 1, turbidity 7
	-1.345662e+000,
	-4.038158e-001,
	1.601105e-001,
	-6.892546e-003,
	-5.010308e+000,
	3.903794e-001,
	1.543535e-001,
	2.538245e+000,
	5.555141e-001,
	-1.998866e+000,
	-9.786972e-001,
	5.763250e-001,
	1.007104e+000,
	8.983795e+000,
	3.752110e-001,
	7.375525e-002,
	1.792659e-001,
	4.969463e-001,
	-7.854213e-001,
	1.186171e-001,
	-1.925047e-001,
	-3.567464e+000,
	-8.901606e+000,
	1.181923e+000,
	4.049067e-002,
	3.603602e+000,
	1.081550e+000,
	-1.113558e+000,
	-1.964692e-001,
	-6.175963e-002,
	7.345047e+000,
	-5.293662e+000,
	-1.720046e+000,
	8.863695e-001,
	-1.699694e-001,
	2.184709e-001,
	-1.077319e+000,
	-2.429937e-001,
	2.226652e+000,
	8.082352e+000,
	-5.647382e-001,
	2.187018e+000,
	-3.571678e-001,
	-2.370890e-001,
	9.528157e-001,
	-1.101702e+000,
	-2.020333e-001,
	1.637670e+000,
	5.276716e-001,
	-4.006007e+000,
	-1.066501e+000,
	4.548015e-001,
	4.055769e-001,
	6.485706e-001,
	// albedo 1, turbidity 8
	-1.411469e+000,
	-4.870956e-001,
	1.017578e-001,
	-8.806763e-003,
	-5.014847e+000,
	4.306981e-001,
	1.278033e-001,
	2.361142e+000,
	5.472925e-001,
	-2.735007e+000,
	-1.453253e+000,
	5.783189e-001,
	5.673243e-001,
	9.968637e+000,
	2.236397e-001,
	1.860109e-001,
	-3.781953e-001,
	2.505082e-001,
	-7.371503e-001,
	1.290592e-001,
	-5.349577e-001,
	-1.885854e+000,
	-8.623054e+000,
	1.078614e+000,
	-5.694996e-002,
	4.526279e+000,
	1.347569e+000,
	-9.678370e-001,
	-2.562830e-001,
	2.961987e-001,
	2.461144e+000,
	-4.753928e+000,
	-1.657373e+000,
	8.388825e-001,
	-2.440974e+000,
	1.816225e-002,
	-1.148918e+000,
	-2.271366e-001,
	1.817890e+000,
	1.097345e+001,
	-1.126160e+000,
	1.993895e+000,
	-2.870862e-001,
	7.269217e-001,
	1.032783e+000,
	-1.090291e+000,
	-2.315314e-001,
	1.491197e+000,
	9.632479e+000,
	-4.323932e+000,
	-1.326631e+000,
	3.604933e-001,
	1.905995e-001,
	6.312241e-001,
	// albedo 1, turbidity 9
	-1.552618e+000,
	-6.336918e-001,
	4.605315e-002,
	-8.452985e-003,
	-4.979015e+000,
	3.484674e-001,
	8.791637e-002,
	2.297399e+000,
	5.705230e-001,
	-2.770597e+000,
	-1.302036e+000,
	3.421676e-001,
	1.220769e+000,
	7.584372e+000,
	4.050789e-001,
	4.478808e-002,
	9.435710e-001,
	2.393878e-001,
	-2.631791e+000,
	-1.247576e+000,
	-8.423940e-001,
	-3.955998e+000,
	-5.341100e+000,
	6.385142e-001,
	3.872948e-001,
	2.279807e+000,
	1.101259e+000,
	1.875824e-001,
	3.564184e-001,
	7.973268e-001,
	7.159160e+000,
	-3.857340e+000,
	-9.227702e-001,
	8.283793e-002,
	-1.444145e+000,
	3.654244e-001,
	-1.489693e+000,
	-4.947623e-001,
	1.253918e+000,
	3.949282e+000,
	-1.320903e+000,
	1.088652e+000,
	1.489763e-001,
	-3.855853e-001,
	8.130960e-001,
	-1.042349e+000,
	-2.134514e-001,
	1.289359e+000,
	-3.129206e-003,
	-2.385397e+000,
	-7.642278e-001,
	3.772293e-001,
	3.683001e-001,
	6.811674e-001,
	// albedo 1, turbidity 10
	-1.924886e+000,
	-9.354584e-001,
	-1.879067e-001,
	1.267892e+000,
	-1.174622e+000,
	5.570232e-001,
	-1.060836e-005,
	2.002481e+000,
	9.001398e-001,
	-1.556107e+000,
	-8.200410e-001,
	-1.065249e-001,
	-3.241942e-001,
	1.552504e-001,
	7.662815e-002,
	-2.568474e-002,
	1.738474e+000,
	-2.100942e-001,
	-7.169297e+000,
	-2.972878e+000,
	-1.324108e+000,
	7.276378e-003,
	2.638975e+000,
	1.186150e+000,
	5.695709e-001,
	2.027718e+000,
	1.328077e+000,
	1.889259e+000,
	2.600110e-001,
	1.309033e+000,
	1.187864e+000,
	-6.905754e+000,
	-1.163025e+000,
	-1.642758e-001,
	-1.774036e+000,
	2.566466e-001,
	-1.816439e+000,
	-3.601966e-001,
	6.367922e-001,
	6.798160e+000,
	-6.431562e-001,
	9.014269e-001,
	2.490693e-001,
	-6.685128e-003,
	8.542883e-001,
	-9.684886e-001,
	-3.866519e-001,
	1.268224e+000,
	-4.187273e-003,
	-1.833316e+000,
	-4.626197e-001,
	2.263859e-001,
	-5.583963e-001,
	6.650112e-001,
};

double datasetRad640[] = 
{
	// albedo 0, turbidity 1
	1.479989e-002,
	9.575884e-003,
	2.973854e-002,
	4.822245e-002,
	3.622965e-002,
	3.714381e-002,
	// albedo 0, turbidity 2
	1.494233e-002,
	1.021187e-002,
	2.574697e-002,
	7.232352e-002,
	3.290719e-002,
	4.167409e-002,
	// albedo 0, turbidity 3
	1.434641e-002,
	1.147574e-002,
	1.506677e-002,
	1.142492e-001,
	2.532042e-002,
	4.995278e-002,
	// albedo 0, turbidity 4
	1.326292e-002,
	1.444403e-002,
	-7.612369e-003,
	1.768500e-001,
	1.846871e-002,
	6.093428e-002,
	// albedo 0, turbidity 5
	1.210064e-002,
	1.800376e-002,
	-3.160469e-002,
	2.285807e-001,
	2.227077e-002,
	6.824549e-002,
	// albedo 0, turbidity 6
	1.130890e-002,
	2.150486e-002,
	-5.124749e-002,
	2.648020e-001,
	2.123060e-002,
	7.588774e-002,
	// albedo 0, turbidity 7
	1.023130e-002,
	2.633945e-002,
	-7.626006e-002,
	3.042057e-001,
	3.007536e-002,
	8.597681e-002,
	// albedo 0, turbidity 8
	8.913856e-003,
	3.088076e-002,
	-9.896179e-002,
	3.274618e-001,
	6.060024e-002,
	9.959796e-002,
	// albedo 0, turbidity 9
	7.548425e-003,
	3.088764e-002,
	-9.837988e-002,
	2.862874e-001,
	1.450480e-001,
	1.121877e-001,
	// albedo 0, turbidity 10
	6.525594e-003,
	2.429771e-002,
	-6.656565e-002,
	1.679199e-001,
	2.792664e-001,
	1.313366e-001,
	// albedo 1, turbidity 1
	1.534297e-002,
	1.199131e-002,
	2.491229e-002,
	5.492441e-002,
	7.679650e-002,
	9.300994e-002,
	// albedo 1, turbidity 2
	1.542409e-002,
	1.237811e-002,
	2.235351e-002,
	7.606092e-002,
	7.888526e-002,
	9.886009e-002,
	// albedo 1, turbidity 3
	1.501351e-002,
	1.379279e-002,
	1.162514e-002,
	1.159528e-001,
	7.784537e-002,
	1.097624e-001,
	// albedo 1, turbidity 4
	1.398757e-002,
	1.622679e-002,
	-9.033929e-003,
	1.740587e-001,
	8.042195e-002,
	1.246928e-001,
	// albedo 1, turbidity 5
	1.276036e-002,
	2.055104e-002,
	-3.597123e-002,
	2.310287e-001,
	8.109251e-002,
	1.421324e-001,
	// albedo 1, turbidity 6
	1.198617e-002,
	2.326685e-002,
	-5.243143e-002,
	2.599544e-001,
	8.840775e-002,
	1.517899e-001,
	// albedo 1, turbidity 7
	1.092344e-002,
	2.669375e-002,
	-7.074274e-002,
	2.830300e-001,
	1.143047e-001,
	1.610563e-001,
	// albedo 1, turbidity 8
	9.699402e-003,
	2.953350e-002,
	-8.582613e-002,
	2.867195e-001,
	1.638123e-001,
	1.760228e-001,
	// albedo 1, turbidity 9
	8.432894e-003,
	2.784449e-002,
	-7.740437e-002,
	2.250221e-001,
	2.667103e-001,
	1.889583e-001,
	// albedo 1, turbidity 10
	7.395069e-003,
	2.031820e-002,
	-4.154554e-002,
	9.577204e-002,
	4.084819e-001,
	2.043633e-001,
};

double dataset680[] = 
{
	// albedo 0, turbidity 1
	-1.112655e+000,
	-1.844098e-001,
	-3.170582e+000,
	5.334685e+000,
	-6.690891e-002,
	1.561122e+000,
	-2.792088e-006,
	1.400688e+000,
	6.639418e-001,
	-1.138469e+000,
	-1.797086e-001,
	1.271179e+000,
	1.158372e+000,
	-1.687824e-001,
	1.414051e+000,
	4.258569e-003,
	2.135675e+000,
	5.322718e-001,
	-1.026337e+000,
	-1.861539e-001,
	2.119648e+000,
	-6.753200e-001,
	-1.972700e-001,
	2.384659e+000,
	-1.304972e-002,
	-1.804518e+000,
	1.207802e+000,
	-1.198321e+000,
	-1.585305e-001,
	1.339219e+000,
	5.796904e-001,
	-5.143433e-002,
	1.107455e+000,
	2.551349e-002,
	3.346946e+000,
	-3.387602e-002,
	-9.935091e-001,
	-1.747698e-001,
	2.816779e+000,
	-3.496148e-001,
	1.832218e+000,
	2.324658e+000,
	-3.408305e-002,
	-1.618451e+000,
	1.189512e+000,
	-1.092682e+000,
	-1.840784e-001,
	2.455887e+000,
	1.441429e-001,
	-4.002347e+000,
	1.186375e+000,
	3.634755e-002,
	3.070963e-001,
	5.512501e-001,
	// albedo 0, turbidity 2
	-1.104975e+000,
	-1.425541e-001,
	-1.889148e+000,
	3.408593e+000,
	-1.252648e-001,
	1.396095e+000,
	8.358812e-002,
	3.814297e+000,
	6.848154e-001,
	-1.131570e+000,
	-1.500053e-001,
	-1.048539e+000,
	3.133642e+000,
	-2.651219e-001,
	1.193999e+000,
	7.013543e-002,
	4.592749e+000,
	6.857750e-001,
	-1.030016e+000,
	-1.667752e-001,
	6.179600e+000,
	-5.163198e+000,
	-4.084328e-001,
	2.617798e+000,
	1.966627e-003,
	-2.417731e+000,
	8.402310e-001,
	-1.167563e+000,
	-3.644294e-002,
	-4.501893e+000,
	4.471663e+000,
	-5.377956e-001,
	4.971351e-002,
	4.621337e-001,
	1.014187e+001,
	4.411276e-001,
	-1.018402e+000,
	-2.068288e-001,
	4.710566e+000,
	-1.425858e+000,
	1.287815e-001,
	3.605281e+000,
	-2.164599e-001,
	-4.336932e+000,
	9.051639e-001,
	-1.078985e+000,
	-1.995548e-001,
	1.678948e+000,
	3.074167e-001,
	-1.642830e+000,
	-1.235470e-001,
	2.735898e-001,
	6.360197e-001,
	5.870665e-001,
	// albedo 0, turbidity 3
	-1.132881e+000,
	-1.676238e-001,
	-1.179974e+000,
	1.902080e+000,
	-7.980402e-002,
	8.946611e-001,
	1.939671e-001,
	3.793414e+000,
	6.357246e-001,
	-1.138356e+000,
	-1.681053e-001,
	1.548320e+000,
	-6.001024e-001,
	-4.138892e-001,
	2.586807e-001,
	2.126762e-001,
	4.742849e+000,
	5.910253e-001,
	-1.093982e+000,
	-1.847904e-001,
	1.234133e+000,
	-4.707125e-001,
	1.076579e+000,
	3.355751e+000,
	5.394600e-002,
	-2.314910e+000,
	8.900752e-001,
	-1.117812e+000,
	-6.182272e-002,
	-4.681118e-001,
	5.075227e+000,
	-1.561122e+001,
	-2.343845e+000,
	5.618788e-001,
	7.005713e+000,
	4.622191e-001,
	-1.013135e+000,
	-1.529086e-001,
	1.960772e+000,
	-3.022528e+000,
	8.938126e+000,
	4.411437e+000,
	3.156643e-002,
	-1.449180e+000,
	8.181914e-001,
	-1.087086e+000,
	-2.231900e-001,
	1.871061e+000,
	1.830836e+000,
	-4.397140e+000,
	-5.441402e-001,
	2.728682e-001,
	-5.607736e-002,
	6.741811e-001,
	// albedo 0, turbidity 4
	-1.176035e+000,
	-2.099056e-001,
	-8.221907e-001,
	1.520994e+000,
	-2.507738e-001,
	9.100863e-001,
	1.507234e-001,
	3.661138e+000,
	6.726424e-001,
	-1.140180e+000,
	-1.918480e-001,
	2.844393e-001,
	-3.842927e-001,
	-5.520764e-001,
	-1.868484e-001,
	2.247948e-001,
	5.381202e+000,
	6.059726e-001,
	-1.282085e+000,
	-3.059464e-001,
	1.619956e+000,
	-1.362117e+000,
	2.324649e+000,
	3.350678e+000,
	2.102082e-001,
	-4.028753e+000,
	8.172091e-001,
	-9.092985e-001,
	4.843416e-002,
	-1.076741e+000,
	8.143038e+000,
	-1.618418e+001,
	-3.681285e+000,
	5.217800e-001,
	7.307672e+000,
	5.312006e-001,
	-1.110248e+000,
	-2.047143e-001,
	1.565253e+000,
	-4.575474e+000,
	8.737741e+000,
	5.023419e+000,
	2.469230e-001,
	-1.716906e+000,
	7.856742e-001,
	-1.054900e+000,
	-2.018466e-001,
	1.352034e+000,
	2.656066e+000,
	-4.403444e+000,
	-1.479998e+000,
	3.939305e-001,
	6.455032e-001,
	6.775162e-001,
	// albedo 0, turbidity 5
	-1.237521e+000,
	-2.734963e-001,
	-4.554763e-001,
	3.417711e-001,
	2.054204e-001,
	3.954470e-001,
	2.366979e-001,
	3.239693e+000,
	6.083737e-001,
	-1.354583e+000,
	-4.251172e-001,
	-3.241668e-001,
	2.077967e+000,
	-1.910410e+000,
	8.755633e-001,
	-8.365829e-002,
	2.443727e+000,
	7.260119e-001,
	-1.152500e+000,
	-1.277879e-001,
	1.089367e+000,
	-4.497520e+000,
	5.636501e+000,
	1.249272e+000,
	5.829396e-001,
	9.198423e-001,
	7.039872e-001,
	-9.782313e-001,
	-8.253891e-002,
	-5.673470e-001,
	1.098032e+001,
	-1.689550e+001,
	-1.619205e+000,
	2.125660e-001,
	2.080566e+000,
	6.315535e-001,
	-1.064286e+000,
	-1.710957e-001,
	9.336921e-001,
	-5.525059e+000,
	8.053084e+000,
	2.664602e+000,
	4.815015e-001,
	4.884965e-001,
	7.093015e-001,
	-1.067798e+000,
	-1.817268e-001,
	1.095720e+000,
	3.551145e+000,
	-5.009504e+000,
	-4.802047e-001,
	4.854159e-001,
	8.021585e-001,
	7.133339e-001,
	// albedo 0, turbidity 6
	-1.251896e+000,
	-2.936510e-001,
	-3.090944e-002,
	-5.488869e-003,
	-6.577788e-001,
	4.577691e-001,
	1.780002e-001,
	3.335561e+000,
	6.394482e-001,
	-1.615603e+000,
	-6.405318e-001,
	-4.651954e-001,
	2.332689e+000,
	-1.893131e-001,
	3.391170e-001,
	3.495888e-002,
	1.058634e+000,
	6.310524e-001,
	-9.703572e-001,
	1.437971e-002,
	6.532383e-001,
	-6.450045e+000,
	4.026380e+000,
	2.198628e+000,
	2.684967e-001,
	2.873804e+000,
	8.626816e-001,
	-1.053437e+000,
	-1.577255e-001,
	-2.354526e-001,
	1.753047e+001,
	-1.802766e+001,
	-3.193379e+000,
	6.264380e-001,
	3.733714e-001,
	4.466776e-001,
	-1.051388e+000,
	-1.690749e-001,
	6.925698e-001,
	-7.450365e+000,
	7.747780e+000,
	3.681960e+000,
	1.688173e-001,
	9.054528e-001,
	8.229209e-001,
	-1.060369e+000,
	-1.751603e-001,
	8.678290e-001,
	5.136962e+000,
	-5.014566e+000,
	-1.283438e+000,
	6.547844e-001,
	9.420523e-001,
	6.738511e-001,
	// albedo 0, turbidity 7
	-1.358251e+000,
	-3.909003e-001,
	-7.590093e-002,
	-8.010253e-003,
	-2.417641e-001,
	5.031789e-001,
	1.882499e-001,
	2.807060e+000,
	5.884485e-001,
	-2.043506e+000,
	-9.923881e-001,
	-4.530797e-001,
	1.750575e+000,
	-4.362236e-001,
	2.997323e-001,
	2.328504e-002,
	1.626543e-001,
	5.806819e-001,
	-7.280672e-001,
	2.228069e-001,
	2.169765e-001,
	-3.681736e+000,
	4.308793e+000,
	1.308622e+000,
	3.451835e-001,
	4.037459e+000,
	9.113772e-001,
	-1.155299e+000,
	-3.079453e-001,
	-1.640569e-001,
	7.663297e+000,
	-1.327817e+001,
	-1.431157e+000,
	4.096359e-001,
	-9.185502e-001,
	4.578034e-001,
	-1.006427e+000,
	-1.250087e-001,
	7.477012e-001,
	2.612704e+000,
	2.531799e+000,
	1.565371e+000,
	3.452604e-001,
	9.129266e-001,
	7.684386e-001,
	-1.068759e+000,
	-1.729191e-001,
	5.265652e-001,
	7.074812e+000,
	-4.259958e+000,
	-4.833255e-001,
	6.043380e-001,
	1.489203e+000,
	7.089074e-001,
	// albedo 0, turbidity 8
	-1.398983e+000,
	-4.500153e-001,
	-5.189309e-001,
	1.546325e-001,
	4.187327e-001,
	2.811516e-001,
	2.379667e-001,
	2.801040e+000,
	5.198375e-001,
	-2.970455e+000,
	-1.529948e+000,
	1.094532e-001,
	7.382263e-001,
	-1.024683e+000,
	2.074091e-001,
	1.397605e-001,
	-6.743828e-001,
	3.496944e-001,
	-3.942086e-001,
	3.424842e-001,
	-1.253259e+000,
	-9.268654e-001,
	5.636065e+000,
	8.224289e-001,
	2.452235e-001,
	5.864258e+000,
	1.202820e+000,
	-1.181174e+000,
	-4.197175e-001,
	1.429102e+000,
	-7.894317e-003,
	-1.239152e+001,
	-5.753431e-001,
	3.552180e-001,
	-4.495555e+000,
	2.141883e-001,
	-1.060281e+000,
	-1.080598e-001,
	-3.276480e-001,
	1.369250e+001,
	1.504389e+000,
	6.401191e-001,
	2.437501e-001,
	3.212918e+000,
	9.172133e-001,
	-1.037564e+000,
	-2.018083e-001,
	6.250668e-001,
	-2.525843e-003,
	-3.269998e+000,
	-2.649814e-001,
	6.600589e-001,
	3.337508e-001,
	6.516131e-001,
	// albedo 0, turbidity 9
	-1.610481e+000,
	-6.353902e-001,
	-5.968977e-001,
	1.414037e+000,
	-7.941453e-001,
	7.888684e-001,
	2.209045e-002,
	2.615106e+000,
	6.870260e-001,
	-3.073343e+000,
	-1.365905e+000,
	-2.651943e-001,
	-1.685310e+000,
	4.755874e-001,
	-1.110669e-001,
	2.561961e-001,
	1.222045e+000,
	3.362780e-002,
	-2.207768e+000,
	-1.009608e+000,
	-1.329601e+000,
	3.393091e+000,
	3.419104e+000,
	-4.733375e-002,
	5.989185e-001,
	2.814641e+000,
	1.245189e+000,
	-1.981173e-002,
	2.018414e-001,
	1.457765e+000,
	-6.316169e+000,
	-6.640569e+000,
	7.150646e-001,
	-2.993748e-001,
	-2.703376e+000,
	3.218596e-001,
	-1.435873e+000,
	-3.390505e-001,
	-3.859047e-001,
	1.457464e+001,
	-1.121591e+000,
	-6.089868e-002,
	5.319220e-001,
	1.852395e+000,
	8.379521e-001,
	-9.812568e-001,
	-2.273751e-001,
	5.108069e-001,
	-3.735693e-003,
	-2.547988e+000,
	-4.492561e-001,
	5.069199e-001,
	2.977910e-001,
	6.639273e-001,
	// albedo 0, turbidity 10
	-2.056405e+000,
	-9.703512e-001,
	-3.731953e-001,
	2.052022e+000,
	-1.445283e+000,
	6.103743e-001,
	-9.389644e-006,
	2.198652e+000,
	8.567335e-001,
	-2.105651e+000,
	-8.924283e-001,
	-6.868702e-001,
	-1.665838e+000,
	4.795702e-001,
	5.228080e-001,
	-4.272483e-002,
	2.661317e+000,
	-1.154062e-001,
	-6.179767e+000,
	-2.651580e+000,
	-1.527652e+000,
	2.692054e+000,
	2.293427e+000,
	-1.005611e-001,
	9.545323e-001,
	1.367438e+000,
	1.169193e+000,
	1.240848e+000,
	1.126706e-001,
	1.620422e+000,
	-3.384604e+000,
	-5.545532e+000,
	4.928203e-001,
	-5.999585e-001,
	-1.407078e+000,
	4.193816e-001,
	-1.539149e+000,
	-2.081890e-001,
	-4.552234e-001,
	1.056410e+001,
	-1.048637e+000,
	-2.780921e-001,
	5.682296e-001,
	6.785092e-001,
	7.729892e-001,
	-1.036841e+000,
	-4.359099e-001,
	4.767834e-001,
	-3.794262e-003,
	-1.980492e+000,
	9.954067e-002,
	3.037557e-001,
	2.156592e-002,
	6.845201e-001,
	// albedo 1, turbidity 1
	-1.110980e+000,
	-1.799491e-001,
	-3.168600e+000,
	5.336662e+000,
	-6.318131e-002,
	1.559251e+000,
	3.204341e-003,
	1.401140e+000,
	6.638144e-001,
	-1.132332e+000,
	-1.786787e-001,
	1.272954e+000,
	1.160211e+000,
	-1.685885e-001,
	1.409550e+000,
	7.140682e-003,
	2.136473e+000,
	5.320908e-001,
	-1.015776e+000,
	-1.825058e-001,
	2.122848e+000,
	-6.725506e-001,
	-1.976294e-001,
	2.376807e+000,
	-1.859856e-002,
	-1.803033e+000,
	1.207528e+000,
	-1.189845e+000,
	-1.509036e-001,
	1.345709e+000,
	5.832609e-001,
	-5.130839e-002,
	1.097035e+000,
	2.686911e-002,
	3.349361e+000,
	-3.431297e-002,
	-1.000281e+000,
	-1.696328e-001,
	2.829408e+000,
	-3.466041e-001,
	1.832532e+000,
	2.314637e+000,
	-2.721994e-002,
	-1.614939e+000,
	1.188720e+000,
	-1.120411e+000,
	-1.974172e-001,
	2.474172e+000,
	1.453506e-001,
	-4.002206e+000,
	1.180333e+000,
	2.229171e-002,
	3.112615e-001,
	5.505539e-001,
	// albedo 1, turbidity 2
	-1.112667e+000,
	-1.574855e-001,
	-2.284814e+000,
	4.255050e+000,
	-1.386097e-001,
	1.459506e+000,
	4.508931e-002,
	2.944474e+000,
	7.339984e-001,
	-1.113577e+000,
	-1.331062e-001,
	-1.828757e+000,
	3.910596e+000,
	-2.095519e-001,
	1.159335e+000,
	9.311608e-002,
	4.517295e+000,
	6.365313e-001,
	-1.061651e+000,
	-2.007134e-001,
	5.907472e+000,
	-4.808769e+000,
	-2.120206e-001,
	2.727568e+000,
	-4.222666e-002,
	-2.599674e+000,
	9.265659e-001,
	-1.136633e+000,
	-4.281875e-003,
	-3.407541e+000,
	4.132332e+000,
	-3.866153e-001,
	-5.082717e-001,
	4.828348e-001,
	9.797167e+000,
	3.325034e-001,
	-1.027909e+000,
	-2.334388e-001,
	4.972147e+000,
	-1.499736e+000,
	9.598438e-002,
	2.744895e+000,
	-3.558702e-001,
	-4.288054e+000,
	1.000138e+000,
	-1.102843e+000,
	-1.875642e-001,
	2.087760e+000,
	3.692600e-001,
	-6.520835e-001,
	-9.598766e-001,
	2.984231e-001,
	4.045786e-001,
	5.091931e-001,
	// albedo 1, turbidity 3
	-1.117485e+000,
	-1.492968e-001,
	-2.639425e+000,
	3.672106e+000,
	-1.058342e-001,
	1.098101e+000,
	1.544782e-001,
	4.496691e+000,
	6.582312e-001,
	-1.123872e+000,
	-1.467158e-001,
	3.049045e+000,
	-2.607634e+000,
	-2.505495e-001,
	-8.310458e-002,
	3.333822e-001,
	4.631418e+000,
	5.120491e-001,
	-1.118262e+000,
	-2.462050e-001,
	-8.333919e-002,
	2.438788e+000,
	6.143236e-001,
	3.745903e+000,
	-2.043295e-001,
	-3.451983e+000,
	1.056003e+000,
	-1.095394e+000,
	2.009680e-002,
	8.468659e-001,
	1.230624e-002,
	-8.638525e+000,
	-2.989487e+000,
	8.735734e-001,
	8.533740e+000,
	2.548062e-001,
	-1.035035e+000,
	-2.296018e-001,
	2.722309e+000,
	1.849369e-001,
	3.440975e+000,
	4.372083e+000,
	-4.747494e-001,
	-2.984092e+000,
	1.009737e+000,
	-1.113497e+000,
	-1.931400e-001,
	2.288509e+000,
	4.973129e-002,
	-1.353292e-001,
	-1.587772e+000,
	4.073801e-001,
	-8.180513e-003,
	5.682569e-001,
	// albedo 1, turbidity 4
	-1.172242e+000,
	-2.084847e-001,
	-1.212027e+000,
	1.991627e+000,
	-1.403495e-001,
	7.684996e-001,
	1.582914e-001,
	3.407597e+000,
	6.659386e-001,
	-1.167834e+000,
	-2.117291e-001,
	1.196578e+000,
	-1.438719e+000,
	-3.137939e-001,
	-4.537552e-002,
	2.260096e-001,
	4.659389e+000,
	5.776369e-001,
	-1.222298e+000,
	-2.893306e-001,
	9.080116e-001,
	1.413518e+000,
	1.709237e+000,
	2.915962e+000,
	8.464584e-002,
	-3.867076e+000,
	9.110543e-001,
	-9.554071e-001,
	6.610246e-002,
	-3.323811e-001,
	2.702543e+000,
	-1.345592e+001,
	-3.119309e+000,
	7.740473e-001,
	7.452516e+000,
	3.929172e-001,
	-1.119763e+000,
	-2.579942e-001,
	2.830634e+000,
	-1.333418e+000,
	6.825773e+000,
	4.230596e+000,
	-2.654108e-001,
	-2.669457e+000,
	9.126183e-001,
	-1.084261e+000,
	-2.086570e-001,
	2.248616e+000,
	6.993871e-001,
	-2.391760e+000,
	-1.738827e+000,
	3.674794e-001,
	-5.324741e-001,
	6.183292e-001,
	// albedo 1, turbidity 5
	-1.226325e+000,
	-2.688667e-001,
	-1.462040e-001,
	4.749868e-001,
	-8.718681e-002,
	4.956704e-001,
	1.752427e-001,
	2.933911e+000,
	6.470198e-001,
	-1.359737e+000,
	-3.985716e-001,
	-1.570034e-001,
	1.277905e+000,
	-1.314322e+000,
	4.320873e-001,
	8.532731e-002,
	2.774395e+000,
	6.318556e-001,
	-1.088212e+000,
	-1.688766e-001,
	1.399098e+000,
	-3.254950e+000,
	4.733557e+000,
	2.079183e+000,
	1.907990e-001,
	-9.540048e-001,
	8.714774e-001,
	-1.034524e+000,
	-1.050729e-002,
	-8.054376e-001,
	1.166351e+001,
	-1.879498e+001,
	-3.021428e+000,
	7.755251e-001,
	4.516574e+000,
	4.092690e-001,
	-1.076150e+000,
	-2.551781e-001,
	2.797790e+000,
	-5.437950e+000,
	9.156159e+000,
	3.988462e+000,
	-2.324172e-001,
	-2.124766e+000,
	8.863276e-001,
	-1.103432e+000,
	-2.058047e-001,
	2.117130e+000,
	2.401558e+000,
	-5.015370e+000,
	-1.829480e+000,
	4.046378e-001,
	-2.078794e-001,
	6.449045e-001,
	// albedo 1, turbidity 6
	-1.263516e+000,
	-3.133966e-001,
	3.174560e-001,
	-4.989246e-003,
	-2.317630e+000,
	3.963746e-001,
	1.677262e-001,
	2.563898e+000,
	6.335899e-001,
	-1.577927e+000,
	-5.893907e-001,
	-2.991531e-001,
	1.783728e+000,
	3.693827e+000,
	5.704918e-001,
	6.768069e-002,
	2.215180e+000,
	6.196162e-001,
	-9.191335e-001,
	-4.529201e-002,
	1.577262e+000,
	-6.455191e+000,
	-4.020064e+000,
	1.309911e+000,
	1.373281e-001,
	-7.178508e-001,
	9.243738e-001,
	-1.144508e+000,
	-9.289247e-002,
	-1.606387e+000,
	2.061805e+001,
	-1.051527e+001,
	-2.077164e+000,
	8.328239e-001,
	4.729795e+000,
	3.298487e-001,
	-1.018834e+000,
	-2.186851e-001,
	3.321767e+000,
	-7.887012e+000,
	3.374834e+000,
	3.005232e+000,
	-2.515037e-001,
	-2.656610e+000,
	9.316017e-001,
	-1.125230e+000,
	-2.422532e-001,
	1.850916e+000,
	6.213105e+000,
	-5.017914e+000,
	-1.644457e+000,
	3.811828e-001,
	-1.772362e-001,
	6.297360e-001,
	// albedo 1, turbidity 7
	-1.365631e+000,
	-4.017085e-001,
	1.942501e-001,
	-7.073927e-003,
	-1.461125e-001,
	4.898017e-001,
	1.623346e-001,
	2.330174e+000,
	5.983242e-001,
	-1.957177e+000,
	-9.640834e-001,
	-2.217521e-001,
	1.316645e+000,
	-1.907085e-001,
	1.134191e-002,
	9.704476e-002,
	3.828565e-002,
	5.538419e-001,
	-7.832629e-001,
	1.949904e-001,
	6.232354e-001,
	-2.947737e+000,
	3.702377e+000,
	2.212239e+000,
	9.128296e-002,
	3.131504e+000,
	9.923939e-001,
	-1.121562e+000,
	-2.704893e-001,
	-5.161748e-001,
	8.115427e+000,
	-1.443497e+001,
	-3.292676e+000,
	8.232212e-001,
	-1.548451e-002,
	3.199244e-001,
	-1.059207e+000,
	-1.613941e-001,
	2.375866e+000,
	-9.517705e-002,
	4.514722e+000,
	3.755824e+000,
	-1.696953e-001,
	-2.539157e-001,
	8.992553e-001,
	-1.108877e+000,
	-2.404852e-001,
	1.830175e+000,
	2.808956e+000,
	-4.932362e+000,
	-2.042775e+000,
	4.168739e-001,
	-2.534590e-001,
	6.533212e-001,
	// albedo 1, turbidity 8
	-1.405398e+000,
	-4.540068e-001,
	-4.766512e-001,
	1.871207e-001,
	5.535070e-001,
	-4.467365e-002,
	2.846366e-001,
	2.443422e+000,
	5.035706e-001,
	-2.843953e+000,
	-1.562366e+000,
	8.527921e-001,
	5.991182e-001,
	-9.984088e-001,
	7.599314e-001,
	-2.025184e-002,
	-1.515050e+000,
	4.397429e-001,
	-5.156586e-001,
	3.789775e-001,
	-1.194407e+000,
	-7.591558e-001,
	4.515532e+000,
	4.795814e-001,
	3.163186e-001,
	5.993132e+000,
	1.096327e+000,
	-1.070353e+000,
	-4.037269e-001,
	1.108932e+000,
	1.269159e+000,
	-1.099135e+001,
	-1.049849e+000,
	4.644725e-001,
	-4.387074e+000,
	2.704008e-001,
	-1.136211e+000,
	-1.473182e-001,
	1.235769e+000,
	5.725364e+000,
	1.712036e+000,
	1.630777e+000,
	3.656685e-002,
	2.082798e+000,
	9.036801e-001,
	-1.083101e+000,
	-2.468910e-001,
	1.894919e+000,
	6.574012e+000,
	-4.949098e+000,
	-1.132033e+000,
	3.336584e-001,
	-7.321133e-001,
	6.606587e-001,
	// albedo 1, turbidity 9
	-1.609910e+000,
	-6.550380e-001,
	-5.773346e-001,
	1.426156e+000,
	-5.000686e-001,
	8.257866e-001,
	1.839148e-002,
	2.106656e+000,
	6.957214e-001,
	-3.047283e+000,
	-1.421592e+000,
	-4.003615e-001,
	-6.531692e-001,
	5.643821e-001,
	-2.693762e-001,
	2.295553e-001,
	5.533910e-001,
	2.751822e-002,
	-2.160824e+000,
	-9.212504e-001,
	-8.438420e-001,
	1.466021e+000,
	1.124686e+000,
	-6.848173e-002,
	6.224893e-001,
	3.137662e+000,
	1.224147e+000,
	1.444817e-002,
	1.418426e-001,
	7.055176e-001,
	-1.787432e+000,
	-1.625625e+000,
	7.638401e-001,
	-3.309940e-001,
	-3.414755e+000,
	3.580691e-001,
	-1.480512e+000,
	-3.141638e-001,
	1.193403e+000,
	6.152773e+000,
	-3.314867e+000,
	1.345353e-001,
	5.359935e-001,
	1.409582e+000,
	8.072343e-001,
	-1.016066e+000,
	-2.346375e-001,
	1.457587e+000,
	-2.761458e-003,
	-2.546952e+000,
	-6.058542e-001,
	3.134230e-001,
	-2.232281e-001,
	6.760089e-001,
	// albedo 1, turbidity 10
	-2.019395e+000,
	-9.550942e-001,
	-1.187885e-001,
	1.995372e+000,
	-1.604228e+000,
	4.995785e-001,
	-9.647137e-006,
	1.929333e+000,
	8.659254e-001,
	-2.071307e+000,
	-9.485438e-001,
	-3.817151e-001,
	-1.657017e+000,
	9.488626e-001,
	5.816145e-001,
	-3.856514e-002,
	1.677756e+000,
	-1.262572e-001,
	-6.388445e+000,
	-2.738739e+000,
	-9.872469e-001,
	2.450058e+000,
	1.075999e+000,
	2.305434e-002,
	8.598771e-001,
	1.853582e+000,
	1.180017e+000,
	1.742851e+000,
	2.950102e-001,
	1.015937e+000,
	-2.511194e+000,
	-3.829361e+000,
	-1.126698e-001,
	-4.564605e-001,
	-2.097128e+000,
	4.012648e-001,
	-1.845177e+000,
	-3.242819e-001,
	7.060963e-001,
	7.747868e+000,
	-1.721532e+000,
	6.057347e-001,
	4.266212e-001,
	3.153697e-001,
	7.958222e-001,
	-9.599955e-001,
	-3.732025e-001,
	1.381129e+000,
	-3.983023e-003,
	-1.941446e+000,
	-5.943490e-001,
	2.269207e-001,
	-7.249738e-001,
	6.710888e-001,
};

double datasetRad680[] = 
{
	// albedo 0, turbidity 1
	1.320908e-002,
	9.179272e-003,
	2.540842e-002,
	3.413687e-002,
	2.736575e-002,
	2.799241e-002,
	// albedo 0, turbidity 2
	1.364418e-002,
	9.639315e-003,
	2.455688e-002,
	5.468867e-002,
	2.423200e-002,
	3.240293e-002,
	// albedo 0, turbidity 3
	1.356642e-002,
	9.864007e-003,
	2.017166e-002,
	8.738638e-002,
	2.138981e-002,
	3.828822e-002,
	// albedo 0, turbidity 4
	1.274664e-002,
	1.046958e-002,
	7.076299e-003,
	1.378101e-001,
	2.058352e-002,
	4.607358e-002,
	// albedo 0, turbidity 5
	1.151617e-002,
	1.429568e-002,
	-1.804673e-002,
	1.974118e-001,
	1.313176e-002,
	5.733295e-002,
	// albedo 0, turbidity 6
	1.089311e-002,
	1.719127e-002,
	-3.582843e-002,
	2.315641e-001,
	1.402940e-002,
	6.289477e-002,
	// albedo 0, turbidity 7
	9.705879e-003,
	2.218462e-002,
	-6.221073e-002,
	2.771148e-001,
	1.651339e-002,
	7.346287e-002,
	// albedo 0, turbidity 8
	8.356372e-003,
	2.724501e-002,
	-8.836051e-002,
	3.099528e-001,
	4.114206e-002,
	8.518889e-002,
	// albedo 0, turbidity 9
	7.026434e-003,
	2.944084e-002,
	-9.824183e-002,
	2.940735e-001,
	1.048477e-001,
	1.012199e-001,
	// albedo 0, turbidity 10
	5.935885e-003,
	2.429070e-002,
	-7.239967e-002,
	1.895904e-001,
	2.306596e-001,
	1.177261e-001,
	// albedo 1, turbidity 1
	1.370741e-002,
	1.011873e-002,
	2.499587e-002,
	3.362880e-002,
	6.416750e-002,
	6.673258e-002,
	// albedo 1, turbidity 2
	1.417558e-002,
	1.065771e-002,
	2.402602e-002,
	5.330606e-002,
	6.505571e-002,
	7.324558e-002,
	// albedo 1, turbidity 3
	1.406012e-002,
	1.182138e-002,
	1.636956e-002,
	9.161153e-002,
	6.031840e-002,
	8.638638e-002,
	// albedo 1, turbidity 4
	1.321071e-002,
	1.310944e-002,
	1.017467e-003,
	1.450040e-001,
	6.291618e-002,
	1.003625e-001,
	// albedo 1, turbidity 5
	1.194910e-002,
	1.687076e-002,
	-2.332212e-002,
	2.021394e-001,
	6.093196e-002,
	1.177929e-001,
	// albedo 1, turbidity 6
	1.126778e-002,
	1.905450e-002,
	-3.804088e-002,
	2.298767e-001,
	7.038318e-002,
	1.240367e-001,
	// albedo 1, turbidity 7
	1.025282e-002,
	2.337214e-002,
	-6.236283e-002,
	2.708195e-001,
	7.801793e-002,
	1.406577e-001,
	// albedo 1, turbidity 8
	9.018216e-003,
	2.718840e-002,
	-8.215497e-002,
	2.866465e-001,
	1.194106e-001,
	1.556975e-001,
	// albedo 1, turbidity 9
	7.747698e-003,
	2.701679e-002,
	-8.076599e-002,
	2.419548e-001,
	2.126954e-001,
	1.683085e-001,
	// albedo 1, turbidity 10
	6.701188e-003,
	2.085440e-002,
	-5.068221e-002,
	1.256935e-001,
	3.480598e-001,
	1.851691e-001,
};

double dataset720[] = 
{
	// albedo 0, turbidity 1
	-1.110553e+000,
	-1.675726e-001,
	-2.349324e-001,
	2.433790e+000,
	-1.342878e-001,
	1.755516e+000,
	-1.879493e-006,
	1.509217e+000,
	7.216495e-001,
	-1.149960e+000,
	-2.418229e-001,
	2.341927e+000,
	1.486508e-001,
	-4.333388e-001,
	9.028740e-001,
	9.450710e-003,
	-3.134790e-001,
	5.923234e-001,
	-9.702430e-001,
	-5.384657e-002,
	3.025898e+000,
	-6.450284e-001,
	9.728166e-001,
	3.532967e+000,
	-2.429753e-002,
	1.343614e+000,
	1.067807e+000,
	-1.278773e+000,
	-2.072018e-001,
	-2.458359e-001,
	3.749133e-001,
	-9.580484e+000,
	3.066020e-001,
	4.056471e-002,
	4.343208e+000,
	1.865704e-001,
	-9.511618e-001,
	-1.674143e-001,
	4.195842e+000,
	-1.205785e-001,
	2.160133e+000,
	3.048813e+000,
	-4.826924e-002,
	-3.779096e+000,
	1.024834e+000,
	-1.095577e+000,
	-1.855865e-001,
	1.973593e+000,
	7.894097e-002,
	9.578182e-001,
	8.565674e-001,
	4.663966e-002,
	7.375811e-001,
	5.577192e-001,
	// albedo 0, turbidity 2
	-1.099352e+000,
	-1.338612e-001,
	-8.419373e-001,
	2.710346e+000,
	-2.241044e-001,
	1.645463e+000,
	7.621625e-002,
	3.548772e+000,
	7.268231e-001,
	-1.140694e+000,
	-1.723890e-001,
	1.413194e+000,
	3.429051e-001,
	-4.431396e-001,
	9.757402e-001,
	1.248306e-001,
	1.780103e+000,
	6.637254e-001,
	-9.861499e-001,
	-8.032931e-002,
	2.396682e+000,
	7.281382e-001,
	1.472495e-001,
	3.316479e+000,
	-1.028439e-001,
	3.729469e+000,
	9.059004e-001,
	-1.233397e+000,
	-9.896833e-002,
	-1.679568e+000,
	1.542653e+000,
	-9.977726e+000,
	-6.579124e-001,
	6.386315e-001,
	6.157752e+000,
	3.985939e-001,
	-9.438092e-001,
	-1.629239e-001,
	4.213446e+000,
	-3.419684e-001,
	2.110121e+000,
	3.552183e+000,
	-2.817116e-001,
	-3.323718e+000,
	8.785077e-001,
	-1.120794e+000,
	-2.121477e-001,
	1.326767e+000,
	2.317528e-001,
	5.648291e-001,
	4.155089e-001,
	3.048162e-001,
	3.186797e-001,
	6.285665e-001,
	// albedo 0, turbidity 3
	-1.117191e+000,
	-1.510453e-001,
	-3.511136e-001,
	1.706946e+000,
	-3.820460e-001,
	1.228101e+000,
	1.641555e-001,
	3.663544e+000,
	6.846104e-001,
	-1.130950e+000,
	-1.622534e-001,
	1.197076e+000,
	-1.342532e+000,
	6.608991e-002,
	-1.955817e-001,
	3.515286e-001,
	3.237403e+000,
	5.732364e-001,
	-1.103903e+000,
	-1.810472e-001,
	1.254237e+000,
	3.367565e+000,
	-1.746589e+000,
	4.464939e+000,
	-2.831757e-001,
	-2.424241e-001,
	9.961252e-001,
	-1.107818e+000,
	-2.407723e-002,
	-7.518594e-001,
	7.115830e+000,
	-1.603375e+001,
	-4.077248e+000,
	1.210904e+000,
	6.281392e+000,
	2.496837e-001,
	-1.012153e+000,
	-1.911658e-001,
	2.357463e+000,
	-2.392720e+000,
	7.080581e+000,
	6.002768e+000,
	-5.120158e-001,
	-2.039879e+000,
	1.008071e+000,
	-1.083766e+000,
	-1.889743e-001,
	1.669813e+000,
	1.205140e+000,
	-2.973102e+000,
	-1.420288e+000,
	5.838643e-001,
	1.338574e-001,
	5.902153e-001,
	// albedo 0, turbidity 4
	-1.176390e+000,
	-2.045914e-001,
	-1.035177e+000,
	1.521425e+000,
	-9.698257e-002,
	7.561111e-001,
	2.338582e-001,
	3.264500e+000,
	6.520267e-001,
	-1.132876e+000,
	-1.921539e-001,
	9.661015e-001,
	-2.470184e-001,
	-5.825797e-001,
	5.044517e-001,
	1.418233e-001,
	4.416172e+000,
	6.580570e-001,
	-1.296062e+000,
	-2.855719e-001,
	1.143329e+000,
	-1.640682e+000,
	1.921828e+000,
	1.625086e+000,
	5.248871e-001,
	-3.757434e+000,
	7.293814e-001,
	-9.026255e-001,
	2.670242e-002,
	-8.632572e-001,
	7.076787e+000,
	-1.407525e+001,
	-1.251814e+000,
	1.806495e-001,
	6.575978e+000,
	6.367149e-001,
	-1.103623e+000,
	-1.818983e-001,
	1.490037e+000,
	-3.276017e+000,
	6.936153e+000,
	2.689183e+000,
	5.705211e-001,
	-1.354153e+000,
	7.095230e-001,
	-1.049370e+000,
	-1.854814e-001,
	1.385509e+000,
	1.714977e+000,
	-3.205204e+000,
	-1.161420e-001,
	3.453320e-001,
	4.355508e-001,
	7.115006e-001,
	// albedo 0, turbidity 5
	-1.225291e+000,
	-2.574996e-001,
	-4.766919e-001,
	4.951357e-001,
	5.242961e-002,
	4.702062e-001,
	2.428653e-001,
	3.095075e+000,
	6.424221e-001,
	-1.318856e+000,
	-3.713082e-001,
	-4.987985e-001,
	2.026237e+000,
	-1.457426e+000,
	7.809557e-001,
	1.419197e-003,
	2.776845e+000,
	7.058454e-001,
	-1.168038e+000,
	-1.572586e-001,
	1.786834e+000,
	-4.594005e+000,
	4.780600e+000,
	1.639416e+000,
	5.324063e-001,
	-1.000719e+000,
	7.325083e-001,
	-9.862998e-001,
	-7.482649e-002,
	-1.332445e+000,
	1.329260e+001,
	-1.803019e+001,
	-2.669936e+000,
	3.591475e-001,
	3.852972e+000,
	5.714399e-001,
	-1.049025e+000,
	-1.404280e-001,
	1.342894e+000,
	-5.633938e+000,
	8.396123e+000,
	3.809869e+000,
	4.313231e-001,
	-5.373938e-001,
	7.693298e-001,
	-1.069033e+000,
	-2.091865e-001,
	1.088280e+000,
	3.125506e+000,
	-4.664580e+000,
	-1.191484e+000,
	5.195344e-001,
	3.961673e-001,
	6.817393e-001,
	// albedo 0, turbidity 6
	-1.267895e+000,
	-3.004228e-001,
	-5.149611e-001,
	4.302967e-001,
	1.504018e-001,
	3.700643e-001,
	2.354209e-001,
	2.887788e+000,
	6.298388e-001,
	-1.551925e+000,
	-5.917820e-001,
	-5.915642e-001,
	2.016019e+000,
	-1.252286e+000,
	8.651065e-001,
	7.721402e-003,
	1.148828e+000,
	6.589887e-001,
	-9.782795e-001,
	3.652455e-002,
	1.331304e+000,
	-4.804135e+000,
	5.130801e+000,
	1.052586e+000,
	4.439877e-001,
	2.100157e+000,
	8.308236e-001,
	-1.077598e+000,
	-2.015253e-001,
	-1.037818e+000,
	1.307045e+001,
	-1.715211e+001,
	-1.607252e+000,
	4.472382e-001,
	6.802371e-001,
	4.848934e-001,
	-1.025969e+000,
	-1.170376e-001,
	1.139546e+000,
	-3.374680e+000,
	6.330035e+000,
	2.199093e+000,
	3.928627e-001,
	8.428666e-001,
	7.960910e-001,
	-1.062382e+000,
	-1.881842e-001,
	8.863153e-001,
	4.266858e+000,
	-5.011692e+000,
	-4.086830e-001,
	5.889147e-001,
	5.341939e-001,
	6.866073e-001,
	// albedo 0, turbidity 7
	-1.352417e+000,
	-3.836953e-001,
	-5.951560e-001,
	4.053297e-001,
	2.468304e-001,
	2.565711e-001,
	2.321365e-001,
	2.512376e+000,
	6.089904e-001,
	-1.976438e+000,
	-9.152777e-001,
	-4.417666e-001,
	1.790189e+000,
	-1.085567e+000,
	4.562228e-001,
	2.133332e-002,
	4.989856e-001,
	6.257100e-001,
	-7.197412e-001,
	2.165210e-001,
	6.233215e-001,
	-3.960686e+000,
	4.694083e+000,
	2.062797e+000,
	3.121864e-001,
	2.942681e+000,
	8.846033e-001,
	-1.189984e+000,
	-3.151612e-001,
	-5.020073e-001,
	1.015136e+001,
	-1.483684e+001,
	-3.476730e+000,
	6.049863e-001,
	-1.941153e-001,
	4.281015e-001,
	-9.781383e-001,
	-8.764833e-002,
	8.290915e-001,
	1.086960e-001,
	4.467570e+000,
	3.905633e+000,
	1.975895e-001,
	6.964295e-001,
	8.333166e-001,
	-1.081242e+000,
	-2.051949e-001,
	6.056482e-001,
	5.219268e+000,
	-4.410608e+000,
	-1.963212e+000,
	7.277904e-001,
	8.509624e-001,
	6.689251e-001,
	// albedo 0, turbidity 8
	-1.443212e+000,
	-4.725757e-001,
	-9.477961e-001,
	2.671049e-001,
	6.163577e-001,
	-3.965036e-001,
	4.071134e-001,
	2.464218e+000,
	4.997820e-001,
	-3.021428e+000,
	-1.558459e+000,
	1.389763e-001,
	1.122031e+000,
	-1.014816e+000,
	1.265687e+000,
	-1.649604e-001,
	-6.627923e-001,
	5.494665e-001,
	-1.593477e-001,
	5.076305e-001,
	-7.283933e-001,
	-1.265076e+000,
	3.904153e+000,
	-8.196757e-002,
	6.585734e-001,
	4.998464e+000,
	9.330667e-001,
	-1.378374e+000,
	-5.064534e-001,
	7.231197e-001,
	1.385088e+000,
	-9.500118e+000,
	-4.806746e-001,
	1.067642e-001,
	-3.297209e+000,
	4.441955e-001,
	-9.436176e-001,
	-6.189764e-002,
	1.144482e-001,
	9.137694e+000,
	2.948867e-001,
	1.224655e+000,
	3.675148e-001,
	2.124090e+000,
	8.014519e-001,
	-1.078915e+000,
	-2.051854e-001,
	4.754209e-001,
	5.826389e-003,
	-2.498632e+000,
	-8.265078e-001,
	7.644670e-001,
	6.066256e-001,
	6.811963e-001,
	// albedo 0, turbidity 9
	-1.621711e+000,
	-6.425839e-001,
	-7.307813e-001,
	1.109519e+000,
	-4.107299e-001,
	7.789953e-001,
	7.764812e-002,
	2.335627e+000,
	6.230915e-001,
	-4.003597e+000,
	-1.736865e+000,
	-6.062450e-001,
	-7.370264e-001,
	7.002778e-001,
	-4.140325e-001,
	3.926087e-001,
	8.316399e-001,
	1.516341e-001,
	-7.696712e-001,
	-3.872306e-001,
	-1.159436e+000,
	1.660752e+000,
	2.031840e+000,
	-7.697685e-001,
	5.481684e-001,
	2.788249e+000,
	1.112977e+000,
	-8.506589e-001,
	-5.430791e-002,
	1.088719e+000,
	-2.513532e+000,
	-4.144477e+000,
	2.760914e+000,
	-3.011272e-001,
	-2.383556e+000,
	4.496070e-001,
	-1.150061e+000,
	-3.009215e-001,
	-9.176868e-002,
	8.996074e+000,
	-1.753862e+000,
	-2.428423e+000,
	5.764492e-001,
	1.218492e+000,
	7.552230e-001,
	-1.020853e+000,
	-1.499849e-001,
	3.437744e-001,
	-2.339597e-003,
	-2.646520e+000,
	1.378457e+000,
	6.708410e-001,
	9.149680e-001,
	6.961806e-001,
	// albedo 0, turbidity 10
	-1.982394e+000,
	-9.369621e-001,
	-3.767595e-001,
	2.514582e+000,
	-1.501415e+000,
	6.258952e-001,
	-5.260430e-006,
	2.100142e+000,
	7.824077e-001,
	-3.432415e+000,
	-1.264283e+000,
	-9.042363e-001,
	-2.930432e+000,
	8.249096e-001,
	7.244840e-001,
	3.055253e-002,
	2.527405e+000,
	-2.107031e-003,
	-4.333533e+000,
	-2.156157e+000,
	-8.341654e-001,
	5.048387e+000,
	1.803580e+000,
	-9.318434e-001,
	1.085401e+000,
	8.728330e-001,
	1.050061e+000,
	4.889224e-001,
	5.956721e-002,
	8.445388e-001,
	-7.479177e+000,
	-4.049292e+000,
	1.199966e+000,
	-7.060560e-001,
	-9.742353e-001,
	4.893674e-001,
	-1.347508e+000,
	-1.874523e-001,
	-5.063342e-002,
	1.299813e+001,
	-1.707387e+000,
	-4.076088e-001,
	6.119042e-001,
	3.717790e-001,
	7.662157e-001,
	-1.047037e+000,
	-3.743109e-001,
	3.452375e-001,
	-3.615559e-003,
	-2.169432e+000,
	-7.166880e-002,
	3.747046e-001,
	2.746126e-001,
	6.773818e-001,
	// albedo 1, turbidity 1
	-1.105396e+000,
	-1.663441e-001,
	-2.359634e-001,
	2.476496e+000,
	-1.329052e-001,
	1.715759e+000,
	2.103991e-003,
	1.421966e+000,
	6.270733e-001,
	-1.132480e+000,
	-2.330883e-001,
	2.273938e+000,
	2.422717e-001,
	-4.159883e-001,
	9.350714e-001,
	1.432347e-002,
	-4.176684e-001,
	4.664640e-001,
	-1.036155e+000,
	-9.432450e-002,
	3.117262e+000,
	-6.369808e-001,
	1.060389e+000,
	3.386481e+000,
	-4.605081e-002,
	1.248000e+000,
	9.701974e-001,
	-1.162485e+000,
	-1.382303e-001,
	1.544122e-001,
	3.716511e-001,
	-9.520209e+000,
	-2.739605e-001,
	8.489054e-002,
	4.371570e+000,
	7.694391e-002,
	-1.031787e+000,
	-2.165067e-001,
	4.446666e+000,
	-1.470711e-001,
	2.143436e+000,
	1.922123e+000,
	-9.589030e-002,
	-3.594664e+000,
	8.629249e-001,
	-1.081125e+000,
	-1.623953e-001,
	2.048137e+000,
	8.639386e-002,
	1.225845e+000,
	1.239255e-001,
	8.366038e-002,
	8.322625e-001,
	5.604708e-001,
	// albedo 1, turbidity 2
	-1.112606e+000,
	-1.514491e-001,
	-1.608942e+000,
	3.592344e+000,
	-1.616115e-001,
	1.593861e+000,
	5.488306e-002,
	2.854783e+000,
	7.519999e-001,
	-1.098630e+000,
	-1.410161e-001,
	2.155487e+000,
	-4.381610e-001,
	-3.635146e-001,
	1.313843e+000,
	1.201277e-001,
	2.469958e+000,
	6.481071e-001,
	-1.077575e+000,
	-1.275645e-001,
	1.418205e+000,
	2.057232e+000,
	-7.778503e-002,
	2.433840e+000,
	-7.094034e-002,
	3.347259e+000,
	9.344752e-001,
	-1.099714e+000,
	-4.474282e-002,
	-1.247041e-001,
	-1.578342e-001,
	-7.968895e+000,
	1.730912e-001,
	5.303765e-001,
	5.523179e+000,
	3.840340e-001,
	-1.061945e+000,
	-2.200148e-001,
	4.333103e+000,
	1.818948e-002,
	1.907751e+000,
	1.560633e+000,
	-3.182192e-001,
	-3.010282e+000,
	8.844351e-001,
	-1.087782e+000,
	-1.709041e-001,
	1.834683e+000,
	7.351214e-002,
	1.282669e+000,
	2.075884e-001,
	2.698971e-001,
	3.373859e-001,
	5.808336e-001,
	// albedo 1, turbidity 3
	-1.121417e+000,
	-1.551220e-001,
	-1.527123e+000,
	2.788105e+000,
	-1.477847e-001,
	1.152139e+000,
	1.742181e-001,
	3.473417e+000,
	6.737050e-001,
	-1.118910e+000,
	-1.496848e-001,
	2.736873e+000,
	-1.829596e+000,
	-3.411991e-001,
	1.177538e-001,
	2.960683e-001,
	3.273898e+000,
	5.743833e-001,
	-1.121145e+000,
	-1.980292e-001,
	-5.407002e-001,
	2.886807e+000,
	4.877852e-001,
	3.692424e+000,
	-1.104033e-001,
	-2.358878e-001,
	9.976295e-001,
	-1.078889e+000,
	-1.541161e-003,
	1.370650e+000,
	1.644450e+000,
	-1.425572e+001,
	-3.075430e+000,
	9.346385e-001,
	5.871863e+000,
	2.618026e-001,
	-1.053346e+000,
	-2.262166e-001,
	2.532003e+000,
	-8.720058e-001,
	7.667901e+000,
	4.357082e+000,
	-5.367969e-001,
	-2.073329e+000,
	1.023965e+000,
	-1.100093e+000,
	-1.810893e-001,
	2.566430e+000,
	4.757700e-001,
	-2.069684e+000,
	-1.585209e+000,
	4.693140e-001,
	-6.719615e-001,
	5.569453e-001,
	// albedo 1, turbidity 4
	-1.181528e+000,
	-2.151896e-001,
	-1.076470e+000,
	2.037517e+000,
	-1.683559e-001,
	8.780110e-001,
	1.782773e-001,
	2.768650e+000,
	6.743293e-001,
	-1.142132e+000,
	-1.825403e-001,
	1.320992e+000,
	-1.895472e+000,
	-2.160241e-001,
	-2.079637e-001,
	3.424953e-001,
	4.333355e+000,
	5.663420e-001,
	-1.225408e+000,
	-2.906477e-001,
	8.323962e-001,
	2.176300e+000,
	1.943859e+000,
	3.003671e+000,
	1.130255e-001,
	-4.449977e+000,
	8.867390e-001,
	-9.815988e-001,
	5.577004e-002,
	-4.240348e-001,
	1.488466e+000,
	-1.279361e+001,
	-3.110899e+000,
	7.360104e-001,
	7.937751e+000,
	4.474817e-001,
	-1.103439e+000,
	-2.481553e-001,
	3.045691e+000,
	-6.993993e-001,
	6.081464e+000,
	3.986228e+000,
	-1.616828e-001,
	-3.373973e+000,
	8.572294e-001,
	-1.081695e+000,
	-1.943361e-001,
	2.303236e+000,
	3.906537e-001,
	-1.498982e+000,
	-1.372140e+000,
	3.379214e-001,
	-4.953601e-001,
	6.521383e-001,
	// albedo 1, turbidity 5
	-1.235776e+000,
	-2.745978e-001,
	2.205316e-002,
	4.505193e-001,
	-1.569202e-001,
	5.065039e-001,
	2.016320e-001,
	2.449382e+000,
	6.535188e-001,
	-1.268478e+000,
	-3.078367e-001,
	-2.041769e-001,
	1.189583e+000,
	-1.311782e+000,
	4.724677e-001,
	1.025764e-001,
	3.300615e+000,
	6.689797e-001,
	-1.190389e+000,
	-2.597641e-001,
	1.377486e+000,
	-2.289003e+000,
	4.214767e+000,
	1.900318e+000,
	3.126604e-001,
	-2.537399e+000,
	7.980811e-001,
	-9.632300e-001,
	7.067379e-002,
	-6.690546e-001,
	9.507059e+000,
	-1.721426e+001,
	-2.850631e+000,
	6.931159e-001,
	5.722238e+000,
	4.856193e-001,
	-1.119689e+000,
	-3.019499e-001,
	2.657474e+000,
	-5.208105e+000,
	1.015200e+001,
	3.863887e+000,
	-1.603721e-001,
	-3.132328e+000,
	8.543154e-001,
	-1.078742e+000,
	-1.840880e-001,
	2.341448e+000,
	2.576821e+000,
	-5.011296e+000,
	-1.671996e+000,
	3.955131e-001,
	-4.700684e-001,
	6.516593e-001,
	// albedo 1, turbidity 6
	-1.263449e+000,
	-3.016185e-001,
	-1.680842e-001,
	4.791728e-001,
	-8.989862e-002,
	5.069014e-001,
	1.892810e-001,
	2.535339e+000,
	6.506411e-001,
	-1.544305e+000,
	-5.656222e-001,
	-2.084263e-001,
	1.312304e+000,
	-8.580598e-001,
	4.039133e-001,
	1.008588e-001,
	1.268784e+000,
	6.333075e-001,
	-9.436041e-001,
	-1.620107e-002,
	1.253874e+000,
	-3.499120e+000,
	4.452594e+000,
	1.870490e+000,
	1.524710e-001,
	8.031346e-001,
	8.930942e-001,
	-1.106718e+000,
	-1.102586e-001,
	-8.803979e-001,
	1.326904e+001,
	-1.878253e+001,
	-2.994671e+000,
	9.501205e-001,
	2.284893e+000,
	3.662824e-001,
	-1.048783e+000,
	-2.156089e-001,
	2.786728e+000,
	-4.862603e+000,
	8.438175e+000,
	3.683031e+000,
	-3.092444e-001,
	-1.293934e+000,
	9.110045e-001,
	-1.108140e+000,
	-2.156079e-001,
	2.181504e+000,
	2.124553e+000,
	-5.007442e+000,
	-1.711417e+000,
	4.904871e-001,
	-8.710312e-001,
	6.376965e-001,
	// albedo 1, turbidity 7
	-1.345282e+000,
	-3.856197e-001,
	-1.975094e-001,
	3.016919e-001,
	2.765844e-001,
	2.092275e-001,
	2.251325e-001,
	2.058589e+000,
	6.014266e-001,
	-1.907309e+000,
	-8.881952e-001,
	-4.827860e-001,
	1.495665e+000,
	-9.243173e-001,
	3.864061e-001,
	7.491538e-002,
	2.719526e-001,
	6.046039e-001,
	-7.540737e-001,
	1.800167e-001,
	1.174575e+000,
	-3.052295e+000,
	4.669060e+000,
	1.793876e+000,
	1.664066e-001,
	2.376187e+000,
	9.261122e-001,
	-1.165479e+000,
	-2.500464e-001,
	-9.603937e-001,
	8.919733e+000,
	-1.561899e+001,
	-2.850650e+000,
	8.368531e-001,
	3.404393e-001,
	3.694265e-001,
	-1.032259e+000,
	-1.593662e-001,
	2.621639e+000,
	-5.369281e-001,
	6.011517e+000,
	3.234312e+000,
	-1.842335e-001,
	-3.749684e-001,
	8.913063e-001,
	-1.119906e+000,
	-2.533313e-001,
	2.017975e+000,
	4.776492e-001,
	-5.005474e+000,
	-1.503414e+000,
	4.694448e-001,
	-1.039200e+000,
	6.438630e-001,
	// albedo 1, turbidity 8
	-1.457842e+000,
	-4.806585e-001,
	-6.807833e-001,
	2.682520e-001,
	5.586195e-001,
	-2.806536e-001,
	3.694491e-001,
	2.169304e+000,
	4.997873e-001,
	-2.906600e+000,
	-1.558470e+000,
	4.048869e-001,
	1.012321e+000,
	-8.709928e-001,
	9.025637e-001,
	-9.171486e-002,
	-1.279805e+000,
	5.327924e-001,
	-2.500868e-001,
	5.175467e-001,
	-4.366020e-001,
	-1.156645e+000,
	3.657335e+000,
	4.092973e-001,
	4.611188e-001,
	4.971048e+000,
	9.789196e-001,
	-1.282240e+000,
	-4.792753e-001,
	3.824491e-001,
	2.061672e+000,
	-9.474747e+000,
	-1.080446e+000,
	3.852100e-001,
	-3.234591e+000,
	3.696703e-001,
	-1.046065e+000,
	-1.097023e-001,
	1.672284e+000,
	4.799701e+000,
	1.286403e+000,
	1.712569e+000,
	1.099301e-001,
	1.214451e+000,
	8.572886e-001,
	-1.104124e+000,
	-2.576744e-001,
	1.919030e+000,
	-1.296687e-003,
	-3.500874e+000,
	-1.048831e+000,
	3.929400e-001,
	-9.229794e-001,
	6.687909e-001,
	// albedo 1, turbidity 9
	-1.658918e+000,
	-6.637256e-001,
	-1.162850e+000,
	1.829549e+000,
	-2.525065e-001,
	8.624803e-001,
	5.214746e-002,
	1.977784e+000,
	6.455044e-001,
	-3.553256e+000,
	-1.639022e+000,
	-8.821743e-001,
	-2.660037e-001,
	5.168738e-001,
	-8.582770e-001,
	4.110780e-001,
	1.034123e-001,
	1.039852e-001,
	-1.299367e+000,
	-4.890457e-001,
	-5.595307e-001,
	1.129115e+000,
	5.445041e-001,
	5.361314e-001,
	4.579589e-001,
	3.385708e+000,
	1.184267e+000,
	-4.366852e-001,
	-2.303554e-002,
	5.417530e-001,
	-9.106900e-001,
	-4.398484e-001,
	3.178252e-001,
	-2.132156e-001,
	-3.682761e+000,
	3.754470e-001,
	-1.334075e+000,
	-2.466639e-001,
	1.293237e+000,
	4.685982e+000,
	-4.032879e+000,
	4.666293e-001,
	5.337822e-001,
	1.603290e+000,
	8.067400e-001,
	-1.052460e+000,
	-2.501759e-001,
	1.601487e+000,
	1.713504e+000,
	-2.810006e+000,
	-8.042597e-001,
	3.216101e-001,
	-5.944876e-001,
	6.740783e-001,
	// albedo 1, turbidity 10
	-1.974746e+000,
	-9.111910e-001,
	-2.159155e-001,
	2.437415e+000,
	-1.592257e+000,
	6.133797e-001,
	-6.243023e-006,
	1.960399e+000,
	7.806415e-001,
	-2.677119e+000,
	-1.100702e+000,
	-6.847246e-001,
	-2.820855e+000,
	1.577837e+000,
	6.243833e-001,
	2.218481e-002,
	1.568717e+000,
	2.327673e-002,
	-5.323827e+000,
	-2.461050e+000,
	-3.941307e-001,
	4.908417e+000,
	-1.657232e-001,
	-9.501763e-001,
	1.063520e+000,
	1.455622e+000,
	9.781890e-001,
	1.325000e+000,
	3.538115e-001,
	1.783573e-001,
	-6.903650e+000,
	-8.079921e-001,
	1.215973e+000,
	-6.852540e-001,
	-1.735835e+000,
	5.744662e-001,
	-1.741196e+000,
	-3.448017e-001,
	1.242377e+000,
	1.098613e+001,
	-3.386782e+000,
	-3.128683e-001,
	5.792848e-001,
	1.364330e-002,
	7.112763e-001,
	-9.762671e-001,
	-3.368355e-001,
	1.374728e+000,
	-3.312353e-003,
	-2.576919e+000,
	-1.778015e-001,
	2.024288e-001,
	-6.128666e-001,
	6.917938e-001,
};

double datasetRad720[] = 
{
	// albedo 0, turbidity 1
	1.130152e-002,
	8.671843e-003,
	2.004792e-002,
	2.515879e-002,
	2.020140e-002,
	2.117353e-002,
	// albedo 0, turbidity 2
	1.224368e-002,
	8.839480e-003,
	2.189489e-002,
	4.083873e-002,
	1.919064e-002,
	2.455945e-002,
	// albedo 0, turbidity 3
	1.252249e-002,
	8.009335e-003,
	2.371432e-002,
	6.397292e-002,
	2.042384e-002,
	2.862112e-002,
	// albedo 0, turbidity 4
	1.180325e-002,
	8.958479e-003,
	1.183940e-002,
	1.148189e-001,
	1.354571e-002,
	3.848691e-002,
	// albedo 0, turbidity 5
	1.085725e-002,
	1.134459e-002,
	-7.554548e-003,
	1.671603e-001,
	8.431212e-003,
	4.772824e-002,
	// albedo 0, turbidity 6
	1.014547e-002,
	1.403737e-002,
	-2.479898e-002,
	2.032831e-001,
	5.127749e-003,
	5.409735e-002,
	// albedo 0, turbidity 7
	9.143208e-003,
	1.825961e-002,
	-4.902126e-002,
	2.473204e-001,
	7.992708e-003,
	6.238918e-002,
	// albedo 0, turbidity 8
	7.784746e-003,
	2.352715e-002,
	-7.647231e-002,
	2.868914e-001,
	2.581232e-002,
	7.345921e-002,
	// albedo 0, turbidity 9
	6.425568e-003,
	2.680506e-002,
	-9.216963e-002,
	2.866525e-001,
	7.712816e-002,
	8.877708e-002,
	// albedo 0, turbidity 10
	5.348459e-003,
	2.347534e-002,
	-7.499904e-002,
	2.035369e-001,
	1.874982e-001,
	1.045961e-001,
	// albedo 1, turbidity 1
	1.168435e-002,
	9.445039e-003,
	1.950520e-002,
	2.563333e-002,
	4.729214e-002,
	5.096829e-002,
	// albedo 1, turbidity 2
	1.252521e-002,
	1.012940e-002,
	2.002302e-002,
	4.276714e-002,
	4.778275e-002,
	5.748908e-002,
	// albedo 1, turbidity 3
	1.285682e-002,
	9.705956e-003,
	2.018767e-002,
	6.797612e-002,
	5.181662e-002,
	6.548541e-002,
	// albedo 1, turbidity 4
	1.218970e-002,
	1.070161e-002,
	8.436124e-003,
	1.177409e-001,
	5.124773e-002,
	8.069723e-002,
	// albedo 1, turbidity 5
	1.129406e-002,
	1.339498e-002,
	-1.193989e-002,
	1.709051e-001,
	5.001995e-002,
	9.558448e-002,
	// albedo 1, turbidity 6
	1.056724e-002,
	1.570995e-002,
	-2.759057e-002,
	2.030760e-001,
	5.311962e-002,
	1.037882e-001,
	// albedo 1, turbidity 7
	9.594077e-003,
	1.966415e-002,
	-5.024827e-002,
	2.432607e-001,
	6.172355e-002,
	1.169276e-001,
	// albedo 1, turbidity 8
	8.348105e-003,
	2.415281e-002,
	-7.475064e-002,
	2.748209e-001,
	8.753187e-002,
	1.356651e-001,
	// albedo 1, turbidity 9
	7.106169e-003,
	2.513833e-002,
	-7.928946e-002,
	2.463668e-001,
	1.685984e-001,
	1.485820e-001,
	// albedo 1, turbidity 10
	6.031610e-003,
	2.016534e-002,
	-5.448075e-002,
	1.436689e-001,
	2.971830e-001,
	1.639884e-001,
};

double* datasets[] =
{
	dataset320,
	dataset360,
	dataset400,
	dataset440,
	dataset480,
	dataset520,
	dataset560,
	dataset600,
	dataset640,
	dataset680,
    dataset720
};

double* datasetsRad[] =
{
	datasetRad320,
	datasetRad360,
	datasetRad400,
	datasetRad440,
	datasetRad480,
	datasetRad520,
	datasetRad560,
	datasetRad600,
	datasetRad640,
	datasetRad680,
    datasetRad720
};

// Uses Feb 9 dataset
double solarDataset320[] = 
{
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.162049e+02,
	4.610588e+00,
	0,
	0,
	-3.824759e+00,
	1.338698e+01,
	5.595274e-02,
	3.125000e-04,
	-2.161500e+03,
	1.113209e+02,
	3.458172e-01,
	2.500000e-03,
	8.294600e+01,
	1.711252e+02,
	2.111274e+00,
	1.984375e-02,
	-4.229939e+03,
	6.275308e+02,
	6.980643e+00,
	8.375000e-02,
	-1.740178e+04,
	1.708634e+03,
	2.367820e+01,
	3.350000e-01,
	-1.976851e+04,
	2.817040e+03,
	6.781352e+01,
	1.193125e+00,
	-3.810737e+04,
	4.836590e+03,
	1.556846e+02,
	3.466250e+00,
	-4.549929e+04,
	6.516914e+03,
	3.119331e+02,
	8.744219e+00,
	-5.263436e+04,
	8.036785e+03,
	5.455303e+02,
	1.930562e+01,
	-6.309578e+04,
	9.205958e+03,
	8.581439e+02,
	3.815516e+01,
	-4.954890e+04,
	8.736703e+03,
	1.229615e+03,
	6.870672e+01,
	-6.343828e+04,
	9.001550e+03,
	1.628815e+03,
	1.138184e+02,
	-3.475406e+04,
	6.615408e+03,
	2.019023e+03,
	1.763652e+02,
	-4.201833e+04,
	6.105544e+03,
	2.362030e+03,
	2.567578e+02,
	-2.667604e+04,
	4.055614e+03,
	2.646799e+03,
	3.559691e+02,
	-2.036310e+04,
	2.748587e+03,
	2.846313e+03,
	4.723367e+02,
	-2.032124e+04,
	1.878732e+03,
	2.969980e+03,
	6.041547e+02,
	-1.073640e+04,
	4.777580e+02,
	3.009645e+03,
	7.491283e+02,
	-1.005389e+04,
	-3.672131e+01,
	2.973858e+03,
	9.033814e+02,
	-1.030868e+04,
	-4.464229e+02,
	2.879841e+03,
	1.064085e+03,
	-2.157918e+03,
	-1.342683e+03,
	2.723843e+03,
	1.227711e+03,
	-3.651657e+03,
	-1.197013e+03,
	2.534012e+03,
	1.389789e+03,
	-7.289195e+03,
	-9.708760e+02,
	2.331442e+03,
	1.548851e+03,
	-7.704469e+02,
	-1.628402e+03,
	2.093848e+03,
	1.702493e+03,
	-4.214558e+03,
	-1.153021e+03,
	1.844767e+03,
	1.845862e+03,
	-2.390689e+03,
	-1.287373e+03,
	1.593697e+03,
	1.978602e+03,
	-6.413034e+03,
	-8.008887e+02,
	1.339243e+03,
	2.097559e+03,
	-2.988481e+03,
	-1.136665e+03,
	1.064931e+03,
	2.201486e+03,
	-6.139876e+03,
	-5.991924e+02,
	7.913266e+02,
	2.285209e+03,
	-1.196221e+04,
	1.344918e+02,
	5.186582e+02,
	2.348895e+03,
	-5.971683e+03,
	-6.555303e+01,
	2.013157e+02,
	2.389728e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.229445e+02,
	7.374485e+00,
	0,
	0,
	-1.231740e+01,
	1.262553e+01,
	7.960490e-02,
	4.687500e-04,
	-2.643352e+02,
	5.605647e+01,
	3.498905e-01,
	2.812500e-03,
	-2.454452e+03,
	2.369608e+02,
	1.620789e+00,
	1.531250e-02,
	-4.320948e+03,
	5.952227e+02,
	6.834726e+00,
	7.828125e-02,
	-1.272903e+04,
	1.474486e+03,
	2.244014e+01,
	3.187500e-01,
	-1.829132e+04,
	2.679893e+03,
	6.267850e+01,
	1.107500e+00,
	-3.969700e+04,
	4.797859e+03,
	1.468690e+02,
	3.237813e+00,
	-4.233637e+04,
	6.288595e+03,
	2.991805e+02,
	8.289531e+00,
	-5.378742e+04,
	8.016312e+03,
	5.272841e+02,
	1.845875e+01,
	-6.132387e+04,
	9.078358e+03,
	8.364539e+02,
	3.679578e+01,
	-5.902508e+04,
	9.037411e+03,
	1.204972e+03,
	6.666500e+01,
	-4.718111e+04,
	8.049720e+03,
	1.595444e+03,
	1.110180e+02,
	-4.077260e+04,
	7.049147e+03,
	1.976792e+03,
	1.719842e+02,
	-4.205766e+04,
	6.112440e+03,
	2.327488e+03,
	2.511269e+02,
	-2.791505e+04,
	4.115557e+03,
	2.612616e+03,
	3.489953e+02,
	-1.609988e+04,
	2.510900e+03,
	2.810607e+03,
	4.639409e+02,
	-2.314164e+04,
	2.163386e+03,
	2.938786e+03,
	5.940591e+02,
	-1.330257e+04,
	6.221024e+02,
	2.986256e+03,
	7.378767e+02,
	-5.675969e+03,
	-3.846177e+02,
	2.945011e+03,
	8.909630e+02,
	-6.495665e+03,
	-5.518256e+02,
	2.852178e+03,
	1.049766e+03,
	-1.215437e+04,
	-4.405937e+02,
	2.722478e+03,
	1.212177e+03,
	2.719602e+03,
	-1.879784e+03,
	2.530070e+03,
	1.375258e+03,
	-8.647169e+03,
	-7.569952e+02,
	2.319694e+03,
	1.532926e+03,
	-1.867684e+03,
	-1.528257e+03,
	2.092233e+03,
	1.686330e+03,
	-4.025935e+03,
	-1.211125e+03,
	1.840308e+03,
	1.829689e+03,
	-1.081717e+03,
	-1.411956e+03,
	1.583655e+03,
	1.961830e+03,
	-7.350389e+03,
	-6.622648e+02,
	1.334664e+03,
	2.079855e+03,
	-2.343916e+03,
	-1.205267e+03,
	1.063635e+03,
	2.183818e+03,
	-7.430550e+03,
	-4.556049e+02,
	7.931502e+02,
	2.267336e+03,
	-1.068232e+04,
	-2.114828e+01,
	5.135211e+02,
	2.331394e+03,
	-6.217560e+03,
	-3.350260e+01,
	2.024873e+02,
	2.371433e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.203441e+02,
	4.171995e+00,
	0,
	0,
	1.426480e+02,
	-4.022426e-01,
	2.425240e-02,
	1.562500e-04,
	-4.009478e+01,
	1.125399e+01,
	5.471435e-02,
	4.687500e-04,
	-6.200072e+02,
	5.758122e+01,
	2.853042e-01,
	2.343750e-03,
	-6.987267e+02,
	1.643846e+02,
	1.429285e+00,
	1.359375e-02,
	-5.632468e+03,
	5.971678e+02,
	5.643686e+00,
	6.437500e-02,
	-1.136274e+04,
	1.361972e+03,
	2.032334e+01,
	2.812500e-01,
	-1.952933e+04,
	2.607796e+03,
	5.786257e+01,
	1.004844e+00,
	-3.532941e+04,
	4.461645e+03,
	1.377803e+02,
	3.003125e+00,
	-4.143687e+04,
	6.064540e+03,
	2.816662e+02,
	7.743281e+00,
	-5.085245e+04,
	7.694233e+03,
	5.005985e+02,
	1.737797e+01,
	-6.042859e+04,
	8.861458e+03,
	7.989383e+02,
	3.484813e+01,
	-5.375945e+04,
	8.686126e+03,
	1.157257e+03,
	6.348969e+01,
	-4.609594e+04,
	8.037224e+03,
	1.541142e+03,
	1.061803e+02,
	-5.818693e+04,
	7.796026e+03,
	1.925333e+03,
	1.653475e+02,
	-1.234873e+04,
	4.326471e+03,
	2.261366e+03,
	2.427720e+02,
	-4.100578e+04,
	5.301137e+03,
	2.543132e+03,
	3.370997e+02,
	-2.570418e+04,
	3.036407e+03,
	2.771427e+03,
	4.502481e+02,
	-9.930667e+03,
	1.185082e+03,
	2.888544e+03,
	5.787917e+02,
	-1.540011e+04,
	1.011847e+03,
	2.933616e+03,
	7.193989e+02,
	-8.074592e+03,
	-9.360958e+01,
	2.915801e+03,
	8.705267e+02,
	-1.229699e+04,
	-1.891092e+02,
	2.833288e+03,
	1.028212e+03,
	1.425166e+02,
	-1.460737e+03,
	2.687065e+03,
	1.189614e+03,
	-7.667229e+03,
	-7.968169e+02,
	2.508850e+03,
	1.349517e+03,
	-2.347845e+03,
	-1.408348e+03,
	2.307273e+03,
	1.507527e+03,
	-4.419120e+03,
	-1.175822e+03,
	2.079767e+03,
	1.659044e+03,
	-4.704423e+03,
	-1.172710e+03,
	1.838621e+03,
	1.802379e+03,
	-3.231727e+01,
	-1.540847e+03,
	1.575896e+03,
	1.934311e+03,
	-7.381753e+03,
	-6.308022e+02,
	1.326603e+03,
	2.051421e+03,
	-2.673977e+03,
	-1.159966e+03,
	1.060234e+03,
	2.154908e+03,
	-6.512200e+03,
	-5.471063e+02,
	7.899642e+02,
	2.238250e+03,
	-9.505497e+03,
	-1.111579e+02,
	5.172803e+02,
	2.301960e+03,
	-6.085971e+03,
	-7.278179e+01,
	2.224392e+02,
	2.342608e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.398243e+02,
	5.776206e+00,
	0,
	0,
	2.463155e+02,
	-2.094592e-01,
	4.496203e-02,
	3.125000e-04,
	-1.010040e+03,
	5.790287e+01,
	1.278306e-01,
	1.093750e-03,
	-3.545764e+02,
	1.294156e+02,
	1.099066e+00,
	9.687500e-03,
	-6.451710e+03,
	5.563384e+02,
	4.533285e+00,
	4.984375e-02,
	-5.934123e+03,
	1.056602e+03,
	1.730255e+01,
	2.356250e-01,
	-2.331347e+04,
	2.539950e+03,
	4.913378e+01,
	8.401563e-01,
	-2.454544e+04,
	3.778662e+03,
	1.219910e+02,
	2.611719e+00,
	-4.570703e+04,
	5.952157e+03,
	2.514711e+02,
	6.796719e+00,
	-4.332230e+04,
	7.038252e+03,
	4.577067e+02,
	1.558687e+01,
	-6.059598e+04,
	8.589735e+03,
	7.371821e+02,
	3.161938e+01,
	-4.538550e+04,
	8.101580e+03,
	1.079569e+03,
	5.827141e+01,
	-5.158798e+04,
	8.232570e+03,
	1.451372e+03,
	9.823734e+01,
	-4.012520e+04,
	6.957081e+03,
	1.830066e+03,
	1.543975e+02,
	-3.793394e+04,
	5.939944e+03,
	2.176636e+03,
	2.281206e+02,
	-3.211292e+04,
	4.482161e+03,
	2.467196e+03,
	3.200717e+02,
	-1.588792e+04,
	2.521470e+03,
	2.673764e+03,
	4.292442e+02,
	-1.756764e+04,
	1.927386e+03,
	2.804183e+03,
	5.532441e+02,
	-1.277374e+04,
	8.843716e+02,
	2.867650e+03,
	6.906603e+02,
	-8.721587e+03,
	7.343786e+01,
	2.857501e+03,
	8.384222e+02,
	-1.210720e+04,
	-1.134775e+02,
	2.787446e+03,
	9.933153e+02,
	-7.324531e+02,
	-1.323481e+03,
	2.651921e+03,
	1.152349e+03,
	-7.693693e+03,
	-7.693487e+02,
	2.480657e+03,
	1.310405e+03,
	-2.653371e+03,
	-1.366675e+03,
	2.282324e+03,
	1.466687e+03,
	-3.648018e+03,
	-1.230454e+03,
	2.056210e+03,
	1.616582e+03,
	-2.664373e+03,
	-1.284624e+03,
	1.819352e+03,
	1.758212e+03,
	-5.222558e+03,
	-9.816239e+02,
	1.575433e+03,
	1.888928e+03,
	-2.865965e+03,
	-1.196481e+03,
	1.315007e+03,
	2.006915e+03,
	-3.599541e+03,
	-9.578621e+02,
	1.050151e+03,
	2.108105e+03,
	-6.734962e+03,
	-5.085043e+02,
	7.938554e+02,
	2.191497e+03,
	-1.211854e+04,
	1.393363e+02,
	5.225520e+02,
	2.255726e+03,
	-5.940851e+03,
	-7.200209e+01,
	2.016666e+02,
	2.296840e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-5.810245e+01,
	2.305294e+00,
	0,
	0,
	-4.677095e+01,
	7.181418e+00,
	2.797637e-02,
	1.562500e-04,
	-2.390763e+02,
	3.399401e+01,
	1.676014e-01,
	1.250000e-03,
	-1.572353e+03,
	1.448172e+02,
	9.018003e-01,
	8.125000e-03,
	-1.932258e+03,
	3.555380e+02,
	4.045229e+00,
	4.515625e-02,
	-8.021604e+03,
	1.011597e+03,
	1.385505e+01,
	1.907813e-01,
	-1.760146e+04,
	2.142284e+03,
	4.213012e+01,
	7.085938e-01,
	-2.771190e+04,
	3.598579e+03,
	1.059734e+02,
	2.232031e+00,
	-2.685562e+04,
	4.912314e+03,
	2.231363e+02,
	5.951250e+00,
	-5.816933e+04,
	7.488614e+03,
	4.119772e+02,
	1.372719e+01,
	-5.375236e+04,
	7.934157e+03,
	6.844993e+02,
	2.860453e+01,
	-4.429083e+04,
	7.764848e+03,
	1.006186e+03,
	5.337641e+01,
	-4.260900e+04,
	7.623473e+03,
	1.360246e+03,
	9.077234e+01,
	-4.165134e+04,
	7.075685e+03,
	1.728438e+03,
	1.435205e+02,
	-4.199611e+04,
	6.142734e+03,
	2.077584e+03,
	2.136358e+02,
	-1.823240e+04,
	3.778736e+03,
	2.365364e+03,
	3.017798e+02,
	-2.860530e+04,
	3.604470e+03,
	2.586318e+03,
	4.064622e+02,
	-1.609512e+04,
	1.794040e+03,
	2.736939e+03,
	5.275606e+02,
	-1.254070e+04,
	8.805854e+02,
	2.797800e+03,
	6.615970e+02,
	-6.090084e+03,
	-5.143658e+01,
	2.789103e+03,
	8.057959e+02,
	-1.308790e+04,
	9.060229e+01,
	2.728964e+03,
	9.570091e+02,
	-1.747122e+03,
	-1.183227e+03,
	2.607217e+03,
	1.113144e+03,
	-4.502060e+03,
	-9.631705e+02,
	2.441686e+03,
	1.268743e+03,
	-4.925191e+03,
	-1.030626e+03,
	2.258761e+03,
	1.422545e+03,
	-4.605435e+03,
	-1.142309e+03,
	2.046600e+03,
	1.571669e+03,
	-2.008970e+03,
	-1.371278e+03,
	1.807372e+03,
	1.712698e+03,
	-4.054953e+03,
	-1.064272e+03,
	1.561721e+03,
	1.842282e+03,
	-4.186489e+03,
	-1.014859e+03,
	1.310764e+03,
	1.959238e+03,
	-4.536370e+03,
	-8.990475e+02,
	1.048215e+03,
	2.060568e+03,
	-4.732931e+03,
	-7.451517e+02,
	7.801005e+02,
	2.143593e+03,
	-1.235209e+04,
	2.174097e+02,
	5.169935e+02,
	2.206104e+03,
	-6.154950e+03,
	-5.382014e+01,
	2.046788e+02,
	2.247203e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.126883e+02,
	5.520338e+00,
	0,
	0,
	1.263603e+02,
	2.194173e+00,
	4.737462e-02,
	3.125000e-04,
	-1.508116e+01,
	2.129591e+01,
	1.399562e-01,
	1.250000e-03,
	-9.018236e+02,
	1.098378e+02,
	6.623187e-01,
	6.250000e-03,
	-3.504771e+03,
	3.721805e+02,
	3.219475e+00,
	3.484375e-02,
	-6.289506e+03,
	8.722241e+02,
	1.237269e+01,
	1.653125e-01,
	-1.480606e+04,
	1.913931e+03,
	3.734160e+01,
	6.228125e-01,
	-2.450066e+04,
	3.351021e+03,
	9.544644e+01,
	1.985000e+00,
	-3.693950e+04,
	5.083189e+03,
	2.063989e+02,
	5.391406e+00,
	-4.358414e+04,
	6.496516e+03,
	3.861177e+02,
	1.272703e+01,
	-4.530622e+04,
	7.428171e+03,
	6.366847e+02,
	2.650891e+01,
	-4.733767e+04,
	7.964659e+03,
	9.501384e+02,
	4.969906e+01,
	-5.370278e+04,
	8.090009e+03,
	1.307795e+03,
	8.545641e+01,
	-3.321384e+04,
	6.411379e+03,
	1.669725e+03,
	1.365462e+02,
	-3.641652e+04,
	5.884973e+03,
	2.004006e+03,
	2.040570e+02,
	-2.540098e+04,
	4.300449e+03,
	2.297230e+03,
	2.892628e+02,
	-2.760640e+04,
	3.474278e+03,
	2.524065e+03,
	3.914722e+02,
	-8.048468e+03,
	1.366510e+03,
	2.669037e+03,
	5.095961e+02,
	-2.029543e+04,
	1.620800e+03,
	2.744637e+03,
	6.402722e+02,
	-3.964493e+03,
	-2.191741e+02,
	2.750646e+03,
	7.826442e+02,
	-1.106059e+04,
	3.180232e+01,
	2.691209e+03,
	9.316025e+02,
	-4.643371e+03,
	-8.533850e+02,
	2.583124e+03,
	1.085744e+03,
	-4.533634e+03,
	-9.829180e+02,
	2.425278e+03,
	1.240435e+03,
	-6.144697e+03,
	-9.649133e+02,
	2.239377e+03,
	1.393075e+03,
	1.615287e+03,
	-1.671132e+03,
	2.018903e+03,
	1.540777e+03,
	-9.492625e+03,
	-5.137586e+02,
	1.801463e+03,
	1.679387e+03,
	-4.863360e+02,
	-1.552130e+03,
	1.555354e+03,
	1.810186e+03,
	-4.150248e+03,
	-9.569455e+02,
	1.295372e+03,
	1.925326e+03,
	-3.336249e+03,
	-9.666328e+02,
	1.043430e+03,
	2.025790e+03,
	-8.928017e+03,
	-2.828557e+02,
	7.918380e+02,
	2.108700e+03,
	-8.901351e+03,
	-2.240739e+02,
	5.052828e+02,
	2.172922e+03,
	-6.226979e+03,
	-2.346247e+01,
	2.056987e+02,
	2.211881e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.915526e+02,
	7.366238e+00,
	0,
	0,
	6.163369e+01,
	1.204175e+01,
	9.225802e-02,
	6.250000e-04,
	-6.773000e+02,
	7.896783e+01,
	4.201401e-01,
	3.750000e-03,
	-1.616556e+03,
	2.639201e+02,
	2.241390e+00,
	2.343750e-02,
	-1.059666e+04,
	9.232364e+02,
	9.386152e+00,
	1.187500e-01,
	-8.791318e+03,
	1.500107e+03,
	3.211158e+01,
	5.154688e-01,
	-2.227497e+04,
	2.999099e+03,
	8.091825e+01,
	1.660469e+00,
	-3.111629e+04,
	4.548813e+03,
	1.797262e+02,
	4.607656e+00,
	-4.734025e+04,
	6.313047e+03,
	3.438787e+02,
	1.107969e+01,
	-3.301271e+04,
	6.534868e+03,
	5.771119e+02,
	2.356234e+01,
	-5.497932e+04,
	8.077472e+03,
	8.696235e+02,
	4.460859e+01,
	-3.691249e+04,
	7.075388e+03,
	1.212190e+03,
	7.774641e+01,
	-4.535714e+04,
	7.102579e+03,
	1.562845e+03,
	1.251120e+02,
	-3.169379e+04,
	5.490801e+03,
	1.899280e+03,
	1.890709e+02,
	-1.728180e+04,
	3.949454e+03,
	2.183344e+03,
	2.698602e+02,
	-3.714132e+04,
	4.285851e+03,
	2.423673e+03,
	3.672678e+02,
	-5.215022e+03,
	1.183427e+03,
	2.583754e+03,
	4.816480e+02,
	-1.863398e+04,
	1.625851e+03,
	2.661413e+03,
	6.081128e+02,
	-6.406195e+03,
	7.803378e+01,
	2.681066e+03,
	7.464519e+02,
	-1.136441e+04,
	7.752814e+01,
	2.632242e+03,
	8.920981e+02,
	-2.047264e+03,
	-1.002831e+03,
	2.526395e+03,
	1.042912e+03,
	-6.248742e+03,
	-7.263883e+02,
	2.379661e+03,
	1.194150e+03,
	-5.489763e+03,
	-9.816353e+02,
	2.205342e+03,
	1.344432e+03,
	-1.167746e+02,
	-1.486682e+03,
	1.991891e+03,
	1.489923e+03,
	-6.259862e+03,
	-8.113410e+02,
	1.773796e+03,
	1.626878e+03,
	-1.374682e+03,
	-1.342055e+03,
	1.539054e+03,
	1.755264e+03,
	-5.056021e+03,
	-8.353907e+02,
	1.295621e+03,
	1.869990e+03,
	-4.537758e+03,
	-8.790940e+02,
	1.044749e+03,
	1.970797e+03,
	-6.706975e+03,
	-5.509051e+02,
	7.801558e+02,
	2.053670e+03,
	-1.020946e+04,
	-4.372454e+01,
	5.016635e+02,
	2.116272e+03,
	-6.221044e+03,
	-1.982749e+01,
	1.997960e+02,
	2.155378e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.471287e+01,
	3.454011e+00,
	0,
	0,
	-5.151738e+01,
	1.088983e+01,
	4.862104e-02,
	3.125000e-04,
	-5.554154e+02,
	5.853337e+01,
	2.954357e-01,
	2.500000e-03,
	-1.401631e+03,
	1.899381e+02,
	1.613639e+00,
	1.671875e-02,
	-3.677010e+03,
	5.381794e+02,
	6.576231e+00,
	8.437500e-02,
	-1.130930e+04,
	1.351274e+03,
	2.217409e+01,
	3.490625e-01,
	-1.610460e+04,
	2.382976e+03,
	6.220396e+01,
	1.221875e+00,
	-3.182774e+04,
	4.050808e+03,
	1.429730e+02,
	3.534531e+00,
	-2.661339e+04,
	4.911419e+03,
	2.820920e+02,
	8.833438e+00,
	-4.684400e+04,
	6.742349e+03,
	4.845560e+02,
	1.910938e+01,
	-3.607371e+04,
	6.710619e+03,
	7.550675e+02,
	3.735891e+01,
	-4.154781e+04,
	7.152810e+03,
	1.067429e+03,
	6.618859e+01,
	-4.204317e+04,
	6.774326e+03,
	1.407564e+03,
	1.085970e+02,
	-2.942193e+04,
	5.355563e+03,
	1.733269e+03,
	1.666419e+02,
	-2.313904e+04,
	4.280577e+03,
	2.017180e+03,
	2.408670e+02,
	-2.385720e+04,
	3.520820e+03,
	2.254320e+03,
	3.314445e+02,
	-1.513209e+04,
	2.112956e+03,
	2.426267e+03,
	4.378639e+02,
	-9.126023e+03,
	1.113924e+03,
	2.524502e+03,
	5.577991e+02,
	-1.571455e+04,
	1.029708e+03,
	2.566730e+03,
	6.890491e+02,
	-7.238440e+03,
	-2.206829e+02,
	2.538549e+03,
	8.297720e+02,
	-3.160979e+03,
	-7.760560e+02,
	2.439782e+03,
	9.749502e+02,
	-5.602452e+03,
	-6.902848e+02,
	2.308307e+03,
	1.121456e+03,
	-3.553157e+03,
	-1.014479e+03,
	2.146930e+03,
	1.267419e+03,
	-4.461083e+03,
	-9.863057e+02,
	1.956534e+03,
	1.409364e+03,
	-2.326809e+03,
	-1.209321e+03,
	1.742287e+03,
	1.544723e+03,
	-4.135229e+03,
	-9.712685e+02,
	1.515864e+03,
	1.670126e+03,
	-3.963535e+03,
	-9.751278e+02,
	1.278348e+03,
	1.783945e+03,
	-3.590545e+03,
	-9.317344e+02,
	1.027352e+03,
	1.882948e+03,
	-7.816601e+03,
	-3.861471e+02,
	7.759248e+02,
	1.964524e+03,
	-8.824559e+03,
	-1.916167e+02,
	4.991662e+02,
	2.027263e+03,
	-6.003275e+03,
	-4.576937e+01,
	2.081407e+02,
	2.066007e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-5.625582e+01,
	1.932575e+00,
	0,
	0,
	6.414978e+01,
	1.472767e+00,
	2.207452e-02,
	1.562500e-04,
	-2.922836e+02,
	2.777474e+01,
	8.841004e-02,
	7.812500e-04,
	-8.188740e+02,
	1.059625e+02,
	6.968160e-01,
	6.718750e-03,
	-2.889488e+03,
	3.500503e+02,
	3.437535e+00,
	4.109375e-02,
	-6.748480e+03,
	8.561885e+02,
	1.311485e+01,
	1.956250e-01,
	-9.511546e+03,
	1.611095e+03,
	3.896265e+01,
	7.334375e-01,
	-2.290021e+04,
	3.066546e+03,
	9.552066e+01,
	2.243906e+00,
	-2.821286e+04,
	4.251733e+03,
	2.028843e+02,
	5.967656e+00,
	-2.913541e+04,
	5.203704e+03,
	3.675117e+02,
	1.368859e+01,
	-4.048369e+04,
	6.372044e+03,
	5.934689e+02,
	2.775234e+01,
	-3.547831e+04,
	6.262590e+03,
	8.720572e+02,
	5.110688e+01,
	-3.218587e+04,
	5.921591e+03,
	1.172909e+03,
	8.616875e+01,
	-2.477427e+04,
	5.121564e+03,
	1.475680e+03,
	1.350383e+02,
	-2.868072e+04,
	4.746820e+03,
	1.762617e+03,
	1.991086e+02,
	-1.754454e+04,
	3.266592e+03,
	2.009591e+03,
	2.794042e+02,
	-1.913506e+04,
	2.655854e+03,
	2.197015e+03,
	3.748694e+02,
	-9.992284e+03,
	1.320722e+03,
	2.319693e+03,
	4.845859e+02,
	-1.419455e+04,
	1.062222e+03,
	2.376302e+03,
	6.057533e+02,
	-2.694677e+03,
	-3.023730e+02,
	2.365281e+03,
	7.364186e+02,
	-9.185589e+03,
	-8.118530e+00,
	2.302949e+03,
	8.721534e+02,
	-2.847409e+03,
	-8.444596e+02,
	2.197532e+03,
	1.011741e+03,
	-3.035145e+03,
	-8.775668e+02,
	2.051168e+03,
	1.150592e+03,
	-5.533588e+03,
	-7.385513e+02,
	1.887015e+03,
	1.286758e+03,
	-3.565998e+03,
	-1.040906e+03,
	1.691788e+03,
	1.417959e+03,
	-2.327347e+03,
	-1.126813e+03,
	1.469339e+03,
	1.539923e+03,
	-3.906176e+03,
	-8.827879e+02,
	1.242034e+03,
	1.649925e+03,
	-6.221863e+03,
	-6.310295e+02,
	1.007942e+03,
	1.746547e+03,
	-3.114073e+03,
	-8.975397e+02,
	7.474580e+02,
	1.826920e+03,
	-1.186080e+04,
	2.407749e+02,
	4.982586e+02,
	1.886371e+03,
	-6.394004e+03,
	-1.686521e+01,
	2.046311e+02,
	1.926321e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.355371e+02,
	8.998932e+00,
	0,
	0,
	-3.468260e+02,
	4.003623e+01,
	1.728223e-01,
	1.406250e-03,
	-1.659534e+03,
	1.606414e+02,
	1.180182e+00,
	1.281250e-02,
	-5.133751e+02,
	3.182364e+02,
	5.307610e+00,
	7.484375e-02,
	-1.044783e+04,
	1.132211e+03,
	1.723019e+01,
	2.984375e-01,
	-1.232620e+04,
	1.809523e+03,
	5.164214e+01,
	1.100625e+00,
	-1.492798e+04,
	2.716347e+03,
	1.170312e+02,
	3.201250e+00,
	-2.509641e+04,
	4.034536e+03,
	2.285777e+02,
	7.860000e+00,
	-3.139992e+04,
	4.936112e+03,
	3.976305e+02,
	1.709562e+01,
	-1.992734e+04,
	4.752382e+03,
	6.133259e+02,
	3.325813e+01,
	-3.583565e+04,
	5.733661e+03,
	8.653644e+02,
	5.850203e+01,
	-1.864658e+04,
	4.463079e+03,
	1.140041e+03,
	9.577875e+01,
	-2.806870e+04,
	4.628337e+03,
	1.403590e+03,
	1.460806e+02,
	-1.224450e+04,
	3.007469e+03,
	1.643849e+03,
	2.111303e+02,
	-1.837221e+04,
	2.895966e+03,
	1.840158e+03,
	2.900925e+02,
	-1.305949e+04,
	1.813863e+03,
	1.991237e+03,
	3.832811e+02,
	-7.995788e+03,
	9.019857e+02,
	2.074227e+03,
	4.884772e+02,
	-5.202137e+03,
	3.292653e+02,
	2.101192e+03,
	6.031734e+02,
	-9.894927e+03,
	3.490710e+02,
	2.086841e+03,
	7.252181e+02,
	-2.081824e+03,
	-6.584184e+02,
	2.017335e+03,
	8.526909e+02,
	-5.753047e+03,
	-4.455308e+02,
	1.904978e+03,
	9.807998e+02,
	-2.548608e+03,
	-9.027576e+02,
	1.761653e+03,
	1.108055e+03,
	-4.593746e+03,
	-7.480921e+02,
	1.589904e+03,
	1.230419e+03,
	-2.237374e+03,
	-1.028298e+03,
	1.394230e+03,
	1.345830e+03,
	-4.404710e+03,
	-7.547906e+02,
	1.184581e+03,
	1.450460e+03,
	-3.128602e+03,
	-8.687342e+02,
	9.614427e+02,
	1.542825e+03,
	-7.364928e+03,
	-3.355787e+02,
	7.322318e+02,
	1.619357e+03,
	-9.377841e+03,
	-7.234116e+01,
	4.767442e+02,
	1.678824e+03,
	-6.106783e+03,
	-2.487557e+00,
	1.931677e+02,
	1.715997e+03,
};

double solarDataset360[] = 
{
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.078413e+03,
	7.118205e+01,
	0,
	0,
	4.658139e+03,
	-1.838006e+01,
	1.514489e-01,
	5.208333e-04,
	-1.266691e+04,
	2.223605e+02,
	2.846817e-01,
	1.302083e-03,
	5.376673e+03,
	1.263979e+02,
	1.585011e+00,
	7.812500e-03,
	-6.287382e+03,
	6.310960e+02,
	4.070404e+00,
	2.630208e-02,
	-1.089068e+04,
	1.566596e+03,
	1.304182e+01,
	9.713542e-02,
	-5.578495e+04,
	4.275269e+03,
	3.968016e+01,
	3.502604e-01,
	-7.874206e+04,
	8.041790e+03,
	1.128851e+02,
	1.215885e+00,
	-1.523996e+05,
	1.484058e+04,
	2.762902e+02,
	3.709896e+00,
	-2.545257e+05,
	2.361556e+04,
	6.036183e+02,
	1.011875e+01,
	-2.941122e+05,
	3.066092e+04,
	1.160209e+03,
	2.459557e+01,
	-3.612497e+05,
	3.709042e+04,
	1.969276e+03,
	5.311250e+01,
	-2.820800e+05,
	3.689189e+04,
	3.009049e+03,
	1.034445e+02,
	-3.813699e+05,
	4.027793e+04,
	4.213037e+03,
	1.833859e+02,
	-3.197931e+05,
	3.414742e+04,
	5.485024e+03,
	3.019268e+02,
	-1.923698e+05,
	2.458254e+04,
	6.615509e+03,
	4.632190e+02,
	-2.078027e+05,
	2.080724e+04,
	7.548980e+03,
	6.677510e+02,
	-1.360611e+05,
	1.255134e+04,
	8.240067e+03,
	9.159479e+02,
	-6.729497e+04,
	5.762938e+03,
	8.622622e+03,
	1.202090e+03,
	-9.900171e+04,
	4.710833e+03,
	8.774927e+03,
	1.519642e+03,
	-3.788016e+04,
	-1.223413e+03,
	8.689075e+03,
	1.864136e+03,
	-3.007086e+04,
	-2.674663e+03,
	8.385744e+03,
	2.224184e+03,
	-1.454468e+04,
	-4.149445e+03,
	7.962237e+03,
	2.593449e+03,
	-3.313233e+04,
	-3.256536e+03,
	7.461974e+03,
	2.965295e+03,
	-2.461750e+03,
	-5.667421e+03,
	6.865987e+03,
	3.335167e+03,
	-5.859709e+03,
	-4.818237e+03,
	6.224765e+03,
	3.692920e+03,
	-1.114171e+04,
	-4.055929e+03,
	5.606249e+03,
	4.036827e+03,
	-2.940298e+01,
	-4.599486e+03,
	4.980260e+03,
	4.363959e+03,
	-8.192323e+03,
	-3.332635e+03,
	4.380331e+03,
	4.669007e+03,
	-1.314651e+02,
	-3.690650e+03,
	3.804426e+03,
	4.952310e+03,
	-9.321444e+03,
	-2.355513e+03,
	3.265525e+03,
	5.209421e+03,
	-4.323778e+03,
	-2.664833e+03,
	2.740069e+03,
	5.441705e+03,
	-4.030446e+03,
	-2.268601e+03,
	2.225562e+03,
	5.643180e+03,
	-7.709530e+03,
	-1.532269e+03,
	1.753678e+03,
	5.813184e+03,
	-9.915496e+03,
	-1.081222e+03,
	1.297245e+03,
	5.951777e+03,
	-1.918399e+04,
	1.650147e+02,
	8.356870e+02,
	6.055439e+03,
	-9.182623e+03,
	-1.363456e+02,
	3.168424e+02,
	6.120820e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.007459e+06,
	1.920534e+03,
	0,
	0,
	4.479837e+05,
	-7.065871e+02,
	0,
	2.604167e-04,
	0,
	0,
	0,
	0,
	-4.964101e+04,
	1.630114e+02,
	0,
	0,
	2.106646e+04,
	-9.205597e+01,
	0,
	2.604167e-04,
	0,
	0,
	0,
	0,
	-1.305437e+04,
	1.325834e+02,
	0,
	0,
	7.455004e+03,
	-2.985865e+01,
	3.840792e-01,
	1.562500e-03,
	-2.055425e+04,
	4.505399e+02,
	7.714470e-01,
	4.166667e-03,
	1.086675e+04,
	2.797690e+02,
	4.050099e+00,
	2.395833e-02,
	-1.873506e+04,
	1.575040e+03,
	1.070445e+01,
	8.072917e-02,
	-4.327245e+04,
	3.801002e+03,
	3.540976e+01,
	3.059896e-01,
	-1.102894e+05,
	8.242103e+03,
	1.027385e+02,
	1.085156e+00,
	-7.645743e+04,
	1.218373e+04,
	2.565037e+02,
	3.423437e+00,
	-3.095499e+05,
	2.422173e+04,
	5.541844e+02,
	9.238802e+00,
	-1.908061e+05,
	2.675484e+04,
	1.088555e+03,
	2.286589e+01,
	-3.934663e+05,
	3.821301e+04,
	1.856451e+03,
	4.946328e+01,
	-3.390953e+05,
	3.834252e+04,
	2.902994e+03,
	9.776536e+01,
	-3.420266e+05,
	3.790490e+04,
	4.089229e+03,
	1.755013e+02,
	-2.686944e+05,
	3.228911e+04,
	5.315213e+03,
	2.902633e+02,
	-2.564538e+05,
	2.755072e+04,
	6.453482e+03,
	4.467523e+02,
	-1.509348e+05,
	1.825991e+04,
	7.399666e+03,
	6.475846e+02,
	-1.630120e+05,
	1.453409e+04,
	8.097017e+03,
	8.903924e+02,
	-9.950958e+04,
	7.104934e+03,
	8.521488e+03,
	1.172941e+03,
	-2.923012e+04,
	1.025880e+03,
	8.643788e+03,
	1.487047e+03,
	-8.585662e+04,
	2.418502e+03,
	8.589889e+03,
	1.824949e+03,
	-1.614087e+04,
	-3.639570e+03,
	8.338546e+03,
	2.183701e+03,
	-2.320497e+04,
	-3.485113e+03,
	7.912837e+03,
	2.550157e+03,
	-2.187702e+04,
	-3.972423e+03,
	7.416360e+03,
	2.920199e+03,
	-1.034810e+04,
	-4.884562e+03,
	6.835820e+03,
	3.287367e+03,
	-2.759089e+03,
	-5.058797e+03,
	6.209527e+03,
	3.644522e+03,
	-9.328274e+03,
	-4.074038e+03,
	5.594421e+03,
	3.987341e+03,
	-4.936422e+03,
	-4.126474e+03,
	4.986817e+03,
	4.314099e+03,
	-3.321617e+03,
	-3.792265e+03,
	4.386012e+03,
	4.620225e+03,
	-1.003521e+04,
	-2.819991e+03,
	3.816137e+03,
	4.903331e+03,
	2.907803e+03,
	-3.685267e+03,
	3.246729e+03,
	5.162089e+03,
	-7.981799e+03,
	-2.001596e+03,
	2.732990e+03,
	5.390627e+03,
	-8.279987e+03,
	-1.868805e+03,
	2.254065e+03,
	5.593927e+03,
	-5.136369e+03,
	-1.945934e+03,
	1.758273e+03,
	5.766632e+03,
	-9.493658e+03,
	-1.095077e+03,
	1.289392e+03,
	5.904171e+03,
	-1.816478e+04,
	8.782733e+01,
	8.362875e+02,
	6.007321e+03,
	-1.016501e+04,
	-5.757161e+01,
	3.316172e+02,
	6.072978e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.106646e+04,
	9.205597e+01,
	0,
	0,
	9.951134e+03,
	-5.583492e+01,
	0,
	2.604167e-04,
	-6.862369e+03,
	7.979095e+01,
	0,
	0,
	3.093701e+03,
	1.042453e+01,
	2.962179e-01,
	1.041667e-03,
	-3.848975e+03,
	1.884300e+02,
	7.173252e-01,
	3.645833e-03,
	-1.922464e+03,
	4.118046e+02,
	2.755566e+00,
	1.614583e-02,
	-1.029728e+04,
	1.238807e+03,
	9.037110e+00,
	6.432292e-02,
	-5.326510e+04,
	3.551966e+03,
	2.965222e+01,
	2.510417e-01,
	-5.119148e+04,
	6.178442e+03,
	8.801668e+01,
	9.252604e-01,
	-1.102076e+05,
	1.208818e+04,
	2.178717e+02,
	2.875260e+00,
	-2.455519e+05,
	2.133109e+04,
	4.927790e+02,
	8.033333e+00,
	-2.314605e+05,
	2.675653e+04,
	9.837470e+02,
	2.021667e+01,
	-3.383926e+05,
	3.503899e+04,
	1.713479e+03,
	4.473359e+01,
	-3.279210e+05,
	3.710837e+04,
	2.699082e+03,
	8.941484e+01,
	-3.295655e+05,
	3.695410e+04,
	3.847503e+03,
	1.622500e+02,
	-2.654830e+05,
	3.200589e+04,
	5.049391e+03,
	2.708594e+02,
	-2.374300e+05,
	2.701443e+04,
	6.179434e+03,
	4.202516e+02,
	-1.686326e+05,
	1.951749e+04,
	7.141543e+03,
	6.132620e+02,
	-1.530711e+05,
	1.439417e+04,
	7.865806e+03,
	8.487388e+02,
	-8.333989e+04,
	7.055607e+03,
	8.314596e+03,
	1.123732e+03,
	-8.130111e+04,
	4.141743e+03,
	8.497304e+03,
	1.431033e+03,
	-3.575768e+04,
	-5.696968e+02,
	8.448170e+03,
	1.764856e+03,
	-3.255295e+04,
	-1.826416e+03,
	8.210999e+03,
	2.116095e+03,
	-3.660834e+04,
	-2.550753e+03,
	7.848763e+03,
	2.478988e+03,
	-7.337777e+03,
	-5.008166e+03,
	7.349120e+03,
	2.846617e+03,
	-5.379678e+03,
	-4.784496e+03,
	6.777142e+03,
	3.209571e+03,
	-2.374637e+04,
	-3.331316e+03,
	6.206260e+03,
	3.564630e+03,
	1.080518e+04,
	-5.854954e+03,
	5.579585e+03,
	3.908975e+03,
	-1.909992e+04,
	-2.668851e+03,
	4.981595e+03,
	4.232768e+03,
	1.911058e+03,
	-4.437068e+03,
	4.390299e+03,
	4.540824e+03,
	-3.848120e+03,
	-3.213454e+03,
	3.806091e+03,
	4.822876e+03,
	-9.851976e+03,
	-2.361374e+03,
	3.277626e+03,
	5.081202e+03,
	-1.578794e+03,
	-2.943684e+03,
	2.741918e+03,
	5.314140e+03,
	-5.601199e+03,
	-2.034313e+03,
	2.236027e+03,
	5.515390e+03,
	-8.507381e+03,
	-1.484607e+03,
	1.769983e+03,
	5.687009e+03,
	-8.981222e+03,
	-1.217297e+03,
	1.303053e+03,
	5.826869e+03,
	-1.807778e+04,
	6.647867e+01,
	8.405294e+02,
	5.930647e+03,
	-1.028919e+04,
	-5.100950e+01,
	3.341801e+02,
	5.996596e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.528365e+03,
	1.907311e+01,
	0,
	0,
	1.516070e+03,
	1.652342e+00,
	7.814024e-02,
	2.604167e-04,
	-1.566422e+04,
	2.938113e+02,
	2.450638e-01,
	1.041667e-03,
	9.323103e+03,
	7.951170e+01,
	2.065634e+00,
	1.145833e-02,
	-7.689699e+03,
	8.647270e+02,
	5.179331e+00,
	3.828125e-02,
	-4.120250e+04,
	2.746625e+03,
	1.943548e+01,
	1.575521e-01,
	-5.390461e+04,
	5.341204e+03,
	6.456184e+01,
	6.408854e-01,
	-1.009697e+05,
	1.038629e+04,
	1.723484e+02,
	2.164844e+00,
	-1.920166e+05,
	1.804640e+04,
	4.048162e+02,
	6.370052e+00,
	-2.372478e+05,
	2.492915e+04,
	8.320197e+02,
	1.654844e+01,
	-2.793231e+05,
	3.114679e+04,
	1.491609e+03,
	3.777448e+01,
	-3.104765e+05,
	3.519482e+04,
	2.392658e+03,
	7.703568e+01,
	-3.177075e+05,
	3.568983e+04,
	3.482617e+03,
	1.424852e+02,
	-2.494221e+05,
	3.108444e+04,
	4.644386e+03,
	2.418099e+02,
	-2.364069e+05,
	2.715189e+04,
	5.759209e+03,
	3.802539e+02,
	-1.404746e+05,
	1.898809e+04,
	6.731675e+03,
	5.613974e+02,
	-2.017016e+05,
	1.743282e+04,
	7.504484e+03,
	7.844820e+02,
	-4.320413e+04,
	5.367012e+03,
	7.992650e+03,
	1.048910e+03,
	-9.571801e+04,
	5.908238e+03,
	8.211533e+03,
	1.344214e+03,
	-3.686322e+04,
	6.522573e+01,
	8.234419e+03,
	1.668699e+03,
	-4.436791e+04,
	-8.088656e+02,
	8.044739e+03,
	2.011998e+03,
	-2.002588e+04,
	-3.383672e+03,
	7.702298e+03,
	2.368391e+03,
	-1.741256e+04,
	-3.854559e+03,
	7.237658e+03,
	2.728893e+03,
	-7.888695e+03,
	-4.546112e+03,
	6.704484e+03,
	3.087804e+03,
	-6.588850e+03,
	-4.351038e+03,
	6.137185e+03,
	3.439195e+03,
	-1.547834e+04,
	-3.487809e+03,
	5.565533e+03,
	3.779451e+03,
	3.267247e+03,
	-4.786579e+03,
	4.960190e+03,
	4.105218e+03,
	-6.089460e+03,
	-3.295662e+03,
	4.377885e+03,
	4.409076e+03,
	-1.218322e+04,
	-2.582626e+03,
	3.837023e+03,
	4.693073e+03,
	3.616890e+03,
	-3.794143e+03,
	3.268057e+03,
	4.953780e+03,
	-9.102661e+03,
	-1.913822e+03,
	2.750126e+03,
	5.183632e+03,
	-6.696343e+03,
	-2.063778e+03,
	2.263473e+03,
	5.388297e+03,
	-3.048448e+03,
	-2.093974e+03,
	1.768789e+03,
	5.561364e+03,
	-1.551802e+04,
	-4.318095e+02,
	1.323227e+03,
	5.700141e+03,
	-1.234976e+04,
	-6.368560e+02,
	8.363357e+02,
	5.807329e+03,
	-9.311490e+03,
	-1.488186e+02,
	3.568924e+02,
	5.871500e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.492148e+03,
	2.451223e+01,
	0,
	0,
	1.641003e+03,
	8.115125e+00,
	1.339882e-01,
	5.208333e-04,
	-1.214574e+04,
	3.860017e+02,
	4.756144e-01,
	2.343750e-03,
	-1.064944e+04,
	7.243819e+02,
	4.335378e+00,
	2.500000e-02,
	-6.266723e+03,
	1.498871e+03,
	1.515545e+01,
	1.213542e-01,
	-4.724146e+04,
	4.315847e+03,
	4.553783e+01,
	4.554687e-01,
	-8.443089e+04,
	8.583278e+03,
	1.309248e+02,
	1.597396e+00,
	-1.541231e+05,
	1.527165e+04,
	3.224487e+02,
	4.907813e+00,
	-2.382286e+05,
	2.297833e+04,
	6.902681e+02,
	1.323568e+01,
	-2.235609e+05,
	2.735690e+04,
	1.279864e+03,
	3.133542e+01,
	-2.906342e+05,
	3.320621e+04,
	2.096545e+03,
	6.539010e+01,
	-3.123834e+05,
	3.467834e+04,
	3.128177e+03,
	1.236672e+02,
	-2.393461e+05,
	3.025589e+04,
	4.250709e+03,
	2.140122e+02,
	-2.028333e+05,
	2.609503e+04,
	5.342867e+03,
	3.417609e+02,
	-2.151191e+05,
	2.250055e+04,
	6.337131e+03,
	5.109326e+02,
	-9.763169e+04,
	1.271519e+04,
	7.112202e+03,
	7.229203e+02,
	-1.312211e+05,
	1.094586e+04,
	7.636174e+03,
	9.727784e+02,
	-3.907836e+04,
	2.892178e+03,
	7.911983e+03,
	1.258277e+03,
	-5.691819e+04,
	2.234234e+03,
	7.958878e+03,
	1.569822e+03,
	-4.605984e+04,
	-2.949351e+02,
	7.845258e+03,
	1.903886e+03,
	-9.288844e+03,
	-3.584873e+03,
	7.538797e+03,
	2.252188e+03,
	-3.275040e+04,
	-2.362390e+03,
	7.129354e+03,
	2.605553e+03,
	7.240576e+03,
	-5.434321e+03,
	6.628154e+03,
	2.960763e+03,
	-2.435119e+04,
	-2.700395e+03,
	6.099256e+03,
	3.307801e+03,
	-3.407342e+03,
	-4.548247e+03,
	5.539707e+03,
	3.647942e+03,
	-4.437134e+03,
	-3.961614e+03,
	4.941027e+03,
	3.970917e+03,
	-3.090062e+03,
	-3.635715e+03,
	4.368076e+03,
	4.274897e+03,
	-6.315304e+03,
	-2.954206e+03,
	3.823070e+03,
	4.557586e+03,
	-5.534764e+03,
	-2.764660e+03,
	3.293166e+03,
	4.817570e+03,
	-7.186551e+03,
	-2.326088e+03,
	2.771736e+03,
	5.051273e+03,
	-2.914677e+03,
	-2.446875e+03,
	2.255978e+03,
	5.256005e+03,
	-7.073055e+03,
	-1.589272e+03,
	1.777935e+03,
	5.427988e+03,
	-1.092444e+04,
	-9.714652e+02,
	1.326496e+03,
	5.568739e+03,
	-1.803434e+04,
	5.807577e+00,
	8.590316e+02,
	5.675268e+03,
	-1.059246e+04,
	-4.287520e+01,
	3.420559e+02,
	5.742487e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-5.109094e+03,
	3.580031e+01,
	0,
	0,
	2.803934e+03,
	-2.399769e+01,
	0,
	2.604167e-04,
	-3.970877e+03,
	8.834116e+01,
	0,
	0,
	-5.636564e+02,
	1.192399e+02,
	6.512142e-01,
	2.864583e-03,
	-6.086357e+02,
	3.883172e+02,
	2.468692e+00,
	1.562500e-02,
	-2.893914e+04,
	1.718661e+03,
	9.629309e+00,
	7.291667e-02,
	-2.076572e+04,
	3.183627e+03,
	3.674586e+01,
	3.437500e-01,
	-1.011023e+05,
	8.189104e+03,
	1.062582e+02,
	1.252344e+00,
	-1.095898e+05,
	1.282006e+04,
	2.767597e+02,
	4.090625e+00,
	-2.297269e+05,
	2.151665e+04,
	6.004328e+02,
	1.125651e+01,
	-2.107325e+05,
	2.568211e+04,
	1.146269e+03,
	2.735495e+01,
	-2.800842e+05,
	3.166650e+04,
	1.911957e+03,
	5.823177e+01,
	-2.923688e+05,
	3.303608e+04,
	2.891607e+03,
	1.118773e+02,
	-2.033237e+05,
	2.870850e+04,
	3.969933e+03,
	1.959010e+02,
	-2.617431e+05,
	2.851329e+04,
	5.055149e+03,
	3.158836e+02,
	-1.440848e+05,
	1.921772e+04,
	6.043374e+03,
	4.774372e+02,
	-1.420361e+05,
	1.553418e+04,
	6.820003e+03,
	6.792667e+02,
	-9.006131e+04,
	9.284458e+03,
	7.382916e+03,
	9.207971e+02,
	-7.093812e+04,
	5.455005e+03,
	7.700927e+03,
	1.196878e+03,
	-3.964068e+04,
	1.575567e+03,
	7.802084e+03,
	1.502182e+03,
	-7.280366e+04,
	1.632438e+03,
	7.724594e+03,
	1.829778e+03,
	1.690897e+04,
	-5.252913e+03,
	7.429101e+03,
	2.174115e+03,
	-4.574865e+04,
	-9.598807e+02,
	7.041073e+03,
	2.521259e+03,
	2.816103e+03,
	-5.134375e+03,
	6.581128e+03,
	2.873876e+03,
	-1.565202e+04,
	-3.351712e+03,
	6.045391e+03,
	3.218518e+03,
	-2.906298e+03,
	-4.297581e+03,
	5.498150e+03,
	3.555040e+03,
	-9.963636e+03,
	-3.361737e+03,
	4.936026e+03,
	3.876524e+03,
	-2.334266e+02,
	-3.922430e+03,
	4.370841e+03,
	4.181196e+03,
	-1.330539e+04,
	-2.367708e+03,
	3.827009e+03,
	4.463648e+03,
	2.006252e+03,
	-3.636281e+03,
	3.271498e+03,
	4.724332e+03,
	-6.128696e+03,
	-2.215009e+03,
	2.749376e+03,
	4.954650e+03,
	-5.894247e+03,
	-2.020601e+03,
	2.272207e+03,
	5.158856e+03,
	-8.330230e+03,
	-1.530492e+03,
	1.802163e+03,
	5.333464e+03,
	-8.185462e+03,
	-1.311486e+03,
	1.331275e+03,
	5.475951e+03,
	-2.089177e+04,
	3.374858e+02,
	8.719856e+02,
	5.582192e+03,
	-9.930639e+03,
	-1.239258e+02,
	3.378337e+02,
	5.651177e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-5.109094e+03,
	3.580031e+01,
	0,
	0,
	2.803934e+03,
	-2.399769e+01,
	0,
	2.604167e-04,
	-5.944797e+02,
	2.075013e+01,
	0,
	0,
	-4.117657e+03,
	1.320064e+02,
	2.004808e-01,
	7.812500e-04,
	2.833792e+03,
	1.774131e+02,
	1.527515e+00,
	8.854167e-03,
	-2.276165e+04,
	1.257648e+03,
	5.629040e+00,
	4.140625e-02,
	-1.581115e+04,
	2.383463e+03,
	2.490926e+01,
	2.221354e-01,
	-8.271046e+04,
	6.514143e+03,
	7.682795e+01,
	8.695312e-01,
	-7.892773e+04,
	1.023660e+04,
	2.110950e+02,
	3.012500e+00,
	-1.833413e+05,
	1.835639e+04,
	4.760003e+02,
	8.611719e+00,
	-2.594243e+05,
	2.515475e+04,
	9.535555e+02,
	2.177422e+01,
	-1.626629e+05,
	2.553274e+04,
	1.641990e+03,
	4.828620e+01,
	-3.138765e+05,
	3.311180e+04,
	2.521424e+03,
	9.437135e+01,
	-2.023791e+05,
	2.790945e+04,
	3.566488e+03,
	1.692937e+02,
	-2.361401e+05,
	2.715103e+04,
	4.611801e+03,
	2.781815e+02,
	-1.387146e+05,
	1.936281e+04,
	5.584871e+03,
	4.265570e+02,
	-1.260435e+05,
	1.563798e+04,
	6.386036e+03,
	6.144526e+02,
	-1.326077e+05,
	1.212714e+04,
	7.010195e+03,
	8.421141e+02,
	-3.897682e+04,
	3.959405e+03,
	7.366325e+03,
	1.106369e+03,
	-5.889334e+04,
	3.350540e+03,
	7.497170e+03,
	1.398210e+03,
	-3.933554e+04,
	2.719489e+02,
	7.466882e+03,
	1.714702e+03,
	-2.390631e+04,
	-1.853368e+03,
	7.252314e+03,
	2.047736e+03,
	-2.178522e+04,
	-2.640984e+03,
	6.907977e+03,
	2.389698e+03,
	-6.125885e+03,
	-4.003762e+03,
	6.464812e+03,
	2.734296e+03,
	-1.126017e+04,
	-3.477681e+03,
	5.972548e+03,
	3.074501e+03,
	-1.131751e+04,
	-3.475106e+03,
	5.455067e+03,
	3.407229e+03,
	-5.340261e+02,
	-4.136362e+03,
	4.898586e+03,
	3.727215e+03,
	-8.792165e+03,
	-2.990082e+03,
	4.352596e+03,
	4.028768e+03,
	-4.742079e+03,
	-3.169825e+03,
	3.815352e+03,
	4.311590e+03,
	-4.254148e+03,
	-2.851538e+03,
	3.279048e+03,
	4.570477e+03,
	-4.354544e+03,
	-2.480152e+03,
	2.766874e+03,
	4.803165e+03,
	-7.432540e+03,
	-1.878460e+03,
	2.281570e+03,
	5.007989e+03,
	-6.205415e+03,
	-1.788706e+03,
	1.802434e+03,
	5.183474e+03,
	-1.145931e+04,
	-9.481364e+02,
	1.336118e+03,
	5.325439e+03,
	-1.587470e+04,
	-2.321854e+02,
	8.590106e+02,
	5.432634e+03,
	-1.049374e+04,
	-6.518902e+01,
	3.575002e+02,
	5.499596e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-8.531048e+02,
	1.695939e+01,
	0,
	0,
	6.095111e+02,
	9.076932e+00,
	1.122616e-01,
	5.208333e-04,
	-6.857359e+02,
	1.069152e+02,
	3.785397e-01,
	2.343750e-03,
	-6.528912e+03,
	5.478130e+02,
	2.211863e+00,
	1.484375e-02,
	-2.807616e+04,
	1.924054e+03,
	1.181174e+01,
	9.531250e-02,
	-4.135252e+04,
	3.975660e+03,
	4.662733e+01,
	4.854167e-01,
	-6.513897e+04,
	7.571929e+03,
	1.340027e+02,
	1.815104e+00,
	-1.130550e+05,
	1.330006e+04,
	3.248641e+02,
	5.579167e+00,
	-2.128461e+05,
	2.104638e+04,
	6.894764e+02,
	1.487135e+01,
	-1.938231e+05,
	2.394323e+04,
	1.270357e+03,
	3.495443e+01,
	-2.250683e+05,
	2.733125e+04,
	2.036520e+03,
	7.189036e+01,
	-1.878061e+05,
	2.633878e+04,
	2.957468e+03,
	1.331286e+02,
	-2.270545e+05,
	2.650296e+04,
	3.950502e+03,
	2.252544e+02,
	-1.452222e+05,
	1.974198e+04,
	4.908788e+03,
	3.544242e+02,
	-9.739988e+04,
	1.480522e+04,
	5.714679e+03,
	5.215013e+02,
	-1.391311e+05,
	1.365247e+04,
	6.380017e+03,
	7.267320e+02,
	-4.788766e+04,
	5.382256e+03,
	6.821131e+03,
	9.697984e+02,
	-5.285286e+04,
	3.809721e+03,
	7.022384e+03,
	1.241959e+03,
	-3.337682e+04,
	9.042881e+02,
	7.062654e+03,
	1.539764e+03,
	-4.007437e+04,
	-2.699339e+01,
	6.941219e+03,
	1.856429e+03,
	-6.051283e+03,
	-3.209377e+03,
	6.660347e+03,
	2.185851e+03,
	-2.435908e+04,
	-2.124954e+03,
	6.283149e+03,
	2.518370e+03,
	2.551445e+03,
	-4.363071e+03,
	5.832923e+03,
	2.851286e+03,
	-1.489483e+04,
	-2.673771e+03,
	5.352245e+03,
	3.175629e+03,
	-9.389643e+03,
	-3.278006e+03,
	4.853753e+03,
	3.491487e+03,
	3.161923e+03,
	-4.031601e+03,
	4.306797e+03,
	3.791312e+03,
	-1.194090e+04,
	-2.196499e+03,
	3.796276e+03,
	4.069944e+03,
	-2.953957e+03,
	-3.004063e+03,
	3.287319e+03,
	4.329823e+03,
	-6.149918e+03,
	-2.304854e+03,
	2.774682e+03,
	4.562834e+03,
	-3.373794e+03,
	-2.296007e+03,
	2.282599e+03,
	4.768486e+03,
	-1.034299e+04,
	-1.265867e+03,
	1.820241e+03,
	4.943532e+03,
	-1.110375e+04,
	-1.092537e+03,
	1.348590e+03,
	5.088307e+03,
	-1.629907e+04,
	-2.127533e+02,
	8.538122e+02,
	5.195697e+03,
	-1.089887e+04,
	-2.417175e+00,
	3.439132e+02,
	5.261939e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.508513e+01,
	4.753078e+00,
	0,
	0,
	-7.542336e+02,
	4.194538e+01,
	5.820865e-02,
	2.604167e-04,
	-1.284200e+03,
	1.590937e+02,
	6.480504e-01,
	3.906250e-03,
	-7.617453e+03,
	6.908946e+02,
	3.653193e+00,
	2.812500e-02,
	-2.285529e+04,
	2.070239e+03,
	1.729678e+01,
	1.656250e-01,
	-4.265825e+04,
	4.564970e+03,
	6.200908e+01,
	7.559896e-01,
	-8.135927e+04,
	8.796250e+03,
	1.745256e+02,
	2.714323e+00,
	-1.186992e+05,
	1.383851e+04,
	4.094748e+02,
	8.109375e+00,
	-1.729788e+05,
	1.934059e+04,
	8.160818e+02,
	2.061328e+01,
	-1.630315e+05,
	2.150283e+04,
	1.411697e+03,
	4.571406e+01,
	-1.624940e+05,
	2.289915e+04,
	2.160330e+03,
	8.952969e+01,
	-1.678006e+05,
	2.296466e+04,
	3.025299e+03,
	1.588792e+02,
	-1.625820e+05,
	2.081553e+04,
	3.926482e+03,
	2.601164e+02,
	-1.026208e+05,
	1.529805e+04,
	4.748836e+03,
	3.972128e+02,
	-9.110283e+04,
	1.222390e+04,
	5.429607e+03,
	5.703201e+02,
	-7.839298e+04,
	8.798951e+03,
	5.957019e+03,
	7.792841e+02,
	-4.969894e+04,
	4.718760e+03,
	6.285543e+03,
	1.021049e+03,
	-3.394798e+04,
	2.050471e+03,
	6.418885e+03,
	1.289738e+03,
	-2.926526e+04,
	4.598630e+02,
	6.397153e+03,
	1.579698e+03,
	-1.911569e+04,
	-1.195949e+03,
	6.238186e+03,
	1.885275e+03,
	-2.090631e+04,
	-1.729267e+03,
	5.964421e+03,
	2.199667e+03,
	-1.444247e+03,
	-3.487510e+03,
	5.588336e+03,
	2.516915e+03,
	-1.151447e+04,
	-2.536741e+03,
	5.168912e+03,
	2.829230e+03,
	-1.111331e+04,
	-2.723565e+03,
	4.725716e+03,
	3.135111e+03,
	1.710810e+03,
	-3.676459e+03,
	4.229067e+03,
	3.428469e+03,
	-1.164580e+04,
	-2.096150e+03,
	3.746819e+03,
	3.702957e+03,
	-1.692949e+03,
	-2.995892e+03,
	3.257140e+03,
	3.959883e+03,
	-8.118107e+03,
	-2.006853e+03,
	2.767986e+03,
	4.191197e+03,
	-4.383850e+03,
	-2.223397e+03,
	2.285550e+03,
	4.397215e+03,
	-9.697211e+03,
	-1.380502e+03,
	1.813706e+03,
	4.572417e+03,
	-7.068293e+03,
	-1.463914e+03,
	1.337003e+03,
	4.716157e+03,
	-2.122598e+04,
	3.866204e+02,
	8.784811e+02,
	4.822514e+03,
	-1.022737e+04,
	-1.101296e+02,
	3.443440e+02,
	4.892292e+03,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.856739e+02,
	1.195308e+01,
	0,
	0,
	0,
	0,
	0,
	2.604167e-04,
	-1.720472e+02,
	1.507814e+01,
	0,
	2.604167e-04,
	-5.197869e+03,
	2.521753e+02,
	2.669468e-01,
	1.822917e-03,
	-1.789035e+03,
	4.897775e+02,
	4.126558e+00,
	3.411458e-02,
	-2.356297e+04,
	1.990572e+03,
	1.685742e+01,
	1.843750e-01,
	-3.079983e+04,
	3.806333e+03,
	6.218522e+01,
	8.572917e-01,
	-5.867444e+04,
	7.219324e+03,
	1.679956e+02,
	2.980208e+00,
	-9.193536e+04,
	1.140888e+04,
	3.838865e+02,
	8.630729e+00,
	-1.093232e+05,
	1.496515e+04,
	7.495575e+02,
	2.142161e+01,
	-1.454474e+05,
	1.835651e+04,
	1.277678e+03,
	4.640313e+01,
	-1.060384e+05,
	1.738770e+04,
	1.939819e+03,
	8.983255e+01,
	-1.317236e+05,
	1.829440e+04,
	2.673577e+03,
	1.569544e+02,
	-9.918836e+04,
	1.511239e+04,
	3.428617e+03,
	2.536474e+02,
	-6.597280e+04,
	1.172004e+04,
	4.108547e+03,
	3.822750e+02,
	-8.933787e+04,
	1.089011e+04,
	4.698809e+03,
	5.437974e+02,
	-3.303439e+04,
	5.345711e+03,
	5.140684e+03,
	7.388943e+02,
	-4.639993e+04,
	4.646300e+03,
	5.414926e+03,
	9.618318e+02,
	-2.854970e+04,
	1.826186e+03,
	5.551188e+03,
	1.210728e+03,
	-2.483031e+04,
	4.061465e+02,
	5.528659e+03,
	1.478848e+03,
	-1.065058e+04,
	-1.391460e+03,
	5.374176e+03,
	1.760276e+03,
	-7.673933e+03,
	-1.880549e+03,
	5.126809e+03,
	2.047961e+03,
	-1.467883e+04,
	-1.593262e+03,
	4.830964e+03,
	2.337684e+03,
	-7.526978e+03,
	-2.499826e+03,
	4.467952e+03,
	2.625599e+03,
	-4.169590e+03,
	-2.726037e+03,
	4.046171e+03,
	2.904100e+03,
	-4.507799e+03,
	-2.496923e+03,
	3.611144e+03,
	3.168575e+03,
	-6.215844e+03,
	-2.180448e+03,
	3.176433e+03,
	3.416260e+03,
	-9.828176e+03,
	-1.778987e+03,
	2.732565e+03,
	3.644142e+03,
	-2.786098e+03,
	-2.382096e+03,
	2.253500e+03,
	3.847887e+03,
	-6.796697e+03,
	-1.565581e+03,
	1.789222e+03,
	4.020204e+03,
	-1.447871e+04,
	-6.111844e+02,
	1.348581e+03,
	4.162343e+03,
	-1.363735e+04,
	-5.238507e+02,
	8.553840e+02,
	4.271182e+03,
	-9.848364e+03,
	-1.203178e+02,
	3.610664e+02,
	4.337093e+03,
};

double solarDataset400[] = 
{
	1.117129e+12,
	-1.629427e+07,
	-4.340837e+02,
	2.288813e-02,
	-3.507469e+09,
	6.348417e+05,
	0,
	1.628578e-02,
	2.505700e+07,
	-1.230995e+04,
	0,
	1.936688e-02,
	-1.719863e+07,
	2.178956e+04,
	0,
	1.892672e-02,
	1.438988e+06,
	-1.616402e+03,
	6.806146e+00,
	2.332828e-02,
	1.696702e+05,
	1.495455e+03,
	8.179956e+00,
	3.037078e-02,
	-1.912560e+06,
	7.286691e+03,
	1.412411e+01,
	4.753688e-02,
	1.068454e+06,
	-3.820033e+03,
	1.852974e+01,
	9.331313e-02,
	-4.480441e+05,
	7.070752e+03,
	2.347567e+01,
	1.412902e-01,
	-2.844742e+05,
	7.763926e+03,
	5.756619e+01,
	3.045881e-01,
	3.820870e+05,
	5.835991e+03,
	1.114800e+02,
	7.139334e-01,
	-5.903447e+05,
	2.442660e+04,
	2.153938e+02,
	1.610972e+00,
	-2.022151e+05,
	3.048178e+04,
	4.667749e+02,
	4.039754e+00,
	-7.774876e+05,
	5.556041e+04,
	9.199868e+02,
	9.698843e+00,
	-7.414445e+05,
	7.551752e+04,
	1.760381e+03,
	2.266144e+01,
	-1.531201e+06,
	1.128349e+05,
	3.140037e+03,
	4.978959e+01,
	-1.554180e+06,
	1.298094e+05,
	5.235208e+03,
	1.033051e+02,
	-1.695156e+06,
	1.421715e+05,
	7.966732e+03,
	1.984392e+02,
	-1.678161e+06,
	1.399827e+05,
	1.119495e+04,
	3.535841e+02,
	-1.463039e+06,
	1.225635e+05,
	1.457341e+04,
	5.863313e+02,
	-1.215237e+06,
	9.771091e+04,
	1.769675e+04,
	9.092475e+02,
	-8.636409e+05,
	6.734484e+04,
	2.022204e+04,
	1.327606e+03,
	-6.651680e+05,
	4.343026e+04,
	2.196126e+04,
	1.837785e+03,
	-3.857503e+05,
	1.929567e+04,
	2.286749e+04,
	2.430659e+03,
	-3.671416e+05,
	8.823173e+03,
	2.302563e+04,
	3.090578e+03,
	-1.503106e+05,
	-7.693949e+03,
	2.251190e+04,
	3.802935e+03,
	-1.434123e+05,
	-1.080121e+04,
	2.148437e+04,
	4.545612e+03,
	-7.621756e+04,
	-1.576213e+04,
	2.013222e+04,
	5.304807e+03,
	-7.041412e+04,
	-1.599827e+04,
	1.854944e+04,
	6.063558e+03,
	1.247797e+04,
	-1.940579e+04,
	1.683252e+04,
	6.809340e+03,
	-4.230704e+04,
	-1.372257e+04,
	1.516152e+04,
	7.528765e+03,
	-1.341378e+04,
	-1.442508e+04,
	1.354734e+04,
	8.221723e+03,
	1.305159e+04,
	-1.404328e+04,
	1.196086e+04,
	8.877132e+03,
	-3.228613e+04,
	-8.830029e+03,
	1.054343e+04,
	9.490735e+03,
	6.334330e+03,
	-1.081216e+04,
	9.192167e+03,
	1.006662e+04,
	-1.320077e+04,
	-7.485103e+03,
	7.933060e+03,
	1.059296e+04,
	9.474767e+03,
	-8.180859e+03,
	6.789131e+03,
	1.107455e+04,
	-1.394154e+04,
	-4.679057e+03,
	5.796750e+03,
	1.150659e+04,
	-3.468549e+03,
	-5.125712e+03,
	4.894953e+03,
	1.189805e+04,
	-1.168377e+04,
	-3.552944e+03,
	4.047968e+03,
	1.224160e+04,
	-3.595156e+03,
	-3.828358e+03,
	3.246376e+03,
	1.253896e+04,
	-9.636883e+03,
	-2.443091e+03,
	2.519269e+03,
	1.278460e+04,
	-1.695233e+04,
	-1.289283e+03,
	1.854717e+03,
	1.298280e+04,
	-1.903977e+04,
	-6.528410e+02,
	1.170083e+03,
	1.313098e+04,
	-1.350669e+04,
	-1.652916e+02,
	4.953127e+02,
	1.322139e+04,
	1.427101e+11,
	-1.957428e+06,
	-5.973210e+01,
	1.232438e-02,
	-2.505335e+09,
	4.534583e+05,
	0,
	1.144406e-02,
	2.505700e+07,
	-1.230995e+04,
	0,
	1.364484e-02,
	-1.530567e+07,
	1.841817e+04,
	0,
	1.320469e-02,
	1.680202e+06,
	-2.365652e+03,
	4.815713e+00,
	1.672594e-02,
	-1.426389e+06,
	3.973627e+03,
	5.413944e+00,
	2.112750e-02,
	6.318979e+05,
	-1.710393e+03,
	7.350863e+00,
	3.389203e-02,
	-1.473582e+05,
	2.336923e+03,
	8.947389e+00,
	4.841719e-02,
	6.750351e+04,
	2.142457e+03,
	1.881145e+01,
	9.067219e-02,
	-6.137863e+04,
	5.312427e+03,
	3.767319e+01,
	1.945491e-01,
	-2.368579e+05,
	1.056334e+04,
	8.328836e+01,
	4.802105e-01,
	-3.502458e+04,
	1.450254e+04,
	1.806983e+02,
	1.255326e+00,
	-3.536828e+05,
	2.941026e+04,
	3.742713e+02,
	3.159882e+00,
	-5.525650e+05,
	4.829087e+04,
	7.804581e+02,
	7.921052e+00,
	-1.131425e+06,
	7.774385e+04,
	1.543754e+03,
	1.911026e+01,
	-9.674282e+05,
	9.542627e+04,
	2.833425e+03,
	4.364369e+01,
	-1.726176e+06,
	1.303805e+05,
	4.757123e+03,
	9.174177e+01,
	-1.560050e+06,
	1.354377e+05,
	7.402393e+03,
	1.797757e+02,
	-1.659007e+06,
	1.378766e+05,
	1.051897e+04,
	3.248278e+02,
	-1.371101e+06,
	1.198850e+05,
	1.384088e+04,
	5.450543e+02,
	-1.299875e+06,
	1.013112e+05,
	1.696555e+04,
	8.532262e+02,
	-7.373351e+05,
	6.441420e+04,
	1.952739e+04,
	1.256523e+03,
	-6.447884e+05,
	4.627416e+04,
	2.134307e+04,
	1.750144e+03,
	-5.825478e+05,
	2.880250e+04,
	2.244015e+04,
	2.329148e+03,
	-1.914632e+05,
	1.757698e+03,
	2.265971e+04,
	2.980030e+03,
	-2.801179e+05,
	8.443567e+01,
	2.221525e+04,
	3.679473e+03,
	-9.016021e+04,
	-1.353444e+04,
	2.127045e+04,
	4.416034e+03,
	-5.848055e+04,
	-1.550950e+04,
	1.993050e+04,
	5.166405e+03,
	-8.007881e+04,
	-1.426653e+04,
	1.844888e+04,
	5.918714e+03,
	4.462178e+03,
	-1.832929e+04,
	1.682629e+04,
	6.662612e+03,
	-8.309437e+04,
	-1.148821e+04,
	1.520348e+04,
	7.383206e+03,
	4.995264e+04,
	-1.893244e+04,
	1.352107e+04,
	8.078812e+03,
	-3.495005e+04,
	-9.918410e+03,
	1.197260e+04,
	8.729566e+03,
	-2.254439e+03,
	-1.140785e+04,
	1.057610e+04,
	9.348295e+03,
	-1.194317e+04,
	-9.037030e+03,
	9.229099e+03,
	9.923259e+03,
	4.037681e+03,
	-8.955305e+03,
	7.980764e+03,
	1.045434e+04,
	-1.351607e+04,
	-6.061553e+03,
	6.864874e+03,
	1.093757e+04,
	7.338831e+03,
	-6.963548e+03,
	5.837108e+03,
	1.137736e+04,
	-2.292706e+04,
	-3.086934e+03,
	4.940689e+03,
	1.176787e+04,
	4.648356e+03,
	-5.474011e+03,
	4.063248e+03,
	1.211814e+04,
	-1.227871e+04,
	-2.657876e+03,
	3.270644e+03,
	1.241280e+04,
	-8.698683e+03,
	-2.708755e+03,
	2.554663e+03,
	1.266362e+04,
	-1.098022e+04,
	-1.900095e+03,
	1.865115e+03,
	1.286352e+04,
	-2.959044e+04,
	5.140675e+02,
	1.222700e+03,
	1.301222e+04,
	-1.386763e+04,
	-1.800631e+02,
	4.732027e+02,
	1.310906e+04,
	-2.250626e+10,
	2.821518e+05,
	2.735822e+01,
	3.081094e-03,
	1.015964e+08,
	-6.264336e+04,
	1.702289e+01,
	3.521250e-03,
	-1.603967e+07,
	-1.803368e+03,
	6.342924e+00,
	4.841719e-03,
	2.035804e+07,
	-1.947652e+04,
	0,
	6.162188e-03,
	-6.628634e+06,
	1.134906e+04,
	0,
	3.521250e-03,
	5.620458e+05,
	-1.364648e+03,
	1.880042e+00,
	8.362969e-03,
	-3.417573e+05,
	2.062172e+03,
	1.747725e+00,
	1.012359e-02,
	-7.534766e+03,
	8.619116e+02,
	5.863022e+00,
	2.024719e-02,
	8.599540e+04,
	9.720702e+02,
	1.069301e+01,
	4.445578e-02,
	-1.156890e+05,
	3.868880e+03,
	2.157506e+01,
	1.025564e-01,
	7.657473e+04,
	4.835159e+03,
	5.014776e+01,
	2.759780e-01,
	-2.781167e+05,
	1.440504e+04,
	1.128026e+02,
	7.337405e-01,
	-2.634244e+05,
	2.323850e+04,
	2.708874e+02,
	2.091182e+00,
	-5.456420e+05,
	4.153386e+04,
	5.949804e+02,
	5.660850e+00,
	-7.962351e+05,
	6.431258e+04,
	1.232698e+03,
	1.450623e+01,
	-1.197053e+06,
	9.234505e+04,
	2.349153e+03,
	3.449857e+01,
	-1.230918e+06,
	1.114998e+05,
	4.089853e+03,
	7.566110e+01,
	-1.644144e+06,
	1.336157e+05,
	6.498004e+03,
	1.519362e+02,
	-1.555109e+06,
	1.322636e+05,
	9.493547e+03,
	2.818699e+02,
	-1.357583e+06,
	1.188301e+05,
	1.271440e+04,
	4.827603e+02,
	-1.116449e+06,
	9.761383e+04,
	1.581326e+04,
	7.684710e+02,
	-9.139236e+05,
	7.403173e+04,
	1.847437e+04,
	1.146857e+03,
	-6.990817e+05,
	4.906624e+04,
	2.044711e+04,
	1.618387e+03,
	-3.467195e+05,
	2.202997e+04,
	2.157873e+04,
	2.174869e+03,
	-4.305811e+05,
	1.548297e+04,
	2.198860e+04,
	2.801117e+03,
	-1.289765e+05,
	-5.992939e+03,
	2.170495e+04,
	3.485799e+03,
	-1.198868e+05,
	-8.943475e+03,
	2.086422e+04,
	4.204074e+03,
	-1.470410e+05,
	-1.001341e+04,
	1.974012e+04,
	4.944323e+03,
	1.334018e+03,
	-1.882254e+04,
	1.828199e+04,
	5.692294e+03,
	-3.345755e+04,
	-1.481065e+04,
	1.670764e+04,
	6.427177e+03,
	-4.222028e+04,
	-1.336937e+04,
	1.517112e+04,
	7.146100e+03,
	-1.048132e+04,
	-1.430800e+04,
	1.359152e+04,
	7.840347e+03,
	-2.882922e+03,
	-1.287178e+04,
	1.204023e+04,
	8.498728e+03,
	-1.162564e+04,
	-1.046185e+04,
	1.060814e+04,
	9.117565e+03,
	8.458319e+02,
	-9.934087e+03,
	9.276245e+03,
	9.695744e+03,
	-1.175585e+04,
	-7.451056e+03,
	8.062850e+03,
	1.022931e+04,
	3.308565e+02,
	-7.420070e+03,
	6.941772e+03,
	1.071991e+04,
	-1.318812e+04,
	-5.104680e+03,
	5.924005e+03,
	1.116308e+04,
	2.440679e+03,
	-5.803752e+03,
	4.972255e+03,
	1.156184e+04,
	-1.312707e+04,
	-3.300552e+03,
	4.125489e+03,
	1.190999e+04,
	-6.642305e+03,
	-3.582143e+03,
	3.336437e+03,
	1.221449e+04,
	-7.838423e+03,
	-2.777393e+03,
	2.585322e+03,
	1.246768e+04,
	-1.594267e+04,
	-1.412070e+03,
	1.904021e+03,
	1.267038e+04,
	-2.650924e+04,
	5.450457e+01,
	1.222878e+03,
	1.282292e+04,
	-1.407506e+04,
	-1.421113e+02,
	4.719557e+02,
	1.291827e+04,
	0,
	0,
	0,
	0,
	-1.002134e+09,
	1.813833e+05,
	0,
	0,
	2.505700e+07,
	-1.230995e+04,
	0,
	8.803125e-04,
	-3.540684e+06,
	4.422303e+03,
	0,
	4.401563e-04,
	-1.077551e+06,
	1.071832e+03,
	1.320161e+00,
	1.320469e-03,
	4.561374e+05,
	-1.073274e+03,
	0,
	2.640938e-03,
	-1.241178e+05,
	7.309221e+02,
	0,
	1.760625e-03,
	-6.807449e+03,
	4.155531e+02,
	1.415729e+00,
	3.961406e-03,
	-5.892697e+04,
	1.065543e+03,
	3.663583e+00,
	1.144406e-02,
	7.462404e+04,
	7.963727e+02,
	9.161593e+00,
	3.697313e-02,
	-1.449805e+05,
	4.808397e+03,
	2.148746e+01,
	1.047572e-01,
	-7.483031e+04,
	7.438418e+03,
	6.219855e+01,
	3.569667e-01,
	-1.551526e+05,
	1.519258e+04,
	1.534935e+02,
	1.106993e+00,
	-3.869766e+05,
	3.031932e+04,
	3.687213e+02,
	3.258917e+00,
	-7.418804e+05,
	5.270793e+04,
	8.372727e+02,
	9.106833e+00,
	-8.892984e+05,
	7.452028e+04,
	1.720571e+03,
	2.349510e+01,
	-1.173248e+06,
	9.980147e+04,
	3.160816e+03,
	5.468281e+01,
	-1.451666e+06,
	1.199829e+05,
	5.273780e+03,
	1.157149e+02,
	-1.406590e+06,
	1.229404e+05,
	7.982304e+03,
	2.235989e+02,
	-1.256174e+06,
	1.143387e+05,
	1.101269e+04,
	3.956375e+02,
	-1.047141e+06,
	9.726801e+04,
	1.405257e+04,
	6.469126e+02,
	-9.893584e+05,
	7.986424e+04,
	1.679688e+04,
	9.875755e+02,
	-6.207149e+05,
	4.968663e+04,
	1.891915e+04,
	1.421301e+03,
	-4.129199e+05,
	2.877273e+04,
	2.024445e+04,
	1.939607e+03,
	-3.571950e+05,
	1.606478e+04,
	2.087749e+04,
	2.531703e+03,
	-1.930391e+05,
	8.010621e+02,
	2.084215e+04,
	3.184647e+03,
	-1.137334e+05,
	-6.987208e+03,
	2.024103e+04,
	3.879152e+03,
	-9.850133e+04,
	-9.863565e+03,
	1.928338e+04,
	4.599642e+03,
	-9.788409e+04,
	-1.144184e+04,
	1.805974e+04,
	5.332882e+03,
	1.245732e+04,
	-1.762258e+04,
	1.658022e+04,
	6.064098e+03,
	-5.720841e+04,
	-1.160080e+04,
	1.506961e+04,
	6.775777e+03,
	1.067936e+04,
	-1.514209e+04,
	1.355611e+04,
	7.467565e+03,
	-2.175393e+04,
	-1.083518e+04,
	1.208639e+04,
	8.124791e+03,
	-1.089978e+04,
	-1.053521e+04,
	1.070786e+04,
	8.749151e+03,
	1.343549e+03,
	-9.970273e+03,
	9.374791e+03,
	9.333012e+03,
	-1.328865e+04,
	-7.346112e+03,
	8.162598e+03,
	9.872624e+03,
	-1.034417e+03,
	-7.407299e+03,
	7.035667e+03,
	1.036975e+04,
	-5.754438e+03,
	-5.779644e+03,
	6.000216e+03,
	1.081900e+04,
	-9.018099e+03,
	-4.670102e+03,
	5.068244e+03,
	1.122259e+04,
	-9.313739e+02,
	-4.706751e+03,
	4.193278e+03,
	1.157960e+04,
	-1.674258e+04,
	-2.394722e+03,
	3.415508e+03,
	1.188682e+04,
	-4.162404e+03,
	-3.416222e+03,
	2.647810e+03,
	1.214910e+04,
	-1.641018e+04,
	-1.375684e+03,
	1.940197e+03,
	1.235489e+04,
	-2.597781e+04,
	-4.072350e+01,
	1.253613e+03,
	1.251075e+04,
	-1.550160e+04,
	-5.658062e+01,
	4.993210e+02,
	1.260869e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.571821e+05,
	1.194273e+03,
	0,
	0,
	2.280687e+05,
	-5.366371e+02,
	0,
	4.401563e-04,
	-3.880904e+04,
	2.686421e+02,
	0,
	0,
	-1.184002e+05,
	6.513468e+02,
	6.182344e-01,
	8.803125e-04,
	6.120952e+04,
	-2.568675e+02,
	1.398755e+00,
	5.281875e-03,
	-2.456577e+04,
	8.465396e+02,
	2.046431e+00,
	1.012359e-02,
	-5.560163e+04,
	2.207308e+03,
	8.347310e+00,
	3.565266e-02,
	-6.365941e+04,
	4.514850e+03,
	2.810550e+01,
	1.448114e-01,
	-1.150207e+05,
	9.826355e+03,
	8.095553e+01,
	5.281875e-01,
	-2.675326e+05,
	2.088122e+04,
	2.172854e+02,
	1.764146e+00,
	-4.855776e+05,
	3.851471e+04,
	5.397100e+02,
	5.445173e+00,
	-8.721331e+05,
	6.367194e+04,
	1.205217e+03,
	1.524745e+01,
	-9.184539e+05,
	8.282197e+04,
	2.383759e+03,
	3.838735e+01,
	-1.307361e+06,
	1.073647e+05,
	4.170076e+03,
	8.581991e+01,
	-1.216270e+06,
	1.119986e+05,
	6.587459e+03,
	1.736267e+02,
	-1.276352e+06,
	1.124177e+05,
	9.409381e+03,
	3.185987e+02,
	-9.788697e+05,
	9.416016e+04,
	1.235028e+04,
	5.374427e+02,
	-7.995613e+05,
	7.618671e+04,
	1.505625e+04,
	8.403357e+02,
	-7.460602e+05,
	5.950676e+04,
	1.732816e+04,
	1.232937e+03,
	-4.349269e+05,
	3.288320e+04,
	1.890991e+04,
	1.714067e+03,
	-2.903175e+05,
	1.679987e+04,
	1.972389e+04,
	2.270884e+03,
	-2.341700e+05,
	6.717412e+03,
	1.992757e+04,
	2.890724e+03,
	-1.591140e+05,
	-2.541145e+03,
	1.958483e+04,
	3.559598e+03,
	-9.377026e+04,
	-9.049582e+03,
	1.877055e+04,
	4.259945e+03,
	-3.112181e+04,
	-1.324477e+04,
	1.763230e+04,
	4.974656e+03,
	-6.713941e+04,
	-1.097160e+04,
	1.635475e+04,
	5.689683e+03,
	-1.171086e+04,
	-1.418498e+04,
	1.495911e+04,
	6.397430e+03,
	-1.203079e+04,
	-1.259366e+04,
	1.351290e+04,
	7.082987e+03,
	-2.735949e+04,
	-1.036650e+04,
	1.212531e+04,
	7.741638e+03,
	8.398267e+03,
	-1.176714e+04,
	1.074781e+04,
	8.368608e+03,
	-2.360952e+04,
	-7.700526e+03,
	9.466757e+03,
	8.954412e+03,
	3.871276e+03,
	-9.056076e+03,
	8.250344e+03,
	9.502464e+03,
	-6.443405e+03,
	-6.671943e+03,
	7.119198e+03,
	1.000279e+04,
	-7.871410e+03,
	-5.649041e+03,
	6.108047e+03,
	1.045952e+04,
	-8.718557e+03,
	-4.829450e+03,
	5.161480e+03,
	1.087083e+04,
	-1.292495e+03,
	-4.766287e+03,
	4.267365e+03,
	1.123419e+04,
	-9.861345e+03,
	-3.065607e+03,
	3.472933e+03,
	1.154681e+04,
	-1.727524e+04,
	-2.001187e+03,
	2.739962e+03,
	1.181333e+04,
	-9.339880e+03,
	-2.491882e+03,
	1.972342e+03,
	1.202929e+04,
	-2.480383e+04,
	-8.960043e+01,
	1.262307e+03,
	1.218417e+04,
	-1.550976e+04,
	-1.052398e+02,
	5.321763e+02,
	1.228360e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.280687e+05,
	5.366371e+02,
	0,
	0,
	0,
	0,
	0,
	4.401563e-04,
	0,
	0,
	0,
	4.401563e-04,
	-1.733338e+04,
	2.221243e+02,
	0,
	4.401563e-04,
	-1.275858e+04,
	4.042146e+02,
	9.341664e-01,
	2.640938e-03,
	1.648620e+03,
	8.526882e+02,
	3.875433e+00,
	1.452516e-02,
	-1.019729e+05,
	3.723777e+03,
	1.376684e+01,
	6.470297e-02,
	-5.222279e+04,
	6.376447e+03,
	5.040666e+01,
	3.006267e-01,
	-1.972467e+05,
	1.575596e+04,
	1.432681e+02,
	1.097310e+00,
	-4.522255e+05,
	3.224516e+04,
	3.877865e+02,
	3.683668e+00,
	-6.472011e+05,
	5.229836e+04,
	9.287428e+02,
	1.113463e+01,
	-9.846451e+05,
	7.751316e+04,
	1.928807e+03,
	2.951336e+01,
	-1.120147e+06,
	9.516690e+04,
	3.526207e+03,
	6.930084e+01,
	-1.060774e+06,
	1.024968e+05,
	5.698072e+03,
	1.445909e+02,
	-1.080278e+06,
	1.054362e+05,
	8.329768e+03,
	2.717027e+02,
	-1.167184e+06,
	1.012812e+05,
	1.122358e+04,
	4.681035e+02,
	-8.134116e+05,
	7.589663e+04,
	1.397221e+04,
	7.479364e+02,
	-5.142486e+05,
	5.263146e+04,
	1.620649e+04,
	1.114264e+03,
	-5.840860e+05,
	4.293903e+04,
	1.790499e+04,
	1.565472e+03,
	-2.806635e+05,
	1.804160e+04,
	1.892835e+04,
	2.098314e+03,
	-1.902676e+05,
	6.983141e+03,
	1.923705e+04,
	2.694941e+03,
	-2.082007e+05,
	2.150441e+03,
	1.906114e+04,
	3.342563e+03,
	-5.374742e+04,
	-9.636906e+03,
	1.839341e+04,
	4.027727e+03,
	-9.427047e+04,
	-8.455175e+03,
	1.739289e+04,
	4.729183e+03,
	-1.263315e+04,
	-1.383242e+04,
	1.618343e+04,
	5.437924e+03,
	-5.405956e+04,
	-1.051530e+04,
	1.486152e+04,
	6.137134e+03,
	4.123323e+03,
	-1.373276e+04,
	1.347434e+04,
	6.821774e+03,
	-1.966848e+04,
	-1.038438e+04,
	1.209746e+04,
	7.477629e+03,
	-1.751199e+04,
	-9.652355e+03,
	1.078686e+04,
	8.104279e+03,
	3.295847e+03,
	-1.002127e+04,
	9.489445e+03,
	8.694407e+03,
	-1.938731e+03,
	-7.963785e+03,
	8.293167e+03,
	9.241338e+03,
	-2.615570e+04,
	-5.085764e+03,
	7.230361e+03,
	9.747489e+03,
	1.004382e+04,
	-7.737635e+03,
	6.157052e+03,
	1.021296e+04,
	-1.151870e+04,
	-4.264058e+03,
	5.190961e+03,
	1.062368e+04,
	-5.395239e+03,
	-4.360268e+03,
	4.334166e+03,
	1.099135e+04,
	-1.187237e+04,
	-3.068215e+03,
	3.525120e+03,
	1.130985e+04,
	-8.828785e+03,
	-2.951184e+03,
	2.748294e+03,
	1.157956e+04,
	-1.425606e+04,
	-1.790576e+03,
	2.012464e+03,
	1.179469e+04,
	-3.104649e+04,
	4.096561e+02,
	1.304758e+03,
	1.195543e+04,
	-1.414188e+04,
	-2.345618e+02,
	4.929940e+02,
	1.205795e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.284378e+03,
	4.000235e+01,
	0,
	0,
	-1.596943e+04,
	2.327633e+02,
	2.033762e-01,
	4.401563e-04,
	1.547436e+04,
	9.728437e+01,
	1.332585e+00,
	4.841719e-03,
	-4.391863e+04,
	1.611874e+03,
	3.954053e+00,
	1.848656e-02,
	-1.774277e+04,
	3.338879e+03,
	1.984506e+01,
	1.069580e-01,
	-2.636354e+05,
	1.231744e+04,
	7.035266e+01,
	4.762491e-01,
	-1.523250e+05,
	1.881496e+04,
	2.323194e+02,
	2.013715e+00,
	-5.937322e+05,
	4.171430e+04,
	5.875574e+02,
	6.570653e+00,
	-7.266381e+05,
	6.055013e+04,
	1.349311e+03,
	1.917673e+01,
	-8.860678e+05,
	8.010778e+04,
	2.622440e+03,
	4.815926e+01,
	-1.086569e+06,
	9.639717e+04,
	4.493415e+03,
	1.062836e+02,
	-9.745768e+05,
	9.666372e+04,
	6.884892e+03,
	2.100144e+02,
	-1.047773e+06,
	9.496512e+04,
	9.556296e+03,
	3.754075e+02,
	-6.732150e+05,
	7.257512e+04,
	1.219959e+04,
	6.172408e+02,
	-6.412646e+05,
	6.073496e+04,
	1.451547e+04,
	9.412046e+02,
	-4.770761e+05,
	4.172546e+04,
	1.637709e+04,
	1.351410e+03,
	-3.658491e+05,
	2.573258e+04,
	1.759304e+04,
	1.842114e+03,
	-1.459050e+05,
	7.797252e+03,
	1.813296e+04,
	2.402150e+03,
	-2.270501e+05,
	6.345087e+03,
	1.816235e+04,
	3.015249e+03,
	-5.163556e+04,
	-7.248933e+03,
	1.772472e+04,
	3.672398e+03,
	-9.784000e+04,
	-6.113061e+03,
	1.692069e+04,
	4.351479e+03,
	-4.721276e+04,
	-1.058933e+04,
	1.588911e+04,
	5.044252e+03,
	-2.325812e+04,
	-1.187676e+04,
	1.464898e+04,
	5.733633e+03,
	-7.615191e+03,
	-1.186838e+04,
	1.334468e+04,
	6.408326e+03,
	-2.309797e+04,
	-9.681961e+03,
	1.206642e+04,
	7.060851e+03,
	-1.619285e+04,
	-9.482512e+03,
	1.080185e+04,
	7.687342e+03,
	2.078178e+03,
	-9.714292e+03,
	9.537486e+03,
	8.279170e+03,
	-1.618945e+04,
	-6.927762e+03,
	8.365159e+03,
	8.829938e+03,
	7.335199e+02,
	-7.533587e+03,
	7.255793e+03,
	9.341236e+03,
	-1.450326e+03,
	-6.043556e+03,
	6.228118e+03,
	9.805634e+03,
	-1.816953e+04,
	-3.758371e+03,
	5.326053e+03,
	1.022606e+04,
	-1.744599e+03,
	-5.007206e+03,
	4.429541e+03,
	1.060407e+04,
	-1.013527e+04,
	-3.265815e+03,
	3.587398e+03,
	1.092797e+04,
	-1.259356e+04,
	-2.582008e+03,
	2.814548e+03,
	1.120259e+04,
	-1.274805e+04,
	-2.097313e+03,
	2.054883e+03,
	1.142390e+04,
	-2.791789e+04,
	7.523855e+01,
	1.329347e+03,
	1.158716e+04,
	-1.719612e+04,
	-4.713965e+00,
	5.420132e+02,
	1.169180e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.176421e+02,
	3.113526e+01,
	0,
	0,
	-1.800870e+04,
	5.044997e+02,
	2.852090e-01,
	8.803125e-04,
	-6.298356e+03,
	1.097487e+03,
	4.660042e+00,
	2.068734e-02,
	-8.791947e+04,
	4.920687e+03,
	2.117041e+01,
	1.267650e-01,
	-1.511792e+05,
	1.141104e+04,
	9.051543e+01,
	6.901650e-01,
	-3.106193e+05,
	2.415462e+04,
	2.850943e+02,
	2.830205e+00,
	-5.405713e+05,
	4.217464e+04,
	7.415631e+02,
	9.508255e+00,
	-5.706933e+05,
	5.709472e+04,
	1.607830e+03,
	2.680684e+01,
	-8.596668e+05,
	7.785137e+04,
	2.987113e+03,
	6.433676e+01,
	-8.771786e+05,
	8.485822e+04,
	4.935285e+03,
	1.368477e+02,
	-8.102174e+05,
	8.281917e+04,
	7.255334e+03,
	2.600694e+02,
	-6.674694e+05,
	7.297462e+04,
	9.707332e+03,
	4.485879e+02,
	-6.717545e+05,
	6.389033e+04,
	1.205217e+04,
	7.132714e+02,
	-3.554819e+05,
	4.055708e+04,
	1.401631e+04,
	1.060593e+03,
	-4.167811e+05,
	3.366675e+04,
	1.546312e+04,
	1.485747e+03,
	-1.323838e+05,
	1.206436e+04,
	1.634842e+04,
	1.985782e+03,
	-2.565296e+05,
	1.235833e+04,
	1.671070e+04,
	2.544205e+03,
	-7.754431e+04,
	-2.778930e+03,
	1.659321e+04,
	3.155150e+03,
	-6.065238e+04,
	-5.532359e+03,
	1.601994e+04,
	3.795263e+03,
	-6.016013e+04,
	-6.874641e+03,
	1.523403e+04,
	4.453979e+03,
	-3.842724e+04,
	-9.051155e+03,
	1.424960e+04,
	5.120220e+03,
	-1.505812e+04,
	-1.038403e+04,
	1.311185e+04,
	5.780549e+03,
	-1.932609e+04,
	-9.311433e+03,
	1.192713e+04,
	6.424029e+03,
	-2.567878e+03,
	-9.668649e+03,
	1.073681e+04,
	7.044632e+03,
	-2.137310e+04,
	-7.226824e+03,
	9.588529e+03,
	7.634721e+03,
	-4.048428e+03,
	-8.024655e+03,
	8.455858e+03,
	8.192586e+03,
	-9.345105e+03,
	-6.504380e+03,
	7.358232e+03,
	8.708498e+03,
	1.110868e+03,
	-6.498387e+03,
	6.328846e+03,
	9.181543e+03,
	-1.038927e+04,
	-4.423289e+03,
	5.401265e+03,
	9.607874e+03,
	-8.382929e+03,
	-4.148725e+03,
	4.539967e+03,
	9.991244e+03,
	-1.284061e+04,
	-3.196734e+03,
	3.706702e+03,
	1.032616e+04,
	-7.952644e+03,
	-3.238144e+03,
	2.887171e+03,
	1.060975e+04,
	-2.012766e+04,
	-1.354531e+03,
	2.121075e+03,
	1.083559e+04,
	-2.131326e+04,
	-8.004748e+02,
	1.341130e+03,
	1.100550e+04,
	-1.524196e+04,
	-2.164961e+02,
	5.721496e+02,
	1.110911e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.811733e+03,
	6.623464e+01,
	0,
	0,
	2.568464e+03,
	8.432503e+01,
	5.115023e-01,
	2.200781e-03,
	-2.004794e+04,
	1.119994e+03,
	2.378582e+00,
	1.320469e-02,
	-5.899960e+04,
	3.846531e+03,
	1.815237e+01,
	1.184020e-01,
	-1.105061e+05,
	9.320633e+03,
	8.088947e+01,
	6.950067e-01,
	-2.221620e+05,
	1.985802e+04,
	2.613633e+02,
	2.927919e+00,
	-4.065581e+05,
	3.551385e+04,
	6.885058e+02,
	9.926844e+00,
	-5.094984e+05,
	4.979654e+04,
	1.507612e+03,
	2.812995e+01,
	-6.336678e+05,
	6.263542e+04,
	2.791695e+03,
	6.759920e+01,
	-5.771321e+05,
	6.548998e+04,
	4.520174e+03,
	1.419161e+02,
	-5.870919e+05,
	6.615160e+04,
	6.549199e+03,
	2.651867e+02,
	-5.916423e+05,
	6.099313e+04,
	8.705613e+03,
	4.515611e+02,
	-3.105146e+05,
	4.215730e+04,
	1.068282e+04,
	7.107075e+02,
	-3.690182e+05,
	3.754835e+04,
	1.233110e+04,
	1.043000e+03,
	-2.480750e+05,
	2.322678e+04,
	1.359551e+04,
	1.450970e+03,
	-1.497117e+05,
	1.185092e+04,
	1.431604e+04,
	1.925035e+03,
	-8.514757e+04,
	4.263741e+03,
	1.458441e+04,
	2.453455e+03,
	-1.505205e+05,
	4.067158e+03,
	1.452717e+04,
	3.025317e+03,
	-3.556097e+03,
	-7.629858e+03,
	1.407200e+04,
	3.631602e+03,
	-5.542532e+04,
	-4.547126e+03,
	1.336358e+04,
	4.249173e+03,
	-2.492334e+04,
	-7.511616e+03,
	1.254118e+04,
	4.875408e+03,
	-3.228374e+04,
	-7.095606e+03,
	1.157333e+04,
	5.495835e+03,
	8.005456e+03,
	-9.642728e+03,
	1.050910e+04,
	6.101611e+03,
	-2.540419e+04,
	-5.998865e+03,
	9.470682e+03,
	6.680639e+03,
	-1.534258e+03,
	-7.644748e+03,
	8.443364e+03,
	7.234962e+03,
	-1.521422e+04,
	-5.588894e+03,
	7.427301e+03,
	7.752369e+03,
	2.151713e+03,
	-6.514804e+03,
	6.440484e+03,
	8.232600e+03,
	-1.841369e+04,
	-3.729884e+03,
	5.527030e+03,
	8.667363e+03,
	1.579701e+03,
	-5.323167e+03,
	4.630580e+03,
	9.060834e+03,
	-1.605496e+04,
	-2.666378e+03,
	3.802381e+03,
	9.400648e+03,
	-1.363337e+04,
	-2.777913e+03,
	3.003439e+03,
	9.694207e+03,
	-9.563748e+03,
	-2.638621e+03,
	2.184130e+03,
	9.930046e+03,
	-3.556888e+04,
	7.624686e+02,
	1.440821e+03,
	1.010325e+04,
	-1.690964e+04,
	-1.764955e+02,
	5.681839e+02,
	1.021822e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.643694e+03,
	1.140404e+02,
	0,
	0,
	-6.562979e+03,
	4.816660e+02,
	1.445460e+00,
	7.922813e-03,
	-1.299063e+04,
	1.609270e+03,
	9.594276e+00,
	7.218563e-02,
	-7.131240e+04,
	5.726209e+03,
	4.357593e+01,
	4.150673e-01,
	-1.117634e+05,
	1.180640e+04,
	1.624316e+02,
	1.965298e+00,
	-2.304253e+05,
	2.279086e+04,
	4.523525e+02,
	7.057025e+00,
	-3.315911e+05,
	3.411993e+04,
	1.042647e+03,
	2.092943e+01,
	-3.603710e+05,
	4.191874e+04,
	1.999991e+03,
	5.211274e+01,
	-3.916216e+05,
	4.727670e+04,
	3.311539e+03,
	1.116914e+02,
	-3.844057e+05,
	4.753490e+04,
	4.900611e+03,
	2.125391e+02,
	-3.148316e+05,
	4.217486e+04,
	6.599279e+03,
	3.665476e+02,
	-2.947627e+05,
	3.672338e+04,
	8.238001e+03,
	5.821150e+02,
	-1.877393e+05,
	2.615824e+04,
	9.665892e+03,
	8.644409e+02,
	-1.939038e+05,
	2.109766e+04,
	1.078832e+04,
	1.211959e+03,
	-1.268775e+05,
	1.194889e+04,
	1.155350e+04,
	1.622333e+03,
	-5.212276e+04,
	4.145660e+03,
	1.190591e+04,
	2.084908e+03,
	-1.041510e+05,
	4.464942e+03,
	1.197827e+04,
	2.588510e+03,
	-1.984863e+04,
	-3.569719e+03,
	1.174725e+04,
	3.127176e+03,
	-3.741808e+04,
	-3.091579e+03,
	1.126593e+04,
	3.681872e+03,
	-2.888744e+04,
	-4.650632e+03,
	1.065302e+04,
	4.246808e+03,
	-6.248874e+03,
	-6.533785e+03,
	9.886316e+03,
	4.810160e+03,
	-1.492326e+04,
	-5.462305e+03,
	9.064728e+03,
	5.360728e+03,
	-1.612605e+04,
	-5.277340e+03,
	8.222609e+03,
	5.894540e+03,
	-1.302281e+04,
	-5.381978e+03,
	7.329188e+03,
	6.403576e+03,
	1.844868e+03,
	-6.123135e+03,
	6.402092e+03,
	6.878745e+03,
	-1.598640e+04,
	-3.668586e+03,
	5.540739e+03,
	7.312670e+03,
	-3.218371e+03,
	-4.662379e+03,
	4.696477e+03,
	7.708645e+03,
	-1.404880e+04,
	-2.925585e+03,
	3.881197e+03,
	8.055558e+03,
	-1.463165e+04,
	-2.666220e+03,
	3.081586e+03,
	8.355163e+03,
	-1.277586e+04,
	-2.405669e+03,
	2.258415e+03,
	8.598143e+03,
	-3.742817e+04,
	7.803610e+02,
	1.474543e+03,
	8.777701e+03,
	-1.548654e+04,
	-3.160486e+02,
	5.519917e+02,
	8.894396e+03,
};

double solarDataset440[] = 
{
	-6.439155e+11,
	7.682264e+06,
	1.061520e+03,
	2.039373e+00,
	-1.551568e+09,
	-1.644546e+06,
	7.523669e+02,
	2.056656e+00,
	1.570174e+09,
	-8.522139e+05,
	2.877172e+02,
	2.120770e+00,
	-3.012090e+08,
	4.421119e+05,
	2.347757e+02,
	2.178751e+00,
	-2.081867e+07,
	7.272809e+04,
	4.311484e+02,
	2.430188e+00,
	7.899508e+06,
	1.295109e+04,
	5.150411e+02,
	2.939752e+00,
	4.151745e+06,
	2.883739e+04,
	6.139858e+02,
	3.810026e+00,
	3.293018e+06,
	4.361918e+04,
	7.999407e+02,
	5.335932e+00,
	-3.828120e+06,
	9.429242e+04,
	1.137923e+03,
	8.117909e+00,
	2.986346e+06,
	6.726090e+04,
	1.682654e+03,
	1.349342e+01,
	-1.518315e+06,
	1.401839e+05,
	2.506574e+03,
	2.312609e+01,
	-2.560500e+06,
	1.889565e+05,
	3.957987e+03,
	4.170958e+01,
	-3.827648e+06,
	2.429145e+05,
	6.184460e+03,
	7.682438e+01,
	-3.299120e+06,
	2.716569e+05,
	9.361640e+03,
	1.406772e+02,
	-4.786591e+06,
	3.230548e+05,
	1.360464e+04,
	2.503356e+02,
	-5.235884e+06,
	3.347402e+05,
	1.893351e+04,
	4.303752e+02,
	-4.344959e+06,
	2.992049e+05,
	2.482781e+04,
	7.073441e+02,
	-4.495848e+06,
	2.671507e+05,
	3.067007e+04,
	1.104209e+03,
	-2.904965e+06,
	1.819224e+05,
	3.574947e+04,
	1.639240e+03,
	-2.295257e+06,
	1.245881e+05,
	3.945941e+04,
	2.313019e+03,
	-2.021822e+06,
	7.712727e+04,
	4.169658e+04,
	3.119853e+03,
	-5.892701e+05,
	4.095196e+03,
	4.218370e+04,
	4.041884e+03,
	-1.166644e+06,
	8.504980e+03,
	4.136899e+04,
	5.044736e+03,
	-1.972687e+05,
	-4.070728e+04,
	3.941477e+04,
	6.112839e+03,
	-2.093258e+05,
	-3.893157e+04,
	3.660650e+04,
	7.200837e+03,
	-2.639589e+05,
	-3.598837e+04,
	3.358396e+04,
	8.293512e+03,
	8.246154e+03,
	-4.584505e+04,
	3.026767e+04,
	9.372228e+03,
	-6.438522e+04,
	-3.581717e+04,
	2.697011e+04,
	1.041147e+04,
	-7.353188e+04,
	-3.121684e+04,
	2.387281e+04,
	1.140770e+04,
	5.933961e+04,
	-3.366294e+04,
	2.086077e+04,
	1.235002e+04,
	-3.538054e+04,
	-2.202528e+04,
	1.819119e+04,
	1.322614e+04,
	-2.443121e+04,
	-1.981273e+04,
	1.582620e+04,
	1.404641e+04,
	3.781173e+04,
	-2.036056e+04,
	1.359973e+04,
	1.480309e+04,
	-1.650133e+04,
	-1.256169e+04,
	1.171377e+04,
	1.549140e+04,
	-1.983390e+04,
	-1.069497e+04,
	1.008886e+04,
	1.612572e+04,
	1.056101e+04,
	-1.130558e+04,
	8.546710e+03,
	1.670160e+04,
	-2.713816e+03,
	-7.912829e+03,
	7.207588e+03,
	1.721354e+04,
	-4.452889e+03,
	-6.395793e+03,
	6.078559e+03,
	1.767169e+04,
	-6.835308e+03,
	-5.126471e+03,
	5.077617e+03,
	1.807822e+04,
	-9.922932e+03,
	-4.054774e+03,
	4.171164e+03,
	1.843425e+04,
	-4.659839e+03,
	-3.888745e+03,
	3.322981e+03,
	1.873921e+04,
	-9.547958e+03,
	-2.601152e+03,
	2.562645e+03,
	1.899026e+04,
	-1.701043e+04,
	-1.361229e+03,
	1.872053e+03,
	1.919113e+04,
	-1.872608e+04,
	-7.127307e+02,
	1.172457e+03,
	1.934026e+04,
	-1.350361e+04,
	-1.647467e+02,
	4.949774e+02,
	1.943062e+04,
	2.157451e+11,
	1.943248e+06,
	-2.593158e+02,
	9.505553e-01,
	-7.114316e+10,
	1.371541e+07,
	0,
	9.477677e-01,
	1.280844e+09,
	-7.152589e+05,
	2.024044e+02,
	1.022474e+00,
	-3.379517e+08,
	4.237257e+05,
	1.460656e+02,
	1.057040e+00,
	3.483677e+07,
	-4.170331e+04,
	2.741455e+02,
	1.234886e+00,
	-6.107958e+06,
	4.113951e+04,
	3.019965e+02,
	1.517543e+00,
	6.609522e+06,
	7.210950e+03,
	3.859744e+02,
	2.068921e+00,
	6.293178e+05,
	4.235131e+04,
	5.125775e+02,
	3.017804e+00,
	-8.119125e+05,
	6.395016e+04,
	7.753549e+02,
	4.886021e+00,
	-1.001544e+06,
	8.369718e+04,
	1.219698e+03,
	8.638624e+00,
	2.469002e+05,
	1.020158e+05,
	1.936104e+03,
	1.606076e+01,
	-3.071414e+06,
	1.744496e+05,
	3.124365e+03,
	3.047463e+01,
	-2.398553e+06,
	2.065189e+05,
	5.080502e+03,
	5.904147e+01,
	-4.148108e+06,
	2.720416e+05,
	7.949415e+03,
	1.123456e+02,
	-4.421216e+06,
	3.044491e+05,
	1.197323e+04,
	2.080105e+02,
	-4.886328e+06,
	3.225125e+05,
	1.702702e+04,
	3.685740e+02,
	-4.260302e+06,
	2.983774e+05,
	2.277937e+04,
	6.206306e+02,
	-4.488843e+06,
	2.719539e+05,
	2.864869e+04,
	9.887191e+02,
	-3.035307e+06,
	1.911892e+05,
	3.388554e+04,
	1.492962e+03,
	-2.303207e+06,
	1.301134e+05,
	3.780104e+04,
	2.135924e+03,
	-1.695747e+06,
	7.533493e+04,
	4.024633e+04,
	2.912218e+03,
	-1.131339e+06,
	2.856670e+04,
	4.111774e+04,
	3.805227e+03,
	-7.045700e+05,
	-4.867972e+03,
	4.054360e+04,
	4.789173e+03,
	-3.620224e+05,
	-2.694148e+04,
	3.883948e+04,
	5.834790e+03,
	-4.066279e+05,
	-2.925181e+04,
	3.641435e+04,
	6.913749e+03,
	-1.132796e+05,
	-4.305023e+04,
	3.342235e+04,
	8.003883e+03,
	3.570589e+03,
	-4.331910e+04,
	3.014234e+04,
	9.074909e+03,
	-1.133431e+05,
	-3.225022e+04,
	2.700976e+04,
	1.011271e+04,
	1.186040e+03,
	-3.456607e+04,
	2.396680e+04,
	1.111301e+04,
	-4.979073e+04,
	-2.665824e+04,
	2.106894e+04,
	1.205891e+04,
	1.592532e+04,
	-2.657005e+04,
	1.836669e+04,
	1.294864e+04,
	8.401869e+03,
	-2.123268e+04,
	1.592066e+04,
	1.377255e+04,
	-2.611279e+04,
	-1.551961e+04,
	1.380784e+04,
	1.453477e+04,
	1.246222e+04,
	-1.579531e+04,
	1.187851e+04,
	1.523848e+04,
	-6.658919e+03,
	-1.142901e+04,
	1.017094e+04,
	1.587713e+04,
	1.928404e+03,
	-1.015849e+04,
	8.688190e+03,
	1.645836e+04,
	-1.608648e+04,
	-7.006837e+03,
	7.388582e+03,
	1.698200e+04,
	6.840295e+03,
	-7.868280e+03,
	6.193951e+03,
	1.745255e+04,
	-1.757879e+04,
	-4.203383e+03,
	5.158025e+03,
	1.786403e+04,
	6.926599e+03,
	-5.876158e+03,
	4.203700e+03,
	1.822680e+04,
	-1.598552e+04,
	-2.390669e+03,
	3.390699e+03,
	1.853138e+04,
	-6.027778e+03,
	-3.175285e+03,
	2.640031e+03,
	1.879204e+04,
	-1.851678e+04,
	-1.220782e+03,
	1.930943e+03,
	1.899774e+04,
	-2.290692e+04,
	-3.911046e+02,
	1.218154e+03,
	1.915237e+04,
	-1.519600e+04,
	-2.633004e+01,
	4.835101e+02,
	1.924636e+04,
	-3.704596e+12,
	5.454497e+07,
	1.421905e+03,
	2.926930e-01,
	3.173305e+09,
	-5.743591e+05,
	0,
	3.144359e-01,
	-3.364539e+06,
	6.299289e+03,
	0,
	3.116483e-01,
	-3.980029e+08,
	4.573928e+05,
	3.043542e+00,
	3.122058e-01,
	4.559887e+07,
	-6.916950e+04,
	1.007848e+02,
	3.969474e-01,
	-2.443350e+07,
	8.526024e+04,
	1.065719e+02,
	4.794590e-01,
	5.589237e+06,
	-4.160307e+03,
	1.936915e+02,
	7.621167e-01,
	9.451238e+04,
	2.614347e+04,
	2.558371e+02,
	1.224850e+00,
	3.067526e+04,
	3.723230e+04,
	4.105653e+02,
	2.194361e+00,
	-7.036798e+05,
	5.911092e+04,
	6.903957e+02,
	4.252689e+00,
	-5.513797e+05,
	8.299526e+04,
	1.196595e+03,
	8.696047e+00,
	-2.191497e+06,
	1.345808e+05,
	2.089839e+03,
	1.812299e+01,
	-2.070793e+06,
	1.743475e+05,
	3.623925e+03,
	3.802500e+01,
	-4.038717e+06,
	2.455242e+05,
	6.036923e+03,
	7.762385e+01,
	-3.761674e+06,
	2.746045e+05,
	9.589842e+03,
	1.529898e+02,
	-5.050391e+06,
	3.152332e+05,
	1.422849e+04,
	2.849469e+02,
	-4.033593e+06,
	2.876971e+05,
	1.972387e+04,
	5.007826e+02,
	-3.837058e+06,
	2.611389e+05,
	2.542725e+04,
	8.243544e+02,
	-3.415481e+06,
	2.122601e+05,
	3.081216e+04,
	1.277441e+03,
	-2.263710e+06,
	1.384666e+05,
	3.511626e+04,
	1.870490e+03,
	-1.502418e+06,
	8.143096e+04,
	3.793597e+04,
	2.597510e+03,
	-1.629920e+06,
	5.437166e+04,
	3.934644e+04,
	3.445165e+03,
	-3.463979e+05,
	-1.248103e+04,
	3.915122e+04,
	4.394698e+03,
	-4.796136e+05,
	-1.400399e+04,
	3.778512e+04,
	5.405067e+03,
	-4.525999e+05,
	-2.265499e+04,
	3.581125e+04,
	6.461725e+03,
	-3.180239e+04,
	-4.281554e+04,
	3.309592e+04,
	7.538118e+03,
	-1.696614e+05,
	-3.260128e+04,
	3.010816e+04,
	8.601531e+03,
	2.216761e+03,
	-3.819533e+04,
	2.706857e+04,
	9.643927e+03,
	-5.840964e+04,
	-2.977311e+04,
	2.409090e+04,
	1.064435e+04,
	-5.917126e+04,
	-2.642897e+04,
	2.128022e+04,
	1.159950e+04,
	7.415464e+04,
	-2.984562e+04,
	1.854160e+04,
	1.249835e+04,
	-4.015798e+04,
	-1.708081e+04,
	1.618474e+04,
	1.332958e+04,
	-2.724330e+04,
	-1.610742e+04,
	1.411441e+04,
	1.410972e+04,
	3.392267e+04,
	-1.758161e+04,
	1.211073e+04,
	1.482824e+04,
	-1.941985e+04,
	-1.017686e+04,
	1.041268e+04,
	1.547855e+04,
	-1.295582e+04,
	-9.453817e+03,
	8.939028e+03,
	1.607642e+04,
	1.103183e+04,
	-9.749963e+03,
	7.541593e+03,
	1.661529e+04,
	-1.309367e+04,
	-5.774869e+03,
	6.355166e+03,
	1.709222e+04,
	-6.434020e+03,
	-5.622814e+03,
	5.307434e+03,
	1.751883e+04,
	-4.996029e+03,
	-4.764721e+03,
	4.331959e+03,
	1.788974e+04,
	-4.447507e+03,
	-3.893715e+03,
	3.465440e+03,
	1.820564e+04,
	-1.239499e+04,
	-2.374546e+03,
	2.708845e+03,
	1.846887e+04,
	-1.791766e+04,
	-1.467369e+03,
	1.990862e+03,
	1.868255e+04,
	-2.061413e+04,
	-6.862093e+02,
	1.247688e+03,
	1.884111e+04,
	-1.468218e+04,
	-1.400460e+02,
	5.211565e+02,
	1.893732e+04,
	1.308076e+12,
	-1.882941e+07,
	-5.168990e+02,
	4.404332e-02,
	-8.250594e+09,
	1.493334e+06,
	0,
	3.623818e-02,
	6.347536e+07,
	-3.118404e+04,
	0,
	4.348581e-02,
	-6.744998e+07,
	8.687614e+04,
	0,
	4.237079e-02,
	-1.059940e+06,
	1.737933e+03,
	2.850557e+01,
	6.021112e-02,
	3.873147e+06,
	-6.437214e+03,
	2.864464e+01,
	9.087420e-02,
	-2.038775e+06,
	1.383359e+04,
	3.704050e+01,
	1.349175e-01,
	1.734783e+06,
	9.982716e+02,
	6.829641e+01,
	2.609149e-01,
	-1.300032e+06,
	2.675349e+04,
	1.182804e+02,
	5.112371e-01,
	-4.406929e+05,
	3.149201e+04,
	2.638582e+02,
	1.259974e+00,
	-8.366025e+05,
	5.266660e+04,
	5.292339e+02,
	3.134881e+00,
	-7.924932e+05,
	7.942542e+04,
	1.048528e+03,
	7.713714e+00,
	-2.114312e+06,
	1.343945e+05,
	2.024267e+03,
	1.835492e+01,
	-3.185798e+06,
	1.914041e+05,
	3.782729e+03,
	4.238696e+01,
	-3.032631e+06,
	2.279831e+05,
	6.542534e+03,
	9.240122e+01,
	-4.568244e+06,
	2.833195e+05,
	1.042573e+04,
	1.866350e+02,
	-3.365946e+06,
	2.645481e+05,
	1.535126e+04,
	3.512042e+02,
	-4.471630e+06,
	2.758277e+05,
	2.079988e+04,
	6.104689e+02,
	-2.224000e+06,
	1.886401e+05,
	2.617243e+04,
	9.914146e+02,
	-2.922616e+06,
	1.750678e+05,
	3.076047e+04,
	1.501533e+03,
	-1.487031e+06,
	9.279157e+04,
	3.425527e+04,
	2.152028e+03,
	-1.120184e+06,
	5.413495e+04,
	3.618144e+04,
	2.925201e+03,
	-9.574249e+05,
	2.560661e+04,
	3.684905e+04,
	3.805894e+03,
	-4.688823e+05,
	-8.953231e+03,
	3.622075e+04,
	4.771127e+03,
	-2.008025e+05,
	-2.566219e+04,
	3.456168e+04,
	5.787472e+03,
	-2.845628e+05,
	-2.408577e+04,
	3.238769e+04,
	6.829708e+03,
	-9.819349e+04,
	-3.380507e+04,
	2.980207e+04,
	7.880871e+03,
	-2.605063e+04,
	-3.403133e+04,
	2.695787e+04,
	8.913987e+03,
	-6.318205e+04,
	-2.810438e+04,
	2.417620e+04,
	9.914760e+03,
	-4.302365e+04,
	-2.624841e+04,
	2.148046e+04,
	1.087609e+04,
	6.156530e+04,
	-2.811597e+04,
	1.885622e+04,
	1.178578e+04,
	-7.492135e+04,
	-1.496397e+04,
	1.657837e+04,
	1.263475e+04,
	1.109430e+04,
	-1.929611e+04,
	1.445066e+04,
	1.343597e+04,
	2.424357e+04,
	-1.637395e+04,
	1.244181e+04,
	1.416959e+04,
	-4.234273e+04,
	-8.757096e+03,
	1.078613e+04,
	1.484129e+04,
	2.003718e+04,
	-1.262376e+04,
	9.226693e+03,
	1.546219e+04,
	-1.526070e+04,
	-7.207988e+03,
	7.836505e+03,
	1.601547e+04,
	-1.628001e+03,
	-7.394836e+03,
	6.625916e+03,
	1.651619e+04,
	-7.377006e+03,
	-5.561068e+03,
	5.524485e+03,
	1.695833e+04,
	-6.725890e+03,
	-4.724347e+03,
	4.541853e+03,
	1.734582e+04,
	-4.572217e+03,
	-4.074851e+03,
	3.648060e+03,
	1.767801e+04,
	-1.896547e+04,
	-1.949759e+03,
	2.858043e+03,
	1.795535e+04,
	-1.298453e+04,
	-2.311439e+03,
	2.059357e+03,
	1.818104e+04,
	-2.551484e+04,
	-2.163187e+02,
	1.287627e+03,
	1.834266e+04,
	-1.600338e+04,
	-4.270993e+01,
	5.122679e+02,
	1.844268e+04,
	-1.846467e+11,
	2.613334e+06,
	7.450276e+01,
	3.902573e-03,
	1.667286e+09,
	-3.160544e+05,
	0,
	5.017594e-03,
	-3.902174e+05,
	5.452947e+03,
	-3.446309e+00,
	3.345062e-03,
	-2.708707e+06,
	4.468648e+03,
	0,
	2.787552e-03,
	-1.153853e+06,
	2.969827e+03,
	2.394593e+00,
	3.902573e-03,
	3.457846e+05,
	1.456899e+01,
	4.812851e+00,
	8.362656e-03,
	2.322128e+04,
	1.682256e+03,
	7.411109e+00,
	1.728282e-02,
	-9.250953e+04,
	3.491170e+03,
	1.511058e+01,
	4.181328e-02,
	-1.140402e+04,
	5.499039e+03,
	3.309618e+01,
	1.131746e-01,
	2.602436e+05,
	9.641526e+03,
	7.375697e+01,
	3.133209e-01,
	-1.325523e+06,
	3.732442e+04,
	1.808742e+02,
	8.948042e-01,
	-4.382676e+05,
	4.642239e+04,
	4.773414e+02,
	2.895709e+00,
	-1.636631e+06,
	9.209222e+04,
	1.051141e+03,
	8.195961e+00,
	-2.042284e+06,
	1.355507e+05,
	2.219278e+03,
	2.184828e+01,
	-2.868143e+06,
	1.895901e+05,
	4.230793e+03,
	5.311346e+01,
	-3.378460e+06,
	2.314211e+05,
	7.337166e+03,
	1.178716e+02,
	-3.383704e+06,
	2.485497e+05,
	1.152400e+04,
	2.383223e+02,
	-3.611693e+06,
	2.504024e+05,
	1.651144e+04,
	4.404639e+02,
	-2.710830e+06,
	2.062171e+05,
	2.172585e+04,
	7.505122e+02,
	-2.193920e+06,
	1.640529e+05,
	2.647851e+04,
	1.184719e+03,
	-1.888746e+06,
	1.220847e+05,
	3.038570e+04,
	1.752278e+03,
	-1.180573e+06,
	6.785978e+04,
	3.301593e+04,
	2.451054e+03,
	-9.119347e+05,
	3.479131e+04,
	3.423626e+04,
	3.263083e+03,
	-4.432393e+05,
	6.671025e+02,
	3.418252e+04,
	4.167016e+03,
	-3.338143e+05,
	-1.199384e+04,
	3.313578e+04,
	5.133589e+03,
	-1.979577e+05,
	-2.245575e+04,
	3.142588e+04,
	6.140752e+03,
	-1.443444e+05,
	-2.612535e+04,
	2.924376e+04,
	7.164707e+03,
	-1.039579e+05,
	-2.759601e+04,
	2.677478e+04,
	8.185464e+03,
	6.889591e+03,
	-3.078271e+04,
	2.413897e+04,
	9.184259e+03,
	-7.514438e+04,
	-2.239874e+04,
	2.158917e+04,
	1.014449e+04,
	4.257686e+04,
	-2.654203e+04,
	1.911626e+04,
	1.106395e+04,
	-6.392534e+04,
	-1.575459e+04,
	1.685800e+04,
	1.192695e+04,
	3.833671e+04,
	-2.059340e+04,
	1.473601e+04,
	1.274193e+04,
	-4.175233e+04,
	-1.138346e+04,
	1.282932e+04,
	1.349170e+04,
	1.568732e+04,
	-1.428547e+04,
	1.108599e+04,
	1.418980e+04,
	-1.592132e+04,
	-9.200685e+03,
	9.505594e+03,
	1.482175e+04,
	9.423744e+03,
	-9.833787e+03,
	8.103365e+03,
	1.539779e+04,
	-2.081387e+04,
	-5.508437e+03,
	6.882485e+03,
	1.591251e+04,
	2.938513e+03,
	-6.992832e+03,
	5.751007e+03,
	1.637591e+04,
	-1.006852e+04,
	-4.396123e+03,
	4.730716e+03,
	1.677699e+04,
	-9.845785e+03,
	-3.800704e+03,
	3.824602e+03,
	1.712480e+04,
	-1.466034e+04,
	-2.720469e+03,
	2.967253e+03,
	1.741587e+04,
	-1.131802e+04,
	-2.508277e+03,
	2.133736e+03,
	1.764822e+04,
	-2.788700e+04,
	-1.062039e+01,
	1.368856e+03,
	1.781643e+04,
	-1.738426e+04,
	-4.486282e+01,
	5.656062e+02,
	1.792414e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-4.297648e+06,
	4.111555e+03,
	0,
	0,
	0,
	0,
	0,
	5.575104e-04,
	-5.581082e+05,
	1.781758e+03,
	0,
	5.575104e-04,
	1.843572e+05,
	-3.770991e+02,
	1.469976e+00,
	2.787552e-03,
	-3.952308e+05,
	2.931368e+03,
	2.469540e+00,
	6.132615e-03,
	2.621871e+05,
	-9.011830e+01,
	9.486217e+00,
	2.843303e-02,
	-1.562634e+05,
	6.783349e+03,
	1.981770e+01,
	7.637893e-02,
	-5.987073e+05,
	1.920998e+04,
	7.296369e+01,
	3.010556e-01,
	-4.734045e+05,
	3.233755e+04,
	2.337040e+02,
	1.231541e+00,
	-1.292884e+06,
	6.785280e+04,
	6.097906e+02,
	4.193593e+00,
	-1.682559e+06,
	1.071776e+05,
	1.453400e+03,
	1.287515e+01,
	-2.404541e+06,
	1.584818e+05,
	3.025797e+03,
	3.469778e+01,
	-3.146009e+06,
	2.066665e+05,
	5.619983e+03,
	8.326530e+01,
	-2.709797e+06,
	2.201851e+05,
	9.299217e+03,
	1.789965e+02,
	-3.778700e+06,
	2.492082e+05,
	1.388870e+04,
	3.460623e+02,
	-2.343804e+06,
	1.957822e+05,
	1.893955e+04,
	6.135988e+02,
	-2.283303e+06,
	1.718623e+05,
	2.366783e+04,
	9.972451e+02,
	-1.924180e+06,
	1.288603e+05,
	2.777848e+04,
	1.511863e+03,
	-9.241237e+05,
	6.747835e+04,
	3.065304e+04,
	2.156804e+03,
	-1.086438e+06,
	5.116178e+04,
	3.229492e+04,
	2.915626e+03,
	-4.632157e+05,
	7.870416e+03,
	3.273955e+04,
	3.776818e+03,
	-3.230504e+05,
	-6.985506e+03,
	3.205541e+04,
	4.707586e+03,
	-2.475074e+05,
	-1.596795e+04,
	3.068760e+04,
	5.686358e+03,
	-1.378401e+05,
	-2.375715e+04,
	2.877374e+04,
	6.690937e+03,
	-8.940252e+04,
	-2.589151e+04,
	2.650252e+04,
	7.698058e+03,
	-2.683560e+04,
	-2.716741e+04,
	2.406685e+04,
	8.689683e+03,
	-5.526493e+04,
	-2.270183e+04,
	2.164225e+04,
	9.650765e+03,
	-8.489383e+03,
	-2.300292e+04,
	1.926287e+04,
	1.057381e+04,
	-1.388131e+04,
	-1.936649e+04,
	1.699055e+04,
	1.144637e+04,
	7.094209e+03,
	-1.780787e+04,
	1.489322e+04,
	1.226540e+04,
	-2.836236e+04,
	-1.264700e+04,
	1.301116e+04,
	1.302698e+04,
	2.092988e+04,
	-1.443269e+04,
	1.125648e+04,
	1.373400e+04,
	-2.156834e+04,
	-8.504181e+03,
	9.717555e+03,
	1.437710e+04,
	-6.708749e+03,
	-8.789276e+03,
	8.334151e+03,
	1.496836e+04,
	-1.692188e+03,
	-7.736227e+03,
	7.027454e+03,
	1.549866e+04,
	-4.473494e+03,
	-6.083076e+03,
	5.875349e+03,
	1.596817e+04,
	-1.208879e+04,
	-4.407527e+03,
	4.863871e+03,
	1.638080e+04,
	-8.618245e+03,
	-4.133615e+03,
	3.916455e+03,
	1.673821e+04,
	-8.899190e+03,
	-3.323467e+03,
	3.029126e+03,
	1.703543e+04,
	-1.897729e+04,
	-1.633485e+03,
	2.225304e+03,
	1.727258e+04,
	-3.279575e+04,
	2.298052e+02,
	1.423357e+03,
	1.745072e+04,
	-1.484592e+04,
	-2.882339e+02,
	5.261383e+02,
	1.756148e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-5.090528e+04,
	4.110663e+02,
	0,
	0,
	2.437332e+04,
	1.728558e+02,
	1.098978e+00,
	2.230042e-03,
	-5.251004e+04,
	1.839037e+03,
	3.415254e+00,
	1.003519e-02,
	-1.034817e+05,
	5.494798e+03,
	1.715950e+01,
	6.076864e-02,
	-3.817933e+05,
	1.664499e+04,
	6.975643e+01,
	3.183384e-01,
	-5.260784e+05,
	3.421596e+04,
	2.439328e+02,
	1.452872e+00,
	-1.288699e+06,
	7.236937e+04,
	6.940201e+02,
	5.383321e+00,
	-1.884821e+06,
	1.157847e+05,
	1.715049e+03,
	1.728115e+01,
	-2.068708e+06,
	1.540029e+05,
	3.564861e+03,
	4.720887e+01,
	-2.701302e+06,
	1.965799e+05,
	6.434261e+03,
	1.113315e+02,
	-2.916540e+06,
	2.134724e+05,
	1.036392e+04,
	2.333911e+02,
	-2.526077e+06,
	1.969947e+05,
	1.493163e+04,
	4.395490e+02,
	-1.965767e+06,
	1.637507e+05,
	1.953147e+04,
	7.516110e+02,
	-1.697977e+06,
	1.315705e+05,
	2.369155e+04,
	1.184152e+03,
	-1.124648e+06,
	8.674265e+04,
	2.700457e+04,
	1.743860e+03,
	-9.015866e+05,
	5.643048e+04,
	2.922375e+04,
	2.423722e+03,
	-7.506628e+05,
	3.028053e+04,
	3.032450e+04,
	3.211428e+03,
	-1.502096e+05,
	-6.976241e+03,
	3.021703e+04,
	4.084801e+03,
	-4.313262e+05,
	-4.280012e+02,
	2.934955e+04,
	5.011680e+03,
	-8.356901e+04,
	-2.305404e+04,
	2.785722e+04,
	5.981843e+03,
	-6.447470e+04,
	-2.307799e+04,
	2.585185e+04,
	6.959204e+03,
	-6.518919e+04,
	-2.177705e+04,
	2.375067e+04,
	7.931175e+03,
	-6.379765e+04,
	-2.063416e+04,
	2.157590e+04,
	8.885643e+03,
	3.719946e+02,
	-2.246051e+04,
	1.933079e+04,
	9.809115e+03,
	-2.302765e+04,
	-1.787789e+04,
	1.717219e+04,
	1.068719e+04,
	-8.297077e+03,
	-1.659973e+04,
	1.515538e+04,
	1.151822e+04,
	7.842093e+02,
	-1.472122e+04,
	1.326753e+04,
	1.229522e+04,
	-1.859957e+04,
	-1.110603e+04,
	1.156662e+04,
	1.301583e+04,
	4.434424e+03,
	-1.134157e+04,
	9.987902e+03,
	1.368140e+04,
	-2.070461e+04,
	-7.474109e+03,
	8.566013e+03,
	1.428543e+04,
	1.277143e+04,
	-9.241875e+03,
	7.241224e+03,
	1.483337e+04,
	-1.508531e+04,
	-4.897739e+03,
	6.099617e+03,
	1.531603e+04,
	-1.471159e+04,
	-4.527480e+03,
	5.082794e+03,
	1.574803e+04,
	-3.968351e+03,
	-4.893573e+03,
	4.064790e+03,
	1.612095e+04,
	-1.081038e+04,
	-3.174699e+03,
	3.148908e+03,
	1.642812e+04,
	-2.027976e+04,
	-1.650839e+03,
	2.326102e+03,
	1.667577e+04,
	-2.971391e+04,
	-2.147712e+02,
	1.486818e+03,
	1.686212e+04,
	-1.842872e+04,
	-5.515463e+01,
	5.911260e+02,
	1.697771e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.548164e+03,
	5.832732e+01,
	0,
	0,
	-4.254350e+04,
	1.106875e+03,
	4.435921e-01,
	1.115021e-03,
	-6.186367e+04,
	3.476985e+03,
	8.919585e+00,
	3.177809e-02,
	-2.400450e+05,
	1.236929e+04,
	4.781682e+01,
	2.358269e-01,
	-5.044807e+05,
	3.042742e+04,
	2.007490e+02,
	1.304017e+00,
	-1.089476e+06,
	6.341001e+04,
	6.399979e+02,
	5.479212e+00,
	-1.227911e+06,
	9.442542e+04,
	1.632738e+03,
	1.854057e+01,
	-1.843917e+06,
	1.380790e+05,
	3.410850e+03,
	5.106126e+01,
	-2.151846e+06,
	1.665970e+05,
	6.202903e+03,
	1.213332e+02,
	-2.042129e+06,
	1.709803e+05,
	9.861164e+03,
	2.528505e+02,
	-2.013808e+06,
	1.629299e+05,
	1.399494e+04,
	4.696808e+02,
	-1.226414e+06,
	1.227890e+05,
	1.806697e+04,
	7.926443e+02,
	-1.415486e+06,
	1.097980e+05,
	2.166666e+04,
	1.230785e+03,
	-7.867272e+05,
	6.384606e+04,
	2.448953e+04,
	1.792229e+03,
	-6.455655e+05,
	4.083803e+04,
	2.621488e+04,
	2.463119e+03,
	-4.555601e+05,
	1.792048e+04,
	2.696774e+04,
	3.230170e+03,
	-9.267617e+04,
	-6.476458e+03,
	2.676322e+04,
	4.071033e+03,
	-2.927601e+05,
	-1.052446e+03,
	2.601313e+04,
	4.960256e+03,
	-1.217774e+05,
	-1.516011e+04,
	2.477810e+04,
	5.889640e+03,
	-3.133872e+04,
	-2.038053e+04,
	2.303332e+04,
	6.828298e+03,
	-8.323439e+04,
	-1.637279e+04,
	2.115509e+04,
	7.757606e+03,
	2.477021e+04,
	-2.169634e+04,
	1.917545e+04,
	8.668998e+03,
	-6.502164e+04,
	-1.334719e+04,
	1.725980e+04,
	9.544082e+03,
	5.350009e+03,
	-1.721099e+04,
	1.537623e+04,
	1.038587e+04,
	-1.384803e+04,
	-1.325894e+04,
	1.354377e+04,
	1.117533e+04,
	4.594548e+03,
	-1.274668e+04,
	1.186473e+04,
	1.191404e+04,
	-3.094085e+04,
	-8.212376e+03,
	1.034769e+04,
	1.259716e+04,
	2.132700e+04,
	-1.145801e+04,
	8.882879e+03,
	1.322813e+04,
	-3.035282e+04,
	-4.902982e+03,
	7.607703e+03,
	1.379274e+04,
	5.411916e+03,
	-7.830371e+03,
	6.412932e+03,
	1.430841e+04,
	-1.810219e+04,
	-4.158606e+03,
	5.307838e+03,
	1.475643e+04,
	-3.007288e+02,
	-5.370719e+03,
	4.283134e+03,
	1.514813e+04,
	-2.178750e+04,
	-2.173925e+03,
	3.365475e+03,
	1.547263e+04,
	-1.511740e+04,
	-2.655632e+03,
	2.459696e+03,
	1.573975e+04,
	-3.355339e+04,
	7.946364e+01,
	1.567829e+03,
	1.593402e+04,
	-1.896481e+04,
	-1.109393e+02,
	6.194191e+02,
	1.605676e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.491786e+03,
	2.774529e+02,
	0,
	0,
	-4.543511e+04,
	1.887313e+03,
	2.744877e+00,
	1.059270e-02,
	-6.058786e+04,
	5.419371e+03,
	2.435209e+01,
	1.321300e-01,
	-2.888232e+05,
	1.859427e+04,
	1.103914e+02,
	7.927798e-01,
	-6.056967e+05,
	4.106824e+04,
	4.123811e+02,
	3.821734e+00,
	-8.632473e+05,
	6.819488e+04,
	1.152532e+03,
	1.412787e+01,
	-1.223397e+06,
	9.931776e+04,
	2.559702e+03,
	4.147376e+01,
	-1.340520e+06,
	1.187963e+05,
	4.785345e+03,
	1.020841e+02,
	-1.331923e+06,
	1.258200e+05,
	7.731127e+03,
	2.165939e+02,
	-1.384212e+06,
	1.233902e+05,
	1.113473e+04,
	4.071911e+02,
	-6.897551e+05,
	8.991942e+04,
	1.453688e+04,
	6.933099e+02,
	-1.214735e+06,
	9.534407e+04,
	1.765376e+04,
	1.082844e+03,
	-4.097940e+05,
	4.438210e+04,
	2.014827e+04,
	1.588657e+03,
	-3.878253e+05,
	3.305638e+04,
	2.168065e+04,
	2.190812e+03,
	-4.045554e+05,
	2.233340e+04,
	2.261177e+04,
	2.884151e+03,
	-1.793317e+05,
	1.946184e+03,
	2.274125e+04,
	3.654479e+03,
	-6.062687e+04,
	-7.801344e+03,
	2.217293e+04,
	4.474418e+03,
	-1.596910e+05,
	-4.718906e+03,
	2.128443e+04,
	5.326097e+03,
	-4.954925e+04,
	-1.385354e+04,
	2.004253e+04,
	6.200059e+03,
	-1.408864e+04,
	-1.539126e+04,
	1.849437e+04,
	7.069552e+03,
	-3.886102e+04,
	-1.263844e+04,
	1.691557e+04,
	7.922135e+03,
	-2.899779e+04,
	-1.274985e+04,
	1.531142e+04,
	8.751657e+03,
	3.490567e+03,
	-1.374791e+04,
	1.365887e+04,
	9.545296e+03,
	-1.297414e+04,
	-1.056211e+04,
	1.209829e+04,
	1.029242e+04,
	-9.319178e+03,
	-9.642875e+03,
	1.065048e+04,
	1.099410e+04,
	-9.836923e+03,
	-8.388618e+03,
	9.274745e+03,
	1.164472e+04,
	-1.192357e+04,
	-7.167599e+03,
	7.978709e+03,
	1.224070e+04,
	1.301938e+03,
	-7.300621e+03,
	6.746966e+03,
	1.277847e+04,
	-2.409152e+04,
	-3.801826e+03,
	5.650636e+03,
	1.325335e+04,
	2.135069e+03,
	-6.018935e+03,
	4.566522e+03,
	1.367190e+04,
	-2.471835e+04,
	-2.111991e+03,
	3.591472e+03,
	1.401725e+04,
	-1.336144e+04,
	-3.118779e+03,
	2.626973e+03,
	1.430292e+04,
	-3.618346e+04,
	1.887078e+02,
	1.694546e+03,
	1.451020e+04,
	-2.192421e+04,
	-1.048766e+01,
	6.919574e+02,
	1.464393e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.298658e+02,
	1.891811e+01,
	0,
	0,
	-1.240277e+04,
	5.345032e+02,
	2.608164e-01,
	1.115021e-03,
	-1.596284e+04,
	1.741852e+03,
	7.032467e+00,
	4.069826e-02,
	-1.027246e+05,
	7.361202e+03,
	3.925922e+01,
	3.027282e-01,
	-2.060335e+05,
	1.759016e+04,
	1.746335e+02,
	1.730512e+00,
	-4.143519e+05,
	3.512883e+04,
	5.474948e+02,
	7.103240e+00,
	-5.194204e+05,
	5.235380e+04,
	1.348534e+03,
	2.294490e+01,
	-7.226607e+05,
	7.188365e+04,
	2.713832e+03,
	6.034437e+01,
	-8.224504e+05,
	8.236982e+04,
	4.702827e+03,
	1.360303e+02,
	-5.759747e+05,
	7.532407e+04,
	7.117950e+03,
	2.687273e+02,
	-7.814308e+05,
	7.950876e+04,
	9.732035e+03,
	4.740952e+02,
	-4.677243e+05,
	5.706459e+04,
	1.228851e+04,
	7.694051e+02,
	-3.405356e+05,
	4.326742e+04,
	1.440361e+04,
	1.156059e+03,
	-3.661262e+05,
	3.527188e+04,
	1.610547e+04,
	1.634736e+03,
	-2.050564e+05,
	1.800520e+04,
	1.723562e+04,
	2.202346e+03,
	-1.739701e+05,
	9.803099e+03,
	1.773202e+04,
	2.842272e+03,
	-4.267503e+04,
	-1.775289e+03,
	1.770045e+04,
	3.540405e+03,
	-1.174590e+05,
	2.979865e+02,
	1.732537e+04,
	4.277679e+03,
	-6.005372e+04,
	-6.416114e+03,
	1.663838e+04,
	5.047353e+03,
	-1.009872e+04,
	-1.033768e+04,
	1.560400e+04,
	5.826299e+03,
	-4.043125e+04,
	-7.878538e+03,
	1.446322e+04,
	6.598461e+03,
	-2.113247e+04,
	-9.484497e+03,
	1.324051e+04,
	7.358438e+03,
	2.589035e+03,
	-1.043233e+04,
	1.192600e+04,
	8.090833e+03,
	-2.651877e+04,
	-6.981116e+03,
	1.067108e+04,
	8.786026e+03,
	-6.138087e+03,
	-8.355998e+03,
	9.423123e+03,
	9.444529e+03,
	-1.199978e+04,
	-6.803323e+03,
	8.184259e+03,
	1.005210e+04,
	-5.136721e+03,
	-6.606467e+03,
	7.004292e+03,
	1.060672e+04,
	-8.765806e+03,
	-5.278347e+03,
	5.900880e+03,
	1.110251e+04,
	-2.318204e+04,
	-3.325419e+03,
	4.877837e+03,
	1.153968e+04,
	-6.973830e+03,
	-4.679254e+03,
	3.813233e+03,
	1.191537e+04,
	-2.198839e+04,
	-2.109273e+03,
	2.813720e+03,
	1.221296e+04,
	-4.232767e+04,
	4.552064e+02,
	1.844062e+03,
	1.243947e+04,
	-2.133196e+04,
	-2.242884e+02,
	7.171137e+02,
	1.258462e+04,
};

double solarDataset480[] = 
{
	-2.547404e+13,
	3.635631e+08,
	1.293910e+04,
	3.796038e+01,
	1.491564e+11,
	-3.082064e+07,
	2.764923e+03,
	3.816097e+01,
	-4.508309e+10,
	2.784696e+07,
	1.842137e+03,
	3.830790e+01,
	1.877320e+09,
	-2.075191e+06,
	5.574952e+03,
	4.031446e+01,
	1.363759e+08,
	1.060735e+05,
	5.218855e+03,
	4.351307e+01,
	-4.042173e+07,
	4.168932e+05,
	5.894289e+03,
	4.927657e+01,
	-1.979427e+07,
	3.130223e+05,
	6.903811e+03,
	5.939239e+01,
	6.227794e+07,
	3.355382e+04,
	7.989751e+03,
	7.579875e+01,
	-2.611063e+07,
	5.428849e+05,
	9.770848e+03,
	1.008989e+02,
	6.751575e+06,
	3.486580e+05,
	1.273626e+04,
	1.436773e+02,
	-7.094370e+06,
	5.158292e+05,
	1.643574e+04,
	2.114709e+02,
	-9.375221e+06,
	5.686982e+05,
	2.162922e+04,
	3.207238e+02,
	-9.044998e+06,
	5.787047e+05,
	2.809570e+04,
	4.923702e+02,
	-1.059918e+07,
	5.884594e+05,
	3.567928e+04,
	7.525556e+02,
	-1.032559e+07,
	5.383256e+05,
	4.394951e+04,
	1.132412e+03,
	-9.508141e+06,
	4.496710e+05,
	5.199543e+04,
	1.660855e+03,
	-6.314974e+06,
	3.051184e+05,
	5.876680e+04,
	2.358284e+03,
	-6.086400e+06,
	2.212357e+05,
	6.360343e+04,
	3.228792e+03,
	-3.788528e+06,
	9.381155e+04,
	6.603062e+04,
	4.267693e+03,
	-2.077730e+06,
	4.085149e+03,
	6.579013e+04,
	5.445031e+03,
	-1.998244e+06,
	-2.581562e+04,
	6.353956e+04,
	6.724786e+03,
	-5.455764e+05,
	-8.455452e+04,
	5.958479e+04,
	8.073218e+03,
	-5.401502e+05,
	-8.066396e+04,
	5.460598e+04,
	9.442031e+03,
	-4.626920e+05,
	-7.878633e+04,
	4.927072e+04,
	1.080685e+04,
	4.307696e+04,
	-8.866941e+04,
	4.363750e+04,
	1.213911e+04,
	-9.896498e+04,
	-6.809587e+04,
	3.825652e+04,
	1.340968e+04,
	-4.046726e+04,
	-6.013412e+04,
	3.334045e+04,
	1.461550e+04,
	2.465424e+04,
	-5.267288e+04,
	2.881215e+04,
	1.574516e+04,
	-6.606890e+04,
	-3.886479e+04,
	2.480495e+04,
	1.679298e+04,
	8.625368e+04,
	-3.988716e+04,
	2.118987e+04,
	1.776151e+04,
	-5.094497e+04,
	-2.400663e+04,
	1.812357e+04,
	1.864229e+04,
	3.521782e+04,
	-2.523723e+04,
	1.545985e+04,
	1.945299e+04,
	-2.910575e+04,
	-1.612809e+04,
	1.314789e+04,
	2.018464e+04,
	2.987436e+04,
	-1.729633e+04,
	1.112528e+04,
	2.084999e+04,
	-2.392041e+04,
	-9.871844e+03,
	9.419435e+03,
	2.144328e+04,
	1.318656e+04,
	-1.113363e+04,
	7.932171e+03,
	2.198012e+04,
	-8.189886e+03,
	-7.083342e+03,
	6.648923e+03,
	2.245346e+04,
	8.760018e+02,
	-6.634529e+03,
	5.556208e+03,
	2.287527e+04,
	-7.219063e+03,
	-4.650361e+03,
	4.605098e+03,
	2.324459e+04,
	-7.443951e+03,
	-3.898973e+03,
	3.764874e+03,
	2.356703e+04,
	-5.229746e+03,
	-3.417661e+03,
	2.990255e+03,
	2.384152e+04,
	-9.160621e+03,
	-2.339852e+03,
	2.297538e+03,
	2.406739e+04,
	-1.337575e+04,
	-1.443204e+03,
	1.662712e+03,
	2.424699e+04,
	-1.609842e+04,
	-6.573803e+02,
	1.042947e+03,
	2.437881e+04,
	-1.154888e+04,
	-2.049765e+02,
	4.517902e+02,
	2.445949e+04,
	4.227183e+11,
	1.389648e+06,
	1.036346e+03,
	1.739462e+01,
	-4.523986e+10,
	1.309428e+07,
	1.461077e+03,
	1.741507e+01,
	-1.974469e+09,
	2.075506e+06,
	2.645040e+03,
	1.770254e+01,
	-1.554063e+09,
	1.591460e+06,
	3.369179e+03,
	1.872211e+01,
	5.672809e+08,
	-8.382778e+05,
	3.502720e+03,
	2.111515e+01,
	-1.132935e+08,
	5.257210e+05,
	3.621481e+03,
	2.453096e+01,
	5.367205e+07,
	3.863978e+04,
	4.434495e+03,
	3.106808e+01,
	-7.651470e+05,
	2.973158e+05,
	5.375363e+03,
	4.152440e+01,
	-5.641271e+06,
	3.520079e+05,
	7.088158e+03,
	5.968817e+01,
	-3.575740e+05,
	3.595429e+05,
	9.484804e+03,
	9.083227e+01,
	-5.432283e+06,
	4.570748e+05,
	1.282057e+04,
	1.429497e+02,
	-8.493195e+06,
	5.345880e+05,
	1.750590e+04,
	2.299714e+02,
	-9.361727e+06,
	5.742448e+05,
	2.362945e+04,
	3.720855e+02,
	-1.230376e+07,
	6.089220e+05,
	3.107881e+04,
	5.957043e+02,
	-8.209413e+06,
	5.098829e+05,
	3.928027e+04,
	9.325726e+02,
	-9.315159e+06,
	4.745999e+05,
	4.745855e+04,
	1.409587e+03,
	-8.627264e+06,
	3.733993e+05,
	5.493900e+04,
	2.054851e+03,
	-4.714765e+06,
	2.032292e+05,
	6.032301e+04,
	2.878534e+03,
	-3.679437e+06,
	1.165562e+05,
	6.321237e+04,
	3.866403e+03,
	-2.929350e+06,
	4.492419e+04,
	6.387975e+04,
	5.001581e+03,
	-1.392612e+06,
	-3.265661e+04,
	6.224732e+04,
	6.253081e+03,
	-1.117804e+06,
	-5.501965e+04,
	5.885362e+04,
	7.576411e+03,
	-4.075604e+05,
	-8.239287e+04,
	5.430578e+04,
	8.936806e+03,
	-2.459750e+05,
	-8.099482e+04,
	4.915270e+04,
	1.029496e+04,
	-3.665911e+05,
	-6.851276e+04,
	4.392374e+04,
	1.162710e+04,
	2.205685e+05,
	-8.274490e+04,
	3.860977e+04,
	1.291372e+04,
	-3.040342e+05,
	-4.570146e+04,
	3.379260e+04,
	1.412701e+04,
	1.469667e+05,
	-6.087770e+04,
	2.926964e+04,
	1.527950e+04,
	-6.797871e+04,
	-3.790137e+04,
	2.518196e+04,
	1.633998e+04,
	3.949307e+04,
	-3.733814e+04,
	2.163770e+04,
	1.732591e+04,
	-7.975621e+03,
	-2.732830e+04,
	1.851668e+04,
	1.822774e+04,
	-4.377782e+03,
	-2.272640e+04,
	1.583173e+04,
	1.905445e+04,
	1.693589e+04,
	-1.978767e+04,
	1.346464e+04,
	1.980645e+04,
	-1.488896e+04,
	-1.382418e+04,
	1.145439e+04,
	2.048569e+04,
	-5.303294e+03,
	-1.226164e+04,
	9.699219e+03,
	2.110102e+04,
	2.706972e+04,
	-1.214607e+04,
	8.129372e+03,
	2.165037e+04,
	-3.562524e+04,
	-4.676288e+03,
	6.891074e+03,
	2.213611e+04,
	2.093737e+04,
	-9.026232e+03,
	5.739331e+03,
	2.257705e+04,
	-2.006414e+04,
	-3.337389e+03,
	4.758662e+03,
	2.295476e+04,
	-1.964465e+03,
	-4.781112e+03,
	3.893292e+03,
	2.329090e+04,
	-7.979526e+03,
	-3.208613e+03,
	3.083342e+03,
	2.357289e+04,
	-3.882281e+03,
	-2.975486e+03,
	2.366732e+03,
	2.380648e+04,
	-1.970221e+04,
	-7.385175e+02,
	1.744297e+03,
	2.399093e+04,
	-2.049545e+04,
	-4.245408e+02,
	1.090574e+03,
	2.413137e+04,
	-1.271643e+04,
	-9.063678e+01,
	4.186658e+02,
	2.421482e+04,
	-3.562425e+12,
	4.547613e+07,
	3.869422e+03,
	4.918330e+00,
	4.689183e+10,
	-1.281786e+07,
	2.261597e+03,
	4.980296e+00,
	2.022864e+09,
	-1.220456e+06,
	1.216501e+03,
	5.148946e+00,
	2.776720e+08,
	-1.053418e+05,
	1.068025e+03,
	5.487525e+00,
	-1.590271e+08,
	4.112991e+05,
	1.272512e+03,
	6.197900e+00,
	6.495931e+07,
	-3.603970e+04,
	1.609987e+03,
	7.805828e+00,
	-2.064038e+07,
	2.320516e+05,
	1.976444e+03,
	1.049337e+01,
	1.765744e+07,
	1.028749e+05,
	2.695696e+03,
	1.571579e+01,
	-1.181768e+07,
	3.056096e+05,
	3.744644e+03,
	2.487848e+01,
	3.197837e+06,
	2.544026e+05,
	5.534911e+03,
	4.254333e+01,
	-9.201137e+06,
	4.284098e+05,
	8.121123e+03,
	7.427706e+01,
	-8.890947e+06,
	4.785445e+05,
	1.211126e+04,
	1.328518e+02,
	-7.071586e+06,
	5.059339e+05,
	1.741186e+04,
	2.352960e+02,
	-1.166674e+07,
	5.930738e+05,
	2.420576e+04,
	4.053939e+02,
	-1.014664e+07,
	5.469944e+05,
	3.227826e+04,
	6.765805e+02,
	-8.709155e+06,
	4.717684e+05,
	4.057628e+04,
	1.079331e+03,
	-6.589641e+06,
	3.640900e+05,
	4.826717e+04,
	1.639785e+03,
	-5.956205e+06,
	2.764700e+05,
	5.460139e+04,
	2.373352e+03,
	-4.410054e+06,
	1.636818e+05,
	5.887661e+04,
	3.284026e+03,
	-2.573675e+06,
	5.767791e+04,
	6.052561e+04,
	4.353163e+03,
	-1.725557e+06,
	-2.089540e+03,
	5.980763e+04,
	5.546333e+03,
	-7.726710e+05,
	-4.982537e+04,
	5.727085e+04,
	6.827655e+03,
	-9.367723e+05,
	-5.118449e+04,
	5.356326e+04,
	8.157893e+03,
	-2.139498e+05,
	-7.920098e+04,
	4.895601e+04,
	9.508497e+03,
	-1.552485e+05,
	-7.235301e+04,
	4.390792e+04,
	1.083723e+04,
	-1.628579e+04,
	-6.809604e+04,
	3.896658e+04,
	1.212598e+04,
	-1.983318e+05,
	-5.059195e+04,
	3.433105e+04,
	1.335883e+04,
	8.171771e+04,
	-5.652750e+04,
	2.987115e+04,
	1.452950e+04,
	-1.382147e+04,
	-4.085430e+04,
	2.582431e+04,
	1.561625e+04,
	-1.903892e+04,
	-3.373542e+04,
	2.231868e+04,
	1.662797e+04,
	1.630797e+04,
	-2.980642e+04,
	1.916625e+04,
	1.756241e+04,
	-1.470429e+04,
	-2.241600e+04,
	1.641147e+04,
	1.841734e+04,
	1.183830e+04,
	-2.013913e+04,
	1.399466e+04,
	1.919851e+04,
	-7.425767e+03,
	-1.497561e+04,
	1.190037e+04,
	1.990483e+04,
	2.348122e+04,
	-1.430663e+04,
	1.008697e+04,
	2.054362e+04,
	-3.407580e+04,
	-7.210622e+03,
	8.592568e+03,
	2.111580e+04,
	8.410728e+03,
	-9.841158e+03,
	7.218391e+03,
	2.163577e+04,
	5.333101e+03,
	-7.356348e+03,
	5.982069e+03,
	2.208915e+04,
	-1.934314e+04,
	-3.841909e+03,
	4.996690e+03,
	2.248734e+04,
	3.189408e+03,
	-5.483261e+03,
	4.066681e+03,
	2.283908e+04,
	-1.021377e+04,
	-2.980445e+03,
	3.244087e+03,
	2.313320e+04,
	-9.790041e+03,
	-2.583961e+03,
	2.517956e+03,
	2.338071e+04,
	-1.444370e+04,
	-1.591158e+03,
	1.824665e+03,
	2.357756e+04,
	-2.379887e+04,
	-1.133726e+02,
	1.149303e+03,
	2.372235e+04,
	-1.332327e+04,
	-1.181356e+02,
	4.433913e+02,
	2.381143e+04,
	-4.062495e+12,
	5.889514e+07,
	1.822539e+03,
	5.934704e-01,
	1.116655e+10,
	-2.476749e+06,
	2.315678e+02,
	6.215788e-01,
	-2.883849e+08,
	3.186874e+05,
	1.216092e+02,
	6.330776e-01,
	-3.334973e+08,
	3.506258e+05,
	2.375575e+02,
	6.969603e-01,
	9.502123e+07,
	-1.388013e+05,
	2.778272e+02,
	9.045791e-01,
	-3.169474e+07,
	1.355526e+05,
	3.011117e+02,
	1.153722e+00,
	1.354177e+07,
	8.549983e+03,
	4.924110e+02,
	1.837267e+00,
	-9.788296e+06,
	1.268912e+05,
	7.245476e+02,
	3.098311e+00,
	8.321999e+06,
	5.975755e+04,
	1.214653e+03,
	6.043943e+00,
	-9.981085e+06,
	2.455768e+05,
	2.011040e+03,
	1.185919e+01,
	-2.885803e+06,
	2.397529e+05,
	3.652004e+03,
	2.559525e+01,
	-6.329634e+06,
	3.478969e+05,
	6.106085e+03,
	5.370172e+01,
	-7.960277e+06,
	4.345711e+05,
	9.978396e+03,
	1.097524e+02,
	-7.895936e+06,
	4.855802e+05,
	1.544416e+04,
	2.146203e+02,
	-1.056970e+07,
	5.455151e+05,
	2.249529e+04,
	3.967972e+02,
	-8.772676e+06,
	4.836844e+05,
	3.061098e+04,
	6.924183e+02,
	-6.125317e+06,
	3.824122e+05,
	3.856863e+04,
	1.130737e+03,
	-6.234374e+06,
	3.223025e+05,
	4.569520e+04,
	1.732649e+03,
	-4.135207e+06,
	1.989626e+05,
	5.121311e+04,
	2.512630e+03,
	-2.831010e+06,
	1.064359e+05,
	5.436969e+04,
	3.458681e+03,
	-1.771421e+06,
	3.391272e+04,
	5.527105e+04,
	4.547677e+03,
	-1.352058e+06,
	-6.747689e+03,
	5.423442e+04,
	5.746928e+03,
	-4.737948e+05,
	-5.056302e+04,
	5.159311e+04,
	7.021275e+03,
	-5.178401e+05,
	-5.085618e+04,
	4.797068e+04,
	8.329029e+03,
	-3.165613e+05,
	-5.894560e+04,
	4.379803e+04,
	9.645661e+03,
	-3.525713e+04,
	-6.498724e+04,
	3.922274e+04,
	1.093910e+04,
	-1.698033e+03,
	-5.646027e+04,
	3.473194e+04,
	1.218335e+04,
	-8.252137e+04,
	-4.418587e+04,
	3.062394e+04,
	1.337026e+04,
	-4.452976e+04,
	-4.012949e+04,
	2.678876e+04,
	1.449551e+04,
	1.756583e+04,
	-3.688401e+04,
	2.318145e+04,
	1.554675e+04,
	2.497374e+04,
	-3.028839e+04,
	1.996805e+04,
	1.651698e+04,
	-4.542787e+04,
	-2.074654e+04,
	1.722708e+04,
	1.741034e+04,
	4.577114e+04,
	-2.317554e+04,
	1.473888e+04,
	1.823360e+04,
	-2.941513e+04,
	-1.335336e+04,
	1.261663e+04,
	1.897704e+04,
	9.540414e+03,
	-1.422160e+04,
	1.076932e+04,
	1.965858e+04,
	-1.333019e+04,
	-9.795617e+03,
	9.126910e+03,
	2.026983e+04,
	6.872783e+03,
	-9.753800e+03,
	7.680151e+03,
	2.081939e+04,
	-6.794840e+03,
	-6.642494e+03,
	6.433964e+03,
	2.130449e+04,
	-6.512347e+03,
	-5.595285e+03,
	5.359979e+03,
	2.173466e+04,
	-7.453009e+03,
	-4.569078e+03,
	4.387344e+03,
	2.210973e+04,
	-8.453112e+03,
	-3.685525e+03,
	3.504406e+03,
	2.243008e+04,
	-1.058157e+04,
	-2.798516e+03,
	2.696662e+03,
	2.269567e+04,
	-1.175275e+04,
	-2.070349e+03,
	1.946314e+03,
	2.290618e+04,
	-2.725053e+04,
	1.473825e+02,
	1.251869e+03,
	2.306034e+04,
	-1.529872e+04,
	-8.045642e+01,
	4.978280e+02,
	2.315872e+04,
	0,
	0,
	0,
	3.002487e-02,
	-1.090846e+10,
	1.974400e+06,
	0,
	3.002487e-02,
	3.636683e+07,
	-1.786622e+04,
	0,
	3.960728e-02,
	-7.026847e+07,
	9.507055e+04,
	0,
	3.896845e-02,
	1.333478e+06,
	3.529875e+03,
	3.551876e+01,
	5.941092e-02,
	2.003892e+06,
	3.786981e+03,
	4.736528e+01,
	1.022123e-01,
	-1.002646e+05,
	1.491867e+04,
	7.403866e+01,
	1.935646e-01,
	8.840045e+05,
	2.053897e+04,
	1.379171e+02,
	4.260977e-01,
	-1.799941e+06,
	5.585624e+04,
	2.800918e+02,
	1.024040e+00,
	-1.272606e+06,
	8.353843e+04,
	6.224092e+02,
	2.759094e+00,
	-3.142945e+06,
	1.498386e+05,
	1.319586e+03,
	7.359927e+00,
	-5.325514e+06,
	2.353986e+05,
	2.722502e+03,
	1.918334e+01,
	-4.367873e+06,
	2.950794e+05,
	5.196144e+03,
	4.713202e+01,
	-8.293792e+06,
	4.208244e+05,
	9.110856e+03,
	1.061188e+02,
	-8.395418e+06,
	4.579295e+05,
	1.483469e+04,
	2.224875e+02,
	-6.520037e+06,
	4.312038e+05,
	2.181675e+04,
	4.272194e+02,
	-7.601962e+06,
	4.292473e+05,
	2.951377e+04,
	7.524578e+02,
	-5.359980e+06,
	3.235804e+05,
	3.708090e+04,
	1.232011e+03,
	-4.257096e+06,
	2.366275e+05,
	4.329759e+04,
	1.879326e+03,
	-2.362298e+06,
	1.320983e+05,
	4.767316e+04,
	2.696374e+03,
	-2.586387e+06,
	9.404854e+04,
	5.012795e+04,
	3.667154e+03,
	-1.346937e+06,
	1.521702e+04,
	5.055045e+04,
	4.774654e+03,
	-6.311932e+05,
	-2.761653e+04,
	4.896823e+04,
	5.973547e+03,
	-2.859925e+05,
	-4.535140e+04,
	4.622372e+04,
	7.225477e+03,
	-5.833449e+05,
	-3.576030e+04,
	4.293299e+04,
	8.502104e+03,
	5.723729e+03,
	-6.133686e+04,
	3.902591e+04,
	9.783052e+03,
	-8.123325e+04,
	-4.879934e+04,
	3.491969e+04,
	1.102637e+04,
	-5.068165e+04,
	-4.411026e+04,
	3.105343e+04,
	1.222640e+04,
	-3.207428e+04,
	-3.889547e+04,
	2.737029e+04,
	1.337046e+04,
	-1.066219e+04,
	-3.412928e+04,
	2.393260e+04,
	1.444923e+04,
	-1.141680e+04,
	-2.854544e+04,
	2.079563e+04,
	1.545628e+04,
	-4.908479e+03,
	-2.421760e+04,
	1.796966e+04,
	1.638943e+04,
	2.053346e+04,
	-2.145813e+04,
	1.544534e+04,
	1.724714e+04,
	-3.179755e+04,
	-1.406796e+04,
	1.328479e+04,
	1.803018e+04,
	3.081852e+04,
	-1.632250e+04,
	1.133044e+04,
	1.874762e+04,
	-2.520860e+04,
	-8.744463e+03,
	9.671271e+03,
	1.939042e+04,
	-5.258707e+02,
	-9.682975e+03,
	8.210156e+03,
	1.997663e+04,
	-3.603629e+03,
	-7.596047e+03,
	6.868361e+03,
	2.049617e+04,
	-1.284514e+04,
	-5.501197e+03,
	5.706315e+03,
	2.095412e+04,
	5.408753e+03,
	-6.215871e+03,
	4.636466e+03,
	2.135343e+04,
	-1.729670e+04,
	-2.725560e+03,
	3.738994e+03,
	2.168992e+04,
	-8.133455e+03,
	-3.384342e+03,
	2.903206e+03,
	2.197692e+04,
	-1.400569e+04,
	-2.007834e+03,
	2.106764e+03,
	2.220291e+04,
	-3.787921e+04,
	9.695897e+02,
	1.365023e+03,
	2.237077e+04,
	-1.169926e+04,
	-4.806728e+02,
	4.665493e+02,
	2.247814e+04,
	6.525532e+11,
	-9.597776e+06,
	-2.508142e+02,
	5.110617e-03,
	-7.272307e+08,
	1.316266e+05,
	0,
	1.277654e-03,
	7.273367e+07,
	-3.573244e+04,
	0,
	1.916481e-03,
	-9.307074e+05,
	2.164022e+03,
	0,
	6.388271e-04,
	-3.846153e+06,
	8.276968e+03,
	1.624622e+00,
	1.277654e-03,
	7.045428e+05,
	-9.506031e+02,
	6.273509e+00,
	7.665925e-03,
	5.471221e+05,
	7.881141e+02,
	8.492069e+00,
	1.788716e-02,
	-1.157790e+06,
	1.343443e+04,
	1.980918e+01,
	4.599555e-02,
	5.648178e+05,
	1.177962e+04,
	6.860591e+01,
	1.890928e-01,
	-2.168944e+06,
	5.449721e+04,
	1.804408e+02,
	6.401047e-01,
	-1.936415e+06,
	8.671467e+04,
	5.476078e+02,
	2.451180e+00,
	-2.778014e+06,
	1.502939e+05,
	1.348026e+03,
	8.039000e+00,
	-5.988957e+06,
	2.595586e+05,
	3.014769e+03,
	2.341237e+01,
	-4.953844e+06,
	3.123771e+05,
	6.037281e+03,
	6.158549e+01,
	-8.072078e+06,
	4.188727e+05,
	1.060684e+04,
	1.421314e+02,
	-6.102258e+06,
	4.036899e+05,
	1.685401e+04,
	2.966719e+02,
	-7.081157e+06,
	4.155400e+05,
	2.406072e+04,
	5.567832e+02,
	-5.275326e+06,
	3.322858e+05,
	3.155165e+04,
	9.582758e+02,
	-3.846919e+06,
	2.463955e+05,
	3.810789e+04,
	1.520520e+03,
	-3.514763e+06,
	1.822427e+05,
	4.321496e+04,
	2.251031e+03,
	-1.456565e+06,
	7.443224e+04,
	4.630479e+04,
	3.144755e+03,
	-1.859068e+06,
	5.498326e+04,
	4.747600e+04,
	4.171486e+03,
	-4.928980e+05,
	-1.792985e+04,
	4.691705e+04,
	5.312605e+03,
	-8.773971e+05,
	-1.418775e+04,
	4.496428e+04,
	6.519951e+03,
	-2.751454e+04,
	-5.502387e+04,
	4.200632e+04,
	7.772248e+03,
	-1.594475e+05,
	-4.385961e+04,
	3.851029e+04,
	9.022491e+03,
	-2.928118e+05,
	-3.624179e+04,
	3.501918e+04,
	1.026196e+04,
	9.244874e+04,
	-5.182584e+04,
	3.122779e+04,
	1.147202e+04,
	-7.298447e+04,
	-3.463156e+04,
	2.759798e+04,
	1.261967e+04,
	-2.297138e+04,
	-3.303978e+04,
	2.430195e+04,
	1.371250e+04,
	-7.257520e+03,
	-2.883089e+04,
	2.118824e+04,
	1.473725e+04,
	1.617806e+04,
	-2.529034e+04,
	1.836369e+04,
	1.568909e+04,
	-1.048687e+04,
	-1.906491e+04,
	1.589586e+04,
	1.656705e+04,
	-2.280875e+03,
	-1.656326e+04,
	1.371907e+04,
	1.737679e+04,
	-1.173034e+04,
	-1.313659e+04,
	1.177337e+04,
	1.811680e+04,
	1.764221e+03,
	-1.200134e+04,
	1.002274e+04,
	1.878901e+04,
	-5.443919e+03,
	-9.216609e+03,
	8.480824e+03,
	1.939176e+04,
	-2.042247e+03,
	-7.901444e+03,
	7.133254e+03,
	1.993055e+04,
	-8.037811e+03,
	-5.968600e+03,
	5.951562e+03,
	2.040675e+04,
	-1.379071e+04,
	-4.556409e+03,
	4.894801e+03,
	2.082428e+04,
	-5.451456e+02,
	-5.063627e+03,
	3.890115e+03,
	2.118233e+04,
	-2.023326e+04,
	-2.060668e+03,
	3.019280e+03,
	2.147555e+04,
	-2.864907e+03,
	-3.469182e+03,
	2.170665e+03,
	2.171383e+04,
	-4.564474e+04,
	1.914149e+03,
	1.447545e+03,
	2.188399e+04,
	-1.285998e+04,
	-5.186207e+02,
	5.108418e+02,
	2.200120e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.075985e+04,
	4.214961e+02,
	0,
	0,
	5.562181e+04,
	8.061994e+01,
	8.281078e-01,
	1.277654e-03,
	-3.121437e+05,
	4.825055e+03,
	2.713965e+00,
	5.749444e-03,
	-1.563799e+05,
	9.395735e+03,
	2.570856e+01,
	6.707684e-02,
	-7.453272e+05,
	3.122976e+04,
	1.032542e+02,
	3.762692e-01,
	-1.989081e+06,
	7.880134e+04,
	3.868377e+02,
	1.843655e+00,
	-3.098191e+06,
	1.440545e+05,
	1.185918e+03,
	7.543909e+00,
	-4.215556e+06,
	2.225784e+05,
	2.907656e+03,
	2.490978e+01,
	-4.786020e+06,
	2.938944e+05,
	5.980692e+03,
	6.858128e+01,
	-6.298563e+06,
	3.655079e+05,
	1.067540e+04,
	1.622455e+02,
	-5.412413e+06,
	3.568233e+05,
	1.684205e+04,
	3.392913e+02,
	-4.918343e+06,
	3.291889e+05,
	2.367207e+04,
	6.321366e+02,
	-3.916896e+06,
	2.666399e+05,
	3.039895e+04,
	1.070198e+03,
	-3.234356e+06,
	2.003322e+05,
	3.615701e+04,
	1.670192e+03,
	-2.040334e+06,
	1.180905e+05,
	4.028384e+04,
	2.434229e+03,
	-1.401604e+06,
	6.196017e+04,
	4.252555e+04,
	3.344716e+03,
	-8.510153e+05,
	1.754662e+04,
	4.308474e+04,
	4.377716e+03,
	-5.868429e+05,
	-7.897552e+03,
	4.225322e+04,
	5.502610e+03,
	-4.777308e+05,
	-2.215277e+04,
	4.036574e+04,
	6.689373e+03,
	-2.027395e+05,
	-3.838610e+04,
	3.760893e+04,
	7.906894e+03,
	4.688571e+04,
	-4.650040e+04,
	3.433909e+04,
	9.120592e+03,
	-1.731682e+05,
	-3.045624e+04,
	3.114684e+04,
	1.030870e+04,
	-9.393385e+04,
	-3.336297e+04,
	2.796966e+04,
	1.146998e+04,
	5.520659e+04,
	-3.698224e+04,
	2.466929e+04,
	1.257910e+04,
	-3.127735e+04,
	-2.548739e+04,
	2.167580e+04,
	1.361953e+04,
	-2.886510e+04,
	-2.234154e+04,
	1.900618e+04,
	1.459990e+04,
	4.803892e+04,
	-2.356220e+04,
	1.648513e+04,
	1.551250e+04,
	-6.916297e+04,
	-1.140155e+04,
	1.434094e+04,
	1.635055e+04,
	2.995112e+04,
	-1.761090e+04,
	1.231851e+04,
	1.713096e+04,
	-1.131187e+04,
	-1.076782e+04,
	1.049085e+04,
	1.782950e+04,
	-5.672132e+03,
	-9.605872e+03,
	8.943086e+03,
	1.846438e+04,
	-2.342928e+02,
	-8.391650e+03,
	7.538626e+03,
	1.903310e+04,
	-1.356312e+04,
	-5.763390e+03,
	6.314320e+03,
	1.953688e+04,
	-1.029218e+04,
	-5.313462e+03,
	5.191616e+03,
	1.998094e+04,
	-4.820491e+03,
	-4.883491e+03,
	4.133093e+03,
	2.035985e+04,
	-1.332017e+04,
	-3.043612e+03,
	3.200526e+03,
	2.067237e+04,
	-1.507804e+04,
	-2.298738e+03,
	2.341341e+03,
	2.092387e+04,
	-3.372668e+04,
	2.668844e+02,
	1.517180e+03,
	2.111023e+04,
	-1.829462e+04,
	-1.213923e+02,
	6.004736e+02,
	2.122965e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.017242e+04,
	1.750194e+02,
	0,
	0,
	-1.457144e+04,
	7.281291e+02,
	8.823561e-01,
	1.916481e-03,
	-8.138557e+04,
	3.915626e+03,
	6.731239e+00,
	2.044247e-02,
	-3.416115e+05,
	1.616098e+04,
	4.346558e+01,
	1.712057e-01,
	-1.112109e+06,
	4.948532e+04,
	2.166628e+02,
	1.116031e+00,
	-1.851122e+06,
	9.973810e+04,
	7.987332e+02,
	5.514355e+00,
	-2.976474e+06,
	1.703720e+05,
	2.185875e+03,
	2.036134e+01,
	-3.752852e+06,
	2.346189e+05,
	4.835726e+03,
	6.046371e+01,
	-3.916406e+06,
	2.725329e+05,
	8.928559e+03,
	1.496005e+02,
	-4.124056e+06,
	2.880126e+05,
	1.427455e+04,
	3.184585e+02,
	-3.454381e+06,
	2.560391e+05,
	2.029483e+04,
	6.004725e+02,
	-2.730599e+06,
	2.065880e+05,
	2.611242e+04,
	1.020835e+03,
	-2.156132e+06,
	1.532252e+05,
	3.106996e+04,
	1.593564e+03,
	-1.423653e+06,
	9.444510e+04,
	3.467497e+04,
	2.319182e+03,
	-1.066952e+06,
	5.365130e+04,
	3.674970e+04,
	3.182752e+03,
	-5.913676e+05,
	1.479975e+04,
	3.736478e+04,
	4.162645e+03,
	-4.507312e+05,
	-3.442068e+03,
	3.676283e+04,
	5.228191e+03,
	-3.349898e+05,
	-1.694648e+04,
	3.524585e+04,
	6.352700e+03,
	-5.373997e+04,
	-3.272371e+04,
	3.296933e+04,
	7.506143e+03,
	-1.042929e+05,
	-2.794349e+04,
	3.037961e+04,
	8.657850e+03,
	-1.338463e+05,
	-2.558203e+04,
	2.771508e+04,
	9.797088e+03,
	4.568200e+04,
	-3.329463e+04,
	2.485715e+04,
	1.090629e+04,
	-6.786858e+04,
	-2.165789e+04,
	2.213772e+04,
	1.196178e+04,
	1.306047e+04,
	-2.435543e+04,
	1.958249e+04,
	1.296915e+04,
	-3.322576e+04,
	-1.756840e+04,
	1.718597e+04,
	1.391169e+04,
	2.749390e+04,
	-1.920271e+04,
	1.496912e+04,
	1.479267e+04,
	-3.110219e+04,
	-1.154084e+04,
	1.301793e+04,
	1.560216e+04,
	-6.075291e+03,
	-1.225057e+04,
	1.124355e+04,
	1.635251e+04,
	6.180475e+02,
	-1.069972e+04,
	9.569241e+03,
	1.703160e+04,
	-6.748771e+03,
	-8.170462e+03,
	8.103632e+03,
	1.764032e+04,
	-1.585713e+04,
	-6.165047e+03,
	6.808130e+03,
	1.818386e+04,
	-6.803412e+01,
	-6.704295e+03,
	5.583407e+03,
	1.866238e+04,
	-1.271216e+04,
	-4.147672e+03,
	4.500136e+03,
	1.906922e+04,
	-1.789297e+04,
	-3.078470e+03,
	3.522047e+03,
	1.941335e+04,
	-1.300839e+04,
	-2.995513e+03,
	2.547822e+03,
	1.968999e+04,
	-3.739496e+04,
	4.124892e+02,
	1.647666e+03,
	1.989124e+04,
	-1.991360e+04,
	-1.343689e+02,
	6.540701e+02,
	2.002139e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-3.836497e+03,
	1.200044e+02,
	0,
	0,
	-6.317725e+03,
	7.299639e+02,
	9.947280e-01,
	3.194135e-03,
	-1.879736e+05,
	7.112439e+03,
	1.009800e+01,
	4.216259e-02,
	-2.264187e+05,
	1.783873e+04,
	8.824183e+01,
	4.893415e-01,
	-1.027429e+06,
	5.516548e+04,
	3.642565e+02,
	2.717570e+00,
	-1.310055e+06,
	9.297558e+04,
	1.199666e+03,
	1.188410e+01,
	-2.088964e+06,
	1.472067e+05,
	2.903674e+03,
	3.864073e+01,
	-2.404946e+06,
	1.832584e+05,
	5.807015e+03,
	1.028959e+02,
	-2.419199e+06,
	1.963782e+05,
	9.802613e+03,
	2.313167e+02,
	-2.144173e+06,
	1.846474e+05,
	1.448111e+04,
	4.529782e+02,
	-1.755673e+06,
	1.566924e+05,
	1.925615e+04,
	7.929135e+02,
	-1.556385e+06,
	1.260006e+05,
	2.357954e+04,
	1.267487e+03,
	-9.670740e+05,
	7.884178e+04,
	2.693555e+04,
	1.882001e+03,
	-5.837683e+05,
	4.472897e+04,
	2.907526e+04,
	2.623982e+03,
	-5.604275e+05,
	2.840427e+04,
	3.020165e+04,
	3.477349e+03,
	-3.582842e+05,
	6.067834e+03,
	3.034485e+04,
	4.425576e+03,
	-2.245319e+05,
	-8.290479e+03,
	2.953728e+04,
	5.439338e+03,
	-1.015845e+05,
	-1.802273e+04,
	2.804648e+04,
	6.490440e+03,
	-4.708202e+04,
	-2.097995e+04,
	2.617044e+04,
	7.553762e+03,
	-9.140648e+04,
	-1.778019e+04,
	2.415851e+04,
	8.612631e+03,
	-3.474920e+04,
	-2.078888e+04,
	2.200252e+04,
	9.655604e+03,
	2.006550e+04,
	-2.169175e+04,
	1.976088e+04,
	1.066217e+04,
	-7.457237e+04,
	-1.281394e+04,
	1.769310e+04,
	1.162183e+04,
	1.660390e+04,
	-1.849862e+04,
	1.562554e+04,
	1.253795e+04,
	-1.242914e+03,
	-1.387174e+04,
	1.364603e+04,
	1.338579e+04,
	-2.136653e+04,
	-1.038594e+04,
	1.192412e+04,
	1.417293e+04,
	8.461670e+02,
	-1.092230e+04,
	1.029799e+04,
	1.490007e+04,
	-1.726136e+04,
	-7.648424e+03,
	8.804960e+03,
	1.555802e+04,
	-5.951019e+03,
	-7.711382e+03,
	7.418584e+03,
	1.615128e+04,
	-1.124333e+04,
	-5.937896e+03,
	6.131419e+03,
	1.667197e+04,
	-7.000456e+03,
	-5.382316e+03,
	4.953545e+03,
	1.712215e+04,
	-1.739957e+04,
	-3.384351e+03,
	3.889292e+03,
	1.749934e+04,
	-2.766408e+04,
	-1.885413e+03,
	2.872322e+03,
	1.780661e+04,
	-2.473009e+04,
	-1.511121e+03,
	1.795912e+03,
	1.803592e+04,
	-1.893613e+04,
	-4.433274e+02,
	7.896820e+02,
	1.817402e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.795339e+03,
	1.024806e+02,
	0,
	0,
	-2.505222e+04,
	1.240280e+03,
	1.304988e+00,
	5.749444e-03,
	-4.666245e+04,
	4.461716e+03,
	1.801239e+01,
	1.073229e-01,
	-2.724635e+05,
	1.761495e+04,
	9.851115e+01,
	7.710643e-01,
	-4.861356e+05,
	3.717743e+04,
	4.101052e+02,
	4.193261e+00,
	-6.383714e+05,
	6.152061e+04,
	1.168007e+03,
	1.598473e+01,
	-1.205391e+06,
	9.889684e+04,
	2.636565e+03,
	4.738883e+01,
	-1.147720e+06,
	1.106241e+05,
	5.004828e+03,
	1.183715e+02,
	-1.133494e+06,
	1.155726e+05,
	8.024451e+03,
	2.508700e+02,
	-1.063750e+06,
	1.090501e+05,
	1.144213e+04,
	4.682622e+02,
	-7.206625e+05,
	8.651512e+04,
	1.483243e+04,
	7.896286e+02,
	-8.230661e+05,
	7.733914e+04,
	1.788080e+04,
	1.224383e+03,
	-3.893929e+05,
	4.348949e+04,
	2.028440e+04,
	1.779031e+03,
	-4.194027e+05,
	3.349138e+04,
	2.185878e+04,
	2.439030e+03,
	-1.895883e+05,
	1.198418e+04,
	2.268839e+04,
	3.196090e+03,
	-2.138071e+05,
	6.670906e+03,
	2.280864e+04,
	4.026859e+03,
	-6.125361e+04,
	-6.683706e+03,
	2.234923e+04,
	4.916377e+03,
	-1.266566e+05,
	-5.092214e+03,
	2.146339e+04,
	5.838900e+03,
	-3.668092e+04,
	-1.292182e+04,
	2.023530e+04,
	6.783060e+03,
	-4.502149e+04,
	-1.220835e+04,
	1.873724e+04,
	7.722602e+03,
	-6.724879e+03,
	-1.428205e+04,
	1.712856e+04,
	8.645906e+03,
	-3.147242e+04,
	-1.120290e+04,
	1.550800e+04,
	9.537867e+03,
	4.822493e+03,
	-1.299009e+04,
	1.388952e+04,
	1.039406e+04,
	-3.661611e+04,
	-8.222351e+03,
	1.234509e+04,
	1.120095e+04,
	7.706524e+02,
	-1.086522e+04,
	1.080666e+04,
	1.196049e+04,
	-1.428372e+04,
	-7.903936e+03,
	9.320418e+03,
	1.265373e+04,
	-1.558705e+04,
	-6.942237e+03,
	7.944124e+03,
	1.328427e+04,
	3.569541e+03,
	-7.689284e+03,
	6.605008e+03,
	1.384543e+04,
	-2.207606e+04,
	-3.799092e+03,
	5.433831e+03,
	1.433020e+04,
	-2.173362e+04,
	-3.685308e+03,
	4.312741e+03,
	1.475032e+04,
	-1.842206e+04,
	-3.390404e+03,
	3.139013e+03,
	1.508986e+04,
	-4.332377e+04,
	1.904433e+02,
	2.023367e+03,
	1.533848e+04,
	-2.551285e+04,
	-6.475346e+01,
	8.159825e+02,
	1.549771e+04,
};

double solarDataset520[] = 
{
	3.441260e+12,
	4.257012e+05,
	9.159649e+03,
	2.155997e+02,
	-3.813319e+11,
	9.728458e+07,
	1.224196e+04,
	2.157753e+02,
	-8.993466e+09,
	5.812620e+06,
	1.906304e+04,
	2.179990e+02,
	2.219112e+09,
	-1.465148e+06,
	1.997638e+04,
	2.245501e+02,
	-4.029785e+08,
	1.497071e+06,
	2.081556e+04,
	2.372707e+02,
	7.073014e+07,
	4.201511e+05,
	2.262724e+04,
	2.603452e+02,
	1.148052e+08,
	3.113398e+05,
	2.446750e+04,
	2.971461e+02,
	-6.975728e+07,
	9.816228e+05,
	2.748132e+04,
	3.534071e+02,
	4.543997e+07,
	3.776559e+05,
	3.142461e+04,
	4.400715e+02,
	-1.929005e+07,
	8.214878e+05,
	3.615734e+04,
	5.652811e+02,
	-6.188209e+06,
	6.920153e+05,
	4.256955e+04,
	7.501487e+02,
	-2.183429e+07,
	7.943841e+05,
	4.986206e+04,
	1.014418e+03,
	-1.140788e+07,
	5.966216e+05,
	5.766701e+04,
	1.385850e+03,
	-1.246868e+07,
	5.332061e+05,
	6.507698e+04,
	1.885028e+03,
	-1.535117e+07,
	4.615705e+05,
	7.180659e+04,
	2.535598e+03,
	-6.922309e+06,
	2.072982e+05,
	7.639904e+04,
	3.351496e+03,
	-7.654747e+06,
	1.405907e+05,
	7.834404e+04,
	4.319751e+03,
	-3.608348e+06,
	-1.032324e+04,
	7.774929e+04,
	5.429596e+03,
	-3.310273e+06,
	-5.122568e+04,
	7.470562e+04,
	6.644330e+03,
	-1.803698e+06,
	-1.089710e+05,
	6.977953e+04,
	7.932441e+03,
	-4.481058e+05,
	-1.414144e+05,
	6.339972e+04,
	9.249011e+03,
	-8.474652e+05,
	-1.138910e+05,
	5.661672e+04,
	1.055570e+04,
	9.091255e+04,
	-1.286682e+05,
	4.971740e+04,
	1.183266e+04,
	-3.296997e+05,
	-9.203473e+04,
	4.316623e+04,
	1.304789e+04,
	6.138098e+04,
	-9.130578e+04,
	3.710169e+04,
	1.419808e+04,
	8.019984e+04,
	-7.334147e+04,
	3.160993e+04,
	1.526375e+04,
	-1.056039e+05,
	-5.125085e+04,
	2.694897e+04,
	1.624692e+04,
	3.523169e+04,
	-4.850597e+04,
	2.280818e+04,
	1.715304e+04,
	6.870219e+04,
	-3.957775e+04,
	1.917548e+04,
	1.797303e+04,
	-1.326338e+04,
	-2.682913e+04,
	1.621399e+04,
	1.871381e+04,
	1.157345e+03,
	-2.265762e+04,
	1.371834e+04,
	1.938801e+04,
	1.114799e+04,
	-1.872180e+04,
	1.154622e+04,
	1.999570e+04,
	4.035315e+02,
	-1.421776e+04,
	9.712803e+03,
	2.054042e+04,
	-8.685193e+01,
	-1.141822e+04,
	8.163078e+03,
	2.102864e+04,
	2.765763e+03,
	-9.358492e+03,
	6.836780e+03,
	2.146394e+04,
	9.596016e+02,
	-7.320212e+03,
	5.716072e+03,
	2.184997e+04,
	-3.591287e+03,
	-5.538701e+03,
	4.774094e+03,
	2.219169e+04,
	4.877164e+02,
	-4.837933e+03,
	3.959721e+03,
	2.249316e+04,
	-3.944127e+03,
	-3.487922e+03,
	3.263769e+03,
	2.275573e+04,
	-8.194186e+03,
	-2.533610e+03,
	2.659495e+03,
	2.298365e+04,
	1.810861e+03,
	-3.022148e+03,
	2.090564e+03,
	2.317744e+04,
	-8.870991e+03,
	-1.251568e+03,
	1.616934e+03,
	2.333414e+04,
	-1.072378e+04,
	-9.168446e+02,
	1.182863e+03,
	2.346196e+04,
	-1.120528e+04,
	-5.191012e+02,
	7.308553e+02,
	2.355571e+04,
	-8.359487e+03,
	-1.040853e+02,
	3.073388e+02,
	2.361176e+04,
	2.035431e+12,
	2.901375e+07,
	4.780096e+03,
	9.809298e+01,
	-5.474072e+11,
	1.251406e+08,
	7.594803e+03,
	9.819442e+01,
	1.394761e+10,
	-7.629265e+06,
	1.388420e+04,
	9.997117e+01,
	-1.679680e+09,
	2.117312e+06,
	1.337516e+04,
	1.041901e+02,
	8.766416e+08,
	-9.398136e+05,
	1.402618e+04,
	1.131463e+02,
	-1.075785e+08,
	9.687180e+05,
	1.495756e+04,
	1.278750e+02,
	2.864970e+07,
	5.123123e+05,
	1.720256e+04,
	1.533065e+02,
	9.381308e+06,
	5.907406e+05,
	1.985760e+04,
	1.937223e+02,
	6.513705e+05,
	6.528921e+05,
	2.353833e+04,
	2.568166e+02,
	-5.060574e+06,
	7.148069e+05,
	2.845009e+04,
	3.540337e+02,
	-2.618546e+07,
	8.664181e+05,
	3.479716e+04,
	5.020198e+02,
	-3.042888e+06,
	6.182842e+05,
	4.212681e+04,
	7.239051e+02,
	-2.186162e+07,
	7.922891e+05,
	5.016165e+04,
	1.040177e+03,
	-1.315392e+07,
	5.761193e+05,
	5.868562e+04,
	1.485943e+03,
	-1.193382e+07,
	4.596976e+05,
	6.604172e+04,
	2.079489e+03,
	-1.054882e+07,
	3.262631e+05,
	7.180635e+04,
	2.836858e+03,
	-7.325607e+06,
	1.634016e+05,
	7.502793e+04,
	3.759447e+03,
	-3.572050e+06,
	1.753149e+04,
	7.527153e+04,
	4.828034e+03,
	-3.650321e+06,
	-2.059097e+04,
	7.313771e+04,
	6.010651e+03,
	-1.306615e+06,
	-1.038379e+05,
	6.897657e+04,
	7.278719e+03,
	-1.434776e+06,
	-1.010734e+05,
	6.337556e+04,
	8.585264e+03,
	-2.928626e+05,
	-1.291286e+05,
	5.694775e+04,
	9.900359e+03,
	-2.016734e+05,
	-1.130713e+05,
	5.027089e+04,
	1.118410e+04,
	-2.496937e+05,
	-9.435927e+04,
	4.393471e+04,
	1.241926e+04,
	2.877942e+04,
	-8.902541e+04,
	3.793319e+04,
	1.359137e+04,
	-4.486830e+04,
	-6.924231e+04,
	3.248876e+04,
	1.468407e+04,
	6.596483e+04,
	-6.067637e+04,
	2.767914e+04,
	1.569668e+04,
	1.919128e+03,
	-4.535751e+04,
	2.353265e+04,
	1.662511e+04,
	-1.625891e+04,
	-3.587718e+04,
	1.999336e+04,
	1.747626e+04,
	4.744522e+02,
	-2.997748e+04,
	1.689298e+04,
	1.825163e+04,
	4.486151e+04,
	-2.618098e+04,
	1.419742e+04,
	1.895127e+04,
	-1.216274e+04,
	-1.716435e+04,
	1.198976e+04,
	1.957871e+04,
	-1.352060e+03,
	-1.478644e+04,
	1.013202e+04,
	2.014715e+04,
	1.854542e+04,
	-1.309060e+04,
	8.504452e+03,
	2.065628e+04,
	-1.365895e+04,
	-8.081327e+03,
	7.172319e+03,
	2.110940e+04,
	7.774980e+03,
	-8.328556e+03,
	6.022138e+03,
	2.151710e+04,
	-1.162068e+04,
	-5.117308e+03,
	5.035574e+03,
	2.187637e+04,
	5.375795e+02,
	-5.332525e+03,
	4.164918e+03,
	2.219523e+04,
	4.583329e+03,
	-4.486221e+03,
	3.397818e+03,
	2.247013e+04,
	-1.191642e+04,
	-2.061146e+03,
	2.790819e+03,
	2.270630e+04,
	-4.488671e+02,
	-2.946084e+03,
	2.225430e+03,
	2.291181e+04,
	-1.079293e+04,
	-1.286923e+03,
	1.715923e+03,
	2.307911e+04,
	-7.008889e+03,
	-1.462410e+03,
	1.229813e+03,
	2.321411e+04,
	-1.789120e+04,
	1.465535e+02,
	7.731271e+02,
	2.331052e+04,
	-8.173676e+03,
	-1.495901e+02,
	2.878103e+02,
	2.337081e+04,
	1.247757e+12,
	-4.159768e+06,
	4.106319e+03,
	2.671606e+01,
	-1.699001e+11,
	3.477713e+07,
	5.075193e+03,
	2.679200e+01,
	7.370859e+09,
	-4.831578e+06,
	6.046716e+03,
	2.761225e+01,
	1.300189e+09,
	-8.314183e+05,
	5.253834e+03,
	2.933335e+01,
	-4.200184e+08,
	1.179100e+06,
	5.779982e+03,
	3.268336e+01,
	1.995671e+08,
	-6.254952e+04,
	6.866446e+03,
	3.957643e+01,
	-6.307859e+07,
	7.234239e+05,
	8.143396e+03,
	5.096381e+01,
	2.152375e+07,
	3.977221e+05,
	1.040391e+04,
	7.159662e+01,
	-8.539422e+06,
	6.140945e+05,
	1.326918e+04,
	1.058127e+02,
	-1.078821e+07,
	6.779304e+05,
	1.750490e+04,
	1.635930e+02,
	-1.275937e+07,
	7.382400e+05,
	2.313246e+04,
	2.590606e+02,
	-1.872188e+07,
	8.098821e+05,
	3.031069e+04,
	4.127114e+02,
	-1.831776e+07,
	7.681029e+05,
	3.876504e+04,
	6.520684e+02,
	-1.327143e+07,
	6.348936e+05,
	4.759282e+04,
	1.005990e+03,
	-1.250117e+07,
	5.390875e+05,
	5.602596e+04,
	1.500068e+03,
	-1.108426e+07,
	4.074780e+05,
	6.331628e+04,
	2.157158e+03,
	-7.144209e+06,
	2.282751e+05,
	6.830848e+04,
	2.985745e+03,
	-5.593622e+06,
	1.138962e+05,
	7.048728e+04,
	3.973074e+03,
	-2.744275e+06,
	-8.550059e+03,
	6.988463e+04,
	5.096047e+03,
	-2.060504e+06,
	-5.271929e+04,
	6.700169e+04,
	6.315326e+03,
	-1.188937e+06,
	-8.943405e+04,
	6.253661e+04,
	7.597067e+03,
	-7.019956e+05,
	-1.025893e+05,
	5.696328e+04,
	8.901951e+03,
	-1.520013e+05,
	-1.094255e+05,
	5.085384e+04,
	1.019564e+04,
	-4.279199e+05,
	-8.501426e+04,
	4.481075e+04,
	1.144946e+04,
	2.473795e+05,
	-9.671243e+04,
	3.890686e+04,
	1.265006e+04,
	-1.850617e+05,
	-6.070952e+04,
	3.361721e+04,
	1.377212e+04,
	-1.055200e+04,
	-5.889414e+04,
	2.890583e+04,
	1.482700e+04,
	8.554444e+04,
	-5.153152e+04,
	2.458599e+04,
	1.579867e+04,
	-3.284826e+04,
	-3.517891e+04,
	2.094752e+04,
	1.668657e+04,
	2.250379e+04,
	-3.169404e+04,
	1.781798e+04,
	1.750203e+04,
	7.187402e+02,
	-2.410799e+04,
	1.510178e+04,
	1.824183e+04,
	-1.312021e+04,
	-1.879373e+04,
	1.278706e+04,
	1.891267e+04,
	2.993219e+04,
	-1.781145e+04,
	1.075453e+04,
	1.951760e+04,
	-4.534421e+03,
	-1.160389e+04,
	9.076530e+03,
	2.005681e+04,
	-9.759605e+03,
	-9.241454e+03,
	7.683732e+03,
	2.054363e+04,
	1.191358e+04,
	-9.141714e+03,
	6.435051e+03,
	2.097932e+04,
	-8.934994e+03,
	-5.555194e+03,
	5.395231e+03,
	2.136320e+04,
	-6.609238e+03,
	-4.931263e+03,
	4.502483e+03,
	2.170563e+04,
	5.379062e+03,
	-5.019351e+03,
	3.680346e+03,
	2.200446e+04,
	-1.353400e+04,
	-2.242077e+03,
	3.005639e+03,
	2.225951e+04,
	2.319882e+03,
	-3.483057e+03,
	2.379456e+03,
	2.248033e+04,
	-1.195571e+04,
	-1.258098e+03,
	1.838619e+03,
	2.265852e+04,
	-8.857921e+03,
	-1.424507e+03,
	1.329970e+03,
	2.280386e+04,
	-1.138151e+04,
	-6.455122e+02,
	8.319621e+02,
	2.290844e+04,
	-8.381217e+03,
	-2.582078e+02,
	3.786418e+02,
	2.297301e+04,
	-6.454234e+12,
	9.523189e+07,
	2.495739e+03,
	3.168572e+00,
	1.564445e+09,
	-3.199648e+05,
	2.543842e+01,
	3.206831e+00,
	-1.131465e+10,
	7.292156e+06,
	1.655634e+01,
	3.207991e+00,
	4.572081e+08,
	-3.622419e+05,
	1.152075e+03,
	3.598120e+00,
	-1.359952e+08,
	3.523478e+05,
	1.247960e+03,
	4.304180e+00,
	8.530206e+07,
	-7.761152e+04,
	1.537856e+03,
	5.847887e+00,
	-4.046656e+06,
	2.350133e+05,
	1.924059e+03,
	8.398513e+00,
	-9.369154e+06,
	3.013373e+05,
	2.894860e+03,
	1.369454e+01,
	1.558148e+05,
	3.157345e+05,
	4.412027e+03,
	2.445354e+01,
	-9.593296e+06,
	4.737070e+05,
	6.780646e+03,
	4.538315e+01,
	-1.399124e+07,
	5.975570e+05,
	1.057839e+04,
	8.641807e+01,
	-1.458432e+07,
	6.713753e+05,
	1.603092e+04,
	1.636301e+02,
	-1.575957e+07,
	7.190945e+05,
	2.317086e+04,
	3.001042e+02,
	-1.469259e+07,
	6.919930e+05,
	3.170783e+04,
	5.261023e+02,
	-1.349217e+07,
	6.160599e+05,
	4.083870e+04,
	8.742847e+02,
	-1.067177e+07,
	4.778233e+05,
	4.945175e+04,
	1.374014e+03,
	-7.035158e+06,
	3.153236e+05,
	5.638367e+04,
	2.041943e+03,
	-6.267557e+06,
	2.139302e+05,
	6.107922e+04,
	2.878901e+03,
	-3.507150e+06,
	7.645845e+04,
	6.313857e+04,
	3.875261e+03,
	-2.677493e+06,
	9.369796e+03,
	6.254822e+04,
	4.997522e+03,
	-1.075512e+06,
	-6.097170e+04,
	5.980948e+04,
	6.210996e+03,
	-7.903147e+05,
	-7.423698e+04,
	5.563430e+04,
	7.471213e+03,
	-4.489454e+05,
	-8.347235e+04,
	5.072914e+04,
	8.748128e+03,
	-2.919591e+05,
	-8.138940e+04,
	4.543441e+04,
	1.001114e+04,
	-1.257206e+05,
	-7.734475e+04,
	4.007037e+04,
	1.123568e+04,
	7.103736e+04,
	-7.237268e+04,
	3.490447e+04,
	1.240137e+04,
	-1.651301e+05,
	-4.973913e+04,
	3.027758e+04,
	1.349609e+04,
	2.019954e+05,
	-5.792714e+04,
	2.601103e+04,
	1.452225e+04,
	-2.203643e+05,
	-2.570562e+04,
	2.240670e+04,
	1.546308e+04,
	1.590559e+05,
	-4.244143e+04,
	1.908034e+04,
	1.634265e+04,
	-4.466576e+04,
	-2.108640e+04,
	1.622655e+04,
	1.712995e+04,
	-3.174091e+03,
	-2.048205e+04,
	1.388742e+04,
	1.785684e+04,
	2.790637e+04,
	-1.838833e+04,
	1.176019e+04,
	1.851513e+04,
	-2.641650e+04,
	-1.106596e+04,
	1.000103e+04,
	1.910723e+04,
	1.001047e+04,
	-1.197742e+04,
	8.449539e+03,
	1.964524e+04,
	-6.360157e+03,
	-8.288998e+03,
	7.088763e+03,
	2.012232e+04,
	9.035106e+03,
	-7.929982e+03,
	5.927220e+03,
	2.054736e+04,
	-1.377516e+04,
	-4.429300e+03,
	4.963148e+03,
	2.092106e+04,
	-1.844206e+03,
	-4.907418e+03,
	4.100319e+03,
	2.125328e+04,
	-1.021359e+03,
	-3.955754e+03,
	3.315436e+03,
	2.153793e+04,
	-1.171826e+04,
	-2.188327e+03,
	2.657105e+03,
	2.177916e+04,
	-3.402617e+03,
	-2.688462e+03,
	2.032883e+03,
	2.198166e+04,
	-1.058462e+04,
	-1.288381e+03,
	1.472992e+03,
	2.213899e+04,
	-1.978474e+04,
	9.938386e+00,
	9.552157e+02,
	2.225671e+04,
	-1.234013e+04,
	-2.436993e+00,
	3.887609e+02,
	2.233175e+04,
	0,
	0,
	0,
	1.826016e-01,
	-1.781927e+10,
	3.424198e+06,
	0,
	1.826016e-01,
	3.387426e+08,
	-1.818905e+05,
	4.801526e+01,
	2.011516e-01,
	-1.332156e+08,
	1.980034e+05,
	3.787939e+01,
	2.092672e-01,
	7.713524e+06,
	2.074307e+04,
	1.278808e+02,
	2.794094e-01,
	-1.191841e+07,
	6.762032e+04,
	1.970895e+02,
	4.457797e-01,
	1.168172e+07,
	9.597587e+03,
	3.212529e+02,
	8.753281e-01,
	-7.375921e+06,
	1.272459e+05,
	5.312329e+02,
	1.747178e+00,
	-1.857624e+06,
	1.420437e+05,
	1.084825e+03,
	4.192300e+00,
	-4.445982e+06,
	2.336181e+05,
	2.069508e+03,
	1.014047e+01,
	-9.256611e+06,
	3.691046e+05,
	3.961112e+03,
	2.445296e+01,
	-1.146668e+07,
	4.853842e+05,
	7.269072e+03,
	5.735080e+01,
	-1.079778e+07,
	5.581243e+05,
	1.230141e+04,
	1.261528e+02,
	-1.490989e+07,
	6.582014e+05,
	1.920854e+04,
	2.563772e+02,
	-1.194617e+07,
	5.952954e+05,
	2.764421e+04,
	4.835162e+02,
	-1.014583e+07,
	5.122274e+05,
	3.635427e+04,
	8.392605e+02,
	-7.408351e+06,
	3.853587e+05,
	4.438509e+04,
	1.350733e+03,
	-6.570506e+06,
	2.855657e+05,
	5.083123e+04,
	2.031559e+03,
	-3.758086e+06,
	1.418179e+05,
	5.493214e+04,
	2.882348e+03,
	-2.683018e+06,
	6.098002e+04,
	5.642001e+04,
	3.878421e+03,
	-1.659085e+06,
	-4.330207e+03,
	5.570503e+04,
	4.991285e+03,
	-7.795872e+05,
	-4.882689e+04,
	5.316507e+04,
	6.183054e+03,
	-5.845028e+05,
	-5.942304e+04,
	4.949336e+04,
	7.415604e+03,
	-5.798157e+05,
	-6.026377e+04,
	4.517923e+04,
	8.660316e+03,
	1.100702e+05,
	-8.130453e+04,
	4.031747e+04,
	9.888095e+03,
	-6.137872e+04,
	-6.032203e+04,
	3.558748e+04,
	1.106470e+04,
	-1.487668e+05,
	-4.829607e+04,
	3.132184e+04,
	1.219098e+04,
	6.027672e+04,
	-5.086659e+04,
	2.722487e+04,
	1.325775e+04,
	-5.216647e+04,
	-3.589720e+04,
	2.352245e+04,
	1.424838e+04,
	3.877460e+04,
	-3.464697e+04,
	2.023029e+04,
	1.516931e+04,
	2.888551e+03,
	-2.575328e+04,
	1.734715e+04,
	1.601318e+04,
	-2.191980e+04,
	-1.979610e+04,
	1.488919e+04,
	1.678848e+04,
	2.034645e+04,
	-1.902784e+04,
	1.268427e+04,
	1.749745e+04,
	-1.314803e+04,
	-1.300850e+04,
	1.078756e+04,
	1.813689e+04,
	7.781400e+03,
	-1.225965e+04,
	9.144667e+03,
	1.871660e+04,
	-1.204517e+04,
	-8.419968e+03,
	7.723806e+03,
	1.923488e+04,
	7.765000e+03,
	-8.536896e+03,
	6.472742e+03,
	1.969918e+04,
	-4.584280e+03,
	-5.708889e+03,
	5.406950e+03,
	2.010716e+04,
	-7.904211e+03,
	-4.491134e+03,
	4.503836e+03,
	2.046843e+04,
	-5.550058e+03,
	-3.997071e+03,
	3.675945e+03,
	2.078373e+04,
	-5.689591e+03,
	-3.236437e+03,
	2.922488e+03,
	2.105140e+04,
	-7.906009e+03,
	-2.378643e+03,
	2.250590e+03,
	2.127255e+04,
	-9.071692e+03,
	-1.745359e+03,
	1.638712e+03,
	2.144855e+04,
	-2.806270e+04,
	6.649150e+02,
	1.075166e+03,
	2.157900e+04,
	-1.103646e+04,
	-2.530936e+02,
	3.990825e+02,
	2.166428e+04,
	1.172160e+12,
	-1.700048e+07,
	-4.587932e+02,
	9.275000e-03,
	-5.008907e+09,
	9.229085e+05,
	0,
	2.318750e-03,
	3.111030e+07,
	-1.680365e+04,
	3.936294e+00,
	6.956250e-03,
	-5.703770e+07,
	5.741850e+04,
	2.940735e+00,
	7.535938e-03,
	4.750408e+06,
	-7.579855e+03,
	6.576946e+00,
	1.797031e-02,
	-4.550239e+06,
	1.931719e+04,
	6.393513e+00,
	2.202812e-02,
	1.542980e+06,
	4.706168e+03,
	3.340755e+01,
	6.202656e-02,
	-1.997114e+06,
	3.649206e+04,
	7.619777e+01,
	1.739063e-01,
	-1.593482e+06,
	6.356589e+04,
	2.379679e+02,
	6.562062e-01,
	-4.537893e+06,
	1.384804e+05,
	6.466292e+02,
	2.352372e+00,
	-5.704782e+06,
	2.258349e+05,
	1.643354e+03,
	7.932444e+00,
	-8.516026e+06,
	3.526078e+05,
	3.663294e+03,
	2.360140e+01,
	-1.066595e+07,
	4.742071e+05,
	7.292901e+03,
	6.245495e+01,
	-1.234505e+07,
	5.621427e+05,
	1.286902e+04,
	1.467728e+02,
	-1.044587e+07,
	5.508898e+05,
	2.017730e+04,
	3.077457e+02,
	-9.750714e+06,
	5.176087e+05,
	2.845385e+04,
	5.789490e+02,
	-8.773548e+06,
	4.361175e+05,
	3.680154e+04,
	9.938209e+02,
	-4.887482e+06,
	2.768423e+05,
	4.386506e+04,
	1.574100e+03,
	-4.580514e+06,
	2.042767e+05,
	4.895668e+04,
	2.319036e+03,
	-3.037548e+06,
	1.001684e+05,
	5.188273e+04,
	3.224335e+03,
	-1.252849e+06,
	9.423824e+03,
	5.229785e+04,
	4.260421e+03,
	-1.512708e+06,
	-4.514040e+03,
	5.093166e+04,
	5.388799e+03,
	-3.330454e+05,
	-5.840272e+04,
	4.812166e+04,
	6.583262e+03,
	-4.555910e+05,
	-5.259927e+04,
	4.437818e+04,
	7.797270e+03,
	-2.055898e+05,
	-6.043330e+04,
	4.025830e+04,
	9.011318e+03,
	-6.518244e+04,
	-5.931446e+04,
	3.591151e+04,
	1.019675e+04,
	-4.788129e+04,
	-5.148756e+04,
	3.170073e+04,
	1.133492e+04,
	-1.294721e+04,
	-4.516239e+04,
	2.777118e+04,
	1.241608e+04,
	-4.132531e+04,
	-3.650926e+04,
	2.417892e+04,
	1.343242e+04,
	4.353457e+04,
	-3.480201e+04,
	2.089273e+04,
	1.438065e+04,
	-3.999510e+04,
	-2.363060e+04,
	1.802457e+04,
	1.525446e+04,
	1.132551e+04,
	-2.302607e+04,
	1.547307e+04,
	1.606249e+04,
	2.024966e+04,
	-1.900290e+04,
	1.319929e+04,
	1.679741e+04,
	-2.275982e+04,
	-1.253345e+04,
	1.130444e+04,
	1.746504e+04,
	2.065540e+03,
	-1.244152e+04,
	9.619555e+03,
	1.807448e+04,
	1.308942e+04,
	-1.073860e+04,
	8.111327e+03,
	1.861996e+04,
	-1.540943e+04,
	-6.359948e+03,
	6.878335e+03,
	1.910663e+04,
	-6.509802e+03,
	-6.323129e+03,
	5.782487e+03,
	1.954531e+04,
	2.137483e+03,
	-5.897918e+03,
	4.759477e+03,
	1.992990e+04,
	-1.089014e+04,
	-3.529000e+03,
	3.892929e+03,
	2.026106e+04,
	-7.464418e+03,
	-3.372208e+03,
	3.110704e+03,
	2.054648e+04,
	-4.499778e+03,
	-2.965848e+03,
	2.377458e+03,
	2.078153e+04,
	-1.809100e+04,
	-9.389300e+02,
	1.742044e+03,
	2.096658e+04,
	-1.603605e+04,
	-8.315728e+02,
	1.093057e+03,
	2.110637e+04,
	-1.205302e+04,
	-2.096724e+02,
	4.696001e+02,
	2.119034e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-6.475609e+04,
	3.371635e+02,
	0,
	0,
	1.073009e+04,
	4.374122e+02,
	5.797537e-01,
	5.796875e-04,
	-1.153454e+05,
	2.841920e+03,
	2.649198e+00,
	4.057812e-03,
	-4.687182e+05,
	1.144817e+04,
	1.627061e+01,
	3.304219e-02,
	-6.252477e+05,
	3.031476e+04,
	8.224170e+01,
	2.295562e-01,
	-3.526268e+06,
	9.906712e+04,
	3.245361e+02,
	1.211547e+00,
	-3.609003e+06,
	1.630030e+05,
	1.110639e+03,
	5.633403e+00,
	-5.915653e+06,
	2.810662e+05,
	2.834579e+03,
	1.971111e+01,
	-9.862311e+06,
	4.241441e+05,
	6.219224e+03,
	5.787194e+01,
	-8.614873e+06,
	4.527786e+05,
	1.158730e+04,
	1.459555e+02,
	-7.889704e+06,
	4.557367e+05,
	1.837941e+04,
	3.144735e+02,
	-7.157548e+06,
	4.205437e+05,
	2.605154e+04,
	5.981511e+02,
	-6.360659e+06,
	3.497342e+05,
	3.363796e+04,
	1.028460e+03,
	-4.118223e+06,
	2.292622e+05,
	3.992991e+04,
	1.623818e+03,
	-2.878278e+06,
	1.400867e+05,
	4.417527e+04,
	2.379710e+03,
	-1.927495e+06,
	6.762589e+04,
	4.634548e+04,
	3.280857e+03,
	-1.164354e+06,
	1.289313e+04,
	4.655326e+04,
	4.300420e+03,
	-7.359802e+05,
	-1.922557e+04,
	4.517303e+04,
	5.404912e+03,
	-4.551779e+05,
	-3.785206e+04,
	4.265242e+04,
	6.561340e+03,
	-2.858538e+05,
	-4.634143e+04,
	3.937600e+04,
	7.738135e+03,
	-3.103799e+04,
	-5.354515e+04,
	3.567211e+04,
	8.907358e+03,
	-1.299037e+05,
	-4.253021e+04,
	3.196524e+04,
	1.004530e+04,
	-2.685978e+04,
	-4.253756e+04,
	2.836175e+04,
	1.114396e+04,
	-1.368389e+04,
	-3.669976e+04,
	2.491097e+04,
	1.218658e+04,
	-2.352848e+04,
	-3.043266e+04,
	2.175512e+04,
	1.316727e+04,
	-1.339091e+03,
	-2.684603e+04,
	1.887271e+04,
	1.408263e+04,
	1.046307e+04,
	-2.278972e+04,
	1.628025e+04,
	1.492832e+04,
	9.352423e+03,
	-1.845807e+04,
	1.402391e+04,
	1.570518e+04,
	-4.319180e+04,
	-1.193961e+04,
	1.209103e+04,
	1.641770e+04,
	4.028668e+04,
	-1.613776e+04,
	1.026860e+04,
	1.707080e+04,
	-3.050514e+04,
	-7.295972e+03,
	8.739795e+03,
	1.765114e+04,
	8.928799e+03,
	-9.664089e+03,
	7.399996e+03,
	1.818133e+04,
	-7.753111e+03,
	-6.276519e+03,
	6.195452e+03,
	1.864823e+04,
	-6.909366e+03,
	-5.375705e+03,
	5.159494e+03,
	1.906262e+04,
	-3.726578e+03,
	-4.729953e+03,
	4.213524e+03,
	1.942343e+04,
	-9.907304e+03,
	-3.262236e+03,
	3.377412e+03,
	1.973067e+04,
	-4.707397e+03,
	-3.194871e+03,
	2.610089e+03,
	1.998764e+04,
	-2.459705e+04,
	-5.431231e+02,
	1.928936e+03,
	2.019144e+04,
	-1.504684e+04,
	-1.268530e+03,
	1.183585e+03,
	2.034684e+04,
	-1.274940e+04,
	-2.357602e+02,
	5.030266e+02,
	2.043642e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.625111e+03,
	1.942406e+02,
	0,
	0,
	-7.931768e+04,
	2.359336e+03,
	1.133080e+00,
	2.318750e-03,
	-4.492099e+05,
	1.342479e+04,
	1.798340e+01,
	5.101250e-02,
	-7.104236e+05,
	3.641425e+04,
	1.273072e+02,
	5.072266e-01,
	-2.419312e+06,
	1.031931e+05,
	5.258904e+02,
	2.856120e+00,
	-3.805147e+06,
	1.873084e+05,
	1.720050e+03,
	1.257400e+01,
	-5.317208e+06,
	2.798090e+05,
	4.237425e+03,
	4.225574e+01,
	-5.851424e+06,
	3.374836e+05,
	8.437182e+03,
	1.146083e+02,
	-5.507526e+06,
	3.474492e+05,
	1.411444e+04,
	2.603661e+02,
	-4.895399e+06,
	3.204240e+05,
	2.062382e+04,
	5.126727e+02,
	-3.869675e+06,
	2.596800e+05,
	2.709028e+04,
	9.003364e+02,
	-3.250395e+06,
	1.961919e+05,
	3.264631e+04,
	1.439837e+03,
	-1.719326e+06,
	1.064571e+05,
	3.659167e+04,
	2.133101e+03,
	-1.508329e+06,
	6.693764e+04,
	3.878265e+04,
	2.961132e+03,
	-7.388517e+05,
	1.449523e+04,
	3.939682e+04,
	3.906030e+03,
	-7.540220e+05,
	-5.614775e+02,
	3.863621e+04,
	4.934280e+03,
	-7.321527e+04,
	-3.634823e+04,
	3.675864e+04,
	6.019820e+03,
	-3.975025e+05,
	-2.269491e+04,
	3.429005e+04,
	7.123780e+03,
	3.467499e+04,
	-4.367236e+04,
	3.141477e+04,
	8.236199e+03,
	-1.266303e+05,
	-3.044243e+04,
	2.837963e+04,
	9.321237e+03,
	-4.572541e+04,
	-3.225554e+04,
	2.541711e+04,
	1.037709e+04,
	8.047126e+03,
	-3.069461e+04,
	2.246501e+04,
	1.138452e+04,
	2.719321e+02,
	-2.520116e+04,
	1.975091e+04,
	1.233417e+04,
	-3.455116e+04,
	-1.935606e+04,
	1.732791e+04,
	1.322610e+04,
	-4.689464e+03,
	-1.871996e+04,
	1.506835e+04,
	1.405968e+04,
	1.058268e+04,
	-1.648905e+04,
	1.298115e+04,
	1.482619e+04,
	-7.793109e+03,
	-1.216890e+04,
	1.117406e+04,
	1.552613e+04,
	-1.325167e+04,
	-9.935753e+03,
	9.587327e+03,
	1.616604e+04,
	5.085932e+03,
	-9.803685e+03,
	8.123301e+03,
	1.674503e+04,
	-3.985046e+03,
	-7.120467e+03,
	6.844793e+03,
	1.725984e+04,
	-1.845867e+04,
	-4.797864e+03,
	5.745869e+03,
	1.771845e+04,
	5.144229e+03,
	-6.303880e+03,
	4.684891e+03,
	1.812240e+04,
	-1.572588e+04,
	-2.947990e+03,
	3.768049e+03,
	1.846208e+04,
	-1.031994e+04,
	-3.174327e+03,
	2.928434e+03,
	1.875090e+04,
	-1.099561e+04,
	-2.380398e+03,
	2.117366e+03,
	1.897926e+04,
	-3.437355e+04,
	6.816807e+02,
	1.384817e+03,
	1.914731e+04,
	-1.532091e+04,
	-2.375851e+02,
	5.307093e+02,
	1.925714e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.099496e+03,
	3.170007e+01,
	0,
	0,
	-4.582160e+03,
	2.717530e+02,
	2.241895e-01,
	5.796875e-04,
	-3.585634e+04,
	2.139538e+03,
	2.877762e+00,
	9.854688e-03,
	-2.609433e+05,
	1.233333e+04,
	2.712355e+01,
	1.182562e-01,
	-6.784321e+05,
	3.792404e+04,
	1.753766e+02,
	1.005758e+00,
	-1.704870e+06,
	9.086509e+04,
	7.096012e+02,
	5.462395e+00,
	-2.182629e+06,
	1.428588e+05,
	2.081180e+03,
	2.173712e+01,
	-3.045174e+06,
	2.017171e+05,
	4.620780e+03,
	6.547976e+01,
	-3.120058e+06,
	2.258261e+05,
	8.490531e+03,
	1.620580e+02,
	-2.909976e+06,
	2.219603e+05,
	1.329642e+04,
	3.408296e+02,
	-2.611518e+06,
	1.958497e+05,
	1.841926e+04,
	6.296374e+02,
	-1.382570e+06,
	1.339214e+05,
	2.309259e+04,
	1.047807e+03,
	-1.998218e+06,
	1.265819e+05,
	2.695490e+04,
	1.598845e+03,
	-5.702259e+05,
	4.570461e+04,
	2.958101e+04,
	2.288355e+03,
	-8.368829e+05,
	3.927422e+04,
	3.080162e+04,
	3.084010e+03,
	-1.837335e+05,
	-2.241597e+03,
	3.099690e+04,
	3.976339e+03,
	-5.682648e+05,
	6.527088e+03,
	3.032646e+04,
	4.930989e+03,
	5.233127e+04,
	-2.991358e+04,
	2.883729e+04,
	5.936664e+03,
	-1.539996e+05,
	-1.717267e+04,
	2.687146e+04,
	6.947084e+03,
	-8.235537e+04,
	-2.202557e+04,
	2.482136e+04,
	7.962612e+03,
	-7.507519e+04,
	-2.154411e+04,
	2.253483e+04,
	8.960347e+03,
	3.590736e+04,
	-2.572879e+04,
	2.013928e+04,
	9.924107e+03,
	-6.467983e+03,
	-1.870191e+04,
	1.791295e+04,
	1.083747e+04,
	-6.478698e+04,
	-1.295785e+04,
	1.594240e+04,
	1.170658e+04,
	2.068703e+04,
	-1.780974e+04,
	1.394673e+04,
	1.252823e+04,
	1.440187e+03,
	-1.297839e+04,
	1.208844e+04,
	1.328175e+04,
	-2.660685e+04,
	-8.967767e+03,
	1.050701e+04,
	1.397703e+04,
	7.110755e+03,
	-1.063004e+04,
	8.998969e+03,
	1.461637e+04,
	-5.590234e+03,
	-7.510638e+03,
	7.635425e+03,
	1.518826e+04,
	-2.267292e+04,
	-5.019825e+03,
	6.454280e+03,
	1.570168e+04,
	7.270321e+03,
	-7.162343e+03,
	5.284981e+03,
	1.615674e+04,
	-1.519724e+04,
	-3.427299e+03,
	4.271128e+03,
	1.654037e+04,
	-1.855140e+04,
	-2.800418e+03,
	3.361608e+03,
	1.686874e+04,
	-6.231274e+03,
	-3.489017e+03,
	2.421245e+03,
	1.713283e+04,
	-4.271753e+04,
	1.261302e+03,
	1.606297e+03,
	1.732348e+04,
	-1.812555e+04,
	-2.715809e+02,
	6.259157e+02,
	1.745271e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.063987e+03,
	3.054462e+02,
	0,
	0,
	-2.813574e+04,
	1.877042e+03,
	3.553681e+00,
	1.623125e-02,
	-1.257337e+05,
	8.447415e+03,
	3.144681e+01,
	1.930359e-01,
	-3.207497e+05,
	2.447929e+04,
	1.705861e+02,
	1.372700e+00,
	-8.991627e+05,
	5.794734e+04,
	6.304306e+02,
	6.658291e+00,
	-8.788635e+05,
	7.984047e+04,
	1.727592e+03,
	2.451846e+01,
	-1.340991e+06,
	1.142918e+05,
	3.595521e+03,
	6.842863e+01,
	-1.502817e+06,
	1.295800e+05,
	6.381372e+03,
	1.604604e+02,
	-1.121162e+06,
	1.171558e+05,
	9.734555e+03,
	3.246644e+02,
	-1.189577e+06,
	1.116388e+05,
	1.323854e+04,
	5.801037e+02,
	-7.285780e+05,
	8.048449e+04,
	1.653685e+04,
	9.441805e+02,
	-7.755311e+05,
	6.738083e+04,
	1.925313e+04,
	1.419287e+03,
	-3.489333e+05,
	3.413203e+04,
	2.120419e+04,
	2.006116e+03,
	-3.711578e+05,
	2.473199e+04,
	2.231455e+04,
	2.686863e+03,
	-1.949665e+05,
	6.860180e+03,
	2.271868e+04,
	3.451178e+03,
	-2.043607e+05,
	1.205191e+03,
	2.244544e+04,
	4.276031e+03,
	-2.253753e+04,
	-1.242250e+04,
	2.160182e+04,
	5.143546e+03,
	-1.162624e+05,
	-7.671662e+03,
	2.043880e+04,
	6.027415e+03,
	-1.819840e+04,
	-1.508886e+04,
	1.904169e+04,
	6.921183e+03,
	-3.748045e+04,
	-1.282426e+04,
	1.746345e+04,
	7.800341e+03,
	-2.463956e+04,
	-1.307192e+04,
	1.585114e+04,
	8.657676e+03,
	1.800068e+04,
	-1.453209e+04,
	1.420241e+04,
	9.480546e+03,
	-5.751030e+04,
	-7.191141e+03,
	1.269744e+04,
	1.025942e+04,
	2.143863e+04,
	-1.325078e+04,
	1.115837e+04,
	1.100036e+04,
	-2.937991e+04,
	-6.800654e+03,
	9.704313e+03,
	1.167727e+04,
	6.744357e+03,
	-9.354022e+03,
	8.348776e+03,
	1.230400e+04,
	-1.635229e+04,
	-5.637506e+03,
	7.095223e+03,
	1.286429e+04,
	-9.355270e+03,
	-5.739525e+03,
	5.942650e+03,
	1.336770e+04,
	-1.379714e+04,
	-4.465673e+03,
	4.833668e+03,
	1.380493e+04,
	-1.440112e+04,
	-3.753966e+03,
	3.778207e+03,
	1.417440e+04,
	-1.584389e+04,
	-2.861359e+03,
	2.766756e+03,
	1.447096e+04,
	-4.596605e+04,
	9.777166e+02,
	1.817438e+03,
	1.469152e+04,
	-1.955254e+04,
	-3.565949e+02,
	6.882263e+02,
	1.483566e+04,
};

double solarDataset560[] = 
{
	9.427478e+12,
	-2.974054e+07,
	3.050751e+04,
	6.870437e+02,
	-1.142007e+12,
	2.473531e+08,
	3.788610e+04,
	6.876090e+02,
	6.030303e+10,
	-3.189085e+07,
	4.769687e+04,
	6.937756e+02,
	-1.001912e+10,
	1.190166e+07,
	4.621301e+04,
	7.080949e+02,
	2.017518e+09,
	-2.733973e+06,
	4.916779e+04,
	7.398116e+02,
	-1.421427e+08,
	1.460792e+06,
	5.011031e+04,
	7.908346e+02,
	-1.387029e+07,
	8.966726e+05,
	5.364395e+04,
	8.724855e+02,
	9.871561e+06,
	7.113724e+05,
	5.737052e+04,
	9.940749e+02,
	1.877554e+07,
	6.336258e+05,
	6.176658e+04,
	1.167487e+03,
	-3.308155e+07,
	8.873357e+05,
	6.729500e+04,
	1.408380e+03,
	-9.604436e+06,
	6.024616e+05,
	7.341952e+04,
	1.738737e+03,
	-2.182764e+07,
	6.203282e+05,
	7.935645e+04,
	2.175477e+03,
	-1.396323e+07,
	4.168430e+05,
	8.478006e+04,
	2.740602e+03,
	-1.869470e+07,
	3.550893e+05,
	8.878213e+04,
	3.445876e+03,
	-8.924426e+06,
	9.938325e+04,
	9.049216e+04,
	4.298909e+03,
	-6.077214e+06,
	-9.169328e+03,
	8.948659e+04,
	5.283471e+03,
	-9.030289e+06,
	-1.361099e+04,
	8.644249e+04,
	6.382569e+03,
	-6.018017e+05,
	-2.166279e+05,
	8.068593e+04,
	7.572041e+03,
	-2.261151e+06,
	-1.582668e+05,
	7.336941e+04,
	8.793475e+03,
	-1.285988e+06,
	-1.711686e+05,
	6.563977e+04,
	1.003020e+04,
	-3.781520e+05,
	-1.714659e+05,
	5.741413e+04,
	1.124523e+04,
	6.312955e+04,
	-1.524940e+05,
	4.942384e+04,
	1.240834e+04,
	-2.965801e+05,
	-1.122897e+05,
	4.224018e+04,
	1.350369e+04,
	3.140122e+04,
	-1.022589e+05,
	3.574972e+04,
	1.452741e+04,
	6.861713e+04,
	-8.171721e+04,
	2.998492e+04,
	1.546584e+04,
	8.598786e+04,
	-6.438726e+04,
	2.510945e+04,
	1.632002e+04,
	-5.450437e+04,
	-4.482419e+04,
	2.107040e+04,
	1.709492e+04,
	3.899927e+04,
	-4.009451e+04,
	1.759867e+04,
	1.779846e+04,
	3.081603e+04,
	-3.072117e+04,
	1.464125e+04,
	1.842779e+04,
	2.777883e+04,
	-2.372218e+04,
	1.222329e+04,
	1.899091e+04,
	-2.403858e+04,
	-1.592528e+04,
	1.025673e+04,
	1.949554e+04,
	2.604334e+04,
	-1.580705e+04,
	8.557456e+03,
	1.994946e+04,
	-6.779180e+03,
	-1.020950e+04,
	7.140866e+03,
	2.035049e+04,
	1.072751e+04,
	-9.367305e+03,
	5.964755e+03,
	2.070901e+04,
	-7.568154e+03,
	-6.091544e+03,
	4.985814e+03,
	2.102574e+04,
	7.747026e+03,
	-6.090631e+03,
	4.149838e+03,
	2.130780e+04,
	-5.115560e+03,
	-3.749778e+03,
	3.454636e+03,
	2.155454e+04,
	2.055488e+03,
	-3.682627e+03,
	2.865067e+03,
	2.177309e+04,
	-8.313760e+03,
	-2.062212e+03,
	2.362034e+03,
	2.196277e+04,
	2.244934e+03,
	-2.716908e+03,
	1.899309e+03,
	2.212797e+04,
	-8.606358e+03,
	-1.085119e+03,
	1.504703e+03,
	2.226472e+04,
	7.692302e+02,
	-1.849182e+03,
	1.134821e+03,
	2.237930e+04,
	-4.992822e+03,
	-7.414604e+02,
	8.237234e+02,
	2.246625e+04,
	-2.212781e+04,
	1.130582e+03,
	5.545028e+02,
	2.253265e+04,
	-2.342747e+03,
	-3.239579e+02,
	1.400637e+02,
	2.257701e+04,
	-5.454661e+13,
	6.695227e+08,
	7.553013e+04,
	3.151823e+02,
	1.134950e+12,
	-2.733669e+08,
	4.998801e+04,
	3.164039e+02,
	2.457067e+09,
	-5.372394e+05,
	3.359107e+04,
	3.204494e+02,
	1.705050e+09,
	-3.885735e+05,
	3.402986e+04,
	3.314798e+02,
	-4.762097e+08,
	1.872482e+06,
	3.561497e+04,
	3.534683e+02,
	2.502076e+08,
	3.098756e+05,
	3.797324e+04,
	3.924344e+02,
	9.657814e+05,
	9.594652e+05,
	4.079242e+04,
	4.537291e+02,
	2.387841e+07,
	8.134300e+05,
	4.500723e+04,
	5.476404e+02,
	-3.806754e+07,
	1.053126e+06,
	5.035453e+04,
	6.862488e+02,
	1.459099e+06,
	7.335645e+05,
	5.663526e+04,
	8.873484e+02,
	-2.588512e+07,
	8.852511e+05,
	6.358440e+04,
	1.168074e+03,
	-2.562254e+07,
	7.542671e+05,
	7.115830e+04,
	1.554880e+03,
	-1.380731e+07,
	5.011328e+05,
	7.788194e+04,
	2.068958e+03,
	-1.739894e+07,
	4.295264e+05,
	8.327746e+04,
	2.724056e+03,
	-1.402960e+07,
	2.469259e+05,
	8.673685e+04,
	3.532888e+03,
	-5.683137e+06,
	1.809832e+04,
	8.712896e+04,
	4.487490e+03,
	-7.386279e+06,
	-5.267831e+03,
	8.494526e+04,
	5.562255e+03,
	-2.550597e+06,
	-1.428422e+05,
	8.040191e+04,
	6.736888e+03,
	-2.244178e+06,
	-1.494782e+05,
	7.395598e+04,
	7.964592e+03,
	-9.741098e+05,
	-1.707178e+05,
	6.655347e+04,
	9.214554e+03,
	-7.847748e+05,
	-1.541107e+05,
	5.870751e+04,
	1.045010e+04,
	4.829605e+04,
	-1.529932e+05,
	5.089533e+04,
	1.164534e+04,
	-2.588837e+05,
	-1.146882e+05,
	4.366237e+04,
	1.277539e+04,
	8.471593e+04,
	-1.046703e+05,
	3.712384e+04,
	1.383538e+04,
	-3.204309e+04,
	-7.873300e+04,
	3.135177e+04,
	1.481233e+04,
	3.884792e+04,
	-6.547482e+04,
	2.637054e+04,
	1.570881e+04,
	3.311172e+04,
	-5.122588e+04,
	2.209839e+04,
	1.652310e+04,
	5.272904e+04,
	-4.098012e+04,
	1.850837e+04,
	1.725973e+04,
	-2.098666e+04,
	-2.870596e+04,
	1.554469e+04,
	1.792411e+04,
	-7.645698e+03,
	-2.392850e+04,
	1.302179e+04,
	1.852490e+04,
	4.529440e+04,
	-2.168625e+04,
	1.082138e+04,
	1.906182e+04,
	7.563854e+03,
	-1.438042e+04,
	9.049216e+03,
	1.953729e+04,
	-2.029968e+04,
	-9.904209e+03,
	7.633053e+03,
	1.996482e+04,
	2.455605e+04,
	-1.104624e+04,
	6.369259e+03,
	2.034892e+04,
	-2.217501e+04,
	-5.312960e+03,
	5.335176e+03,
	2.068618e+04,
	1.389523e+04,
	-7.222185e+03,
	4.429009e+03,
	2.098929e+04,
	3.350305e+03,
	-4.596824e+03,
	3.664659e+03,
	2.125113e+04,
	-1.643678e+04,
	-2.165698e+03,
	3.078933e+03,
	2.148290e+04,
	8.244762e+03,
	-4.103965e+03,
	2.503118e+03,
	2.168904e+04,
	-4.309852e+03,
	-1.906462e+03,
	2.019271e+03,
	2.186052e+04,
	-4.502906e+03,
	-1.615093e+03,
	1.627422e+03,
	2.200877e+04,
	-6.673494e+03,
	-1.145054e+03,
	1.256210e+03,
	2.213245e+04,
	-4.431929e+03,
	-1.125020e+03,
	8.934107e+02,
	2.223054e+04,
	-1.277831e+04,
	1.017818e+02,
	5.672148e+02,
	2.230057e+04,
	-6.550689e+03,
	-6.795150e+01,
	2.200245e+02,
	2.234508e+04,
	7.028093e+11,
	-5.632931e+06,
	1.212518e+04,
	8.786962e+01,
	1.096934e+10,
	3.427657e+06,
	1.255748e+04,
	8.808056e+01,
	-8.620693e+09,
	6.311300e+06,
	1.386382e+04,
	8.966498e+01,
	1.905895e+09,
	-7.785063e+05,
	1.522377e+04,
	9.457978e+01,
	-6.642623e+08,
	2.069152e+06,
	1.655659e+04,
	1.044673e+02,
	2.755384e+08,
	1.270856e+05,
	1.870469e+04,
	1.233922e+02,
	-1.858521e+07,
	9.802503e+05,
	2.113739e+04,
	1.541094e+02,
	1.127113e+07,
	8.555788e+05,
	2.516211e+04,
	2.048864e+02,
	-2.155426e+07,
	1.035915e+06,
	3.043400e+04,
	2.857281e+02,
	-2.670990e+07,
	1.046843e+06,
	3.727913e+04,
	4.129363e+02,
	-2.064658e+07,
	9.583745e+05,
	4.531105e+04,
	6.072056e+02,
	-2.771027e+07,
	9.488663e+05,
	5.423102e+04,
	8.931027e+02,
	-2.275812e+07,
	7.675189e+05,
	6.332478e+04,
	1.299785e+03,
	-1.807120e+07,
	5.679364e+05,
	7.127246e+04,
	1.849876e+03,
	-1.307118e+07,
	3.611235e+05,
	7.716269e+04,
	2.557254e+03,
	-1.108885e+07,
	2.095800e+05,
	8.037925e+04,
	3.422462e+03,
	-4.138438e+06,
	-1.246738e+03,
	8.045019e+04,
	4.432538e+03,
	-5.721080e+06,
	-1.375766e+04,
	7.795263e+04,
	5.553735e+03,
	-1.846673e+06,
	-1.340584e+05,
	7.320954e+04,
	6.762429e+03,
	-7.381453e+05,
	-1.533237e+05,
	6.672674e+04,
	8.006215e+03,
	-1.220612e+06,
	-1.255252e+05,
	5.983885e+04,
	9.253691e+03,
	-4.493834e+05,
	-1.350154e+05,
	5.265160e+04,
	1.048256e+04,
	2.241188e+05,
	-1.320572e+05,
	4.542483e+04,
	1.165807e+04,
	-1.586451e+05,
	-9.300775e+04,
	3.897017e+04,
	1.276097e+04,
	-8.185331e+04,
	-7.944104e+04,
	3.326870e+04,
	1.379450e+04,
	1.437491e+05,
	-7.221282e+04,
	2.809949e+04,
	1.474832e+04,
	-8.452171e+04,
	-4.730130e+04,
	2.373007e+04,
	1.561713e+04,
	7.065088e+04,
	-4.526031e+04,
	1.995960e+04,
	1.641256e+04,
	-1.228967e+04,
	-3.137736e+04,
	1.674335e+04,
	1.712822e+04,
	8.313530e+04,
	-2.961873e+04,
	1.404205e+04,
	1.777530e+04,
	-9.556767e+04,
	-1.350497e+04,
	1.188112e+04,
	1.835489e+04,
	7.279899e+04,
	-2.152115e+04,
	9.918036e+03,
	1.888459e+04,
	-1.801529e+04,
	-1.047619e+04,
	8.284368e+03,
	1.934672e+04,
	1.422292e+04,
	-1.081166e+04,
	6.978533e+03,
	1.976507e+04,
	-1.971096e+04,
	-6.232236e+03,
	5.867255e+03,
	2.013646e+04,
	2.555580e+04,
	-8.493675e+03,
	4.875924e+03,
	2.046942e+04,
	-2.220971e+04,
	-2.736626e+03,
	4.094432e+03,
	2.075821e+04,
	6.086730e+03,
	-4.963141e+03,
	3.401028e+03,
	2.102006e+04,
	-4.421174e+03,
	-2.900042e+03,
	2.775707e+03,
	2.124349e+04,
	-4.520515e+03,
	-2.411202e+03,
	2.253152e+03,
	2.143723e+04,
	-2.508622e+03,
	-2.146013e+03,
	1.775733e+03,
	2.160097e+04,
	-2.936199e+03,
	-1.618598e+03,
	1.357499e+03,
	2.173462e+04,
	-9.367685e+03,
	-6.231229e+02,
	9.992896e+02,
	2.184062e+04,
	-1.206672e+04,
	-1.719530e+02,
	6.376552e+02,
	2.192089e+04,
	-8.102102e+03,
	-5.838292e+00,
	2.573335e+02,
	2.197034e+04,
	-4.403129e+12,
	5.670988e+07,
	4.522792e+03,
	1.062499e+01,
	1.009104e+11,
	-2.052389e+07,
	2.552832e+03,
	1.069725e+01,
	-1.358716e+10,
	8.667774e+06,
	2.007574e+03,
	1.088375e+01,
	9.860870e+08,
	-7.696195e+05,
	3.312868e+03,
	1.199369e+01,
	-7.263205e+07,
	5.079683e+05,
	3.534528e+03,
	1.404941e+01,
	6.095618e+07,
	2.370154e+05,
	4.361871e+03,
	1.824319e+01,
	1.451466e+07,
	4.286776e+05,
	5.555429e+03,
	2.590389e+01,
	-1.400850e+07,
	6.184504e+05,
	7.641043e+03,
	4.027263e+01,
	-1.241073e+07,
	6.950653e+05,
	1.088771e+04,
	6.743470e+01,
	-1.795027e+07,
	8.260387e+05,
	1.556669e+04,
	1.172372e+02,
	-2.319572e+07,
	9.411195e+05,
	2.210913e+04,
	2.061525e+02,
	-3.010013e+07,
	1.015888e+06,
	3.058323e+04,
	3.586307e+02,
	-2.022242e+07,
	8.484787e+05,
	4.025853e+04,
	6.058539e+02,
	-1.910299e+07,
	7.492166e+05,
	5.001245e+04,
	9.760963e+02,
	-1.557142e+07,
	5.745389e+05,
	5.904610e+04,
	1.498265e+03,
	-1.230740e+07,
	3.873126e+05,
	6.601791e+04,
	2.188449e+03,
	-6.940073e+06,
	1.748956e+05,
	6.994206e+04,
	3.045149e+03,
	-5.177292e+06,
	6.314485e+04,
	7.073880e+04,
	4.045467e+03,
	-2.366516e+06,
	-4.755500e+04,
	6.884163e+04,
	5.161344e+03,
	-2.358205e+06,
	-6.773915e+04,
	6.493284e+04,
	6.352030e+03,
	-5.046368e+05,
	-1.245616e+05,
	5.953143e+04,
	7.585005e+03,
	-7.352958e+05,
	-1.050440e+05,
	5.340095e+04,
	8.814996e+03,
	-4.712122e+04,
	-1.140651e+05,
	4.711703e+04,
	1.002166e+04,
	-1.940792e+05,
	-9.000891e+04,
	4.104669e+04,
	1.117633e+04,
	-5.334300e+04,
	-8.040981e+04,
	3.542982e+04,
	1.227079e+04,
	3.617207e+04,
	-6.882656e+04,
	3.028288e+04,
	1.329163e+04,
	3.113110e+04,
	-5.478774e+04,
	2.577621e+04,
	1.423360e+04,
	-6.129565e+04,
	-4.010649e+04,
	2.191962e+04,
	1.509901e+04,
	8.799100e+04,
	-3.960913e+04,
	1.850097e+04,
	1.589132e+04,
	-3.273914e+04,
	-2.471044e+04,
	1.563896e+04,
	1.660515e+04,
	5.062606e+04,
	-2.465741e+04,
	1.321567e+04,
	1.725598e+04,
	-4.331664e+04,
	-1.394978e+04,
	1.119464e+04,
	1.784036e+04,
	2.151457e+04,
	-1.584838e+04,
	9.420701e+03,
	1.837225e+04,
	2.057252e+04,
	-1.209662e+04,
	7.881816e+03,
	1.884308e+04,
	-3.218097e+04,
	-5.996226e+03,
	6.685549e+03,
	1.926382e+04,
	1.272473e+04,
	-8.675284e+03,
	5.581521e+03,
	1.964513e+04,
	1.293397e+04,
	-6.525058e+03,
	4.612838e+03,
	1.997558e+04,
	-2.512579e+04,
	-2.085553e+03,
	3.897889e+03,
	2.026666e+04,
	9.631166e+03,
	-5.124486e+03,
	3.195860e+03,
	2.052944e+04,
	-8.369392e+03,
	-2.217471e+03,
	2.579994e+03,
	2.074865e+04,
	-4.945385e+03,
	-2.272369e+03,
	2.058660e+03,
	2.093800e+04,
	-3.084443e+03,
	-1.973310e+03,
	1.566386e+03,
	2.109326e+04,
	-7.303688e+03,
	-1.067347e+03,
	1.141462e+03,
	2.121494e+04,
	-1.970787e+04,
	4.640662e+02,
	7.508659e+02,
	2.130630e+04,
	-7.520008e+03,
	-1.899019e+02,
	2.755003e+02,
	2.136575e+04,
	1.985745e+12,
	-2.912097e+07,
	-7.661830e+02,
	6.684121e-01,
	-6.636634e+08,
	2.990354e+05,
	0,
	6.567228e-01,
	-2.343986e+09,
	1.611661e+06,
	4.317728e+01,
	6.599108e-01,
	2.254208e+07,
	4.359743e+04,
	3.445681e+02,
	7.645827e-01,
	1.156883e+07,
	5.539843e+04,
	4.276905e+02,
	1.007931e+00,
	1.328478e+07,
	6.727963e+04,
	5.825680e+02,
	1.532353e+00,
	-1.427828e+06,
	1.497926e+05,
	8.917103e+02,
	2.663022e+00,
	9.122115e+05,
	2.061081e+05,
	1.527034e+03,
	5.318074e+00,
	-1.436027e+07,
	3.894326e+05,
	2.751124e+03,
	1.153834e+01,
	-1.297819e+07,
	4.891972e+05,
	5.061759e+03,
	2.652661e+01,
	-1.440164e+07,
	6.231437e+05,
	8.782631e+03,
	5.952481e+01,
	-2.071955e+07,
	7.895515e+05,
	1.448705e+04,
	1.272475e+02,
	-2.105556e+07,
	8.342286e+05,
	2.238247e+04,
	2.567244e+02,
	-1.730582e+07,
	7.638287e+05,
	3.174262e+04,
	4.810755e+02,
	-1.649409e+07,
	6.787079e+05,
	4.153117e+04,
	8.337819e+02,
	-1.213281e+07,
	4.915370e+05,
	5.044160e+04,
	1.344592e+03,
	-7.204027e+06,
	2.923513e+05,
	5.703735e+04,
	2.024137e+03,
	-6.395770e+06,
	1.876444e+05,
	6.098537e+04,
	2.865273e+03,
	-3.652266e+06,
	5.084202e+04,
	6.211538e+04,
	3.853040e+03,
	-1.242084e+06,
	-4.545439e+04,
	6.048160e+04,
	4.948354e+03,
	-2.077700e+06,
	-3.761168e+04,
	5.725210e+04,
	6.110893e+03,
	-4.035125e+05,
	-9.878235e+04,
	5.267188e+04,
	7.316266e+03,
	-2.774259e+05,
	-9.184399e+04,
	4.725635e+04,
	8.513608e+03,
	-7.489327e+04,
	-8.630250e+04,
	4.187600e+04,
	9.683030e+03,
	-1.824318e+05,
	-6.931827e+04,
	3.676257e+04,
	1.080698e+04,
	-2.043178e+04,
	-6.528394e+04,
	3.193106e+04,
	1.187602e+04,
	-2.125564e+04,
	-5.356901e+04,
	2.747061e+04,
	1.287528e+04,
	3.802628e+04,
	-4.622590e+04,
	2.349523e+04,
	1.380133e+04,
	-1.011949e+04,
	-3.479996e+04,
	2.005371e+04,
	1.465185e+04,
	1.957445e+04,
	-2.979789e+04,
	1.707635e+04,
	1.543211e+04,
	-2.310000e+04,
	-2.169519e+04,
	1.451302e+04,
	1.614210e+04,
	4.887815e+04,
	-2.176628e+04,
	1.226507e+04,
	1.678755e+04,
	-3.010570e+04,
	-1.212523e+04,
	1.041726e+04,
	1.736624e+04,
	1.141261e+04,
	-1.307324e+04,
	8.823028e+03,
	1.789421e+04,
	2.115730e+03,
	-9.658469e+03,
	7.420827e+03,
	1.836449e+04,
	-3.130044e+03,
	-7.419199e+03,
	6.255799e+03,
	1.878518e+04,
	-1.015496e+04,
	-5.605767e+03,
	5.248800e+03,
	1.916053e+04,
	1.197197e+04,
	-6.387298e+03,
	4.331709e+03,
	1.949224e+04,
	-9.451760e+03,
	-3.045742e+03,
	3.592623e+03,
	1.977809e+04,
	-9.143314e+03,
	-2.779727e+03,
	2.959049e+03,
	2.003133e+04,
	-4.060531e+02,
	-3.138927e+03,
	2.331861e+03,
	2.024720e+04,
	-8.374759e+03,
	-1.630913e+03,
	1.790562e+03,
	2.042217e+04,
	-9.631227e+03,
	-1.214229e+03,
	1.300725e+03,
	2.056279e+04,
	-1.757971e+04,
	-7.909526e+00,
	8.217597e+02,
	2.066585e+04,
	-9.360190e+03,
	-1.008561e+02,
	3.151603e+02,
	2.072972e+04,
	7.057544e+11,
	-1.002630e+07,
	-2.834657e+02,
	2.019051e-02,
	-5.762712e+09,
	1.096773e+06,
	0,
	1.593987e-02,
	9.580494e+07,
	-5.116182e+04,
	1.296875e+01,
	2.178450e-02,
	-7.314732e+07,
	8.930245e+04,
	1.028639e+01,
	2.390981e-02,
	1.212836e+07,
	-1.522072e+04,
	3.493413e+01,
	4.781962e-02,
	1.107723e+06,
	1.523353e+04,
	4.315452e+01,
	8.182469e-02,
	-3.122114e+06,
	4.692205e+04,
	9.912353e+01,
	1.912785e-01,
	-1.218946e+05,
	6.710879e+04,
	2.596781e+02,
	6.004020e-01,
	-7.767512e+06,
	1.781769e+05,
	6.475762e+02,
	1.923412e+00,
	-7.081599e+06,
	2.703169e+05,
	1.654503e+03,
	6.432271e+00,
	-1.388268e+07,
	4.599894e+05,
	3.716433e+03,
	1.933826e+01,
	-1.677008e+07,
	6.152583e+05,
	7.609712e+03,
	5.293951e+01,
	-1.773788e+07,
	7.158283e+05,
	1.367450e+04,
	1.284552e+02,
	-1.673161e+07,
	7.330517e+05,
	2.177075e+04,
	2.764208e+02,
	-1.582636e+07,
	6.844310e+05,
	3.113206e+04,
	5.328466e+02,
	-1.143484e+07,
	5.250286e+05,
	4.040399e+04,
	9.320810e+02,
	-7.912410e+06,
	3.651709e+05,
	4.815568e+04,
	1.493388e+03,
	-6.534461e+06,
	2.459158e+05,
	5.373328e+04,
	2.221905e+03,
	-3.824178e+06,
	1.046254e+05,
	5.660509e+04,
	3.108860e+03,
	-2.225738e+06,
	1.563807e+04,
	5.671396e+04,
	4.122526e+03,
	-1.458328e+06,
	-3.221722e+04,
	5.474607e+04,
	5.227111e+03,
	-8.183570e+05,
	-6.333746e+04,
	5.127832e+04,
	6.386920e+03,
	-2.794557e+05,
	-7.986545e+04,
	4.684627e+04,
	7.565535e+03,
	-3.250386e+05,
	-7.038672e+04,
	4.208904e+04,
	8.732396e+03,
	-1.754872e+05,
	-6.847775e+04,
	3.727257e+04,
	9.869589e+03,
	1.159607e+05,
	-6.912938e+04,
	3.251333e+04,
	1.095548e+04,
	-9.178916e+04,
	-4.742331e+04,
	2.825702e+04,
	1.197515e+04,
	-3.478289e+04,
	-4.291868e+04,
	2.444894e+04,
	1.293450e+04,
	4.096451e+04,
	-3.883179e+04,
	2.093198e+04,
	1.382302e+04,
	1.018149e+04,
	-2.939198e+04,
	1.788632e+04,
	1.463685e+04,
	-6.312718e+03,
	-2.298834e+04,
	1.530245e+04,
	1.538327e+04,
	8.853193e+01,
	-1.922555e+04,
	1.304664e+04,
	1.606557e+04,
	-4.315150e+03,
	-1.538511e+04,
	1.107414e+04,
	1.668446e+04,
	2.613878e+04,
	-1.434570e+04,
	9.354640e+03,
	1.724279e+04,
	-3.056698e+04,
	-7.440654e+03,
	7.953552e+03,
	1.774252e+04,
	1.201257e+04,
	-9.709738e+03,
	6.690044e+03,
	1.819679e+04,
	2.315698e+03,
	-6.742600e+03,
	5.577442e+03,
	1.859490e+04,
	-9.440768e+03,
	-4.516726e+03,
	4.681297e+03,
	1.894793e+04,
	1.196941e+03,
	-4.741381e+03,
	3.874527e+03,
	1.926086e+04,
	-7.702191e+03,
	-2.981726e+03,
	3.168711e+03,
	1.953055e+04,
	-8.882011e+03,
	-2.461540e+03,
	2.537074e+03,
	1.976277e+04,
	-1.422894e+03,
	-2.714319e+03,
	1.927726e+03,
	1.995485e+04,
	-1.333538e+04,
	-8.409366e+02,
	1.410345e+03,
	2.010401e+04,
	-1.909208e+04,
	-3.880590e+01,
	9.041545e+02,
	2.021755e+04,
	-1.040053e+04,
	-1.016679e+02,
	3.480591e+02,
	2.028776e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.747318e+05,
	3.472389e+03,
	0,
	0,
	4.067195e+05,
	-3.625279e+02,
	3.698487e+00,
	4.781962e-03,
	-2.201325e+05,
	7.112541e+03,
	7.958936e+00,
	1.540855e-02,
	-1.375506e+06,
	3.099300e+04,
	4.379474e+01,
	9.351393e-02,
	-2.748196e+06,
	8.093983e+04,
	2.179212e+02,
	6.189985e-01,
	-4.968397e+06,
	1.759744e+05,
	7.942168e+02,
	3.123153e+00,
	-9.224231e+06,
	3.310828e+05,
	2.317096e+03,
	1.246073e+01,
	-1.172345e+07,
	4.760308e+05,
	5.552592e+03,
	4.086665e+01,
	-1.364940e+07,
	5.855323e+05,
	1.095084e+04,
	1.106753e+02,
	-1.160214e+07,
	5.818835e+05,
	1.835230e+04,
	2.545476e+02,
	-1.186484e+07,
	5.618680e+05,
	2.689271e+04,
	5.080793e+02,
	-8.404699e+06,
	4.221755e+05,
	3.536085e+04,
	9.063264e+02,
	-5.194575e+06,
	2.784763e+05,
	4.225115e+04,
	1.464581e+03,
	-5.350129e+06,
	2.094167e+05,
	4.716334e+04,
	2.183139e+03,
	-1.602308e+06,
	5.042204e+04,
	4.954778e+04,
	3.054031e+03,
	-2.214826e+06,
	3.646787e+04,
	4.967168e+04,
	4.035868e+03,
	-9.356126e+05,
	-3.084597e+04,
	4.811762e+04,
	5.110060e+03,
	-4.549349e+05,
	-5.386665e+04,
	4.503815e+04,
	6.230077e+03,
	-3.040345e+05,
	-5.796460e+04,
	4.128150e+04,
	7.364268e+03,
	-1.176667e+05,
	-6.013046e+04,
	3.722607e+04,
	8.489020e+03,
	-2.285004e+05,
	-4.899339e+04,
	3.315231e+04,
	9.583239e+03,
	1.171614e+05,
	-5.738783e+04,
	2.908158e+04,
	1.063408e+04,
	-6.209781e+04,
	-3.832039e+04,
	2.537658e+04,
	1.162023e+04,
	-2.092407e+04,
	-3.477457e+04,
	2.209397e+04,
	1.255044e+04,
	7.150074e+03,
	-3.032506e+04,
	1.906153e+04,
	1.341566e+04,
	-1.872806e+04,
	-2.346902e+04,
	1.637525e+04,
	1.421280e+04,
	3.845397e+04,
	-2.256213e+04,
	1.398698e+04,
	1.494422e+04,
	-2.212050e+04,
	-1.416819e+04,
	1.197514e+04,
	1.560777e+04,
	1.117884e+04,
	-1.415931e+04,
	1.022919e+04,
	1.621605e+04,
	-9.805903e+03,
	-9.936432e+03,
	8.698553e+03,
	1.676423e+04,
	-6.284957e+03,
	-8.619152e+03,
	7.363785e+03,
	1.725975e+04,
	8.194854e+03,
	-8.133936e+03,
	6.160163e+03,
	1.770134e+04,
	-1.348632e+03,
	-5.585066e+03,
	5.156021e+03,
	1.808984e+04,
	-2.129218e+04,
	-3.033875e+03,
	4.322259e+03,
	1.843476e+04,
	1.090528e+04,
	-5.636095e+03,
	3.481772e+03,
	1.873867e+04,
	-1.576162e+04,
	-1.719787e+03,
	2.785226e+03,
	1.898864e+04,
	-3.646745e+03,
	-2.827982e+03,
	2.153210e+03,
	1.920291e+04,
	-1.365574e+04,
	-1.131453e+03,
	1.562656e+03,
	1.936968e+04,
	-1.907849e+04,
	-2.359625e+02,
	9.938042e+02,
	1.949465e+04,
	-1.267951e+04,
	-2.792363e+00,
	3.995119e+02,
	1.957176e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-4.253495e+03,
	7.499863e+01,
	0,
	0,
	-1.750552e+04,
	6.611353e+02,
	3.286766e-01,
	5.313292e-04,
	-1.773001e+05,
	5.748574e+03,
	4.539952e+00,
	1.009525e-02,
	-9.223470e+05,
	2.879966e+04,
	4.664094e+01,
	1.386769e-01,
	-1.930323e+06,
	7.899737e+04,
	2.852048e+02,
	1.171049e+00,
	-4.376965e+06,
	1.804810e+05,
	1.095224e+03,
	6.203799e+00,
	-6.199410e+06,
	2.925007e+05,
	3.155202e+03,
	2.454156e+01,
	-8.265951e+06,
	3.988727e+05,
	7.017706e+03,
	7.510072e+01,
	-7.418139e+06,
	4.164357e+05,
	1.276099e+04,
	1.879864e+02,
	-7.040578e+06,
	4.038613e+05,
	1.967473e+04,
	3.966702e+02,
	-5.686102e+06,
	3.336694e+05,
	2.686086e+04,
	7.341906e+02,
	-4.304528e+06,
	2.438082e+05,
	3.315168e+04,
	1.220839e+03,
	-2.692813e+06,
	1.463149e+05,
	3.773689e+04,
	1.860259e+03,
	-1.797320e+06,
	7.842619e+04,
	4.036734e+04,
	2.638594e+03,
	-1.480552e+06,
	3.567044e+04,
	4.122917e+04,
	3.534651e+03,
	-4.691014e+05,
	-1.943763e+04,
	4.039585e+04,
	4.520549e+03,
	-4.771614e+05,
	-2.551283e+04,
	3.841306e+04,
	5.556536e+03,
	-2.993912e+05,
	-3.669547e+04,
	3.578773e+04,
	6.621797e+03,
	-7.863820e+04,
	-4.472026e+04,
	3.264362e+04,
	7.688512e+03,
	-7.947163e+04,
	-3.968368e+04,
	2.936882e+04,
	8.732777e+03,
	-4.626689e+04,
	-3.655540e+04,
	2.617168e+04,
	9.743299e+03,
	-3.298749e+04,
	-3.228438e+04,
	2.309979e+04,
	1.070825e+04,
	7.557068e+03,
	-2.951923e+04,
	2.021271e+04,
	1.161922e+04,
	-1.131117e+04,
	-2.346075e+04,
	1.760143e+04,
	1.246985e+04,
	-8.138479e+02,
	-2.029297e+04,
	1.526546e+04,
	1.326110e+04,
	-6.482612e+03,
	-1.648920e+04,
	1.317628e+04,
	1.399093e+04,
	-9.595959e+02,
	-1.408842e+04,
	1.131675e+04,
	1.466044e+04,
	-8.934017e+03,
	-1.109881e+04,
	9.671678e+03,
	1.526962e+04,
	1.509275e+04,
	-1.089459e+04,
	8.203717e+03,
	1.582083e+04,
	-1.453210e+04,
	-6.361619e+03,
	6.975921e+03,
	1.631342e+04,
	-1.009911e+04,
	-6.003604e+03,
	5.892338e+03,
	1.675910e+04,
	4.806694e+03,
	-6.254916e+03,
	4.858851e+03,
	1.715199e+04,
	-1.071047e+04,
	-3.527770e+03,
	3.984625e+03,
	1.748987e+04,
	-8.640748e+03,
	-3.280218e+03,
	3.206107e+03,
	1.778279e+04,
	-5.456272e+03,
	-2.969433e+03,
	2.463075e+03,
	1.802588e+04,
	-1.521043e+04,
	-1.321653e+03,
	1.804258e+03,
	1.821785e+04,
	-2.367697e+04,
	-9.087804e+01,
	1.159175e+03,
	1.836246e+04,
	-1.433487e+04,
	-4.953068e+01,
	4.611681e+02,
	1.845283e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-3.175559e+04,
	9.319479e+02,
	0,
	0,
	-1.155952e+05,
	5.362912e+03,
	7.533434e+00,
	2.444114e-02,
	-4.781473e+05,
	2.294213e+04,
	6.469392e+01,
	2.901057e-01,
	-1.186903e+06,
	6.363668e+04,
	3.418921e+02,
	2.059963e+00,
	-2.457058e+06,
	1.339813e+05,
	1.225389e+03,
	9.946482e+00,
	-3.689532e+06,
	2.089429e+05,
	3.267949e+03,
	3.596461e+01,
	-3.635500e+06,
	2.440573e+05,
	6.751900e+03,
	1.017719e+02,
	-4.240893e+06,
	2.702413e+05,
	1.146298e+04,
	2.351121e+02,
	-2.806952e+06,
	2.203272e+05,
	1.683224e+04,
	4.676621e+02,
	-2.755320e+06,
	1.948001e+05,
	2.199412e+04,
	8.191252e+02,
	-2.060483e+06,
	1.377770e+05,
	2.645927e+04,
	1.306106e+03,
	-1.097631e+06,
	7.499210e+04,
	2.952827e+04,
	1.925185e+03,
	-1.000923e+06,
	4.815843e+04,
	3.123190e+04,
	2.659039e+03,
	-4.315165e+05,
	8.335406e+03,
	3.169514e+04,
	3.491872e+03,
	-4.699637e+05,
	-3.883861e+02,
	3.111515e+04,
	4.393927e+03,
	-1.358086e+05,
	-2.181426e+04,
	2.973216e+04,
	5.345470e+03,
	-2.102148e+05,
	-1.969387e+04,
	2.780408e+04,
	6.315553e+03,
	-2.056386e+03,
	-3.015444e+04,
	2.554160e+04,
	7.289349e+03,
	-1.214515e+05,
	-2.109060e+04,
	2.317332e+04,
	8.242094e+03,
	2.283767e+04,
	-2.752130e+04,
	2.075837e+04,
	9.169350e+03,
	7.777847e+02,
	-2.167302e+04,
	1.841980e+04,
	1.004997e+04,
	-5.404760e+04,
	-1.555831e+04,
	1.633979e+04,
	1.088609e+04,
	2.732346e+04,
	-1.905176e+04,
	1.431599e+04,
	1.167632e+04,
	-2.032427e+04,
	-1.233088e+04,
	1.247912e+04,
	1.240595e+04,
	-1.714066e+04,
	-1.113399e+04,
	1.084237e+04,
	1.308473e+04,
	1.575944e+04,
	-1.185483e+04,
	9.276789e+03,
	1.370596e+04,
	-1.758306e+04,
	-6.912145e+03,
	7.932318e+03,
	1.426459e+04,
	-4.249523e+03,
	-7.239515e+03,
	6.729422e+03,
	1.477256e+04,
	-2.329697e+03,
	-6.114440e+03,
	5.608986e+03,
	1.522204e+04,
	-5.910026e+03,
	-4.665776e+03,
	4.630493e+03,
	1.561502e+04,
	-1.798960e+04,
	-2.846416e+03,
	3.762089e+03,
	1.595518e+04,
	-3.910095e+03,
	-3.884273e+03,
	2.890839e+03,
	1.624284e+04,
	-1.926873e+04,
	-1.391269e+03,
	2.105855e+03,
	1.646675e+04,
	-2.740709e+04,
	-1.634349e+02,
	1.341530e+03,
	1.663561e+04,
	-1.586965e+04,
	-1.115448e+02,
	5.221589e+02,
	1.673964e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.127396e+02,
	4.028231e+01,
	0,
	0,
	-2.922208e+03,
	3.533675e+02,
	4.231000e-01,
	1.593987e-03,
	-7.834748e+04,
	3.913683e+03,
	5.563741e+00,
	2.656646e-02,
	-1.794238e+05,
	1.330030e+04,
	5.847158e+01,
	3.613038e-01,
	-7.133529e+05,
	4.140932e+04,
	2.841249e+02,
	2.339974e+00,
	-8.219289e+05,
	6.765098e+04,
	9.828657e+02,
	1.089809e+01,
	-1.608881e+06,
	1.135553e+05,
	2.399301e+03,
	3.586206e+01,
	-1.380790e+06,
	1.250011e+05,
	4.785818e+03,
	9.597186e+01,
	-1.681694e+06,
	1.416683e+05,
	7.913429e+03,
	2.122113e+02,
	-1.342164e+06,
	1.248846e+05,
	1.153453e+04,
	4.098636e+02,
	-1.138530e+06,
	1.048019e+05,
	1.506125e+04,
	7.058108e+02,
	-7.560038e+05,
	7.458648e+04,
	1.812017e+04,
	1.110256e+03,
	-7.365586e+05,
	5.736215e+04,
	2.047117e+04,
	1.622284e+03,
	-2.829319e+05,
	2.385083e+04,
	2.194529e+04,
	2.236639e+03,
	-3.746521e+05,
	1.866296e+04,
	2.260812e+04,
	2.932459e+03,
	-2.109677e+05,
	1.572390e+03,
	2.259219e+04,
	3.699650e+03,
	-4.422227e+04,
	-1.078135e+04,
	2.187151e+04,
	4.512166e+03,
	-1.480152e+05,
	-6.663066e+03,
	2.082518e+04,
	5.348479e+03,
	-3.470247e+04,
	-1.527565e+04,
	1.948176e+04,
	6.200584e+03,
	-1.374575e+04,
	-1.543198e+04,
	1.789581e+04,
	7.043310e+03,
	-4.756536e+04,
	-1.215076e+04,
	1.631547e+04,
	7.867040e+03,
	-2.328940e+03,
	-1.445670e+04,
	1.469261e+04,
	8.665875e+03,
	-2.943259e+04,
	-1.086144e+04,
	1.309232e+04,
	9.424964e+03,
	2.219356e+04,
	-1.335516e+04,
	1.153409e+04,
	1.014250e+04,
	-3.753978e+04,
	-6.601135e+03,
	1.014219e+04,
	1.080706e+04,
	6.462929e+03,
	-9.897952e+03,
	8.803313e+03,
	1.142966e+04,
	-1.185789e+04,
	-6.587254e+03,
	7.531425e+03,
	1.199133e+04,
	-5.585795e+03,
	-6.310054e+03,
	6.385138e+03,
	1.249966e+04,
	-1.095521e+04,
	-4.847504e+03,
	5.319253e+03,
	1.294953e+04,
	-1.433834e+04,
	-3.906517e+03,
	4.322975e+03,
	1.334142e+04,
	-3.995946e+03,
	-4.280124e+03,
	3.350694e+03,
	1.367127e+04,
	-2.687799e+04,
	-1.046360e+03,
	2.493151e+03,
	1.393293e+04,
	-3.083327e+04,
	-4.093439e+02,
	1.594075e+03,
	1.413478e+04,
	-1.950779e+04,
	-7.012349e+01,
	6.281431e+02,
	1.425796e+04,
};

double solarDataset600[] = 
{
	1.454828e+13,
	-1.753873e+07,
	4.108891e+04,
	1.618972e+03,
	-1.384284e+12,
	3.644504e+08,
	5.345299e+04,
	1.619749e+03,
	-5.626237e+10,
	3.552050e+07,
	8.094015e+04,
	1.629074e+03,
	3.728997e+09,
	-3.217893e+06,
	8.610187e+04,
	1.657417e+03,
	-1.341046e+09,
	2.537266e+06,
	8.654787e+04,
	1.711991e+03,
	1.037406e+09,
	-1.842154e+06,
	8.743552e+04,
	1.804243e+03,
	-2.281591e+08,
	1.692114e+06,
	8.931420e+04,
	1.940869e+03,
	4.381924e+07,
	4.651551e+05,
	9.344253e+04,
	2.142112e+03,
	-4.759171e+07,
	8.163875e+05,
	9.726835e+04,
	2.419359e+03,
	-1.821050e+07,
	4.964279e+05,
	1.013782e+05,
	2.792134e+03,
	-2.368294e+07,
	4.294862e+05,
	1.048241e+05,
	3.274694e+03,
	-1.941022e+07,
	2.763683e+05,
	1.074121e+05,
	3.882373e+03,
	-1.590314e+07,
	1.381601e+05,
	1.084676e+05,
	4.624161e+03,
	-1.691643e+07,
	5.407009e+04,
	1.075833e+05,
	5.501698e+03,
	-9.692053e+06,
	-1.241486e+05,
	1.040909e+05,
	6.506736e+03,
	-4.836417e+06,
	-2.247011e+05,
	9.795019e+04,
	7.611780e+03,
	-5.822942e+06,
	-2.072205e+05,
	9.012361e+04,
	8.785157e+03,
	-4.934677e+05,
	-2.953874e+05,
	8.082216e+04,
	9.997030e+03,
	-1.972241e+06,
	-2.181519e+05,
	7.109185e+04,
	1.120129e+04,
	-2.891157e+05,
	-2.240168e+05,
	6.151353e+04,
	1.238053e+04,
	-4.966324e+05,
	-1.758467e+05,
	5.236592e+04,
	1.350154e+04,
	1.641487e+05,
	-1.585700e+05,
	4.401724e+04,
	1.455163e+04,
	8.034773e+04,
	-1.203842e+05,
	3.671628e+04,
	1.551563e+04,
	-1.271137e+04,
	-9.085232e+04,
	3.057720e+04,
	1.639592e+04,
	3.823284e+04,
	-7.282635e+04,
	2.535605e+04,
	1.719488e+04,
	4.041914e+04,
	-5.648343e+04,
	2.094476e+04,
	1.791302e+04,
	9.493516e+04,
	-4.559175e+04,
	1.728272e+04,
	1.855507e+04,
	-5.146686e+04,
	-2.872101e+04,
	1.434663e+04,
	1.912718e+04,
	7.274758e+04,
	-2.868041e+04,
	1.186372e+04,
	1.964130e+04,
	-1.137111e+04,
	-1.752581e+04,
	9.839214e+03,
	2.009446e+04,
	-1.008472e+04,
	-1.422576e+04,
	8.192508e+03,
	2.050076e+04,
	2.515788e+04,
	-1.323360e+04,
	6.753657e+03,
	2.086086e+04,
	1.584386e+04,
	-9.397442e+03,
	5.594194e+03,
	2.117599e+04,
	-1.982323e+04,
	-5.090890e+03,
	4.709331e+03,
	2.145612e+04,
	9.160687e+03,
	-6.384271e+03,
	3.918052e+03,
	2.170842e+04,
	6.487543e+03,
	-4.632844e+03,
	3.236203e+03,
	2.192755e+04,
	-1.558850e+04,
	-2.009499e+03,
	2.714977e+03,
	2.212059e+04,
	1.214568e+04,
	-4.063965e+03,
	2.216067e+03,
	2.229301e+04,
	-9.387616e+03,
	-1.151481e+03,
	1.817672e+03,
	2.243736e+04,
	1.549500e+03,
	-2.094099e+03,
	1.475644e+03,
	2.256570e+04,
	-4.531227e+03,
	-1.034617e+03,
	1.167963e+03,
	2.267195e+04,
	-2.936346e+03,
	-1.036553e+03,
	8.946197e+02,
	2.276081e+04,
	-4.991516e+03,
	-5.847746e+02,
	6.400900e+02,
	2.283020e+04,
	-8.686370e+03,
	-8.226384e+00,
	4.001762e+02,
	2.288082e+04,
	-4.282608e+03,
	-6.966287e+01,
	1.490135e+02,
	2.291176e+04,
	-8.258616e+13,
	9.904778e+08,
	1.318286e+05,
	7.747884e+02,
	2.062665e+12,
	-4.786463e+08,
	9.235644e+04,
	7.769322e+02,
	-3.538830e+10,
	2.205724e+07,
	6.694206e+04,
	7.847311e+02,
	4.058662e+09,
	-3.295631e+06,
	7.000223e+04,
	8.077786e+02,
	-1.994471e+07,
	1.416720e+06,
	7.075137e+04,
	8.521384e+02,
	-1.187269e+08,
	1.283696e+06,
	7.366460e+04,
	9.280772e+02,
	2.540619e+08,
	2.026807e+05,
	7.681548e+04,
	1.046331e+03,
	-1.391960e+08,
	1.579054e+06,
	8.135576e+04,
	1.218133e+03,
	2.530622e+07,
	5.920718e+05,
	8.701200e+04,
	1.465097e+03,
	-3.251666e+07,
	8.728196e+05,
	9.250368e+04,
	1.800184e+03,
	-4.349050e+07,
	7.754678e+05,
	9.852956e+04,
	2.248042e+03,
	-2.011892e+07,
	3.930905e+05,
	1.031312e+05,
	2.827391e+03,
	-1.799797e+07,
	2.525175e+05,
	1.056848e+05,
	3.545122e+03,
	-1.574729e+07,
	1.139525e+05,
	1.062387e+05,
	4.406529e+03,
	-1.205118e+07,
	-2.983359e+04,
	1.041875e+05,
	5.405193e+03,
	-6.697812e+06,
	-1.674924e+05,
	9.926112e+04,
	6.519409e+03,
	-4.384345e+06,
	-2.195876e+05,
	9.199400e+04,
	7.714342e+03,
	-1.862072e+06,
	-2.540928e+05,
	8.320020e+04,
	8.954122e+03,
	-1.908592e+06,
	-2.218975e+05,
	7.374786e+04,
	1.020097e+04,
	-6.595484e+05,
	-2.191046e+05,
	6.409677e+04,
	1.142642e+04,
	5.591668e+05,
	-2.065625e+05,
	5.471249e+04,
	1.259732e+04,
	-8.093373e+05,
	-1.264564e+05,
	4.652504e+04,
	1.369474e+04,
	1.688527e+05,
	-1.334041e+05,
	3.909025e+04,
	1.472375e+04,
	2.419749e+05,
	-1.045422e+05,
	3.245138e+04,
	1.565887e+04,
	-1.230208e+05,
	-6.804517e+04,
	2.707154e+04,
	1.650613e+04,
	1.126806e+05,
	-6.300250e+04,
	2.249086e+04,
	1.727731e+04,
	-7.142991e+04,
	-4.118624e+04,
	1.863553e+04,
	1.796673e+04,
	1.675606e+05,
	-4.267365e+04,
	1.536107e+04,
	1.858582e+04,
	-6.485362e+04,
	-2.110609e+04,
	1.279192e+04,
	1.913137e+04,
	2.637560e+04,
	-2.212235e+04,
	1.067530e+04,
	1.962669e+04,
	7.981750e+03,
	-1.608272e+04,
	8.844225e+03,
	2.006475e+04,
	1.871909e+04,
	-1.315898e+04,
	7.352146e+03,
	2.045392e+04,
	-1.840475e+04,
	-8.056233e+03,
	6.149474e+03,
	2.079909e+04,
	1.957039e+04,
	-9.075917e+03,
	5.104541e+03,
	2.110797e+04,
	-8.536233e+03,
	-4.982923e+03,
	4.248788e+03,
	2.137749e+04,
	3.499200e+03,
	-5.020523e+03,
	3.538293e+03,
	2.161816e+04,
	-2.000849e+03,
	-3.512066e+03,
	2.928448e+03,
	2.182841e+04,
	3.638545e+03,
	-3.264362e+03,
	2.415994e+03,
	2.201285e+04,
	-1.015257e+04,
	-1.420977e+03,
	1.998918e+03,
	2.217269e+04,
	4.403337e+03,
	-2.590383e+03,
	1.602086e+03,
	2.231300e+04,
	-7.875874e+03,
	-7.971346e+02,
	1.270059e+03,
	2.242772e+04,
	2.108760e+03,
	-1.686184e+03,
	9.648043e+02,
	2.252491e+04,
	-9.024057e+03,
	-1.121285e+02,
	7.146217e+02,
	2.259896e+04,
	-1.078560e+04,
	5.370255e+01,
	4.574484e+02,
	2.265738e+04,
	-4.144847e+03,
	-1.351749e+02,
	1.580973e+02,
	2.269255e+04,
	-7.925848e+12,
	7.954113e+07,
	4.342033e+04,
	2.306639e+02,
	2.269955e+11,
	-6.495581e+07,
	3.909724e+04,
	2.313954e+02,
	3.302993e+10,
	-1.552044e+07,
	3.333664e+04,
	2.355661e+02,
	-4.784910e+09,
	7.541830e+06,
	3.379938e+04,
	2.459800e+02,
	3.613537e+08,
	7.051546e+05,
	3.758040e+04,
	2.693637e+02,
	2.012123e+08,
	9.047518e+05,
	4.026196e+04,
	3.100796e+02,
	-3.247217e+07,
	1.458624e+06,
	4.458575e+04,
	3.762391e+02,
	3.509220e+07,
	1.133284e+06,
	5.050532e+04,
	4.804963e+02,
	-6.375528e+07,
	1.554986e+06,
	5.800171e+04,
	6.381134e+02,
	-2.892941e+07,
	1.197304e+06,
	6.695868e+04,
	8.734957e+02,
	-5.164969e+07,
	1.213830e+06,
	7.625104e+04,
	1.209469e+03,
	-2.739672e+07,
	7.928510e+05,
	8.505819e+04,
	1.674458e+03,
	-2.787464e+07,
	6.247649e+05,
	9.206065e+04,
	2.284897e+03,
	-1.871019e+07,
	3.383328e+05,
	9.669688e+04,
	3.055270e+03,
	-1.379705e+07,
	1.369205e+05,
	9.808678e+04,
	3.981429e+03,
	-8.704135e+06,
	-3.571846e+04,
	9.616835e+04,
	5.046769e+03,
	-4.155272e+06,
	-1.581929e+05,
	9.124700e+04,
	6.219767e+03,
	-4.104771e+06,
	-1.676177e+05,
	8.431879e+04,
	7.461843e+03,
	-1.265230e+06,
	-2.229547e+05,
	7.591780e+04,
	8.739201e+03,
	-9.083431e+05,
	-2.002438e+05,
	6.683417e+04,
	1.000630e+04,
	-5.255757e+05,
	-1.783831e+05,
	5.790308e+04,
	1.123644e+04,
	4.993118e+05,
	-1.719879e+05,
	4.940310e+04,
	1.240539e+04,
	-7.487545e+05,
	-9.942973e+04,
	4.203530e+04,
	1.349507e+04,
	3.978438e+05,
	-1.195978e+05,
	3.528825e+04,
	1.451412e+04,
	-2.047206e+04,
	-7.632391e+04,
	2.942983e+04,
	1.543376e+04,
	6.154258e+04,
	-6.346317e+04,
	2.463164e+04,
	1.627325e+04,
	-2.863798e+04,
	-4.606248e+04,
	2.057180e+04,
	1.703219e+04,
	7.388099e+04,
	-4.085648e+04,
	1.711248e+04,
	1.771723e+04,
	-2.064163e+04,
	-2.712556e+04,
	1.425554e+04,
	1.832846e+04,
	3.328744e+04,
	-2.433972e+04,
	1.186725e+04,
	1.887791e+04,
	1.002028e+04,
	-1.754222e+04,
	9.878580e+03,
	1.936576e+04,
	8.911729e+03,
	-1.374369e+04,
	8.260222e+03,
	1.980154e+04,
	-2.085488e+04,
	-9.181720e+03,
	6.920058e+03,
	2.019044e+04,
	2.914076e+04,
	-1.070749e+04,
	5.730227e+03,
	2.053766e+04,
	-1.293038e+04,
	-5.174966e+03,
	4.781798e+03,
	2.083987e+04,
	5.221232e+03,
	-5.721930e+03,
	3.997709e+03,
	2.111160e+04,
	2.329131e+03,
	-4.209210e+03,
	3.318380e+03,
	2.134929e+04,
	-1.120600e+04,
	-2.323414e+03,
	2.771525e+03,
	2.155871e+04,
	4.077728e+03,
	-3.348798e+03,
	2.255768e+03,
	2.174367e+04,
	-4.397494e+03,
	-1.781340e+03,
	1.814239e+03,
	2.189875e+04,
	-2.371566e+03,
	-1.679149e+03,
	1.440870e+03,
	2.203123e+04,
	-3.509356e+03,
	-1.211255e+03,
	1.104800e+03,
	2.213993e+04,
	-6.401342e+03,
	-6.643209e+02,
	8.055120e+02,
	2.222624e+04,
	-9.121022e+03,
	-1.798506e+02,
	5.138316e+02,
	2.229047e+04,
	-6.114652e+03,
	-5.727757e+01,
	2.165918e+02,
	2.233048e+04,
	9.465569e+11,
	2.157107e+07,
	2.323822e+03,
	3.141042e+01,
	-3.198079e+11,
	7.414625e+07,
	3.911285e+03,
	3.146173e+01,
	9.476628e+09,
	-4.475969e+06,
	7.835770e+03,
	3.245139e+01,
	-8.928972e+08,
	1.881666e+06,
	7.953473e+03,
	3.487056e+01,
	3.171872e+08,
	2.635279e+05,
	9.264064e+03,
	4.047706e+01,
	-5.849106e+07,
	9.732834e+05,
	1.087038e+04,
	5.087843e+01,
	8.242971e+07,
	6.037953e+05,
	1.349207e+04,
	7.009928e+01,
	-3.032662e+07,
	1.159453e+06,
	1.732089e+04,
	1.033948e+02,
	-3.561716e+07,
	1.251423e+06,
	2.330419e+04,
	1.629440e+02,
	-3.448639e+07,
	1.286417e+06,
	3.117127e+04,
	2.657617e+02,
	-3.649510e+07,
	1.300592e+06,
	4.093241e+04,
	4.359338e+02,
	-4.363745e+07,
	1.276591e+06,
	5.220971e+04,
	7.050447e+02,
	-2.840810e+07,
	9.451539e+05,
	6.355126e+04,
	1.108138e+03,
	-2.581926e+07,
	7.360833e+05,
	7.326328e+04,
	1.668684e+03,
	-1.354418e+07,
	3.883004e+05,
	8.025788e+04,
	2.403289e+03,
	-1.377454e+07,
	2.590663e+05,
	8.389776e+04,
	3.304769e+03,
	-6.998331e+06,
	2.378317e+04,
	8.395422e+04,
	4.361063e+03,
	-3.017568e+06,
	-1.031107e+05,
	8.045998e+04,
	5.528584e+03,
	-3.053944e+06,
	-1.159054e+05,
	7.492129e+04,
	6.765323e+03,
	-9.988790e+05,
	-1.670190e+05,
	6.794613e+04,
	8.038403e+03,
	-7.984465e+05,
	-1.523819e+05,
	6.021692e+04,
	9.302581e+03,
	-9.338634e+04,
	-1.494507e+05,
	5.246052e+04,
	1.053131e+04,
	-1.035431e+05,
	-1.215806e+05,
	4.515398e+04,
	1.169887e+04,
	-7.357601e+04,
	-9.990059e+04,
	3.857402e+04,
	1.279598e+04,
	1.792570e+03,
	-8.319324e+04,
	3.268700e+04,
	1.381455e+04,
	3.874347e+04,
	-6.749650e+04,
	2.752666e+04,
	1.474920e+04,
	4.244814e+04,
	-5.329079e+04,
	2.311818e+04,
	1.560008e+04,
	-7.930994e+03,
	-3.984100e+04,
	1.941511e+04,
	1.637147e+04,
	8.733277e+04,
	-3.589956e+04,
	1.626214e+04,
	1.706943e+04,
	-7.640893e+04,
	-1.973546e+04,
	1.370832e+04,
	1.769570e+04,
	6.465562e+04,
	-2.412718e+04,
	1.146747e+04,
	1.826574e+04,
	-1.257959e+04,
	-1.387134e+04,
	9.594876e+03,
	1.876880e+04,
	-3.216704e+03,
	-1.199645e+04,
	8.071823e+03,
	1.922295e+04,
	1.185898e+04,
	-1.055074e+04,
	6.732374e+03,
	1.962756e+04,
	-8.043290e+02,
	-7.356438e+03,
	5.627495e+03,
	1.998509e+04,
	-1.628058e+03,
	-5.891328e+03,
	4.712682e+03,
	2.030343e+04,
	-3.439586e+03,
	-4.645427e+03,
	3.923985e+03,
	2.058511e+04,
	3.075924e+03,
	-4.271196e+03,
	3.234865e+03,
	2.083229e+04,
	-1.635081e+03,
	-2.923961e+03,
	2.662415e+03,
	2.104614e+04,
	-7.090127e+03,
	-1.933064e+03,
	2.185308e+03,
	2.123232e+04,
	-4.437563e+03,
	-1.933243e+03,
	1.734860e+03,
	2.139234e+04,
	-3.653738e+02,
	-1.892874e+03,
	1.311083e+03,
	2.152288e+04,
	-1.354368e+04,
	-1.252045e+02,
	9.651989e+02,
	2.162438e+04,
	-6.525776e+03,
	-7.519351e+02,
	5.872714e+02,
	2.170241e+04,
	-6.046958e+03,
	-1.425454e+02,
	2.526236e+02,
	2.174657e+04,
	7.685478e+11,
	-3.587368e+06,
	-5.614277e+02,
	2.176726e+00,
	-6.325697e+10,
	1.540102e+07,
	0,
	2.169919e+00,
	6.037976e+08,
	-1.269417e+05,
	9.536601e+02,
	2.283023e+00,
	-1.231879e+08,
	2.884108e+05,
	1.064814e+03,
	2.602961e+00,
	1.338161e+08,
	-3.138454e+04,
	1.282376e+03,
	3.367459e+00,
	-8.742091e+06,
	3.029956e+05,
	1.660242e+03,
	4.836763e+00,
	4.214728e+05,
	3.431726e+05,
	2.546292e+03,
	8.152906e+00,
	-8.769409e+06,
	4.935859e+05,
	4.054901e+03,
	1.537637e+01,
	-2.118875e+07,
	7.043190e+05,
	6.707452e+03,
	3.116117e+01,
	-1.956295e+07,
	8.532277e+05,
	1.108718e+04,
	6.499704e+01,
	-3.731153e+07,
	1.135945e+06,
	1.777807e+04,
	1.334155e+02,
	-3.091261e+07,
	1.121036e+06,
	2.709678e+04,
	2.649024e+02,
	-3.270901e+07,
	1.105922e+06,
	3.809708e+04,
	4.929304e+02,
	-2.200409e+07,
	8.529194e+05,
	4.956525e+04,
	8.559269e+02,
	-2.038642e+07,
	6.855276e+05,
	5.978076e+04,
	1.380667e+03,
	-1.117204e+07,
	3.795010e+05,
	6.745803e+04,
	2.085776e+03,
	-9.901093e+06,
	2.365954e+05,
	7.171413e+04,
	2.961349e+03,
	-4.354972e+06,
	3.054048e+04,
	7.248689e+04,
	3.990590e+03,
	-3.140714e+06,
	-3.946535e+04,
	7.017581e+04,
	5.129246e+03,
	-1.994865e+06,
	-9.051388e+04,
	6.582553e+04,
	6.341791e+03,
	-5.803806e+05,
	-1.294484e+05,
	5.994991e+04,
	7.586278e+03,
	-8.405790e+05,
	-1.086236e+05,
	5.349962e+04,
	8.822279e+03,
	2.303613e+05,
	-1.273856e+05,
	4.686398e+04,
	1.002781e+04,
	-4.101851e+05,
	-8.285763e+04,
	4.066681e+04,
	1.117171e+04,
	2.025071e+05,
	-9.176353e+04,
	3.492952e+04,
	1.225612e+04,
	-1.241871e+05,
	-6.014883e+04,
	2.981741e+04,
	1.325813e+04,
	7.450568e+04,
	-5.766421e+04,
	2.535029e+04,
	1.418817e+04,
	-3.498195e+04,
	-4.081103e+04,
	2.145641e+04,
	1.503639e+04,
	5.737509e+04,
	-3.728994e+04,
	1.810341e+04,
	1.581109e+04,
	1.553564e+04,
	-2.696393e+04,
	1.527417e+04,
	1.651003e+04,
	-3.264956e+04,
	-1.915601e+04,
	1.294140e+04,
	1.714428e+04,
	2.039836e+04,
	-1.885321e+04,
	1.087146e+04,
	1.771893e+04,
	3.616331e+04,
	-1.547233e+04,
	9.097636e+03,
	1.822993e+04,
	-4.400956e+04,
	-6.947860e+03,
	7.730975e+03,
	1.868663e+04,
	2.524433e+04,
	-1.107087e+04,
	6.479718e+03,
	1.910332e+04,
	-1.159559e+04,
	-5.722883e+03,
	5.403721e+03,
	1.946613e+04,
	8.803311e+03,
	-6.362971e+03,
	4.509957e+03,
	1.979080e+04,
	-7.832658e+03,
	-3.602953e+03,
	3.758517e+03,
	2.007421e+04,
	-6.382527e+03,
	-3.252304e+03,
	3.110174e+03,
	2.032548e+04,
	1.111503e+03,
	-3.330009e+03,
	2.499038e+03,
	2.054191e+04,
	-6.645172e+03,
	-1.857684e+03,
	1.983350e+03,
	2.072246e+04,
	-4.647336e+02,
	-2.123280e+03,
	1.524736e+03,
	2.087328e+04,
	-1.619462e+04,
	-7.161461e+01,
	1.135444e+03,
	2.099191e+04,
	-1.145722e+04,
	-5.148367e+02,
	6.981336e+02,
	2.108415e+04,
	-8.317955e+03,
	-3.174918e+01,
	2.682136e+02,
	2.113680e+04,
	6.686770e+09,
	-5.232905e+04,
	9.004540e+01,
	8.220978e-02,
	-1.221062e+09,
	1.938090e+05,
	9.420210e+01,
	8.378067e-02,
	9.327238e+07,
	-6.870038e+04,
	8.763799e+01,
	9.582414e-02,
	5.996937e+07,
	-4.274478e+04,
	7.265223e+01,
	1.204347e-01,
	-1.133786e+07,
	6.147611e+04,
	9.131150e+01,
	1.649432e-01,
	3.386784e+05,
	5.305621e+04,
	1.829889e+02,
	3.157484e-01,
	3.484062e+06,
	8.082698e+04,
	3.519414e+02,
	7.346517e-01,
	-8.136297e+06,
	2.145670e+05,
	7.559280e+02,
	1.929050e+00,
	-1.422495e+07,
	3.782352e+05,
	1.798927e+03,
	5.751019e+00,
	-1.921481e+07,
	5.817554e+05,
	4.031473e+03,
	1.702790e+01,
	-2.466374e+07,
	8.092501e+05,
	8.208813e+03,
	4.659724e+01,
	-2.957367e+07,
	9.988951e+05,
	1.503472e+04,
	1.151984e+02,
	-2.934849e+07,
	1.043498e+06,
	2.455141e+04,
	2.553897e+02,
	-2.437625e+07,
	9.281228e+05,
	3.566919e+04,
	5.065714e+02,
	-1.808598e+07,
	7.249953e+05,
	4.667018e+04,
	9.049815e+02,
	-1.413967e+07,
	5.250627e+05,
	5.602253e+04,
	1.475116e+03,
	-9.253251e+06,
	3.021326e+05,
	6.252165e+04,
	2.225350e+03,
	-4.436136e+06,
	1.093543e+05,
	6.552585e+04,
	3.139939e+03,
	-4.814005e+06,
	5.669314e+04,
	6.565072e+04,
	4.187778e+03,
	-1.840489e+06,
	-6.337635e+04,
	6.313183e+04,
	5.341067e+03,
	-6.904183e+05,
	-1.012176e+05,
	5.850287e+04,
	6.544246e+03,
	-7.497582e+05,
	-9.311380e+04,
	5.312391e+04,
	7.761001e+03,
	-4.210654e+05,
	-9.618680e+04,
	4.738566e+04,
	8.967658e+03,
	8.995083e+04,
	-9.946898e+04,
	4.148243e+04,
	1.013491e+04,
	-2.075976e+05,
	-7.103257e+04,
	3.602031e+04,
	1.124072e+04,
	8.338291e+04,
	-7.078879e+04,
	3.100960e+04,
	1.228431e+04,
	-2.730415e+04,
	-5.205078e+04,
	2.653114e+04,
	1.325030e+04,
	2.150946e+04,
	-4.459231e+04,
	2.264211e+04,
	1.414394e+04,
	-1.423980e+04,
	-3.417936e+04,
	1.925258e+04,
	1.496260e+04,
	1.473821e+04,
	-2.918906e+04,
	1.630554e+04,
	1.571000e+04,
	3.220392e+04,
	-2.405451e+04,
	1.376762e+04,
	1.638610e+04,
	-2.684524e+04,
	-1.571254e+04,
	1.167668e+04,
	1.699638e+04,
	3.088042e+04,
	-1.651758e+04,
	9.851958e+03,
	1.755058e+04,
	-1.721349e+04,
	-9.750730e+03,
	8.323807e+03,
	1.804451e+04,
	1.345637e+04,
	-1.027197e+04,
	7.017991e+03,
	1.849141e+04,
	-2.174811e+04,
	-5.602956e+03,
	5.906349e+03,
	1.888762e+04,
	1.177125e+04,
	-7.439854e+03,
	4.898836e+03,
	1.924275e+04,
	1.647970e+03,
	-4.795697e+03,
	4.041270e+03,
	1.954881e+04,
	-5.843917e+03,
	-3.222697e+03,
	3.369872e+03,
	1.981799e+04,
	-9.789821e+03,
	-2.446804e+03,
	2.772770e+03,
	2.005474e+04,
	-1.378097e+03,
	-2.879752e+03,
	2.186681e+03,
	2.025740e+04,
	-6.290251e+03,
	-1.724383e+03,
	1.668369e+03,
	2.042133e+04,
	-1.101343e+04,
	-9.097999e+02,
	1.211492e+03,
	2.055181e+04,
	-1.111452e+04,
	-5.639870e+02,
	7.532181e+02,
	2.064806e+04,
	-8.320836e+03,
	-1.432660e+02,
	3.235242e+02,
	2.070595e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.472727e+07,
	9.704940e+03,
	0,
	0,
	-2.351848e+05,
	1.879504e+02,
	1.617783e+00,
	5.236292e-04,
	8.699198e+05,
	-9.875575e+02,
	1.570521e+00,
	1.570887e-03,
	-6.250379e+05,
	4.145386e+03,
	2.379199e+00,
	3.141775e-03,
	4.286236e+05,
	4.412056e+03,
	1.077048e+01,
	1.466162e-02,
	-2.043447e+06,
	3.157819e+04,
	3.625093e+01,
	6.388276e-02,
	-1.085061e+06,
	6.162908e+04,
	1.682113e+02,
	3.869620e-01,
	-6.697354e+06,
	1.915110e+05,
	5.837246e+02,
	1.821706e+00,
	-1.347910e+07,
	3.939200e+05,
	1.934535e+03,
	8.045039e+00,
	-1.740487e+07,
	5.943821e+05,
	5.113283e+03,
	2.940335e+01,
	-2.005659e+07,
	7.567963e+05,
	1.080316e+04,
	8.665382e+01,
	-1.933757e+07,
	8.074300e+05,
	1.910717e+04,
	2.128584e+02,
	-1.922524e+07,
	7.785521e+05,
	2.917605e+04,
	4.485973e+02,
	-1.197210e+07,
	5.629568e+05,
	3.928913e+04,
	8.333176e+02,
	-9.951533e+06,
	4.244022e+05,
	4.773463e+04,
	1.385596e+03,
	-6.709627e+06,
	2.506304e+05,
	5.376726e+04,
	2.114235e+03,
	-3.571100e+06,
	9.933375e+04,
	5.665657e+04,
	3.002215e+03,
	-2.574425e+06,
	2.579319e+04,
	5.681603e+04,
	4.016538e+03,
	-1.456834e+06,
	-3.525546e+04,
	5.484294e+04,
	5.124406e+03,
	-8.939211e+05,
	-6.390266e+04,
	5.124523e+04,
	6.284900e+03,
	-1.101180e+05,
	-8.746416e+04,
	4.665656e+04,
	7.461369e+03,
	-4.681458e+05,
	-6.529437e+04,
	4.184970e+04,
	8.621092e+03,
	-4.045757e+03,
	-7.596463e+04,
	3.697388e+04,
	9.752269e+03,
	-1.734660e+04,
	-6.231731e+04,
	3.224549e+04,
	1.082680e+04,
	-9.987665e+04,
	-4.861101e+04,
	2.799504e+04,
	1.184010e+04,
	7.265535e+04,
	-4.826171e+04,
	2.406867e+04,
	1.278797e+04,
	-1.134999e+04,
	-3.441852e+04,
	2.062683e+04,
	1.365988e+04,
	6.090832e+03,
	-2.914563e+04,
	1.767500e+04,
	1.446480e+04,
	-6.974627e+02,
	-2.329559e+04,
	1.508844e+04,
	1.520183e+04,
	-1.472800e+04,
	-1.825859e+04,
	1.284207e+04,
	1.587375e+04,
	3.206836e+04,
	-1.770135e+04,
	1.085176e+04,
	1.648269e+04,
	-2.032028e+03,
	-1.153400e+04,
	9.204911e+03,
	1.702789e+04,
	-2.968679e+04,
	-7.797147e+03,
	7.845514e+03,
	1.752289e+04,
	3.245165e+04,
	-1.117046e+04,
	6.548123e+03,
	1.796936e+04,
	-1.709462e+04,
	-4.558688e+03,
	5.505584e+03,
	1.835768e+04,
	-9.796017e+03,
	-4.811111e+03,
	4.633948e+03,
	1.870978e+04,
	3.674447e+03,
	-5.128812e+03,
	3.778722e+03,
	1.901758e+04,
	1.967537e+02,
	-3.600181e+03,
	3.057183e+03,
	1.927876e+04,
	-1.317163e+04,
	-1.679278e+03,
	2.480028e+03,
	1.950210e+04,
	-2.183190e+03,
	-2.611229e+03,
	1.910794e+03,
	1.969236e+04,
	-1.531156e+04,
	-6.658682e+02,
	1.393683e+03,
	1.984029e+04,
	-1.371122e+04,
	-5.957229e+02,
	8.684685e+02,
	1.995218e+04,
	-1.023819e+04,
	-8.502304e+01,
	3.579622e+02,
	2.001862e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.585623e+03,
	2.130250e+02,
	0,
	0,
	-1.935079e+05,
	3.900197e+03,
	9.971148e-01,
	1.570887e-03,
	-6.527066e+05,
	1.858015e+04,
	2.205255e+01,
	4.974477e-02,
	-1.500053e+06,
	6.028248e+04,
	1.529140e+02,
	4.916878e-01,
	-4.974313e+06,
	1.764505e+05,
	6.943200e+02,
	3.048045e+00,
	-8.678217e+06,
	3.342531e+05,
	2.410493e+03,
	1.446892e+01,
	-1.052839e+07,
	4.688102e+05,
	6.113438e+03,
	5.121774e+01,
	-1.280428e+07,
	5.701865e+05,
	1.214618e+04,
	1.417166e+02,
	-9.465653e+06,
	5.125406e+05,
	2.000545e+04,
	3.248129e+02,
	-9.176467e+06,
	4.685079e+05,
	2.835925e+04,
	6.344485e+02,
	-6.639283e+06,
	3.383421e+05,
	3.609536e+04,
	1.101131e+03,
	-3.945560e+06,
	2.017257e+05,
	4.181661e+04,
	1.731452e+03,
	-3.291661e+06,
	1.255684e+05,
	4.524933e+04,
	2.513072e+03,
	-1.322687e+06,
	2.510134e+04,
	4.636870e+04,
	3.426583e+03,
	-1.300582e+06,
	1.614129e+03,
	4.558508e+04,
	4.432770e+03,
	-4.698930e+05,
	-4.109357e+04,
	4.343189e+04,
	5.505804e+03,
	-4.863562e+05,
	-4.316647e+04,
	4.031339e+04,
	6.606426e+03,
	-1.901139e+05,
	-5.444630e+04,
	3.665707e+04,
	7.711348e+03,
	5.980810e+04,
	-5.772322e+04,
	3.272677e+04,
	8.791214e+03,
	-1.495518e+05,
	-3.987647e+04,
	2.904712e+04,
	9.828835e+03,
	-6.078588e+04,
	-3.976407e+04,
	2.555865e+04,
	1.082406e+04,
	5.486112e+04,
	-3.893029e+04,
	2.216912e+04,
	1.175926e+04,
	1.144987e+04,
	-2.896840e+04,
	1.918876e+04,
	1.262592e+04,
	-5.371250e+04,
	-2.059823e+04,
	1.665072e+04,
	1.343193e+04,
	5.297801e+04,
	-2.371871e+04,
	1.429575e+04,
	1.417935e+04,
	-5.458191e+04,
	-1.220823e+04,
	1.227995e+04,
	1.485766e+04,
	2.920703e+04,
	-1.633866e+04,
	1.045753e+04,
	1.548314e+04,
	-2.082029e+03,
	-1.050044e+04,
	8.856110e+03,
	1.604077e+04,
	-2.664664e+03,
	-8.621342e+03,
	7.539708e+03,
	1.654564e+04,
	-1.404636e+04,
	-6.326128e+03,
	6.381937e+03,
	1.699969e+04,
	1.024075e+04,
	-7.296601e+03,
	5.310162e+03,
	1.740478e+04,
	-1.510660e+04,
	-3.541083e+03,
	4.411345e+03,
	1.775632e+04,
	3.804952e+03,
	-4.830017e+03,
	3.602141e+03,
	1.806686e+04,
	-1.490810e+04,
	-2.032319e+03,
	2.896991e+03,
	1.832807e+04,
	-1.242364e+03,
	-3.160581e+03,
	2.230378e+03,
	1.855009e+04,
	-1.894988e+04,
	-6.198991e+02,
	1.637798e+03,
	1.872279e+04,
	-1.737924e+04,
	-5.863084e+02,
	1.025930e+03,
	1.885493e+04,
	-1.268231e+04,
	-3.096204e+01,
	4.118873e+02,
	1.893342e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-5.049934e+03,
	5.631291e+01,
	0,
	0,
	6.967623e+03,
	1.862467e+01,
	2.093108e-01,
	5.236292e-04,
	-7.322636e+04,
	2.442067e+03,
	8.394707e-01,
	2.618146e-03,
	-3.181040e+05,
	1.374125e+04,
	2.155526e+01,
	7.330808e-02,
	-1.148779e+06,
	5.153572e+04,
	1.649367e+02,
	7.624041e-01,
	-2.733073e+06,
	1.274952e+05,
	7.729699e+02,
	4.857184e+00,
	-4.098947e+06,
	2.168990e+05,
	2.448323e+03,
	2.118970e+01,
	-5.332313e+06,
	2.988307e+05,
	5.711927e+03,
	6.820689e+01,
	-5.635984e+06,
	3.325101e+05,
	1.066895e+04,
	1.751199e+02,
	-4.580008e+06,
	3.018134e+05,
	1.668111e+04,
	3.755809e+02,
	-3.996023e+06,
	2.577529e+05,
	2.279537e+04,
	6.973693e+02,
	-2.766915e+06,
	1.817487e+05,
	2.816438e+04,
	1.159531e+03,
	-1.990806e+06,
	1.182930e+05,
	3.210268e+04,
	1.762734e+03,
	-1.289423e+06,
	6.188542e+04,
	3.442340e+04,
	2.495993e+03,
	-8.057612e+05,
	2.131305e+04,
	3.517139e+04,
	3.336770e+03,
	-4.410684e+05,
	-6.496765e+03,
	3.463019e+04,
	4.257853e+03,
	-4.309360e+05,
	-1.502963e+04,
	3.317952e+04,
	5.231419e+03,
	-1.311448e+05,
	-3.210778e+04,
	3.100030e+04,
	6.234108e+03,
	-4.415939e+04,
	-3.380143e+04,
	2.839568e+04,
	7.235375e+03,
	-1.499349e+05,
	-2.599550e+04,
	2.576558e+04,
	8.220003e+03,
	1.383474e+04,
	-3.242390e+04,
	2.304396e+04,
	9.179023e+03,
	-2.218020e+04,
	-2.541662e+04,
	2.039304e+04,
	1.009087e+04,
	-1.073837e+04,
	-2.250757e+04,
	1.797035e+04,
	1.095521e+04,
	-2.943186e+03,
	-1.953326e+04,
	1.573007e+04,
	1.176649e+04,
	-1.123711e+04,
	-1.592828e+04,
	1.370204e+04,
	1.252187e+04,
	2.490499e+03,
	-1.435292e+04,
	1.186123e+04,
	1.322100e+04,
	-1.794959e+04,
	-1.053958e+04,
	1.022032e+04,
	1.386157e+04,
	7.179634e+03,
	-1.085313e+04,
	8.718724e+03,
	1.444657e+04,
	8.523870e+02,
	-8.182112e+03,
	7.395488e+03,
	1.497070e+04,
	-1.097305e+04,
	-5.802531e+03,
	6.280139e+03,
	1.544169e+04,
	-8.647890e+03,
	-5.258780e+03,
	5.262032e+03,
	1.586351e+04,
	-5.795295e+03,
	-4.678129e+03,
	4.303340e+03,
	1.623208e+04,
	-6.554213e+03,
	-3.732850e+03,
	3.435184e+03,
	1.654581e+04,
	-7.571927e+03,
	-2.901504e+03,
	2.660403e+03,
	1.680635e+04,
	-2.053198e+04,
	-1.047036e+03,
	1.963335e+03,
	1.701494e+04,
	-2.185000e+04,
	-5.709901e+02,
	1.230253e+03,
	1.717247e+04,
	-1.551733e+04,
	-6.146695e+00,
	4.907671e+02,
	1.726691e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-7.205704e+02,
	2.019571e+01,
	0,
	0,
	5.648551e+02,
	8.455095e+01,
	1.600871e-01,
	5.236292e-04,
	-2.062497e+04,
	1.347926e+03,
	1.396682e+00,
	5.759921e-03,
	-1.861333e+05,
	9.330316e+03,
	1.914727e+01,
	9.425325e-02,
	-4.557963e+05,
	2.826252e+04,
	1.454540e+02,
	9.482924e-01,
	-9.818830e+05,
	6.498886e+04,
	5.985040e+02,
	5.287607e+00,
	-1.707438e+06,
	1.141619e+05,
	1.758923e+03,
	2.087971e+01,
	-2.036629e+06,
	1.496179e+05,
	3.958518e+03,
	6.352460e+01,
	-2.012618e+06,
	1.637584e+05,
	7.165573e+03,
	1.556844e+02,
	-1.950650e+06,
	1.617404e+05,
	1.107139e+04,
	3.226943e+02,
	-1.667168e+06,
	1.387401e+05,
	1.516993e+04,
	5.881769e+02,
	-1.142383e+06,
	1.009370e+05,
	1.883831e+04,
	9.663550e+02,
	-7.952061e+05,
	6.944554e+04,
	2.170582e+04,
	1.458843e+03,
	-7.726009e+05,
	5.004691e+04,
	2.370696e+04,
	2.060531e+03,
	-2.850905e+05,
	1.452110e+04,
	2.467497e+04,
	2.760501e+03,
	-3.098623e+05,
	7.430022e+03,
	2.475227e+04,
	3.532009e+03,
	-2.339934e+05,
	-3.779062e+03,
	2.420063e+04,
	4.361069e+03,
	9.185211e+03,
	-1.890242e+04,
	2.300010e+04,
	5.223842e+03,
	-1.739850e+05,
	-8.944235e+03,
	2.156361e+04,
	6.095069e+03,
	-2.235243e+04,
	-1.943860e+04,
	1.989104e+04,
	6.972243e+03,
	1.198136e+04,
	-1.908709e+04,
	1.800541e+04,
	7.826082e+03,
	-5.284415e+04,
	-1.280211e+04,
	1.625202e+04,
	8.649491e+03,
	7.936083e+03,
	-1.590172e+04,
	1.452061e+04,
	9.442641e+03,
	-3.481822e+04,
	-1.076757e+04,
	1.285434e+04,
	1.018969e+04,
	2.668691e+04,
	-1.397913e+04,
	1.125258e+04,
	1.089268e+04,
	-4.318571e+04,
	-6.253629e+03,
	9.834934e+03,
	1.153860e+04,
	1.098736e+04,
	-1.042348e+04,
	8.469408e+03,
	1.214108e+04,
	-2.425142e+02,
	-7.313199e+03,
	7.189537e+03,
	1.267873e+04,
	-2.017386e+04,
	-4.486061e+03,
	6.121964e+03,
	1.316283e+04,
	-2.992189e+03,
	-5.709493e+03,
	5.078553e+03,
	1.359667e+04,
	-9.666249e+03,
	-3.987421e+03,
	4.098707e+03,
	1.396771e+04,
	-1.813279e+04,
	-2.576703e+03,
	3.213557e+03,
	1.428080e+04,
	-1.133652e+04,
	-2.823670e+03,
	2.323008e+03,
	1.453377e+04,
	-3.741587e+04,
	7.057299e+02,
	1.498721e+03,
	1.471689e+04,
	-1.584264e+04,
	-3.098032e+02,
	5.619166e+02,
	1.483525e+04,
};

double solarDataset640[] = 
{
	-4.439940e+13,
	4.727269e+08,
	1.531960e+05,
	2.789585e+03,
	1.591240e+12,
	-3.752929e+08,
	1.299147e+05,
	2.792139e+03,
	-1.520825e+10,
	9.464386e+06,
	1.088507e+05,
	2.805146e+03,
	4.968166e+09,
	-3.484485e+06,
	1.101562e+05,
	2.841278e+03,
	-1.879797e+09,
	4.089612e+06,
	1.117743e+05,
	2.911407e+03,
	3.175884e+08,
	-3.936103e+05,
	1.141396e+05,
	3.031274e+03,
	-1.247720e+08,
	7.638848e+05,
	1.152491e+05,
	3.210576e+03,
	-5.488648e+07,
	3.411906e+05,
	1.167998e+05,
	3.465231e+03,
	7.500485e+07,
	-2.624350e+05,
	1.173902e+05,
	3.807030e+03,
	-7.626345e+07,
	6.188938e+05,
	1.185754e+05,
	4.246394e+03,
	-3.559987e+07,
	1.218147e+05,
	1.193649e+05,
	4.806045e+03,
	-5.712451e+04,
	-2.445439e+05,
	1.172780e+05,
	5.484460e+03,
	-2.917238e+07,
	2.280130e+04,
	1.139230e+05,
	6.275571e+03,
	-5.538333e+06,
	-3.268659e+05,
	1.085716e+05,
	7.182661e+03,
	-1.121999e+07,
	-2.401591e+05,
	1.009303e+05,
	8.172688e+03,
	-2.076868e+06,
	-3.706500e+05,
	9.172349e+04,
	9.227661e+03,
	-3.291261e+06,
	-2.970064e+05,
	8.154785e+04,
	1.030640e+04,
	-1.434784e+06,
	-2.886252e+05,
	7.122383e+04,
	1.138676e+04,
	-1.028562e+06,
	-2.454059e+05,
	6.099909e+04,
	1.243693e+04,
	5.490447e+05,
	-2.301291e+05,
	5.134306e+04,
	1.343419e+04,
	-3.430376e+05,
	-1.558810e+05,
	4.292772e+04,
	1.435918e+04,
	1.571421e+03,
	-1.323344e+05,
	3.566474e+04,
	1.521511e+04,
	9.796970e+04,
	-1.046920e+05,
	2.933950e+04,
	1.599219e+04,
	3.387552e+04,
	-7.798390e+04,
	2.405845e+04,
	1.669041e+04,
	8.586974e+04,
	-6.144906e+04,
	1.968644e+04,
	1.731476e+04,
	2.430737e+04,
	-4.445872e+04,
	1.611932e+04,
	1.786927e+04,
	8.554925e+04,
	-3.643019e+04,
	1.321141e+04,
	1.836202e+04,
	-4.184780e+04,
	-2.225372e+04,
	1.090368e+04,
	1.879790e+04,
	1.450911e+04,
	-2.047436e+04,
	8.970817e+03,
	1.918782e+04,
	5.758854e+04,
	-1.762438e+04,
	7.327434e+03,
	1.952962e+04,
	-2.647884e+04,
	-8.760163e+03,
	6.090933e+03,
	1.982896e+04,
	9.619644e+03,
	-9.392713e+03,
	5.064150e+03,
	2.009878e+04,
	1.331023e+04,
	-7.397082e+03,
	4.176136e+03,
	2.033522e+04,
	-1.686056e+04,
	-3.825364e+03,
	3.487137e+03,
	2.054344e+04,
	1.693753e+04,
	-5.541195e+03,
	2.872701e+03,
	2.072965e+04,
	-8.264414e+03,
	-2.280044e+03,
	2.383048e+03,
	2.088944e+04,
	4.622434e+03,
	-2.963743e+03,
	1.980519e+03,
	2.103278e+04,
	-5.561131e+03,
	-1.469762e+03,
	1.637947e+03,
	2.115668e+04,
	-5.453383e+02,
	-1.717846e+03,
	1.335926e+03,
	2.126589e+04,
	-4.010140e+02,
	-1.347042e+03,
	1.062944e+03,
	2.135796e+04,
	1.078165e+02,
	-1.080735e+03,
	8.377248e+02,
	2.143475e+04,
	-4.695232e+03,
	-3.873397e+02,
	6.567006e+02,
	2.149810e+04,
	-3.120412e+03,
	-5.195693e+02,
	4.759587e+02,
	2.155020e+04,
	-6.441655e+03,
	1.058743e+00,
	2.972071e+02,
	2.158758e+04,
	-3.280148e+03,
	-4.465469e+01,
	1.123506e+02,
	2.161064e+04,
	-2.992526e+13,
	3.093632e+08,
	1.285107e+05,
	1.370598e+03,
	1.480405e+12,
	-3.114235e+08,
	1.125000e+05,
	1.372752e+03,
	-1.218458e+11,
	6.632321e+07,
	1.020083e+05,
	1.384393e+03,
	1.665317e+10,
	-1.847940e+07,
	1.062419e+05,
	1.420637e+03,
	-9.113149e+08,
	3.008784e+06,
	1.029925e+05,
	1.485201e+03,
	1.490734e+08,
	6.212466e+05,
	1.062972e+05,
	1.595766e+03,
	-1.105384e+08,
	1.142941e+06,
	1.093467e+05,
	1.764612e+03,
	-5.228906e+06,
	5.746185e+05,
	1.127616e+05,
	2.008312e+03,
	-4.552848e+07,
	6.442601e+05,
	1.159764e+05,
	2.341555e+03,
	-3.742689e+07,
	4.419059e+05,
	1.188852e+05,
	2.782009e+03,
	-3.101838e+07,
	2.582848e+05,
	1.205636e+05,
	3.343203e+03,
	-2.861615e+07,
	1.118720e+05,
	1.204816e+05,
	4.033752e+03,
	-1.284625e+07,
	-1.383981e+05,
	1.179923e+05,
	4.854326e+03,
	-1.827905e+07,
	-1.249114e+05,
	1.132356e+05,
	5.792405e+03,
	-3.759817e+06,
	-3.523765e+05,
	1.060046e+05,
	6.833684e+03,
	-8.330140e+06,
	-2.577154e+05,
	9.700446e+04,
	7.940175e+03,
	-1.445189e+06,
	-3.560434e+05,
	8.673825e+04,
	9.089991e+03,
	-2.022213e+06,
	-2.868506e+05,
	7.584981e+04,
	1.023690e+04,
	-2.065185e+05,
	-2.739897e+05,
	6.523903e+04,
	1.135845e+04,
	-2.118780e+05,
	-2.174656e+05,
	5.534385e+04,
	1.242638e+04,
	-3.909280e+05,
	-1.684039e+05,
	4.654358e+04,
	1.342916e+04,
	1.510131e+05,
	-1.471904e+05,
	3.866829e+04,
	1.435729e+04,
	1.105359e+05,
	-1.114876e+05,
	3.188896e+04,
	1.519973e+04,
	2.486681e+04,
	-8.288938e+04,
	2.627788e+04,
	1.596027e+04,
	8.548810e+04,
	-6.590200e+04,
	2.160359e+04,
	1.664380e+04,
	1.020428e+04,
	-4.763506e+04,
	1.775888e+04,
	1.725353e+04,
	9.132896e+04,
	-3.989775e+04,
	1.458947e+04,
	1.779729e+04,
	-5.893551e+04,
	-2.401330e+04,
	1.205272e+04,
	1.827892e+04,
	8.786788e+04,
	-2.590156e+04,
	9.903800e+03,
	1.871007e+04,
	-4.375724e+04,
	-1.286701e+04,
	8.192812e+03,
	1.908692e+04,
	3.806013e+04,
	-1.494288e+04,
	6.768657e+03,
	1.942561e+04,
	-2.022679e+04,
	-7.996085e+03,
	5.595118e+03,
	1.972091e+04,
	4.406976e+04,
	-1.028506e+04,
	4.614651e+03,
	1.998424e+04,
	-3.557882e+04,
	-2.482117e+03,
	3.885495e+03,
	2.021282e+04,
	1.494002e+04,
	-6.049385e+03,
	3.237819e+03,
	2.042301e+04,
	-4.199329e+03,
	-3.113389e+03,
	2.662895e+03,
	2.060288e+04,
	3.034471e+03,
	-3.103970e+03,
	2.203542e+03,
	2.076205e+04,
	1.633791e+03,
	-2.268264e+03,
	1.819033e+03,
	2.090013e+04,
	-1.012340e+04,
	-8.623465e+02,
	1.515031e+03,
	2.102106e+04,
	2.750467e+03,
	-2.003038e+03,
	1.204360e+03,
	2.112756e+04,
	-6.190024e-03,
	-1.186111e+03,
	9.348330e+02,
	2.121315e+04,
	-5.805871e+03,
	-3.823047e+02,
	7.336037e+02,
	2.128391e+04,
	-3.542666e+03,
	-5.948154e+02,
	5.273264e+02,
	2.134212e+04,
	-5.934580e+03,
	-1.228610e+02,
	3.234636e+02,
	2.138330e+04,
	-4.084604e+03,
	-1.983933e+00,
	1.289217e+02,
	2.140821e+04,
	-3.727579e+12,
	5.679231e+08,
	-1.625664e+04,
	4.250653e+02,
	-4.419365e+12,
	1.046109e+09,
	0,
	4.249347e+02,
	3.326869e+10,
	-2.023689e+07,
	5.941925e+04,
	4.324018e+02,
	3.471040e+09,
	-1.203176e+06,
	5.686938e+04,
	4.508607e+02,
	-6.372727e+08,
	3.160899e+06,
	5.957054e+04,
	4.875431e+02,
	2.755881e+08,
	1.055176e+06,
	6.410412e+04,
	5.529359e+02,
	-1.275647e+08,
	1.970311e+06,
	6.944887e+04,
	6.571524e+02,
	5.075274e+07,
	1.126893e+06,
	7.624159e+04,
	8.172947e+02,
	-8.482724e+07,
	1.658999e+06,
	8.409947e+04,
	1.050219e+03,
	-6.311669e+07,
	1.260619e+06,
	9.295005e+04,
	1.383576e+03,
	-4.552108e+07,
	8.872372e+05,
	1.005958e+05,
	1.838863e+03,
	-3.875198e+07,
	6.047687e+05,
	1.062746e+05,
	2.433263e+03,
	-1.845368e+07,
	2.163822e+05,
	1.091074e+05,
	3.176447e+03,
	-2.407756e+07,
	1.539447e+05,
	1.089878e+05,
	4.062922e+03,
	-9.843639e+06,
	-1.515457e+05,
	1.054688e+05,
	5.084079e+03,
	-6.115161e+06,
	-2.330786e+05,
	9.867827e+04,
	6.200673e+03,
	-4.041083e+06,
	-2.626724e+05,
	9.005089e+04,
	7.379350e+03,
	-2.210499e+06,
	-2.717189e+05,
	8.024778e+04,
	8.584178e+03,
	-7.206211e+05,
	-2.613685e+05,
	6.997467e+04,
	9.778451e+03,
	-3.314310e+05,
	-2.216301e+05,
	6.004300e+04,
	1.093132e+04,
	-3.603027e+05,
	-1.775358e+05,
	5.094016e+04,
	1.202401e+04,
	1.605319e+04,
	-1.514987e+05,
	4.271129e+04,
	1.304370e+04,
	2.002792e+05,
	-1.228584e+05,
	3.549450e+04,
	1.397850e+04,
	-8.648454e+04,
	-8.570485e+04,
	2.947253e+04,
	1.482726e+04,
	1.357791e+05,
	-7.475766e+04,
	2.436487e+04,
	1.559714e+04,
	-3.989941e+03,
	-5.194180e+04,
	2.011571e+04,
	1.628557e+04,
	8.306635e+04,
	-4.386703e+04,
	1.660847e+04,
	1.690318e+04,
	-2.096461e+04,
	-2.912937e+04,
	1.375069e+04,
	1.745251e+04,
	5.301057e+04,
	-2.639084e+04,
	1.137582e+04,
	1.794452e+04,
	-3.157995e+04,
	-1.607394e+04,
	9.439187e+03,
	1.837976e+04,
	5.385344e+04,
	-1.741312e+04,
	7.800361e+03,
	1.876916e+04,
	-2.015355e+04,
	-8.869094e+03,
	6.498800e+03,
	1.911013e+04,
	-2.198646e+03,
	-8.557864e+03,
	5.429310e+03,
	1.941755e+04,
	2.183501e+04,
	-8.210271e+03,
	4.474652e+03,
	1.968824e+04,
	-1.617257e+04,
	-3.638040e+03,
	3.742270e+03,
	1.992456e+04,
	1.241488e+04,
	-5.232775e+03,
	3.110539e+03,
	2.013736e+04,
	-1.201730e+04,
	-2.114134e+03,
	2.586648e+03,
	2.032131e+04,
	4.745978e+03,
	-3.261955e+03,
	2.124178e+03,
	2.048556e+04,
	1.127970e+03,
	-2.123757e+03,
	1.725024e+03,
	2.062462e+04,
	-7.597785e+03,
	-9.417226e+02,
	1.419309e+03,
	2.074488e+04,
	1.883744e+03,
	-1.753948e+03,
	1.118928e+03,
	2.084928e+04,
	-6.322678e+03,
	-5.176974e+02,
	8.620266e+02,
	2.093272e+04,
	-1.605836e+03,
	-9.285398e+02,
	6.193314e+02,
	2.100093e+04,
	-1.097960e+04,
	3.171899e+02,
	4.038220e+02,
	2.104937e+04,
	-4.141973e+03,
	-9.836002e+01,
	1.504665e+02,
	2.108164e+04,
	-2.330422e+13,
	2.884024e+08,
	3.068028e+04,
	6.138150e+01,
	4.881998e+11,
	-1.148322e+08,
	1.984912e+04,
	6.187669e+01,
	1.916792e+09,
	9.729664e+05,
	1.346125e+04,
	6.345753e+01,
	-6.675440e+08,
	2.022162e+06,
	1.471542e+04,
	6.803805e+01,
	3.159170e+08,
	5.956514e+05,
	1.648024e+04,
	7.807293e+01,
	1.478614e+08,
	9.030786e+05,
	1.878080e+04,
	9.642790e+01,
	-3.518216e+07,
	1.443802e+06,
	2.270551e+04,
	1.286811e+02,
	1.119347e+07,
	1.312378e+06,
	2.852122e+04,
	1.849385e+02,
	-7.701323e+07,
	1.801352e+06,
	3.645263e+04,
	2.794408e+02,
	-4.292657e+07,
	1.527104e+06,
	4.669619e+04,
	4.369697e+02,
	-5.878099e+07,
	1.547497e+06,
	5.815348e+04,
	6.840577e+02,
	-4.645158e+07,
	1.228475e+06,
	7.007176e+04,
	1.055326e+03,
	-3.318499e+07,
	8.600360e+05,
	8.035939e+04,
	1.577501e+03,
	-2.625219e+07,
	5.584589e+05,
	8.775849e+04,
	2.265846e+03,
	-1.490142e+07,
	2.204949e+05,
	9.128794e+04,
	3.120972e+03,
	-9.255229e+06,
	2.252877e+04,
	9.079563e+04,
	4.120827e+03,
	-7.977564e+06,
	-6.768208e+04,
	8.706674e+04,
	5.234990e+03,
	-1.201566e+06,
	-2.257152e+05,
	8.041358e+04,
	6.425469e+03,
	-2.557683e+06,
	-1.738737e+05,
	7.235760e+04,
	7.637924e+03,
	-6.451356e+05,
	-2.017795e+05,
	6.379658e+04,
	8.850205e+03,
	-3.054659e+05,
	-1.757830e+05,
	5.511053e+04,
	1.002201e+04,
	4.282739e+03,
	-1.507765e+05,
	4.703559e+04,
	1.113375e+04,
	-6.875119e+04,
	-1.179384e+05,
	3.983315e+04,
	1.217219e+04,
	-6.539296e+04,
	-9.429366e+04,
	3.351548e+04,
	1.313309e+04,
	1.390880e+05,
	-8.139794e+04,
	2.796880e+04,
	1.401195e+04,
	1.433916e+04,
	-5.814147e+04,
	2.331691e+04,
	1.480596e+04,
	4.800799e+04,
	-4.699949e+04,
	1.945486e+04,
	1.552491e+04,
	3.355324e+04,
	-3.590662e+04,
	1.623079e+04,
	1.617181e+04,
	-4.753516e+04,
	-2.457913e+04,
	1.357598e+04,
	1.675372e+04,
	4.184174e+04,
	-2.433031e+04,
	1.125925e+04,
	1.727713e+04,
	1.681958e+04,
	-1.719019e+04,
	9.323416e+03,
	1.773841e+04,
	1.359243e+04,
	-1.318457e+04,
	7.786144e+03,
	1.814905e+04,
	-1.223584e+04,
	-8.858780e+03,
	6.540344e+03,
	1.851573e+04,
	6.675612e+03,
	-8.506817e+03,
	5.462955e+03,
	1.884458e+04,
	9.691761e+03,
	-6.794523e+03,
	4.542950e+03,
	1.913430e+04,
	-1.311304e+04,
	-3.705444e+03,
	3.816631e+03,
	1.939046e+04,
	3.177047e+03,
	-4.478421e+03,
	3.166507e+03,
	1.961984e+04,
	1.744567e+02,
	-3.216510e+03,
	2.594630e+03,
	1.981779e+04,
	-3.774980e+03,
	-2.236340e+03,
	2.129548e+03,
	1.998954e+04,
	7.002038e+02,
	-2.227548e+03,
	1.720140e+03,
	2.013795e+04,
	-5.785630e+03,
	-1.144891e+03,
	1.374334e+03,
	2.026261e+04,
	-1.111106e+03,
	-1.431800e+03,
	1.055204e+03,
	2.036742e+04,
	-9.405081e+03,
	-2.669856e+02,
	7.737057e+02,
	2.044926e+04,
	-7.953502e+03,
	-3.131021e+02,
	4.776272e+02,
	2.051154e+04,
	-5.955234e+03,
	-2.333631e+00,
	1.878496e+02,
	2.054783e+04,
	5.900736e+12,
	-6.184322e+07,
	-3.127993e+03,
	4.662247e+00,
	-2.586883e+11,
	5.655632e+07,
	0,
	4.620175e+00,
	6.674828e+09,
	-3.908526e+06,
	2.349221e+03,
	4.989151e+00,
	1.823458e+08,
	2.419007e+05,
	1.936986e+03,
	5.573806e+00,
	-9.320896e+07,
	5.604882e+05,
	2.468082e+03,
	6.954925e+00,
	7.579802e+07,
	2.506737e+05,
	3.337623e+03,
	1.006148e+01,
	-1.611317e+07,
	6.330473e+05,
	4.683591e+03,
	1.620640e+01,
	-1.376354e+07,
	7.637402e+05,
	7.223657e+03,
	2.932462e+01,
	-2.583591e+07,
	1.010277e+06,
	1.132308e+04,
	5.650986e+01,
	-4.465643e+07,
	1.303261e+06,
	1.779668e+04,
	1.116488e+02,
	-4.722198e+07,
	1.403819e+06,
	2.704938e+04,
	2.186730e+02,
	-4.285916e+07,
	1.335126e+06,
	3.845701e+04,
	4.099392e+02,
	-3.417982e+07,
	1.121722e+06,
	5.070906e+04,
	7.219074e+02,
	-2.901563e+07,
	8.791541e+05,
	6.214431e+04,
	1.187121e+03,
	-1.838120e+07,
	5.316987e+05,
	7.098441e+04,
	1.826925e+03,
	-1.217421e+07,
	2.767583e+05,
	7.602698e+04,
	2.638278e+03,
	-7.803981e+06,
	8.631945e+04,
	7.726482e+04,
	3.602555e+03,
	-4.483355e+06,
	-4.639403e+04,
	7.505263e+04,
	4.686021e+03,
	-2.447868e+06,
	-1.176936e+05,
	7.020737e+04,
	5.845505e+03,
	-1.057698e+06,
	-1.499728e+05,
	6.373873e+04,
	7.037935e+03,
	-5.877838e+05,
	-1.450739e+05,
	5.661180e+04,
	8.225507e+03,
	-3.775252e+05,
	-1.299298e+05,
	4.947172e+04,
	9.381489e+03,
	-4.735522e+04,
	-1.179415e+05,
	4.261136e+04,
	1.048487e+04,
	-3.826733e+04,
	-9.552913e+04,
	3.633754e+04,
	1.151890e+04,
	7.634655e+04,
	-8.044760e+04,
	3.078666e+04,
	1.247799e+04,
	-1.166207e+04,
	-6.027152e+04,
	2.601237e+04,
	1.335852e+04,
	-3.488352e+04,
	-4.748362e+04,
	2.191882e+04,
	1.416472e+04,
	1.451432e+05,
	-4.532720e+04,
	1.833155e+04,
	1.489651e+04,
	-1.018718e+05,
	-2.331123e+04,
	1.545194e+04,
	1.555285e+04,
	6.092841e+04,
	-2.791611e+04,
	1.295407e+04,
	1.615327e+04,
	9.914125e+03,
	-1.852473e+04,
	1.081145e+04,
	1.668531e+04,
	-1.018421e+04,
	-1.364660e+04,
	9.097815e+03,
	1.716368e+04,
	2.677632e+04,
	-1.320567e+04,
	7.616752e+03,
	1.759324e+04,
	-3.190707e+04,
	-6.537187e+03,
	6.413697e+03,
	1.797428e+04,
	3.224420e+04,
	-1.002234e+04,
	5.332416e+03,
	1.831827e+04,
	-1.790675e+04,
	-3.819177e+03,
	4.465077e+03,
	1.861606e+04,
	5.741706e+03,
	-5.269812e+03,
	3.739037e+03,
	1.888589e+04,
	-7.215146e+03,
	-3.071621e+03,
	3.094632e+03,
	1.912037e+04,
	-1.751587e+03,
	-3.077939e+03,
	2.533371e+03,
	1.932641e+04,
	1.684196e+03,
	-2.713112e+03,
	2.030604e+03,
	1.950173e+04,
	-5.727454e+03,
	-1.411693e+03,
	1.625658e+03,
	1.964880e+04,
	-4.801342e+03,
	-1.316339e+03,
	1.262519e+03,
	1.977305e+04,
	-6.741413e+03,
	-8.448004e+02,
	9.137641e+02,
	1.987167e+04,
	-1.490630e+04,
	2.471177e+02,
	5.794638e+02,
	1.994416e+04,
	-5.125526e+03,
	-1.870754e+02,
	1.995830e+02,
	1.998926e+04,
	-2.869444e+12,
	4.196504e+07,
	1.111129e+03,
	1.914998e-01,
	7.156578e+09,
	-1.295320e+06,
	0,
	2.084253e-01,
	-1.403689e+09,
	9.962077e+05,
	0,
	2.021387e-01,
	-8.216375e+07,
	1.203012e+05,
	2.008386e+02,
	2.596854e-01,
	6.555093e+07,
	-5.683459e+04,
	2.540250e+02,
	4.153999e-01,
	-1.211732e+07,
	1.476175e+05,
	3.519336e+02,
	6.958794e-01,
	6.522379e+05,
	1.744630e+05,
	7.256024e+02,
	1.564399e+00,
	-1.052628e+07,
	3.516827e+05,
	1.498850e+03,
	3.995866e+00,
	-2.574797e+07,
	6.281950e+05,
	3.279889e+03,
	1.108668e+01,
	-3.086743e+07,
	8.810812e+05,
	6.898743e+03,
	3.079762e+01,
	-3.884285e+07,
	1.142616e+06,
	1.310979e+04,
	7.910539e+01,
	-3.943960e+07,
	1.250215e+06,
	2.235506e+04,
	1.838892e+02,
	-3.665357e+07,
	1.197647e+06,
	3.392539e+04,
	3.827845e+02,
	-2.694963e+07,
	9.520602e+05,
	4.610324e+04,
	7.159656e+02,
	-2.036503e+07,
	6.966329e+05,
	5.686927e+04,
	1.212730e+03,
	-1.444636e+07,
	4.337031e+05,
	6.479572e+04,
	1.887513e+03,
	-7.699672e+06,
	1.790196e+05,
	6.888180e+04,
	2.732083e+03,
	-5.257205e+06,
	4.882563e+04,
	6.934273e+04,
	3.716165e+03,
	-3.250320e+06,
	-4.591330e+04,
	6.693171e+04,
	4.806015e+03,
	-1.348332e+06,
	-1.107657e+05,
	6.225009e+04,
	5.958500e+03,
	-6.591738e+05,
	-1.229398e+05,
	5.632815e+04,
	7.129749e+03,
	-5.308371e+05,
	-1.127866e+05,
	5.004913e+04,
	8.289289e+03,
	-2.262225e+05,
	-1.068280e+05,
	4.374560e+04,
	9.414179e+03,
	3.731957e+04,
	-9.700161e+04,
	3.768587e+04,
	1.048232e+04,
	-1.736652e+04,
	-7.613110e+04,
	3.223589e+04,
	1.148048e+04,
	-2.414547e+04,
	-6.138152e+04,
	2.745864e+04,
	1.240735e+04,
	6.789920e+04,
	-5.299159e+04,
	2.324807e+04,
	1.326047e+04,
	-1.736037e+04,
	-3.809564e+04,
	1.966746e+04,
	1.403819e+04,
	2.647414e+04,
	-3.277573e+04,
	1.660775e+04,
	1.474812e+04,
	8.534694e+03,
	-2.499570e+04,
	1.399418e+04,
	1.538991e+04,
	-7.165778e+03,
	-1.917919e+04,
	1.179604e+04,
	1.596990e+04,
	1.820885e+04,
	-1.685831e+04,
	9.900832e+03,
	1.649223e+04,
	5.374457e+03,
	-1.240641e+04,
	8.314451e+03,
	1.695838e+04,
	-6.216827e+03,
	-9.208817e+03,
	7.007123e+03,
	1.737642e+04,
	6.178700e+03,
	-8.349800e+03,
	5.875342e+03,
	1.775088e+04,
	-5.600157e+03,
	-5.764635e+03,
	4.917613e+03,
	1.808234e+04,
	6.164147e+03,
	-5.602643e+03,
	4.094812e+03,
	1.837682e+04,
	-9.844895e+03,
	-3.124692e+03,
	3.410559e+03,
	1.863437e+04,
	1.870561e+03,
	-3.694799e+03,
	2.799852e+03,
	1.886209e+04,
	-1.653556e+03,
	-2.538690e+03,
	2.266366e+03,
	1.905585e+04,
	-7.849600e+03,
	-1.504537e+03,
	1.824372e+03,
	1.922132e+04,
	-6.752870e+03,
	-1.437372e+03,
	1.399671e+03,
	1.936046e+04,
	-3.301713e+03,
	-1.417094e+03,
	9.829110e+02,
	1.946895e+04,
	-1.406390e+04,
	1.486421e+02,
	6.317347e+02,
	1.954571e+04,
	-8.038091e+03,
	-1.892693e+01,
	2.567819e+02,
	1.959578e+04,
	8.092438e+10,
	-1.162467e+06,
	-3.206142e+01,
	9.671708e-04,
	-5.505060e+08,
	9.964000e+04,
	0,
	4.835854e-04,
	2.752931e+07,
	-1.352454e+04,
	0,
	9.671708e-04,
	-1.833317e+07,
	2.120320e+04,
	0,
	4.835854e-04,
	2.571019e+06,
	-3.649190e+03,
	4.673637e+00,
	4.352269e-03,
	-7.491211e+04,
	4.848017e+03,
	5.527414e+00,
	8.220952e-03,
	-7.418260e+05,
	1.692347e+04,
	2.018402e+01,
	2.853154e-02,
	-2.336180e+06,
	5.229333e+04,
	8.361598e+01,
	1.460428e-01,
	-4.201515e+06,
	1.305820e+05,
	3.288177e+02,
	7.756710e-01,
	-1.289169e+07,
	3.289640e+05,
	1.129365e+03,
	3.612867e+00,
	-1.762035e+07,
	5.566023e+05,
	3.358858e+03,
	1.475322e+01,
	-2.747414e+07,
	8.490401e+05,
	7.989587e+03,
	4.876524e+01,
	-2.619987e+07,
	9.449800e+05,
	1.575022e+04,
	1.343985e+02,
	-2.483176e+07,
	9.407079e+05,
	2.589242e+04,
	3.096513e+02,
	-2.096394e+07,
	7.980703e+05,
	3.700925e+04,
	6.166125e+02,
	-1.260854e+07,
	5.301678e+05,
	4.692981e+04,
	1.086607e+03,
	-1.011947e+07,
	3.644354e+05,
	5.426536e+04,
	1.727560e+03,
	-6.162520e+06,
	1.740138e+05,
	5.850899e+04,
	2.535811e+03,
	-3.372106e+06,
	4.020494e+04,
	5.938275e+04,
	3.481855e+03,
	-2.254455e+06,
	-2.599647e+04,
	5.763576e+04,
	4.527013e+03,
	-9.857144e+05,
	-7.745357e+04,
	5.399678e+04,
	5.633404e+03,
	-5.863116e+05,
	-8.788475e+04,
	4.923235e+04,
	6.760406e+03,
	-1.620644e+05,
	-9.249139e+04,
	4.402444e+04,
	7.879244e+03,
	-2.699903e+05,
	-7.601326e+04,
	3.884746e+04,
	8.965668e+03,
	-1.358876e+05,
	-7.057037e+04,
	3.384431e+04,
	1.000696e+04,
	1.675314e+05,
	-6.959774e+04,
	2.906964e+04,
	1.098559e+04,
	-9.302058e+04,
	-4.442220e+04,
	2.495681e+04,
	1.189088e+04,
	7.251168e+03,
	-4.169873e+04,
	2.136185e+04,
	1.273426e+04,
	5.481866e+04,
	-3.555078e+04,
	1.813324e+04,
	1.350642e+04,
	-3.479656e+04,
	-2.368568e+04,
	1.543658e+04,
	1.420950e+04,
	1.551094e+04,
	-2.236704e+04,
	1.309303e+04,
	1.485312e+04,
	1.826623e+04,
	-1.782883e+04,
	1.104855e+04,
	1.543299e+04,
	1.003366e+04,
	-1.355278e+04,
	9.363013e+03,
	1.595548e+04,
	-3.906669e+04,
	-7.936198e+03,
	7.972150e+03,
	1.642815e+04,
	3.712882e+04,
	-1.211740e+04,
	6.656119e+03,
	1.685648e+04,
	-2.359586e+04,
	-4.682025e+03,
	5.586378e+03,
	1.722895e+04,
	1.313605e+04,
	-7.041172e+03,
	4.675363e+03,
	1.756662e+04,
	-8.595405e+03,
	-3.626245e+03,
	3.892172e+03,
	1.785962e+04,
	-4.083225e+03,
	-3.541047e+03,
	3.228339e+03,
	1.812020e+04,
	-2.079108e+03,
	-3.062724e+03,
	2.613468e+03,
	1.834503e+04,
	-4.585763e+03,
	-2.207125e+03,
	2.078593e+03,
	1.853488e+04,
	-8.379371e+03,
	-1.445921e+03,
	1.605151e+03,
	1.869252e+04,
	-3.288252e+03,
	-1.643252e+03,
	1.148159e+03,
	1.881809e+04,
	-1.880134e+04,
	4.395417e+02,
	7.550833e+02,
	1.890833e+04,
	-9.040297e+03,
	-8.067476e+01,
	3.009619e+02,
	1.896881e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.709387e+03,
	1.221581e+02,
	0,
	0,
	-5.051096e+04,
	1.037139e+03,
	3.952580e-01,
	4.835854e-04,
	-1.390577e+05,
	5.605787e+03,
	5.152017e+00,
	9.188123e-03,
	-1.185086e+06,
	3.357945e+04,
	4.125296e+01,
	9.961860e-02,
	-3.324630e+06,
	1.101904e+05,
	2.773980e+02,
	9.043047e-01,
	-7.853728e+06,
	2.688967e+05,
	1.210126e+03,
	5.456778e+00,
	-1.227331e+07,
	4.602241e+05,
	3.787044e+03,
	2.381416e+01,
	-1.502364e+07,
	6.070524e+05,
	8.821902e+03,
	7.802554e+01,
	-1.336220e+07,
	6.235281e+05,
	1.626265e+04,
	2.025851e+02,
	-1.337434e+07,
	5.982898e+05,
	2.508429e+04,
	4.360495e+02,
	-8.551671e+06,
	4.261216e+05,
	3.375827e+04,
	8.145489e+02,
	-6.484517e+06,
	2.997790e+05,
	4.067227e+04,
	1.350606e+03,
	-3.892800e+06,
	1.628204e+05,
	4.528823e+04,
	2.044370e+03,
	-3.174152e+06,
	8.617744e+04,
	4.739307e+04,
	2.875549e+03,
	-7.858401e+05,
	-1.795473e+04,
	4.709930e+04,
	3.816879e+03,
	-1.506677e+06,
	-1.051765e+04,
	4.520483e+04,
	4.824117e+03,
	-1.654844e+05,
	-6.662056e+04,
	4.211810e+04,
	5.878308e+03,
	-3.325870e+05,
	-5.482462e+04,
	3.828890e+04,
	6.932492e+03,
	-1.669931e+05,
	-5.691599e+04,
	3.434296e+04,
	7.973661e+03,
	3.176809e+04,
	-5.704259e+04,
	3.032616e+04,
	8.979996e+03,
	-1.281974e+05,
	-4.107245e+04,
	2.659716e+04,
	9.936586e+03,
	5.251609e+04,
	-4.338252e+04,
	2.310631e+04,
	1.084227e+04,
	-3.310454e+04,
	-3.100850e+04,
	1.995372e+04,
	1.168280e+04,
	1.373580e+04,
	-2.826584e+04,
	1.717322e+04,
	1.246385e+04,
	1.486695e+04,
	-2.286523e+04,
	1.471232e+04,
	1.318078e+04,
	-2.699775e+04,
	-1.623475e+04,
	1.261542e+04,
	1.383733e+04,
	3.280403e+04,
	-1.719400e+04,
	1.073590e+04,
	1.443831e+04,
	-2.669848e+04,
	-9.678436e+03,
	9.151064e+03,
	1.497882e+04,
	1.838055e+04,
	-1.142924e+04,
	7.757786e+03,
	1.547212e+04,
	-1.527434e+04,
	-6.522392e+03,
	6.559644e+03,
	1.591064e+04,
	6.134069e+03,
	-7.241503e+03,
	5.514782e+03,
	1.630624e+04,
	-6.323445e+03,
	-4.711065e+03,
	4.604267e+03,
	1.665383e+04,
	-4.073073e+03,
	-4.157336e+03,
	3.818693e+03,
	1.696133e+04,
	-3.689038e+03,
	-3.435628e+03,
	3.109516e+03,
	1.722780e+04,
	-5.989523e+03,
	-2.575961e+03,
	2.483016e+03,
	1.745440e+04,
	-7.028686e+03,
	-2.007072e+03,
	1.916696e+03,
	1.764283e+04,
	-1.237906e+04,
	-1.066394e+03,
	1.391888e+03,
	1.779266e+04,
	-1.530568e+04,
	-3.931004e+02,
	8.686103e+02,
	1.790328e+04,
	-1.075759e+04,
	-3.241883e+01,
	3.519534e+02,
	1.797018e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-3.054978e+04,
	7.410320e+02,
	0,
	0,
	-9.722180e+04,
	4.326381e+03,
	4.923375e+00,
	1.305681e-02,
	-3.957187e+05,
	2.108857e+04,
	4.479837e+01,
	1.639355e-01,
	-2.217090e+06,
	8.601666e+04,
	2.778367e+02,
	1.331311e+00,
	-3.595510e+06,
	1.730620e+05,
	1.233921e+03,
	8.028002e+00,
	-5.986757e+06,
	2.900617e+05,
	3.538550e+03,
	3.203512e+01,
	-6.769567e+06,
	3.551039e+05,
	7.723701e+03,
	9.713732e+01,
	-5.667593e+06,
	3.457250e+05,
	1.341347e+04,
	2.349867e+02,
	-5.458172e+06,
	3.222378e+05,
	1.977905e+04,
	4.766324e+02,
	-3.782412e+06,
	2.373311e+05,
	2.587928e+04,
	8.491315e+02,
	-2.850464e+06,
	1.657680e+05,
	3.072606e+04,
	1.360673e+03,
	-2.076195e+06,
	9.869617e+04,
	3.393877e+04,
	2.007443e+03,
	-8.459967e+05,
	2.822829e+04,
	3.528651e+04,
	2.770476e+03,
	-7.874505e+05,
	9.303483e+03,
	3.518552e+04,
	3.618710e+03,
	-4.961071e+05,
	-1.453427e+04,
	3.405307e+04,
	4.532258e+03,
	-2.021158e+05,
	-3.136214e+04,
	3.200853e+04,
	5.481500e+03,
	-1.413239e+05,
	-3.330948e+04,
	2.947684e+04,
	6.438940e+03,
	-1.032936e+05,
	-3.292416e+04,
	2.675684e+04,
	7.387225e+03,
	-2.743197e+04,
	-3.315766e+04,
	2.395645e+04,
	8.310655e+03,
	-4.213430e+04,
	-2.797667e+04,
	2.123679e+04,
	9.195288e+03,
	1.688152e+04,
	-2.708199e+04,
	1.866320e+04,
	1.003492e+04,
	-3.945755e+04,
	-1.950281e+04,
	1.632798e+04,
	1.082159e+04,
	3.775898e+04,
	-2.118019e+04,
	1.417740e+04,
	1.155761e+04,
	-3.951332e+04,
	-1.232675e+04,
	1.230190e+04,
	1.223448e+04,
	1.628466e+04,
	-1.456907e+04,
	1.060143e+04,
	1.286326e+04,
	2.475050e+03,
	-1.062776e+04,
	9.074832e+03,
	1.343267e+04,
	-2.958304e+04,
	-6.604437e+03,
	7.794557e+03,
	1.395159e+04,
	2.382873e+04,
	-9.973204e+03,
	6.556652e+03,
	1.442337e+04,
	-1.898300e+04,
	-4.141927e+03,
	5.521709e+03,
	1.483557e+04,
	-6.649303e+02,
	-5.415087e+03,
	4.618044e+03,
	1.520793e+04,
	-5.006126e+03,
	-3.945080e+03,
	3.776118e+03,
	1.552981e+04,
	-8.901394e+03,
	-2.910036e+03,
	3.041676e+03,
	1.580619e+04,
	-1.200711e+04,
	-2.169750e+03,
	2.355820e+03,
	1.603784e+04,
	-4.968676e+03,
	-2.395668e+03,
	1.683550e+03,
	1.622197e+04,
	-2.774133e+04,
	6.568597e+02,
	1.105917e+03,
	1.635428e+04,
	-1.302099e+04,
	-1.357563e+02,
	4.374897e+02,
	1.644280e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-9.717292e+02,
	3.525304e+01,
	0,
	0,
	-5.304463e+03,
	3.218125e+02,
	3.073832e-01,
	9.671708e-04,
	-1.934360e+04,
	2.085146e+03,
	3.966715e+00,
	1.644190e-02,
	-3.180464e+05,
	1.510232e+04,
	3.388872e+01,
	1.745743e-01,
	-6.480828e+05,
	4.043076e+04,
	2.338605e+02,
	1.570202e+00,
	-1.516090e+06,
	9.036847e+04,
	8.833714e+02,
	8.063303e+00,
	-2.034832e+06,
	1.366083e+05,
	2.427098e+03,
	3.009062e+01,
	-2.361191e+06,
	1.706568e+05,
	5.064127e+03,
	8.568311e+01,
	-2.387942e+06,
	1.804522e+05,
	8.693407e+03,
	1.993470e+02,
	-2.155769e+06,
	1.647391e+05,
	1.283741e+04,
	3.965541e+02,
	-1.303862e+06,
	1.206826e+05,
	1.681586e+04,
	6.963707e+02,
	-1.382930e+06,
	1.028904e+05,
	2.021420e+04,
	1.105526e+03,
	-7.363076e+05,
	5.682299e+04,
	2.276260e+04,
	1.628739e+03,
	-7.293309e+05,
	3.878596e+04,
	2.422386e+04,
	2.250501e+03,
	-1.958146e+05,
	3.375079e+03,
	2.465448e+04,
	2.957056e+03,
	-2.527096e+05,
	3.571719e+02,
	2.429786e+04,
	3.719856e+03,
	-1.824193e+05,
	-8.454398e+03,
	2.346440e+04,
	4.527808e+03,
	-1.207450e+05,
	-1.454655e+04,
	2.212836e+04,
	5.360145e+03,
	-1.873828e+04,
	-2.014348e+04,
	2.043631e+04,
	6.196165e+03,
	-6.547356e+04,
	-1.592640e+04,
	1.864471e+04,
	7.017728e+03,
	1.538025e+04,
	-1.940620e+04,
	1.681319e+04,
	7.818656e+03,
	-3.081477e+04,
	-1.380759e+04,
	1.505269e+04,
	8.584346e+03,
	-3.688264e+04,
	-1.237202e+04,
	1.339212e+04,
	9.316279e+03,
	3.700757e+04,
	-1.579093e+04,
	1.171025e+04,
	1.000491e+04,
	-3.096457e+04,
	-7.862788e+03,
	1.025124e+04,
	1.063862e+04,
	-3.624742e+03,
	-9.431423e+03,
	8.931243e+03,
	1.123263e+04,
	-7.771562e+02,
	-8.102068e+03,
	7.655642e+03,
	1.177367e+04,
	-9.869735e+03,
	-6.022230e+03,
	6.528116e+03,
	1.226242e+04,
	-4.868512e+03,
	-5.631664e+03,
	5.495559e+03,
	1.270154e+04,
	-9.937763e+03,
	-4.263030e+03,
	4.546326e+03,
	1.308752e+04,
	-4.005424e+03,
	-4.161767e+03,
	3.664244e+03,
	1.342139e+04,
	-1.613158e+04,
	-2.200682e+03,
	2.871716e+03,
	1.369982e+04,
	-1.400113e+04,
	-2.118312e+03,
	2.095777e+03,
	1.392675e+04,
	-2.681191e+04,
	-1.270264e+02,
	1.333515e+03,
	1.409262e+04,
	-1.703298e+04,
	-1.198066e+01,
	5.383685e+02,
	1.419677e+04,
};

double solarDataset680[] = 
{
	-352468042275216,
	4.565228e+09,
	3.493754e+05,
	4.079590e+03,
	5.683662e+12,
	-1.328402e+09,
	1.925649e+05,
	4.085164e+03,
	-7.764229e+10,
	4.963131e+07,
	1.202445e+05,
	4.099044e+03,
	5.563528e+09,
	-4.324424e+06,
	1.277691e+05,
	4.141022e+03,
	-3.769498e+09,
	6.005153e+06,
	1.290424e+05,
	4.222198e+03,
	9.852032e+08,
	-2.967738e+06,
	1.291679e+05,
	4.360144e+03,
	-3.875109e+07,
	1.836524e+05,
	1.271300e+05,
	4.559262e+03,
	-1.192922e+08,
	3.590793e+05,
	1.273769e+05,
	4.838049e+03,
	5.235498e+06,
	-2.993428e+05,
	1.264319e+05,
	5.209221e+03,
	-3.536095e+07,
	-5.551723e+04,
	1.244122e+05,
	5.678238e+03,
	-3.682262e+07,
	-1.175068e+05,
	1.215785e+05,
	6.254607e+03,
	-1.683494e+07,
	-3.365406e+05,
	1.166413e+05,
	6.937634e+03,
	-6.725039e+06,
	-4.184973e+05,
	1.096698e+05,
	7.714702e+03,
	-1.347547e+07,
	-3.110082e+05,
	1.015845e+05,
	8.570426e+03,
	-5.796493e+06,
	-3.962767e+05,
	9.212522e+04,
	9.489327e+03,
	-1.470687e+06,
	-3.999603e+05,
	8.144721e+04,
	1.043704e+04,
	-3.891564e+06,
	-2.924573e+05,
	7.082390e+04,
	1.138470e+04,
	1.268637e+06,
	-3.320372e+05,
	6.027083e+04,
	1.231325e+04,
	-1.553830e+06,
	-2.010288e+05,
	5.070597e+04,
	1.318976e+04,
	6.401092e+05,
	-2.083886e+05,
	4.212731e+04,
	1.401579e+04,
	-4.089157e+05,
	-1.325947e+05,
	3.467286e+04,
	1.476862e+04,
	4.689382e+05,
	-1.255255e+05,
	2.832884e+04,
	1.545545e+04,
	-2.414026e+05,
	-7.345191e+04,
	2.313068e+04,
	1.606742e+04,
	2.093406e+05,
	-7.131366e+04,
	1.878759e+04,
	1.661838e+04,
	8.730097e+04,
	-4.851327e+04,
	1.522608e+04,
	1.710171e+04,
	-2.825615e+04,
	-3.260464e+04,
	1.246629e+04,
	1.753026e+04,
	9.246158e+03,
	-2.696444e+04,
	1.017736e+04,
	1.791157e+04,
	5.845154e+04,
	-2.256224e+04,
	8.255250e+03,
	1.824608e+04,
	-1.623206e+03,
	-1.409944e+04,
	6.758571e+03,
	1.853795e+04,
	1.397299e+04,
	-1.179690e+04,
	5.565383e+03,
	1.879686e+04,
	9.810044e+03,
	-8.809613e+03,
	4.588390e+03,
	1.902473e+04,
	-1.056924e+04,
	-5.731825e+03,
	3.808836e+03,
	1.922618e+04,
	1.867460e+04,
	-6.355988e+03,
	3.137056e+03,
	1.940511e+04,
	-2.207924e+04,
	-2.223620e+03,
	2.609823e+03,
	1.956056e+04,
	2.317944e+04,
	-5.069146e+03,
	2.128577e+03,
	1.970022e+04,
	-1.315186e+04,
	-9.880525e+02,
	1.767994e+03,
	1.981745e+04,
	4.416039e+03,
	-2.401660e+03,
	1.471594e+03,
	1.992484e+04,
	2.469023e+02,
	-1.450777e+03,
	1.203539e+03,
	2.001628e+04,
	-7.126793e+03,
	-5.842061e+02,
	9.964367e+02,
	2.009623e+04,
	5.680761e+03,
	-1.675038e+03,
	7.812342e+02,
	2.016597e+04,
	-3.303117e+03,
	-3.317838e+02,
	6.218765e+02,
	2.022109e+04,
	-3.628281e+03,
	-3.367296e+02,
	4.942834e+02,
	2.026943e+04,
	-1.932363e+03,
	-4.513063e+02,
	3.479496e+02,
	2.030822e+04,
	-2.905107e+03,
	-1.741303e+02,
	2.130510e+02,
	2.033521e+04,
	-2.186812e+03,
	-6.044464e+01,
	9.550916e+01,
	2.035167e+04,
	2.566491e+12,
	-2.160143e+07,
	1.253489e+05,
	2.094745e+03,
	1.072830e+11,
	3.373914e+06,
	1.268921e+05,
	2.096912e+03,
	-6.278151e+10,
	3.625360e+07,
	1.323924e+05,
	2.112461e+03,
	5.355040e+09,
	-6.437409e+06,
	1.359364e+05,
	2.157505e+03,
	6.328454e+08,
	-3.831994e+05,
	1.342600e+05,
	2.242976e+03,
	-3.525021e+08,
	1.289271e+06,
	1.355533e+05,
	2.384464e+03,
	7.237564e+06,
	1.315110e+05,
	1.369959e+05,
	2.598910e+03,
	-8.490662e+07,
	3.829063e+05,
	1.376758e+05,
	2.899528e+03,
	-3.478052e+07,
	3.597080e+04,
	1.377450e+05,
	3.301754e+03,
	-5.179258e+07,
	5.107895e+04,
	1.365542e+05,
	3.815687e+03,
	-2.559535e+07,
	-2.211796e+05,
	1.336407e+05,
	4.449428e+03,
	-2.591427e+07,
	-2.568699e+05,
	1.286169e+05,
	5.199989e+03,
	-1.373490e+07,
	-3.999240e+05,
	1.214603e+05,
	6.059833e+03,
	-1.260242e+07,
	-3.952445e+05,
	1.123008e+05,
	7.008387e+03,
	-2.957989e+06,
	-4.813305e+05,
	1.014858e+05,
	8.021575e+03,
	-5.251237e+06,
	-3.746148e+05,
	8.996501e+04,
	9.064690e+03,
	-4.198038e+05,
	-3.933644e+05,
	7.821981e+04,
	1.011487e+04,
	-1.996456e+06,
	-2.874528e+05,
	6.689029e+04,
	1.113727e+04,
	4.266078e+05,
	-2.786719e+05,
	5.627982e+04,
	1.211684e+04,
	-3.919704e+05,
	-1.965459e+05,
	4.681414e+04,
	1.302821e+04,
	1.091816e+05,
	-1.649710e+05,
	3.862777e+04,
	1.386995e+04,
	3.750077e+05,
	-1.318222e+05,
	3.161062e+04,
	1.463277e+04,
	-2.406655e+05,
	-8.206026e+04,
	2.595029e+04,
	1.531832e+04,
	2.170257e+05,
	-7.837065e+04,
	2.115790e+04,
	1.593722e+04,
	-7.134165e+04,
	-4.885270e+04,
	1.721207e+04,
	1.648268e+04,
	1.378171e+05,
	-4.537327e+04,
	1.397250e+04,
	1.696781e+04,
	3.258145e+04,
	-2.938905e+04,
	1.138823e+04,
	1.739164e+04,
	1.146137e+03,
	-2.126903e+04,
	9.382346e+03,
	1.776806e+04,
	1.883121e+04,
	-1.738343e+04,
	7.723831e+03,
	1.810256e+04,
	-1.217855e+04,
	-1.191290e+04,
	6.363021e+03,
	1.839774e+04,
	1.663010e+04,
	-1.094152e+04,
	5.216659e+03,
	1.865889e+04,
	1.933224e+04,
	-8.372961e+03,
	4.279327e+03,
	1.888639e+04,
	-6.277107e+03,
	-4.826426e+03,
	3.572708e+03,
	1.908656e+04,
	-1.213908e+04,
	-3.694135e+03,
	2.989211e+03,
	1.926630e+04,
	1.843629e+04,
	-5.074897e+03,
	2.437722e+03,
	1.942497e+04,
	-3.720726e+03,
	-2.060727e+03,
	2.022513e+03,
	1.956010e+04,
	-7.571230e+03,
	-1.529007e+03,
	1.706477e+03,
	1.968213e+04,
	3.388922e+03,
	-2.219310e+03,
	1.387955e+03,
	1.978997e+04,
	-8.136688e+02,
	-1.296765e+03,
	1.118924e+03,
	1.988048e+04,
	-2.113553e+00,
	-1.105284e+03,
	9.057690e+02,
	1.995827e+04,
	-5.605613e+03,
	-3.817953e+02,
	7.273565e+02,
	2.002416e+04,
	2.555659e+03,
	-1.135591e+03,
	5.415747e+02,
	2.007969e+04,
	-7.323743e+03,
	1.792085e+02,
	4.001082e+02,
	2.012072e+04,
	-1.158262e+03,
	-4.852916e+02,
	2.418730e+02,
	2.015369e+04,
	-1.923105e+03,
	-1.119911e+02,
	1.136166e+02,
	2.017163e+04,
	-4.453960e+13,
	4.901918e+08,
	1.224067e+05,
	6.971794e+02,
	1.428199e+12,
	-3.402263e+08,
	9.960258e+04,
	6.992069e+02,
	2.850891e+09,
	1.332939e+06,
	7.987958e+04,
	7.087809e+02,
	3.653290e+09,
	-2.318826e+05,
	8.167014e+04,
	7.351861e+02,
	-1.710126e+09,
	5.205901e+06,
	8.583269e+04,
	7.881288e+02,
	3.500513e+08,
	7.327072e+05,
	9.110828e+04,
	8.821503e+02,
	-3.667415e+07,
	1.644077e+06,
	9.599104e+04,
	1.028221e+03,
	-6.427903e+07,
	1.499947e+06,
	1.026622e+05,
	1.245859e+03,
	-8.902301e+07,
	1.348587e+06,
	1.097649e+05,
	1.556074e+03,
	-5.458529e+07,
	8.715855e+05,
	1.161171e+05,
	1.980872e+03,
	-7.078158e+07,
	7.296954e+05,
	1.206867e+05,
	2.536762e+03,
	-2.407104e+07,
	9.613678e+04,
	1.221006e+05,
	3.235974e+03,
	-2.892878e+07,
	3.067619e+04,
	1.200345e+05,
	4.068347e+03,
	-1.424189e+07,
	-2.367188e+05,
	1.148582e+05,
	5.025490e+03,
	-8.468524e+06,
	-3.287116e+05,
	1.065955e+05,
	6.075512e+03,
	-4.418101e+06,
	-3.647176e+05,
	9.643889e+04,
	7.185170e+03,
	-3.842678e+06,
	-3.284474e+05,
	8.532578e+04,
	8.318939e+03,
	-5.278715e+05,
	-3.366958e+05,
	7.378807e+04,
	9.444730e+03,
	-3.937578e+05,
	-2.707005e+05,
	6.272309e+04,
	1.052705e+04,
	-4.639425e+05,
	-2.130327e+05,
	5.276832e+04,
	1.155043e+04,
	2.817660e+05,
	-1.847892e+05,
	4.384989e+04,
	1.250236e+04,
	2.903034e+04,
	-1.344634e+05,
	3.621580e+04,
	1.337110e+04,
	4.635096e+03,
	-1.030736e+05,
	2.983586e+04,
	1.416051e+04,
	2.047168e+05,
	-8.515824e+04,
	2.444758e+04,
	1.487116e+04,
	-1.279274e+05,
	-5.337031e+04,
	2.008387e+04,
	1.550475e+04,
	1.415452e+05,
	-5.181761e+04,
	1.640018e+04,
	1.607299e+04,
	5.602843e+04,
	-3.510271e+04,
	1.339511e+04,
	1.657132e+04,
	-1.127698e+04,
	-2.404607e+04,
	1.106697e+04,
	1.701421e+04,
	1.253660e+04,
	-2.007243e+04,
	9.134211e+03,
	1.740961e+04,
	1.780279e+04,
	-1.574977e+04,
	7.514154e+03,
	1.775883e+04,
	5.640618e+03,
	-1.147763e+04,
	6.204614e+03,
	1.806675e+04,
	2.936546e+03,
	-8.829144e+03,
	5.139387e+03,
	1.833932e+04,
	5.299726e+03,
	-7.061936e+03,
	4.256417e+03,
	1.858020e+04,
	5.686652e+03,
	-5.507486e+03,
	3.532321e+03,
	1.879251e+04,
	-7.404946e+03,
	-3.452414e+03,
	2.950484e+03,
	1.898008e+04,
	3.770764e+03,
	-3.682956e+03,
	2.441272e+03,
	1.914689e+04,
	3.794749e+03,
	-2.805228e+03,
	2.009244e+03,
	1.929140e+04,
	-9.089152e+03,
	-1.190131e+03,
	1.676729e+03,
	1.941776e+04,
	3.011825e+03,
	-2.138990e+03,
	1.359400e+03,
	1.952992e+04,
	1.428751e+02,
	-1.319583e+03,
	1.084559e+03,
	1.962291e+04,
	-4.913817e+03,
	-5.934187e+02,
	8.743950e+02,
	1.970191e+04,
	-5.071407e+02,
	-9.664004e+02,
	6.676441e+02,
	1.976881e+04,
	-4.650836e+03,
	-3.007170e+02,
	4.834242e+02,
	1.982025e+04,
	-5.376321e+03,
	-1.327924e+02,
	3.054971e+02,
	1.985899e+04,
	-3.742214e+03,
	-1.749535e+01,
	1.250497e+02,
	1.988258e+04,
	-7.893237e+12,
	8.288681e+07,
	3.010748e+04,
	1.136166e+02,
	3.103597e+11,
	-7.118740e+07,
	2.592881e+04,
	1.141198e+02,
	8.428280e+09,
	-8.028634e+05,
	2.230568e+04,
	1.167572e+02,
	-3.605961e+09,
	5.798521e+06,
	2.449204e+04,
	1.242727e+02,
	8.783630e+08,
	-1.200222e+04,
	2.748804e+04,
	1.413170e+02,
	1.044530e+08,
	1.460532e+06,
	3.037633e+04,
	1.712288e+02,
	-9.170265e+05,
	1.717708e+06,
	3.572950e+04,
	2.228753e+02,
	-4.501713e+07,
	1.862117e+06,
	4.323714e+04,
	3.093172e+02,
	-7.396908e+07,
	1.935003e+06,
	5.294040e+04,
	4.499654e+02,
	-6.169410e+07,
	1.717830e+06,
	6.431161e+04,
	6.711980e+02,
	-7.366754e+07,
	1.587813e+06,
	7.632218e+04,
	1.002824e+03,
	-4.663231e+07,
	1.055055e+06,
	8.724662e+04,
	1.476305e+03,
	-4.048764e+07,
	7.247687e+05,
	9.513528e+04,
	2.107835e+03,
	-1.960904e+07,
	2.489285e+05,
	9.891534e+04,
	2.902937e+03,
	-1.894416e+07,
	9.872926e+04,
	9.837949e+04,
	3.841311e+03,
	-4.442386e+06,
	-2.116653e+05,
	9.380338e+04,
	4.898693e+03,
	-5.834290e+06,
	-1.885613e+05,
	8.648343e+04,
	6.023302e+03,
	-1.719788e+06,
	-2.613590e+05,
	7.770079e+04,
	7.187578e+03,
	-1.691541e+06,
	-2.251616e+05,
	6.812535e+04,
	8.346053e+03,
	-5.227803e+05,
	-2.157890e+05,
	5.856276e+04,
	9.472141e+03,
	4.814127e+05,
	-1.960903e+05,
	4.946763e+04,
	1.053652e+04,
	-4.579357e+05,
	-1.276666e+05,
	4.162523e+04,
	1.152409e+04,
	1.805291e+05,
	-1.211531e+05,
	3.473519e+04,
	1.244006e+04,
	1.359116e+05,
	-9.125698e+04,
	2.876191e+04,
	1.326975e+04,
	-8.572899e+04,
	-6.301636e+04,
	2.388140e+04,
	1.401999e+04,
	1.408473e+05,
	-5.792684e+04,
	1.972080e+04,
	1.469810e+04,
	-3.746225e+04,
	-3.691816e+04,
	1.630243e+04,
	1.530117e+04,
	6.587470e+04,
	-3.359362e+04,
	1.347244e+04,
	1.584278e+04,
	1.012335e+04,
	-2.298597e+04,
	1.114689e+04,
	1.632227e+04,
	6.639102e+03,
	-1.787249e+04,
	9.269274e+03,
	1.675072e+04,
	-6.477797e+02,
	-1.369067e+04,
	7.700812e+03,
	1.713232e+04,
	2.142191e+04,
	-1.198949e+04,
	6.378977e+03,
	1.747105e+04,
	-4.414359e+03,
	-7.644321e+03,
	5.317687e+03,
	1.776972e+04,
	1.533924e+03,
	-6.582866e+03,
	4.443001e+03,
	1.803667e+04,
	1.981630e+03,
	-5.240241e+03,
	3.694367e+03,
	1.827267e+04,
	-1.052148e+03,
	-3.932107e+03,
	3.071754e+03,
	1.848069e+04,
	7.306138e+02,
	-3.290251e+03,
	2.545786e+03,
	1.866390e+04,
	4.229719e+02,
	-2.571537e+03,
	2.102797e+03,
	1.882392e+04,
	-7.944393e+03,
	-1.390188e+03,
	1.735472e+03,
	1.896341e+04,
	4.214760e+03,
	-2.291285e+03,
	1.382288e+03,
	1.908470e+04,
	-5.750642e+03,
	-7.694022e+02,
	1.094846e+03,
	1.918353e+04,
	1.100272e+02,
	-1.256194e+03,
	8.401738e+02,
	1.926736e+04,
	-1.010048e+04,
	6.181541e+01,
	6.190195e+02,
	1.933230e+04,
	-3.820373e+03,
	-5.389325e+02,
	3.661653e+02,
	1.938243e+04,
	-3.917769e+03,
	-6.433621e+01,
	1.509301e+02,
	1.940952e+04,
	-8.070633e+12,
	1.076138e+08,
	6.631032e+03,
	1.018617e+01,
	1.369399e+11,
	-2.815586e+07,
	3.146703e+03,
	1.029111e+01,
	-1.827832e+10,
	1.209860e+07,
	2.333390e+03,
	1.050144e+01,
	9.521666e+08,
	-5.255783e+05,
	4.376365e+03,
	1.192131e+01,
	1.173580e+07,
	6.003251e+05,
	4.867928e+03,
	1.474579e+01,
	1.090046e+08,
	4.481858e+05,
	6.169347e+03,
	2.054185e+01,
	-8.730001e+06,
	9.393270e+05,
	8.380095e+03,
	3.174291e+01,
	-3.942600e+07,
	1.234005e+06,
	1.236733e+04,
	5.449888e+01,
	-5.058522e+07,
	1.455714e+06,
	1.855333e+04,
	1.000252e+02,
	-5.517395e+07,
	1.596469e+06,
	2.732046e+04,
	1.871469e+02,
	-5.839261e+07,
	1.629707e+06,
	3.862401e+04,
	3.439872e+02,
	-5.114727e+07,
	1.444003e+06,
	5.151836e+04,
	6.065740e+02,
	-3.969641e+07,
	1.116577e+06,
	6.409615e+04,
	1.010369e+03,
	-3.222007e+07,
	7.829705e+05,
	7.436652e+04,
	1.580560e+03,
	-1.492637e+07,
	3.287719e+05,
	8.053808e+04,
	2.324370e+03,
	-1.367783e+07,
	1.737145e+05,
	8.239238e+04,
	3.220077e+03,
	-5.409060e+06,
	-6.916228e+04,
	8.037208e+04,
	4.244663e+03,
	-3.749200e+06,
	-1.294274e+05,
	7.520553e+04,
	5.347740e+03,
	-1.438150e+06,
	-1.808190e+05,
	6.828222e+04,
	6.491727e+03,
	-1.031219e+06,
	-1.695525e+05,
	6.052789e+04,
	7.635895e+03,
	-5.897295e+05,
	-1.566876e+05,
	5.266149e+04,
	8.752942e+03,
	2.142786e+05,
	-1.502598e+05,
	4.501376e+04,
	9.817549e+03,
	-3.080940e+05,
	-1.038003e+05,
	3.819615e+04,
	1.081081e+04,
	2.489975e+05,
	-1.015549e+05,
	3.212658e+04,
	1.173425e+04,
	-1.029353e+05,
	-6.635146e+04,
	2.693457e+04,
	1.257483e+04,
	1.251409e+05,
	-6.152113e+04,
	2.251714e+04,
	1.334400e+04,
	-3.664596e+04,
	-4.097680e+04,
	1.880373e+04,
	1.403645e+04,
	5.410562e+04,
	-3.659535e+04,
	1.568214e+04,
	1.466359e+04,
	-8.388199e+03,
	-2.544703e+04,
	1.306777e+04,
	1.522421e+04,
	3.381060e+04,
	-2.226293e+04,
	1.088538e+04,
	1.572764e+04,
	8.123732e+03,
	-1.580665e+04,
	9.086832e+03,
	1.617555e+04,
	-5.569137e+02,
	-1.204825e+04,
	7.622303e+03,
	1.657705e+04,
	-3.528642e+03,
	-9.509650e+03,
	6.381344e+03,
	1.693640e+04,
	1.153206e+04,
	-8.551674e+03,
	5.310794e+03,
	1.725604e+04,
	-7.248790e+03,
	-5.378741e+03,
	4.434661e+03,
	1.753772e+04,
	3.681099e+03,
	-5.223851e+03,
	3.690070e+03,
	1.778863e+04,
	1.885868e+03,
	-3.926101e+03,
	3.056040e+03,
	1.800796e+04,
	-4.915319e+03,
	-2.588201e+03,
	2.541884e+03,
	1.820050e+04,
	4.294262e+02,
	-2.621170e+03,
	2.087430e+03,
	1.836978e+04,
	-5.053803e+03,
	-1.594382e+03,
	1.693140e+03,
	1.851459e+04,
	-1.007074e+02,
	-1.793775e+03,
	1.337123e+03,
	1.863817e+04,
	-7.506678e+03,
	-6.792374e+02,
	1.030627e+03,
	1.873863e+04,
	8.309197e+02,
	-1.383974e+03,
	7.309777e+02,
	1.881973e+04,
	-1.813795e+04,
	9.635944e+02,
	4.941701e+02,
	1.887662e+04,
	-3.621577e+03,
	-2.330195e+02,
	1.616740e+02,
	1.891720e+04,
	6.535480e+11,
	-5.929338e+06,
	-3.781728e+02,
	5.184347e-01,
	-3.304103e+10,
	7.713900e+06,
	0,
	5.135015e-01,
	1.605064e+08,
	-1.634788e+05,
	4.183612e+02,
	5.677667e-01,
	3.242006e+08,
	-2.400051e+05,
	3.629284e+02,
	6.928907e-01,
	-1.079961e+08,
	3.789254e+05,
	4.524209e+02,
	9.108485e-01,
	1.466292e+07,
	1.653131e+05,
	8.910833e+02,
	1.679980e+00,
	5.139923e+06,
	3.030831e+05,
	1.517958e+03,
	3.541142e+00,
	-2.137928e+07,
	6.141632e+05,
	2.918879e+03,
	8.370747e+00,
	-4.382682e+07,
	9.923543e+05,
	5.952912e+03,
	2.155764e+01,
	-4.591369e+07,
	1.251039e+06,
	1.153723e+04,
	5.541645e+01,
	-5.599871e+07,
	1.504362e+06,
	2.021971e+04,
	1.319322e+02,
	-4.905457e+07,
	1.461205e+06,
	3.191749e+04,
	2.858732e+02,
	-4.156802e+07,
	1.274441e+06,
	4.502474e+04,
	5.570078e+02,
	-3.338034e+07,
	9.727163e+05,
	5.748065e+04,
	9.823445e+02,
	-1.872780e+07,
	5.500384e+05,
	6.692099e+04,
	1.582833e+03,
	-1.333256e+07,
	3.021913e+05,
	7.223951e+04,
	2.351712e+03,
	-6.921961e+06,
	7.087433e+04,
	7.357275e+04,
	3.270621e+03,
	-5.394556e+06,
	-2.381757e+04,
	7.145035e+04,
	4.301491e+03,
	-2.089262e+06,
	-1.282498e+05,
	6.663436e+04,
	5.405952e+03,
	-6.847307e+05,
	-1.546674e+05,
	6.012913e+04,
	6.533810e+03,
	-7.349015e+05,
	-1.335175e+05,
	5.325038e+04,
	7.651409e+03,
	-2.879821e+05,
	-1.272674e+05,
	4.640416e+04,
	8.738273e+03,
	-8.462746e+03,
	-1.130442e+05,
	3.982467e+04,
	9.771057e+03,
	-1.063739e+05,
	-8.787637e+04,
	3.388731e+04,
	1.073618e+04,
	1.343560e+05,
	-7.883937e+04,
	2.860691e+04,
	1.162993e+04,
	1.389387e+04,
	-5.691194e+04,
	2.410021e+04,
	1.244608e+04,
	-5.177439e+04,
	-4.289378e+04,
	2.031934e+04,
	1.319275e+04,
	8.139572e+04,
	-4.013155e+04,
	1.699864e+04,
	1.387169e+04,
	2.468899e+04,
	-2.814082e+04,
	1.423289e+04,
	1.448002e+04,
	-6.571990e+04,
	-1.805698e+04,
	1.199929e+04,
	1.503010e+04,
	8.726906e+04,
	-2.301298e+04,
	9.974486e+03,
	1.552759e+04,
	-3.911454e+04,
	-9.959665e+03,
	8.366133e+03,
	1.596392e+04,
	2.754859e+04,
	-1.261897e+04,
	7.034917e+03,
	1.636173e+04,
	-2.143616e+04,
	-6.578940e+03,
	5.902874e+03,
	1.671286e+04,
	1.445855e+04,
	-8.060233e+03,
	4.922564e+03,
	1.702911e+04,
	-1.068146e+03,
	-5.007837e+03,
	4.094606e+03,
	1.730495e+04,
	-1.446239e+03,
	-4.042107e+03,
	3.428210e+03,
	1.755026e+04,
	-7.646742e+03,
	-2.833790e+03,
	2.850615e+03,
	1.776680e+04,
	6.036580e+03,
	-3.510960e+03,
	2.317098e+03,
	1.795618e+04,
	-5.012745e+03,
	-1.656924e+03,
	1.885239e+03,
	1.811589e+04,
	-4.810884e+03,
	-1.478773e+03,
	1.519931e+03,
	1.825459e+04,
	-6.234266e+03,
	-1.106439e+03,
	1.165198e+03,
	1.836994e+04,
	-2.823139e+03,
	-1.181941e+03,
	8.197310e+02,
	1.846054e+04,
	-1.258697e+04,
	2.043762e+02,
	5.250146e+02,
	1.852450e+04,
	-5.978057e+03,
	-7.475415e+01,
	2.034009e+02,
	1.856604e+04,
	-8.418277e+10,
	1.154661e+06,
	5.714404e+01,
	4.036256e-03,
	-2.687024e+07,
	-8.592069e+04,
	2.190888e+01,
	4.933202e-03,
	1.021218e+08,
	-5.017017e+04,
	0,
	6.278621e-03,
	-1.255189e+07,
	1.903032e+04,
	0,
	4.484729e-03,
	1.558282e+06,
	2.417039e+03,
	8.957179e+00,
	8.969458e-03,
	-3.914997e+05,
	1.370244e+04,
	1.920907e+01,
	2.287212e-02,
	-6.741212e+05,
	3.455420e+04,
	5.930749e+01,
	8.520985e-02,
	-4.870917e+06,
	1.084084e+05,
	2.009074e+02,
	3.735779e-01,
	-9.230984e+06,
	2.505707e+05,
	7.085224e+02,
	1.758462e+00,
	-2.106645e+07,
	5.356899e+05,
	2.195612e+03,
	7.431645e+00,
	-2.950385e+07,
	8.461586e+05,
	5.821344e+03,
	2.723083e+01,
	-3.782577e+07,
	1.119956e+06,
	1.259572e+04,
	8.251229e+01,
	-3.282215e+07,
	1.127447e+06,
	2.260996e+04,
	2.090373e+02,
	-3.131878e+07,
	1.051472e+06,
	3.440400e+04,
	4.481747e+02,
	-2.053329e+07,
	7.431721e+05,
	4.587941e+04,
	8.398019e+02,
	-1.369182e+07,
	4.785742e+05,
	5.475855e+04,
	1.400337e+03,
	-9.066544e+06,
	2.627224e+05,
	6.030965e+04,
	2.128540e+03,
	-6.437927e+06,
	1.088040e+05,
	6.231489e+04,
	3.004682e+03,
	-2.053492e+06,
	-4.777547e+04,
	6.091525e+04,
	3.993557e+03,
	-1.949825e+06,
	-6.605211e+04,
	5.729296e+04,
	5.045588e+03,
	-9.414086e+05,
	-9.996283e+04,
	5.243186e+04,
	6.132059e+03,
	-1.890967e+05,
	-1.121647e+05,
	4.675167e+04,
	7.214864e+03,
	-3.045963e+05,
	-9.180211e+04,
	4.106393e+04,
	8.265942e+03,
	-5.330101e+04,
	-8.608205e+04,
	3.562988e+04,
	9.272761e+03,
	-3.028050e+04,
	-7.119125e+04,
	3.058189e+04,
	1.021899e+04,
	3.389382e+04,
	-6.002974e+04,
	2.607403e+04,
	1.109889e+04,
	2.504837e+04,
	-4.749684e+04,
	2.215132e+04,
	1.190918e+04,
	3.155848e+04,
	-3.811928e+04,
	1.880026e+04,
	1.265226e+04,
	-7.201400e+04,
	-2.586018e+04,
	1.596321e+04,
	1.333116e+04,
	7.110271e+04,
	-2.854939e+04,
	1.340926e+04,
	1.395078e+04,
	4.710820e+03,
	-1.819806e+04,
	1.127146e+04,
	1.450295e+04,
	-1.716947e+04,
	-1.351549e+04,
	9.553127e+03,
	1.500363e+04,
	1.705228e+04,
	-1.317062e+04,
	8.030335e+03,
	1.545596e+04,
	-7.296253e+03,
	-8.740504e+03,
	6.744056e+03,
	1.585811e+04,
	1.124590e+04,
	-8.382692e+03,
	5.655728e+03,
	1.621866e+04,
	-6.404979e+03,
	-5.276710e+03,
	4.751552e+03,
	1.653766e+04,
	-4.078801e+03,
	-4.618901e+03,
	3.982096e+03,
	1.682316e+04,
	5.784536e+03,
	-4.519947e+03,
	3.287528e+03,
	1.707427e+04,
	-1.229816e+04,
	-2.021194e+03,
	2.721875e+03,
	1.729168e+04,
	1.842108e+03,
	-3.109246e+03,
	2.195199e+03,
	1.748291e+04,
	1.022085e+03,
	-2.237389e+03,
	1.729408e+03,
	1.764076e+04,
	-1.355747e+04,
	-3.814936e+02,
	1.371889e+03,
	1.777199e+04,
	-4.135917e+03,
	-1.405750e+03,
	9.812738e+02,
	1.788158e+04,
	-1.176006e+04,
	-1.122970e+02,
	6.103796e+02,
	1.795760e+04,
	-7.664940e+03,
	-2.255428e+01,
	2.505438e+02,
	1.800524e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.756796e+04,
	3.410796e+02,
	0,
	0,
	-1.318358e+05,
	2.755397e+03,
	1.097018e+00,
	1.345419e-03,
	-5.608807e+05,
	1.562207e+04,
	1.379447e+01,
	2.466601e-02,
	-2.514261e+06,
	6.918882e+04,
	1.071228e+02,
	2.654960e-01,
	-6.065589e+06,
	1.944641e+05,
	5.889450e+02,
	2.019474e+00,
	-1.283506e+07,
	4.191455e+05,
	2.215660e+03,
	1.058396e+01,
	-1.846805e+07,
	6.414717e+05,
	6.149145e+03,
	4.126265e+01,
	-1.742585e+07,
	7.178521e+05,
	1.289995e+04,
	1.231435e+02,
	-1.832815e+07,
	7.396414e+05,
	2.178945e+04,
	2.939924e+02,
	-1.255612e+07,
	5.674151e+05,
	3.137447e+04,
	5.949191e+02,
	-9.863656e+06,
	4.196776e+05,
	3.966016e+04,
	1.048397e+03,
	-6.077376e+06,
	2.402884e+05,
	4.561200e+04,
	1.662630e+03,
	-3.971539e+06,
	1.160875e+05,
	4.864964e+04,
	2.421336e+03,
	-1.807408e+06,
	1.308620e+04,
	4.902579e+04,
	3.296939e+03,
	-1.659778e+06,
	-1.565950e+04,
	4.744301e+04,
	4.252506e+03,
	-6.733442e+05,
	-5.969285e+04,
	4.440953e+04,
	5.259324e+03,
	-2.473511e+05,
	-7.140758e+04,
	4.040044e+04,
	6.277780e+03,
	-2.042537e+05,
	-6.499188e+04,
	3.615217e+04,
	7.282236e+03,
	-1.170966e+05,
	-6.002899e+04,
	3.193951e+04,
	8.257070e+03,
	-2.352214e+04,
	-5.459684e+04,
	2.787370e+04,
	9.187282e+03,
	4.937715e+04,
	-4.785421e+04,
	2.412159e+04,
	1.006206e+04,
	-1.156724e+05,
	-3.191696e+04,
	2.084086e+04,
	1.087739e+04,
	1.297973e+05,
	-3.849662e+04,
	1.781328e+04,
	1.163679e+04,
	-9.774888e+04,
	-1.844295e+04,
	1.526608e+04,
	1.232678e+04,
	5.200490e+04,
	-2.438844e+04,
	1.301188e+04,
	1.296761e+04,
	-8.135849e+03,
	-1.543929e+04,
	1.102631e+04,
	1.354296e+04,
	1.028947e+04,
	-1.379101e+04,
	9.377438e+03,
	1.406704e+04,
	-8.156883e+03,
	-9.874940e+03,
	7.962838e+03,
	1.453982e+04,
	-9.036508e+01,
	-8.750479e+03,
	6.734128e+03,
	1.496712e+04,
	1.570054e+03,
	-7.174620e+03,
	5.655807e+03,
	1.534847e+04,
	-1.278293e+03,
	-5.539760e+03,
	4.740587e+03,
	1.568705e+04,
	-2.566299e+03,
	-4.405104e+03,
	3.959008e+03,
	1.598696e+04,
	-1.910568e+03,
	-3.654087e+03,
	3.277553e+03,
	1.625060e+04,
	-8.951905e+03,
	-2.385243e+03,
	2.683652e+03,
	1.647951e+04,
	-2.863973e+03,
	-2.620958e+03,
	2.123866e+03,
	1.667582e+04,
	-5.366473e+03,
	-1.785690e+03,
	1.617383e+03,
	1.683538e+04,
	-4.998538e+03,
	-1.403221e+03,
	1.171570e+03,
	1.696147e+04,
	-1.930573e+04,
	4.416717e+02,
	7.785677e+02,
	1.705459e+04,
	-9.332163e+03,
	-8.178539e+01,
	3.103724e+02,
	1.711692e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-8.909025e+02,
	3.538429e+01,
	0,
	0,
	-6.422168e+04,
	1.628264e+03,
	2.273205e-01,
	4.484729e-04,
	-1.684485e+05,
	8.745175e+03,
	1.123560e+01,
	3.049616e-02,
	-1.396076e+06,
	4.954183e+04,
	9.457898e+01,
	3.480150e-01,
	-3.153636e+06,
	1.315038e+05,
	5.765050e+02,
	2.867984e+00,
	-5.753237e+06,
	2.566029e+05,
	2.084437e+03,
	1.445742e+01,
	-8.015029e+06,
	3.742078e+05,
	5.388979e+03,
	5.210269e+01,
	-8.074433e+06,
	4.135002e+05,
	1.068476e+04,
	1.446774e+02,
	-6.661386e+06,
	3.790568e+05,
	1.722141e+04,
	3.258434e+02,
	-6.077928e+06,
	3.260624e+05,
	2.393450e+04,
	6.249524e+02,
	-3.712201e+06,
	2.107243e+05,
	2.968932e+04,
	1.061776e+03,
	-2.467015e+06,
	1.292915e+05,
	3.366006e+04,
	1.632819e+03,
	-1.882443e+06,
	7.221017e+04,
	3.588291e+04,
	2.326102e+03,
	-1.086002e+06,
	1.703520e+04,
	3.635384e+04,
	3.120870e+03,
	-4.605255e+05,
	-1.927992e+04,
	3.530604e+04,
	3.984944e+03,
	-4.341743e+05,
	-2.590209e+04,
	3.334915e+04,
	4.887920e+03,
	-1.327876e+05,
	-3.966641e+04,
	3.080680e+04,
	5.809224e+03,
	-1.434539e+05,
	-3.617659e+04,
	2.795994e+04,
	6.723427e+03,
	-3.317195e+04,
	-3.750287e+04,
	2.503988e+04,
	7.617373e+03,
	-7.415801e+04,
	-3.064914e+04,
	2.218438e+04,
	8.475763e+03,
	5.703238e+04,
	-3.265980e+04,
	1.944651e+04,
	9.292128e+03,
	-6.193252e+04,
	-2.057404e+04,
	1.700446e+04,
	1.005564e+04,
	1.215735e+04,
	-2.212679e+04,
	1.477610e+04,
	1.077365e+04,
	1.341243e+04,
	-1.799234e+04,
	1.273145e+04,
	1.143468e+04,
	-3.132178e+04,
	-1.206636e+04,
	1.099078e+04,
	1.204245e+04,
	3.848496e+04,
	-1.481817e+04,
	9.392096e+03,
	1.260173e+04,
	-3.404114e+04,
	-6.555128e+03,
	8.060933e+03,
	1.310445e+04,
	4.790791e+03,
	-8.972117e+03,
	6.866951e+03,
	1.356787e+04,
	2.423192e+03,
	-6.922553e+03,
	5.758467e+03,
	1.397865e+04,
	1.399033e+03,
	-5.445455e+03,
	4.839055e+03,
	1.434333e+04,
	-1.893961e+04,
	-2.804734e+03,
	4.069198e+03,
	1.466700e+04,
	1.877066e+03,
	-4.505274e+03,
	3.305315e+03,
	1.495392e+04,
	-2.115025e+03,
	-3.042529e+03,
	2.614916e+03,
	1.519227e+04,
	-1.104184e+04,
	-1.582042e+03,
	2.053080e+03,
	1.539091e+04,
	-1.188713e+04,
	-1.306613e+03,
	1.508474e+03,
	1.555342e+04,
	-2.215601e+04,
	1.527387e+02,
	9.531955e+02,
	1.567324e+04,
	-9.598320e+03,
	-2.176024e+02,
	3.465646e+02,
	1.574722e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.644955e+03,
	6.448869e+01,
	0,
	0,
	-1.029582e+04,
	6.950336e+02,
	5.752530e-01,
	1.793892e-03,
	-1.273869e+05,
	6.122692e+03,
	8.641528e+00,
	3.498089e-02,
	-4.160031e+05,
	2.380720e+04,
	8.266186e+01,
	4.377096e-01,
	-1.255311e+06,
	6.800200e+04,
	4.206646e+02,
	2.985036e+00,
	-2.081254e+06,
	1.244833e+05,
	1.454439e+03,
	1.399056e+01,
	-2.900617e+06,
	1.789184e+05,
	3.584258e+03,
	4.729999e+01,
	-2.756955e+06,
	1.947111e+05,
	6.897862e+03,
	1.251625e+02,
	-2.672126e+06,
	1.929093e+05,
	1.099130e+04,
	2.723388e+02,
	-2.086269e+06,
	1.602556e+05,
	1.530917e+04,
	5.125534e+02,
	-1.573510e+06,
	1.215890e+05,
	1.919192e+04,
	8.597800e+02,
	-1.355439e+06,
	8.820952e+04,
	2.224744e+04,
	1.318242e+03,
	-5.451509e+05,
	3.738095e+04,
	2.414097e+04,
	1.882051e+03,
	-6.036619e+05,
	2.573667e+04,
	2.497727e+04,
	2.530007e+03,
	-3.048824e+05,
	1.354461e+03,
	2.497001e+04,
	3.250364e+03,
	-2.405107e+05,
	-7.845169e+03,
	2.417257e+04,
	4.017749e+03,
	-7.981406e+04,
	-1.839566e+04,
	2.282880e+04,
	4.812674e+03,
	-5.359818e+04,
	-1.914615e+04,
	2.117668e+04,
	5.613727e+03,
	-9.539372e+04,
	-1.631387e+04,
	1.943298e+04,
	6.409506e+03,
	-4.737571e+03,
	-2.057378e+04,
	1.755731e+04,
	7.189996e+03,
	-1.608912e+04,
	-1.712993e+04,
	1.567655e+04,
	7.938106e+03,
	-2.088100e+03,
	-1.571847e+04,
	1.391656e+04,
	8.650875e+03,
	-3.661972e+04,
	-1.147036e+04,
	1.228681e+04,
	9.323355e+03,
	1.657977e+04,
	-1.377689e+04,
	1.070581e+04,
	9.954345e+03,
	-3.463596e+03,
	-9.698335e+03,
	9.274149e+03,
	1.053254e+04,
	-5.891139e+03,
	-8.043333e+03,
	8.040790e+03,
	1.106587e+04,
	-1.191734e+04,
	-6.450980e+03,
	6.917247e+03,
	1.155414e+04,
	3.491650e+02,
	-6.574146e+03,
	5.858587e+03,
	1.199621e+04,
	-7.578241e+03,
	-4.689544e+03,
	4.907900e+03,
	1.238765e+04,
	-1.092448e+04,
	-3.741680e+03,
	4.055337e+03,
	1.273290e+04,
	4.106714e+03,
	-4.518819e+03,
	3.238118e+03,
	1.303002e+04,
	-2.102369e+04,
	-1.074664e+03,
	2.560131e+03,
	1.327469e+04,
	-1.056000e+04,
	-2.204585e+03,
	1.868347e+03,
	1.347934e+04,
	-2.377808e+04,
	-1.032248e+02,
	1.180047e+03,
	1.362602e+04,
	-1.508705e+04,
	-9.908849e+00,
	4.767186e+02,
	1.371823e+04,
};

double solarDataset720[] = 
{
	2.525918e+14,
	-2.554558e+09,
	-1.370972e+05,
	5.293898e+03,
	-9.815726e+12,
	2.361968e+09,
	0,
	5.292070e+03,
	-2.161284e+10,
	3.681165e+06,
	1.412622e+05,
	5.309215e+03,
	5.368037e+09,
	-9.739389e+06,
	1.367183e+05,
	5.355116e+03,
	1.822593e+09,
	-3.920899e+06,
	1.308458e+05,
	5.439746e+03,
	7.141674e+07,
	-1.791913e+05,
	1.286456e+05,
	5.575115e+03,
	-2.827977e+08,
	6.550345e+05,
	1.286106e+05,
	5.776749e+03,
	-4.278581e+07,
	-3.471843e+05,
	1.274126e+05,
	6.058476e+03,
	-4.678445e+07,
	-3.154022e+05,
	1.243004e+05,
	6.425649e+03,
	-1.705526e+06,
	-5.419689e+05,
	1.199770e+05,
	6.883746e+03,
	-4.511176e+07,
	-2.088734e+05,
	1.148018e+05,
	7.432212e+03,
	-9.899075e+06,
	-5.263774e+05,
	1.080124e+05,
	8.072059e+03,
	-1.136389e+07,
	-4.495800e+05,
	9.941715e+04,
	8.783408e+03,
	-4.432855e+06,
	-4.699310e+05,
	8.991963e+04,
	9.551761e+03,
	-6.678983e+06,
	-3.711487e+05,
	7.987525e+04,
	1.035412e+04,
	-1.048795e+06,
	-3.923684e+05,
	6.943065e+04,
	1.117043e+04,
	-1.487792e+06,
	-3.054383e+05,
	5.919156e+04,
	1.197072e+04,
	-5.138917e+05,
	-2.592954e+05,
	4.970314e+04,
	1.273960e+04,
	4.638959e+05,
	-2.185755e+05,
	4.110096e+04,
	1.345986e+04,
	-3.133674e+05,
	-1.488658e+05,
	3.379813e+04,
	1.412155e+04,
	7.701003e+02,
	-1.222341e+05,
	2.757857e+04,
	1.472633e+04,
	1.443326e+05,
	-9.575337e+04,
	2.226568e+04,
	1.526806e+04,
	1.586498e+05,
	-7.156428e+04,
	1.793449e+04,
	1.574764e+04,
	1.756484e+04,
	-4.896879e+04,
	1.451310e+04,
	1.617102e+04,
	8.828851e+04,
	-3.944113e+04,
	1.175869e+04,
	1.654602e+04,
	-6.323419e+04,
	-2.418904e+04,
	9.565046e+03,
	1.687570e+04,
	9.171615e+04,
	-2.493151e+04,
	7.723482e+03,
	1.716762e+04,
	-1.428085e+04,
	-1.376363e+04,
	6.275414e+03,
	1.741964e+04,
	2.437380e+04,
	-1.256407e+04,
	5.133211e+03,
	1.764318e+04,
	1.709855e+03,
	-8.360511e+03,
	4.206652e+03,
	1.783845e+04,
	-1.602339e+03,
	-6.380326e+03,
	3.464464e+03,
	1.801101e+04,
	1.086892e+04,
	-5.672266e+03,
	2.839413e+03,
	1.816274e+04,
	1.947834e+03,
	-3.743557e+03,
	2.343114e+03,
	1.829498e+04,
	-4.914126e+03,
	-2.541311e+03,
	1.951555e+03,
	1.841212e+04,
	7.500891e+03,
	-2.900219e+03,
	1.606900e+03,
	1.851587e+04,
	-6.683859e+03,
	-1.171479e+03,
	1.335113e+03,
	1.860554e+04,
	2.524698e+03,
	-1.755106e+03,
	1.097230e+03,
	1.868573e+04,
	1.413303e+02,
	-1.123324e+03,
	8.913331e+02,
	1.875383e+04,
	-5.972485e+02,
	-8.258019e+02,
	7.301851e+02,
	1.881276e+04,
	-1.374811e+03,
	-6.044738e+02,
	5.930501e+02,
	1.886362e+04,
	-2.464199e+02,
	-6.001397e+02,
	4.686460e+02,
	1.890681e+04,
	-3.386839e+03,
	-1.749768e+02,
	3.615101e+02,
	1.894210e+04,
	1.115795e+03,
	-5.876697e+02,
	2.497363e+02,
	1.897051e+04,
	-5.909912e+03,
	3.198230e+02,
	1.691543e+02,
	1.898962e+04,
	-1.580136e+03,
	-5.978889e+01,
	6.196234e+01,
	1.900370e+04,
	2.989518e+13,
	-1.289421e+08,
	1.099829e+05,
	2.834177e+03,
	-3.090365e+12,
	6.856653e+08,
	1.321869e+05,
	2.836187e+03,
	9.682967e+10,
	-5.904165e+07,
	1.626712e+05,
	2.856692e+03,
	-5.436058e+09,
	6.318661e+06,
	1.551570e+05,
	2.907038e+03,
	6.591801e+08,
	-1.130499e+06,
	1.565831e+05,
	3.007157e+03,
	-7.138774e+08,
	1.316135e+06,
	1.563922e+05,
	3.171322e+03,
	3.237601e+07,
	-7.953836e+05,
	1.552515e+05,
	3.417128e+03,
	-4.655197e+07,
	-3.938954e+05,
	1.522345e+05,
	3.753533e+03,
	-2.305480e+07,
	-4.616706e+05,
	1.487543e+05,
	4.192527e+03,
	-8.350406e+07,
	-1.385543e+05,
	1.443327e+05,
	4.741292e+03,
	-2.273311e+07,
	-6.254407e+05,
	1.375714e+05,
	5.403999e+03,
	-2.274408e+07,
	-5.692192e+05,
	1.282140e+05,
	6.164358e+03,
	-6.189259e+06,
	-6.624563e+05,
	1.172277e+05,
	7.007832e+03,
	-1.040898e+07,
	-5.161737e+05,
	1.053028e+05,
	7.908995e+03,
	-2.699482e+06,
	-5.346775e+05,
	9.279238e+04,
	8.847287e+03,
	-2.235491e+06,
	-4.383825e+05,
	8.020280e+04,
	9.789863e+03,
	-1.374288e+06,
	-3.645659e+05,
	6.827003e+04,
	1.071465e+04,
	-1.221563e+04,
	-3.098323e+05,
	5.718372e+04,
	1.159997e+04,
	-3.432144e+05,
	-2.317054e+05,
	4.735807e+04,
	1.242805e+04,
	1.796722e+05,
	-1.889060e+05,
	3.883150e+04,
	1.319192e+04,
	5.940359e+04,
	-1.395754e+05,
	3.160908e+04,
	1.388396e+04,
	1.898772e+05,
	-1.085417e+05,
	2.562541e+04,
	1.450571e+04,
	6.259607e+04,
	-7.758476e+04,
	2.076082e+04,
	1.505893e+04,
	9.493680e+03,
	-5.706448e+04,
	1.682657e+04,
	1.555047e+04,
	1.154325e+05,
	-4.666948e+04,
	1.358994e+04,
	1.598475e+04,
	-6.600032e+03,
	-3.033826e+04,
	1.102596e+04,
	1.636513e+04,
	5.150180e+04,
	-2.556832e+04,
	8.962958e+03,
	1.670138e+04,
	-5.043216e+03,
	-1.683693e+04,
	7.309487e+03,
	1.699565e+04,
	4.630010e+04,
	-1.531867e+04,
	5.969269e+03,
	1.725549e+04,
	-3.176222e+04,
	-7.688050e+03,
	4.927359e+03,
	1.748265e+04,
	1.990387e+04,
	-9.109929e+03,
	4.042288e+03,
	1.768595e+04,
	1.136736e+04,
	-6.270534e+03,
	3.303928e+03,
	1.786155e+04,
	-1.921046e+03,
	-4.000413e+03,
	2.750164e+03,
	1.801613e+04,
	-8.295624e+03,
	-2.881436e+03,
	2.295908e+03,
	1.815411e+04,
	1.158890e+04,
	-3.694378e+03,
	1.877598e+03,
	1.827603e+04,
	-7.985865e+03,
	-1.327338e+03,
	1.554511e+03,
	1.838032e+04,
	6.287924e+03,
	-2.268548e+03,
	1.279719e+03,
	1.847378e+04,
	-5.841113e+03,
	-7.169778e+02,
	1.056665e+03,
	1.855324e+04,
	2.331521e+03,
	-1.372167e+03,
	8.596951e+02,
	1.862405e+04,
	-6.715950e+02,
	-7.448262e+02,
	6.904255e+02,
	1.868294e+04,
	-2.277589e+03,
	-4.673925e+02,
	5.571070e+02,
	1.873345e+04,
	-2.143745e+03,
	-4.255135e+02,
	4.286454e+02,
	1.877595e+04,
	-2.342452e+03,
	-3.095573e+02,
	3.018268e+02,
	1.880924e+04,
	-2.141651e+03,
	-1.996398e+02,
	1.826752e+02,
	1.883282e+04,
	-1.800736e+03,
	-5.698464e+01,
	8.207416e+01,
	1.884678e+04,
	1.447401e+13,
	-8.993067e+07,
	7.803754e+04,
	1.013116e+03,
	-8.727215e+11,
	2.292335e+08,
	8.783964e+04,
	1.014508e+03,
	-2.637424e+10,
	1.849076e+07,
	1.050400e+05,
	1.026912e+03,
	2.501031e+09,
	-8.153203e+05,
	1.086648e+05,
	1.062371e+03,
	6.350316e+08,
	1.081054e+06,
	1.106769e+05,
	1.131995e+03,
	-5.067515e+08,
	2.734648e+06,
	1.150568e+05,
	1.250306e+03,
	8.471154e+07,
	7.604123e+05,
	1.198954e+05,
	1.435562e+03,
	-5.169626e+07,
	1.125922e+06,
	1.244427e+05,
	1.702570e+03,
	-1.420182e+08,
	1.257137e+06,
	1.296866e+05,
	2.073373e+03,
	-6.016236e+07,
	4.507910e+05,
	1.331301e+05,
	2.568637e+03,
	-6.181395e+07,
	2.560844e+05,
	1.334031e+05,
	3.194251e+03,
	-2.944661e+07,
	-1.809190e+05,
	1.302883e+05,
	3.952267e+03,
	-1.974673e+07,
	-3.302753e+05,
	1.236749e+05,
	4.825974e+03,
	-1.831211e+07,
	-3.630744e+05,
	1.144628e+05,
	5.793807e+03,
	-1.063314e+05,
	-5.671483e+05,
	1.027316e+05,
	6.825455e+03,
	-7.428135e+06,
	-3.646082e+05,
	9.035604e+04,
	7.875637e+03,
	-4.224498e+05,
	-4.226070e+05,
	7.785079e+04,
	8.928044e+03,
	-5.225200e+05,
	-3.292931e+05,
	6.569603e+04,
	9.939440e+03,
	1.351084e+05,
	-2.692418e+05,
	5.486961e+04,
	1.089545e+04,
	-6.986607e+05,
	-1.900635e+05,
	4.546374e+04,
	1.178319e+04,
	8.151561e+05,
	-1.826275e+05,
	3.717645e+04,
	1.259855e+04,
	-2.097157e+05,
	-1.087743e+05,
	3.039241e+04,
	1.332873e+04,
	8.873651e+04,
	-9.305999e+04,
	2.483143e+04,
	1.399033e+04,
	8.394321e+04,
	-7.004892e+04,
	2.014053e+04,
	1.457831e+04,
	2.568894e+04,
	-5.092930e+04,
	1.634436e+04,
	1.509840e+04,
	1.280322e+05,
	-4.220220e+04,
	1.325641e+04,
	1.555749e+04,
	-3.361001e+04,
	-2.513248e+04,
	1.085224e+04,
	1.596046e+04,
	2.979468e+04,
	-2.253703e+04,
	8.893598e+03,
	1.631985e+04,
	3.723816e+04,
	-1.735501e+04,
	7.267372e+03,
	1.663501e+04,
	-1.726087e+04,
	-1.053326e+04,
	6.006399e+03,
	1.691243e+04,
	1.578262e+04,
	-1.021949e+04,
	4.953342e+03,
	1.715986e+04,
	1.743296e+03,
	-6.992042e+03,
	4.079600e+03,
	1.737627e+04,
	1.170557e+03,
	-5.467831e+03,
	3.375752e+03,
	1.756744e+04,
	7.317985e+03,
	-4.658490e+03,
	2.788852e+03,
	1.773572e+04,
	-2.944508e+03,
	-2.890565e+03,
	2.322051e+03,
	1.788333e+04,
	-1.384627e+03,
	-2.499429e+03,
	1.932715e+03,
	1.801462e+04,
	3.870094e+03,
	-2.380198e+03,
	1.589263e+03,
	1.812959e+04,
	-7.589419e+03,
	-9.387526e+02,
	1.316390e+03,
	1.822906e+04,
	6.765004e+03,
	-2.055863e+03,
	1.059421e+03,
	1.831691e+04,
	-7.908487e+03,
	-1.944332e+02,
	8.634886e+02,
	1.838909e+04,
	2.402999e+03,
	-1.255047e+03,
	6.776365e+02,
	1.845334e+04,
	-3.022120e+03,
	-3.713633e+02,
	5.165854e+02,
	1.850326e+04,
	-2.480041e+03,
	-3.839458e+02,
	3.785083e+02,
	1.854419e+04,
	-7.542281e+03,
	2.431373e+02,
	2.418575e+02,
	1.857417e+04,
	-1.557329e+03,
	-1.160108e+02,
	7.276011e+01,
	1.859310e+04,
	-4.132444e+13,
	4.983149e+08,
	6.380020e+04,
	1.851747e+02,
	1.098450e+12,
	-2.448093e+08,
	4.414219e+04,
	1.862109e+02,
	-3.624187e+10,
	2.421969e+07,
	3.304274e+04,
	1.899028e+02,
	3.813707e+09,
	-2.123873e+06,
	3.724471e+04,
	2.020496e+02,
	-9.762495e+07,
	2.271395e+06,
	3.918961e+04,
	2.259298e+02,
	3.247350e+08,
	1.259102e+06,
	4.364256e+04,
	2.695358e+02,
	-7.726482e+07,
	2.316327e+06,
	4.998989e+04,
	3.423470e+02,
	-1.019017e+08,
	2.228401e+06,
	5.902081e+04,
	4.620756e+02,
	-5.107875e+07,
	1.805353e+06,
	6.940990e+04,
	6.504069e+02,
	-9.891926e+07,
	1.883571e+06,
	8.077203e+04,
	9.326294e+02,
	-6.594961e+07,
	1.309945e+06,
	9.189406e+04,
	1.340972e+03,
	-5.421313e+07,
	8.991718e+05,
	1.004014e+05,
	1.895689e+03,
	-3.766459e+07,
	4.481471e+05,
	1.050914e+05,
	2.607513e+03,
	-2.032421e+07,
	5.007750e+04,
	1.049523e+05,
	3.466517e+03,
	-1.278947e+07,
	-1.455609e+05,
	1.004758e+05,
	4.443536e+03,
	-6.566446e+06,
	-2.703383e+05,
	9.276981e+04,
	5.502737e+03,
	-2.497008e+06,
	-3.170135e+05,
	8.300714e+04,
	6.601359e+03,
	-2.210423e+06,
	-2.754951e+05,
	7.259218e+04,
	7.700522e+03,
	-8.795482e+05,
	-2.564902e+05,
	6.219949e+04,
	8.772571e+03,
	4.875594e+05,
	-2.333622e+05,
	5.229111e+04,
	9.788438e+03,
	-3.924964e+05,
	-1.589745e+05,
	4.367724e+04,
	1.073035e+04,
	2.878946e+05,
	-1.428811e+05,
	3.620966e+04,
	1.160062e+04,
	-8.617935e+04,
	-9.818419e+04,
	2.987112e+04,
	1.238861e+04,
	1.563730e+05,
	-8.375478e+04,
	2.455211e+04,
	1.310190e+04,
	3.157587e+04,
	-5.922817e+04,
	2.015025e+04,
	1.373849e+04,
	1.956095e+04,
	-4.524892e+04,
	1.656404e+04,
	1.430792e+04,
	4.832654e+04,
	-3.595669e+04,
	1.358688e+04,
	1.481455e+04,
	4.014487e+04,
	-2.701491e+04,
	1.116623e+04,
	1.526291e+04,
	-8.957043e+03,
	-1.852113e+04,
	9.237221e+03,
	1.566073e+04,
	1.813805e+04,
	-1.597159e+04,
	7.633708e+03,
	1.601542e+04,
	7.265770e+03,
	-1.171307e+04,
	6.306238e+03,
	1.632830e+04,
	5.845122e+03,
	-9.056395e+03,
	5.229642e+03,
	1.660539e+04,
	1.705465e+03,
	-6.842519e+03,
	4.346327e+03,
	1.685070e+04,
	-3.099670e+03,
	-5.132762e+03,
	3.614027e+03,
	1.706799e+04,
	9.091824e+03,
	-4.904382e+03,
	2.986894e+03,
	1.725985e+04,
	-3.097208e+03,
	-2.861985e+03,
	2.486454e+03,
	1.742725e+04,
	-5.115305e+03,
	-2.254430e+03,
	2.073917e+03,
	1.757629e+04,
	3.305222e+03,
	-2.536090e+03,
	1.690410e+03,
	1.770681e+04,
	8.613358e+02,
	-1.693291e+03,
	1.373974e+03,
	1.781760e+04,
	-5.270481e+03,
	-8.177981e+02,
	1.129554e+03,
	1.791337e+04,
	7.202933e+01,
	-1.244067e+03,
	8.946304e+02,
	1.799642e+04,
	-3.932364e+03,
	-5.617175e+02,
	6.851235e+02,
	1.806340e+04,
	-2.555341e+03,
	-5.981541e+02,
	4.914744e+02,
	1.811718e+04,
	-7.312382e+03,
	8.261489e+01,
	3.128333e+02,
	1.815579e+04,
	-3.444405e+03,
	-5.151392e+01,
	1.189236e+02,
	1.818034e+04,
	8.583418e+11,
	-5.864616e+06,
	5.801889e+03,
	1.923411e+01,
	-6.597669e+10,
	1.477868e+07,
	6.364852e+03,
	1.933677e+01,
	2.967102e+09,
	-1.520837e+06,
	7.049525e+03,
	2.020405e+01,
	1.724924e+09,
	-8.185196e+05,
	7.008149e+03,
	2.245400e+01,
	-3.378314e+08,
	1.650445e+06,
	8.069082e+03,
	2.703836e+01,
	1.552037e+08,
	6.585714e+05,
	1.041940e+04,
	3.695513e+01,
	-3.403201e+07,
	1.345522e+06,
	1.363123e+04,
	5.551902e+01,
	-1.703697e+07,
	1.439665e+06,
	1.903317e+04,
	9.145205e+01,
	-9.003897e+07,
	1.961474e+06,
	2.698744e+04,
	1.586961e+02,
	-6.267348e+07,
	1.801412e+06,
	3.788213e+04,
	2.823781e+02,
	-7.470787e+07,
	1.811829e+06,
	5.060948e+04,
	4.922647e+02,
	-5.781055e+07,
	1.427287e+06,
	6.398865e+04,
	8.261355e+02,
	-4.006817e+07,
	9.697074e+05,
	7.540147e+04,
	1.312352e+03,
	-3.092562e+07,
	6.019593e+05,
	8.322421e+04,
	1.964145e+03,
	-1.617086e+07,
	1.930166e+05,
	8.632748e+04,
	2.776467e+03,
	-7.153255e+06,
	-5.054112e+04,
	8.478684e+04,
	3.717483e+03,
	-8.315402e+06,
	-7.881484e+04,
	8.021572e+04,
	4.749714e+03,
	-1.434409e+06,
	-2.349591e+05,
	7.304797e+04,
	5.840556e+03,
	-1.429239e+06,
	-2.030418e+05,
	6.452381e+04,
	6.933083e+03,
	-6.545407e+05,
	-1.903916e+05,
	5.599103e+04,
	8.003800e+03,
	-3.793090e+04,
	-1.703670e+05,
	4.774203e+04,
	9.026419e+03,
	-9.296898e+04,
	-1.335883e+05,
	4.028177e+04,
	9.983296e+03,
	5.681627e+04,
	-1.098699e+05,
	3.373445e+04,
	1.086875e+04,
	7.934290e+04,
	-8.617558e+04,
	2.809759e+04,
	1.167776e+04,
	-1.118900e+05,
	-6.075673e+04,
	2.336891e+04,
	1.241185e+04,
	2.127956e+05,
	-5.972293e+04,
	1.927296e+04,
	1.307544e+04,
	-1.157300e+04,
	-3.572063e+04,
	1.597792e+04,
	1.366415e+04,
	-1.006642e+04,
	-2.856674e+04,
	1.333737e+04,
	1.419680e+04,
	2.851548e+04,
	-2.432571e+04,
	1.105653e+04,
	1.467415e+04,
	1.366951e+04,
	-1.801951e+04,
	9.163722e+03,
	1.509781e+04,
	2.547955e+03,
	-1.350032e+04,
	7.624751e+03,
	1.547499e+04,
	1.201292e+04,
	-1.116877e+04,
	6.343424e+03,
	1.581086e+04,
	-7.993522e+03,
	-7.540323e+03,
	5.292034e+03,
	1.610860e+04,
	1.389183e+04,
	-7.477679e+03,
	4.396669e+03,
	1.637388e+04,
	-4.384238e+03,
	-4.479632e+03,
	3.669053e+03,
	1.660659e+04,
	-3.138125e+03,
	-3.810639e+03,
	3.067716e+03,
	1.681444e+04,
	2.205661e+03,
	-3.486730e+03,
	2.530998e+03,
	1.699733e+04,
	3.541657e+03,
	-2.789475e+03,
	2.081942e+03,
	1.715588e+04,
	-6.419750e+03,
	-1.349094e+03,
	1.732402e+03,
	1.729391e+04,
	-3.412184e+03,
	-1.520739e+03,
	1.412396e+03,
	1.741589e+04,
	-1.601511e+03,
	-1.397792e+03,
	1.100329e+03,
	1.751816e+04,
	1.155029e+03,
	-1.304754e+03,
	8.286155e+02,
	1.760046e+04,
	-1.103308e+04,
	2.218581e+02,
	6.236810e+02,
	1.766473e+04,
	-2.654581e+03,
	-6.688353e+02,
	3.763136e+02,
	1.771593e+04,
	-3.364310e+03,
	-1.387471e+02,
	1.691463e+02,
	1.774386e+04,
	-3.366371e+12,
	4.551509e+07,
	2.521199e+03,
	1.176103e+00,
	4.269705e+10,
	-9.375992e+06,
	1.089486e+03,
	1.215845e+00,
	-2.678077e+09,
	1.632330e+06,
	6.917876e+02,
	1.285806e+00,
	5.646428e+08,
	-4.307335e+05,
	8.992048e+02,
	1.593390e+00,
	-6.281455e+07,
	4.035231e+05,
	1.038831e+03,
	2.138181e+00,
	3.725795e+07,
	2.678653e+05,
	1.679090e+03,
	3.603652e+00,
	-1.868599e+07,
	6.078925e+05,
	2.794495e+03,
	7.040473e+00,
	-2.585413e+07,
	8.892713e+05,
	5.187431e+03,
	1.587553e+01,
	-6.872034e+07,
	1.419539e+06,
	9.710418e+03,
	3.789527e+01,
	-5.812931e+07,
	1.579306e+06,
	1.744566e+04,
	9.048376e+01,
	-7.327242e+07,
	1.818701e+06,
	2.839538e+04,
	2.005187e+02,
	-6.016819e+07,
	1.612661e+06,
	4.199317e+04,
	4.081326e+02,
	-4.581463e+07,
	1.252723e+06,
	5.561195e+04,
	7.517504e+02,
	-3.153234e+07,
	8.265349e+05,
	6.688402e+04,
	1.259016e+03,
	-1.853079e+07,
	4.259439e+05,
	7.406056e+04,
	1.936723e+03,
	-1.281312e+07,
	1.802667e+05,
	7.674943e+04,
	2.768831e+03,
	-5.976285e+06,
	-3.734133e+04,
	7.529271e+04,
	3.725956e+03,
	-3.885336e+06,
	-1.139315e+05,
	7.068494e+04,
	4.762226e+03,
	-1.400809e+06,
	-1.718468e+05,
	6.415010e+04,
	5.837947e+03,
	-8.976969e+05,
	-1.633241e+05,
	5.674855e+04,
	6.911982e+03,
	-2.378758e+05,
	-1.548497e+05,
	4.928211e+04,
	7.958122e+03,
	-4.067629e+05,
	-1.224513e+05,
	4.221302e+04,
	8.953753e+03,
	3.647054e+05,
	-1.214788e+05,
	3.566013e+04,
	9.887462e+03,
	-3.019450e+05,
	-7.317725e+04,
	3.004861e+04,
	1.074445e+04,
	2.857755e+05,
	-7.965496e+04,
	2.512925e+04,
	1.153600e+04,
	-1.459626e+05,
	-4.460431e+04,
	2.100972e+04,
	1.224792e+04,
	1.068546e+05,
	-4.654852e+04,
	1.751428e+04,
	1.289850e+04,
	1.656740e+04,
	-3.151584e+04,
	1.455586e+04,
	1.347833e+04,
	3.276173e+04,
	-2.545561e+04,
	1.216656e+04,
	1.400043e+04,
	-2.466748e+04,
	-1.712349e+04,
	1.020130e+04,
	1.446904e+04,
	1.127833e+04,
	-1.587340e+04,
	8.510004e+03,
	1.489124e+04,
	1.967525e+04,
	-1.277787e+04,
	7.060958e+03,
	1.526518e+04,
	-5.566324e+03,
	-8.375268e+03,
	5.904955e+03,
	1.559653e+04,
	6.832170e+03,
	-7.582035e+03,
	4.940098e+03,
	1.589320e+04,
	-1.505137e+03,
	-5.380298e+03,
	4.129024e+03,
	1.615572e+04,
	-4.851997e+03,
	-4.146360e+03,
	3.449533e+03,
	1.638915e+04,
	6.220823e+03,
	-4.200678e+03,
	2.847212e+03,
	1.659502e+04,
	-2.257540e+03,
	-2.529572e+03,
	2.356955e+03,
	1.677328e+04,
	-6.506661e+03,
	-1.772864e+03,
	1.953201e+03,
	1.693045e+04,
	1.966362e+03,
	-2.261074e+03,
	1.566694e+03,
	1.706682e+04,
	-2.160232e+03,
	-1.314709e+03,
	1.240209e+03,
	1.717955e+04,
	-6.509197e+03,
	-6.756691e+02,
	9.705296e+02,
	1.727398e+04,
	-3.335667e+03,
	-8.945697e+02,
	6.952550e+02,
	1.735046e+04,
	-1.024257e+04,
	1.096345e+02,
	4.408097e+02,
	1.740488e+04,
	-4.884337e+03,
	-6.995646e+01,
	1.680061e+02,
	1.743947e+04,
	5.051346e+10,
	-3.482968e+05,
	-3.302132e+01,
	1.117732e-02,
	-6.399594e+09,
	1.170259e+06,
	0,
	1.076335e-02,
	2.378197e+07,
	-1.273564e+04,
	2.884079e+00,
	1.655900e-02,
	-4.193101e+07,
	6.299121e+04,
	2.194923e+00,
	1.697297e-02,
	2.186069e+06,
	9.422620e+03,
	3.137534e+01,
	3.311800e-02,
	3.955651e+06,
	1.710432e+04,
	5.844243e+01,
	7.906922e-02,
	-5.048300e+06,
	8.807915e+04,
	1.413038e+02,
	2.281002e-01,
	-5.834264e+06,
	1.808251e+05,
	4.543665e+02,
	9.066052e-01,
	-1.717877e+07,
	4.260059e+05,
	1.359382e+03,
	3.620625e+00,
	-3.208799e+07,
	7.976457e+05,
	3.825320e+03,
	1.376715e+01,
	-4.503408e+07,
	1.172645e+06,
	9.176929e+03,
	4.577239e+01,
	-4.518399e+07,
	1.327171e+06,
	1.816020e+04,
	1.279439e+02,
	-4.202028e+07,
	1.290199e+06,
	2.997675e+04,
	2.998951e+02,
	-3.158344e+07,
	1.021061e+06,
	4.259877e+04,
	6.043667e+02,
	-2.250542e+07,
	7.018793e+05,
	5.343008e+04,
	1.070337e+03,
	-1.237124e+07,
	3.643660e+05,
	6.071096e+04,
	1.705578e+03,
	-9.254795e+06,
	1.838508e+05,
	6.403515e+04,
	2.492654e+03,
	-4.016937e+06,
	-5.014300e+03,
	6.370683e+04,
	3.405094e+03,
	-3.183145e+06,
	-5.838735e+04,
	6.052375e+04,
	4.397082e+03,
	-6.326153e+05,
	-1.310928e+05,
	5.546362e+04,
	5.432589e+03,
	-8.980466e+05,
	-1.100814e+05,
	4.957269e+04,
	6.467941e+03,
	-1.845464e+05,
	-1.171335e+05,
	4.351408e+04,
	7.484261e+03,
	-7.330240e+04,
	-1.000436e+05,
	3.759655e+04,
	8.455153e+03,
	-8.536306e+04,
	-8.124805e+04,
	3.220664e+04,
	9.369683e+03,
	6.271460e+04,
	-7.084973e+04,
	2.735632e+04,
	1.022133e+04,
	-6.549462e+04,
	-5.149641e+04,
	2.313856e+04,
	1.100420e+04,
	1.042378e+05,
	-4.819678e+04,
	1.945257e+04,
	1.172164e+04,
	-6.586040e+03,
	-3.243944e+04,
	1.636407e+04,
	1.236958e+04,
	1.937888e+04,
	-2.723890e+04,
	1.379626e+04,
	1.295960e+04,
	-2.094192e+04,
	-1.965536e+04,
	1.161032e+04,
	1.349253e+04,
	2.879330e+04,
	-1.852871e+04,
	9.713757e+03,
	1.397336e+04,
	1.432240e+04,
	-1.343548e+04,
	8.130835e+03,
	1.440101e+04,
	-1.821063e+04,
	-8.725253e+03,
	6.865050e+03,
	1.478482e+04,
	1.419588e+04,
	-9.358718e+03,
	5.748762e+03,
	1.513083e+04,
	1.055273e+03,
	-6.305478e+03,
	4.805868e+03,
	1.543573e+04,
	-5.662820e+03,
	-4.626779e+03,
	4.041581e+03,
	1.570792e+04,
	3.620958e+02,
	-4.298662e+03,
	3.366303e+03,
	1.595011e+04,
	1.279925e+03,
	-3.472943e+03,
	2.779108e+03,
	1.616176e+04,
	-8.119412e+03,
	-1.999793e+03,
	2.294268e+03,
	1.634600e+04,
	2.703808e+03,
	-2.683207e+03,
	1.844539e+03,
	1.650646e+04,
	-5.608882e+03,
	-1.263187e+03,
	1.464334e+03,
	1.663925e+04,
	-2.539837e+03,
	-1.379024e+03,
	1.128950e+03,
	1.675095e+04,
	-6.360200e+03,
	-6.734980e+02,
	8.228503e+02,
	1.683877e+04,
	-1.233536e+04,
	1.203160e+02,
	5.305324e+02,
	1.690457e+04,
	-5.730992e+03,
	-9.461582e+01,
	1.996954e+02,
	1.694608e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.824802e+05,
	5.662913e+02,
	0,
	0,
	-2.089360e+05,
	7.956041e+02,
	5.856313e-01,
	4.139750e-04,
	2.204465e+05,
	-3.219661e+02,
	1.539320e+00,
	2.483850e-03,
	-2.076559e+05,
	5.716207e+03,
	3.299164e+00,
	6.623600e-03,
	-1.630833e+06,
	3.651570e+04,
	3.131705e+01,
	5.961240e-02,
	-4.750601e+06,
	1.270860e+05,
	2.360423e+02,
	6.023336e-01,
	-1.059805e+07,
	3.175159e+05,
	1.112384e+03,
	3.994031e+00,
	-1.908619e+07,
	5.949891e+05,
	3.700632e+03,
	1.870919e+01,
	-2.366093e+07,
	8.041978e+05,
	9.162593e+03,
	6.578187e+01,
	-2.229039e+07,
	8.434683e+05,
	1.752631e+04,
	1.799168e+02,
	-1.954097e+07,
	7.599747e+05,
	2.748722e+04,
	4.014783e+02,
	-1.339870e+07,
	5.499302e+05,
	3.708410e+04,
	7.652249e+02,
	-1.029819e+07,
	3.727003e+05,
	4.454472e+04,
	1.285347e+03,
	-4.368519e+06,
	1.495000e+05,
	4.891481e+04,
	1.957839e+03,
	-4.419116e+06,
	8.860581e+04,
	5.036253e+04,
	2.752876e+03,
	-1.481145e+06,
	-3.114013e+04,
	4.934483e+04,
	3.647707e+03,
	-1.131953e+06,
	-5.304541e+04,
	4.640097e+04,
	4.594923e+03,
	-4.087520e+05,
	-7.696885e+04,
	4.249037e+04,
	5.566846e+03,
	-4.277536e+05,
	-6.969004e+04,
	3.810892e+04,
	6.533158e+03,
	-3.981790e+04,
	-7.471184e+04,
	3.357954e+04,
	7.475552e+03,
	-5.532513e+04,
	-6.146236e+04,
	2.921408e+04,
	8.372805e+03,
	2.297742e+04,
	-5.372960e+04,
	2.523788e+04,
	9.218872e+03,
	-4.526357e+04,
	-4.095211e+04,
	2.170188e+04,
	1.000775e+04,
	2.858501e+04,
	-3.694172e+04,
	1.854799e+04,
	1.073977e+04,
	-3.310096e+04,
	-2.679609e+04,
	1.578940e+04,
	1.141043e+04,
	8.050741e+04,
	-2.739862e+04,
	1.336283e+04,
	1.202398e+04,
	-6.328003e+04,
	-1.355651e+04,
	1.138577e+04,
	1.257725e+04,
	3.556582e+04,
	-1.753080e+04,
	9.641932e+03,
	1.308660e+04,
	-1.740585e+03,
	-1.121468e+04,
	8.123657e+03,
	1.354004e+04,
	4.908269e+03,
	-9.544626e+03,
	6.882834e+03,
	1.395006e+04,
	-1.374891e+04,
	-6.463029e+03,
	5.824501e+03,
	1.431834e+04,
	1.616534e+04,
	-7.552350e+03,
	4.872531e+03,
	1.464918e+04,
	-1.772732e+04,
	-3.244296e+03,
	4.094072e+03,
	1.493915e+04,
	9.689841e+03,
	-5.153985e+03,
	3.394548e+03,
	1.520003e+04,
	-9.718081e+03,
	-2.277143e+03,
	2.798639e+03,
	1.542337e+04,
	-6.633543e+02,
	-2.845618e+03,
	2.278206e+03,
	1.562014e+04,
	-4.278643e+03,
	-1.892766e+03,
	1.806022e+03,
	1.578510e+04,
	-5.433639e+03,
	-1.433992e+03,
	1.392542e+03,
	1.592207e+04,
	-7.648617e+03,
	-9.150271e+02,
	1.007781e+03,
	1.603088e+04,
	-8.612245e+03,
	-4.992492e+02,
	6.366121e+02,
	1.611080e+04,
	-6.343749e+03,
	-2.056231e+02,
	2.914770e+02,
	1.616025e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-1.135457e+04,
	2.791630e+02,
	0,
	0,
	-7.955274e+04,
	2.985927e+03,
	1.611854e+00,
	3.311800e-03,
	-6.493155e+05,
	2.185150e+04,
	2.430096e+01,
	6.789190e-02,
	-2.078383e+06,
	8.094823e+04,
	2.102422e+02,
	7.973158e-01,
	-6.000804e+06,
	2.164166e+05,
	1.026160e+03,
	5.360976e+00,
	-7.509681e+06,
	3.346173e+05,
	3.348784e+03,
	2.463110e+01,
	-9.709505e+06,
	4.476003e+05,
	7.656050e+03,
	7.966162e+01,
	-9.777442e+06,
	4.686826e+05,
	1.394700e+04,
	2.033979e+02,
	-7.272808e+06,
	3.875450e+05,
	2.106614e+04,
	4.303630e+02,
	-6.067236e+06,
	3.045882e+05,
	2.765451e+04,
	7.835942e+02,
	-3.743681e+06,
	1.836085e+05,
	3.273701e+04,
	1.274002e+03,
	-2.204422e+06,
	9.353882e+04,
	3.571808e+04,
	1.890326e+03,
	-1.657859e+06,
	4.246821e+04,
	3.683928e+04,
	2.612254e+03,
	-8.290594e+05,
	-6.996218e+03,
	3.633556e+04,
	3.416065e+03,
	-4.247261e+05,
	-3.007731e+04,
	3.457926e+04,
	4.269476e+03,
	-4.641352e+05,
	-3.218306e+04,
	3.213056e+04,
	5.146662e+03,
	3.361520e+04,
	-5.076883e+04,
	2.915608e+04,
	6.027337e+03,
	-1.771637e+05,
	-3.534656e+04,
	2.610100e+04,
	6.884571e+03,
	-4.187517e+04,
	-3.789010e+04,
	2.312238e+04,
	7.715656e+03,
	8.157849e+04,
	-3.709787e+04,
	2.020432e+04,
	8.503474e+03,
	-1.077364e+05,
	-2.122007e+04,
	1.767673e+04,
	9.241847e+03,
	3.794355e+04,
	-2.646253e+04,
	1.532351e+04,
	9.938986e+03,
	-2.130421e+03,
	-1.891377e+04,
	1.317205e+04,
	1.057852e+04,
	2.458205e+03,
	-1.585926e+04,
	1.133734e+04,
	1.116822e+04,
	-1.024932e+04,
	-1.227472e+04,
	9.729063e+03,
	1.170859e+04,
	1.302318e+04,
	-1.167431e+04,
	8.296256e+03,
	1.220175e+04,
	-2.645825e+03,
	-8.200160e+03,
	7.072718e+03,
	1.264649e+04,
	-1.946731e+04,
	-5.712138e+03,
	6.033100e+03,
	1.305017e+04,
	1.908928e+04,
	-7.856404e+03,
	5.040421e+03,
	1.341373e+04,
	-1.921842e+04,
	-2.904171e+03,
	4.229674e+03,
	1.372996e+04,
	7.815975e+03,
	-5.041356e+03,
	3.502309e+03,
	1.401481e+04,
	-1.222105e+04,
	-2.090158e+03,
	2.867188e+03,
	1.425719e+04,
	-1.443808e+03,
	-2.926865e+03,
	2.291167e+03,
	1.446851e+04,
	-8.489031e+03,
	-1.591866e+03,
	1.763443e+03,
	1.464092e+04,
	-6.705956e+03,
	-1.467380e+03,
	1.277843e+03,
	1.477936e+04,
	-2.081073e+04,
	4.070825e+02,
	8.281583e+02,
	1.488046e+04,
	-8.711751e+03,
	-1.750566e+02,
	3.099560e+02,
	1.494590e+04,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	-2.563361e+03,
	1.163545e+02,
	0,
	0,
	-4.016111e+04,
	1.858785e+03,
	1.077420e+00,
	3.311800e-03,
	-2.538882e+05,
	1.204296e+04,
	2.087577e+01,
	8.486487e-02,
	-8.568045e+05,
	4.291307e+04,
	1.658171e+02,
	9.066052e-01,
	-1.848280e+06,
	9.915324e+04,
	7.465497e+02,
	5.567136e+00,
	-2.940953e+06,
	1.660291e+05,
	2.247529e+03,
	2.303978e+01,
	-3.370234e+06,
	2.089797e+05,
	5.011666e+03,
	7.097312e+01,
	-3.259946e+06,
	2.186080e+05,
	8.892565e+03,
	1.735888e+02,
	-3.097047e+06,
	2.032584e+05,
	1.336445e+04,
	3.563617e+02,
	-1.821542e+06,
	1.437017e+05,
	1.764923e+04,
	6.394746e+02,
	-1.802035e+06,
	1.171823e+05,
	2.118802e+04,
	1.028337e+03,
	-1.000732e+06,
	6.321832e+04,
	2.372803e+04,
	1.525758e+03,
	-7.690809e+05,
	3.504376e+04,
	2.503483e+04,
	2.115529e+03,
	-3.914894e+05,
	6.298728e+03,
	2.528814e+04,
	2.781267e+03,
	-3.035803e+05,
	-5.220347e+03,
	2.468978e+04,
	3.499590e+03,
	-1.135560e+05,
	-1.761802e+04,
	2.348786e+04,
	4.251977e+03,
	-1.801992e+05,
	-1.570171e+04,
	2.191753e+04,
	5.017650e+03,
	1.706318e+04,
	-2.545515e+04,
	2.006382e+04,
	5.784350e+03,
	-6.797234e+04,
	-1.795386e+04,
	1.815090e+04,
	6.531178e+03,
	-1.793578e+04,
	-1.930896e+04,
	1.628261e+04,
	7.256949e+03,
	-2.326593e+04,
	-1.656161e+04,
	1.443550e+04,
	7.949046e+03,
	2.835627e+04,
	-1.719413e+04,
	1.268036e+04,
	8.602624e+03,
	-3.200616e+04,
	-1.034425e+04,
	1.113968e+04,
	9.211894e+03,
	-1.865985e+04,
	-1.040495e+04,
	9.723009e+03,
	9.784332e+03,
	3.642018e+04,
	-1.251177e+04,
	8.326634e+03,
	1.030995e+04,
	-3.566772e+04,
	-4.462584e+03,
	7.200285e+03,
	1.078360e+04,
	1.006844e+04,
	-8.044621e+03,
	6.164034e+03,
	1.122405e+04,
	-1.216649e+04,
	-4.566143e+03,
	5.198882e+03,
	1.161386e+04,
	2.635189e+03,
	-5.240412e+03,
	4.341674e+03,
	1.196312e+04,
	-9.610371e+03,
	-3.091591e+03,
	3.584704e+03,
	1.226633e+04,
	-5.856573e+03,
	-3.064976e+03,
	2.898065e+03,
	1.253040e+04,
	-1.080053e+04,
	-2.040908e+03,
	2.251652e+03,
	1.275061e+04,
	-1.117498e+04,
	-1.629984e+03,
	1.631049e+03,
	1.292734e+04,
	-1.961133e+04,
	-2.300963e+02,
	1.034000e+03,
	1.305636e+04,
	-1.288515e+04,
	-4.832654e+01,
	4.255474e+02,
	1.313697e+04,
};

double* solarDatasets[] =
{
	solarDataset320,
	solarDataset360,
	solarDataset400,
	solarDataset440,
	solarDataset480,
	solarDataset520,
	solarDataset560,
	solarDataset600,
	solarDataset640,
	solarDataset680,
	solarDataset720
};

double limbDarkeningDataset320[] =
{ 0.087657, 0.767174, 0.658123, -1.02953, 0.703297, -0.186735 };

double limbDarkeningDataset360[] =
{ 0.122953, 1.01278, 0.238687, -1.12208, 1.17087, -0.424947 };

double limbDarkeningDataset400[] =
{ 0.123511, 1.08444, -0.405598, 0.370629, -0.240567, 0.0674778 };

double limbDarkeningDataset440[] =
{ 0.158489, 1.23346, -0.875754, 0.857812, -0.484919, 0.110895 };

double limbDarkeningDataset480[] =
{ 0.198587, 1.30507, -1.25998, 1.49727, -1.04047, 0.299516 };

double limbDarkeningDataset520[] =
{ 0.23695, 1.29927, -1.28034, 1.37760, -0.85054, 0.21706 };

double limbDarkeningDataset560[] =
{ 0.26892, 1.34319, -1.58427, 1.91271, -1.31350, 0.37295 };

double limbDarkeningDataset600[] =
{ 0.299804, 1.36718, -1.80884, 2.29294, -1.60595, 0.454874 };

double limbDarkeningDataset640[] =
{ 0.33551, 1.30791, -1.79382, 2.44646, -1.89082, 0.594769 };

double limbDarkeningDataset680[] =
{ 0.364007, 1.27316, -1.73824, 2.28535, -1.70203, 0.517758 };

double limbDarkeningDataset720[] =
{ 0.389704, 1.2448, -1.69708, 2.14061, -1.51803, 0.440004 };

double * limbDarkeningDatasets[] =
{
	limbDarkeningDataset320,
	limbDarkeningDataset360,
	limbDarkeningDataset400,
	limbDarkeningDataset440,
	limbDarkeningDataset480,
	limbDarkeningDataset520,
	limbDarkeningDataset560,
	limbDarkeningDataset600,
	limbDarkeningDataset640,
	limbDarkeningDataset680,
	limbDarkeningDataset720
};


