/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.RootScanner;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.walkers.J9MemTagIterator;
import com.ibm.j9ddr.vm29.j9.walkers.MemoryCategoryIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITConfigPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.structure.J9JITConfig;
import com.ibm.j9ddr.vm29.structure.J9JavaVM;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClassloader;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaHeap;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntimeMemoryCategory;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaThread;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaVMInitArgs;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJMemoryTagRuntimeMemorySection;
import com.ibm.j9ddr.vm29.view.dtfj.java.corrupt.AddCorruptionToListListener;
import com.ibm.j9ddr.vm29.view.dtfj.java.j9.DTFJMonitorIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class DTFJJavaRuntime
implements JavaRuntime {
    private final DTFJJavaVMInitArgs vminitargs = new DTFJJavaVMInitArgs();
    private List<Object> references;
    private Properties systemProperties;
    private LinkedList<Object> classLoaders = null;
    private List<ImageSection> mergedHeapSections = null;
    private List<Object> compiledMethods = null;

    public boolean equals(Object other) {
        if (!(other instanceof JavaRuntime)) {
            return false;
        }
        try {
            return this.getJavaVM().equals((Object)((JavaRuntime)other).getJavaVM());
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getJavaVM().hashCode();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Iterator getCompiledMethods() {
        if (this.compiledMethods == null) {
            this.compiledMethods = new ArrayList<Object>();
            Iterator classLoaderIterators = this.getJavaClassLoaders();
            while (classLoaderIterators.hasNext()) {
                Object classLoaderObj = classLoaderIterators.next();
                if (classLoaderObj instanceof CorruptData) {
                    this.compiledMethods.add(classLoaderObj);
                    continue;
                }
                Iterator classesIterator = ((JavaClassLoader)classLoaderObj).getDefinedClasses();
                while (classesIterator.hasNext()) {
                    Object classObject = classesIterator.next();
                    if (classObject instanceof CorruptData) {
                        this.compiledMethods.add(classObject);
                        continue;
                    }
                    Iterator methodsIterator = ((JavaClass)classObject).getDeclaredMethods();
                    while (methodsIterator.hasNext()) {
                        Object methodObj = methodsIterator.next();
                        if (methodObj instanceof CorruptData) {
                            this.compiledMethods.add(methodObj);
                        }
                        if (!((JavaMethod)methodObj).getCompiledSections().hasNext()) continue;
                        this.compiledMethods.add(methodObj);
                    }
                }
            }
        }
        return this.compiledMethods.iterator();
    }

    public Iterator getHeapRoots() {
        if (null == this.references) {
            this.scanReferences();
        }
        return this.references.iterator();
    }

    public boolean isJITEnabled() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9JITConfigPointer jitConfig = DTFJContext.getVm().jitConfig();
            return jitConfig.notNull() && jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public Properties getJITProperties() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties = new Properties();
        try {
            J9JITConfigPointer jitConfig = DTFJContext.getVm().jitConfig();
            if (jitConfig.notNull()) {
                if (jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED)) {
                    properties.setProperty("JIT", "enabled");
                } else {
                    properties.setProperty("JIT", "disabled");
                }
                if (jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_AOT_ATTACHED)) {
                    properties.setProperty("AOT", "enabled");
                } else {
                    properties.setProperty("AOT", "disabled");
                }
                if (!jitConfig.fsdEnabled().eq(new UDATA(0L))) {
                    properties.setProperty("FSD", "enabled");
                } else {
                    properties.setProperty("FSD", "disabled");
                }
                if (DTFJContext.getVm().requiredDebugAttributes().allBitsIn(J9JavaVM.J9VM_DEBUG_ATTRIBUTE_CAN_REDEFINE_CLASSES)) {
                    properties.setProperty("HCR", "enabled");
                } else {
                    properties.setProperty("HCR", "disabled");
                }
            } else {
                throw new DataUnavailable("JIT not enabled");
            }
            return properties;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private void scanReferences() {
        this.references = new LinkedList<Object>();
        AddCorruptionToListListener corruptionListener = new AddCorruptionToListListener(this.references);
        EventManager.register(corruptionListener);
        try {
            DTFJRootScanner scanner = new DTFJRootScanner();
            scanner.setScanStackSlots(false);
            scanner.scanAllSlots();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.references.add(cd);
        }
        EventManager.unregister(corruptionListener);
    }

    public Iterator getHeaps() throws UnsupportedOperationException {
        try {
            LinkedList<DTFJJavaHeap> heaps = new LinkedList<DTFJJavaHeap>();
            VoidPointer memorySpace = DTFJContext.getVm().defaultMemorySpace();
            MM_MemorySpacePointer defaultMemorySpace = MM_MemorySpacePointer.cast(memorySpace);
            U8Pointer namePtr = defaultMemorySpace._name();
            String name = "No name";
            if (namePtr != null && !namePtr.isNull()) {
                try {
                    name = namePtr.getCStringAtOffset(0L);
                }
                catch (CorruptDataException e) {
                    name = "<<corrupt heap name>>";
                }
            }
            heaps.add(new DTFJJavaHeap(defaultMemorySpace, name, DTFJContext.getImagePointer(memorySpace.getAddress())));
            return heaps.iterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public Iterator getJavaClassLoaders() {
        GCClassLoaderIterator classLoaderIterator;
        if (this.classLoaders != null) {
            return this.classLoaders.iterator();
        }
        this.classLoaders = new LinkedList();
        try {
            classLoaderIterator = GCClassLoaderIterator.from();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.classLoaders.add(cd);
            return this.classLoaders.iterator();
        }
        AddCorruptionToListListener corruptionListener = new AddCorruptionToListListener(this.classLoaders);
        EventManager.register(corruptionListener);
        try {
            while (!corruptionListener.fatalCorruption() && classLoaderIterator.hasNext()) {
                J9ClassLoaderPointer next = classLoaderIterator.next();
                if (next == null) continue;
                this.classLoaders.add(new DTFJJavaClassloader(next));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.classLoaders.add(cd);
        }
        EventManager.unregister(corruptionListener);
        return this.classLoaders.iterator();
    }

    public ImagePointer getJavaVM() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getImagePointer(DTFJContext.getVm().getAddress());
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        return this.vminitargs;
    }

    public Iterator getMonitors() {
        try {
            return new DTFJMonitorIterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public JavaObject getObjectAtAddress(ImagePointer address) throws com.ibm.dtfj.image.CorruptDataException, IllegalArgumentException, MemoryAccessException, DataUnavailable {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(address.getAddress());
            if (object.anyBitsIn(ObjectModel.getObjectAlignmentInBytes() - 1L)) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject. Address = " + address);
            }
            if (this.validHeapAddress(address)) {
                return new DTFJJavaObject(null, object);
            }
            throw new IllegalArgumentException("Object address " + address + " is not in any heap");
        }
        catch (Throwable t) {
            Class[] whitelist = new Class[]{IllegalArgumentException.class};
            throw J9DDRDTFJUtils.handleAllButMemAccExAndDataUnavailAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    private synchronized void mergeSections() {
        if (this.mergedHeapSections != null) {
            return;
        }
        Iterator heaps = this.getHeaps();
        LinkedList<ImageSection> heapSections = new LinkedList<ImageSection>();
        if (!heaps.hasNext()) {
            return;
        }
        while (heaps.hasNext()) {
            DTFJJavaHeap heap = (DTFJJavaHeap)heaps.next();
            Iterator sections = heap.getSections();
            while (sections.hasNext()) {
                heapSections.add((ImageSection)sections.next());
            }
        }
        Collections.sort(heapSections, new Comparator<ImageSection>(){

            @Override
            public int compare(ImageSection arg0, ImageSection arg1) {
                U64 ptr1;
                U64 ptr0 = new U64(arg0.getBaseAddress().getAddress());
                if (ptr0.lt(ptr1 = new U64(arg1.getBaseAddress().getAddress()))) {
                    return -1;
                }
                if (ptr0.gt(ptr1)) {
                    return 1;
                }
                return 0;
            }
        });
        this.mergedHeapSections = new LinkedList<ImageSection>();
        Iterator itr = heapSections.iterator();
        ImageSection currentSection = (ImageSection)itr.next();
        while (itr.hasNext()) {
            ImageSection nextSection = (ImageSection)itr.next();
            if (currentSection.getBaseAddress().getAddress() + currentSection.getSize() == nextSection.getBaseAddress().getAddress()) {
                currentSection = new J9DDRImageSection(DTFJContext.getProcess(), currentSection.getBaseAddress().getAddress(), currentSection.getSize() + nextSection.getSize(), null);
                continue;
            }
            this.mergedHeapSections.add(currentSection);
            currentSection = nextSection;
        }
        this.mergedHeapSections.add(currentSection);
    }

    private boolean validHeapAddress(ImagePointer address) {
        if (this.mergedHeapSections == null) {
            this.mergeSections();
        }
        U64 addr = new U64(address.getAddress());
        for (ImageSection i : this.mergedHeapSections) {
            U64 baseAddress = new U64(i.getBaseAddress().getAddress());
            if (baseAddress.gt(addr)) {
                return false;
            }
            U64 endAddress = new U64(i.getBaseAddress().getAddress() + i.getSize());
            if (!endAddress.gt(addr)) continue;
            return true;
        }
        return false;
    }

    public DTFJJavaHeap getHeapFromAddress(ImagePointer address) {
        try {
            VoidPointer pointer = VoidPointer.cast(address.getAddress());
            Iterator heapsIterator = this.getHeaps();
            while (heapsIterator.hasNext()) {
                DTFJJavaHeap heap = (DTFJJavaHeap)heapsIterator.next();
                Iterator sectionsIterator = heap.getSections();
                while (sectionsIterator.hasNext()) {
                    ImageSection section = (ImageSection)sectionsIterator.next();
                    VoidPointer base = VoidPointer.cast(section.getBaseAddress().getAddress());
                    VoidPointer top = base.addOffset(section.getSize());
                    if (!pointer.gte(base) || !pointer.lt(top)) continue;
                    return heap;
                }
            }
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return null;
    }

    public Iterator getThreads() {
        GCVMThreadListIterator threadIterator;
        try {
            threadIterator = GCVMThreadListIterator.from();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
        LinkedList<Object> toIterate = new LinkedList<Object>();
        AddCorruptionToListListener listener = new AddCorruptionToListListener(toIterate);
        EventManager.register(listener);
        try {
            while (threadIterator.hasNext() && !listener.fatalCorruption()) {
                J9VMThreadPointer next = threadIterator.next();
                if (next == null) continue;
                toIterate.add(new DTFJJavaThread(next));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            toIterate.add(cd);
        }
        EventManager.unregister(listener);
        return toIterate.iterator();
    }

    public Object getTraceBuffer(String arg0, boolean arg1) throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRCorruptData(DTFJContext.getProcess(), "Trace buffers are not available");
    }

    public String getFullVersion() throws com.ibm.dtfj.image.CorruptDataException {
        return this.getVersion();
    }

    public String getVersion() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getVm().j9ras().serviceLevel().getCStringAtOffset(0L);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private String getRequiredSystemProperty(String name) throws com.ibm.dtfj.image.CorruptDataException {
        String value = null;
        SystemPropertiesEventListener listener = new SystemPropertiesEventListener();
        EventManager.register(listener);
        try {
            value = this.getSystemProperties().getProperty(name);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        finally {
            EventManager.unregister(listener);
        }
        if (value != null) {
            return value;
        }
        if (listener.corruption) {
            throw new DTFJCorruptDataException(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), listener.exception));
        }
        throw new DTFJCorruptDataException(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find required system property " + name));
    }

    private Properties getSystemProperties() throws CorruptDataException {
        if (this.systemProperties == null) {
            this.systemProperties = J9JavaVMHelper.getSystemProperties(DTFJContext.getVm());
        }
        return this.systemProperties;
    }

    private String getServiceLevel() {
        try {
            U8Pointer serviceLevelPointer = DataType.getJ9RASPointer().serviceLevel();
            String serviceLevel = serviceLevelPointer.getCStringAtOffset(0L);
            if (serviceLevel != null && serviceLevel.length() > 0) {
                return serviceLevel;
            }
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return "unknown";
    }

    public String toString() {
        return "Java Runtime 0x" + Long.toHexString(DTFJContext.getVm().getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<?> getMemoryCategories() throws DataUnavailable {
        final LinkedList<DTFJJavaRuntimeMemoryCategory> returnList = new LinkedList<DTFJJavaRuntimeMemoryCategory>();
        IEventListener eventListener = new IEventListener(){

            @Override
            public void corruptData(String message2, CorruptDataException e, boolean fatal) {
                returnList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
            }
        };
        EventManager.register(eventListener);
        try {
            Iterator<? extends OMRMemCategoryPointer> rootCategories = MemoryCategoryIterator.iterateCategoryRootSet(DTFJContext.getVm().portLibrary());
            while (rootCategories.hasNext()) {
                returnList.add(new DTFJJavaRuntimeMemoryCategory(this, rootCategories.next()));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            returnList.add((DTFJJavaRuntimeMemoryCategory)cd);
        }
        finally {
            EventManager.unregister(eventListener);
        }
        return Collections.unmodifiableList(returnList).iterator();
    }

    public Iterator<?> getMemorySections(boolean includeFreed) throws DataUnavailable {
        if (includeFreed) {
            return IteratorHelpers.combineIterators(new MemTagMemorySectionIterator(J9MemTagIterator.iterateAllocatedHeaders()), new MemTagMemorySectionIterator(J9MemTagIterator.iterateFreedHeaders()), DTFJJavaRuntime.getNonMallocMemorySections());
        }
        return IteratorHelpers.combineIterators(new MemTagMemorySectionIterator(J9MemTagIterator.iterateAllocatedHeaders()), DTFJJavaRuntime.getNonMallocMemorySections());
    }

    private static Iterator<Object> getNonMallocMemorySections() {
        LinkedList list = new LinkedList();
        return list.iterator();
    }

    public JavaObject getNestedPackedObject(JavaClass jc, ImagePointer packedDataAddress) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public JavaObject getNestedPackedArrayObject(JavaClass jc, ImagePointer i, int arrayLength) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public long getStartTime() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getVm().j9ras().startTimeMillis().longValue();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public long getStartTimeNanos() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getVm().j9ras().startTimeNanos().longValue();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public class DTFJRootScanner
    extends RootScanner {
        DTFJRootScanner() throws CorruptDataException {
        }

        private int getReachabilityCode() {
            switch (this.getReachability()) {
                case STRONG: {
                    return 1;
                }
                case WEAK: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown reachability: " + this.getReachability() + " found");
        }

        @Override
        protected void doClassLoader(J9ClassLoaderPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClassloader(slot).getObject(), "ClassLoader", 0, 10, this.getReachabilityCode()));
                }
                catch (com.ibm.dtfj.image.CorruptDataException e) {
                    DTFJJavaRuntime.this.references.add(e.getCorruptData());
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doClassSlot(J9ClassPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(slot), "Class", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doFinalizableObject(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "FinalizableObject", 0, 8, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doJNIGlobalReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JNIGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doJNIWeakGlobalReference(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JNIWeakGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doJVMTIObjectTagSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JVMTIObjectTagTable", 0, 0, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doMonitorReference(J9ObjectMonitorPointer slot) {
            if (slot.notNull()) {
                try {
                    J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(slot.monitor());
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(monitor.userData())), "MonitorReference", 0, 3, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doPhantomReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "PhantomReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doRememberedSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "RememberedSlot", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doSoftReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "SoftReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doStringTableSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "StringTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doStringCacheTableSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "StringCacheTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doUnfinalizedObject(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "UnfinalizedObject", 0, 9, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMClassSlot(J9ClassPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(slot), "VMClassSlot", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMThreadJNISlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMThreadMonitorRecordSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doNonCollectableObjectSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Reference from an immortal/scoped region", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doMemorySpaceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "MemorySpace reference to Java MemoryArea object", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMThreadSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doWeakReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "WeakReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doClass(J9ClassPointer clazz) {
            this.doClassSlot(clazz);
        }

        @Override
        protected void doStackSlot(J9ObjectPointer slot) {
        }

        @Override
        protected void doOwnableSynchronizerObject(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "OwnableSynchronizerObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doMonitorLookupCacheSlot(J9ObjectMonitorPointer slot) {
            if (slot.notNull()) {
                try {
                    J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(slot.monitor());
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(monitor.userData())), "MonitorReference", 0, 3, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }
    }

    private class SystemPropertiesEventListener
    implements IEventListener {
        protected boolean corruption = false;
        protected CorruptDataException exception;

        private SystemPropertiesEventListener() {
        }

        @Override
        public void corruptData(String message2, CorruptDataException e, boolean fatal) {
            this.corruption = true;
            this.exception = e;
        }
    }

    private class MemTagMemorySectionIterator
    implements Iterator<Object> {
        private final J9MemTagIterator memTagIt;
        private final List<Object> buffer = new ArrayList<Object>(2);
        private final IEventListener eventListener = new IEventListener(){

            @Override
            public void corruptData(String message2, CorruptDataException e, boolean fatal) {
                MemTagMemorySectionIterator.this.buffer.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
            }
        };

        MemTagMemorySectionIterator(J9MemTagIterator it) {
            this.memTagIt = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.buffer.size() > 0) {
                return true;
            }
            EventManager.register(this.eventListener);
            try {
                if (this.memTagIt.hasNext()) {
                    this.buffer.add(new DTFJMemoryTagRuntimeMemorySection(DTFJJavaRuntime.this, this.memTagIt.next()));
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                this.buffer.add(cd);
                boolean bl = true;
                return bl;
            }
            finally {
                EventManager.unregister(this.eventListener);
            }
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return this.buffer.remove(0);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

