/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import java.io.PrintStream;
import java.util.ArrayList;

public class Table {
    int numColumns = -1;
    String title = null;
    ArrayList<String[]> rows = new ArrayList();

    public Table(String title) {
        this.title = title;
    }

    public Table row(String ... row) {
        if (-1 == this.numColumns) {
            this.numColumns = row.length;
        } else if (row.length != this.numColumns) {
            throw new IllegalArgumentException("Invalid row, expected " + this.numColumns + " elements but got " + row.length);
        }
        this.rows.add(row);
        return this;
    }

    private int[] computeColumnWidths() {
        int[] widths = new int[this.numColumns];
        for (String[] row : this.rows) {
            int column = 0;
            for (String val : row) {
                if (val.length() > widths[column]) {
                    widths[column] = val.length();
                }
                ++column;
            }
        }
        return widths;
    }

    public void render(PrintStream out) {
        int[] widths = this.computeColumnWidths();
        this.title.length();
        int rowIndex = 0;
        String colSpace = "  ";
        out.println();
        out.println(this.title);
        for (int i = 0; i < this.title.length(); ++i) {
            out.append("=");
        }
        out.println();
        for (String[] row : this.rows) {
            int columnIndex = 0;
            for (String value : row) {
                int width = widths[columnIndex];
                String format = "%-" + width + "s";
                out.append(String.format(format, value));
                out.append(colSpace);
                ++columnIndex;
            }
            out.append("\n");
            if (rowIndex == 0) {
                for (int i = 0; i < this.numColumns; ++i) {
                    int width = widths[i];
                    for (int j = 0; j < width; ++j) {
                        out.append("-");
                    }
                    out.append(colSpace);
                }
                out.append("\n");
            }
            ++rowIndex;
        }
    }

    public static void main(String[] args) {
        new Table("Test").row("col1", "col2", "col3").row("value-1", "value-2", "value-3").row("a longer value", "short", "value-3").render(System.out);
    }
}

