/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.PointerGenerator;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StructureStubGenerator {
    final Map<String, String> opts = new HashMap<String, String>();
    StructureReader structureReader;
    File outputDir;

    public StructureStubGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-s", null);
        this.opts.put("-l", "false");
    }

    public static void main(String[] args) throws Exception {
        StructureStubGenerator app = new StructureStubGenerator();
        app.parseArgs(args);
        app.generateClasses();
        System.out.println("Processing complete");
    }

    private void generateClasses() {
        String supersetDirectoryName = this.opts.get("-f");
        String supersetFileName = this.opts.get("-s");
        try {
            J9DDRStructureStore store = new J9DDRStructureStore(supersetDirectoryName, supersetFileName);
            System.out.println("superset directory name : " + supersetDirectoryName);
            System.out.println("superset file name : " + store.getSuperSetFileName());
            InputStream inputStream = store.getSuperset();
            this.structureReader = new StructureReader(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + supersetDirectoryName + "/" + supersetFileName);
            return;
        }
        this.outputDir = this.getOutputDir();
        for (StructureReader.StructureDescriptor structure : this.structureReader.getStructures()) {
            String error;
            try {
                if (FlagStructureList.isFlagsStructure(structure.getName())) continue;
                this.generateClass(structure);
            }
            catch (FileNotFoundException e) {
                error = String.format("File Not Found processing: %s: %s", structure.getName(), e.getMessage());
                System.out.println(error);
            }
            catch (IOException e) {
                error = String.format("IOException processing: %s: %s", structure.getName(), e.getMessage());
                System.out.println(error);
            }
        }
    }

    private void generateClass(StructureReader.StructureDescriptor structure) throws IOException {
        File javaFile = new File(this.outputDir, structure.getName() + ".java");
        byte[] original = null;
        int length = 0;
        if (javaFile.exists()) {
            length = (int)javaFile.length();
            original = new byte[length];
            FileInputStream fis = new FileInputStream(javaFile);
            fis.read(original);
            fis.close();
        }
        ByteArrayOutputStream newContents = new ByteArrayOutputStream(length);
        PrintWriter writer = new PrintWriter(newContents);
        StructureStubGenerator.writeCopyright(writer);
        writer.format("package %s;%n", this.opts.get("-p"));
        writer.println();
        StructureStubGenerator.writeClassComment(writer, structure.getName());
        writer.format("public final class %s {%n", structure.getName());
        writer.println();
        StructureStubGenerator.writeConstants(writer, structure);
        writer.println();
        this.writeOffsetStubs(writer, structure);
        writer.println();
        this.writeStaticInitializer(writer, structure);
        writer.println("}");
        writer.close();
        byte[] newContentsBytes = newContents.toByteArray();
        if (null == original || !Arrays.equals(original, newContentsBytes)) {
            FileOutputStream fos = new FileOutputStream(javaFile);
            fos.write(newContentsBytes);
            fos.close();
        }
    }

    private static void writeConstants(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.println("\t// VM Constants");
        writer.println();
        writer.format("\tpublic static final long %s;%n", "SIZEOF");
        Collections.sort(structure.getConstants());
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\tpublic static final long %s;%n", constant.getName());
        }
    }

    private static void writeConstantInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.format("\t\t%s = 0;%n", "SIZEOF");
        Collections.sort(structure.getConstants());
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\t\t%s = 0;%n", constant.getName());
        }
    }

    private void writeStaticInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.println("\t// Static Initializer");
        writer.println();
        writer.println("\tprivate static final boolean RUNTIME = false;");
        writer.println();
        writer.println("\tstatic {");
        writer.println("\t\tif (!RUNTIME) {");
        writer.println("\t\t\tthrow new IllegalArgumentException(\"This stub class should not be on your classpath\");");
        writer.println("\t\t}");
        writer.println();
        StructureStubGenerator.writeConstantInitializer(writer, structure);
        this.writeOffsetInitializer(writer, structure);
        writer.println("\t}");
        writer.println();
    }

    private static void writeClassComment(PrintWriter writer, String name) {
        writer.println("/**");
        writer.format(" * Structure: %s%n", name);
        writer.println(" *");
        writer.println(" * This stub class represents a class that can return in memory offsets");
        writer.println(" * to VM C and C++ structures.");
        writer.println(" *");
        writer.println(" * This particular implementation exists only to allow StructurePointer code to");
        writer.println(" * compile at development time.  This is never loaded at run time.");
        writer.println(" *");
        writer.println(" * At runtime generated byte codes returning actual offset values from the core file");
        writer.println(" * will be loaded by the StructureClassLoader.");
        writer.println(" */");
    }

    private String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        if (this.opts.get("-l").equals("true")) {
            return PointerGenerator.getOffsetConstant(fieldName);
        }
        return fieldName;
    }

    private void writeOffsetStubs(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        ArrayList<StructureReader.FieldDescriptor> fields = structure.getFields();
        if (fields.isEmpty()) {
            return;
        }
        writer.println("\t// Offsets");
        writer.println();
        Collections.sort(fields);
        for (StructureReader.FieldDescriptor fieldDescriptor : fields) {
            if (!this.getOffsetConstant(fieldDescriptor).equals(fieldDescriptor.getName()) || PointerGenerator.omitFieldImplementation(structure, fieldDescriptor)) continue;
            StructureStubGenerator.writeOffsetStub(writer, fieldDescriptor, structure.getName(), "Offset");
        }
    }

    private static void writeOffsetStub(PrintWriter writer, StructureReader.FieldDescriptor fieldDescriptor, String className, String postFix) {
        String getter = fieldDescriptor.getName();
        CTypeParser parser = new CTypeParser(fieldDescriptor.getType());
        if (parser.getSuffix().contains(":")) {
            writer.format("\tpublic static final int _%s_s_;%n", getter);
            writer.format("\tpublic static final int _%s_b_;%n", getter);
        } else {
            writer.format("\tpublic static final int _%s%s_;%n", getter, postFix);
        }
    }

    private void writeOffsetInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        Collections.sort(structure.getFields());
        for (StructureReader.FieldDescriptor fieldDescriptor : structure.getFields()) {
            String fieldName = fieldDescriptor.getName();
            if (!this.getOffsetConstant(fieldDescriptor).equals(fieldName) || PointerGenerator.omitFieldImplementation(structure, fieldDescriptor)) continue;
            CTypeParser parser = new CTypeParser(fieldDescriptor.getType());
            if (parser.getSuffix().contains(":")) {
                String bitfieldName = fieldName;
                writer.format("\t\t_%s_s_ = 0;%n", bitfieldName);
                writer.format("\t\t_%s_b_ = 0;%n", bitfieldName);
                continue;
            }
            writer.format("\t\t_%sOffset_ = 0;%n", fieldName);
        }
    }

    private void parseArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < args.length; i += 2) {
            if (this.opts.containsKey(args[i])) {
                this.opts.put(args[i], args[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + args[i]);
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        for (String key : this.opts.keySet()) {
            String value = this.opts.get(key);
            if (value != null || key.equals("-s")) continue;
            System.err.println("The option " + key + " has not been set.\n");
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava PointerGenerator -p <package name> -o <output path> -f <path to structure file> [-s <superset file name> -l <legacy mode>]\n");
        System.out.println("<package name>           : the package name for all the generated classes e.g. com.ibm.dtfj.j9.structures");
        System.out.println("<relative output path>   : where to write out the class files.  Full path to base of package hierarchy e.g. c:\\src\\");
        System.out.println("<path to structure file> : full path to the J9 structure file");
        System.out.println("<superset file name>     : optional file name of the superset to be used for input / output");
        System.out.println("<legacy mode>            : optional flag set to true or false indicating if legacy DDR is used");
    }

    private File getOutputDir() {
        Object outputPath = this.opts.get("-o").replace('\\', '/');
        if (!((String)outputPath).endsWith("/")) {
            outputPath = (String)outputPath + "/";
        }
        outputPath = (String)outputPath + this.opts.get("-p").replace('.', '/');
        System.out.println("Writing generated classes to " + (String)outputPath);
        File output = new File((String)outputPath);
        output.mkdirs();
        return output;
    }

    private static void writeCopyright(PrintWriter writer) {
        int year = Calendar.getInstance().get(1);
        writer.println("/*******************************************************************************");
        writer.println(" * Copyright (c) 1991, " + year + " IBM Corp. and others");
        writer.println(" *");
        writer.println(" * This program and the accompanying materials are made available under");
        writer.println(" * the terms of the Eclipse Public License 2.0 which accompanies this");
        writer.println(" * distribution and is available at https://www.eclipse.org/legal/epl-2.0/");
        writer.println(" * or the Apache License, Version 2.0 which accompanies this distribution");
        writer.println(" * and is available at https://www.apache.org/licenses/LICENSE-2.0.");
        writer.println(" *");
        writer.println(" * This Source Code may also be made available under the following");
        writer.println(" * Secondary Licenses when the conditions for such availability set");
        writer.println(" * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU");
        writer.println(" * General Public License, version 2 with the GNU Classpath");
        writer.println(" * Exception [1] and GNU General Public License, version 2 with the");
        writer.println(" * OpenJDK Assembly Exception [2].");
        writer.println(" *");
        writer.println(" * [1] https://www.gnu.org/software/classpath/license.html");
        writer.println(" * [2] http://openjdk.java.net/legal/assembly-exception.html");
        writer.println(" *");
        writer.println(" * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception");
        writer.println(" *******************************************************************************/");
    }
}

