/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.corereaders.memory.DetailedDumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.minidump.Stream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MemoryInfoStream
extends Stream {
    private static final int STATE_MEM_COMMIT = 4096;
    private static final int STATE_MEM_FREE = 65536;
    private static final int STATE_MEM_RESERVE = 8192;
    private static final int TYPE_MEM_IMAGE = 0x1000000;
    private static final int TYPE_MEM_MAPPED = 262144;
    private static final int TYPE_MEM_PRIVATE = 131072;
    private static final int PROTECT_PAGE_NOACCESS = 1;
    private static final int PROTECT_PAGE_READONLY = 2;
    private static final int PROTECT_PAGE_READWRITE = 4;
    private static final int PROTECT_PAGE_WRITECOPY = 8;
    private static final int PROTECT_PAGE_EXECUTE = 16;
    private static final int PROTECT_PAGE_EXECUTE_READ = 32;
    private static final int PROTECT_PAGE_EXECUTE_READWRITE = 64;
    private static final int PROTECT_PAGE_EXECUTE_WRITECOPY = 128;
    private static final int PROTECT_PAGE_GUARD = 256;
    private static final int PROTECT_PAGE_NOCACHE = 512;
    private static final int PROTECT_PAGE_WRITECOMBINE = 1024;
    private final String TRUE = Boolean.TRUE.toString();
    private final String FALSE = Boolean.FALSE.toString();

    protected MemoryInfoStream(int dataSize, long location) {
        super(dataSize, location);
    }

    public void readFrom(MiniDumpReader dump, boolean is64Bit, Collection<? extends IMemorySource> ranges) throws IOException {
        dump.seek(this.getLocation());
        int sizeOfHeader = 0;
        int sizeOfEntry = 0;
        long numberOfEntries = 0L;
        HashMap<Long, Properties> memoryInfo = new HashMap<Long, Properties>();
        sizeOfHeader = dump.readInt();
        sizeOfEntry = dump.readInt();
        numberOfEntries = dump.readLong();
        dump.seek(this.getLocation() + (long)sizeOfHeader);
        int i = 0;
        while ((long)i < numberOfEntries) {
            Properties props = new Properties();
            long baseAddress = dump.readLong();
            long allocationBase = dump.readLong();
            int allocationProtect = dump.readInt();
            dump.readInt();
            long regionSize = dump.readLong();
            int state = dump.readInt();
            int protect = dump.readInt();
            int type = dump.readInt();
            dump.readInt();
            props.put("state", this.decodeStateFlags(state));
            props.put("state_flags", String.format("0x%X", state));
            props.put("size", String.format(is64Bit ? "0x%016X" : "0x%08X", regionSize));
            if (state != 65536) {
                props.put("allocationBase", String.format(is64Bit ? "0x%016X" : "0x%08X", allocationBase));
                props.put("allocationProtect", this.decodeProtectFlags(allocationProtect));
                props.put("allocationProtect_flags", String.format("0x%X", allocationProtect));
                props.put("protect", this.decodeProtectFlags(protect));
                this.setReadWriteExecProperties(protect, props);
                props.put("protect_flags", String.format("0x%X", protect));
                props.put("type", this.decodeTypeFlags(type));
                props.put("type_flags", String.format("0x%X", allocationProtect));
            } else {
                props.setProperty("readable", this.FALSE);
                props.setProperty("writable", this.FALSE);
                props.setProperty("executable", this.FALSE);
            }
            memoryInfo.put(new Long(baseAddress), props);
            ++i;
        }
        Iterator<? extends IMemorySource> memoryIterator = ranges.iterator();
        ArrayList<IMemorySource> newRanges = new ArrayList<IMemorySource>(memoryInfo.size());
        while (memoryIterator.hasNext()) {
            IMemorySource m = memoryIterator.next();
            Properties p = (Properties)memoryInfo.remove(m.getBaseAddress());
            if (p != null && m instanceof DumpMemorySource) {
                DetailedDumpMemorySource newSource = new DetailedDumpMemorySource((DumpMemorySource)m, p);
                newSource.getProperties().putAll((Map<?, ?>)p);
                newRanges.add(newSource);
                continue;
            }
            newRanges.add(m);
        }
        for (Map.Entry e : memoryInfo.entrySet()) {
            long size = Long.parseLong(((String)((Properties)e.getValue()).get("size")).substring(2), 16);
            String explanation = "Windows MINIDUMP_MEMORY_INFO entry included but data not included in dump";
            if ("MEM_FREE".equals(((Properties)e.getValue()).get("state"))) {
                explanation = "Free memory, unallocated";
            }
            UnbackedMemorySource m = new UnbackedMemorySource((Long)e.getKey(), size, explanation);
            m.getProperties().putAll((Map<?, ?>)((Map)e.getValue()));
            newRanges.add(m);
        }
        Collections.sort(newRanges, new Comparator<IMemorySource>(){

            @Override
            public int compare(IMemorySource o1, IMemorySource o2) {
                if (o1.getBaseAddress() > o2.getBaseAddress()) {
                    return 1;
                }
                if (o1.getBaseAddress() < o2.getBaseAddress()) {
                    return -1;
                }
                return 0;
            }
        });
        dump.setMemorySources(newRanges);
    }

    private void setReadWriteExecProperties(int protect, Properties props) {
        if ((protect & 1) != 0) {
            props.setProperty("readable", this.FALSE);
            props.setProperty("writable", this.FALSE);
            props.setProperty("executable", this.FALSE);
        } else if ((protect & 2) != 0) {
            props.setProperty("readable", this.TRUE);
            props.setProperty("writable", this.FALSE);
            props.setProperty("executable", this.FALSE);
        } else if ((protect & 4) != 0) {
            props.setProperty("readable", this.TRUE);
            props.setProperty("writable", this.TRUE);
            props.setProperty("executable", this.FALSE);
        } else if ((protect & 8) != 0) {
            props.setProperty("readable", this.TRUE);
            props.setProperty("writable", this.TRUE);
            props.setProperty("executable", this.FALSE);
        } else if ((protect & 0x10) != 0) {
            props.setProperty("readable", this.FALSE);
            props.setProperty("writable", this.FALSE);
            props.setProperty("executable", this.TRUE);
        } else if ((protect & 0x20) != 0) {
            props.setProperty("readable", this.TRUE);
            props.setProperty("writable", this.FALSE);
            props.setProperty("executable", this.TRUE);
        } else if ((protect & 0x40) != 0) {
            props.setProperty("readable", this.TRUE);
            props.setProperty("writable", this.TRUE);
            props.setProperty("executable", this.TRUE);
        } else if ((protect & 0x80) != 0) {
            props.setProperty("readable", this.TRUE);
            props.setProperty("writable", this.TRUE);
            props.setProperty("executable", this.TRUE);
        }
    }

    private String decodeProtectFlags(int protect) {
        Object flagString = "";
        if ((protect & 1) != 0) {
            flagString = (String)flagString + "PAGE_NOACCESS|";
        }
        if ((protect & 2) != 0) {
            flagString = (String)flagString + "PAGE_READONLY|";
        }
        if ((protect & 4) != 0) {
            flagString = (String)flagString + "PAGE_READWRITE|";
        }
        if ((protect & 8) != 0) {
            flagString = (String)flagString + "PAGE_WRITECOPY|";
        }
        if ((protect & 0x10) != 0) {
            flagString = (String)flagString + "PAGE_EXECUTE|";
        }
        if ((protect & 0x20) != 0) {
            flagString = (String)flagString + "PAGE_EXECUTE_READ|";
        }
        if ((protect & 0x40) != 0) {
            flagString = (String)flagString + "PAGE_EXECUTE_READWRITE|";
        }
        if ((protect & 0x80) != 0) {
            flagString = (String)flagString + "PAGE_EXECUTE_WRITECOPY|";
        }
        if ((protect & 0x100) != 0) {
            flagString = (String)flagString + "PAGE_GUARD";
        }
        if ((protect & 0x200) != 0) {
            flagString = (String)flagString + "PAGE_NOCACHE";
        }
        if ((protect & 0x400) != 0) {
            flagString = (String)flagString + "PAGE_WRITECOMBINE";
        }
        if (((String)flagString).endsWith("|")) {
            flagString = ((String)flagString).substring(0, ((String)flagString).length() - 1);
        }
        return flagString;
    }

    private String decodeStateFlags(int state) {
        switch (state) {
            case 4096: {
                return "MEM_COMMIT";
            }
            case 65536: {
                return "MEM_FREE";
            }
            case 8192: {
                return "MEM_RESERVE";
            }
        }
        return "UNKNOWN";
    }

    private String decodeTypeFlags(int type) {
        switch (type) {
            case 0x1000000: {
                return "MEM_IMAGE";
            }
            case 262144: {
                return "MEM_MAPPED";
            }
            case 131072: {
                return "MEM_PRIVATE";
            }
        }
        return "UNKNOWN";
    }
}

