/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;
import java.util.List;

public class J9ModuleStructureFormatter
extends BaseStructureFormatter {
    @Override
    public FormatWalkResult postFormat(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        if (type2.equalsIgnoreCase("j9module") && address != 0L) {
            J9ModulePointer modulePtr = J9ModulePointer.cast(address);
            String moduleAddress = modulePtr.getHexAddress();
            try {
                out.println("Module name: " + J9ObjectHelper.stringValue(modulePtr.moduleName()));
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            out.println("To display all j9packages exported by a module, use !dumpmoduleexports " + moduleAddress);
            out.println("To display all modules that the target module reads, use !dumpmodulereads " + moduleAddress);
            out.println("To find all modules that read a module, use !findallreads " + moduleAddress);
            out.println("To find all loaded classes in a module, use !dumpallclassesinmodule " + moduleAddress);
        }
        return FormatWalkResult.KEEP_WALKING;
    }
}

