/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import java.io.PrintStream;

public class CStringFieldFormatter
extends BaseFieldFormatter {
    public static final int MAXIMUM_LENGTH = 120;

    @Override
    public FormatWalkResult postFormat(String name, String type2, String declaredType, int typeCode, long address, PrintStream out, Context context, IStructureFormatter structureFormatter) throws CorruptDataException {
        CTypeParser parser;
        if (typeCode == 110 && (parser = new CTypeParser(declaredType)).getCoreType().equals("char") && parser.getSuffix().equals("*")) {
            U8Pointer ptr = U8Pointer.cast(PointerPointer.cast(address).at(0L));
            if (ptr.isNull()) {
                return FormatWalkResult.KEEP_WALKING;
            }
            String str = ptr.getCStringAtOffset(0L, 120L);
            if (str.length() > 0) {
                out.print(" // \"");
                out.print(str);
                if (str.length() >= 120) {
                    out.print("...");
                }
                out.print("\"");
            }
        }
        return FormatWalkResult.KEEP_WALKING;
    }
}

