/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.structure.OMR;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=OMR.class)
public class OMRPointer
extends StructurePointer {
    public static final OMRPointer NULL = new OMRPointer(0L);

    protected OMRPointer(long address) {
        super(address);
    }

    public static OMRPointer cast(AbstractPointer structure) {
        return OMRPointer.cast(structure.getAddress());
    }

    public static OMRPointer cast(UDATA udata) {
        return OMRPointer.cast(udata.longValue());
    }

    public static OMRPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new OMRPointer(address);
    }

    @Override
    public OMRPointer add(long count) {
        return OMRPointer.cast(this.address + OMR.SIZEOF * count);
    }

    @Override
    public OMRPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public OMRPointer addOffset(long offset) {
        return OMRPointer.cast(this.address + offset);
    }

    @Override
    public OMRPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public OMRPointer sub(long count) {
        return OMRPointer.cast(this.address - OMR.SIZEOF * count);
    }

    @Override
    public OMRPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public OMRPointer subOffset(long offset) {
        return OMRPointer.cast(this.address - offset);
    }

    @Override
    public OMRPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public OMRPointer untag(long mask) {
        return OMRPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public OMRPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return OMR.SIZEOF;
    }
}

