/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.CountFieldData;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=CountFieldData.class)
public class CountFieldDataPointer
extends StructurePointer {
    public static final CountFieldDataPointer NULL = new CountFieldDataPointer(0L);

    protected CountFieldDataPointer(long address) {
        super(address);
    }

    public static CountFieldDataPointer cast(AbstractPointer structure) {
        return CountFieldDataPointer.cast(structure.getAddress());
    }

    public static CountFieldDataPointer cast(UDATA udata) {
        return CountFieldDataPointer.cast(udata.longValue());
    }

    public static CountFieldDataPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new CountFieldDataPointer(address);
    }

    @Override
    public CountFieldDataPointer add(long count) {
        return CountFieldDataPointer.cast(this.address + CountFieldData.SIZEOF * count);
    }

    @Override
    public CountFieldDataPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public CountFieldDataPointer addOffset(long offset) {
        return CountFieldDataPointer.cast(this.address + offset);
    }

    @Override
    public CountFieldDataPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public CountFieldDataPointer sub(long count) {
        return CountFieldDataPointer.cast(this.address - CountFieldData.SIZEOF * count);
    }

    @Override
    public CountFieldDataPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public CountFieldDataPointer subOffset(long offset) {
        return CountFieldDataPointer.cast(this.address - offset);
    }

    @Override
    public CountFieldDataPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public CountFieldDataPointer untag(long mask) {
        return CountFieldDataPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public CountFieldDataPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return CountFieldData.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_fieldCountOffset_", declaredType="U32")
    public UDATA fieldCount() throws CorruptDataException {
        return new U32(this.getIntAtOffset(CountFieldData._fieldCountOffset_));
    }

    public UDATAPointer fieldCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)CountFieldData._fieldCountOffset_);
    }
}

