/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAddressOrderedList;
import com.ibm.j9ddr.vm29.j9.gc.GCModronAllocateHintIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModronAllocateHintPointer;
import java.util.NoSuchElementException;

public class GCModronAllocateHintIteratorAOL
extends GCModronAllocateHintIterator {
    protected J9ModronAllocateHintPointer _currentHint = null;
    protected GCMemoryPoolAddressOrderedList _memoryPool = null;

    public GCModronAllocateHintIteratorAOL(GCMemoryPoolAddressOrderedList memoryPool) throws CorruptDataException {
        this._memoryPool = memoryPool;
        this._currentHint = memoryPool.getFirstHint();
        if (this._currentHint.isNull()) {
            this._currentHint = null;
        }
    }

    private void advanceHint() {
        try {
            this._currentHint = this._currentHint.next();
            if (this._currentHint.isNull()) {
                this._currentHint = null;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", e, false);
            this._currentHint = null;
        }
    }

    @Override
    public boolean hasNext() {
        return null != this._currentHint;
    }

    @Override
    public J9ModronAllocateHintPointer next() {
        if (this.hasNext()) {
            J9ModronAllocateHintPointer next = this._currentHint;
            this.advanceHint();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public int getFreeListNumber() {
        return 0;
    }

    @Override
    public String toString() {
        GCModronAllocateHintIteratorAOL tempIter = null;
        try {
            tempIter = new GCModronAllocateHintIteratorAOL(this._memoryPool);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next().getHexAddress() + NEW_LINE);
        }
        return builder.toString();
    }
}

