/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAggregatedCellList;
import java.util.NoSuchElementException;

public class GCFreeListIteratorAggregatedCellList
extends GCFreeListHeapIterator {
    protected GCHeapLinkedFreeHeader _currentFreeEntry = null;
    protected GCMemoryPoolAggregatedCellList _memoryPool = null;

    public GCFreeListIteratorAggregatedCellList(GCMemoryPoolAggregatedCellList memoryPool) throws CorruptDataException {
        this._memoryPool = memoryPool;
        this._currentFreeEntry = memoryPool.getFirstFreeEntry();
        if (!this._memoryPool.getRegion().containsObjects() || this._currentFreeEntry.getHeader().isNull()) {
            this._currentFreeEntry = null;
        }
    }

    private void advanceFreeListEntry() {
        try {
            this._currentFreeEntry = this._currentFreeEntry.getNext();
            if (this._currentFreeEntry.getHeader().isNull()) {
                this._currentFreeEntry = null;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", e, false);
            this._currentFreeEntry = null;
        }
    }

    @Override
    public int getFreeListNumber() {
        return 0;
    }

    @Override
    public boolean hasNext() {
        return null != this._currentFreeEntry;
    }

    @Override
    public GCHeapLinkedFreeHeader next() throws NoSuchElementException {
        if (this.hasNext()) {
            GCHeapLinkedFreeHeader next = this._currentFreeEntry;
            this.advanceFreeListEntry();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public String toString() {
        GCFreeListIteratorAggregatedCellList tempIter = null;
        try {
            tempIter = new GCFreeListIteratorAggregatedCellList(this._memoryPool);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next().toString() + NEW_LINE);
        }
        return builder.toString();
    }
}

