/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;

public class J9DDRImageStackFrame
implements ImageStackFrame {
    private final IProcess process;
    private final IOSStackFrame frame;
    private final ImageThread parentThread;

    public J9DDRImageStackFrame(IProcess process, IOSStackFrame frame, ImageThread parent) {
        this.frame = frame;
        this.process = process;
        this.parentThread = parent;
    }

    public ImagePointer getBasePointer() throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRImagePointer(this.process, this.frame.getBasePointer());
    }

    public ImagePointer getProcedureAddress() throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRImagePointer(this.process, this.frame.getInstructionPointer());
    }

    public String getProcedureName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return this.process.getProcedureNameForAddress(this.frame.getInstructionPointer(), true);
        }
        catch (DataUnavailableException ex) {
            return "<unknown location>";
        }
        catch (CorruptDataException e) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(this.process, e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.frame == null ? 0 : this.frame.hashCode());
        result = 31 * result + (this.process == null ? 0 : this.process.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof J9DDRImageStackFrame)) {
            return false;
        }
        J9DDRImageStackFrame other = (J9DDRImageStackFrame)obj;
        if (this.frame == null ? other.frame != null : !this.frame.equals(other.frame)) {
            return false;
        }
        return !(this.process == null ? other.process != null : !this.process.equals(other.process));
    }

    public String toString() {
        try {
            return "J9DDRImageStackFrame: " + this.getProcedureName() + " from Thread " + this.parentThread.getID();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return "J9DDRImageStackFrame <exception getting details>";
        }
    }
}

