/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Context {
    public static final String TASK_FINDVM = "tools.ddrinteractive.FindVMTask";
    public static final String TASK_GETCOMMANDS = "tools.ddrinteractive.GetCommandsTask";
    public final IProcess process;
    public final IVMData vmData;
    public final long vmAddress;
    public List<ICommand> nonVMCommands;
    public List<ICommand> commands;
    public final Logger logger = Logger.getLogger("j9ddr.interactive.context");
    private DDRInteractiveClassLoader loader;

    public Context(IProcess process, IVMData vmData, List<ICommand> nonVMCommands) {
        this.vmData = vmData;
        this.process = process;
        this.nonVMCommands = nonVMCommands;
        this.vmAddress = this.getVMAddress();
        this.refreshCommandList();
    }

    public DDRInteractiveClassLoader getPluginClassloader() {
        return this.loader;
    }

    public void refreshCommandList() {
        try {
            this.loader = this.vmData.getClassLoader() == null ? new DDRInteractiveClassLoader(this.vmData, this.getClass().getClassLoader()) : new DDRInteractiveClassLoader(this.vmData);
        }
        catch (DDRInteractiveCommandException e) {
            this.logger.log(Level.FINE, "Problem loading DDR plugins: ", e);
            System.err.println("Problem loading DDR plugins:");
            System.err.println(e.getMessage());
        }
        this.commands = this.getContextCommands();
    }

    private List<ICommand> getContextCommands() {
        Object[] bootstrapArray = new Object[2];
        bootstrapArray[1] = this.loader;
        try {
            this.vmData.bootstrapRelative(TASK_GETCOMMANDS, new Object[]{bootstrapArray});
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        return Collections.unmodifiableList((List)bootstrapArray[0]);
    }

    public String toString() {
        long pid;
        try {
            pid = this.process.getProcessId();
        }
        catch (CorruptDataException e1) {
            pid = -1L;
        }
        if (this.process.getPlatform() == Platform.ZOS) {
            if (pid == -1L) {
                return "ASID: " + Long.toHexString(this.process.getAddressSpace().getAddressSpaceId()) + " : No JRE";
            }
            return "ASID: " + Long.toHexString(this.process.getAddressSpace().getAddressSpaceId()) + " EDB: " + Long.toHexString(pid) + " " + this.vmString();
        }
        String pidString = pid == -1L ? "<error>" : Long.toString(pid);
        return "PID: " + pidString + "; " + this.vmString();
    }

    public String toString(boolean shortFormat) {
        long pid;
        StringBuilder data = new StringBuilder();
        try {
            pid = this.process.getProcessId();
        }
        catch (CorruptDataException e1) {
            pid = -1L;
        }
        if (this.process.getPlatform() == Platform.ZOS) {
            data.append("ASID: 0x" + Long.toHexString(this.process.getAddressSpace().getAddressSpaceId()));
            if (pid == -1L) {
                data.append(" : No JRE");
            } else {
                data.append(" EDB: 0x" + Long.toHexString(pid));
                if (!shortFormat) {
                    data.append(" " + this.vmString());
                }
            }
            return data.toString();
        }
        if (shortFormat) {
            String pidString = pid == -1L ? "<error>" : Long.toString(pid);
            return "PID: " + pidString;
        }
        String pidString = pid == -1L ? "<error>" : Long.toString(pid);
        return "PID: " + pidString + "; " + this.vmString();
    }

    private long getVMAddress() {
        long[] passBackArray = new long[1];
        try {
            this.vmData.bootstrapRelative(TASK_FINDVM, new Object[]{passBackArray});
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        return passBackArray[0];
    }

    private String vmString() {
        String hexAddress = "0x" + Long.toHexString(this.vmAddress);
        return " !j9javavm " + hexAddress;
    }

    public void execute(String command, String[] arguments, PrintStream out) {
        try {
            this.execute(new CommandParser(command, arguments), out);
        }
        catch (ParseException e) {
            out.println("Error executing command: " + e.getMessage());
        }
    }

    public void execute(CommandParser command, PrintStream defaultOut) {
        for (ICommand thisCommand : this.nonVMCommands) {
            if (!this.tryCommand(command, thisCommand, defaultOut)) continue;
            return;
        }
        for (ICommand thisCommand : this.commands) {
            if (!this.tryCommand(command, thisCommand, defaultOut)) continue;
            return;
        }
        defaultOut.println("Unrecognised command: " + command);
    }

    private boolean tryCommand(CommandParser command, ICommand thisCommand, PrintStream defaultOut) {
        Object cmd = !command.getCommand().startsWith("!") ? "!" + command.getCommand() : command.getCommand();
        if (thisCommand.recognises((String)cmd, this)) {
            PrintStream fileOut = null;
            try {
                if (command.isRedirectedToFile()) {
                    fileOut = command.getOutputFile();
                    thisCommand.run((String)cmd, command.getArguments(), this, fileOut);
                    fileOut.flush();
                    fileOut.close();
                } else {
                    thisCommand.run((String)cmd, command.getArguments(), this, defaultOut);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Problem running command: ", e);
                defaultOut.println("Problem running command:");
                defaultOut.println(e.getMessage());
            }
            defaultOut.flush();
            if (fileOut != null) {
                fileOut.flush();
                fileOut.close();
            }
            return true;
        }
        return false;
    }

    public Vector<String> getCommandNames() {
        Vector<String> commandNames = new Vector<String>();
        for (ICommand thisCommand : this.nonVMCommands) {
            if (thisCommand.getCommandNames() == null) continue;
            commandNames.addAll(thisCommand.getCommandNames());
        }
        for (ICommand thisCommand : this.commands) {
            if (thisCommand.getCommandNames() == null) continue;
            commandNames.addAll(thisCommand.getCommandNames());
        }
        Map<String, StructureReader.StructureDescriptor> structureMap = StructureCommandUtil.getStructureMap(this);
        for (String command : structureMap.keySet()) {
            commandNames.add(command);
        }
        return commandNames;
    }
}

