/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.logging.Logger;

public class CommandUtils {
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.tools.ddrinteractive");
    public static final BigInteger UDATA_MAX_64BIT = new BigInteger("18446744073709551615");
    public static final BigInteger UDATA_MAX_32BIT = new BigInteger("4294967295");
    public static final int RADIX_BINARY = 2;
    public static final int RADIX_DECIMAL = 10;
    public static final int RADIX_HEXADECIMAL = 16;
    public static final String HEX_SUFFIX = "0x";

    public static long parsePointer(String input, boolean is64bit) throws DDRInteractiveCommandException {
        BigInteger pointer = CommandUtils.parseNumber(input);
        if (-1 == pointer.signum()) {
            throw new DDRInteractiveCommandException(input + " is not a valid address: Address can not be a negative number");
        }
        if (is64bit) {
            if (pointer.compareTo(UDATA_MAX_64BIT) == 1) {
                throw new DDRInteractiveCommandException(input + " is larger than the max available memory address: 0xFFFFFFFFFFFFFFFF (" + UDATA_MAX_64BIT + ")");
            }
        } else if (pointer.compareTo(UDATA_MAX_32BIT) == 1) {
            throw new DDRInteractiveCommandException(input + " is larger than the max available memory address: 0xFFFFFFFF (" + UDATA_MAX_32BIT + ")");
        }
        return pointer.longValue();
    }

    public static BigInteger longToBigInteger(long pointer) {
        BigInteger result = new BigInteger(Long.toBinaryString(pointer), 2);
        return result;
    }

    public static BigInteger parseNumber(String number) throws DDRInteractiveCommandException {
        BigInteger result = null;
        if (null == number) {
            throw new DDRInteractiveCommandException("Parsed value is null");
        }
        if (0 == (number = number.trim()).length()) {
            throw new DDRInteractiveCommandException("Parsed value is empty. (zero length string)");
        }
        try {
            result = number.startsWith(HEX_SUFFIX) ? new BigInteger(number.substring(HEX_SUFFIX.length()), 16) : new BigInteger(number, 10);
        }
        catch (NumberFormatException nfe) {
            throw new DDRInteractiveCommandException(number + " is not a valid decimal or hexadecimal number.");
        }
        return result;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static long followPointerFromStructure(Context context, String structureName, long structureAddress, String fieldName) throws MemoryFault, DDRInteractiveCommandException {
        if (structureAddress == 0L) {
            throw new DDRInteractiveCommandException(new NullPointerException("Null " + structureName + " found."));
        }
        StructureReader.StructureDescriptor desc = StructureCommandUtil.getStructureDescriptor(structureName, context);
        for (StructureReader.FieldDescriptor f : desc.getFields()) {
            if (!f.getDeclaredName().equals(fieldName)) continue;
            long offset = f.getOffset();
            long pointerAddress = structureAddress + offset;
            long pointer = context.process.getPointerAt(pointerAddress);
            return pointer;
        }
        return 0L;
    }

    public static long getOffsetForField(StructureReader.StructureDescriptor desc, String fieldName) throws NoSuchFieldException {
        for (StructureReader.FieldDescriptor f : desc.getFields()) {
            if (!f.getDeclaredName().equals(fieldName)) continue;
            return f.getOffset();
        }
        throw new NoSuchFieldException(desc.getName() + " does not contain a field named " + fieldName);
    }

    public static String getCStringAtAddress(IProcess process, long address) throws CorruptDataException {
        return CommandUtils.getCStringAtAddress(process, address, Long.MAX_VALUE);
    }

    public static boolean fieldExists(Class class1, String string) {
        try {
            class1.getField(string);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (java.lang.NoSuchFieldException e) {
            return false;
        }
        return true;
    }

    public static String getCStringAtAddress(IProcess process, long address, long maxLength) throws CorruptDataException {
        int length = 0;
        while (0 != process.getByteAt(address + (long)length) && (long)length < maxLength) {
            ++length;
        }
        byte[] buffer = new byte[length];
        process.getBytesAt(address, buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void dbgError(PrintStream out, String msg) {
        CommandUtils.dbgPrint(out, msg);
    }

    public static void dbgPrint(PrintStream out, String msg) {
        out.append(msg);
    }

    public static void dbgPrint(PrintStream out, String msg, Object ... args) {
        CommandUtils.dbgPrint(out, String.format(msg, args));
    }

    public static byte[] longToByteArray(long index, int size) {
        byte[] bytearray = new byte[size];
        for (int k = 0; k < size; ++k) {
            bytearray[k] = (byte)(index >>> k * 8);
        }
        return bytearray;
    }
}

