/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class SlidingFileInputStream
extends InputStream {
    private final long length;
    private final ImageInputStream stream;
    private final byte[] buffer = new byte[4096];
    private int bytesAvailable = 0;
    private boolean EOF = false;
    private int bufferPos = 0;
    private long bytesRead = 0L;

    public SlidingFileInputStream(File file, long start, long length) throws FileNotFoundException, IOException {
        this.length = length;
        this.stream = new FileImageInputStream(file);
        this.stream.seek(start);
    }

    public SlidingFileInputStream(ImageInputStream iis, long start, long length) throws FileNotFoundException, IOException {
        this.length = length;
        this.stream = iis;
        this.stream.seek(start);
    }

    @Override
    public int read() throws IOException {
        if (this.EOF) {
            return -1;
        }
        if (this.bytesRead == this.length) {
            this.EOF = true;
            return -1;
        }
        if (this.bytesAvailable == this.bufferPos) {
            this.bytesAvailable = this.stream.read(this.buffer);
            if (this.bytesAvailable == -1) {
                this.EOF = true;
                return -1;
            }
            this.bufferPos = 0;
        }
        ++this.bytesRead;
        return 0xFF & this.buffer[this.bufferPos++];
    }

    public void disposeStream() throws IOException {
        this.stream.close();
    }
}

