/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Template;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Element;

public class TemplateField {
    private Template template;
    private Element element;
    private int offset;
    private boolean isBitField;
    int bitLength = -1;
    private String name;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    TemplateField(String name, Template template, Element element, int offset) {
        this.template = template;
        this.element = element;
        this.offset = offset;
        this.name = name;
        if ((offset & 7) != 0 || (this.bitLength() & 7) != 0) {
            this.isBitField = true;
        }
    }

    public boolean isBitField() {
        return this.isBitField;
    }

    public int byteLength() {
        return this.bitLength() / 8;
    }

    public int bitLength() {
        if (this.bitLength != -1) {
            return this.bitLength;
        }
        if (this.element == null) {
            return 0;
        }
        if (this.element.getTagName().equals("array")) {
            Element child = (Element)this.element.getElementsByTagName("item").item(0);
            this.bitLength = Integer.parseInt(this.element.getAttribute("length")) * Integer.parseInt(child.getAttribute("length"));
        } else if (this.element.getTagName().equals("item")) {
            this.bitLength = Integer.parseInt(this.element.getAttribute("length"));
        } else {
            throw new Error("unknown element tag: " + this.element.getTagName());
        }
        return this.bitLength;
    }

    public String getName() {
        return this.name;
    }

    public long readLong(ImageInputStream inputStream, long address) throws IOException {
        inputStream.seek(address + (long)(this.offset / 8));
        long result = 0L;
        if (this.isBitField) {
            if (this.bitLength() > 64) {
                throw new Error("request for long value for field " + this.name + " which has length of " + this.bitLength() + " bits");
            }
            inputStream.setBitOffset(this.offset & 7);
            result = inputStream.readBits(this.bitLength());
            int shift = 64 - this.bitLength();
            result <<= shift;
            result >>= shift;
        } else if (this.byteLength() == 1) {
            result = inputStream.readByte();
        } else if (this.byteLength() == 4) {
            result = this.isPointer() ? inputStream.readUnsignedInt() : (long)inputStream.readInt();
        } else if (this.byteLength() == 8) {
            result = inputStream.readLong();
        } else if (this.byteLength() > 0 && this.byteLength() < 8) {
            for (int i = 0; i < this.byteLength(); ++i) {
                result <<= 8;
                result |= (long)inputStream.readUnsignedByte();
            }
            if (!this.isPointer()) {
                int shift = 64 - this.byteLength() * 8;
                result <<= shift;
                result >>= shift;
            }
        } else {
            throw new Error("request for long value for field " + this.name + " which has length of " + this.byteLength());
        }
        log.fine("for field " + this.name + " of type " + this.element.getTagName() + " read value of 0x" + TemplateField.hex(result));
        return result;
    }

    public boolean isPointer() {
        return this.element.getElementsByTagName("pointer").getLength() != 0;
    }

    public int getOffset() {
        return this.offset / 8;
    }

    public int getBitOffset() {
        return this.offset;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }
}

