/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.jzos.ZFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStreamImpl;

public class MVSFileReader
extends ImageInputStreamImpl {
    private ZFile dataset;
    private int recordLength;
    byte[] cacheRecord = null;
    private long cacheRecordNumber = -1L;
    private boolean firstTimeThrough = true;
    private List fposList = new ArrayList(10000);
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public MVSFileReader(String filename) throws FileNotFoundException {
        log.fine("Opening dump as an MVS dataset");
        try {
            this.dataset = new ZFile("//'" + filename + "'", "rb,type=record");
            this.recordLength = this.dataset.getLrecl();
            this.cacheRecord = new byte[this.recordLength];
            log.fine("MVS dataset opened OK, record length = " + this.recordLength);
        }
        catch (IOException e) {
            FileNotFoundException e1 = new FileNotFoundException("Could not find: " + filename);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        long recordNumber = this.streamPos / (long)this.recordLength;
        int recordOffset = (int)(this.streamPos % (long)this.recordLength);
        if (recordNumber != this.cacheRecordNumber) {
            int bytesRead;
            if (recordNumber != this.cacheRecordNumber + 1L) {
                this.dataset.setPos((byte[])this.fposList.get((int)recordNumber));
            }
            if (this.firstTimeThrough) {
                this.fposList.add(this.dataset.getPos());
            }
            if ((bytesRead = this.dataset.read(this.cacheRecord)) < 0) {
                this.firstTimeThrough = false;
                return -1;
            }
            this.cacheRecordNumber = recordNumber;
        }
        if (recordOffset + length > this.recordLength) {
            length = this.recordLength - recordOffset;
        }
        System.arraycopy(this.cacheRecord, recordOffset, buffer, offset, length);
        this.seek(this.streamPos + (long)length);
        return length;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int n = this.read(b);
        return n < 0 ? -1 : b[1] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.dataset != null) {
            this.dataset.close();
        }
        super.close();
    }
}

