/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public class SymbolUtil {
    private static WeakHashMap<IModule, List<ISymbol>> extraSymbolsMap = new WeakHashMap();

    protected static String getProcedureNameForAddress(IProcess process, long address, boolean dtfjFormat) throws DataUnavailableException, CorruptDataException {
        String name = SymbolUtil.getNameExactMatch(process, address, dtfjFormat);
        if (name == null) {
            name = SymbolUtil.getNameBestMatch(process, address, dtfjFormat);
        }
        if (name == null) {
            return "<unknown location>";
        }
        return name;
    }

    private static String getNameExactMatch(IProcess process, long address, boolean dtfjFormat) throws DataUnavailableException, CorruptDataException {
        Collection<? extends IModule> modules = process.getModules();
        IModule matchingModule = null;
        block0: for (IModule iModule : modules) {
            for (IMemoryRange iMemoryRange : iModule.getMemoryRanges()) {
                if (!iMemoryRange.contains(address)) continue;
                matchingModule = iModule;
                break block0;
            }
        }
        if (matchingModule == null) {
            return null;
        }
        List<ISymbol> symbols = SymbolUtil.getSymbols(matchingModule);
        ISymbol iSymbol = SymbolUtil.findClosestSymbol(address, symbols);
        if (iSymbol != null) {
            long delta = address - iSymbol.getAddress();
            if (delta < 0x100000L) {
                return matchingModule.getName() + "::" + SymbolUtil.getSymbolName(iSymbol, dtfjFormat) + "+0x" + Long.toHexString(delta);
            }
            return null;
        }
        long delta = SymbolUtil.getDelta(address, matchingModule, null);
        return matchingModule.getName() + "+0x" + Long.toHexString(delta);
    }

    private static String getNameBestMatch(IProcess process, long address, boolean dtfjFormat) {
        IModule bestModule = null;
        ISymbol bestClosest = null;
        long bestDelta = Long.MAX_VALUE;
        String moduleName = null;
        try {
            ISymbol closest;
            long delta;
            IModule module = process.getExecutable();
            ArrayList<ISymbol> arrayList = new ArrayList<ISymbol>();
            if (module != null) {
                arrayList.addAll(SymbolUtil.getSymbols(module));
            }
            if ((delta = SymbolUtil.getDelta(address, module, closest = SymbolUtil.findClosestSymbol(address, arrayList))) >= 0L && delta < bestDelta) {
                bestModule = module;
                moduleName = module.getName();
                bestClosest = closest;
                bestDelta = delta;
            }
        }
        catch (CorruptDataException module) {
        }
        catch (DataUnavailableException module) {
            // empty catch block
        }
        try {
            for (IModule iModule : process.getModules()) {
                ArrayList<ISymbol> symbols;
                ISymbol closest;
                long delta = SymbolUtil.getDelta(address, iModule, closest = SymbolUtil.findClosestSymbol(address, symbols = new ArrayList<ISymbol>(SymbolUtil.getSymbols(iModule))));
                if (delta < 0L || delta >= bestDelta) continue;
                bestModule = iModule;
                moduleName = iModule.getName();
                bestClosest = closest;
                bestDelta = delta;
            }
        }
        catch (DataUnavailableException module) {
        }
        catch (CorruptDataException module) {
            // empty catch block
        }
        if (null != bestModule) {
            Object deltaString = "";
            deltaString = bestDelta == Long.MAX_VALUE ? "<offset not available>" : (bestDelta >= 0L ? "+0x" + Long.toHexString(bestDelta) : "-0x" + Long.toHexString(bestDelta));
            if (null != bestClosest) {
                return moduleName + "::" + SymbolUtil.getSymbolName(bestClosest, dtfjFormat) + (String)deltaString;
            }
            return moduleName + (String)deltaString;
        }
        return null;
    }

    private static long getDelta(long address, IModule module, ISymbol closest) throws CorruptDataException {
        long delta = 0L;
        delta = closest != null ? address - closest.getAddress() : address - module.getLoadAddress();
        return delta;
    }

    private static ISymbol findClosestSymbol(long address, List<? extends ISymbol> symbols) {
        Collections.sort(symbols, new SymbolComparator());
        ISymbol bestMatch = null;
        for (ISymbol iSymbol : symbols) {
            if (!Addresses.lessThanOrEqual(iSymbol.getAddress(), address)) break;
            if (bestMatch != null && bestMatch.getAddress() == iSymbol.getAddress()) continue;
            bestMatch = iSymbol;
        }
        return bestMatch;
    }

    private static List<ISymbol> getSymbols(IModule module) throws DataUnavailableException {
        if (!extraSymbolsMap.containsKey(module)) {
            return new ArrayList<ISymbol>(module.getSymbols());
        }
        Collection<? extends ISymbol> moduleSymbols = module.getSymbols();
        List<ISymbol> extraSymbols = extraSymbolsMap.get(module);
        ArrayList<ISymbol> allSymbols = new ArrayList<ISymbol>(moduleSymbols.size() + extraSymbols.size());
        allSymbols.addAll(moduleSymbols);
        allSymbols.addAll(extraSymbols);
        Collections.sort(allSymbols, new SymbolComparator());
        return allSymbols;
    }

    private static String getSymbolName(ISymbol symbol, boolean dtfjFormat) {
        if (!dtfjFormat && symbol instanceof DDRSymbol) {
            return ((DDRSymbol)symbol).getddrName();
        }
        return symbol.getName();
    }

    public static void addDDRSymbolToModule(IModule module, String dtfjName, String ddrName, long address) {
        List<ISymbol> currentSymbols = extraSymbolsMap.get(module);
        DDRSymbol symbol = new DDRSymbol(dtfjName, ddrName, address);
        if (currentSymbols == null) {
            currentSymbols = new LinkedList<ISymbol>();
            currentSymbols.add(symbol);
            extraSymbolsMap.put(module, currentSymbols);
        } else {
            currentSymbols = extraSymbolsMap.get(module);
            currentSymbols.add(symbol);
        }
        Collections.sort(currentSymbols, new SymbolComparator());
    }

    private static class DDRSymbol
    extends Symbol {
        private String ddrName;

        public DDRSymbol(String dtfjName, String ddrName, long address) {
            super(dtfjName, address);
            this.ddrName = ddrName;
        }

        public String getddrName() {
            return this.ddrName;
        }
    }

    private static final class SymbolComparator
    implements Comparator<ISymbol> {
        private SymbolComparator() {
        }

        @Override
        public int compare(ISymbol arg0, ISymbol arg1) {
            if (arg0.getAddress() > arg1.getAddress()) {
                return 1;
            }
            if (arg0.getAddress() < arg1.getAddress()) {
                return -1;
            }
            return 0;
        }
    }
}

