/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.StringTable;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;
import java.util.Iterator;

class CheckStringTable
extends Check {
    CheckStringTable() {
    }

    @Override
    public void check() {
        try {
            MM_StringTablePointer stringTable = this.getGCExtensions().stringTable();
            long tableCount = stringTable._tableCount().longValue();
            for (long tableIndex = 0L; tableIndex < tableCount; ++tableIndex) {
                J9HashTablePointer hashTable = J9HashTablePointer.cast(stringTable._table().at(tableIndex));
                Iterator stringTableIterator = HashTable.fromJ9HashTable(hashTable, true, PointerPointer.class, new StringTable.StringHashFunction(), new StringTable.StringComparatorFunction()).iterator();
                while (stringTableIterator.hasNext()) {
                    PointerPointer slot = (PointerPointer)stringTableIterator.next();
                    if (!slot.notNull() || this._engine.checkSlotPool(slot, VoidPointer.cast(hashTable)) == 0) continue;
                    return;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "STRING TABLE";
    }

    @Override
    public void print() {
        try {
            MM_StringTablePointer stringTable = this.getGCExtensions().stringTable();
            long tableCount = stringTable._tableCount().longValue();
            ScanFormatter formatter = new ScanFormatter(this, "StringTable", stringTable);
            for (long tableIndex = 0L; tableIndex < tableCount; ++tableIndex) {
                J9HashTablePointer hashTablePtr = J9HashTablePointer.cast(stringTable._table().at(tableIndex));
                HashTable<PointerPointer> hashTable = HashTable.fromJ9HashTable(hashTablePtr, true, PointerPointer.class, new StringTable.StringHashFunction(), new StringTable.StringComparatorFunction());
                Iterator stringTableIterator = hashTable.iterator();
                while (stringTableIterator.hasNext()) {
                    PointerPointer slot = (PointerPointer)stringTableIterator.next();
                    if (!slot.notNull()) continue;
                    formatter.entry(slot.at(0L));
                }
            }
            formatter.end("StringTable", stringTable);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

