/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASdumpAgentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASdumpFunctionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASdumpQueuePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9RASdumpAgent;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class ShowDumpAgentsCommand
extends Command {
    private static final UDATA DUMP_FACADE_KEY = UDATA.roundToSizeofU32(UDATA.cast(VoidPointer.cast(4207599322L)));
    private Map<Long, String> rasDumpEventsToNames = new HashMap<Long, String>();
    private long[] rasDumpEvents = new long[]{J9RASdumpAgent.J9RAS_DUMP_ON_GP_FAULT, J9RASdumpAgent.J9RAS_DUMP_ON_USER_SIGNAL, J9RASdumpAgent.J9RAS_DUMP_ON_ABORT_SIGNAL, J9RASdumpAgent.J9RAS_DUMP_ON_VM_STARTUP, J9RASdumpAgent.J9RAS_DUMP_ON_VM_SHUTDOWN, J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_LOAD, J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_UNLOAD, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_THROW, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_CATCH, J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_START, J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_BLOCKED, J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_END, J9RASdumpAgent.J9RAS_DUMP_ON_GLOBAL_GC, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_DESCRIBE, J9RASdumpAgent.J9RAS_DUMP_ON_SLOW_EXCLUSIVE_ENTER, J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_SYSTHROW, J9RASdumpAgent.J9RAS_DUMP_ON_TRACE_ASSERT, J9RASdumpAgent.J9RAS_DUMP_ON_OBJECT_ALLOCATION, J9RASdumpAgent.J9RAS_DUMP_ON_CORRUPT_CACHE};
    private int J9RAS_DUMP_KNOWN_EVENTS = this.rasDumpEvents.length;
    private Map<Long, String> rasDumpRequestsToNames = new HashMap<Long, String>();
    private long[] rasDumpRequests = new long[]{J9RASdumpAgent.J9RAS_DUMP_DO_MULTIPLE_HEAPS, J9RASdumpAgent.J9RAS_DUMP_DO_EXCLUSIVE_VM_ACCESS, J9RASdumpAgent.J9RAS_DUMP_DO_COMPACT_HEAP, J9RASdumpAgent.J9RAS_DUMP_DO_PREPARE_HEAP_FOR_WALK, J9RASdumpAgent.J9RAS_DUMP_DO_SUSPEND_OTHER_DUMPS, J9RASdumpAgent.J9RAS_DUMP_DO_ATTACH_THREAD, J9RASdumpAgent.J9RAS_DUMP_DO_PREEMPT_THREADS};
    private int J9RAS_DUMP_KNOWN_REQUESTS = this.rasDumpRequests.length;

    public ShowDumpAgentsCommand() {
        this.addCommand("showdumpagents", "", "print the dump agent settings in force when this dump was taken, like -Xdump:what");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_GP_FAULT, "gpf");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_USER_SIGNAL, "user");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_ABORT_SIGNAL, "abort");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_VM_STARTUP, "vmstart");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_VM_SHUTDOWN, "vmstop");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_LOAD, "load");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_CLASS_UNLOAD, "unload");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_THROW, "throw");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_CATCH, "catch");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_START, "thrstart");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_BLOCKED, "blocked");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_THREAD_END, "thrstop");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_GLOBAL_GC, "fullgc");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_DESCRIBE, "uncaught");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_SLOW_EXCLUSIVE_ENTER, "slow");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_EXCEPTION_SYSTHROW, "systhrow");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_TRACE_ASSERT, "traceassert");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_OBJECT_ALLOCATION, "allocation");
        this.rasDumpEventsToNames.put(J9RASdumpAgent.J9RAS_DUMP_ON_CORRUPT_CACHE, "corruptcache");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_MULTIPLE_HEAPS, "multiple");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_EXCLUSIVE_VM_ACCESS, "exclusive");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_COMPACT_HEAP, "compact");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_PREPARE_HEAP_FOR_WALK, "prepwalk");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_SUSPEND_OTHER_DUMPS, "serial");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_ATTACH_THREAD, "attach");
        this.rasDumpRequestsToNames.put(J9RASdumpAgent.J9RAS_DUMP_DO_PREEMPT_THREADS, "preempt");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9RASdumpAgentPointer agent = J9RASdumpAgentPointer.NULL;
            out.println("Registered dump agents\n----------------------");
            while ((agent = this.seekDumpAgent(vm, agent, null)) != null && !agent.isNull()) {
                this.printDumpAgent(vm, agent, context, out);
                out.println("----------------------");
            }
            out.println();
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }

    private J9RASdumpAgentPointer seekDumpAgent(J9JavaVMPointer vm, J9RASdumpAgentPointer agentPtr, J9RASdumpFunctionsPointer dumpFn) throws CorruptDataException {
        J9RASdumpFunctionsPointer func = vm.j9rasDumpFunctions();
        J9RASdumpQueuePointer queue2 = J9RASdumpQueuePointer.cast(func);
        UDATA reserved = UDATA.roundToSizeofU32(UDATA.cast(queue2.facade().reserved()));
        if (!DUMP_FACADE_KEY.equals(reserved = reserved.bitAnd(0xFFFFFFFFL))) {
            return null;
        }
        if (!queue2.isNull()) {
            J9RASdumpAgentPointer node = agentPtr;
            J9RASdumpAgentPointer j9RASdumpAgentPointer = node = node != null && !node.isNull() ? node.nextPtr() : queue2.agents();
            while (node != null && !node.isNull() && dumpFn != null && !dumpFn.isNull() && node.dumpFn().getAddress() != dumpFn.getAddress()) {
                node = node.nextPtr();
            }
            agentPtr = node;
            return node;
        }
        agentPtr = J9RASdumpAgentPointer.NULL;
        return agentPtr;
    }

    private void printDumpAgent(J9JavaVMPointer vm, J9RASdumpAgentPointer agent, Context context, PrintStream out) throws CorruptDataException {
        out.println("-Xdump:");
        String dumpFn = "<unknown>";
        String dumpFnAddress = "<unknown>";
        try {
            dumpFnAddress = agent.dumpFn().getHexAddress();
            dumpFn = context.process.getProcedureNameForAddress(agent.dumpFn().getAddress());
        }
        catch (DataUnavailableException dataUnavailableException) {
            // empty catch block
        }
        out.printf("dumpFn=%s (%s)\n", dumpFnAddress, dumpFn);
        out.print("    events=");
        this.printDumpEvents(vm, agent.eventMask(), out);
        out.println(",");
        if (!agent.detailFilter().isNull()) {
            out.printf("    filter=%s,\n", agent.detailFilter().getCStringAtOffset(0L));
        }
        if (!agent.subFilter().isNull()) {
            out.printf("    msg_filter=%s,\n", agent.subFilter().getCStringAtOffset(0L));
        }
        out.printf("    label=%s,\n    range=%d..%d,\n    priority=%d,\n", !agent.labelTemplate().isNull() ? agent.labelTemplate().getCStringAtOffset(0L) : "-", agent.startOnCount().intValue(), agent.stopOnCount().intValue(), agent.priority().intValue());
        out.print("    request=");
        this.printDumpRequests(vm, agent.requestMask(), out);
        if (!agent.dumpOptions().isNull()) {
            out.println(",");
            out.printf("    opts=%s", agent.dumpOptions().getCStringAtOffset(0L));
        }
        out.println();
    }

    private void printDumpEvents(J9JavaVMPointer vm, UDATA bits, PrintStream out) {
        String separator = "";
        for (int i = 0; i < this.J9RAS_DUMP_KNOWN_EVENTS; ++i) {
            if ((bits.longValue() & this.rasDumpEvents[i]) == 0L) continue;
            out.printf("%s%s", separator, this.rasDumpEventsToNames.get(this.rasDumpEvents[i]));
            separator = "+";
        }
    }

    private void printDumpRequests(J9JavaVMPointer vm, UDATA bits, PrintStream out) {
        String separator = "";
        for (int i = 0; i < this.J9RAS_DUMP_KNOWN_REQUESTS; ++i) {
            if ((bits.longValue() & this.rasDumpRequests[i]) == 0L) continue;
            out.printf("%s%s", separator, this.rasDumpRequestsToNames.get(this.rasDumpRequests[i]));
            separator = "+";
        }
    }
}

