/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.ThreadMap;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=ThreadMap.class)
public class ThreadMapPointer
extends StructurePointer {
    public static final ThreadMapPointer NULL = new ThreadMapPointer(0L);

    protected ThreadMapPointer(long address) {
        super(address);
    }

    public static ThreadMapPointer cast(AbstractPointer structure) {
        return ThreadMapPointer.cast(structure.getAddress());
    }

    public static ThreadMapPointer cast(UDATA udata) {
        return ThreadMapPointer.cast(udata.longValue());
    }

    public static ThreadMapPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ThreadMapPointer(address);
    }

    @Override
    public ThreadMapPointer add(long count) {
        return ThreadMapPointer.cast(this.address + ThreadMap.SIZEOF * count);
    }

    @Override
    public ThreadMapPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ThreadMapPointer addOffset(long offset) {
        return ThreadMapPointer.cast(this.address + offset);
    }

    @Override
    public ThreadMapPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public ThreadMapPointer sub(long count) {
        return ThreadMapPointer.cast(this.address - ThreadMap.SIZEOF * count);
    }

    @Override
    public ThreadMapPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ThreadMapPointer subOffset(long offset) {
        return ThreadMapPointer.cast(this.address - offset);
    }

    @Override
    public ThreadMapPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ThreadMapPointer untag(long mask) {
        return ThreadMapPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ThreadMapPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ThreadMap.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="IDATA")
    public IDATA index() throws CorruptDataException {
        return new IDATA(this.getIDATAAtOffset(ThreadMap._indexOffset_));
    }

    public IDATAPointer indexEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)ThreadMap._indexOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_threadOffset_", declaredType="J9VMThread*")
    public J9VMThreadPointer thread() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(ThreadMap._threadOffset_);
        return J9VMThreadPointer.cast(pointer);
    }

    public PointerPointer threadEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ThreadMap._threadOffset_);
    }
}

