/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9VMParkEvent;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9VMParkEvent.class)
public class J9VMParkEventPointer
extends StructurePointer {
    public static final J9VMParkEventPointer NULL = new J9VMParkEventPointer(0L);

    protected J9VMParkEventPointer(long address) {
        super(address);
    }

    public static J9VMParkEventPointer cast(AbstractPointer structure) {
        return J9VMParkEventPointer.cast(structure.getAddress());
    }

    public static J9VMParkEventPointer cast(UDATA udata) {
        return J9VMParkEventPointer.cast(udata.longValue());
    }

    public static J9VMParkEventPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9VMParkEventPointer(address);
    }

    @Override
    public J9VMParkEventPointer add(long count) {
        return J9VMParkEventPointer.cast(this.address + J9VMParkEvent.SIZEOF * count);
    }

    @Override
    public J9VMParkEventPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9VMParkEventPointer addOffset(long offset) {
        return J9VMParkEventPointer.cast(this.address + offset);
    }

    @Override
    public J9VMParkEventPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9VMParkEventPointer sub(long count) {
        return J9VMParkEventPointer.cast(this.address - J9VMParkEvent.SIZEOF * count);
    }

    @Override
    public J9VMParkEventPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9VMParkEventPointer subOffset(long offset) {
        return J9VMParkEventPointer.cast(this.address - offset);
    }

    @Override
    public J9VMParkEventPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9VMParkEventPointer untag(long mask) {
        return J9VMParkEventPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9VMParkEventPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9VMParkEvent.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_currentThreadOffset_", declaredType="J9VMThread*")
    public J9VMThreadPointer currentThread() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9VMParkEvent._currentThreadOffset_);
        return J9VMThreadPointer.cast(pointer);
    }

    public PointerPointer currentThreadEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9VMParkEvent._currentThreadOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_millisOffset_", declaredType="I64")
    public IDATA millis() throws CorruptDataException {
        return new I64(this.getLongAtOffset(J9VMParkEvent._millisOffset_));
    }

    public IDATAPointer millisEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)J9VMParkEvent._millisOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nanosOffset_", declaredType="IDATA")
    public IDATA nanos() throws CorruptDataException {
        return new IDATA(this.getIDATAAtOffset(J9VMParkEvent._nanosOffset_));
    }

    public IDATAPointer nanosEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)J9VMParkEvent._nanosOffset_);
    }
}

