/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.plugins;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.annotations.DebugExtension;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.Attribute;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;

public class DDRInteractiveClassLoader
extends ClassLoader {
    public static final String PLUGIN_SYSTEM_PROPERTY = "plugins";
    public static final String PLUGIN_ENV_VAR = "com.ibm.java.diagnostics.plugins";
    public static final String PLUGIN_ENV_VAR_ALT = "com_ibm_java_diagnostics_plugins";
    private static final String FILE_EXT_JAR = ".jar";
    private static final String FILE_EXT_CLASS = ".class";
    private static final String VM_ALLVERSIONS = "*";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    Level logLevelForPluginLoadFailures = Level.WARNING;
    private final String vmversion;
    private final ArrayList<PluginConfig> pluginCache = new ArrayList();
    private final ArrayList<PluginConfig> pluginFailures = new ArrayList();
    protected static ArrayList<String> runtimeCommandClasses = new ArrayList();
    private final ArrayList<File> pluginSearchPath = new ArrayList();
    private Map<String, ClassFile> classFilesOnClasspath = new HashMap<String, ClassFile>();

    public DDRInteractiveClassLoader(IVMData vmdata) throws DDRInteractiveCommandException {
        this(vmdata, (ClassLoader)vmdata.getClassLoader());
    }

    public DDRInteractiveClassLoader(IVMData vmdata, ClassLoader loader) throws DDRInteractiveCommandException {
        super(loader);
        this.vmversion = vmdata.getVersion();
        this.configureSearchPath();
        this.loadPlugins();
    }

    private void examineClass(URL url, Class<?> clazz) {
        DebugExtension a;
        if (clazz.isAnnotationPresent(DebugExtension.class) && null != (a = clazz.getAnnotation(DebugExtension.class))) {
            String[] versions;
            String value = a.VMVersion();
            for (String version : versions = value.split(",")) {
                if (version.equals(this.vmversion) || version.equals(VM_ALLVERSIONS)) {
                    if (this.hasCommandIFace(clazz)) {
                        PluginConfig config = new PluginConfig(clazz.getName(), this.vmversion, clazz, true, url);
                        this.pluginCache.add(config);
                        this.logger.fine("Added command " + clazz.getName());
                        continue;
                    }
                    this.logger.fine("Skipping annotated command which did not implement the ICommand interface : " + clazz.getName());
                    continue;
                }
                String msg = String.format("Skipping %s as wrong VM version [allowed = %s, * : actual = %s]", clazz.getName(), this.vmversion, version);
                this.logger.fine(msg);
            }
        }
    }

    private void definePackage(String name) {
        int finalSeparator = name.lastIndexOf("/");
        if (finalSeparator != -1) {
            String packageName = name.substring(0, finalSeparator);
            if (this.getPackage(packageName) != null) {
                return;
            }
            this.definePackage(packageName, "J9DDR", "0.1", "IBM", "J9DDR", "0.1", "IBM", null);
        }
    }

    private void configureSearchPath() {
        String property = System.getProperty(PLUGIN_SYSTEM_PROPERTY);
        if (null == property && (property = System.getenv(PLUGIN_ENV_VAR)) == null) {
            property = System.getenv(PLUGIN_ENV_VAR_ALT);
        }
        if (null == property || property.length() == 0) {
            this.logger.fine("No system property called plugins was found");
            return;
        }
        this.logger.fine("Plugins search path = " + property);
        String[] parts = property.split(File.pathSeparator);
        for (int i = 0; i < parts.length; ++i) {
            try {
                File file = new File(parts[i]);
                this.pluginSearchPath.add(file);
                continue;
            }
            catch (Exception e) {
                this.logger.warning("Failed to create a URI or URL from " + parts[i]);
            }
        }
    }

    public void loadPlugins() throws DDRInteractiveCommandException {
        this.scanForClassFiles();
        for (String str : this.classFilesOnClasspath.keySet()) {
            try {
                DTFJPluginSnifferVisitor sniffer = this.sniffClassFile(this.classFilesOnClasspath.get(str).getStreamForByteCode());
                if (!sniffer.isDebugExtension) continue;
                Class<?> clazz = this.loadClass(str);
                this.examineClass(this.classFilesOnClasspath.get(str).toURL(), clazz);
            }
            catch (ClassNotFoundException e) {
                this.logger.log(this.logLevelForPluginLoadFailures, "Exception while loading plugins : " + e.getMessage());
            }
            catch (IOException e) {
                this.logger.fine(e.getMessage());
            }
        }
        this.addRuntimeCommands();
    }

    private void addRuntimeCommands() {
        for (String name : runtimeCommandClasses) {
            try {
                this.loadCommandClass(name, false);
            }
            catch (ClassNotFoundException e) {
                this.logger.log(this.logLevelForPluginLoadFailures, "Could not load a runtime command class", e);
            }
        }
    }

    private void scanForClassFiles() throws DDRInteractiveCommandException {
        for (File file : this.pluginSearchPath) {
            this.logger.fine("Scanning path " + file + " in search of DDR plugins");
            if (!file.exists()) {
                this.logger.fine(String.format("Abandoning scan of DDR plugins search path: %s does not exist", file.getAbsolutePath()));
                throw new DDRInteractiveCommandException(file.getAbsolutePath() + " was specified on the plugins search path but it does not exist");
            }
            if (file.isDirectory()) {
                this.scanDirectory(file);
                continue;
            }
            this.scanFile(file);
        }
    }

    private void scanDirectory(File dir) {
        File[] files;
        this.logger.fine("Scanning directory " + dir.getAbsolutePath());
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDirectory(file);
                continue;
            }
            this.scanFile(file);
        }
    }

    private static String getExtension(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        if (-1 == pos || name.length() == pos + 1) {
            return "";
        }
        return name.substring(pos);
    }

    private void scanFile(File file) {
        this.logger.fine("Scanning file " + file.getAbsolutePath());
        String ext = DDRInteractiveClassLoader.getExtension(file);
        if (ext.equals(FILE_EXT_JAR)) {
            this.examineJarFile(file);
            return;
        }
        if (ext.equals(FILE_EXT_CLASS)) {
            this.examineClassFile(file);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineClassFile(File file) {
        this.logger.fine("Found class file " + file.getAbsolutePath());
        if (file.length() > Integer.MAX_VALUE) {
            this.logger.fine("Skipping file " + file.getAbsolutePath() + " as the file size is > Integer.MAX_VALUE");
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            DTFJPluginSnifferVisitor sniffer = this.sniffClassFile(is);
            this.classFilesOnClasspath.put(sniffer.className, new StandaloneClassFile(file));
        }
        catch (IOException e) {
            this.logger.log(this.logLevelForPluginLoadFailures, e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                this.logger.log(this.logLevelForPluginLoadFailures, "Error closing file " + file.getAbsolutePath(), e);
            }
        }
    }

    private DTFJPluginSnifferVisitor sniffClassFile(InputStream in) throws IOException {
        DTFJPluginSnifferVisitor sniffer = new DTFJPluginSnifferVisitor();
        ClassReader cr = new ClassReader(in);
        cr.accept(sniffer, 0);
        return sniffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineJarFile(File file) {
        this.logger.fine("Found jar file " + file.getAbsolutePath());
        JarInputStream jin = null;
        try {
            jin = new JarInputStream(new FileInputStream(file));
            JarEntry entry = null;
            while (null != (entry = jin.getNextJarEntry())) {
                if (entry.isDirectory() || !entry.getName().endsWith(FILE_EXT_CLASS)) continue;
                if (entry.getSize() > Integer.MAX_VALUE) {
                    this.logger.fine("Skipping jar entry " + entry.getName() + " as the uncompressed size is > Integer.MAX_VALUE");
                    continue;
                }
                ClassFileWithinJarFile classFile = new ClassFileWithinJarFile(file, entry.getName());
                InputStream in = ((ClassFile)classFile).getStreamForByteCode();
                DTFJPluginSnifferVisitor sniffer = this.sniffClassFile(in);
                in.close();
                this.classFilesOnClasspath.put(sniffer.className, classFile);
            }
        }
        catch (IOException e) {
            this.logger.log(this.logLevelForPluginLoadFailures, "Error reading from file " + file.getAbsolutePath(), e);
        }
        finally {
            if (null != jin) {
                try {
                    jin.close();
                }
                catch (IOException e) {
                    this.logger.log(this.logLevelForPluginLoadFailures, "Error closing file " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    protected boolean hasCommandIFace(Class<?> clazz) {
        return ICommand.class.isAssignableFrom(clazz);
    }

    public ArrayList<PluginConfig> getPlugins() {
        return this.pluginCache;
    }

    public ArrayList<PluginConfig> getPluginFailures() {
        return this.pluginFailures;
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        this.logger.finest("Entered findClass with class name of " + className);
        if (this.classFilesOnClasspath.containsKey(className)) {
            this.logger.finest("Found match for with class " + className);
            return this.classFilesOnClasspath.get(className).loadByteCode();
        }
        throw new ClassNotFoundException("Unable to load class " + className);
    }

    private synchronized Class<?> loadCommandClass(String className, boolean resolveClass) throws ClassNotFoundException {
        Class<?> clazz = this.loadClass(className, resolveClass);
        try {
            URL url = new File("RuntimeLoad").toURI().toURL();
            this.examineClass(url, clazz);
        }
        catch (MalformedURLException e) {
            this.logger.log(this.logLevelForPluginLoadFailures, "Exception thrown when forming URL from file \"RuntimeLoad\" : " + e);
        }
        return clazz;
    }

    public void addCommandClass(String className) {
        runtimeCommandClasses.add(className);
    }

    public void removeCommandClass(String className) {
        if (!runtimeCommandClasses.remove(className)) {
            this.logger.fine(String.format("Ignored call to remove command %s as it was not previously added", new Object[0]));
        }
    }

    private class StandaloneClassFile
    extends ClassFile {
        private File classFile;

        public StandaloneClassFile(File f) {
            super(f.getAbsolutePath());
            this.classFile = f;
        }

        @Override
        public URL toURL() {
            try {
                return this.classFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                DDRInteractiveClassLoader.this.logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "Exception thrown when constructing URL from class file name " + this.classFile.getName());
                return null;
            }
        }

        @Override
        public InputStream getStreamForByteCode() throws FileNotFoundException, IOException {
            return new FileInputStream(this.classFile);
        }
    }

    private class ClassFileWithinJarFile
    extends ClassFile {
        private File jarFile;

        public ClassFileWithinJarFile(File f, String cfpn) {
            super(cfpn);
            this.jarFile = f;
        }

        @Override
        public URL toURL() {
            try {
                return new URL("jar:file:" + this.jarFile.getAbsolutePath() + "!/" + this.classFilePathName);
            }
            catch (MalformedURLException e) {
                DDRInteractiveClassLoader.this.logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "Exception thrown when constructing URL from jar file name " + this.jarFile.getAbsolutePath() + " and class file name " + this.classFilePathName);
                return null;
            }
        }

        @Override
        public InputStream getStreamForByteCode() throws FileNotFoundException, IOException {
            JarInputStream jin = new JarInputStream(new FileInputStream(this.jarFile));
            JarEntry entry = null;
            while (null != (entry = jin.getNextJarEntry())) {
                if (!entry.getName().equals(this.classFilePathName)) continue;
                return jin;
            }
            throw new FileNotFoundException();
        }
    }

    private abstract class ClassFile {
        protected String classFilePathName;
        boolean loaded = false;

        ClassFile(String cfpn) {
            this.classFilePathName = cfpn;
        }

        public abstract URL toURL();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class<?> loadByteCode() {
            if (this.loaded) {
                DDRInteractiveClassLoader.this.logger.finest("Would load " + this.toURL() + " but it is already loaded (presumably because required by an earlier class)");
                return null;
            }
            InputStream in = null;
            try {
                in = this.getStreamForByteCode();
                byte[] byteCodeBuffer = this.readByteCodeFromStream(in);
                Class<?> clazz = this.loadByteCodeFromBuffer(this.toURL(), null, byteCodeBuffer, 0, byteCodeBuffer.length);
                return clazz;
            }
            catch (FileNotFoundException e) {
                DDRInteractiveClassLoader.this.logger.log(Level.FINE, "Unable to find file " + this.toURL(), e);
            }
            catch (IOException e) {
                DDRInteractiveClassLoader.this.logger.log(Level.FINE, "Error reading from file " + this.toURL(), e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    DDRInteractiveClassLoader.this.logger.log(Level.FINE, "Error closing file " + this.toURL(), e);
                }
            }
            return null;
        }

        public abstract InputStream getStreamForByteCode() throws FileNotFoundException, IOException;

        private byte[] readByteCodeFromStream(InputStream in) throws IOException {
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            int bytesRead = 0;
            while (-1 != (bytesRead = in.read(buffer))) {
                out.write(buffer, 0, bytesRead);
            }
            return out.toByteArray();
        }

        private Class<?> loadByteCodeFromBuffer(URL u, String packageName, byte[] bytecode, int offset, int length) {
            try {
                DDRInteractiveClassLoader.this.logger.finer("About to call defineClass with byte code from " + u);
                Class clazz = DDRInteractiveClassLoader.this.defineClass(null, bytecode, offset, length);
                DDRInteractiveClassLoader.this.logger.finer("Successful call to defineClass, loaded class is " + clazz.getName());
                this.loaded = true;
                if (null == packageName) {
                    DDRInteractiveClassLoader.this.definePackage(clazz.getName());
                } else {
                    DDRInteractiveClassLoader.this.definePackage(packageName);
                }
                return clazz;
            }
            catch (ClassFormatError t) {
                DDRInteractiveClassLoader.this.logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "ClassFormatError thrown when processing byte code from " + u + " : " + t);
                PluginConfig config = new PluginConfig(u.toString(), t, u);
                DDRInteractiveClassLoader.this.pluginFailures.add(config);
            }
            catch (NoClassDefFoundError t) {
                DDRInteractiveClassLoader.this.logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "NoClassDefFoundError thrown when processing byte code from " + u + " : " + t);
                PluginConfig config = new PluginConfig(u.toString(), t, u);
                DDRInteractiveClassLoader.this.pluginFailures.add(config);
            }
            catch (SecurityException t) {
                DDRInteractiveClassLoader.this.logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "SecurityException thrown when processing byte code from " + u + " : " + t);
                PluginConfig config = new PluginConfig(u.toString(), t, u);
                DDRInteractiveClassLoader.this.pluginFailures.add(config);
            }
            catch (LinkageError t) {
                DDRInteractiveClassLoader.this.logger.log(DDRInteractiveClassLoader.this.logLevelForPluginLoadFailures, "LinkageError thrown when processing byte code from " + u + " : " + t);
                PluginConfig config = new PluginConfig(u.toString(), t, u);
                DDRInteractiveClassLoader.this.pluginFailures.add(config);
            }
            return null;
        }
    }

    private class DTFJPluginSnifferVisitor
    extends ClassVisitor {
        private boolean isDebugExtension;
        private String className;

        public DTFJPluginSnifferVisitor() {
            super(262144, null);
            this.isDebugExtension = false;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String extensionClassname = DebugExtension.class.getName().replace(".", "/");
            DDRInteractiveClassLoader.this.logger.finest("Inspecting annotation " + desc + " looking for annotation " + extensionClassname);
            if (desc.contains(extensionClassname)) {
                DDRInteractiveClassLoader.this.logger.finest("Found DebugExtension annotation");
                this.isDebugExtension = true;
            } else {
                DDRInteractiveClassLoader.this.logger.finest("Did not find DebugExtension annotation");
                this.isDebugExtension = false;
            }
            return null;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name.replace("/", ".");
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }

        @Override
        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        @Override
        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            return null;
        }

        @Override
        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        @Override
        public void visitSource(String arg0, String arg1) {
        }
    }
}

