/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ExtractMemoryCommand
extends Command {
    public ExtractMemoryCommand() {
        this.addCommand("extractmemory", "<hexAddress> <hexLength> <filename>", "Dump the specified memory range to a binary file");
    }

    @Override
    public void run(String command, String[] arguments, Context context, PrintStream out) throws DDRInteractiveCommandException {
        FileOutputStream fos;
        if (arguments.length != 3) {
            out.println("Unexpected number of arguments.");
            this.printUsage(out);
            return;
        }
        long address = 0L;
        address = arguments[0].startsWith("0x") ? Long.parseLong(arguments[0].substring(2), 16) : Long.parseLong(arguments[0], 16);
        int length = 0;
        length = arguments[1].startsWith("0x") ? Integer.parseInt(arguments[1].substring(2), 16) : Integer.parseInt(arguments[1], 16);
        String filename = arguments[2];
        try {
            fos = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            throw new DDRInteractiveCommandException("Failed to open output file " + filename, e);
        }
        try {
            byte[] data = new byte[length];
            context.process.getBytesAt(address, data);
            try {
                fos.write(data, 0, length);
            }
            catch (IOException e) {
                throw new DDRInteractiveCommandException("Failed to write data to file " + filename, e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (MemoryFault e) {
            throw new DDRInteractiveCommandException("Unable to read memory range", e);
        }
    }

    private void printUsage(PrintStream out) {
        out.println("Usage:\n  !extractmemory <hexAddress> <hexLength> <filename>");
    }
}

